import { A as NovelType, C as StopParam, D as NarouNovel, E as NarouNovelJsonp, O as End, S as RankingType, T as UserOrder, _ as OptionalFields, a as NovelSearchBuilderBase, b as R18Site, c as BigGenre, d as BuntaiParam, f as DateParam, g as NovelTypeParam, h as GenreNotation, i as RankingBuilder, k as NarouSearchResults, l as BigGenreNotation, m as Genre, n as SearchBuilderR18, o as SearchBuilder, p as Fields, r as formatRankingHistory, s as SearchBuilderBase, t as UserSearchBuilder, u as BooleanNumber, v as Order, w as UserFields, x as R18SiteNotation, y as R18Fields } from "./index.common-8lS2K_1Y.mjs";

//#region src/index.browser.ts
const narouNovelJsonp = new NarouNovelJsonp();
/**
* なろう小説 API で小説を検索する
* @param {string} [word] 検索ワード
* @returns {SearchBuilder}
* @see https://dev.syosetu.com/man/api/
*/
function search(word = "", api = narouNovelJsonp) {
	const builder = new SearchBuilder({}, api);
	if (word != "") builder.word(word);
	return builder;
}
/**
* 18禁小説 API で小説を検索する
* @param {string} [word] 検索ワード
* @returns {SearchBuilder}
* @see https://dev.syosetu.com/xman/api/
*/
function searchR18(word = "", api = narouNovelJsonp) {
	const builder = new SearchBuilderR18({}, api);
	if (word != "") builder.word(word);
	return builder;
}
/**
* なろうユーザ検索 API でユーザを検索する
* @param {string} [word] - 検索ワード
* @returns {UserSearchBuilder}
* @see https://dev.syosetu.com/man/userapi/
*/
function searchUser(word = "", api = narouNovelJsonp) {
	const builder = new UserSearchBuilder({}, api);
	if (word != "") builder.word(word);
	return builder;
}
/**
* なろう小説ランキング API でランキングを取得する
* @returns {RankingBuilder}
* @see https://dev.syosetu.com/man/rankapi/
*/
function ranking(api = narouNovelJsonp) {
	return new RankingBuilder({}, api);
}
/**
* なろう殿堂入り API でランキング履歴を取得する
* @param {string} ncode 小説のNコード
* @param {ExecuteOptions} [options] 実行オプション
* @param {NarouNovel} [api] API実行クラスのインスタンス
* @see https://dev.syosetu.com/man/rankinapi/
*/
async function rankingHistory(ncode, options, api = narouNovelJsonp) {
	const result = await api.executeRankingHistory({ ncode }, options);
	if (Array.isArray(result)) return result.map(formatRankingHistory);
	else throw new Error(result);
}
var index_browser_default = {
	search,
	searchR18,
	searchUser,
	ranking,
	rankingHistory
};

//#endregion
export { BigGenre, BigGenreNotation, BooleanNumber, BuntaiParam, DateParam, End, Fields, Genre, GenreNotation, NarouNovel, NarouNovelJsonp, NarouSearchResults, NovelSearchBuilderBase, NovelType, NovelTypeParam, OptionalFields, Order, R18Fields, R18Site, R18SiteNotation, RankingBuilder, RankingType, SearchBuilder, SearchBuilderBase, SearchBuilderR18, StopParam, UserFields, UserOrder, index_browser_default as default, formatRankingHistory, ranking, rankingHistory, search, searchR18, searchUser };
//# sourceMappingURL=index.browser.mjs.map