/**
 * Merges an array of buffers into a new buffer.
 *
 * @param {Buffer[]} list The array of buffers to concatP>
 * @param {Number} totalLength The total length of buffers in the list
 * @return {Buffer} The resulting buffer
 * @public
 */
export declare function concat(list: Buffer[], totalLength: number): Buffer;
/**
 * Masks a buffer using the given mask.
 *
 * @param {Buffer} source The buffer to mask
 * @param {Buffer} mask The mask to use
 * @param {Buffer} output The buffer where to store the result
 * @param {Number} offset The offset at which to start writing
 * @param {Number} length The number of bytes to mask.
 * @public
 */
declare function _mask(source: Buffer, mask: Buffer, output: Buffer, offset: number, length: number): void;
/**
 * Unmasks a buffer using the given mask.
 *
 * @param {Buffer} buffer The buffer to unmask
 * @param {Buffer} mask The mask to use
 * @public
 */
export declare function _unmask(buffer: Buffer, mask: Buffer): void;
/**
 * Converts a buffer to an `ArrayBuffer`.
 *
 * @param {Buffer} buf The buffer to convert
 * @return {ArrayBuffer} Converted buffer
 * @public
 */
export declare function toArrayBuffer(buf: Buffer): ArrayBuffer;
export interface ToBufferFn {
    (data: any): Buffer;
    readOnly: boolean;
}
/**
 * Converts `data` to a `Buffer`.
 *
 * @param {*} data The data to convert
 * @return {Buffer} The buffer
 * @throws {TypeError}
 * @public
 */
export declare function toBuffer(data: any): Buffer;
export { _unmask as unmask };
export { _mask as mask };
//# sourceMappingURL=buffer-util.d.ts.map