export interface DevtoolMessageRequest {
    method: string;
    params: Record<string, any>;
}
export interface DevtoolMessageResponse {
    id: string;
    result: any;
    method?: string;
}
export interface DevtoolErrorResponse {
    id: string;
    error: {
        code: number;
        message?: string;
    };
}
export type DevtoolMessage = DevtoolMessageRequest | DevtoolMessageResponse | DevtoolErrorResponse;
export declare class BaseDevtoolServer {
    timestamp: number;
    private startTime;
    getTimestamp(): number;
    listeners: ((error: unknown | null, message?: any) => void)[];
    updateTimestamp(): void;
    on(listener: (error: unknown | null, message?: any) => void): void;
}
//# sourceMappingURL=type.d.ts.map