import { default as fs } from 'fs';

export declare class ScriptMap {
    private urlToScriptId;
    private scriptIdToUrl;
    constructor();
    addMapping(filePath: string, scriptId: string): void;
    getUrlByScriptId(scriptId: string): string | undefined;
    getScriptIdByUrl(url: string): string | undefined;
}
export declare class ResourceService {
    private scriptMap;
    private scriptIdCounter;
    constructor();
    getScriptIdByUrl(url: string): string | undefined;
    getUrlByScriptId(scriptId: string): string | undefined;
    getScriptSource(scriptId: string): string | null;
    /**
     * @description Read the last lines of the file
     * @param filePath
     * @param stat
     * @param totalLines
     * @returns string
     */
    readLastLine(filePath: string, stat: fs.Stats, totalLines?: number): string;
    private traverseDirToMap;
    getLocalScriptList(): {
        url: string;
        scriptLanguage: string;
        embedderName: string;
        scriptId: string;
        sourceMapURL: string;
        hasSourceURL: boolean;
    }[];
}
//# sourceMappingURL=resource-service.d.ts.map