import { t as Options } from "./index-DgRWzHwv.js";

//#region src-js/libs/prettier.d.ts
type FormatEmbeddedCodeParam = {
  code: string;
  parserName: string;
  options: Options & {
    _tailwindPluginEnabled?: boolean;
  };
};
/**
 * Format xxx-in-js code snippets
 *
 * @returns Formatted code snippet
 * TODO: In the future, this should return `Doc` instead of string,
 * otherwise, we cannot calculate `printWidth` correctly.
 */
declare function formatEmbeddedCode({
  code,
  parserName,
  options
}: FormatEmbeddedCodeParam): Promise<string>;
type FormatFileParam = {
  code: string;
  parserName: string;
  fileName: string;
  options: Options & {
    _tailwindPluginEnabled?: boolean;
  };
};
/**
 * Format non-js file
 *
 * @returns Formatted code
 */
declare function formatFile({
  code,
  parserName,
  fileName,
  options
}: FormatFileParam): Promise<string>;
interface SortTailwindClassesArgs {
  filepath: string;
  classes: string[];
  options?: Record<string, unknown>;
}
/**
 * Process Tailwind CSS classes found in JSX attributes.
 * Option mapping (`experimentalTailwindcss.xxx` → `tailwindXxx`) is done in Rust side.
 * @param args - Object containing filepath, classes, and options
 * @returns Array of sorted class strings (same order/length as input)
 */
declare function sortTailwindClasses({
  filepath,
  classes,
  options
}: SortTailwindClassesArgs): Promise<string[]>;
//#endregion
export { formatEmbeddedCode, formatFile, sortTailwindClasses };