import { createRequire as __cjs_createRequire } from "node:module";
const __cjs_require = __cjs_createRequire(import.meta.url);
import { createRequire } from "node:module";
import process from "node:process";
import { bgRed, bgYellow, blue, green, rgb, yellow } from "ansis";
import { pathToFileURL } from "node:url";
const picomatch = __cjs_require("picomatch");
import readline from "node:readline";

//#region rolldown:runtime
var __require = /* @__PURE__ */ createRequire(import.meta.url);

//#endregion
//#region src/utils/general.ts
function toArray(val, defaultValue) {
	if (Array.isArray(val)) return val;
	else if (val == null) {
		if (defaultValue) return [defaultValue];
		return [];
	} else return [val];
}
function resolveComma(arr) {
	return arr.flatMap((format) => format.split(","));
}
function resolveRegex(str) {
	if (typeof str === "string" && str.length > 2 && str[0] === "/" && str.at(-1) === "/") return new RegExp(str.slice(1, -1));
	return str;
}
function slash(string) {
	return string.replaceAll("\\", "/");
}
const noop = (v) => v;
function matchPattern(id, patterns) {
	return patterns.some((pattern) => {
		if (pattern instanceof RegExp) {
			pattern.lastIndex = 0;
			return pattern.test(id);
		}
		return id === pattern || picomatch(pattern)(id);
	});
}
function pkgExists(moduleName) {
	try {
		import.meta.resolve(moduleName);
		return true;
	} catch {}
	return false;
}
async function importWithError(moduleName, resolvePaths) {
	let resolved;
	if (resolvePaths) resolved = pathToFileURL(__require.resolve(moduleName, { paths: resolvePaths })).href;
	try {
		return await import(resolved || moduleName);
	} catch (error) {
		throw new Error(`Failed to import module "${moduleName}". Please ensure it is installed.`, { cause: error });
	}
}
function promiseWithResolvers() {
	let resolve;
	return {
		promise: new Promise((res) => {
			resolve = res;
		}),
		resolve
	};
}

//#endregion
//#region src/utils/logger.ts
const LogLevels = {
	silent: 0,
	error: 1,
	warn: 2,
	info: 3
};
function format(msgs) {
	return msgs.filter((arg) => arg !== void 0 && arg !== false).join(" ");
}
function clearScreen() {
	const repeatCount = process.stdout.rows - 2;
	const blank = repeatCount > 0 ? "\n".repeat(repeatCount) : "";
	console.info(blank);
	readline.cursorTo(process.stdout, 0, 0);
	readline.clearScreenDown(process.stdout);
}
const warnedMessages = /* @__PURE__ */ new Set();
function createLogger(level = "info", { customLogger, console = globalThis.console, failOnWarn = false, allowClearScreen = true } = {}) {
	if (customLogger) return customLogger;
	function output(type, msg) {
		if (LogLevels[logger.level] < LogLevels[type]) return;
		console[type === "info" ? "log" : type](msg);
	}
	const clear = allowClearScreen && process.stdout.isTTY && !process.env.CI ? clearScreen : () => {};
	const logger = {
		level,
		info(...msgs) {
			output("info", `${blue`ℹ`} ${format(msgs)}`);
		},
		warn(...msgs) {
			if (failOnWarn) return this.error(...msgs);
			const message = format(msgs);
			warnedMessages.add(message);
			output("warn", `\n${bgYellow` WARN `} ${message}\n`);
		},
		warnOnce(...msgs) {
			const message = format(msgs);
			if (warnedMessages.has(message)) return;
			if (failOnWarn) return this.error(...msgs);
			warnedMessages.add(message);
			output("warn", `\n${bgYellow` WARN `} ${message}\n`);
		},
		error(...msgs) {
			output("error", `\n${bgRed` ERROR `} ${format(msgs)}\n`);
			process.exitCode = 1;
		},
		success(...msgs) {
			output("info", `${green`✔`} ${format(msgs)}`);
		},
		clearScreen(type) {
			if (LogLevels[logger.level] >= LogLevels[type]) clear();
		}
	};
	return logger;
}
const globalLogger = createLogger();
function getNameLabel(ansis, name) {
	if (!name) return void 0;
	return ansis(`[${name}]`);
}
function prettyFormat(format) {
	const formatColor = format === "es" ? blue : format === "cjs" ? yellow : noop;
	let formatText;
	switch (format) {
		case "es":
			formatText = "ESM";
			break;
		default:
			formatText = format.toUpperCase();
			break;
	}
	return formatColor(`[${formatText}]`);
}
const colors = /* @__PURE__ */ new Map();
function generateColor(name = "default") {
	if (colors.has(name)) return colors.get(name);
	let color;
	if (name === "default") color = blue;
	else {
		let hash = 0;
		for (let i = 0; i < name.length; i++) hash = name.charCodeAt(i) + ((hash << 5) - hash);
		color = rgb(...hslToRgb(hash % 360, 35, 55));
	}
	colors.set(name, color);
	return color;
}
function hslToRgb(h, s, l) {
	h = h % 360;
	h /= 360;
	s /= 100;
	l /= 100;
	let r, g, b;
	if (s === 0) r = g = b = l;
	else {
		const q = l < .5 ? l * (1 + s) : l + s - l * s;
		const p = 2 * l - q;
		r = hue2rgb(p, q, h + 1 / 3);
		g = hue2rgb(p, q, h);
		b = hue2rgb(p, q, h - 1 / 3);
	}
	return [
		Math.max(0, Math.round(r * 255)),
		Math.max(0, Math.round(g * 255)),
		Math.max(0, Math.round(b * 255))
	];
}
function hue2rgb(p, q, t) {
	if (t < 0) t += 1;
	if (t > 1) t -= 1;
	if (t < 1 / 6) return p + (q - p) * 6 * t;
	if (t < 1 / 2) return q;
	if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;
	return p;
}

//#endregion
export { globalLogger as a, matchPattern as c, promiseWithResolvers as d, resolveComma as f, toArray as h, getNameLabel as i, noop as l, slash as m, createLogger as n, prettyFormat as o, resolveRegex as p, generateColor as r, importWithError as s, LogLevels as t, pkgExists as u };