/* eslint-disable */
var __defProp = Object.defineProperty;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __privateWrapper = (obj, member, setter, getter) => ({
  set _(value) {
    __privateSet(obj, member, value, setter);
  },
  get _() {
    return __privateGet(obj, member, getter);
  }
});

// dist/src/utils/Utils.js
var Utils_exports = {};
__export(Utils_exports, {
  ChannelError: () => ChannelError,
  InnertubeError: () => InnertubeError,
  MissingParamError: () => MissingParamError,
  OAuth2Error: () => OAuth2Error,
  ParsingError: () => ParsingError,
  Platform: () => Platform,
  PlayerError: () => PlayerError,
  SessionError: () => SessionError,
  base64ToU8: () => base64ToU8,
  concatMemos: () => concatMemos,
  debugFetch: () => debugFetch,
  deepCompare: () => deepCompare,
  escapeStringRegexp: () => escapeStringRegexp,
  generateRandomString: () => generateRandomString,
  generateSidAuth: () => generateSidAuth,
  getCookie: () => getCookie,
  getRandomUserAgent: () => getRandomUserAgent,
  getStringBetweenStrings: () => getStringBetweenStrings,
  hasKeys: () => hasKeys,
  isTextRun: () => isTextRun,
  streamToIterable: () => streamToIterable,
  throwIfMissing: () => throwIfMissing,
  timeToSeconds: () => timeToSeconds,
  u8ToBase64: () => u8ToBase64
});

// dist/src/parser/helpers.js
var helpers_exports = {};
__export(helpers_exports, {
  Maybe: () => Maybe,
  Memo: () => Memo,
  SuperParsedResult: () => SuperParsedResult,
  YTNode: () => YTNode,
  observe: () => observe
});

// dist/src/utils/Log.js
var Log_exports = {};
__export(Log_exports, {
  Level: () => Level,
  debug: () => debug,
  error: () => error,
  info: () => info,
  setLevel: () => setLevel,
  warn: () => warn,
  warnOnce: () => warnOnce
});
var YTJS_TAG = "YOUTUBEJS";
var Level = {
  NONE: 0,
  ERROR: 1,
  WARNING: 2,
  INFO: 3,
  DEBUG: 4
};
var log_map = {
  [Level.ERROR]: (...args) => console.error(...args),
  [Level.WARNING]: (...args) => console.warn(...args),
  [Level.INFO]: (...args) => console.info(...args),
  [Level.DEBUG]: (...args) => console.debug(...args)
};
var log_level = [Level.WARNING];
var one_time_warnings_issued = /* @__PURE__ */ new Set();
function doLog(level, tag, args) {
  if (!log_map[level] || !log_level.includes(level))
    return;
  const tags = [`[${YTJS_TAG}]`];
  if (tag)
    tags.push(`[${tag}]`);
  log_map[level](`${tags.join("")}:`, ...args || []);
}
__name(doLog, "doLog");
var warnOnce = /* @__PURE__ */ __name((id, ...args) => {
  if (one_time_warnings_issued.has(id))
    return;
  doLog(Level.WARNING, id, args);
  one_time_warnings_issued.add(id);
}, "warnOnce");
var warn = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.WARNING, tag, args), "warn");
var error = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.ERROR, tag, args), "error");
var info = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.INFO, tag, args), "info");
var debug = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.DEBUG, tag, args), "debug");
function setLevel(...args) {
  log_level = args;
}
__name(setLevel, "setLevel");

// dist/src/parser/helpers.js
var isObserved = Symbol("ObservedArray.isObserved");
var _YTNode = class _YTNode {
  constructor() {
    __publicField(this, "type");
    this.type = this.constructor.type;
  }
  /**
   * Check if the node is of the given type.
   * @param types - The type to check
   * @returns whether the node is of the given type
   */
  is(...types) {
    return types.some((type) => this.type === type.type);
  }
  /**
   * Cast to one of the given types.
   * @param types - The types to cast to
   * @returns The node cast to one of the given types
   * @throws {ParsingError} If the node is not of the given type
   */
  as(...types) {
    if (!this.is(...types)) {
      throw new ParsingError(`Cannot cast ${this.type} to one of ${types.map((t) => t.type).join(", ")}`);
    }
    return this;
  }
  /**
   * Check for a key without asserting the type.
   * @param key - The key to check
   * @returns Whether the node has the key
   */
  hasKey(key) {
    return Reflect.has(this, key);
  }
  /**
   * Assert that the node has the given key and return it.
   * @param key - The key to check
   * @returns The value of the key wrapped in a Maybe
   * @throws {ParsingError} If the node does not have the key
   */
  key(key) {
    if (!this.hasKey(key)) {
      throw new ParsingError(`Missing key ${key}`);
    }
    return new Maybe(this[key]);
  }
};
__name(_YTNode, "YTNode");
__publicField(_YTNode, "type", "YTNode");
var YTNode = _YTNode;
var MAYBE_TAG = "Maybe";
var _value, _Maybe_instances, checkPrimitive_fn, assertPrimitive_fn;
var _Maybe = class _Maybe {
  constructor(value) {
    __privateAdd(this, _Maybe_instances);
    __privateAdd(this, _value);
    __privateSet(this, _value, value);
  }
  get typeof() {
    return typeof __privateGet(this, _value);
  }
  string() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "string");
  }
  isString() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "string");
  }
  number() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "number");
  }
  isNumber() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "number");
  }
  bigint() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "bigint");
  }
  isBigint() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "bigint");
  }
  boolean() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "boolean");
  }
  isBoolean() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "boolean");
  }
  symbol() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "symbol");
  }
  isSymbol() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "symbol");
  }
  undefined() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "undefined");
  }
  isUndefined() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "undefined");
  }
  null() {
    if (__privateGet(this, _value) !== null)
      throw new TypeError(`Expected null, got ${typeof __privateGet(this, _value)}`);
    return __privateGet(this, _value);
  }
  isNull() {
    return __privateGet(this, _value) === null;
  }
  object() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "object");
  }
  isObject() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "object");
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  function() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "function");
  }
  isFunction() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "function");
  }
  /**
   * Get the value as an array.
   * @returns the value as any[].
   * @throws If the value is not an array.
   */
  array() {
    if (!Array.isArray(__privateGet(this, _value))) {
      throw new TypeError(`Expected array, got ${typeof __privateGet(this, _value)}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * More typesafe variant of {@link Maybe#array}.
   * @returns a proxied array which returns all the values as {@link Maybe}.
   * @throws {TypeError} If the value is not an array
   */
  arrayOfMaybe() {
    const arrayProps = [];
    return new Proxy(this.array(), {
      get(target, prop) {
        if (Reflect.has(arrayProps, prop)) {
          return Reflect.get(target, prop);
        }
        return new _Maybe(Reflect.get(target, prop));
      }
    });
  }
  /**
   * Check whether the value is an array.
   * @returns whether the value is an array.
   */
  isArray() {
    return Array.isArray(__privateGet(this, _value));
  }
  /**
   * Get the value as a YTNode.
   * @returns the value as a YTNode.
   * @throws If the value is not a YTNode.
   */
  node() {
    if (!(__privateGet(this, _value) instanceof YTNode)) {
      throw new TypeError(`Expected YTNode, got ${__privateGet(this, _value).constructor.name}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Check if the value is a YTNode.
   * @returns Whether the value is a YTNode.
   */
  isNode() {
    return __privateGet(this, _value) instanceof YTNode;
  }
  /**
   * Get the value as a YTNode of the given type.
   * @param types - The type(s) to cast to.
   * @returns The node cast to the given type.
   * @throws If the node is not of the given type.
   */
  nodeOfType(...types) {
    return this.node().as(...types);
  }
  /**
   * Check if the value is a YTNode of the given type.
   * @param types - the type(s) to check.
   * @returns Whether the value is a YTNode of the given type.
   */
  isNodeOfType(...types) {
    return this.isNode() && this.node().is(...types);
  }
  /**
   * Get the value as an ObservedArray.
   * @returns the value of the Maybe as a ObservedArray.
   */
  observed() {
    if (!this.isObserved()) {
      throw new TypeError(`Expected ObservedArray, got ${typeof __privateGet(this, _value)}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Check if the value is an ObservedArray.
   */
  isObserved() {
    var _a;
    return (_a = __privateGet(this, _value)) == null ? void 0 : _a[isObserved];
  }
  /**
   * Get the value of the Maybe as a SuperParsedResult.
   * @returns the value as a SuperParsedResult.
   * @throws If the value is not a SuperParsedResult.
   */
  parsed() {
    if (!(__privateGet(this, _value) instanceof SuperParsedResult)) {
      throw new TypeError(`Expected SuperParsedResult, got ${typeof __privateGet(this, _value)}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Is the result a SuperParsedResult?
   */
  isParsed() {
    return __privateGet(this, _value) instanceof SuperParsedResult;
  }
  /**
   * @deprecated
   * This call is not meant to be used outside of debugging. Please use the specific type getter instead.
   */
  any() {
    warn(MAYBE_TAG, "This call is not meant to be used outside of debugging. Please use the specific type getter instead.");
    return __privateGet(this, _value);
  }
  /**
   * Get the node as an instance of the given class.
   * @param type - The type to check.
   * @returns the value as the given type.
   * @throws If the node is not of the given type.
   */
  instanceof(type) {
    if (!this.isInstanceof(type)) {
      throw new TypeError(`Expected instance of ${type.name}, got ${__privateGet(this, _value).constructor.name}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Check if the node is an instance of the given class.
   * @param type - The type to check.
   * @returns Whether the node is an instance of the given type.
   */
  isInstanceof(type) {
    return __privateGet(this, _value) instanceof type;
  }
};
_value = new WeakMap();
_Maybe_instances = new WeakSet();
checkPrimitive_fn = /* @__PURE__ */ __name(function(type) {
  return typeof __privateGet(this, _value) === type;
}, "#checkPrimitive");
assertPrimitive_fn = /* @__PURE__ */ __name(function(type) {
  if (!__privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, type)) {
    throw new TypeError(`Expected ${type}, got ${this.typeof}`);
  }
  return __privateGet(this, _value);
}, "#assertPrimitive");
__name(_Maybe, "Maybe");
var Maybe = _Maybe;
var _result;
var _SuperParsedResult = class _SuperParsedResult {
  constructor(result) {
    __privateAdd(this, _result);
    __privateSet(this, _result, result);
  }
  get is_null() {
    return __privateGet(this, _result) === null;
  }
  get is_array() {
    return !this.is_null && Array.isArray(__privateGet(this, _result));
  }
  get is_node() {
    return !this.is_array;
  }
  array() {
    if (!this.is_array) {
      throw new TypeError("Expected an array, got a node");
    }
    return __privateGet(this, _result);
  }
  item() {
    if (!this.is_node) {
      throw new TypeError("Expected a node, got an array");
    }
    return __privateGet(this, _result);
  }
};
_result = new WeakMap();
__name(_SuperParsedResult, "SuperParsedResult");
var SuperParsedResult = _SuperParsedResult;
function observe(obj) {
  return new Proxy(obj, {
    get(target, prop) {
      if (prop == "get") {
        return (rule, del_item) => target.find((obj2, index) => {
          const match = deepCompare(rule, obj2);
          if (match && del_item) {
            target.splice(index, 1);
          }
          return match;
        });
      }
      if (prop == isObserved) {
        return true;
      }
      if (prop == "getAll") {
        return (rule, del_items) => target.filter((obj2, index) => {
          const match = deepCompare(rule, obj2);
          if (match && del_items) {
            target.splice(index, 1);
          }
          return match;
        });
      }
      if (prop == "matchCondition") {
        return (condition) => target.find((obj2) => {
          return condition(obj2);
        });
      }
      if (prop == "filterType") {
        return (...types) => {
          return observe(target.filter((node) => {
            return !!node.is(...types);
          }));
        };
      }
      if (prop == "firstOfType") {
        return (...types) => {
          return target.find((node) => {
            return !!node.is(...types);
          });
        };
      }
      if (prop == "first") {
        return () => target[0];
      }
      if (prop == "as") {
        return (...types) => {
          return observe(target.map((node) => {
            if (node.is(...types))
              return node;
            throw new ParsingError(`Expected node of any type ${types.map((type) => type.type).join(", ")}, got ${node.type}`);
          }));
        };
      }
      if (prop == "remove") {
        return (index) => target.splice(index, 1);
      }
      return Reflect.get(target, prop);
    }
  });
}
__name(observe, "observe");
var _Memo = class _Memo extends Map {
  getType(...types) {
    types = types.flat();
    return observe(types.flatMap((type) => this.get(type.type) || []));
  }
};
__name(_Memo, "Memo");
var Memo = _Memo;

// dist/src/parser/misc.js
var misc_exports = {};
__export(misc_exports, {
  AccessibilityContext: () => AccessibilityContext,
  AccessibilityData: () => AccessibilityData,
  Author: () => Author,
  ChildElement: () => ChildElement,
  CommandContext: () => CommandContext,
  EmojiRun: () => EmojiRun,
  Format: () => Format,
  RendererContext: () => RendererContext,
  SubscriptionButton: () => SubscriptionButton,
  Text: () => Text2,
  TextRun: () => TextRun,
  Thumbnail: () => Thumbnail,
  VideoDetails: () => VideoDetails
});

// dist/src/parser/classes/misc/AccessibilityContext.js
var _AccessibilityContext = class _AccessibilityContext {
  constructor(data) {
    __publicField(this, "label");
    this.label = data.label;
  }
};
__name(_AccessibilityContext, "AccessibilityContext");
var AccessibilityContext = _AccessibilityContext;

// dist/src/parser/classes/misc/AccessibilityData.js
var _AccessibilityData = class _AccessibilityData {
  constructor(data) {
    __publicField(this, "accessibility_identifier");
    __publicField(this, "identifier");
    __publicField(this, "label");
    if ("accessibilityIdentifier" in data) {
      this.accessibility_identifier = data.accessibilityIdentifier;
    }
    if ("identifier" in data) {
      this.identifier = {
        accessibility_id_type: data.identifier.accessibilityIdType
      };
    }
    if ("label" in data) {
      this.label = data.label;
    }
  }
};
__name(_AccessibilityData, "AccessibilityData");
var AccessibilityData = _AccessibilityData;

// dist/src/utils/Constants.js
var Constants_exports = {};
__export(Constants_exports, {
  CLIENTS: () => CLIENTS,
  CLIENT_NAME_IDS: () => CLIENT_NAME_IDS,
  INNERTUBE_HEADERS_BASE: () => INNERTUBE_HEADERS_BASE,
  OAUTH: () => OAUTH,
  STREAM_HEADERS: () => STREAM_HEADERS,
  SUPPORTED_CLIENTS: () => SUPPORTED_CLIENTS,
  URLS: () => URLS
});
var URLS = {
  YT_BASE: "https://www.youtube.com",
  YT_MUSIC_BASE: "https://music.youtube.com",
  YT_SUGGESTIONS: "https://suggestqueries-clients6.youtube.com",
  YT_UPLOAD: "https://upload.youtube.com/",
  API: {
    BASE: "https://youtubei.googleapis.com",
    PRODUCTION_1: "https://www.youtube.com/youtubei/",
    PRODUCTION_2: "https://youtubei.googleapis.com/youtubei/",
    STAGING: "https://green-youtubei.sandbox.googleapis.com/youtubei/",
    RELEASE: "https://release-youtubei.sandbox.googleapis.com/youtubei/",
    TEST: "https://test-youtubei.sandbox.googleapis.com/youtubei/",
    CAMI: "http://cami-youtubei.sandbox.googleapis.com/youtubei/",
    UYTFE: "https://uytfe.sandbox.google.com/youtubei/"
  },
  GOOGLE_SEARCH_BASE: "https://www.google.com/"
};
var OAUTH = {
  REGEX: {
    TV_SCRIPT: new RegExp('<script\\s+id="base-js"\\s+src="([^"]+)"[^>]*><\\/script>'),
    CLIENT_IDENTITY: new RegExp('clientId:"(?<client_id>[^"]+)",[^"]*?:"(?<client_secret>[^"]+)"')
  }
};
var CLIENTS = {
  IOS: {
    NAME: "iOS",
    VERSION: "20.11.6",
    USER_AGENT: "com.google.ios.youtube/20.11.6 (iPhone10,4; U; CPU iOS 16_7_7 like Mac OS X)",
    DEVICE_MODEL: "iPhone10,4",
    OS_NAME: "iOS",
    OS_VERSION: "16.7.7.20H330"
  },
  WEB: {
    NAME: "WEB",
    VERSION: "2.20250222.10.00",
    API_KEY: "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8",
    API_VERSION: "v1",
    STATIC_VISITOR_ID: "6zpwvWUNAco",
    SUGG_EXP_ID: "ytzpb5_e2,ytpo.bo.lqp.elu=1,ytpo.bo.lqp.ecsc=1,ytpo.bo.lqp.mcsc=3,ytpo.bo.lqp.mec=1,ytpo.bo.lqp.rw=0.8,ytpo.bo.lqp.fw=0.2,ytpo.bo.lqp.szp=1,ytpo.bo.lqp.mz=3,ytpo.bo.lqp.al=en_us,ytpo.bo.lqp.zrm=1,ytpo.bo.lqp.er=1,ytpo.bo.ro.erl=1,ytpo.bo.ro.mlus=3,ytpo.bo.ro.erls=3,ytpo.bo.qfo.mlus=3,ytzprp.ppp.e=1,ytzprp.ppp.st=772,ytzprp.ppp.p=5"
  },
  MWEB: {
    NAME: "MWEB",
    VERSION: "2.20250224.01.00",
    API_VERSION: "v1"
  },
  WEB_KIDS: {
    NAME: "WEB_KIDS",
    VERSION: "2.20250221.11.00"
  },
  YTMUSIC: {
    NAME: "WEB_REMIX",
    VERSION: "1.20250219.01.00"
  },
  ANDROID: {
    NAME: "ANDROID",
    VERSION: "19.35.36",
    SDK_VERSION: 33,
    USER_AGENT: "com.google.android.youtube/19.35.36(Linux; U; Android 13; en_US; SM-S908E Build/TP1A.220624.014) gzip"
  },
  YTSTUDIO_ANDROID: {
    NAME: "ANDROID_CREATOR",
    VERSION: "22.43.101"
  },
  YTMUSIC_ANDROID: {
    NAME: "ANDROID_MUSIC",
    VERSION: "5.34.51"
  },
  TV: {
    NAME: "TVHTML5",
    VERSION: "7.20250219.14.00",
    USER_AGENT: "Mozilla/5.0 (ChromiumStylePlatform) Cobalt/Version"
  },
  TV_SIMPLY: {
    NAME: "TVHTML5_SIMPLY",
    VERSION: "1.0"
  },
  TV_EMBEDDED: {
    NAME: "TVHTML5_SIMPLY_EMBEDDED_PLAYER",
    VERSION: "2.0"
  },
  WEB_EMBEDDED: {
    NAME: "WEB_EMBEDDED_PLAYER",
    VERSION: "1.20250219.01.00",
    API_KEY: "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8",
    API_VERSION: "v1",
    STATIC_VISITOR_ID: "6zpwvWUNAco"
  },
  WEB_CREATOR: {
    NAME: "WEB_CREATOR",
    VERSION: "1.20241203.01.00",
    API_KEY: "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8",
    API_VERSION: "v1",
    STATIC_VISITOR_ID: "6zpwvWUNAco"
  }
};
var CLIENT_NAME_IDS = {
  iOS: "5",
  WEB: "1",
  MWEB: "2",
  WEB_KIDS: "76",
  WEB_REMIX: "67",
  ANDROID: "3",
  ANDROID_CREATOR: "14",
  ANDROID_MUSIC: "21",
  TVHTML5: "7",
  TVHTML5_SIMPLY: "74",
  TVHTML5_SIMPLY_EMBEDDED_PLAYER: "85",
  WEB_EMBEDDED_PLAYER: "56",
  WEB_CREATOR: "62"
};
var STREAM_HEADERS = {
  "accept": "*/*",
  "origin": "https://www.youtube.com",
  "referer": "https://www.youtube.com",
  "DNT": "?1"
};
var INNERTUBE_HEADERS_BASE = {
  "accept": "*/*",
  "accept-encoding": "gzip, deflate",
  "content-type": "application/json"
};
var SUPPORTED_CLIENTS = ["IOS", "WEB", "MWEB", "YTKIDS", "YTMUSIC", "ANDROID", "YTSTUDIO_ANDROID", "YTMUSIC_ANDROID", "TV", "TV_SIMPLY", "TV_EMBEDDED", "WEB_EMBEDDED", "WEB_CREATOR"];

// dist/src/parser/parser.js
var parser_exports = {};
__export(parser_exports, {
  addRuntimeParser: () => addRuntimeParser,
  applyCommentsMutations: () => applyCommentsMutations,
  applyMutations: () => applyMutations,
  getDynamicParsers: () => getDynamicParsers,
  getParserByName: () => getParserByName,
  hasParser: () => hasParser,
  parse: () => parse,
  parseActions: () => parseActions,
  parseArray: () => parseArray,
  parseC: () => parseC,
  parseCommand: () => parseCommand,
  parseCommands: () => parseCommands,
  parseFormats: () => parseFormats,
  parseItem: () => parseItem,
  parseLC: () => parseLC,
  parseRR: () => parseRR,
  parseResponse: () => parseResponse,
  sanitizeClassName: () => sanitizeClassName,
  setParserErrorHandler: () => setParserErrorHandler,
  shouldIgnore: () => shouldIgnore
});

// dist/src/parser/nodes.js
var nodes_exports = {};
__export(nodes_exports, {
  AboutChannel: () => AboutChannel,
  AboutChannelView: () => AboutChannelView,
  AccountChannel: () => AccountChannel,
  AccountItem: () => AccountItem,
  AccountItemSection: () => AccountItemSection,
  AccountItemSectionHeader: () => AccountItemSectionHeader,
  AccountSectionList: () => AccountSectionList,
  ActiveAccountHeader: () => ActiveAccountHeader,
  AddBannerToLiveChatCommand: () => AddBannerToLiveChatCommand,
  AddChatItemAction: () => AddChatItemAction,
  AddLiveChatTickerItemAction: () => AddLiveChatTickerItemAction,
  AddToPlaylist: () => AddToPlaylist,
  AddToPlaylistCommand: () => AddToPlaylistCommand,
  AddToPlaylistEndpoint: () => AddToPlaylistEndpoint,
  AddToPlaylistServiceEndpoint: () => AddToPlaylistServiceEndpoint,
  Alert: () => Alert,
  AlertWithButton: () => AlertWithButton,
  AnchoredSection: () => AnchoredSection,
  AnimatedThumbnailOverlayView: () => AnimatedThumbnailOverlayView,
  AppendContinuationItemsAction: () => AppendContinuationItemsAction,
  AttributionView: () => AttributionView,
  AudioOnlyPlayability: () => AudioOnlyPlayability,
  AuthorCommentBadge: () => AuthorCommentBadge,
  AutomixPreviewVideo: () => AutomixPreviewVideo,
  AvatarStackView: () => AvatarStackView,
  AvatarView: () => AvatarView,
  BackgroundPromo: () => BackgroundPromo,
  BackstageImage: () => BackstageImage,
  BackstagePost: () => BackstagePost,
  BackstagePostThread: () => BackstagePostThread,
  BadgeView: () => BadgeView,
  BrowseEndpoint: () => BrowseEndpoint,
  BrowseFeedActions: () => BrowseFeedActions,
  BrowserMediaSession: () => BrowserMediaSession,
  BumperUserEduContentView: () => BumperUserEduContentView,
  Button: () => Button,
  ButtonCardView: () => ButtonCardView,
  ButtonView: () => ButtonView,
  C4TabbedHeader: () => C4TabbedHeader,
  CallToActionButton: () => CallToActionButton,
  Card: () => Card,
  CardCollection: () => CardCollection,
  CarouselHeader: () => CarouselHeader,
  CarouselItem: () => CarouselItem,
  CarouselItemView: () => CarouselItemView,
  CarouselLockup: () => CarouselLockup,
  CarouselTitleView: () => CarouselTitleView,
  ChangeEngagementPanelVisibilityAction: () => ChangeEngagementPanelVisibilityAction,
  Channel: () => Channel,
  ChannelAboutFullMetadata: () => ChannelAboutFullMetadata,
  ChannelAgeGate: () => ChannelAgeGate,
  ChannelExternalLinkView: () => ChannelExternalLinkView,
  ChannelFeaturedContent: () => ChannelFeaturedContent,
  ChannelHeaderLinks: () => ChannelHeaderLinks,
  ChannelHeaderLinksView: () => ChannelHeaderLinksView,
  ChannelMetadata: () => ChannelMetadata,
  ChannelMobileHeader: () => ChannelMobileHeader,
  ChannelOptions: () => ChannelOptions,
  ChannelOwnerEmptyState: () => ChannelOwnerEmptyState,
  ChannelSubMenu: () => ChannelSubMenu,
  ChannelSwitcherHeader: () => ChannelSwitcherHeader,
  ChannelSwitcherPage: () => ChannelSwitcherPage,
  ChannelTagline: () => ChannelTagline,
  ChannelThumbnailWithLink: () => ChannelThumbnailWithLink,
  ChannelVideoPlayer: () => ChannelVideoPlayer,
  Chapter: () => Chapter,
  ChildVideo: () => ChildVideo,
  ChipBarView: () => ChipBarView,
  ChipCloud: () => ChipCloud,
  ChipCloudChip: () => ChipCloudChip,
  ChipView: () => ChipView,
  ClientSideToggleMenuItem: () => ClientSideToggleMenuItem,
  ClipAdState: () => ClipAdState,
  ClipCreation: () => ClipCreation,
  ClipCreationScrubber: () => ClipCreationScrubber,
  ClipCreationTextInput: () => ClipCreationTextInput,
  ClipSection: () => ClipSection,
  CollaboratorInfoCardContent: () => CollaboratorInfoCardContent,
  CollageHeroImage: () => CollageHeroImage,
  CollectionThumbnailView: () => CollectionThumbnailView,
  CommandExecutorCommand: () => CommandExecutorCommand,
  CommentActionButtons: () => CommentActionButtons,
  CommentDialog: () => CommentDialog,
  CommentReplies: () => CommentReplies,
  CommentReplyDialog: () => CommentReplyDialog,
  CommentSimplebox: () => CommentSimplebox,
  CommentThread: () => CommentThread,
  CommentView: () => CommentView,
  CommentsEntryPointHeader: () => CommentsEntryPointHeader,
  CommentsEntryPointTeaser: () => CommentsEntryPointTeaser,
  CommentsHeader: () => CommentsHeader,
  CommentsSimplebox: () => CommentsSimplebox,
  CompactChannel: () => CompactChannel,
  CompactLink: () => CompactLink,
  CompactMix: () => CompactMix,
  CompactMovie: () => CompactMovie,
  CompactPlaylist: () => CompactPlaylist_default,
  CompactStation: () => CompactStation,
  CompactVideo: () => CompactVideo,
  CompositeVideoPrimaryInfo: () => CompositeVideoPrimaryInfo,
  ConfirmDialog: () => ConfirmDialog,
  ContentMetadataView: () => ContentMetadataView,
  ContentPreviewImageView: () => ContentPreviewImageView,
  ContinuationCommand: () => ContinuationCommand,
  ContinuationItem: () => ContinuationItem,
  ConversationBar: () => ConversationBar,
  CopyLink: () => CopyLink,
  CreateCommentEndpoint: () => CreateCommentEndpoint,
  CreatePlaylistDialog: () => CreatePlaylistDialog,
  CreatePlaylistDialogFormView: () => CreatePlaylistDialogFormView,
  CreatePlaylistServiceEndpoint: () => CreatePlaylistServiceEndpoint,
  CreatorHeart: () => CreatorHeart,
  CreatorHeartView: () => CreatorHeartView,
  DecoratedAvatarView: () => DecoratedAvatarView,
  DecoratedPlayerBar: () => DecoratedPlayerBar,
  DefaultPromoPanel: () => DefaultPromoPanel,
  DeletePlaylistEndpoint: () => DeletePlaylistEndpoint,
  DescriptionPreviewView: () => DescriptionPreviewView,
  DialogHeaderView: () => DialogHeaderView,
  DialogView: () => DialogView,
  DidYouMean: () => DidYouMean,
  DimChatItemAction: () => DimChatItemAction,
  DislikeButtonView: () => DislikeButtonView,
  DismissableDialog: () => DismissableDialog,
  DismissableDialogContentSection: () => DismissableDialogContentSection,
  DownloadButton: () => DownloadButton,
  Dropdown: () => Dropdown,
  DropdownItem: () => DropdownItem,
  DropdownView: () => DropdownView,
  DynamicTextView: () => DynamicTextView,
  Element: () => Element,
  EmergencyOnebox: () => EmergencyOnebox,
  EmojiPicker: () => EmojiPicker,
  EmojiPickerCategory: () => EmojiPickerCategory,
  EmojiPickerCategoryButton: () => EmojiPickerCategoryButton,
  EmojiPickerUpsellCategory: () => EmojiPickerUpsellCategory,
  EndScreenPlaylist: () => EndScreenPlaylist,
  EndScreenVideo: () => EndScreenVideo,
  Endscreen: () => Endscreen,
  EndscreenElement: () => EndscreenElement,
  EngagementPanelSectionList: () => EngagementPanelSectionList,
  EngagementPanelTitleHeader: () => EngagementPanelTitleHeader,
  EomSettingsDisclaimer: () => EomSettingsDisclaimer,
  ExpandableMetadata: () => ExpandableMetadata,
  ExpandableTab: () => ExpandableTab,
  ExpandableVideoDescriptionBody: () => ExpandableVideoDescriptionBody,
  ExpandedShelfContents: () => ExpandedShelfContents,
  Factoid: () => Factoid,
  FancyDismissibleDialog: () => FancyDismissibleDialog,
  FeedFilterChipBar: () => FeedFilterChipBar,
  FeedNudge: () => FeedNudge,
  FeedTabbedHeader: () => FeedTabbedHeader,
  FeedbackEndpoint: () => FeedbackEndpoint,
  FlexibleActionsView: () => FlexibleActionsView,
  Form: () => Form,
  FormFooterView: () => FormFooterView,
  FormPopup: () => FormPopup,
  GameCard: () => GameCard,
  GameDetails: () => GameDetails,
  GetAccountsListInnertubeEndpoint: () => GetAccountsListInnertubeEndpoint,
  GetKidsBlocklistPickerCommand: () => GetKidsBlocklistPickerCommand,
  GetMultiPageMenuAction: () => GetMultiPageMenuAction,
  Grid: () => Grid,
  GridChannel: () => GridChannel,
  GridHeader: () => GridHeader,
  GridMix: () => GridMix,
  GridMovie: () => GridMovie,
  GridPlaylist: () => GridPlaylist,
  GridShelfView: () => GridShelfView,
  GridShow: () => GridShow,
  GridVideo: () => GridVideo,
  GuideCollapsibleEntry: () => GuideCollapsibleEntry,
  GuideCollapsibleSectionEntry: () => GuideCollapsibleSectionEntry,
  GuideDownloadsEntry: () => GuideDownloadsEntry,
  GuideEntry: () => GuideEntry,
  GuideSection: () => GuideSection,
  GuideSubscriptionsSection: () => GuideSubscriptionsSection,
  HashtagHeader: () => HashtagHeader,
  HashtagTile: () => HashtagTile,
  HeatMarker: () => HeatMarker,
  Heatmap: () => Heatmap,
  HeroPlaylistThumbnail: () => HeroPlaylistThumbnail,
  HideEngagementPanelEndpoint: () => HideEngagementPanelEndpoint,
  HighlightsCarousel: () => HighlightsCarousel,
  HistorySuggestion: () => HistorySuggestion,
  HorizontalCardList: () => HorizontalCardList,
  HorizontalList: () => HorizontalList,
  HorizontalMovieList: () => HorizontalMovieList,
  HowThisWasMadeSectionView: () => HowThisWasMadeSectionView,
  HypePointsFactoid: () => HypePointsFactoid,
  IconLink: () => IconLink,
  ImageBannerView: () => ImageBannerView,
  IncludingResultsFor: () => IncludingResultsFor,
  InfoPanelContainer: () => InfoPanelContainer,
  InfoPanelContent: () => InfoPanelContent,
  InfoRow: () => InfoRow,
  InteractiveTabbedHeader: () => InteractiveTabbedHeader,
  ItemSection: () => ItemSection,
  ItemSectionHeader: () => ItemSectionHeader,
  ItemSectionTab: () => ItemSectionTab,
  ItemSectionTabbedHeader: () => ItemSectionTabbedHeader,
  KidsBlocklistPicker: () => KidsBlocklistPicker,
  KidsBlocklistPickerItem: () => KidsBlocklistPickerItem,
  KidsCategoriesHeader: () => KidsCategoriesHeader,
  KidsCategoryTab: () => KidsCategoryTab,
  KidsHomeScreen: () => KidsHomeScreen,
  LikeButton: () => LikeButton,
  LikeButtonView: () => LikeButtonView,
  LikeEndpoint: () => LikeEndpoint,
  ListItemView: () => ListItemView,
  ListView: () => ListView,
  LiveChat: () => LiveChat,
  LiveChatActionPanel: () => LiveChatActionPanel,
  LiveChatAuthorBadge: () => LiveChatAuthorBadge,
  LiveChatAutoModMessage: () => LiveChatAutoModMessage,
  LiveChatBanner: () => LiveChatBanner,
  LiveChatBannerChatSummary: () => LiveChatBannerChatSummary,
  LiveChatBannerHeader: () => LiveChatBannerHeader,
  LiveChatBannerPoll: () => LiveChatBannerPoll,
  LiveChatBannerRedirect: () => LiveChatBannerRedirect,
  LiveChatDialog: () => LiveChatDialog,
  LiveChatHeader: () => LiveChatHeader,
  LiveChatItemBumperView: () => LiveChatItemBumperView,
  LiveChatItemContextMenuEndpoint: () => LiveChatItemContextMenuEndpoint,
  LiveChatItemList: () => LiveChatItemList,
  LiveChatMembershipItem: () => LiveChatMembershipItem,
  LiveChatMessageInput: () => LiveChatMessageInput,
  LiveChatModeChangeMessage: () => LiveChatModeChangeMessage,
  LiveChatPaidMessage: () => LiveChatPaidMessage,
  LiveChatPaidSticker: () => LiveChatPaidSticker,
  LiveChatParticipant: () => LiveChatParticipant,
  LiveChatParticipantsList: () => LiveChatParticipantsList,
  LiveChatPlaceholderItem: () => LiveChatPlaceholderItem,
  LiveChatProductItem: () => LiveChatProductItem,
  LiveChatRestrictedParticipation: () => LiveChatRestrictedParticipation,
  LiveChatSponsorshipsGiftPurchaseAnnouncement: () => LiveChatSponsorshipsGiftPurchaseAnnouncement,
  LiveChatSponsorshipsGiftRedemptionAnnouncement: () => LiveChatSponsorshipsGiftRedemptionAnnouncement,
  LiveChatSponsorshipsHeader: () => LiveChatSponsorshipsHeader,
  LiveChatTextMessage: () => LiveChatTextMessage,
  LiveChatTickerPaidMessageItem: () => LiveChatTickerPaidMessageItem,
  LiveChatTickerPaidStickerItem: () => LiveChatTickerPaidStickerItem,
  LiveChatTickerSponsorItem: () => LiveChatTickerSponsorItem,
  LiveChatViewerEngagementMessage: () => LiveChatViewerEngagementMessage,
  LockupMetadataView: () => LockupMetadataView,
  LockupView: () => LockupView,
  MacroMarkersInfoItem: () => MacroMarkersInfoItem,
  MacroMarkersList: () => MacroMarkersList,
  MacroMarkersListEntity: () => MacroMarkersListEntity,
  MacroMarkersListItem: () => MacroMarkersListItem,
  MarkChatItemAsDeletedAction: () => MarkChatItemAsDeletedAction,
  MarkChatItemsByAuthorAsDeletedAction: () => MarkChatItemsByAuthorAsDeletedAction,
  Menu: () => Menu,
  MenuFlexibleItem: () => MenuFlexibleItem,
  MenuNavigationItem: () => MenuNavigationItem,
  MenuPopup: () => MenuPopup,
  MenuServiceItem: () => MenuServiceItem,
  MenuServiceItemDownload: () => MenuServiceItemDownload,
  MenuTitle: () => MenuTitle,
  MerchandiseItem: () => MerchandiseItem,
  MerchandiseShelf: () => MerchandiseShelf,
  Message: () => Message,
  MetadataBadge: () => MetadataBadge,
  MetadataRow: () => MetadataRow,
  MetadataRowContainer: () => MetadataRowContainer,
  MetadataRowHeader: () => MetadataRowHeader,
  MetadataScreen: () => MetadataScreen,
  MicroformatData: () => MicroformatData,
  Mix: () => Mix,
  MobileTopbar: () => MobileTopbar,
  ModalWithTitleAndButton: () => ModalWithTitleAndButton,
  ModifyChannelNotificationPreferenceEndpoint: () => ModifyChannelNotificationPreferenceEndpoint,
  Movie: () => Movie,
  MovingThumbnail: () => MovingThumbnail,
  MultiMarkersPlayerBar: () => MultiMarkersPlayerBar,
  MultiPageMenu: () => MultiPageMenu,
  MultiPageMenuNotificationSection: () => MultiPageMenuNotificationSection,
  MultiPageMenuSection: () => MultiPageMenuSection,
  MusicCardShelf: () => MusicCardShelf,
  MusicCardShelfHeaderBasic: () => MusicCardShelfHeaderBasic,
  MusicCarouselShelf: () => MusicCarouselShelf,
  MusicCarouselShelfBasicHeader: () => MusicCarouselShelfBasicHeader,
  MusicDescriptionShelf: () => MusicDescriptionShelf,
  MusicDetailHeader: () => MusicDetailHeader,
  MusicDownloadStateBadge: () => MusicDownloadStateBadge,
  MusicEditablePlaylistDetailHeader: () => MusicEditablePlaylistDetailHeader,
  MusicElementHeader: () => MusicElementHeader,
  MusicHeader: () => MusicHeader,
  MusicImmersiveHeader: () => MusicImmersiveHeader,
  MusicInlineBadge: () => MusicInlineBadge,
  MusicItemThumbnailOverlay: () => MusicItemThumbnailOverlay,
  MusicLargeCardItemCarousel: () => MusicLargeCardItemCarousel,
  MusicMenuItemDivider: () => MusicMenuItemDivider,
  MusicMultiRowListItem: () => MusicMultiRowListItem,
  MusicMultiSelectMenu: () => MusicMultiSelectMenu,
  MusicMultiSelectMenuItem: () => MusicMultiSelectMenuItem,
  MusicNavigationButton: () => MusicNavigationButton,
  MusicPlayButton: () => MusicPlayButton,
  MusicPlaylistEditHeader: () => MusicPlaylistEditHeader,
  MusicPlaylistShelf: () => MusicPlaylistShelf,
  MusicQueue: () => MusicQueue,
  MusicResponsiveHeader: () => MusicResponsiveHeader,
  MusicResponsiveListItem: () => MusicResponsiveListItem,
  MusicResponsiveListItemFixedColumn: () => MusicResponsiveListItemFixedColumn,
  MusicResponsiveListItemFlexColumn: () => MusicResponsiveListItemFlexColumn,
  MusicShelf: () => MusicShelf,
  MusicSideAlignedItem: () => MusicSideAlignedItem,
  MusicSortFilterButton: () => MusicSortFilterButton,
  MusicTastebuilderShelf: () => MusicTasteBuilderShelf,
  MusicTastebuilderShelfThumbnail: () => MusicTastebuilderShelfThumbnail,
  MusicThumbnail: () => MusicThumbnail,
  MusicTwoRowItem: () => MusicTwoRowItem,
  MusicVisualHeader: () => MusicVisualHeader,
  NavigationEndpoint: () => NavigationEndpoint,
  Notification: () => Notification,
  NotificationAction: () => NotificationAction,
  OpenOnePickAddVideoModalCommand: () => OpenOnePickAddVideoModalCommand,
  OpenPopupAction: () => OpenPopupAction,
  PageHeader: () => PageHeader,
  PageHeaderView: () => PageHeaderView,
  PageIntroduction: () => PageIntroduction,
  PanelFooterView: () => PanelFooterView,
  PdgCommentChip: () => PdgCommentChip,
  PdgReplyButtonView: () => PdgReplyButtonView,
  PerformCommentActionEndpoint: () => PerformCommentActionEndpoint,
  PivotBar: () => PivotBar,
  PivotBarItem: () => PivotBarItem,
  PivotButton: () => PivotButton,
  PlayerAnnotationsExpanded: () => PlayerAnnotationsExpanded,
  PlayerCaptionsTracklist: () => PlayerCaptionsTracklist,
  PlayerControlsOverlay: () => PlayerControlsOverlay,
  PlayerErrorMessage: () => PlayerErrorMessage,
  PlayerLegacyDesktopYpcOffer: () => PlayerLegacyDesktopYpcOffer,
  PlayerLegacyDesktopYpcTrailer: () => PlayerLegacyDesktopYpcTrailer,
  PlayerLiveStoryboardSpec: () => PlayerLiveStoryboardSpec,
  PlayerMicroformat: () => PlayerMicroformat,
  PlayerOverflow: () => PlayerOverflow,
  PlayerOverlay: () => PlayerOverlay,
  PlayerOverlayAutoplay: () => PlayerOverlayAutoplay,
  PlayerOverlayVideoDetails: () => PlayerOverlayVideoDetails,
  PlayerStoryboardSpec: () => PlayerStoryboardSpec,
  Playlist: () => Playlist,
  PlaylistAddToOption: () => PlaylistAddToOption,
  PlaylistCustomThumbnail: () => PlaylistCustomThumbnail,
  PlaylistEditEndpoint: () => PlaylistEditEndpoint,
  PlaylistHeader: () => PlaylistHeader,
  PlaylistInfoCardContent: () => PlaylistInfoCardContent,
  PlaylistMetadata: () => PlaylistMetadata,
  PlaylistPanel: () => PlaylistPanel,
  PlaylistPanelVideo: () => PlaylistPanelVideo,
  PlaylistPanelVideoWrapper: () => PlaylistPanelVideoWrapper,
  PlaylistSidebar: () => PlaylistSidebar,
  PlaylistSidebarPrimaryInfo: () => PlaylistSidebarPrimaryInfo,
  PlaylistSidebarSecondaryInfo: () => PlaylistSidebarSecondaryInfo,
  PlaylistThumbnailOverlay: () => PlaylistThumbnailOverlay,
  PlaylistVideo: () => PlaylistVideo,
  PlaylistVideoList: () => PlaylistVideoList,
  PlaylistVideoThumbnail: () => PlaylistVideoThumbnail,
  Poll: () => Poll,
  PollHeader: () => PollHeader,
  Post: () => Post,
  PostMultiImage: () => PostMultiImage,
  PrefetchWatchCommand: () => PrefetchWatchCommand,
  PremiereTrailerBadge: () => PremiereTrailerBadge,
  ProductList: () => ProductList,
  ProductListHeader: () => ProductListHeader,
  ProductListItem: () => ProductListItem,
  ProfileColumn: () => ProfileColumn,
  ProfileColumnStats: () => ProfileColumnStats,
  ProfileColumnStatsEntry: () => ProfileColumnStatsEntry,
  ProfileColumnUserInfo: () => ProfileColumnUserInfo,
  Quiz: () => Quiz,
  RecognitionShelf: () => RecognitionShelf,
  ReelItem: () => ReelItem,
  ReelPlayerHeader: () => ReelPlayerHeader,
  ReelPlayerOverlay: () => ReelPlayerOverlay,
  ReelShelf: () => ReelShelf,
  ReelWatchEndpoint: () => ReelWatchEndpoint,
  RelatedChipCloud: () => RelatedChipCloud,
  RemoveBannerForLiveChatCommand: () => RemoveBannerForLiveChatCommand,
  RemoveChatItemAction: () => RemoveChatItemAction,
  RemoveChatItemByAuthorAction: () => RemoveChatItemByAuthorAction,
  ReplaceChatItemAction: () => ReplaceChatItemAction,
  ReplaceLiveChatAction: () => ReplaceLiveChatAction,
  ReplayChatItemAction: () => ReplayChatItemAction,
  RichGrid: () => RichGrid,
  RichItem: () => RichItem,
  RichListHeader: () => RichListHeader,
  RichMetadata: () => RichMetadata,
  RichMetadataRow: () => RichMetadataRow,
  RichSection: () => RichSection,
  RichShelf: () => RichShelf,
  RunAttestationCommand: () => RunAttestationCommand,
  SearchBox: () => SearchBox,
  SearchEndpoint: () => SearchEndpoint,
  SearchFilter: () => SearchFilter2,
  SearchFilterGroup: () => SearchFilterGroup,
  SearchFilterOptionsDialog: () => SearchFilterOptionsDialog,
  SearchHeader: () => SearchHeader,
  SearchRefinementCard: () => SearchRefinementCard,
  SearchSubMenu: () => SearchSubMenu,
  SearchSuggestion: () => SearchSuggestion,
  SearchSuggestionsSection: () => SearchSuggestionsSection,
  SecondarySearchContainer: () => SecondarySearchContainer,
  SectionHeaderView: () => SectionHeaderView,
  SectionList: () => SectionList,
  SegmentedLikeDislikeButton: () => SegmentedLikeDislikeButton,
  SegmentedLikeDislikeButtonView: () => SegmentedLikeDislikeButtonView,
  SendFeedbackAction: () => SendFeedbackAction,
  SettingBoolean: () => SettingBoolean,
  SettingsCheckbox: () => SettingsCheckbox,
  SettingsOptions: () => SettingsOptions,
  SettingsSidebar: () => SettingsSidebar,
  SettingsSwitch: () => SettingsSwitch,
  ShareEndpoint: () => ShareEndpoint,
  ShareEntityEndpoint: () => ShareEntityEndpoint,
  ShareEntityServiceEndpoint: () => ShareEntityServiceEndpoint,
  SharePanelHeader: () => SharePanelHeader,
  SharePanelTitleV15: () => SharePanelTitleV15,
  ShareTarget: () => ShareTarget,
  SharedPost: () => SharedPost,
  Shelf: () => Shelf,
  ShortsLockupView: () => ShortsLockupView,
  ShowCustomThumbnail: () => ShowCustomThumbnail,
  ShowDialogCommand: () => ShowDialogCommand,
  ShowEngagementPanelEndpoint: () => ShowEngagementPanelEndpoint,
  ShowLiveChatActionPanelAction: () => ShowLiveChatActionPanelAction,
  ShowLiveChatDialogAction: () => ShowLiveChatDialogAction,
  ShowLiveChatTooltipCommand: () => ShowLiveChatTooltipCommand,
  ShowingResultsFor: () => ShowingResultsFor,
  SignalAction: () => SignalAction,
  SignalServiceEndpoint: () => SignalServiceEndpoint,
  SimpleCardContent: () => SimpleCardContent,
  SimpleCardTeaser: () => SimpleCardTeaser,
  SimpleMenuHeader: () => SimpleMenuHeader,
  SimpleTextSection: () => SimpleTextSection,
  SingleActionEmergencySupport: () => SingleActionEmergencySupport,
  SingleColumnBrowseResults: () => SingleColumnBrowseResults,
  SingleColumnMusicWatchNextResults: () => SingleColumnMusicWatchNextResults,
  SingleHeroImage: () => SingleHeroImage,
  SlimOwner: () => SlimOwner,
  SlimVideoMetadata: () => SlimVideoMetadata,
  SortFilterHeader: () => SortFilterHeader,
  SortFilterSubMenu: () => SortFilterSubMenu,
  SponsorCommentBadge: () => SponsorCommentBadge,
  StartAt: () => StartAt,
  StructuredDescriptionContent: () => StructuredDescriptionContent,
  StructuredDescriptionPlaylistLockup: () => StructuredDescriptionPlaylistLockup,
  SubFeedOption: () => SubFeedOption,
  SubFeedSelector: () => SubFeedSelector,
  SubscribeButton: () => SubscribeButton,
  SubscribeButtonView: () => SubscribeButtonView,
  SubscribeEndpoint: () => SubscribeEndpoint,
  SubscriptionNotificationToggleButton: () => SubscriptionNotificationToggleButton,
  Tab: () => Tab,
  Tabbed: () => Tabbed,
  TabbedSearchResults: () => TabbedSearchResults,
  TextCarouselItemView: () => TextCarouselItemView,
  TextFieldView: () => TextFieldView,
  TextHeader: () => TextHeader,
  ThirdPartyShareTargetSection: () => ThirdPartyShareTargetSection,
  ThumbnailBadgeView: () => ThumbnailBadgeView,
  ThumbnailBottomOverlayView: () => ThumbnailBottomOverlayView,
  ThumbnailHoverOverlayToggleActionsView: () => ThumbnailHoverOverlayToggleActionsView,
  ThumbnailHoverOverlayView: () => ThumbnailHoverOverlayView,
  ThumbnailLandscapePortrait: () => ThumbnailLandscapePortrait,
  ThumbnailOverlayBadgeView: () => ThumbnailOverlayBadgeView,
  ThumbnailOverlayBottomPanel: () => ThumbnailOverlayBottomPanel,
  ThumbnailOverlayEndorsement: () => ThumbnailOverlayEndorsement,
  ThumbnailOverlayHoverText: () => ThumbnailOverlayHoverText,
  ThumbnailOverlayInlineUnplayable: () => ThumbnailOverlayInlineUnplayable,
  ThumbnailOverlayLoadingPreview: () => ThumbnailOverlayLoadingPreview,
  ThumbnailOverlayNowPlaying: () => ThumbnailOverlayNowPlaying,
  ThumbnailOverlayPinking: () => ThumbnailOverlayPinking,
  ThumbnailOverlayPlaybackStatus: () => ThumbnailOverlayPlaybackStatus,
  ThumbnailOverlayProgressBarView: () => ThumbnailOverlayProgressBarView,
  ThumbnailOverlayResumePlayback: () => ThumbnailOverlayResumePlayback,
  ThumbnailOverlaySidePanel: () => ThumbnailOverlaySidePanel,
  ThumbnailOverlayTimeStatus: () => ThumbnailOverlayTimeStatus,
  ThumbnailOverlayToggleButton: () => ThumbnailOverlayToggleButton,
  ThumbnailView: () => ThumbnailView,
  TimedMarkerDecoration: () => TimedMarkerDecoration,
  TitleAndButtonListHeader: () => TitleAndButtonListHeader,
  ToggleButton: () => ToggleButton,
  ToggleButtonView: () => ToggleButtonView,
  ToggleFormField: () => ToggleFormField,
  ToggleMenuServiceItem: () => ToggleMenuServiceItem,
  Tooltip: () => Tooltip,
  TopbarMenuButton: () => TopbarMenuButton,
  TopicChannelDetails: () => TopicChannelDetails,
  Transcript: () => Transcript,
  TranscriptFooter: () => TranscriptFooter,
  TranscriptSearchBox: () => TranscriptSearchBox,
  TranscriptSearchPanel: () => TranscriptSearchPanel,
  TranscriptSectionHeader: () => TranscriptSectionHeader,
  TranscriptSegment: () => TranscriptSegment,
  TranscriptSegmentList: () => TranscriptSegmentList,
  TwoColumnBrowseResults: () => TwoColumnBrowseResults,
  TwoColumnSearchResults: () => TwoColumnSearchResults,
  TwoColumnWatchNextResults: () => TwoColumnWatchNextResults,
  UnifiedSharePanel: () => UnifiedSharePanel,
  UniversalWatchCard: () => UniversalWatchCard,
  UnsubscribeEndpoint: () => UnsubscribeEndpoint,
  UpdateChannelSwitcherPageAction: () => UpdateChannelSwitcherPageAction,
  UpdateDateTextAction: () => UpdateDateTextAction,
  UpdateDescriptionAction: () => UpdateDescriptionAction,
  UpdateEngagementPanelAction: () => UpdateEngagementPanelAction,
  UpdateEngagementPanelContentCommand: () => UpdateEngagementPanelContentCommand,
  UpdateLiveChatPollAction: () => UpdateLiveChatPollAction,
  UpdateSubscribeButtonAction: () => UpdateSubscribeButtonAction,
  UpdateTitleAction: () => UpdateTitleAction,
  UpdateToggleButtonTextAction: () => UpdateToggleButtonTextAction,
  UpdateViewershipAction: () => UpdateViewershipAction,
  UploadTimeFactoid: () => UploadTimeFactoid,
  UpsellDialog: () => UpsellDialog,
  VerticalList: () => VerticalList,
  VerticalWatchCardList: () => VerticalWatchCardList,
  Video: () => Video,
  VideoAttributeView: () => VideoAttributeView,
  VideoAttributesSectionView: () => VideoAttributesSectionView,
  VideoCard: () => VideoCard,
  VideoDescriptionCourseSection: () => VideoDescriptionCourseSection,
  VideoDescriptionHeader: () => VideoDescriptionHeader,
  VideoDescriptionInfocardsSection: () => VideoDescriptionInfocardsSection,
  VideoDescriptionMusicSection: () => VideoDescriptionMusicSection,
  VideoDescriptionTranscriptSection: () => VideoDescriptionTranscriptSection,
  VideoInfoCardContent: () => VideoInfoCardContent,
  VideoMetadataCarouselView: () => VideoMetadataCarouselView,
  VideoOwner: () => VideoOwner,
  VideoPrimaryInfo: () => VideoPrimaryInfo,
  VideoSecondaryInfo: () => VideoSecondaryInfo,
  VideoViewCount: () => VideoViewCount,
  ViewCountFactoid: () => ViewCountFactoid,
  VoiceReplyContainerView: () => VoiceReplyContainerView,
  WatchCardCompactVideo: () => WatchCardCompactVideo,
  WatchCardHeroVideo: () => WatchCardHeroVideo,
  WatchCardRichHeader: () => WatchCardRichHeader,
  WatchCardSectionSequence: () => WatchCardSectionSequence,
  WatchEndpoint: () => WatchEndpoint,
  WatchNextEndScreen: () => WatchNextEndScreen,
  WatchNextEndpoint: () => WatchNextEndpoint,
  WatchNextTabbedResults: () => WatchNextTabbedResults,
  YpcTrailer: () => YpcTrailer
});

// dist/src/utils/Cache.js
var _cache;
var _UniversalCache = class _UniversalCache {
  constructor(persistent, persistent_directory) {
    __privateAdd(this, _cache);
    __privateSet(this, _cache, new Platform.shim.Cache(persistent, persistent_directory));
  }
  get cache_dir() {
    return __privateGet(this, _cache).cache_dir;
  }
  get(key) {
    return __privateGet(this, _cache).get(key);
  }
  set(key, value) {
    return __privateGet(this, _cache).set(key, value);
  }
  remove(key) {
    return __privateGet(this, _cache).remove(key);
  }
};
_cache = new WeakMap();
__name(_UniversalCache, "UniversalCache");
var UniversalCache = _UniversalCache;

// dist/src/utils/EventEmitterLike.js
var _legacy_listeners;
var _EventEmitterLike = class _EventEmitterLike extends EventTarget {
  constructor() {
    super();
    __privateAdd(this, _legacy_listeners, /* @__PURE__ */ new Map());
  }
  emit(type, ...args) {
    const event = new Platform.shim.CustomEvent(type, { detail: args });
    this.dispatchEvent(event);
  }
  on(type, listener) {
    const wrapper = /* @__PURE__ */ __name((ev) => {
      if (ev instanceof Platform.shim.CustomEvent) {
        listener(...ev.detail);
      } else {
        listener(ev);
      }
    }, "wrapper");
    __privateGet(this, _legacy_listeners).set(listener, wrapper);
    this.addEventListener(type, wrapper);
  }
  once(type, listener) {
    const wrapper = /* @__PURE__ */ __name((ev) => {
      if (ev instanceof Platform.shim.CustomEvent) {
        listener(...ev.detail);
      } else {
        listener(ev);
      }
      this.off(type, listener);
    }, "wrapper");
    __privateGet(this, _legacy_listeners).set(listener, wrapper);
    this.addEventListener(type, wrapper);
  }
  off(type, listener) {
    const wrapper = __privateGet(this, _legacy_listeners).get(listener);
    if (wrapper) {
      this.removeEventListener(type, wrapper);
      __privateGet(this, _legacy_listeners).delete(listener);
    }
  }
};
_legacy_listeners = new WeakMap();
__name(_EventEmitterLike, "EventEmitterLike");
var EventEmitterLike = _EventEmitterLike;

// dist/src/utils/FormatUtils.js
var FormatUtils_exports = {};
__export(FormatUtils_exports, {
  chooseFormat: () => chooseFormat,
  download: () => download,
  toDash: () => toDash
});

// dist/src/utils/DashUtils.js
var XML_CHARACTER_MAP = {
  "&": "&amp;",
  '"': "&quot;",
  "'": "&apos;",
  "<": "&lt;",
  ">": "&gt;"
};
function escapeXMLString(str) {
  return str.replace(/([&"<>'])/g, (_, item) => {
    return XML_CHARACTER_MAP[item];
  });
}
__name(escapeXMLString, "escapeXMLString");
function normalizeTag(tag) {
  return tag.charAt(0).toUpperCase() + tag.slice(1);
}
__name(normalizeTag, "normalizeTag");
function createElement(tagNameOrFunction, props, ...children) {
  const normalizedChildren = children.flat();
  if (typeof tagNameOrFunction === "function") {
    return tagNameOrFunction({ ...props, children: normalizedChildren });
  }
  return {
    type: normalizeTag(tagNameOrFunction),
    props: {
      ...props,
      children: normalizedChildren
    }
  };
}
__name(createElement, "createElement");
async function renderElementToString(element) {
  if (typeof element === "string")
    return escapeXMLString(element);
  let dom = `<${element.type}`;
  if (element.props) {
    for (const key of Object.keys(element.props)) {
      if (key !== "children" && element.props[key] !== void 0) {
        dom += ` ${key}="${escapeXMLString(`${element.props[key]}`)}"`;
      }
    }
  }
  if (element.props.children) {
    const children = await Promise.all((await Promise.all(element.props.children.flat())).flat().filter((child) => !!child).map((child) => renderElementToString(child)));
    if (children.length > 0) {
      dom += `>${children.join("")}</${element.type}>`;
      return dom;
    }
  }
  return `${dom}/>`;
}
__name(renderElementToString, "renderElementToString");
async function renderToString(root) {
  const dom = await renderElementToString(await root);
  return `<?xml version="1.0" encoding="utf-8"?>${dom}`;
}
__name(renderToString, "renderToString");
function Fragment(props) {
  return props.children;
}
__name(Fragment, "Fragment");

// dist/src/parser/classes/PlayerStoryboardSpec.js
var _PlayerStoryboardSpec = class _PlayerStoryboardSpec extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "boards");
    const parts = data.spec.split("|");
    const url = new URL(parts.shift());
    this.boards = parts.map((part, i) => {
      const [thumbnail_width, thumbnail_height, thumbnail_count, columns, rows, interval, name, sigh] = part.split("#");
      url.searchParams.set("sigh", sigh);
      const storyboard_count = Math.ceil(parseInt(thumbnail_count, 10) / (parseInt(columns, 10) * parseInt(rows, 10)));
      return {
        type: "vod",
        template_url: url.toString().replace("$L", i).replace("$N", name),
        thumbnail_width: parseInt(thumbnail_width, 10),
        thumbnail_height: parseInt(thumbnail_height, 10),
        thumbnail_count: parseInt(thumbnail_count, 10),
        interval: parseInt(interval, 10),
        columns: parseInt(columns, 10),
        rows: parseInt(rows, 10),
        storyboard_count
      };
    });
  }
};
__name(_PlayerStoryboardSpec, "PlayerStoryboardSpec");
__publicField(_PlayerStoryboardSpec, "type", "PlayerStoryboardSpec");
var PlayerStoryboardSpec = _PlayerStoryboardSpec;

// dist/package.json
var package_default = {
  name: "youtubei.js",
  version: "16.0.1",
  description: "A JavaScript client for YouTube's private API, known as InnerTube.",
  type: "module",
  types: "./dist/src/platform/lib.d.ts",
  typesVersions: {
    "*": {
      agnostic: [
        "./dist/src/platform/lib.d.ts"
      ],
      web: [
        "./dist/src/platform/lib.d.ts"
      ],
      "react-native": [
        "./dist/src/platform/lib.d.ts"
      ],
      "web.bundle": [
        "./dist/src/platform/lib.d.ts"
      ],
      "web.bundle.min": [
        "./dist/src/platform/lib.d.ts"
      ],
      "cf-worker": [
        "./dist/src/platform/lib.d.ts"
      ]
    }
  },
  exports: {
    ".": {
      deno: "./dist/src/platform/deno.js",
      node: {
        import: "./dist/src/platform/node.js",
        default: "./dist/src/platform/node.js"
      },
      types: "./dist/src/platform/lib.d.ts",
      browser: "./dist/src/platform/web.js",
      "react-native": "./dist/src/platform/react-native.js",
      default: "./dist/src/platform/web.js"
    },
    "./package.json": "./package.json",
    "./agnostic": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/lib.js"
    },
    "./web": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/web.js"
    },
    "./react-native": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/react-native.js"
    },
    "./web.bundle": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./bundle/browser.js"
    },
    "./cf-worker": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/cf-worker.js"
    }
  },
  author: "LuanRT <luan.lrt4@gmail.com> (https://github.com/LuanRT)",
  funding: [
    "https://github.com/sponsors/LuanRT"
  ],
  contributors: [
    "Wykerd (https://github.com/wykerd/)",
    "MasterOfBob777 (https://github.com/MasterOfBob777)",
    "patrickkfkan (https://github.com/patrickkfkan)",
    "akkadaska (https://github.com/akkadaska)",
    "Absidue (https://github.com/absidue)"
  ],
  scripts: {
    test: "vitest run --reporter verbose",
    lint: "eslint ./src",
    "lint:fix": "eslint --fix ./src",
    "clean:source-maps": "rimraf ./bundle/browser.js.map ./bundle/cf-worker.js.map ./bundle/react-native.js.map",
    "clean:build-output": "rimraf ./dist ./bundle/browser.js ./bundle/cf-worker.js ./bundle/react-native.js ./deno",
    build: "npm run clean:build-output && npm run clean:source-maps && npm run build:parser-map && npm run build:esm && npm run bundle:browser && npm run bundle:cf-worker && npm run bundle:react-native",
    "build:esm": "tspc",
    "build:deno": `cpy ./src ./deno && cpy ./protos ./deno && esbuild ./src/utils/DashManifest.tsx --keep-names --format=esm --platform=neutral --target=es2020 --outfile=./deno/src/utils/DashManifest.js && cpy ./package.json ./deno && replace ".js';" ".ts';" ./deno -r && replace '.js";' '.ts";' ./deno -r && replace "'./DashManifest.ts';" "'./DashManifest.js';" ./deno -r && replace "'jintr';" "'jsr:@luanrt/jintr';" ./deno -r && replace "@bufbuild/protobuf/wire" "https://esm.sh/@bufbuild/protobuf@2.0.0/wire" ./deno -r`,
    "build:proto": "rimraf ./protos/generated && node ./dev-scripts/generate-proto.mjs",
    "build:parser-map": "node ./dev-scripts/gen-parser-map.mjs",
    "bundle:browser": 'esbuild ./dist/src/platform/web.js --banner:js="/* eslint-disable */" --bundle --sourcemap --target=chrome70 --keep-names --format=esm --define:global=globalThis --conditions=module --outfile=./bundle/browser.js --platform=browser',
    "bundle:react-native": "esbuild ./dist/src/platform/react-native.js --bundle --sourcemap --target=es2020 --keep-names --format=esm --platform=neutral --define:global=globalThis --conditions=module --outfile=./bundle/react-native.js",
    "bundle:cf-worker": 'esbuild ./dist/src/platform/cf-worker.js --banner:js="/* eslint-disable */" --bundle --sourcemap --target=es2020 --keep-names --format=esm --define:global=globalThis --conditions=module --outfile=./bundle/cf-worker.js --platform=node',
    "build:docs": "typedoc",
    prepare: "npm run build",
    watch: "tspc --watch"
  },
  repository: {
    type: "git",
    url: "git+https://github.com/LuanRT/YouTube.js.git"
  },
  files: [
    "dist/",
    "bundle/",
    "package.json",
    "README.md",
    "LICENSE"
  ],
  license: "MIT",
  dependencies: {
    "@bufbuild/protobuf": "^2.0.0",
    meriyah: "^6.1.4"
  },
  devDependencies: {
    "@eslint/js": "^9.37.0",
    "@types/estree": "^1.0.6",
    "@types/glob": "^8.1.0",
    "@types/node": "^24.0.14",
    "@typescript-eslint/eslint-plugin": "^8.46.0",
    "@typescript-eslint/parser": "^8.46.0",
    "cpy-cli": "^6.0.0",
    esbuild: "^0.25.6",
    eslint: "^9.37.0",
    globals: "^16.4.0",
    replace: "^1.2.2",
    rimraf: "^6.0.1",
    "ts-patch": "^3.0.2",
    "ts-proto": "^2.2.0",
    typedoc: "^0.28.14",
    "typedoc-plugin-markdown": "^4.9.0",
    typescript: "^5.9.3",
    "typescript-eslint": "^8.46.0",
    vitest: "^3.2.4"
  },
  bugs: {
    url: "https://github.com/LuanRT/YouTube.js/issues"
  },
  homepage: "https://github.com/LuanRT/YouTube.js#readme",
  keywords: [
    "api",
    "youtube",
    "innertube",
    "livechat",
    "youtube-music",
    "ytdl",
    "youtube-studio",
    "downloader",
    "ytmusic"
  ]
};

// dist/src/utils/StreamingInfo.js
var TAG_ = "StreamingInfo";
function getFormatGroupings(formats, is_post_live_dvr) {
  var _a, _b, _c;
  const group_info = /* @__PURE__ */ new Map();
  const has_multiple_audio_tracks = formats.some((fmt) => !!fmt.audio_track);
  for (const format of formats) {
    if ((!format.index_range || !format.init_range) && !format.is_type_otf && !is_post_live_dvr) {
      continue;
    }
    const mime_type = format.mime_type.split(";")[0];
    const just_codec = (_a = getStringBetweenStrings(format.mime_type, 'codecs="', '"')) == null ? void 0 : _a.split(".")[0];
    const color_info = format.color_info ? Object.values(format.color_info).join("-") : "";
    const audio_track_id = ((_b = format.audio_track) == null ? void 0 : _b.id) || "";
    const drc = format.is_drc ? "drc" : "";
    const group_id = `${mime_type}-${just_codec}-${color_info}-${audio_track_id}-${drc}`;
    if (!group_info.has(group_id)) {
      group_info.set(group_id, []);
    }
    (_c = group_info.get(group_id)) == null ? void 0 : _c.push(format);
  }
  return {
    groups: Array.from(group_info.values()),
    has_multiple_audio_tracks
  };
}
__name(getFormatGroupings, "getFormatGroupings");
function hoistCodecsIfPossible(formats, hoisted) {
  if (formats.length > 1 && new Set(formats.map((format) => getStringBetweenStrings(format.mime_type, 'codecs="', '"'))).size === 1) {
    hoisted.push("codecs");
    return getStringBetweenStrings(formats[0].mime_type, 'codecs="', '"');
  }
}
__name(hoistCodecsIfPossible, "hoistCodecsIfPossible");
function hoistNumberAttributeIfPossible(formats, property, hoisted) {
  if (formats.length > 1 && new Set(formats.map((format) => format.fps)).size === 1) {
    hoisted.push(property);
    return Number(formats[0][property]);
  }
}
__name(hoistNumberAttributeIfPossible, "hoistNumberAttributeIfPossible");
function hoistAudioChannelsIfPossible(formats, hoisted) {
  if (formats.length > 1 && new Set(formats.map((format) => format.audio_channels || 2)).size === 1) {
    hoisted.push("AudioChannelConfiguration");
    return formats[0].audio_channels;
  }
}
__name(hoistAudioChannelsIfPossible, "hoistAudioChannelsIfPossible");
async function getOTFSegmentTemplate(url, actions) {
  var _a;
  const response = await actions.session.http.fetch_function(`${url}&rn=0&sq=0`, {
    method: "GET",
    headers: STREAM_HEADERS,
    redirect: "follow"
  });
  const resolved_url = response.url.replace("&rn=0", "").replace("&sq=0", "");
  const response_text = await response.text();
  const segment_duration_strings = (_a = getStringBetweenStrings(response_text, "Segment-Durations-Ms:", "\r\n")) == null ? void 0 : _a.split(",");
  if (!segment_duration_strings) {
    throw new InnertubeError("Failed to extract the segment durations from this OTF stream", { url });
  }
  const segment_durations = [];
  for (const segment_duration_string of segment_duration_strings) {
    const trimmed_segment_duration = segment_duration_string.trim();
    if (trimmed_segment_duration.length === 0) {
      continue;
    }
    let repeat_count;
    const repeat_count_string = getStringBetweenStrings(trimmed_segment_duration, "(r=", ")");
    if (repeat_count_string) {
      repeat_count = parseInt(repeat_count_string);
    }
    segment_durations.push({
      duration: parseInt(trimmed_segment_duration),
      repeat_count
    });
  }
  return {
    init_url: `${resolved_url}&sq=0`,
    media_url: `${resolved_url}&sq=$Number$`,
    timeline: segment_durations
  };
}
__name(getOTFSegmentTemplate, "getOTFSegmentTemplate");
async function getPostLiveDvrInfo(transformed_url, actions) {
  const response = await actions.session.http.fetch_function(`${transformed_url}&rn=0&sq=0`, {
    method: "HEAD",
    headers: STREAM_HEADERS,
    redirect: "follow"
  });
  const duration_ms = parseInt(response.headers.get("X-Head-Time-Millis") || "");
  const segment_count = parseInt(response.headers.get("X-Head-Seqnum") || "");
  if (isNaN(duration_ms) || isNaN(segment_count)) {
    throw new InnertubeError("Failed to extract the duration or segment count for this Post Live DVR video");
  }
  return {
    duration: duration_ms / 1e3,
    segment_count
  };
}
__name(getPostLiveDvrInfo, "getPostLiveDvrInfo");
async function getPostLiveDvrDuration(shared_post_live_dvr_info, format, url_transformer, actions, player, cpn) {
  if (!shared_post_live_dvr_info.item) {
    const url = new URL(await format.decipher(player));
    url.searchParams.set("cpn", cpn || "");
    const transformed_url = url_transformer(url).toString();
    shared_post_live_dvr_info.item = await getPostLiveDvrInfo(transformed_url, actions);
  }
  return shared_post_live_dvr_info.item.duration;
}
__name(getPostLiveDvrDuration, "getPostLiveDvrDuration");
async function getSegmentInfo(format, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr) {
  let transformed_url = "";
  if (is_sabr) {
    const formatKey = `${format.itag || ""}:${format.xtags || ""}`;
    transformed_url = `sabr://${format.has_video ? "video" : "audio"}?key=${formatKey}`;
  } else {
    const url = new URL(await format.decipher(player));
    url.searchParams.set("cpn", cpn || "");
    transformed_url = url_transformer(url).toString();
  }
  if (format.is_type_otf) {
    if (!actions)
      throw new InnertubeError("Unable to get segment durations for this OTF stream without an Actions instance", { format });
    const info3 = {
      is_oft: true,
      is_post_live_dvr: false,
      getSegmentTemplate() {
        return getOTFSegmentTemplate(transformed_url, actions);
      }
    };
    return info3;
  }
  if (shared_post_live_dvr_info) {
    if (!actions) {
      throw new InnertubeError("Unable to get segment count for this Post Live DVR video without an Actions instance", { format });
    }
    const target_duration_dec = format.target_duration_dec;
    if (typeof target_duration_dec !== "number") {
      throw new InnertubeError("Format is missing target_duration_dec", { format });
    }
    const info3 = {
      is_oft: false,
      is_post_live_dvr: true,
      async getSegmentTemplate() {
        if (!shared_post_live_dvr_info.item) {
          shared_post_live_dvr_info.item = await getPostLiveDvrInfo(transformed_url, actions);
        }
        return {
          media_url: `${transformed_url}&sq=$Number$`,
          timeline: [
            {
              duration: target_duration_dec * 1e3,
              repeat_count: shared_post_live_dvr_info.item.segment_count
            }
          ]
        };
      }
    };
    return info3;
  }
  if (!format.index_range || !format.init_range)
    throw new InnertubeError("Index and init ranges not available", { format });
  const info2 = {
    is_oft: false,
    is_post_live_dvr: false,
    base_url: transformed_url,
    index_range: format.index_range,
    init_range: format.init_range
  };
  return info2;
}
__name(getSegmentInfo, "getSegmentInfo");
async function getAudioRepresentation(format, hoisted, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr) {
  const uid_parts = [format.itag.toString()];
  if (format.audio_track) {
    uid_parts.push(format.audio_track.id);
  }
  if (format.is_drc) {
    uid_parts.push("drc");
  }
  const rep = {
    uid: uid_parts.join("-"),
    bitrate: format.bitrate,
    codecs: !hoisted.includes("codecs") ? getStringBetweenStrings(format.mime_type, 'codecs="', '"') : void 0,
    audio_sample_rate: !hoisted.includes("audio_sample_rate") ? format.audio_sample_rate : void 0,
    channels: !hoisted.includes("AudioChannelConfiguration") ? format.audio_channels || 2 : void 0,
    segment_info: await getSegmentInfo(format, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr)
  };
  return rep;
}
__name(getAudioRepresentation, "getAudioRepresentation");
function getTrackRoles(format, has_drc_streams) {
  if (!format.audio_track && !has_drc_streams) {
    return;
  }
  const roles = [
    format.is_original ? "main" : "alternate"
  ];
  if (format.is_dubbed || format.is_auto_dubbed)
    roles.push("dub");
  if (format.is_descriptive)
    roles.push("description");
  if (format.is_drc)
    roles.push("enhanced-audio-intelligibility");
  return roles;
}
__name(getTrackRoles, "getTrackRoles");
async function getAudioSet(formats, url_transformer, actions, player, cpn, shared_post_live_dvr_info, drc_labels, is_sabr) {
  var _a;
  const first_format = formats[0];
  const { audio_track } = first_format;
  const hoisted = [];
  const has_drc_streams = !!drc_labels;
  let track_name;
  if (audio_track) {
    if (has_drc_streams && first_format.is_drc) {
      track_name = drc_labels.label_drc_multiple(audio_track.display_name);
    } else {
      track_name = audio_track.display_name;
    }
  } else if (has_drc_streams) {
    track_name = first_format.is_drc ? drc_labels.label_drc : drc_labels.label_original;
  }
  const set = {
    mime_type: first_format.mime_type.split(";")[0],
    language: (_a = first_format.language) != null ? _a : void 0,
    codecs: hoistCodecsIfPossible(formats, hoisted),
    audio_sample_rate: hoistNumberAttributeIfPossible(formats, "audio_sample_rate", hoisted),
    track_name,
    track_roles: getTrackRoles(first_format, has_drc_streams),
    channels: hoistAudioChannelsIfPossible(formats, hoisted),
    drm_families: first_format.drm_families,
    drm_track_type: first_format.drm_track_type,
    representations: await Promise.all(formats.map((format) => getAudioRepresentation(format, hoisted, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr)))
  };
  return set;
}
__name(getAudioSet, "getAudioSet");
var COLOR_PRIMARIES = {
  BT709: "1",
  BT2020: "9"
};
var COLOR_TRANSFER_CHARACTERISTICS = {
  BT709: "1",
  BT2020_10: "14",
  SMPTEST2084: "16",
  ARIB_STD_B67: "18"
};
var COLOR_MATRIX_COEFFICIENTS = {
  BT709: "1",
  BT2020_NCL: "14"
};
function getColorInfo(format) {
  var _a;
  const color_info = format.color_info;
  let primaries;
  let transfer_characteristics;
  let matrix_coefficients;
  if (color_info) {
    if (color_info.primaries) {
      primaries = COLOR_PRIMARIES[color_info.primaries];
    }
    if (color_info.transfer_characteristics) {
      transfer_characteristics = COLOR_TRANSFER_CHARACTERISTICS[color_info.transfer_characteristics];
    }
    if (color_info.matrix_coefficients) {
      matrix_coefficients = COLOR_MATRIX_COEFFICIENTS[color_info.matrix_coefficients];
      if (!matrix_coefficients) {
        const url = new URL(format.url);
        const anonymisedFormat = JSON.parse(JSON.stringify(format));
        anonymisedFormat.url = "REDACTED";
        anonymisedFormat.signature_cipher = "REDACTED";
        anonymisedFormat.cipher = "REDACTED";
        warn(TAG_, `Unknown matrix coefficients "${color_info.matrix_coefficients}". The DASH manifest is still usable without this.
Please report it at ${package_default.bugs.url} so we can add support for it.
InnerTube client: ${url.searchParams.get("c")}
format:`, anonymisedFormat);
      }
    }
  } else if ((_a = getStringBetweenStrings(format.mime_type, 'codecs="', '"')) == null ? void 0 : _a.startsWith("avc1")) {
    transfer_characteristics = COLOR_TRANSFER_CHARACTERISTICS.BT709;
  }
  const info2 = {
    primaries,
    transfer_characteristics,
    matrix_coefficients
  };
  return info2;
}
__name(getColorInfo, "getColorInfo");
async function getVideoRepresentation(format, url_transformer, hoisted, player, actions, cpn, shared_post_live_dvr_info, is_sabr) {
  const rep = {
    uid: format.itag.toString(),
    bitrate: format.bitrate,
    width: format.width,
    height: format.height,
    codecs: !hoisted.includes("codecs") ? getStringBetweenStrings(format.mime_type, 'codecs="', '"') : void 0,
    fps: !hoisted.includes("fps") ? format.fps : void 0,
    segment_info: await getSegmentInfo(format, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr)
  };
  return rep;
}
__name(getVideoRepresentation, "getVideoRepresentation");
async function getVideoSet(formats, url_transformer, player, actions, cpn, shared_post_live_dvr_info, is_sabr) {
  const first_format = formats[0];
  const color_info = getColorInfo(first_format);
  const hoisted = [];
  const set = {
    mime_type: first_format.mime_type.split(";")[0],
    color_info,
    codecs: hoistCodecsIfPossible(formats, hoisted),
    fps: hoistNumberAttributeIfPossible(formats, "fps", hoisted),
    drm_families: first_format.drm_families,
    drm_track_type: first_format.drm_track_type,
    representations: await Promise.all(formats.map((format) => getVideoRepresentation(format, url_transformer, hoisted, player, actions, cpn, shared_post_live_dvr_info, is_sabr)))
  };
  return set;
}
__name(getVideoSet, "getVideoSet");
function getStoryboardInfo(storyboards) {
  var _a;
  const mime_info = /* @__PURE__ */ new Map();
  const boards = storyboards.is(PlayerStoryboardSpec) ? storyboards.boards : [storyboards.board];
  for (const storyboard of boards) {
    const extension = new URL(storyboard.template_url).pathname.split(".").pop();
    const mime_type = `image/${extension === "jpg" ? "jpeg" : extension}`;
    if (!mime_info.has(mime_type)) {
      mime_info.set(mime_type, []);
    }
    (_a = mime_info.get(mime_type)) == null ? void 0 : _a.push(storyboard);
  }
  return mime_info;
}
__name(getStoryboardInfo, "getStoryboardInfo");
async function getStoryboardMimeType(actions, board, transform_url, probable_mime_type, shared_response) {
  const url = board.template_url;
  const req_url = transform_url(new URL(url.replace("$M", "0")));
  const res_promise = shared_response.response ? shared_response.response : actions.session.http.fetch_function(req_url, {
    method: "HEAD",
    headers: STREAM_HEADERS
  });
  shared_response.response = res_promise;
  const res = await res_promise;
  return res.headers.get("Content-Type") || probable_mime_type;
}
__name(getStoryboardMimeType, "getStoryboardMimeType");
async function getStoryboardBitrate(actions, board, shared_response) {
  const url = board.template_url;
  const response_promises = [];
  const request_limit = Math.min(board.type === "vod" ? board.storyboard_count : 5, 10);
  for (let i = 0; i < request_limit; i++) {
    const req_url = new URL(url.replace("$M", i.toString()));
    const response_promise = i === 0 && shared_response.response ? shared_response.response : actions.session.http.fetch_function(req_url, {
      method: "HEAD",
      headers: STREAM_HEADERS
    });
    if (i === 0)
      shared_response.response = response_promise;
    response_promises.push(response_promise);
  }
  const responses = await Promise.all(response_promises);
  const content_lengths = [];
  for (const response of responses) {
    content_lengths.push(parseInt(response.headers.get("Content-Length") || "0"));
  }
  return Math.ceil(Math.max(...content_lengths) / (board.rows * board.columns) * 8);
}
__name(getStoryboardBitrate, "getStoryboardBitrate");
function getImageRepresentation(duration, actions, board, transform_url, shared_response) {
  const url = board.template_url;
  const template_url = new URL(url.replace("$M", "$Number$"));
  let template_duration;
  if (board.type === "vod") {
    template_duration = duration / board.storyboard_count;
  } else {
    template_duration = duration * board.columns * board.rows;
  }
  const rep = {
    uid: `thumbnails_${board.thumbnail_width}x${board.thumbnail_height}`,
    getBitrate() {
      return getStoryboardBitrate(actions, board, shared_response);
    },
    sheet_width: board.thumbnail_width * board.columns,
    sheet_height: board.thumbnail_height * board.rows,
    thumbnail_height: board.thumbnail_height,
    thumbnail_width: board.thumbnail_width,
    rows: board.rows,
    columns: board.columns,
    template_duration: Math.round(template_duration),
    template_url: transform_url(template_url).toString(),
    getURL(n) {
      return template_url.toString().replace("$Number$", n.toString());
    }
  };
  return rep;
}
__name(getImageRepresentation, "getImageRepresentation");
function getImageSets(duration, actions, storyboards, transform_url) {
  const mime_info = getStoryboardInfo(storyboards);
  const shared_response = {};
  return Array.from(mime_info.entries()).map(([type, boards]) => ({
    probable_mime_type: type,
    getMimeType() {
      return getStoryboardMimeType(actions, boards[0], transform_url, type, shared_response);
    },
    representations: boards.map((board) => getImageRepresentation(duration, actions, board, transform_url, shared_response))
  }));
}
__name(getImageSets, "getImageSets");
function getTextSets(caption_tracks, format, transform_url) {
  const mime_type = format === "vtt" ? "text/vtt" : "application/ttml+xml";
  return caption_tracks.map((caption_track) => {
    const url = new URL(caption_track.base_url);
    url.searchParams.set("fmt", format);
    const track_roles = ["caption"];
    if (url.searchParams.has("tlang")) {
      track_roles.push("dub");
    }
    return {
      mime_type,
      language: caption_track.language_code,
      track_name: caption_track.name.toString(),
      track_roles,
      representation: {
        uid: `text-${caption_track.vss_id}`,
        base_url: transform_url(url).toString()
      }
    };
  });
}
__name(getTextSets, "getTextSets");
async function getStreamingInfo(streaming_data, is_post_live_dvr = false, url_transformer = (url) => url, format_filter, cpn, player, actions, storyboards, caption_tracks, options) {
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available");
  const formats = format_filter ? streaming_data.adaptive_formats.filter((fmt) => !format_filter(fmt)) : streaming_data.adaptive_formats;
  let getDuration;
  let shared_post_live_dvr_info;
  if (is_post_live_dvr) {
    shared_post_live_dvr_info = {};
    if (!actions) {
      throw new InnertubeError("Unable to get duration or segment count for this Post Live DVR video without an Actions instance");
    }
    getDuration = /* @__PURE__ */ __name(() => {
      if (!shared_post_live_dvr_info) {
        return Promise.resolve(0);
      }
      return getPostLiveDvrDuration(shared_post_live_dvr_info, formats[0], url_transformer, actions, player, cpn);
    }, "getDuration");
  } else {
    const duration = formats[0].approx_duration_ms / 1e3;
    getDuration = /* @__PURE__ */ __name(() => Promise.resolve(duration), "getDuration");
  }
  const { groups, has_multiple_audio_tracks } = getFormatGroupings(formats, is_post_live_dvr);
  const { video_groups, audio_groups } = groups.reduce((acc, formats2) => {
    if (formats2[0].has_audio) {
      if (has_multiple_audio_tracks && !formats2[0].audio_track)
        return acc;
      acc.audio_groups.push(formats2);
      return acc;
    }
    acc.video_groups.push(formats2);
    return acc;
  }, {
    video_groups: [],
    audio_groups: []
  });
  let drc_labels;
  if (audio_groups.flat().some((format) => format.is_drc)) {
    drc_labels = {
      label_original: (options == null ? void 0 : options.label_original) || "Original",
      label_drc: (options == null ? void 0 : options.label_drc) || "Stable Volume",
      label_drc_multiple: (options == null ? void 0 : options.label_drc_multiple) || ((display_name) => `${display_name} (Stable Volume)`)
    };
  }
  const audio_sets = await Promise.all(audio_groups.map((formats2) => getAudioSet(formats2, url_transformer, actions, player, cpn, shared_post_live_dvr_info, drc_labels, options == null ? void 0 : options.is_sabr)));
  const video_sets = await Promise.all(video_groups.map((formats2) => getVideoSet(formats2, url_transformer, player, actions, cpn, shared_post_live_dvr_info, options == null ? void 0 : options.is_sabr)));
  let image_sets = [];
  if (storyboards && actions) {
    let duration;
    if (storyboards.is(PlayerStoryboardSpec)) {
      duration = formats[0].approx_duration_ms / 1e3;
    } else {
      const target_duration_dec = formats[0].target_duration_dec;
      if (target_duration_dec === void 0)
        throw new InnertubeError("Format is missing target_duration_dec", { format: formats[0] });
      duration = target_duration_dec;
    }
    image_sets = getImageSets(duration, actions, storyboards, url_transformer);
  }
  let text_sets = [];
  if (caption_tracks && (options == null ? void 0 : options.captions_format)) {
    if (options.captions_format !== "vtt" && options.captions_format !== "ttml") {
      throw new InnertubeError("Invalid captions format", options.captions_format);
    }
    text_sets = getTextSets(caption_tracks, options.captions_format, url_transformer);
  }
  const info2 = {
    getDuration,
    audio_sets,
    video_sets,
    image_sets,
    text_sets
  };
  return info2;
}
__name(getStreamingInfo, "getStreamingInfo");

// dist/src/utils/DashManifest.js
async function OTFPostLiveDvrSegmentInfo({ info: info2 }) {
  if (!info2.is_oft && !info2.is_post_live_dvr)
    return null;
  const template = await info2.getSegmentTemplate();
  return createElement(
    "segmentTemplate",
    { startNumber: template.init_url ? "1" : "0", timescale: "1000", initialization: template.init_url, media: template.media_url },
    createElement("segmentTimeline", null, template.timeline.map((segment_duration) => createElement("s", { d: segment_duration.duration, r: segment_duration.repeat_count })))
  );
}
__name(OTFPostLiveDvrSegmentInfo, "OTFPostLiveDvrSegmentInfo");
function SegmentInfo({ info: info2 }) {
  if (info2.is_oft || info2.is_post_live_dvr) {
    return createElement(OTFPostLiveDvrSegmentInfo, { info: info2 });
  }
  return createElement(
    Fragment,
    null,
    createElement("baseURL", null, info2.base_url),
    createElement(
      "segmentBase",
      { indexRange: `${info2.index_range.start}-${info2.index_range.end}` },
      createElement("initialization", { range: `${info2.init_range.start}-${info2.init_range.end}` })
    )
  );
}
__name(SegmentInfo, "SegmentInfo");
function getDrmSystemId(drm_family) {
  switch (drm_family) {
    case "WIDEVINE":
      return "edef8ba9-79d6-4ace-a3c8-27dcd51d21ed";
    case "PLAYREADY":
      return "9a04f079-9840-4286-ab92-e65be0885f95";
    default:
      return null;
  }
}
__name(getDrmSystemId, "getDrmSystemId");
async function DashManifest({ streamingData, isPostLiveDvr, transformURL, rejectFormat, cpn, player, actions, storyboards, captionTracks, options }) {
  const { getDuration, audio_sets, video_sets, image_sets, text_sets } = await getStreamingInfo(streamingData, isPostLiveDvr, transformURL, rejectFormat, cpn, player, actions, storyboards, captionTracks, options);
  return createElement(
    "mPD",
    { xmlns: "urn:mpeg:dash:schema:mpd:2011", minBufferTime: "PT1.500S", profiles: "urn:mpeg:dash:profile:isoff-main:2011", type: "static", mediaPresentationDuration: `PT${await getDuration()}S`, "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation": "urn:mpeg:dash:schema:mpd:2011 http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-DASH_schema_files/DASH-MPD.xsd" },
    createElement(
      "period",
      null,
      audio_sets.map((set, index) => createElement(
        "adaptationSet",
        { id: index, mimeType: set.mime_type, startWithSAP: "1", subsegmentAlignment: "true", lang: set.language, codecs: set.codecs, audioSamplingRate: set.audio_sample_rate, contentType: "audio" },
        set.drm_families && set.drm_families.map((drm_family) => createElement("contentProtection", { schemeIdUri: `urn:uuid:${getDrmSystemId(drm_family)}` })),
        set.track_roles && set.track_roles.map((role) => createElement("role", { schemeIdUri: "urn:mpeg:dash:role:2011", value: role })),
        set.track_name && createElement("label", { id: index }, set.track_name),
        set.channels && createElement("audioChannelConfiguration", { schemeIdUri: "urn:mpeg:dash:23003:3:audio_channel_configuration:2011", value: set.channels }),
        set.representations.map((rep) => createElement(
          "representation",
          { id: rep.uid, bandwidth: rep.bitrate, codecs: rep.codecs, audioSamplingRate: rep.audio_sample_rate },
          rep.channels && createElement("audioChannelConfiguration", { schemeIdUri: "urn:mpeg:dash:23003:3:audio_channel_configuration:2011", value: rep.channels }),
          createElement(SegmentInfo, { info: rep.segment_info })
        ))
      )),
      video_sets.map((set, index) => createElement(
        "adaptationSet",
        { id: index + audio_sets.length, mimeType: set.mime_type, startWithSAP: "1", subsegmentAlignment: "true", codecs: set.codecs, maxPlayoutRate: "1", frameRate: set.fps, contentType: "video" },
        set.drm_families && set.drm_families.map((drm_family) => createElement("contentProtection", { schemeIdUri: `urn:uuid:${getDrmSystemId(drm_family)}` })),
        set.color_info.primaries && createElement("supplementalProperty", { schemeIdUri: "urn:mpeg:mpegB:cicp:ColourPrimaries", value: set.color_info.primaries }),
        set.color_info.transfer_characteristics && createElement("supplementalProperty", { schemeIdUri: "urn:mpeg:mpegB:cicp:TransferCharacteristics", value: set.color_info.transfer_characteristics }),
        set.color_info.matrix_coefficients && createElement("supplementalProperty", { schemeIdUri: "urn:mpeg:mpegB:cicp:MatrixCoefficients", value: set.color_info.matrix_coefficients }),
        set.representations.map((rep) => createElement(
          "representation",
          { id: rep.uid, bandwidth: rep.bitrate, width: rep.width, height: rep.height, codecs: rep.codecs, frameRate: rep.fps },
          createElement(SegmentInfo, { info: rep.segment_info })
        ))
      )),
      image_sets.map(async (set, index) => {
        return createElement("adaptationSet", { id: index + audio_sets.length + video_sets.length, mimeType: await set.getMimeType(), contentType: "image" }, set.representations.map(async (rep) => createElement(
          "representation",
          { id: `thumbnails_${rep.thumbnail_width}x${rep.thumbnail_height}`, bandwidth: await rep.getBitrate(), width: rep.sheet_width, height: rep.sheet_height },
          createElement("essentialProperty", { schemeIdUri: "http://dashif.org/thumbnail_tile", value: `${rep.columns}x${rep.rows}` }),
          createElement("segmentTemplate", { media: rep.template_url, duration: rep.template_duration, startNumber: "0" })
        )));
      }),
      text_sets.map((set, index) => {
        return createElement(
          "adaptationSet",
          { id: index + audio_sets.length + video_sets.length + image_sets.length, mimeType: set.mime_type, lang: set.language, contentType: "text" },
          set.track_roles.map((role) => createElement("role", { schemeIdUri: "urn:mpeg:dash:role:2011", value: role })),
          createElement("label", { id: index + audio_sets.length }, set.track_name),
          createElement(
            "representation",
            { id: set.representation.uid, bandwidth: "0" },
            createElement("baseURL", null, set.representation.base_url)
          )
        );
      })
    )
  );
}
__name(DashManifest, "DashManifest");
function toDash(streaming_data, is_post_live_dvr = false, url_transformer = (url) => url, format_filter, cpn, player, actions, storyboards, caption_tracks, options) {
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available");
  return renderToString(createElement(DashManifest, { streamingData: streaming_data, isPostLiveDvr: is_post_live_dvr, transformURL: url_transformer, options, rejectFormat: format_filter, cpn, player, actions, storyboards, captionTracks: caption_tracks }));
}
__name(toDash, "toDash");

// dist/src/utils/FormatUtils.js
async function download(options, actions, playability_status, streaming_data, player, cpn) {
  if ((playability_status == null ? void 0 : playability_status.status) === "UNPLAYABLE")
    throw new InnertubeError("Video is unplayable", { error_type: "UNPLAYABLE" });
  if ((playability_status == null ? void 0 : playability_status.status) === "LOGIN_REQUIRED")
    throw new InnertubeError("Video is login required", { error_type: "LOGIN_REQUIRED" });
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available.", { error_type: "NO_STREAMING_DATA" });
  const opts = {
    quality: "360p",
    type: "video+audio",
    format: "mp4",
    range: void 0,
    ...options
  };
  const format = chooseFormat(opts, streaming_data);
  const format_url = await format.decipher(player);
  if (opts.type === "video+audio" && !options.range) {
    const response = await actions.session.http.fetch_function(`${format_url}&cpn=${cpn}`, {
      method: "GET",
      headers: STREAM_HEADERS,
      redirect: "follow"
    });
    if (!response.ok)
      throw new InnertubeError("The server responded with a non 2xx status code", { error_type: "FETCH_FAILED", response });
    const body = response.body;
    if (!body)
      throw new InnertubeError("Could not get ReadableStream from fetch Response.", { error_type: "FETCH_FAILED", response });
    return body;
  }
  const chunk_size = 1048576 * 10;
  let chunk_start = options.range ? options.range.start : 0;
  let chunk_end = options.range ? options.range.end : chunk_size;
  let must_end = false;
  let cancel;
  return new Platform.shim.ReadableStream({
    start() {
    },
    pull: /* @__PURE__ */ __name(async (controller) => {
      if (must_end) {
        controller.close();
        return;
      }
      if (chunk_end >= (format.content_length ? format.content_length : 0) || options.range) {
        must_end = true;
      }
      return new Promise(async (resolve, reject) => {
        try {
          cancel = new AbortController();
          const response = await actions.session.http.fetch_function(`${format_url}&cpn=${cpn}&range=${chunk_start}-${chunk_end || ""}`, {
            method: "GET",
            headers: {
              ...STREAM_HEADERS
              // XXX: use YouTube's range parameter instead of a Range header.
              // Range: `bytes=${chunk_start}-${chunk_end}`
            },
            signal: cancel.signal
          });
          if (!response.ok)
            throw new InnertubeError("The server responded with a non 2xx status code", {
              error_type: "FETCH_FAILED",
              response
            });
          const body = response.body;
          if (!body)
            throw new InnertubeError("Could not get ReadableStream from fetch Response.", {
              error_type: "FETCH_FAILED",
              response
            });
          for await (const chunk of streamToIterable(body)) {
            controller.enqueue(chunk);
          }
          chunk_start = chunk_end + 1;
          chunk_end += chunk_size;
          resolve();
        } catch (e) {
          reject(e);
        }
      });
    }, "pull"),
    async cancel(reason) {
      cancel.abort(reason);
    }
  }, {
    highWaterMark: 1,
    // TODO: better value?
    size(chunk) {
      return chunk.byteLength;
    }
  });
}
__name(download, "download");
function chooseFormat(options, streaming_data) {
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available");
  const formats = [
    ...streaming_data.formats || [],
    ...streaming_data.adaptive_formats || []
  ];
  if (options.itag) {
    const candidates2 = formats.filter((format) => format.itag === options.itag);
    if (!candidates2.length)
      throw new InnertubeError("No matching formats found", { options });
    return candidates2[0];
  }
  const requires_audio = options.type ? options.type.includes("audio") : true;
  const requires_video = options.type ? options.type.includes("video") : true;
  const language = options.language || "original";
  const quality = options.quality || "best";
  let best_width = -1;
  const is_best = ["best", "bestefficiency"].includes(quality);
  const use_most_efficient = quality !== "best";
  let candidates = formats.filter((format) => {
    if (requires_audio && !format.has_audio)
      return false;
    if (requires_video && !format.has_video)
      return false;
    if (options.codec && !format.mime_type.includes(options.codec))
      return false;
    if (options.format !== "any" && !format.mime_type.includes(options.format || "mp4"))
      return false;
    if (!is_best && format.quality_label !== quality)
      return false;
    if (format.width && best_width < format.width)
      best_width = format.width;
    return true;
  });
  if (!candidates.length)
    throw new InnertubeError("No matching formats found", { options });
  if (is_best && requires_video)
    candidates = candidates.filter((format) => format.width === best_width);
  if (requires_audio && !requires_video) {
    const audio_only = candidates.filter((format) => {
      if (language !== "original") {
        return !format.has_video && !format.has_text && format.language === language;
      }
      return !format.has_video && !format.has_text && format.is_original;
    });
    if (audio_only.length > 0) {
      candidates = audio_only;
    }
  }
  if (use_most_efficient) {
    candidates.sort((a, b) => a.bitrate - b.bitrate);
  } else {
    candidates.sort((a, b) => b.bitrate - a.bitrate);
  }
  return candidates[0];
}
__name(chooseFormat, "chooseFormat");

// dist/src/utils/HTTPClient.js
var _session, _cookie, _fetch, _HTTPClient_instances, processJsonPayload_fn, setupCommonHeaders_fn, adjustContext_fn;
var _HTTPClient = class _HTTPClient {
  constructor(session, cookie, fetch) {
    __privateAdd(this, _HTTPClient_instances);
    __privateAdd(this, _session);
    __privateAdd(this, _cookie);
    __privateAdd(this, _fetch);
    __privateSet(this, _session, session);
    __privateSet(this, _cookie, cookie);
    __privateSet(this, _fetch, fetch || Platform.shim.fetch);
  }
  get fetch_function() {
    return __privateGet(this, _fetch);
  }
  async fetch(input, init) {
    const session = __privateGet(this, _session);
    const innertube_url = URLS.API.PRODUCTION_1 + session.api_version;
    const baseURL = (init == null ? void 0 : init.baseURL) || innertube_url;
    const request_url = typeof input === "string" ? new URL(`${baseURL}${baseURL.endsWith("/") || input.startsWith("/") ? "" : "/"}${input}`) : input instanceof URL ? input : new URL(input.url, baseURL);
    const headers = (init == null ? void 0 : init.headers) || (input instanceof Platform.shim.Request ? input.headers : new Platform.shim.Headers()) || new Platform.shim.Headers();
    const body = (init == null ? void 0 : init.body) || (input instanceof Platform.shim.Request ? input.body : void 0);
    const request_headers = new Platform.shim.Headers(headers);
    __privateMethod(this, _HTTPClient_instances, setupCommonHeaders_fn).call(this, request_headers, session, request_url);
    request_url.searchParams.set("prettyPrint", "false");
    request_url.searchParams.set("alt", "json");
    const content_type = request_headers.get("Content-Type");
    let request_body = body;
    let is_web_kids = false;
    const is_innertube_req = baseURL === innertube_url || baseURL === URLS.YT_UPLOAD;
    if (content_type === "application/json" && is_innertube_req && typeof body === "string") {
      const { newBody, isWebKids: processedIsWebKids, clientVersion: processedClientVersion, clientNameId: processedClientNameId, adjustedClientName } = __privateMethod(this, _HTTPClient_instances, processJsonPayload_fn).call(this, body, session);
      request_body = newBody;
      is_web_kids = processedIsWebKids;
      if (processedClientVersion) {
        request_headers.set("X-Youtube-Client-Version", processedClientVersion);
      }
      if (processedClientNameId) {
        request_headers.set("X-Youtube-Client-Name", processedClientNameId);
      }
      if (adjustedClientName === CLIENTS.ANDROID.NAME || adjustedClientName === CLIENTS.YTMUSIC_ANDROID.NAME) {
        request_headers.set("User-Agent", CLIENTS.ANDROID.USER_AGENT);
        request_headers.set("X-GOOG-API-FORMAT-VERSION", "2");
      } else if (adjustedClientName === CLIENTS.IOS.NAME) {
        request_headers.set("User-Agent", CLIENTS.IOS.USER_AGENT);
      }
    } else if (content_type === "application/x-protobuf") {
      if (Platform.shim.server) {
        request_headers.set("User-Agent", CLIENTS.ANDROID.USER_AGENT);
        request_headers.set("X-GOOG-API-FORMAT-VERSION", "2");
        request_headers.delete("X-Youtube-Client-Version");
      }
    }
    if (session.logged_in && is_innertube_req && !is_web_kids) {
      const oauth = session.oauth;
      if (oauth.oauth2_tokens) {
        if (oauth.shouldRefreshToken()) {
          await oauth.refreshAccessToken();
        }
        request_headers.set("Authorization", `Bearer ${oauth.oauth2_tokens.access_token}`);
      }
      const cookie = __privateGet(this, _cookie);
      if (cookie) {
        const sapisid = getCookie(cookie, "SAPISID");
        if (sapisid) {
          request_headers.set("Authorization", await generateSidAuth(sapisid));
          request_headers.set("X-Goog-Authuser", session.account_index.toString());
          if (session.context.user.onBehalfOfUser)
            request_headers.set("X-Goog-PageId", session.context.user.onBehalfOfUser);
        }
        request_headers.set("Cookie", cookie);
      }
    }
    const request = new Platform.shim.Request(request_url, input instanceof Platform.shim.Request ? input : init);
    const response = await __privateGet(this, _fetch).call(this, request, {
      body: request_body,
      headers: request_headers,
      redirect: input instanceof Platform.shim.Request ? input.redirect : (init == null ? void 0 : init.redirect) || "follow",
      ...Platform.shim.runtime !== "cf-worker" ? { credentials: "include" } : {}
    });
    if (response.ok) {
      return response;
    }
    throw new InnertubeError(`Request to ${response.url} failed with status code ${response.status}`, await response.text());
  }
};
_session = new WeakMap();
_cookie = new WeakMap();
_fetch = new WeakMap();
_HTTPClient_instances = new WeakSet();
processJsonPayload_fn = /* @__PURE__ */ __name(function(json_body, session) {
  const parsed_payload = JSON.parse(json_body);
  const adjusted_context = JSON.parse(JSON.stringify(session.context));
  __privateMethod(this, _HTTPClient_instances, adjustContext_fn).call(this, adjusted_context, parsed_payload.client);
  const new_payload = {
    ...parsed_payload,
    context: adjusted_context
  };
  const clientVersion = new_payload.context.client.clientVersion;
  const clientNameFromAdjustedContext = new_payload.context.client.clientName;
  const clientNameId = CLIENT_NAME_IDS[clientNameFromAdjustedContext];
  delete new_payload.client;
  const isWebKids = new_payload.context.client.clientName === CLIENTS.WEB_KIDS.NAME;
  return {
    newBody: JSON.stringify(new_payload),
    isWebKids,
    clientVersion,
    clientNameId,
    adjustedClientName: new_payload.context.client.clientName
  };
}, "#processJsonPayload");
setupCommonHeaders_fn = /* @__PURE__ */ __name(function(request_headers, session, request_url) {
  request_headers.set("Accept", "*/*");
  request_headers.set("Accept-Language", "*");
  request_headers.set("X-Goog-Visitor-Id", session.context.client.visitorData || "");
  request_headers.set("X-Youtube-Client-Version", session.context.client.clientVersion || "");
  const client_name_id = CLIENT_NAME_IDS[session.context.client.clientName];
  if (client_name_id) {
    request_headers.set("X-Youtube-Client-Name", client_name_id);
  }
  if (Platform.shim.server) {
    request_headers.set("User-Agent", session.user_agent || "");
    request_headers.set("Origin", request_url.origin);
  }
}, "#setupCommonHeaders");
adjustContext_fn = /* @__PURE__ */ __name(function(ctx, client) {
  if (!client)
    return;
  const clientName = client.toUpperCase();
  if (!SUPPORTED_CLIENTS.includes(clientName)) {
    throw new InnertubeError(`Invalid client: ${client}`, {
      available_innertube_clients: SUPPORTED_CLIENTS
    });
  }
  if (clientName !== "WEB") {
    delete ctx.client.configInfo;
  }
  if (clientName === "ANDROID" || clientName === "YTMUSIC_ANDROID" || clientName === "YTSTUDIO_ANDROID") {
    ctx.client.androidSdkVersion = CLIENTS.ANDROID.SDK_VERSION;
    ctx.client.userAgent = CLIENTS.ANDROID.USER_AGENT;
    ctx.client.osName = "Android";
    ctx.client.osVersion = "13";
    ctx.client.platform = "MOBILE";
  }
  switch (clientName) {
    case "MWEB":
      ctx.client.clientVersion = CLIENTS.MWEB.VERSION;
      ctx.client.clientName = CLIENTS.MWEB.NAME;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.platform = "MOBILE";
      break;
    case "IOS":
      ctx.client.deviceMake = "Apple";
      ctx.client.deviceModel = CLIENTS.IOS.DEVICE_MODEL;
      ctx.client.clientVersion = CLIENTS.IOS.VERSION;
      ctx.client.clientName = CLIENTS.IOS.NAME;
      ctx.client.platform = "MOBILE";
      ctx.client.osName = CLIENTS.IOS.OS_NAME;
      ctx.client.osVersion = CLIENTS.IOS.OS_VERSION;
      delete ctx.client.browserName;
      delete ctx.client.browserVersion;
      break;
    case "YTMUSIC":
      ctx.client.clientVersion = CLIENTS.YTMUSIC.VERSION;
      ctx.client.clientName = CLIENTS.YTMUSIC.NAME;
      break;
    case "ANDROID":
      ctx.client.clientVersion = CLIENTS.ANDROID.VERSION;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.clientName = CLIENTS.ANDROID.NAME;
      break;
    case "YTMUSIC_ANDROID":
      ctx.client.clientVersion = CLIENTS.YTMUSIC_ANDROID.VERSION;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.clientName = CLIENTS.YTMUSIC_ANDROID.NAME;
      break;
    case "YTSTUDIO_ANDROID":
      ctx.client.clientVersion = CLIENTS.YTSTUDIO_ANDROID.VERSION;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.clientName = CLIENTS.YTSTUDIO_ANDROID.NAME;
      break;
    case "TV":
      ctx.client.clientVersion = CLIENTS.TV.VERSION;
      ctx.client.clientName = CLIENTS.TV.NAME;
      ctx.client.userAgent = CLIENTS.TV.USER_AGENT;
      break;
    case "TV_SIMPLY":
      ctx.client.clientVersion = CLIENTS.TV_SIMPLY.VERSION;
      ctx.client.clientName = CLIENTS.TV_SIMPLY.NAME;
      break;
    case "TV_EMBEDDED":
      ctx.client.clientName = CLIENTS.TV_EMBEDDED.NAME;
      ctx.client.clientVersion = CLIENTS.TV_EMBEDDED.VERSION;
      ctx.client.clientScreen = "EMBED";
      ctx.thirdParty = { embedUrl: URLS.YT_BASE };
      break;
    case "YTKIDS":
      ctx.client.clientVersion = CLIENTS.WEB_KIDS.VERSION;
      ctx.client.clientName = CLIENTS.WEB_KIDS.NAME;
      ctx.client.kidsAppInfo = {
        categorySettings: {
          enabledCategories: [
            "approved_for_you",
            "black_joy",
            "camp",
            "collections",
            "earth",
            "explore",
            "favorites",
            "gaming",
            "halloween",
            "hero",
            "learning",
            "move",
            "music",
            "reading",
            "shared_by_parents",
            "shows",
            "soccer",
            "sports",
            "spotlight",
            "winter"
          ]
        },
        contentSettings: {
          corpusPreference: "KIDS_CORPUS_PREFERENCE_YOUNGER",
          kidsNoSearchMode: "YT_KIDS_NO_SEARCH_MODE_OFF"
        }
      };
      break;
    case "WEB_EMBEDDED":
      ctx.client.clientName = CLIENTS.WEB_EMBEDDED.NAME;
      ctx.client.clientVersion = CLIENTS.WEB_EMBEDDED.VERSION;
      ctx.client.clientScreen = "EMBED";
      ctx.thirdParty = { embedUrl: URLS.GOOGLE_SEARCH_BASE };
      break;
    case "WEB_CREATOR":
      ctx.client.clientName = CLIENTS.WEB_CREATOR.NAME;
      ctx.client.clientVersion = CLIENTS.WEB_CREATOR.VERSION;
      break;
    default:
      break;
  }
}, "#adjustContext");
__name(_HTTPClient, "HTTPClient");
var HTTPClient = _HTTPClient;

// dist/src/utils/LZW.js
var LZW_exports = {};
__export(LZW_exports, {
  compress: () => compress,
  decompress: () => decompress
});
function compress(input) {
  const output = [];
  const dictionary = {};
  for (let i = 0; i < 256; i++) {
    dictionary[String.fromCharCode(i)] = i;
  }
  let current_string = "";
  let dictionary_size = 256;
  for (let i = 0; i < input.length; i++) {
    const current_char = input[i];
    const combined_string = current_string + current_char;
    if (dictionary.hasOwnProperty(combined_string)) {
      current_string = combined_string;
    } else {
      output.push(dictionary[current_string]);
      dictionary[combined_string] = dictionary_size++;
      current_string = current_char;
    }
  }
  if (current_string !== "") {
    output.push(dictionary[current_string]);
  }
  return output.map((code) => String.fromCharCode(code)).join("");
}
__name(compress, "compress");
function decompress(input) {
  const dictionary = {};
  const input_data = input.split("");
  const output = [input_data.shift()];
  const input_length = input_data.length >>> 0;
  let dictionary_code = 256;
  let current_char = output[0];
  let current_string = current_char;
  for (let i = 0; i < input_length; ++i) {
    const current_code = input_data[i].charCodeAt(0);
    const entry = current_code < 256 ? input_data[i] : dictionary[current_code] ? dictionary[current_code] : current_string + current_char;
    output.push(entry);
    current_char = entry.charAt(0);
    dictionary[dictionary_code++] = current_string + current_char;
    current_string = entry;
  }
  return output.join("");
}
__name(decompress, "decompress");

// dist/src/utils/BinarySerializer.js
var BinarySerializer_exports = {};
__export(BinarySerializer_exports, {
  MAGIC_HEADER: () => MAGIC_HEADER,
  VERSION: () => VERSION,
  deserialize: () => deserialize,
  serialize: () => serialize
});
var MAGIC_HEADER = 5849684;
var VERSION = 1;
function serialize(data) {
  const json_str = JSON.stringify(data);
  const compressed = compress(json_str);
  const compressed_bytes = new TextEncoder().encode(compressed);
  const buffer = new ArrayBuffer(12 + compressed_bytes.byteLength);
  const view = new DataView(buffer);
  view.setUint32(0, MAGIC_HEADER, true);
  view.setUint32(4, VERSION, true);
  view.setUint32(8, compressed_bytes.byteLength, true);
  new Uint8Array(buffer).set(compressed_bytes, 12);
  return buffer;
}
__name(serialize, "serialize");
function deserialize(buffer) {
  if (buffer.byteLength < 12)
    throw new Error("Invalid binary format: buffer too short");
  const view = new DataView(buffer.buffer, buffer.byteOffset);
  const magic = view.getUint32(0, true);
  if (magic !== MAGIC_HEADER) {
    throw new Error("Invalid binary format: magic header mismatch");
  }
  const version = view.getUint32(4, true);
  if (version !== VERSION) {
    throw new Error(`Unsupported binary format version: ${version}`);
  }
  const data_length = view.getUint32(8, true);
  const compressed_data = buffer.slice(12, 12 + data_length);
  const compressed = new TextDecoder().decode(compressed_data);
  const json_str = decompress(compressed);
  return JSON.parse(json_str);
}
__name(deserialize, "deserialize");

// dist/src/utils/ProtoUtils.js
var ProtoUtils_exports = {};
__export(ProtoUtils_exports, {
  decodeVisitorData: () => decodeVisitorData,
  encodeCommentActionParams: () => encodeCommentActionParams,
  encodeNextParams: () => encodeNextParams,
  encodeVisitorData: () => encodeVisitorData
});

// node_modules/@bufbuild/protobuf/dist/esm/wire/varint.js
function varint64read() {
  let lowBits = 0;
  let highBits = 0;
  for (let shift = 0; shift < 28; shift += 7) {
    let b = this.buf[this.pos++];
    lowBits |= (b & 127) << shift;
    if ((b & 128) == 0) {
      this.assertBounds();
      return [lowBits, highBits];
    }
  }
  let middleByte = this.buf[this.pos++];
  lowBits |= (middleByte & 15) << 28;
  highBits = (middleByte & 112) >> 4;
  if ((middleByte & 128) == 0) {
    this.assertBounds();
    return [lowBits, highBits];
  }
  for (let shift = 3; shift <= 31; shift += 7) {
    let b = this.buf[this.pos++];
    highBits |= (b & 127) << shift;
    if ((b & 128) == 0) {
      this.assertBounds();
      return [lowBits, highBits];
    }
  }
  throw new Error("invalid varint");
}
__name(varint64read, "varint64read");
function varint64write(lo, hi, bytes) {
  for (let i = 0; i < 28; i = i + 7) {
    const shift = lo >>> i;
    const hasNext = !(shift >>> 7 == 0 && hi == 0);
    const byte = (hasNext ? shift | 128 : shift) & 255;
    bytes.push(byte);
    if (!hasNext) {
      return;
    }
  }
  const splitBits = lo >>> 28 & 15 | (hi & 7) << 4;
  const hasMoreBits = !(hi >> 3 == 0);
  bytes.push((hasMoreBits ? splitBits | 128 : splitBits) & 255);
  if (!hasMoreBits) {
    return;
  }
  for (let i = 3; i < 31; i = i + 7) {
    const shift = hi >>> i;
    const hasNext = !(shift >>> 7 == 0);
    const byte = (hasNext ? shift | 128 : shift) & 255;
    bytes.push(byte);
    if (!hasNext) {
      return;
    }
  }
  bytes.push(hi >>> 31 & 1);
}
__name(varint64write, "varint64write");
var TWO_PWR_32_DBL = 4294967296;
function int64FromString(dec) {
  const minus = dec[0] === "-";
  if (minus) {
    dec = dec.slice(1);
  }
  const base = 1e6;
  let lowBits = 0;
  let highBits = 0;
  function add1e6digit(begin, end) {
    const digit1e6 = Number(dec.slice(begin, end));
    highBits *= base;
    lowBits = lowBits * base + digit1e6;
    if (lowBits >= TWO_PWR_32_DBL) {
      highBits = highBits + (lowBits / TWO_PWR_32_DBL | 0);
      lowBits = lowBits % TWO_PWR_32_DBL;
    }
  }
  __name(add1e6digit, "add1e6digit");
  add1e6digit(-24, -18);
  add1e6digit(-18, -12);
  add1e6digit(-12, -6);
  add1e6digit(-6);
  return minus ? negate(lowBits, highBits) : newBits(lowBits, highBits);
}
__name(int64FromString, "int64FromString");
function int64ToString(lo, hi) {
  let bits = newBits(lo, hi);
  const negative = bits.hi & 2147483648;
  if (negative) {
    bits = negate(bits.lo, bits.hi);
  }
  const result = uInt64ToString(bits.lo, bits.hi);
  return negative ? "-" + result : result;
}
__name(int64ToString, "int64ToString");
function uInt64ToString(lo, hi) {
  ({ lo, hi } = toUnsigned(lo, hi));
  if (hi <= 2097151) {
    return String(TWO_PWR_32_DBL * hi + lo);
  }
  const low = lo & 16777215;
  const mid = (lo >>> 24 | hi << 8) & 16777215;
  const high = hi >> 16 & 65535;
  let digitA = low + mid * 6777216 + high * 6710656;
  let digitB = mid + high * 8147497;
  let digitC = high * 2;
  const base = 1e7;
  if (digitA >= base) {
    digitB += Math.floor(digitA / base);
    digitA %= base;
  }
  if (digitB >= base) {
    digitC += Math.floor(digitB / base);
    digitB %= base;
  }
  return digitC.toString() + decimalFrom1e7WithLeadingZeros(digitB) + decimalFrom1e7WithLeadingZeros(digitA);
}
__name(uInt64ToString, "uInt64ToString");
function toUnsigned(lo, hi) {
  return { lo: lo >>> 0, hi: hi >>> 0 };
}
__name(toUnsigned, "toUnsigned");
function newBits(lo, hi) {
  return { lo: lo | 0, hi: hi | 0 };
}
__name(newBits, "newBits");
function negate(lowBits, highBits) {
  highBits = ~highBits;
  if (lowBits) {
    lowBits = ~lowBits + 1;
  } else {
    highBits += 1;
  }
  return newBits(lowBits, highBits);
}
__name(negate, "negate");
var decimalFrom1e7WithLeadingZeros = /* @__PURE__ */ __name((digit1e7) => {
  const partial = String(digit1e7);
  return "0000000".slice(partial.length) + partial;
}, "decimalFrom1e7WithLeadingZeros");
function varint32write(value, bytes) {
  if (value >= 0) {
    while (value > 127) {
      bytes.push(value & 127 | 128);
      value = value >>> 7;
    }
    bytes.push(value);
  } else {
    for (let i = 0; i < 9; i++) {
      bytes.push(value & 127 | 128);
      value = value >> 7;
    }
    bytes.push(1);
  }
}
__name(varint32write, "varint32write");
function varint32read() {
  let b = this.buf[this.pos++];
  let result = b & 127;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 127) << 7;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 127) << 14;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 127) << 21;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 15) << 28;
  for (let readBytes = 5; (b & 128) !== 0 && readBytes < 10; readBytes++)
    b = this.buf[this.pos++];
  if ((b & 128) != 0)
    throw new Error("invalid varint");
  this.assertBounds();
  return result >>> 0;
}
__name(varint32read, "varint32read");

// node_modules/@bufbuild/protobuf/dist/esm/proto-int64.js
var protoInt64 = /* @__PURE__ */ makeInt64Support();
function makeInt64Support() {
  const dv = new DataView(new ArrayBuffer(8));
  const ok = typeof BigInt === "function" && typeof dv.getBigInt64 === "function" && typeof dv.getBigUint64 === "function" && typeof dv.setBigInt64 === "function" && typeof dv.setBigUint64 === "function" && (typeof process != "object" || typeof process.env != "object" || process.env.BUF_BIGINT_DISABLE !== "1");
  if (ok) {
    const MIN = BigInt("-9223372036854775808"), MAX = BigInt("9223372036854775807"), UMIN = BigInt("0"), UMAX = BigInt("18446744073709551615");
    return {
      zero: BigInt(0),
      supported: true,
      parse(value) {
        const bi = typeof value == "bigint" ? value : BigInt(value);
        if (bi > MAX || bi < MIN) {
          throw new Error(`invalid int64: ${value}`);
        }
        return bi;
      },
      uParse(value) {
        const bi = typeof value == "bigint" ? value : BigInt(value);
        if (bi > UMAX || bi < UMIN) {
          throw new Error(`invalid uint64: ${value}`);
        }
        return bi;
      },
      enc(value) {
        dv.setBigInt64(0, this.parse(value), true);
        return {
          lo: dv.getInt32(0, true),
          hi: dv.getInt32(4, true)
        };
      },
      uEnc(value) {
        dv.setBigInt64(0, this.uParse(value), true);
        return {
          lo: dv.getInt32(0, true),
          hi: dv.getInt32(4, true)
        };
      },
      dec(lo, hi) {
        dv.setInt32(0, lo, true);
        dv.setInt32(4, hi, true);
        return dv.getBigInt64(0, true);
      },
      uDec(lo, hi) {
        dv.setInt32(0, lo, true);
        dv.setInt32(4, hi, true);
        return dv.getBigUint64(0, true);
      }
    };
  }
  return {
    zero: "0",
    supported: false,
    parse(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertInt64String(value);
      return value;
    },
    uParse(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertUInt64String(value);
      return value;
    },
    enc(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertInt64String(value);
      return int64FromString(value);
    },
    uEnc(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertUInt64String(value);
      return int64FromString(value);
    },
    dec(lo, hi) {
      return int64ToString(lo, hi);
    },
    uDec(lo, hi) {
      return uInt64ToString(lo, hi);
    }
  };
}
__name(makeInt64Support, "makeInt64Support");
function assertInt64String(value) {
  if (!/^-?[0-9]+$/.test(value)) {
    throw new Error("invalid int64: " + value);
  }
}
__name(assertInt64String, "assertInt64String");
function assertUInt64String(value) {
  if (!/^[0-9]+$/.test(value)) {
    throw new Error("invalid uint64: " + value);
  }
}
__name(assertUInt64String, "assertUInt64String");

// node_modules/@bufbuild/protobuf/dist/esm/wire/text-encoding.js
var symbol = Symbol.for("@bufbuild/protobuf/text-encoding");
function getTextEncoding() {
  if (globalThis[symbol] == void 0) {
    const te = new globalThis.TextEncoder();
    const td = new globalThis.TextDecoder();
    globalThis[symbol] = {
      encodeUtf8(text) {
        return te.encode(text);
      },
      decodeUtf8(bytes) {
        return td.decode(bytes);
      },
      checkUtf8(text) {
        try {
          encodeURIComponent(text);
          return true;
        } catch (e) {
          return false;
        }
      }
    };
  }
  return globalThis[symbol];
}
__name(getTextEncoding, "getTextEncoding");

// node_modules/@bufbuild/protobuf/dist/esm/wire/binary-encoding.js
var WireType;
(function(WireType2) {
  WireType2[WireType2["Varint"] = 0] = "Varint";
  WireType2[WireType2["Bit64"] = 1] = "Bit64";
  WireType2[WireType2["LengthDelimited"] = 2] = "LengthDelimited";
  WireType2[WireType2["StartGroup"] = 3] = "StartGroup";
  WireType2[WireType2["EndGroup"] = 4] = "EndGroup";
  WireType2[WireType2["Bit32"] = 5] = "Bit32";
})(WireType || (WireType = {}));
var FLOAT32_MAX = 34028234663852886e22;
var FLOAT32_MIN = -34028234663852886e22;
var UINT32_MAX = 4294967295;
var INT32_MAX = 2147483647;
var INT32_MIN = -2147483648;
var _BinaryWriter = class _BinaryWriter {
  constructor(encodeUtf8 = getTextEncoding().encodeUtf8) {
    this.encodeUtf8 = encodeUtf8;
    this.stack = [];
    this.chunks = [];
    this.buf = [];
  }
  /**
   * Return all bytes written and reset this writer.
   */
  finish() {
    this.chunks.push(new Uint8Array(this.buf));
    let len = 0;
    for (let i = 0; i < this.chunks.length; i++)
      len += this.chunks[i].length;
    let bytes = new Uint8Array(len);
    let offset = 0;
    for (let i = 0; i < this.chunks.length; i++) {
      bytes.set(this.chunks[i], offset);
      offset += this.chunks[i].length;
    }
    this.chunks = [];
    return bytes;
  }
  /**
   * Start a new fork for length-delimited data like a message
   * or a packed repeated field.
   *
   * Must be joined later with `join()`.
   */
  fork() {
    this.stack.push({ chunks: this.chunks, buf: this.buf });
    this.chunks = [];
    this.buf = [];
    return this;
  }
  /**
   * Join the last fork. Write its length and bytes, then
   * return to the previous state.
   */
  join() {
    let chunk = this.finish();
    let prev = this.stack.pop();
    if (!prev)
      throw new Error("invalid state, fork stack empty");
    this.chunks = prev.chunks;
    this.buf = prev.buf;
    this.uint32(chunk.byteLength);
    return this.raw(chunk);
  }
  /**
   * Writes a tag (field number and wire type).
   *
   * Equivalent to `uint32( (fieldNo << 3 | type) >>> 0 )`.
   *
   * Generated code should compute the tag ahead of time and call `uint32()`.
   */
  tag(fieldNo, type) {
    return this.uint32((fieldNo << 3 | type) >>> 0);
  }
  /**
   * Write a chunk of raw bytes.
   */
  raw(chunk) {
    if (this.buf.length) {
      this.chunks.push(new Uint8Array(this.buf));
      this.buf = [];
    }
    this.chunks.push(chunk);
    return this;
  }
  /**
   * Write a `uint32` value, an unsigned 32 bit varint.
   */
  uint32(value) {
    assertUInt32(value);
    while (value > 127) {
      this.buf.push(value & 127 | 128);
      value = value >>> 7;
    }
    this.buf.push(value);
    return this;
  }
  /**
   * Write a `int32` value, a signed 32 bit varint.
   */
  int32(value) {
    assertInt32(value);
    varint32write(value, this.buf);
    return this;
  }
  /**
   * Write a `bool` value, a variant.
   */
  bool(value) {
    this.buf.push(value ? 1 : 0);
    return this;
  }
  /**
   * Write a `bytes` value, length-delimited arbitrary data.
   */
  bytes(value) {
    this.uint32(value.byteLength);
    return this.raw(value);
  }
  /**
   * Write a `string` value, length-delimited data converted to UTF-8 text.
   */
  string(value) {
    let chunk = this.encodeUtf8(value);
    this.uint32(chunk.byteLength);
    return this.raw(chunk);
  }
  /**
   * Write a `float` value, 32-bit floating point number.
   */
  float(value) {
    assertFloat32(value);
    let chunk = new Uint8Array(4);
    new DataView(chunk.buffer).setFloat32(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `double` value, a 64-bit floating point number.
   */
  double(value) {
    let chunk = new Uint8Array(8);
    new DataView(chunk.buffer).setFloat64(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `fixed32` value, an unsigned, fixed-length 32-bit integer.
   */
  fixed32(value) {
    assertUInt32(value);
    let chunk = new Uint8Array(4);
    new DataView(chunk.buffer).setUint32(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `sfixed32` value, a signed, fixed-length 32-bit integer.
   */
  sfixed32(value) {
    assertInt32(value);
    let chunk = new Uint8Array(4);
    new DataView(chunk.buffer).setInt32(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `sint32` value, a signed, zigzag-encoded 32-bit varint.
   */
  sint32(value) {
    assertInt32(value);
    value = (value << 1 ^ value >> 31) >>> 0;
    varint32write(value, this.buf);
    return this;
  }
  /**
   * Write a `fixed64` value, a signed, fixed-length 64-bit integer.
   */
  sfixed64(value) {
    let chunk = new Uint8Array(8), view = new DataView(chunk.buffer), tc = protoInt64.enc(value);
    view.setInt32(0, tc.lo, true);
    view.setInt32(4, tc.hi, true);
    return this.raw(chunk);
  }
  /**
   * Write a `fixed64` value, an unsigned, fixed-length 64 bit integer.
   */
  fixed64(value) {
    let chunk = new Uint8Array(8), view = new DataView(chunk.buffer), tc = protoInt64.uEnc(value);
    view.setInt32(0, tc.lo, true);
    view.setInt32(4, tc.hi, true);
    return this.raw(chunk);
  }
  /**
   * Write a `int64` value, a signed 64-bit varint.
   */
  int64(value) {
    let tc = protoInt64.enc(value);
    varint64write(tc.lo, tc.hi, this.buf);
    return this;
  }
  /**
   * Write a `sint64` value, a signed, zig-zag-encoded 64-bit varint.
   */
  sint64(value) {
    let tc = protoInt64.enc(value), sign = tc.hi >> 31, lo = tc.lo << 1 ^ sign, hi = (tc.hi << 1 | tc.lo >>> 31) ^ sign;
    varint64write(lo, hi, this.buf);
    return this;
  }
  /**
   * Write a `uint64` value, an unsigned 64-bit varint.
   */
  uint64(value) {
    let tc = protoInt64.uEnc(value);
    varint64write(tc.lo, tc.hi, this.buf);
    return this;
  }
};
__name(_BinaryWriter, "BinaryWriter");
var BinaryWriter = _BinaryWriter;
var _BinaryReader = class _BinaryReader {
  constructor(buf, decodeUtf8 = getTextEncoding().decodeUtf8) {
    this.decodeUtf8 = decodeUtf8;
    this.varint64 = varint64read;
    this.uint32 = varint32read;
    this.buf = buf;
    this.len = buf.length;
    this.pos = 0;
    this.view = new DataView(buf.buffer, buf.byteOffset, buf.byteLength);
  }
  /**
   * Reads a tag - field number and wire type.
   */
  tag() {
    let tag = this.uint32(), fieldNo = tag >>> 3, wireType = tag & 7;
    if (fieldNo <= 0 || wireType < 0 || wireType > 5)
      throw new Error("illegal tag: field no " + fieldNo + " wire type " + wireType);
    return [fieldNo, wireType];
  }
  /**
   * Skip one element and return the skipped data.
   *
   * When skipping StartGroup, provide the tags field number to check for
   * matching field number in the EndGroup tag.
   */
  skip(wireType, fieldNo) {
    let start = this.pos;
    switch (wireType) {
      case WireType.Varint:
        while (this.buf[this.pos++] & 128) {
        }
        break;
      // eslint-disable-next-line
      // @ts-expect-error TS7029: Fallthrough case in switch
      case WireType.Bit64:
        this.pos += 4;
      // eslint-disable-next-line no-fallthrough
      case WireType.Bit32:
        this.pos += 4;
        break;
      case WireType.LengthDelimited:
        let len = this.uint32();
        this.pos += len;
        break;
      case WireType.StartGroup:
        for (; ; ) {
          const [fn, wt] = this.tag();
          if (wt === WireType.EndGroup) {
            if (fieldNo !== void 0 && fn !== fieldNo) {
              throw new Error("invalid end group tag");
            }
            break;
          }
          this.skip(wt, fn);
        }
        break;
      default:
        throw new Error("cant skip wire type " + wireType);
    }
    this.assertBounds();
    return this.buf.subarray(start, this.pos);
  }
  /**
   * Throws error if position in byte array is out of range.
   */
  assertBounds() {
    if (this.pos > this.len)
      throw new RangeError("premature EOF");
  }
  /**
   * Read a `int32` field, a signed 32 bit varint.
   */
  int32() {
    return this.uint32() | 0;
  }
  /**
   * Read a `sint32` field, a signed, zigzag-encoded 32-bit varint.
   */
  sint32() {
    let zze = this.uint32();
    return zze >>> 1 ^ -(zze & 1);
  }
  /**
   * Read a `int64` field, a signed 64-bit varint.
   */
  int64() {
    return protoInt64.dec(...this.varint64());
  }
  /**
   * Read a `uint64` field, an unsigned 64-bit varint.
   */
  uint64() {
    return protoInt64.uDec(...this.varint64());
  }
  /**
   * Read a `sint64` field, a signed, zig-zag-encoded 64-bit varint.
   */
  sint64() {
    let [lo, hi] = this.varint64();
    let s = -(lo & 1);
    lo = (lo >>> 1 | (hi & 1) << 31) ^ s;
    hi = hi >>> 1 ^ s;
    return protoInt64.dec(lo, hi);
  }
  /**
   * Read a `bool` field, a variant.
   */
  bool() {
    let [lo, hi] = this.varint64();
    return lo !== 0 || hi !== 0;
  }
  /**
   * Read a `fixed32` field, an unsigned, fixed-length 32-bit integer.
   */
  fixed32() {
    return this.view.getUint32((this.pos += 4) - 4, true);
  }
  /**
   * Read a `sfixed32` field, a signed, fixed-length 32-bit integer.
   */
  sfixed32() {
    return this.view.getInt32((this.pos += 4) - 4, true);
  }
  /**
   * Read a `fixed64` field, an unsigned, fixed-length 64 bit integer.
   */
  fixed64() {
    return protoInt64.uDec(this.sfixed32(), this.sfixed32());
  }
  /**
   * Read a `fixed64` field, a signed, fixed-length 64-bit integer.
   */
  sfixed64() {
    return protoInt64.dec(this.sfixed32(), this.sfixed32());
  }
  /**
   * Read a `float` field, 32-bit floating point number.
   */
  float() {
    return this.view.getFloat32((this.pos += 4) - 4, true);
  }
  /**
   * Read a `double` field, a 64-bit floating point number.
   */
  double() {
    return this.view.getFloat64((this.pos += 8) - 8, true);
  }
  /**
   * Read a `bytes` field, length-delimited arbitrary data.
   */
  bytes() {
    let len = this.uint32(), start = this.pos;
    this.pos += len;
    this.assertBounds();
    return this.buf.subarray(start, start + len);
  }
  /**
   * Read a `string` field, length-delimited data converted to UTF-8 text.
   */
  string() {
    return this.decodeUtf8(this.bytes());
  }
};
__name(_BinaryReader, "BinaryReader");
var BinaryReader = _BinaryReader;
function assertInt32(arg) {
  if (typeof arg == "string") {
    arg = Number(arg);
  } else if (typeof arg != "number") {
    throw new Error("invalid int32: " + typeof arg);
  }
  if (!Number.isInteger(arg) || arg > INT32_MAX || arg < INT32_MIN)
    throw new Error("invalid int32: " + arg);
}
__name(assertInt32, "assertInt32");
function assertUInt32(arg) {
  if (typeof arg == "string") {
    arg = Number(arg);
  } else if (typeof arg != "number") {
    throw new Error("invalid uint32: " + typeof arg);
  }
  if (!Number.isInteger(arg) || arg > UINT32_MAX || arg < 0)
    throw new Error("invalid uint32: " + arg);
}
__name(assertUInt32, "assertUInt32");
function assertFloat32(arg) {
  if (typeof arg == "string") {
    const o = arg;
    arg = Number(arg);
    if (isNaN(arg) && o !== "NaN") {
      throw new Error("invalid float32: " + o);
    }
  } else if (typeof arg != "number") {
    throw new Error("invalid float32: " + typeof arg);
  }
  if (Number.isFinite(arg) && (arg > FLOAT32_MAX || arg < FLOAT32_MIN))
    throw new Error("invalid float32: " + arg);
}
__name(assertFloat32, "assertFloat32");

// dist/protos/generated/misc/params.js
var SearchFilter_SortBy = {
  RELEVANCE: 0,
  0: "RELEVANCE",
  RATING: 1,
  1: "RATING",
  UPLOAD_DATE: 2,
  2: "UPLOAD_DATE",
  VIEW_COUNT: 3,
  3: "VIEW_COUNT",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
var SearchFilter_Filters_UploadDate = {
  ANY_DATE: 0,
  0: "ANY_DATE",
  HOUR: 1,
  1: "HOUR",
  TODAY: 2,
  2: "TODAY",
  WEEK: 3,
  3: "WEEK",
  MONTH: 4,
  4: "MONTH",
  YEAR: 5,
  5: "YEAR",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
var SearchFilter_Filters_SearchType = {
  ANY_TYPE: 0,
  0: "ANY_TYPE",
  VIDEO: 1,
  1: "VIDEO",
  CHANNEL: 2,
  2: "CHANNEL",
  PLAYLIST: 3,
  3: "PLAYLIST",
  MOVIE: 4,
  4: "MOVIE",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
var SearchFilter_Filters_Duration = {
  ANY_DURATION: 0,
  0: "ANY_DURATION",
  SHORT: 1,
  1: "SHORT",
  LONG: 2,
  2: "LONG",
  MEDIUM: 3,
  3: "MEDIUM",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
function createBaseVisitorData() {
  return { id: "", timestamp: 0 };
}
__name(createBaseVisitorData, "createBaseVisitorData");
var VisitorData = {
  encode(message, writer = new BinaryWriter()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.timestamp !== 0) {
      writer.uint32(40).int32(message.timestamp);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseVisitorData();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.timestamp = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSearchFilter() {
  return { sortBy: void 0, filters: void 0 };
}
__name(createBaseSearchFilter, "createBaseSearchFilter");
var SearchFilter = {
  encode(message, writer = new BinaryWriter()) {
    if (message.sortBy !== void 0) {
      writer.uint32(8).int32(message.sortBy);
    }
    if (message.filters !== void 0) {
      SearchFilter_Filters.encode(message.filters, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSearchFilter();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.sortBy = reader.int32();
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.filters = SearchFilter_Filters.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSearchFilter_Filters() {
  return {
    uploadDate: void 0,
    type: void 0,
    duration: void 0,
    musicSearchType: void 0,
    featuresHd: void 0,
    featuresSubtitles: void 0,
    featuresCreativeCommons: void 0,
    features3d: void 0,
    featuresLive: void 0,
    featuresPurchased: void 0,
    features4k: void 0,
    features360: void 0,
    featuresLocation: void 0,
    featuresHdr: void 0,
    featuresVr180: void 0
  };
}
__name(createBaseSearchFilter_Filters, "createBaseSearchFilter_Filters");
var SearchFilter_Filters = {
  encode(message, writer = new BinaryWriter()) {
    if (message.uploadDate !== void 0) {
      writer.uint32(8).int32(message.uploadDate);
    }
    if (message.type !== void 0) {
      writer.uint32(16).int32(message.type);
    }
    if (message.duration !== void 0) {
      writer.uint32(24).int32(message.duration);
    }
    if (message.musicSearchType !== void 0) {
      SearchFilter_Filters_MusicSearchType.encode(message.musicSearchType, writer.uint32(138).fork()).join();
    }
    if (message.featuresHd !== void 0) {
      writer.uint32(32).bool(message.featuresHd);
    }
    if (message.featuresSubtitles !== void 0) {
      writer.uint32(40).bool(message.featuresSubtitles);
    }
    if (message.featuresCreativeCommons !== void 0) {
      writer.uint32(48).bool(message.featuresCreativeCommons);
    }
    if (message.features3d !== void 0) {
      writer.uint32(56).bool(message.features3d);
    }
    if (message.featuresLive !== void 0) {
      writer.uint32(64).bool(message.featuresLive);
    }
    if (message.featuresPurchased !== void 0) {
      writer.uint32(72).bool(message.featuresPurchased);
    }
    if (message.features4k !== void 0) {
      writer.uint32(112).bool(message.features4k);
    }
    if (message.features360 !== void 0) {
      writer.uint32(120).bool(message.features360);
    }
    if (message.featuresLocation !== void 0) {
      writer.uint32(184).bool(message.featuresLocation);
    }
    if (message.featuresHdr !== void 0) {
      writer.uint32(200).bool(message.featuresHdr);
    }
    if (message.featuresVr180 !== void 0) {
      writer.uint32(208).bool(message.featuresVr180);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSearchFilter_Filters();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.uploadDate = reader.int32();
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.type = reader.int32();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.duration = reader.int32();
          continue;
        case 17:
          if (tag !== 138) {
            break;
          }
          message.musicSearchType = SearchFilter_Filters_MusicSearchType.decode(reader, reader.uint32());
          continue;
        case 4:
          if (tag !== 32) {
            break;
          }
          message.featuresHd = reader.bool();
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.featuresSubtitles = reader.bool();
          continue;
        case 6:
          if (tag !== 48) {
            break;
          }
          message.featuresCreativeCommons = reader.bool();
          continue;
        case 7:
          if (tag !== 56) {
            break;
          }
          message.features3d = reader.bool();
          continue;
        case 8:
          if (tag !== 64) {
            break;
          }
          message.featuresLive = reader.bool();
          continue;
        case 9:
          if (tag !== 72) {
            break;
          }
          message.featuresPurchased = reader.bool();
          continue;
        case 14:
          if (tag !== 112) {
            break;
          }
          message.features4k = reader.bool();
          continue;
        case 15:
          if (tag !== 120) {
            break;
          }
          message.features360 = reader.bool();
          continue;
        case 23:
          if (tag !== 184) {
            break;
          }
          message.featuresLocation = reader.bool();
          continue;
        case 25:
          if (tag !== 200) {
            break;
          }
          message.featuresHdr = reader.bool();
          continue;
        case 26:
          if (tag !== 208) {
            break;
          }
          message.featuresVr180 = reader.bool();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSearchFilter_Filters_MusicSearchType() {
  return { song: void 0, video: void 0, album: void 0, artist: void 0, playlist: void 0 };
}
__name(createBaseSearchFilter_Filters_MusicSearchType, "createBaseSearchFilter_Filters_MusicSearchType");
var SearchFilter_Filters_MusicSearchType = {
  encode(message, writer = new BinaryWriter()) {
    if (message.song !== void 0) {
      writer.uint32(8).bool(message.song);
    }
    if (message.video !== void 0) {
      writer.uint32(16).bool(message.video);
    }
    if (message.album !== void 0) {
      writer.uint32(24).bool(message.album);
    }
    if (message.artist !== void 0) {
      writer.uint32(32).bool(message.artist);
    }
    if (message.playlist !== void 0) {
      writer.uint32(40).bool(message.playlist);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSearchFilter_Filters_MusicSearchType();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.song = reader.bool();
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.video = reader.bool();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.album = reader.bool();
          continue;
        case 4:
          if (tag !== 32) {
            break;
          }
          message.artist = reader.bool();
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.playlist = reader.bool();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseNotificationPreferences() {
  return { channelId: "", prefId: void 0, number0: void 0, number1: void 0 };
}
__name(createBaseNotificationPreferences, "createBaseNotificationPreferences");
var NotificationPreferences = {
  encode(message, writer = new BinaryWriter()) {
    if (message.channelId !== "") {
      writer.uint32(10).string(message.channelId);
    }
    if (message.prefId !== void 0) {
      NotificationPreferences_Preference.encode(message.prefId, writer.uint32(18).fork()).join();
    }
    if (message.number0 !== void 0) {
      writer.uint32(24).int32(message.number0);
    }
    if (message.number1 !== void 0) {
      writer.uint32(32).int32(message.number1);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseNotificationPreferences();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.prefId = NotificationPreferences_Preference.decode(reader, reader.uint32());
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.number0 = reader.int32();
          continue;
        case 4:
          if (tag !== 32) {
            break;
          }
          message.number1 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseNotificationPreferences_Preference() {
  return { index: 0 };
}
__name(createBaseNotificationPreferences_Preference, "createBaseNotificationPreferences_Preference");
var NotificationPreferences_Preference = {
  encode(message, writer = new BinaryWriter()) {
    if (message.index !== 0) {
      writer.uint32(8).int32(message.index);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseNotificationPreferences_Preference();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.index = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseLiveMessageParams() {
  return { params: void 0, number0: void 0, number1: void 0 };
}
__name(createBaseLiveMessageParams, "createBaseLiveMessageParams");
var LiveMessageParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.params !== void 0) {
      LiveMessageParams_Params.encode(message.params, writer.uint32(10).fork()).join();
    }
    if (message.number0 !== void 0) {
      writer.uint32(16).int32(message.number0);
    }
    if (message.number1 !== void 0) {
      writer.uint32(24).int32(message.number1);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseLiveMessageParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.params = LiveMessageParams_Params.decode(reader, reader.uint32());
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.number0 = reader.int32();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.number1 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseLiveMessageParams_Params() {
  return { ids: void 0 };
}
__name(createBaseLiveMessageParams_Params, "createBaseLiveMessageParams_Params");
var LiveMessageParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.ids !== void 0) {
      LiveMessageParams_Params_Ids.encode(message.ids, writer.uint32(42).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseLiveMessageParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 5:
          if (tag !== 42) {
            break;
          }
          message.ids = LiveMessageParams_Params_Ids.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseLiveMessageParams_Params_Ids() {
  return { channelId: "", videoId: "" };
}
__name(createBaseLiveMessageParams_Params_Ids, "createBaseLiveMessageParams_Params_Ids");
var LiveMessageParams_Params_Ids = {
  encode(message, writer = new BinaryWriter()) {
    if (message.channelId !== "") {
      writer.uint32(10).string(message.channelId);
    }
    if (message.videoId !== "") {
      writer.uint32(18).string(message.videoId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseLiveMessageParams_Params_Ids();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.videoId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams() {
  return { ctx: void 0, unkParam: 0, params: void 0 };
}
__name(createBaseGetCommentsSectionParams, "createBaseGetCommentsSectionParams");
var GetCommentsSectionParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.ctx !== void 0) {
      GetCommentsSectionParams_Context.encode(message.ctx, writer.uint32(18).fork()).join();
    }
    if (message.unkParam !== 0) {
      writer.uint32(24).int32(message.unkParam);
    }
    if (message.params !== void 0) {
      GetCommentsSectionParams_Params.encode(message.params, writer.uint32(50).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.ctx = GetCommentsSectionParams_Context.decode(reader, reader.uint32());
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.unkParam = reader.int32();
          continue;
        case 6:
          if (tag !== 50) {
            break;
          }
          message.params = GetCommentsSectionParams_Params.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Context() {
  return { videoId: "" };
}
__name(createBaseGetCommentsSectionParams_Context, "createBaseGetCommentsSectionParams_Context");
var GetCommentsSectionParams_Context = {
  encode(message, writer = new BinaryWriter()) {
    if (message.videoId !== "") {
      writer.uint32(18).string(message.videoId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Context();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.videoId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params() {
  return { unkToken: void 0, opts: void 0, repliesOpts: void 0, page: void 0, target: "" };
}
__name(createBaseGetCommentsSectionParams_Params, "createBaseGetCommentsSectionParams_Params");
var GetCommentsSectionParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.unkToken !== void 0) {
      writer.uint32(10).string(message.unkToken);
    }
    if (message.opts !== void 0) {
      GetCommentsSectionParams_Params_Options.encode(message.opts, writer.uint32(34).fork()).join();
    }
    if (message.repliesOpts !== void 0) {
      GetCommentsSectionParams_Params_RepliesOptions.encode(message.repliesOpts, writer.uint32(26).fork()).join();
    }
    if (message.page !== void 0) {
      writer.uint32(40).int32(message.page);
    }
    if (message.target !== "") {
      writer.uint32(66).string(message.target);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.unkToken = reader.string();
          continue;
        case 4:
          if (tag !== 34) {
            break;
          }
          message.opts = GetCommentsSectionParams_Params_Options.decode(reader, reader.uint32());
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.repliesOpts = GetCommentsSectionParams_Params_RepliesOptions.decode(reader, reader.uint32());
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.page = reader.int32();
          continue;
        case 8:
          if (tag !== 66) {
            break;
          }
          message.target = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params_Options() {
  return { videoId: "", sortBy: 0, type: 0, commentId: void 0 };
}
__name(createBaseGetCommentsSectionParams_Params_Options, "createBaseGetCommentsSectionParams_Params_Options");
var GetCommentsSectionParams_Params_Options = {
  encode(message, writer = new BinaryWriter()) {
    if (message.videoId !== "") {
      writer.uint32(34).string(message.videoId);
    }
    if (message.sortBy !== 0) {
      writer.uint32(48).int32(message.sortBy);
    }
    if (message.type !== 0) {
      writer.uint32(120).int32(message.type);
    }
    if (message.commentId !== void 0) {
      writer.uint32(130).string(message.commentId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params_Options();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 4:
          if (tag !== 34) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 6:
          if (tag !== 48) {
            break;
          }
          message.sortBy = reader.int32();
          continue;
        case 15:
          if (tag !== 120) {
            break;
          }
          message.type = reader.int32();
          continue;
        case 16:
          if (tag !== 130) {
            break;
          }
          message.commentId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params_RepliesOptions() {
  return { commentId: "", unkopts: void 0, channelId: void 0, videoId: "", unkParam1: 0, unkParam2: 0 };
}
__name(createBaseGetCommentsSectionParams_Params_RepliesOptions, "createBaseGetCommentsSectionParams_Params_RepliesOptions");
var GetCommentsSectionParams_Params_RepliesOptions = {
  encode(message, writer = new BinaryWriter()) {
    if (message.commentId !== "") {
      writer.uint32(18).string(message.commentId);
    }
    if (message.unkopts !== void 0) {
      GetCommentsSectionParams_Params_RepliesOptions_UnkOpts.encode(message.unkopts, writer.uint32(34).fork()).join();
    }
    if (message.channelId !== void 0) {
      writer.uint32(42).string(message.channelId);
    }
    if (message.videoId !== "") {
      writer.uint32(50).string(message.videoId);
    }
    if (message.unkParam1 !== 0) {
      writer.uint32(64).int32(message.unkParam1);
    }
    if (message.unkParam2 !== 0) {
      writer.uint32(72).int32(message.unkParam2);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params_RepliesOptions();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.commentId = reader.string();
          continue;
        case 4:
          if (tag !== 34) {
            break;
          }
          message.unkopts = GetCommentsSectionParams_Params_RepliesOptions_UnkOpts.decode(reader, reader.uint32());
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 6:
          if (tag !== 50) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 8:
          if (tag !== 64) {
            break;
          }
          message.unkParam1 = reader.int32();
          continue;
        case 9:
          if (tag !== 72) {
            break;
          }
          message.unkParam2 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts() {
  return { unkParam: 0 };
}
__name(createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts, "createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts");
var GetCommentsSectionParams_Params_RepliesOptions_UnkOpts = {
  encode(message, writer = new BinaryWriter()) {
    if (message.unkParam !== 0) {
      writer.uint32(8).int32(message.unkParam);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.unkParam = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCreateCommentParams() {
  return { videoId: "", params: void 0, number: 0 };
}
__name(createBaseCreateCommentParams, "createBaseCreateCommentParams");
var CreateCommentParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.videoId !== "") {
      writer.uint32(18).string(message.videoId);
    }
    if (message.params !== void 0) {
      CreateCommentParams_Params.encode(message.params, writer.uint32(42).fork()).join();
    }
    if (message.number !== 0) {
      writer.uint32(80).int32(message.number);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCreateCommentParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.params = CreateCommentParams_Params.decode(reader, reader.uint32());
          continue;
        case 10:
          if (tag !== 80) {
            break;
          }
          message.number = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCreateCommentParams_Params() {
  return { index: 0 };
}
__name(createBaseCreateCommentParams_Params, "createBaseCreateCommentParams_Params");
var CreateCommentParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.index !== 0) {
      writer.uint32(8).int32(message.index);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCreateCommentParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.index = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams() {
  return {
    type: 0,
    commentId: "",
    videoId: "",
    unkNum: void 0,
    channelId: void 0,
    translateCommentParams: void 0
  };
}
__name(createBasePeformCommentActionParams, "createBasePeformCommentActionParams");
var PeformCommentActionParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.type !== 0) {
      writer.uint32(8).int32(message.type);
    }
    if (message.commentId !== "") {
      writer.uint32(26).string(message.commentId);
    }
    if (message.videoId !== "") {
      writer.uint32(42).string(message.videoId);
    }
    if (message.unkNum !== void 0) {
      writer.uint32(16).int32(message.unkNum);
    }
    if (message.channelId !== void 0) {
      writer.uint32(186).string(message.channelId);
    }
    if (message.translateCommentParams !== void 0) {
      PeformCommentActionParams_TranslateCommentParams.encode(message.translateCommentParams, writer.uint32(250).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.type = reader.int32();
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.commentId = reader.string();
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.unkNum = reader.int32();
          continue;
        case 23:
          if (tag !== 186) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 31:
          if (tag !== 250) {
            break;
          }
          message.translateCommentParams = PeformCommentActionParams_TranslateCommentParams.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams_TranslateCommentParams() {
  return { params: void 0, commentId: "", targetLanguage: "" };
}
__name(createBasePeformCommentActionParams_TranslateCommentParams, "createBasePeformCommentActionParams_TranslateCommentParams");
var PeformCommentActionParams_TranslateCommentParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.params !== void 0) {
      PeformCommentActionParams_TranslateCommentParams_Params.encode(message.params, writer.uint32(26).fork()).join();
    }
    if (message.commentId !== "") {
      writer.uint32(18).string(message.commentId);
    }
    if (message.targetLanguage !== "") {
      writer.uint32(34).string(message.targetLanguage);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams_TranslateCommentParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 3:
          if (tag !== 26) {
            break;
          }
          message.params = PeformCommentActionParams_TranslateCommentParams_Params.decode(reader, reader.uint32());
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.commentId = reader.string();
          continue;
        case 4:
          if (tag !== 34) {
            break;
          }
          message.targetLanguage = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams_TranslateCommentParams_Params() {
  return { comment: void 0 };
}
__name(createBasePeformCommentActionParams_TranslateCommentParams_Params, "createBasePeformCommentActionParams_TranslateCommentParams_Params");
var PeformCommentActionParams_TranslateCommentParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.comment !== void 0) {
      PeformCommentActionParams_TranslateCommentParams_Params_Comment.encode(message.comment, writer.uint32(10).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams_TranslateCommentParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.comment = PeformCommentActionParams_TranslateCommentParams_Params_Comment.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment() {
  return { text: "" };
}
__name(createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment, "createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment");
var PeformCommentActionParams_TranslateCommentParams_Params_Comment = {
  encode(message, writer = new BinaryWriter()) {
    if (message.text !== "") {
      writer.uint32(10).string(message.text);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.text = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseHashtag() {
  return { params: void 0 };
}
__name(createBaseHashtag, "createBaseHashtag");
var Hashtag = {
  encode(message, writer = new BinaryWriter()) {
    if (message.params !== void 0) {
      Hashtag_Params.encode(message.params, writer.uint32(746).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseHashtag();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 93:
          if (tag !== 746) {
            break;
          }
          message.params = Hashtag_Params.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseHashtag_Params() {
  return { hashtag: "", type: 0 };
}
__name(createBaseHashtag_Params, "createBaseHashtag_Params");
var Hashtag_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.hashtag !== "") {
      writer.uint32(10).string(message.hashtag);
    }
    if (message.type !== 0) {
      writer.uint32(24).int32(message.type);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseHashtag_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.hashtag = reader.string();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.type = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseReelSequence() {
  return { shortId: "", params: void 0, feature2: 0, feature3: 0 };
}
__name(createBaseReelSequence, "createBaseReelSequence");
var ReelSequence = {
  encode(message, writer = new BinaryWriter()) {
    if (message.shortId !== "") {
      writer.uint32(10).string(message.shortId);
    }
    if (message.params !== void 0) {
      ReelSequence_Params.encode(message.params, writer.uint32(42).fork()).join();
    }
    if (message.feature2 !== 0) {
      writer.uint32(80).int32(message.feature2);
    }
    if (message.feature3 !== 0) {
      writer.uint32(104).int32(message.feature3);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseReelSequence();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.shortId = reader.string();
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.params = ReelSequence_Params.decode(reader, reader.uint32());
          continue;
        case 10:
          if (tag !== 80) {
            break;
          }
          message.feature2 = reader.int32();
          continue;
        case 13:
          if (tag !== 104) {
            break;
          }
          message.feature3 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseReelSequence_Params() {
  return { number: 0 };
}
__name(createBaseReelSequence_Params, "createBaseReelSequence_Params");
var ReelSequence_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.number !== 0) {
      writer.uint32(24).int32(message.number);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseReelSequence_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 3:
          if (tag !== 24) {
            break;
          }
          message.number = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseNextParams() {
  return { videoId: [], playlistTitle: void 0 };
}
__name(createBaseNextParams, "createBaseNextParams");
var NextParams = {
  encode(message, writer = new BinaryWriter()) {
    for (const v of message.videoId) {
      writer.uint32(42).string(v);
    }
    if (message.playlistTitle !== void 0) {
      writer.uint32(50).string(message.playlistTitle);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseNextParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 5:
          if (tag !== 42) {
            break;
          }
          message.videoId.push(reader.string());
          continue;
        case 6:
          if (tag !== 50) {
            break;
          }
          message.playlistTitle = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostParams() {
  return { f1: void 0 };
}
__name(createBaseCommunityPostParams, "createBaseCommunityPostParams");
var CommunityPostParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.f1 !== void 0) {
      CommunityPostParams_Field1.encode(message.f1, writer.uint32(450).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 56:
          if (tag !== 450) {
            break;
          }
          message.f1 = CommunityPostParams_Field1.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostParams_Field1() {
  return { ucid1: "", postId: "", ucid2: "" };
}
__name(createBaseCommunityPostParams_Field1, "createBaseCommunityPostParams_Field1");
var CommunityPostParams_Field1 = {
  encode(message, writer = new BinaryWriter()) {
    if (message.ucid1 !== "") {
      writer.uint32(18).string(message.ucid1);
    }
    if (message.postId !== "") {
      writer.uint32(26).string(message.postId);
    }
    if (message.ucid2 !== "") {
      writer.uint32(90).string(message.ucid2);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostParams_Field1();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.ucid1 = reader.string();
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.postId = reader.string();
          continue;
        case 11:
          if (tag !== 90) {
            break;
          }
          message.ucid2 = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParamContainer() {
  return { f0: void 0 };
}
__name(createBaseCommunityPostCommentsParamContainer, "createBaseCommunityPostCommentsParamContainer");
var CommunityPostCommentsParamContainer = {
  encode(message, writer = new BinaryWriter()) {
    if (message.f0 !== void 0) {
      CommunityPostCommentsParamContainer_Container.encode(message.f0, writer.uint32(641815778).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParamContainer();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 80226972:
          if (tag !== 641815778) {
            break;
          }
          message.f0 = CommunityPostCommentsParamContainer_Container.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParamContainer_Container() {
  return { location: "", protoData: "" };
}
__name(createBaseCommunityPostCommentsParamContainer_Container, "createBaseCommunityPostCommentsParamContainer_Container");
var CommunityPostCommentsParamContainer_Container = {
  encode(message, writer = new BinaryWriter()) {
    if (message.location !== "") {
      writer.uint32(18).string(message.location);
    }
    if (message.protoData !== "") {
      writer.uint32(26).string(message.protoData);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParamContainer_Container();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.location = reader.string();
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.protoData = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParam() {
  return { title: "", commentDataContainer: void 0 };
}
__name(createBaseCommunityPostCommentsParam, "createBaseCommunityPostCommentsParam");
var CommunityPostCommentsParam = {
  encode(message, writer = new BinaryWriter()) {
    if (message.title !== "") {
      writer.uint32(18).string(message.title);
    }
    if (message.commentDataContainer !== void 0) {
      CommunityPostCommentsParam_CommentDataContainer.encode(message.commentDataContainer, writer.uint32(426).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParam();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.title = reader.string();
          continue;
        case 53:
          if (tag !== 426) {
            break;
          }
          message.commentDataContainer = CommunityPostCommentsParam_CommentDataContainer.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParam_CommentDataContainer() {
  return { commentData: void 0, f0: 0, title: "" };
}
__name(createBaseCommunityPostCommentsParam_CommentDataContainer, "createBaseCommunityPostCommentsParam_CommentDataContainer");
var CommunityPostCommentsParam_CommentDataContainer = {
  encode(message, writer = new BinaryWriter()) {
    if (message.commentData !== void 0) {
      CommunityPostCommentsParam_CommentDataContainer_CommentData.encode(message.commentData, writer.uint32(34).fork()).join();
    }
    if (message.f0 !== 0) {
      writer.uint32(56).int32(message.f0);
    }
    if (message.title !== "") {
      writer.uint32(66).string(message.title);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParam_CommentDataContainer();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 4:
          if (tag !== 34) {
            break;
          }
          message.commentData = CommunityPostCommentsParam_CommentDataContainer_CommentData.decode(reader, reader.uint32());
          continue;
        case 7:
          if (tag !== 56) {
            break;
          }
          message.f0 = reader.int32();
          continue;
        case 8:
          if (tag !== 66) {
            break;
          }
          message.title = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData() {
  return { sortBy: 0, f0: 0, f1: 0, postId: "", channelId: "" };
}
__name(createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData, "createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData");
var CommunityPostCommentsParam_CommentDataContainer_CommentData = {
  encode(message, writer = new BinaryWriter()) {
    if (message.sortBy !== 0) {
      writer.uint32(48).int32(message.sortBy);
    }
    if (message.f0 !== 0) {
      writer.uint32(120).int32(message.f0);
    }
    if (message.f1 !== 0) {
      writer.uint32(200).int32(message.f1);
    }
    if (message.postId !== "") {
      writer.uint32(234).string(message.postId);
    }
    if (message.channelId !== "") {
      writer.uint32(242).string(message.channelId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 6:
          if (tag !== 48) {
            break;
          }
          message.sortBy = reader.int32();
          continue;
        case 15:
          if (tag !== 120) {
            break;
          }
          message.f0 = reader.int32();
          continue;
        case 25:
          if (tag !== 200) {
            break;
          }
          message.f1 = reader.int32();
          continue;
        case 29:
          if (tag !== 234) {
            break;
          }
          message.postId = reader.string();
          continue;
        case 30:
          if (tag !== 242) {
            break;
          }
          message.channelId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};

// dist/src/utils/ProtoUtils.js
function encodeVisitorData(id, timestamp) {
  const writer = VisitorData.encode({ id, timestamp });
  return encodeURIComponent(u8ToBase64(writer.finish()).replace(/\+/g, "-").replace(/\//g, "_"));
}
__name(encodeVisitorData, "encodeVisitorData");
function decodeVisitorData(visitor_data) {
  return VisitorData.decode(base64ToU8(decodeURIComponent(visitor_data).replace(/-/g, "+").replace(/_/g, "/")));
}
__name(decodeVisitorData, "decodeVisitorData");
function encodeCommentActionParams(type, args = {}) {
  const data = {
    type,
    commentId: args.comment_id || " ",
    videoId: args.video_id || " ",
    channelId: " ",
    unkNum: 2
  };
  if (args.hasOwnProperty("text")) {
    if (typeof args.target_language !== "string")
      throw new Error("target_language must be a string");
    if (args.comment_id)
      delete data.unkNum;
    data.translateCommentParams = {
      params: {
        comment: {
          text: args.text
        }
      },
      commentId: args.comment_id || " ",
      targetLanguage: args.target_language
    };
  }
  const writer = PeformCommentActionParams.encode(data);
  return encodeURIComponent(u8ToBase64(writer.finish()));
}
__name(encodeCommentActionParams, "encodeCommentActionParams");
function encodeNextParams(video_ids, playlist_title) {
  const writer = NextParams.encode({ videoId: video_ids, playlistTitle: playlist_title });
  return encodeURIComponent(u8ToBase64(writer.finish()).replace(/\+/g, "-").replace(/\//g, "_"));
}
__name(encodeNextParams, "encodeNextParams");

// dist/src/utils/javascript/helpers.js
var helpers_exports2 = {};
__export(helpers_exports2, {
  WALK_STOP: () => WALK_STOP,
  createWrapperFunction: () => createWrapperFunction,
  extractNodeSource: () => extractNodeSource,
  getNodeSourceRange: () => getNodeSourceRange,
  indent: () => indent,
  jsBuiltIns: () => jsBuiltIns,
  memberBaseName: () => memberBaseName,
  memberToString: () => memberToString,
  walkAst: () => walkAst
});
var WALK_STOP = Symbol("WALK_STOP");
var jsBuiltIns = /* @__PURE__ */ new Set([
  "AbortController",
  "AbortSignal",
  "Array",
  "ArrayBuffer",
  "AsyncContext",
  "Atomics",
  "AudioContext",
  "BigInt",
  "BigInt64Array",
  "BigUint64Array",
  "Blob",
  "Boolean",
  "BroadcastChannel",
  "Buffer",
  "CanvasRenderingContext2D",
  "clearImmediate",
  "clearInterval",
  "clearTimeout",
  "confirm",
  "console",
  "Crypto",
  "CustomEvent",
  "DataView",
  "Date",
  "decodeURI",
  "decodeURIComponent",
  "document",
  "Element",
  "encodeURI",
  "encodeURIComponent",
  "Error",
  "escape",
  "eval",
  "Event",
  "EventTarget",
  "fetch",
  "File",
  "FileReader",
  "Float32Array",
  "Float64Array",
  "FormData",
  "function",
  "global",
  "globalThis",
  "hasOwnProperty",
  "Headers",
  "History",
  "HTMLElement",
  "HTMLCollection",
  "IDBKeyRange",
  "Infinity",
  "Int16Array",
  "Int32Array",
  "Int8Array",
  "Intl",
  "IntersectionObserver",
  "isFinite",
  "isNaN",
  "isPrototypeOf",
  "JSON",
  "location",
  "log",
  "Map",
  "Math",
  "MediaRecorder",
  "MediaSource",
  "MediaStream",
  "MemberExpression",
  "MutationObserver",
  "NaN",
  "navigator",
  "Node",
  "NodeList",
  "Number",
  "Object",
  "OfflineAudioContext",
  "parse",
  "parseFloat",
  "parseInt",
  "Performance",
  "process",
  "Promise",
  "prompt",
  "prototype",
  "Proxy",
  "ReadableStream",
  "Reflect",
  "RegExp",
  "requestAnimationFrame",
  "requestIdleCallback",
  "Request",
  "Response",
  "ResizeObserver",
  "Screen",
  "setImmediate",
  "setInterval",
  "setTimeout",
  "SharedArrayBuffer",
  "SharedWorker",
  "SourceBuffer",
  "split",
  "String",
  "stringify",
  "structuredClone",
  "SubtleCrypto",
  "Symbol",
  "TextDecoder",
  "TextEncoder",
  "this",
  "toString",
  "TransformStream",
  "Uint16Array",
  "Uint32Array",
  "Uint8Array",
  "Uint8ClampedArray",
  "undefined",
  "unescape",
  "URL",
  "URLSearchParams",
  "valueOf",
  "WeakMap",
  "WeakSet",
  "WebAssembly",
  "WebGLRenderingContext",
  "window",
  "Worker",
  "WritableStream",
  "XMLHttpRequest",
  "alert",
  "arguments",
  "atob",
  "btoa",
  "cancelAnimationFrame",
  "cancelIdleCallback",
  "queueMicrotask"
]);
var indent = "  ";
function walkAst(root, visitor) {
  var _a, _b;
  if (!root || typeof root !== "object")
    return;
  const stack = [{ node: root, parent: null, exit: false }];
  const ancestors = [];
  const enter = typeof visitor === "function" ? visitor : (_a = visitor.enter) != null ? _a : null;
  const leave = typeof visitor === "function" ? null : (_b = visitor.leave) != null ? _b : null;
  let shouldStop = false;
  while (!shouldStop && stack.length > 0) {
    const frame = stack.pop();
    const { node, parent, exit } = frame;
    if (exit) {
      ancestors.pop();
      if (leave && leave(node, parent, ancestors) === WALK_STOP) {
        shouldStop = true;
      }
      continue;
    }
    if (!node || typeof node.type !== "string")
      continue;
    const result = enter ? enter(node, parent, ancestors) : void 0;
    if (result === WALK_STOP) {
      shouldStop = true;
      continue;
    }
    if (result === true)
      continue;
    stack.push({ node, parent, exit: true });
    ancestors.push(node);
    for (const key in node) {
      if (key === "loc" || key === "range" || key === "start" || key === "end")
        continue;
      if (!Object.prototype.hasOwnProperty.call(node, key))
        continue;
      const value = node[key];
      if (!value)
        continue;
      if (Array.isArray(value)) {
        for (let i = value.length - 1; i >= 0; i--) {
          const item = value[i];
          if (item && typeof item.type === "string") {
            stack.push({ node: item, parent: node, exit: false });
          }
        }
      } else if (typeof value === "object" && typeof value.type === "string") {
        stack.push({ node: value, parent: node, exit: false });
      }
    }
  }
}
__name(walkAst, "walkAst");
function getNodeSourceRange(node) {
  if (!node)
    return null;
  if (Array.isArray(node.range))
    return node.range;
  if (typeof node.start === "number" && typeof node.end === "number")
    return [node.start, node.end];
  return null;
}
__name(getNodeSourceRange, "getNodeSourceRange");
function extractNodeSource(node, source) {
  const range = getNodeSourceRange(node);
  return range ? source.slice(range[0], range[1]) : null;
}
__name(extractNodeSource, "extractNodeSource");
function memberToString(memberExpression, source) {
  if (memberExpression.type !== "MemberExpression")
    return null;
  const segments = [];
  let cur = memberExpression;
  while (cur && cur.type === "MemberExpression") {
    const member = cur;
    const prop = member.property;
    if (!prop)
      return null;
    if (member.computed) {
      const propSource = extractNodeSource(prop, source);
      if (!propSource)
        return null;
      segments.unshift(`[${propSource.trim()}]`);
    } else {
      if (prop.type !== "Identifier")
        return null;
      segments.unshift(`.${prop.name}`);
    }
    cur = member.object;
  }
  let base = null;
  if ((cur == null ? void 0 : cur.type) === "Identifier") {
    base = cur.name;
  } else if ((cur == null ? void 0 : cur.type) === "ThisExpression") {
    base = "this";
  }
  return base ? base + segments.join("") : null;
}
__name(memberToString, "memberToString");
function memberBaseName(memberExpression, source) {
  let target = memberExpression.object;
  while (target && target.type === "MemberExpression") {
    const parentName = memberToString(target, source);
    if (parentName)
      return parentName;
    target = target.object;
  }
  if ((target == null ? void 0 : target.type) === "Identifier")
    return target.name;
  if ((target == null ? void 0 : target.type) === "ThisExpression")
    return "this";
  return null;
}
__name(memberBaseName, "memberBaseName");
function createWrapperFunction(analyzer, name, node) {
  var _a;
  if (node.type === "CallExpression" && node.callee.type === "Identifier" && analyzer.declaredVariables.has(node.callee.name)) {
    return generateWrapper(name, node.callee.name, parseFunctionArguments(analyzer, node.arguments));
  } else if (node.type === "VariableDeclarator" && ((_a = node.init) == null ? void 0 : _a.type) === "FunctionExpression" && node.id.type === "Identifier") {
    return generateWrapper(name, node.id.name, parseFunctionArguments(analyzer, node.init.params));
  }
}
__name(createWrapperFunction, "createWrapperFunction");
function generateWrapper(functionName, targetFunction, args) {
  return [
    `${indent}function ${functionName}(input) {`,
    `${indent}${indent}return ${targetFunction}(${args});`,
    `${indent}}`
  ].join("\n");
}
__name(generateWrapper, "generateWrapper");
function parseFunctionArguments(analyzer, args) {
  const params = [];
  for (const arg of args) {
    if (arg.type === "Identifier" && analyzer.declaredVariables.has(arg.name)) {
      params.push(arg.name);
    } else if (arg.type === "Literal" && (typeof arg.value === "string" || typeof arg.value === "number")) {
      params.push(JSON.stringify(arg.value));
    } else if (!params.includes("input"))
      params.push("input");
  }
  return params.join(", ");
}
__name(parseFunctionArguments, "parseFunctionArguments");

// dist/src/utils/javascript/matchers.js
var matchers_exports = {};
__export(matchers_exports, {
  nMatcher: () => nMatcher,
  sigMatcher: () => sigMatcher,
  timestampMatcher: () => timestampMatcher
});
function sigMatcher(node) {
  var _a;
  if (node.type === "VariableDeclarator" && ((_a = node.id) == null ? void 0 : _a.type) === "Identifier") {
    const idNode = node.id;
    const initNode = node.init;
    if (idNode.type === "Identifier" && (initNode == null ? void 0 : initNode.type) === "FunctionExpression" && initNode.params.length === 3) {
      const functionInitNode = initNode.body;
      if (!functionInitNode || functionInitNode.type !== "BlockStatement")
        return false;
      for (const st of functionInitNode.body) {
        if ((st == null ? void 0 : st.type) === "ExpressionStatement") {
          const expression = st.expression;
          if (expression.type === "LogicalExpression" && expression.operator === "&&" && expression.left.type === "Identifier" && expression.right.type === "SequenceExpression") {
            const firstExp = expression.right.expressions[0];
            if (firstExp.type === "AssignmentExpression" && firstExp.operator === "=" && firstExp.left.type === "Identifier" && firstExp.right.type === "CallExpression" && firstExp.right.callee.type === "Identifier") {
              const rightArguments = firstExp.right.arguments;
              if (rightArguments.length >= 1) {
                const callExpression = rightArguments.find((exp) => exp.type === "CallExpression");
                if ((callExpression == null ? void 0 : callExpression.type) === "CallExpression" && (callExpression == null ? void 0 : callExpression.callee.type) === "Identifier" && callExpression.callee.name === "decodeURIComponent" && callExpression.arguments[0].type === "Identifier") {
                  return firstExp.right;
                }
              }
            }
          }
        }
      }
    }
  }
  return false;
}
__name(sigMatcher, "sigMatcher");
function nMatcher(node) {
  var _a, _b;
  if (node.type !== "VariableDeclarator")
    return false;
  if (node.id.type === "Identifier" && ((_a = node.init) == null ? void 0 : _a.type) === "ArrayExpression" && ((_b = node.init.elements[0]) == null ? void 0 : _b.type) === "Identifier") {
    return node.init.elements[0];
  }
  return false;
}
__name(nMatcher, "nMatcher");
function timestampMatcher(node) {
  var _a;
  if (node.type !== "VariableDeclarator" || ((_a = node.init) == null ? void 0 : _a.type) !== "FunctionExpression") {
    return false;
  }
  const funcBody = node.init.body;
  if (!funcBody)
    return false;
  let foundObject = null;
  walkAst(funcBody, (innerNode) => {
    if (innerNode.type === "ObjectExpression") {
      for (const prop of innerNode.properties) {
        if (prop.type === "Property" && prop.key.type === "Identifier" && prop.key.name === "signatureTimestamp") {
          foundObject = prop;
          return WALK_STOP;
        }
      }
    }
  });
  return foundObject || false;
}
__name(timestampMatcher, "timestampMatcher");

// node_modules/meriyah/dist/meriyah.mjs
var unicodeLookup = ((compressed, lookup) => {
  const result = new Uint32Array(69632);
  let index = 0;
  let subIndex = 0;
  while (index < 2571) {
    const inst = compressed[index++];
    if (inst < 0) {
      subIndex -= inst;
    } else {
      let code = compressed[index++];
      if (inst & 2)
        code = lookup[code];
      if (inst & 1) {
        result.fill(code, subIndex, subIndex += compressed[index++]);
      } else {
        result[subIndex++] = code;
      }
    }
  }
  return result;
})([-1, 2, 26, 2, 27, 2, 5, -1, 0, 77595648, 3, 44, 2, 3, 0, 14, 2, 63, 2, 64, 3, 0, 3, 0, 3168796671, 0, 4294956992, 2, 1, 2, 0, 2, 41, 3, 0, 4, 0, 4294966523, 3, 0, 4, 2, 16, 2, 65, 2, 0, 0, 4294836735, 0, 3221225471, 0, 4294901942, 2, 66, 0, 134152192, 3, 0, 2, 0, 4294951935, 3, 0, 2, 0, 2683305983, 0, 2684354047, 2, 18, 2, 0, 0, 4294961151, 3, 0, 2, 2, 19, 2, 0, 0, 608174079, 2, 0, 2, 60, 2, 7, 2, 6, 0, 4286611199, 3, 0, 2, 2, 1, 3, 0, 3, 0, 4294901711, 2, 40, 0, 4089839103, 0, 2961209759, 0, 1342439375, 0, 4294543342, 0, 3547201023, 0, 1577204103, 0, 4194240, 0, 4294688750, 2, 2, 0, 80831, 0, 4261478351, 0, 4294549486, 2, 2, 0, 2967484831, 0, 196559, 0, 3594373100, 0, 3288319768, 0, 8469959, 0, 65472, 2, 3, 0, 4093640191, 0, 660618719, 0, 65487, 0, 4294828015, 0, 4092591615, 0, 1616920031, 0, 982991, 2, 3, 2, 0, 0, 2163244511, 0, 4227923919, 0, 4236247022, 2, 71, 0, 4284449919, 0, 851904, 2, 4, 2, 12, 0, 67076095, -1, 2, 72, 0, 1073741743, 0, 4093607775, -1, 0, 50331649, 0, 3265266687, 2, 33, 0, 4294844415, 0, 4278190047, 2, 20, 2, 137, -1, 3, 0, 2, 2, 23, 2, 0, 2, 10, 2, 0, 2, 15, 2, 22, 3, 0, 10, 2, 74, 2, 0, 2, 75, 2, 76, 2, 77, 2, 0, 2, 78, 2, 0, 2, 11, 0, 261632, 2, 25, 3, 0, 2, 2, 13, 2, 4, 3, 0, 18, 2, 79, 2, 5, 3, 0, 2, 2, 80, 0, 2151677951, 2, 29, 2, 9, 0, 909311, 3, 0, 2, 0, 814743551, 2, 49, 0, 67090432, 3, 0, 2, 2, 42, 2, 0, 2, 6, 2, 0, 2, 30, 2, 8, 0, 268374015, 2, 110, 2, 51, 2, 0, 2, 81, 0, 134153215, -1, 2, 7, 2, 0, 2, 8, 0, 2684354559, 0, 67044351, 0, 3221160064, 2, 17, -1, 3, 0, 2, 2, 53, 0, 1046528, 3, 0, 3, 2, 9, 2, 0, 2, 54, 0, 4294960127, 2, 10, 2, 6, 2, 11, 0, 4294377472, 2, 12, 3, 0, 16, 2, 13, 2, 0, 2, 82, 2, 10, 2, 0, 2, 83, 2, 84, 2, 85, 0, 12288, 2, 55, 0, 1048577, 2, 86, 2, 14, -1, 2, 14, 0, 131042, 2, 87, 2, 88, 2, 89, 2, 0, 2, 34, -83, 3, 0, 7, 0, 1046559, 2, 0, 2, 15, 2, 0, 0, 2147516671, 2, 21, 3, 90, 2, 2, 0, -16, 2, 91, 0, 524222462, 2, 4, 2, 0, 0, 4269801471, 2, 4, 3, 0, 2, 2, 28, 2, 16, 3, 0, 2, 2, 17, 2, 0, -1, 2, 18, -16, 3, 0, 206, -2, 3, 0, 692, 2, 73, -1, 2, 18, 2, 10, 3, 0, 8, 2, 93, 2, 133, 2, 0, 0, 3220242431, 3, 0, 3, 2, 19, 2, 94, 2, 95, 3, 0, 2, 2, 96, 2, 0, 2, 97, 2, 46, 2, 0, 0, 4351, 2, 0, 2, 9, 3, 0, 2, 0, 67043391, 0, 3909091327, 2, 0, 2, 24, 2, 9, 2, 20, 3, 0, 2, 0, 67076097, 2, 8, 2, 0, 2, 21, 0, 67059711, 0, 4236247039, 3, 0, 2, 0, 939524103, 0, 8191999, 2, 101, 2, 102, 2, 22, 2, 23, 3, 0, 3, 0, 67057663, 3, 0, 349, 2, 103, 2, 104, 2, 7, -264, 3, 0, 11, 2, 24, 3, 0, 2, 2, 32, -1, 0, 3774349439, 2, 105, 2, 106, 3, 0, 2, 2, 19, 2, 107, 3, 0, 10, 2, 10, 2, 18, 2, 0, 2, 47, 2, 0, 2, 31, 2, 108, 2, 25, 0, 1638399, 0, 57344, 2, 109, 3, 0, 3, 2, 20, 2, 26, 2, 27, 2, 5, 2, 28, 2, 0, 2, 8, 2, 111, -1, 2, 112, 2, 113, 2, 114, -1, 3, 0, 3, 2, 12, -2, 2, 0, 2, 29, -3, 0, 536870912, -4, 2, 20, 2, 0, 2, 36, 0, 1, 2, 0, 2, 67, 2, 6, 2, 12, 2, 10, 2, 0, 2, 115, -1, 3, 0, 4, 2, 10, 2, 23, 2, 116, 2, 7, 2, 0, 2, 117, 2, 0, 2, 118, 2, 119, 2, 120, 2, 0, 2, 9, 3, 0, 9, 2, 21, 2, 30, 2, 31, 2, 121, 2, 122, -2, 2, 123, 2, 124, 2, 30, 2, 21, 2, 8, -2, 2, 125, 2, 30, 2, 32, -2, 2, 0, 2, 39, -2, 0, 4277137519, 0, 2269118463, -1, 3, 20, 2, -1, 2, 33, 2, 38, 2, 0, 3, 30, 2, 2, 35, 2, 19, -3, 3, 0, 2, 2, 34, -1, 2, 0, 2, 35, 2, 0, 2, 35, 2, 0, 2, 48, 2, 0, 0, 4294950463, 2, 37, -7, 2, 0, 0, 203775, 2, 57, 0, 4026531840, 2, 20, 2, 43, 2, 36, 2, 18, 2, 37, 2, 18, 2, 126, 2, 21, 3, 0, 2, 2, 38, 0, 2151677888, 2, 0, 2, 12, 0, 4294901764, 2, 144, 2, 0, 2, 58, 2, 56, 0, 5242879, 3, 0, 2, 0, 402644511, -1, 2, 128, 2, 39, 0, 3, -1, 2, 129, 2, 130, 2, 0, 0, 67045375, 2, 40, 0, 4226678271, 0, 3766565279, 0, 2039759, 2, 132, 2, 41, 0, 1046437, 0, 6, 3, 0, 2, 0, 3288270847, 0, 3, 3, 0, 2, 0, 67043519, -5, 2, 0, 0, 4282384383, 0, 1056964609, -1, 3, 0, 2, 0, 67043345, -1, 2, 0, 2, 42, 2, 23, 2, 50, 2, 11, 2, 61, 2, 38, -5, 2, 0, 2, 12, -3, 3, 0, 2, 0, 2147484671, 2, 134, 0, 4190109695, 2, 52, -2, 2, 135, 0, 4244635647, 0, 27, 2, 0, 2, 8, 2, 43, 2, 0, 2, 68, 2, 18, 2, 0, 2, 42, -6, 2, 0, 2, 45, 2, 59, 2, 44, 2, 45, 2, 46, 2, 47, 0, 8388351, -2, 2, 136, 0, 3028287487, 2, 48, 2, 138, 0, 33259519, 2, 49, -9, 2, 21, 0, 4294836223, 0, 3355443199, 0, 134152199, -2, 2, 69, -2, 3, 0, 28, 2, 32, -3, 3, 0, 3, 2, 17, 3, 0, 6, 2, 50, -81, 2, 18, 3, 0, 2, 2, 36, 3, 0, 33, 2, 25, 2, 30, 3, 0, 124, 2, 12, 3, 0, 18, 2, 38, -213, 2, 0, 2, 32, -54, 3, 0, 17, 2, 42, 2, 8, 2, 23, 2, 0, 2, 8, 2, 23, 2, 51, 2, 0, 2, 21, 2, 52, 2, 139, 2, 25, -13, 2, 0, 2, 53, -6, 3, 0, 2, -4, 3, 0, 2, 0, 4294936575, 2, 0, 0, 4294934783, -2, 0, 196635, 3, 0, 191, 2, 54, 3, 0, 38, 2, 30, 2, 55, 2, 34, -278, 2, 140, 3, 0, 9, 2, 141, 2, 142, 2, 56, 3, 0, 11, 2, 7, -72, 3, 0, 3, 2, 143, 0, 1677656575, -130, 2, 26, -16, 2, 0, 2, 24, 2, 38, -16, 0, 4161266656, 0, 4071, 0, 15360, -4, 2, 57, -13, 3, 0, 2, 2, 58, 2, 0, 2, 145, 2, 146, 2, 62, 2, 0, 2, 147, 2, 148, 2, 149, 3, 0, 10, 2, 150, 2, 151, 2, 22, 3, 58, 2, 3, 152, 2, 3, 59, 2, 0, 4294954999, 2, 0, -16, 2, 0, 2, 92, 2, 0, 0, 2105343, 0, 4160749584, 0, 65534, -34, 2, 8, 2, 154, -6, 0, 4194303871, 0, 4294903771, 2, 0, 2, 60, 2, 100, -3, 2, 0, 0, 1073684479, 0, 17407, -9, 2, 18, 2, 17, 2, 0, 2, 32, -14, 2, 18, 2, 32, -6, 2, 18, 2, 12, -15, 2, 155, 3, 0, 6, 0, 8323103, -1, 3, 0, 2, 2, 61, -37, 2, 62, 2, 156, 2, 157, 2, 158, 2, 159, 2, 160, -105, 2, 26, -32, 3, 0, 1335, -1, 3, 0, 129, 2, 32, 3, 0, 6, 2, 10, 3, 0, 180, 2, 161, 3, 0, 233, 2, 162, 3, 0, 18, 2, 10, -77, 3, 0, 16, 2, 10, -47, 3, 0, 154, 2, 6, 3, 0, 130, 2, 25, -22250, 3, 0, 7, 2, 25, -6130, 3, 5, 2, -1, 0, 69207040, 3, 44, 2, 3, 0, 14, 2, 63, 2, 64, -3, 0, 3168731136, 0, 4294956864, 2, 1, 2, 0, 2, 41, 3, 0, 4, 0, 4294966275, 3, 0, 4, 2, 16, 2, 65, 2, 0, 2, 34, -1, 2, 18, 2, 66, -1, 2, 0, 0, 2047, 0, 4294885376, 3, 0, 2, 0, 3145727, 0, 2617294944, 0, 4294770688, 2, 25, 2, 67, 3, 0, 2, 0, 131135, 2, 98, 0, 70256639, 0, 71303167, 0, 272, 2, 42, 2, 6, 0, 32511, 2, 0, 2, 49, -1, 2, 99, 2, 68, 0, 4278255616, 0, 4294836227, 0, 4294549473, 0, 600178175, 0, 2952806400, 0, 268632067, 0, 4294543328, 0, 57540095, 0, 1577058304, 0, 1835008, 0, 4294688736, 2, 70, 2, 69, 0, 33554435, 2, 131, 2, 70, 0, 2952790016, 0, 131075, 0, 3594373096, 0, 67094296, 2, 69, -1, 0, 4294828e3, 0, 603979263, 0, 654311424, 0, 3, 0, 4294828001, 0, 602930687, 0, 1610612736, 0, 393219, 0, 4294828016, 0, 671088639, 0, 2154840064, 0, 4227858435, 0, 4236247008, 2, 71, 2, 38, -1, 2, 4, 0, 917503, 2, 38, -1, 2, 72, 0, 537788335, 0, 4026531935, -1, 0, 1, -1, 2, 33, 2, 73, 0, 7936, -3, 2, 0, 0, 2147485695, 0, 1010761728, 0, 4292984930, 0, 16387, 2, 0, 2, 15, 2, 22, 3, 0, 10, 2, 74, 2, 0, 2, 75, 2, 76, 2, 77, 2, 0, 2, 78, 2, 0, 2, 12, -1, 2, 25, 3, 0, 2, 2, 13, 2, 4, 3, 0, 18, 2, 79, 2, 5, 3, 0, 2, 2, 80, 0, 2147745791, 3, 19, 2, 0, 122879, 2, 0, 2, 9, 0, 276824064, -2, 3, 0, 2, 2, 42, 2, 0, 0, 4294903295, 2, 0, 2, 30, 2, 8, -1, 2, 18, 2, 51, 2, 0, 2, 81, 2, 49, -1, 2, 21, 2, 0, 2, 29, -2, 0, 128, -2, 2, 28, 2, 9, 0, 8160, -1, 2, 127, 0, 4227907585, 2, 0, 2, 37, 2, 0, 2, 50, 0, 4227915776, 2, 10, 2, 6, 2, 11, -1, 0, 74440192, 3, 0, 6, -2, 3, 0, 8, 2, 13, 2, 0, 2, 82, 2, 10, 2, 0, 2, 83, 2, 84, 2, 85, -3, 2, 86, 2, 14, -3, 2, 87, 2, 88, 2, 89, 2, 0, 2, 34, -83, 3, 0, 7, 0, 817183, 2, 0, 2, 15, 2, 0, 0, 33023, 2, 21, 3, 90, 2, -17, 2, 91, 0, 524157950, 2, 4, 2, 0, 2, 92, 2, 4, 2, 0, 2, 22, 2, 28, 2, 16, 3, 0, 2, 2, 17, 2, 0, -1, 2, 18, -16, 3, 0, 206, -2, 3, 0, 692, 2, 73, -1, 2, 18, 2, 10, 3, 0, 8, 2, 93, 0, 3072, 2, 0, 0, 2147516415, 2, 10, 3, 0, 2, 2, 25, 2, 94, 2, 95, 3, 0, 2, 2, 96, 2, 0, 2, 97, 2, 46, 0, 4294965179, 0, 7, 2, 0, 2, 9, 2, 95, 2, 9, -1, 0, 1761345536, 2, 98, 0, 4294901823, 2, 38, 2, 20, 2, 99, 2, 35, 2, 100, 0, 2080440287, 2, 0, 2, 34, 2, 153, 0, 3296722943, 2, 0, 0, 1046675455, 0, 939524101, 0, 1837055, 2, 101, 2, 102, 2, 22, 2, 23, 3, 0, 3, 0, 7, 3, 0, 349, 2, 103, 2, 104, 2, 7, -264, 3, 0, 11, 2, 24, 3, 0, 2, 2, 32, -1, 0, 2700607615, 2, 105, 2, 106, 3, 0, 2, 2, 19, 2, 107, 3, 0, 10, 2, 10, 2, 18, 2, 0, 2, 47, 2, 0, 2, 31, 2, 108, -3, 2, 109, 3, 0, 3, 2, 20, -1, 3, 5, 2, 2, 110, 2, 0, 2, 8, 2, 111, -1, 2, 112, 2, 113, 2, 114, -1, 3, 0, 3, 2, 12, -2, 2, 0, 2, 29, -8, 2, 20, 2, 0, 2, 36, -1, 2, 0, 2, 67, 2, 6, 2, 30, 2, 10, 2, 0, 2, 115, -1, 3, 0, 4, 2, 10, 2, 18, 2, 116, 2, 7, 2, 0, 2, 117, 2, 0, 2, 118, 2, 119, 2, 120, 2, 0, 2, 9, 3, 0, 9, 2, 21, 2, 30, 2, 31, 2, 121, 2, 122, -2, 2, 123, 2, 124, 2, 30, 2, 21, 2, 8, -2, 2, 125, 2, 30, 2, 32, -2, 2, 0, 2, 39, -2, 0, 4277075969, 2, 30, -1, 3, 20, 2, -1, 2, 33, 2, 126, 2, 0, 3, 30, 2, 2, 35, 2, 19, -3, 3, 0, 2, 2, 34, -1, 2, 0, 2, 35, 2, 0, 2, 35, 2, 0, 2, 50, 2, 98, 0, 4294934591, 2, 37, -7, 2, 0, 0, 197631, 2, 57, -1, 2, 20, 2, 43, 2, 37, 2, 18, 0, 3, 2, 18, 2, 126, 2, 21, 2, 127, 2, 54, -1, 0, 2490368, 2, 127, 2, 25, 2, 18, 2, 34, 2, 127, 2, 38, 0, 4294901904, 0, 4718591, 2, 127, 2, 35, 0, 335544350, -1, 2, 128, 0, 2147487743, 0, 1, -1, 2, 129, 2, 130, 2, 8, -1, 2, 131, 2, 70, 0, 3758161920, 0, 3, 2, 132, 0, 12582911, 0, 655360, -1, 2, 0, 2, 29, 0, 2147485568, 0, 3, 2, 0, 2, 25, 0, 176, -5, 2, 0, 2, 17, 0, 251658240, -1, 2, 0, 2, 25, 0, 16, -1, 2, 0, 0, 16779263, -2, 2, 12, -1, 2, 38, -5, 2, 0, 2, 133, -3, 3, 0, 2, 2, 55, 2, 134, 0, 2147549183, 0, 2, -2, 2, 135, 2, 36, 0, 10, 0, 4294965249, 0, 67633151, 0, 4026597376, 2, 0, 0, 536871935, 2, 18, 2, 0, 2, 42, -6, 2, 0, 0, 1, 2, 59, 2, 17, 0, 1, 2, 46, 2, 25, -3, 2, 136, 2, 36, 2, 137, 2, 138, 0, 16778239, -10, 2, 35, 0, 4294836212, 2, 9, -3, 2, 69, -2, 3, 0, 28, 2, 32, -3, 3, 0, 3, 2, 17, 3, 0, 6, 2, 50, -81, 2, 18, 3, 0, 2, 2, 36, 3, 0, 33, 2, 25, 0, 126, 3, 0, 124, 2, 12, 3, 0, 18, 2, 38, -213, 2, 10, -55, 3, 0, 17, 2, 42, 2, 8, 2, 18, 2, 0, 2, 8, 2, 18, 2, 60, 2, 0, 2, 25, 2, 50, 2, 139, 2, 25, -13, 2, 0, 2, 73, -6, 3, 0, 2, -4, 3, 0, 2, 0, 67583, -1, 2, 107, -2, 0, 11, 3, 0, 191, 2, 54, 3, 0, 38, 2, 30, 2, 55, 2, 34, -278, 2, 140, 3, 0, 9, 2, 141, 2, 142, 2, 56, 3, 0, 11, 2, 7, -72, 3, 0, 3, 2, 143, 2, 144, -187, 3, 0, 2, 2, 58, 2, 0, 2, 145, 2, 146, 2, 62, 2, 0, 2, 147, 2, 148, 2, 149, 3, 0, 10, 2, 150, 2, 151, 2, 22, 3, 58, 2, 3, 152, 2, 3, 59, 2, 2, 153, -57, 2, 8, 2, 154, -7, 2, 18, 2, 0, 2, 60, -4, 2, 0, 0, 1065361407, 0, 16384, -9, 2, 18, 2, 60, 2, 0, 2, 133, -14, 2, 18, 2, 133, -6, 2, 18, 0, 81919, -15, 2, 155, 3, 0, 6, 2, 126, -1, 3, 0, 2, 0, 2063, -37, 2, 62, 2, 156, 2, 157, 2, 158, 2, 159, 2, 160, -138, 3, 0, 1335, -1, 3, 0, 129, 2, 32, 3, 0, 6, 2, 10, 3, 0, 180, 2, 161, 3, 0, 233, 2, 162, 3, 0, 18, 2, 10, -77, 3, 0, 16, 2, 10, -47, 3, 0, 154, 2, 6, 3, 0, 130, 2, 25, -28386], [4294967295, 4294967291, 4092460543, 4294828031, 4294967294, 134217726, 4294903807, 268435455, 2147483647, 1048575, 1073741823, 3892314111, 134217727, 1061158911, 536805376, 4294910143, 4294901759, 32767, 4294901760, 262143, 536870911, 8388607, 4160749567, 4294902783, 4294918143, 65535, 67043328, 2281701374, 4294967264, 2097151, 4194303, 255, 67108863, 4294967039, 511, 524287, 131071, 63, 127, 3238002687, 4294549487, 4290772991, 33554431, 4294901888, 4286578687, 67043329, 4294705152, 4294770687, 67043583, 1023, 15, 2047999, 67043343, 67051519, 16777215, 2147483648, 4294902e3, 28, 4292870143, 4294966783, 16383, 67047423, 4294967279, 262083, 20511, 41943039, 493567, 4294959104, 603979775, 65536, 602799615, 805044223, 4294965206, 8191, 1031749119, 4294917631, 2134769663, 4286578493, 4282253311, 4294942719, 33540095, 4294905855, 2868854591, 1608515583, 265232348, 534519807, 2147614720, 1060109444, 4093640016, 17376, 2139062143, 224, 4169138175, 4294909951, 4286578688, 4294967292, 4294965759, 535511039, 4294966272, 4294967280, 32768, 8289918, 4294934399, 4294901775, 4294965375, 1602223615, 4294967259, 4294443008, 268369920, 4292804608, 4294967232, 486341884, 4294963199, 3087007615, 1073692671, 4128527, 4279238655, 4294902015, 4160684047, 4290246655, 469499899, 4294967231, 134086655, 4294966591, 2445279231, 3670015, 31, 4294967288, 4294705151, 3221208447, 4294902271, 4294549472, 4294921215, 4095, 4285526655, 4294966527, 4294966143, 64, 4294966719, 3774873592, 1877934080, 262151, 2555904, 536807423, 67043839, 3758096383, 3959414372, 3755993023, 2080374783, 4294835295, 4294967103, 4160749565, 4294934527, 4087, 2016, 2147446655, 184024726, 2862017156, 1593309078, 268434431, 268434414, 4294901763, 4294901761]);
var isIDContinue = /* @__PURE__ */ __name((code) => (unicodeLookup[(code >>> 5) + 0] >>> code & 31 & 1) !== 0, "isIDContinue");
var isIDStart = /* @__PURE__ */ __name((code) => (unicodeLookup[(code >>> 5) + 34816] >>> code & 31 & 1) !== 0, "isIDStart");
function advanceChar(parser) {
  parser.column++;
  return parser.currentChar = parser.source.charCodeAt(++parser.index);
}
__name(advanceChar, "advanceChar");
function consumePossibleSurrogatePair(parser) {
  const hi = parser.currentChar;
  if ((hi & 64512) !== 55296)
    return 0;
  const lo = parser.source.charCodeAt(parser.index + 1);
  if ((lo & 64512) !== 56320)
    return 0;
  return 65536 + ((hi & 1023) << 10) + (lo & 1023);
}
__name(consumePossibleSurrogatePair, "consumePossibleSurrogatePair");
function consumeLineFeed(parser, state) {
  parser.currentChar = parser.source.charCodeAt(++parser.index);
  parser.flags |= 1;
  if ((state & 4) === 0) {
    parser.column = 0;
    parser.line++;
  }
}
__name(consumeLineFeed, "consumeLineFeed");
function scanNewLine(parser) {
  parser.flags |= 1;
  parser.currentChar = parser.source.charCodeAt(++parser.index);
  parser.column = 0;
  parser.line++;
}
__name(scanNewLine, "scanNewLine");
function isExoticECMAScriptWhitespace(ch) {
  return ch === 160 || ch === 65279 || ch === 133 || ch === 5760 || ch >= 8192 && ch <= 8203 || ch === 8239 || ch === 8287 || ch === 12288 || ch === 8201 || ch === 65519;
}
__name(isExoticECMAScriptWhitespace, "isExoticECMAScriptWhitespace");
function toHex(code) {
  return code < 65 ? code - 48 : code - 65 + 10 & 15;
}
__name(toHex, "toHex");
function convertTokenType(t) {
  switch (t) {
    case 134283266:
      return "NumericLiteral";
    case 134283267:
      return "StringLiteral";
    case 86021:
    case 86022:
      return "BooleanLiteral";
    case 86023:
      return "NullLiteral";
    case 65540:
      return "RegularExpression";
    case 67174408:
    case 67174409:
    case 131:
      return "TemplateLiteral";
    default:
      if ((t & 143360) === 143360)
        return "Identifier";
      if ((t & 4096) === 4096)
        return "Keyword";
      return "Punctuator";
  }
}
__name(convertTokenType, "convertTokenType");
var CharTypes = [
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  8 | 1024,
  0,
  0,
  8 | 2048,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  8192,
  0,
  1 | 2,
  0,
  0,
  8192,
  0,
  0,
  0,
  256,
  0,
  256 | 32768,
  0,
  0,
  2 | 16 | 128 | 32 | 64,
  2 | 16 | 128 | 32 | 64,
  2 | 16 | 32 | 64,
  2 | 16 | 32 | 64,
  2 | 16 | 32 | 64,
  2 | 16 | 32 | 64,
  2 | 16 | 32 | 64,
  2 | 16 | 32 | 64,
  2 | 16 | 512 | 64,
  2 | 16 | 512 | 64,
  0,
  0,
  16384,
  0,
  0,
  0,
  0,
  1 | 2 | 64,
  1 | 2 | 64,
  1 | 2 | 64,
  1 | 2 | 64,
  1 | 2 | 64,
  1 | 2 | 64,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  1 | 2,
  0,
  1,
  0,
  0,
  1 | 2 | 4096,
  0,
  1 | 2 | 4 | 64,
  1 | 2 | 4 | 64,
  1 | 2 | 4 | 64,
  1 | 2 | 4 | 64,
  1 | 2 | 4 | 64,
  1 | 2 | 4 | 64,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  1 | 2 | 4,
  16384,
  0,
  0,
  0,
  0
];
var isIdStart = [
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  0,
  0,
  1,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  0,
  0,
  0
];
var isIdPart = [
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  0,
  0,
  1,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  0,
  0,
  0
];
function isIdentifierStart(code) {
  return code <= 127 ? isIdStart[code] > 0 : isIDStart(code);
}
__name(isIdentifierStart, "isIdentifierStart");
function isIdentifierPart(code) {
  return code <= 127 ? isIdPart[code] > 0 : isIDContinue(code) || (code === 8204 || code === 8205);
}
__name(isIdentifierPart, "isIdentifierPart");
var CommentTypes = ["SingleLine", "MultiLine", "HTMLOpen", "HTMLClose", "HashbangComment"];
function skipHashBang(parser) {
  const { source } = parser;
  if (parser.currentChar === 35 && source.charCodeAt(parser.index + 1) === 33) {
    advanceChar(parser);
    advanceChar(parser);
    skipSingleLineComment(parser, source, 0, 4, parser.tokenStart);
  }
}
__name(skipHashBang, "skipHashBang");
function skipSingleHTMLComment(parser, source, state, context, type, start) {
  if (context & 2)
    parser.report(0);
  return skipSingleLineComment(parser, source, state, type, start);
}
__name(skipSingleHTMLComment, "skipSingleHTMLComment");
function skipSingleLineComment(parser, source, state, type, start) {
  const { index } = parser;
  parser.tokenIndex = parser.index;
  parser.tokenLine = parser.line;
  parser.tokenColumn = parser.column;
  while (parser.index < parser.end) {
    if (CharTypes[parser.currentChar] & 8) {
      const isCR = parser.currentChar === 13;
      scanNewLine(parser);
      if (isCR && parser.index < parser.end && parser.currentChar === 10)
        parser.currentChar = source.charCodeAt(++parser.index);
      break;
    } else if ((parser.currentChar ^ 8232) <= 1) {
      scanNewLine(parser);
      break;
    }
    advanceChar(parser);
    parser.tokenIndex = parser.index;
    parser.tokenLine = parser.line;
    parser.tokenColumn = parser.column;
  }
  if (parser.options.onComment) {
    const loc = {
      start: {
        line: start.line,
        column: start.column
      },
      end: {
        line: parser.tokenLine,
        column: parser.tokenColumn
      }
    };
    parser.options.onComment(CommentTypes[type & 255], source.slice(index, parser.tokenIndex), start.index, parser.tokenIndex, loc);
  }
  return state | 1;
}
__name(skipSingleLineComment, "skipSingleLineComment");
function skipMultiLineComment(parser, source, state) {
  const { index } = parser;
  while (parser.index < parser.end) {
    if (parser.currentChar < 43) {
      let skippedOneAsterisk = false;
      while (parser.currentChar === 42) {
        if (!skippedOneAsterisk) {
          state &= -5;
          skippedOneAsterisk = true;
        }
        if (advanceChar(parser) === 47) {
          advanceChar(parser);
          if (parser.options.onComment) {
            const loc = {
              start: {
                line: parser.tokenLine,
                column: parser.tokenColumn
              },
              end: {
                line: parser.line,
                column: parser.column
              }
            };
            parser.options.onComment(CommentTypes[1 & 255], source.slice(index, parser.index - 2), index - 2, parser.index, loc);
          }
          parser.tokenIndex = parser.index;
          parser.tokenLine = parser.line;
          parser.tokenColumn = parser.column;
          return state;
        }
      }
      if (skippedOneAsterisk) {
        continue;
      }
      if (CharTypes[parser.currentChar] & 8) {
        if (parser.currentChar === 13) {
          state |= 1 | 4;
          scanNewLine(parser);
        } else {
          consumeLineFeed(parser, state);
          state = state & -5 | 1;
        }
      } else {
        advanceChar(parser);
      }
    } else if ((parser.currentChar ^ 8232) <= 1) {
      state = state & -5 | 1;
      scanNewLine(parser);
    } else {
      state &= -5;
      advanceChar(parser);
    }
  }
  parser.report(18);
}
__name(skipMultiLineComment, "skipMultiLineComment");
var RegexState;
(function(RegexState2) {
  RegexState2[RegexState2["Empty"] = 0] = "Empty";
  RegexState2[RegexState2["Escape"] = 1] = "Escape";
  RegexState2[RegexState2["Class"] = 2] = "Class";
})(RegexState || (RegexState = {}));
var RegexFlags;
(function(RegexFlags2) {
  RegexFlags2[RegexFlags2["Empty"] = 0] = "Empty";
  RegexFlags2[RegexFlags2["IgnoreCase"] = 1] = "IgnoreCase";
  RegexFlags2[RegexFlags2["Global"] = 2] = "Global";
  RegexFlags2[RegexFlags2["Multiline"] = 4] = "Multiline";
  RegexFlags2[RegexFlags2["Unicode"] = 16] = "Unicode";
  RegexFlags2[RegexFlags2["Sticky"] = 8] = "Sticky";
  RegexFlags2[RegexFlags2["DotAll"] = 32] = "DotAll";
  RegexFlags2[RegexFlags2["Indices"] = 64] = "Indices";
  RegexFlags2[RegexFlags2["UnicodeSets"] = 128] = "UnicodeSets";
})(RegexFlags || (RegexFlags = {}));
function scanRegularExpression(parser) {
  const bodyStart = parser.index;
  let preparseState = RegexState.Empty;
  loop: while (true) {
    const ch = parser.currentChar;
    advanceChar(parser);
    if (preparseState & RegexState.Escape) {
      preparseState &= ~RegexState.Escape;
    } else {
      switch (ch) {
        case 47:
          if (!preparseState)
            break loop;
          else
            break;
        case 92:
          preparseState |= RegexState.Escape;
          break;
        case 91:
          preparseState |= RegexState.Class;
          break;
        case 93:
          preparseState &= RegexState.Escape;
          break;
      }
    }
    if (ch === 13 || ch === 10 || ch === 8232 || ch === 8233) {
      parser.report(34);
    }
    if (parser.index >= parser.source.length) {
      return parser.report(34);
    }
  }
  const bodyEnd = parser.index - 1;
  let mask = RegexFlags.Empty;
  let char = parser.currentChar;
  const { index: flagStart } = parser;
  while (isIdentifierPart(char)) {
    switch (char) {
      case 103:
        if (mask & RegexFlags.Global)
          parser.report(36, "g");
        mask |= RegexFlags.Global;
        break;
      case 105:
        if (mask & RegexFlags.IgnoreCase)
          parser.report(36, "i");
        mask |= RegexFlags.IgnoreCase;
        break;
      case 109:
        if (mask & RegexFlags.Multiline)
          parser.report(36, "m");
        mask |= RegexFlags.Multiline;
        break;
      case 117:
        if (mask & RegexFlags.Unicode)
          parser.report(36, "u");
        if (mask & RegexFlags.UnicodeSets)
          parser.report(36, "vu");
        mask |= RegexFlags.Unicode;
        break;
      case 118:
        if (mask & RegexFlags.Unicode)
          parser.report(36, "uv");
        if (mask & RegexFlags.UnicodeSets)
          parser.report(36, "v");
        mask |= RegexFlags.UnicodeSets;
        break;
      case 121:
        if (mask & RegexFlags.Sticky)
          parser.report(36, "y");
        mask |= RegexFlags.Sticky;
        break;
      case 115:
        if (mask & RegexFlags.DotAll)
          parser.report(36, "s");
        mask |= RegexFlags.DotAll;
        break;
      case 100:
        if (mask & RegexFlags.Indices)
          parser.report(36, "d");
        mask |= RegexFlags.Indices;
        break;
      default:
        parser.report(35);
    }
    char = advanceChar(parser);
  }
  const flags = parser.source.slice(flagStart, parser.index);
  const pattern = parser.source.slice(bodyStart, bodyEnd);
  parser.tokenRegExp = { pattern, flags };
  if (parser.options.raw)
    parser.tokenRaw = parser.source.slice(parser.tokenIndex, parser.index);
  parser.tokenValue = validate(parser, pattern, flags);
  return 65540;
}
__name(scanRegularExpression, "scanRegularExpression");
function validate(parser, pattern, flags) {
  try {
    return new RegExp(pattern, flags);
  } catch {
    try {
      new RegExp(pattern, flags);
      return null;
    } catch {
      parser.report(34);
    }
  }
}
__name(validate, "validate");
function scanString(parser, context, quote) {
  const { index: start } = parser;
  let ret = "";
  let char = advanceChar(parser);
  let marker = parser.index;
  while ((CharTypes[char] & 8) === 0) {
    if (char === quote) {
      ret += parser.source.slice(marker, parser.index);
      advanceChar(parser);
      if (parser.options.raw)
        parser.tokenRaw = parser.source.slice(start, parser.index);
      parser.tokenValue = ret;
      return 134283267;
    }
    if ((char & 8) === 8 && char === 92) {
      ret += parser.source.slice(marker, parser.index);
      char = advanceChar(parser);
      if (char < 127 || char === 8232 || char === 8233) {
        const code = parseEscape(parser, context, char);
        if (code >= 0)
          ret += String.fromCodePoint(code);
        else
          handleStringError(parser, code, 0);
      } else {
        ret += String.fromCodePoint(char);
      }
      marker = parser.index + 1;
    } else if (char === 8232 || char === 8233) {
      parser.column = -1;
      parser.line++;
    }
    if (parser.index >= parser.end)
      parser.report(16);
    char = advanceChar(parser);
  }
  parser.report(16);
}
__name(scanString, "scanString");
function parseEscape(parser, context, first, isTemplate = 0) {
  switch (first) {
    case 98:
      return 8;
    case 102:
      return 12;
    case 114:
      return 13;
    case 110:
      return 10;
    case 116:
      return 9;
    case 118:
      return 11;
    case 13: {
      if (parser.index < parser.end) {
        const nextChar = parser.source.charCodeAt(parser.index + 1);
        if (nextChar === 10) {
          parser.index = parser.index + 1;
          parser.currentChar = nextChar;
        }
      }
    }
    case 10:
    case 8232:
    case 8233:
      parser.column = -1;
      parser.line++;
      return -1;
    case 48:
    case 49:
    case 50:
    case 51: {
      let code = first - 48;
      let index = parser.index + 1;
      let column = parser.column + 1;
      if (index < parser.end) {
        const next = parser.source.charCodeAt(index);
        if ((CharTypes[next] & 32) === 0) {
          if (code !== 0 || CharTypes[next] & 512) {
            if (context & 1 || isTemplate)
              return -2;
            parser.flags |= 64;
          }
        } else if (context & 1 || isTemplate) {
          return -2;
        } else {
          parser.currentChar = next;
          code = code << 3 | next - 48;
          index++;
          column++;
          if (index < parser.end) {
            const next2 = parser.source.charCodeAt(index);
            if (CharTypes[next2] & 32) {
              parser.currentChar = next2;
              code = code << 3 | next2 - 48;
              index++;
              column++;
            }
          }
          parser.flags |= 64;
        }
        parser.index = index - 1;
        parser.column = column - 1;
      }
      return code;
    }
    case 52:
    case 53:
    case 54:
    case 55: {
      if (isTemplate || context & 1)
        return -2;
      let code = first - 48;
      const index = parser.index + 1;
      const column = parser.column + 1;
      if (index < parser.end) {
        const next = parser.source.charCodeAt(index);
        if (CharTypes[next] & 32) {
          code = code << 3 | next - 48;
          parser.currentChar = next;
          parser.index = index;
          parser.column = column;
        }
      }
      parser.flags |= 64;
      return code;
    }
    case 120: {
      const ch1 = advanceChar(parser);
      if ((CharTypes[ch1] & 64) === 0)
        return -4;
      const hi = toHex(ch1);
      const ch2 = advanceChar(parser);
      if ((CharTypes[ch2] & 64) === 0)
        return -4;
      const lo = toHex(ch2);
      return hi << 4 | lo;
    }
    case 117: {
      const ch = advanceChar(parser);
      if (parser.currentChar === 123) {
        let code = 0;
        while ((CharTypes[advanceChar(parser)] & 64) !== 0) {
          code = code << 4 | toHex(parser.currentChar);
          if (code > 1114111)
            return -5;
        }
        if (parser.currentChar < 1 || parser.currentChar !== 125) {
          return -4;
        }
        return code;
      } else {
        if ((CharTypes[ch] & 64) === 0)
          return -4;
        const ch2 = parser.source.charCodeAt(parser.index + 1);
        if ((CharTypes[ch2] & 64) === 0)
          return -4;
        const ch3 = parser.source.charCodeAt(parser.index + 2);
        if ((CharTypes[ch3] & 64) === 0)
          return -4;
        const ch4 = parser.source.charCodeAt(parser.index + 3);
        if ((CharTypes[ch4] & 64) === 0)
          return -4;
        parser.index += 3;
        parser.column += 3;
        parser.currentChar = parser.source.charCodeAt(parser.index);
        return toHex(ch) << 12 | toHex(ch2) << 8 | toHex(ch3) << 4 | toHex(ch4);
      }
    }
    case 56:
    case 57:
      if (isTemplate || !parser.options.webcompat || context & 1)
        return -3;
      parser.flags |= 4096;
    default:
      return first;
  }
}
__name(parseEscape, "parseEscape");
function handleStringError(parser, code, isTemplate) {
  switch (code) {
    case -1:
      return;
    case -2:
      parser.report(isTemplate ? 2 : 1);
    case -3:
      parser.report(isTemplate ? 3 : 14);
    case -4:
      parser.report(7);
    case -5:
      parser.report(104);
  }
}
__name(handleStringError, "handleStringError");
function scanTemplate(parser, context) {
  const { index: start } = parser;
  let token = 67174409;
  let ret = "";
  let char = advanceChar(parser);
  while (char !== 96) {
    if (char === 36 && parser.source.charCodeAt(parser.index + 1) === 123) {
      advanceChar(parser);
      token = 67174408;
      break;
    } else if (char === 92) {
      char = advanceChar(parser);
      if (char > 126) {
        ret += String.fromCodePoint(char);
      } else {
        const { index, line, column } = parser;
        const code = parseEscape(parser, context | 1, char, 1);
        if (code >= 0) {
          ret += String.fromCodePoint(code);
        } else if (code !== -1 && context & 64) {
          parser.index = index;
          parser.line = line;
          parser.column = column;
          ret = null;
          char = scanBadTemplate(parser, char);
          if (char < 0)
            token = 67174408;
          break;
        } else {
          handleStringError(parser, code, 1);
        }
      }
    } else if (parser.index < parser.end) {
      if (char === 13 && parser.source.charCodeAt(parser.index) === 10) {
        ret += String.fromCodePoint(char);
        parser.currentChar = parser.source.charCodeAt(++parser.index);
      }
      if ((char & 83) < 3 && char === 10 || (char ^ 8232) <= 1) {
        parser.column = -1;
        parser.line++;
      }
      ret += String.fromCodePoint(char);
    }
    if (parser.index >= parser.end)
      parser.report(17);
    char = advanceChar(parser);
  }
  advanceChar(parser);
  parser.tokenValue = ret;
  parser.tokenRaw = parser.source.slice(start + 1, parser.index - (token === 67174409 ? 1 : 2));
  return token;
}
__name(scanTemplate, "scanTemplate");
function scanBadTemplate(parser, ch) {
  while (ch !== 96) {
    switch (ch) {
      case 36: {
        const index = parser.index + 1;
        if (index < parser.end && parser.source.charCodeAt(index) === 123) {
          parser.index = index;
          parser.column++;
          return -ch;
        }
        break;
      }
      case 10:
      case 8232:
      case 8233:
        parser.column = -1;
        parser.line++;
    }
    if (parser.index >= parser.end)
      parser.report(17);
    ch = advanceChar(parser);
  }
  return ch;
}
__name(scanBadTemplate, "scanBadTemplate");
function scanTemplateTail(parser, context) {
  if (parser.index >= parser.end)
    parser.report(0);
  parser.index--;
  parser.column--;
  return scanTemplate(parser, context);
}
__name(scanTemplateTail, "scanTemplateTail");
var errorMessages = {
  [0]: "Unexpected token",
  [30]: "Unexpected token: '%0'",
  [1]: "Octal escape sequences are not allowed in strict mode",
  [2]: "Octal escape sequences are not allowed in template strings",
  [3]: "\\8 and \\9 are not allowed in template strings",
  [4]: "Private identifier #%0 is not defined",
  [5]: "Illegal Unicode escape sequence",
  [6]: "Invalid code point %0",
  [7]: "Invalid hexadecimal escape sequence",
  [9]: "Octal literals are not allowed in strict mode",
  [8]: "Decimal integer literals with a leading zero are forbidden in strict mode",
  [10]: "Expected number in radix %0",
  [151]: "Invalid left-hand side assignment to a destructible right-hand side",
  [11]: "Non-number found after exponent indicator",
  [12]: "Invalid BigIntLiteral",
  [13]: "No identifiers allowed directly after numeric literal",
  [14]: "Escapes \\8 or \\9 are not syntactically valid escapes",
  [15]: "Escapes \\8 or \\9 are not allowed in strict mode",
  [16]: "Unterminated string literal",
  [17]: "Unterminated template literal",
  [18]: "Multiline comment was not closed properly",
  [19]: "The identifier contained dynamic unicode escape that was not closed",
  [20]: "Illegal character '%0'",
  [21]: "Missing hexadecimal digits",
  [22]: "Invalid implicit octal",
  [23]: "Invalid line break in string literal",
  [24]: "Only unicode escapes are legal in identifier names",
  [25]: "Expected '%0'",
  [26]: "Invalid left-hand side in assignment",
  [27]: "Invalid left-hand side in async arrow",
  [28]: 'Calls to super must be in the "constructor" method of a class expression or class declaration that has a superclass',
  [29]: "Member access on super must be in a method",
  [31]: "Await expression not allowed in formal parameter",
  [32]: "Yield expression not allowed in formal parameter",
  [95]: "Unexpected token: 'escaped keyword'",
  [33]: "Unary expressions as the left operand of an exponentiation expression must be disambiguated with parentheses",
  [123]: "Async functions can only be declared at the top level or inside a block",
  [34]: "Unterminated regular expression",
  [35]: "Unexpected regular expression flag",
  [36]: "Duplicate regular expression flag '%0'",
  [37]: "%0 functions must have exactly %1 argument%2",
  [38]: "Setter function argument must not be a rest parameter",
  [39]: "%0 declaration must have a name in this context",
  [40]: "Function name may not contain any reserved words or be eval or arguments in strict mode",
  [41]: "The rest operator is missing an argument",
  [42]: "A getter cannot be a generator",
  [43]: "A setter cannot be a generator",
  [44]: "A computed property name must be followed by a colon or paren",
  [134]: "Object literal keys that are strings or numbers must be a method or have a colon",
  [46]: "Found `* async x(){}` but this should be `async * x(){}`",
  [45]: "Getters and setters can not be generators",
  [47]: "'%0' can not be generator method",
  [48]: "No line break is allowed after '=>'",
  [49]: "The left-hand side of the arrow can only be destructed through assignment",
  [50]: "The binding declaration is not destructible",
  [51]: "Async arrow can not be followed by new expression",
  [52]: "Classes may not have a static property named 'prototype'",
  [53]: "Class constructor may not be a %0",
  [54]: "Duplicate constructor method in class",
  [55]: "Invalid increment/decrement operand",
  [56]: "Invalid use of `new` keyword on an increment/decrement expression",
  [57]: "`=>` is an invalid assignment target",
  [58]: "Rest element may not have a trailing comma",
  [59]: "Missing initializer in %0 declaration",
  [60]: "'for-%0' loop head declarations can not have an initializer",
  [61]: "Invalid left-hand side in for-%0 loop: Must have a single binding",
  [62]: "Invalid shorthand property initializer",
  [63]: "Property name __proto__ appears more than once in object literal",
  [64]: "Let is disallowed as a lexically bound name",
  [65]: "Invalid use of '%0' inside new expression",
  [66]: "Illegal 'use strict' directive in function with non-simple parameter list",
  [67]: 'Identifier "let" disallowed as left-hand side expression in strict mode',
  [68]: "Illegal continue statement",
  [69]: "Illegal break statement",
  [70]: "Cannot have `let[...]` as a var name in strict mode",
  [71]: "Invalid destructuring assignment target",
  [72]: "Rest parameter may not have a default initializer",
  [73]: "The rest argument must the be last parameter",
  [74]: "Invalid rest argument",
  [76]: "In strict mode code, functions can only be declared at top level or inside a block",
  [77]: "In non-strict mode code, functions can only be declared at top level, inside a block, or as the body of an if statement",
  [78]: "Without web compatibility enabled functions can not be declared at top level, inside a block, or as the body of an if statement",
  [79]: "Class declaration can't appear in single-statement context",
  [80]: "Invalid left-hand side in for-%0",
  [81]: "Invalid assignment in for-%0",
  [82]: "for await (... of ...) is only valid in async functions and async generators",
  [83]: "The first token after the template expression should be a continuation of the template",
  [85]: "`let` declaration not allowed here and `let` cannot be a regular var name in strict mode",
  [84]: "`let \n [` is a restricted production at the start of a statement",
  [86]: "Catch clause requires exactly one parameter, not more (and no trailing comma)",
  [87]: "Catch clause parameter does not support default values",
  [88]: "Missing catch or finally after try",
  [89]: "More than one default clause in switch statement",
  [90]: "Illegal newline after throw",
  [91]: "Strict mode code may not include a with statement",
  [92]: "Illegal return statement",
  [93]: "The left hand side of the for-header binding declaration is not destructible",
  [94]: "new.target only allowed within functions or static blocks",
  [96]: "'#' not followed by identifier",
  [102]: "Invalid keyword",
  [101]: "Can not use 'let' as a class name",
  [100]: "'A lexical declaration can't define a 'let' binding",
  [99]: "Can not use `let` as variable name in strict mode",
  [97]: "'%0' may not be used as an identifier in this context",
  [98]: "Await is only valid in async functions",
  [103]: "The %0 keyword can only be used with the module goal",
  [104]: "Unicode codepoint must not be greater than 0x10FFFF",
  [105]: "%0 source must be string",
  [106]: "Only a identifier or string can be used to indicate alias",
  [107]: "Only '*' or '{...}' can be imported after default",
  [108]: "Trailing decorator may be followed by method",
  [109]: "Decorators can't be used with a constructor",
  [110]: "Can not use `await` as identifier in module or async func",
  [111]: "Can not use `await` as identifier in module",
  [112]: "HTML comments are only allowed with web compatibility (Annex B)",
  [113]: "The identifier 'let' must not be in expression position in strict mode",
  [114]: "Cannot assign to `eval` and `arguments` in strict mode",
  [115]: "The left-hand side of a for-of loop may not start with 'let'",
  [116]: "Block body arrows can not be immediately invoked without a group",
  [117]: "Block body arrows can not be immediately accessed without a group",
  [118]: "Unexpected strict mode reserved word",
  [119]: "Unexpected eval or arguments in strict mode",
  [120]: "Decorators must not be followed by a semicolon",
  [121]: "Calling delete on expression not allowed in strict mode",
  [122]: "Pattern can not have a tail",
  [124]: "Can not have a `yield` expression on the left side of a ternary",
  [125]: "An arrow function can not have a postfix update operator",
  [126]: "Invalid object literal key character after generator star",
  [127]: "Private fields can not be deleted",
  [129]: "Classes may not have a field called constructor",
  [128]: "Classes may not have a private element named constructor",
  [130]: "A class field initializer or static block may not contain arguments",
  [131]: "Generators can only be declared at the top level or inside a block",
  [132]: "Async methods are a restricted production and cannot have a newline following it",
  [133]: "Unexpected character after object literal property name",
  [135]: "Invalid key token",
  [136]: "Label '%0' has already been declared",
  [137]: "continue statement must be nested within an iteration statement",
  [138]: "Undefined label '%0'",
  [139]: "Trailing comma is disallowed inside import(...) arguments",
  [140]: "Invalid binding in JSON import",
  [141]: "import() requires exactly one argument",
  [142]: "Cannot use new with import(...)",
  [143]: "... is not allowed in import()",
  [144]: "Expected '=>'",
  [145]: "Duplicate binding '%0'",
  [146]: "Duplicate private identifier #%0",
  [147]: "Cannot export a duplicate name '%0'",
  [150]: "Duplicate %0 for-binding",
  [148]: "Exported binding '%0' needs to refer to a top-level declared variable",
  [149]: "Unexpected private field",
  [153]: "Numeric separators are not allowed at the end of numeric literals",
  [152]: "Only one underscore is allowed as numeric separator",
  [154]: "JSX value should be either an expression or a quoted JSX text",
  [155]: "Expected corresponding JSX closing tag for %0",
  [156]: "Adjacent JSX elements must be wrapped in an enclosing tag",
  [157]: "JSX attributes must only be assigned a non-empty 'expression'",
  [158]: "'%0' has already been declared",
  [159]: "'%0' shadowed a catch clause binding",
  [160]: "Dot property must be an identifier",
  [161]: "Encountered invalid input after spread/rest argument",
  [162]: "Catch without try",
  [163]: "Finally without try",
  [164]: "Expected corresponding closing tag for JSX fragment",
  [165]: "Coalescing and logical operators used together in the same expression must be disambiguated with parentheses",
  [166]: "Invalid tagged template on optional chain",
  [167]: "Invalid optional chain from super property",
  [168]: "Invalid optional chain from new expression",
  [169]: 'Cannot use "import.meta" outside a module',
  [170]: "Leading decorators must be attached to a class declaration",
  [171]: "An export name cannot include a lone surrogate, found %0",
  [172]: "A string literal cannot be used as an exported binding without `from`",
  [173]: "Private fields can't be accessed on super",
  [174]: "The only valid meta property for import is 'import.meta'",
  [175]: "'import.meta' must not contain escaped characters",
  [176]: 'cannot use "await" as identifier inside an async function',
  [177]: 'cannot use "await" in static blocks'
};
var _ParseError = class _ParseError extends SyntaxError {
  constructor(start, end, type, ...params) {
    const description = errorMessages[type].replace(/%(\d+)/g, (_, i) => params[i]);
    const message = "[" + start.line + ":" + start.column + "-" + end.line + ":" + end.column + "]: " + description;
    super(message);
    __publicField(this, "start");
    __publicField(this, "end");
    __publicField(this, "range");
    __publicField(this, "loc");
    __publicField(this, "description");
    this.start = start.index;
    this.end = end.index;
    this.range = [start.index, end.index];
    this.loc = {
      start: { line: start.line, column: start.column },
      end: { line: end.line, column: end.column }
    };
    this.description = description;
  }
};
__name(_ParseError, "ParseError");
var ParseError = _ParseError;
function scanNumber(parser, context, kind) {
  let char = parser.currentChar;
  let value = 0;
  let digit = 9;
  let atStart = kind & 64 ? 0 : 1;
  let digits = 0;
  let allowSeparator = 0;
  if (kind & 64) {
    value = "." + scanDecimalDigitsOrSeparator(parser, char);
    char = parser.currentChar;
    if (char === 110)
      parser.report(12);
  } else {
    if (char === 48) {
      char = advanceChar(parser);
      if ((char | 32) === 120) {
        kind = 8 | 128;
        char = advanceChar(parser);
        while (CharTypes[char] & (64 | 4096)) {
          if (char === 95) {
            if (!allowSeparator)
              parser.report(152);
            allowSeparator = 0;
            char = advanceChar(parser);
            continue;
          }
          allowSeparator = 1;
          value = value * 16 + toHex(char);
          digits++;
          char = advanceChar(parser);
        }
        if (digits === 0 || !allowSeparator) {
          parser.report(digits === 0 ? 21 : 153);
        }
      } else if ((char | 32) === 111) {
        kind = 4 | 128;
        char = advanceChar(parser);
        while (CharTypes[char] & (32 | 4096)) {
          if (char === 95) {
            if (!allowSeparator) {
              parser.report(152);
            }
            allowSeparator = 0;
            char = advanceChar(parser);
            continue;
          }
          allowSeparator = 1;
          value = value * 8 + (char - 48);
          digits++;
          char = advanceChar(parser);
        }
        if (digits === 0 || !allowSeparator) {
          parser.report(digits === 0 ? 0 : 153);
        }
      } else if ((char | 32) === 98) {
        kind = 2 | 128;
        char = advanceChar(parser);
        while (CharTypes[char] & (128 | 4096)) {
          if (char === 95) {
            if (!allowSeparator) {
              parser.report(152);
            }
            allowSeparator = 0;
            char = advanceChar(parser);
            continue;
          }
          allowSeparator = 1;
          value = value * 2 + (char - 48);
          digits++;
          char = advanceChar(parser);
        }
        if (digits === 0 || !allowSeparator) {
          parser.report(digits === 0 ? 0 : 153);
        }
      } else if (CharTypes[char] & 32) {
        if (context & 1)
          parser.report(1);
        kind = 1;
        while (CharTypes[char] & 16) {
          if (CharTypes[char] & 512) {
            kind = 32;
            atStart = 0;
            break;
          }
          value = value * 8 + (char - 48);
          char = advanceChar(parser);
        }
      } else if (CharTypes[char] & 512) {
        if (context & 1)
          parser.report(1);
        parser.flags |= 64;
        kind = 32;
      } else if (char === 95) {
        parser.report(0);
      }
    }
    if (kind & 48) {
      if (atStart) {
        while (digit >= 0 && CharTypes[char] & (16 | 4096)) {
          if (char === 95) {
            char = advanceChar(parser);
            if (char === 95 || kind & 32) {
              throw new ParseError(parser.currentLocation, { index: parser.index + 1, line: parser.line, column: parser.column }, 152);
            }
            allowSeparator = 1;
            continue;
          }
          allowSeparator = 0;
          value = 10 * value + (char - 48);
          char = advanceChar(parser);
          --digit;
        }
        if (allowSeparator) {
          throw new ParseError(parser.currentLocation, { index: parser.index + 1, line: parser.line, column: parser.column }, 153);
        }
        if (digit >= 0 && !isIdentifierStart(char) && char !== 46) {
          parser.tokenValue = value;
          if (parser.options.raw)
            parser.tokenRaw = parser.source.slice(parser.tokenIndex, parser.index);
          return 134283266;
        }
      }
      value += scanDecimalDigitsOrSeparator(parser, char);
      char = parser.currentChar;
      if (char === 46) {
        if (advanceChar(parser) === 95)
          parser.report(0);
        kind = 64;
        value += "." + scanDecimalDigitsOrSeparator(parser, parser.currentChar);
        char = parser.currentChar;
      }
    }
  }
  const end = parser.index;
  let isBigInt = 0;
  if (char === 110 && kind & 128) {
    isBigInt = 1;
    char = advanceChar(parser);
  } else {
    if ((char | 32) === 101) {
      char = advanceChar(parser);
      if (CharTypes[char] & 256)
        char = advanceChar(parser);
      const { index } = parser;
      if ((CharTypes[char] & 16) === 0)
        parser.report(11);
      value += parser.source.substring(end, index) + scanDecimalDigitsOrSeparator(parser, char);
      char = parser.currentChar;
    }
  }
  if (parser.index < parser.end && CharTypes[char] & 16 || isIdentifierStart(char)) {
    parser.report(13);
  }
  if (isBigInt) {
    parser.tokenRaw = parser.source.slice(parser.tokenIndex, parser.index);
    parser.tokenValue = BigInt(parser.tokenRaw.slice(0, -1).replaceAll("_", ""));
    return 134283388;
  }
  parser.tokenValue = kind & (1 | 2 | 8 | 4) ? value : kind & 32 ? parseFloat(parser.source.substring(parser.tokenIndex, parser.index)) : +value;
  if (parser.options.raw)
    parser.tokenRaw = parser.source.slice(parser.tokenIndex, parser.index);
  return 134283266;
}
__name(scanNumber, "scanNumber");
function scanDecimalDigitsOrSeparator(parser, char) {
  let allowSeparator = 0;
  let start = parser.index;
  let ret = "";
  while (CharTypes[char] & (16 | 4096)) {
    if (char === 95) {
      const { index } = parser;
      char = advanceChar(parser);
      if (char === 95) {
        throw new ParseError(parser.currentLocation, { index: parser.index + 1, line: parser.line, column: parser.column }, 152);
      }
      allowSeparator = 1;
      ret += parser.source.substring(start, index);
      start = parser.index;
      continue;
    }
    allowSeparator = 0;
    char = advanceChar(parser);
  }
  if (allowSeparator) {
    throw new ParseError(parser.currentLocation, { index: parser.index + 1, line: parser.line, column: parser.column }, 153);
  }
  return ret + parser.source.substring(start, parser.index);
}
__name(scanDecimalDigitsOrSeparator, "scanDecimalDigitsOrSeparator");
var KeywordDescTable = [
  "end of source",
  "identifier",
  "number",
  "string",
  "regular expression",
  "false",
  "true",
  "null",
  "template continuation",
  "template tail",
  "=>",
  "(",
  "{",
  ".",
  "...",
  "}",
  ")",
  ";",
  ",",
  "[",
  "]",
  ":",
  "?",
  "'",
  '"',
  "++",
  "--",
  "=",
  "<<=",
  ">>=",
  ">>>=",
  "**=",
  "+=",
  "-=",
  "*=",
  "/=",
  "%=",
  "^=",
  "|=",
  "&=",
  "||=",
  "&&=",
  "??=",
  "typeof",
  "delete",
  "void",
  "!",
  "~",
  "+",
  "-",
  "in",
  "instanceof",
  "*",
  "%",
  "/",
  "**",
  "&&",
  "||",
  "===",
  "!==",
  "==",
  "!=",
  "<=",
  ">=",
  "<",
  ">",
  "<<",
  ">>",
  ">>>",
  "&",
  "|",
  "^",
  "var",
  "let",
  "const",
  "break",
  "case",
  "catch",
  "class",
  "continue",
  "debugger",
  "default",
  "do",
  "else",
  "export",
  "extends",
  "finally",
  "for",
  "function",
  "if",
  "import",
  "new",
  "return",
  "super",
  "switch",
  "this",
  "throw",
  "try",
  "while",
  "with",
  "implements",
  "interface",
  "package",
  "private",
  "protected",
  "public",
  "static",
  "yield",
  "as",
  "async",
  "await",
  "constructor",
  "get",
  "set",
  "accessor",
  "from",
  "of",
  "enum",
  "eval",
  "arguments",
  "escaped keyword",
  "escaped future reserved keyword",
  "reserved if strict",
  "#",
  "BigIntLiteral",
  "??",
  "?.",
  "WhiteSpace",
  "Illegal",
  "LineTerminator",
  "PrivateField",
  "Template",
  "@",
  "target",
  "meta",
  "LineFeed",
  "Escaped",
  "JSXText"
];
var descKeywordTable = {
  this: 86111,
  function: 86104,
  if: 20569,
  return: 20572,
  var: 86088,
  else: 20563,
  for: 20567,
  new: 86107,
  in: 8673330,
  typeof: 16863275,
  while: 20578,
  case: 20556,
  break: 20555,
  try: 20577,
  catch: 20557,
  delete: 16863276,
  throw: 86112,
  switch: 86110,
  continue: 20559,
  default: 20561,
  instanceof: 8411187,
  do: 20562,
  void: 16863277,
  finally: 20566,
  async: 209005,
  await: 209006,
  class: 86094,
  const: 86090,
  constructor: 12399,
  debugger: 20560,
  export: 20564,
  extends: 20565,
  false: 86021,
  from: 209011,
  get: 209008,
  implements: 36964,
  import: 86106,
  interface: 36965,
  let: 241737,
  null: 86023,
  of: 471156,
  package: 36966,
  private: 36967,
  protected: 36968,
  public: 36969,
  set: 209009,
  static: 36970,
  super: 86109,
  true: 86022,
  with: 20579,
  yield: 241771,
  enum: 86133,
  eval: 537079926,
  as: 77932,
  arguments: 537079927,
  target: 209029,
  meta: 209030,
  accessor: 12402
};
function matchOrInsertSemicolon(parser, context) {
  var _a, _b;
  if ((parser.flags & 1) === 0 && (parser.getToken() & 1048576) !== 1048576) {
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
  if (!consumeOpt(parser, context, 1074790417)) {
    (_b = (_a = parser.options).onInsertedSemicolon) == null ? void 0 : _b.call(_a, parser.startIndex);
  }
}
__name(matchOrInsertSemicolon, "matchOrInsertSemicolon");
function isValidStrictMode(parser, index, tokenIndex, tokenValue) {
  if (index - tokenIndex < 13 && tokenValue === "use strict") {
    if ((parser.getToken() & 1048576) === 1048576 || parser.flags & 1) {
      return 1;
    }
  }
  return 0;
}
__name(isValidStrictMode, "isValidStrictMode");
function optionalBit(parser, context, t) {
  if (parser.getToken() !== t)
    return 0;
  nextToken(parser, context);
  return 1;
}
__name(optionalBit, "optionalBit");
function consumeOpt(parser, context, t) {
  if (parser.getToken() !== t)
    return false;
  nextToken(parser, context);
  return true;
}
__name(consumeOpt, "consumeOpt");
function consume(parser, context, t) {
  if (parser.getToken() !== t)
    parser.report(25, KeywordDescTable[t & 255]);
  nextToken(parser, context);
}
__name(consume, "consume");
function reinterpretToPattern(parser, node) {
  switch (node.type) {
    case "ArrayExpression": {
      node.type = "ArrayPattern";
      const { elements } = node;
      for (let i = 0, n = elements.length; i < n; ++i) {
        const element = elements[i];
        if (element)
          reinterpretToPattern(parser, element);
      }
      return;
    }
    case "ObjectExpression": {
      node.type = "ObjectPattern";
      const { properties } = node;
      for (let i = 0, n = properties.length; i < n; ++i) {
        reinterpretToPattern(parser, properties[i]);
      }
      return;
    }
    case "AssignmentExpression":
      node.type = "AssignmentPattern";
      if (node.operator !== "=")
        parser.report(71);
      delete node.operator;
      reinterpretToPattern(parser, node.left);
      return;
    case "Property":
      reinterpretToPattern(parser, node.value);
      return;
    case "SpreadElement":
      node.type = "RestElement";
      reinterpretToPattern(parser, node.argument);
  }
}
__name(reinterpretToPattern, "reinterpretToPattern");
function validateBindingIdentifier(parser, context, kind, t, skipEvalArgCheck) {
  if (context & 1) {
    if ((t & 36864) === 36864) {
      parser.report(118);
    }
    if (!skipEvalArgCheck && (t & 537079808) === 537079808) {
      parser.report(119);
    }
  }
  if ((t & 20480) === 20480 || t === -2147483528) {
    parser.report(102);
  }
  if (kind & (8 | 16) && (t & 255) === (241737 & 255)) {
    parser.report(100);
  }
  if (context & (2048 | 2) && t === 209006) {
    parser.report(110);
  }
  if (context & (1024 | 1) && t === 241771) {
    parser.report(97, "yield");
  }
}
__name(validateBindingIdentifier, "validateBindingIdentifier");
function validateFunctionName(parser, context, t) {
  if (context & 1) {
    if ((t & 36864) === 36864) {
      parser.report(118);
    }
    if ((t & 537079808) === 537079808) {
      parser.report(119);
    }
    if (t === -2147483527) {
      parser.report(95);
    }
    if (t === -2147483528) {
      parser.report(95);
    }
  }
  if ((t & 20480) === 20480) {
    parser.report(102);
  }
  if (context & (2048 | 2) && t === 209006) {
    parser.report(110);
  }
  if (context & (1024 | 1) && t === 241771) {
    parser.report(97, "yield");
  }
}
__name(validateFunctionName, "validateFunctionName");
function isStrictReservedWord(parser, context, t) {
  if (t === 209006) {
    if (context & (2048 | 2))
      parser.report(110);
    parser.destructible |= 128;
  }
  if (t === 241771 && context & 1024)
    parser.report(97, "yield");
  return (t & 20480) === 20480 || (t & 36864) === 36864 || t == -2147483527;
}
__name(isStrictReservedWord, "isStrictReservedWord");
function isPropertyWithPrivateFieldKey(expr) {
  return !expr.property ? false : expr.property.type === "PrivateIdentifier";
}
__name(isPropertyWithPrivateFieldKey, "isPropertyWithPrivateFieldKey");
function isValidLabel(parser, labels, name, isIterationStatement) {
  while (labels) {
    if (labels["$" + name]) {
      if (isIterationStatement)
        parser.report(137);
      return 1;
    }
    if (isIterationStatement && labels.loop)
      isIterationStatement = 0;
    labels = labels["$"];
  }
  return 0;
}
__name(isValidLabel, "isValidLabel");
function validateAndDeclareLabel(parser, labels, name) {
  let set = labels;
  while (set) {
    if (set["$" + name])
      parser.report(136, name);
    set = set["$"];
  }
  labels["$" + name] = 1;
}
__name(validateAndDeclareLabel, "validateAndDeclareLabel");
function isEqualTagName(elementName) {
  switch (elementName.type) {
    case "JSXIdentifier":
      return elementName.name;
    case "JSXNamespacedName":
      return elementName.namespace + ":" + elementName.name;
    case "JSXMemberExpression":
      return isEqualTagName(elementName.object) + "." + isEqualTagName(elementName.property);
  }
}
__name(isEqualTagName, "isEqualTagName");
function isValidIdentifier(context, t) {
  if (context & (1 | 1024)) {
    if (context & 2 && t === 209006)
      return false;
    if (context & 1024 && t === 241771)
      return false;
    return (t & 12288) === 12288;
  }
  return (t & 12288) === 12288 || (t & 36864) === 36864;
}
__name(isValidIdentifier, "isValidIdentifier");
function classifyIdentifier(parser, context, t) {
  if ((t & 537079808) === 537079808) {
    if (context & 1)
      parser.report(119);
    parser.flags |= 512;
  }
  if (!isValidIdentifier(context, t))
    parser.report(0);
}
__name(classifyIdentifier, "classifyIdentifier");
function getOwnProperty(object, key) {
  return Object.hasOwn(object, key) ? object[key] : void 0;
}
__name(getOwnProperty, "getOwnProperty");
function scanIdentifier(parser, context, isValidAsKeyword) {
  var _a;
  while (isIdPart[advanceChar(parser)])
    ;
  parser.tokenValue = parser.source.slice(parser.tokenIndex, parser.index);
  return parser.currentChar !== 92 && parser.currentChar <= 126 ? (_a = getOwnProperty(descKeywordTable, parser.tokenValue)) != null ? _a : 208897 : scanIdentifierSlowCase(parser, context, 0, isValidAsKeyword);
}
__name(scanIdentifier, "scanIdentifier");
function scanUnicodeIdentifier(parser, context) {
  const cookedChar = scanIdentifierUnicodeEscape(parser);
  if (!isIdentifierStart(cookedChar))
    parser.report(5);
  parser.tokenValue = String.fromCodePoint(cookedChar);
  return scanIdentifierSlowCase(parser, context, 1, CharTypes[cookedChar] & 4);
}
__name(scanUnicodeIdentifier, "scanUnicodeIdentifier");
function scanIdentifierSlowCase(parser, context, hasEscape, isValidAsKeyword) {
  let start = parser.index;
  while (parser.index < parser.end) {
    if (parser.currentChar === 92) {
      parser.tokenValue += parser.source.slice(start, parser.index);
      hasEscape = 1;
      const code = scanIdentifierUnicodeEscape(parser);
      if (!isIdentifierPart(code))
        parser.report(5);
      isValidAsKeyword = isValidAsKeyword && CharTypes[code] & 4;
      parser.tokenValue += String.fromCodePoint(code);
      start = parser.index;
    } else {
      const merged = consumePossibleSurrogatePair(parser);
      if (merged > 0) {
        if (!isIdentifierPart(merged)) {
          parser.report(20, String.fromCodePoint(merged));
        }
        parser.currentChar = merged;
        parser.index++;
        parser.column++;
      } else if (!isIdentifierPart(parser.currentChar)) {
        break;
      }
      advanceChar(parser);
    }
  }
  if (parser.index <= parser.end) {
    parser.tokenValue += parser.source.slice(start, parser.index);
  }
  const { length } = parser.tokenValue;
  if (isValidAsKeyword && length >= 2 && length <= 11) {
    const token = getOwnProperty(descKeywordTable, parser.tokenValue);
    if (token === void 0)
      return 208897 | (hasEscape ? -2147483648 : 0);
    if (!hasEscape)
      return token;
    if (token === 209006) {
      if ((context & (2 | 2048)) === 0) {
        return token | -2147483648;
      }
      return -2147483528;
    }
    if (context & 1) {
      if (token === 36970) {
        return -2147483527;
      }
      if ((token & 36864) === 36864) {
        return -2147483527;
      }
      if ((token & 20480) === 20480) {
        if (context & 262144 && (context & 8) === 0) {
          return token | -2147483648;
        } else {
          return -2147483528;
        }
      }
      return 209018 | -2147483648;
    }
    if (context & 262144 && (context & 8) === 0 && (token & 20480) === 20480) {
      return token | -2147483648;
    }
    if (token === 241771) {
      return context & 262144 ? 209018 | -2147483648 : context & 1024 ? -2147483528 : token | -2147483648;
    }
    if (token === 209005) {
      return 209018 | -2147483648;
    }
    if ((token & 36864) === 36864) {
      return token | 12288 | -2147483648;
    }
    return -2147483528;
  }
  return 208897 | (hasEscape ? -2147483648 : 0);
}
__name(scanIdentifierSlowCase, "scanIdentifierSlowCase");
function scanPrivateIdentifier(parser) {
  let char = advanceChar(parser);
  if (char === 92)
    return 130;
  const merged = consumePossibleSurrogatePair(parser);
  if (merged)
    char = merged;
  if (!isIdentifierStart(char))
    parser.report(96);
  return 130;
}
__name(scanPrivateIdentifier, "scanPrivateIdentifier");
function scanIdentifierUnicodeEscape(parser) {
  if (parser.source.charCodeAt(parser.index + 1) !== 117) {
    parser.report(5);
  }
  parser.currentChar = parser.source.charCodeAt(parser.index += 2);
  parser.column += 2;
  return scanUnicodeEscape(parser);
}
__name(scanIdentifierUnicodeEscape, "scanIdentifierUnicodeEscape");
function scanUnicodeEscape(parser) {
  let codePoint = 0;
  const char = parser.currentChar;
  if (char === 123) {
    const begin = parser.index - 2;
    while (CharTypes[advanceChar(parser)] & 64) {
      codePoint = codePoint << 4 | toHex(parser.currentChar);
      if (codePoint > 1114111)
        throw new ParseError({ index: begin, line: parser.line, column: parser.column }, parser.currentLocation, 104);
    }
    if (parser.currentChar !== 125) {
      throw new ParseError({ index: begin, line: parser.line, column: parser.column }, parser.currentLocation, 7);
    }
    advanceChar(parser);
    return codePoint;
  }
  if ((CharTypes[char] & 64) === 0)
    parser.report(7);
  const char2 = parser.source.charCodeAt(parser.index + 1);
  if ((CharTypes[char2] & 64) === 0)
    parser.report(7);
  const char3 = parser.source.charCodeAt(parser.index + 2);
  if ((CharTypes[char3] & 64) === 0)
    parser.report(7);
  const char4 = parser.source.charCodeAt(parser.index + 3);
  if ((CharTypes[char4] & 64) === 0)
    parser.report(7);
  codePoint = toHex(char) << 12 | toHex(char2) << 8 | toHex(char3) << 4 | toHex(char4);
  parser.currentChar = parser.source.charCodeAt(parser.index += 4);
  parser.column += 4;
  return codePoint;
}
__name(scanUnicodeEscape, "scanUnicodeEscape");
var TokenLookup = [
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  127,
  135,
  127,
  127,
  129,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  128,
  127,
  16842798,
  134283267,
  130,
  208897,
  8391477,
  8390213,
  134283267,
  67174411,
  16,
  8391476,
  25233968,
  18,
  25233969,
  67108877,
  8457014,
  134283266,
  134283266,
  134283266,
  134283266,
  134283266,
  134283266,
  134283266,
  134283266,
  134283266,
  134283266,
  21,
  1074790417,
  8456256,
  1077936155,
  8390721,
  22,
  132,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  208897,
  69271571,
  136,
  20,
  8389959,
  208897,
  131,
  4096,
  4096,
  4096,
  4096,
  4096,
  4096,
  4096,
  208897,
  4096,
  208897,
  208897,
  4096,
  208897,
  4096,
  208897,
  4096,
  208897,
  4096,
  4096,
  4096,
  208897,
  4096,
  4096,
  208897,
  4096,
  4096,
  2162700,
  8389702,
  1074790415,
  16842799,
  128
];
function nextToken(parser, context) {
  parser.flags = (parser.flags | 1) ^ 1;
  parser.startIndex = parser.index;
  parser.startColumn = parser.column;
  parser.startLine = parser.line;
  parser.setToken(scanSingleToken(parser, context, 0));
}
__name(nextToken, "nextToken");
function scanSingleToken(parser, context, state) {
  const isStartOfLine = parser.index === 0;
  const { source } = parser;
  let start = parser.currentLocation;
  while (parser.index < parser.end) {
    parser.tokenIndex = parser.index;
    parser.tokenColumn = parser.column;
    parser.tokenLine = parser.line;
    let char = parser.currentChar;
    if (char <= 126) {
      const token = TokenLookup[char];
      switch (token) {
        case 67174411:
        case 16:
        case 2162700:
        case 1074790415:
        case 69271571:
        case 20:
        case 21:
        case 1074790417:
        case 18:
        case 16842799:
        case 132:
        case 128:
          advanceChar(parser);
          return token;
        case 208897:
          return scanIdentifier(parser, context, 0);
        case 4096:
          return scanIdentifier(parser, context, 1);
        case 134283266:
          return scanNumber(parser, context, 16 | 128);
        case 134283267:
          return scanString(parser, context, char);
        case 131:
          return scanTemplate(parser, context);
        case 136:
          return scanUnicodeIdentifier(parser, context);
        case 130:
          return scanPrivateIdentifier(parser);
        case 127:
          advanceChar(parser);
          break;
        case 129:
          state |= 1 | 4;
          scanNewLine(parser);
          break;
        case 135:
          consumeLineFeed(parser, state);
          state = state & -5 | 1;
          break;
        case 8456256: {
          const ch = advanceChar(parser);
          if (parser.index < parser.end) {
            if (ch === 60) {
              if (parser.index < parser.end && advanceChar(parser) === 61) {
                advanceChar(parser);
                return 4194332;
              }
              return 8390978;
            } else if (ch === 61) {
              advanceChar(parser);
              return 8390718;
            }
            if (ch === 33) {
              const index = parser.index + 1;
              if (index + 1 < parser.end && source.charCodeAt(index) === 45 && source.charCodeAt(index + 1) == 45) {
                parser.column += 3;
                parser.currentChar = source.charCodeAt(parser.index += 3);
                state = skipSingleHTMLComment(parser, source, state, context, 2, parser.tokenStart);
                start = parser.tokenStart;
                continue;
              }
              return 8456256;
            }
          }
          return 8456256;
        }
        case 1077936155: {
          advanceChar(parser);
          const ch = parser.currentChar;
          if (ch === 61) {
            if (advanceChar(parser) === 61) {
              advanceChar(parser);
              return 8390458;
            }
            return 8390460;
          }
          if (ch === 62) {
            advanceChar(parser);
            return 10;
          }
          return 1077936155;
        }
        case 16842798:
          if (advanceChar(parser) !== 61) {
            return 16842798;
          }
          if (advanceChar(parser) !== 61) {
            return 8390461;
          }
          advanceChar(parser);
          return 8390459;
        case 8391477:
          if (advanceChar(parser) !== 61)
            return 8391477;
          advanceChar(parser);
          return 4194340;
        case 8391476: {
          advanceChar(parser);
          if (parser.index >= parser.end)
            return 8391476;
          const ch = parser.currentChar;
          if (ch === 61) {
            advanceChar(parser);
            return 4194338;
          }
          if (ch !== 42)
            return 8391476;
          if (advanceChar(parser) !== 61)
            return 8391735;
          advanceChar(parser);
          return 4194335;
        }
        case 8389959:
          if (advanceChar(parser) !== 61)
            return 8389959;
          advanceChar(parser);
          return 4194341;
        case 25233968: {
          advanceChar(parser);
          const ch = parser.currentChar;
          if (ch === 43) {
            advanceChar(parser);
            return 33619993;
          }
          if (ch === 61) {
            advanceChar(parser);
            return 4194336;
          }
          return 25233968;
        }
        case 25233969: {
          advanceChar(parser);
          const ch = parser.currentChar;
          if (ch === 45) {
            advanceChar(parser);
            if ((state & 1 || isStartOfLine) && parser.currentChar === 62) {
              if (!parser.options.webcompat)
                parser.report(112);
              advanceChar(parser);
              state = skipSingleHTMLComment(parser, source, state, context, 3, start);
              start = parser.tokenStart;
              continue;
            }
            return 33619994;
          }
          if (ch === 61) {
            advanceChar(parser);
            return 4194337;
          }
          return 25233969;
        }
        case 8457014: {
          advanceChar(parser);
          if (parser.index < parser.end) {
            const ch = parser.currentChar;
            if (ch === 47) {
              advanceChar(parser);
              state = skipSingleLineComment(parser, source, state, 0, parser.tokenStart);
              start = parser.tokenStart;
              continue;
            }
            if (ch === 42) {
              advanceChar(parser);
              state = skipMultiLineComment(parser, source, state);
              start = parser.tokenStart;
              continue;
            }
            if (context & 32) {
              return scanRegularExpression(parser);
            }
            if (ch === 61) {
              advanceChar(parser);
              return 4259875;
            }
          }
          return 8457014;
        }
        case 67108877: {
          const next = advanceChar(parser);
          if (next >= 48 && next <= 57)
            return scanNumber(parser, context, 64 | 16);
          if (next === 46) {
            const index = parser.index + 1;
            if (index < parser.end && source.charCodeAt(index) === 46) {
              parser.column += 2;
              parser.currentChar = source.charCodeAt(parser.index += 2);
              return 14;
            }
          }
          return 67108877;
        }
        case 8389702: {
          advanceChar(parser);
          const ch = parser.currentChar;
          if (ch === 124) {
            advanceChar(parser);
            if (parser.currentChar === 61) {
              advanceChar(parser);
              return 4194344;
            }
            return 8913465;
          }
          if (ch === 61) {
            advanceChar(parser);
            return 4194342;
          }
          return 8389702;
        }
        case 8390721: {
          advanceChar(parser);
          const ch = parser.currentChar;
          if (ch === 61) {
            advanceChar(parser);
            return 8390719;
          }
          if (ch !== 62)
            return 8390721;
          advanceChar(parser);
          if (parser.index < parser.end) {
            const ch2 = parser.currentChar;
            if (ch2 === 62) {
              if (advanceChar(parser) === 61) {
                advanceChar(parser);
                return 4194334;
              }
              return 8390980;
            }
            if (ch2 === 61) {
              advanceChar(parser);
              return 4194333;
            }
          }
          return 8390979;
        }
        case 8390213: {
          advanceChar(parser);
          const ch = parser.currentChar;
          if (ch === 38) {
            advanceChar(parser);
            if (parser.currentChar === 61) {
              advanceChar(parser);
              return 4194345;
            }
            return 8913720;
          }
          if (ch === 61) {
            advanceChar(parser);
            return 4194343;
          }
          return 8390213;
        }
        case 22: {
          let ch = advanceChar(parser);
          if (ch === 63) {
            advanceChar(parser);
            if (parser.currentChar === 61) {
              advanceChar(parser);
              return 4194346;
            }
            return 276824445;
          }
          if (ch === 46) {
            const index = parser.index + 1;
            if (index < parser.end) {
              ch = source.charCodeAt(index);
              if (!(ch >= 48 && ch <= 57)) {
                advanceChar(parser);
                return 67108990;
              }
            }
          }
          return 22;
        }
      }
    } else {
      if ((char ^ 8232) <= 1) {
        state = state & -5 | 1;
        scanNewLine(parser);
        continue;
      }
      const merged = consumePossibleSurrogatePair(parser);
      if (merged > 0)
        char = merged;
      if (isIDStart(char)) {
        parser.tokenValue = "";
        return scanIdentifierSlowCase(parser, context, 0, 0);
      }
      if (isExoticECMAScriptWhitespace(char)) {
        advanceChar(parser);
        continue;
      }
      parser.report(20, String.fromCodePoint(char));
    }
  }
  return 1048576;
}
__name(scanSingleToken, "scanSingleToken");
var entities = {
  AElig: "\xC6",
  AMP: "&",
  Aacute: "\xC1",
  Abreve: "\u0102",
  Acirc: "\xC2",
  Acy: "\u0410",
  Afr: "\u{1D504}",
  Agrave: "\xC0",
  Alpha: "\u0391",
  Amacr: "\u0100",
  And: "\u2A53",
  Aogon: "\u0104",
  Aopf: "\u{1D538}",
  ApplyFunction: "\u2061",
  Aring: "\xC5",
  Ascr: "\u{1D49C}",
  Assign: "\u2254",
  Atilde: "\xC3",
  Auml: "\xC4",
  Backslash: "\u2216",
  Barv: "\u2AE7",
  Barwed: "\u2306",
  Bcy: "\u0411",
  Because: "\u2235",
  Bernoullis: "\u212C",
  Beta: "\u0392",
  Bfr: "\u{1D505}",
  Bopf: "\u{1D539}",
  Breve: "\u02D8",
  Bscr: "\u212C",
  Bumpeq: "\u224E",
  CHcy: "\u0427",
  COPY: "\xA9",
  Cacute: "\u0106",
  Cap: "\u22D2",
  CapitalDifferentialD: "\u2145",
  Cayleys: "\u212D",
  Ccaron: "\u010C",
  Ccedil: "\xC7",
  Ccirc: "\u0108",
  Cconint: "\u2230",
  Cdot: "\u010A",
  Cedilla: "\xB8",
  CenterDot: "\xB7",
  Cfr: "\u212D",
  Chi: "\u03A7",
  CircleDot: "\u2299",
  CircleMinus: "\u2296",
  CirclePlus: "\u2295",
  CircleTimes: "\u2297",
  ClockwiseContourIntegral: "\u2232",
  CloseCurlyDoubleQuote: "\u201D",
  CloseCurlyQuote: "\u2019",
  Colon: "\u2237",
  Colone: "\u2A74",
  Congruent: "\u2261",
  Conint: "\u222F",
  ContourIntegral: "\u222E",
  Copf: "\u2102",
  Coproduct: "\u2210",
  CounterClockwiseContourIntegral: "\u2233",
  Cross: "\u2A2F",
  Cscr: "\u{1D49E}",
  Cup: "\u22D3",
  CupCap: "\u224D",
  DD: "\u2145",
  DDotrahd: "\u2911",
  DJcy: "\u0402",
  DScy: "\u0405",
  DZcy: "\u040F",
  Dagger: "\u2021",
  Darr: "\u21A1",
  Dashv: "\u2AE4",
  Dcaron: "\u010E",
  Dcy: "\u0414",
  Del: "\u2207",
  Delta: "\u0394",
  Dfr: "\u{1D507}",
  DiacriticalAcute: "\xB4",
  DiacriticalDot: "\u02D9",
  DiacriticalDoubleAcute: "\u02DD",
  DiacriticalGrave: "`",
  DiacriticalTilde: "\u02DC",
  Diamond: "\u22C4",
  DifferentialD: "\u2146",
  Dopf: "\u{1D53B}",
  Dot: "\xA8",
  DotDot: "\u20DC",
  DotEqual: "\u2250",
  DoubleContourIntegral: "\u222F",
  DoubleDot: "\xA8",
  DoubleDownArrow: "\u21D3",
  DoubleLeftArrow: "\u21D0",
  DoubleLeftRightArrow: "\u21D4",
  DoubleLeftTee: "\u2AE4",
  DoubleLongLeftArrow: "\u27F8",
  DoubleLongLeftRightArrow: "\u27FA",
  DoubleLongRightArrow: "\u27F9",
  DoubleRightArrow: "\u21D2",
  DoubleRightTee: "\u22A8",
  DoubleUpArrow: "\u21D1",
  DoubleUpDownArrow: "\u21D5",
  DoubleVerticalBar: "\u2225",
  DownArrow: "\u2193",
  DownArrowBar: "\u2913",
  DownArrowUpArrow: "\u21F5",
  DownBreve: "\u0311",
  DownLeftRightVector: "\u2950",
  DownLeftTeeVector: "\u295E",
  DownLeftVector: "\u21BD",
  DownLeftVectorBar: "\u2956",
  DownRightTeeVector: "\u295F",
  DownRightVector: "\u21C1",
  DownRightVectorBar: "\u2957",
  DownTee: "\u22A4",
  DownTeeArrow: "\u21A7",
  Downarrow: "\u21D3",
  Dscr: "\u{1D49F}",
  Dstrok: "\u0110",
  ENG: "\u014A",
  ETH: "\xD0",
  Eacute: "\xC9",
  Ecaron: "\u011A",
  Ecirc: "\xCA",
  Ecy: "\u042D",
  Edot: "\u0116",
  Efr: "\u{1D508}",
  Egrave: "\xC8",
  Element: "\u2208",
  Emacr: "\u0112",
  EmptySmallSquare: "\u25FB",
  EmptyVerySmallSquare: "\u25AB",
  Eogon: "\u0118",
  Eopf: "\u{1D53C}",
  Epsilon: "\u0395",
  Equal: "\u2A75",
  EqualTilde: "\u2242",
  Equilibrium: "\u21CC",
  Escr: "\u2130",
  Esim: "\u2A73",
  Eta: "\u0397",
  Euml: "\xCB",
  Exists: "\u2203",
  ExponentialE: "\u2147",
  Fcy: "\u0424",
  Ffr: "\u{1D509}",
  FilledSmallSquare: "\u25FC",
  FilledVerySmallSquare: "\u25AA",
  Fopf: "\u{1D53D}",
  ForAll: "\u2200",
  Fouriertrf: "\u2131",
  Fscr: "\u2131",
  GJcy: "\u0403",
  GT: ">",
  Gamma: "\u0393",
  Gammad: "\u03DC",
  Gbreve: "\u011E",
  Gcedil: "\u0122",
  Gcirc: "\u011C",
  Gcy: "\u0413",
  Gdot: "\u0120",
  Gfr: "\u{1D50A}",
  Gg: "\u22D9",
  Gopf: "\u{1D53E}",
  GreaterEqual: "\u2265",
  GreaterEqualLess: "\u22DB",
  GreaterFullEqual: "\u2267",
  GreaterGreater: "\u2AA2",
  GreaterLess: "\u2277",
  GreaterSlantEqual: "\u2A7E",
  GreaterTilde: "\u2273",
  Gscr: "\u{1D4A2}",
  Gt: "\u226B",
  HARDcy: "\u042A",
  Hacek: "\u02C7",
  Hat: "^",
  Hcirc: "\u0124",
  Hfr: "\u210C",
  HilbertSpace: "\u210B",
  Hopf: "\u210D",
  HorizontalLine: "\u2500",
  Hscr: "\u210B",
  Hstrok: "\u0126",
  HumpDownHump: "\u224E",
  HumpEqual: "\u224F",
  IEcy: "\u0415",
  IJlig: "\u0132",
  IOcy: "\u0401",
  Iacute: "\xCD",
  Icirc: "\xCE",
  Icy: "\u0418",
  Idot: "\u0130",
  Ifr: "\u2111",
  Igrave: "\xCC",
  Im: "\u2111",
  Imacr: "\u012A",
  ImaginaryI: "\u2148",
  Implies: "\u21D2",
  Int: "\u222C",
  Integral: "\u222B",
  Intersection: "\u22C2",
  InvisibleComma: "\u2063",
  InvisibleTimes: "\u2062",
  Iogon: "\u012E",
  Iopf: "\u{1D540}",
  Iota: "\u0399",
  Iscr: "\u2110",
  Itilde: "\u0128",
  Iukcy: "\u0406",
  Iuml: "\xCF",
  Jcirc: "\u0134",
  Jcy: "\u0419",
  Jfr: "\u{1D50D}",
  Jopf: "\u{1D541}",
  Jscr: "\u{1D4A5}",
  Jsercy: "\u0408",
  Jukcy: "\u0404",
  KHcy: "\u0425",
  KJcy: "\u040C",
  Kappa: "\u039A",
  Kcedil: "\u0136",
  Kcy: "\u041A",
  Kfr: "\u{1D50E}",
  Kopf: "\u{1D542}",
  Kscr: "\u{1D4A6}",
  LJcy: "\u0409",
  LT: "<",
  Lacute: "\u0139",
  Lambda: "\u039B",
  Lang: "\u27EA",
  Laplacetrf: "\u2112",
  Larr: "\u219E",
  Lcaron: "\u013D",
  Lcedil: "\u013B",
  Lcy: "\u041B",
  LeftAngleBracket: "\u27E8",
  LeftArrow: "\u2190",
  LeftArrowBar: "\u21E4",
  LeftArrowRightArrow: "\u21C6",
  LeftCeiling: "\u2308",
  LeftDoubleBracket: "\u27E6",
  LeftDownTeeVector: "\u2961",
  LeftDownVector: "\u21C3",
  LeftDownVectorBar: "\u2959",
  LeftFloor: "\u230A",
  LeftRightArrow: "\u2194",
  LeftRightVector: "\u294E",
  LeftTee: "\u22A3",
  LeftTeeArrow: "\u21A4",
  LeftTeeVector: "\u295A",
  LeftTriangle: "\u22B2",
  LeftTriangleBar: "\u29CF",
  LeftTriangleEqual: "\u22B4",
  LeftUpDownVector: "\u2951",
  LeftUpTeeVector: "\u2960",
  LeftUpVector: "\u21BF",
  LeftUpVectorBar: "\u2958",
  LeftVector: "\u21BC",
  LeftVectorBar: "\u2952",
  Leftarrow: "\u21D0",
  Leftrightarrow: "\u21D4",
  LessEqualGreater: "\u22DA",
  LessFullEqual: "\u2266",
  LessGreater: "\u2276",
  LessLess: "\u2AA1",
  LessSlantEqual: "\u2A7D",
  LessTilde: "\u2272",
  Lfr: "\u{1D50F}",
  Ll: "\u22D8",
  Lleftarrow: "\u21DA",
  Lmidot: "\u013F",
  LongLeftArrow: "\u27F5",
  LongLeftRightArrow: "\u27F7",
  LongRightArrow: "\u27F6",
  Longleftarrow: "\u27F8",
  Longleftrightarrow: "\u27FA",
  Longrightarrow: "\u27F9",
  Lopf: "\u{1D543}",
  LowerLeftArrow: "\u2199",
  LowerRightArrow: "\u2198",
  Lscr: "\u2112",
  Lsh: "\u21B0",
  Lstrok: "\u0141",
  Lt: "\u226A",
  Map: "\u2905",
  Mcy: "\u041C",
  MediumSpace: "\u205F",
  Mellintrf: "\u2133",
  Mfr: "\u{1D510}",
  MinusPlus: "\u2213",
  Mopf: "\u{1D544}",
  Mscr: "\u2133",
  Mu: "\u039C",
  NJcy: "\u040A",
  Nacute: "\u0143",
  Ncaron: "\u0147",
  Ncedil: "\u0145",
  Ncy: "\u041D",
  NegativeMediumSpace: "\u200B",
  NegativeThickSpace: "\u200B",
  NegativeThinSpace: "\u200B",
  NegativeVeryThinSpace: "\u200B",
  NestedGreaterGreater: "\u226B",
  NestedLessLess: "\u226A",
  NewLine: "\n",
  Nfr: "\u{1D511}",
  NoBreak: "\u2060",
  NonBreakingSpace: "\xA0",
  Nopf: "\u2115",
  Not: "\u2AEC",
  NotCongruent: "\u2262",
  NotCupCap: "\u226D",
  NotDoubleVerticalBar: "\u2226",
  NotElement: "\u2209",
  NotEqual: "\u2260",
  NotEqualTilde: "\u2242\u0338",
  NotExists: "\u2204",
  NotGreater: "\u226F",
  NotGreaterEqual: "\u2271",
  NotGreaterFullEqual: "\u2267\u0338",
  NotGreaterGreater: "\u226B\u0338",
  NotGreaterLess: "\u2279",
  NotGreaterSlantEqual: "\u2A7E\u0338",
  NotGreaterTilde: "\u2275",
  NotHumpDownHump: "\u224E\u0338",
  NotHumpEqual: "\u224F\u0338",
  NotLeftTriangle: "\u22EA",
  NotLeftTriangleBar: "\u29CF\u0338",
  NotLeftTriangleEqual: "\u22EC",
  NotLess: "\u226E",
  NotLessEqual: "\u2270",
  NotLessGreater: "\u2278",
  NotLessLess: "\u226A\u0338",
  NotLessSlantEqual: "\u2A7D\u0338",
  NotLessTilde: "\u2274",
  NotNestedGreaterGreater: "\u2AA2\u0338",
  NotNestedLessLess: "\u2AA1\u0338",
  NotPrecedes: "\u2280",
  NotPrecedesEqual: "\u2AAF\u0338",
  NotPrecedesSlantEqual: "\u22E0",
  NotReverseElement: "\u220C",
  NotRightTriangle: "\u22EB",
  NotRightTriangleBar: "\u29D0\u0338",
  NotRightTriangleEqual: "\u22ED",
  NotSquareSubset: "\u228F\u0338",
  NotSquareSubsetEqual: "\u22E2",
  NotSquareSuperset: "\u2290\u0338",
  NotSquareSupersetEqual: "\u22E3",
  NotSubset: "\u2282\u20D2",
  NotSubsetEqual: "\u2288",
  NotSucceeds: "\u2281",
  NotSucceedsEqual: "\u2AB0\u0338",
  NotSucceedsSlantEqual: "\u22E1",
  NotSucceedsTilde: "\u227F\u0338",
  NotSuperset: "\u2283\u20D2",
  NotSupersetEqual: "\u2289",
  NotTilde: "\u2241",
  NotTildeEqual: "\u2244",
  NotTildeFullEqual: "\u2247",
  NotTildeTilde: "\u2249",
  NotVerticalBar: "\u2224",
  Nscr: "\u{1D4A9}",
  Ntilde: "\xD1",
  Nu: "\u039D",
  OElig: "\u0152",
  Oacute: "\xD3",
  Ocirc: "\xD4",
  Ocy: "\u041E",
  Odblac: "\u0150",
  Ofr: "\u{1D512}",
  Ograve: "\xD2",
  Omacr: "\u014C",
  Omega: "\u03A9",
  Omicron: "\u039F",
  Oopf: "\u{1D546}",
  OpenCurlyDoubleQuote: "\u201C",
  OpenCurlyQuote: "\u2018",
  Or: "\u2A54",
  Oscr: "\u{1D4AA}",
  Oslash: "\xD8",
  Otilde: "\xD5",
  Otimes: "\u2A37",
  Ouml: "\xD6",
  OverBar: "\u203E",
  OverBrace: "\u23DE",
  OverBracket: "\u23B4",
  OverParenthesis: "\u23DC",
  PartialD: "\u2202",
  Pcy: "\u041F",
  Pfr: "\u{1D513}",
  Phi: "\u03A6",
  Pi: "\u03A0",
  PlusMinus: "\xB1",
  Poincareplane: "\u210C",
  Popf: "\u2119",
  Pr: "\u2ABB",
  Precedes: "\u227A",
  PrecedesEqual: "\u2AAF",
  PrecedesSlantEqual: "\u227C",
  PrecedesTilde: "\u227E",
  Prime: "\u2033",
  Product: "\u220F",
  Proportion: "\u2237",
  Proportional: "\u221D",
  Pscr: "\u{1D4AB}",
  Psi: "\u03A8",
  QUOT: '"',
  Qfr: "\u{1D514}",
  Qopf: "\u211A",
  Qscr: "\u{1D4AC}",
  RBarr: "\u2910",
  REG: "\xAE",
  Racute: "\u0154",
  Rang: "\u27EB",
  Rarr: "\u21A0",
  Rarrtl: "\u2916",
  Rcaron: "\u0158",
  Rcedil: "\u0156",
  Rcy: "\u0420",
  Re: "\u211C",
  ReverseElement: "\u220B",
  ReverseEquilibrium: "\u21CB",
  ReverseUpEquilibrium: "\u296F",
  Rfr: "\u211C",
  Rho: "\u03A1",
  RightAngleBracket: "\u27E9",
  RightArrow: "\u2192",
  RightArrowBar: "\u21E5",
  RightArrowLeftArrow: "\u21C4",
  RightCeiling: "\u2309",
  RightDoubleBracket: "\u27E7",
  RightDownTeeVector: "\u295D",
  RightDownVector: "\u21C2",
  RightDownVectorBar: "\u2955",
  RightFloor: "\u230B",
  RightTee: "\u22A2",
  RightTeeArrow: "\u21A6",
  RightTeeVector: "\u295B",
  RightTriangle: "\u22B3",
  RightTriangleBar: "\u29D0",
  RightTriangleEqual: "\u22B5",
  RightUpDownVector: "\u294F",
  RightUpTeeVector: "\u295C",
  RightUpVector: "\u21BE",
  RightUpVectorBar: "\u2954",
  RightVector: "\u21C0",
  RightVectorBar: "\u2953",
  Rightarrow: "\u21D2",
  Ropf: "\u211D",
  RoundImplies: "\u2970",
  Rrightarrow: "\u21DB",
  Rscr: "\u211B",
  Rsh: "\u21B1",
  RuleDelayed: "\u29F4",
  SHCHcy: "\u0429",
  SHcy: "\u0428",
  SOFTcy: "\u042C",
  Sacute: "\u015A",
  Sc: "\u2ABC",
  Scaron: "\u0160",
  Scedil: "\u015E",
  Scirc: "\u015C",
  Scy: "\u0421",
  Sfr: "\u{1D516}",
  ShortDownArrow: "\u2193",
  ShortLeftArrow: "\u2190",
  ShortRightArrow: "\u2192",
  ShortUpArrow: "\u2191",
  Sigma: "\u03A3",
  SmallCircle: "\u2218",
  Sopf: "\u{1D54A}",
  Sqrt: "\u221A",
  Square: "\u25A1",
  SquareIntersection: "\u2293",
  SquareSubset: "\u228F",
  SquareSubsetEqual: "\u2291",
  SquareSuperset: "\u2290",
  SquareSupersetEqual: "\u2292",
  SquareUnion: "\u2294",
  Sscr: "\u{1D4AE}",
  Star: "\u22C6",
  Sub: "\u22D0",
  Subset: "\u22D0",
  SubsetEqual: "\u2286",
  Succeeds: "\u227B",
  SucceedsEqual: "\u2AB0",
  SucceedsSlantEqual: "\u227D",
  SucceedsTilde: "\u227F",
  SuchThat: "\u220B",
  Sum: "\u2211",
  Sup: "\u22D1",
  Superset: "\u2283",
  SupersetEqual: "\u2287",
  Supset: "\u22D1",
  THORN: "\xDE",
  TRADE: "\u2122",
  TSHcy: "\u040B",
  TScy: "\u0426",
  Tab: "	",
  Tau: "\u03A4",
  Tcaron: "\u0164",
  Tcedil: "\u0162",
  Tcy: "\u0422",
  Tfr: "\u{1D517}",
  Therefore: "\u2234",
  Theta: "\u0398",
  ThickSpace: "\u205F\u200A",
  ThinSpace: "\u2009",
  Tilde: "\u223C",
  TildeEqual: "\u2243",
  TildeFullEqual: "\u2245",
  TildeTilde: "\u2248",
  Topf: "\u{1D54B}",
  TripleDot: "\u20DB",
  Tscr: "\u{1D4AF}",
  Tstrok: "\u0166",
  Uacute: "\xDA",
  Uarr: "\u219F",
  Uarrocir: "\u2949",
  Ubrcy: "\u040E",
  Ubreve: "\u016C",
  Ucirc: "\xDB",
  Ucy: "\u0423",
  Udblac: "\u0170",
  Ufr: "\u{1D518}",
  Ugrave: "\xD9",
  Umacr: "\u016A",
  UnderBar: "_",
  UnderBrace: "\u23DF",
  UnderBracket: "\u23B5",
  UnderParenthesis: "\u23DD",
  Union: "\u22C3",
  UnionPlus: "\u228E",
  Uogon: "\u0172",
  Uopf: "\u{1D54C}",
  UpArrow: "\u2191",
  UpArrowBar: "\u2912",
  UpArrowDownArrow: "\u21C5",
  UpDownArrow: "\u2195",
  UpEquilibrium: "\u296E",
  UpTee: "\u22A5",
  UpTeeArrow: "\u21A5",
  Uparrow: "\u21D1",
  Updownarrow: "\u21D5",
  UpperLeftArrow: "\u2196",
  UpperRightArrow: "\u2197",
  Upsi: "\u03D2",
  Upsilon: "\u03A5",
  Uring: "\u016E",
  Uscr: "\u{1D4B0}",
  Utilde: "\u0168",
  Uuml: "\xDC",
  VDash: "\u22AB",
  Vbar: "\u2AEB",
  Vcy: "\u0412",
  Vdash: "\u22A9",
  Vdashl: "\u2AE6",
  Vee: "\u22C1",
  Verbar: "\u2016",
  Vert: "\u2016",
  VerticalBar: "\u2223",
  VerticalLine: "|",
  VerticalSeparator: "\u2758",
  VerticalTilde: "\u2240",
  VeryThinSpace: "\u200A",
  Vfr: "\u{1D519}",
  Vopf: "\u{1D54D}",
  Vscr: "\u{1D4B1}",
  Vvdash: "\u22AA",
  Wcirc: "\u0174",
  Wedge: "\u22C0",
  Wfr: "\u{1D51A}",
  Wopf: "\u{1D54E}",
  Wscr: "\u{1D4B2}",
  Xfr: "\u{1D51B}",
  Xi: "\u039E",
  Xopf: "\u{1D54F}",
  Xscr: "\u{1D4B3}",
  YAcy: "\u042F",
  YIcy: "\u0407",
  YUcy: "\u042E",
  Yacute: "\xDD",
  Ycirc: "\u0176",
  Ycy: "\u042B",
  Yfr: "\u{1D51C}",
  Yopf: "\u{1D550}",
  Yscr: "\u{1D4B4}",
  Yuml: "\u0178",
  ZHcy: "\u0416",
  Zacute: "\u0179",
  Zcaron: "\u017D",
  Zcy: "\u0417",
  Zdot: "\u017B",
  ZeroWidthSpace: "\u200B",
  Zeta: "\u0396",
  Zfr: "\u2128",
  Zopf: "\u2124",
  Zscr: "\u{1D4B5}",
  aacute: "\xE1",
  abreve: "\u0103",
  ac: "\u223E",
  acE: "\u223E\u0333",
  acd: "\u223F",
  acirc: "\xE2",
  acute: "\xB4",
  acy: "\u0430",
  aelig: "\xE6",
  af: "\u2061",
  afr: "\u{1D51E}",
  agrave: "\xE0",
  alefsym: "\u2135",
  aleph: "\u2135",
  alpha: "\u03B1",
  amacr: "\u0101",
  amalg: "\u2A3F",
  amp: "&",
  and: "\u2227",
  andand: "\u2A55",
  andd: "\u2A5C",
  andslope: "\u2A58",
  andv: "\u2A5A",
  ang: "\u2220",
  ange: "\u29A4",
  angle: "\u2220",
  angmsd: "\u2221",
  angmsdaa: "\u29A8",
  angmsdab: "\u29A9",
  angmsdac: "\u29AA",
  angmsdad: "\u29AB",
  angmsdae: "\u29AC",
  angmsdaf: "\u29AD",
  angmsdag: "\u29AE",
  angmsdah: "\u29AF",
  angrt: "\u221F",
  angrtvb: "\u22BE",
  angrtvbd: "\u299D",
  angsph: "\u2222",
  angst: "\xC5",
  angzarr: "\u237C",
  aogon: "\u0105",
  aopf: "\u{1D552}",
  ap: "\u2248",
  apE: "\u2A70",
  apacir: "\u2A6F",
  ape: "\u224A",
  apid: "\u224B",
  apos: "'",
  approx: "\u2248",
  approxeq: "\u224A",
  aring: "\xE5",
  ascr: "\u{1D4B6}",
  ast: "*",
  asymp: "\u2248",
  asympeq: "\u224D",
  atilde: "\xE3",
  auml: "\xE4",
  awconint: "\u2233",
  awint: "\u2A11",
  bNot: "\u2AED",
  backcong: "\u224C",
  backepsilon: "\u03F6",
  backprime: "\u2035",
  backsim: "\u223D",
  backsimeq: "\u22CD",
  barvee: "\u22BD",
  barwed: "\u2305",
  barwedge: "\u2305",
  bbrk: "\u23B5",
  bbrktbrk: "\u23B6",
  bcong: "\u224C",
  bcy: "\u0431",
  bdquo: "\u201E",
  becaus: "\u2235",
  because: "\u2235",
  bemptyv: "\u29B0",
  bepsi: "\u03F6",
  bernou: "\u212C",
  beta: "\u03B2",
  beth: "\u2136",
  between: "\u226C",
  bfr: "\u{1D51F}",
  bigcap: "\u22C2",
  bigcirc: "\u25EF",
  bigcup: "\u22C3",
  bigodot: "\u2A00",
  bigoplus: "\u2A01",
  bigotimes: "\u2A02",
  bigsqcup: "\u2A06",
  bigstar: "\u2605",
  bigtriangledown: "\u25BD",
  bigtriangleup: "\u25B3",
  biguplus: "\u2A04",
  bigvee: "\u22C1",
  bigwedge: "\u22C0",
  bkarow: "\u290D",
  blacklozenge: "\u29EB",
  blacksquare: "\u25AA",
  blacktriangle: "\u25B4",
  blacktriangledown: "\u25BE",
  blacktriangleleft: "\u25C2",
  blacktriangleright: "\u25B8",
  blank: "\u2423",
  blk12: "\u2592",
  blk14: "\u2591",
  blk34: "\u2593",
  block: "\u2588",
  bne: "=\u20E5",
  bnequiv: "\u2261\u20E5",
  bnot: "\u2310",
  bopf: "\u{1D553}",
  bot: "\u22A5",
  bottom: "\u22A5",
  bowtie: "\u22C8",
  boxDL: "\u2557",
  boxDR: "\u2554",
  boxDl: "\u2556",
  boxDr: "\u2553",
  boxH: "\u2550",
  boxHD: "\u2566",
  boxHU: "\u2569",
  boxHd: "\u2564",
  boxHu: "\u2567",
  boxUL: "\u255D",
  boxUR: "\u255A",
  boxUl: "\u255C",
  boxUr: "\u2559",
  boxV: "\u2551",
  boxVH: "\u256C",
  boxVL: "\u2563",
  boxVR: "\u2560",
  boxVh: "\u256B",
  boxVl: "\u2562",
  boxVr: "\u255F",
  boxbox: "\u29C9",
  boxdL: "\u2555",
  boxdR: "\u2552",
  boxdl: "\u2510",
  boxdr: "\u250C",
  boxh: "\u2500",
  boxhD: "\u2565",
  boxhU: "\u2568",
  boxhd: "\u252C",
  boxhu: "\u2534",
  boxminus: "\u229F",
  boxplus: "\u229E",
  boxtimes: "\u22A0",
  boxuL: "\u255B",
  boxuR: "\u2558",
  boxul: "\u2518",
  boxur: "\u2514",
  boxv: "\u2502",
  boxvH: "\u256A",
  boxvL: "\u2561",
  boxvR: "\u255E",
  boxvh: "\u253C",
  boxvl: "\u2524",
  boxvr: "\u251C",
  bprime: "\u2035",
  breve: "\u02D8",
  brvbar: "\xA6",
  bscr: "\u{1D4B7}",
  bsemi: "\u204F",
  bsim: "\u223D",
  bsime: "\u22CD",
  bsol: "\\",
  bsolb: "\u29C5",
  bsolhsub: "\u27C8",
  bull: "\u2022",
  bullet: "\u2022",
  bump: "\u224E",
  bumpE: "\u2AAE",
  bumpe: "\u224F",
  bumpeq: "\u224F",
  cacute: "\u0107",
  cap: "\u2229",
  capand: "\u2A44",
  capbrcup: "\u2A49",
  capcap: "\u2A4B",
  capcup: "\u2A47",
  capdot: "\u2A40",
  caps: "\u2229\uFE00",
  caret: "\u2041",
  caron: "\u02C7",
  ccaps: "\u2A4D",
  ccaron: "\u010D",
  ccedil: "\xE7",
  ccirc: "\u0109",
  ccups: "\u2A4C",
  ccupssm: "\u2A50",
  cdot: "\u010B",
  cedil: "\xB8",
  cemptyv: "\u29B2",
  cent: "\xA2",
  centerdot: "\xB7",
  cfr: "\u{1D520}",
  chcy: "\u0447",
  check: "\u2713",
  checkmark: "\u2713",
  chi: "\u03C7",
  cir: "\u25CB",
  cirE: "\u29C3",
  circ: "\u02C6",
  circeq: "\u2257",
  circlearrowleft: "\u21BA",
  circlearrowright: "\u21BB",
  circledR: "\xAE",
  circledS: "\u24C8",
  circledast: "\u229B",
  circledcirc: "\u229A",
  circleddash: "\u229D",
  cire: "\u2257",
  cirfnint: "\u2A10",
  cirmid: "\u2AEF",
  cirscir: "\u29C2",
  clubs: "\u2663",
  clubsuit: "\u2663",
  colon: ":",
  colone: "\u2254",
  coloneq: "\u2254",
  comma: ",",
  commat: "@",
  comp: "\u2201",
  compfn: "\u2218",
  complement: "\u2201",
  complexes: "\u2102",
  cong: "\u2245",
  congdot: "\u2A6D",
  conint: "\u222E",
  copf: "\u{1D554}",
  coprod: "\u2210",
  copy: "\xA9",
  copysr: "\u2117",
  crarr: "\u21B5",
  cross: "\u2717",
  cscr: "\u{1D4B8}",
  csub: "\u2ACF",
  csube: "\u2AD1",
  csup: "\u2AD0",
  csupe: "\u2AD2",
  ctdot: "\u22EF",
  cudarrl: "\u2938",
  cudarrr: "\u2935",
  cuepr: "\u22DE",
  cuesc: "\u22DF",
  cularr: "\u21B6",
  cularrp: "\u293D",
  cup: "\u222A",
  cupbrcap: "\u2A48",
  cupcap: "\u2A46",
  cupcup: "\u2A4A",
  cupdot: "\u228D",
  cupor: "\u2A45",
  cups: "\u222A\uFE00",
  curarr: "\u21B7",
  curarrm: "\u293C",
  curlyeqprec: "\u22DE",
  curlyeqsucc: "\u22DF",
  curlyvee: "\u22CE",
  curlywedge: "\u22CF",
  curren: "\xA4",
  curvearrowleft: "\u21B6",
  curvearrowright: "\u21B7",
  cuvee: "\u22CE",
  cuwed: "\u22CF",
  cwconint: "\u2232",
  cwint: "\u2231",
  cylcty: "\u232D",
  dArr: "\u21D3",
  dHar: "\u2965",
  dagger: "\u2020",
  daleth: "\u2138",
  darr: "\u2193",
  dash: "\u2010",
  dashv: "\u22A3",
  dbkarow: "\u290F",
  dblac: "\u02DD",
  dcaron: "\u010F",
  dcy: "\u0434",
  dd: "\u2146",
  ddagger: "\u2021",
  ddarr: "\u21CA",
  ddotseq: "\u2A77",
  deg: "\xB0",
  delta: "\u03B4",
  demptyv: "\u29B1",
  dfisht: "\u297F",
  dfr: "\u{1D521}",
  dharl: "\u21C3",
  dharr: "\u21C2",
  diam: "\u22C4",
  diamond: "\u22C4",
  diamondsuit: "\u2666",
  diams: "\u2666",
  die: "\xA8",
  digamma: "\u03DD",
  disin: "\u22F2",
  div: "\xF7",
  divide: "\xF7",
  divideontimes: "\u22C7",
  divonx: "\u22C7",
  djcy: "\u0452",
  dlcorn: "\u231E",
  dlcrop: "\u230D",
  dollar: "$",
  dopf: "\u{1D555}",
  dot: "\u02D9",
  doteq: "\u2250",
  doteqdot: "\u2251",
  dotminus: "\u2238",
  dotplus: "\u2214",
  dotsquare: "\u22A1",
  doublebarwedge: "\u2306",
  downarrow: "\u2193",
  downdownarrows: "\u21CA",
  downharpoonleft: "\u21C3",
  downharpoonright: "\u21C2",
  drbkarow: "\u2910",
  drcorn: "\u231F",
  drcrop: "\u230C",
  dscr: "\u{1D4B9}",
  dscy: "\u0455",
  dsol: "\u29F6",
  dstrok: "\u0111",
  dtdot: "\u22F1",
  dtri: "\u25BF",
  dtrif: "\u25BE",
  duarr: "\u21F5",
  duhar: "\u296F",
  dwangle: "\u29A6",
  dzcy: "\u045F",
  dzigrarr: "\u27FF",
  eDDot: "\u2A77",
  eDot: "\u2251",
  eacute: "\xE9",
  easter: "\u2A6E",
  ecaron: "\u011B",
  ecir: "\u2256",
  ecirc: "\xEA",
  ecolon: "\u2255",
  ecy: "\u044D",
  edot: "\u0117",
  ee: "\u2147",
  efDot: "\u2252",
  efr: "\u{1D522}",
  eg: "\u2A9A",
  egrave: "\xE8",
  egs: "\u2A96",
  egsdot: "\u2A98",
  el: "\u2A99",
  elinters: "\u23E7",
  ell: "\u2113",
  els: "\u2A95",
  elsdot: "\u2A97",
  emacr: "\u0113",
  empty: "\u2205",
  emptyset: "\u2205",
  emptyv: "\u2205",
  emsp13: "\u2004",
  emsp14: "\u2005",
  emsp: "\u2003",
  eng: "\u014B",
  ensp: "\u2002",
  eogon: "\u0119",
  eopf: "\u{1D556}",
  epar: "\u22D5",
  eparsl: "\u29E3",
  eplus: "\u2A71",
  epsi: "\u03B5",
  epsilon: "\u03B5",
  epsiv: "\u03F5",
  eqcirc: "\u2256",
  eqcolon: "\u2255",
  eqsim: "\u2242",
  eqslantgtr: "\u2A96",
  eqslantless: "\u2A95",
  equals: "=",
  equest: "\u225F",
  equiv: "\u2261",
  equivDD: "\u2A78",
  eqvparsl: "\u29E5",
  erDot: "\u2253",
  erarr: "\u2971",
  escr: "\u212F",
  esdot: "\u2250",
  esim: "\u2242",
  eta: "\u03B7",
  eth: "\xF0",
  euml: "\xEB",
  euro: "\u20AC",
  excl: "!",
  exist: "\u2203",
  expectation: "\u2130",
  exponentiale: "\u2147",
  fallingdotseq: "\u2252",
  fcy: "\u0444",
  female: "\u2640",
  ffilig: "\uFB03",
  fflig: "\uFB00",
  ffllig: "\uFB04",
  ffr: "\u{1D523}",
  filig: "\uFB01",
  fjlig: "fj",
  flat: "\u266D",
  fllig: "\uFB02",
  fltns: "\u25B1",
  fnof: "\u0192",
  fopf: "\u{1D557}",
  forall: "\u2200",
  fork: "\u22D4",
  forkv: "\u2AD9",
  fpartint: "\u2A0D",
  frac12: "\xBD",
  frac13: "\u2153",
  frac14: "\xBC",
  frac15: "\u2155",
  frac16: "\u2159",
  frac18: "\u215B",
  frac23: "\u2154",
  frac25: "\u2156",
  frac34: "\xBE",
  frac35: "\u2157",
  frac38: "\u215C",
  frac45: "\u2158",
  frac56: "\u215A",
  frac58: "\u215D",
  frac78: "\u215E",
  frasl: "\u2044",
  frown: "\u2322",
  fscr: "\u{1D4BB}",
  gE: "\u2267",
  gEl: "\u2A8C",
  gacute: "\u01F5",
  gamma: "\u03B3",
  gammad: "\u03DD",
  gap: "\u2A86",
  gbreve: "\u011F",
  gcirc: "\u011D",
  gcy: "\u0433",
  gdot: "\u0121",
  ge: "\u2265",
  gel: "\u22DB",
  geq: "\u2265",
  geqq: "\u2267",
  geqslant: "\u2A7E",
  ges: "\u2A7E",
  gescc: "\u2AA9",
  gesdot: "\u2A80",
  gesdoto: "\u2A82",
  gesdotol: "\u2A84",
  gesl: "\u22DB\uFE00",
  gesles: "\u2A94",
  gfr: "\u{1D524}",
  gg: "\u226B",
  ggg: "\u22D9",
  gimel: "\u2137",
  gjcy: "\u0453",
  gl: "\u2277",
  glE: "\u2A92",
  gla: "\u2AA5",
  glj: "\u2AA4",
  gnE: "\u2269",
  gnap: "\u2A8A",
  gnapprox: "\u2A8A",
  gne: "\u2A88",
  gneq: "\u2A88",
  gneqq: "\u2269",
  gnsim: "\u22E7",
  gopf: "\u{1D558}",
  grave: "`",
  gscr: "\u210A",
  gsim: "\u2273",
  gsime: "\u2A8E",
  gsiml: "\u2A90",
  gt: ">",
  gtcc: "\u2AA7",
  gtcir: "\u2A7A",
  gtdot: "\u22D7",
  gtlPar: "\u2995",
  gtquest: "\u2A7C",
  gtrapprox: "\u2A86",
  gtrarr: "\u2978",
  gtrdot: "\u22D7",
  gtreqless: "\u22DB",
  gtreqqless: "\u2A8C",
  gtrless: "\u2277",
  gtrsim: "\u2273",
  gvertneqq: "\u2269\uFE00",
  gvnE: "\u2269\uFE00",
  hArr: "\u21D4",
  hairsp: "\u200A",
  half: "\xBD",
  hamilt: "\u210B",
  hardcy: "\u044A",
  harr: "\u2194",
  harrcir: "\u2948",
  harrw: "\u21AD",
  hbar: "\u210F",
  hcirc: "\u0125",
  hearts: "\u2665",
  heartsuit: "\u2665",
  hellip: "\u2026",
  hercon: "\u22B9",
  hfr: "\u{1D525}",
  hksearow: "\u2925",
  hkswarow: "\u2926",
  hoarr: "\u21FF",
  homtht: "\u223B",
  hookleftarrow: "\u21A9",
  hookrightarrow: "\u21AA",
  hopf: "\u{1D559}",
  horbar: "\u2015",
  hscr: "\u{1D4BD}",
  hslash: "\u210F",
  hstrok: "\u0127",
  hybull: "\u2043",
  hyphen: "\u2010",
  iacute: "\xED",
  ic: "\u2063",
  icirc: "\xEE",
  icy: "\u0438",
  iecy: "\u0435",
  iexcl: "\xA1",
  iff: "\u21D4",
  ifr: "\u{1D526}",
  igrave: "\xEC",
  ii: "\u2148",
  iiiint: "\u2A0C",
  iiint: "\u222D",
  iinfin: "\u29DC",
  iiota: "\u2129",
  ijlig: "\u0133",
  imacr: "\u012B",
  image: "\u2111",
  imagline: "\u2110",
  imagpart: "\u2111",
  imath: "\u0131",
  imof: "\u22B7",
  imped: "\u01B5",
  in: "\u2208",
  incare: "\u2105",
  infin: "\u221E",
  infintie: "\u29DD",
  inodot: "\u0131",
  int: "\u222B",
  intcal: "\u22BA",
  integers: "\u2124",
  intercal: "\u22BA",
  intlarhk: "\u2A17",
  intprod: "\u2A3C",
  iocy: "\u0451",
  iogon: "\u012F",
  iopf: "\u{1D55A}",
  iota: "\u03B9",
  iprod: "\u2A3C",
  iquest: "\xBF",
  iscr: "\u{1D4BE}",
  isin: "\u2208",
  isinE: "\u22F9",
  isindot: "\u22F5",
  isins: "\u22F4",
  isinsv: "\u22F3",
  isinv: "\u2208",
  it: "\u2062",
  itilde: "\u0129",
  iukcy: "\u0456",
  iuml: "\xEF",
  jcirc: "\u0135",
  jcy: "\u0439",
  jfr: "\u{1D527}",
  jmath: "\u0237",
  jopf: "\u{1D55B}",
  jscr: "\u{1D4BF}",
  jsercy: "\u0458",
  jukcy: "\u0454",
  kappa: "\u03BA",
  kappav: "\u03F0",
  kcedil: "\u0137",
  kcy: "\u043A",
  kfr: "\u{1D528}",
  kgreen: "\u0138",
  khcy: "\u0445",
  kjcy: "\u045C",
  kopf: "\u{1D55C}",
  kscr: "\u{1D4C0}",
  lAarr: "\u21DA",
  lArr: "\u21D0",
  lAtail: "\u291B",
  lBarr: "\u290E",
  lE: "\u2266",
  lEg: "\u2A8B",
  lHar: "\u2962",
  lacute: "\u013A",
  laemptyv: "\u29B4",
  lagran: "\u2112",
  lambda: "\u03BB",
  lang: "\u27E8",
  langd: "\u2991",
  langle: "\u27E8",
  lap: "\u2A85",
  laquo: "\xAB",
  larr: "\u2190",
  larrb: "\u21E4",
  larrbfs: "\u291F",
  larrfs: "\u291D",
  larrhk: "\u21A9",
  larrlp: "\u21AB",
  larrpl: "\u2939",
  larrsim: "\u2973",
  larrtl: "\u21A2",
  lat: "\u2AAB",
  latail: "\u2919",
  late: "\u2AAD",
  lates: "\u2AAD\uFE00",
  lbarr: "\u290C",
  lbbrk: "\u2772",
  lbrace: "{",
  lbrack: "[",
  lbrke: "\u298B",
  lbrksld: "\u298F",
  lbrkslu: "\u298D",
  lcaron: "\u013E",
  lcedil: "\u013C",
  lceil: "\u2308",
  lcub: "{",
  lcy: "\u043B",
  ldca: "\u2936",
  ldquo: "\u201C",
  ldquor: "\u201E",
  ldrdhar: "\u2967",
  ldrushar: "\u294B",
  ldsh: "\u21B2",
  le: "\u2264",
  leftarrow: "\u2190",
  leftarrowtail: "\u21A2",
  leftharpoondown: "\u21BD",
  leftharpoonup: "\u21BC",
  leftleftarrows: "\u21C7",
  leftrightarrow: "\u2194",
  leftrightarrows: "\u21C6",
  leftrightharpoons: "\u21CB",
  leftrightsquigarrow: "\u21AD",
  leftthreetimes: "\u22CB",
  leg: "\u22DA",
  leq: "\u2264",
  leqq: "\u2266",
  leqslant: "\u2A7D",
  les: "\u2A7D",
  lescc: "\u2AA8",
  lesdot: "\u2A7F",
  lesdoto: "\u2A81",
  lesdotor: "\u2A83",
  lesg: "\u22DA\uFE00",
  lesges: "\u2A93",
  lessapprox: "\u2A85",
  lessdot: "\u22D6",
  lesseqgtr: "\u22DA",
  lesseqqgtr: "\u2A8B",
  lessgtr: "\u2276",
  lesssim: "\u2272",
  lfisht: "\u297C",
  lfloor: "\u230A",
  lfr: "\u{1D529}",
  lg: "\u2276",
  lgE: "\u2A91",
  lhard: "\u21BD",
  lharu: "\u21BC",
  lharul: "\u296A",
  lhblk: "\u2584",
  ljcy: "\u0459",
  ll: "\u226A",
  llarr: "\u21C7",
  llcorner: "\u231E",
  llhard: "\u296B",
  lltri: "\u25FA",
  lmidot: "\u0140",
  lmoust: "\u23B0",
  lmoustache: "\u23B0",
  lnE: "\u2268",
  lnap: "\u2A89",
  lnapprox: "\u2A89",
  lne: "\u2A87",
  lneq: "\u2A87",
  lneqq: "\u2268",
  lnsim: "\u22E6",
  loang: "\u27EC",
  loarr: "\u21FD",
  lobrk: "\u27E6",
  longleftarrow: "\u27F5",
  longleftrightarrow: "\u27F7",
  longmapsto: "\u27FC",
  longrightarrow: "\u27F6",
  looparrowleft: "\u21AB",
  looparrowright: "\u21AC",
  lopar: "\u2985",
  lopf: "\u{1D55D}",
  loplus: "\u2A2D",
  lotimes: "\u2A34",
  lowast: "\u2217",
  lowbar: "_",
  loz: "\u25CA",
  lozenge: "\u25CA",
  lozf: "\u29EB",
  lpar: "(",
  lparlt: "\u2993",
  lrarr: "\u21C6",
  lrcorner: "\u231F",
  lrhar: "\u21CB",
  lrhard: "\u296D",
  lrm: "\u200E",
  lrtri: "\u22BF",
  lsaquo: "\u2039",
  lscr: "\u{1D4C1}",
  lsh: "\u21B0",
  lsim: "\u2272",
  lsime: "\u2A8D",
  lsimg: "\u2A8F",
  lsqb: "[",
  lsquo: "\u2018",
  lsquor: "\u201A",
  lstrok: "\u0142",
  lt: "<",
  ltcc: "\u2AA6",
  ltcir: "\u2A79",
  ltdot: "\u22D6",
  lthree: "\u22CB",
  ltimes: "\u22C9",
  ltlarr: "\u2976",
  ltquest: "\u2A7B",
  ltrPar: "\u2996",
  ltri: "\u25C3",
  ltrie: "\u22B4",
  ltrif: "\u25C2",
  lurdshar: "\u294A",
  luruhar: "\u2966",
  lvertneqq: "\u2268\uFE00",
  lvnE: "\u2268\uFE00",
  mDDot: "\u223A",
  macr: "\xAF",
  male: "\u2642",
  malt: "\u2720",
  maltese: "\u2720",
  map: "\u21A6",
  mapsto: "\u21A6",
  mapstodown: "\u21A7",
  mapstoleft: "\u21A4",
  mapstoup: "\u21A5",
  marker: "\u25AE",
  mcomma: "\u2A29",
  mcy: "\u043C",
  mdash: "\u2014",
  measuredangle: "\u2221",
  mfr: "\u{1D52A}",
  mho: "\u2127",
  micro: "\xB5",
  mid: "\u2223",
  midast: "*",
  midcir: "\u2AF0",
  middot: "\xB7",
  minus: "\u2212",
  minusb: "\u229F",
  minusd: "\u2238",
  minusdu: "\u2A2A",
  mlcp: "\u2ADB",
  mldr: "\u2026",
  mnplus: "\u2213",
  models: "\u22A7",
  mopf: "\u{1D55E}",
  mp: "\u2213",
  mscr: "\u{1D4C2}",
  mstpos: "\u223E",
  mu: "\u03BC",
  multimap: "\u22B8",
  mumap: "\u22B8",
  nGg: "\u22D9\u0338",
  nGt: "\u226B\u20D2",
  nGtv: "\u226B\u0338",
  nLeftarrow: "\u21CD",
  nLeftrightarrow: "\u21CE",
  nLl: "\u22D8\u0338",
  nLt: "\u226A\u20D2",
  nLtv: "\u226A\u0338",
  nRightarrow: "\u21CF",
  nVDash: "\u22AF",
  nVdash: "\u22AE",
  nabla: "\u2207",
  nacute: "\u0144",
  nang: "\u2220\u20D2",
  nap: "\u2249",
  napE: "\u2A70\u0338",
  napid: "\u224B\u0338",
  napos: "\u0149",
  napprox: "\u2249",
  natur: "\u266E",
  natural: "\u266E",
  naturals: "\u2115",
  nbsp: "\xA0",
  nbump: "\u224E\u0338",
  nbumpe: "\u224F\u0338",
  ncap: "\u2A43",
  ncaron: "\u0148",
  ncedil: "\u0146",
  ncong: "\u2247",
  ncongdot: "\u2A6D\u0338",
  ncup: "\u2A42",
  ncy: "\u043D",
  ndash: "\u2013",
  ne: "\u2260",
  neArr: "\u21D7",
  nearhk: "\u2924",
  nearr: "\u2197",
  nearrow: "\u2197",
  nedot: "\u2250\u0338",
  nequiv: "\u2262",
  nesear: "\u2928",
  nesim: "\u2242\u0338",
  nexist: "\u2204",
  nexists: "\u2204",
  nfr: "\u{1D52B}",
  ngE: "\u2267\u0338",
  nge: "\u2271",
  ngeq: "\u2271",
  ngeqq: "\u2267\u0338",
  ngeqslant: "\u2A7E\u0338",
  nges: "\u2A7E\u0338",
  ngsim: "\u2275",
  ngt: "\u226F",
  ngtr: "\u226F",
  nhArr: "\u21CE",
  nharr: "\u21AE",
  nhpar: "\u2AF2",
  ni: "\u220B",
  nis: "\u22FC",
  nisd: "\u22FA",
  niv: "\u220B",
  njcy: "\u045A",
  nlArr: "\u21CD",
  nlE: "\u2266\u0338",
  nlarr: "\u219A",
  nldr: "\u2025",
  nle: "\u2270",
  nleftarrow: "\u219A",
  nleftrightarrow: "\u21AE",
  nleq: "\u2270",
  nleqq: "\u2266\u0338",
  nleqslant: "\u2A7D\u0338",
  nles: "\u2A7D\u0338",
  nless: "\u226E",
  nlsim: "\u2274",
  nlt: "\u226E",
  nltri: "\u22EA",
  nltrie: "\u22EC",
  nmid: "\u2224",
  nopf: "\u{1D55F}",
  not: "\xAC",
  notin: "\u2209",
  notinE: "\u22F9\u0338",
  notindot: "\u22F5\u0338",
  notinva: "\u2209",
  notinvb: "\u22F7",
  notinvc: "\u22F6",
  notni: "\u220C",
  notniva: "\u220C",
  notnivb: "\u22FE",
  notnivc: "\u22FD",
  npar: "\u2226",
  nparallel: "\u2226",
  nparsl: "\u2AFD\u20E5",
  npart: "\u2202\u0338",
  npolint: "\u2A14",
  npr: "\u2280",
  nprcue: "\u22E0",
  npre: "\u2AAF\u0338",
  nprec: "\u2280",
  npreceq: "\u2AAF\u0338",
  nrArr: "\u21CF",
  nrarr: "\u219B",
  nrarrc: "\u2933\u0338",
  nrarrw: "\u219D\u0338",
  nrightarrow: "\u219B",
  nrtri: "\u22EB",
  nrtrie: "\u22ED",
  nsc: "\u2281",
  nsccue: "\u22E1",
  nsce: "\u2AB0\u0338",
  nscr: "\u{1D4C3}",
  nshortmid: "\u2224",
  nshortparallel: "\u2226",
  nsim: "\u2241",
  nsime: "\u2244",
  nsimeq: "\u2244",
  nsmid: "\u2224",
  nspar: "\u2226",
  nsqsube: "\u22E2",
  nsqsupe: "\u22E3",
  nsub: "\u2284",
  nsubE: "\u2AC5\u0338",
  nsube: "\u2288",
  nsubset: "\u2282\u20D2",
  nsubseteq: "\u2288",
  nsubseteqq: "\u2AC5\u0338",
  nsucc: "\u2281",
  nsucceq: "\u2AB0\u0338",
  nsup: "\u2285",
  nsupE: "\u2AC6\u0338",
  nsupe: "\u2289",
  nsupset: "\u2283\u20D2",
  nsupseteq: "\u2289",
  nsupseteqq: "\u2AC6\u0338",
  ntgl: "\u2279",
  ntilde: "\xF1",
  ntlg: "\u2278",
  ntriangleleft: "\u22EA",
  ntrianglelefteq: "\u22EC",
  ntriangleright: "\u22EB",
  ntrianglerighteq: "\u22ED",
  nu: "\u03BD",
  num: "#",
  numero: "\u2116",
  numsp: "\u2007",
  nvDash: "\u22AD",
  nvHarr: "\u2904",
  nvap: "\u224D\u20D2",
  nvdash: "\u22AC",
  nvge: "\u2265\u20D2",
  nvgt: ">\u20D2",
  nvinfin: "\u29DE",
  nvlArr: "\u2902",
  nvle: "\u2264\u20D2",
  nvlt: "<\u20D2",
  nvltrie: "\u22B4\u20D2",
  nvrArr: "\u2903",
  nvrtrie: "\u22B5\u20D2",
  nvsim: "\u223C\u20D2",
  nwArr: "\u21D6",
  nwarhk: "\u2923",
  nwarr: "\u2196",
  nwarrow: "\u2196",
  nwnear: "\u2927",
  oS: "\u24C8",
  oacute: "\xF3",
  oast: "\u229B",
  ocir: "\u229A",
  ocirc: "\xF4",
  ocy: "\u043E",
  odash: "\u229D",
  odblac: "\u0151",
  odiv: "\u2A38",
  odot: "\u2299",
  odsold: "\u29BC",
  oelig: "\u0153",
  ofcir: "\u29BF",
  ofr: "\u{1D52C}",
  ogon: "\u02DB",
  ograve: "\xF2",
  ogt: "\u29C1",
  ohbar: "\u29B5",
  ohm: "\u03A9",
  oint: "\u222E",
  olarr: "\u21BA",
  olcir: "\u29BE",
  olcross: "\u29BB",
  oline: "\u203E",
  olt: "\u29C0",
  omacr: "\u014D",
  omega: "\u03C9",
  omicron: "\u03BF",
  omid: "\u29B6",
  ominus: "\u2296",
  oopf: "\u{1D560}",
  opar: "\u29B7",
  operp: "\u29B9",
  oplus: "\u2295",
  or: "\u2228",
  orarr: "\u21BB",
  ord: "\u2A5D",
  order: "\u2134",
  orderof: "\u2134",
  ordf: "\xAA",
  ordm: "\xBA",
  origof: "\u22B6",
  oror: "\u2A56",
  orslope: "\u2A57",
  orv: "\u2A5B",
  oscr: "\u2134",
  oslash: "\xF8",
  osol: "\u2298",
  otilde: "\xF5",
  otimes: "\u2297",
  otimesas: "\u2A36",
  ouml: "\xF6",
  ovbar: "\u233D",
  par: "\u2225",
  para: "\xB6",
  parallel: "\u2225",
  parsim: "\u2AF3",
  parsl: "\u2AFD",
  part: "\u2202",
  pcy: "\u043F",
  percnt: "%",
  period: ".",
  permil: "\u2030",
  perp: "\u22A5",
  pertenk: "\u2031",
  pfr: "\u{1D52D}",
  phi: "\u03C6",
  phiv: "\u03D5",
  phmmat: "\u2133",
  phone: "\u260E",
  pi: "\u03C0",
  pitchfork: "\u22D4",
  piv: "\u03D6",
  planck: "\u210F",
  planckh: "\u210E",
  plankv: "\u210F",
  plus: "+",
  plusacir: "\u2A23",
  plusb: "\u229E",
  pluscir: "\u2A22",
  plusdo: "\u2214",
  plusdu: "\u2A25",
  pluse: "\u2A72",
  plusmn: "\xB1",
  plussim: "\u2A26",
  plustwo: "\u2A27",
  pm: "\xB1",
  pointint: "\u2A15",
  popf: "\u{1D561}",
  pound: "\xA3",
  pr: "\u227A",
  prE: "\u2AB3",
  prap: "\u2AB7",
  prcue: "\u227C",
  pre: "\u2AAF",
  prec: "\u227A",
  precapprox: "\u2AB7",
  preccurlyeq: "\u227C",
  preceq: "\u2AAF",
  precnapprox: "\u2AB9",
  precneqq: "\u2AB5",
  precnsim: "\u22E8",
  precsim: "\u227E",
  prime: "\u2032",
  primes: "\u2119",
  prnE: "\u2AB5",
  prnap: "\u2AB9",
  prnsim: "\u22E8",
  prod: "\u220F",
  profalar: "\u232E",
  profline: "\u2312",
  profsurf: "\u2313",
  prop: "\u221D",
  propto: "\u221D",
  prsim: "\u227E",
  prurel: "\u22B0",
  pscr: "\u{1D4C5}",
  psi: "\u03C8",
  puncsp: "\u2008",
  qfr: "\u{1D52E}",
  qint: "\u2A0C",
  qopf: "\u{1D562}",
  qprime: "\u2057",
  qscr: "\u{1D4C6}",
  quaternions: "\u210D",
  quatint: "\u2A16",
  quest: "?",
  questeq: "\u225F",
  quot: '"',
  rAarr: "\u21DB",
  rArr: "\u21D2",
  rAtail: "\u291C",
  rBarr: "\u290F",
  rHar: "\u2964",
  race: "\u223D\u0331",
  racute: "\u0155",
  radic: "\u221A",
  raemptyv: "\u29B3",
  rang: "\u27E9",
  rangd: "\u2992",
  range: "\u29A5",
  rangle: "\u27E9",
  raquo: "\xBB",
  rarr: "\u2192",
  rarrap: "\u2975",
  rarrb: "\u21E5",
  rarrbfs: "\u2920",
  rarrc: "\u2933",
  rarrfs: "\u291E",
  rarrhk: "\u21AA",
  rarrlp: "\u21AC",
  rarrpl: "\u2945",
  rarrsim: "\u2974",
  rarrtl: "\u21A3",
  rarrw: "\u219D",
  ratail: "\u291A",
  ratio: "\u2236",
  rationals: "\u211A",
  rbarr: "\u290D",
  rbbrk: "\u2773",
  rbrace: "}",
  rbrack: "]",
  rbrke: "\u298C",
  rbrksld: "\u298E",
  rbrkslu: "\u2990",
  rcaron: "\u0159",
  rcedil: "\u0157",
  rceil: "\u2309",
  rcub: "}",
  rcy: "\u0440",
  rdca: "\u2937",
  rdldhar: "\u2969",
  rdquo: "\u201D",
  rdquor: "\u201D",
  rdsh: "\u21B3",
  real: "\u211C",
  realine: "\u211B",
  realpart: "\u211C",
  reals: "\u211D",
  rect: "\u25AD",
  reg: "\xAE",
  rfisht: "\u297D",
  rfloor: "\u230B",
  rfr: "\u{1D52F}",
  rhard: "\u21C1",
  rharu: "\u21C0",
  rharul: "\u296C",
  rho: "\u03C1",
  rhov: "\u03F1",
  rightarrow: "\u2192",
  rightarrowtail: "\u21A3",
  rightharpoondown: "\u21C1",
  rightharpoonup: "\u21C0",
  rightleftarrows: "\u21C4",
  rightleftharpoons: "\u21CC",
  rightrightarrows: "\u21C9",
  rightsquigarrow: "\u219D",
  rightthreetimes: "\u22CC",
  ring: "\u02DA",
  risingdotseq: "\u2253",
  rlarr: "\u21C4",
  rlhar: "\u21CC",
  rlm: "\u200F",
  rmoust: "\u23B1",
  rmoustache: "\u23B1",
  rnmid: "\u2AEE",
  roang: "\u27ED",
  roarr: "\u21FE",
  robrk: "\u27E7",
  ropar: "\u2986",
  ropf: "\u{1D563}",
  roplus: "\u2A2E",
  rotimes: "\u2A35",
  rpar: ")",
  rpargt: "\u2994",
  rppolint: "\u2A12",
  rrarr: "\u21C9",
  rsaquo: "\u203A",
  rscr: "\u{1D4C7}",
  rsh: "\u21B1",
  rsqb: "]",
  rsquo: "\u2019",
  rsquor: "\u2019",
  rthree: "\u22CC",
  rtimes: "\u22CA",
  rtri: "\u25B9",
  rtrie: "\u22B5",
  rtrif: "\u25B8",
  rtriltri: "\u29CE",
  ruluhar: "\u2968",
  rx: "\u211E",
  sacute: "\u015B",
  sbquo: "\u201A",
  sc: "\u227B",
  scE: "\u2AB4",
  scap: "\u2AB8",
  scaron: "\u0161",
  sccue: "\u227D",
  sce: "\u2AB0",
  scedil: "\u015F",
  scirc: "\u015D",
  scnE: "\u2AB6",
  scnap: "\u2ABA",
  scnsim: "\u22E9",
  scpolint: "\u2A13",
  scsim: "\u227F",
  scy: "\u0441",
  sdot: "\u22C5",
  sdotb: "\u22A1",
  sdote: "\u2A66",
  seArr: "\u21D8",
  searhk: "\u2925",
  searr: "\u2198",
  searrow: "\u2198",
  sect: "\xA7",
  semi: ";",
  seswar: "\u2929",
  setminus: "\u2216",
  setmn: "\u2216",
  sext: "\u2736",
  sfr: "\u{1D530}",
  sfrown: "\u2322",
  sharp: "\u266F",
  shchcy: "\u0449",
  shcy: "\u0448",
  shortmid: "\u2223",
  shortparallel: "\u2225",
  shy: "\xAD",
  sigma: "\u03C3",
  sigmaf: "\u03C2",
  sigmav: "\u03C2",
  sim: "\u223C",
  simdot: "\u2A6A",
  sime: "\u2243",
  simeq: "\u2243",
  simg: "\u2A9E",
  simgE: "\u2AA0",
  siml: "\u2A9D",
  simlE: "\u2A9F",
  simne: "\u2246",
  simplus: "\u2A24",
  simrarr: "\u2972",
  slarr: "\u2190",
  smallsetminus: "\u2216",
  smashp: "\u2A33",
  smeparsl: "\u29E4",
  smid: "\u2223",
  smile: "\u2323",
  smt: "\u2AAA",
  smte: "\u2AAC",
  smtes: "\u2AAC\uFE00",
  softcy: "\u044C",
  sol: "/",
  solb: "\u29C4",
  solbar: "\u233F",
  sopf: "\u{1D564}",
  spades: "\u2660",
  spadesuit: "\u2660",
  spar: "\u2225",
  sqcap: "\u2293",
  sqcaps: "\u2293\uFE00",
  sqcup: "\u2294",
  sqcups: "\u2294\uFE00",
  sqsub: "\u228F",
  sqsube: "\u2291",
  sqsubset: "\u228F",
  sqsubseteq: "\u2291",
  sqsup: "\u2290",
  sqsupe: "\u2292",
  sqsupset: "\u2290",
  sqsupseteq: "\u2292",
  squ: "\u25A1",
  square: "\u25A1",
  squarf: "\u25AA",
  squf: "\u25AA",
  srarr: "\u2192",
  sscr: "\u{1D4C8}",
  ssetmn: "\u2216",
  ssmile: "\u2323",
  sstarf: "\u22C6",
  star: "\u2606",
  starf: "\u2605",
  straightepsilon: "\u03F5",
  straightphi: "\u03D5",
  strns: "\xAF",
  sub: "\u2282",
  subE: "\u2AC5",
  subdot: "\u2ABD",
  sube: "\u2286",
  subedot: "\u2AC3",
  submult: "\u2AC1",
  subnE: "\u2ACB",
  subne: "\u228A",
  subplus: "\u2ABF",
  subrarr: "\u2979",
  subset: "\u2282",
  subseteq: "\u2286",
  subseteqq: "\u2AC5",
  subsetneq: "\u228A",
  subsetneqq: "\u2ACB",
  subsim: "\u2AC7",
  subsub: "\u2AD5",
  subsup: "\u2AD3",
  succ: "\u227B",
  succapprox: "\u2AB8",
  succcurlyeq: "\u227D",
  succeq: "\u2AB0",
  succnapprox: "\u2ABA",
  succneqq: "\u2AB6",
  succnsim: "\u22E9",
  succsim: "\u227F",
  sum: "\u2211",
  sung: "\u266A",
  sup1: "\xB9",
  sup2: "\xB2",
  sup3: "\xB3",
  sup: "\u2283",
  supE: "\u2AC6",
  supdot: "\u2ABE",
  supdsub: "\u2AD8",
  supe: "\u2287",
  supedot: "\u2AC4",
  suphsol: "\u27C9",
  suphsub: "\u2AD7",
  suplarr: "\u297B",
  supmult: "\u2AC2",
  supnE: "\u2ACC",
  supne: "\u228B",
  supplus: "\u2AC0",
  supset: "\u2283",
  supseteq: "\u2287",
  supseteqq: "\u2AC6",
  supsetneq: "\u228B",
  supsetneqq: "\u2ACC",
  supsim: "\u2AC8",
  supsub: "\u2AD4",
  supsup: "\u2AD6",
  swArr: "\u21D9",
  swarhk: "\u2926",
  swarr: "\u2199",
  swarrow: "\u2199",
  swnwar: "\u292A",
  szlig: "\xDF",
  target: "\u2316",
  tau: "\u03C4",
  tbrk: "\u23B4",
  tcaron: "\u0165",
  tcedil: "\u0163",
  tcy: "\u0442",
  tdot: "\u20DB",
  telrec: "\u2315",
  tfr: "\u{1D531}",
  there4: "\u2234",
  therefore: "\u2234",
  theta: "\u03B8",
  thetasym: "\u03D1",
  thetav: "\u03D1",
  thickapprox: "\u2248",
  thicksim: "\u223C",
  thinsp: "\u2009",
  thkap: "\u2248",
  thksim: "\u223C",
  thorn: "\xFE",
  tilde: "\u02DC",
  times: "\xD7",
  timesb: "\u22A0",
  timesbar: "\u2A31",
  timesd: "\u2A30",
  tint: "\u222D",
  toea: "\u2928",
  top: "\u22A4",
  topbot: "\u2336",
  topcir: "\u2AF1",
  topf: "\u{1D565}",
  topfork: "\u2ADA",
  tosa: "\u2929",
  tprime: "\u2034",
  trade: "\u2122",
  triangle: "\u25B5",
  triangledown: "\u25BF",
  triangleleft: "\u25C3",
  trianglelefteq: "\u22B4",
  triangleq: "\u225C",
  triangleright: "\u25B9",
  trianglerighteq: "\u22B5",
  tridot: "\u25EC",
  trie: "\u225C",
  triminus: "\u2A3A",
  triplus: "\u2A39",
  trisb: "\u29CD",
  tritime: "\u2A3B",
  trpezium: "\u23E2",
  tscr: "\u{1D4C9}",
  tscy: "\u0446",
  tshcy: "\u045B",
  tstrok: "\u0167",
  twixt: "\u226C",
  twoheadleftarrow: "\u219E",
  twoheadrightarrow: "\u21A0",
  uArr: "\u21D1",
  uHar: "\u2963",
  uacute: "\xFA",
  uarr: "\u2191",
  ubrcy: "\u045E",
  ubreve: "\u016D",
  ucirc: "\xFB",
  ucy: "\u0443",
  udarr: "\u21C5",
  udblac: "\u0171",
  udhar: "\u296E",
  ufisht: "\u297E",
  ufr: "\u{1D532}",
  ugrave: "\xF9",
  uharl: "\u21BF",
  uharr: "\u21BE",
  uhblk: "\u2580",
  ulcorn: "\u231C",
  ulcorner: "\u231C",
  ulcrop: "\u230F",
  ultri: "\u25F8",
  umacr: "\u016B",
  uml: "\xA8",
  uogon: "\u0173",
  uopf: "\u{1D566}",
  uparrow: "\u2191",
  updownarrow: "\u2195",
  upharpoonleft: "\u21BF",
  upharpoonright: "\u21BE",
  uplus: "\u228E",
  upsi: "\u03C5",
  upsih: "\u03D2",
  upsilon: "\u03C5",
  upuparrows: "\u21C8",
  urcorn: "\u231D",
  urcorner: "\u231D",
  urcrop: "\u230E",
  uring: "\u016F",
  urtri: "\u25F9",
  uscr: "\u{1D4CA}",
  utdot: "\u22F0",
  utilde: "\u0169",
  utri: "\u25B5",
  utrif: "\u25B4",
  uuarr: "\u21C8",
  uuml: "\xFC",
  uwangle: "\u29A7",
  vArr: "\u21D5",
  vBar: "\u2AE8",
  vBarv: "\u2AE9",
  vDash: "\u22A8",
  vangrt: "\u299C",
  varepsilon: "\u03F5",
  varkappa: "\u03F0",
  varnothing: "\u2205",
  varphi: "\u03D5",
  varpi: "\u03D6",
  varpropto: "\u221D",
  varr: "\u2195",
  varrho: "\u03F1",
  varsigma: "\u03C2",
  varsubsetneq: "\u228A\uFE00",
  varsubsetneqq: "\u2ACB\uFE00",
  varsupsetneq: "\u228B\uFE00",
  varsupsetneqq: "\u2ACC\uFE00",
  vartheta: "\u03D1",
  vartriangleleft: "\u22B2",
  vartriangleright: "\u22B3",
  vcy: "\u0432",
  vdash: "\u22A2",
  vee: "\u2228",
  veebar: "\u22BB",
  veeeq: "\u225A",
  vellip: "\u22EE",
  verbar: "|",
  vert: "|",
  vfr: "\u{1D533}",
  vltri: "\u22B2",
  vnsub: "\u2282\u20D2",
  vnsup: "\u2283\u20D2",
  vopf: "\u{1D567}",
  vprop: "\u221D",
  vrtri: "\u22B3",
  vscr: "\u{1D4CB}",
  vsubnE: "\u2ACB\uFE00",
  vsubne: "\u228A\uFE00",
  vsupnE: "\u2ACC\uFE00",
  vsupne: "\u228B\uFE00",
  vzigzag: "\u299A",
  wcirc: "\u0175",
  wedbar: "\u2A5F",
  wedge: "\u2227",
  wedgeq: "\u2259",
  weierp: "\u2118",
  wfr: "\u{1D534}",
  wopf: "\u{1D568}",
  wp: "\u2118",
  wr: "\u2240",
  wreath: "\u2240",
  wscr: "\u{1D4CC}",
  xcap: "\u22C2",
  xcirc: "\u25EF",
  xcup: "\u22C3",
  xdtri: "\u25BD",
  xfr: "\u{1D535}",
  xhArr: "\u27FA",
  xharr: "\u27F7",
  xi: "\u03BE",
  xlArr: "\u27F8",
  xlarr: "\u27F5",
  xmap: "\u27FC",
  xnis: "\u22FB",
  xodot: "\u2A00",
  xopf: "\u{1D569}",
  xoplus: "\u2A01",
  xotime: "\u2A02",
  xrArr: "\u27F9",
  xrarr: "\u27F6",
  xscr: "\u{1D4CD}",
  xsqcup: "\u2A06",
  xuplus: "\u2A04",
  xutri: "\u25B3",
  xvee: "\u22C1",
  xwedge: "\u22C0",
  yacute: "\xFD",
  yacy: "\u044F",
  ycirc: "\u0177",
  ycy: "\u044B",
  yen: "\xA5",
  yfr: "\u{1D536}",
  yicy: "\u0457",
  yopf: "\u{1D56A}",
  yscr: "\u{1D4CE}",
  yucy: "\u044E",
  yuml: "\xFF",
  zacute: "\u017A",
  zcaron: "\u017E",
  zcy: "\u0437",
  zdot: "\u017C",
  zeetrf: "\u2128",
  zeta: "\u03B6",
  zfr: "\u{1D537}",
  zhcy: "\u0436",
  zigrarr: "\u21DD",
  zopf: "\u{1D56B}",
  zscr: "\u{1D4CF}",
  zwj: "\u200D",
  zwnj: "\u200C"
};
var decodeMap = {
  "0": 65533,
  "128": 8364,
  "130": 8218,
  "131": 402,
  "132": 8222,
  "133": 8230,
  "134": 8224,
  "135": 8225,
  "136": 710,
  "137": 8240,
  "138": 352,
  "139": 8249,
  "140": 338,
  "142": 381,
  "145": 8216,
  "146": 8217,
  "147": 8220,
  "148": 8221,
  "149": 8226,
  "150": 8211,
  "151": 8212,
  "152": 732,
  "153": 8482,
  "154": 353,
  "155": 8250,
  "156": 339,
  "158": 382,
  "159": 376
};
function decodeHTMLStrict(text) {
  return text.replace(/&(?:[a-zA-Z]+|#[xX][\da-fA-F]+|#\d+);/g, (key) => {
    var _a;
    if (key.charAt(1) === "#") {
      const secondChar = key.charAt(2);
      const codePoint = secondChar === "X" || secondChar === "x" ? parseInt(key.slice(3), 16) : parseInt(key.slice(2), 10);
      return decodeCodePoint(codePoint);
    }
    return (_a = getOwnProperty(entities, key.slice(1, -1))) != null ? _a : key;
  });
}
__name(decodeHTMLStrict, "decodeHTMLStrict");
function decodeCodePoint(codePoint) {
  var _a;
  if (codePoint >= 55296 && codePoint <= 57343 || codePoint > 1114111) {
    return "\uFFFD";
  }
  return String.fromCodePoint((_a = getOwnProperty(decodeMap, codePoint)) != null ? _a : codePoint);
}
__name(decodeCodePoint, "decodeCodePoint");
function scanJSXAttributeValue(parser, context) {
  parser.startIndex = parser.tokenIndex = parser.index;
  parser.startColumn = parser.tokenColumn = parser.column;
  parser.startLine = parser.tokenLine = parser.line;
  parser.setToken(CharTypes[parser.currentChar] & 8192 ? scanJSXString(parser) : scanSingleToken(parser, context, 0));
  return parser.getToken();
}
__name(scanJSXAttributeValue, "scanJSXAttributeValue");
function scanJSXString(parser) {
  const quote = parser.currentChar;
  let char = advanceChar(parser);
  const start = parser.index;
  while (char !== quote) {
    if (parser.index >= parser.end)
      parser.report(16);
    char = advanceChar(parser);
  }
  if (char !== quote)
    parser.report(16);
  parser.tokenValue = parser.source.slice(start, parser.index);
  advanceChar(parser);
  if (parser.options.raw)
    parser.tokenRaw = parser.source.slice(parser.tokenIndex, parser.index);
  return 134283267;
}
__name(scanJSXString, "scanJSXString");
function nextJSXToken(parser) {
  parser.startIndex = parser.tokenIndex = parser.index;
  parser.startColumn = parser.tokenColumn = parser.column;
  parser.startLine = parser.tokenLine = parser.line;
  if (parser.index >= parser.end) {
    parser.setToken(1048576);
    return;
  }
  if (parser.currentChar === 60) {
    advanceChar(parser);
    parser.setToken(8456256);
    return;
  }
  if (parser.currentChar === 123) {
    advanceChar(parser);
    parser.setToken(2162700);
    return;
  }
  let state = 0;
  while (parser.index < parser.end) {
    const type = CharTypes[parser.source.charCodeAt(parser.index)];
    if (type & 1024) {
      state |= 1 | 4;
      scanNewLine(parser);
    } else if (type & 2048) {
      consumeLineFeed(parser, state);
      state = state & -5 | 1;
    } else {
      advanceChar(parser);
    }
    if (CharTypes[parser.currentChar] & 16384)
      break;
  }
  if (parser.tokenIndex === parser.index)
    parser.report(0);
  const raw = parser.source.slice(parser.tokenIndex, parser.index);
  if (parser.options.raw)
    parser.tokenRaw = raw;
  parser.tokenValue = decodeHTMLStrict(raw);
  parser.setToken(137);
}
__name(nextJSXToken, "nextJSXToken");
function rescanJSXIdentifier(parser) {
  if ((parser.getToken() & 143360) === 143360) {
    const { index } = parser;
    let char = parser.currentChar;
    while (CharTypes[char] & (32768 | 2)) {
      char = advanceChar(parser);
    }
    parser.tokenValue += parser.source.slice(index, parser.index);
    parser.setToken(208897, true);
  }
  return parser.getToken();
}
__name(rescanJSXIdentifier, "rescanJSXIdentifier");
var _Scope = class _Scope {
  constructor(parser, type = 2, parent) {
    __publicField(this, "parser");
    __publicField(this, "type");
    __publicField(this, "parent");
    __publicField(this, "scopeError");
    __publicField(this, "variableBindings", /* @__PURE__ */ new Map());
    this.parser = parser;
    this.type = type;
    this.parent = parent;
  }
  createChildScope(type) {
    return new _Scope(this.parser, type, this);
  }
  addVarOrBlock(context, name, kind, origin) {
    if (kind & 4) {
      this.addVarName(context, name, kind);
    } else {
      this.addBlockName(context, name, kind, origin);
    }
    if (origin & 64) {
      this.parser.declareUnboundVariable(name);
    }
  }
  addVarName(context, name, kind) {
    const { parser } = this;
    let currentScope = this;
    while (currentScope && (currentScope.type & 128) === 0) {
      const { variableBindings } = currentScope;
      const value = variableBindings.get(name);
      if (value && value & 248) {
        if (parser.options.webcompat && (context & 1) === 0 && (kind & 128 && value & 68 || value & 128 && kind & 68)) ;
        else {
          parser.report(145, name);
        }
      }
      if (currentScope === this) {
        if (value && value & 1 && kind & 1) {
          currentScope.recordScopeError(145, name);
        }
      }
      if (value && (value & 256 || value & 512 && !parser.options.webcompat)) {
        parser.report(145, name);
      }
      currentScope.variableBindings.set(name, kind);
      currentScope = currentScope.parent;
    }
  }
  hasVariable(name) {
    return this.variableBindings.has(name);
  }
  addBlockName(context, name, kind, origin) {
    var _a;
    const { parser } = this;
    const value = this.variableBindings.get(name);
    if (value && (value & 2) === 0) {
      if (kind & 1) {
        this.recordScopeError(145, name);
      } else if (parser.options.webcompat && (context & 1) === 0 && origin & 2 && value === 64 && kind === 64) ;
      else {
        parser.report(145, name);
      }
    }
    if (this.type & 64 && ((_a = this.parent) == null ? void 0 : _a.hasVariable(name)) && (this.parent.variableBindings.get(name) & 2) === 0) {
      parser.report(145, name);
    }
    if (this.type & 512 && value && (value & 2) === 0) {
      if (kind & 1) {
        this.recordScopeError(145, name);
      }
    }
    if (this.type & 32) {
      if (this.parent.variableBindings.get(name) & 768)
        parser.report(159, name);
    }
    this.variableBindings.set(name, kind);
  }
  recordScopeError(type, ...params) {
    this.scopeError = {
      type,
      params,
      start: this.parser.tokenStart,
      end: this.parser.currentLocation
    };
  }
  reportScopeError() {
    const { scopeError } = this;
    if (!scopeError) {
      return;
    }
    throw new ParseError(scopeError.start, scopeError.end, scopeError.type, ...scopeError.params);
  }
};
__name(_Scope, "Scope");
var Scope = _Scope;
function createArrowHeadParsingScope(parser, context, value) {
  const scope = parser.createScope().createChildScope(512);
  scope.addBlockName(context, value, 1, 0);
  return scope;
}
__name(createArrowHeadParsingScope, "createArrowHeadParsingScope");
var _PrivateScope = class _PrivateScope {
  constructor(parser, parent) {
    __publicField(this, "parser");
    __publicField(this, "parent");
    __publicField(this, "refs", /* @__PURE__ */ Object.create(null));
    __publicField(this, "privateIdentifiers", /* @__PURE__ */ new Map());
    this.parser = parser;
    this.parent = parent;
  }
  addPrivateIdentifier(name, kind) {
    const { privateIdentifiers } = this;
    let focusKind = kind & (32 | 768);
    if (!(focusKind & 768))
      focusKind |= 768;
    const value = privateIdentifiers.get(name);
    if (this.hasPrivateIdentifier(name) && ((value & 32) !== (focusKind & 32) || value & focusKind & 768)) {
      this.parser.report(146, name);
    }
    privateIdentifiers.set(name, this.hasPrivateIdentifier(name) ? value | focusKind : focusKind);
  }
  addPrivateIdentifierRef(name) {
    var _a, _b;
    (_b = (_a = this.refs)[name]) != null ? _b : _a[name] = [];
    this.refs[name].push(this.parser.tokenStart);
  }
  isPrivateIdentifierDefined(name) {
    var _a;
    return this.hasPrivateIdentifier(name) || Boolean((_a = this.parent) == null ? void 0 : _a.isPrivateIdentifierDefined(name));
  }
  validatePrivateIdentifierRefs() {
    for (const name in this.refs) {
      if (!this.isPrivateIdentifierDefined(name)) {
        const { index, line, column } = this.refs[name][0];
        throw new ParseError({ index, line, column }, { index: index + name.length, line, column: column + name.length }, 4, name);
      }
    }
  }
  hasPrivateIdentifier(name) {
    return this.privateIdentifiers.has(name);
  }
};
__name(_PrivateScope, "PrivateScope");
var PrivateScope = _PrivateScope;
var _Parser = class _Parser {
  constructor(source, options = {}) {
    __publicField(this, "source");
    __publicField(this, "options");
    __publicField(this, "lastOnToken", null);
    __publicField(this, "token", 1048576);
    __publicField(this, "flags", 0);
    __publicField(this, "index", 0);
    __publicField(this, "line", 1);
    __publicField(this, "column", 0);
    __publicField(this, "startIndex", 0);
    __publicField(this, "end", 0);
    __publicField(this, "tokenIndex", 0);
    __publicField(this, "startColumn", 0);
    __publicField(this, "tokenColumn", 0);
    __publicField(this, "tokenLine", 1);
    __publicField(this, "startLine", 1);
    __publicField(this, "tokenValue", "");
    __publicField(this, "tokenRaw", "");
    __publicField(this, "tokenRegExp");
    __publicField(this, "currentChar", 0);
    __publicField(this, "exportedNames", /* @__PURE__ */ new Set());
    __publicField(this, "exportedBindings", /* @__PURE__ */ new Set());
    __publicField(this, "assignable", 1);
    __publicField(this, "destructible", 0);
    __publicField(this, "leadingDecorators", { decorators: [] });
    this.source = source;
    this.options = options;
    this.end = source.length;
    this.currentChar = source.charCodeAt(0);
  }
  getToken() {
    return this.token;
  }
  setToken(value, replaceLast = false) {
    this.token = value;
    const { onToken } = this.options;
    if (onToken) {
      if (value !== 1048576) {
        const loc = {
          start: {
            line: this.tokenLine,
            column: this.tokenColumn
          },
          end: {
            line: this.line,
            column: this.column
          }
        };
        if (!replaceLast && this.lastOnToken) {
          onToken(...this.lastOnToken);
        }
        this.lastOnToken = [convertTokenType(value), this.tokenIndex, this.index, loc];
      } else {
        if (this.lastOnToken) {
          onToken(...this.lastOnToken);
          this.lastOnToken = null;
        }
      }
    }
    return value;
  }
  get tokenStart() {
    return {
      index: this.tokenIndex,
      line: this.tokenLine,
      column: this.tokenColumn
    };
  }
  get currentLocation() {
    return { index: this.index, line: this.line, column: this.column };
  }
  finishNode(node, start, end) {
    if (this.options.ranges) {
      node.start = start.index;
      const endIndex = end ? end.index : this.startIndex;
      node.end = endIndex;
      node.range = [start.index, endIndex];
    }
    if (this.options.loc) {
      node.loc = {
        start: {
          line: start.line,
          column: start.column
        },
        end: end ? { line: end.line, column: end.column } : { line: this.startLine, column: this.startColumn }
      };
      if (this.options.source) {
        node.loc.source = this.options.source;
      }
    }
    return node;
  }
  addBindingToExports(name) {
    this.exportedBindings.add(name);
  }
  declareUnboundVariable(name) {
    const { exportedNames } = this;
    if (exportedNames.has(name)) {
      this.report(147, name);
    }
    exportedNames.add(name);
  }
  report(type, ...params) {
    throw new ParseError(this.tokenStart, this.currentLocation, type, ...params);
  }
  createScopeIfLexical(type, parent) {
    if (this.options.lexical) {
      return this.createScope(type, parent);
    }
    return void 0;
  }
  createScope(type, parent) {
    return new Scope(this, type, parent);
  }
  createPrivateScopeIfLexical(parent) {
    if (this.options.lexical) {
      return new PrivateScope(this, parent);
    }
    return void 0;
  }
};
__name(_Parser, "Parser");
var Parser = _Parser;
function pushComment(comments, options) {
  return function(type, value, start, end, loc) {
    const comment = {
      type,
      value
    };
    if (options.ranges) {
      comment.start = start;
      comment.end = end;
      comment.range = [start, end];
    }
    if (options.loc) {
      comment.loc = loc;
    }
    comments.push(comment);
  };
}
__name(pushComment, "pushComment");
function pushToken(tokens, options) {
  return function(type, start, end, loc) {
    const token = {
      token: type
    };
    if (options.ranges) {
      token.start = start;
      token.end = end;
      token.range = [start, end];
    }
    if (options.loc) {
      token.loc = loc;
    }
    tokens.push(token);
  };
}
__name(pushToken, "pushToken");
function normalizeOptions(rawOptions) {
  const options = { ...rawOptions };
  if (options.onComment) {
    options.onComment = Array.isArray(options.onComment) ? pushComment(options.onComment, options) : options.onComment;
  }
  if (options.onToken) {
    options.onToken = Array.isArray(options.onToken) ? pushToken(options.onToken, options) : options.onToken;
  }
  return options;
}
__name(normalizeOptions, "normalizeOptions");
function parseSource(source, rawOptions = {}, context = 0) {
  const options = normalizeOptions(rawOptions);
  if (options.module)
    context |= 2 | 1;
  if (options.globalReturn)
    context |= 4096;
  if (options.impliedStrict)
    context |= 1;
  const parser = new Parser(source, options);
  skipHashBang(parser);
  const scope = parser.createScopeIfLexical();
  let body = [];
  let sourceType = "script";
  if (context & 2) {
    sourceType = "module";
    body = parseModuleItemList(parser, context | 8, scope);
    if (scope) {
      for (const name of parser.exportedBindings) {
        if (!scope.hasVariable(name))
          parser.report(148, name);
      }
    }
  } else {
    body = parseStatementList(parser, context | 8, scope);
  }
  return parser.finishNode({
    type: "Program",
    sourceType,
    body
  }, { index: 0, line: 1, column: 0 }, parser.currentLocation);
}
__name(parseSource, "parseSource");
function parseStatementList(parser, context, scope) {
  nextToken(parser, context | 32 | 262144);
  const statements = [];
  while (parser.getToken() === 134283267) {
    const { index, tokenValue, tokenStart, tokenIndex } = parser;
    const token = parser.getToken();
    const expr = parseLiteral(parser, context);
    if (isValidStrictMode(parser, index, tokenIndex, tokenValue)) {
      context |= 1;
      if (parser.flags & 64) {
        throw new ParseError(parser.tokenStart, parser.currentLocation, 9);
      }
      if (parser.flags & 4096) {
        throw new ParseError(parser.tokenStart, parser.currentLocation, 15);
      }
    }
    statements.push(parseDirective(parser, context, expr, token, tokenStart));
  }
  while (parser.getToken() !== 1048576) {
    statements.push(parseStatementListItem(parser, context, scope, void 0, 4, {}));
  }
  return statements;
}
__name(parseStatementList, "parseStatementList");
function parseModuleItemList(parser, context, scope) {
  nextToken(parser, context | 32);
  const statements = [];
  while (parser.getToken() === 134283267) {
    const { tokenStart } = parser;
    const token = parser.getToken();
    statements.push(parseDirective(parser, context, parseLiteral(parser, context), token, tokenStart));
  }
  while (parser.getToken() !== 1048576) {
    statements.push(parseModuleItem(parser, context, scope));
  }
  return statements;
}
__name(parseModuleItemList, "parseModuleItemList");
function parseModuleItem(parser, context, scope) {
  var _a;
  if (parser.getToken() === 132) {
    Object.assign(parser.leadingDecorators, {
      start: parser.tokenStart,
      decorators: parseDecorators(parser, context, void 0)
    });
  }
  let moduleItem;
  switch (parser.getToken()) {
    case 20564:
      moduleItem = parseExportDeclaration(parser, context, scope);
      break;
    case 86106:
      moduleItem = parseImportDeclaration(parser, context, scope);
      break;
    default:
      moduleItem = parseStatementListItem(parser, context, scope, void 0, 4, {});
  }
  if ((_a = parser.leadingDecorators) == null ? void 0 : _a.decorators.length) {
    parser.report(170);
  }
  return moduleItem;
}
__name(parseModuleItem, "parseModuleItem");
function parseStatementListItem(parser, context, scope, privateScope, origin, labels) {
  const start = parser.tokenStart;
  switch (parser.getToken()) {
    case 86104:
      return parseFunctionDeclaration(parser, context, scope, privateScope, origin, 1, 0, 0, start);
    case 132:
    case 86094:
      return parseClassDeclaration(parser, context, scope, privateScope, 0);
    case 86090:
      return parseLexicalDeclaration(parser, context, scope, privateScope, 16, 0);
    case 241737:
      return parseLetIdentOrVarDeclarationStatement(parser, context, scope, privateScope, origin);
    case 20564:
      parser.report(103, "export");
    case 86106:
      nextToken(parser, context);
      switch (parser.getToken()) {
        case 67174411:
          return parseImportCallDeclaration(parser, context, privateScope, start);
        case 67108877:
          return parseImportMetaDeclaration(parser, context, start);
        default:
          parser.report(103, "import");
      }
    case 209005:
      return parseAsyncArrowOrAsyncFunctionDeclaration(parser, context, scope, privateScope, origin, labels, 1);
    default:
      return parseStatement(parser, context, scope, privateScope, origin, labels, 1);
  }
}
__name(parseStatementListItem, "parseStatementListItem");
function parseStatement(parser, context, scope, privateScope, origin, labels, allowFuncDecl) {
  switch (parser.getToken()) {
    case 86088:
      return parseVariableStatement(parser, context, scope, privateScope, 0);
    case 20572:
      return parseReturnStatement(parser, context, privateScope);
    case 20569:
      return parseIfStatement(parser, context, scope, privateScope, labels);
    case 20567:
      return parseForStatement(parser, context, scope, privateScope, labels);
    case 20562:
      return parseDoWhileStatement(parser, context, scope, privateScope, labels);
    case 20578:
      return parseWhileStatement(parser, context, scope, privateScope, labels);
    case 86110:
      return parseSwitchStatement(parser, context, scope, privateScope, labels);
    case 1074790417:
      return parseEmptyStatement(parser, context);
    case 2162700:
      return parseBlock(parser, context, scope == null ? void 0 : scope.createChildScope(), privateScope, labels, parser.tokenStart);
    case 86112:
      return parseThrowStatement(parser, context, privateScope);
    case 20555:
      return parseBreakStatement(parser, context, labels);
    case 20559:
      return parseContinueStatement(parser, context, labels);
    case 20577:
      return parseTryStatement(parser, context, scope, privateScope, labels);
    case 20579:
      return parseWithStatement(parser, context, scope, privateScope, labels);
    case 20560:
      return parseDebuggerStatement(parser, context);
    case 209005:
      return parseAsyncArrowOrAsyncFunctionDeclaration(parser, context, scope, privateScope, origin, labels, 0);
    case 20557:
      parser.report(162);
    case 20566:
      parser.report(163);
    case 86104:
      parser.report(context & 1 ? 76 : !parser.options.webcompat ? 78 : 77);
    case 86094:
      parser.report(79);
    default:
      return parseExpressionOrLabelledStatement(parser, context, scope, privateScope, origin, labels, allowFuncDecl);
  }
}
__name(parseStatement, "parseStatement");
function parseExpressionOrLabelledStatement(parser, context, scope, privateScope, origin, labels, allowFuncDecl) {
  const { tokenValue, tokenStart } = parser;
  const token = parser.getToken();
  let expr;
  switch (token) {
    case 241737:
      expr = parseIdentifier(parser, context);
      if (context & 1)
        parser.report(85);
      if (parser.getToken() === 69271571)
        parser.report(84);
      break;
    default:
      expr = parsePrimaryExpression(parser, context, privateScope, 2, 0, 1, 0, 1, parser.tokenStart);
  }
  if (token & 143360 && parser.getToken() === 21) {
    return parseLabelledStatement(parser, context, scope, privateScope, origin, labels, tokenValue, expr, token, allowFuncDecl, tokenStart);
  }
  expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 0, 0, tokenStart);
  expr = parseAssignmentExpression(parser, context, privateScope, 0, 0, tokenStart, expr);
  if (parser.getToken() === 18) {
    expr = parseSequenceExpression(parser, context, privateScope, 0, tokenStart, expr);
  }
  return parseExpressionStatement(parser, context, expr, tokenStart);
}
__name(parseExpressionOrLabelledStatement, "parseExpressionOrLabelledStatement");
function parseBlock(parser, context, scope, privateScope, labels, start = parser.tokenStart, type = "BlockStatement") {
  const body = [];
  consume(parser, context | 32, 2162700);
  while (parser.getToken() !== 1074790415) {
    body.push(parseStatementListItem(parser, context, scope, privateScope, 2, { $: labels }));
  }
  consume(parser, context | 32, 1074790415);
  return parser.finishNode({
    type,
    body
  }, start);
}
__name(parseBlock, "parseBlock");
function parseReturnStatement(parser, context, privateScope) {
  if ((context & 4096) === 0)
    parser.report(92);
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  const argument = parser.flags & 1 || parser.getToken() & 1048576 ? null : parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "ReturnStatement",
    argument
  }, start);
}
__name(parseReturnStatement, "parseReturnStatement");
function parseExpressionStatement(parser, context, expression, start) {
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "ExpressionStatement",
    expression
  }, start);
}
__name(parseExpressionStatement, "parseExpressionStatement");
function parseLabelledStatement(parser, context, scope, privateScope, origin, labels, value, expr, token, allowFuncDecl, start) {
  validateBindingIdentifier(parser, context, 0, token, 1);
  validateAndDeclareLabel(parser, labels, value);
  nextToken(parser, context | 32);
  const body = allowFuncDecl && (context & 1) === 0 && parser.options.webcompat && parser.getToken() === 86104 ? parseFunctionDeclaration(parser, context, scope == null ? void 0 : scope.createChildScope(), privateScope, origin, 0, 0, 0, parser.tokenStart) : parseStatement(parser, context, scope, privateScope, origin, labels, allowFuncDecl);
  return parser.finishNode({
    type: "LabeledStatement",
    label: expr,
    body
  }, start);
}
__name(parseLabelledStatement, "parseLabelledStatement");
function parseAsyncArrowOrAsyncFunctionDeclaration(parser, context, scope, privateScope, origin, labels, allowFuncDecl) {
  const { tokenValue, tokenStart: start } = parser;
  const token = parser.getToken();
  let expr = parseIdentifier(parser, context);
  if (parser.getToken() === 21) {
    return parseLabelledStatement(parser, context, scope, privateScope, origin, labels, tokenValue, expr, token, 1, start);
  }
  const asyncNewLine = parser.flags & 1;
  if (!asyncNewLine) {
    if (parser.getToken() === 86104) {
      if (!allowFuncDecl)
        parser.report(123);
      return parseFunctionDeclaration(parser, context, scope, privateScope, origin, 1, 0, 1, start);
    }
    if (isValidIdentifier(context, parser.getToken())) {
      expr = parseAsyncArrowAfterIdent(parser, context, privateScope, 1, start);
      if (parser.getToken() === 18)
        expr = parseSequenceExpression(parser, context, privateScope, 0, start, expr);
      return parseExpressionStatement(parser, context, expr, start);
    }
  }
  if (parser.getToken() === 67174411) {
    expr = parseAsyncArrowOrCallExpression(parser, context, privateScope, expr, 1, 1, 0, asyncNewLine, start);
  } else {
    if (parser.getToken() === 10) {
      classifyIdentifier(parser, context, token);
      if ((token & 36864) === 36864) {
        parser.flags |= 256;
      }
      expr = parseArrowFromIdentifier(parser, context | 2048, privateScope, parser.tokenValue, expr, 0, 1, 0, start);
    }
    parser.assignable = 1;
  }
  expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 0, 0, start);
  expr = parseAssignmentExpression(parser, context, privateScope, 0, 0, start, expr);
  parser.assignable = 1;
  if (parser.getToken() === 18) {
    expr = parseSequenceExpression(parser, context, privateScope, 0, start, expr);
  }
  return parseExpressionStatement(parser, context, expr, start);
}
__name(parseAsyncArrowOrAsyncFunctionDeclaration, "parseAsyncArrowOrAsyncFunctionDeclaration");
function parseDirective(parser, context, expression, token, start) {
  const endIndex = parser.startIndex;
  if (token !== 1074790417) {
    parser.assignable = 2;
    expression = parseMemberOrUpdateExpression(parser, context, void 0, expression, 0, 0, start);
    if (parser.getToken() !== 1074790417) {
      expression = parseAssignmentExpression(parser, context, void 0, 0, 0, start, expression);
      if (parser.getToken() === 18) {
        expression = parseSequenceExpression(parser, context, void 0, 0, start, expression);
      }
    }
    matchOrInsertSemicolon(parser, context | 32);
  }
  const node = {
    type: "ExpressionStatement",
    expression
  };
  if (expression.type === "Literal" && typeof expression.value === "string") {
    node.directive = parser.source.slice(start.index + 1, endIndex - 1);
  }
  return parser.finishNode(node, start);
}
__name(parseDirective, "parseDirective");
function parseEmptyStatement(parser, context) {
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  return parser.finishNode({
    type: "EmptyStatement"
  }, start);
}
__name(parseEmptyStatement, "parseEmptyStatement");
function parseThrowStatement(parser, context, privateScope) {
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  if (parser.flags & 1)
    parser.report(90);
  const argument = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "ThrowStatement",
    argument
  }, start);
}
__name(parseThrowStatement, "parseThrowStatement");
function parseIfStatement(parser, context, scope, privateScope, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  consume(parser, context | 32, 67174411);
  parser.assignable = 1;
  const test = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  consume(parser, context | 32, 16);
  const consequent = parseConsequentOrAlternative(parser, context, scope, privateScope, labels);
  let alternate = null;
  if (parser.getToken() === 20563) {
    nextToken(parser, context | 32);
    alternate = parseConsequentOrAlternative(parser, context, scope, privateScope, labels);
  }
  return parser.finishNode({
    type: "IfStatement",
    test,
    consequent,
    alternate
  }, start);
}
__name(parseIfStatement, "parseIfStatement");
function parseConsequentOrAlternative(parser, context, scope, privateScope, labels) {
  const { tokenStart } = parser;
  return context & 1 || !parser.options.webcompat || parser.getToken() !== 86104 ? parseStatement(parser, context, scope, privateScope, 0, { $: labels }, 0) : parseFunctionDeclaration(parser, context, scope == null ? void 0 : scope.createChildScope(), privateScope, 0, 0, 0, 0, tokenStart);
}
__name(parseConsequentOrAlternative, "parseConsequentOrAlternative");
function parseSwitchStatement(parser, context, scope, privateScope, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  consume(parser, context | 32, 67174411);
  const discriminant = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  consume(parser, context, 16);
  consume(parser, context, 2162700);
  const cases = [];
  let seenDefault = 0;
  scope = scope == null ? void 0 : scope.createChildScope(8);
  while (parser.getToken() !== 1074790415) {
    const { tokenStart } = parser;
    let test = null;
    const consequent = [];
    if (consumeOpt(parser, context | 32, 20556)) {
      test = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
    } else {
      consume(parser, context | 32, 20561);
      if (seenDefault)
        parser.report(89);
      seenDefault = 1;
    }
    consume(parser, context | 32, 21);
    while (parser.getToken() !== 20556 && parser.getToken() !== 1074790415 && parser.getToken() !== 20561) {
      consequent.push(parseStatementListItem(parser, context | 4, scope, privateScope, 2, {
        $: labels
      }));
    }
    cases.push(parser.finishNode({
      type: "SwitchCase",
      test,
      consequent
    }, tokenStart));
  }
  consume(parser, context | 32, 1074790415);
  return parser.finishNode({
    type: "SwitchStatement",
    discriminant,
    cases
  }, start);
}
__name(parseSwitchStatement, "parseSwitchStatement");
function parseWhileStatement(parser, context, scope, privateScope, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  consume(parser, context | 32, 67174411);
  const test = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  consume(parser, context | 32, 16);
  const body = parseIterationStatementBody(parser, context, scope, privateScope, labels);
  return parser.finishNode({
    type: "WhileStatement",
    test,
    body
  }, start);
}
__name(parseWhileStatement, "parseWhileStatement");
function parseIterationStatementBody(parser, context, scope, privateScope, labels) {
  return parseStatement(parser, (context | 131072) ^ 131072 | 128, scope, privateScope, 0, { loop: 1, $: labels }, 0);
}
__name(parseIterationStatementBody, "parseIterationStatementBody");
function parseContinueStatement(parser, context, labels) {
  if ((context & 128) === 0)
    parser.report(68);
  const start = parser.tokenStart;
  nextToken(parser, context);
  let label = null;
  if ((parser.flags & 1) === 0 && parser.getToken() & 143360) {
    const { tokenValue } = parser;
    label = parseIdentifier(parser, context | 32);
    if (!isValidLabel(parser, labels, tokenValue, 1))
      parser.report(138, tokenValue);
  }
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "ContinueStatement",
    label
  }, start);
}
__name(parseContinueStatement, "parseContinueStatement");
function parseBreakStatement(parser, context, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  let label = null;
  if ((parser.flags & 1) === 0 && parser.getToken() & 143360) {
    const { tokenValue } = parser;
    label = parseIdentifier(parser, context | 32);
    if (!isValidLabel(parser, labels, tokenValue, 0))
      parser.report(138, tokenValue);
  } else if ((context & (4 | 128)) === 0) {
    parser.report(69);
  }
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "BreakStatement",
    label
  }, start);
}
__name(parseBreakStatement, "parseBreakStatement");
function parseWithStatement(parser, context, scope, privateScope, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  if (context & 1)
    parser.report(91);
  consume(parser, context | 32, 67174411);
  const object = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  consume(parser, context | 32, 16);
  const body = parseStatement(parser, context, scope, privateScope, 2, labels, 0);
  return parser.finishNode({
    type: "WithStatement",
    object,
    body
  }, start);
}
__name(parseWithStatement, "parseWithStatement");
function parseDebuggerStatement(parser, context) {
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "DebuggerStatement"
  }, start);
}
__name(parseDebuggerStatement, "parseDebuggerStatement");
function parseTryStatement(parser, context, scope, privateScope, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  const firstScope = scope == null ? void 0 : scope.createChildScope(16);
  const block = parseBlock(parser, context, firstScope, privateScope, { $: labels });
  const { tokenStart } = parser;
  const handler = consumeOpt(parser, context | 32, 20557) ? parseCatchBlock(parser, context, scope, privateScope, labels, tokenStart) : null;
  let finalizer = null;
  if (parser.getToken() === 20566) {
    nextToken(parser, context | 32);
    const finalizerScope = scope == null ? void 0 : scope.createChildScope(4);
    const block2 = parseBlock(parser, context, finalizerScope, privateScope, { $: labels });
    finalizer = block2;
  }
  if (!handler && !finalizer) {
    parser.report(88);
  }
  return parser.finishNode({
    type: "TryStatement",
    block,
    handler,
    finalizer
  }, start);
}
__name(parseTryStatement, "parseTryStatement");
function parseCatchBlock(parser, context, scope, privateScope, labels, start) {
  let param = null;
  let additionalScope = scope;
  if (consumeOpt(parser, context, 67174411)) {
    scope = scope == null ? void 0 : scope.createChildScope(4);
    param = parseBindingPattern(parser, context, scope, privateScope, (parser.getToken() & 2097152) === 2097152 ? 256 : 512, 0);
    if (parser.getToken() === 18) {
      parser.report(86);
    } else if (parser.getToken() === 1077936155) {
      parser.report(87);
    }
    consume(parser, context | 32, 16);
  }
  additionalScope = scope == null ? void 0 : scope.createChildScope(32);
  const body = parseBlock(parser, context, additionalScope, privateScope, { $: labels });
  return parser.finishNode({
    type: "CatchClause",
    param,
    body
  }, start);
}
__name(parseCatchBlock, "parseCatchBlock");
function parseStaticBlock(parser, context, scope, privateScope, start) {
  scope = scope == null ? void 0 : scope.createChildScope();
  const ctorContext = 512 | 4096 | 1024 | 4 | 128;
  context = (context | ctorContext) ^ ctorContext | 256 | 2048 | 524288 | 65536;
  return parseBlock(parser, context, scope, privateScope, {}, start, "StaticBlock");
}
__name(parseStaticBlock, "parseStaticBlock");
function parseDoWhileStatement(parser, context, scope, privateScope, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  const body = parseIterationStatementBody(parser, context, scope, privateScope, labels);
  consume(parser, context, 20578);
  consume(parser, context | 32, 67174411);
  const test = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  consume(parser, context | 32, 16);
  consumeOpt(parser, context | 32, 1074790417);
  return parser.finishNode({
    type: "DoWhileStatement",
    body,
    test
  }, start);
}
__name(parseDoWhileStatement, "parseDoWhileStatement");
function parseLetIdentOrVarDeclarationStatement(parser, context, scope, privateScope, origin) {
  const { tokenValue, tokenStart } = parser;
  const token = parser.getToken();
  let expr = parseIdentifier(parser, context);
  if (parser.getToken() & (143360 | 2097152)) {
    const declarations = parseVariableDeclarationList(parser, context, scope, privateScope, 8, 0);
    matchOrInsertSemicolon(parser, context | 32);
    return parser.finishNode({
      type: "VariableDeclaration",
      kind: "let",
      declarations
    }, tokenStart);
  }
  parser.assignable = 1;
  if (context & 1)
    parser.report(85);
  if (parser.getToken() === 21) {
    return parseLabelledStatement(parser, context, scope, privateScope, origin, {}, tokenValue, expr, token, 0, tokenStart);
  }
  if (parser.getToken() === 10) {
    let scope2 = void 0;
    if (parser.options.lexical)
      scope2 = createArrowHeadParsingScope(parser, context, tokenValue);
    parser.flags = (parser.flags | 128) ^ 128;
    expr = parseArrowFunctionExpression(parser, context, scope2, privateScope, [expr], 0, tokenStart);
  } else {
    expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 0, 0, tokenStart);
    expr = parseAssignmentExpression(parser, context, privateScope, 0, 0, tokenStart, expr);
  }
  if (parser.getToken() === 18) {
    expr = parseSequenceExpression(parser, context, privateScope, 0, tokenStart, expr);
  }
  return parseExpressionStatement(parser, context, expr, tokenStart);
}
__name(parseLetIdentOrVarDeclarationStatement, "parseLetIdentOrVarDeclarationStatement");
function parseLexicalDeclaration(parser, context, scope, privateScope, kind, origin) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  const declarations = parseVariableDeclarationList(parser, context, scope, privateScope, kind, origin);
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "VariableDeclaration",
    kind: kind & 8 ? "let" : "const",
    declarations
  }, start);
}
__name(parseLexicalDeclaration, "parseLexicalDeclaration");
function parseVariableStatement(parser, context, scope, privateScope, origin) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  const declarations = parseVariableDeclarationList(parser, context, scope, privateScope, 4, origin);
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode({
    type: "VariableDeclaration",
    kind: "var",
    declarations
  }, start);
}
__name(parseVariableStatement, "parseVariableStatement");
function parseVariableDeclarationList(parser, context, scope, privateScope, kind, origin) {
  let bindingCount = 1;
  const list = [
    parseVariableDeclaration(parser, context, scope, privateScope, kind, origin)
  ];
  while (consumeOpt(parser, context, 18)) {
    bindingCount++;
    list.push(parseVariableDeclaration(parser, context, scope, privateScope, kind, origin));
  }
  if (bindingCount > 1 && origin & 32 && parser.getToken() & 262144) {
    parser.report(61, KeywordDescTable[parser.getToken() & 255]);
  }
  return list;
}
__name(parseVariableDeclarationList, "parseVariableDeclarationList");
function parseVariableDeclaration(parser, context, scope, privateScope, kind, origin) {
  const { tokenStart } = parser;
  const token = parser.getToken();
  let init = null;
  const id = parseBindingPattern(parser, context, scope, privateScope, kind, origin);
  if (parser.getToken() === 1077936155) {
    nextToken(parser, context | 32);
    init = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
    if (origin & 32 || (token & 2097152) === 0) {
      if (parser.getToken() === 471156 || parser.getToken() === 8673330 && (token & 2097152 || (kind & 4) === 0 || context & 1)) {
        throw new ParseError(tokenStart, parser.currentLocation, 60, parser.getToken() === 471156 ? "of" : "in");
      }
    }
  } else if ((kind & 16 || (token & 2097152) > 0) && (parser.getToken() & 262144) !== 262144) {
    parser.report(59, kind & 16 ? "const" : "destructuring");
  }
  return parser.finishNode({
    type: "VariableDeclarator",
    id,
    init
  }, tokenStart);
}
__name(parseVariableDeclaration, "parseVariableDeclaration");
function parseForStatement(parser, context, scope, privateScope, labels) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  const forAwait = ((context & 2048) > 0 || (context & 2) > 0 && (context & 8) > 0) && consumeOpt(parser, context, 209006);
  consume(parser, context | 32, 67174411);
  scope = scope == null ? void 0 : scope.createChildScope(1);
  let test = null;
  let update = null;
  let destructible = 0;
  let init = null;
  let isVarDecl = parser.getToken() === 86088 || parser.getToken() === 241737 || parser.getToken() === 86090;
  let right;
  const { tokenStart } = parser;
  const token = parser.getToken();
  if (isVarDecl) {
    if (token === 241737) {
      init = parseIdentifier(parser, context);
      if (parser.getToken() & (143360 | 2097152)) {
        if (parser.getToken() === 8673330) {
          if (context & 1)
            parser.report(67);
        } else {
          init = parser.finishNode({
            type: "VariableDeclaration",
            kind: "let",
            declarations: parseVariableDeclarationList(parser, context | 131072, scope, privateScope, 8, 32)
          }, tokenStart);
        }
        parser.assignable = 1;
      } else if (context & 1) {
        parser.report(67);
      } else {
        isVarDecl = false;
        parser.assignable = 1;
        init = parseMemberOrUpdateExpression(parser, context, privateScope, init, 0, 0, tokenStart);
        if (parser.getToken() === 471156)
          parser.report(115);
      }
    } else {
      nextToken(parser, context);
      init = parser.finishNode(token === 86088 ? {
        type: "VariableDeclaration",
        kind: "var",
        declarations: parseVariableDeclarationList(parser, context | 131072, scope, privateScope, 4, 32)
      } : {
        type: "VariableDeclaration",
        kind: "const",
        declarations: parseVariableDeclarationList(parser, context | 131072, scope, privateScope, 16, 32)
      }, tokenStart);
      parser.assignable = 1;
    }
  } else if (token === 1074790417) {
    if (forAwait)
      parser.report(82);
  } else if ((token & 2097152) === 2097152) {
    const patternStart = parser.tokenStart;
    init = token === 2162700 ? parseObjectLiteralOrPattern(parser, context, void 0, privateScope, 1, 0, 0, 2, 32) : parseArrayExpressionOrPattern(parser, context, void 0, privateScope, 1, 0, 0, 2, 32);
    destructible = parser.destructible;
    if (destructible & 64) {
      parser.report(63);
    }
    parser.assignable = destructible & 16 ? 2 : 1;
    init = parseMemberOrUpdateExpression(parser, context | 131072, privateScope, init, 0, 0, patternStart);
  } else {
    init = parseLeftHandSideExpression(parser, context | 131072, privateScope, 1, 0, 1);
  }
  if ((parser.getToken() & 262144) === 262144) {
    if (parser.getToken() === 471156) {
      if (parser.assignable & 2)
        parser.report(80, forAwait ? "await" : "of");
      reinterpretToPattern(parser, init);
      nextToken(parser, context | 32);
      right = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
      consume(parser, context | 32, 16);
      const body3 = parseIterationStatementBody(parser, context, scope, privateScope, labels);
      return parser.finishNode({
        type: "ForOfStatement",
        left: init,
        right,
        body: body3,
        await: forAwait
      }, start);
    }
    if (parser.assignable & 2)
      parser.report(80, "in");
    reinterpretToPattern(parser, init);
    nextToken(parser, context | 32);
    if (forAwait)
      parser.report(82);
    right = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
    consume(parser, context | 32, 16);
    const body2 = parseIterationStatementBody(parser, context, scope, privateScope, labels);
    return parser.finishNode({
      type: "ForInStatement",
      body: body2,
      left: init,
      right
    }, start);
  }
  if (forAwait)
    parser.report(82);
  if (!isVarDecl) {
    if (destructible & 8 && parser.getToken() !== 1077936155) {
      parser.report(80, "loop");
    }
    init = parseAssignmentExpression(parser, context | 131072, privateScope, 0, 0, tokenStart, init);
  }
  if (parser.getToken() === 18)
    init = parseSequenceExpression(parser, context, privateScope, 0, tokenStart, init);
  consume(parser, context | 32, 1074790417);
  if (parser.getToken() !== 1074790417)
    test = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  consume(parser, context | 32, 1074790417);
  if (parser.getToken() !== 16)
    update = parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart);
  consume(parser, context | 32, 16);
  const body = parseIterationStatementBody(parser, context, scope, privateScope, labels);
  return parser.finishNode({
    type: "ForStatement",
    init,
    test,
    update,
    body
  }, start);
}
__name(parseForStatement, "parseForStatement");
function parseRestrictedIdentifier(parser, context, scope) {
  if (!isValidIdentifier(context, parser.getToken()))
    parser.report(118);
  if ((parser.getToken() & 537079808) === 537079808)
    parser.report(119);
  scope == null ? void 0 : scope.addBlockName(context, parser.tokenValue, 8, 0);
  return parseIdentifier(parser, context);
}
__name(parseRestrictedIdentifier, "parseRestrictedIdentifier");
function parseImportDeclaration(parser, context, scope) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  let source = null;
  const { tokenStart } = parser;
  let specifiers = [];
  if (parser.getToken() === 134283267) {
    source = parseLiteral(parser, context);
  } else {
    if (parser.getToken() & 143360) {
      const local = parseRestrictedIdentifier(parser, context, scope);
      specifiers = [
        parser.finishNode({
          type: "ImportDefaultSpecifier",
          local
        }, tokenStart)
      ];
      if (consumeOpt(parser, context, 18)) {
        switch (parser.getToken()) {
          case 8391476:
            specifiers.push(parseImportNamespaceSpecifier(parser, context, scope));
            break;
          case 2162700:
            parseImportSpecifierOrNamedImports(parser, context, scope, specifiers);
            break;
          default:
            parser.report(107);
        }
      }
    } else {
      switch (parser.getToken()) {
        case 8391476:
          specifiers = [parseImportNamespaceSpecifier(parser, context, scope)];
          break;
        case 2162700:
          parseImportSpecifierOrNamedImports(parser, context, scope, specifiers);
          break;
        case 67174411:
          return parseImportCallDeclaration(parser, context, void 0, start);
        case 67108877:
          return parseImportMetaDeclaration(parser, context, start);
        default:
          parser.report(30, KeywordDescTable[parser.getToken() & 255]);
      }
    }
    source = parseModuleSpecifier(parser, context);
  }
  const attributes = parseImportAttributes(parser, context);
  const node = {
    type: "ImportDeclaration",
    specifiers,
    source,
    attributes
  };
  matchOrInsertSemicolon(parser, context | 32);
  return parser.finishNode(node, start);
}
__name(parseImportDeclaration, "parseImportDeclaration");
function parseImportNamespaceSpecifier(parser, context, scope) {
  const { tokenStart } = parser;
  nextToken(parser, context);
  consume(parser, context, 77932);
  if ((parser.getToken() & 134217728) === 134217728) {
    throw new ParseError(tokenStart, parser.currentLocation, 30, KeywordDescTable[parser.getToken() & 255]);
  }
  return parser.finishNode({
    type: "ImportNamespaceSpecifier",
    local: parseRestrictedIdentifier(parser, context, scope)
  }, tokenStart);
}
__name(parseImportNamespaceSpecifier, "parseImportNamespaceSpecifier");
function parseModuleSpecifier(parser, context) {
  consume(parser, context, 209011);
  if (parser.getToken() !== 134283267)
    parser.report(105, "Import");
  return parseLiteral(parser, context);
}
__name(parseModuleSpecifier, "parseModuleSpecifier");
function parseImportSpecifierOrNamedImports(parser, context, scope, specifiers) {
  nextToken(parser, context);
  while (parser.getToken() & 143360 || parser.getToken() === 134283267) {
    let { tokenValue, tokenStart } = parser;
    const token = parser.getToken();
    const imported = parseModuleExportName(parser, context);
    let local;
    if (consumeOpt(parser, context, 77932)) {
      if ((parser.getToken() & 134217728) === 134217728 || parser.getToken() === 18) {
        parser.report(106);
      } else {
        validateBindingIdentifier(parser, context, 16, parser.getToken(), 0);
      }
      tokenValue = parser.tokenValue;
      local = parseIdentifier(parser, context);
    } else if (imported.type === "Identifier") {
      validateBindingIdentifier(parser, context, 16, token, 0);
      local = imported;
    } else {
      parser.report(25, KeywordDescTable[77932 & 255]);
    }
    scope == null ? void 0 : scope.addBlockName(context, tokenValue, 8, 0);
    specifiers.push(parser.finishNode({
      type: "ImportSpecifier",
      local,
      imported
    }, tokenStart));
    if (parser.getToken() !== 1074790415)
      consume(parser, context, 18);
  }
  consume(parser, context, 1074790415);
  return specifiers;
}
__name(parseImportSpecifierOrNamedImports, "parseImportSpecifierOrNamedImports");
function parseImportMetaDeclaration(parser, context, start) {
  let expr = parseImportMetaExpression(parser, context, parser.finishNode({
    type: "Identifier",
    name: "import"
  }, start), start);
  expr = parseMemberOrUpdateExpression(parser, context, void 0, expr, 0, 0, start);
  expr = parseAssignmentExpression(parser, context, void 0, 0, 0, start, expr);
  if (parser.getToken() === 18) {
    expr = parseSequenceExpression(parser, context, void 0, 0, start, expr);
  }
  return parseExpressionStatement(parser, context, expr, start);
}
__name(parseImportMetaDeclaration, "parseImportMetaDeclaration");
function parseImportCallDeclaration(parser, context, privateScope, start) {
  let expr = parseImportExpression(parser, context, privateScope, 0, start);
  expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 0, 0, start);
  if (parser.getToken() === 18) {
    expr = parseSequenceExpression(parser, context, privateScope, 0, start, expr);
  }
  return parseExpressionStatement(parser, context, expr, start);
}
__name(parseImportCallDeclaration, "parseImportCallDeclaration");
function parseExportDeclaration(parser, context, scope) {
  const start = parser.leadingDecorators.decorators.length ? parser.leadingDecorators.start : parser.tokenStart;
  nextToken(parser, context | 32);
  const specifiers = [];
  let declaration = null;
  let source = null;
  let attributes = [];
  if (consumeOpt(parser, context | 32, 20561)) {
    switch (parser.getToken()) {
      case 86104: {
        declaration = parseFunctionDeclaration(parser, context, scope, void 0, 4, 1, 1, 0, parser.tokenStart);
        break;
      }
      case 132:
      case 86094:
        declaration = parseClassDeclaration(parser, context, scope, void 0, 1);
        break;
      case 209005: {
        const { tokenStart } = parser;
        declaration = parseIdentifier(parser, context);
        const { flags } = parser;
        if ((flags & 1) === 0) {
          if (parser.getToken() === 86104) {
            declaration = parseFunctionDeclaration(parser, context, scope, void 0, 4, 1, 1, 1, tokenStart);
          } else {
            if (parser.getToken() === 67174411) {
              declaration = parseAsyncArrowOrCallExpression(parser, context, void 0, declaration, 1, 1, 0, flags, tokenStart);
              declaration = parseMemberOrUpdateExpression(parser, context, void 0, declaration, 0, 0, tokenStart);
              declaration = parseAssignmentExpression(parser, context, void 0, 0, 0, tokenStart, declaration);
            } else if (parser.getToken() & 143360) {
              if (scope)
                scope = createArrowHeadParsingScope(parser, context, parser.tokenValue);
              declaration = parseIdentifier(parser, context);
              declaration = parseArrowFunctionExpression(parser, context, scope, void 0, [declaration], 1, tokenStart);
            }
          }
        }
        break;
      }
      default:
        declaration = parseExpression(parser, context, void 0, 1, 0, parser.tokenStart);
        matchOrInsertSemicolon(parser, context | 32);
    }
    if (scope)
      parser.declareUnboundVariable("default");
    return parser.finishNode({
      type: "ExportDefaultDeclaration",
      declaration
    }, start);
  }
  switch (parser.getToken()) {
    case 8391476: {
      nextToken(parser, context);
      let exported = null;
      const isNamedDeclaration = consumeOpt(parser, context, 77932);
      if (isNamedDeclaration) {
        if (scope)
          parser.declareUnboundVariable(parser.tokenValue);
        exported = parseModuleExportName(parser, context);
      }
      consume(parser, context, 209011);
      if (parser.getToken() !== 134283267)
        parser.report(105, "Export");
      source = parseLiteral(parser, context);
      const attributes2 = parseImportAttributes(parser, context);
      const node2 = {
        type: "ExportAllDeclaration",
        source,
        exported,
        attributes: attributes2
      };
      matchOrInsertSemicolon(parser, context | 32);
      return parser.finishNode(node2, start);
    }
    case 2162700: {
      nextToken(parser, context);
      const tmpExportedNames = [];
      const tmpExportedBindings = [];
      let hasLiteralLocal = 0;
      while (parser.getToken() & 143360 || parser.getToken() === 134283267) {
        const { tokenStart, tokenValue } = parser;
        const local = parseModuleExportName(parser, context);
        if (local.type === "Literal") {
          hasLiteralLocal = 1;
        }
        let exported;
        if (parser.getToken() === 77932) {
          nextToken(parser, context);
          if ((parser.getToken() & 143360) === 0 && parser.getToken() !== 134283267) {
            parser.report(106);
          }
          if (scope) {
            tmpExportedNames.push(parser.tokenValue);
            tmpExportedBindings.push(tokenValue);
          }
          exported = parseModuleExportName(parser, context);
        } else {
          if (scope) {
            tmpExportedNames.push(parser.tokenValue);
            tmpExportedBindings.push(parser.tokenValue);
          }
          exported = local;
        }
        specifiers.push(parser.finishNode({
          type: "ExportSpecifier",
          local,
          exported
        }, tokenStart));
        if (parser.getToken() !== 1074790415)
          consume(parser, context, 18);
      }
      consume(parser, context, 1074790415);
      if (consumeOpt(parser, context, 209011)) {
        if (parser.getToken() !== 134283267)
          parser.report(105, "Export");
        source = parseLiteral(parser, context);
        attributes = parseImportAttributes(parser, context);
        if (scope) {
          tmpExportedNames.forEach((n) => parser.declareUnboundVariable(n));
        }
      } else {
        if (hasLiteralLocal) {
          parser.report(172);
        }
        if (scope) {
          tmpExportedNames.forEach((n) => parser.declareUnboundVariable(n));
          tmpExportedBindings.forEach((b) => parser.addBindingToExports(b));
        }
      }
      matchOrInsertSemicolon(parser, context | 32);
      break;
    }
    case 132:
    case 86094:
      declaration = parseClassDeclaration(parser, context, scope, void 0, 2);
      break;
    case 86104:
      declaration = parseFunctionDeclaration(parser, context, scope, void 0, 4, 1, 2, 0, parser.tokenStart);
      break;
    case 241737:
      declaration = parseLexicalDeclaration(parser, context, scope, void 0, 8, 64);
      break;
    case 86090:
      declaration = parseLexicalDeclaration(parser, context, scope, void 0, 16, 64);
      break;
    case 86088:
      declaration = parseVariableStatement(parser, context, scope, void 0, 64);
      break;
    case 209005: {
      const { tokenStart } = parser;
      nextToken(parser, context);
      if ((parser.flags & 1) === 0 && parser.getToken() === 86104) {
        declaration = parseFunctionDeclaration(parser, context, scope, void 0, 4, 1, 2, 1, tokenStart);
        break;
      }
    }
    default:
      parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
  const node = {
    type: "ExportNamedDeclaration",
    declaration,
    specifiers,
    source,
    attributes
  };
  return parser.finishNode(node, start);
}
__name(parseExportDeclaration, "parseExportDeclaration");
function parseExpression(parser, context, privateScope, canAssign, inGroup, start) {
  let expr = parsePrimaryExpression(parser, context, privateScope, 2, 0, canAssign, inGroup, 1, start);
  expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, inGroup, 0, start);
  return parseAssignmentExpression(parser, context, privateScope, inGroup, 0, start, expr);
}
__name(parseExpression, "parseExpression");
function parseSequenceExpression(parser, context, privateScope, inGroup, start, expr) {
  const expressions = [expr];
  while (consumeOpt(parser, context | 32, 18)) {
    expressions.push(parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart));
  }
  return parser.finishNode({
    type: "SequenceExpression",
    expressions
  }, start);
}
__name(parseSequenceExpression, "parseSequenceExpression");
function parseExpressions(parser, context, privateScope, inGroup, canAssign, start) {
  const expr = parseExpression(parser, context, privateScope, canAssign, inGroup, start);
  return parser.getToken() === 18 ? parseSequenceExpression(parser, context, privateScope, inGroup, start, expr) : expr;
}
__name(parseExpressions, "parseExpressions");
function parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, start, left) {
  const token = parser.getToken();
  if ((token & 4194304) === 4194304) {
    if (parser.assignable & 2)
      parser.report(26);
    if (!isPattern && token === 1077936155 && left.type === "ArrayExpression" || left.type === "ObjectExpression") {
      reinterpretToPattern(parser, left);
    }
    nextToken(parser, context | 32);
    const right = parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart);
    parser.assignable = 2;
    return parser.finishNode(isPattern ? {
      type: "AssignmentPattern",
      left,
      right
    } : {
      type: "AssignmentExpression",
      left,
      operator: KeywordDescTable[token & 255],
      right
    }, start);
  }
  if ((token & 8388608) === 8388608) {
    left = parseBinaryExpression(parser, context, privateScope, inGroup, start, 4, token, left);
  }
  if (consumeOpt(parser, context | 32, 22)) {
    left = parseConditionalExpression(parser, context, privateScope, left, start);
  }
  return left;
}
__name(parseAssignmentExpression, "parseAssignmentExpression");
function parseAssignmentExpressionOrPattern(parser, context, privateScope, inGroup, isPattern, start, left) {
  const token = parser.getToken();
  nextToken(parser, context | 32);
  const right = parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart);
  left = parser.finishNode(isPattern ? {
    type: "AssignmentPattern",
    left,
    right
  } : {
    type: "AssignmentExpression",
    left,
    operator: KeywordDescTable[token & 255],
    right
  }, start);
  parser.assignable = 2;
  return left;
}
__name(parseAssignmentExpressionOrPattern, "parseAssignmentExpressionOrPattern");
function parseConditionalExpression(parser, context, privateScope, test, start) {
  const consequent = parseExpression(parser, (context | 131072) ^ 131072, privateScope, 1, 0, parser.tokenStart);
  consume(parser, context | 32, 21);
  parser.assignable = 1;
  const alternate = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
  parser.assignable = 2;
  return parser.finishNode({
    type: "ConditionalExpression",
    test,
    consequent,
    alternate
  }, start);
}
__name(parseConditionalExpression, "parseConditionalExpression");
function parseBinaryExpression(parser, context, privateScope, inGroup, start, minPrecedence, operator, left) {
  const bit = -((context & 131072) > 0) & 8673330;
  let t;
  let precedence;
  parser.assignable = 2;
  while (parser.getToken() & 8388608) {
    t = parser.getToken();
    precedence = t & 3840;
    if (t & 524288 && operator & 268435456 || operator & 524288 && t & 268435456) {
      parser.report(165);
    }
    if (precedence + ((t === 8391735) << 8) - ((bit === t) << 12) <= minPrecedence)
      break;
    nextToken(parser, context | 32);
    left = parser.finishNode({
      type: t & 524288 || t & 268435456 ? "LogicalExpression" : "BinaryExpression",
      left,
      right: parseBinaryExpression(parser, context, privateScope, inGroup, parser.tokenStart, precedence, t, parseLeftHandSideExpression(parser, context, privateScope, 0, inGroup, 1)),
      operator: KeywordDescTable[t & 255]
    }, start);
  }
  if (parser.getToken() === 1077936155)
    parser.report(26);
  return left;
}
__name(parseBinaryExpression, "parseBinaryExpression");
function parseUnaryExpression(parser, context, privateScope, isLHS, inGroup) {
  if (!isLHS)
    parser.report(0);
  const { tokenStart } = parser;
  const unaryOperator = parser.getToken();
  nextToken(parser, context | 32);
  const arg = parseLeftHandSideExpression(parser, context, privateScope, 0, inGroup, 1);
  if (parser.getToken() === 8391735)
    parser.report(33);
  if (context & 1 && unaryOperator === 16863276) {
    if (arg.type === "Identifier") {
      parser.report(121);
    } else if (isPropertyWithPrivateFieldKey(arg)) {
      parser.report(127);
    }
  }
  parser.assignable = 2;
  return parser.finishNode({
    type: "UnaryExpression",
    operator: KeywordDescTable[unaryOperator & 255],
    argument: arg,
    prefix: true
  }, tokenStart);
}
__name(parseUnaryExpression, "parseUnaryExpression");
function parseAsyncExpression(parser, context, privateScope, inGroup, isLHS, canAssign, inNew, start) {
  const token = parser.getToken();
  const expr = parseIdentifier(parser, context);
  const { flags } = parser;
  if ((flags & 1) === 0) {
    if (parser.getToken() === 86104) {
      return parseFunctionExpression(parser, context, privateScope, 1, inGroup, start);
    }
    if (isValidIdentifier(context, parser.getToken())) {
      if (!isLHS)
        parser.report(0);
      if ((parser.getToken() & 36864) === 36864) {
        parser.flags |= 256;
      }
      return parseAsyncArrowAfterIdent(parser, context, privateScope, canAssign, start);
    }
  }
  if (!inNew && parser.getToken() === 67174411) {
    return parseAsyncArrowOrCallExpression(parser, context, privateScope, expr, canAssign, 1, 0, flags, start);
  }
  if (parser.getToken() === 10) {
    classifyIdentifier(parser, context, token);
    if (inNew)
      parser.report(51);
    if ((token & 36864) === 36864) {
      parser.flags |= 256;
    }
    return parseArrowFromIdentifier(parser, context, privateScope, parser.tokenValue, expr, inNew, canAssign, 0, start);
  }
  parser.assignable = 1;
  return expr;
}
__name(parseAsyncExpression, "parseAsyncExpression");
function parseYieldExpressionOrIdentifier(parser, context, privateScope, inGroup, canAssign, start) {
  if (inGroup)
    parser.destructible |= 256;
  if (context & 1024) {
    nextToken(parser, context | 32);
    if (context & 8192)
      parser.report(32);
    if (!canAssign)
      parser.report(26);
    if (parser.getToken() === 22)
      parser.report(124);
    let argument = null;
    let delegate = false;
    if ((parser.flags & 1) === 0) {
      delegate = consumeOpt(parser, context | 32, 8391476);
      if (parser.getToken() & (12288 | 65536) || delegate) {
        argument = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
      }
    } else if (parser.getToken() === 8391476) {
      parser.report(30, KeywordDescTable[parser.getToken() & 255]);
    }
    parser.assignable = 2;
    return parser.finishNode({
      type: "YieldExpression",
      argument,
      delegate
    }, start);
  }
  if (context & 1)
    parser.report(97, "yield");
  return parseIdentifierOrArrow(parser, context, privateScope);
}
__name(parseYieldExpressionOrIdentifier, "parseYieldExpressionOrIdentifier");
function parseAwaitExpressionOrIdentifier(parser, context, privateScope, inNew, inGroup, start) {
  if (inGroup)
    parser.destructible |= 128;
  if (context & 524288)
    parser.report(177);
  const possibleIdentifierOrArrowFunc = parseIdentifierOrArrow(parser, context, privateScope);
  const isIdentifier = possibleIdentifierOrArrowFunc.type === "ArrowFunctionExpression" || (parser.getToken() & 65536) === 0;
  if (isIdentifier) {
    if (context & 2048)
      throw new ParseError(start, { index: parser.startIndex, line: parser.startLine, column: parser.startColumn }, 176);
    if (context & 2)
      throw new ParseError(start, { index: parser.startIndex, line: parser.startLine, column: parser.startColumn }, 110);
    if (context & 8192 && context & 2048)
      throw new ParseError(start, { index: parser.startIndex, line: parser.startLine, column: parser.startColumn }, 110);
    return possibleIdentifierOrArrowFunc;
  }
  if (context & 8192) {
    throw new ParseError(start, { index: parser.startIndex, line: parser.startLine, column: parser.startColumn }, 31);
  }
  if (context & 2048 || context & 2 && context & 8) {
    if (inNew)
      throw new ParseError(start, { index: parser.startIndex, line: parser.startLine, column: parser.startColumn }, 0);
    const argument = parseLeftHandSideExpression(parser, context, privateScope, 0, 0, 1);
    if (parser.getToken() === 8391735)
      parser.report(33);
    parser.assignable = 2;
    return parser.finishNode({
      type: "AwaitExpression",
      argument
    }, start);
  }
  if (context & 2)
    throw new ParseError(start, { index: parser.startIndex, line: parser.startLine, column: parser.startColumn }, 98);
  return possibleIdentifierOrArrowFunc;
}
__name(parseAwaitExpressionOrIdentifier, "parseAwaitExpressionOrIdentifier");
function parseFunctionBody(parser, context, scope, privateScope, origin, funcNameToken, functionScope) {
  const { tokenStart } = parser;
  consume(parser, context | 32, 2162700);
  const body = [];
  if (parser.getToken() !== 1074790415) {
    while (parser.getToken() === 134283267) {
      const { index, tokenStart: tokenStart2, tokenIndex, tokenValue } = parser;
      const token = parser.getToken();
      const expr = parseLiteral(parser, context);
      if (isValidStrictMode(parser, index, tokenIndex, tokenValue)) {
        context |= 1;
        if (parser.flags & 128) {
          throw new ParseError(tokenStart2, parser.currentLocation, 66);
        }
        if (parser.flags & 64) {
          throw new ParseError(tokenStart2, parser.currentLocation, 9);
        }
        if (parser.flags & 4096) {
          throw new ParseError(tokenStart2, parser.currentLocation, 15);
        }
        functionScope == null ? void 0 : functionScope.reportScopeError();
      }
      body.push(parseDirective(parser, context, expr, token, tokenStart2));
    }
    if (context & 1) {
      if (funcNameToken) {
        if ((funcNameToken & 537079808) === 537079808) {
          parser.report(119);
        }
        if ((funcNameToken & 36864) === 36864) {
          parser.report(40);
        }
      }
      if (parser.flags & 512)
        parser.report(119);
      if (parser.flags & 256)
        parser.report(118);
    }
  }
  parser.flags = (parser.flags | 512 | 256 | 64 | 4096) ^ (512 | 256 | 64 | 4096);
  parser.destructible = (parser.destructible | 256) ^ 256;
  while (parser.getToken() !== 1074790415) {
    body.push(parseStatementListItem(parser, context, scope, privateScope, 4, {}));
  }
  consume(parser, origin & (16 | 8) ? context | 32 : context, 1074790415);
  parser.flags &= -4289;
  if (parser.getToken() === 1077936155)
    parser.report(26);
  return parser.finishNode({
    type: "BlockStatement",
    body
  }, tokenStart);
}
__name(parseFunctionBody, "parseFunctionBody");
function parseSuperExpression(parser, context) {
  const { tokenStart } = parser;
  nextToken(parser, context);
  switch (parser.getToken()) {
    case 67108990:
      parser.report(167);
    case 67174411: {
      if ((context & 512) === 0)
        parser.report(28);
      parser.assignable = 2;
      break;
    }
    case 69271571:
    case 67108877: {
      if ((context & 256) === 0)
        parser.report(29);
      parser.assignable = 1;
      break;
    }
    default:
      parser.report(30, "super");
  }
  return parser.finishNode({ type: "Super" }, tokenStart);
}
__name(parseSuperExpression, "parseSuperExpression");
function parseLeftHandSideExpression(parser, context, privateScope, canAssign, inGroup, isLHS) {
  const start = parser.tokenStart;
  const expression = parsePrimaryExpression(parser, context, privateScope, 2, 0, canAssign, inGroup, isLHS, start);
  return parseMemberOrUpdateExpression(parser, context, privateScope, expression, inGroup, 0, start);
}
__name(parseLeftHandSideExpression, "parseLeftHandSideExpression");
function parseUpdateExpression(parser, context, expr, start) {
  if (parser.assignable & 2)
    parser.report(55);
  const token = parser.getToken();
  nextToken(parser, context);
  parser.assignable = 2;
  return parser.finishNode({
    type: "UpdateExpression",
    argument: expr,
    operator: KeywordDescTable[token & 255],
    prefix: false
  }, start);
}
__name(parseUpdateExpression, "parseUpdateExpression");
function parseMemberOrUpdateExpression(parser, context, privateScope, expr, inGroup, inChain, start) {
  if ((parser.getToken() & 33619968) === 33619968 && (parser.flags & 1) === 0) {
    expr = parseUpdateExpression(parser, context, expr, start);
  } else if ((parser.getToken() & 67108864) === 67108864) {
    context = (context | 131072) ^ 131072;
    switch (parser.getToken()) {
      case 67108877: {
        nextToken(parser, (context | 262144 | 8) ^ 8);
        if (context & 16 && parser.getToken() === 130 && parser.tokenValue === "super") {
          parser.report(173);
        }
        parser.assignable = 1;
        const property = parsePropertyOrPrivatePropertyName(parser, context | 64, privateScope);
        expr = parser.finishNode({
          type: "MemberExpression",
          object: expr,
          computed: false,
          property,
          optional: false
        }, start);
        break;
      }
      case 69271571: {
        let restoreHasOptionalChaining = false;
        if ((parser.flags & 2048) === 2048) {
          restoreHasOptionalChaining = true;
          parser.flags = (parser.flags | 2048) ^ 2048;
        }
        nextToken(parser, context | 32);
        const { tokenStart } = parser;
        const property = parseExpressions(parser, context, privateScope, inGroup, 1, tokenStart);
        consume(parser, context, 20);
        parser.assignable = 1;
        expr = parser.finishNode({
          type: "MemberExpression",
          object: expr,
          computed: true,
          property,
          optional: false
        }, start);
        if (restoreHasOptionalChaining) {
          parser.flags |= 2048;
        }
        break;
      }
      case 67174411: {
        if ((parser.flags & 1024) === 1024) {
          parser.flags = (parser.flags | 1024) ^ 1024;
          return expr;
        }
        let restoreHasOptionalChaining = false;
        if ((parser.flags & 2048) === 2048) {
          restoreHasOptionalChaining = true;
          parser.flags = (parser.flags | 2048) ^ 2048;
        }
        const args = parseArguments(parser, context, privateScope, inGroup);
        parser.assignable = 2;
        expr = parser.finishNode({
          type: "CallExpression",
          callee: expr,
          arguments: args,
          optional: false
        }, start);
        if (restoreHasOptionalChaining) {
          parser.flags |= 2048;
        }
        break;
      }
      case 67108990: {
        nextToken(parser, (context | 262144 | 8) ^ 8);
        parser.flags |= 2048;
        parser.assignable = 2;
        expr = parseOptionalChain(parser, context, privateScope, expr, start);
        break;
      }
      default:
        if ((parser.flags & 2048) === 2048) {
          parser.report(166);
        }
        parser.assignable = 2;
        expr = parser.finishNode({
          type: "TaggedTemplateExpression",
          tag: expr,
          quasi: parser.getToken() === 67174408 ? parseTemplate(parser, context | 64, privateScope) : parseTemplateLiteral(parser, context)
        }, start);
    }
    expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 0, 1, start);
  }
  if (inChain === 0 && (parser.flags & 2048) === 2048) {
    parser.flags = (parser.flags | 2048) ^ 2048;
    expr = parser.finishNode({
      type: "ChainExpression",
      expression: expr
    }, start);
  }
  return expr;
}
__name(parseMemberOrUpdateExpression, "parseMemberOrUpdateExpression");
function parseOptionalChain(parser, context, privateScope, expr, start) {
  let restoreHasOptionalChaining = false;
  let node;
  if (parser.getToken() === 69271571 || parser.getToken() === 67174411) {
    if ((parser.flags & 2048) === 2048) {
      restoreHasOptionalChaining = true;
      parser.flags = (parser.flags | 2048) ^ 2048;
    }
  }
  if (parser.getToken() === 69271571) {
    nextToken(parser, context | 32);
    const { tokenStart } = parser;
    const property = parseExpressions(parser, context, privateScope, 0, 1, tokenStart);
    consume(parser, context, 20);
    parser.assignable = 2;
    node = parser.finishNode({
      type: "MemberExpression",
      object: expr,
      computed: true,
      optional: true,
      property
    }, start);
  } else if (parser.getToken() === 67174411) {
    const args = parseArguments(parser, context, privateScope, 0);
    parser.assignable = 2;
    node = parser.finishNode({
      type: "CallExpression",
      callee: expr,
      arguments: args,
      optional: true
    }, start);
  } else {
    const property = parsePropertyOrPrivatePropertyName(parser, context, privateScope);
    parser.assignable = 2;
    node = parser.finishNode({
      type: "MemberExpression",
      object: expr,
      computed: false,
      optional: true,
      property
    }, start);
  }
  if (restoreHasOptionalChaining) {
    parser.flags |= 2048;
  }
  return node;
}
__name(parseOptionalChain, "parseOptionalChain");
function parsePropertyOrPrivatePropertyName(parser, context, privateScope) {
  if ((parser.getToken() & 143360) === 0 && parser.getToken() !== -2147483528 && parser.getToken() !== -2147483527 && parser.getToken() !== 130) {
    parser.report(160);
  }
  return parser.getToken() === 130 ? parsePrivateIdentifier(parser, context, privateScope, 0) : parseIdentifier(parser, context);
}
__name(parsePropertyOrPrivatePropertyName, "parsePropertyOrPrivatePropertyName");
function parseUpdateExpressionPrefixed(parser, context, privateScope, inNew, isLHS, start) {
  if (inNew)
    parser.report(56);
  if (!isLHS)
    parser.report(0);
  const token = parser.getToken();
  nextToken(parser, context | 32);
  const arg = parseLeftHandSideExpression(parser, context, privateScope, 0, 0, 1);
  if (parser.assignable & 2) {
    parser.report(55);
  }
  parser.assignable = 2;
  return parser.finishNode({
    type: "UpdateExpression",
    argument: arg,
    operator: KeywordDescTable[token & 255],
    prefix: true
  }, start);
}
__name(parseUpdateExpressionPrefixed, "parseUpdateExpressionPrefixed");
function parsePrimaryExpression(parser, context, privateScope, kind, inNew, canAssign, inGroup, isLHS, start) {
  if ((parser.getToken() & 143360) === 143360) {
    switch (parser.getToken()) {
      case 209006:
        return parseAwaitExpressionOrIdentifier(parser, context, privateScope, inNew, inGroup, start);
      case 241771:
        return parseYieldExpressionOrIdentifier(parser, context, privateScope, inGroup, canAssign, start);
      case 209005:
        return parseAsyncExpression(parser, context, privateScope, inGroup, isLHS, canAssign, inNew, start);
    }
    const { tokenValue } = parser;
    const token = parser.getToken();
    const expr = parseIdentifier(parser, context | 64);
    if (parser.getToken() === 10) {
      if (!isLHS)
        parser.report(0);
      classifyIdentifier(parser, context, token);
      if ((token & 36864) === 36864) {
        parser.flags |= 256;
      }
      return parseArrowFromIdentifier(parser, context, privateScope, tokenValue, expr, inNew, canAssign, 0, start);
    }
    if (context & 16 && !(context & 32768) && !(context & 8192) && parser.tokenValue === "arguments")
      parser.report(130);
    if ((token & 255) === (241737 & 255)) {
      if (context & 1)
        parser.report(113);
      if (kind & (8 | 16))
        parser.report(100);
    }
    parser.assignable = context & 1 && (token & 537079808) === 537079808 ? 2 : 1;
    return expr;
  }
  if ((parser.getToken() & 134217728) === 134217728) {
    return parseLiteral(parser, context);
  }
  switch (parser.getToken()) {
    case 33619993:
    case 33619994:
      return parseUpdateExpressionPrefixed(parser, context, privateScope, inNew, isLHS, start);
    case 16863276:
    case 16842798:
    case 16842799:
    case 25233968:
    case 25233969:
    case 16863275:
    case 16863277:
      return parseUnaryExpression(parser, context, privateScope, isLHS, inGroup);
    case 86104:
      return parseFunctionExpression(parser, context, privateScope, 0, inGroup, start);
    case 2162700:
      return parseObjectLiteral(parser, context, privateScope, canAssign ? 0 : 1, inGroup);
    case 69271571:
      return parseArrayLiteral(parser, context, privateScope, canAssign ? 0 : 1, inGroup);
    case 67174411:
      return parseParenthesizedExpression(parser, context | 64, privateScope, canAssign, 1, 0, start);
    case 86021:
    case 86022:
    case 86023:
      return parseNullOrTrueOrFalseLiteral(parser, context);
    case 86111:
      return parseThisExpression(parser, context);
    case 65540:
      return parseRegExpLiteral(parser, context);
    case 132:
    case 86094:
      return parseClassExpression(parser, context, privateScope, inGroup, start);
    case 86109:
      return parseSuperExpression(parser, context);
    case 67174409:
      return parseTemplateLiteral(parser, context);
    case 67174408:
      return parseTemplate(parser, context, privateScope);
    case 86107:
      return parseNewExpression(parser, context, privateScope, inGroup);
    case 134283388:
      return parseBigIntLiteral(parser, context);
    case 130:
      return parsePrivateIdentifier(parser, context, privateScope, 0);
    case 86106:
      return parseImportCallOrMetaExpression(parser, context, privateScope, inNew, inGroup, start);
    case 8456256:
      if (parser.options.jsx)
        return parseJSXRootElementOrFragment(parser, context, privateScope, 0, parser.tokenStart);
    default:
      if (isValidIdentifier(context, parser.getToken()))
        return parseIdentifierOrArrow(parser, context, privateScope);
      parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
}
__name(parsePrimaryExpression, "parsePrimaryExpression");
function parseImportCallOrMetaExpression(parser, context, privateScope, inNew, inGroup, start) {
  let expr = parseIdentifier(parser, context);
  if (parser.getToken() === 67108877) {
    return parseImportMetaExpression(parser, context, expr, start);
  }
  if (inNew)
    parser.report(142);
  expr = parseImportExpression(parser, context, privateScope, inGroup, start);
  parser.assignable = 2;
  return parseMemberOrUpdateExpression(parser, context, privateScope, expr, inGroup, 0, start);
}
__name(parseImportCallOrMetaExpression, "parseImportCallOrMetaExpression");
function parseImportMetaExpression(parser, context, meta, start) {
  if ((context & 2) === 0)
    parser.report(169);
  nextToken(parser, context);
  const token = parser.getToken();
  if (token !== 209030 && parser.tokenValue !== "meta") {
    parser.report(174);
  } else if (token & -2147483648) {
    parser.report(175);
  }
  parser.assignable = 2;
  return parser.finishNode({
    type: "MetaProperty",
    meta,
    property: parseIdentifier(parser, context)
  }, start);
}
__name(parseImportMetaExpression, "parseImportMetaExpression");
function parseImportExpression(parser, context, privateScope, inGroup, start) {
  consume(parser, context | 32, 67174411);
  if (parser.getToken() === 14)
    parser.report(143);
  const source = parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart);
  let options = null;
  if (parser.getToken() === 18) {
    consume(parser, context, 18);
    if (parser.getToken() !== 16) {
      const expContext = (context | 131072) ^ 131072;
      options = parseExpression(parser, expContext, privateScope, 1, inGroup, parser.tokenStart);
    }
    consumeOpt(parser, context, 18);
  }
  const node = {
    type: "ImportExpression",
    source,
    options
  };
  consume(parser, context, 16);
  return parser.finishNode(node, start);
}
__name(parseImportExpression, "parseImportExpression");
function parseImportAttributes(parser, context) {
  if (!consumeOpt(parser, context, 20579))
    return [];
  consume(parser, context, 2162700);
  const attributes = [];
  const keysContent = /* @__PURE__ */ new Set();
  while (parser.getToken() !== 1074790415) {
    const start = parser.tokenStart;
    const key = parseIdentifierOrStringLiteral(parser, context);
    consume(parser, context, 21);
    const value = parseStringLiteral(parser, context);
    const keyContent = key.type === "Literal" ? key.value : key.name;
    if (keysContent.has(keyContent)) {
      parser.report(145, `${keyContent}`);
    }
    keysContent.add(keyContent);
    attributes.push(parser.finishNode({
      type: "ImportAttribute",
      key,
      value
    }, start));
    if (parser.getToken() !== 1074790415) {
      consume(parser, context, 18);
    }
  }
  consume(parser, context, 1074790415);
  return attributes;
}
__name(parseImportAttributes, "parseImportAttributes");
function parseStringLiteral(parser, context) {
  if (parser.getToken() === 134283267) {
    return parseLiteral(parser, context);
  } else {
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
}
__name(parseStringLiteral, "parseStringLiteral");
function parseIdentifierOrStringLiteral(parser, context) {
  if (parser.getToken() === 134283267) {
    return parseLiteral(parser, context);
  } else if (parser.getToken() & 143360) {
    return parseIdentifier(parser, context);
  } else {
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
}
__name(parseIdentifierOrStringLiteral, "parseIdentifierOrStringLiteral");
function validateStringWellFormed(parser, str) {
  const len = str.length;
  for (let i = 0; i < len; i++) {
    const code = str.charCodeAt(i);
    if ((code & 64512) !== 55296)
      continue;
    if (code > 56319 || ++i >= len || (str.charCodeAt(i) & 64512) !== 56320) {
      parser.report(171, JSON.stringify(str.charAt(i--)));
    }
  }
}
__name(validateStringWellFormed, "validateStringWellFormed");
function parseModuleExportName(parser, context) {
  if (parser.getToken() === 134283267) {
    validateStringWellFormed(parser, parser.tokenValue);
    return parseLiteral(parser, context);
  } else if (parser.getToken() & 143360) {
    return parseIdentifier(parser, context);
  } else {
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
}
__name(parseModuleExportName, "parseModuleExportName");
function parseBigIntLiteral(parser, context) {
  const { tokenRaw, tokenValue, tokenStart } = parser;
  nextToken(parser, context);
  parser.assignable = 2;
  const node = {
    type: "Literal",
    value: tokenValue,
    bigint: String(tokenValue)
  };
  if (parser.options.raw) {
    node.raw = tokenRaw;
  }
  return parser.finishNode(node, tokenStart);
}
__name(parseBigIntLiteral, "parseBigIntLiteral");
function parseTemplateLiteral(parser, context) {
  parser.assignable = 2;
  const { tokenValue, tokenRaw, tokenStart } = parser;
  consume(parser, context, 67174409);
  const quasis = [parseTemplateElement(parser, tokenValue, tokenRaw, tokenStart, true)];
  return parser.finishNode({
    type: "TemplateLiteral",
    expressions: [],
    quasis
  }, tokenStart);
}
__name(parseTemplateLiteral, "parseTemplateLiteral");
function parseTemplate(parser, context, privateScope) {
  context = (context | 131072) ^ 131072;
  const { tokenValue, tokenRaw, tokenStart } = parser;
  consume(parser, context & -65 | 32, 67174408);
  const quasis = [parseTemplateElement(parser, tokenValue, tokenRaw, tokenStart, false)];
  const expressions = [
    parseExpressions(parser, context & -65, privateScope, 0, 1, parser.tokenStart)
  ];
  if (parser.getToken() !== 1074790415)
    parser.report(83);
  while (parser.setToken(scanTemplateTail(parser, context), true) !== 67174409) {
    const { tokenValue: tokenValue2, tokenRaw: tokenRaw2, tokenStart: tokenStart2 } = parser;
    consume(parser, context & -65 | 32, 67174408);
    quasis.push(parseTemplateElement(parser, tokenValue2, tokenRaw2, tokenStart2, false));
    expressions.push(parseExpressions(parser, context, privateScope, 0, 1, parser.tokenStart));
    if (parser.getToken() !== 1074790415)
      parser.report(83);
  }
  {
    const { tokenValue: tokenValue2, tokenRaw: tokenRaw2, tokenStart: tokenStart2 } = parser;
    consume(parser, context, 67174409);
    quasis.push(parseTemplateElement(parser, tokenValue2, tokenRaw2, tokenStart2, true));
  }
  return parser.finishNode({
    type: "TemplateLiteral",
    expressions,
    quasis
  }, tokenStart);
}
__name(parseTemplate, "parseTemplate");
function parseTemplateElement(parser, cooked, raw, start, tail) {
  const node = parser.finishNode({
    type: "TemplateElement",
    value: {
      cooked,
      raw
    },
    tail
  }, start);
  const tailSize = tail ? 1 : 2;
  if (parser.options.ranges) {
    node.start += 1;
    node.range[0] += 1;
    node.end -= tailSize;
    node.range[1] -= tailSize;
  }
  if (parser.options.loc) {
    node.loc.start.column += 1;
    node.loc.end.column -= tailSize;
  }
  return node;
}
__name(parseTemplateElement, "parseTemplateElement");
function parseSpreadElement(parser, context, privateScope) {
  const start = parser.tokenStart;
  context = (context | 131072) ^ 131072;
  consume(parser, context | 32, 14);
  const argument = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
  parser.assignable = 1;
  return parser.finishNode({
    type: "SpreadElement",
    argument
  }, start);
}
__name(parseSpreadElement, "parseSpreadElement");
function parseArguments(parser, context, privateScope, inGroup) {
  nextToken(parser, context | 32);
  const args = [];
  if (parser.getToken() === 16) {
    nextToken(parser, context | 64);
    return args;
  }
  while (parser.getToken() !== 16) {
    if (parser.getToken() === 14) {
      args.push(parseSpreadElement(parser, context, privateScope));
    } else {
      args.push(parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart));
    }
    if (parser.getToken() !== 18)
      break;
    nextToken(parser, context | 32);
    if (parser.getToken() === 16)
      break;
  }
  consume(parser, context | 64, 16);
  return args;
}
__name(parseArguments, "parseArguments");
function parseIdentifier(parser, context) {
  const { tokenValue, tokenStart } = parser;
  const allowRegex = tokenValue === "await" && (parser.getToken() & -2147483648) === 0;
  nextToken(parser, context | (allowRegex ? 32 : 0));
  return parser.finishNode({
    type: "Identifier",
    name: tokenValue
  }, tokenStart);
}
__name(parseIdentifier, "parseIdentifier");
function parseLiteral(parser, context) {
  const { tokenValue, tokenRaw, tokenStart } = parser;
  if (parser.getToken() === 134283388) {
    return parseBigIntLiteral(parser, context);
  }
  nextToken(parser, context);
  parser.assignable = 2;
  return parser.finishNode(parser.options.raw ? {
    type: "Literal",
    value: tokenValue,
    raw: tokenRaw
  } : {
    type: "Literal",
    value: tokenValue
  }, tokenStart);
}
__name(parseLiteral, "parseLiteral");
function parseNullOrTrueOrFalseLiteral(parser, context) {
  const start = parser.tokenStart;
  const raw = KeywordDescTable[parser.getToken() & 255];
  const value = parser.getToken() === 86023 ? null : raw === "true";
  nextToken(parser, context);
  parser.assignable = 2;
  return parser.finishNode(parser.options.raw ? {
    type: "Literal",
    value,
    raw
  } : {
    type: "Literal",
    value
  }, start);
}
__name(parseNullOrTrueOrFalseLiteral, "parseNullOrTrueOrFalseLiteral");
function parseThisExpression(parser, context) {
  const { tokenStart } = parser;
  nextToken(parser, context);
  parser.assignable = 2;
  return parser.finishNode({
    type: "ThisExpression"
  }, tokenStart);
}
__name(parseThisExpression, "parseThisExpression");
function parseFunctionDeclaration(parser, context, scope, privateScope, origin, allowGen, flags, isAsync, start) {
  nextToken(parser, context | 32);
  const isGenerator = allowGen ? optionalBit(parser, context, 8391476) : 0;
  let id = null;
  let funcNameToken;
  let functionScope = scope ? parser.createScope() : void 0;
  if (parser.getToken() === 67174411) {
    if ((flags & 1) === 0)
      parser.report(39, "Function");
  } else {
    const kind = origin & 4 && ((context & 8) === 0 || (context & 2) === 0) ? 4 : 64 | (isAsync ? 1024 : 0) | (isGenerator ? 1024 : 0);
    validateFunctionName(parser, context, parser.getToken());
    if (scope) {
      if (kind & 4) {
        scope.addVarName(context, parser.tokenValue, kind);
      } else {
        scope.addBlockName(context, parser.tokenValue, kind, origin);
      }
      functionScope = functionScope == null ? void 0 : functionScope.createChildScope(128);
      if (flags) {
        if (flags & 2) {
          parser.declareUnboundVariable(parser.tokenValue);
        }
      }
    }
    funcNameToken = parser.getToken();
    if (parser.getToken() & 143360) {
      id = parseIdentifier(parser, context);
    } else {
      parser.report(30, KeywordDescTable[parser.getToken() & 255]);
    }
  }
  {
    const modifierFlags2 = 256 | 512 | 1024 | 2048 | 8192 | 16384;
    context = (context | modifierFlags2) ^ modifierFlags2 | 65536 | (isAsync ? 2048 : 0) | (isGenerator ? 1024 : 0) | (isGenerator ? 0 : 262144);
  }
  functionScope = functionScope == null ? void 0 : functionScope.createChildScope(256);
  const params = parseFormalParametersOrFormalList(parser, (context | 8192) & -524289, functionScope, privateScope, 0, 1);
  const modifierFlags = 8 | 4 | 128 | 524288;
  const body = parseFunctionBody(parser, (context | modifierFlags) ^ modifierFlags | 32768 | 4096, functionScope == null ? void 0 : functionScope.createChildScope(64), privateScope, 8, funcNameToken, functionScope);
  return parser.finishNode({
    type: "FunctionDeclaration",
    id,
    params,
    body,
    async: isAsync === 1,
    generator: isGenerator === 1
  }, start);
}
__name(parseFunctionDeclaration, "parseFunctionDeclaration");
function parseFunctionExpression(parser, context, privateScope, isAsync, inGroup, start) {
  nextToken(parser, context | 32);
  const isGenerator = optionalBit(parser, context, 8391476);
  const generatorAndAsyncFlags = (isAsync ? 2048 : 0) | (isGenerator ? 1024 : 0);
  let id = null;
  let funcNameToken;
  let scope = parser.createScopeIfLexical();
  const modifierFlags = 256 | 512 | 1024 | 2048 | 8192 | 16384 | 524288;
  if (parser.getToken() & 143360) {
    validateFunctionName(parser, (context | modifierFlags) ^ modifierFlags | generatorAndAsyncFlags, parser.getToken());
    scope = scope == null ? void 0 : scope.createChildScope(128);
    funcNameToken = parser.getToken();
    id = parseIdentifier(parser, context);
  }
  context = (context | modifierFlags) ^ modifierFlags | 65536 | generatorAndAsyncFlags | (isGenerator ? 0 : 262144);
  scope = scope == null ? void 0 : scope.createChildScope(256);
  const params = parseFormalParametersOrFormalList(parser, (context | 8192) & -524289, scope, privateScope, inGroup, 1);
  const body = parseFunctionBody(parser, context & -131229 | 32768 | 4096, scope == null ? void 0 : scope.createChildScope(64), privateScope, 0, funcNameToken, scope);
  parser.assignable = 2;
  return parser.finishNode({
    type: "FunctionExpression",
    id,
    params,
    body,
    async: isAsync === 1,
    generator: isGenerator === 1
  }, start);
}
__name(parseFunctionExpression, "parseFunctionExpression");
function parseArrayLiteral(parser, context, privateScope, skipInitializer, inGroup) {
  const expr = parseArrayExpressionOrPattern(parser, context, void 0, privateScope, skipInitializer, inGroup, 0, 2, 0);
  if (parser.destructible & 64) {
    parser.report(63);
  }
  if (parser.destructible & 8) {
    parser.report(62);
  }
  return expr;
}
__name(parseArrayLiteral, "parseArrayLiteral");
function parseArrayExpressionOrPattern(parser, context, scope, privateScope, skipInitializer, inGroup, isPattern, kind, origin) {
  const { tokenStart: start } = parser;
  nextToken(parser, context | 32);
  const elements = [];
  let destructible = 0;
  context = (context | 131072) ^ 131072;
  while (parser.getToken() !== 20) {
    if (consumeOpt(parser, context | 32, 18)) {
      elements.push(null);
    } else {
      let left;
      const { tokenStart, tokenValue } = parser;
      const token = parser.getToken();
      if (token & 143360) {
        left = parsePrimaryExpression(parser, context, privateScope, kind, 0, 1, inGroup, 1, tokenStart);
        if (parser.getToken() === 1077936155) {
          if (parser.assignable & 2)
            parser.report(26);
          nextToken(parser, context | 32);
          scope == null ? void 0 : scope.addVarOrBlock(context, tokenValue, kind, origin);
          const right = parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart);
          left = parser.finishNode(isPattern ? {
            type: "AssignmentPattern",
            left,
            right
          } : {
            type: "AssignmentExpression",
            operator: "=",
            left,
            right
          }, tokenStart);
          destructible |= parser.destructible & 256 ? 256 : 0 | parser.destructible & 128 ? 128 : 0;
        } else if (parser.getToken() === 18 || parser.getToken() === 20) {
          if (parser.assignable & 2) {
            destructible |= 16;
          } else {
            scope == null ? void 0 : scope.addVarOrBlock(context, tokenValue, kind, origin);
          }
          destructible |= parser.destructible & 256 ? 256 : 0 | parser.destructible & 128 ? 128 : 0;
        } else {
          destructible |= kind & 1 ? 32 : (kind & 2) === 0 ? 16 : 0;
          left = parseMemberOrUpdateExpression(parser, context, privateScope, left, inGroup, 0, tokenStart);
          if (parser.getToken() !== 18 && parser.getToken() !== 20) {
            if (parser.getToken() !== 1077936155)
              destructible |= 16;
            left = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart, left);
          } else if (parser.getToken() !== 1077936155) {
            destructible |= parser.assignable & 2 ? 16 : 32;
          }
        }
      } else if (token & 2097152) {
        left = parser.getToken() === 2162700 ? parseObjectLiteralOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin) : parseArrayExpressionOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin);
        destructible |= parser.destructible;
        parser.assignable = parser.destructible & 16 ? 2 : 1;
        if (parser.getToken() === 18 || parser.getToken() === 20) {
          if (parser.assignable & 2) {
            destructible |= 16;
          }
        } else if (parser.destructible & 8) {
          parser.report(71);
        } else {
          left = parseMemberOrUpdateExpression(parser, context, privateScope, left, inGroup, 0, tokenStart);
          destructible = parser.assignable & 2 ? 16 : 0;
          if (parser.getToken() !== 18 && parser.getToken() !== 20) {
            left = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart, left);
          } else if (parser.getToken() !== 1077936155) {
            destructible |= parser.assignable & 2 ? 16 : 32;
          }
        }
      } else if (token === 14) {
        left = parseSpreadOrRestElement(parser, context, scope, privateScope, 20, kind, origin, 0, inGroup, isPattern);
        destructible |= parser.destructible;
        if (parser.getToken() !== 18 && parser.getToken() !== 20)
          parser.report(30, KeywordDescTable[parser.getToken() & 255]);
      } else {
        left = parseLeftHandSideExpression(parser, context, privateScope, 1, 0, 1);
        if (parser.getToken() !== 18 && parser.getToken() !== 20) {
          left = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart, left);
          if ((kind & (2 | 1)) === 0 && token === 67174411)
            destructible |= 16;
        } else if (parser.assignable & 2) {
          destructible |= 16;
        } else if (token === 67174411) {
          destructible |= parser.assignable & 1 && kind & (2 | 1) ? 32 : 16;
        }
      }
      elements.push(left);
      if (consumeOpt(parser, context | 32, 18)) {
        if (parser.getToken() === 20)
          break;
      } else
        break;
    }
  }
  consume(parser, context, 20);
  const node = parser.finishNode({
    type: isPattern ? "ArrayPattern" : "ArrayExpression",
    elements
  }, start);
  if (!skipInitializer && parser.getToken() & 4194304) {
    return parseArrayOrObjectAssignmentPattern(parser, context, privateScope, destructible, inGroup, isPattern, start, node);
  }
  parser.destructible = destructible;
  return node;
}
__name(parseArrayExpressionOrPattern, "parseArrayExpressionOrPattern");
function parseArrayOrObjectAssignmentPattern(parser, context, privateScope, destructible, inGroup, isPattern, start, node) {
  if (parser.getToken() !== 1077936155)
    parser.report(26);
  nextToken(parser, context | 32);
  if (destructible & 16)
    parser.report(26);
  if (!isPattern)
    reinterpretToPattern(parser, node);
  const { tokenStart } = parser;
  const right = parseExpression(parser, context, privateScope, 1, inGroup, tokenStart);
  parser.destructible = (destructible | 64 | 8) ^ (8 | 64) | (parser.destructible & 128 ? 128 : 0) | (parser.destructible & 256 ? 256 : 0);
  return parser.finishNode(isPattern ? {
    type: "AssignmentPattern",
    left: node,
    right
  } : {
    type: "AssignmentExpression",
    left: node,
    operator: "=",
    right
  }, start);
}
__name(parseArrayOrObjectAssignmentPattern, "parseArrayOrObjectAssignmentPattern");
function parseSpreadOrRestElement(parser, context, scope, privateScope, closingToken, kind, origin, isAsync, inGroup, isPattern) {
  const { tokenStart: start } = parser;
  nextToken(parser, context | 32);
  let argument = null;
  let destructible = 0;
  const { tokenValue, tokenStart } = parser;
  let token = parser.getToken();
  if (token & 143360) {
    parser.assignable = 1;
    argument = parsePrimaryExpression(parser, context, privateScope, kind, 0, 1, inGroup, 1, tokenStart);
    token = parser.getToken();
    argument = parseMemberOrUpdateExpression(parser, context, privateScope, argument, inGroup, 0, tokenStart);
    if (parser.getToken() !== 18 && parser.getToken() !== closingToken) {
      if (parser.assignable & 2 && parser.getToken() === 1077936155)
        parser.report(71);
      destructible |= 16;
      argument = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart, argument);
    }
    if (parser.assignable & 2) {
      destructible |= 16;
    } else if (token === closingToken || token === 18) {
      scope == null ? void 0 : scope.addVarOrBlock(context, tokenValue, kind, origin);
    } else {
      destructible |= 32;
    }
    destructible |= parser.destructible & 128 ? 128 : 0;
  } else if (token === closingToken) {
    parser.report(41);
  } else if (token & 2097152) {
    argument = parser.getToken() === 2162700 ? parseObjectLiteralOrPattern(parser, context, scope, privateScope, 1, inGroup, isPattern, kind, origin) : parseArrayExpressionOrPattern(parser, context, scope, privateScope, 1, inGroup, isPattern, kind, origin);
    token = parser.getToken();
    if (token !== 1077936155 && token !== closingToken && token !== 18) {
      if (parser.destructible & 8)
        parser.report(71);
      argument = parseMemberOrUpdateExpression(parser, context, privateScope, argument, inGroup, 0, tokenStart);
      destructible |= parser.assignable & 2 ? 16 : 0;
      if ((parser.getToken() & 4194304) === 4194304) {
        if (parser.getToken() !== 1077936155)
          destructible |= 16;
        argument = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart, argument);
      } else {
        if ((parser.getToken() & 8388608) === 8388608) {
          argument = parseBinaryExpression(parser, context, privateScope, 1, tokenStart, 4, token, argument);
        }
        if (consumeOpt(parser, context | 32, 22)) {
          argument = parseConditionalExpression(parser, context, privateScope, argument, tokenStart);
        }
        destructible |= parser.assignable & 2 ? 16 : 32;
      }
    } else {
      destructible |= closingToken === 1074790415 && token !== 1077936155 ? 16 : parser.destructible;
    }
  } else {
    destructible |= 32;
    argument = parseLeftHandSideExpression(parser, context, privateScope, 1, inGroup, 1);
    const { tokenStart: tokenStart2 } = parser;
    const token2 = parser.getToken();
    if (token2 === 1077936155) {
      if (parser.assignable & 2)
        parser.report(26);
      argument = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, argument);
      destructible |= 16;
    } else {
      if (token2 === 18) {
        destructible |= 16;
      } else if (token2 !== closingToken) {
        argument = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, argument);
      }
      destructible |= parser.assignable & 1 ? 32 : 16;
    }
    parser.destructible = destructible;
    if (parser.getToken() !== closingToken && parser.getToken() !== 18)
      parser.report(161);
    return parser.finishNode({
      type: isPattern ? "RestElement" : "SpreadElement",
      argument
    }, start);
  }
  if (parser.getToken() !== closingToken) {
    if (kind & 1)
      destructible |= isAsync ? 16 : 32;
    if (consumeOpt(parser, context | 32, 1077936155)) {
      if (destructible & 16)
        parser.report(26);
      reinterpretToPattern(parser, argument);
      const right = parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart);
      argument = parser.finishNode(isPattern ? {
        type: "AssignmentPattern",
        left: argument,
        right
      } : {
        type: "AssignmentExpression",
        left: argument,
        operator: "=",
        right
      }, tokenStart);
      destructible = 16;
    } else {
      destructible |= 16;
    }
  }
  parser.destructible = destructible;
  return parser.finishNode({
    type: isPattern ? "RestElement" : "SpreadElement",
    argument
  }, start);
}
__name(parseSpreadOrRestElement, "parseSpreadOrRestElement");
function parseMethodDefinition(parser, context, privateScope, kind, inGroup, start) {
  const modifierFlags = 1024 | 2048 | 8192 | ((kind & 64) === 0 ? 512 | 16384 : 0);
  context = (context | modifierFlags) ^ modifierFlags | (kind & 8 ? 1024 : 0) | (kind & 16 ? 2048 : 0) | (kind & 64 ? 16384 : 0) | 256 | 32768 | 65536;
  let scope = parser.createScopeIfLexical(256);
  const params = parseMethodFormals(parser, (context | 8192) & -524289, scope, privateScope, kind, 1, inGroup);
  scope = scope == null ? void 0 : scope.createChildScope(64);
  const body = parseFunctionBody(parser, context & -655373 | 32768 | 4096, scope, privateScope, 0, void 0, scope == null ? void 0 : scope.parent);
  return parser.finishNode({
    type: "FunctionExpression",
    params,
    body,
    async: (kind & 16) > 0,
    generator: (kind & 8) > 0,
    id: null
  }, start);
}
__name(parseMethodDefinition, "parseMethodDefinition");
function parseObjectLiteral(parser, context, privateScope, skipInitializer, inGroup) {
  const expr = parseObjectLiteralOrPattern(parser, context, void 0, privateScope, skipInitializer, inGroup, 0, 2, 0);
  if (parser.destructible & 64) {
    parser.report(63);
  }
  if (parser.destructible & 8) {
    parser.report(62);
  }
  return expr;
}
__name(parseObjectLiteral, "parseObjectLiteral");
function parseObjectLiteralOrPattern(parser, context, scope, privateScope, skipInitializer, inGroup, isPattern, kind, origin) {
  const { tokenStart: start } = parser;
  nextToken(parser, context);
  const properties = [];
  let destructible = 0;
  let prototypeCount = 0;
  context = (context | 131072) ^ 131072;
  while (parser.getToken() !== 1074790415) {
    const { tokenValue, tokenStart } = parser;
    const token = parser.getToken();
    if (token === 14) {
      properties.push(parseSpreadOrRestElement(parser, context, scope, privateScope, 1074790415, kind, origin, 0, inGroup, isPattern));
    } else {
      let state = 0;
      let key = null;
      let value;
      if (parser.getToken() & 143360 || parser.getToken() === -2147483528 || parser.getToken() === -2147483527) {
        if (parser.getToken() === -2147483527)
          destructible |= 16;
        key = parseIdentifier(parser, context);
        if (parser.getToken() === 18 || parser.getToken() === 1074790415 || parser.getToken() === 1077936155) {
          state |= 4;
          if (context & 1 && (token & 537079808) === 537079808) {
            destructible |= 16;
          } else {
            validateBindingIdentifier(parser, context, kind, token, 0);
          }
          scope == null ? void 0 : scope.addVarOrBlock(context, tokenValue, kind, origin);
          if (consumeOpt(parser, context | 32, 1077936155)) {
            destructible |= 8;
            const right = parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart);
            destructible |= parser.destructible & 256 ? 256 : 0 | parser.destructible & 128 ? 128 : 0;
            value = parser.finishNode({
              type: "AssignmentPattern",
              left: parser.options.uniqueKeyInPattern ? Object.assign({}, key) : key,
              right
            }, tokenStart);
          } else {
            destructible |= (token === 209006 ? 128 : 0) | (token === -2147483528 ? 16 : 0);
            value = parser.options.uniqueKeyInPattern ? Object.assign({}, key) : key;
          }
        } else if (consumeOpt(parser, context | 32, 21)) {
          const { tokenStart: tokenStart2 } = parser;
          if (tokenValue === "__proto__")
            prototypeCount++;
          if (parser.getToken() & 143360) {
            const tokenAfterColon = parser.getToken();
            const valueAfterColon = parser.tokenValue;
            value = parsePrimaryExpression(parser, context, privateScope, kind, 0, 1, inGroup, 1, tokenStart2);
            const token2 = parser.getToken();
            value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (token2 === 1077936155 || token2 === 1074790415 || token2 === 18) {
                destructible |= parser.destructible & 128 ? 128 : 0;
                if (parser.assignable & 2) {
                  destructible |= 16;
                } else if ((tokenAfterColon & 143360) === 143360) {
                  scope == null ? void 0 : scope.addVarOrBlock(context, valueAfterColon, kind, origin);
                }
              } else {
                destructible |= parser.assignable & 1 ? 32 : 16;
              }
            } else if ((parser.getToken() & 4194304) === 4194304) {
              if (parser.assignable & 2) {
                destructible |= 16;
              } else if (token2 !== 1077936155) {
                destructible |= 32;
              } else {
                scope == null ? void 0 : scope.addVarOrBlock(context, valueAfterColon, kind, origin);
              }
              value = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
            } else {
              destructible |= 16;
              if ((parser.getToken() & 8388608) === 8388608) {
                value = parseBinaryExpression(parser, context, privateScope, 1, tokenStart2, 4, token2, value);
              }
              if (consumeOpt(parser, context | 32, 22)) {
                value = parseConditionalExpression(parser, context, privateScope, value, tokenStart2);
              }
            }
          } else if ((parser.getToken() & 2097152) === 2097152) {
            value = parser.getToken() === 69271571 ? parseArrayExpressionOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin) : parseObjectLiteralOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin);
            destructible = parser.destructible;
            parser.assignable = destructible & 16 ? 2 : 1;
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (parser.assignable & 2)
                destructible |= 16;
            } else if (parser.destructible & 8) {
              parser.report(71);
            } else {
              value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
              destructible = parser.assignable & 2 ? 16 : 0;
              if ((parser.getToken() & 4194304) === 4194304) {
                value = parseAssignmentExpressionOrPattern(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
              } else {
                if ((parser.getToken() & 8388608) === 8388608) {
                  value = parseBinaryExpression(parser, context, privateScope, 1, tokenStart2, 4, token, value);
                }
                if (consumeOpt(parser, context | 32, 22)) {
                  value = parseConditionalExpression(parser, context, privateScope, value, tokenStart2);
                }
                destructible |= parser.assignable & 2 ? 16 : 32;
              }
            }
          } else {
            value = parseLeftHandSideExpression(parser, context, privateScope, 1, inGroup, 1);
            destructible |= parser.assignable & 1 ? 32 : 16;
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (parser.assignable & 2)
                destructible |= 16;
            } else {
              value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
              destructible = parser.assignable & 2 ? 16 : 0;
              if (parser.getToken() !== 18 && token !== 1074790415) {
                if (parser.getToken() !== 1077936155)
                  destructible |= 16;
                value = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
              }
            }
          }
        } else if (parser.getToken() === 69271571) {
          destructible |= 16;
          if (token === 209005)
            state |= 16;
          state |= (token === 209008 ? 256 : token === 209009 ? 512 : 1) | 2;
          key = parseComputedPropertyName(parser, context, privateScope, inGroup);
          destructible |= parser.assignable;
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
        } else if (parser.getToken() & 143360) {
          destructible |= 16;
          if (token === -2147483528)
            parser.report(95);
          if (token === 209005) {
            if (parser.flags & 1)
              parser.report(132);
            state |= 16 | 1;
          } else if (token === 209008) {
            state |= 256;
          } else if (token === 209009) {
            state |= 512;
          } else {
            parser.report(0);
          }
          key = parseIdentifier(parser, context);
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
        } else if (parser.getToken() === 67174411) {
          destructible |= 16;
          state |= 1;
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
        } else if (parser.getToken() === 8391476) {
          destructible |= 16;
          if (token === 209008) {
            parser.report(42);
          } else if (token === 209009) {
            parser.report(43);
          } else if (token !== 209005) {
            parser.report(30, KeywordDescTable[8391476 & 255]);
          }
          nextToken(parser, context);
          state |= 8 | 1 | (token === 209005 ? 16 : 0);
          if (parser.getToken() & 143360) {
            key = parseIdentifier(parser, context);
          } else if ((parser.getToken() & 134217728) === 134217728) {
            key = parseLiteral(parser, context);
          } else if (parser.getToken() === 69271571) {
            state |= 2;
            key = parseComputedPropertyName(parser, context, privateScope, inGroup);
            destructible |= parser.assignable;
          } else {
            parser.report(30, KeywordDescTable[parser.getToken() & 255]);
          }
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
        } else if ((parser.getToken() & 134217728) === 134217728) {
          if (token === 209005)
            state |= 16;
          state |= token === 209008 ? 256 : token === 209009 ? 512 : 1;
          destructible |= 16;
          key = parseLiteral(parser, context);
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
        } else {
          parser.report(133);
        }
      } else if ((parser.getToken() & 134217728) === 134217728) {
        key = parseLiteral(parser, context);
        if (parser.getToken() === 21) {
          consume(parser, context | 32, 21);
          const { tokenStart: tokenStart2 } = parser;
          if (tokenValue === "__proto__")
            prototypeCount++;
          if (parser.getToken() & 143360) {
            value = parsePrimaryExpression(parser, context, privateScope, kind, 0, 1, inGroup, 1, tokenStart2);
            const { tokenValue: valueAfterColon } = parser;
            const token2 = parser.getToken();
            value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (token2 === 1077936155 || token2 === 1074790415 || token2 === 18) {
                if (parser.assignable & 2) {
                  destructible |= 16;
                } else {
                  scope == null ? void 0 : scope.addVarOrBlock(context, valueAfterColon, kind, origin);
                }
              } else {
                destructible |= parser.assignable & 1 ? 32 : 16;
              }
            } else if (parser.getToken() === 1077936155) {
              if (parser.assignable & 2)
                destructible |= 16;
              value = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
            } else {
              destructible |= 16;
              value = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
            }
          } else if ((parser.getToken() & 2097152) === 2097152) {
            value = parser.getToken() === 69271571 ? parseArrayExpressionOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin) : parseObjectLiteralOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin);
            destructible = parser.destructible;
            parser.assignable = destructible & 16 ? 2 : 1;
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (parser.assignable & 2) {
                destructible |= 16;
              }
            } else if ((parser.destructible & 8) !== 8) {
              value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
              destructible = parser.assignable & 2 ? 16 : 0;
              if ((parser.getToken() & 4194304) === 4194304) {
                value = parseAssignmentExpressionOrPattern(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
              } else {
                if ((parser.getToken() & 8388608) === 8388608) {
                  value = parseBinaryExpression(parser, context, privateScope, 1, tokenStart2, 4, token, value);
                }
                if (consumeOpt(parser, context | 32, 22)) {
                  value = parseConditionalExpression(parser, context, privateScope, value, tokenStart2);
                }
                destructible |= parser.assignable & 2 ? 16 : 32;
              }
            }
          } else {
            value = parseLeftHandSideExpression(parser, context, privateScope, 1, 0, 1);
            destructible |= parser.assignable & 1 ? 32 : 16;
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (parser.assignable & 2) {
                destructible |= 16;
              }
            } else {
              value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
              destructible = parser.assignable & 1 ? 0 : 16;
              if (parser.getToken() !== 18 && parser.getToken() !== 1074790415) {
                if (parser.getToken() !== 1077936155)
                  destructible |= 16;
                value = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
              }
            }
          }
        } else if (parser.getToken() === 67174411) {
          state |= 1;
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
          destructible = parser.assignable | 16;
        } else {
          parser.report(134);
        }
      } else if (parser.getToken() === 69271571) {
        key = parseComputedPropertyName(parser, context, privateScope, inGroup);
        destructible |= parser.destructible & 256 ? 256 : 0;
        state |= 2;
        if (parser.getToken() === 21) {
          nextToken(parser, context | 32);
          const { tokenStart: tokenStart2, tokenValue: tokenValue2 } = parser;
          const tokenAfterColon = parser.getToken();
          if (parser.getToken() & 143360) {
            value = parsePrimaryExpression(parser, context, privateScope, kind, 0, 1, inGroup, 1, tokenStart2);
            const token2 = parser.getToken();
            value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
            if ((parser.getToken() & 4194304) === 4194304) {
              destructible |= parser.assignable & 2 ? 16 : token2 === 1077936155 ? 0 : 32;
              value = parseAssignmentExpressionOrPattern(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
            } else if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (token2 === 1077936155 || token2 === 1074790415 || token2 === 18) {
                if (parser.assignable & 2) {
                  destructible |= 16;
                } else if ((tokenAfterColon & 143360) === 143360) {
                  scope == null ? void 0 : scope.addVarOrBlock(context, tokenValue2, kind, origin);
                }
              } else {
                destructible |= parser.assignable & 1 ? 32 : 16;
              }
            } else {
              destructible |= 16;
              value = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
            }
          } else if ((parser.getToken() & 2097152) === 2097152) {
            value = parser.getToken() === 69271571 ? parseArrayExpressionOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin) : parseObjectLiteralOrPattern(parser, context, scope, privateScope, 0, inGroup, isPattern, kind, origin);
            destructible = parser.destructible;
            parser.assignable = destructible & 16 ? 2 : 1;
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (parser.assignable & 2)
                destructible |= 16;
            } else if (destructible & 8) {
              parser.report(62);
            } else {
              value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
              destructible = parser.assignable & 2 ? destructible | 16 : 0;
              if ((parser.getToken() & 4194304) === 4194304) {
                if (parser.getToken() !== 1077936155)
                  destructible |= 16;
                value = parseAssignmentExpressionOrPattern(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
              } else {
                if ((parser.getToken() & 8388608) === 8388608) {
                  value = parseBinaryExpression(parser, context, privateScope, 1, tokenStart2, 4, token, value);
                }
                if (consumeOpt(parser, context | 32, 22)) {
                  value = parseConditionalExpression(parser, context, privateScope, value, tokenStart2);
                }
                destructible |= parser.assignable & 2 ? 16 : 32;
              }
            }
          } else {
            value = parseLeftHandSideExpression(parser, context, privateScope, 1, 0, 1);
            destructible |= parser.assignable & 1 ? 32 : 16;
            if (parser.getToken() === 18 || parser.getToken() === 1074790415) {
              if (parser.assignable & 2)
                destructible |= 16;
            } else {
              value = parseMemberOrUpdateExpression(parser, context, privateScope, value, inGroup, 0, tokenStart2);
              destructible = parser.assignable & 1 ? 0 : 16;
              if (parser.getToken() !== 18 && parser.getToken() !== 1074790415) {
                if (parser.getToken() !== 1077936155)
                  destructible |= 16;
                value = parseAssignmentExpression(parser, context, privateScope, inGroup, isPattern, tokenStart2, value);
              }
            }
          }
        } else if (parser.getToken() === 67174411) {
          state |= 1;
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
          destructible = 16;
        } else {
          parser.report(44);
        }
      } else if (token === 8391476) {
        consume(parser, context | 32, 8391476);
        state |= 8;
        if (parser.getToken() & 143360) {
          const token2 = parser.getToken();
          key = parseIdentifier(parser, context);
          state |= 1;
          if (parser.getToken() === 67174411) {
            destructible |= 16;
            value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
          } else {
            throw new ParseError(parser.tokenStart, parser.currentLocation, token2 === 209005 ? 46 : token2 === 209008 || parser.getToken() === 209009 ? 45 : 47, KeywordDescTable[token2 & 255]);
          }
        } else if ((parser.getToken() & 134217728) === 134217728) {
          destructible |= 16;
          key = parseLiteral(parser, context);
          state |= 1;
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
        } else if (parser.getToken() === 69271571) {
          destructible |= 16;
          state |= 2 | 1;
          key = parseComputedPropertyName(parser, context, privateScope, inGroup);
          value = parseMethodDefinition(parser, context, privateScope, state, inGroup, parser.tokenStart);
        } else {
          parser.report(126);
        }
      } else {
        parser.report(30, KeywordDescTable[token & 255]);
      }
      destructible |= parser.destructible & 128 ? 128 : 0;
      parser.destructible = destructible;
      properties.push(parser.finishNode({
        type: "Property",
        key,
        value,
        kind: !(state & 768) ? "init" : state & 512 ? "set" : "get",
        computed: (state & 2) > 0,
        method: (state & 1) > 0,
        shorthand: (state & 4) > 0
      }, tokenStart));
    }
    destructible |= parser.destructible;
    if (parser.getToken() !== 18)
      break;
    nextToken(parser, context);
  }
  consume(parser, context, 1074790415);
  if (prototypeCount > 1)
    destructible |= 64;
  const node = parser.finishNode({
    type: isPattern ? "ObjectPattern" : "ObjectExpression",
    properties
  }, start);
  if (!skipInitializer && parser.getToken() & 4194304) {
    return parseArrayOrObjectAssignmentPattern(parser, context, privateScope, destructible, inGroup, isPattern, start, node);
  }
  parser.destructible = destructible;
  return node;
}
__name(parseObjectLiteralOrPattern, "parseObjectLiteralOrPattern");
function parseMethodFormals(parser, context, scope, privateScope, kind, type, inGroup) {
  consume(parser, context, 67174411);
  const params = [];
  parser.flags = (parser.flags | 128) ^ 128;
  if (parser.getToken() === 16) {
    if (kind & 512) {
      parser.report(37, "Setter", "one", "");
    }
    nextToken(parser, context);
    return params;
  }
  if (kind & 256) {
    parser.report(37, "Getter", "no", "s");
  }
  if (kind & 512 && parser.getToken() === 14) {
    parser.report(38);
  }
  context = (context | 131072) ^ 131072;
  let setterArgs = 0;
  let isNonSimpleParameterList = 0;
  while (parser.getToken() !== 18) {
    let left = null;
    const { tokenStart } = parser;
    if (parser.getToken() & 143360) {
      if ((context & 1) === 0) {
        if ((parser.getToken() & 36864) === 36864) {
          parser.flags |= 256;
        }
        if ((parser.getToken() & 537079808) === 537079808) {
          parser.flags |= 512;
        }
      }
      left = parseAndClassifyIdentifier(parser, context, scope, kind | 1, 0);
    } else {
      if (parser.getToken() === 2162700) {
        left = parseObjectLiteralOrPattern(parser, context, scope, privateScope, 1, inGroup, 1, type, 0);
      } else if (parser.getToken() === 69271571) {
        left = parseArrayExpressionOrPattern(parser, context, scope, privateScope, 1, inGroup, 1, type, 0);
      } else if (parser.getToken() === 14) {
        left = parseSpreadOrRestElement(parser, context, scope, privateScope, 16, type, 0, 0, inGroup, 1);
      }
      isNonSimpleParameterList = 1;
      if (parser.destructible & (32 | 16))
        parser.report(50);
    }
    if (parser.getToken() === 1077936155) {
      nextToken(parser, context | 32);
      isNonSimpleParameterList = 1;
      const right = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
      left = parser.finishNode({
        type: "AssignmentPattern",
        left,
        right
      }, tokenStart);
    }
    setterArgs++;
    params.push(left);
    if (!consumeOpt(parser, context, 18))
      break;
    if (parser.getToken() === 16) {
      break;
    }
  }
  if (kind & 512 && setterArgs !== 1) {
    parser.report(37, "Setter", "one", "");
  }
  scope == null ? void 0 : scope.reportScopeError();
  if (isNonSimpleParameterList)
    parser.flags |= 128;
  consume(parser, context, 16);
  return params;
}
__name(parseMethodFormals, "parseMethodFormals");
function parseComputedPropertyName(parser, context, privateScope, inGroup) {
  nextToken(parser, context | 32);
  const key = parseExpression(parser, (context | 131072) ^ 131072, privateScope, 1, inGroup, parser.tokenStart);
  consume(parser, context, 20);
  return key;
}
__name(parseComputedPropertyName, "parseComputedPropertyName");
function parseParenthesizedExpression(parser, context, privateScope, canAssign, kind, origin, start) {
  var _a;
  parser.flags = (parser.flags | 128) ^ 128;
  const parenthesesStart = parser.tokenStart;
  nextToken(parser, context | 32 | 262144);
  const scope = (_a = parser.createScopeIfLexical()) == null ? void 0 : _a.createChildScope(512);
  context = (context | 131072) ^ 131072;
  if (consumeOpt(parser, context, 16)) {
    return parseParenthesizedArrow(parser, context, scope, privateScope, [], canAssign, 0, start);
  }
  let destructible = 0;
  parser.destructible &= -385;
  let expr;
  let expressions = [];
  let isSequence = 0;
  let isNonSimpleParameterList = 0;
  let hasStrictReserved = 0;
  const tokenAfterParenthesesStart = parser.tokenStart;
  parser.assignable = 1;
  while (parser.getToken() !== 16) {
    const { tokenStart } = parser;
    const token = parser.getToken();
    if (token & 143360) {
      scope == null ? void 0 : scope.addBlockName(context, parser.tokenValue, 1, 0);
      if ((token & 537079808) === 537079808) {
        isNonSimpleParameterList = 1;
      } else if ((token & 36864) === 36864) {
        hasStrictReserved = 1;
      }
      expr = parsePrimaryExpression(parser, context, privateScope, kind, 0, 1, 1, 1, tokenStart);
      if (parser.getToken() === 16 || parser.getToken() === 18) {
        if (parser.assignable & 2) {
          destructible |= 16;
          isNonSimpleParameterList = 1;
        }
      } else {
        if (parser.getToken() === 1077936155) {
          isNonSimpleParameterList = 1;
        } else {
          destructible |= 16;
        }
        expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 1, 0, tokenStart);
        if (parser.getToken() !== 16 && parser.getToken() !== 18) {
          expr = parseAssignmentExpression(parser, context, privateScope, 1, 0, tokenStart, expr);
        }
      }
    } else if ((token & 2097152) === 2097152) {
      expr = token === 2162700 ? parseObjectLiteralOrPattern(parser, context | 262144, scope, privateScope, 0, 1, 0, kind, origin) : parseArrayExpressionOrPattern(parser, context | 262144, scope, privateScope, 0, 1, 0, kind, origin);
      destructible |= parser.destructible;
      isNonSimpleParameterList = 1;
      parser.assignable = 2;
      if (parser.getToken() !== 16 && parser.getToken() !== 18) {
        if (destructible & 8)
          parser.report(122);
        expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 0, 0, tokenStart);
        destructible |= 16;
        if (parser.getToken() !== 16 && parser.getToken() !== 18) {
          expr = parseAssignmentExpression(parser, context, privateScope, 0, 0, tokenStart, expr);
        }
      }
    } else if (token === 14) {
      expr = parseSpreadOrRestElement(parser, context, scope, privateScope, 16, kind, origin, 0, 1, 0);
      if (parser.destructible & 16)
        parser.report(74);
      isNonSimpleParameterList = 1;
      if (isSequence && (parser.getToken() === 16 || parser.getToken() === 18)) {
        expressions.push(expr);
      }
      destructible |= 8;
      break;
    } else {
      destructible |= 16;
      expr = parseExpression(parser, context, privateScope, 1, 1, tokenStart);
      if (isSequence && (parser.getToken() === 16 || parser.getToken() === 18)) {
        expressions.push(expr);
      }
      if (parser.getToken() === 18) {
        if (!isSequence) {
          isSequence = 1;
          expressions = [expr];
        }
      }
      if (isSequence) {
        while (consumeOpt(parser, context | 32, 18)) {
          expressions.push(parseExpression(parser, context, privateScope, 1, 1, parser.tokenStart));
        }
        parser.assignable = 2;
        expr = parser.finishNode({
          type: "SequenceExpression",
          expressions
        }, tokenAfterParenthesesStart);
      }
      consume(parser, context, 16);
      parser.destructible = destructible;
      return parser.options.preserveParens ? parser.finishNode({
        type: "ParenthesizedExpression",
        expression: expr
      }, parenthesesStart) : expr;
    }
    if (isSequence && (parser.getToken() === 16 || parser.getToken() === 18)) {
      expressions.push(expr);
    }
    if (!consumeOpt(parser, context | 32, 18))
      break;
    if (!isSequence) {
      isSequence = 1;
      expressions = [expr];
    }
    if (parser.getToken() === 16) {
      destructible |= 8;
      break;
    }
  }
  if (isSequence) {
    parser.assignable = 2;
    expr = parser.finishNode({
      type: "SequenceExpression",
      expressions
    }, tokenAfterParenthesesStart);
  }
  consume(parser, context, 16);
  if (destructible & 16 && destructible & 8)
    parser.report(151);
  destructible |= parser.destructible & 256 ? 256 : 0 | parser.destructible & 128 ? 128 : 0;
  if (parser.getToken() === 10) {
    if (destructible & (32 | 16))
      parser.report(49);
    if (context & (2048 | 2) && destructible & 128)
      parser.report(31);
    if (context & (1 | 1024) && destructible & 256) {
      parser.report(32);
    }
    if (isNonSimpleParameterList)
      parser.flags |= 128;
    if (hasStrictReserved)
      parser.flags |= 256;
    return parseParenthesizedArrow(parser, context, scope, privateScope, isSequence ? expressions : [expr], canAssign, 0, start);
  }
  if (destructible & 64) {
    parser.report(63);
  }
  if (destructible & 8) {
    parser.report(144);
  }
  parser.destructible = (parser.destructible | 256) ^ 256 | destructible;
  return parser.options.preserveParens ? parser.finishNode({
    type: "ParenthesizedExpression",
    expression: expr
  }, parenthesesStart) : expr;
}
__name(parseParenthesizedExpression, "parseParenthesizedExpression");
function parseIdentifierOrArrow(parser, context, privateScope) {
  const { tokenStart: start } = parser;
  const { tokenValue } = parser;
  let isNonSimpleParameterList = 0;
  let hasStrictReserved = 0;
  if ((parser.getToken() & 537079808) === 537079808) {
    isNonSimpleParameterList = 1;
  } else if ((parser.getToken() & 36864) === 36864) {
    hasStrictReserved = 1;
  }
  const expr = parseIdentifier(parser, context);
  parser.assignable = 1;
  if (parser.getToken() === 10) {
    const scope = parser.options.lexical ? createArrowHeadParsingScope(parser, context, tokenValue) : void 0;
    if (isNonSimpleParameterList)
      parser.flags |= 128;
    if (hasStrictReserved)
      parser.flags |= 256;
    return parseArrowFunctionExpression(parser, context, scope, privateScope, [expr], 0, start);
  }
  return expr;
}
__name(parseIdentifierOrArrow, "parseIdentifierOrArrow");
function parseArrowFromIdentifier(parser, context, privateScope, value, expr, inNew, canAssign, isAsync, start) {
  if (!canAssign)
    parser.report(57);
  if (inNew)
    parser.report(51);
  parser.flags &= -129;
  const scope = parser.options.lexical ? createArrowHeadParsingScope(parser, context, value) : void 0;
  return parseArrowFunctionExpression(parser, context, scope, privateScope, [expr], isAsync, start);
}
__name(parseArrowFromIdentifier, "parseArrowFromIdentifier");
function parseParenthesizedArrow(parser, context, scope, privateScope, params, canAssign, isAsync, start) {
  if (!canAssign)
    parser.report(57);
  for (let i = 0; i < params.length; ++i)
    reinterpretToPattern(parser, params[i]);
  return parseArrowFunctionExpression(parser, context, scope, privateScope, params, isAsync, start);
}
__name(parseParenthesizedArrow, "parseParenthesizedArrow");
function parseArrowFunctionExpression(parser, context, scope, privateScope, params, isAsync, start) {
  if (parser.flags & 1)
    parser.report(48);
  consume(parser, context | 32, 10);
  const modifierFlags = 1024 | 2048 | 8192 | 524288;
  context = (context | modifierFlags) ^ modifierFlags | (isAsync ? 2048 : 0);
  const expression = parser.getToken() !== 2162700;
  let body;
  scope == null ? void 0 : scope.reportScopeError();
  if (expression) {
    parser.flags = (parser.flags | 512 | 256 | 64 | 4096) ^ (512 | 256 | 64 | 4096);
    body = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
  } else {
    scope = scope == null ? void 0 : scope.createChildScope(64);
    const modifierFlags2 = 4 | 131072 | 8;
    body = parseFunctionBody(parser, (context | modifierFlags2) ^ modifierFlags2 | 4096, scope, privateScope, 16, void 0, void 0);
    switch (parser.getToken()) {
      case 69271571:
        if ((parser.flags & 1) === 0) {
          parser.report(116);
        }
        break;
      case 67108877:
      case 67174409:
      case 22:
        parser.report(117);
      case 67174411:
        if ((parser.flags & 1) === 0) {
          parser.report(116);
        }
        parser.flags |= 1024;
        break;
    }
    if ((parser.getToken() & 8388608) === 8388608 && (parser.flags & 1) === 0)
      parser.report(30, KeywordDescTable[parser.getToken() & 255]);
    if ((parser.getToken() & 33619968) === 33619968)
      parser.report(125);
  }
  parser.assignable = 2;
  return parser.finishNode({
    type: "ArrowFunctionExpression",
    params,
    body,
    async: isAsync === 1,
    expression,
    generator: false
  }, start);
}
__name(parseArrowFunctionExpression, "parseArrowFunctionExpression");
function parseFormalParametersOrFormalList(parser, context, scope, privateScope, inGroup, kind) {
  consume(parser, context, 67174411);
  parser.flags = (parser.flags | 128) ^ 128;
  const params = [];
  if (consumeOpt(parser, context, 16))
    return params;
  context = (context | 131072) ^ 131072;
  let isNonSimpleParameterList = 0;
  while (parser.getToken() !== 18) {
    let left;
    const { tokenStart } = parser;
    const token = parser.getToken();
    if (token & 143360) {
      if ((context & 1) === 0) {
        if ((token & 36864) === 36864) {
          parser.flags |= 256;
        }
        if ((token & 537079808) === 537079808) {
          parser.flags |= 512;
        }
      }
      left = parseAndClassifyIdentifier(parser, context, scope, kind | 1, 0);
    } else {
      if (token === 2162700) {
        left = parseObjectLiteralOrPattern(parser, context, scope, privateScope, 1, inGroup, 1, kind, 0);
      } else if (token === 69271571) {
        left = parseArrayExpressionOrPattern(parser, context, scope, privateScope, 1, inGroup, 1, kind, 0);
      } else if (token === 14) {
        left = parseSpreadOrRestElement(parser, context, scope, privateScope, 16, kind, 0, 0, inGroup, 1);
      } else {
        parser.report(30, KeywordDescTable[token & 255]);
      }
      isNonSimpleParameterList = 1;
      if (parser.destructible & (32 | 16)) {
        parser.report(50);
      }
    }
    if (parser.getToken() === 1077936155) {
      nextToken(parser, context | 32);
      isNonSimpleParameterList = 1;
      const right = parseExpression(parser, context, privateScope, 1, inGroup, parser.tokenStart);
      left = parser.finishNode({
        type: "AssignmentPattern",
        left,
        right
      }, tokenStart);
    }
    params.push(left);
    if (!consumeOpt(parser, context, 18))
      break;
    if (parser.getToken() === 16) {
      break;
    }
  }
  if (isNonSimpleParameterList)
    parser.flags |= 128;
  if (isNonSimpleParameterList || context & 1) {
    scope == null ? void 0 : scope.reportScopeError();
  }
  consume(parser, context, 16);
  return params;
}
__name(parseFormalParametersOrFormalList, "parseFormalParametersOrFormalList");
function parseMemberExpressionNoCall(parser, context, privateScope, expr, inGroup, start) {
  const token = parser.getToken();
  if (token & 67108864) {
    if (token === 67108877) {
      nextToken(parser, context | 262144);
      parser.assignable = 1;
      const property = parsePropertyOrPrivatePropertyName(parser, context, privateScope);
      return parseMemberExpressionNoCall(parser, context, privateScope, parser.finishNode({
        type: "MemberExpression",
        object: expr,
        computed: false,
        property,
        optional: false
      }, start), 0, start);
    } else if (token === 69271571) {
      nextToken(parser, context | 32);
      const { tokenStart } = parser;
      const property = parseExpressions(parser, context, privateScope, inGroup, 1, tokenStart);
      consume(parser, context, 20);
      parser.assignable = 1;
      return parseMemberExpressionNoCall(parser, context, privateScope, parser.finishNode({
        type: "MemberExpression",
        object: expr,
        computed: true,
        property,
        optional: false
      }, start), 0, start);
    } else if (token === 67174408 || token === 67174409) {
      parser.assignable = 2;
      return parseMemberExpressionNoCall(parser, context, privateScope, parser.finishNode({
        type: "TaggedTemplateExpression",
        tag: expr,
        quasi: parser.getToken() === 67174408 ? parseTemplate(parser, context | 64, privateScope) : parseTemplateLiteral(parser, context | 64)
      }, start), 0, start);
    }
  }
  return expr;
}
__name(parseMemberExpressionNoCall, "parseMemberExpressionNoCall");
function parseNewExpression(parser, context, privateScope, inGroup) {
  const { tokenStart: start } = parser;
  const id = parseIdentifier(parser, context | 32);
  const { tokenStart } = parser;
  if (consumeOpt(parser, context, 67108877)) {
    if (context & 65536 && parser.getToken() === 209029) {
      parser.assignable = 2;
      return parseMetaProperty(parser, context, id, start);
    }
    parser.report(94);
  }
  parser.assignable = 2;
  if ((parser.getToken() & 16842752) === 16842752) {
    parser.report(65, KeywordDescTable[parser.getToken() & 255]);
  }
  const expr = parsePrimaryExpression(parser, context, privateScope, 2, 1, 0, inGroup, 1, tokenStart);
  context = (context | 131072) ^ 131072;
  if (parser.getToken() === 67108990)
    parser.report(168);
  const callee = parseMemberExpressionNoCall(parser, context, privateScope, expr, inGroup, tokenStart);
  parser.assignable = 2;
  return parser.finishNode({
    type: "NewExpression",
    callee,
    arguments: parser.getToken() === 67174411 ? parseArguments(parser, context, privateScope, inGroup) : []
  }, start);
}
__name(parseNewExpression, "parseNewExpression");
function parseMetaProperty(parser, context, meta, start) {
  const property = parseIdentifier(parser, context);
  return parser.finishNode({
    type: "MetaProperty",
    meta,
    property
  }, start);
}
__name(parseMetaProperty, "parseMetaProperty");
function parseAsyncArrowAfterIdent(parser, context, privateScope, canAssign, start) {
  if (parser.getToken() === 209006)
    parser.report(31);
  if (context & (1 | 1024) && parser.getToken() === 241771) {
    parser.report(32);
  }
  classifyIdentifier(parser, context, parser.getToken());
  if ((parser.getToken() & 36864) === 36864) {
    parser.flags |= 256;
  }
  return parseArrowFromIdentifier(parser, context & -524289 | 2048, privateScope, parser.tokenValue, parseIdentifier(parser, context), 0, canAssign, 1, start);
}
__name(parseAsyncArrowAfterIdent, "parseAsyncArrowAfterIdent");
function parseAsyncArrowOrCallExpression(parser, context, privateScope, callee, canAssign, kind, origin, flags, start) {
  var _a;
  nextToken(parser, context | 32);
  const scope = (_a = parser.createScopeIfLexical()) == null ? void 0 : _a.createChildScope(512);
  context = (context | 131072) ^ 131072;
  if (consumeOpt(parser, context, 16)) {
    if (parser.getToken() === 10) {
      if (flags & 1)
        parser.report(48);
      return parseParenthesizedArrow(parser, context, scope, privateScope, [], canAssign, 1, start);
    }
    return parser.finishNode({
      type: "CallExpression",
      callee,
      arguments: [],
      optional: false
    }, start);
  }
  let destructible = 0;
  let expr = null;
  let isNonSimpleParameterList = 0;
  parser.destructible = (parser.destructible | 256 | 128) ^ (256 | 128);
  const params = [];
  while (parser.getToken() !== 16) {
    const { tokenStart } = parser;
    const token = parser.getToken();
    if (token & 143360) {
      scope == null ? void 0 : scope.addBlockName(context, parser.tokenValue, kind, 0);
      if ((token & 537079808) === 537079808) {
        parser.flags |= 512;
      } else if ((token & 36864) === 36864) {
        parser.flags |= 256;
      }
      expr = parsePrimaryExpression(parser, context, privateScope, kind, 0, 1, 1, 1, tokenStart);
      if (parser.getToken() === 16 || parser.getToken() === 18) {
        if (parser.assignable & 2) {
          destructible |= 16;
          isNonSimpleParameterList = 1;
        }
      } else {
        if (parser.getToken() === 1077936155) {
          isNonSimpleParameterList = 1;
        } else {
          destructible |= 16;
        }
        expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 1, 0, tokenStart);
        if (parser.getToken() !== 16 && parser.getToken() !== 18) {
          expr = parseAssignmentExpression(parser, context, privateScope, 1, 0, tokenStart, expr);
        }
      }
    } else if (token & 2097152) {
      expr = token === 2162700 ? parseObjectLiteralOrPattern(parser, context, scope, privateScope, 0, 1, 0, kind, origin) : parseArrayExpressionOrPattern(parser, context, scope, privateScope, 0, 1, 0, kind, origin);
      destructible |= parser.destructible;
      isNonSimpleParameterList = 1;
      if (parser.getToken() !== 16 && parser.getToken() !== 18) {
        if (destructible & 8)
          parser.report(122);
        expr = parseMemberOrUpdateExpression(parser, context, privateScope, expr, 0, 0, tokenStart);
        destructible |= 16;
        if ((parser.getToken() & 8388608) === 8388608) {
          expr = parseBinaryExpression(parser, context, privateScope, 1, start, 4, token, expr);
        }
        if (consumeOpt(parser, context | 32, 22)) {
          expr = parseConditionalExpression(parser, context, privateScope, expr, start);
        }
      }
    } else if (token === 14) {
      expr = parseSpreadOrRestElement(parser, context, scope, privateScope, 16, kind, origin, 1, 1, 0);
      destructible |= (parser.getToken() === 16 ? 0 : 16) | parser.destructible;
      isNonSimpleParameterList = 1;
    } else {
      expr = parseExpression(parser, context, privateScope, 1, 0, tokenStart);
      destructible = parser.assignable;
      params.push(expr);
      while (consumeOpt(parser, context | 32, 18)) {
        params.push(parseExpression(parser, context, privateScope, 1, 0, tokenStart));
      }
      destructible |= parser.assignable;
      consume(parser, context, 16);
      parser.destructible = destructible | 16;
      parser.assignable = 2;
      return parser.finishNode({
        type: "CallExpression",
        callee,
        arguments: params,
        optional: false
      }, start);
    }
    params.push(expr);
    if (!consumeOpt(parser, context | 32, 18))
      break;
  }
  consume(parser, context, 16);
  destructible |= parser.destructible & 256 ? 256 : 0 | parser.destructible & 128 ? 128 : 0;
  if (parser.getToken() === 10) {
    if (destructible & (32 | 16))
      parser.report(27);
    if (parser.flags & 1 || flags & 1)
      parser.report(48);
    if (destructible & 128)
      parser.report(31);
    if (context & (1 | 1024) && destructible & 256)
      parser.report(32);
    if (isNonSimpleParameterList)
      parser.flags |= 128;
    return parseParenthesizedArrow(parser, context | 2048, scope, privateScope, params, canAssign, 1, start);
  }
  if (destructible & 64) {
    parser.report(63);
  }
  if (destructible & 8) {
    parser.report(62);
  }
  parser.assignable = 2;
  return parser.finishNode({
    type: "CallExpression",
    callee,
    arguments: params,
    optional: false
  }, start);
}
__name(parseAsyncArrowOrCallExpression, "parseAsyncArrowOrCallExpression");
function parseRegExpLiteral(parser, context) {
  const { tokenRaw, tokenRegExp, tokenValue, tokenStart } = parser;
  nextToken(parser, context);
  parser.assignable = 2;
  const node = {
    type: "Literal",
    value: tokenValue,
    regex: tokenRegExp
  };
  if (parser.options.raw) {
    node.raw = tokenRaw;
  }
  return parser.finishNode(node, tokenStart);
}
__name(parseRegExpLiteral, "parseRegExpLiteral");
function parseClassDeclaration(parser, context, scope, privateScope, flags) {
  let start;
  let decorators;
  if (parser.leadingDecorators.decorators.length) {
    if (parser.getToken() === 132) {
      parser.report(30, "@");
    }
    start = parser.leadingDecorators.start;
    decorators = [...parser.leadingDecorators.decorators];
    parser.leadingDecorators.decorators.length = 0;
  } else {
    start = parser.tokenStart;
    decorators = parseDecorators(parser, context, privateScope);
  }
  context = (context | 16384 | 1) ^ 16384;
  nextToken(parser, context);
  let id = null;
  let superClass = null;
  const { tokenValue } = parser;
  if (parser.getToken() & 4096 && parser.getToken() !== 20565) {
    if (isStrictReservedWord(parser, context, parser.getToken())) {
      parser.report(118);
    }
    if ((parser.getToken() & 537079808) === 537079808) {
      parser.report(119);
    }
    if (scope) {
      scope.addBlockName(context, tokenValue, 32, 0);
      if (flags) {
        if (flags & 2) {
          parser.declareUnboundVariable(tokenValue);
        }
      }
    }
    id = parseIdentifier(parser, context);
  } else {
    if ((flags & 1) === 0)
      parser.report(39, "Class");
  }
  let inheritedContext = context;
  if (consumeOpt(parser, context | 32, 20565)) {
    superClass = parseLeftHandSideExpression(parser, context, privateScope, 0, 0, 0);
    inheritedContext |= 512;
  } else {
    inheritedContext = (inheritedContext | 512) ^ 512;
  }
  const body = parseClassBody(parser, inheritedContext, context, scope, privateScope, 2, 8, 0);
  return parser.finishNode({
    type: "ClassDeclaration",
    id,
    superClass,
    body,
    ...parser.options.next ? { decorators } : null
  }, start);
}
__name(parseClassDeclaration, "parseClassDeclaration");
function parseClassExpression(parser, context, privateScope, inGroup, start) {
  let id = null;
  let superClass = null;
  const decorators = parseDecorators(parser, context, privateScope);
  context = (context | 1 | 16384) ^ 16384;
  nextToken(parser, context);
  if (parser.getToken() & 4096 && parser.getToken() !== 20565) {
    if (isStrictReservedWord(parser, context, parser.getToken()))
      parser.report(118);
    if ((parser.getToken() & 537079808) === 537079808) {
      parser.report(119);
    }
    id = parseIdentifier(parser, context);
  }
  let inheritedContext = context;
  if (consumeOpt(parser, context | 32, 20565)) {
    superClass = parseLeftHandSideExpression(parser, context, privateScope, 0, inGroup, 0);
    inheritedContext |= 512;
  } else {
    inheritedContext = (inheritedContext | 512) ^ 512;
  }
  const body = parseClassBody(parser, inheritedContext, context, void 0, privateScope, 2, 0, inGroup);
  parser.assignable = 2;
  return parser.finishNode({
    type: "ClassExpression",
    id,
    superClass,
    body,
    ...parser.options.next ? { decorators } : null
  }, start);
}
__name(parseClassExpression, "parseClassExpression");
function parseDecorators(parser, context, privateScope) {
  const list = [];
  if (parser.options.next) {
    while (parser.getToken() === 132) {
      list.push(parseDecoratorList(parser, context, privateScope));
    }
  }
  return list;
}
__name(parseDecorators, "parseDecorators");
function parseDecoratorList(parser, context, privateScope) {
  const start = parser.tokenStart;
  nextToken(parser, context | 32);
  let expression = parsePrimaryExpression(parser, context, privateScope, 2, 0, 1, 0, 1, start);
  expression = parseMemberOrUpdateExpression(parser, context, privateScope, expression, 0, 0, parser.tokenStart);
  return parser.finishNode({
    type: "Decorator",
    expression
  }, start);
}
__name(parseDecoratorList, "parseDecoratorList");
function parseClassBody(parser, context, inheritedContext, scope, parentScope, kind, origin, inGroup) {
  const { tokenStart } = parser;
  const privateScope = parser.createPrivateScopeIfLexical(parentScope);
  consume(parser, context | 32, 2162700);
  const modifierFlags = 131072 | 524288;
  context = (context | modifierFlags) ^ modifierFlags;
  const hasConstr = parser.flags & 32;
  parser.flags = (parser.flags | 32) ^ 32;
  const body = [];
  while (parser.getToken() !== 1074790415) {
    const decoratorStart = parser.tokenStart;
    const decorators = parseDecorators(parser, context, privateScope);
    if (decorators.length > 0 && parser.tokenValue === "constructor") {
      parser.report(109);
    }
    if (parser.getToken() === 1074790415)
      parser.report(108);
    if (consumeOpt(parser, context, 1074790417)) {
      if (decorators.length > 0)
        parser.report(120);
      continue;
    }
    body.push(parseClassElementList(parser, context, scope, privateScope, inheritedContext, kind, decorators, 0, inGroup, decorators.length > 0 ? decoratorStart : parser.tokenStart));
  }
  consume(parser, origin & 8 ? context | 32 : context, 1074790415);
  privateScope == null ? void 0 : privateScope.validatePrivateIdentifierRefs();
  parser.flags = parser.flags & -33 | hasConstr;
  return parser.finishNode({
    type: "ClassBody",
    body
  }, tokenStart);
}
__name(parseClassBody, "parseClassBody");
function parseClassElementList(parser, context, scope, privateScope, inheritedContext, type, decorators, isStatic, inGroup, start) {
  let kind = isStatic ? 32 : 0;
  let key = null;
  const token = parser.getToken();
  if (token & (143360 | 36864) || token === -2147483528) {
    key = parseIdentifier(parser, context);
    switch (token) {
      case 36970:
        if (!isStatic && parser.getToken() !== 67174411 && (parser.getToken() & 1048576) !== 1048576 && parser.getToken() !== 1077936155) {
          return parseClassElementList(parser, context, scope, privateScope, inheritedContext, type, decorators, 1, inGroup, start);
        }
        break;
      case 209005:
        if (parser.getToken() !== 67174411 && (parser.flags & 1) === 0) {
          if ((parser.getToken() & 1073741824) === 1073741824) {
            return parsePropertyDefinition(parser, context, privateScope, key, kind, decorators, start);
          }
          kind |= 16 | (optionalBit(parser, context, 8391476) ? 8 : 0);
        }
        break;
      case 209008:
        if (parser.getToken() !== 67174411) {
          if ((parser.getToken() & 1073741824) === 1073741824) {
            return parsePropertyDefinition(parser, context, privateScope, key, kind, decorators, start);
          }
          kind |= 256;
        }
        break;
      case 209009:
        if (parser.getToken() !== 67174411) {
          if ((parser.getToken() & 1073741824) === 1073741824) {
            return parsePropertyDefinition(parser, context, privateScope, key, kind, decorators, start);
          }
          kind |= 512;
        }
        break;
      case 12402:
        if (parser.getToken() !== 67174411 && (parser.flags & 1) === 0) {
          if ((parser.getToken() & 1073741824) === 1073741824) {
            return parsePropertyDefinition(parser, context, privateScope, key, kind, decorators, start);
          }
          if (parser.options.next)
            kind |= 1024;
        }
        break;
    }
  } else if (token === 69271571) {
    kind |= 2;
    key = parseComputedPropertyName(parser, inheritedContext, privateScope, inGroup);
  } else if ((token & 134217728) === 134217728) {
    key = parseLiteral(parser, context);
  } else if (token === 8391476) {
    kind |= 8;
    nextToken(parser, context);
  } else if (parser.getToken() === 130) {
    kind |= 8192;
    key = parsePrivateIdentifier(parser, context | 16, privateScope, 768);
  } else if ((parser.getToken() & 1073741824) === 1073741824) {
    kind |= 128;
  } else if (isStatic && token === 2162700) {
    return parseStaticBlock(parser, context | 16, scope, privateScope, start);
  } else if (token === -2147483527) {
    key = parseIdentifier(parser, context);
    if (parser.getToken() !== 67174411)
      parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  } else {
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
  if (kind & (8 | 16 | 768 | 1024)) {
    if (parser.getToken() & 143360 || parser.getToken() === -2147483528 || parser.getToken() === -2147483527) {
      key = parseIdentifier(parser, context);
    } else if ((parser.getToken() & 134217728) === 134217728) {
      key = parseLiteral(parser, context);
    } else if (parser.getToken() === 69271571) {
      kind |= 2;
      key = parseComputedPropertyName(parser, context, privateScope, 0);
    } else if (parser.getToken() === 130) {
      kind |= 8192;
      key = parsePrivateIdentifier(parser, context, privateScope, kind);
    } else
      parser.report(135);
  }
  if ((kind & 2) === 0) {
    if (parser.tokenValue === "constructor") {
      if ((parser.getToken() & 1073741824) === 1073741824) {
        parser.report(129);
      } else if ((kind & 32) === 0 && parser.getToken() === 67174411) {
        if (kind & (768 | 16 | 128 | 8)) {
          parser.report(53, "accessor");
        } else if ((context & 512) === 0) {
          if (parser.flags & 32)
            parser.report(54);
          else
            parser.flags |= 32;
        }
      }
      kind |= 64;
    } else if ((kind & 8192) === 0 && kind & 32 && parser.tokenValue === "prototype") {
      parser.report(52);
    }
  }
  if (kind & 1024 || parser.getToken() !== 67174411 && (kind & 768) === 0) {
    return parsePropertyDefinition(parser, context, privateScope, key, kind, decorators, start);
  }
  const value = parseMethodDefinition(parser, context | 16, privateScope, kind, inGroup, parser.tokenStart);
  return parser.finishNode({
    type: "MethodDefinition",
    kind: (kind & 32) === 0 && kind & 64 ? "constructor" : kind & 256 ? "get" : kind & 512 ? "set" : "method",
    static: (kind & 32) > 0,
    computed: (kind & 2) > 0,
    key,
    value,
    ...parser.options.next ? { decorators } : null
  }, start);
}
__name(parseClassElementList, "parseClassElementList");
function parsePrivateIdentifier(parser, context, privateScope, kind) {
  const { tokenStart } = parser;
  nextToken(parser, context);
  const { tokenValue } = parser;
  if (tokenValue === "constructor")
    parser.report(128);
  if (parser.options.lexical) {
    if (!privateScope)
      parser.report(4, tokenValue);
    if (kind) {
      privateScope.addPrivateIdentifier(tokenValue, kind);
    } else {
      privateScope.addPrivateIdentifierRef(tokenValue);
    }
  }
  nextToken(parser, context);
  return parser.finishNode({
    type: "PrivateIdentifier",
    name: tokenValue
  }, tokenStart);
}
__name(parsePrivateIdentifier, "parsePrivateIdentifier");
function parsePropertyDefinition(parser, context, privateScope, key, state, decorators, start) {
  let value = null;
  if (state & 8)
    parser.report(0);
  if (parser.getToken() === 1077936155) {
    nextToken(parser, context | 32);
    const { tokenStart } = parser;
    if (parser.getToken() === 537079927)
      parser.report(119);
    const modifierFlags = 1024 | 2048 | 8192 | ((state & 64) === 0 ? 512 | 16384 : 0);
    context = (context | modifierFlags) ^ modifierFlags | (state & 8 ? 1024 : 0) | (state & 16 ? 2048 : 0) | (state & 64 ? 16384 : 0) | 256 | 65536;
    value = parsePrimaryExpression(parser, context | 16, privateScope, 2, 0, 1, 0, 1, tokenStart);
    if ((parser.getToken() & 1073741824) !== 1073741824 || (parser.getToken() & 4194304) === 4194304) {
      value = parseMemberOrUpdateExpression(parser, context | 16, privateScope, value, 0, 0, tokenStart);
      value = parseAssignmentExpression(parser, context | 16, privateScope, 0, 0, tokenStart, value);
    }
  }
  matchOrInsertSemicolon(parser, context);
  return parser.finishNode({
    type: state & 1024 ? "AccessorProperty" : "PropertyDefinition",
    key,
    value,
    static: (state & 32) > 0,
    computed: (state & 2) > 0,
    ...parser.options.next ? { decorators } : null
  }, start);
}
__name(parsePropertyDefinition, "parsePropertyDefinition");
function parseBindingPattern(parser, context, scope, privateScope, type, origin) {
  if (parser.getToken() & 143360 || (context & 1) === 0 && parser.getToken() === -2147483527)
    return parseAndClassifyIdentifier(parser, context, scope, type, origin);
  if ((parser.getToken() & 2097152) !== 2097152)
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  const left = parser.getToken() === 69271571 ? parseArrayExpressionOrPattern(parser, context, scope, privateScope, 1, 0, 1, type, origin) : parseObjectLiteralOrPattern(parser, context, scope, privateScope, 1, 0, 1, type, origin);
  if (parser.destructible & 16)
    parser.report(50);
  if (parser.destructible & 32)
    parser.report(50);
  return left;
}
__name(parseBindingPattern, "parseBindingPattern");
function parseAndClassifyIdentifier(parser, context, scope, kind, origin) {
  const token = parser.getToken();
  if (context & 1) {
    if ((token & 537079808) === 537079808) {
      parser.report(119);
    } else if ((token & 36864) === 36864 || token === -2147483527) {
      parser.report(118);
    }
  }
  if ((token & 20480) === 20480) {
    parser.report(102);
  }
  if (token === 241771) {
    if (context & 1024)
      parser.report(32);
    if (context & 2)
      parser.report(111);
  }
  if ((token & 255) === (241737 & 255)) {
    if (kind & (8 | 16))
      parser.report(100);
  }
  if (token === 209006) {
    if (context & 2048)
      parser.report(176);
    if (context & 2)
      parser.report(110);
  }
  const { tokenValue, tokenStart: start } = parser;
  nextToken(parser, context);
  scope == null ? void 0 : scope.addVarOrBlock(context, tokenValue, kind, origin);
  return parser.finishNode({
    type: "Identifier",
    name: tokenValue
  }, start);
}
__name(parseAndClassifyIdentifier, "parseAndClassifyIdentifier");
function parseJSXRootElementOrFragment(parser, context, privateScope, inJSXChild, start) {
  if (!inJSXChild)
    consume(parser, context, 8456256);
  if (parser.getToken() === 8390721) {
    const openingFragment = parseJSXOpeningFragment(parser, start);
    const [children2, closingFragment] = parseJSXChildrenAndClosingFragment(parser, context, privateScope, inJSXChild);
    return parser.finishNode({
      type: "JSXFragment",
      openingFragment,
      children: children2,
      closingFragment
    }, start);
  }
  if (parser.getToken() === 8457014)
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  let closingElement = null;
  let children = [];
  const openingElement = parseJSXOpeningElementOrSelfCloseElement(parser, context, privateScope, inJSXChild, start);
  if (!openingElement.selfClosing) {
    [children, closingElement] = parseJSXChildrenAndClosingElement(parser, context, privateScope, inJSXChild);
    const close = isEqualTagName(closingElement.name);
    if (isEqualTagName(openingElement.name) !== close)
      parser.report(155, close);
  }
  return parser.finishNode({
    type: "JSXElement",
    children,
    openingElement,
    closingElement
  }, start);
}
__name(parseJSXRootElementOrFragment, "parseJSXRootElementOrFragment");
function parseJSXOpeningFragment(parser, start) {
  nextJSXToken(parser);
  return parser.finishNode({
    type: "JSXOpeningFragment"
  }, start);
}
__name(parseJSXOpeningFragment, "parseJSXOpeningFragment");
function parseJSXClosingElement(parser, context, inJSXChild, start) {
  consume(parser, context, 8457014);
  const name = parseJSXElementName(parser, context);
  if (parser.getToken() !== 8390721) {
    parser.report(25, KeywordDescTable[8390721 & 255]);
  }
  if (inJSXChild) {
    nextJSXToken(parser);
  } else {
    nextToken(parser, context);
  }
  return parser.finishNode({
    type: "JSXClosingElement",
    name
  }, start);
}
__name(parseJSXClosingElement, "parseJSXClosingElement");
function parseJSXClosingFragment(parser, context, inJSXChild, start) {
  consume(parser, context, 8457014);
  if (parser.getToken() !== 8390721) {
    parser.report(25, KeywordDescTable[8390721 & 255]);
  }
  if (inJSXChild) {
    nextJSXToken(parser);
  } else {
    nextToken(parser, context);
  }
  return parser.finishNode({
    type: "JSXClosingFragment"
  }, start);
}
__name(parseJSXClosingFragment, "parseJSXClosingFragment");
function parseJSXChildrenAndClosingElement(parser, context, privateScope, inJSXChild) {
  const children = [];
  while (true) {
    const child = parseJSXChildOrClosingElement(parser, context, privateScope, inJSXChild);
    if (child.type === "JSXClosingElement") {
      return [children, child];
    }
    children.push(child);
  }
}
__name(parseJSXChildrenAndClosingElement, "parseJSXChildrenAndClosingElement");
function parseJSXChildrenAndClosingFragment(parser, context, privateScope, inJSXChild) {
  const children = [];
  while (true) {
    const child = parseJSXChildOrClosingFragment(parser, context, privateScope, inJSXChild);
    if (child.type === "JSXClosingFragment") {
      return [children, child];
    }
    children.push(child);
  }
}
__name(parseJSXChildrenAndClosingFragment, "parseJSXChildrenAndClosingFragment");
function parseJSXChildOrClosingElement(parser, context, privateScope, inJSXChild) {
  if (parser.getToken() === 137)
    return parseJSXText(parser, context);
  if (parser.getToken() === 2162700)
    return parseJSXExpressionContainer(parser, context, privateScope, 1, 0);
  if (parser.getToken() === 8456256) {
    const { tokenStart } = parser;
    nextToken(parser, context);
    if (parser.getToken() === 8457014)
      return parseJSXClosingElement(parser, context, inJSXChild, tokenStart);
    return parseJSXRootElementOrFragment(parser, context, privateScope, 1, tokenStart);
  }
  parser.report(0);
}
__name(parseJSXChildOrClosingElement, "parseJSXChildOrClosingElement");
function parseJSXChildOrClosingFragment(parser, context, privateScope, inJSXChild) {
  if (parser.getToken() === 137)
    return parseJSXText(parser, context);
  if (parser.getToken() === 2162700)
    return parseJSXExpressionContainer(parser, context, privateScope, 1, 0);
  if (parser.getToken() === 8456256) {
    const { tokenStart } = parser;
    nextToken(parser, context);
    if (parser.getToken() === 8457014)
      return parseJSXClosingFragment(parser, context, inJSXChild, tokenStart);
    return parseJSXRootElementOrFragment(parser, context, privateScope, 1, tokenStart);
  }
  parser.report(0);
}
__name(parseJSXChildOrClosingFragment, "parseJSXChildOrClosingFragment");
function parseJSXText(parser, context) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  const node = {
    type: "JSXText",
    value: parser.tokenValue
  };
  if (parser.options.raw) {
    node.raw = parser.tokenRaw;
  }
  return parser.finishNode(node, start);
}
__name(parseJSXText, "parseJSXText");
function parseJSXOpeningElementOrSelfCloseElement(parser, context, privateScope, inJSXChild, start) {
  if ((parser.getToken() & 143360) !== 143360 && (parser.getToken() & 4096) !== 4096)
    parser.report(0);
  const tagName = parseJSXElementName(parser, context);
  const attributes = parseJSXAttributes(parser, context, privateScope);
  const selfClosing = parser.getToken() === 8457014;
  if (selfClosing)
    consume(parser, context, 8457014);
  if (parser.getToken() !== 8390721) {
    parser.report(25, KeywordDescTable[8390721 & 255]);
  }
  if (inJSXChild || !selfClosing) {
    nextJSXToken(parser);
  } else {
    nextToken(parser, context);
  }
  return parser.finishNode({
    type: "JSXOpeningElement",
    name: tagName,
    attributes,
    selfClosing
  }, start);
}
__name(parseJSXOpeningElementOrSelfCloseElement, "parseJSXOpeningElementOrSelfCloseElement");
function parseJSXElementName(parser, context) {
  const { tokenStart } = parser;
  rescanJSXIdentifier(parser);
  let key = parseJSXIdentifier(parser, context);
  if (parser.getToken() === 21)
    return parseJSXNamespacedName(parser, context, key, tokenStart);
  while (consumeOpt(parser, context, 67108877)) {
    rescanJSXIdentifier(parser);
    key = parseJSXMemberExpression(parser, context, key, tokenStart);
  }
  return key;
}
__name(parseJSXElementName, "parseJSXElementName");
function parseJSXMemberExpression(parser, context, object, start) {
  const property = parseJSXIdentifier(parser, context);
  return parser.finishNode({
    type: "JSXMemberExpression",
    object,
    property
  }, start);
}
__name(parseJSXMemberExpression, "parseJSXMemberExpression");
function parseJSXAttributes(parser, context, privateScope) {
  const attributes = [];
  while (parser.getToken() !== 8457014 && parser.getToken() !== 8390721 && parser.getToken() !== 1048576) {
    attributes.push(parseJsxAttribute(parser, context, privateScope));
  }
  return attributes;
}
__name(parseJSXAttributes, "parseJSXAttributes");
function parseJSXSpreadAttribute(parser, context, privateScope) {
  const start = parser.tokenStart;
  nextToken(parser, context);
  consume(parser, context, 14);
  const expression = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
  consume(parser, context, 1074790415);
  return parser.finishNode({
    type: "JSXSpreadAttribute",
    argument: expression
  }, start);
}
__name(parseJSXSpreadAttribute, "parseJSXSpreadAttribute");
function parseJsxAttribute(parser, context, privateScope) {
  const { tokenStart } = parser;
  if (parser.getToken() === 2162700)
    return parseJSXSpreadAttribute(parser, context, privateScope);
  rescanJSXIdentifier(parser);
  let value = null;
  let name = parseJSXIdentifier(parser, context);
  if (parser.getToken() === 21) {
    name = parseJSXNamespacedName(parser, context, name, tokenStart);
  }
  if (parser.getToken() === 1077936155) {
    const token = scanJSXAttributeValue(parser, context);
    switch (token) {
      case 134283267:
        value = parseLiteral(parser, context);
        break;
      case 8456256:
        value = parseJSXRootElementOrFragment(parser, context, privateScope, 0, parser.tokenStart);
        break;
      case 2162700:
        value = parseJSXExpressionContainer(parser, context, privateScope, 0, 1);
        break;
      default:
        parser.report(154);
    }
  }
  return parser.finishNode({
    type: "JSXAttribute",
    value,
    name
  }, tokenStart);
}
__name(parseJsxAttribute, "parseJsxAttribute");
function parseJSXNamespacedName(parser, context, namespace, start) {
  consume(parser, context, 21);
  const name = parseJSXIdentifier(parser, context);
  return parser.finishNode({
    type: "JSXNamespacedName",
    namespace,
    name
  }, start);
}
__name(parseJSXNamespacedName, "parseJSXNamespacedName");
function parseJSXExpressionContainer(parser, context, privateScope, inJSXChild, isAttr) {
  const { tokenStart: start } = parser;
  nextToken(parser, context | 32);
  const { tokenStart } = parser;
  if (parser.getToken() === 14)
    return parseJSXSpreadChild(parser, context, privateScope, start);
  let expression = null;
  if (parser.getToken() === 1074790415) {
    if (isAttr)
      parser.report(157);
    expression = parseJSXEmptyExpression(parser, {
      index: parser.startIndex,
      line: parser.startLine,
      column: parser.startColumn
    });
  } else {
    expression = parseExpression(parser, context, privateScope, 1, 0, tokenStart);
  }
  if (parser.getToken() !== 1074790415) {
    parser.report(25, KeywordDescTable[1074790415 & 255]);
  }
  if (inJSXChild) {
    nextJSXToken(parser);
  } else {
    nextToken(parser, context);
  }
  return parser.finishNode({
    type: "JSXExpressionContainer",
    expression
  }, start);
}
__name(parseJSXExpressionContainer, "parseJSXExpressionContainer");
function parseJSXSpreadChild(parser, context, privateScope, start) {
  consume(parser, context, 14);
  const expression = parseExpression(parser, context, privateScope, 1, 0, parser.tokenStart);
  consume(parser, context, 1074790415);
  return parser.finishNode({
    type: "JSXSpreadChild",
    expression
  }, start);
}
__name(parseJSXSpreadChild, "parseJSXSpreadChild");
function parseJSXEmptyExpression(parser, start) {
  return parser.finishNode({
    type: "JSXEmptyExpression"
  }, start, parser.tokenStart);
}
__name(parseJSXEmptyExpression, "parseJSXEmptyExpression");
function parseJSXIdentifier(parser, context) {
  const start = parser.tokenStart;
  if (!(parser.getToken() & 143360)) {
    parser.report(30, KeywordDescTable[parser.getToken() & 255]);
  }
  const { tokenValue } = parser;
  nextToken(parser, context);
  return parser.finishNode({
    type: "JSXIdentifier",
    name: tokenValue
  }, start);
}
__name(parseJSXIdentifier, "parseJSXIdentifier");
function parseScript(source, options) {
  return parseSource(source, options);
}
__name(parseScript, "parseScript");

// dist/src/utils/javascript/JsAnalyzer.js
var _JsAnalyzer = class _JsAnalyzer {
  /**
   * Creates a new instance over the provided source.
   * @param code JavaScript source to parse and inspect.
   * @param options Optional traversal settings.
   */
  constructor(code, options = {}) {
    __publicField(this, "source");
    __publicField(this, "programAst");
    __publicField(this, "hasExtractions");
    __publicField(this, "extractionStates");
    __publicField(this, "dependentsTracker", /* @__PURE__ */ new Map());
    __publicField(this, "declaredVariables", /* @__PURE__ */ new Map());
    __publicField(this, "iifeParamName", null);
    this.source = code;
    const extractionConfigs = options.extractions ? Array.isArray(options.extractions) ? options.extractions : [options.extractions] : [];
    this.extractionStates = extractionConfigs.map((config) => ({
      config: { collectDependencies: true, stopWhenReady: true, ...config },
      dependencies: /* @__PURE__ */ new Set(),
      dependents: /* @__PURE__ */ new Set(),
      ready: false
    }));
    this.hasExtractions = this.extractionStates.length > 0;
    this.programAst = parseScript(code, {
      ranges: true,
      loc: false,
      module: false
    });
    this.analyzeAst();
  }
  /**
   * Walks the AST to collect declarations and resolve initial targets.
   */
  analyzeAst() {
    var _a;
    let iifeBody;
    for (const statement of this.programAst.body) {
      if (statement.type === "ExpressionStatement" && statement.expression.type === "CallExpression") {
        const callExpr = statement.expression;
        if (callExpr.callee.type === "FunctionExpression") {
          const funcExpr = callExpr.callee;
          const firstParam = funcExpr.params.length > 0 ? funcExpr.params[0] : null;
          if (!this.iifeParamName && (firstParam == null ? void 0 : firstParam.type) === "Identifier") {
            this.iifeParamName = firstParam.name;
          }
          if (((_a = funcExpr.body) == null ? void 0 : _a.type) === "BlockStatement") {
            iifeBody = funcExpr.body;
            break;
          }
        }
      }
    }
    if (!iifeBody)
      return;
    for (const currentNode of iifeBody.body) {
      switch (currentNode.type) {
        case "ExpressionStatement": {
          const assignment = currentNode.expression;
          if (assignment.type !== "AssignmentExpression")
            continue;
          const left = assignment.left;
          const right = assignment.right;
          if (left.type === "Identifier") {
            const existingVariable = this.declaredVariables.get(left.name);
            if (!existingVariable)
              continue;
            existingVariable.node.init = right;
            if (this.needsDependencyAnalysis(right)) {
              existingVariable.dependencies = this.findDependencies(assignment.right, left.name);
            }
            if (this.onMatch(existingVariable.node, existingVariable))
              return;
          } else if (assignment.left.type === "MemberExpression") {
            const memberName = memberToString(assignment.left, this.source);
            if (!memberName || this.declaredVariables.has(memberName))
              continue;
            const metadata = {
              name: memberName,
              node: currentNode,
              dependents: this.dependentsTracker.get(memberName) || /* @__PURE__ */ new Set(),
              predeclared: false,
              dependencies: this.findDependencies(right, memberName)
            };
            const baseName = memberBaseName(assignment.left, this.source);
            if (baseName && baseName !== memberName && !baseName.startsWith("this.")) {
              metadata.dependencies.add(baseName.replace(".prototype", ""));
            }
            if (this.dependentsTracker.has(memberName)) {
              this.dependentsTracker.delete(memberName);
            }
            this.declaredVariables.set(memberName, metadata);
            if (this.onMatch(currentNode, metadata))
              return;
          }
          break;
        }
        case "VariableDeclaration": {
          for (const declaration of currentNode.declarations) {
            if (declaration.id.type !== "Identifier")
              continue;
            const metadata = {
              name: declaration.id.name,
              node: declaration,
              dependents: this.dependentsTracker.get(declaration.id.name) || /* @__PURE__ */ new Set(),
              dependencies: /* @__PURE__ */ new Set(),
              predeclared: false
            };
            const init = declaration.init;
            if (!init && currentNode.kind === "var") {
              metadata.predeclared = true;
            } else if (init && this.needsDependencyAnalysis(init)) {
              metadata.dependencies = this.findDependencies(init, metadata.name);
            }
            if (this.dependentsTracker.has(metadata.name)) {
              this.dependentsTracker.delete(metadata.name);
            }
            this.declaredVariables.set(metadata.name, metadata);
            if (this.onMatch(declaration, metadata))
              return;
          }
          break;
        }
      }
    }
  }
  /**
   * Quick check if node type requires dependency analysis
   */
  needsDependencyAnalysis(node) {
    if (!node)
      return false;
    switch (node.type) {
      case "FunctionExpression":
      case "ArrowFunctionExpression":
      case "ArrayExpression":
      case "LogicalExpression":
      case "CallExpression":
      case "NewExpression":
      case "MemberExpression":
      case "BinaryExpression":
      case "ConditionalExpression":
      case "ObjectExpression":
      case "SequenceExpression":
      case "Identifier":
        return true;
      default:
        return false;
    }
  }
  /**
   * Records a match, attaches metadata, and updates readiness state.
   * @returns True when traversal can stop as a result of the match.
   */
  onMatch(node, metadata) {
    if (!this.hasExtractions)
      return false;
    let matched = false;
    let result = false;
    for (const state of this.extractionStates) {
      if (!state.node) {
        if (node.type === "VariableDeclarator" && !node.init)
          continue;
        result = state.config.match(node);
        if (!result)
          continue;
        state.node = node;
      } else if (state.node !== node) {
        this.refreshExtractionState(state);
        if (this.shouldStopTraversal()) {
          return true;
        }
        continue;
      }
      matched = true;
      if (metadata) {
        state.metadata = metadata;
        state.dependents = metadata.dependents;
        state.dependencies = metadata.dependencies;
        if (typeof result !== "boolean")
          state.matchContext = result;
      }
      this.refreshExtractionState(state);
    }
    if (!matched)
      return false;
    return this.shouldStopTraversal();
  }
  /**
   * Refreshes the readiness state of an extraction target based on its dependencies
   * and/or configuration.
   * @param state - State to refresh.
   */
  refreshExtractionState(state) {
    if (!state.node) {
      state.ready = false;
      return;
    }
    if (state.config.collectDependencies === false) {
      state.ready = true;
      return;
    }
    if (!state.metadata) {
      state.ready = false;
      return;
    }
    state.ready = this.areDependenciesResolved(state.dependencies);
  }
  /**
   * Determines whether traversal should stop based on extraction states and configuration.
   */
  shouldStopTraversal() {
    if (!this.hasExtractions)
      return false;
    let hasStoppingTarget = false;
    for (const state of this.extractionStates) {
      if (state.config.stopWhenReady === false)
        continue;
      hasStoppingTarget = true;
      if (!state.node)
        return false;
      if (!state.ready)
        return false;
    }
    return hasStoppingTarget;
  }
  /**
   * Checks if every dependency resolves to a declaration or built-in symbol.
   * @param dependencies - Dependencies to validate.
   * @param seen - Tracks recursively visited identifiers.
   */
  areDependenciesResolved(dependencies, seen = /* @__PURE__ */ new Set()) {
    if (!dependencies || dependencies.size === 0)
      return true;
    for (const dependency of dependencies) {
      if (!dependency)
        continue;
      if (jsBuiltIns.has(dependency))
        continue;
      if (dependency === this.iifeParamName)
        continue;
      if (seen.has(dependency))
        continue;
      const depMeta = this.declaredVariables.get(dependency);
      if (!depMeta)
        return false;
      seen.add(dependency);
      if (!this.areDependenciesResolved(depMeta.dependencies, seen)) {
        return false;
      }
    }
    return true;
  }
  /**
   * Collects free identifier dependencies reachable from the provided AST node.
   * @param rootNode - AST node to search for dependencies.
   * @param identifierName - Name of the identifier represented by `rootNode`, used for tracking dependents.
   */
  findDependencies(rootNode, identifierName) {
    var _a;
    const dependencies = /* @__PURE__ */ new Set();
    if (!rootNode)
      return dependencies;
    const scopeStack = [
      {
        names: /* @__PURE__ */ new Set(),
        type: "block"
      }
    ];
    const currentScope = /* @__PURE__ */ __name(() => scopeStack[scopeStack.length - 1], "currentScope");
    const isInScope = /* @__PURE__ */ __name((name) => {
      for (let i = scopeStack.length - 1; i >= 0; i--) {
        if (scopeStack[i].names.has(name))
          return true;
      }
      return false;
    }, "isInScope");
    const rootIdentifierName = "id" in rootNode && ((_a = rootNode == null ? void 0 : rootNode.id) == null ? void 0 : _a.type) === "Identifier" ? rootNode.id.name : void 0;
    const collectBindingIdentifiers = /* @__PURE__ */ __name((pattern, target) => {
      if (!pattern)
        return;
      switch (pattern.type) {
        case "Identifier":
          target.add(pattern.name);
          break;
        case "ObjectPattern":
          for (const prop of pattern.properties) {
            if (prop.type === "RestElement") {
              collectBindingIdentifiers(prop.argument, target);
            } else if (prop.type === "Property") {
              collectBindingIdentifiers(prop.value, target);
            }
          }
          break;
        case "ArrayPattern":
          for (const el of pattern.elements) {
            if (el)
              collectBindingIdentifiers(el, target);
          }
          break;
        case "RestElement":
          collectBindingIdentifiers(pattern.argument, target);
          break;
        case "AssignmentPattern":
          collectBindingIdentifiers(pattern.left, target);
          break;
      }
    }, "collectBindingIdentifiers");
    const collectParams = /* @__PURE__ */ __name((fnNode, target) => {
      if (!(fnNode == null ? void 0 : fnNode.params))
        return;
      for (const p of fnNode.params)
        collectBindingIdentifiers(p, target);
    }, "collectParams");
    walkAst(rootNode, {
      enter: /* @__PURE__ */ __name((n, parent) => {
        var _a2, _b, _c;
        switch (n.type) {
          case "FunctionDeclaration":
          case "FunctionExpression":
          case "ArrowFunctionExpression": {
            const isDecl = n.type === "FunctionDeclaration";
            const fnName = "id" in n ? (_a2 = n.id) == null ? void 0 : _a2.name : void 0;
            if (isDecl && fnName) {
              currentScope().names.add(fnName);
            }
            const fnScope = { names: /* @__PURE__ */ new Set(), type: "function" };
            if (n.type === "FunctionExpression" && fnName) {
              fnScope.names.add(fnName);
            }
            collectParams(n, fnScope.names);
            scopeStack.push(fnScope);
            break;
          }
          case "BlockStatement": {
            scopeStack.push({ names: /* @__PURE__ */ new Set(), type: "block" });
            break;
          }
          case "CatchClause": {
            const s = /* @__PURE__ */ new Set();
            if (n.param)
              collectBindingIdentifiers(n.param, s);
            scopeStack.push({ names: s, type: "block" });
            break;
          }
          case "VariableDeclaration": {
            const scope = currentScope();
            for (const d of n.declarations) {
              collectBindingIdentifiers(d.id, scope.names);
            }
            break;
          }
          case "ClassDeclaration": {
            if ((_b = n.id) == null ? void 0 : _b.name) {
              currentScope().names.add(n.id.name);
            }
            break;
          }
          case "LabeledStatement": {
            if (((_c = n.label) == null ? void 0 : _c.type) === "Identifier")
              currentScope().names.add(n.label.name);
            break;
          }
          case "Identifier": {
            if (n.name === rootIdentifierName)
              return;
            if ((parent == null ? void 0 : parent.type) === "Property" && parent.key === n && !parent.computed)
              return;
            if ((parent == null ? void 0 : parent.type) === "MemberExpression" && parent.property === n && !parent.computed) {
              if (parent.object.type === "ThisExpression")
                return;
              const full = memberToString(parent, this.source);
              if (!full)
                return;
              const declaredVariable2 = this.declaredVariables.get(full);
              if (declaredVariable2) {
                declaredVariable2.dependents.add(identifierName);
                dependencies.add(full);
              } else if (parent.object.type === "Identifier") {
                const baseName = parent.object.name;
                const declaredBaseVariable = this.declaredVariables.get(baseName);
                if ((declaredBaseVariable || baseName === this.iifeParamName) && !isInScope(baseName) && !jsBuiltIns.has(baseName)) {
                  declaredBaseVariable == null ? void 0 : declaredBaseVariable.dependents.add(identifierName);
                  dependencies.add(full);
                  const existingTracker = this.dependentsTracker.get(full);
                  if (existingTracker) {
                    existingTracker.add(identifierName);
                  } else {
                    this.dependentsTracker.set(full, /* @__PURE__ */ new Set([identifierName]));
                  }
                }
              }
              return;
            }
            if (isInScope(n.name) || jsBuiltIns.has(n.name))
              return;
            dependencies.add(n.name);
            const declaredVariable = this.declaredVariables.get(n.name);
            if (declaredVariable) {
              declaredVariable.dependents.add(identifierName);
            } else {
              const existing = this.dependentsTracker.get(n.name);
              if (existing) {
                existing.add(identifierName);
              } else {
                this.dependentsTracker.set(n.name, /* @__PURE__ */ new Set([identifierName]));
              }
            }
            break;
          }
        }
      }, "enter"),
      leave: /* @__PURE__ */ __name((n) => {
        switch (n.type) {
          case "FunctionDeclaration":
          case "FunctionExpression":
          case "ArrowFunctionExpression":
          case "BlockStatement":
          case "CatchClause":
            if (scopeStack.length > 1)
              scopeStack.pop();
            break;
        }
      }, "leave")
    });
    return dependencies;
  }
  /**
   * Returns the current set of matched extractions.
   */
  getExtractedMatches() {
    return this.extractionStates.filter((state) => !!state.node);
  }
  /**
   * Returns the raw, original source.
   */
  getSource() {
    return this.source;
  }
};
__name(_JsAnalyzer, "JsAnalyzer");
var JsAnalyzer = _JsAnalyzer;

// dist/src/utils/javascript/JsExtractor.js
var _JsExtractor = class _JsExtractor {
  constructor(analyzer) {
    __publicField(this, "analyzer");
    this.analyzer = analyzer;
  }
  /**
   * Checks if all provided arguments are safe initializers.
   * @param args - The arguments to check.
   * @param mode - The side effect mode to use ('strict' or 'loose').
   */
  areSafeArgs(args, mode = "strict") {
    return (args != null ? args : []).every((arg) => {
      if (!arg)
        return false;
      if (arg.type === "SpreadElement")
        return false;
      return this.isSafeInitializer(arg, mode);
    });
  }
  /**
   * Determines if a given AST node is a safe initializer without side effects.
   * @param node - The AST node to evaluate.
   * @param mode - The side effect mode to use ('strict' or 'loose').
   */
  isSafeInitializer(node, mode = "strict") {
    var _a;
    if (!node)
      return true;
    switch (node.type) {
      case "Literal": {
        const literal = node;
        return typeof literal.value === "string" || typeof literal.value === "number" || typeof literal.value === "boolean" || literal.value === null || Boolean(literal.regex);
      }
      case "TemplateLiteral": {
        return node.expressions.every((expr) => this.isSafeInitializer(expr, mode));
      }
      case "ArrayExpression": {
        return node.elements.every((elem) => {
          if (!elem)
            return true;
          if (elem.type === "SpreadElement")
            return false;
          return this.isSafeInitializer(elem, mode);
        });
      }
      case "ObjectExpression": {
        return node.properties.every((prop) => {
          if (prop.type !== "Property")
            return false;
          if (prop.computed)
            return false;
          if (prop.kind !== "init")
            return false;
          const value = prop.value;
          if (!value)
            return false;
          return value.type === "FunctionExpression" || value.type === "ArrowFunctionExpression" || value.type === "Literal";
        });
      }
      case "CallExpression": {
        if (node.callee.type === "Identifier" && jsBuiltIns.has(node.callee.name)) {
          return this.areSafeArgs(node.arguments, mode);
        } else if (node.callee.type === "MemberExpression") {
          if (!this.isSafeInitializer(node.callee.object, mode))
            return false;
          if (mode === "strict") {
            const propertyName = node.callee.property.type === "Identifier" ? node.callee.property.name : "";
            if (node.callee.computed || !jsBuiltIns.has(propertyName)) {
              return false;
            }
          }
          return this.areSafeArgs(node.arguments, mode);
        }
        return false;
      }
      case "NewExpression": {
        if (node.callee.type === "Identifier") {
          if (jsBuiltIns.has(node.callee.name)) {
            return this.areSafeArgs(node.arguments, mode);
          }
          if (mode === "loose") {
            return this.areSafeArgs(node.arguments, mode);
          }
        }
        return false;
      }
      case "UnaryExpression": {
        return this.isSafeInitializer(node.argument, mode);
      }
      case "FunctionExpression":
      case "ArrowFunctionExpression":
      case "Identifier": {
        return true;
      }
      case "MemberExpression": {
        if (mode === "loose") {
          if (node.computed && !this.isSafeInitializer(node.property, mode)) {
            return false;
          }
          return this.isSafeInitializer(node.object, mode);
        }
        return false;
      }
      case "LogicalExpression":
      case "BinaryExpression": {
        return this.isSafeInitializer(node.left, mode) && this.isSafeInitializer(node.right, mode);
      }
      case "ConditionalExpression": {
        if (mode === "loose") {
          return this.isSafeInitializer(node.test, mode) && this.isSafeInitializer(node.consequent, mode) && this.isSafeInitializer(node.alternate, mode);
        }
        return false;
      }
      case "SequenceExpression": {
        if (mode === "loose") {
          return node.expressions.every((expr) => this.isSafeInitializer(expr, mode));
        }
        return false;
      }
      case "AssignmentExpression": {
        if (node.left.type === "MemberExpression" && !node.left.computed) {
          const object = node.left.object;
          if (object.type === "Identifier" && ((_a = this.analyzer.declaredVariables.get(object.name)) == null ? void 0 : _a.node.init) !== void 0) {
            return this.isSafeInitializer(node.right, mode);
          }
        } else if (node.left.type === "Identifier") {
          if (this.analyzer.declaredVariables.has(node.left.name)) {
            return this.isSafeInitializer(node.right, mode);
          }
        }
        return false;
      }
      // @todo: check for more?
      default:
        return false;
    }
  }
  /**
   * Provides a fallback initializer string based on the type of the initializer node.
   * @TODO: Check more cases.
   * @param init - The initializer expression to evaluate.
   */
  getInitializerFallback(init) {
    switch (init == null ? void 0 : init.type) {
      case "ObjectExpression":
      case "NewExpression":
      case "MemberExpression":
      case "LogicalExpression":
        return "{}";
      case "ArrayExpression":
        return "[]";
      default:
        return "undefined";
    }
  }
  /**
   * Renders an AST node to JavaScript source code, with special handling for variable declarators.
   * @param node - The ESTree node to render.
   * @param preDeclared - Whether the variable has been previously declared.
   * @param options - Configuration options for the emitter.
   */
  renderNode(node, preDeclared, options = {}) {
    var _a, _b, _c;
    const source = this.analyzer.getSource();
    const declaredVariables = this.analyzer.declaredVariables;
    const sideEffectPolicy = options.disallowSideEffectInitializers;
    const sideEffectMode = typeof sideEffectPolicy === "object" && sideEffectPolicy !== null ? (_a = sideEffectPolicy.mode) != null ? _a : "strict" : "strict";
    const canDisallow = Boolean(sideEffectPolicy);
    const assignmentTarget = node.type === "AssignmentExpression" ? node : node.type === "ExpressionStatement" && node.expression.type === "AssignmentExpression" ? node.expression : null;
    const init = assignmentTarget && assignmentTarget.operator === "=" ? assignmentTarget.right : node.type === "VariableDeclarator" ? node.init : null;
    const forceRemove = canDisallow && init && !this.isSafeInitializer(init, sideEffectMode);
    const initializerFallback = this.getInitializerFallback(init);
    let initSource = initializerFallback;
    if (!forceRemove && init) {
      if (!preDeclared && init.type === "Identifier" && !declaredVariables.has(init.name)) {
        initSource = initializerFallback;
      } else {
        const left = assignmentTarget == null ? void 0 : assignmentTarget.left;
        if ((left == null ? void 0 : left.type) === "MemberExpression" && init) {
          if (canDisallow && left.object.type === "Identifier" && init.type !== "FunctionExpression" && init.type !== "ArrowFunctionExpression" && init.type !== "LogicalExpression") {
            return `${indent}// Skipped ${memberToString(left, source)} assignment.`;
          }
        }
        initSource = ((_b = extractNodeSource(init, source)) == null ? void 0 : _b.trim().replace(/;\s*$/, "")) || "kk";
      }
    }
    if (!forceRemove && init && init.type === "SequenceExpression" && !initSource.startsWith("(")) {
      initSource = `(${initSource})`;
    }
    const idName = node.type === "VariableDeclarator" && node.id.type === "Identifier" ? node.id.name : assignmentTarget && assignmentTarget.left.type === "Identifier" ? assignmentTarget.left.name : (assignmentTarget == null ? void 0 : assignmentTarget.type) === "AssignmentExpression" ? (_c = memberToString(assignmentTarget.left, source)) == null ? void 0 : _c.trim() : "unknown";
    const assignmentExpression = `${idName} = ${initSource};`;
    if (node.type === "VariableDeclarator" && node.init && !preDeclared) {
      return `${indent}var ${assignmentExpression}`;
    }
    return `${indent}${assignmentExpression}`;
  }
  /**
   * Processes extracted matches from the analyzer, handles dependencies, predeclares
   * variables as needed, and generates an IIFE-wrapped output string containing the
   * code snippets and exported variables.
   * @param config - Configuration options for the emitter.
   */
  buildScript(config) {
    var _a, _b;
    const { maxDepth = Infinity, forceVarPredeclaration = false, exportRawValues = false, rawValueOnly: skipEmitFor = [] } = config;
    const extractions = this.analyzer.getExtractedMatches();
    const seen = new Set(extractions.map((e) => {
      var _a2;
      return ((_a2 = e.metadata) == null ? void 0 : _a2.name) || "";
    }));
    const snippets = [];
    const predeclaredVarSet = /* @__PURE__ */ new Set();
    const exported = /* @__PURE__ */ new Map();
    const exportedRawValues = {};
    function registerPredeclaredVar(name) {
      if (!name || name.includes("."))
        return;
      predeclaredVarSet.add(name);
    }
    __name(registerPredeclaredVar, "registerPredeclaredVar");
    const visit = /* @__PURE__ */ __name((metadata, depth = 0) => {
      if (!metadata || depth > maxDepth)
        return;
      for (const dependency of metadata.dependencies) {
        if (seen.has(dependency))
          continue;
        seen.add(dependency);
        const dependencyMetadata = this.analyzer.declaredVariables.get(dependency);
        if (!dependencyMetadata)
          continue;
        const shouldPredeclare = forceVarPredeclaration || dependencyMetadata.predeclared;
        if (shouldPredeclare) {
          registerPredeclaredVar(dependency);
        }
        if (!dependency.includes(".")) {
          visit(dependencyMetadata, depth + 1);
        }
        snippets.push(this.renderNode(dependencyMetadata.node, shouldPredeclare, config));
      }
    }, "visit");
    for (const extraction of extractions) {
      const fname = extraction.config.friendlyName;
      const shouldSkip = fname && skipEmitFor.includes(fname);
      if (extraction.metadata) {
        if (!shouldSkip)
          snippets.push(`${indent}//#region --- start [${fname || "Unknown"}] ---`);
        const shouldPredeclare = (forceVarPredeclaration || extraction.metadata.predeclared) && !shouldSkip;
        if (shouldPredeclare) {
          registerPredeclaredVar(extraction.metadata.name);
        }
        if (extraction.config.collectDependencies && !shouldSkip) {
          visit(extraction.metadata);
        }
        if (extraction.matchContext && fname) {
          exported.set(fname, extraction.matchContext);
          if (exportRawValues) {
            const ctx = extraction.matchContext;
            const src = this.analyzer.getSource();
            let rawValue = null;
            if (ctx.type === "Property") {
              rawValue = extractNodeSource(ctx.value, src);
            } else if (ctx.type === "Identifier") {
              rawValue = ctx.name;
            } else {
              rawValue = extractNodeSource(ctx, src);
            }
            exportedRawValues[fname] = rawValue;
          }
        }
        if (!shouldSkip) {
          snippets.push(this.renderNode(extraction.metadata.node, shouldPredeclare, config));
          snippets.push(`${indent}//#endregion --- end [${fname || "Unknown"}] ---
`);
        }
      }
    }
    const output = [];
    output.push("const window = Object.assign({}, globalThis);");
    output.push("const document = {};");
    output.push("const self = window;\n");
    output.push(`const exportedVars = (function(${this.analyzer.iifeParamName}) {`);
    if (predeclaredVarSet.size > 0) {
      output.push(`${indent}var ${Array.from(predeclaredVarSet).join(", ")};
`);
    }
    output.push(snippets.join("\n"));
    const exportedVars = [];
    for (const [friendlyName, node] of exported) {
      let currentFunctionNode = null;
      if (node.type === "Identifier") {
        const decl = this.analyzer.declaredVariables.get(node.name);
        if (((_a = decl == null ? void 0 : decl.node) == null ? void 0 : _a.type) === "VariableDeclarator" && ((_b = decl.node.init) == null ? void 0 : _b.type) === "FunctionExpression") {
          currentFunctionNode = decl.node;
        }
      } else if (node.type === "CallExpression") {
        currentFunctionNode = node;
      }
      if (currentFunctionNode) {
        const wrapper = createWrapperFunction(this.analyzer, friendlyName, currentFunctionNode);
        if (wrapper) {
          output.push(`${wrapper}
`);
          exportedVars.push(friendlyName);
        }
      }
    }
    if (exportRawValues) {
      const rawJson = JSON.stringify(exportedRawValues, null, indent.length);
      const rawJsonLines = rawJson.split("\n");
      const formattedRawJson = `${rawJsonLines[0]}
${rawJsonLines.slice(1).map((line) => indent + line).join("\n")}`;
      output.push(`${indent}const rawValues = ${formattedRawJson};
`);
      exportedVars.push("rawValues");
    }
    output.push(`${indent}return { ${exportedVars.join(", ")} };`);
    output.push("})({});\n");
    return {
      output: output.join("\n"),
      exported: exportedVars,
      exportedRawValues: exportRawValues ? exportedRawValues : void 0
    };
  }
};
__name(_JsExtractor, "JsExtractor");
var JsExtractor = _JsExtractor;

// dist/src/parser/classes/actions/OpenPopupAction.js
var _OpenPopupAction = class _OpenPopupAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "popup");
    __publicField(this, "popup_type");
    this.popup = parser_exports.parseItem(data.popup);
    this.popup_type = data.popupType;
  }
};
__name(_OpenPopupAction, "OpenPopupAction");
__publicField(_OpenPopupAction, "type", "OpenPopupAction");
var OpenPopupAction = _OpenPopupAction;

// dist/src/parser/classes/Button.js
var _Button = class _Button extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "label");
    __publicField(this, "tooltip");
    __publicField(this, "style");
    __publicField(this, "size");
    __publicField(this, "icon_type");
    __publicField(this, "is_disabled");
    __publicField(this, "target_id");
    __publicField(this, "endpoint");
    __publicField(this, "accessibility");
    if (Reflect.has(data, "text"))
      this.text = new Text2(data.text).toString();
    if (Reflect.has(data, "accessibility") && Reflect.has(data.accessibility, "label")) {
      this.label = data.accessibility.label;
    }
    if ("accessibilityData" in data && "accessibilityData" in data.accessibilityData) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibilityData.accessibilityData)
      };
    }
    if (Reflect.has(data, "tooltip"))
      this.tooltip = data.tooltip;
    if (Reflect.has(data, "style"))
      this.style = data.style;
    if (Reflect.has(data, "size"))
      this.size = data.size;
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType"))
      this.icon_type = data.icon.iconType;
    if (Reflect.has(data, "isDisabled"))
      this.is_disabled = data.isDisabled;
    if (Reflect.has(data, "targetId"))
      this.target_id = data.targetId;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint || data.serviceEndpoint || data.command);
  }
};
__name(_Button, "Button");
__publicField(_Button, "type", "Button");
var Button = _Button;

// dist/src/parser/classes/DropdownItem.js
var _DropdownItem = class _DropdownItem extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "label");
    __publicField(this, "selected");
    __publicField(this, "value");
    __publicField(this, "icon_type");
    __publicField(this, "description");
    __publicField(this, "endpoint");
    this.label = new Text2(data.label).toString();
    this.selected = !!data.isSelected;
    if (Reflect.has(data, "int32Value")) {
      this.value = data.int32Value;
    } else if (data.stringValue) {
      this.value = data.stringValue;
    }
    if (Reflect.has(data, "onSelectCommand")) {
      this.endpoint = new NavigationEndpoint(data.onSelectCommand);
    }
    if (Reflect.has(data, "icon")) {
      this.icon_type = (_a = data.icon) == null ? void 0 : _a.iconType;
    }
    if (Reflect.has(data, "descriptionText")) {
      this.description = new Text2(data.descriptionText);
    }
  }
};
__name(_DropdownItem, "DropdownItem");
__publicField(_DropdownItem, "type", "DropdownItem");
var DropdownItem = _DropdownItem;

// dist/src/parser/classes/Dropdown.js
var _Dropdown = class _Dropdown extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    __publicField(this, "entries");
    this.label = data.label || "";
    this.entries = parser_exports.parseArray(data.entries, DropdownItem);
  }
};
__name(_Dropdown, "Dropdown");
__publicField(_Dropdown, "type", "Dropdown");
var Dropdown = _Dropdown;

// dist/src/parser/classes/CreatePlaylistDialog.js
var _CreatePlaylistDialog = class _CreatePlaylistDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "title_placeholder");
    __publicField(this, "privacy_option");
    __publicField(this, "cancel_button");
    __publicField(this, "create_button");
    this.title = new Text2(data.dialogTitle).toString();
    this.title_placeholder = data.titlePlaceholder || "";
    this.privacy_option = parser_exports.parseItem(data.privacyOption, Dropdown);
    this.create_button = parser_exports.parseItem(data.cancelButton, Button);
    this.cancel_button = parser_exports.parseItem(data.cancelButton, Button);
  }
};
__name(_CreatePlaylistDialog, "CreatePlaylistDialog");
__publicField(_CreatePlaylistDialog, "type", "CreatePlaylistDialog");
var CreatePlaylistDialog = _CreatePlaylistDialog;

// dist/src/parser/classes/commands/CommandExecutorCommand.js
var _CommandExecutorCommand = class _CommandExecutorCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "commands");
    this.commands = parser_exports.parseCommands(data.commands);
  }
};
__name(_CommandExecutorCommand, "CommandExecutorCommand");
__publicField(_CommandExecutorCommand, "type", "CommandExecutorCommand");
var CommandExecutorCommand = _CommandExecutorCommand;

// dist/src/parser/classes/NavigationEndpoint.js
var _NavigationEndpoint = class _NavigationEndpoint extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    super();
    __publicField(this, "name");
    __publicField(this, "payload");
    __publicField(this, "dialog");
    __publicField(this, "modal");
    __publicField(this, "open_popup");
    __publicField(this, "next_endpoint");
    __publicField(this, "metadata");
    __publicField(this, "command");
    __publicField(this, "commands");
    if (data) {
      if (data.serialCommand || data.parallelCommand) {
        const raw_command = data.serialCommand || data.parallelCommand;
        this.commands = raw_command.commands.map((command) => new _NavigationEndpoint(command));
      }
      if (data.innertubeCommand || data.command || data.performOnceCommand) {
        data = data.innertubeCommand || data.command || data.performOnceCommand;
      }
    }
    this.command = parser_exports.parseCommand(data);
    if (Reflect.has(data || {}, "openPopupAction"))
      this.open_popup = new OpenPopupAction(data.openPopupAction);
    this.name = Object.keys(data || {}).find((item) => item.endsWith("Endpoint") || item.endsWith("Command"));
    this.payload = this.name ? Reflect.get(data, this.name) : {};
    if (Reflect.has(this.payload, "dialog") || Reflect.has(this.payload, "content")) {
      this.dialog = parser_exports.parseItem(this.payload.dialog || this.payload.content);
    }
    if (Reflect.has(this.payload, "modal")) {
      this.modal = parser_exports.parseItem(this.payload.modal);
    }
    if (Reflect.has(this.payload, "nextEndpoint")) {
      this.next_endpoint = new _NavigationEndpoint(this.payload.nextEndpoint);
    }
    if (data == null ? void 0 : data.serviceEndpoint) {
      data = data.serviceEndpoint;
    }
    this.metadata = {};
    if ((_b = (_a = data == null ? void 0 : data.commandMetadata) == null ? void 0 : _a.webCommandMetadata) == null ? void 0 : _b.url) {
      this.metadata.url = data.commandMetadata.webCommandMetadata.url;
    }
    if ((_d = (_c = data == null ? void 0 : data.commandMetadata) == null ? void 0 : _c.webCommandMetadata) == null ? void 0 : _d.webPageType) {
      this.metadata.page_type = data.commandMetadata.webCommandMetadata.webPageType;
    }
    if ((_f = (_e = data == null ? void 0 : data.commandMetadata) == null ? void 0 : _e.webCommandMetadata) == null ? void 0 : _f.apiUrl) {
      this.metadata.api_url = data.commandMetadata.webCommandMetadata.apiUrl.replace("/youtubei/v1/", "");
    } else if (this.name) {
      this.metadata.api_url = this.getPath(this.name);
    }
    if ((_h = (_g = data == null ? void 0 : data.commandMetadata) == null ? void 0 : _g.webCommandMetadata) == null ? void 0 : _h.sendPost) {
      this.metadata.send_post = data.commandMetadata.webCommandMetadata.sendPost;
    }
    if (data == null ? void 0 : data.createPlaylistEndpoint) {
      if (data == null ? void 0 : data.createPlaylistEndpoint.createPlaylistDialog) {
        this.dialog = parser_exports.parseItem(data == null ? void 0 : data.createPlaylistEndpoint.createPlaylistDialog, CreatePlaylistDialog);
      }
    }
  }
  /**
   * Sometimes InnerTube does not return an API url, in that case the library should set it based on the name of the payload object.
   * @deprecated This should be removed in the future.
   */
  getPath(name) {
    switch (name) {
      case "browseEndpoint":
        return "/browse";
      case "watchEndpoint":
      case "reelWatchEndpoint":
        return "/player";
      case "searchEndpoint":
        return "/search";
      case "watchPlaylistEndpoint":
        return "/next";
      case "liveChatItemContextMenuEndpoint":
        return "/live_chat/get_item_context_menu";
    }
  }
  call(actions, args) {
    if (!actions)
      throw new Error("An API caller must be provided");
    if (this.command) {
      let command = this.command;
      if (command.is(CommandExecutorCommand)) {
        command = command.commands.at(-1);
      }
      return actions.execute(command.getApiPath(), { ...command.buildRequest(), ...args });
    }
    if (!this.metadata.api_url)
      throw new Error("Expected an api_url, but none was found.");
    return actions.execute(this.metadata.api_url, { ...this.payload, ...args });
  }
  toURL() {
    if (!this.metadata.url)
      return void 0;
    if (!this.metadata.page_type)
      return void 0;
    return this.metadata.page_type === "WEB_PAGE_TYPE_UNKNOWN" ? this.metadata.url : `https://www.youtube.com${this.metadata.url}`;
  }
};
__name(_NavigationEndpoint, "NavigationEndpoint");
__publicField(_NavigationEndpoint, "type", "NavigationEndpoint");
var NavigationEndpoint = _NavigationEndpoint;

// dist/src/parser/classes/misc/Thumbnail.js
var _Thumbnail = class _Thumbnail {
  constructor(data) {
    __publicField(this, "url");
    __publicField(this, "width");
    __publicField(this, "height");
    this.url = data.url;
    this.width = data.width;
    this.height = data.height;
  }
  /**
   * Get thumbnails from response object.
   */
  static fromResponse(data) {
    if (!data)
      return [];
    let thumbnail_data;
    if (data.thumbnails) {
      thumbnail_data = data.thumbnails;
    } else if (data.sources) {
      thumbnail_data = data.sources;
    }
    if (thumbnail_data) {
      return thumbnail_data.map((x) => new _Thumbnail(x)).sort((a, b) => b.width - a.width);
    }
    return [];
  }
};
__name(_Thumbnail, "Thumbnail");
var Thumbnail = _Thumbnail;

// dist/src/parser/classes/misc/EmojiRun.js
var _EmojiRun = class _EmojiRun {
  constructor(data) {
    __publicField(this, "text");
    __publicField(this, "emoji");
    var _a, _b, _c, _d, _e, _f;
    this.text = ((_a = data.emoji) == null ? void 0 : _a.emojiId) || ((_c = (_b = data.emoji) == null ? void 0 : _b.shortcuts) == null ? void 0 : _c[0]) || data.text || "";
    this.emoji = {
      emoji_id: data.emoji.emojiId,
      shortcuts: ((_d = data.emoji) == null ? void 0 : _d.shortcuts) || [],
      search_terms: ((_e = data.emoji) == null ? void 0 : _e.searchTerms) || [],
      image: Thumbnail.fromResponse(data.emoji.image),
      is_custom: !!((_f = data.emoji) == null ? void 0 : _f.isCustomEmoji)
    };
  }
  toString() {
    return this.text;
  }
  toHTML() {
    const escaped_text = escape(this.text);
    return `<img src="${this.emoji.image[0].url}" alt="${escaped_text}" title="${escaped_text}" style="display: inline-block; vertical-align: text-top; height: var(--yt-emoji-size, 1rem); width: var(--yt-emoji-size, 1rem);" loading="lazy" crossorigin="anonymous" />`;
  }
};
__name(_EmojiRun, "EmojiRun");
var EmojiRun = _EmojiRun;

// dist/src/parser/classes/misc/TextRun.js
var _TextRun = class _TextRun {
  constructor(data) {
    __publicField(this, "text");
    __publicField(this, "text_color");
    __publicField(this, "endpoint");
    __publicField(this, "bold");
    __publicField(this, "bracket");
    __publicField(this, "dark_mode_text_color");
    __publicField(this, "deemphasize");
    __publicField(this, "italics");
    __publicField(this, "strikethrough");
    __publicField(this, "error_underline");
    __publicField(this, "underline");
    __publicField(this, "font_face");
    __publicField(this, "attachment");
    this.text = data.text;
    this.bold = Boolean(data.bold);
    this.bracket = Boolean(data.bracket);
    this.italics = Boolean(data.italics);
    this.strikethrough = Boolean(data.strikethrough);
    this.error_underline = Boolean(data.error_underline);
    this.underline = Boolean(data.underline);
    this.deemphasize = Boolean(data.deemphasize);
    if ("textColor" in data) {
      this.text_color = data.textColor;
    }
    if ("navigationEndpoint" in data) {
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    }
    if ("darkModeTextColor" in data) {
      this.dark_mode_text_color = data.darkModeTextColor;
    }
    if ("fontFace" in data) {
      this.font_face = data.fontFace;
    }
    this.attachment = data.attachment;
  }
  toString() {
    return this.text;
  }
  toHTML() {
    var _a;
    const tags = [];
    if (this.bold)
      tags.push("b");
    if (this.italics)
      tags.push("i");
    if (this.strikethrough)
      tags.push("s");
    if (this.deemphasize)
      tags.push("small");
    if (this.underline)
      tags.push("u");
    if (this.error_underline)
      tags.push("u");
    if (!((_a = this.text) == null ? void 0 : _a.length))
      return "";
    const escaped_text = escape(this.text);
    const styled_text = tags.map((tag) => `<${tag}>`).join("") + escaped_text + tags.map((tag) => `</${tag}>`).join("");
    const wrapped_text = `<span style="white-space: pre-wrap;">${styled_text}</span>`;
    if (this.attachment) {
      if (this.attachment.element.type.imageType.image.sources.length) {
        if (this.endpoint) {
          const { url } = this.attachment.element.type.imageType.image.sources[0];
          let image_el = "";
          if (url) {
            image_el = `<img src="${url}" style="vertical-align: middle; height: ${this.attachment.element.properties.layoutProperties.height.value}px; width: ${this.attachment.element.properties.layoutProperties.width.value}px;" alt="">`;
          }
          const nav_url = this.endpoint.toURL();
          if (nav_url)
            return `<a href="${nav_url}" class="yt-ch-link">${image_el}${wrapped_text}</a>`;
        }
      }
    }
    if (this.endpoint) {
      const url = this.endpoint.toURL();
      if (url)
        return `<a href="${url}">${wrapped_text}</a>`;
    }
    return wrapped_text;
  }
};
__name(_TextRun, "TextRun");
var TextRun = _TextRun;

// dist/src/parser/classes/misc/Text.js
function escape(text) {
  return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
}
__name(escape, "escape");
var TAG = "Text";
var _Text = class _Text {
  constructor(data) {
    /**
     * The plain text content.
     */
    __publicField(this, "text");
    /**
     * Individual text segments with their formatting.
     */
    __publicField(this, "runs");
    /**
     * Navigation endpoint associated with this text.
     */
    __publicField(this, "endpoint");
    /**
     * Accessibility data associated with this text.
     */
    __publicField(this, "accessibility");
    /**
     * Indicates if the text is right-to-left.
     */
    __publicField(this, "rtl");
    if (this.isRunsData(data)) {
      this.runs = data.runs.map((run) => run.emoji ? new EmojiRun(run) : new TextRun(run));
      this.text = this.runs.map((run) => run.text).join("");
    } else {
      this.text = data == null ? void 0 : data.simpleText;
    }
    if (this.isObject(data) && "accessibility" in data && "accessibilityData" in data.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibility.accessibilityData)
      };
    }
    this.rtl = !!(data == null ? void 0 : data.rtl);
    this.parseEndpoint(data);
  }
  isRunsData(data) {
    return this.isObject(data) && Reflect.has(data, "runs") && Array.isArray(data.runs);
  }
  parseEndpoint(data) {
    var _a, _b, _c;
    if (!this.isObject(data))
      return;
    if ("navigationEndpoint" in data) {
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    } else if ("titleNavigationEndpoint" in data) {
      this.endpoint = new NavigationEndpoint(data.titleNavigationEndpoint);
    } else if ((_b = (_a = this.runs) == null ? void 0 : _a[0]) == null ? void 0 : _b.endpoint) {
      this.endpoint = ((_c = this.runs) == null ? void 0 : _c[0]).endpoint;
    }
  }
  isObject(data) {
    return typeof data === "object" && data !== null;
  }
  static fromAttributed(data) {
    var _a;
    const { content, commandRuns: command_runs, attachmentRuns: attachment_runs } = data;
    const runs = [
      {
        text: content,
        startIndex: 0
      }
    ];
    const style_runs = (_a = data.styleRuns) == null ? void 0 : _a.map((run) => {
      var _a2, _b;
      return {
        ...run,
        startIndex: (_a2 = run.startIndex) != null ? _a2 : 0,
        length: (_b = run.length) != null ? _b : content.length
      };
    });
    if (style_runs == null ? void 0 : style_runs.length)
      this.processStyleRuns(runs, style_runs, data);
    if (command_runs == null ? void 0 : command_runs.length)
      this.processCommandRuns(runs, command_runs, data);
    if (attachment_runs == null ? void 0 : attachment_runs.length)
      this.processAttachmentRuns(runs, attachment_runs, data);
    return new _Text({ runs });
  }
  static processStyleRuns(runs, style_runs, data) {
    for (const style_run of style_runs) {
      if (style_run.italic || style_run.strikethrough === "LINE_STYLE_SINGLE" || style_run.weightLabel === "FONT_WEIGHT_MEDIUM" || style_run.weightLabel === "FONT_WEIGHT_BOLD") {
        const matching_run = findMatchingRun(runs, style_run);
        if (!matching_run) {
          Log_exports.warn(TAG, "Unable to find matching run for style run. Skipping...", {
            style_run,
            input_data: data,
            // For performance reasons, web browser consoles only expand an object, when the user clicks on it,
            // So if we log the original runs object, it might have changed by the time the user looks at it.
            // Deep clone, so that we log the exact state of the runs at this point.
            parsed_runs: JSON.parse(JSON.stringify(runs))
          });
          continue;
        }
        insertSubRun(runs, matching_run, style_run, {
          bold: style_run.weightLabel === "FONT_WEIGHT_MEDIUM" || style_run.weightLabel === "FONT_WEIGHT_BOLD",
          italics: style_run.italic,
          strikethrough: style_run.strikethrough === "LINE_STYLE_SINGLE"
        });
      } else {
        Log_exports.debug(TAG, "Skipping style run as it is doesn't have any information that we parse.", {
          style_run,
          input_data: data
        });
      }
    }
  }
  static processCommandRuns(runs, command_runs, data) {
    for (const command_run of command_runs) {
      if (command_run.onTap) {
        const matching_run = findMatchingRun(runs, command_run);
        if (!matching_run) {
          Log_exports.warn(TAG, "Unable to find matching run for command run. Skipping...", {
            command_run,
            input_data: data,
            // For performance reasons, web browser consoles only expand an object, when the user clicks on it,
            // So if we log the original runs object, it might have changed by the time the user looks at it.
            // Deep clone, so that we log the exact state of the runs at this point.
            parsed_runs: JSON.parse(JSON.stringify(runs))
          });
          continue;
        }
        insertSubRun(runs, matching_run, command_run, {
          navigationEndpoint: command_run.onTap
        });
      } else {
        Log_exports.debug(TAG, 'Skipping command run as it is missing the "doTap" property.', {
          command_run,
          input_data: data
        });
      }
    }
  }
  static processAttachmentRuns(runs, attachment_runs, data) {
    var _a, _b, _c;
    for (const attachment_run of attachment_runs) {
      const matching_run = findMatchingRun(runs, attachment_run);
      if (!matching_run) {
        Log_exports.warn(TAG, "Unable to find matching run for attachment run. Skipping...", {
          attachment_run,
          input_data: data,
          // For performance reasons, web browser consoles only expand an object, when the user clicks on it,
          // So if we log the original runs object, it might have changed by the time the user looks at it.
          // Deep clone, so that we log the exact state of the runs at this point.
          parsed_runs: JSON.parse(JSON.stringify(runs))
        });
        continue;
      }
      if (attachment_run.length === 0) {
        matching_run.attachment = attachment_run;
      } else {
        const offset_start_index = attachment_run.startIndex - matching_run.startIndex;
        const text = matching_run.text.substring(offset_start_index, offset_start_index + attachment_run.length);
        const is_custom_emoji = /^:[^:]+:$/.test(text);
        if (((_c = (_b = (_a = attachment_run.element) == null ? void 0 : _a.type) == null ? void 0 : _b.imageType) == null ? void 0 : _c.image) && (is_custom_emoji || new RegExp("^(?:\\p{Emoji}|\\u200d)+$", "u").test(text))) {
          const emoji = {
            image: attachment_run.element.type.imageType.image,
            isCustomEmoji: is_custom_emoji,
            shortcuts: is_custom_emoji ? [text] : void 0
          };
          insertSubRun(runs, matching_run, attachment_run, { emoji });
        } else {
          insertSubRun(runs, matching_run, attachment_run, {
            attachment: attachment_run
          });
        }
      }
    }
  }
  /**
   * Converts the text to HTML.
   * @returns The HTML.
   */
  toHTML() {
    return this.runs ? this.runs.map((run) => run.toHTML()).join("") : this.text;
  }
  /**
   * Checks if the text is empty.
   * @returns Whether the text is empty.
   */
  isEmpty() {
    return this.text === void 0;
  }
  /**
   * Converts the text to a string.
   * @returns The text.
   */
  toString() {
    return this.text || "N/A";
  }
};
__name(_Text, "Text");
var Text2 = _Text;
function findMatchingRun(runs, response_run) {
  return runs.find((run) => {
    return run.startIndex <= response_run.startIndex && response_run.startIndex + response_run.length <= run.startIndex + run.text.length;
  });
}
__name(findMatchingRun, "findMatchingRun");
function insertSubRun(runs, original_run, response_run, properties_to_add) {
  const replace_index = runs.indexOf(original_run);
  const replacement_runs = [];
  const offset_start_index = response_run.startIndex - original_run.startIndex;
  if (response_run.startIndex > original_run.startIndex) {
    replacement_runs.push({
      ...original_run,
      text: original_run.text.substring(0, offset_start_index)
    });
  }
  replacement_runs.push({
    ...original_run,
    text: original_run.text.substring(offset_start_index, offset_start_index + response_run.length),
    startIndex: response_run.startIndex,
    ...properties_to_add
  });
  if (response_run.startIndex + response_run.length < original_run.startIndex + original_run.text.length) {
    replacement_runs.push({
      ...original_run,
      text: original_run.text.substring(offset_start_index + response_run.length),
      startIndex: response_run.startIndex + response_run.length
    });
  }
  runs.splice(replace_index, 1, ...replacement_runs);
}
__name(insertSubRun, "insertSubRun");

// dist/src/parser/classes/ChannelExternalLinkView.js
var _ChannelExternalLinkView = class _ChannelExternalLinkView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "link");
    __publicField(this, "favicon");
    this.title = Text2.fromAttributed(data.title);
    this.link = Text2.fromAttributed(data.link);
    this.favicon = Thumbnail.fromResponse(data.favicon);
  }
};
__name(_ChannelExternalLinkView, "ChannelExternalLinkView");
__publicField(_ChannelExternalLinkView, "type", "ChannelExternalLinkView");
var ChannelExternalLinkView = _ChannelExternalLinkView;

// dist/src/parser/classes/AboutChannelView.js
var _AboutChannelView = class _AboutChannelView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "description");
    __publicField(this, "description_label");
    __publicField(this, "country");
    __publicField(this, "custom_links_label");
    __publicField(this, "subscriber_count");
    __publicField(this, "view_count");
    __publicField(this, "joined_date");
    __publicField(this, "canonical_channel_url");
    __publicField(this, "channel_id");
    __publicField(this, "additional_info_label");
    __publicField(this, "custom_url_on_tap");
    __publicField(this, "video_count");
    __publicField(this, "sign_in_for_business_email");
    __publicField(this, "links");
    if (Reflect.has(data, "description")) {
      this.description = data.description;
    }
    if (Reflect.has(data, "descriptionLabel")) {
      this.description_label = Text2.fromAttributed(data.descriptionLabel);
    }
    if (Reflect.has(data, "country")) {
      this.country = data.country;
    }
    if (Reflect.has(data, "customLinksLabel")) {
      this.custom_links_label = Text2.fromAttributed(data.customLinksLabel);
    }
    if (Reflect.has(data, "subscriberCountText")) {
      this.subscriber_count = data.subscriberCountText;
    }
    if (Reflect.has(data, "viewCountText")) {
      this.view_count = data.viewCountText;
    }
    if (Reflect.has(data, "joinedDateText")) {
      this.joined_date = Text2.fromAttributed(data.joinedDateText);
    }
    if (Reflect.has(data, "canonicalChannelUrl")) {
      this.canonical_channel_url = data.canonicalChannelUrl;
    }
    if (Reflect.has(data, "channelId")) {
      this.channel_id = data.channelId;
    }
    if (Reflect.has(data, "additionalInfoLabel")) {
      this.additional_info_label = Text2.fromAttributed(data.additionalInfoLabel);
    }
    if (Reflect.has(data, "customUrlOnTap")) {
      this.custom_url_on_tap = new NavigationEndpoint(data.customUrlOnTap);
    }
    if (Reflect.has(data, "videoCountText")) {
      this.video_count = data.videoCountText;
    }
    if (Reflect.has(data, "signInForBusinessEmail")) {
      this.sign_in_for_business_email = Text2.fromAttributed(data.signInForBusinessEmail);
    }
    if (Reflect.has(data, "links")) {
      this.links = parser_exports.parseArray(data.links, ChannelExternalLinkView);
    } else {
      this.links = [];
    }
  }
};
__name(_AboutChannelView, "AboutChannelView");
__publicField(_AboutChannelView, "type", "AboutChannelView");
var AboutChannelView = _AboutChannelView;

// dist/src/parser/classes/AboutChannel.js
var _AboutChannel = class _AboutChannel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "metadata");
    __publicField(this, "share_channel");
    this.metadata = parser_exports.parseItem(data.metadata, AboutChannelView);
    this.share_channel = parser_exports.parseItem(data.shareChannel, Button);
  }
};
__name(_AboutChannel, "AboutChannel");
__publicField(_AboutChannel, "type", "AboutChannel");
var AboutChannel = _AboutChannel;

// dist/src/parser/classes/AccountChannel.js
var _AccountChannel = class _AccountChannel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    this.title = new Text2(data.title);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
  }
};
__name(_AccountChannel, "AccountChannel");
__publicField(_AccountChannel, "type", "AccountChannel");
var AccountChannel = _AccountChannel;

// dist/src/parser/classes/AccountItem.js
var _AccountItem = class _AccountItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "account_name");
    __publicField(this, "account_photo");
    __publicField(this, "is_selected");
    __publicField(this, "is_disabled");
    __publicField(this, "has_channel");
    __publicField(this, "endpoint");
    __publicField(this, "account_byline");
    __publicField(this, "channel_handle");
    this.account_name = new Text2(data.accountName);
    this.account_photo = Thumbnail.fromResponse(data.accountPhoto);
    this.is_selected = !!data.isSelected;
    this.is_disabled = !!data.isDisabled;
    this.has_channel = !!data.hasChannel;
    this.endpoint = new NavigationEndpoint(data.serviceEndpoint);
    this.account_byline = new Text2(data.accountByline);
    this.channel_handle = new Text2(data.channelHandle);
  }
};
__name(_AccountItem, "AccountItem");
__publicField(_AccountItem, "type", "AccountItem");
var AccountItem = _AccountItem;

// dist/src/parser/classes/AccountItemSectionHeader.js
var _AccountItemSectionHeader = class _AccountItemSectionHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_AccountItemSectionHeader, "AccountItemSectionHeader");
__publicField(_AccountItemSectionHeader, "type", "AccountItemSectionHeader");
var AccountItemSectionHeader = _AccountItemSectionHeader;

// dist/src/parser/classes/CompactLink.js
var _CompactLink = class _CompactLink extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "endpoint");
    __publicField(this, "style");
    __publicField(this, "icon_type");
    __publicField(this, "secondary_icon_type");
    this.title = new Text2(data.title).toString();
    if ("subtitle" in data)
      this.subtitle = new Text2(data.subtitle);
    if ("icon" in data && "iconType" in data.icon)
      this.icon_type = data.icon.iconType;
    if ("secondaryIcon" in data && "iconType" in data.secondaryIcon)
      this.secondary_icon_type = data.secondaryIcon.iconType;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint || data.serviceEndpoint);
    this.style = data.style;
  }
};
__name(_CompactLink, "CompactLink");
__publicField(_CompactLink, "type", "CompactLink");
var CompactLink = _CompactLink;

// dist/src/parser/classes/AccountItemSection.js
var _AccountItemSection = class _AccountItemSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    __publicField(this, "header");
    this.contents = parser_exports.parseArray(data.contents, [AccountItem, CompactLink]);
    this.header = parser_exports.parseItem(data.header, AccountItemSectionHeader);
  }
};
__name(_AccountItemSection, "AccountItemSection");
__publicField(_AccountItemSection, "type", "AccountItemSection");
var AccountItemSection = _AccountItemSection;

// dist/src/parser/classes/AccountSectionList.js
var _AccountSectionList = class _AccountSectionList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    __publicField(this, "footers");
    this.contents = parser_exports.parseArray(data.contents, AccountItemSection);
    this.footers = parser_exports.parseArray(data.footers, AccountChannel);
  }
};
__name(_AccountSectionList, "AccountSectionList");
__publicField(_AccountSectionList, "type", "AccountSectionList");
var AccountSectionList = _AccountSectionList;

// dist/src/parser/classes/actions/AppendContinuationItemsAction.js
var _AppendContinuationItemsAction = class _AppendContinuationItemsAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    __publicField(this, "target");
    this.contents = parser_exports.parseArray(data.continuationItems);
    this.target = data.target;
  }
};
__name(_AppendContinuationItemsAction, "AppendContinuationItemsAction");
__publicField(_AppendContinuationItemsAction, "type", "AppendContinuationItemsAction");
var AppendContinuationItemsAction = _AppendContinuationItemsAction;

// dist/src/parser/classes/actions/ChangeEngagementPanelVisibilityAction.js
var _ChangeEngagementPanelVisibilityAction = class _ChangeEngagementPanelVisibilityAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "target_id");
    __publicField(this, "visibility");
    this.target_id = data.targetId;
    this.visibility = data.visibility;
  }
};
__name(_ChangeEngagementPanelVisibilityAction, "ChangeEngagementPanelVisibilityAction");
__publicField(_ChangeEngagementPanelVisibilityAction, "type", "ChangeEngagementPanelVisibilityAction");
var ChangeEngagementPanelVisibilityAction = _ChangeEngagementPanelVisibilityAction;

// dist/src/parser/classes/menus/MultiPageMenu.js
var _MultiPageMenu = class _MultiPageMenu extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "sections");
    __publicField(this, "style");
    this.header = parser_exports.parseItem(data.header);
    this.sections = parser_exports.parseArray(data.sections);
    this.style = data.style;
  }
};
__name(_MultiPageMenu, "MultiPageMenu");
__publicField(_MultiPageMenu, "type", "MultiPageMenu");
var MultiPageMenu = _MultiPageMenu;

// dist/src/parser/classes/actions/GetMultiPageMenuAction.js
var _GetMultiPageMenuAction = class _GetMultiPageMenuAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "menu");
    this.menu = parser_exports.parseItem(data.menu, MultiPageMenu);
  }
};
__name(_GetMultiPageMenuAction, "GetMultiPageMenuAction");
__publicField(_GetMultiPageMenuAction, "type", "GetMultiPageMenuAction");
var GetMultiPageMenuAction = _GetMultiPageMenuAction;

// dist/src/parser/classes/actions/SendFeedbackAction.js
var _SendFeedbackAction = class _SendFeedbackAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "bucket");
    this.bucket = data.bucket;
  }
};
__name(_SendFeedbackAction, "SendFeedbackAction");
__publicField(_SendFeedbackAction, "type", "SendFeedbackAction");
var SendFeedbackAction = _SendFeedbackAction;

// dist/src/parser/classes/actions/SignalAction.js
var _SignalAction = class _SignalAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "signal");
    this.signal = data.signal;
  }
};
__name(_SignalAction, "SignalAction");
__publicField(_SignalAction, "type", "SignalAction");
var SignalAction = _SignalAction;

// dist/src/parser/classes/ChannelSwitcherPage.js
var _ChannelSwitcherPage = class _ChannelSwitcherPage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    this.header = parser_exports.parseItem(data.header);
    this.contents = parser_exports.parse(data.contents, true);
  }
};
__name(_ChannelSwitcherPage, "ChannelSwitcherPage");
__publicField(_ChannelSwitcherPage, "type", "ChannelSwitcherPage");
var ChannelSwitcherPage = _ChannelSwitcherPage;

// dist/src/parser/classes/actions/UpdateChannelSwitcherPageAction.js
var _UpdateChannelSwitcherPageAction = class _UpdateChannelSwitcherPageAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    const page = parser_exports.parseItem(data.page, ChannelSwitcherPage);
    if (page) {
      this.header = page.header;
      this.contents = page.contents;
    }
  }
};
__name(_UpdateChannelSwitcherPageAction, "UpdateChannelSwitcherPageAction");
__publicField(_UpdateChannelSwitcherPageAction, "type", "UpdateChannelSwitcherPageAction");
var UpdateChannelSwitcherPageAction = _UpdateChannelSwitcherPageAction;

// dist/src/parser/classes/SortFilterSubMenu.js
var _SortFilterSubMenu = class _SortFilterSubMenu extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    __publicField(this, "sub_menu_items");
    __publicField(this, "accessibility");
    if ("title" in data) {
      this.title = data.title;
    }
    if ("icon" in data) {
      this.icon_type = data.icon.iconType;
    }
    if ("tooltip" in data) {
      this.tooltip = data.tooltip;
    }
    if ("subMenuItems" in data) {
      this.sub_menu_items = data.subMenuItems.map((item) => {
        var _a, _b;
        return {
          title: item.title,
          selected: item.selected,
          continuation: (_b = (_a = item.continuation) == null ? void 0 : _a.reloadContinuationData) == null ? void 0 : _b.continuation,
          endpoint: new NavigationEndpoint(item.serviceEndpoint || item.navigationEndpoint),
          subtitle: item.subtitle || null
        };
      });
    }
    if ("accessibility" in data && "accessibilityData" in data.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    var _a, _b;
    return (_b = (_a = this.accessibility) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
};
__name(_SortFilterSubMenu, "SortFilterSubMenu");
__publicField(_SortFilterSubMenu, "type", "SortFilterSubMenu");
var SortFilterSubMenu = _SortFilterSubMenu;

// dist/src/parser/classes/TranscriptFooter.js
var _TranscriptFooter = class _TranscriptFooter extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "language_menu");
    this.language_menu = parser_exports.parseItem(data.languageMenu, SortFilterSubMenu);
  }
};
__name(_TranscriptFooter, "TranscriptFooter");
__publicField(_TranscriptFooter, "type", "TranscriptFooter");
var TranscriptFooter = _TranscriptFooter;

// dist/src/parser/classes/TranscriptSearchBox.js
var _TranscriptSearchBox = class _TranscriptSearchBox extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "formatted_placeholder");
    __publicField(this, "clear_button");
    __publicField(this, "endpoint");
    __publicField(this, "search_button");
    this.formatted_placeholder = new Text2(data.formattedPlaceholder);
    this.clear_button = parser_exports.parseItem(data.clearButton, Button);
    this.endpoint = new NavigationEndpoint(data.onTextChangeCommand);
    this.search_button = parser_exports.parseItem(data.searchButton, Button);
  }
};
__name(_TranscriptSearchBox, "TranscriptSearchBox");
__publicField(_TranscriptSearchBox, "type", "TranscriptSearchBox");
var TranscriptSearchBox = _TranscriptSearchBox;

// dist/src/parser/classes/TranscriptSectionHeader.js
var _TranscriptSectionHeader = class _TranscriptSectionHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "start_ms");
    __publicField(this, "end_ms");
    __publicField(this, "snippet");
    this.start_ms = data.startMs;
    this.end_ms = data.endMs;
    this.snippet = new Text2(data.snippet);
  }
};
__name(_TranscriptSectionHeader, "TranscriptSectionHeader");
__publicField(_TranscriptSectionHeader, "type", "TranscriptSectionHeader");
var TranscriptSectionHeader = _TranscriptSectionHeader;

// dist/src/parser/classes/TranscriptSegment.js
var _TranscriptSegment = class _TranscriptSegment extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "start_ms");
    __publicField(this, "end_ms");
    __publicField(this, "snippet");
    __publicField(this, "start_time_text");
    __publicField(this, "target_id");
    this.start_ms = data.startMs;
    this.end_ms = data.endMs;
    this.snippet = new Text2(data.snippet);
    this.start_time_text = new Text2(data.startTimeText);
    this.target_id = data.targetId;
  }
};
__name(_TranscriptSegment, "TranscriptSegment");
__publicField(_TranscriptSegment, "type", "TranscriptSegment");
var TranscriptSegment = _TranscriptSegment;

// dist/src/parser/classes/TranscriptSegmentList.js
var _TranscriptSegmentList = class _TranscriptSegmentList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "initial_segments");
    __publicField(this, "no_result_label");
    __publicField(this, "retry_label");
    __publicField(this, "touch_captions_enabled");
    this.initial_segments = parser_exports.parseArray(data.initialSegments, [TranscriptSegment, TranscriptSectionHeader]);
    this.no_result_label = new Text2(data.noResultLabel);
    this.retry_label = new Text2(data.retryLabel);
    this.touch_captions_enabled = data.touchCaptionsEnabled;
  }
};
__name(_TranscriptSegmentList, "TranscriptSegmentList");
__publicField(_TranscriptSegmentList, "type", "TranscriptSegmentList");
var TranscriptSegmentList = _TranscriptSegmentList;

// dist/src/parser/classes/TranscriptSearchPanel.js
var _TranscriptSearchPanel = class _TranscriptSearchPanel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "body");
    __publicField(this, "footer");
    __publicField(this, "target_id");
    this.header = parser_exports.parseItem(data.header, TranscriptSearchBox);
    this.body = parser_exports.parseItem(data.body, TranscriptSegmentList);
    this.footer = parser_exports.parseItem(data.footer, TranscriptFooter);
    this.target_id = data.targetId;
  }
};
__name(_TranscriptSearchPanel, "TranscriptSearchPanel");
__publicField(_TranscriptSearchPanel, "type", "TranscriptSearchPanel");
var TranscriptSearchPanel = _TranscriptSearchPanel;

// dist/src/parser/classes/Transcript.js
var _Transcript = class _Transcript extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data.content, TranscriptSearchPanel);
  }
};
__name(_Transcript, "Transcript");
__publicField(_Transcript, "type", "Transcript");
var Transcript = _Transcript;

// dist/src/parser/classes/actions/UpdateEngagementPanelAction.js
var _UpdateEngagementPanelAction = class _UpdateEngagementPanelAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "target_id");
    __publicField(this, "content");
    this.target_id = data.targetId;
    this.content = parser_exports.parseItem(data.content, Transcript);
  }
};
__name(_UpdateEngagementPanelAction, "UpdateEngagementPanelAction");
__publicField(_UpdateEngagementPanelAction, "type", "UpdateEngagementPanelAction");
var UpdateEngagementPanelAction = _UpdateEngagementPanelAction;

// dist/src/parser/classes/actions/UpdateSubscribeButtonAction.js
var _UpdateSubscribeButtonAction = class _UpdateSubscribeButtonAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "channel_id");
    __publicField(this, "subscribed");
    this.channel_id = data.channelId;
    this.subscribed = data.subscribed;
  }
};
__name(_UpdateSubscribeButtonAction, "UpdateSubscribeButtonAction");
__publicField(_UpdateSubscribeButtonAction, "type", "UpdateSubscribeButtonAction");
var UpdateSubscribeButtonAction = _UpdateSubscribeButtonAction;

// dist/src/parser/classes/ActiveAccountHeader.js
var _ActiveAccountHeader = class _ActiveAccountHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "account_name");
    __publicField(this, "account_photo");
    __publicField(this, "endpoint");
    __publicField(this, "manage_account_title");
    __publicField(this, "channel_handle");
    this.account_name = new Text2(data.accountName);
    this.account_photo = Thumbnail.fromResponse(data.accountPhoto);
    this.endpoint = new NavigationEndpoint(data.serviceEndpoint);
    this.manage_account_title = new Text2(data.manageAccountTitle);
    this.channel_handle = new Text2(data.channelHandle);
  }
};
__name(_ActiveAccountHeader, "ActiveAccountHeader");
__publicField(_ActiveAccountHeader, "type", "ActiveAccountHeader");
var ActiveAccountHeader = _ActiveAccountHeader;

// dist/src/parser/classes/MenuTitle.js
var _MenuTitle = class _MenuTitle extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_MenuTitle, "MenuTitle");
__publicField(_MenuTitle, "type", "MenuTitle");
var MenuTitle = _MenuTitle;

// dist/src/parser/classes/PlaylistAddToOption.js
var _PlaylistAddToOption = class _PlaylistAddToOption extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "add_to_playlist_service_endpoint");
    __publicField(this, "contains_selected_videos");
    __publicField(this, "playlist_id");
    __publicField(this, "privacy");
    __publicField(this, "privacy_icon");
    __publicField(this, "remove_from_playlist_service_endpoint");
    __publicField(this, "title");
    this.add_to_playlist_service_endpoint = new NavigationEndpoint(data.addToPlaylistServiceEndpoint);
    this.contains_selected_videos = data.containsSelectedVideos;
    this.playlist_id = data.playlistId;
    this.privacy = data.privacy;
    this.privacy_icon = { icon_type: ((_a = data.privacyIcon) == null ? void 0 : _a.iconType) || null };
    this.remove_from_playlist_service_endpoint = new NavigationEndpoint(data.removeFromPlaylistServiceEndpoint);
    this.title = new Text2(data.title);
  }
};
__name(_PlaylistAddToOption, "PlaylistAddToOption");
__publicField(_PlaylistAddToOption, "type", "PlaylistAddToOption");
var PlaylistAddToOption = _PlaylistAddToOption;

// dist/src/parser/classes/AddToPlaylist.js
var _AddToPlaylist = class _AddToPlaylist extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "actions");
    __publicField(this, "playlists");
    this.actions = parser_exports.parseArray(data.actions, [MenuTitle, Button]);
    this.playlists = parser_exports.parseArray(data.playlists, PlaylistAddToOption);
  }
};
__name(_AddToPlaylist, "AddToPlaylist");
__publicField(_AddToPlaylist, "type", "AddToPlaylist");
var AddToPlaylist = _AddToPlaylist;

// dist/src/parser/classes/Alert.js
var _Alert = class _Alert extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "alert_type");
    this.text = new Text2(data.text);
    this.alert_type = data.type;
  }
};
__name(_Alert, "Alert");
__publicField(_Alert, "type", "Alert");
var Alert = _Alert;

// dist/src/parser/classes/AlertWithButton.js
var _AlertWithButton = class _AlertWithButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "alert_type");
    __publicField(this, "dismiss_button");
    this.text = new Text2(data.text);
    this.alert_type = data.type;
    this.dismiss_button = parser_exports.parseItem(data.dismissButton, Button);
  }
};
__name(_AlertWithButton, "AlertWithButton");
__publicField(_AlertWithButton, "type", "AlertWithButton");
var AlertWithButton = _AlertWithButton;

// dist/src/parser/classes/AnimatedThumbnailOverlayView.js
var _AnimatedThumbnailOverlayView = class _AnimatedThumbnailOverlayView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_AnimatedThumbnailOverlayView, "AnimatedThumbnailOverlayView");
__publicField(_AnimatedThumbnailOverlayView, "type", "AnimatedThumbnailOverlayView");
var AnimatedThumbnailOverlayView = _AnimatedThumbnailOverlayView;

// dist/src/parser/classes/AttributionView.js
var _AttributionView = class _AttributionView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "suffix");
    this.text = Text2.fromAttributed(data.text);
    this.suffix = Text2.fromAttributed(data.suffix);
  }
};
__name(_AttributionView, "AttributionView");
__publicField(_AttributionView, "type", "AttributionView");
var AttributionView = _AttributionView;

// dist/src/parser/classes/AudioOnlyPlayability.js
var _AudioOnlyPlayability = class _AudioOnlyPlayability extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "audio_only_availability");
    this.audio_only_availability = data.audioOnlyAvailability;
  }
};
__name(_AudioOnlyPlayability, "AudioOnlyPlayability");
__publicField(_AudioOnlyPlayability, "type", "AudioOnlyPlayability");
var AudioOnlyPlayability = _AudioOnlyPlayability;

// dist/src/parser/classes/AutomixPreviewVideo.js
var _AutomixPreviewVideo = class _AutomixPreviewVideo extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "playlist_video");
    if ((_b = (_a = data == null ? void 0 : data.content) == null ? void 0 : _a.automixPlaylistVideoRenderer) == null ? void 0 : _b.navigationEndpoint) {
      this.playlist_video = {
        endpoint: new NavigationEndpoint(data.content.automixPlaylistVideoRenderer.navigationEndpoint)
      };
    }
  }
};
__name(_AutomixPreviewVideo, "AutomixPreviewVideo");
__publicField(_AutomixPreviewVideo, "type", "AutomixPreviewVideo");
var AutomixPreviewVideo = _AutomixPreviewVideo;

// dist/src/parser/classes/AvatarView.js
var _AvatarView = class _AvatarView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "image");
    __publicField(this, "image_processor");
    __publicField(this, "avatar_image_size");
    this.image = Thumbnail.fromResponse(data.image);
    this.avatar_image_size = data.avatarImageSize;
    if (data.image.processor) {
      this.image_processor = {
        border_image_processor: {
          circular: data.image.processor.borderImageProcessor.circular
        }
      };
    }
  }
};
__name(_AvatarView, "AvatarView");
__publicField(_AvatarView, "type", "AvatarView");
var AvatarView = _AvatarView;

// dist/src/parser/classes/misc/CommandContext.js
var _CommandContext = class _CommandContext {
  constructor(data) {
    __publicField(this, "on_focus");
    __publicField(this, "on_hidden");
    __publicField(this, "on_touch_end");
    __publicField(this, "on_touch_move");
    __publicField(this, "on_long_press");
    __publicField(this, "on_tap");
    __publicField(this, "on_touch_start");
    __publicField(this, "on_visible");
    __publicField(this, "on_first_visible");
    __publicField(this, "on_hover");
    if ("onFocus" in data)
      this.on_focus = new NavigationEndpoint(data.onFocus);
    if ("onHidden" in data)
      this.on_hidden = new NavigationEndpoint(data.onHidden);
    if ("onTouchEnd" in data)
      this.on_touch_end = new NavigationEndpoint(data.onTouchEnd);
    if ("onTouchMove" in data)
      this.on_touch_move = new NavigationEndpoint(data.onTouchMove);
    if ("onLongPress" in data)
      this.on_long_press = new NavigationEndpoint(data.onLongPress);
    if ("onTap" in data)
      this.on_tap = new NavigationEndpoint(data.onTap);
    if ("onTouchStart" in data)
      this.on_touch_start = new NavigationEndpoint(data.onTouchStart);
    if ("onVisible" in data)
      this.on_visible = new NavigationEndpoint(data.onVisible);
    if ("onFirstVisible" in data)
      this.on_first_visible = new NavigationEndpoint(data.onFirstVisible);
    if ("onHover" in data)
      this.on_hover = new NavigationEndpoint(data.onHover);
  }
};
__name(_CommandContext, "CommandContext");
var CommandContext = _CommandContext;

// dist/src/parser/classes/misc/RendererContext.js
var _RendererContext = class _RendererContext {
  constructor(data) {
    __publicField(this, "command_context");
    __publicField(this, "accessibility_context");
    if (!data)
      return;
    if ("commandContext" in data) {
      this.command_context = new CommandContext(data.commandContext);
    }
    if ("accessibilityContext" in data) {
      this.accessibility_context = new AccessibilityContext(data.accessibilityContext);
    }
  }
};
__name(_RendererContext, "RendererContext");
var RendererContext = _RendererContext;

// dist/src/parser/classes/AvatarStackView.js
var _AvatarStackView = class _AvatarStackView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "avatars");
    __publicField(this, "text");
    __publicField(this, "renderer_context");
    this.avatars = parser_exports.parseArray(data.avatars, AvatarView);
    if (Reflect.has(data, "text"))
      this.text = Text2.fromAttributed(data.text);
    this.renderer_context = new RendererContext(data.rendererContext);
  }
};
__name(_AvatarStackView, "AvatarStackView");
__publicField(_AvatarStackView, "type", "AvatarStackView");
var AvatarStackView = _AvatarStackView;

// dist/src/parser/classes/ButtonView.js
var _ButtonView = class _ButtonView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "secondary_icon_image");
    __publicField(this, "icon_name");
    __publicField(this, "enable_icon_button");
    __publicField(this, "tooltip");
    __publicField(this, "icon_image_flip_for_rtl");
    __publicField(this, "button_size");
    __publicField(this, "icon_position");
    __publicField(this, "is_full_width");
    __publicField(this, "state");
    __publicField(this, "on_disabled_tap");
    __publicField(this, "custom_border_color");
    __publicField(this, "on_tap");
    __publicField(this, "style");
    __publicField(this, "icon_image");
    __publicField(this, "custom_dark_theme_border_color");
    __publicField(this, "title");
    __publicField(this, "target_id");
    __publicField(this, "enable_full_width_margins");
    __publicField(this, "custom_font_color");
    __publicField(this, "button_type");
    __publicField(this, "enabled");
    __publicField(this, "accessibility_id");
    __publicField(this, "custom_background_color");
    __publicField(this, "on_long_press");
    __publicField(this, "title_formatted");
    __publicField(this, "on_visible");
    __publicField(this, "icon_trailing");
    __publicField(this, "accessibility_text");
    if ("secondaryIconImage" in data)
      this.secondary_icon_image = Thumbnail.fromResponse(data.secondaryIconImage);
    if ("iconName" in data)
      this.icon_name = data.iconName;
    if ("enableIconButton" in data)
      this.enable_icon_button = data.enableIconButton;
    if ("tooltip" in data)
      this.tooltip = data.tooltip;
    if ("iconImageFlipForRtl" in data)
      this.icon_image_flip_for_rtl = data.iconImageFlipForRtl;
    if ("buttonSize" in data)
      this.button_size = data.buttonSize;
    if ("iconPosition" in data)
      this.icon_position = data.iconPosition;
    if ("isFullWidth" in data)
      this.is_full_width = data.isFullWidth;
    if ("state" in data)
      this.state = data.state;
    if ("onDisabledTap" in data)
      this.on_disabled_tap = new NavigationEndpoint(data.onDisabledTap);
    if ("customBorderColor" in data)
      this.custom_border_color = data.customBorderColor;
    if ("onTap" in data)
      this.on_tap = new NavigationEndpoint(data.onTap);
    if ("style" in data)
      this.style = data.style;
    if ("iconImage" in data)
      this.icon_image = data.iconImage;
    if ("customDarkThemeBorderColor" in data)
      this.custom_dark_theme_border_color = data.customDarkThemeBorderColor;
    if ("title" in data)
      this.title = data.title;
    if ("targetId" in data)
      this.target_id = data.targetId;
    if ("enableFullWidthMargins" in data)
      this.enable_full_width_margins = data.enableFullWidthMargins;
    if ("customFontColor" in data)
      this.custom_font_color = data.customFontColor;
    if ("type" in data)
      this.button_type = data.type;
    if ("enabled" in data)
      this.enabled = data.enabled;
    if ("accessibilityId" in data)
      this.accessibility_id = data.accessibilityId;
    if ("customBackgroundColor" in data)
      this.custom_background_color = data.customBackgroundColor;
    if ("onLongPress" in data)
      this.on_long_press = new NavigationEndpoint(data.onLongPress);
    if ("titleFormatted" in data)
      this.title_formatted = data.titleFormatted;
    if ("onVisible" in data)
      this.on_visible = data.onVisible;
    if ("iconTrailing" in data)
      this.icon_trailing = data.iconTrailing;
    if ("accessibilityText" in data)
      this.accessibility_text = data.accessibilityText;
  }
};
__name(_ButtonView, "ButtonView");
__publicField(_ButtonView, "type", "ButtonView");
var ButtonView = _ButtonView;

// dist/src/parser/classes/BackgroundPromo.js
var _BackgroundPromo = class _BackgroundPromo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "body_text");
    __publicField(this, "cta_button");
    __publicField(this, "icon_type");
    __publicField(this, "title");
    this.body_text = new Text2(data.bodyText);
    this.cta_button = parser_exports.parseItem(data.ctaButton, [Button, ButtonView]);
    if (Reflect.has(data, "icon"))
      this.icon_type = data.icon.iconType;
    this.title = new Text2(data.title);
  }
};
__name(_BackgroundPromo, "BackgroundPromo");
__publicField(_BackgroundPromo, "type", "BackgroundPromo");
var BackgroundPromo = _BackgroundPromo;

// dist/src/parser/classes/BackstageImage.js
var _BackstageImage = class _BackstageImage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "image");
    __publicField(this, "endpoint");
    this.image = Thumbnail.fromResponse(data.image);
    this.endpoint = new NavigationEndpoint(data.command);
  }
};
__name(_BackstageImage, "BackstageImage");
__publicField(_BackstageImage, "type", "BackstageImage");
var BackstageImage = _BackstageImage;

// dist/src/parser/classes/ToggleButton.js
var _ToggleButton = class _ToggleButton extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    super();
    __publicField(this, "text");
    __publicField(this, "toggled_text");
    __publicField(this, "tooltip");
    __publicField(this, "toggled_tooltip");
    __publicField(this, "is_toggled");
    __publicField(this, "is_disabled");
    __publicField(this, "icon_type");
    __publicField(this, "like_count");
    __publicField(this, "short_like_count");
    __publicField(this, "endpoint");
    __publicField(this, "toggled_endpoint");
    __publicField(this, "button_id");
    __publicField(this, "target_id");
    this.text = new Text2(data.defaultText);
    this.toggled_text = new Text2(data.toggledText);
    this.tooltip = data.defaultTooltip;
    this.toggled_tooltip = data.toggledTooltip;
    this.is_toggled = data.isToggled;
    this.is_disabled = data.isDisabled;
    this.icon_type = (_a = data.defaultIcon) == null ? void 0 : _a.iconType;
    const acc_label = ((_d = (_c = (_b = data == null ? void 0 : data.defaultText) == null ? void 0 : _b.accessibility) == null ? void 0 : _c.accessibilityData) == null ? void 0 : _d.label) || ((_f = (_e = data == null ? void 0 : data.accessibilityData) == null ? void 0 : _e.accessibilityData) == null ? void 0 : _f.label) || ((_g = data == null ? void 0 : data.accessibility) == null ? void 0 : _g.label);
    if (this.icon_type == "LIKE") {
      this.like_count = parseInt(acc_label.replace(/\D/g, ""));
      this.short_like_count = new Text2(data.defaultText).toString();
    }
    this.endpoint = ((_i = (_h = data.defaultServiceEndpoint) == null ? void 0 : _h.commandExecutorCommand) == null ? void 0 : _i.commands) ? new NavigationEndpoint(data.defaultServiceEndpoint.commandExecutorCommand.commands.pop()) : new NavigationEndpoint(data.defaultServiceEndpoint);
    this.toggled_endpoint = new NavigationEndpoint(data.toggledServiceEndpoint);
    if (Reflect.has(data, "toggleButtonSupportedData") && Reflect.has(data.toggleButtonSupportedData, "toggleButtonIdData")) {
      this.button_id = data.toggleButtonSupportedData.toggleButtonIdData.id;
    }
    if (Reflect.has(data, "targetId")) {
      this.target_id = data.targetId;
    }
  }
};
__name(_ToggleButton, "ToggleButton");
__publicField(_ToggleButton, "type", "ToggleButton");
var ToggleButton = _ToggleButton;

// dist/src/parser/classes/comments/CreatorHeart.js
var _CreatorHeart = class _CreatorHeart extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "creator_thumbnail");
    __publicField(this, "heart_icon_type");
    __publicField(this, "heart_color");
    __publicField(this, "hearted_tooltip");
    __publicField(this, "is_hearted");
    __publicField(this, "is_enabled");
    __publicField(this, "kennedy_heart_color_string");
    this.creator_thumbnail = Thumbnail.fromResponse(data.creatorThumbnail);
    if (Reflect.has(data, "heartIcon") && Reflect.has(data.heartIcon, "iconType")) {
      this.heart_icon_type = data.heartIcon.iconType;
    }
    this.heart_color = {
      basic_color_palette_data: {
        foreground_title_color: (_b = (_a = data.heartColor) == null ? void 0 : _a.basicColorPaletteData) == null ? void 0 : _b.foregroundTitleColor
      }
    };
    this.hearted_tooltip = data.heartedTooltip;
    this.is_hearted = data.isHearted;
    this.is_enabled = data.isEnabled;
    this.kennedy_heart_color_string = data.kennedyHeartColorString;
  }
};
__name(_CreatorHeart, "CreatorHeart");
__publicField(_CreatorHeart, "type", "CreatorHeart");
var CreatorHeart = _CreatorHeart;

// dist/src/parser/classes/comments/CommentActionButtons.js
var _CommentActionButtons = class _CommentActionButtons extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "dislike_button");
    __publicField(this, "reply_button");
    __publicField(this, "creator_heart");
    this.like_button = parser_exports.parseItem(data.likeButton, ToggleButton);
    this.dislike_button = parser_exports.parseItem(data.dislikeButton, ToggleButton);
    this.reply_button = parser_exports.parseItem(data.replyButton, Button);
    this.creator_heart = parser_exports.parseItem(data.creatorHeart, CreatorHeart);
  }
};
__name(_CommentActionButtons, "CommentActionButtons");
__publicField(_CommentActionButtons, "type", "CommentActionButtons");
var CommentActionButtons = _CommentActionButtons;

// dist/src/parser/classes/ToggleButtonView.js
var _ToggleButtonView = class _ToggleButtonView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "default_button");
    __publicField(this, "toggled_button");
    __publicField(this, "is_toggling_disabled");
    __publicField(this, "identifier");
    __publicField(this, "is_toggled");
    this.default_button = parser_exports.parseItem(data.defaultButtonViewModel, ButtonView);
    this.toggled_button = parser_exports.parseItem(data.toggledButtonViewModel, ButtonView);
    this.is_toggling_disabled = data.isTogglingDisabled;
    this.identifier = data.identifier;
    if (Reflect.has(data, "isToggled")) {
      this.is_toggled = data.isToggled;
    }
  }
};
__name(_ToggleButtonView, "ToggleButtonView");
__publicField(_ToggleButtonView, "type", "ToggleButtonView");
var ToggleButtonView = _ToggleButtonView;

// dist/src/parser/classes/LikeButtonView.js
var _LikeButtonView = class _LikeButtonView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "toggle_button");
    __publicField(this, "like_status_entity_key");
    __publicField(this, "like_status_entity");
    this.toggle_button = parser_exports.parseItem(data.toggleButtonViewModel, ToggleButtonView);
    this.like_status_entity_key = data.likeStatusEntityKey;
    this.like_status_entity = {
      key: data.likeStatusEntity.key,
      like_status: data.likeStatusEntity.likeStatus
    };
  }
};
__name(_LikeButtonView, "LikeButtonView");
__publicField(_LikeButtonView, "type", "LikeButtonView");
var LikeButtonView = _LikeButtonView;

// dist/src/parser/classes/DislikeButtonView.js
var _DislikeButtonView = class _DislikeButtonView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "toggle_button");
    __publicField(this, "dislike_entity_key");
    this.toggle_button = parser_exports.parseItem(data.toggleButtonViewModel, ToggleButtonView);
    this.dislike_entity_key = data.dislikeEntityKey;
  }
};
__name(_DislikeButtonView, "DislikeButtonView");
__publicField(_DislikeButtonView, "type", "DislikeButtonView");
var DislikeButtonView = _DislikeButtonView;

// dist/src/parser/classes/SegmentedLikeDislikeButtonView.js
var _SegmentedLikeDislikeButtonView = class _SegmentedLikeDislikeButtonView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "dislike_button");
    __publicField(this, "icon_type");
    __publicField(this, "like_count_entity");
    __publicField(this, "dynamic_like_count_update_data");
    __publicField(this, "like_count");
    __publicField(this, "short_like_count");
    this.like_button = parser_exports.parseItem(data.likeButtonViewModel, LikeButtonView);
    this.dislike_button = parser_exports.parseItem(data.dislikeButtonViewModel, DislikeButtonView);
    this.icon_type = data.iconType;
    if (this.like_button && this.like_button.toggle_button) {
      const toggle_button = this.like_button.toggle_button;
      if (toggle_button.default_button) {
        this.short_like_count = toggle_button.default_button.title;
        if (toggle_button.default_button.accessibility_text)
          this.like_count = parseInt(toggle_button.default_button.accessibility_text.replace(/\D/g, ""));
      } else if (toggle_button.toggled_button) {
        this.short_like_count = toggle_button.toggled_button.title;
        if (toggle_button.toggled_button.accessibility_text)
          this.like_count = parseInt(toggle_button.toggled_button.accessibility_text.replace(/\D/g, ""));
      }
    }
    this.like_count_entity = {
      key: data.likeCountEntity.key
    };
    this.dynamic_like_count_update_data = {
      update_status_key: data.dynamicLikeCountUpdateData.updateStatusKey,
      placeholder_like_count_values_key: data.dynamicLikeCountUpdateData.placeholderLikeCountValuesKey,
      update_delay_loop_id: data.dynamicLikeCountUpdateData.updateDelayLoopId,
      update_delay_sec: data.dynamicLikeCountUpdateData.updateDelaySec
    };
  }
};
__name(_SegmentedLikeDislikeButtonView, "SegmentedLikeDislikeButtonView");
__publicField(_SegmentedLikeDislikeButtonView, "type", "SegmentedLikeDislikeButtonView");
var SegmentedLikeDislikeButtonView = _SegmentedLikeDislikeButtonView;

// dist/src/parser/classes/menus/MenuServiceItem.js
var _MenuServiceItem = class _MenuServiceItem extends Button {
  constructor(data) {
    super(data);
  }
};
__name(_MenuServiceItem, "MenuServiceItem");
__publicField(_MenuServiceItem, "type", "MenuServiceItem");
var MenuServiceItem = _MenuServiceItem;

// dist/src/parser/classes/DownloadButton.js
var _DownloadButton = class _DownloadButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "style");
    __publicField(this, "size");
    // TODO: check this
    __publicField(this, "endpoint");
    __publicField(this, "target_id");
    this.style = data.style;
    this.size = data.size;
    this.endpoint = new NavigationEndpoint(data.command);
    this.target_id = data.targetId;
  }
};
__name(_DownloadButton, "DownloadButton");
__publicField(_DownloadButton, "type", "DownloadButton");
var DownloadButton = _DownloadButton;

// dist/src/parser/classes/menus/MenuServiceItemDownload.js
var _MenuServiceItemDownload = class _MenuServiceItemDownload extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "has_separator");
    __publicField(this, "endpoint");
    this.has_separator = !!data.hasSeparator;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint || data.serviceEndpoint);
  }
};
__name(_MenuServiceItemDownload, "MenuServiceItemDownload");
__publicField(_MenuServiceItemDownload, "type", "MenuServiceItemDownload");
var MenuServiceItemDownload = _MenuServiceItemDownload;

// dist/src/parser/classes/menus/MenuFlexibleItem.js
var _MenuFlexibleItem = class _MenuFlexibleItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "menu_item");
    __publicField(this, "top_level_button");
    this.menu_item = parser_exports.parseItem(data.menuItem, [MenuServiceItem, MenuServiceItemDownload]);
    this.top_level_button = parser_exports.parseItem(data.topLevelButton, [DownloadButton, ButtonView, Button]);
  }
};
__name(_MenuFlexibleItem, "MenuFlexibleItem");
__publicField(_MenuFlexibleItem, "type", "MenuFlexibleItem");
var MenuFlexibleItem = _MenuFlexibleItem;

// dist/src/parser/classes/LikeButton.js
var _LikeButton = class _LikeButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "target");
    __publicField(this, "like_status");
    __publicField(this, "likes_allowed");
    __publicField(this, "endpoints");
    this.target = {
      video_id: data.target.videoId
    };
    this.like_status = data.likeStatus;
    this.likes_allowed = data.likesAllowed;
    if (Reflect.has(data, "serviceEndpoints")) {
      this.endpoints = data.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    }
  }
};
__name(_LikeButton, "LikeButton");
__publicField(_LikeButton, "type", "LikeButton");
var LikeButton = _LikeButton;

// dist/src/parser/classes/FlexibleActionsView.js
var _FlexibleActionsView = class _FlexibleActionsView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "actions_rows");
    __publicField(this, "style");
    this.actions_rows = data.actionsRows.map((row) => ({
      actions: parser_exports.parseArray(row.actions, [ButtonView, ToggleButtonView])
    }));
    this.style = data.style;
  }
};
__name(_FlexibleActionsView, "FlexibleActionsView");
__publicField(_FlexibleActionsView, "type", "FlexibleActionsView");
var FlexibleActionsView = _FlexibleActionsView;

// dist/src/parser/classes/menus/Menu.js
var _Menu = class _Menu extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    __publicField(this, "flexible_items");
    __publicField(this, "top_level_buttons");
    __publicField(this, "accessibility");
    this.items = parser_exports.parseArray(data.items);
    this.flexible_items = parser_exports.parseArray(data.flexibleItems, MenuFlexibleItem);
    this.top_level_buttons = parser_exports.parseArray(data.topLevelButtons, [ToggleButton, LikeButton, Button, ButtonView, SegmentedLikeDislikeButtonView, FlexibleActionsView]);
    if ("accessibility" in data && "accessibilityData" in data.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    var _a, _b;
    return (_b = (_a = this.accessibility) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
  // XXX: alias for consistency
  get contents() {
    return this.items;
  }
};
__name(_Menu, "Menu");
__publicField(_Menu, "type", "Menu");
var Menu = _Menu;

// dist/src/parser/classes/BackstagePost.js
var _BackstagePost = class _BackstagePost extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "content");
    __publicField(this, "published");
    __publicField(this, "poll_status");
    __publicField(this, "vote_status");
    __publicField(this, "vote_count");
    __publicField(this, "menu");
    __publicField(this, "action_buttons");
    __publicField(this, "vote_button");
    __publicField(this, "surface");
    __publicField(this, "endpoint");
    __publicField(this, "attachment");
    this.id = data.postId;
    this.author = new Author({
      ...data.authorText,
      navigationEndpoint: data.authorEndpoint
    }, null, data.authorThumbnail);
    this.content = new Text2(data.contentText);
    this.published = new Text2(data.publishedTimeText);
    if (Reflect.has(data, "pollStatus")) {
      this.poll_status = data.pollStatus;
    }
    if (Reflect.has(data, "voteStatus")) {
      this.vote_status = data.voteStatus;
    }
    if (Reflect.has(data, "voteCount")) {
      this.vote_count = new Text2(data.voteCount);
    }
    if (Reflect.has(data, "actionMenu")) {
      this.menu = parser_exports.parseItem(data.actionMenu, Menu);
    }
    if (Reflect.has(data, "actionButtons")) {
      this.action_buttons = parser_exports.parseItem(data.actionButtons, CommentActionButtons);
    }
    if (Reflect.has(data, "voteButton")) {
      this.vote_button = parser_exports.parseItem(data.voteButton, Button);
    }
    if (Reflect.has(data, "navigationEndpoint")) {
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    }
    if (Reflect.has(data, "backstageAttachment")) {
      this.attachment = parser_exports.parseItem(data.backstageAttachment);
    }
    this.surface = data.surface;
  }
};
__name(_BackstagePost, "BackstagePost");
__publicField(_BackstagePost, "type", "BackstagePost");
var BackstagePost = _BackstagePost;

// dist/src/parser/classes/BackstagePostThread.js
var _BackstagePostThread = class _BackstagePostThread extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "post");
    this.post = parser_exports.parseItem(data.post);
  }
};
__name(_BackstagePostThread, "BackstagePostThread");
__publicField(_BackstagePostThread, "type", "BackstagePostThread");
var BackstagePostThread = _BackstagePostThread;

// dist/src/parser/classes/BadgeView.js
var _BadgeView = class _BadgeView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "style");
    __publicField(this, "accessibility_label");
    this.text = data.badgeText;
    this.style = data.badgeStyle;
    this.accessibility_label = data.accessibilityLabel;
  }
};
__name(_BadgeView, "BadgeView");
var BadgeView = _BadgeView;

// dist/src/parser/classes/SubFeedOption.js
var _SubFeedOption = class _SubFeedOption extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "name");
    __publicField(this, "is_selected");
    __publicField(this, "endpoint");
    this.name = new Text2(data.name);
    this.is_selected = data.isSelected;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
  }
};
__name(_SubFeedOption, "SubFeedOption");
__publicField(_SubFeedOption, "type", "SubFeedOption");
var SubFeedOption = _SubFeedOption;

// dist/src/parser/classes/SubFeedSelector.js
var _SubFeedSelector = class _SubFeedSelector extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "options");
    this.title = new Text2(data.title);
    this.options = parser_exports.parseArray(data.options, SubFeedOption);
  }
};
__name(_SubFeedSelector, "SubFeedSelector");
__publicField(_SubFeedSelector, "type", "SubFeedSelector");
var SubFeedSelector = _SubFeedSelector;

// dist/src/parser/classes/EomSettingsDisclaimer.js
var _EomSettingsDisclaimer = class _EomSettingsDisclaimer extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "disclaimer");
    __publicField(this, "info_icon");
    __publicField(this, "usage_scenario");
    this.disclaimer = new Text2(data.disclaimer);
    this.info_icon = {
      icon_type: data.infoIcon.iconType
    };
    this.usage_scenario = data.usageScenario;
  }
};
__name(_EomSettingsDisclaimer, "EomSettingsDisclaimer");
__publicField(_EomSettingsDisclaimer, "type", "EomSettingsDisclaimer");
var EomSettingsDisclaimer = _EomSettingsDisclaimer;

// dist/src/parser/classes/SearchBox.js
var _SearchBox = class _SearchBox extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "search_button");
    __publicField(this, "clear_button");
    __publicField(this, "placeholder_text");
    this.endpoint = new NavigationEndpoint(data.endpoint);
    this.search_button = parser_exports.parseItem(data.searchButton, Button);
    this.clear_button = parser_exports.parseItem(data.clearButton, Button);
    this.placeholder_text = new Text2(data.placeholderText);
  }
};
__name(_SearchBox, "SearchBox");
__publicField(_SearchBox, "type", "SearchBox");
var SearchBox = _SearchBox;

// dist/src/parser/classes/BrowseFeedActions.js
var _BrowseFeedActions = class _BrowseFeedActions extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data.contents, [SubFeedSelector, EomSettingsDisclaimer, ToggleButton, CompactLink, SearchBox, Button]);
  }
};
__name(_BrowseFeedActions, "BrowseFeedActions");
__publicField(_BrowseFeedActions, "type", "BrowseFeedActions");
var BrowseFeedActions = _BrowseFeedActions;

// dist/src/parser/classes/BrowserMediaSession.js
var _BrowserMediaSession = class _BrowserMediaSession extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "album");
    __publicField(this, "thumbnails");
    this.album = new Text2(data.album);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnailDetails);
  }
};
__name(_BrowserMediaSession, "BrowserMediaSession");
__publicField(_BrowserMediaSession, "type", "BrowserMediaSession");
var BrowserMediaSession = _BrowserMediaSession;

// dist/src/parser/classes/ButtonCardView.js
var _ButtonCardView = class _ButtonCardView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "icon_name");
    __publicField(this, "renderer_context");
    this.title = data.title;
    this.icon_name = data.image.sources[0].clientResource.imageName;
    this.renderer_context = new RendererContext(data.rendererContext);
  }
};
__name(_ButtonCardView, "ButtonCardView");
__publicField(_ButtonCardView, "type", "ButtonCardView");
var ButtonCardView = _ButtonCardView;

// dist/src/parser/classes/ChannelHeaderLinks.js
var _HeaderLink = class _HeaderLink extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "icon");
    __publicField(this, "title");
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.icon = Thumbnail.fromResponse(data.icon);
    this.title = new Text2(data.title);
  }
};
__name(_HeaderLink, "HeaderLink");
__publicField(_HeaderLink, "type", "HeaderLink");
var HeaderLink = _HeaderLink;
var _ChannelHeaderLinks = class _ChannelHeaderLinks extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "primary");
    __publicField(this, "secondary");
    this.primary = observe(((_a = data.primaryLinks) == null ? void 0 : _a.map((link) => new HeaderLink(link))) || []);
    this.secondary = observe(((_b = data.secondaryLinks) == null ? void 0 : _b.map((link) => new HeaderLink(link))) || []);
  }
};
__name(_ChannelHeaderLinks, "ChannelHeaderLinks");
__publicField(_ChannelHeaderLinks, "type", "ChannelHeaderLinks");
var ChannelHeaderLinks = _ChannelHeaderLinks;

// dist/src/parser/classes/ChannelHeaderLinksView.js
var _ChannelHeaderLinksView = class _ChannelHeaderLinksView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "first_link");
    __publicField(this, "more");
    if (Reflect.has(data, "firstLink")) {
      this.first_link = Text2.fromAttributed(data.firstLink);
    }
    if (Reflect.has(data, "more")) {
      this.more = Text2.fromAttributed(data.more);
    }
  }
};
__name(_ChannelHeaderLinksView, "ChannelHeaderLinksView");
__publicField(_ChannelHeaderLinksView, "type", "ChannelHeaderLinksView");
var ChannelHeaderLinksView = _ChannelHeaderLinksView;

// dist/src/parser/classes/ClipCreationTextInput.js
var _ClipCreationTextInput = class _ClipCreationTextInput extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "placeholder_text");
    __publicField(this, "max_character_limit");
    this.placeholder_text = new Text2(data.placeholderText);
    this.max_character_limit = data.maxCharacterLimit;
  }
};
__name(_ClipCreationTextInput, "ClipCreationTextInput");
__publicField(_ClipCreationTextInput, "type", "ClipCreationTextInput");
var ClipCreationTextInput = _ClipCreationTextInput;

// dist/src/parser/classes/ClipCreationScrubber.js
var _ClipCreationScrubber = class _ClipCreationScrubber extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f;
    super();
    __publicField(this, "length_template");
    __publicField(this, "max_length_ms");
    __publicField(this, "min_length_ms");
    __publicField(this, "default_length_ms");
    __publicField(this, "window_size_ms");
    __publicField(this, "start_label");
    __publicField(this, "end_label");
    __publicField(this, "duration_label");
    this.length_template = data.lengthTemplate;
    this.max_length_ms = data.maxLengthMs;
    this.min_length_ms = data.minLengthMs;
    this.default_length_ms = data.defaultLengthMs;
    this.window_size_ms = data.windowSizeMs;
    this.start_label = (_b = (_a = data.startAccessibility) == null ? void 0 : _a.accessibilityData) == null ? void 0 : _b.label;
    this.end_label = (_d = (_c = data.endAccessibility) == null ? void 0 : _c.accessibilityData) == null ? void 0 : _d.label;
    this.duration_label = (_f = (_e = data.durationAccessibility) == null ? void 0 : _e.accessibilityData) == null ? void 0 : _f.label;
  }
};
__name(_ClipCreationScrubber, "ClipCreationScrubber");
__publicField(_ClipCreationScrubber, "type", "ClipCreationScrubber");
var ClipCreationScrubber = _ClipCreationScrubber;

// dist/src/parser/classes/ClipAdState.js
var _ClipAdState = class _ClipAdState extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "body");
    this.title = new Text2(data.title);
    this.body = new Text2(data.body);
  }
};
__name(_ClipAdState, "ClipAdState");
__publicField(_ClipAdState, "type", "ClipAdState");
var ClipAdState = _ClipAdState;

// dist/src/parser/classes/ClipCreation.js
var _ClipCreation = class _ClipCreation extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "user_avatar");
    __publicField(this, "title_input");
    __publicField(this, "scrubber");
    __publicField(this, "save_button");
    __publicField(this, "display_name");
    __publicField(this, "publicity_label");
    __publicField(this, "cancel_button");
    __publicField(this, "ad_state_overlay");
    __publicField(this, "external_video_id");
    __publicField(this, "publicity_label_icon");
    this.user_avatar = Thumbnail.fromResponse(data.userAvatar);
    this.title_input = parser_exports.parseItem(data.titleInput, [ClipCreationTextInput]);
    this.scrubber = parser_exports.parseItem(data.scrubber, [ClipCreationScrubber]);
    this.save_button = parser_exports.parseItem(data.saveButton, [Button]);
    this.display_name = new Text2(data.displayName);
    this.publicity_label = data.publicityLabel;
    this.cancel_button = parser_exports.parseItem(data.cancelButton, [Button]);
    this.ad_state_overlay = parser_exports.parseItem(data.adStateOverlay, [ClipAdState]);
    this.external_video_id = data.externalVideoId;
    this.publicity_label_icon = data.publicityLabelIcon;
  }
};
__name(_ClipCreation, "ClipCreation");
__publicField(_ClipCreation, "type", "ClipCreation");
var ClipCreation = _ClipCreation;

// dist/src/parser/classes/ClipSection.js
var _ClipSection = class _ClipSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parse(data.contents, true, [ClipCreation]);
  }
};
__name(_ClipSection, "ClipSection");
__publicField(_ClipSection, "type", "ClipSection");
var ClipSection = _ClipSection;

// dist/src/parser/classes/ContinuationItem.js
var _ContinuationItem = class _ContinuationItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "trigger");
    __publicField(this, "button");
    __publicField(this, "endpoint");
    this.trigger = data.trigger;
    if (Reflect.has(data, "button")) {
      this.button = parser_exports.parseItem(data.button, Button);
    }
    this.endpoint = new NavigationEndpoint(data.continuationEndpoint);
  }
};
__name(_ContinuationItem, "ContinuationItem");
__publicField(_ContinuationItem, "type", "ContinuationItem");
var ContinuationItem = _ContinuationItem;

// dist/src/parser/classes/EngagementPanelTitleHeader.js
var _EngagementPanelTitleHeader = class _EngagementPanelTitleHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "visibility_button");
    __publicField(this, "contextual_info");
    __publicField(this, "menu");
    this.title = new Text2(data.title);
    this.contextual_info = data.contextualInfo ? new Text2(data.contextualInfo) : void 0;
    this.visibility_button = parser_exports.parseItem(data.visibilityButton, Button);
    this.menu = parser_exports.parseItem(data.menu);
  }
};
__name(_EngagementPanelTitleHeader, "EngagementPanelTitleHeader");
__publicField(_EngagementPanelTitleHeader, "type", "EngagementPanelTitleHeader");
var EngagementPanelTitleHeader = _EngagementPanelTitleHeader;

// dist/src/parser/classes/MacroMarkersInfoItem.js
var _MacroMarkersInfoItem = class _MacroMarkersInfoItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "info_text");
    __publicField(this, "menu");
    this.info_text = new Text2(data.infoText);
    this.menu = parser_exports.parseItem(data.menu, Menu);
  }
};
__name(_MacroMarkersInfoItem, "MacroMarkersInfoItem");
__publicField(_MacroMarkersInfoItem, "type", "MacroMarkersInfoItem");
var MacroMarkersInfoItem = _MacroMarkersInfoItem;

// dist/src/parser/classes/MacroMarkersListItem.js
var _MacroMarkersListItem = class _MacroMarkersListItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "time_description");
    __publicField(this, "thumbnail");
    __publicField(this, "on_tap_endpoint");
    __publicField(this, "layout");
    __publicField(this, "is_highlighted");
    this.title = new Text2(data.title);
    this.time_description = new Text2(data.timeDescription);
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.on_tap_endpoint = new NavigationEndpoint(data.onTap);
    this.layout = data.layout;
    this.is_highlighted = !!data.isHighlighted;
  }
};
__name(_MacroMarkersListItem, "MacroMarkersListItem");
__publicField(_MacroMarkersListItem, "type", "MacroMarkersListItem");
var MacroMarkersListItem = _MacroMarkersListItem;

// dist/src/parser/classes/MacroMarkersList.js
var _MacroMarkersList = class _MacroMarkersList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    __publicField(this, "sync_button_label");
    this.contents = parser_exports.parseArray(data.contents, [MacroMarkersInfoItem, MacroMarkersListItem]);
    this.sync_button_label = new Text2(data.syncButtonLabel);
  }
};
__name(_MacroMarkersList, "MacroMarkersList");
__publicField(_MacroMarkersList, "type", "MacroMarkersList");
var MacroMarkersList = _MacroMarkersList;

// dist/src/parser/classes/ProductList.js
var _ProductList = class _ProductList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data.contents);
  }
};
__name(_ProductList, "ProductList");
__publicField(_ProductList, "type", "ProductList");
var ProductList = _ProductList;

// dist/src/parser/classes/SectionList.js
var _SectionList = class _SectionList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    __publicField(this, "target_id");
    __publicField(this, "continuation");
    __publicField(this, "header");
    __publicField(this, "sub_menu");
    this.contents = parser_exports.parseArray(data.contents);
    if (Reflect.has(data, "targetId")) {
      this.target_id = data.targetId;
    }
    if (Reflect.has(data, "continuations")) {
      if (Reflect.has(data.continuations[0], "nextContinuationData")) {
        this.continuation = data.continuations[0].nextContinuationData.continuation;
      } else if (Reflect.has(data.continuations[0], "reloadContinuationData")) {
        this.continuation = data.continuations[0].reloadContinuationData.continuation;
      }
    }
    if (Reflect.has(data, "header")) {
      this.header = parser_exports.parseItem(data.header);
    }
    if (Reflect.has(data, "subMenu")) {
      this.sub_menu = parser_exports.parseItem(data.subMenu);
    }
  }
};
__name(_SectionList, "SectionList");
__publicField(_SectionList, "type", "SectionList");
var SectionList = _SectionList;

// dist/src/parser/classes/ExpandableVideoDescriptionBody.js
var _ExpandableVideoDescriptionBody = class _ExpandableVideoDescriptionBody extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "show_more_text");
    __publicField(this, "show_less_text");
    __publicField(this, "attributed_description_body_text");
    this.show_more_text = new Text2(data.showMoreText);
    this.show_less_text = new Text2(data.showLessText);
    if (Reflect.has(data, "attributedDescriptionBodyText")) {
      this.attributed_description_body_text = Text2.fromAttributed(data.attributedDescriptionBodyText);
    }
  }
};
__name(_ExpandableVideoDescriptionBody, "ExpandableVideoDescriptionBody");
__publicField(_ExpandableVideoDescriptionBody, "type", "ExpandableVideoDescriptionBody");
var ExpandableVideoDescriptionBody = _ExpandableVideoDescriptionBody;

// dist/src/parser/classes/SearchRefinementCard.js
var _SearchRefinementCard = class _SearchRefinementCard extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "endpoint");
    __publicField(this, "query");
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.endpoint = new NavigationEndpoint(data.searchEndpoint);
    this.query = new Text2(data.query).toString();
  }
};
__name(_SearchRefinementCard, "SearchRefinementCard");
__publicField(_SearchRefinementCard, "type", "SearchRefinementCard");
var SearchRefinementCard = _SearchRefinementCard;

// dist/src/parser/classes/GameCard.js
var _GameCard = class _GameCard extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "game");
    this.game = parser_exports.parseItem(data.game);
  }
};
__name(_GameCard, "GameCard");
__publicField(_GameCard, "type", "GameCard");
var GameCard = _GameCard;

// dist/src/parser/classes/HorizontalList.js
var _HorizontalList = class _HorizontalList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "visible_item_count");
    __publicField(this, "items");
    this.visible_item_count = data.visibleItemCount;
    this.items = parser_exports.parseArray(data.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_HorizontalList, "HorizontalList");
__publicField(_HorizontalList, "type", "HorizontalList");
var HorizontalList = _HorizontalList;

// dist/src/parser/classes/ExpandableMetadata.js
var _ExpandableMetadata = class _ExpandableMetadata extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "expanded_content");
    __publicField(this, "expand_button");
    __publicField(this, "collapse_button");
    if (Reflect.has(data, "header")) {
      this.header = {
        collapsed_title: new Text2(data.header.collapsedTitle),
        collapsed_thumbnail: Thumbnail.fromResponse(data.header.collapsedThumbnail),
        collapsed_label: new Text2(data.header.collapsedLabel),
        expanded_title: new Text2(data.header.expandedTitle)
      };
    }
    this.expanded_content = parser_exports.parseItem(data.expandedContent, [HorizontalCardList, HorizontalList]);
    this.expand_button = parser_exports.parseItem(data.expandButton, Button);
    this.collapse_button = parser_exports.parseItem(data.collapseButton, Button);
  }
};
__name(_ExpandableMetadata, "ExpandableMetadata");
__publicField(_ExpandableMetadata, "type", "ExpandableMetadata");
var ExpandableMetadata = _ExpandableMetadata;

// dist/src/parser/classes/MetadataBadge.js
var _MetadataBadge = class _MetadataBadge extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "style");
    __publicField(this, "label");
    __publicField(this, "tooltip");
    if (Reflect.has(data, "icon")) {
      this.icon_type = data.icon.iconType;
    }
    if (Reflect.has(data, "style")) {
      this.style = data.style;
    }
    if (Reflect.has(data, "label")) {
      this.label = data.label;
    }
    if (Reflect.has(data, "tooltip") || Reflect.has(data, "iconTooltip")) {
      this.tooltip = data.tooltip || data.iconTooltip;
    }
  }
};
__name(_MetadataBadge, "MetadataBadge");
__publicField(_MetadataBadge, "type", "MetadataBadge");
var MetadataBadge = _MetadataBadge;

// dist/src/parser/classes/ThumbnailOverlayTimeStatus.js
var _ThumbnailOverlayTimeStatus = class _ThumbnailOverlayTimeStatus extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "style");
    this.text = new Text2(data.text).toString();
    this.style = data.style;
  }
};
__name(_ThumbnailOverlayTimeStatus, "ThumbnailOverlayTimeStatus");
__publicField(_ThumbnailOverlayTimeStatus, "type", "ThumbnailOverlayTimeStatus");
var ThumbnailOverlayTimeStatus = _ThumbnailOverlayTimeStatus;

// dist/src/parser/classes/Video.js
var _Video = class _Video extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "video_id");
    __publicField(this, "title");
    __publicField(this, "untranslated_title");
    __publicField(this, "description_snippet");
    __publicField(this, "snippets");
    __publicField(this, "expandable_metadata");
    __publicField(this, "additional_metadatas");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "rich_thumbnail");
    __publicField(this, "author");
    __publicField(this, "badges");
    __publicField(this, "endpoint");
    __publicField(this, "published");
    __publicField(this, "view_count");
    __publicField(this, "short_view_count");
    __publicField(this, "upcoming");
    __publicField(this, "length_text");
    __publicField(this, "show_action_menu");
    __publicField(this, "is_watched");
    __publicField(this, "menu");
    __publicField(this, "byline_text");
    __publicField(this, "search_video_result_entity_key");
    __publicField(this, "service_endpoints");
    __publicField(this, "service_endpoint");
    __publicField(this, "style");
    this.title = new Text2(data.title);
    this.video_id = data.videoId;
    this.expandable_metadata = parser_exports.parseItem(data.expandableMetadata, ExpandableMetadata);
    if ("untranslatedTitle" in data)
      this.untranslated_title = new Text2(data.untranslatedTitle);
    if ("descriptionSnippet" in data)
      this.description_snippet = new Text2(data.descriptionSnippet);
    if ("detailedMetadataSnippets" in data) {
      this.snippets = data.detailedMetadataSnippets.map((snippet) => ({
        text: new Text2(snippet.snippetText),
        hover_text: new Text2(snippet.snippetHoverText)
      }));
    }
    if ("additionalMetadatas" in data)
      this.additional_metadatas = data.additionalMetadatas.map((meta) => new Text2(meta));
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    if ("richThumbnail" in data)
      this.rich_thumbnail = parser_exports.parseItem(data.richThumbnail);
    this.author = new Author(data.ownerText, data.ownerBadges, (_b = (_a = data.channelThumbnailSupportedRenderers) == null ? void 0 : _a.channelThumbnailWithLinkRenderer) == null ? void 0 : _b.thumbnail);
    this.badges = parser_exports.parseArray(data.badges, MetadataBadge);
    if ("navigationEndpoint" in data)
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    if ("publishedTimeText" in data)
      this.published = new Text2(data.publishedTimeText);
    if ("viewCountText" in data)
      this.view_count = new Text2(data.viewCountText);
    if ("shortViewCountText" in data)
      this.short_view_count = new Text2(data.shortViewCountText);
    if ("upcomingEventData" in data)
      this.upcoming = new Date(Number(`${data.upcomingEventData.startTime}000`));
    this.show_action_menu = !!data.showActionMenu;
    this.is_watched = !!data.isWatched;
    this.menu = parser_exports.parseItem(data.menu, Menu);
    if ("searchVideoResultEntityKey" in data)
      this.search_video_result_entity_key = data.searchVideoResultEntityKey;
    if ("bylineText" in data)
      this.byline_text = new Text2(data.bylineText);
    if ("lengthText" in data)
      this.length_text = new Text2(data.lengthText);
    if ("serviceEndpoints" in data)
      this.service_endpoints = data.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if ("serviceEndpoint" in data)
      this.service_endpoint = new NavigationEndpoint(data.serviceEndpoint);
    if ("style" in data)
      this.style = data.style;
  }
  /**
   * @deprecated Use {@linkcode video_id} instead.
   */
  get id() {
    return this.video_id;
  }
  get description() {
    var _a;
    if (this.snippets)
      return this.snippets.map((snip) => snip.text.toString()).join("");
    return ((_a = this.description_snippet) == null ? void 0 : _a.toString()) || "";
  }
  get is_live() {
    var _a;
    return this.badges.some((badge) => {
      if (badge.style === "BADGE_STYLE_TYPE_LIVE_NOW" || badge.label === "LIVE")
        return true;
    }) || ((_a = this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus)) == null ? void 0 : _a.style) === "LIVE";
  }
  get is_upcoming() {
    return this.upcoming && this.upcoming > /* @__PURE__ */ new Date();
  }
  get is_premiere() {
    return this.badges.some((badge) => badge.label === "PREMIERE");
  }
  get is_4k() {
    return this.badges.some((badge) => badge.label === "4K");
  }
  get has_captions() {
    return this.badges.some((badge) => badge.label === "CC");
  }
  get best_thumbnail() {
    return this.thumbnails[0];
  }
  get duration() {
    var _a;
    const overlay_time_status = this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus);
    const length_text = ((_a = this.length_text) == null ? void 0 : _a.toString()) || (overlay_time_status == null ? void 0 : overlay_time_status.text.toString());
    return {
      text: length_text,
      seconds: length_text ? timeToSeconds(length_text) : 0
    };
  }
};
__name(_Video, "Video");
__publicField(_Video, "type", "Video");
var Video = _Video;

// dist/src/parser/classes/VideoCard.js
var _VideoCard = class _VideoCard extends Video {
  constructor(data) {
    var _a, _b, _c, _d;
    super(data);
    __publicField(this, "metadata_text");
    if (Reflect.has(data, "metadataText")) {
      this.metadata_text = new Text2(data.metadataText);
      if (this.metadata_text.text) {
        this.short_view_count = new Text2({ simpleText: (_a = this.metadata_text.text.split("\xB7")[0]) == null ? void 0 : _a.trim() });
        this.published = new Text2({ simpleText: (_b = this.metadata_text.text.split("\xB7")[1]) == null ? void 0 : _b.trim() });
      }
    }
    if (Reflect.has(data, "bylineText")) {
      this.author = new Author(data.bylineText, data.ownerBadges, (_d = (_c = data.channelThumbnailSupportedRenderers) == null ? void 0 : _c.channelThumbnailWithLinkRenderer) == null ? void 0 : _d.thumbnail);
    }
  }
};
__name(_VideoCard, "VideoCard");
__publicField(_VideoCard, "type", "VideoCard");
var VideoCard = _VideoCard;

// dist/src/parser/classes/ContentPreviewImageView.js
var _ContentPreviewImageView = class _ContentPreviewImageView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "image");
    __publicField(this, "style");
    this.image = Thumbnail.fromResponse(data.image);
    this.style = data.style;
  }
};
__name(_ContentPreviewImageView, "ContentPreviewImageView");
__publicField(_ContentPreviewImageView, "type", "ContentPreviewImageView");
var ContentPreviewImageView = _ContentPreviewImageView;

// dist/src/parser/classes/VideoAttributeView.js
var _VideoAttributeView = class _VideoAttributeView extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "image");
    __publicField(this, "image_style");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "secondary_subtitle");
    __publicField(this, "orientation");
    __publicField(this, "sizing_rule");
    __publicField(this, "overflow_menu_on_tap");
    __publicField(this, "overflow_menu_a11y_label");
    if ((_a = data.image) == null ? void 0 : _a.sources) {
      this.image = Thumbnail.fromResponse(data.image);
    } else {
      this.image = parser_exports.parseItem(data.image, ContentPreviewImageView);
    }
    this.image_style = data.imageStyle;
    this.title = data.title;
    this.subtitle = data.subtitle;
    if (Reflect.has(data, "secondarySubtitle")) {
      this.secondary_subtitle = {
        content: data.secondarySubtitle.content
      };
    }
    this.orientation = data.orientation;
    this.sizing_rule = data.sizingRule;
    this.overflow_menu_on_tap = new NavigationEndpoint(data.overflowMenuOnTap);
    this.overflow_menu_a11y_label = data.overflowMenuA11yLabel;
  }
};
__name(_VideoAttributeView, "VideoAttributeView");
__publicField(_VideoAttributeView, "type", "VideoAttributeView");
var VideoAttributeView = _VideoAttributeView;

// dist/src/parser/classes/HorizontalCardList.js
var _HorizontalCardList = class _HorizontalCardList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "cards");
    __publicField(this, "header");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.cards = parser_exports.parseArray(data.cards, [VideoAttributeView, SearchRefinementCard, MacroMarkersListItem, GameCard, VideoCard]);
    this.header = parser_exports.parseItem(data.header);
    this.previous_button = parser_exports.parseItem(data.previousButton, Button);
    this.next_button = parser_exports.parseItem(data.nextButton, Button);
  }
};
__name(_HorizontalCardList, "HorizontalCardList");
__publicField(_HorizontalCardList, "type", "HorizontalCardList");
var HorizontalCardList = _HorizontalCardList;

// dist/src/parser/classes/Factoid.js
var _Factoid = class _Factoid extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    __publicField(this, "value");
    __publicField(this, "accessibility_text");
    this.label = new Text2(data.label);
    this.value = new Text2(data.value);
    this.accessibility_text = data.accessibilityText;
  }
};
__name(_Factoid, "Factoid");
__publicField(_Factoid, "type", "Factoid");
var Factoid = _Factoid;

// dist/src/parser/classes/UploadTimeFactoid.js
var _UploadTimeFactoid = class _UploadTimeFactoid extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "factoid");
    this.factoid = parser_exports.parseItem(data.factoid, Factoid);
  }
};
__name(_UploadTimeFactoid, "UploadTimeFactoid");
__publicField(_UploadTimeFactoid, "type", "UploadTimeFactoid");
var UploadTimeFactoid = _UploadTimeFactoid;

// dist/src/parser/classes/ViewCountFactoid.js
var _ViewCountFactoid = class _ViewCountFactoid extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "view_count_entity_key");
    __publicField(this, "factoid");
    __publicField(this, "view_count_type");
    this.view_count_entity_key = data.viewCountEntityKey;
    this.factoid = parser_exports.parseItem(data.factoid, [Factoid]);
    this.view_count_type = data.viewCountType;
  }
};
__name(_ViewCountFactoid, "ViewCountFactoid");
__publicField(_ViewCountFactoid, "type", "ViewCountFactoid");
var ViewCountFactoid = _ViewCountFactoid;

// dist/src/parser/classes/HypePointsFactoid.js
var _HypePointsFactoid = class _HypePointsFactoid extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "factoid");
    this.factoid = parser_exports.parseItem(data.factoid, Factoid);
  }
};
__name(_HypePointsFactoid, "HypePointsFactoid");
__publicField(_HypePointsFactoid, "type", "HypePointsFactoid");
var HypePointsFactoid = _HypePointsFactoid;

// dist/src/parser/classes/VideoDescriptionHeader.js
var _VideoDescriptionHeader = class _VideoDescriptionHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "channel");
    __publicField(this, "channel_navigation_endpoint");
    __publicField(this, "channel_thumbnail");
    __publicField(this, "factoids");
    __publicField(this, "publish_date");
    __publicField(this, "title");
    __publicField(this, "views");
    this.title = new Text2(data.title);
    this.channel = new Text2(data.channel);
    this.channel_navigation_endpoint = new NavigationEndpoint(data.channelNavigationEndpoint);
    this.channel_thumbnail = Thumbnail.fromResponse(data.channelThumbnail);
    this.publish_date = new Text2(data.publishDate);
    this.views = new Text2(data.views);
    this.factoids = parser_exports.parseArray(data.factoid, [Factoid, HypePointsFactoid, ViewCountFactoid, UploadTimeFactoid]);
  }
};
__name(_VideoDescriptionHeader, "VideoDescriptionHeader");
__publicField(_VideoDescriptionHeader, "type", "VideoDescriptionHeader");
var VideoDescriptionHeader = _VideoDescriptionHeader;

// dist/src/parser/classes/VideoDescriptionInfocardsSection.js
var _VideoDescriptionInfocardsSection = class _VideoDescriptionInfocardsSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "creator_videos_button");
    __publicField(this, "creator_about_button");
    __publicField(this, "section_subtitle");
    __publicField(this, "channel_avatar");
    __publicField(this, "channel_endpoint");
    this.section_title = new Text2(data.sectionTitle);
    this.creator_videos_button = parser_exports.parseItem(data.creatorVideosButton, Button);
    this.creator_about_button = parser_exports.parseItem(data.creatorAboutButton, Button);
    this.section_subtitle = new Text2(data.sectionSubtitle);
    this.channel_avatar = Thumbnail.fromResponse(data.channelAvatar);
    this.channel_endpoint = new NavigationEndpoint(data.channelEndpoint);
  }
};
__name(_VideoDescriptionInfocardsSection, "VideoDescriptionInfocardsSection");
__publicField(_VideoDescriptionInfocardsSection, "type", "VideoDescriptionInfocardsSection");
var VideoDescriptionInfocardsSection = _VideoDescriptionInfocardsSection;

// dist/src/parser/classes/InfoRow.js
var _InfoRow = class _InfoRow extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "default_metadata");
    __publicField(this, "expanded_metadata");
    __publicField(this, "info_row_expand_status_key");
    this.title = new Text2(data.title);
    if (Reflect.has(data, "defaultMetadata")) {
      this.default_metadata = new Text2(data.defaultMetadata);
    }
    if (Reflect.has(data, "expandedMetadata")) {
      this.expanded_metadata = new Text2(data.expandedMetadata);
    }
    if (Reflect.has(data, "infoRowExpandStatusKey")) {
      this.info_row_expand_status_key = data.infoRowExpandStatusKey;
    }
  }
};
__name(_InfoRow, "InfoRow");
__publicField(_InfoRow, "type", "InfoRow");
var InfoRow = _InfoRow;

// dist/src/parser/classes/CompactVideo.js
var _CompactVideo = class _CompactVideo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "video_id");
    __publicField(this, "thumbnails");
    __publicField(this, "rich_thumbnail");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "view_count");
    __publicField(this, "short_view_count");
    __publicField(this, "short_byline_text");
    __publicField(this, "long_byline_text");
    __publicField(this, "published");
    __publicField(this, "badges");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "endpoint");
    __publicField(this, "menu");
    __publicField(this, "length_text");
    __publicField(this, "is_watched");
    __publicField(this, "service_endpoints");
    __publicField(this, "service_endpoint");
    __publicField(this, "style");
    this.video_id = data.videoId;
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.title = new Text2(data.title);
    this.author = new Author(data.longBylineText, data.ownerBadges, data.channelThumbnail);
    this.is_watched = !!data.isWatched;
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.badges = parser_exports.parseArray(data.badges, MetadataBadge);
    if ("publishedTimeText" in data)
      this.published = new Text2(data.publishedTimeText);
    if ("shortBylineText" in data)
      this.view_count = new Text2(data.viewCountText);
    if ("shortViewCountText" in data)
      this.short_view_count = new Text2(data.shortViewCountText);
    if ("richThumbnail" in data)
      this.rich_thumbnail = parser_exports.parseItem(data.richThumbnail);
    if ("shortBylineText" in data)
      this.short_byline_text = new Text2(data.shortBylineText);
    if ("longBylineText" in data)
      this.long_byline_text = new Text2(data.longBylineText);
    if ("lengthText" in data)
      this.length_text = new Text2(data.lengthText);
    if ("serviceEndpoints" in data)
      this.service_endpoints = data.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if ("serviceEndpoint" in data)
      this.service_endpoint = new NavigationEndpoint(data.serviceEndpoint);
    if ("navigationEndpoint" in data)
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    if ("style" in data)
      this.style = data.style;
  }
  /**
   * @deprecated Use {@linkcode video_id} instead.
   */
  get id() {
    return this.video_id;
  }
  get duration() {
    var _a;
    const overlay_time_status = this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus);
    const length_text = ((_a = this.length_text) == null ? void 0 : _a.toString()) || (overlay_time_status == null ? void 0 : overlay_time_status.text.toString());
    return {
      text: length_text,
      seconds: length_text ? timeToSeconds(length_text) : 0
    };
  }
  get best_thumbnail() {
    return this.thumbnails[0];
  }
  get is_fundraiser() {
    return this.badges.some((badge) => badge.label === "Fundraiser");
  }
  get is_live() {
    return this.badges.some((badge) => {
      if (badge.style === "BADGE_STYLE_TYPE_LIVE_NOW" || badge.label === "LIVE")
        return true;
    });
  }
  get is_new() {
    return this.badges.some((badge) => badge.label === "New");
  }
  get is_premiere() {
    return this.badges.some((badge) => badge.style === "PREMIERE");
  }
};
__name(_CompactVideo, "CompactVideo");
__publicField(_CompactVideo, "type", "CompactVideo");
var CompactVideo = _CompactVideo;

// dist/src/parser/classes/CarouselLockup.js
var _CarouselLockup = class _CarouselLockup extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "info_rows");
    __publicField(this, "video_lockup");
    this.info_rows = parser_exports.parseArray(data.infoRows, InfoRow);
    this.video_lockup = parser_exports.parseItem(data.videoLockup, CompactVideo);
  }
};
__name(_CarouselLockup, "CarouselLockup");
__publicField(_CarouselLockup, "type", "CarouselLockup");
var CarouselLockup = _CarouselLockup;

// dist/src/parser/classes/VideoDescriptionMusicSection.js
var _VideoDescriptionMusicSection = class _VideoDescriptionMusicSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "carousel_lockups");
    __publicField(this, "section_title");
    this.carousel_lockups = parser_exports.parseArray(data.carouselLockups, CarouselLockup);
    this.section_title = new Text2(data.sectionTitle);
  }
};
__name(_VideoDescriptionMusicSection, "VideoDescriptionMusicSection");
__publicField(_VideoDescriptionMusicSection, "type", "VideoDescriptionMusicSection");
var VideoDescriptionMusicSection = _VideoDescriptionMusicSection;

// dist/src/parser/classes/VideoDescriptionTranscriptSection.js
var _VideoDescriptionTranscriptSection = class _VideoDescriptionTranscriptSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "sub_header_text");
    __publicField(this, "primary_button");
    this.section_title = new Text2(data.sectionTitle);
    this.sub_header_text = new Text2(data.subHeaderText);
    this.primary_button = parser_exports.parseItem(data.primaryButton, Button);
  }
};
__name(_VideoDescriptionTranscriptSection, "VideoDescriptionTranscriptSection");
__publicField(_VideoDescriptionTranscriptSection, "type", "VideoDescriptionTranscriptSection");
var VideoDescriptionTranscriptSection = _VideoDescriptionTranscriptSection;

// dist/src/parser/classes/StructuredDescriptionPlaylistLockup.js
var _StructuredDescriptionPlaylistLockup = class _StructuredDescriptionPlaylistLockup extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "short_byline_text");
    __publicField(this, "video_count_short_text");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnail_width");
    __publicField(this, "aspect_ratio");
    __publicField(this, "max_lines_title");
    __publicField(this, "max_lines_short_byline_text");
    __publicField(this, "overlay_position");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.title = new Text2(data.title);
    this.short_byline_text = new Text2(data.shortBylineText);
    this.video_count_short_text = new Text2(data.videoCountShortText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.thumbnail_width = data.thumbnailWidth;
    this.aspect_ratio = data.aspectRatio;
    this.max_lines_title = data.maxLinesTitle;
    this.max_lines_short_byline_text = data.maxLinesShortBylineText;
    this.overlay_position = data.overlayPosition;
  }
};
__name(_StructuredDescriptionPlaylistLockup, "StructuredDescriptionPlaylistLockup");
__publicField(_StructuredDescriptionPlaylistLockup, "type", "StructuredDescriptionPlaylistLockup");
var StructuredDescriptionPlaylistLockup = _StructuredDescriptionPlaylistLockup;

// dist/src/parser/classes/VideoDescriptionCourseSection.js
var _VideoDescriptionCourseSection = class _VideoDescriptionCourseSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "media_lockups");
    this.section_title = new Text2(data.sectionTitle);
    this.media_lockups = parser_exports.parseArray(data.mediaLockups, [StructuredDescriptionPlaylistLockup]);
  }
};
__name(_VideoDescriptionCourseSection, "VideoDescriptionCourseSection");
__publicField(_VideoDescriptionCourseSection, "type", "VideoDescriptionCourseSection");
var VideoDescriptionCourseSection = _VideoDescriptionCourseSection;

// dist/src/parser/classes/VideoAttributesSectionView.js
var _VideoAttributesSectionView = class _VideoAttributesSectionView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header_title");
    __publicField(this, "header_subtitle");
    __publicField(this, "video_attributes");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.header_title = data.headerTitle;
    this.header_subtitle = data.headerSubtitle;
    this.video_attributes = parser_exports.parseArray(data.videoAttributeViewModels, VideoAttributeView);
    this.previous_button = parser_exports.parseItem(data.previousButton, ButtonView);
    this.next_button = parser_exports.parseItem(data.nextButton, ButtonView);
  }
};
__name(_VideoAttributesSectionView, "VideoAttributesSectionView");
__publicField(_VideoAttributesSectionView, "type", "VideoAttributesSectionView");
var VideoAttributesSectionView = _VideoAttributesSectionView;

// dist/src/parser/classes/HowThisWasMadeSectionView.js
var _HowThisWasMadeSectionView = class _HowThisWasMadeSectionView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "body_text");
    __publicField(this, "body_header");
    if (Reflect.has(data, "sectionText"))
      this.section_title = Text2.fromAttributed(data.sectionText);
    if (Reflect.has(data, "bodyText"))
      this.body_text = Text2.fromAttributed(data.bodyText);
    if (Reflect.has(data, "bodyHeader"))
      this.body_header = Text2.fromAttributed(data.bodyHeader);
  }
};
__name(_HowThisWasMadeSectionView, "HowThisWasMadeSectionView");
__publicField(_HowThisWasMadeSectionView, "type", "HowThisWasMadeSectionView");
var HowThisWasMadeSectionView = _HowThisWasMadeSectionView;

// dist/src/parser/classes/ReelShelf.js
var _ReelShelf = class _ReelShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    __publicField(this, "endpoint");
    this.title = new Text2(data.title);
    this.items = parser_exports.parseArray(data.items);
    if (Reflect.has(data, "endpoint")) {
      this.endpoint = new NavigationEndpoint(data.endpoint);
    }
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ReelShelf, "ReelShelf");
__publicField(_ReelShelf, "type", "ReelShelf");
var ReelShelf = _ReelShelf;

// dist/src/parser/classes/StructuredDescriptionContent.js
var _StructuredDescriptionContent = class _StructuredDescriptionContent extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items, [
      VideoDescriptionHeader,
      ExpandableVideoDescriptionBody,
      VideoDescriptionMusicSection,
      VideoDescriptionInfocardsSection,
      VideoDescriptionCourseSection,
      VideoDescriptionTranscriptSection,
      VideoDescriptionTranscriptSection,
      HorizontalCardList,
      ReelShelf,
      VideoAttributesSectionView,
      HowThisWasMadeSectionView
    ]);
  }
};
__name(_StructuredDescriptionContent, "StructuredDescriptionContent");
__publicField(_StructuredDescriptionContent, "type", "StructuredDescriptionContent");
var StructuredDescriptionContent = _StructuredDescriptionContent;

// dist/src/parser/classes/EngagementPanelSectionList.js
var _EngagementPanelSectionList = class _EngagementPanelSectionList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "content");
    __publicField(this, "target_id");
    __publicField(this, "panel_identifier");
    __publicField(this, "identifier");
    __publicField(this, "visibility");
    this.header = parser_exports.parseItem(data.header, EngagementPanelTitleHeader);
    this.content = parser_exports.parseItem(data.content, [VideoAttributeView, SectionList, ContinuationItem, ClipSection, StructuredDescriptionContent, MacroMarkersList, ProductList]);
    this.panel_identifier = data.panelIdentifier;
    this.identifier = data.identifier ? {
      surface: data.identifier.surface,
      tag: data.identifier.tag
    } : void 0;
    this.target_id = data.targetId;
    this.visibility = data.visibility;
  }
};
__name(_EngagementPanelSectionList, "EngagementPanelSectionList");
__publicField(_EngagementPanelSectionList, "type", "EngagementPanelSectionList");
var EngagementPanelSectionList = _EngagementPanelSectionList;

// dist/src/parser/classes/ChannelTagline.js
var _ChannelTagline = class _ChannelTagline extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    __publicField(this, "max_lines");
    __publicField(this, "more_endpoint");
    __publicField(this, "more_icon_type");
    __publicField(this, "more_label");
    __publicField(this, "target_id");
    this.content = data.content;
    this.max_lines = data.maxLines;
    this.more_endpoint = data.moreEndpoint.showEngagementPanelEndpoint ? {
      show_engagement_panel_endpoint: {
        engagement_panel: parser_exports.parseItem(data.moreEndpoint.showEngagementPanelEndpoint.engagementPanel, EngagementPanelSectionList),
        engagement_panel_popup_type: data.moreEndpoint.showEngagementPanelEndpoint.engagementPanelPresentationConfigs.engagementPanelPopupPresentationConfig.popupType,
        identifier: {
          surface: data.moreEndpoint.showEngagementPanelEndpoint.identifier.surface,
          tag: data.moreEndpoint.showEngagementPanelEndpoint.identifier.tag
        }
      }
    } : new NavigationEndpoint(data.moreEndpoint);
    this.more_icon_type = data.moreIcon.iconType;
    this.more_label = data.moreLabel;
    this.target_id = data.targetId;
  }
};
__name(_ChannelTagline, "ChannelTagline");
__publicField(_ChannelTagline, "type", "ChannelTagline");
var ChannelTagline = _ChannelTagline;

// dist/src/parser/classes/SubscriptionNotificationToggleButton.js
var _SubscriptionNotificationToggleButton = class _SubscriptionNotificationToggleButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "states");
    __publicField(this, "current_state_id");
    __publicField(this, "target_id");
    this.states = data.states.map((data2) => ({
      id: data2.stateId,
      next_id: data2.nextStateId,
      state: parser_exports.parse(data2.state)
    }));
    this.current_state_id = data.currentStateId;
    this.target_id = data.targetId;
  }
};
__name(_SubscriptionNotificationToggleButton, "SubscriptionNotificationToggleButton");
__publicField(_SubscriptionNotificationToggleButton, "type", "SubscriptionNotificationToggleButton");
var SubscriptionNotificationToggleButton = _SubscriptionNotificationToggleButton;

// dist/src/parser/classes/SubscribeButton.js
var _SubscribeButton = class _SubscribeButton extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "button_text");
    __publicField(this, "subscribed");
    __publicField(this, "enabled");
    __publicField(this, "item_type");
    __publicField(this, "channel_id");
    __publicField(this, "show_preferences");
    __publicField(this, "subscribed_text");
    __publicField(this, "unsubscribed_text");
    __publicField(this, "unsubscribe_text");
    __publicField(this, "notification_preference_button");
    __publicField(this, "service_endpoints");
    __publicField(this, "on_subscribe_endpoints");
    __publicField(this, "on_unsubscribe_endpoints");
    __publicField(this, "subscribed_entity_key");
    __publicField(this, "target_id");
    __publicField(this, "subscribe_accessibility_label");
    __publicField(this, "unsubscribe_accessibility_label");
    this.button_text = new Text2(data.buttonText);
    this.subscribed = data.subscribed;
    this.enabled = data.enabled;
    this.item_type = data.type;
    this.channel_id = data.channelId;
    this.show_preferences = data.showPreferences;
    if (Reflect.has(data, "subscribedButtonText"))
      this.subscribed_text = new Text2(data.subscribedButtonText);
    if (Reflect.has(data, "unsubscribedButtonText"))
      this.unsubscribed_text = new Text2(data.unsubscribedButtonText);
    if (Reflect.has(data, "unsubscribeButtonText"))
      this.unsubscribe_text = new Text2(data.unsubscribeButtonText);
    this.notification_preference_button = parser_exports.parseItem(data.notificationPreferenceButton, SubscriptionNotificationToggleButton);
    if (Reflect.has(data, "serviceEndpoints"))
      this.service_endpoints = data.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if (Reflect.has(data, "onSubscribeEndpoints"))
      this.on_subscribe_endpoints = data.onSubscribeEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if (Reflect.has(data, "onUnsubscribeEndpoints"))
      this.on_unsubscribe_endpoints = data.onUnsubscribeEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if (Reflect.has(data, "subscribedEntityKey"))
      this.subscribed_entity_key = data.subscribedEntityKey;
    if (Reflect.has(data, "targetId"))
      this.target_id = data.targetId;
    if (Reflect.has(data, "subscribeAccessibility"))
      this.subscribe_accessibility_label = (_a = data.subscribeAccessibility.accessibilityData) == null ? void 0 : _a.label;
    if (Reflect.has(data, "unsubscribeAccessibility"))
      this.unsubscribe_accessibility_label = (_b = data.unsubscribeAccessibility.accessibilityData) == null ? void 0 : _b.label;
  }
};
__name(_SubscribeButton, "SubscribeButton");
__publicField(_SubscribeButton, "type", "SubscribeButton");
var SubscribeButton = _SubscribeButton;

// dist/src/parser/classes/C4TabbedHeader.js
var _C4TabbedHeader = class _C4TabbedHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "author");
    __publicField(this, "banner");
    __publicField(this, "tv_banner");
    __publicField(this, "mobile_banner");
    __publicField(this, "subscribers");
    __publicField(this, "videos_count");
    __publicField(this, "sponsor_button");
    __publicField(this, "subscribe_button");
    __publicField(this, "header_links");
    __publicField(this, "channel_handle");
    __publicField(this, "channel_id");
    __publicField(this, "tagline");
    this.author = new Author({
      simpleText: data.title,
      navigationEndpoint: data.navigationEndpoint
    }, data.badges, data.avatar);
    if (Reflect.has(data, "banner")) {
      this.banner = Thumbnail.fromResponse(data.banner);
    }
    if (Reflect.has(data, "tv_banner")) {
      this.tv_banner = Thumbnail.fromResponse(data.tvBanner);
    }
    if (Reflect.has(data, "mobile_banner")) {
      this.mobile_banner = Thumbnail.fromResponse(data.mobileBanner);
    }
    if (Reflect.has(data, "subscriberCountText")) {
      this.subscribers = new Text2(data.subscriberCountText);
    }
    if (Reflect.has(data, "videosCountText")) {
      this.videos_count = new Text2(data.videosCountText);
    }
    if (Reflect.has(data, "sponsorButton")) {
      this.sponsor_button = parser_exports.parseItem(data.sponsorButton, Button);
    }
    if (Reflect.has(data, "subscribeButton")) {
      this.subscribe_button = parser_exports.parseItem(data.subscribeButton, [SubscribeButton, Button]);
    }
    if (Reflect.has(data, "headerLinks")) {
      this.header_links = parser_exports.parseItem(data.headerLinks, [ChannelHeaderLinks, ChannelHeaderLinksView]);
    }
    if (Reflect.has(data, "channelHandleText")) {
      this.channel_handle = new Text2(data.channelHandleText);
    }
    if (Reflect.has(data, "channelId")) {
      this.channel_id = data.channelId;
    }
    if (Reflect.has(data, "tagline")) {
      this.tagline = parser_exports.parseItem(data.tagline, ChannelTagline);
    }
  }
};
__name(_C4TabbedHeader, "C4TabbedHeader");
__publicField(_C4TabbedHeader, "type", "C4TabbedHeader");
var C4TabbedHeader = _C4TabbedHeader;

// dist/src/parser/classes/CallToActionButton.js
var _CallToActionButton = class _CallToActionButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    __publicField(this, "icon_type");
    __publicField(this, "style");
    this.label = new Text2(data.label);
    this.icon_type = data.icon.iconType;
    this.style = data.style;
  }
};
__name(_CallToActionButton, "CallToActionButton");
__publicField(_CallToActionButton, "type", "CallToActionButton");
var CallToActionButton = _CallToActionButton;

// dist/src/parser/classes/Card.js
var _Card = class _Card extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "teaser");
    __publicField(this, "content");
    __publicField(this, "card_id");
    __publicField(this, "feature");
    __publicField(this, "cue_ranges");
    this.teaser = parser_exports.parseItem(data.teaser);
    this.content = parser_exports.parseItem(data.content);
    if (Reflect.has(data, "cardId")) {
      this.card_id = data.cardId;
    }
    if (Reflect.has(data, "feature")) {
      this.feature = data.feature;
    }
    this.cue_ranges = data.cueRanges.map((cr) => ({
      start_card_active_ms: cr.startCardActiveMs,
      end_card_active_ms: cr.endCardActiveMs,
      teaser_duration_ms: cr.teaserDurationMs,
      icon_after_teaser_ms: cr.iconAfterTeaserMs
    }));
  }
};
__name(_Card, "Card");
__publicField(_Card, "type", "Card");
var Card = _Card;

// dist/src/parser/classes/CardCollection.js
var _CardCollection = class _CardCollection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "cards");
    __publicField(this, "header");
    __publicField(this, "allow_teaser_dismiss");
    this.cards = parser_exports.parseArray(data.cards);
    this.header = new Text2(data.headerText);
    this.allow_teaser_dismiss = data.allowTeaserDismiss;
  }
};
__name(_CardCollection, "CardCollection");
__publicField(_CardCollection, "type", "CardCollection");
var CardCollection = _CardCollection;

// dist/src/parser/classes/CarouselHeader.js
var _CarouselHeader = class _CarouselHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data.contents);
  }
};
__name(_CarouselHeader, "CarouselHeader");
__publicField(_CarouselHeader, "type", "CarouselHeader");
var CarouselHeader = _CarouselHeader;

// dist/src/parser/classes/CarouselItem.js
var _CarouselItem = class _CarouselItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    __publicField(this, "background_color");
    __publicField(this, "layout_style");
    __publicField(this, "pagination_thumbnails");
    __publicField(this, "paginator_alignment");
    this.items = parser_exports.parseArray(data.carouselItems);
    this.background_color = data.backgroundColor;
    this.layout_style = data.layoutStyle;
    this.pagination_thumbnails = Thumbnail.fromResponse(data.paginationThumbnails);
    this.paginator_alignment = data.paginatorAlignment;
  }
  // XXX: For consistency.
  get contents() {
    return this.items;
  }
};
__name(_CarouselItem, "CarouselItem");
__publicField(_CarouselItem, "type", "CarouselItem");
var CarouselItem = _CarouselItem;

// dist/src/parser/classes/TextCarouselItemView.js
var _TextCarouselItemView = class _TextCarouselItemView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "icon_name");
    __publicField(this, "text");
    __publicField(this, "on_tap_endpoint");
    __publicField(this, "button");
    this.icon_name = data.iconName;
    this.text = Text2.fromAttributed(data.text);
    this.on_tap_endpoint = new NavigationEndpoint(data.onTap);
    this.button = parser_exports.parseItem(data.button, ButtonView);
  }
};
__name(_TextCarouselItemView, "TextCarouselItemView");
__publicField(_TextCarouselItemView, "type", "TextCarouselItemView");
var TextCarouselItemView = _TextCarouselItemView;

// dist/src/parser/classes/CarouselItemView.js
var _CarouselItemView = class _CarouselItemView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "item_type");
    __publicField(this, "carousel_item");
    this.item_type = data.itemType;
    this.carousel_item = parser_exports.parseItem(data.carouselItem, TextCarouselItemView);
  }
};
__name(_CarouselItemView, "CarouselItemView");
__publicField(_CarouselItemView, "type", "CarouselItemView");
var CarouselItemView = _CarouselItemView;

// dist/src/parser/classes/CarouselTitleView.js
var _CarouselTitleView = class _CarouselTitleView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.title = data.title;
    this.previous_button = parser_exports.parseItem(data.previousButton, ButtonView);
    this.next_button = parser_exports.parseItem(data.nextButton, ButtonView);
  }
};
__name(_CarouselTitleView, "CarouselTitleView");
__publicField(_CarouselTitleView, "type", "CarouselTitleView");
var CarouselTitleView = _CarouselTitleView;

// dist/src/parser/classes/Channel.js
var _Channel = class _Channel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "subscriber_count");
    __publicField(this, "video_count");
    __publicField(this, "long_byline");
    __publicField(this, "short_byline");
    __publicField(this, "endpoint");
    __publicField(this, "subscribe_button");
    __publicField(this, "description_snippet");
    this.id = data.channelId;
    this.author = new Author({
      ...data.title,
      navigationEndpoint: data.navigationEndpoint
    }, data.ownerBadges, data.thumbnail);
    this.subscriber_count = new Text2(data.subscriberCountText);
    this.video_count = new Text2(data.videoCountText);
    this.long_byline = new Text2(data.longBylineText);
    this.short_byline = new Text2(data.shortBylineText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.subscribe_button = parser_exports.parseItem(data.subscribeButton, [SubscribeButton, Button]);
    this.description_snippet = new Text2(data.descriptionSnippet);
  }
};
__name(_Channel, "Channel");
__publicField(_Channel, "type", "Channel");
var Channel = _Channel;

// dist/src/parser/classes/ChannelAboutFullMetadata.js
var _ChannelAboutFullMetadata = class _ChannelAboutFullMetadata extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "id");
    __publicField(this, "name");
    __publicField(this, "avatar");
    __publicField(this, "canonical_channel_url");
    __publicField(this, "primary_links");
    __publicField(this, "view_count");
    __publicField(this, "joined_date");
    __publicField(this, "description");
    __publicField(this, "email_reveal");
    __publicField(this, "can_reveal_email");
    __publicField(this, "country");
    __publicField(this, "buttons");
    this.id = data.channelId;
    this.name = new Text2(data.title);
    this.avatar = Thumbnail.fromResponse(data.avatar);
    this.canonical_channel_url = data.canonicalChannelUrl;
    this.primary_links = (_b = (_a = data.primaryLinks) == null ? void 0 : _a.map((link) => ({
      endpoint: new NavigationEndpoint(link.navigationEndpoint),
      icon: Thumbnail.fromResponse(link.icon),
      title: new Text2(link.title)
    }))) != null ? _b : [];
    this.view_count = new Text2(data.viewCountText);
    this.joined_date = new Text2(data.joinedDateText);
    this.description = new Text2(data.description);
    this.email_reveal = new NavigationEndpoint(data.onBusinessEmailRevealClickCommand);
    this.can_reveal_email = !data.signInForBusinessEmail;
    this.country = new Text2(data.country);
    this.buttons = parser_exports.parseArray(data.actionButtons, Button);
  }
};
__name(_ChannelAboutFullMetadata, "ChannelAboutFullMetadata");
__publicField(_ChannelAboutFullMetadata, "type", "ChannelAboutFullMetadata");
var ChannelAboutFullMetadata = _ChannelAboutFullMetadata;

// dist/src/parser/classes/ChannelAgeGate.js
var _ChannelAgeGate = class _ChannelAgeGate extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "channel_title");
    __publicField(this, "avatar");
    __publicField(this, "header");
    __publicField(this, "main_text");
    __publicField(this, "sign_in_button");
    __publicField(this, "secondary_text");
    this.channel_title = data.channelTitle;
    this.avatar = Thumbnail.fromResponse(data.avatar);
    this.header = new Text2(data.header);
    this.main_text = new Text2(data.mainText);
    this.sign_in_button = parser_exports.parseItem(data.signInButton, Button);
    this.secondary_text = new Text2(data.secondaryText);
  }
};
__name(_ChannelAgeGate, "ChannelAgeGate");
__publicField(_ChannelAgeGate, "type", "ChannelAgeGate");
var ChannelAgeGate = _ChannelAgeGate;

// dist/src/parser/classes/ChannelFeaturedContent.js
var _ChannelFeaturedContent = class _ChannelFeaturedContent extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    this.title = new Text2(data.title);
    this.items = parser_exports.parseArray(data.items);
  }
};
__name(_ChannelFeaturedContent, "ChannelFeaturedContent");
__publicField(_ChannelFeaturedContent, "type", "ChannelFeaturedContent");
var ChannelFeaturedContent = _ChannelFeaturedContent;

// dist/src/parser/classes/ChannelMetadata.js
var _ChannelMetadata = class _ChannelMetadata extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "url");
    __publicField(this, "rss_url");
    __publicField(this, "vanity_channel_url");
    __publicField(this, "external_id");
    __publicField(this, "is_family_safe");
    __publicField(this, "keywords");
    __publicField(this, "avatar");
    __publicField(this, "music_artist_name");
    __publicField(this, "available_countries");
    __publicField(this, "android_deep_link");
    __publicField(this, "android_appindexing_link");
    __publicField(this, "ios_appindexing_link");
    this.title = data.title;
    this.description = data.description;
    this.url = data.channelUrl;
    this.rss_url = data.rssUrl;
    this.vanity_channel_url = data.vanityChannelUrl;
    this.external_id = data.externalId;
    this.is_family_safe = data.isFamilySafe;
    this.keywords = data.keywords;
    this.avatar = Thumbnail.fromResponse(data.avatar);
    this.music_artist_name = typeof data.musicArtistName === "string" && data.musicArtistName.length > 0 ? data.musicArtistName : void 0;
    this.available_countries = data.availableCountryCodes;
    this.android_deep_link = data.androidDeepLink;
    this.android_appindexing_link = data.androidAppindexingLink;
    this.ios_appindexing_link = data.iosAppindexingLink;
  }
};
__name(_ChannelMetadata, "ChannelMetadata");
__publicField(_ChannelMetadata, "type", "ChannelMetadata");
var ChannelMetadata = _ChannelMetadata;

// dist/src/parser/classes/ChannelMobileHeader.js
var _ChannelMobileHeader = class _ChannelMobileHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_ChannelMobileHeader, "ChannelMobileHeader");
__publicField(_ChannelMobileHeader, "type", "ChannelMobileHeader");
var ChannelMobileHeader = _ChannelMobileHeader;

// dist/src/parser/classes/ChannelOptions.js
var _ChannelOptions = class _ChannelOptions extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "avatar");
    __publicField(this, "endpoint");
    __publicField(this, "name");
    __publicField(this, "links");
    this.avatar = Thumbnail.fromResponse(data.avatar);
    this.endpoint = new NavigationEndpoint(data.avatarEndpoint);
    this.name = data.name;
    this.links = data.links.map((link) => new Text2(link));
  }
};
__name(_ChannelOptions, "ChannelOptions");
__publicField(_ChannelOptions, "type", "ChannelOptions");
var ChannelOptions = _ChannelOptions;

// dist/src/parser/classes/ChannelOwnerEmptyState.js
var _ChannelOwnerEmptyState = class _ChannelOwnerEmptyState extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "illustration");
    __publicField(this, "description");
    this.illustration = Thumbnail.fromResponse(data.illustration);
    this.description = new Text2(data.description);
  }
};
__name(_ChannelOwnerEmptyState, "ChannelOwnerEmptyState");
__publicField(_ChannelOwnerEmptyState, "type", "ChannelOwnerEmptyState");
var ChannelOwnerEmptyState = _ChannelOwnerEmptyState;

// dist/src/parser/classes/ChannelSubMenu.js
var _ChannelSubMenu = class _ChannelSubMenu extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content_type_sub_menu_items");
    __publicField(this, "sort_setting");
    this.content_type_sub_menu_items = data.contentTypeSubMenuItems.map((item) => ({
      endpoint: new NavigationEndpoint(item.navigationEndpoint || item.endpoint),
      selected: item.selected,
      title: item.title
    }));
    this.sort_setting = parser_exports.parseItem(data.sortSetting);
  }
};
__name(_ChannelSubMenu, "ChannelSubMenu");
__publicField(_ChannelSubMenu, "type", "ChannelSubMenu");
var ChannelSubMenu = _ChannelSubMenu;

// dist/src/parser/classes/ChannelSwitcherHeader.js
var _ChannelSwitcherHeader = class _ChannelSwitcherHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "button");
    this.title = new Text2(data.title).toString();
    if (Reflect.has(data, "button")) {
      this.button = parser_exports.parseItem(data.button, Button);
    }
  }
};
__name(_ChannelSwitcherHeader, "ChannelSwitcherHeader");
__publicField(_ChannelSwitcherHeader, "type", "ChannelSwitcherHeader");
var ChannelSwitcherHeader = _ChannelSwitcherHeader;

// dist/src/parser/classes/ChannelThumbnailWithLink.js
var _ChannelThumbnailWithLink = class _ChannelThumbnailWithLink extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "endpoint");
    __publicField(this, "accessibility");
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    if ("accessibility" in data && "accessibilityData" in data.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    var _a, _b;
    return (_b = (_a = this.accessibility) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
};
__name(_ChannelThumbnailWithLink, "ChannelThumbnailWithLink");
__publicField(_ChannelThumbnailWithLink, "type", "ChannelThumbnailWithLink");
var ChannelThumbnailWithLink = _ChannelThumbnailWithLink;

// dist/src/parser/classes/ChannelVideoPlayer.js
var _ChannelVideoPlayer = class _ChannelVideoPlayer extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "view_count");
    __publicField(this, "published_time");
    this.id = data.videoId;
    this.title = new Text2(data.title);
    this.description = new Text2(data.description);
    this.view_count = new Text2(data.viewCountText);
    this.published_time = new Text2(data.publishedTimeText);
  }
};
__name(_ChannelVideoPlayer, "ChannelVideoPlayer");
__publicField(_ChannelVideoPlayer, "type", "ChannelVideoPlayer");
var ChannelVideoPlayer = _ChannelVideoPlayer;

// dist/src/parser/classes/Chapter.js
var _Chapter = class _Chapter extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "time_range_start_millis");
    __publicField(this, "thumbnail");
    this.title = new Text2(data.title);
    this.time_range_start_millis = data.timeRangeStartMillis;
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_Chapter, "Chapter");
__publicField(_Chapter, "type", "Chapter");
var Chapter = _Chapter;

// dist/src/parser/classes/ChildVideo.js
var _ChildVideo = class _ChildVideo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    this.id = data.videoId;
    this.title = new Text2(data.title);
    this.duration = {
      text: data.lengthText.simpleText,
      seconds: timeToSeconds(data.lengthText.simpleText)
    };
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
  }
};
__name(_ChildVideo, "ChildVideo");
__publicField(_ChildVideo, "type", "ChildVideo");
var ChildVideo = _ChildVideo;

// dist/src/parser/classes/ChipView.js
var _ChipView = class _ChipView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "display_type");
    __publicField(this, "endpoint");
    __publicField(this, "chip_entity_key");
    this.text = data.text;
    this.display_type = data.displayType;
    this.endpoint = new NavigationEndpoint(data.tapCommand);
    this.chip_entity_key = data.chipEntityKey;
  }
};
__name(_ChipView, "ChipView");
__publicField(_ChipView, "type", "ChipView");
var ChipView = _ChipView;

// dist/src/parser/classes/ChipBarView.js
var _ChipBarView = class _ChipBarView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "chips");
    this.chips = parser_exports.parseArray(data.chips, ChipView);
  }
};
__name(_ChipBarView, "ChipBarView");
__publicField(_ChipBarView, "type", "ChipBarView");
var ChipBarView = _ChipBarView;

// dist/src/parser/classes/ChipCloudChip.js
var _ChipCloudChip = class _ChipCloudChip extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "is_selected");
    __publicField(this, "endpoint");
    __publicField(this, "text");
    this.is_selected = data.isSelected;
    if (Reflect.has(data, "navigationEndpoint")) {
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    }
    this.text = new Text2(data.text).toString();
  }
};
__name(_ChipCloudChip, "ChipCloudChip");
__publicField(_ChipCloudChip, "type", "ChipCloudChip");
var ChipCloudChip = _ChipCloudChip;

// dist/src/parser/classes/ChipCloud.js
var _ChipCloud = class _ChipCloud extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "chips");
    __publicField(this, "next_button");
    __publicField(this, "previous_button");
    __publicField(this, "horizontal_scrollable");
    this.chips = parser_exports.parseArray(data.chips, ChipCloudChip);
    this.next_button = parser_exports.parseItem(data.nextButton, Button);
    this.previous_button = parser_exports.parseItem(data.previousButton, Button);
    this.horizontal_scrollable = data.horizontalScrollable;
  }
};
__name(_ChipCloud, "ChipCloud");
__publicField(_ChipCloud, "type", "ChipCloud");
var ChipCloud = _ChipCloud;

// dist/src/parser/classes/ClientSideToggleMenuItem.js
var _ClientSideToggleMenuItem = class _ClientSideToggleMenuItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    __publicField(this, "toggled_text");
    __publicField(this, "toggled_icon_type");
    __publicField(this, "is_toggled");
    __publicField(this, "menu_item_identifier");
    __publicField(this, "endpoint");
    __publicField(this, "logging_directives");
    this.text = new Text2(data.defaultText);
    this.icon_type = data.defaultIcon.iconType;
    this.toggled_text = new Text2(data.toggledText);
    this.toggled_icon_type = data.toggledIcon.iconType;
    if (Reflect.has(data, "isToggled")) {
      this.is_toggled = data.isToggled;
    }
    this.menu_item_identifier = data.menuItemIdentifier;
    this.endpoint = new NavigationEndpoint(data.command);
    if (Reflect.has(data, "loggingDirectives")) {
      this.logging_directives = {
        visibility: {
          types: data.loggingDirectives.visibility.types
        },
        enable_displaylogger_experiment: data.loggingDirectives.enableDisplayloggerExperiment
      };
    }
  }
};
__name(_ClientSideToggleMenuItem, "ClientSideToggleMenuItem");
__publicField(_ClientSideToggleMenuItem, "type", "ClientSideToggleMenuItem");
var ClientSideToggleMenuItem = _ClientSideToggleMenuItem;

// dist/src/parser/classes/CollaboratorInfoCardContent.js
var _CollaboratorInfoCardContent = class _CollaboratorInfoCardContent extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "channel_avatar");
    __publicField(this, "custom_text");
    __publicField(this, "channel_name");
    __publicField(this, "subscriber_count");
    __publicField(this, "endpoint");
    this.channel_avatar = Thumbnail.fromResponse(data.channelAvatar);
    this.custom_text = new Text2(data.customText);
    this.channel_name = new Text2(data.channelName);
    this.subscriber_count = new Text2(data.subscriberCountText);
    this.endpoint = new NavigationEndpoint(data.endpoint);
  }
};
__name(_CollaboratorInfoCardContent, "CollaboratorInfoCardContent");
__publicField(_CollaboratorInfoCardContent, "type", "CollaboratorInfoCardContent");
var CollaboratorInfoCardContent = _CollaboratorInfoCardContent;

// dist/src/parser/classes/CollageHeroImage.js
var _CollageHeroImage = class _CollageHeroImage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "left");
    __publicField(this, "top_right");
    __publicField(this, "bottom_right");
    __publicField(this, "endpoint");
    this.left = Thumbnail.fromResponse(data.leftThumbnail);
    this.top_right = Thumbnail.fromResponse(data.topRightThumbnail);
    this.bottom_right = Thumbnail.fromResponse(data.bottomRightThumbnail);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
  }
};
__name(_CollageHeroImage, "CollageHeroImage");
__publicField(_CollageHeroImage, "type", "CollageHeroImage");
var CollageHeroImage = _CollageHeroImage;

// dist/src/parser/classes/ThumbnailHoverOverlayView.js
var _ThumbnailHoverOverlayView = class _ThumbnailHoverOverlayView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "icon_name");
    __publicField(this, "text");
    __publicField(this, "style");
    this.icon_name = data.icon.sources[0].clientResource.imageName;
    this.text = Text2.fromAttributed(data.text);
    this.style = data.style;
  }
};
__name(_ThumbnailHoverOverlayView, "ThumbnailHoverOverlayView");
__publicField(_ThumbnailHoverOverlayView, "type", "ThumbnailHoverOverlayView");
var ThumbnailHoverOverlayView = _ThumbnailHoverOverlayView;

// dist/src/parser/classes/ThumbnailBadgeView.js
var _ThumbnailBadgeView = class _ThumbnailBadgeView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "icon_name");
    __publicField(this, "text");
    __publicField(this, "badge_style");
    __publicField(this, "background_color");
    this.text = data.text;
    this.badge_style = data.badgeStyle;
    if (data.backgroundColor) {
      this.background_color = {
        light_theme: data.backgroundColor.lightTheme,
        dark_theme: data.backgroundColor.darkTheme
      };
    }
    if (data.iconName) {
      this.icon_name = data.icon.sources[0].clientResource.imageName;
    }
  }
};
__name(_ThumbnailBadgeView, "ThumbnailBadgeView");
__publicField(_ThumbnailBadgeView, "type", "ThumbnailBadgeView");
var ThumbnailBadgeView = _ThumbnailBadgeView;

// dist/src/parser/classes/ThumbnailOverlayBadgeView.js
var _ThumbnailOverlayBadgeView = class _ThumbnailOverlayBadgeView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "badges");
    __publicField(this, "position");
    this.badges = parser_exports.parseArray(data.thumbnailBadges, ThumbnailBadgeView);
    this.position = data.position;
  }
};
__name(_ThumbnailOverlayBadgeView, "ThumbnailOverlayBadgeView");
__publicField(_ThumbnailOverlayBadgeView, "type", "ThumbnailOverlayBadgeView");
var ThumbnailOverlayBadgeView = _ThumbnailOverlayBadgeView;

// dist/src/parser/classes/ThumbnailHoverOverlayToggleActionsView.js
var _ThumbnailHoverOverlayToggleActionsView = class _ThumbnailHoverOverlayToggleActionsView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "buttons");
    this.buttons = parser_exports.parseArray(data.buttons, ToggleButtonView);
  }
};
__name(_ThumbnailHoverOverlayToggleActionsView, "ThumbnailHoverOverlayToggleActionsView");
__publicField(_ThumbnailHoverOverlayToggleActionsView, "type", "ThumbnailHoverOverlayToggleActionsView");
var ThumbnailHoverOverlayToggleActionsView = _ThumbnailHoverOverlayToggleActionsView;

// dist/src/parser/classes/ThumbnailOverlayProgressBarView.js
var _ThumbnailOverlayProgressBarView = class _ThumbnailOverlayProgressBarView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "start_percent");
    this.start_percent = data.startPercent;
  }
};
__name(_ThumbnailOverlayProgressBarView, "ThumbnailOverlayProgressBarView");
__publicField(_ThumbnailOverlayProgressBarView, "type", "ThumbnailOverlayProgressBarView");
var ThumbnailOverlayProgressBarView = _ThumbnailOverlayProgressBarView;

// dist/src/parser/classes/ThumbnailBottomOverlayView.js
var _ThumbnailBottomOverlayView = class _ThumbnailBottomOverlayView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "progress_bar");
    __publicField(this, "badges");
    this.progress_bar = parser_exports.parseItem(data.progressBar, ThumbnailOverlayProgressBarView);
    this.badges = parser_exports.parseArray(data.badges, ThumbnailBadgeView);
  }
};
__name(_ThumbnailBottomOverlayView, "ThumbnailBottomOverlayView");
__publicField(_ThumbnailBottomOverlayView, "type", "ThumbnailBottomOverlayView");
var ThumbnailBottomOverlayView = _ThumbnailBottomOverlayView;

// dist/src/parser/classes/ThumbnailView.js
var _ThumbnailView = class _ThumbnailView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "image");
    __publicField(this, "overlays");
    __publicField(this, "background_color");
    this.image = Thumbnail.fromResponse(data.image);
    this.overlays = parser_exports.parseArray(data.overlays, [
      ThumbnailHoverOverlayToggleActionsView,
      ThumbnailBottomOverlayView,
      ThumbnailOverlayBadgeView,
      ThumbnailHoverOverlayView,
      AnimatedThumbnailOverlayView
    ]);
    if ("backgroundColor" in data) {
      this.background_color = {
        light_theme: data.backgroundColor.lightTheme,
        dark_theme: data.backgroundColor.darkTheme
      };
    }
  }
};
__name(_ThumbnailView, "ThumbnailView");
__publicField(_ThumbnailView, "type", "ThumbnailView");
var ThumbnailView = _ThumbnailView;

// dist/src/parser/classes/CollectionThumbnailView.js
var _CollectionThumbnailView = class _CollectionThumbnailView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "primary_thumbnail");
    __publicField(this, "stack_color");
    this.primary_thumbnail = parser_exports.parseItem(data.primaryThumbnail, ThumbnailView);
    if (data.stackColor) {
      this.stack_color = {
        light_theme: data.stackColor.lightTheme,
        dark_theme: data.stackColor.darkTheme
      };
    }
  }
};
__name(_CollectionThumbnailView, "CollectionThumbnailView");
__publicField(_CollectionThumbnailView, "type", "CollectionThumbnailView");
var CollectionThumbnailView = _CollectionThumbnailView;

// dist/src/parser/classes/commands/AddToPlaylistCommand.js
var _AddToPlaylistCommand = class _AddToPlaylistCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "open_miniplayer");
    __publicField(this, "video_id");
    __publicField(this, "list_type");
    __publicField(this, "endpoint");
    __publicField(this, "video_ids");
    this.open_miniplayer = data.openMiniplayer;
    this.video_id = data.videoId;
    this.list_type = data.listType;
    this.endpoint = new NavigationEndpoint(data.onCreateListCommand);
    this.video_ids = data.videoIds;
  }
};
__name(_AddToPlaylistCommand, "AddToPlaylistCommand");
__publicField(_AddToPlaylistCommand, "type", "AddToPlaylistCommand");
var AddToPlaylistCommand = _AddToPlaylistCommand;

// dist/src/parser/classes/commands/ContinuationCommand.js
var _data;
var _ContinuationCommand = class _ContinuationCommand extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data);
    __privateSet(this, _data, data);
  }
  getApiPath() {
    switch (__privateGet(this, _data).request) {
      case "CONTINUATION_REQUEST_TYPE_WATCH_NEXT":
        return "next";
      case "CONTINUATION_REQUEST_TYPE_BROWSE":
        return "browse";
      case "CONTINUATION_REQUEST_TYPE_SEARCH":
        return "search";
      case "CONTINUATION_REQUEST_TYPE_ACCOUNTS_LIST":
        return "account/accounts_list";
      case "CONTINUATION_REQUEST_TYPE_COMMENTS_NOTIFICATION_MENU":
        return "notification/get_notification_menu";
      case "CONTINUATION_REQUEST_TYPE_COMMENT_REPLIES":
        return "comment/get_comment_replies";
      case "CONTINUATION_REQUEST_TYPE_REEL_WATCH_SEQUENCE":
        return "reel/reel_watch_sequence";
      case "CONTINUATION_REQUEST_TYPE_GET_PANEL":
        return "get_panel";
      default:
        return "";
    }
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data).formData)
      request.formData = __privateGet(this, _data).formData;
    if (__privateGet(this, _data).token)
      request.continuation = __privateGet(this, _data).token;
    if (__privateGet(this, _data).request === "CONTINUATION_REQUEST_TYPE_COMMENTS_NOTIFICATION_MENU") {
      request.notificationsMenuRequestType = "NOTIFICATIONS_MENU_REQUEST_TYPE_COMMENTS";
      if (__privateGet(this, _data).token) {
        request.fetchCommentsParams = {
          continuation: __privateGet(this, _data).token
        };
        delete request.continuation;
      }
    }
    return request;
  }
};
_data = new WeakMap();
__name(_ContinuationCommand, "ContinuationCommand");
__publicField(_ContinuationCommand, "type", "ContinuationCommand");
var ContinuationCommand = _ContinuationCommand;

// dist/src/parser/classes/commands/GetKidsBlocklistPickerCommand.js
var API_PATH = "kids/get_kids_blocklist_picker";
var _data2;
var _GetKidsBlocklistPickerCommand = class _GetKidsBlocklistPickerCommand extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data2);
    __privateSet(this, _data2, data);
  }
  getApiPath() {
    return API_PATH;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data2).blockedForKidsContent)
      request.blockedForKidsContent = __privateGet(this, _data2).blockedForKidsContent;
    return request;
  }
};
_data2 = new WeakMap();
__name(_GetKidsBlocklistPickerCommand, "GetKidsBlocklistPickerCommand");
__publicField(_GetKidsBlocklistPickerCommand, "type", "GetKidsBlocklistPickerCommand");
var GetKidsBlocklistPickerCommand = _GetKidsBlocklistPickerCommand;

// dist/src/parser/classes/commands/RunAttestationCommand.js
var _RunAttestationCommand = class _RunAttestationCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "engagement_type");
    __publicField(this, "ids");
    this.engagement_type = data.engagementType;
    if (Reflect.has(data, "ids")) {
      this.ids = data.ids.map((id) => ({
        encrypted_video_id: id.encryptedVideoId,
        external_channel_id: id.externalChannelId,
        comment_id: id.commentId,
        external_owner_id: id.externalOwnerId,
        artist_id: id.artistId,
        playlist_id: id.playlistId,
        external_post_id: id.externalPostId,
        share_id: id.shareId
      }));
    }
  }
};
__name(_RunAttestationCommand, "RunAttestationCommand");
__publicField(_RunAttestationCommand, "type", "RunAttestationCommand");
var RunAttestationCommand = _RunAttestationCommand;

// dist/src/parser/classes/commands/ShowDialogCommand.js
var _ShowDialogCommand = class _ShowDialogCommand extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "inline_content");
    __publicField(this, "remove_default_padding");
    this.inline_content = parser_exports.parseItem((_a = data.panelLoadingStrategy) == null ? void 0 : _a.inlineContent);
    this.remove_default_padding = !!data.removeDefaultPadding;
  }
};
__name(_ShowDialogCommand, "ShowDialogCommand");
__publicField(_ShowDialogCommand, "type", "ShowDialogCommand");
var ShowDialogCommand = _ShowDialogCommand;

// dist/src/parser/classes/commands/UpdateEngagementPanelContentCommand.js
var _UpdateEngagementPanelContentCommand = class _UpdateEngagementPanelContentCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content_source_panel_identifier");
    __publicField(this, "target_panel_identifier");
    this.content_source_panel_identifier = data.contentSourcePanelIdentifier;
    this.target_panel_identifier = data.targetPanelIdentifier;
  }
};
__name(_UpdateEngagementPanelContentCommand, "UpdateEngagementPanelContentCommand");
__publicField(_UpdateEngagementPanelContentCommand, "type", "UpdateEngagementPanelContentCommand");
var UpdateEngagementPanelContentCommand = _UpdateEngagementPanelContentCommand;

// dist/src/parser/classes/comments/AuthorCommentBadge.js
var _data3;
var _AuthorCommentBadge = class _AuthorCommentBadge extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data3);
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    __publicField(this, "style");
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType")) {
      this.icon_type = data.icon.iconType;
    }
    this.tooltip = data.iconTooltip;
    if (this.tooltip === "Verified") {
      this.style = "BADGE_STYLE_TYPE_VERIFIED";
      data.style = "BADGE_STYLE_TYPE_VERIFIED";
    }
    __privateSet(this, _data3, data);
  }
  get orig_badge() {
    return __privateGet(this, _data3);
  }
};
_data3 = new WeakMap();
__name(_AuthorCommentBadge, "AuthorCommentBadge");
__publicField(_AuthorCommentBadge, "type", "AuthorCommentBadge");
var AuthorCommentBadge = _AuthorCommentBadge;

// dist/src/parser/classes/comments/EmojiPicker.js
var _EmojiPicker = class _EmojiPicker extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "categories");
    __publicField(this, "category_buttons");
    __publicField(this, "search_placeholder");
    __publicField(this, "search_no_results");
    __publicField(this, "pick_skin_tone");
    __publicField(this, "clear_search_label");
    __publicField(this, "skin_tone_generic_label");
    __publicField(this, "skin_tone_light_label");
    __publicField(this, "skin_tone_medium_light_label");
    __publicField(this, "skin_tone_medium_label");
    __publicField(this, "skin_tone_medium_dark_label");
    __publicField(this, "skin_tone_dark_label");
    this.id = data.id;
    this.categories = parser_exports.parseArray(data.categories);
    this.category_buttons = parser_exports.parseArray(data.categoryButtons);
    this.search_placeholder = new Text2(data.searchPlaceholderText);
    this.search_no_results = new Text2(data.searchNoResultsText);
    this.pick_skin_tone = new Text2(data.pickSkinToneText);
    this.clear_search_label = data.clearSearchLabel;
    this.skin_tone_generic_label = data.skinToneGenericLabel;
    this.skin_tone_light_label = data.skinToneLightLabel;
    this.skin_tone_medium_light_label = data.skinToneMediumLightLabel;
    this.skin_tone_medium_label = data.skinToneMediumLabel;
    this.skin_tone_medium_dark_label = data.skinToneMediumDarkLabel;
    this.skin_tone_dark_label = data.skinToneDarkLabel;
  }
};
__name(_EmojiPicker, "EmojiPicker");
__publicField(_EmojiPicker, "type", "EmojiPicker");
var EmojiPicker = _EmojiPicker;

// dist/src/parser/classes/comments/CommentDialog.js
var _CommentDialog = class _CommentDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "editable_text");
    __publicField(this, "author_thumbnail");
    __publicField(this, "submit_button");
    __publicField(this, "cancel_button");
    __publicField(this, "placeholder");
    __publicField(this, "emoji_button");
    __publicField(this, "emoji_picker");
    this.editable_text = new Text2(data.editableText);
    this.author_thumbnail = Thumbnail.fromResponse(data.authorThumbnail);
    this.submit_button = parser_exports.parseItem(data.submitButton, Button);
    this.cancel_button = parser_exports.parseItem(data.cancelButton, Button);
    this.placeholder = new Text2(data.placeholderText);
    this.emoji_button = parser_exports.parseItem(data.emojiButton, Button);
    this.emoji_picker = parser_exports.parseItem(data.emojiPicker, EmojiPicker);
  }
};
__name(_CommentDialog, "CommentDialog");
__publicField(_CommentDialog, "type", "CommentDialog");
var CommentDialog = _CommentDialog;

// dist/src/parser/classes/comments/CommentReplies.js
var _CommentReplies = class _CommentReplies extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    __publicField(this, "view_replies");
    __publicField(this, "hide_replies");
    __publicField(this, "view_replies_creator_thumbnail");
    __publicField(this, "has_channel_owner_replied");
    this.contents = parser_exports.parseArray(data.contents);
    this.view_replies = parser_exports.parseItem(data.viewReplies, Button);
    this.hide_replies = parser_exports.parseItem(data.hideReplies, Button);
    this.view_replies_creator_thumbnail = Thumbnail.fromResponse(data.viewRepliesCreatorThumbnail);
    this.has_channel_owner_replied = !!data.viewRepliesCreatorThumbnail;
  }
};
__name(_CommentReplies, "CommentReplies");
__publicField(_CommentReplies, "type", "CommentReplies");
var CommentReplies = _CommentReplies;

// dist/src/parser/classes/comments/CommentReplyDialog.js
var _CommentReplyDialog = class _CommentReplyDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "reply_button");
    __publicField(this, "cancel_button");
    __publicField(this, "author_thumbnail");
    __publicField(this, "placeholder");
    __publicField(this, "error_message");
    this.reply_button = parser_exports.parseItem(data.replyButton, Button);
    this.cancel_button = parser_exports.parseItem(data.cancelButton, Button);
    this.author_thumbnail = Thumbnail.fromResponse(data.authorThumbnail);
    this.placeholder = new Text2(data.placeholderText);
    this.error_message = new Text2(data.errorMessage);
  }
};
__name(_CommentReplyDialog, "CommentReplyDialog");
__publicField(_CommentReplyDialog, "type", "CommentReplyDialog");
var CommentReplyDialog = _CommentReplyDialog;

// dist/src/parser/classes/comments/CommentsSimplebox.js
var _CommentsSimplebox = class _CommentsSimplebox extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "simplebox_avatar");
    __publicField(this, "simplebox_placeholder");
    this.simplebox_avatar = Thumbnail.fromResponse(data.simpleboxAvatar);
    this.simplebox_placeholder = new Text2(data.simpleboxPlaceholder);
  }
};
__name(_CommentsSimplebox, "CommentsSimplebox");
__publicField(_CommentsSimplebox, "type", "CommentsSimplebox");
var CommentsSimplebox = _CommentsSimplebox;

// dist/src/parser/classes/comments/CommentsEntryPointTeaser.js
var _CommentsEntryPointTeaser = class _CommentsEntryPointTeaser extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "teaser_avatar");
    __publicField(this, "teaser_content");
    if (Reflect.has(data, "teaserAvatar")) {
      this.teaser_avatar = Thumbnail.fromResponse(data.teaserAvatar);
    }
    if (Reflect.has(data, "teaserContent")) {
      this.teaser_content = new Text2(data.teaserContent);
    }
  }
};
__name(_CommentsEntryPointTeaser, "CommentsEntryPointTeaser");
__publicField(_CommentsEntryPointTeaser, "type", "CommentsEntryPointTeaser");
var CommentsEntryPointTeaser = _CommentsEntryPointTeaser;

// dist/src/parser/classes/comments/CommentsEntryPointHeader.js
var _CommentsEntryPointHeader = class _CommentsEntryPointHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "comment_count");
    __publicField(this, "teaser_avatar");
    __publicField(this, "teaser_content");
    __publicField(this, "content_renderer");
    __publicField(this, "simplebox_placeholder");
    if (Reflect.has(data, "headerText")) {
      this.header = new Text2(data.headerText);
    }
    if (Reflect.has(data, "commentCount")) {
      this.comment_count = new Text2(data.commentCount);
    }
    if (Reflect.has(data, "teaserAvatar") || Reflect.has(data, "simpleboxAvatar")) {
      this.teaser_avatar = Thumbnail.fromResponse(data.teaserAvatar || data.simpleboxAvatar);
    }
    if (Reflect.has(data, "teaserContent")) {
      this.teaser_content = new Text2(data.teaserContent);
    }
    if (Reflect.has(data, "contentRenderer")) {
      this.content_renderer = parser_exports.parseItem(data.contentRenderer, [CommentsEntryPointTeaser, CommentsSimplebox]);
    }
    if (Reflect.has(data, "simpleboxPlaceholder")) {
      this.simplebox_placeholder = new Text2(data.simpleboxPlaceholder);
    }
  }
};
__name(_CommentsEntryPointHeader, "CommentsEntryPointHeader");
__publicField(_CommentsEntryPointHeader, "type", "CommentsEntryPointHeader");
var CommentsEntryPointHeader = _CommentsEntryPointHeader;

// dist/src/parser/classes/comments/CommentsHeader.js
var _CommentsHeader = class _CommentsHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "count");
    __publicField(this, "comments_count");
    __publicField(this, "create_renderer");
    __publicField(this, "sort_menu");
    __publicField(this, "custom_emojis");
    this.title = new Text2(data.titleText);
    this.count = new Text2(data.countText);
    this.comments_count = new Text2(data.commentsCount);
    this.create_renderer = parser_exports.parseItem(data.createRenderer);
    this.sort_menu = parser_exports.parseItem(data.sortMenu, SortFilterSubMenu);
    if (Reflect.has(data, "customEmojis")) {
      this.custom_emojis = data.customEmojis.map((emoji) => ({
        emoji_id: emoji.emojiId,
        shortcuts: emoji.shortcuts,
        search_terms: emoji.searchTerms,
        image: Thumbnail.fromResponse(emoji.image),
        is_custom_emoji: emoji.isCustomEmoji
      }));
    }
  }
};
__name(_CommentsHeader, "CommentsHeader");
__publicField(_CommentsHeader, "type", "CommentsHeader");
var CommentsHeader = _CommentsHeader;

// dist/src/parser/classes/comments/CommentSimplebox.js
var _CommentSimplebox = class _CommentSimplebox extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "submit_button");
    __publicField(this, "cancel_button");
    __publicField(this, "author_thumbnail");
    __publicField(this, "placeholder");
    __publicField(this, "avatar_size");
    this.submit_button = parser_exports.parseItem(data.submitButton, Button);
    this.cancel_button = parser_exports.parseItem(data.cancelButton, Button);
    this.author_thumbnail = Thumbnail.fromResponse(data.authorThumbnail);
    this.placeholder = new Text2(data.placeholderText);
    this.avatar_size = data.avatarSize;
  }
};
__name(_CommentSimplebox, "CommentSimplebox");
__publicField(_CommentSimplebox, "type", "CommentSimplebox");
var CommentSimplebox = _CommentSimplebox;

// dist/src/parser/classes/comments/VoiceReplyContainerView.js
var _VoiceReplyContainerView = class _VoiceReplyContainerView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "voice_reply_unavailable_text");
    __publicField(this, "transcript_text");
    this.voice_reply_unavailable_text = Text2.fromAttributed(data.voiceReplyUnavailableText);
    this.transcript_text = Text2.fromAttributed(data.transcriptText);
  }
};
__name(_VoiceReplyContainerView, "VoiceReplyContainerView");
__publicField(_VoiceReplyContainerView, "type", "VoiceReplyContainerView");
var VoiceReplyContainerView = _VoiceReplyContainerView;

// dist/src/parser/classes/comments/CommentView.js
var _actions;
var _CommentView = class _CommentView extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _actions);
    __publicField(this, "like_command");
    __publicField(this, "dislike_command");
    __publicField(this, "unlike_command");
    __publicField(this, "undislike_command");
    __publicField(this, "reply_command");
    __publicField(this, "prepare_account_command");
    __publicField(this, "comment_id");
    __publicField(this, "is_pinned");
    __publicField(this, "keys");
    __publicField(this, "content");
    __publicField(this, "published_time");
    __publicField(this, "author_is_channel_owner");
    __publicField(this, "creator_thumbnail_url");
    __publicField(this, "like_button_a11y");
    __publicField(this, "like_count");
    __publicField(this, "like_count_liked");
    __publicField(this, "like_count_a11y");
    __publicField(this, "like_active_tooltip");
    __publicField(this, "like_inactive_tooltip");
    __publicField(this, "dislike_active_tooltip");
    __publicField(this, "dislike_inactive_tooltip");
    __publicField(this, "heart_active_tooltip");
    __publicField(this, "reply_count");
    __publicField(this, "reply_count_a11y");
    __publicField(this, "is_member");
    __publicField(this, "member_badge");
    __publicField(this, "author");
    __publicField(this, "is_liked");
    __publicField(this, "is_disliked");
    __publicField(this, "is_hearted");
    __publicField(this, "voice_reply_container");
    this.comment_id = data.commentId;
    this.is_pinned = !!data.pinnedText;
    this.keys = {
      comment: data.commentKey,
      comment_surface: data.commentSurfaceKey,
      toolbar_state: data.toolbarStateKey,
      toolbar_surface: data.toolbarSurfaceKey,
      shared: data.sharedKey
    };
  }
  applyMutations(comment, toolbar_state, toolbar_surface, comment_surface) {
    if (comment) {
      this.content = Text2.fromAttributed(comment.properties.content);
      this.published_time = comment.properties.publishedTime;
      this.author_is_channel_owner = !!comment.author.isCreator;
      this.creator_thumbnail_url = comment.toolbar.creatorThumbnailUrl;
      this.like_count = comment.toolbar.likeCountNotliked ? comment.toolbar.likeCountNotliked : "0";
      this.like_count_liked = comment.toolbar.likeCountLiked ? comment.toolbar.likeCountLiked : "0";
      this.like_count_a11y = comment.toolbar.likeCountA11y;
      this.like_active_tooltip = comment.toolbar.likeActiveTooltip;
      this.like_inactive_tooltip = comment.toolbar.likeInactiveTooltip;
      this.dislike_active_tooltip = comment.toolbar.dislikeActiveTooltip;
      this.dislike_inactive_tooltip = comment.toolbar.dislikeInactiveTooltip;
      this.like_button_a11y = comment.toolbar.likeButtonA11y;
      this.heart_active_tooltip = comment.toolbar.heartActiveTooltip;
      this.reply_count_a11y = comment.toolbar.replyCountA11y;
      this.reply_count = comment.toolbar.replyCount ? comment.toolbar.replyCount : "0";
      this.is_member = !!comment.author.sponsorBadgeUrl;
      if (Reflect.has(comment.author, "sponsorBadgeUrl")) {
        this.member_badge = {
          url: comment.author.sponsorBadgeUrl,
          a11y: comment.author.A11y
        };
      }
      this.author = new Author({
        simpleText: comment.author.displayName,
        navigationEndpoint: comment.avatar.endpoint
      }, comment.author, comment.avatar.image, comment.author.channelId);
    }
    if (toolbar_state) {
      this.is_hearted = toolbar_state.heartState === "TOOLBAR_HEART_STATE_HEARTED";
      this.is_liked = toolbar_state.likeState === "TOOLBAR_LIKE_STATE_LIKED";
      this.is_disliked = toolbar_state.likeState === "TOOLBAR_LIKE_STATE_DISLIKED";
    }
    if (toolbar_surface) {
      if ("prepareAccountCommand" in toolbar_surface) {
        this.prepare_account_command = new NavigationEndpoint(toolbar_surface.prepareAccountCommand);
      } else {
        this.like_command = new NavigationEndpoint(toolbar_surface.likeCommand);
        this.dislike_command = new NavigationEndpoint(toolbar_surface.dislikeCommand);
        this.unlike_command = new NavigationEndpoint(toolbar_surface.unlikeCommand);
        this.undislike_command = new NavigationEndpoint(toolbar_surface.undislikeCommand);
        this.reply_command = new NavigationEndpoint(toolbar_surface.replyCommand);
      }
    }
    if (comment_surface) {
      if ("voiceReplyContainerViewModel" in comment_surface) {
        this.voice_reply_container = parser_exports.parseItem(comment_surface.voiceReplyContainerViewModel, VoiceReplyContainerView);
      }
    }
  }
  /**
   * Likes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the like command is not found.
   */
  async like() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.like_command)
      throw new InnertubeError("Like command not found.");
    if (this.is_liked)
      throw new InnertubeError("This comment is already liked.", { comment_id: this.comment_id });
    return this.like_command.call(__privateGet(this, _actions));
  }
  /**
   * Dislikes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the dislike command is not found.
   */
  async dislike() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.dislike_command)
      throw new InnertubeError("Dislike command not found.");
    if (this.is_disliked)
      throw new InnertubeError("This comment is already disliked.", { comment_id: this.comment_id });
    return this.dislike_command.call(__privateGet(this, _actions));
  }
  /**
   * Unlikes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the unlike command is not found.
   */
  async unlike() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.unlike_command)
      throw new InnertubeError("Unlike command not found.");
    if (!this.is_liked)
      throw new InnertubeError("This comment is not liked.", { comment_id: this.comment_id });
    return this.unlike_command.call(__privateGet(this, _actions));
  }
  /**
   * Undislikes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the undislike command is not found.
   */
  async undislike() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.undislike_command)
      throw new InnertubeError("Undislike command not found.");
    if (!this.is_disliked)
      throw new InnertubeError("This comment is not disliked.", { comment_id: this.comment_id });
    return this.undislike_command.call(__privateGet(this, _actions));
  }
  /**
   * Replies to the comment.
   * @param comment_text - The text of the reply.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the reply command is not found.
   */
  async reply(comment_text) {
    var _a;
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.reply_command)
      throw new InnertubeError("Reply command not found.");
    const dialog = (_a = this.reply_command.dialog) == null ? void 0 : _a.as(CommentReplyDialog);
    if (!dialog)
      throw new InnertubeError("Reply dialog not found.");
    const reply_button = dialog.reply_button;
    if (!reply_button)
      throw new InnertubeError("Reply button not found in the dialog.");
    if (!reply_button.endpoint)
      throw new InnertubeError("Reply button endpoint not found.");
    return reply_button.endpoint.call(__privateGet(this, _actions), { commentText: comment_text });
  }
  /**
   * Translates the comment to the specified target language.
   * @param target_language - The target language to translate the comment to, e.g. 'en', 'ja'.
   * @returns Resolves to an ApiResponse object with the translated content, if available.
   * @throws if the Actions instance is not set for this comment or if the comment content is not found.
   */
  async translate(target_language) {
    var _a, _b, _c, _d, _e, _f;
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.content)
      throw new InnertubeError("Comment content not found.", { comment_id: this.comment_id });
    const text = this.content.toString().replace(/[^\p{L}\p{N}\p{P}\p{Z}]/gu, "");
    const payload = { text, target_language };
    const action = encodeCommentActionParams(22, payload);
    const response = await __privateGet(this, _actions).execute("comment/perform_comment_action", { action });
    const mutations = (_b = (_a = response.data.frameworkUpdates) == null ? void 0 : _a.entityBatchUpdate) == null ? void 0 : _b.mutations;
    const content = (_f = (_e = (_d = (_c = mutations == null ? void 0 : mutations[0]) == null ? void 0 : _c.payload) == null ? void 0 : _d.commentEntityPayload) == null ? void 0 : _e.translatedContent) == null ? void 0 : _f.content;
    return { ...response, content };
  }
  setActions(actions) {
    __privateSet(this, _actions, actions);
  }
};
_actions = new WeakMap();
__name(_CommentView, "CommentView");
__publicField(_CommentView, "type", "CommentView");
var CommentView = _CommentView;

// dist/src/parser/classes/comments/CommentThread.js
var _actions2, _continuation, _CommentThread_instances, getPatchedReplies_fn;
var _CommentThread = class _CommentThread extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _CommentThread_instances);
    __publicField(this, "comment");
    __publicField(this, "replies");
    __publicField(this, "comment_replies_data");
    __publicField(this, "is_moderated_elq_comment");
    __publicField(this, "has_replies");
    __privateAdd(this, _actions2);
    __privateAdd(this, _continuation);
    this.comment = parser_exports.parseItem(data.commentViewModel, CommentView);
    this.comment_replies_data = parser_exports.parseItem(data.replies, CommentReplies);
    this.is_moderated_elq_comment = data.isModeratedElqComment;
    this.has_replies = !!this.comment_replies_data;
  }
  get has_continuation() {
    if (!this.replies)
      throw new InnertubeError("Cannot determine if there is a continuation because this thread's replies have not been loaded.");
    return !!__privateGet(this, _continuation);
  }
  /**
   * Retrieves replies to this comment thread.
   */
  async getReplies() {
    var _a;
    if (!__privateGet(this, _actions2))
      throw new InnertubeError("Actions instance not set for this thread.");
    if (!this.comment_replies_data)
      throw new InnertubeError("This comment has no replies.", this);
    const continuation = (_a = this.comment_replies_data.contents) == null ? void 0 : _a.firstOfType(ContinuationItem);
    if (!continuation)
      throw new InnertubeError("Replies continuation not found.");
    const response = await continuation.endpoint.call(__privateGet(this, _actions2), { parse: true });
    if (!response.on_response_received_endpoints_memo)
      throw new InnertubeError("Unexpected response.", response);
    this.replies = __privateMethod(this, _CommentThread_instances, getPatchedReplies_fn).call(this, response.on_response_received_endpoints_memo);
    __privateSet(this, _continuation, response.on_response_received_endpoints_memo.getType(ContinuationItem)[0]);
    return this;
  }
  /**
   * Retrieves next batch of replies.
   */
  async getContinuation() {
    var _a;
    if (!this.replies)
      throw new InnertubeError("Cannot retrieve continuation because this thread's replies have not been loaded.");
    if (!__privateGet(this, _continuation))
      throw new InnertubeError("Continuation not found.");
    if (!__privateGet(this, _actions2))
      throw new InnertubeError("Actions instance not set for this thread.");
    const load_more_button = (_a = __privateGet(this, _continuation).button) == null ? void 0 : _a.as(Button);
    if (!load_more_button)
      throw new InnertubeError('"Load more" button not found.');
    const response = await load_more_button.endpoint.call(__privateGet(this, _actions2), { parse: true });
    if (!response.on_response_received_endpoints_memo)
      throw new InnertubeError("Unexpected response.", response);
    this.replies = __privateMethod(this, _CommentThread_instances, getPatchedReplies_fn).call(this, response.on_response_received_endpoints_memo);
    __privateSet(this, _continuation, response.on_response_received_endpoints_memo.getType(ContinuationItem)[0]);
    return this;
  }
  setActions(actions) {
    __privateSet(this, _actions2, actions);
  }
};
_actions2 = new WeakMap();
_continuation = new WeakMap();
_CommentThread_instances = new WeakSet();
getPatchedReplies_fn = /* @__PURE__ */ __name(function(data) {
  return observe(data.getType(CommentView).map((comment) => {
    comment.setActions(__privateGet(this, _actions2));
    return comment;
  }));
}, "#getPatchedReplies");
__name(_CommentThread, "CommentThread");
__publicField(_CommentThread, "type", "CommentThread");
var CommentThread = _CommentThread;

// dist/src/parser/classes/comments/PdgCommentChip.js
var _PdgCommentChip = class _PdgCommentChip extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "text");
    __publicField(this, "color_pallette");
    __publicField(this, "icon_type");
    this.text = new Text2(data.chipText);
    this.color_pallette = {
      background_color: (_a = data.chipColorPalette) == null ? void 0 : _a.backgroundColor,
      foreground_title_color: (_b = data.chipColorPalette) == null ? void 0 : _b.foregroundTitleColor
    };
    if (Reflect.has(data, "chipIcon") && Reflect.has(data.chipIcon, "iconType")) {
      this.icon_type = data.chipIcon.iconType;
    }
  }
};
__name(_PdgCommentChip, "PdgCommentChip");
__publicField(_PdgCommentChip, "type", "PdgCommentChip");
var PdgCommentChip = _PdgCommentChip;

// dist/src/parser/classes/comments/SponsorCommentBadge.js
var _SponsorCommentBadge = class _SponsorCommentBadge extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "custom_badge");
    __publicField(this, "tooltip");
    this.custom_badge = Thumbnail.fromResponse(data.customBadge);
    this.tooltip = data.tooltip;
  }
};
__name(_SponsorCommentBadge, "SponsorCommentBadge");
__publicField(_SponsorCommentBadge, "type", "SponsorCommentBadge");
var SponsorCommentBadge = _SponsorCommentBadge;

// dist/src/parser/classes/CompactChannel.js
var _CompactChannel = class _CompactChannel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "channel_id");
    __publicField(this, "thumbnail");
    __publicField(this, "display_name");
    __publicField(this, "video_count");
    __publicField(this, "subscriber_count");
    __publicField(this, "endpoint");
    __publicField(this, "tv_banner");
    __publicField(this, "menu");
    this.title = new Text2(data.title);
    this.channel_id = data.channelId;
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.display_name = new Text2(data.displayName);
    this.video_count = new Text2(data.videoCountText);
    this.subscriber_count = new Text2(data.subscriberCountText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.tv_banner = Thumbnail.fromResponse(data.tvBanner);
    this.menu = parser_exports.parseItem(data.menu, Menu);
  }
};
__name(_CompactChannel, "CompactChannel");
__publicField(_CompactChannel, "type", "CompactChannel");
var CompactChannel = _CompactChannel;

// dist/src/parser/classes/PlaylistCustomThumbnail.js
var _PlaylistCustomThumbnail = class _PlaylistCustomThumbnail extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_PlaylistCustomThumbnail, "PlaylistCustomThumbnail");
__publicField(_PlaylistCustomThumbnail, "type", "PlaylistCustomThumbnail");
var PlaylistCustomThumbnail = _PlaylistCustomThumbnail;

// dist/src/parser/classes/PlaylistVideoThumbnail.js
var _PlaylistVideoThumbnail = class _PlaylistVideoThumbnail extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_PlaylistVideoThumbnail, "PlaylistVideoThumbnail");
__publicField(_PlaylistVideoThumbnail, "type", "PlaylistVideoThumbnail");
var PlaylistVideoThumbnail = _PlaylistVideoThumbnail;

// dist/src/parser/classes/Playlist.js
var _Playlist = class _Playlist extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "video_count");
    __publicField(this, "video_count_short");
    __publicField(this, "first_videos");
    __publicField(this, "share_url");
    __publicField(this, "menu");
    __publicField(this, "badges");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "view_playlist");
    this.id = data.playlistId;
    this.title = new Text2(data.title);
    this.author = ((_a = data.shortBylineText) == null ? void 0 : _a.simpleText) ? new Text2(data.shortBylineText) : new Author(data.longBylineText, data.ownerBadges, null);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail || { thumbnails: data.thumbnails.map((th) => th.thumbnails).flat(1) });
    this.video_count = new Text2(data.thumbnailText);
    this.video_count_short = new Text2(data.videoCountShortText);
    this.first_videos = parser_exports.parseArray(data.videos);
    this.share_url = data.shareUrl || null;
    this.menu = parser_exports.parseItem(data.menu);
    this.badges = parser_exports.parseArray(data.ownerBadges);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    if (Reflect.has(data, "thumbnailRenderer")) {
      this.thumbnail_renderer = parser_exports.parseItem(data.thumbnailRenderer, [PlaylistVideoThumbnail, PlaylistCustomThumbnail]) || void 0;
    }
    if (Reflect.has(data, "viewPlaylistText")) {
      this.view_playlist = new Text2(data.viewPlaylistText);
    }
  }
};
__name(_Playlist, "Playlist");
__publicField(_Playlist, "type", "Playlist");
var Playlist = _Playlist;

// dist/src/parser/classes/CompactMix.js
var _CompactMix = class _CompactMix extends Playlist {
  constructor(data) {
    super(data);
  }
};
__name(_CompactMix, "CompactMix");
__publicField(_CompactMix, "type", "CompactMix");
var CompactMix = _CompactMix;

// dist/src/parser/classes/CompactMovie.js
var _CompactMovie = class _CompactMovie extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "top_metadata_items");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    __publicField(this, "badges");
    __publicField(this, "use_vertical_poster");
    __publicField(this, "menu");
    const overlay_time_status = ((_a = data.thumbnailOverlays.find((overlay) => overlay.thumbnailOverlayTimeStatusRenderer)) == null ? void 0 : _a.thumbnailOverlayTimeStatusRenderer.text) || "N/A";
    this.id = data.videoId;
    this.title = new Text2(data.title);
    this.top_metadata_items = new Text2(data.topMetadataItems);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    this.author = new Author(data.shortBylineText);
    const durationText = data.lengthText ? new Text2(data.lengthText).toString() : new Text2(overlay_time_status).toString();
    this.duration = {
      text: durationText,
      seconds: timeToSeconds(durationText)
    };
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.badges = parser_exports.parseArray(data.badges);
    this.use_vertical_poster = data.useVerticalPoster;
    this.menu = parser_exports.parseItem(data.menu, Menu);
  }
};
__name(_CompactMovie, "CompactMovie");
__publicField(_CompactMovie, "type", "CompactMovie");
var CompactMovie = _CompactMovie;

// dist/src/parser/classes/CompactPlaylist.js
var _CompactPlaylist = class _CompactPlaylist extends Playlist {
  constructor(data) {
    super(data);
  }
};
__name(_CompactPlaylist, "CompactPlaylist");
__publicField(_CompactPlaylist, "type", "CompactPlaylist");
var CompactPlaylist = _CompactPlaylist;
var CompactPlaylist_default = CompactPlaylist;

// dist/src/parser/classes/CompactStation.js
var _CompactStation = class _CompactStation extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "video_count");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnail");
    this.title = new Text2(data.title);
    this.description = new Text2(data.description);
    this.video_count = new Text2(data.videoCountText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_CompactStation, "CompactStation");
__publicField(_CompactStation, "type", "CompactStation");
var CompactStation = _CompactStation;

// dist/src/parser/classes/CompositeVideoPrimaryInfo.js
var _CompositeVideoPrimaryInfo = class _CompositeVideoPrimaryInfo extends YTNode {
  constructor(_data23) {
    super();
  }
};
__name(_CompositeVideoPrimaryInfo, "CompositeVideoPrimaryInfo");
__publicField(_CompositeVideoPrimaryInfo, "type", "CompositeVideoPrimaryInfo");
var CompositeVideoPrimaryInfo = _CompositeVideoPrimaryInfo;

// dist/src/parser/classes/ConfirmDialog.js
var _ConfirmDialog = class _ConfirmDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "confirm_button");
    __publicField(this, "cancel_button");
    __publicField(this, "dialog_messages");
    this.title = new Text2(data.title);
    this.confirm_button = parser_exports.parseItem(data.confirmButton, Button);
    this.cancel_button = parser_exports.parseItem(data.cancelButton, Button);
    this.dialog_messages = data.dialogMessages.map((txt) => new Text2(txt));
  }
};
__name(_ConfirmDialog, "ConfirmDialog");
__publicField(_ConfirmDialog, "type", "ConfirmDialog");
var ConfirmDialog = _ConfirmDialog;

// dist/src/parser/classes/ContentMetadataView.js
var _ContentMetadataView = class _ContentMetadataView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "metadata_rows");
    __publicField(this, "delimiter");
    this.metadata_rows = data.metadataRows.map((row) => {
      var _a;
      return {
        metadata_parts: (_a = row.metadataParts) == null ? void 0 : _a.map((part) => ({
          text: part.text ? Text2.fromAttributed(part.text) : null,
          avatar_stack: parser_exports.parseItem(part.avatarStack, AvatarStackView),
          enable_truncation: data.enableTruncation
        })),
        badges: parser_exports.parseArray(row.badges, BadgeView)
      };
    });
    this.delimiter = data.delimiter;
  }
};
__name(_ContentMetadataView, "ContentMetadataView");
__publicField(_ContentMetadataView, "type", "ContentMetadataView");
var ContentMetadataView = _ContentMetadataView;

// dist/src/parser/classes/Message.js
var _Message = class _Message extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data.text);
  }
};
__name(_Message, "Message");
__publicField(_Message, "type", "Message");
var Message = _Message;

// dist/src/parser/classes/ConversationBar.js
var _ConversationBar = class _ConversationBar extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "availability_message");
    this.availability_message = parser_exports.parseItem(data.availabilityMessage, Message);
  }
};
__name(_ConversationBar, "ConversationBar");
__publicField(_ConversationBar, "type", "ConversationBar");
var ConversationBar = _ConversationBar;

// dist/src/parser/classes/CopyLink.js
var _CopyLink = class _CopyLink extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "copy_button");
    __publicField(this, "short_url");
    __publicField(this, "style");
    this.copy_button = parser_exports.parseItem(data.copyButton, Button);
    this.short_url = data.shortUrl;
    this.style = data.style;
  }
};
__name(_CopyLink, "CopyLink");
__publicField(_CopyLink, "type", "CopyLink");
var CopyLink = _CopyLink;

// dist/src/parser/classes/DropdownView.js
var _DropdownView = class _DropdownView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    __publicField(this, "placeholder_text");
    __publicField(this, "disabled");
    __publicField(this, "options");
    __publicField(this, "dropdown_type");
    __publicField(this, "id");
    this.label = new Text2(data.label);
    this.placeholder_text = new Text2(data.placeholderText);
    this.disabled = !!data.disabled;
    this.dropdown_type = data.type;
    this.id = data.id;
    if (Reflect.has(data, "options")) {
      this.options = data.options.map((option) => {
        var _a;
        return {
          title: new Text2(option.title),
          subtitle: new Text2(option.subtitle),
          leading_image: Thumbnail.fromResponse(option.leadingImage),
          value: { privacy_status_value: (_a = option.value) == null ? void 0 : _a.privacyStatusValue },
          on_tap: new NavigationEndpoint(option.onTap),
          is_selected: !!option.isSelected
        };
      });
    }
  }
};
__name(_DropdownView, "DropdownView");
__publicField(_DropdownView, "type", "DropdownView");
var DropdownView = _DropdownView;

// dist/src/parser/classes/TextFieldView.js
var _TextFieldView = class _TextFieldView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "display_properties");
    __publicField(this, "content_properties");
    __publicField(this, "initial_state");
    __publicField(this, "form_field_metadata");
    if (Reflect.has(data, "displayProperties")) {
      this.display_properties = {
        isMultiline: !!data.displayProperties.isMultiline,
        disableNewLines: !!data.displayProperties.disableNewLines
      };
    }
    if (Reflect.has(data, "contentProperties")) {
      this.content_properties = {
        labelText: data.contentProperties.labelText,
        placeholderText: data.contentProperties.placeholderText,
        maxCharacterCount: data.contentProperties.maxCharacterCount
      };
    }
    if (Reflect.has(data, "initialState")) {
      this.initial_state = {
        isFocused: !!data.initialState.isFocused
      };
    }
    if (Reflect.has(data, "formFieldMetadata")) {
      this.form_field_metadata = {
        formId: data.formFieldMetadata.formId,
        fieldId: data.formFieldMetadata.fieldId
      };
    }
  }
};
__name(_TextFieldView, "TextFieldView");
__publicField(_TextFieldView, "type", "TextFieldView");
var TextFieldView = _TextFieldView;

// dist/src/parser/classes/CreatePlaylistDialogFormView.js
var _CreatePlaylistDialogFormView = class _CreatePlaylistDialogFormView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "playlist_title");
    __publicField(this, "playlist_visibility");
    __publicField(this, "disable_playlist_collaborate");
    __publicField(this, "create_playlist_params_collaboration_enabled");
    __publicField(this, "create_playlist_params_collaboration_disabled");
    __publicField(this, "video_ids");
    this.playlist_title = parser_exports.parseItem(data.playlistTitle, TextFieldView);
    this.playlist_visibility = parser_exports.parseItem(data.playlistVisibility, DropdownView);
    this.disable_playlist_collaborate = !!data.disablePlaylistCollaborate;
    this.create_playlist_params_collaboration_enabled = data.createPlaylistParamsCollaborationEnabled;
    this.create_playlist_params_collaboration_disabled = data.createPlaylistParamsCollaborationDisabled;
    this.video_ids = data.videoIds;
  }
};
__name(_CreatePlaylistDialogFormView, "CreatePlaylistDialogFormView");
__publicField(_CreatePlaylistDialogFormView, "type", "CreatePlaylistDialogFormView");
var CreatePlaylistDialogFormView = _CreatePlaylistDialogFormView;

// dist/src/parser/classes/DecoratedAvatarView.js
var _DecoratedAvatarView = class _DecoratedAvatarView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "avatar");
    __publicField(this, "a11y_label");
    __publicField(this, "renderer_context");
    this.avatar = parser_exports.parseItem(data.avatar, AvatarView);
    this.a11y_label = data.a11yLabel;
    this.renderer_context = new RendererContext(data.rendererContext);
  }
};
__name(_DecoratedAvatarView, "DecoratedAvatarView");
__publicField(_DecoratedAvatarView, "type", "DecoratedAvatarView");
var DecoratedAvatarView = _DecoratedAvatarView;

// dist/src/parser/classes/HeatMarker.js
var _HeatMarker = class _HeatMarker extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "time_range_start_millis");
    __publicField(this, "marker_duration_millis");
    __publicField(this, "heat_marker_intensity_score_normalized");
    this.time_range_start_millis = Number.parseInt(data.startMillis, 10);
    this.marker_duration_millis = Number.parseInt(data.durationMillis, 10);
    this.heat_marker_intensity_score_normalized = data.intensityScoreNormalized;
  }
};
__name(_HeatMarker, "HeatMarker");
__publicField(_HeatMarker, "type", "HeatMarker");
var HeatMarker = _HeatMarker;

// dist/src/parser/classes/TimedMarkerDecoration.js
var _TimedMarkerDecoration = class _TimedMarkerDecoration extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "visible_time_range_start_millis");
    __publicField(this, "visible_time_range_end_millis");
    __publicField(this, "decoration_time_millis");
    __publicField(this, "label");
    __publicField(this, "icon");
    this.visible_time_range_start_millis = data.visibleTimeRangeStartMillis;
    this.visible_time_range_end_millis = data.visibleTimeRangeEndMillis;
    this.decoration_time_millis = data.decorationTimeMillis;
    this.label = new Text2(data.label);
    this.icon = data.icon;
  }
};
__name(_TimedMarkerDecoration, "TimedMarkerDecoration");
__publicField(_TimedMarkerDecoration, "type", "TimedMarkerDecoration");
var TimedMarkerDecoration = _TimedMarkerDecoration;

// dist/src/parser/classes/Heatmap.js
var _Heatmap = class _Heatmap extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "max_height_dp");
    __publicField(this, "min_height_dp");
    __publicField(this, "show_hide_animation_duration_millis");
    __publicField(this, "heat_markers");
    __publicField(this, "heat_markers_decorations");
    this.max_height_dp = data.maxHeightDp;
    this.min_height_dp = data.minHeightDp;
    this.show_hide_animation_duration_millis = data.showHideAnimationDurationMillis;
    this.heat_markers = parser_exports.parseArray(data.heatMarkers, HeatMarker);
    this.heat_markers_decorations = parser_exports.parseArray(data.heatMarkersDecorations, TimedMarkerDecoration);
  }
};
__name(_Heatmap, "Heatmap");
__publicField(_Heatmap, "type", "Heatmap");
var Heatmap = _Heatmap;

// dist/src/parser/classes/MultiMarkersPlayerBar.js
var _Marker = class _Marker extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "marker_key");
    __publicField(this, "value");
    this.marker_key = data.key;
    this.value = {};
    if (Reflect.has(data, "value")) {
      if (Reflect.has(data.value, "heatmap")) {
        this.value.heatmap = parser_exports.parseItem(data.value.heatmap, Heatmap);
      }
      if (Reflect.has(data.value, "chapters")) {
        this.value.chapters = parser_exports.parseArray(data.value.chapters, Chapter);
      }
    }
  }
};
__name(_Marker, "Marker");
__publicField(_Marker, "type", "Marker");
var Marker = _Marker;
var _MultiMarkersPlayerBar = class _MultiMarkersPlayerBar extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "markers_map");
    this.markers_map = observe(((_a = data.markersMap) == null ? void 0 : _a.map((marker) => new Marker(marker))) || []);
  }
};
__name(_MultiMarkersPlayerBar, "MultiMarkersPlayerBar");
__publicField(_MultiMarkersPlayerBar, "type", "MultiMarkersPlayerBar");
var MultiMarkersPlayerBar = _MultiMarkersPlayerBar;

// dist/src/parser/classes/DecoratedPlayerBar.js
var _DecoratedPlayerBar = class _DecoratedPlayerBar extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "player_bar");
    __publicField(this, "player_bar_action_button");
    this.player_bar = parser_exports.parseItem(data.playerBar, MultiMarkersPlayerBar);
    this.player_bar_action_button = parser_exports.parseItem(data.playerBarActionButton, Button);
  }
};
__name(_DecoratedPlayerBar, "DecoratedPlayerBar");
__publicField(_DecoratedPlayerBar, "type", "DecoratedPlayerBar");
var DecoratedPlayerBar = _DecoratedPlayerBar;

// dist/src/parser/classes/DefaultPromoPanel.js
var _DefaultPromoPanel = class _DefaultPromoPanel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "endpoint");
    __publicField(this, "large_form_factor_background_thumbnail");
    __publicField(this, "small_form_factor_background_thumbnail");
    __publicField(this, "scrim_color_values");
    __publicField(this, "min_panel_display_duration_ms");
    __publicField(this, "min_video_play_duration_ms");
    __publicField(this, "scrim_duration");
    __publicField(this, "metadata_order");
    __publicField(this, "panel_layout");
    this.title = new Text2(data.title);
    this.description = new Text2(data.description);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.large_form_factor_background_thumbnail = parser_exports.parseItem(data.largeFormFactorBackgroundThumbnail);
    this.small_form_factor_background_thumbnail = parser_exports.parseItem(data.smallFormFactorBackgroundThumbnail);
    this.scrim_color_values = data.scrimColorValues;
    this.min_panel_display_duration_ms = data.minPanelDisplayDurationMs;
    this.min_video_play_duration_ms = data.minVideoPlayDurationMs;
    this.scrim_duration = data.scrimDuration;
    this.metadata_order = data.metadataOrder;
    this.panel_layout = data.panelLayout;
  }
};
__name(_DefaultPromoPanel, "DefaultPromoPanel");
__publicField(_DefaultPromoPanel, "type", "DefaultPromoPanel");
var DefaultPromoPanel = _DefaultPromoPanel;

// dist/src/parser/classes/DescriptionPreviewView.js
var _DescriptionPreviewView = class _DescriptionPreviewView extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f;
    super();
    __publicField(this, "description");
    __publicField(this, "max_lines");
    __publicField(this, "truncation_text");
    __publicField(this, "always_show_truncation_text");
    __publicField(this, "more_endpoint");
    __publicField(this, "renderer_context");
    if (Reflect.has(data, "description"))
      this.description = Text2.fromAttributed(data.description);
    if (Reflect.has(data, "maxLines"))
      this.max_lines = parseInt(data.maxLines);
    if (Reflect.has(data, "truncationText"))
      this.truncation_text = Text2.fromAttributed(data.truncationText);
    this.always_show_truncation_text = !!data.alwaysShowTruncationText;
    if ((_c = (_b = (_a = data.rendererContext.commandContext) == null ? void 0 : _a.onTap) == null ? void 0 : _b.innertubeCommand) == null ? void 0 : _c.showEngagementPanelEndpoint) {
      const endpoint = (_f = (_e = (_d = data.rendererContext.commandContext) == null ? void 0 : _d.onTap) == null ? void 0 : _e.innertubeCommand) == null ? void 0 : _f.showEngagementPanelEndpoint;
      this.more_endpoint = {
        show_engagement_panel_endpoint: {
          engagement_panel: parser_exports.parseItem(endpoint.engagementPanel, EngagementPanelSectionList),
          engagement_panel_popup_type: endpoint.engagementPanelPresentationConfigs.engagementPanelPopupPresentationConfig.popupType,
          identifier: {
            surface: endpoint.identifier.surface,
            tag: endpoint.identifier.tag
          }
        }
      };
    }
    this.renderer_context = new RendererContext(data.rendererContext);
  }
};
__name(_DescriptionPreviewView, "DescriptionPreviewView");
__publicField(_DescriptionPreviewView, "type", "DescriptionPreviewView");
var DescriptionPreviewView = _DescriptionPreviewView;

// dist/src/parser/classes/DialogHeaderView.js
var _DialogHeaderView = class _DialogHeaderView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "headline");
    this.headline = Text2.fromAttributed(data.headline);
  }
};
__name(_DialogHeaderView, "DialogHeaderView");
__publicField(_DialogHeaderView, "type", "DialogHeaderView");
var DialogHeaderView = _DialogHeaderView;

// dist/src/parser/classes/PanelFooterView.js
var _PanelFooterView = class _PanelFooterView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "primary_button");
    __publicField(this, "secondary_button");
    __publicField(this, "should_hide_divider");
    this.primary_button = parser_exports.parseItem(data.primaryButton, ButtonView);
    this.secondary_button = parser_exports.parseItem(data.secondaryButton, ButtonView);
    this.should_hide_divider = !!data.shouldHideDivider;
  }
};
__name(_PanelFooterView, "PanelFooterView");
__publicField(_PanelFooterView, "type", "PanelFooterView");
var PanelFooterView = _PanelFooterView;

// dist/src/parser/classes/FormFooterView.js
var _FormFooterView = class _FormFooterView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "panel_footer");
    __publicField(this, "form_id");
    __publicField(this, "container_type");
    this.panel_footer = parser_exports.parseItem(data.panelFooter, PanelFooterView);
    this.form_id = data.formId;
    this.container_type = data.containerType;
  }
};
__name(_FormFooterView, "FormFooterView");
__publicField(_FormFooterView, "type", "FormFooterView");
var FormFooterView = _FormFooterView;

// dist/src/parser/classes/SubscribeButtonView.js
var _SubscribeButtonView_instances, parseButtonContent_fn;
var _SubscribeButtonView = class _SubscribeButtonView extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _SubscribeButtonView_instances);
    __publicField(this, "subscribe_button_content");
    __publicField(this, "unsubscribe_button_content");
    __publicField(this, "disable_notification_bell");
    __publicField(this, "button_style");
    __publicField(this, "is_signed_out");
    __publicField(this, "background_style");
    __publicField(this, "disable_subscribe_button");
    __publicField(this, "on_show_subscription_options");
    __publicField(this, "channel_id");
    __publicField(this, "enable_subscribe_button_post_click_animation");
    __publicField(this, "bell_accessiblity_data");
    this.subscribe_button_content = __privateMethod(this, _SubscribeButtonView_instances, parseButtonContent_fn).call(this, data.subscribeButtonContent);
    this.unsubscribe_button_content = __privateMethod(this, _SubscribeButtonView_instances, parseButtonContent_fn).call(this, data.unsubscribeButtonContent);
    this.disable_notification_bell = data.disableNotificationBell;
    this.button_style = {
      unsubscribed_state_style: data.buttonStyle.unsubscribedStateStyle,
      subscribed_state_style: data.buttonStyle.subscribedStateStyle
    };
    this.is_signed_out = data.isSignedOut;
    this.background_style = data.backgroundStyle;
    this.disable_subscribe_button = data.disableSubscribeButton;
    this.on_show_subscription_options = new NavigationEndpoint(data.onShowSubscriptionOptions);
    this.channel_id = data.channelId;
    this.enable_subscribe_button_post_click_animation = data.enableSubscribeButtonPostClickAnimation;
    this.bell_accessiblity_data = {
      off_label: data.bellAccessibilityData.offLabel,
      all_label: data.bellAccessibilityData.allLabel,
      occasional_label: data.bellAccessibilityData.occasionalLabel,
      disabled_label: data.bellAccessibilityData.disabledLabel
    };
  }
};
_SubscribeButtonView_instances = new WeakSet();
parseButtonContent_fn = /* @__PURE__ */ __name(function(data) {
  return {
    button_text: data.buttonText,
    accessibility_text: data.accessibilityText,
    image_name: data.imageName,
    subscribe_state_subscribed: data.subscribeState.subscribed,
    endpoint: new NavigationEndpoint(data.onTapCommand)
  };
}, "#parseButtonContent");
__name(_SubscribeButtonView, "SubscribeButtonView");
__publicField(_SubscribeButtonView, "type", "SubscribeButtonView");
var SubscribeButtonView = _SubscribeButtonView;

// dist/src/parser/classes/ListItemView.js
var _ListItemView = class _ListItemView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "leading_accessory");
    __publicField(this, "renderer_context");
    __publicField(this, "trailing_buttons");
    this.title = Text2.fromAttributed(data.title);
    this.subtitle = Text2.fromAttributed(data.subtitle);
    this.leading_accessory = parser_exports.parseItem(data.leadingAccessory, AvatarView);
    this.renderer_context = new RendererContext(data.rendererContext);
    if ("trailingButtons" in data) {
      this.trailing_buttons = parser_exports.parseArray(data.trailingButtons.buttons, SubscribeButtonView);
    }
  }
};
__name(_ListItemView, "ListItemView");
__publicField(_ListItemView, "type", "ListItemView");
var ListItemView = _ListItemView;

// dist/src/parser/classes/ListView.js
var _ListView = class _ListView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.listItems, ListItemView);
  }
};
__name(_ListView, "ListView");
__publicField(_ListView, "type", "ListView");
var ListView = _ListView;

// dist/src/parser/classes/DialogView.js
var _DialogView = class _DialogView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "footer");
    __publicField(this, "custom_content");
    this.header = parser_exports.parseItem(data.header, DialogHeaderView);
    this.footer = parser_exports.parseItem(data.footer, [FormFooterView, PanelFooterView]);
    this.custom_content = parser_exports.parseItem(data.customContent, [CreatePlaylistDialogFormView, ListView]);
  }
};
__name(_DialogView, "DialogView");
__publicField(_DialogView, "type", "DialogView");
var DialogView = _DialogView;

// dist/src/parser/classes/DidYouMean.js
var _DidYouMean = class _DidYouMean extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "corrected_query");
    __publicField(this, "endpoint");
    this.text = new Text2(data.didYouMean).toString();
    this.corrected_query = new Text2(data.correctedQuery);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint || data.correctedQueryEndpoint);
  }
};
__name(_DidYouMean, "DidYouMean");
__publicField(_DidYouMean, "type", "DidYouMean");
var DidYouMean = _DidYouMean;

// dist/src/parser/classes/DismissableDialogContentSection.js
var _DismissableDialogContentSection = class _DismissableDialogContentSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
  }
};
__name(_DismissableDialogContentSection, "DismissableDialogContentSection");
__publicField(_DismissableDialogContentSection, "type", "DismissableDialogContentSection");
var DismissableDialogContentSection = _DismissableDialogContentSection;

// dist/src/parser/classes/DismissableDialog.js
var _DismissableDialog = class _DismissableDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "sections");
    __publicField(this, "metadata");
    __publicField(this, "display_style");
    this.title = data.title;
    this.sections = parser_exports.parseArray(data.sections, DismissableDialogContentSection);
    this.metadata = parser_exports.parseItem(data.metadata);
    this.display_style = data.displayStyle;
  }
};
__name(_DismissableDialog, "DismissableDialog");
__publicField(_DismissableDialog, "type", "DismissableDialog");
var DismissableDialog = _DismissableDialog;

// dist/src/parser/classes/DynamicTextView.js
var _DynamicTextView = class _DynamicTextView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "max_lines");
    this.text = Text2.fromAttributed(data.text);
    this.max_lines = parseInt(data.maxLines);
  }
};
__name(_DynamicTextView, "DynamicTextView");
__publicField(_DynamicTextView, "type", "DynamicTextView");
var DynamicTextView = _DynamicTextView;

// dist/src/parser/classes/misc/ChildElement.js
var _ChildElement = class _ChildElement extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "text");
    __publicField(this, "properties");
    __publicField(this, "child_elements");
    if (Reflect.has(data, "type") && Reflect.has(data.type, "textType")) {
      this.text = (_a = data.type.textType.text) == null ? void 0 : _a.content;
    }
    this.properties = data.properties;
    if (Reflect.has(data, "childElements")) {
      this.child_elements = data.childElements.map((el) => new _ChildElement(el));
    }
  }
};
__name(_ChildElement, "ChildElement");
__publicField(_ChildElement, "type", "ChildElement");
var ChildElement = _ChildElement;

// dist/src/parser/classes/Element.js
var _Element = class _Element extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "model");
    __publicField(this, "child_elements");
    if (Reflect.has(data, "elementRenderer")) {
      return parser_exports.parseItem(data, _Element);
    }
    const type = data.newElement.type.componentType;
    this.model = parser_exports.parseItem(type == null ? void 0 : type.model);
    if (Reflect.has(data, "newElement") && Reflect.has(data.newElement, "childElements")) {
      this.child_elements = observe(((_a = data.newElement.childElements) == null ? void 0 : _a.map((el) => new ChildElement(el))) || []);
    }
  }
};
__name(_Element, "Element");
__publicField(_Element, "type", "Element");
var Element = _Element;

// dist/src/parser/classes/EmergencyOnebox.js
var _EmergencyOnebox = class _EmergencyOnebox extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "first_option");
    __publicField(this, "menu");
    this.title = new Text2(data.title);
    this.first_option = parser_exports.parseItem(data.firstOption);
    this.menu = parser_exports.parseItem(data.menu, Menu);
  }
};
__name(_EmergencyOnebox, "EmergencyOnebox");
__publicField(_EmergencyOnebox, "type", "EmergencyOnebox");
var EmergencyOnebox = _EmergencyOnebox;

// dist/src/parser/classes/EmojiPickerCategory.js
var _EmojiPickerCategory = class _EmojiPickerCategory extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "category_id");
    __publicField(this, "title");
    __publicField(this, "emoji_ids");
    __publicField(this, "image_loading_lazy");
    __publicField(this, "category_type");
    this.category_id = data.categoryId;
    this.title = new Text2(data.title);
    this.emoji_ids = data.emojiIds;
    this.image_loading_lazy = !!data.imageLoadingLazy;
    this.category_type = data.categoryType;
  }
};
__name(_EmojiPickerCategory, "EmojiPickerCategory");
__publicField(_EmojiPickerCategory, "type", "EmojiPickerCategory");
var EmojiPickerCategory = _EmojiPickerCategory;

// dist/src/parser/classes/EmojiPickerCategoryButton.js
var _EmojiPickerCategoryButton = class _EmojiPickerCategoryButton extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "category_id");
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    this.category_id = data.categoryId;
    if (Reflect.has(data, "icon")) {
      this.icon_type = (_a = data.icon) == null ? void 0 : _a.iconType;
    }
    this.tooltip = data.tooltip;
  }
};
__name(_EmojiPickerCategoryButton, "EmojiPickerCategoryButton");
__publicField(_EmojiPickerCategoryButton, "type", "EmojiPickerCategoryButton");
var EmojiPickerCategoryButton = _EmojiPickerCategoryButton;

// dist/src/parser/classes/EmojiPickerUpsellCategory.js
var _EmojiPickerUpsellCategory = class _EmojiPickerUpsellCategory extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "category_id");
    __publicField(this, "title");
    __publicField(this, "upsell");
    __publicField(this, "emoji_tooltip");
    __publicField(this, "endpoint");
    __publicField(this, "emoji_ids");
    this.category_id = data.categoryId;
    this.title = new Text2(data.title);
    this.upsell = new Text2(data.upsell);
    this.emoji_tooltip = data.emojiTooltip;
    this.endpoint = new NavigationEndpoint(data.command);
    this.emoji_ids = data.emojiIds;
  }
};
__name(_EmojiPickerUpsellCategory, "EmojiPickerUpsellCategory");
__publicField(_EmojiPickerUpsellCategory, "type", "EmojiPickerUpsellCategory");
var EmojiPickerUpsellCategory = _EmojiPickerUpsellCategory;

// dist/src/parser/classes/endpoints/AddToPlaylistServiceEndpoint.js
var API_PATH2 = "playlist/get_add_to_playlist";
var _data4;
var _AddToPlaylistServiceEndpoint = class _AddToPlaylistServiceEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data4);
    __privateSet(this, _data4, data);
  }
  getApiPath() {
    return API_PATH2;
  }
  buildRequest() {
    const request = {};
    request.videoIds = __privateGet(this, _data4).videoIds ? __privateGet(this, _data4).videoIds : [__privateGet(this, _data4).videoId];
    if (__privateGet(this, _data4).playlistId)
      request.playlistId = __privateGet(this, _data4).playlistId;
    if (__privateGet(this, _data4).params)
      request.params = __privateGet(this, _data4).params;
    request.excludeWatchLater = !!__privateGet(this, _data4).excludeWatchLater;
    return request;
  }
};
_data4 = new WeakMap();
__name(_AddToPlaylistServiceEndpoint, "AddToPlaylistServiceEndpoint");
__publicField(_AddToPlaylistServiceEndpoint, "type", "AddToPlaylistServiceEndpoint");
var AddToPlaylistServiceEndpoint = _AddToPlaylistServiceEndpoint;

// dist/src/parser/classes/endpoints/AddToPlaylistEndpoint.js
var _AddToPlaylistEndpoint = class _AddToPlaylistEndpoint extends AddToPlaylistServiceEndpoint {
  constructor(data) {
    super(data);
  }
};
__name(_AddToPlaylistEndpoint, "AddToPlaylistEndpoint");
__publicField(_AddToPlaylistEndpoint, "type", "AddToPlaylistEndpoint");
var AddToPlaylistEndpoint = _AddToPlaylistEndpoint;

// dist/src/parser/classes/endpoints/BrowseEndpoint.js
var API_PATH3 = "browse";
var _data5;
var _BrowseEndpoint = class _BrowseEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data5);
    __privateSet(this, _data5, data);
  }
  getApiPath() {
    return API_PATH3;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data5).browseId)
      request.browseId = __privateGet(this, _data5).browseId;
    if (__privateGet(this, _data5).params)
      request.params = __privateGet(this, _data5).params;
    if (__privateGet(this, _data5).query)
      request.query = __privateGet(this, _data5).query;
    if (__privateGet(this, _data5).browseId === "FEsubscriptions") {
      request.subscriptionSettingsState = __privateGet(this, _data5).subscriptionSettingsState || "MY_SUBS_SETTINGS_STATE_LAYOUT_FORMAT_LIST";
    }
    if (__privateGet(this, _data5).browseId === "SPaccount_playback") {
      request.formData = __privateGet(this, _data5).formData || {
        accountSettingsFormData: {
          flagCaptionsDefaultOff: false,
          flagAutoCaptionsDefaultOn: false,
          flagDisableInlinePreview: false,
          flagAudioDescriptionDefaultOn: false
        }
      };
    }
    if (__privateGet(this, _data5).browseId === "FEwhat_to_watch") {
      if (__privateGet(this, _data5).browseRequestSupportedMetadata)
        request.browseRequestSupportedMetadata = __privateGet(this, _data5).browseRequestSupportedMetadata;
      if (__privateGet(this, _data5).inlineSettingStatus)
        request.inlineSettingStatus = __privateGet(this, _data5).inlineSettingStatus;
    }
    return request;
  }
};
_data5 = new WeakMap();
__name(_BrowseEndpoint, "BrowseEndpoint");
__publicField(_BrowseEndpoint, "type", "BrowseEndpoint");
var BrowseEndpoint = _BrowseEndpoint;

// dist/src/parser/classes/endpoints/CreateCommentEndpoint.js
var API_PATH4 = "comment/create_comment";
var _data6;
var _CreateCommentEndpoint = class _CreateCommentEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data6);
    __privateSet(this, _data6, data);
  }
  getApiPath() {
    return API_PATH4;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data6).createCommentParams)
      request.createCommentParams = __privateGet(this, _data6).createCommentParams;
    if (__privateGet(this, _data6).commentText)
      request.commentText = __privateGet(this, _data6).commentText;
    if (__privateGet(this, _data6).attachedVideoId)
      request.videoAttachment = { videoId: __privateGet(this, _data6).attachedVideoId };
    else if (__privateGet(this, _data6).pollOptions)
      request.pollAttachment = { choices: __privateGet(this, _data6).pollOptions };
    else if (__privateGet(this, _data6).imageBlobId)
      request.imageAttachment = { encryptedBlobId: __privateGet(this, _data6).imageBlobId };
    else if (__privateGet(this, _data6).sharedPostId)
      request.sharedPostAttachment = { postId: __privateGet(this, _data6).sharedPostId };
    if (__privateGet(this, _data6).accessRestrictions && typeof __privateGet(this, _data6).accessRestrictions === "number") {
      const restriction = __privateGet(this, _data6).accessRestrictions === 1 ? "RESTRICTION_TYPE_EVERYONE" : "RESTRICTION_TYPE_SPONSORS_ONLY";
      request.accessRestrictions = { restriction };
    }
    if (__privateGet(this, _data6).botguardResponse)
      request.botguardResponse = __privateGet(this, _data6).botguardResponse;
    return request;
  }
};
_data6 = new WeakMap();
__name(_CreateCommentEndpoint, "CreateCommentEndpoint");
__publicField(_CreateCommentEndpoint, "type", "CreateCommentEndpoint");
var CreateCommentEndpoint = _CreateCommentEndpoint;

// dist/src/parser/classes/endpoints/CreatePlaylistServiceEndpoint.js
var API_PATH5 = "playlist/create";
var _data7;
var _CreatePlaylistServiceEndpoint = class _CreatePlaylistServiceEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data7);
    __privateSet(this, _data7, data);
  }
  getApiPath() {
    return API_PATH5;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data7).title)
      request.title = __privateGet(this, _data7).title;
    if (__privateGet(this, _data7).privacyStatus)
      request.privacyStatus = __privateGet(this, _data7).privacyStatus;
    if (__privateGet(this, _data7).description)
      request.description = __privateGet(this, _data7).description;
    if (__privateGet(this, _data7).videoIds)
      request.videoIds = __privateGet(this, _data7).videoIds;
    if (__privateGet(this, _data7).params)
      request.params = __privateGet(this, _data7).params;
    if (__privateGet(this, _data7).sourcePlaylistId)
      request.sourcePlaylistId = __privateGet(this, _data7).sourcePlaylistId;
    return request;
  }
};
_data7 = new WeakMap();
__name(_CreatePlaylistServiceEndpoint, "CreatePlaylistServiceEndpoint");
__publicField(_CreatePlaylistServiceEndpoint, "type", "CreatePlaylistServiceEndpoint");
var CreatePlaylistServiceEndpoint = _CreatePlaylistServiceEndpoint;

// dist/src/parser/classes/endpoints/DeletePlaylistEndpoint.js
var API_PATH6 = "playlist/delete";
var _data8;
var _DeletePlaylistEndpoint = class _DeletePlaylistEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data8);
    __privateSet(this, _data8, data);
  }
  getApiPath() {
    return API_PATH6;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data8).playlistId)
      request.playlistId = __privateGet(this, _data8).sourcePlaylistId;
    return request;
  }
};
_data8 = new WeakMap();
__name(_DeletePlaylistEndpoint, "DeletePlaylistEndpoint");
__publicField(_DeletePlaylistEndpoint, "type", "DeletePlaylistEndpoint");
var DeletePlaylistEndpoint = _DeletePlaylistEndpoint;

// dist/src/parser/classes/endpoints/FeedbackEndpoint.js
var API_PATH7 = "feedback";
var _data9;
var _FeedbackEndpoint = class _FeedbackEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data9);
    __privateSet(this, _data9, data);
  }
  getApiPath() {
    return API_PATH7;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data9).feedbackToken)
      request.feedbackTokens = [__privateGet(this, _data9).feedbackToken];
    if (__privateGet(this, _data9).cpn)
      request.feedbackContext = { cpn: __privateGet(this, _data9).cpn };
    request.isFeedbackTokenUnencrypted = !!__privateGet(this, _data9).isFeedbackTokenUnencrypted;
    request.shouldMerge = !!__privateGet(this, _data9).shouldMerge;
    return request;
  }
};
_data9 = new WeakMap();
__name(_FeedbackEndpoint, "FeedbackEndpoint");
__publicField(_FeedbackEndpoint, "type", "FeedbackEndpoint");
var FeedbackEndpoint = _FeedbackEndpoint;

// dist/src/parser/classes/endpoints/GetAccountsListInnertubeEndpoint.js
var API_PATH8 = "account/accounts_list";
var _data10;
var _GetAccountsListInnertubeEndpoint = class _GetAccountsListInnertubeEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data10);
    __privateSet(this, _data10, data);
  }
  getApiPath() {
    return API_PATH8;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data10).requestType) {
      request.requestType = __privateGet(this, _data10).requestType;
      if (__privateGet(this, _data10).requestType === "ACCOUNTS_LIST_REQUEST_TYPE_CHANNEL_SWITCHER" || __privateGet(this, _data10).requestType === "ACCOUNTS_LIST_REQUEST_TYPE_IDENTITY_PROMPT") {
        if (__privateGet(this, _data10).nextUrl)
          request.nextNavendpoint = {
            urlEndpoint: {
              url: __privateGet(this, _data10).nextUrl
            }
          };
      }
    }
    if (__privateGet(this, _data10).channelSwitcherQuery)
      request.channelSwitcherQuery = __privateGet(this, _data10).channelSwitcherQuery;
    if (__privateGet(this, _data10).triggerChannelCreation)
      request.triggerChannelCreation = __privateGet(this, _data10).triggerChannelCreation;
    if (__privateGet(this, _data10).contentOwnerConfig && __privateGet(this, _data10).contentOwnerConfig.externalContentOwnerId)
      request.contentOwnerConfig = __privateGet(this, _data10).contentOwnerConfig;
    if (__privateGet(this, _data10).obfuscatedSelectedGaiaId)
      request.obfuscatedSelectedGaiaId = __privateGet(this, _data10).obfuscatedSelectedGaiaId;
    if (__privateGet(this, _data10).selectedSerializedDelegationContext)
      request.selectedSerializedDelegationContext = __privateGet(this, _data10).selectedSerializedDelegationContext;
    if (__privateGet(this, _data10).callCircumstance)
      request.callCircumstance = __privateGet(this, _data10).callCircumstance;
    return request;
  }
};
_data10 = new WeakMap();
__name(_GetAccountsListInnertubeEndpoint, "GetAccountsListInnertubeEndpoint");
__publicField(_GetAccountsListInnertubeEndpoint, "type", "GetAccountsListInnertubeEndpoint");
var GetAccountsListInnertubeEndpoint = _GetAccountsListInnertubeEndpoint;

// dist/src/parser/classes/endpoints/HideEngagementPanelEndpoint.js
var _HideEngagementPanelEndpoint = class _HideEngagementPanelEndpoint extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "panel_identifier");
    this.panel_identifier = data.panelIdentifier;
  }
};
__name(_HideEngagementPanelEndpoint, "HideEngagementPanelEndpoint");
__publicField(_HideEngagementPanelEndpoint, "type", "HideEngagementPanelEndpoint");
var HideEngagementPanelEndpoint = _HideEngagementPanelEndpoint;

// dist/src/parser/classes/endpoints/LikeEndpoint.js
var LIKE_API_PATH = "like/like";
var DISLIKE_API_PATH = "like/dislike";
var REMOVE_LIKE_API_PATH = "like/removelike";
var _data11;
var _LikeEndpoint = class _LikeEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data11);
    __privateSet(this, _data11, data);
  }
  getApiPath() {
    return __privateGet(this, _data11).status === "DISLIKE" ? DISLIKE_API_PATH : __privateGet(this, _data11).status === "INDIFFERENT" ? REMOVE_LIKE_API_PATH : LIKE_API_PATH;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data11).target)
      request.target = __privateGet(this, _data11).target;
    const params = this.getParams();
    if (params)
      request.params = params;
    return request;
  }
  getParams() {
    switch (__privateGet(this, _data11).status) {
      case "LIKE":
        return __privateGet(this, _data11).likeParams;
      case "DISLIKE":
        return __privateGet(this, _data11).dislikeParams;
      case "INDIFFERENT":
        return __privateGet(this, _data11).removeLikeParams;
      default:
        return void 0;
    }
  }
};
_data11 = new WeakMap();
__name(_LikeEndpoint, "LikeEndpoint");
__publicField(_LikeEndpoint, "type", "LikeEndpoint");
var LikeEndpoint = _LikeEndpoint;

// dist/src/parser/classes/endpoints/LiveChatItemContextMenuEndpoint.js
var API_PATH9 = "live_chat/get_item_context_menu";
var _data12;
var _LiveChatItemContextMenuEndpoint = class _LiveChatItemContextMenuEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data12);
    __privateSet(this, _data12, data);
  }
  getApiPath() {
    return API_PATH9;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data12).params)
      request.params = __privateGet(this, _data12).params;
    return request;
  }
};
_data12 = new WeakMap();
__name(_LiveChatItemContextMenuEndpoint, "LiveChatItemContextMenuEndpoint");
__publicField(_LiveChatItemContextMenuEndpoint, "type", "LiveChatItemContextMenuEndpoint");
var LiveChatItemContextMenuEndpoint = _LiveChatItemContextMenuEndpoint;

// dist/src/parser/classes/endpoints/ModifyChannelNotificationPreferenceEndpoint.js
var API_PATH10 = "notification/modify_channel_preference";
var _data13;
var _ModifyChannelNotificationPreferenceEndpoint = class _ModifyChannelNotificationPreferenceEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data13);
    __privateSet(this, _data13, data);
  }
  getApiPath() {
    return API_PATH10;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data13).params)
      request.params = __privateGet(this, _data13).params;
    if (__privateGet(this, _data13).secondaryParams)
      request.secondaryParams = __privateGet(this, _data13).secondaryParams;
    return request;
  }
};
_data13 = new WeakMap();
__name(_ModifyChannelNotificationPreferenceEndpoint, "ModifyChannelNotificationPreferenceEndpoint");
__publicField(_ModifyChannelNotificationPreferenceEndpoint, "type", "ModifyChannelNotificationPreferenceEndpoint");
var ModifyChannelNotificationPreferenceEndpoint = _ModifyChannelNotificationPreferenceEndpoint;

// dist/src/parser/classes/endpoints/PerformCommentActionEndpoint.js
var API_PATH11 = "comment/perform_comment_action";
var _data14;
var _PerformCommentActionEndpoint = class _PerformCommentActionEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data14);
    __privateSet(this, _data14, data);
  }
  getApiPath() {
    return API_PATH11;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data14).actions)
      request.actions = __privateGet(this, _data14).actions;
    if (__privateGet(this, _data14).action)
      request.actions = [__privateGet(this, _data14).action];
    return request;
  }
};
_data14 = new WeakMap();
__name(_PerformCommentActionEndpoint, "PerformCommentActionEndpoint");
__publicField(_PerformCommentActionEndpoint, "type", "PerformCommentActionEndpoint");
var PerformCommentActionEndpoint = _PerformCommentActionEndpoint;

// dist/src/parser/classes/endpoints/PlaylistEditEndpoint.js
var API_PATH12 = "browse/edit_playlist";
var _data15;
var _PlaylistEditEndpoint = class _PlaylistEditEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data15);
    __privateSet(this, _data15, data);
  }
  getApiPath() {
    return API_PATH12;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data15).actions)
      request.actions = __privateGet(this, _data15).actions;
    if (__privateGet(this, _data15).playlistId)
      request.playlistId = __privateGet(this, _data15).playlistId;
    if (__privateGet(this, _data15).params)
      request.params = __privateGet(this, _data15).params;
    return request;
  }
};
_data15 = new WeakMap();
__name(_PlaylistEditEndpoint, "PlaylistEditEndpoint");
__publicField(_PlaylistEditEndpoint, "type", "PlaylistEditEndpoint");
var PlaylistEditEndpoint = _PlaylistEditEndpoint;

// dist/src/parser/classes/endpoints/WatchEndpoint.js
var API_PATH13 = "player";
var _data16;
var _WatchEndpoint = class _WatchEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data16);
    __privateSet(this, _data16, data);
  }
  getApiPath() {
    return API_PATH13;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data16).videoId)
      request.videoId = __privateGet(this, _data16).videoId;
    if (__privateGet(this, _data16).playlistId)
      request.playlistId = __privateGet(this, _data16).playlistId;
    if (__privateGet(this, _data16).index !== void 0 || __privateGet(this, _data16).playlistIndex !== void 0)
      request.playlistIndex = __privateGet(this, _data16).index || __privateGet(this, _data16).playlistIndex;
    if (__privateGet(this, _data16).playerParams || __privateGet(this, _data16).params)
      request.params = __privateGet(this, _data16).playerParams || __privateGet(this, _data16).params;
    if (__privateGet(this, _data16).startTimeSeconds)
      request.startTimeSecs = __privateGet(this, _data16).startTimeSeconds;
    if (__privateGet(this, _data16).overrideMutedAtStart)
      request.overrideMutedAtStart = __privateGet(this, _data16).overrideMutedAtStart;
    request.racyCheckOk = !!__privateGet(this, _data16).racyCheckOk;
    request.contentCheckOk = !!__privateGet(this, _data16).contentCheckOk;
    return request;
  }
};
_data16 = new WeakMap();
__name(_WatchEndpoint, "WatchEndpoint");
__publicField(_WatchEndpoint, "type", "WatchEndpoint");
var WatchEndpoint = _WatchEndpoint;

// dist/src/parser/classes/endpoints/PrefetchWatchCommand.js
var _PrefetchWatchCommand = class _PrefetchWatchCommand extends WatchEndpoint {
  constructor(data) {
    super(data);
  }
};
__name(_PrefetchWatchCommand, "PrefetchWatchCommand");
__publicField(_PrefetchWatchCommand, "type", "PrefetchWatchCommand");
var PrefetchWatchCommand = _PrefetchWatchCommand;

// dist/src/parser/classes/endpoints/ReelWatchEndpoint.js
var API_PATH14 = "reel/reel_item_watch";
var _data17;
var _ReelWatchEndpoint = class _ReelWatchEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data17);
    __privateSet(this, _data17, data);
  }
  getApiPath() {
    return API_PATH14;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data17).videoId) {
      request.playerRequest = {
        videoId: __privateGet(this, _data17).videoId
      };
    }
    if (request.playerRequest) {
      if (__privateGet(this, _data17).playerParams)
        request.playerRequest.params = __privateGet(this, _data17).playerParams;
      if (__privateGet(this, _data17).racyCheckOk)
        request.playerRequest.racyCheckOk = !!__privateGet(this, _data17).racyCheckOk;
      if (__privateGet(this, _data17).contentCheckOk)
        request.playerRequest.contentCheckOk = !!__privateGet(this, _data17).contentCheckOk;
    }
    if (__privateGet(this, _data17).params)
      request.params = __privateGet(this, _data17).params;
    if (__privateGet(this, _data17).inputType)
      request.inputType = __privateGet(this, _data17).inputType;
    request.disablePlayerResponse = !!__privateGet(this, _data17).disablePlayerResponse;
    return request;
  }
};
_data17 = new WeakMap();
__name(_ReelWatchEndpoint, "ReelWatchEndpoint");
__publicField(_ReelWatchEndpoint, "type", "ReelWatchEndpoint");
var ReelWatchEndpoint = _ReelWatchEndpoint;

// dist/src/parser/classes/endpoints/SearchEndpoint.js
var API_PATH15 = "search";
var _data18;
var _SearchEndpoint = class _SearchEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data18);
    __privateSet(this, _data18, data);
  }
  getApiPath() {
    return API_PATH15;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data18).query)
      request.query = __privateGet(this, _data18).query;
    if (__privateGet(this, _data18).params)
      request.params = __privateGet(this, _data18).params;
    if (__privateGet(this, _data18).webSearchboxStatsUrl)
      request.webSearchboxStatsUrl = __privateGet(this, _data18).webSearchboxStatsUrl;
    if (__privateGet(this, _data18).suggestStats)
      request.suggestStats = __privateGet(this, _data18).suggestStats;
    return request;
  }
};
_data18 = new WeakMap();
__name(_SearchEndpoint, "SearchEndpoint");
__publicField(_SearchEndpoint, "type", "SearchEndpoint");
var SearchEndpoint = _SearchEndpoint;

// dist/src/parser/classes/endpoints/ShareEntityServiceEndpoint.js
var API_PATH16 = "share/get_share_panel";
var _data19;
var _ShareEntityServiceEndpoint = class _ShareEntityServiceEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data19);
    __privateSet(this, _data19, data);
  }
  getApiPath() {
    return API_PATH16;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data19).serializedShareEntity)
      request.serializedSharedEntity = __privateGet(this, _data19).serializedShareEntity;
    if (__privateGet(this, _data19).clientParams)
      request.clientParams = __privateGet(this, _data19).clientParams;
    return request;
  }
};
_data19 = new WeakMap();
__name(_ShareEntityServiceEndpoint, "ShareEntityServiceEndpoint");
__publicField(_ShareEntityServiceEndpoint, "type", "ShareEntityServiceEndpoint");
var ShareEntityServiceEndpoint = _ShareEntityServiceEndpoint;

// dist/src/parser/classes/endpoints/ShareEndpoint.js
var _ShareEndpoint = class _ShareEndpoint extends ShareEntityServiceEndpoint {
  constructor(data) {
    super(data);
  }
};
__name(_ShareEndpoint, "ShareEndpoint");
__publicField(_ShareEndpoint, "type", "ShareEndpoint");
var ShareEndpoint = _ShareEndpoint;

// dist/src/parser/classes/endpoints/ShareEntityEndpoint.js
var _ShareEntityEndpoint = class _ShareEntityEndpoint extends ShareEntityServiceEndpoint {
  constructor(data) {
    super(data);
  }
};
__name(_ShareEntityEndpoint, "ShareEntityEndpoint");
__publicField(_ShareEntityEndpoint, "type", "ShareEntityEndpoint");
var ShareEntityEndpoint = _ShareEntityEndpoint;

// dist/src/parser/classes/endpoints/ShowEngagementPanelEndpoint.js
var _ShowEngagementPanelEndpoint = class _ShowEngagementPanelEndpoint extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "panel_identifier");
    __publicField(this, "source_panel_identifier");
    this.panel_identifier = data.panelIdentifier;
    this.source_panel_identifier = data.sourcePanelIdentifier;
  }
};
__name(_ShowEngagementPanelEndpoint, "ShowEngagementPanelEndpoint");
__publicField(_ShowEngagementPanelEndpoint, "type", "ShowEngagementPanelEndpoint");
var ShowEngagementPanelEndpoint = _ShowEngagementPanelEndpoint;

// dist/src/parser/classes/endpoints/SignalServiceEndpoint.js
var _SignalServiceEndpoint = class _SignalServiceEndpoint extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "actions");
    __publicField(this, "signal");
    if (Array.isArray(data.actions)) {
      this.actions = parser_exports.parseArray(data.actions.map((action) => {
        delete action.clickTrackingParams;
        return action;
      }));
    }
    this.signal = data.signal;
  }
};
__name(_SignalServiceEndpoint, "SignalServiceEndpoint");
__publicField(_SignalServiceEndpoint, "type", "SignalServiceEndpoint");
var SignalServiceEndpoint = _SignalServiceEndpoint;

// dist/src/parser/classes/endpoints/SubscribeEndpoint.js
var API_PATH17 = "subscription/subscribe";
var _data20;
var _SubscribeEndpoint = class _SubscribeEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data20);
    __privateSet(this, _data20, data);
  }
  getApiPath() {
    return API_PATH17;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data20).channelIds)
      request.channelIds = __privateGet(this, _data20).channelIds;
    if (__privateGet(this, _data20).siloName)
      request.siloName = __privateGet(this, _data20).siloName;
    if (__privateGet(this, _data20).params)
      request.params = __privateGet(this, _data20).params;
    if (__privateGet(this, _data20).botguardResponse)
      request.botguardResponse = __privateGet(this, _data20).botguardResponse;
    if (__privateGet(this, _data20).feature)
      request.clientFeature = __privateGet(this, _data20).feature;
    return request;
  }
};
_data20 = new WeakMap();
__name(_SubscribeEndpoint, "SubscribeEndpoint");
__publicField(_SubscribeEndpoint, "type", "SubscribeEndpoint");
var SubscribeEndpoint = _SubscribeEndpoint;

// dist/src/parser/classes/endpoints/UnsubscribeEndpoint.js
var API_PATH18 = "subscription/unsubscribe";
var _data21;
var _UnsubscribeEndpoint = class _UnsubscribeEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data21);
    __privateSet(this, _data21, data);
  }
  getApiPath() {
    return API_PATH18;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data21).channelIds)
      request.channelIds = __privateGet(this, _data21).channelIds;
    if (__privateGet(this, _data21).siloName)
      request.siloName = __privateGet(this, _data21).siloName;
    if (__privateGet(this, _data21).params)
      request.params = __privateGet(this, _data21).params;
    return request;
  }
};
_data21 = new WeakMap();
__name(_UnsubscribeEndpoint, "UnsubscribeEndpoint");
__publicField(_UnsubscribeEndpoint, "type", "UnsubscribeEndpoint");
var UnsubscribeEndpoint = _UnsubscribeEndpoint;

// dist/src/parser/classes/endpoints/WatchNextEndpoint.js
var API_PATH19 = "next";
var _data22;
var _WatchNextEndpoint = class _WatchNextEndpoint extends YTNode {
  constructor(data) {
    super();
    __privateAdd(this, _data22);
    __privateSet(this, _data22, data);
  }
  getApiPath() {
    return API_PATH19;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data22).videoId)
      request.videoId = __privateGet(this, _data22).videoId;
    if (__privateGet(this, _data22).playlistId)
      request.playlistId = __privateGet(this, _data22).playlistId;
    if (__privateGet(this, _data22).index !== void 0 || __privateGet(this, _data22).playlistIndex !== void 0)
      request.playlistIndex = __privateGet(this, _data22).index || __privateGet(this, _data22).playlistIndex;
    if (__privateGet(this, _data22).playerParams || __privateGet(this, _data22).params)
      request.params = __privateGet(this, _data22).playerParams || __privateGet(this, _data22).params;
    request.racyCheckOk = !!__privateGet(this, _data22).racyCheckOk;
    request.contentCheckOk = !!__privateGet(this, _data22).contentCheckOk;
    return request;
  }
};
_data22 = new WeakMap();
__name(_WatchNextEndpoint, "WatchNextEndpoint");
__publicField(_WatchNextEndpoint, "type", "WatchNextEndpoint");
var WatchNextEndpoint = _WatchNextEndpoint;

// dist/src/parser/classes/Endscreen.js
var _Endscreen = class _Endscreen extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "elements");
    __publicField(this, "start_ms");
    this.elements = parser_exports.parseArray(data.elements);
    this.start_ms = data.startMs;
  }
};
__name(_Endscreen, "Endscreen");
__publicField(_Endscreen, "type", "Endscreen");
var Endscreen = _Endscreen;

// dist/src/parser/classes/EndscreenElement.js
var _EndscreenElement = class _EndscreenElement extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "style");
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "image");
    __publicField(this, "icon");
    __publicField(this, "metadata");
    __publicField(this, "call_to_action");
    __publicField(this, "hovercard_button");
    __publicField(this, "is_subscribe");
    __publicField(this, "playlist_length");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "left");
    __publicField(this, "top");
    __publicField(this, "width");
    __publicField(this, "aspect_ratio");
    __publicField(this, "start_ms");
    __publicField(this, "end_ms");
    __publicField(this, "id");
    this.style = data.style;
    this.title = new Text2(data.title);
    this.endpoint = new NavigationEndpoint(data.endpoint);
    if (Reflect.has(data, "image")) {
      this.image = Thumbnail.fromResponse(data.image);
    }
    if (Reflect.has(data, "icon")) {
      this.icon = Thumbnail.fromResponse(data.icon);
    }
    if (Reflect.has(data, "metadata")) {
      this.metadata = new Text2(data.metadata);
    }
    if (Reflect.has(data, "callToAction")) {
      this.call_to_action = new Text2(data.callToAction);
    }
    if (Reflect.has(data, "hovercardButton")) {
      this.hovercard_button = parser_exports.parseItem(data.hovercardButton);
    }
    if (Reflect.has(data, "isSubscribe")) {
      this.is_subscribe = !!data.isSubscribe;
    }
    if (Reflect.has(data, "playlistLength")) {
      this.playlist_length = new Text2(data.playlistLength);
    }
    if (Reflect.has(data, "thumbnailOverlays")) {
      this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    }
    this.left = parseFloat(data.left);
    this.width = parseFloat(data.width);
    this.top = parseFloat(data.top);
    this.aspect_ratio = parseFloat(data.aspectRatio);
    this.start_ms = parseFloat(data.startMs);
    this.end_ms = parseFloat(data.endMs);
    this.id = data.id;
  }
};
__name(_EndscreenElement, "EndscreenElement");
__publicField(_EndscreenElement, "type", "EndscreenElement");
var EndscreenElement = _EndscreenElement;

// dist/src/parser/classes/EndScreenPlaylist.js
var _EndScreenPlaylist = class _EndScreenPlaylist extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnails");
    __publicField(this, "video_count");
    this.id = data.playlistId;
    this.title = new Text2(data.title);
    this.author = new Text2(data.longBylineText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.video_count = new Text2(data.videoCountText);
  }
};
__name(_EndScreenPlaylist, "EndScreenPlaylist");
__publicField(_EndScreenPlaylist, "type", "EndScreenPlaylist");
var EndScreenPlaylist = _EndScreenPlaylist;

// dist/src/parser/classes/EndScreenVideo.js
var _EndScreenVideo = class _EndScreenVideo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "endpoint");
    __publicField(this, "short_view_count");
    __publicField(this, "badges");
    __publicField(this, "duration");
    this.id = data.videoId;
    this.title = new Text2(data.title);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    this.author = new Author(data.shortBylineText, data.ownerBadges);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.short_view_count = new Text2(data.shortViewCountText);
    this.badges = parser_exports.parseArray(data.badges);
    this.duration = {
      text: new Text2(data.lengthText).toString(),
      seconds: data.lengthInSeconds
    };
  }
};
__name(_EndScreenVideo, "EndScreenVideo");
__publicField(_EndScreenVideo, "type", "EndScreenVideo");
var EndScreenVideo = _EndScreenVideo;

// dist/src/parser/classes/ExpandableTab.js
var _ExpandableTab = class _ExpandableTab extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "selected");
    __publicField(this, "content");
    this.title = data.title;
    this.endpoint = new NavigationEndpoint(data.endpoint);
    this.selected = data.selected;
    this.content = parser_exports.parseItem(data.content);
  }
};
__name(_ExpandableTab, "ExpandableTab");
__publicField(_ExpandableTab, "type", "ExpandableTab");
var ExpandableTab = _ExpandableTab;

// dist/src/parser/classes/ExpandedShelfContents.js
var _ExpandedShelfContents = class _ExpandedShelfContents extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ExpandedShelfContents, "ExpandedShelfContents");
__publicField(_ExpandedShelfContents, "type", "ExpandedShelfContents");
var ExpandedShelfContents = _ExpandedShelfContents;

// dist/src/parser/classes/FancyDismissibleDialog.js
var _FancyDismissibleDialog = class _FancyDismissibleDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "dialog_message");
    __publicField(this, "confirm_label");
    this.dialog_message = new Text2(data.dialogMessage);
    this.confirm_label = new Text2(data.confirmLabel);
  }
};
__name(_FancyDismissibleDialog, "FancyDismissibleDialog");
__publicField(_FancyDismissibleDialog, "type", "FancyDismissibleDialog");
var FancyDismissibleDialog = _FancyDismissibleDialog;

// dist/src/parser/classes/FeedFilterChipBar.js
var _FeedFilterChipBar = class _FeedFilterChipBar extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data.contents, ChipCloudChip);
  }
};
__name(_FeedFilterChipBar, "FeedFilterChipBar");
__publicField(_FeedFilterChipBar, "type", "FeedFilterChipBar");
var FeedFilterChipBar = _FeedFilterChipBar;

// dist/src/parser/classes/FeedNudge.js
var _FeedNudge = class _FeedNudge extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "endpoint");
    __publicField(this, "apply_modernized_style");
    __publicField(this, "trim_style");
    __publicField(this, "background_style");
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
    this.endpoint = new NavigationEndpoint(data.impressionEndpoint);
    this.apply_modernized_style = data.applyModernizedStyle;
    this.trim_style = data.trimStyle;
    this.background_style = data.backgroundStyle;
  }
};
__name(_FeedNudge, "FeedNudge");
__publicField(_FeedNudge, "type", "FeedNudge");
var FeedNudge = _FeedNudge;

// dist/src/parser/classes/FeedTabbedHeader.js
var _FeedTabbedHeader = class _FeedTabbedHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_FeedTabbedHeader, "FeedTabbedHeader");
__publicField(_FeedTabbedHeader, "type", "FeedTabbedHeader");
var FeedTabbedHeader = _FeedTabbedHeader;

// dist/src/parser/classes/ToggleFormField.js
var _ToggleFormField = class _ToggleFormField extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    __publicField(this, "toggled");
    __publicField(this, "toggle_on_action");
    __publicField(this, "toggle_off_action");
    this.label = new Text(data.label);
    this.toggled = data.toggled;
    if ("toggleOnAction" in data)
      this.toggle_on_action = new NavigationEndpoint(data.toggleOnAction);
    if ("toggleOffAction" in data)
      this.toggle_off_action = new NavigationEndpoint(data.toggleOffAction);
  }
};
__name(_ToggleFormField, "ToggleFormField");
__publicField(_ToggleFormField, "type", "ToggleFormField");
var ToggleFormField = _ToggleFormField;

// dist/src/parser/classes/Form.js
var _Form = class _Form extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "fields");
    this.fields = parser_exports.parseArray(data.fields, ToggleFormField);
  }
};
__name(_Form, "Form");
__publicField(_Form, "type", "Form");
var Form = _Form;

// dist/src/parser/classes/FormPopup.js
var _FormPopup = class _FormPopup extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "form");
    __publicField(this, "buttons");
    this.title = new Text2(data.title);
    this.form = parser_exports.parseItem(data.form, Form);
    this.buttons = parser_exports.parseArray(data.buttons, Button);
  }
};
__name(_FormPopup, "FormPopup");
__publicField(_FormPopup, "type", "FormPopup");
var FormPopup = _FormPopup;

// dist/src/parser/classes/GameDetails.js
var _GameDetails = class _GameDetails extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "box_art");
    __publicField(this, "box_art_overlay_text");
    __publicField(this, "endpoint");
    __publicField(this, "is_official_box_art");
    this.title = new Text2(data.title);
    this.box_art = Thumbnail.fromResponse(data.boxArt);
    this.box_art_overlay_text = new Text2(data.boxArtOverlayText);
    this.endpoint = new NavigationEndpoint(data.endpoint);
    this.is_official_box_art = !!data.isOfficialBoxArt;
  }
};
__name(_GameDetails, "GameDetails");
__publicField(_GameDetails, "type", "GameDetails");
var GameDetails = _GameDetails;

// dist/src/parser/classes/Grid.js
var _Grid = class _Grid extends YTNode {
  constructor(data) {
    var _a, _b, _c;
    super();
    __publicField(this, "items");
    __publicField(this, "is_collapsible");
    __publicField(this, "visible_row_count");
    __publicField(this, "target_id");
    __publicField(this, "continuation");
    __publicField(this, "header");
    this.items = parser_exports.parseArray(data.items);
    if (Reflect.has(data, "header")) {
      this.header = parser_exports.parseItem(data.header);
    }
    if (Reflect.has(data, "isCollapsible")) {
      this.is_collapsible = data.isCollapsible;
    }
    if (Reflect.has(data, "visibleRowCount")) {
      this.visible_row_count = data.visibleRowCount;
    }
    if (Reflect.has(data, "targetId")) {
      this.target_id = data.targetId;
    }
    this.continuation = ((_c = (_b = (_a = data.continuations) == null ? void 0 : _a[0]) == null ? void 0 : _b.nextContinuationData) == null ? void 0 : _c.continuation) || null;
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_Grid, "Grid");
__publicField(_Grid, "type", "Grid");
var Grid = _Grid;

// dist/src/parser/classes/GridChannel.js
var _GridChannel = class _GridChannel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "subscribers");
    __publicField(this, "video_count");
    __publicField(this, "endpoint");
    __publicField(this, "subscribe_button");
    this.id = data.channelId;
    this.author = new Author({
      ...data.title,
      navigationEndpoint: data.navigationEndpoint
    }, data.ownerBadges, data.thumbnail);
    this.subscribers = new Text2(data.subscriberCountText);
    this.video_count = new Text2(data.videoCountText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.subscribe_button = parser_exports.parseItem(data.subscribeButton);
  }
};
__name(_GridChannel, "GridChannel");
__publicField(_GridChannel, "type", "GridChannel");
var GridChannel = _GridChannel;

// dist/src/parser/classes/GridHeader.js
var _GridHeader = class _GridHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_GridHeader, "GridHeader");
__publicField(_GridHeader, "type", "GridHeader");
var GridHeader = _GridHeader;

// dist/src/parser/classes/GridMix.js
var _GridMix = class _GridMix extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "thumbnails");
    __publicField(this, "video_count");
    __publicField(this, "video_count_short");
    __publicField(this, "endpoint");
    __publicField(this, "secondary_endpoint");
    __publicField(this, "thumbnail_overlays");
    this.id = data.playlistId;
    this.title = new Text2(data.title);
    this.author = ((_a = data.shortBylineText) == null ? void 0 : _a.simpleText) ? new Text2(data.shortBylineText) : ((_b = data.longBylineText) == null ? void 0 : _b.simpleText) ? new Text2(data.longBylineText) : null;
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.video_count = new Text2(data.videoCountText);
    this.video_count_short = new Text2(data.videoCountShortText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.secondary_endpoint = new NavigationEndpoint(data.secondaryNavigationEndpoint);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
  }
};
__name(_GridMix, "GridMix");
__publicField(_GridMix, "type", "GridMix");
var GridMix = _GridMix;

// dist/src/parser/classes/GridMovie.js
var _GridMovie = class _GridMovie extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    __publicField(this, "badges");
    __publicField(this, "metadata");
    __publicField(this, "thumbnail_overlays");
    const length_alt = (_a = data.thumbnailOverlays.find((overlay) => overlay.hasOwnProperty("thumbnailOverlayTimeStatusRenderer"))) == null ? void 0 : _a.thumbnailOverlayTimeStatusRenderer;
    this.id = data.videoId;
    this.title = new Text2(data.title);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.duration = data.lengthText ? new Text2(data.lengthText) : (length_alt == null ? void 0 : length_alt.text) ? new Text2(length_alt.text) : null;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.badges = parser_exports.parseArray(data.badges, MetadataBadge);
    this.metadata = new Text2(data.metadata);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
  }
};
__name(_GridMovie, "GridMovie");
__publicField(_GridMovie, "type", "GridMovie");
var GridMovie = _GridMovie;

// dist/src/parser/classes/GridPlaylist.js
var _GridPlaylist = class _GridPlaylist extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "badges");
    __publicField(this, "endpoint");
    __publicField(this, "view_playlist");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "sidebar_thumbnails");
    __publicField(this, "video_count");
    __publicField(this, "video_count_short");
    this.id = data.playlistId;
    this.title = new Text2(data.title);
    if (Reflect.has(data, "shortBylineText")) {
      this.author = new Author(data.shortBylineText, data.ownerBadges);
    }
    this.badges = parser_exports.parseArray(data.ownerBadges);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.view_playlist = new Text2(data.viewPlaylistText);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.thumbnail_renderer = parser_exports.parseItem(data.thumbnailRenderer);
    this.sidebar_thumbnails = [].concat(...((_a = data.sidebarThumbnails) == null ? void 0 : _a.map((thumbnail) => Thumbnail.fromResponse(thumbnail))) || []) || null;
    this.video_count = new Text2(data.thumbnailText);
    this.video_count_short = new Text2(data.videoCountShortText);
  }
};
__name(_GridPlaylist, "GridPlaylist");
__publicField(_GridPlaylist, "type", "GridPlaylist");
var GridPlaylist = _GridPlaylist;

// dist/src/parser/classes/GridShelfView.js
var _GridShelfView = class _GridShelfView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    __publicField(this, "header");
    __publicField(this, "content_aspect_ratio");
    __publicField(this, "enable_vertical_expansion");
    __publicField(this, "show_more_button");
    __publicField(this, "show_less_button");
    __publicField(this, "min_collapsed_item_count");
    this.contents = parser_exports.parseArray(data.contents);
    this.header = parser_exports.parseItem(data.header);
    this.content_aspect_ratio = data.contentAspectRatio;
    this.enable_vertical_expansion = data.enableVerticalExpansion;
    this.show_more_button = parser_exports.parseItem(data.showMoreButton, ButtonView);
    this.show_less_button = parser_exports.parseItem(data.showLessButton, ButtonView);
    this.min_collapsed_item_count = data.minCollapsedItemCount;
  }
};
__name(_GridShelfView, "GridShelfView");
__publicField(_GridShelfView, "type", "GridShelfView");
var GridShelfView = _GridShelfView;

// dist/src/parser/classes/ShowCustomThumbnail.js
var _ShowCustomThumbnail = class _ShowCustomThumbnail extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_ShowCustomThumbnail, "ShowCustomThumbnail");
__publicField(_ShowCustomThumbnail, "type", "ShowCustomThumbnail");
var ShowCustomThumbnail = _ShowCustomThumbnail;

// dist/src/parser/classes/ThumbnailOverlayBottomPanel.js
var _ThumbnailOverlayBottomPanel = class _ThumbnailOverlayBottomPanel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    if (Reflect.has(data, "text")) {
      this.text = new Text2(data.text);
    }
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType")) {
      this.icon_type = data.icon.iconType;
    }
  }
};
__name(_ThumbnailOverlayBottomPanel, "ThumbnailOverlayBottomPanel");
__publicField(_ThumbnailOverlayBottomPanel, "type", "ThumbnailOverlayBottomPanel");
var ThumbnailOverlayBottomPanel = _ThumbnailOverlayBottomPanel;

// dist/src/parser/classes/GridShow.js
var _GridShow = class _GridShow extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "endpoint");
    __publicField(this, "long_byline_text");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    this.title = new Text2(data.title);
    this.thumbnail_renderer = parseItem(data.thumbnailRenderer, ShowCustomThumbnail);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.long_byline_text = new Text2(data.longBylineText);
    this.thumbnail_overlays = parseArray(data.thumbnailOverlays, ThumbnailOverlayBottomPanel);
    this.author = new Author(data.shortBylineText, void 0);
  }
};
__name(_GridShow, "GridShow");
__publicField(_GridShow, "type", "GridShow");
var GridShow = _GridShow;

// dist/src/parser/classes/GridVideo.js
var _GridVideo = class _GridVideo extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "video_id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "rich_thumbnail");
    __publicField(this, "published");
    __publicField(this, "duration");
    __publicField(this, "author");
    __publicField(this, "views");
    __publicField(this, "short_view_count");
    __publicField(this, "endpoint");
    __publicField(this, "menu");
    __publicField(this, "buttons");
    __publicField(this, "upcoming");
    __publicField(this, "upcoming_text");
    __publicField(this, "is_reminder_set");
    const length_alt = (_a = data.thumbnailOverlays.find((overlay) => overlay.hasOwnProperty("thumbnailOverlayTimeStatusRenderer"))) == null ? void 0 : _a.thumbnailOverlayTimeStatusRenderer;
    this.video_id = data.videoId;
    this.title = new Text2(data.title);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    this.rich_thumbnail = parser_exports.parseItem(data.richThumbnail);
    this.published = new Text2(data.publishedTimeText);
    this.duration = data.lengthText ? new Text2(data.lengthText) : (length_alt == null ? void 0 : length_alt.text) ? new Text2(length_alt.text) : null;
    this.author = data.shortBylineText && new Author(data.shortBylineText, data.ownerBadges);
    this.views = new Text2(data.viewCountText);
    this.short_view_count = new Text2(data.shortViewCountText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.menu = parser_exports.parseItem(data.menu, Menu);
    if (Reflect.has(data, "buttons")) {
      this.buttons = parser_exports.parseArray(data.buttons);
    }
    if (Reflect.has(data, "upcomingEventData")) {
      this.upcoming = new Date(Number(`${data.upcomingEventData.startTime}000`));
      this.upcoming_text = new Text2(data.upcomingEventData.upcomingEventText);
      this.is_reminder_set = !!((_b = data.upcomingEventData) == null ? void 0 : _b.isReminderSet);
    }
  }
  /**
   * @deprecated Use {@linkcode video_id} instead.
   */
  get id() {
    return this.video_id;
  }
  get is_upcoming() {
    return Boolean(this.upcoming && this.upcoming > /* @__PURE__ */ new Date());
  }
};
__name(_GridVideo, "GridVideo");
__publicField(_GridVideo, "type", "GridVideo");
var GridVideo = _GridVideo;

// dist/src/parser/classes/GuideEntry.js
var _GuideEntry = class _GuideEntry extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "icon_type");
    __publicField(this, "thumbnails");
    __publicField(this, "badges");
    __publicField(this, "is_primary");
    this.title = new Text2(data.formattedTitle);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint || data.serviceEndpoint);
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType")) {
      this.icon_type = data.icon.iconType;
    }
    if (Reflect.has(data, "thumbnail")) {
      this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    }
    if (Reflect.has(data, "badges")) {
      this.badges = data.badges;
    }
    this.is_primary = !!data.isPrimary;
  }
};
__name(_GuideEntry, "GuideEntry");
__publicField(_GuideEntry, "type", "GuideEntry");
var GuideEntry = _GuideEntry;

// dist/src/parser/classes/GuideCollapsibleEntry.js
var _GuideCollapsibleEntry = class _GuideCollapsibleEntry extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "expander_item");
    __publicField(this, "collapser_item");
    __publicField(this, "expandable_items");
    this.expander_item = parseItem(data.expanderItem, GuideEntry);
    this.collapser_item = parseItem(data.collapserItem, GuideEntry);
    this.expandable_items = parseArray(data.expandableItems);
  }
};
__name(_GuideCollapsibleEntry, "GuideCollapsibleEntry");
__publicField(_GuideCollapsibleEntry, "type", "GuideCollapsibleEntry");
var GuideCollapsibleEntry = _GuideCollapsibleEntry;

// dist/src/parser/classes/GuideCollapsibleSectionEntry.js
var _GuideCollapsibleSectionEntry = class _GuideCollapsibleSectionEntry extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header_entry");
    __publicField(this, "expander_icon");
    __publicField(this, "collapser_icon");
    __publicField(this, "section_items");
    this.header_entry = parseItem(data.headerEntry);
    this.expander_icon = data.expanderIcon.iconType;
    this.collapser_icon = data.collapserIcon.iconType;
    this.section_items = parseArray(data.sectionItems);
  }
};
__name(_GuideCollapsibleSectionEntry, "GuideCollapsibleSectionEntry");
__publicField(_GuideCollapsibleSectionEntry, "type", "GuideCollapsibleSectionEntry");
var GuideCollapsibleSectionEntry = _GuideCollapsibleSectionEntry;

// dist/src/parser/classes/GuideDownloadsEntry.js
var _GuideDownloadsEntry = class _GuideDownloadsEntry extends GuideEntry {
  constructor(data) {
    super(data.entryRenderer.guideEntryRenderer);
    __publicField(this, "always_show");
    this.always_show = !!data.alwaysShow;
  }
};
__name(_GuideDownloadsEntry, "GuideDownloadsEntry");
__publicField(_GuideDownloadsEntry, "type", "GuideDownloadsEntry");
var GuideDownloadsEntry = _GuideDownloadsEntry;

// dist/src/parser/classes/GuideSection.js
var _GuideSection = class _GuideSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    if (Reflect.has(data, "formattedTitle")) {
      this.title = new Text2(data.formattedTitle);
    }
    this.items = parseArray(data.items);
  }
};
__name(_GuideSection, "GuideSection");
__publicField(_GuideSection, "type", "GuideSection");
var GuideSection = _GuideSection;

// dist/src/parser/classes/GuideSubscriptionsSection.js
var _GuideSubscriptionsSection = class _GuideSubscriptionsSection extends GuideSection {
};
__name(_GuideSubscriptionsSection, "GuideSubscriptionsSection");
__publicField(_GuideSubscriptionsSection, "type", "GuideSubscriptionsSection");
var GuideSubscriptionsSection = _GuideSubscriptionsSection;

// dist/src/parser/classes/HashtagHeader.js
var _HashtagHeader = class _HashtagHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "hashtag");
    __publicField(this, "hashtag_info");
    this.hashtag = new Text2(data.hashtag);
    this.hashtag_info = new Text2(data.hashtagInfoText);
  }
};
__name(_HashtagHeader, "HashtagHeader");
__publicField(_HashtagHeader, "type", "HashtagHeader");
var HashtagHeader = _HashtagHeader;

// dist/src/parser/classes/HashtagTile.js
var _HashtagTile = class _HashtagTile extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "hashtag");
    __publicField(this, "hashtag_info_text");
    __publicField(this, "hashtag_thumbnail");
    __publicField(this, "endpoint");
    __publicField(this, "hashtag_background_color");
    __publicField(this, "hashtag_video_count");
    __publicField(this, "hashtag_channel_count");
    this.hashtag = new Text2(data.hashtag);
    this.hashtag_info_text = new Text2(data.hashtagInfoText);
    this.hashtag_thumbnail = Thumbnail.fromResponse(data.hashtagThumbnail);
    this.endpoint = new NavigationEndpoint(data.onTapCommand);
    this.hashtag_background_color = data.hashtagBackgroundColor;
    this.hashtag_video_count = new Text2(data.hashtagVideoCount);
    this.hashtag_channel_count = new Text2(data.hashtagChannelCount);
  }
};
__name(_HashtagTile, "HashtagTile");
__publicField(_HashtagTile, "type", "HashtagTile");
var HashtagTile = _HashtagTile;

// dist/src/parser/classes/HeroPlaylistThumbnail.js
var _HeroPlaylistThumbnail = class _HeroPlaylistThumbnail extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "on_tap_endpoint");
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.on_tap_endpoint = new NavigationEndpoint(data.onTap);
  }
};
__name(_HeroPlaylistThumbnail, "HeroPlaylistThumbnail");
__publicField(_HeroPlaylistThumbnail, "type", "HeroPlaylistThumbnail");
var HeroPlaylistThumbnail = _HeroPlaylistThumbnail;

// dist/src/parser/classes/HighlightsCarousel.js
var _Panel = class _Panel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "background_image");
    __publicField(this, "strapline");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "text_on_tap_endpoint");
    __publicField(this, "cta");
    if (data.thumbnail) {
      this.thumbnail = {
        image: Thumbnail.fromResponse(data.thumbnail.image),
        endpoint: new NavigationEndpoint(data.thumbnail.onTap),
        on_long_press_endpoint: new NavigationEndpoint(data.thumbnail.onLongPress),
        content_mode: data.thumbnail.contentMode,
        crop_options: data.thumbnail.cropOptions
      };
    }
    this.background_image = {
      image: Thumbnail.fromResponse(data.backgroundImage.image),
      gradient_image: Thumbnail.fromResponse(data.backgroundImage.gradientImage)
    };
    this.strapline = data.strapline;
    this.title = data.title;
    this.description = data.description;
    this.cta = {
      icon_name: data.cta.iconName,
      title: data.cta.title,
      endpoint: new NavigationEndpoint(data.cta.onTap),
      accessibility_text: data.cta.accessibilityText,
      state: data.cta.state
    };
    this.text_on_tap_endpoint = new NavigationEndpoint(data.textOnTap);
  }
};
__name(_Panel, "Panel");
__publicField(_Panel, "type", "Panel");
var Panel = _Panel;
var _HighlightsCarousel = class _HighlightsCarousel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "panels");
    this.panels = observe(data.highlightsCarousel.panels.map((el) => new Panel(el)));
  }
};
__name(_HighlightsCarousel, "HighlightsCarousel");
__publicField(_HighlightsCarousel, "type", "HighlightsCarousel");
var HighlightsCarousel = _HighlightsCarousel;

// dist/src/parser/classes/SearchSuggestion.js
var _SearchSuggestion = class _SearchSuggestion extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "suggestion");
    __publicField(this, "endpoint");
    __publicField(this, "icon_type");
    __publicField(this, "service_endpoint");
    this.suggestion = new Text2(data.suggestion);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    if (Reflect.has(data, "icon")) {
      this.icon_type = data.icon.iconType;
    }
    if (Reflect.has(data, "serviceEndpoint")) {
      this.service_endpoint = new NavigationEndpoint(data.serviceEndpoint);
    }
  }
};
__name(_SearchSuggestion, "SearchSuggestion");
__publicField(_SearchSuggestion, "type", "SearchSuggestion");
var SearchSuggestion = _SearchSuggestion;

// dist/src/parser/classes/HistorySuggestion.js
var _HistorySuggestion = class _HistorySuggestion extends SearchSuggestion {
  constructor(data) {
    super(data);
  }
};
__name(_HistorySuggestion, "HistorySuggestion");
__publicField(_HistorySuggestion, "type", "HistorySuggestion");
var HistorySuggestion = _HistorySuggestion;

// dist/src/parser/classes/HorizontalMovieList.js
var _HorizontalMovieList = class _HorizontalMovieList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.items = parser_exports.parseArray(data.items);
    this.previous_button = parser_exports.parseItem(data.previousButton, Button);
    this.next_button = parser_exports.parseItem(data.nextButton, Button);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_HorizontalMovieList, "HorizontalMovieList");
__publicField(_HorizontalMovieList, "type", "HorizontalMovieList");
var HorizontalMovieList = _HorizontalMovieList;

// dist/src/parser/classes/IconLink.js
var _IconLink = class _IconLink extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    __publicField(this, "endpoint");
    this.icon_type = (_a = data.icon) == null ? void 0 : _a.iconType;
    if (Reflect.has(data, "tooltip")) {
      this.tooltip = new Text2(data.tooltip).toString();
    }
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
  }
};
__name(_IconLink, "IconLink");
__publicField(_IconLink, "type", "IconLink");
var IconLink = _IconLink;

// dist/src/parser/classes/ImageBannerView.js
var _ImageBannerView = class _ImageBannerView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "image");
    __publicField(this, "style");
    this.image = Thumbnail.fromResponse(data.image);
    this.style = data.style;
  }
};
__name(_ImageBannerView, "ImageBannerView");
__publicField(_ImageBannerView, "type", "ImageBannerView");
var ImageBannerView = _ImageBannerView;

// dist/src/parser/classes/IncludingResultsFor.js
var _IncludingResultsFor = class _IncludingResultsFor extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "including_results_for");
    __publicField(this, "corrected_query");
    __publicField(this, "corrected_query_endpoint");
    __publicField(this, "search_only_for");
    __publicField(this, "original_query");
    __publicField(this, "original_query_endpoint");
    this.including_results_for = new Text2(data.includingResultsFor);
    this.corrected_query = new Text2(data.correctedQuery);
    this.corrected_query_endpoint = new NavigationEndpoint(data.correctedQueryEndpoint);
    this.search_only_for = Reflect.has(data, "searchOnlyFor") ? new Text2(data.searchOnlyFor) : void 0;
    this.original_query = Reflect.has(data, "originalQuery") ? new Text2(data.originalQuery) : void 0;
    this.original_query_endpoint = Reflect.has(data, "originalQueryEndpoint") ? new NavigationEndpoint(data.originalQueryEndpoint) : void 0;
  }
};
__name(_IncludingResultsFor, "IncludingResultsFor");
__publicField(_IncludingResultsFor, "type", "IncludingResultsFor");
var IncludingResultsFor = _IncludingResultsFor;

// dist/src/parser/classes/InfoPanelContent.js
var _InfoPanelContent = class _InfoPanelContent extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "source");
    __publicField(this, "paragraphs");
    __publicField(this, "attributed_paragraphs");
    __publicField(this, "thumbnail");
    __publicField(this, "source_endpoint");
    __publicField(this, "truncate_paragraphs");
    __publicField(this, "background");
    __publicField(this, "inline_link_icon_type");
    this.title = new Text2(data.title);
    this.source = new Text2(data.source);
    if (Reflect.has(data, "paragraphs"))
      this.paragraphs = data.paragraphs.map((p) => new Text2(p));
    if (Reflect.has(data, "attributedParagraphs"))
      this.attributed_paragraphs = data.attributedParagraphs.map((p) => Text2.fromAttributed(p));
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.source_endpoint = new NavigationEndpoint(data.sourceEndpoint);
    this.truncate_paragraphs = !!data.truncateParagraphs;
    this.background = data.background;
    if (Reflect.has(data, "inlineLinkIcon") && Reflect.has(data.inlineLinkIcon, "iconType")) {
      this.inline_link_icon_type = data.inlineLinkIcon.iconType;
    }
  }
};
__name(_InfoPanelContent, "InfoPanelContent");
__publicField(_InfoPanelContent, "type", "InfoPanelContent");
var InfoPanelContent = _InfoPanelContent;

// dist/src/parser/classes/InfoPanelContainer.js
var _InfoPanelContainer = class _InfoPanelContainer extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "content");
    __publicField(this, "header_endpoint");
    __publicField(this, "background");
    __publicField(this, "title_style");
    __publicField(this, "icon_type");
    this.title = new Text2(data.title);
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.content = parser_exports.parseItem(data.content, InfoPanelContent);
    if (data.headerEndpoint)
      this.header_endpoint = new NavigationEndpoint(data.headerEndpoint);
    this.background = data.background;
    this.title_style = data.titleStyle;
    if (Reflect.has(data, "icon")) {
      this.icon_type = (_a = data.icon) == null ? void 0 : _a.iconType;
    }
  }
};
__name(_InfoPanelContainer, "InfoPanelContainer");
__publicField(_InfoPanelContainer, "type", "InfoPanelContainer");
var InfoPanelContainer = _InfoPanelContainer;

// dist/src/parser/classes/InteractiveTabbedHeader.js
var _InteractiveTabbedHeader = class _InteractiveTabbedHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header_type");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "metadata");
    __publicField(this, "badges");
    __publicField(this, "box_art");
    __publicField(this, "banner");
    __publicField(this, "buttons");
    __publicField(this, "auto_generated");
    this.header_type = data.type;
    this.title = new Text2(data.title);
    this.description = new Text2(data.description);
    this.metadata = new Text2(data.metadata);
    this.badges = parser_exports.parseArray(data.badges, MetadataBadge);
    this.box_art = Thumbnail.fromResponse(data.boxArt);
    this.banner = Thumbnail.fromResponse(data.banner);
    this.buttons = parser_exports.parseArray(data.buttons, [SubscribeButton, Button]);
    this.auto_generated = new Text2(data.autoGenerated);
  }
};
__name(_InteractiveTabbedHeader, "InteractiveTabbedHeader");
__publicField(_InteractiveTabbedHeader, "type", "InteractiveTabbedHeader");
var InteractiveTabbedHeader = _InteractiveTabbedHeader;

// dist/src/parser/classes/ItemSectionHeader.js
var _ItemSectionHeader = class _ItemSectionHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_ItemSectionHeader, "ItemSectionHeader");
__publicField(_ItemSectionHeader, "type", "ItemSectionHeader");
var ItemSectionHeader = _ItemSectionHeader;

// dist/src/parser/classes/ItemSectionTab.js
var _ItemSectionTab = class _ItemSectionTab extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "selected");
    __publicField(this, "endpoint");
    this.title = new Text2(data.title);
    this.selected = !!data.selected;
    this.endpoint = new NavigationEndpoint(data.endpoint);
  }
};
__name(_ItemSectionTab, "ItemSectionTab");
__publicField(_ItemSectionTab, "type", "Tab");
var ItemSectionTab = _ItemSectionTab;

// dist/src/parser/classes/ItemSectionTabbedHeader.js
var _ItemSectionTabbedHeader = class _ItemSectionTabbedHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "tabs");
    __publicField(this, "end_items");
    this.title = new Text2(data.title);
    this.tabs = parser_exports.parseArray(data.tabs, ItemSectionTab);
    if (Reflect.has(data, "endItems")) {
      this.end_items = parser_exports.parseArray(data.endItems);
    }
  }
};
__name(_ItemSectionTabbedHeader, "ItemSectionTabbedHeader");
__publicField(_ItemSectionTabbedHeader, "type", "ItemSectionTabbedHeader");
var ItemSectionTabbedHeader = _ItemSectionTabbedHeader;

// dist/src/parser/classes/SortFilterHeader.js
var _SortFilterHeader = class _SortFilterHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "filter_menu");
    this.filter_menu = parser_exports.parseItem(data.filterMenu, nodes_exports.SortFilterSubMenu);
  }
};
__name(_SortFilterHeader, "SortFilterHeader");
__publicField(_SortFilterHeader, "type", "SortFilterHeader");
var SortFilterHeader = _SortFilterHeader;

// dist/src/parser/classes/ItemSection.js
var _ItemSection = class _ItemSection extends YTNode {
  constructor(data) {
    var _a, _b, _c;
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "target_id");
    __publicField(this, "continuation");
    this.header = parser_exports.parseItem(data.header, [CommentsHeader, ItemSectionHeader, ItemSectionTabbedHeader, SortFilterHeader, FeedFilterChipBar]);
    this.contents = parser_exports.parseArray(data.contents);
    if (data.targetId || data.sectionIdentifier) {
      this.target_id = data.targetId || data.sectionIdentifier;
    }
    if (data.continuations) {
      this.continuation = (_c = (_b = (_a = data.continuations) == null ? void 0 : _a.at(0)) == null ? void 0 : _b.nextContinuationData) == null ? void 0 : _c.continuation;
    }
  }
};
__name(_ItemSection, "ItemSection");
__publicField(_ItemSection, "type", "ItemSection");
var ItemSection = _ItemSection;

// dist/src/parser/classes/LiveChat.js
var _LiveChat = class _LiveChat extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "header");
    __publicField(this, "initial_display_state");
    __publicField(this, "continuation");
    __publicField(this, "client_messages");
    __publicField(this, "is_replay");
    this.header = parser_exports.parseItem(data.header);
    this.initial_display_state = data.initialDisplayState;
    this.continuation = (_b = (_a = data.continuations[0]) == null ? void 0 : _a.reloadContinuationData) == null ? void 0 : _b.continuation;
    this.client_messages = {
      reconnect_message: new Text2(data.clientMessages.reconnectMessage),
      unable_to_reconnect_message: new Text2(data.clientMessages.unableToReconnectMessage),
      fatal_error: new Text2(data.clientMessages.fatalError),
      reconnected_message: new Text2(data.clientMessages.reconnectedMessage),
      generic_error: new Text2(data.clientMessages.genericError)
    };
    this.is_replay = !!data.isReplay;
  }
};
__name(_LiveChat, "LiveChat");
__publicField(_LiveChat, "type", "LiveChat");
var LiveChat = _LiveChat;

// dist/src/parser/classes/livechat/items/LiveChatBannerHeader.js
var _LiveChatBannerHeader = class _LiveChatBannerHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    __publicField(this, "context_menu_button");
    this.text = new Text2(data.text);
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType")) {
      this.icon_type = data.icon.iconType;
    }
    this.context_menu_button = parser_exports.parseItem(data.contextMenuButton, Button);
  }
};
__name(_LiveChatBannerHeader, "LiveChatBannerHeader");
__publicField(_LiveChatBannerHeader, "type", "LiveChatBannerHeader");
var LiveChatBannerHeader = _LiveChatBannerHeader;

// dist/src/parser/classes/livechat/items/LiveChatBanner.js
var _LiveChatBanner = class _LiveChatBanner extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "action_id");
    __publicField(this, "viewer_is_creator");
    __publicField(this, "target_id");
    __publicField(this, "is_stackable");
    __publicField(this, "background_type");
    __publicField(this, "banner_type");
    __publicField(this, "banner_properties_is_ephemeral");
    __publicField(this, "banner_properties_auto_collapse_delay_seconds");
    this.header = parser_exports.parseItem(data.header, LiveChatBannerHeader);
    this.contents = parser_exports.parseItem(data.contents);
    this.action_id = data.actionId;
    if (Reflect.has(data, "viewerIsCreator")) {
      this.viewer_is_creator = data.viewerIsCreator;
    }
    this.target_id = data.targetId;
    this.is_stackable = data.isStackable;
    if (Reflect.has(data, "backgroundType")) {
      this.background_type = data.backgroundType;
    }
    this.banner_type = data.bannerType;
    if (Reflect.has(data, "bannerProperties") && Reflect.has(data.bannerProperties, "isEphemeral")) {
      this.banner_properties_is_ephemeral = Boolean(data.bannerProperties.isEphemeral);
    }
    if (Reflect.has(data, "bannerProperties") && Reflect.has(data.bannerProperties, "autoCollapseDelay") && Reflect.has(data.bannerProperties.autoCollapseDelay, "seconds")) {
      this.banner_properties_auto_collapse_delay_seconds = data.bannerProperties.autoCollapseDelay.seconds;
    }
  }
};
__name(_LiveChatBanner, "LiveChatBanner");
__publicField(_LiveChatBanner, "type", "LiveChatBanner");
var LiveChatBanner = _LiveChatBanner;

// dist/src/parser/classes/livechat/AddBannerToLiveChatCommand.js
var _AddBannerToLiveChatCommand = class _AddBannerToLiveChatCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "banner");
    this.banner = parser_exports.parseItem(data.bannerRenderer, LiveChatBanner);
  }
};
__name(_AddBannerToLiveChatCommand, "AddBannerToLiveChatCommand");
__publicField(_AddBannerToLiveChatCommand, "type", "AddBannerToLiveChatCommand");
var AddBannerToLiveChatCommand = _AddBannerToLiveChatCommand;

// dist/src/parser/classes/livechat/AddChatItemAction.js
var _AddChatItemAction = class _AddChatItemAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "item");
    __publicField(this, "client_id");
    this.item = parser_exports.parseItem(data.item);
    if (Reflect.has(data, "clientId")) {
      this.client_id = data.clientId;
    }
  }
};
__name(_AddChatItemAction, "AddChatItemAction");
__publicField(_AddChatItemAction, "type", "AddChatItemAction");
var AddChatItemAction = _AddChatItemAction;

// dist/src/parser/classes/livechat/AddLiveChatTickerItemAction.js
var _AddLiveChatTickerItemAction = class _AddLiveChatTickerItemAction extends YTNode {
  // TODO: check this assumption.
  constructor(data) {
    super();
    __publicField(this, "item");
    __publicField(this, "duration_sec");
    this.item = parser_exports.parseItem(data.item);
    this.duration_sec = data.durationSec;
  }
};
__name(_AddLiveChatTickerItemAction, "AddLiveChatTickerItemAction");
__publicField(_AddLiveChatTickerItemAction, "type", "AddLiveChatTickerItemAction");
var AddLiveChatTickerItemAction = _AddLiveChatTickerItemAction;

// dist/src/parser/classes/livechat/DimChatItemAction.js
var _DimChatItemAction = class _DimChatItemAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "client_assigned_id");
    this.client_assigned_id = data.clientAssignedId;
  }
};
__name(_DimChatItemAction, "DimChatItemAction");
__publicField(_DimChatItemAction, "type", "DimChatItemAction");
var DimChatItemAction = _DimChatItemAction;

// dist/src/parser/classes/livechat/items/BumperUserEduContentView.js
var _BumperUserEduContentView = class _BumperUserEduContentView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "image_name");
    __publicField(this, "image_color");
    this.text = Text2.fromAttributed(data.text);
    this.image_name = data.image.sources[0].clientResource.imageName;
    this.image_color = data.image.sources[0].clientResource.imageColor;
  }
};
__name(_BumperUserEduContentView, "BumperUserEduContentView");
__publicField(_BumperUserEduContentView, "type", "BumperUserEduContentView");
var BumperUserEduContentView = _BumperUserEduContentView;

// dist/src/parser/classes/livechat/items/CreatorHeartView.js
var _CreatorHeartView = class _CreatorHeartView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "creator_thumbnail");
    __publicField(this, "hearted_icon_name");
    __publicField(this, "unhearted_icon_name");
    __publicField(this, "unhearted_icon_processor");
    __publicField(this, "hearted_hover_text");
    __publicField(this, "hearted_accessibility_label");
    __publicField(this, "unhearted_accessibility_label");
    __publicField(this, "engagement_state_key");
    this.creator_thumbnail = Thumbnail.fromResponse(data.creatorThumbnail);
    this.hearted_icon_name = data.heartedIcon.sources[0].clientResource.imageName;
    this.unhearted_icon_name = data.unheartedIcon.sources[0].clientResource.imageName;
    this.unhearted_icon_processor = {
      border_image_processor: {
        image_tint: {
          color: data.unheartedIcon.processor.borderImageProcessor.imageTint.color
        }
      }
    };
    this.hearted_hover_text = data.heartedHoverText;
    this.hearted_accessibility_label = data.heartedAccessibilityLabel;
    this.unhearted_accessibility_label = data.unheartedAccessibilityLabel;
    this.engagement_state_key = data.engagementStateKey;
  }
};
__name(_CreatorHeartView, "CreatorHeartView");
__publicField(_CreatorHeartView, "type", "CreatorHeartView");
var CreatorHeartView = _CreatorHeartView;

// dist/src/parser/classes/livechat/items/LiveChatAutoModMessage.js
var _LiveChatAutoModMessage = class _LiveChatAutoModMessage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "menu_endpoint");
    __publicField(this, "moderation_buttons");
    __publicField(this, "auto_moderated_item");
    __publicField(this, "header_text");
    __publicField(this, "timestamp");
    __publicField(this, "id");
    this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    this.moderation_buttons = parser_exports.parseArray(data.moderationButtons, Button);
    this.auto_moderated_item = parser_exports.parseItem(data.autoModeratedItem);
    this.header_text = new Text2(data.headerText);
    this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
    this.id = data.id;
  }
};
__name(_LiveChatAutoModMessage, "LiveChatAutoModMessage");
__publicField(_LiveChatAutoModMessage, "type", "LiveChatAutoModMessage");
var LiveChatAutoModMessage = _LiveChatAutoModMessage;

// dist/src/parser/classes/livechat/items/LiveChatBannerChatSummary.js
var _LiveChatBannerChatSummary = class _LiveChatBannerChatSummary extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "chat_summary");
    __publicField(this, "icon_type");
    __publicField(this, "like_feedback_button");
    __publicField(this, "dislike_feedback_button");
    this.id = data.liveChatSummaryId;
    this.chat_summary = new Text2(data.chatSummary);
    this.icon_type = data.icon.iconType;
    this.like_feedback_button = parser_exports.parseItem(data.likeFeedbackButton, ToggleButtonView);
    this.dislike_feedback_button = parser_exports.parseItem(data.dislikeFeedbackButton, ToggleButtonView);
  }
};
__name(_LiveChatBannerChatSummary, "LiveChatBannerChatSummary");
__publicField(_LiveChatBannerChatSummary, "type", "LiveChatBannerChatSummary");
var LiveChatBannerChatSummary = _LiveChatBannerChatSummary;

// dist/src/parser/classes/livechat/items/LiveChatBannerPoll.js
var _LiveChatBannerPoll = class _LiveChatBannerPoll extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "poll_question");
    __publicField(this, "author_photo");
    __publicField(this, "choices");
    __publicField(this, "collapsed_state_entity_key");
    __publicField(this, "live_chat_poll_state_entity_key");
    __publicField(this, "context_menu_button");
    this.poll_question = new Text2(data.pollQuestion);
    this.author_photo = Thumbnail.fromResponse(data.authorPhoto);
    this.choices = data.pollChoices.map((choice) => ({
      option_id: choice.pollOptionId,
      text: new Text2(choice.text).toString()
      // XXX: This toString should probably not be used here.
    }));
    this.collapsed_state_entity_key = data.collapsedStateEntityKey;
    this.live_chat_poll_state_entity_key = data.liveChatPollStateEntityKey;
    this.context_menu_button = parser_exports.parseItem(data.contextMenuButton, Button);
  }
};
__name(_LiveChatBannerPoll, "LiveChatBannerPoll");
__publicField(_LiveChatBannerPoll, "type", "LiveChatBannerPoll");
var LiveChatBannerPoll = _LiveChatBannerPoll;

// dist/src/parser/classes/livechat/items/LiveChatBannerRedirect.js
var _LiveChatBannerRedirect = class _LiveChatBannerRedirect extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "banner_message");
    __publicField(this, "author_photo");
    __publicField(this, "inline_action_button");
    __publicField(this, "context_menu_button");
    this.banner_message = new Text2(data.bannerMessage);
    this.author_photo = Thumbnail.fromResponse(data.authorPhoto);
    this.inline_action_button = parser_exports.parseItem(data.inlineActionButton, Button);
    this.context_menu_button = parser_exports.parseItem(data.contextMenuButton, Button);
  }
};
__name(_LiveChatBannerRedirect, "LiveChatBannerRedirect");
__publicField(_LiveChatBannerRedirect, "type", "LiveChatBannerRedirect");
var LiveChatBannerRedirect = _LiveChatBannerRedirect;

// dist/src/parser/classes/livechat/items/LiveChatItemBumperView.js
var _LiveChatItemBumperView = class _LiveChatItemBumperView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data.content, BumperUserEduContentView);
  }
};
__name(_LiveChatItemBumperView, "LiveChatItemBumperView");
__publicField(_LiveChatItemBumperView, "type", "LiveChatItemBumperView");
var LiveChatItemBumperView = _LiveChatItemBumperView;

// dist/src/parser/classes/livechat/items/LiveChatMembershipItem.js
var _LiveChatMembershipItem = class _LiveChatMembershipItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "header_primary_text");
    __publicField(this, "header_subtext");
    __publicField(this, "message");
    __publicField(this, "author");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    this.id = data.id;
    this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
    this.timestamp_usec = data.timestampUsec;
    if (Reflect.has(data, "timestampText")) {
      this.timestamp_text = new Text2(data.timestampText);
    }
    if (Reflect.has(data, "headerPrimaryText")) {
      this.header_primary_text = new Text2(data.headerPrimaryText);
    }
    this.header_subtext = new Text2(data.headerSubtext);
    if (Reflect.has(data, "message")) {
      this.message = new Text2(data.message);
    }
    this.author = new Author(data.authorName, data.authorBadges, data.authorPhoto, data.authorExternalChannelId);
    this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    this.context_menu_accessibility_label = data.contextMenuAccessibility.accessibilityData.label;
  }
};
__name(_LiveChatMembershipItem, "LiveChatMembershipItem");
__publicField(_LiveChatMembershipItem, "type", "LiveChatMembershipItem");
var LiveChatMembershipItem = _LiveChatMembershipItem;

// dist/src/parser/classes/livechat/items/LiveChatModeChangeMessage.js
var _LiveChatModeChangeMessage = class _LiveChatModeChangeMessage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "icon_type");
    __publicField(this, "text");
    __publicField(this, "subtext");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    this.id = data.id;
    this.icon_type = data.icon.iconType;
    this.text = new Text2(data.text);
    this.subtext = new Text2(data.subtext);
    this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
    this.timestamp_usec = data.timestampUsec;
    this.timestamp_text = new Text2(data.timestampText);
  }
};
__name(_LiveChatModeChangeMessage, "LiveChatModeChangeMessage");
__publicField(_LiveChatModeChangeMessage, "type", "LiveChatModeChangeMessage");
var LiveChatModeChangeMessage = _LiveChatModeChangeMessage;

// dist/src/parser/classes/livechat/items/PdgReplyButtonView.js
var _PdgReplyButtonView = class _PdgReplyButtonView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "reply_button");
    __publicField(this, "reply_count_entity_key");
    __publicField(this, "reply_count_placeholder");
    this.reply_button = parser_exports.parseItem(data.replyButton, ButtonView);
    this.reply_count_entity_key = data.replyCountEntityKey;
    this.reply_count_placeholder = Text2.fromAttributed(data.replyCountPlaceholder);
  }
};
__name(_PdgReplyButtonView, "PdgReplyButtonView");
__publicField(_PdgReplyButtonView, "type", "PdgReplyButtonView");
var PdgReplyButtonView = _PdgReplyButtonView;

// dist/src/parser/classes/livechat/items/LiveChatPaidMessage.js
var _LiveChatPaidMessage = class _LiveChatPaidMessage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "message");
    __publicField(this, "author");
    __publicField(this, "author_name_text_color");
    __publicField(this, "header_background_color");
    __publicField(this, "header_text_color");
    __publicField(this, "body_background_color");
    __publicField(this, "body_text_color");
    __publicField(this, "purchase_amount");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "timestamp_color");
    __publicField(this, "header_overlay_image");
    __publicField(this, "text_input_background_color");
    __publicField(this, "lower_bumper");
    __publicField(this, "creator_heart_button");
    __publicField(this, "is_v2_style");
    __publicField(this, "reply_button");
    this.id = data.id;
    this.message = new Text2(data.message);
    this.author = new Author(data.authorName, data.authorBadges, data.authorPhoto, data.authorExternalChannelId);
    this.author_name_text_color = data.authorNameTextColor;
    this.header_background_color = data.headerBackgroundColor;
    this.header_text_color = data.headerTextColor;
    this.body_background_color = data.bodyBackgroundColor;
    this.body_text_color = data.bodyTextColor;
    this.purchase_amount = new Text2(data.purchaseAmountText).toString();
    this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    this.context_menu_accessibility_label = data.contextMenuAccessibility.accessibilityData.label;
    this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
    this.timestamp_usec = data.timestampUsec;
    if (Reflect.has(data, "timestampText")) {
      this.timestamp_text = new Text2(data.timestampText).toString();
    }
    this.timestamp_color = data.timestampColor;
    if (Reflect.has(data, "headerOverlayImage")) {
      this.header_overlay_image = Thumbnail.fromResponse(data.headerOverlayImage);
    }
    this.text_input_background_color = data.textInputBackgroundColor;
    this.lower_bumper = parser_exports.parseItem(data.lowerBumper, LiveChatItemBumperView);
    this.creator_heart_button = parser_exports.parseItem(data.creatorHeartButton, CreatorHeartView);
    this.is_v2_style = data.isV2Style;
    this.reply_button = parser_exports.parseItem(data.replyButton, PdgReplyButtonView);
  }
};
__name(_LiveChatPaidMessage, "LiveChatPaidMessage");
__publicField(_LiveChatPaidMessage, "type", "LiveChatPaidMessage");
var LiveChatPaidMessage = _LiveChatPaidMessage;

// dist/src/parser/classes/livechat/items/LiveChatPaidSticker.js
var _LiveChatPaidSticker = class _LiveChatPaidSticker extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "money_chip_background_color");
    __publicField(this, "money_chip_text_color");
    __publicField(this, "background_color");
    __publicField(this, "author_name_text_color");
    __publicField(this, "sticker");
    __publicField(this, "sticker_accessibility_label");
    __publicField(this, "sticker_display_width");
    __publicField(this, "sticker_display_height");
    __publicField(this, "purchase_amount");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "is_v2_style");
    this.id = data.id;
    this.author = new Author(data.authorName, data.authorBadges, data.authorPhoto, data.authorExternalChannelId);
    this.money_chip_background_color = data.moneyChipBackgroundColor;
    this.money_chip_text_color = data.moneyChipTextColor;
    this.background_color = data.backgroundColor;
    this.author_name_text_color = data.authorNameTextColor;
    this.sticker = Thumbnail.fromResponse(data.sticker);
    this.sticker_accessibility_label = data.sticker.accessibility.accessibilityData.label;
    this.sticker_display_width = data.stickerDisplayWidth;
    this.sticker_display_height = data.stickerDisplayHeight;
    this.purchase_amount = new Text2(data.purchaseAmountText).toString();
    this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    this.context_menu = this.menu_endpoint;
    this.context_menu_accessibility_label = data.contextMenuAccessibility.accessibilityData.label;
    this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
    this.timestamp_usec = data.timestampUsec;
    this.is_v2_style = data.isV2Style;
  }
};
__name(_LiveChatPaidSticker, "LiveChatPaidSticker");
__publicField(_LiveChatPaidSticker, "type", "LiveChatPaidSticker");
var LiveChatPaidSticker = _LiveChatPaidSticker;

// dist/src/parser/classes/livechat/items/LiveChatPlaceholderItem.js
var _LiveChatPlaceholderItem = class _LiveChatPlaceholderItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp");
    this.id = data.id;
    this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
  }
};
__name(_LiveChatPlaceholderItem, "LiveChatPlaceholderItem");
__publicField(_LiveChatPlaceholderItem, "type", "LiveChatPlaceholderItem");
var LiveChatPlaceholderItem = _LiveChatPlaceholderItem;

// dist/src/parser/classes/livechat/items/LiveChatProductItem.js
var _LiveChatProductItem = class _LiveChatProductItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "accessibility_title");
    __publicField(this, "thumbnail");
    __publicField(this, "price");
    __publicField(this, "vendor_name");
    __publicField(this, "from_vendor_text");
    __publicField(this, "information_button");
    __publicField(this, "endpoint");
    __publicField(this, "creator_message");
    __publicField(this, "creator_name");
    __publicField(this, "author_photo");
    __publicField(this, "information_dialog");
    __publicField(this, "is_verified");
    __publicField(this, "creator_custom_message");
    this.title = data.title;
    this.accessibility_title = data.accessibilityTitle;
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.price = data.price;
    this.vendor_name = data.vendorName;
    this.from_vendor_text = data.fromVendorText;
    this.information_button = parser_exports.parseItem(data.informationButton);
    this.endpoint = new NavigationEndpoint(data.onClickCommand);
    this.creator_message = data.creatorMessage;
    this.creator_name = data.creatorName;
    this.author_photo = Thumbnail.fromResponse(data.authorPhoto);
    this.information_dialog = parser_exports.parseItem(data.informationDialog);
    this.is_verified = data.isVerified;
    this.creator_custom_message = new Text2(data.creatorCustomMessage);
  }
};
__name(_LiveChatProductItem, "LiveChatProductItem");
__publicField(_LiveChatProductItem, "type", "LiveChatProductItem");
var LiveChatProductItem = _LiveChatProductItem;

// dist/src/parser/classes/livechat/items/LiveChatRestrictedParticipation.js
var _LiveChatRestrictedParticipation = class _LiveChatRestrictedParticipation extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "message");
    __publicField(this, "icon_type");
    this.message = new Text2(data.message);
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType")) {
      this.icon_type = data.icon.iconType;
    }
  }
};
__name(_LiveChatRestrictedParticipation, "LiveChatRestrictedParticipation");
__publicField(_LiveChatRestrictedParticipation, "type", "LiveChatRestrictedParticipation");
var LiveChatRestrictedParticipation = _LiveChatRestrictedParticipation;

// dist/src/parser/classes/LiveChatAuthorBadge.js
var _LiveChatAuthorBadge = class _LiveChatAuthorBadge extends MetadataBadge {
  constructor(data) {
    super(data);
    __publicField(this, "custom_thumbnail");
    this.custom_thumbnail = Thumbnail.fromResponse(data.customThumbnail);
  }
};
__name(_LiveChatAuthorBadge, "LiveChatAuthorBadge");
__publicField(_LiveChatAuthorBadge, "type", "LiveChatAuthorBadge");
var LiveChatAuthorBadge = _LiveChatAuthorBadge;

// dist/src/parser/classes/livechat/items/LiveChatSponsorshipsHeader.js
var _LiveChatSponsorshipsHeader = class _LiveChatSponsorshipsHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "author_name");
    __publicField(this, "author_photo");
    __publicField(this, "author_badges");
    __publicField(this, "primary_text");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "image");
    this.author_name = new Text2(data.authorName);
    this.author_photo = Thumbnail.fromResponse(data.authorPhoto);
    this.author_badges = parser_exports.parseArray(data.authorBadges, LiveChatAuthorBadge);
    this.primary_text = new Text2(data.primaryText);
    this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    this.context_menu_accessibility_label = data.contextMenuAccessibility.accessibilityData.label;
    this.image = Thumbnail.fromResponse(data.image);
  }
};
__name(_LiveChatSponsorshipsHeader, "LiveChatSponsorshipsHeader");
__publicField(_LiveChatSponsorshipsHeader, "type", "LiveChatSponsorshipsHeader");
var LiveChatSponsorshipsHeader = _LiveChatSponsorshipsHeader;

// dist/src/parser/classes/livechat/items/LiveChatSponsorshipsGiftPurchaseAnnouncement.js
var _LiveChatSponsorshipsGiftPurchaseAnnouncement = class _LiveChatSponsorshipsGiftPurchaseAnnouncement extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp_usec");
    __publicField(this, "author_external_channel_id");
    __publicField(this, "header");
    this.id = data.id;
    this.timestamp_usec = data.timestampUsec;
    this.author_external_channel_id = data.authorExternalChannelId;
    this.header = parser_exports.parseItem(data.header, LiveChatSponsorshipsHeader);
  }
};
__name(_LiveChatSponsorshipsGiftPurchaseAnnouncement, "LiveChatSponsorshipsGiftPurchaseAnnouncement");
__publicField(_LiveChatSponsorshipsGiftPurchaseAnnouncement, "type", "LiveChatSponsorshipsGiftPurchaseAnnouncement");
var LiveChatSponsorshipsGiftPurchaseAnnouncement = _LiveChatSponsorshipsGiftPurchaseAnnouncement;

// dist/src/parser/classes/livechat/items/LiveChatSponsorshipsGiftRedemptionAnnouncement.js
var _LiveChatSponsorshipsGiftRedemptionAnnouncement = class _LiveChatSponsorshipsGiftRedemptionAnnouncement extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "author");
    __publicField(this, "message");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    this.id = data.id;
    this.timestamp_usec = data.timestampUsec;
    this.timestamp_text = new Text2(data.timestampText);
    this.author = new Author(data.authorName, data.authorBadges, data.authorPhoto, data.authorExternalChannelId);
    this.message = new Text2(data.message);
    this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    this.context_menu_accessibility_label = data.contextMenuAccessibility.accessibilityData.label;
  }
};
__name(_LiveChatSponsorshipsGiftRedemptionAnnouncement, "LiveChatSponsorshipsGiftRedemptionAnnouncement");
__publicField(_LiveChatSponsorshipsGiftRedemptionAnnouncement, "type", "LiveChatSponsorshipsGiftRedemptionAnnouncement");
var LiveChatSponsorshipsGiftRedemptionAnnouncement = _LiveChatSponsorshipsGiftRedemptionAnnouncement;

// dist/src/parser/classes/livechat/items/LiveChatTextMessage.js
var _LiveChatTextMessage = class _LiveChatTextMessage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "message");
    __publicField(this, "inline_action_buttons");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "author");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "before_content_buttons");
    this.id = data.id;
    this.message = new Text2(data.message);
    this.inline_action_buttons = parser_exports.parseArray(data.inlineActionButtons, Button);
    this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
    this.timestamp_usec = data.timestampUsec;
    if (Reflect.has(data, "timestampText")) {
      this.timestamp_text = new Text2(data.timestampText).toString();
    }
    this.author = new Author(data.authorName, data.authorBadges, data.authorPhoto, data.authorExternalChannelId);
    if (Reflect.has(data, "contextMenuEndpoint")) {
      this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    }
    if (Reflect.has(data, "contextMenuAccessibility") && Reflect.has(data.contextMenuAccessibility, "accessibilityData") && Reflect.has(data.contextMenuAccessibility.accessibilityData, "label")) {
      this.context_menu_accessibility_label = data.contextMenuAccessibility.accessibilityData.label;
    }
    this.before_content_buttons = parser_exports.parseArray(data.beforeContentButtons, ButtonView);
  }
};
__name(_LiveChatTextMessage, "LiveChatTextMessage");
__publicField(_LiveChatTextMessage, "type", "LiveChatTextMessage");
var LiveChatTextMessage = _LiveChatTextMessage;

// dist/src/parser/classes/livechat/items/LiveChatTickerPaidMessageItem.js
var _LiveChatTickerPaidMessageItem = class _LiveChatTickerPaidMessageItem extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "amount");
    __publicField(this, "amount_text_color");
    __publicField(this, "start_background_color");
    __publicField(this, "end_background_color");
    __publicField(this, "duration_sec");
    __publicField(this, "full_duration_sec");
    __publicField(this, "show_item");
    __publicField(this, "show_item_endpoint");
    __publicField(this, "animation_origin");
    __publicField(this, "open_engagement_panel_command");
    this.id = data.id;
    this.author = new Author(data.authorName || data.authorUsername, data.authorBadges, data.authorPhoto, data.authorExternalChannelId);
    if (Reflect.has(data, "amount")) {
      this.amount = new Text2(data.amount);
    }
    this.amount_text_color = data.amountTextColor;
    this.start_background_color = data.startBackgroundColor;
    this.end_background_color = data.endBackgroundColor;
    this.duration_sec = data.durationSec;
    this.full_duration_sec = data.fullDurationSec;
    this.show_item = parser_exports.parseItem((_b = (_a = data.showItemEndpoint) == null ? void 0 : _a.showLiveChatItemEndpoint) == null ? void 0 : _b.renderer);
    this.show_item_endpoint = new NavigationEndpoint(data.showItemEndpoint);
    this.animation_origin = data.animationOrigin;
    this.open_engagement_panel_command = new NavigationEndpoint(data.openEngagementPanelCommand);
  }
};
__name(_LiveChatTickerPaidMessageItem, "LiveChatTickerPaidMessageItem");
__publicField(_LiveChatTickerPaidMessageItem, "type", "LiveChatTickerPaidMessageItem");
var LiveChatTickerPaidMessageItem = _LiveChatTickerPaidMessageItem;

// dist/src/parser/classes/livechat/items/LiveChatTickerPaidStickerItem.js
var _LiveChatTickerPaidStickerItem = class _LiveChatTickerPaidStickerItem extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "id");
    __publicField(this, "author_external_channel_id");
    __publicField(this, "author_photo");
    __publicField(this, "start_background_color");
    __publicField(this, "end_background_color");
    __publicField(this, "duration_sec");
    __publicField(this, "full_duration_sec");
    __publicField(this, "show_item");
    __publicField(this, "show_item_endpoint");
    __publicField(this, "ticker_thumbnails");
    this.id = data.id;
    this.author_external_channel_id = data.authorExternalChannelId;
    this.author_photo = Thumbnail.fromResponse(data.authorPhoto);
    this.start_background_color = data.startBackgroundColor;
    this.end_background_color = data.endBackgroundColor;
    this.duration_sec = data.durationSec;
    this.full_duration_sec = data.fullDurationSec;
    this.show_item = parser_exports.parseItem((_b = (_a = data.showItemEndpoint) == null ? void 0 : _a.showLiveChatItemEndpoint) == null ? void 0 : _b.renderer);
    this.show_item_endpoint = new NavigationEndpoint(data.showItemEndpoint);
    this.ticker_thumbnails = data.tickerThumbnails.map((item) => {
      var _a2, _b2;
      return {
        thumbnails: Thumbnail.fromResponse(item),
        label: (_b2 = (_a2 = item == null ? void 0 : item.accessibility) == null ? void 0 : _a2.accessibilityData) == null ? void 0 : _b2.label
      };
    });
  }
};
__name(_LiveChatTickerPaidStickerItem, "LiveChatTickerPaidStickerItem");
__publicField(_LiveChatTickerPaidStickerItem, "type", "LiveChatTickerPaidStickerItem");
var LiveChatTickerPaidStickerItem = _LiveChatTickerPaidStickerItem;

// dist/src/parser/classes/livechat/items/LiveChatTickerSponsorItem.js
var _LiveChatTickerSponsorItem = class _LiveChatTickerSponsorItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "detail");
    __publicField(this, "author");
    __publicField(this, "duration_sec");
    this.id = data.id;
    this.detail = new Text2(data.detailText);
    this.author = new Author(data.authorName, data.authorBadges, data.sponsorPhoto, data.authorExternalChannelId);
    this.duration_sec = data.durationSec;
  }
};
__name(_LiveChatTickerSponsorItem, "LiveChatTickerSponsorItem");
__publicField(_LiveChatTickerSponsorItem, "type", "LiveChatTickerSponsorItem");
var LiveChatTickerSponsorItem = _LiveChatTickerSponsorItem;

// dist/src/parser/classes/livechat/items/LiveChatViewerEngagementMessage.js
var _LiveChatViewerEngagementMessage = class _LiveChatViewerEngagementMessage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "icon_type");
    __publicField(this, "message");
    __publicField(this, "action_button");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    this.id = data.id;
    if (Reflect.has(data, "timestampUsec")) {
      this.timestamp = Math.floor(parseInt(data.timestampUsec) / 1e3);
      this.timestamp_usec = data.timestampUsec;
    }
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType")) {
      this.icon_type = data.icon.iconType;
    }
    this.message = new Text2(data.message);
    this.action_button = parser_exports.parseItem(data.actionButton);
    if (Reflect.has(data, "contextMenuEndpoint")) {
      this.menu_endpoint = new NavigationEndpoint(data.contextMenuEndpoint);
    }
    if (Reflect.has(data, "contextMenuAccessibility") && Reflect.has(data.contextMenuAccessibility, "accessibilityData") && Reflect.has(data.contextMenuAccessibility.accessibilityData, "label")) {
      this.context_menu_accessibility_label = data.contextMenuAccessibility.accessibilityData.label;
    }
  }
};
__name(_LiveChatViewerEngagementMessage, "LiveChatViewerEngagementMessage");
__publicField(_LiveChatViewerEngagementMessage, "type", "LiveChatViewerEngagementMessage");
var LiveChatViewerEngagementMessage = _LiveChatViewerEngagementMessage;

// dist/src/parser/classes/livechat/items/PollHeader.js
var _PollHeader = class _PollHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "poll_question");
    __publicField(this, "thumbnails");
    __publicField(this, "metadata");
    __publicField(this, "live_chat_poll_type");
    __publicField(this, "context_menu_button");
    this.poll_question = new Text2(data.pollQuestion);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.metadata = new Text2(data.metadataText);
    this.live_chat_poll_type = data.liveChatPollType;
    this.context_menu_button = parser_exports.parseItem(data.contextMenuButton, Button);
  }
};
__name(_PollHeader, "PollHeader");
__publicField(_PollHeader, "type", "PollHeader");
var PollHeader = _PollHeader;

// dist/src/parser/classes/livechat/LiveChatActionPanel.js
var _LiveChatActionPanel = class _LiveChatActionPanel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "contents");
    __publicField(this, "target_id");
    this.id = data.id;
    this.contents = parser_exports.parse(data.contents);
    this.target_id = data.targetId;
  }
};
__name(_LiveChatActionPanel, "LiveChatActionPanel");
__publicField(_LiveChatActionPanel, "type", "LiveChatActionPanel");
var LiveChatActionPanel = _LiveChatActionPanel;

// dist/src/parser/classes/livechat/MarkChatItemAsDeletedAction.js
var _MarkChatItemAsDeletedAction = class _MarkChatItemAsDeletedAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "deleted_state_message");
    __publicField(this, "target_item_id");
    this.deleted_state_message = new Text2(data.deletedStateMessage);
    this.target_item_id = data.targetItemId;
  }
};
__name(_MarkChatItemAsDeletedAction, "MarkChatItemAsDeletedAction");
__publicField(_MarkChatItemAsDeletedAction, "type", "MarkChatItemAsDeletedAction");
var MarkChatItemAsDeletedAction = _MarkChatItemAsDeletedAction;

// dist/src/parser/classes/livechat/MarkChatItemsByAuthorAsDeletedAction.js
var _MarkChatItemsByAuthorAsDeletedAction = class _MarkChatItemsByAuthorAsDeletedAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "deleted_state_message");
    __publicField(this, "external_channel_id");
    this.deleted_state_message = new Text2(data.deletedStateMessage);
    this.external_channel_id = data.externalChannelId;
  }
};
__name(_MarkChatItemsByAuthorAsDeletedAction, "MarkChatItemsByAuthorAsDeletedAction");
__publicField(_MarkChatItemsByAuthorAsDeletedAction, "type", "MarkChatItemsByAuthorAsDeletedAction");
var MarkChatItemsByAuthorAsDeletedAction = _MarkChatItemsByAuthorAsDeletedAction;

// dist/src/parser/classes/livechat/RemoveBannerForLiveChatCommand.js
var _RemoveBannerForLiveChatCommand = class _RemoveBannerForLiveChatCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "target_action_id");
    this.target_action_id = data.targetActionId;
  }
};
__name(_RemoveBannerForLiveChatCommand, "RemoveBannerForLiveChatCommand");
__publicField(_RemoveBannerForLiveChatCommand, "type", "RemoveBannerForLiveChatCommand");
var RemoveBannerForLiveChatCommand = _RemoveBannerForLiveChatCommand;

// dist/src/parser/classes/livechat/RemoveChatItemAction.js
var _RemoveChatItemAction = class _RemoveChatItemAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "target_item_id");
    this.target_item_id = data.targetItemId;
  }
};
__name(_RemoveChatItemAction, "RemoveChatItemAction");
__publicField(_RemoveChatItemAction, "type", "RemoveChatItemAction");
var RemoveChatItemAction = _RemoveChatItemAction;

// dist/src/parser/classes/livechat/RemoveChatItemByAuthorAction.js
var _RemoveChatItemByAuthorAction = class _RemoveChatItemByAuthorAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "external_channel_id");
    this.external_channel_id = data.externalChannelId;
  }
};
__name(_RemoveChatItemByAuthorAction, "RemoveChatItemByAuthorAction");
__publicField(_RemoveChatItemByAuthorAction, "type", "RemoveChatItemByAuthorAction");
var RemoveChatItemByAuthorAction = _RemoveChatItemByAuthorAction;

// dist/src/parser/classes/livechat/ReplaceChatItemAction.js
var _ReplaceChatItemAction = class _ReplaceChatItemAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "target_item_id");
    __publicField(this, "replacement_item");
    this.target_item_id = data.targetItemId;
    this.replacement_item = parser_exports.parseItem(data.replacementItem);
  }
};
__name(_ReplaceChatItemAction, "ReplaceChatItemAction");
__publicField(_ReplaceChatItemAction, "type", "ReplaceChatItemAction");
var ReplaceChatItemAction = _ReplaceChatItemAction;

// dist/src/parser/classes/livechat/ReplaceLiveChatAction.js
var _ReplaceLiveChatAction = class _ReplaceLiveChatAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "to_replace");
    __publicField(this, "replacement");
    this.to_replace = data.toReplace;
    this.replacement = parser_exports.parseItem(data.replacement);
  }
};
__name(_ReplaceLiveChatAction, "ReplaceLiveChatAction");
__publicField(_ReplaceLiveChatAction, "type", "ReplaceLiveChatAction");
var ReplaceLiveChatAction = _ReplaceLiveChatAction;

// dist/src/parser/classes/livechat/ReplayChatItemAction.js
var _ReplayChatItemAction = class _ReplayChatItemAction extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "actions");
    __publicField(this, "video_offset_time_msec");
    this.actions = parser_exports.parseArray((_a = data.actions) == null ? void 0 : _a.map((action) => {
      delete action.clickTrackingParams;
      return action;
    }));
    this.video_offset_time_msec = data.videoOffsetTimeMsec;
  }
};
__name(_ReplayChatItemAction, "ReplayChatItemAction");
__publicField(_ReplayChatItemAction, "type", "ReplayChatItemAction");
var ReplayChatItemAction = _ReplayChatItemAction;

// dist/src/parser/classes/livechat/ShowLiveChatActionPanelAction.js
var _ShowLiveChatActionPanelAction = class _ShowLiveChatActionPanelAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "panel_to_show");
    this.panel_to_show = parser_exports.parseItem(data.panelToShow, LiveChatActionPanel);
  }
};
__name(_ShowLiveChatActionPanelAction, "ShowLiveChatActionPanelAction");
__publicField(_ShowLiveChatActionPanelAction, "type", "ShowLiveChatActionPanelAction");
var ShowLiveChatActionPanelAction = _ShowLiveChatActionPanelAction;

// dist/src/parser/classes/livechat/ShowLiveChatDialogAction.js
var _ShowLiveChatDialogAction = class _ShowLiveChatDialogAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "dialog");
    this.dialog = parser_exports.parseItem(data.dialog);
  }
};
__name(_ShowLiveChatDialogAction, "ShowLiveChatDialogAction");
__publicField(_ShowLiveChatDialogAction, "type", "ShowLiveChatDialogAction");
var ShowLiveChatDialogAction = _ShowLiveChatDialogAction;

// dist/src/parser/classes/livechat/ShowLiveChatTooltipCommand.js
var _ShowLiveChatTooltipCommand = class _ShowLiveChatTooltipCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "tooltip");
    this.tooltip = parser_exports.parseItem(data.tooltip);
  }
};
__name(_ShowLiveChatTooltipCommand, "ShowLiveChatTooltipCommand");
__publicField(_ShowLiveChatTooltipCommand, "type", "ShowLiveChatTooltipCommand");
var ShowLiveChatTooltipCommand = _ShowLiveChatTooltipCommand;

// dist/src/parser/classes/livechat/UpdateDateTextAction.js
var _UpdateDateTextAction = class _UpdateDateTextAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "date_text");
    this.date_text = new Text2(data.dateText).toString();
  }
};
__name(_UpdateDateTextAction, "UpdateDateTextAction");
__publicField(_UpdateDateTextAction, "type", "UpdateDateTextAction");
var UpdateDateTextAction = _UpdateDateTextAction;

// dist/src/parser/classes/livechat/UpdateDescriptionAction.js
var _UpdateDescriptionAction = class _UpdateDescriptionAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "description");
    this.description = new Text2(data.description);
  }
};
__name(_UpdateDescriptionAction, "UpdateDescriptionAction");
__publicField(_UpdateDescriptionAction, "type", "UpdateDescriptionAction");
var UpdateDescriptionAction = _UpdateDescriptionAction;

// dist/src/parser/classes/livechat/UpdateLiveChatPollAction.js
var _UpdateLiveChatPollAction = class _UpdateLiveChatPollAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "poll_to_update");
    this.poll_to_update = parser_exports.parseItem(data.pollToUpdate);
  }
};
__name(_UpdateLiveChatPollAction, "UpdateLiveChatPollAction");
__publicField(_UpdateLiveChatPollAction, "type", "UpdateLiveChatPollAction");
var UpdateLiveChatPollAction = _UpdateLiveChatPollAction;

// dist/src/parser/classes/livechat/UpdateTitleAction.js
var _UpdateTitleAction = class _UpdateTitleAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_UpdateTitleAction, "UpdateTitleAction");
__publicField(_UpdateTitleAction, "type", "UpdateTitleAction");
var UpdateTitleAction = _UpdateTitleAction;

// dist/src/parser/classes/livechat/UpdateToggleButtonTextAction.js
var _UpdateToggleButtonTextAction = class _UpdateToggleButtonTextAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "default_text");
    __publicField(this, "toggled_text");
    __publicField(this, "button_id");
    this.default_text = new Text2(data.defaultText).toString();
    this.toggled_text = new Text2(data.toggledText).toString();
    this.button_id = data.buttonId;
  }
};
__name(_UpdateToggleButtonTextAction, "UpdateToggleButtonTextAction");
__publicField(_UpdateToggleButtonTextAction, "type", "UpdateToggleButtonTextAction");
var UpdateToggleButtonTextAction = _UpdateToggleButtonTextAction;

// dist/src/parser/classes/livechat/UpdateViewershipAction.js
var _UpdateViewershipAction = class _UpdateViewershipAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "view_count");
    __publicField(this, "extra_short_view_count");
    __publicField(this, "original_view_count");
    __publicField(this, "unlabeled_view_count_value");
    __publicField(this, "is_live");
    const view_count_renderer = data.viewCount.videoViewCountRenderer;
    this.view_count = new Text2(view_count_renderer.viewCount);
    this.extra_short_view_count = new Text2(view_count_renderer.extraShortViewCount);
    this.original_view_count = parseInt(view_count_renderer.originalViewCount);
    this.unlabeled_view_count_value = new Text2(view_count_renderer.unlabeledViewCountValue);
    this.is_live = view_count_renderer.isLive;
  }
};
__name(_UpdateViewershipAction, "UpdateViewershipAction");
__publicField(_UpdateViewershipAction, "type", "UpdateViewershipAction");
var UpdateViewershipAction = _UpdateViewershipAction;

// dist/src/parser/classes/LiveChatDialog.js
var _LiveChatDialog = class _LiveChatDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "confirm_button");
    __publicField(this, "dialog_messages");
    this.confirm_button = parser_exports.parseItem(data.confirmButton, Button);
    this.dialog_messages = data.dialogMessages.map((el) => new Text2(el));
  }
};
__name(_LiveChatDialog, "LiveChatDialog");
__publicField(_LiveChatDialog, "type", "LiveChatDialog");
var LiveChatDialog = _LiveChatDialog;

// dist/src/parser/classes/LiveChatHeader.js
var _LiveChatHeader = class _LiveChatHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "overflow_menu");
    __publicField(this, "collapse_button");
    __publicField(this, "view_selector");
    this.overflow_menu = parser_exports.parseItem(data.overflowMenu, Menu);
    this.collapse_button = parser_exports.parseItem(data.collapseButton, Button);
    this.view_selector = parser_exports.parseItem(data.viewSelector, SortFilterSubMenu);
  }
};
__name(_LiveChatHeader, "LiveChatHeader");
__publicField(_LiveChatHeader, "type", "LiveChatHeader");
var LiveChatHeader = _LiveChatHeader;

// dist/src/parser/classes/LiveChatItemList.js
var _LiveChatItemList = class _LiveChatItemList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "max_items_to_display");
    __publicField(this, "more_comments_below_button");
    this.max_items_to_display = data.maxItemsToDisplay;
    this.more_comments_below_button = parser_exports.parseItem(data.moreCommentsBelowButton, Button);
  }
};
__name(_LiveChatItemList, "LiveChatItemList");
__publicField(_LiveChatItemList, "type", "LiveChatItemList");
var LiveChatItemList = _LiveChatItemList;

// dist/src/parser/classes/LiveChatMessageInput.js
var _LiveChatMessageInput = class _LiveChatMessageInput extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "author_name");
    __publicField(this, "author_photo");
    __publicField(this, "send_button");
    __publicField(this, "target_id");
    this.author_name = new Text2(data.authorName);
    this.author_photo = Thumbnail.fromResponse(data.authorPhoto);
    this.send_button = parser_exports.parseItem(data.sendButton, Button);
    this.target_id = data.targetId;
  }
};
__name(_LiveChatMessageInput, "LiveChatMessageInput");
__publicField(_LiveChatMessageInput, "type", "LiveChatMessageInput");
var LiveChatMessageInput = _LiveChatMessageInput;

// dist/src/parser/classes/LiveChatParticipant.js
var _LiveChatParticipant = class _LiveChatParticipant extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "name");
    __publicField(this, "photo");
    __publicField(this, "badges");
    this.name = new Text2(data.authorName);
    this.photo = Thumbnail.fromResponse(data.authorPhoto);
    this.badges = parser_exports.parseArray(data.authorBadges);
  }
};
__name(_LiveChatParticipant, "LiveChatParticipant");
__publicField(_LiveChatParticipant, "type", "LiveChatParticipant");
var LiveChatParticipant = _LiveChatParticipant;

// dist/src/parser/classes/LiveChatParticipantsList.js
var _LiveChatParticipantsList = class _LiveChatParticipantsList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "participants");
    this.title = new Text2(data.title);
    this.participants = parser_exports.parseArray(data.participants, LiveChatParticipant);
  }
};
__name(_LiveChatParticipantsList, "LiveChatParticipantsList");
__publicField(_LiveChatParticipantsList, "type", "LiveChatParticipantsList");
var LiveChatParticipantsList = _LiveChatParticipantsList;

// dist/src/parser/classes/LockupMetadataView.js
var _LockupMetadataView = class _LockupMetadataView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "metadata");
    __publicField(this, "image");
    __publicField(this, "menu_button");
    this.title = Text2.fromAttributed(data.title);
    this.metadata = parser_exports.parseItem(data.metadata, ContentMetadataView);
    this.image = parser_exports.parseItem(data.image, [DecoratedAvatarView, AvatarStackView]);
    this.menu_button = parser_exports.parseItem(data.menuButton, ButtonView);
  }
};
__name(_LockupMetadataView, "LockupMetadataView");
__publicField(_LockupMetadataView, "type", "LockupMetadataView");
var LockupMetadataView = _LockupMetadataView;

// dist/src/parser/classes/LockupView.js
var _LockupView = class _LockupView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content_image");
    __publicField(this, "metadata");
    __publicField(this, "content_id");
    __publicField(this, "content_type");
    __publicField(this, "renderer_context");
    this.content_image = parser_exports.parseItem(data.contentImage, [CollectionThumbnailView, ThumbnailView]);
    this.metadata = parser_exports.parseItem(data.metadata, LockupMetadataView);
    this.content_id = data.contentId;
    this.content_type = data.contentType.replace("LOCKUP_CONTENT_TYPE_", "");
    this.renderer_context = new RendererContext(data.rendererContext);
  }
};
__name(_LockupView, "LockupView");
__publicField(_LockupView, "type", "LockupView");
var LockupView = _LockupView;

// dist/src/parser/classes/MacroMarkersListEntity.js
var _MacroMarkersListEntity = class _MacroMarkersListEntity extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f;
    super();
    __publicField(this, "marker_entity_key");
    __publicField(this, "external_video_id");
    /** The type of markers in this entity (e.g., 'MARKER_TYPE_HEATMAP') */
    __publicField(this, "marker_type");
    __publicField(this, "markers");
    __publicField(this, "max_height_dp");
    __publicField(this, "min_height_dp");
    __publicField(this, "show_hide_animation_duration_millis");
    __publicField(this, "timed_marker_decorations");
    // Store raw API data for use in toHeatmap
    __publicField(this, "raw_api_markers");
    __publicField(this, "raw_api_decorations");
    this.marker_entity_key = data.key;
    this.external_video_id = data.externalVideoId;
    this.marker_type = ((_a = data.markersList) == null ? void 0 : _a.markerType) || "";
    this.raw_api_markers = ((_b = data.markersList) == null ? void 0 : _b.markers) || [];
    this.raw_api_decorations = ((_d = (_c = data.markersList) == null ? void 0 : _c.markersDecoration) == null ? void 0 : _d.timedMarkerDecorations) || [];
    this.markers = observe(this.raw_api_markers.map((marker) => new HeatMarker(marker)));
    const heatmapMetadata = (_f = (_e = data.markersList) == null ? void 0 : _e.markersMetadata) == null ? void 0 : _f.heatmapMetadata;
    this.max_height_dp = (heatmapMetadata == null ? void 0 : heatmapMetadata.maxHeightDp) || 40;
    this.min_height_dp = (heatmapMetadata == null ? void 0 : heatmapMetadata.minHeightDp) || 4;
    this.show_hide_animation_duration_millis = (heatmapMetadata == null ? void 0 : heatmapMetadata.showHideAnimationDurationMillis) || 200;
    this.timed_marker_decorations = observe(this.raw_api_decorations.map((decoration) => new TimedMarkerDecoration(decoration)));
  }
  /**
  * Checks if this MacroMarkersListEntity represents heatmap data.
  * Only heatmap markers can be converted to Heatmap objects.
  */
  isHeatmap() {
    return this.marker_type === "MARKER_TYPE_HEATMAP";
  }
  /**
  * Converts this MacroMarkersListEntity to a Heatmap object
  * for compatibility with existing code. Only works for heatmap markers.
  * @returns Heatmap object if this entity contains heatmap data, null otherwise
  */
  toHeatmap() {
    if (!this.isHeatmap()) {
      return null;
    }
    const wrappedHeatMarkers = this.raw_api_markers.map((marker) => ({ HeatMarker: marker }));
    const wrappedDecorations = this.raw_api_decorations.map((decoration) => ({ TimedMarkerDecoration: decoration }));
    const heatmapRawPayload = {
      maxHeightDp: this.max_height_dp,
      minHeightDp: this.min_height_dp,
      showHideAnimationDurationMillis: this.show_hide_animation_duration_millis,
      heatMarkers: wrappedHeatMarkers,
      heatMarkersDecorations: wrappedDecorations
    };
    return parseItem({ Heatmap: heatmapRawPayload }, Heatmap);
  }
};
__name(_MacroMarkersListEntity, "MacroMarkersListEntity");
__publicField(_MacroMarkersListEntity, "type", "MacroMarkersListEntity");
var MacroMarkersListEntity = _MacroMarkersListEntity;

// dist/src/parser/classes/menus/MenuNavigationItem.js
var _MenuNavigationItem = class _MenuNavigationItem extends Button {
  constructor(data) {
    super(data);
  }
};
__name(_MenuNavigationItem, "MenuNavigationItem");
__publicField(_MenuNavigationItem, "type", "MenuNavigationItem");
var MenuNavigationItem = _MenuNavigationItem;

// dist/src/parser/classes/menus/MenuPopup.js
var _MenuPopup = class _MenuPopup extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items, [MenuNavigationItem, MenuServiceItem]);
  }
};
__name(_MenuPopup, "MenuPopup");
__publicField(_MenuPopup, "type", "MenuPopup");
var MenuPopup = _MenuPopup;

// dist/src/parser/classes/Notification.js
var _Notification = class _Notification extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "video_thumbnails");
    __publicField(this, "short_message");
    __publicField(this, "sent_time");
    __publicField(this, "notification_id");
    __publicField(this, "endpoint");
    __publicField(this, "record_click_endpoint");
    __publicField(this, "menu");
    __publicField(this, "read");
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.video_thumbnails = Thumbnail.fromResponse(data.videoThumbnail);
    this.short_message = new Text2(data.shortMessage);
    this.sent_time = new Text2(data.sentTimeText);
    this.notification_id = data.notificationId;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.record_click_endpoint = new NavigationEndpoint(data.recordClickEndpoint);
    this.menu = parser_exports.parseItem(data.contextualMenu);
    this.read = data.read;
  }
};
__name(_Notification, "Notification");
__publicField(_Notification, "type", "Notification");
var Notification = _Notification;

// dist/src/parser/classes/menus/MultiPageMenuNotificationSection.js
var _MultiPageMenuNotificationSection = class _MultiPageMenuNotificationSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "notification_section_title");
    __publicField(this, "items");
    if ("notificationSectionTitle" in data) {
      this.notification_section_title = new Text2(data.notificationSectionTitle);
    }
    this.items = parser_exports.parseArray(data.items, [Notification, Message, ContinuationItem]);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_MultiPageMenuNotificationSection, "MultiPageMenuNotificationSection");
__publicField(_MultiPageMenuNotificationSection, "type", "MultiPageMenuNotificationSection");
var MultiPageMenuNotificationSection = _MultiPageMenuNotificationSection;

// dist/src/parser/classes/menus/MusicMenuItemDivider.js
var _MusicMenuItemDivider = class _MusicMenuItemDivider extends YTNode {
  constructor(_data23) {
    super();
  }
};
__name(_MusicMenuItemDivider, "MusicMenuItemDivider");
__publicField(_MusicMenuItemDivider, "type", "MusicMenuItemDivider");
var MusicMenuItemDivider = _MusicMenuItemDivider;

// dist/src/parser/classes/menus/MusicMultiSelectMenuItem.js
var _MusicMultiSelectMenuItem = class _MusicMultiSelectMenuItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "form_item_entity_key");
    __publicField(this, "selected_icon_type");
    __publicField(this, "endpoint");
    __publicField(this, "selected");
    this.title = new Text2(data.title).toString();
    this.form_item_entity_key = data.formItemEntityKey;
    if (Reflect.has(data, "selectedIcon")) {
      this.selected_icon_type = data.selectedIcon.iconType;
    }
    if (Reflect.has(data, "selectedCommand")) {
      this.endpoint = new NavigationEndpoint(data.selectedCommand);
    }
    this.selected = !!this.endpoint;
  }
};
__name(_MusicMultiSelectMenuItem, "MusicMultiSelectMenuItem");
__publicField(_MusicMultiSelectMenuItem, "type", "MusicMultiSelectMenuItem");
var MusicMultiSelectMenuItem = _MusicMultiSelectMenuItem;

// dist/src/parser/classes/menus/MusicMultiSelectMenu.js
var _MusicMultiSelectMenu = class _MusicMultiSelectMenu extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "title");
    __publicField(this, "options");
    if (Reflect.has(data, "title") && Reflect.has(data.title, "musicMenuTitleRenderer")) {
      this.title = new Text2((_a = data.title.musicMenuTitleRenderer) == null ? void 0 : _a.primaryText);
    }
    this.options = parser_exports.parseArray(data.options, [MusicMultiSelectMenuItem, MusicMenuItemDivider]);
  }
};
__name(_MusicMultiSelectMenu, "MusicMultiSelectMenu");
__publicField(_MusicMultiSelectMenu, "type", "MusicMultiSelectMenu");
var MusicMultiSelectMenu = _MusicMultiSelectMenu;

// dist/src/parser/classes/menus/SimpleMenuHeader.js
var _SimpleMenuHeader = class _SimpleMenuHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "buttons");
    this.title = new Text2(data.title);
    this.buttons = parser_exports.parseArray(data.buttons, Button);
  }
};
__name(_SimpleMenuHeader, "SimpleMenuHeader");
__publicField(_SimpleMenuHeader, "type", "SimpleMenuHeader");
var SimpleMenuHeader = _SimpleMenuHeader;

// dist/src/parser/classes/MerchandiseItem.js
var _MerchandiseItem = class _MerchandiseItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "thumbnails");
    __publicField(this, "price");
    __publicField(this, "vendor_name");
    __publicField(this, "button_text");
    __publicField(this, "button_accessibility_text");
    __publicField(this, "from_vendor_text");
    __publicField(this, "additional_fees_text");
    __publicField(this, "region_format");
    __publicField(this, "endpoint");
    this.title = data.title;
    this.description = data.description;
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.price = data.price;
    this.vendor_name = data.vendorName;
    this.button_text = data.buttonText;
    this.button_accessibility_text = data.buttonAccessibilityText;
    this.from_vendor_text = data.fromVendorText;
    this.additional_fees_text = data.additionalFeesText;
    this.region_format = data.regionFormat;
    this.endpoint = new NavigationEndpoint(data.buttonCommand);
  }
};
__name(_MerchandiseItem, "MerchandiseItem");
__publicField(_MerchandiseItem, "type", "MerchandiseItem");
var MerchandiseItem = _MerchandiseItem;

// dist/src/parser/classes/MerchandiseShelf.js
var _MerchandiseShelf = class _MerchandiseShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "items");
    this.title = data.title;
    this.menu = parser_exports.parseItem(data.actionButton);
    this.items = parser_exports.parseArray(data.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_MerchandiseShelf, "MerchandiseShelf");
__publicField(_MerchandiseShelf, "type", "MerchandiseShelf");
var MerchandiseShelf = _MerchandiseShelf;

// dist/src/parser/classes/MetadataRow.js
var _MetadataRow = class _MetadataRow extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "contents");
    this.title = new Text2(data.title);
    this.contents = data.contents.map((content) => new Text2(content));
  }
};
__name(_MetadataRow, "MetadataRow");
__publicField(_MetadataRow, "type", "MetadataRow");
var MetadataRow = _MetadataRow;

// dist/src/parser/classes/MetadataRowContainer.js
var _MetadataRowContainer = class _MetadataRowContainer extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "rows");
    __publicField(this, "collapsed_item_count");
    this.rows = parser_exports.parseArray(data.rows);
    this.collapsed_item_count = data.collapsedItemCount;
  }
};
__name(_MetadataRowContainer, "MetadataRowContainer");
__publicField(_MetadataRowContainer, "type", "MetadataRowContainer");
var MetadataRowContainer = _MetadataRowContainer;

// dist/src/parser/classes/MetadataRowHeader.js
var _MetadataRowHeader = class _MetadataRowHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    __publicField(this, "has_divider_line");
    this.content = new Text2(data.content);
    this.has_divider_line = data.hasDividerLine;
  }
};
__name(_MetadataRowHeader, "MetadataRowHeader");
__publicField(_MetadataRowHeader, "type", "MetadataRowHeader");
var MetadataRowHeader = _MetadataRowHeader;

// dist/src/parser/classes/MetadataScreen.js
var _MetadataScreen = class _MetadataScreen extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "section_list");
    this.section_list = parser_exports.parseItem(data);
  }
};
__name(_MetadataScreen, "MetadataScreen");
__publicField(_MetadataScreen, "type", "MetadataScreen");
var MetadataScreen = _MetadataScreen;

// dist/src/parser/classes/MicroformatData.js
var _MicroformatData = class _MicroformatData extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "url_canonical");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "thumbnail");
    __publicField(this, "site_name");
    __publicField(this, "app_name");
    __publicField(this, "android_package");
    __publicField(this, "ios_app_store_id");
    __publicField(this, "ios_app_arguments");
    __publicField(this, "og_type");
    __publicField(this, "url_applinks_web");
    __publicField(this, "url_applinks_ios");
    __publicField(this, "url_applinks_android");
    __publicField(this, "url_twitter_ios");
    __publicField(this, "url_twitter_android");
    __publicField(this, "twitter_card_type");
    __publicField(this, "twitter_site_handle");
    __publicField(this, "schema_dot_org_type");
    __publicField(this, "noindex");
    __publicField(this, "is_unlisted");
    __publicField(this, "is_family_safe");
    __publicField(this, "tags");
    __publicField(this, "available_countries");
    this.url_canonical = data.urlCanonical;
    this.title = data.title;
    this.description = data.description;
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.site_name = data.siteName;
    this.app_name = data.appName;
    this.android_package = data.androidPackage;
    this.ios_app_store_id = data.iosAppStoreId;
    this.ios_app_arguments = data.iosAppArguments;
    this.og_type = data.ogType;
    this.url_applinks_web = data.urlApplinksWeb;
    this.url_applinks_ios = data.urlApplinksIos;
    this.url_applinks_android = data.urlApplinksAndroid;
    this.url_twitter_ios = data.urlTwitterIos;
    this.url_twitter_android = data.urlTwitterAndroid;
    this.twitter_card_type = data.twitterCardType;
    this.twitter_site_handle = data.twitterSiteHandle;
    this.schema_dot_org_type = data.schemaDotOrgType;
    this.noindex = data.noindex;
    this.is_unlisted = data.unlisted;
    this.is_family_safe = data.familySafe;
    this.tags = data.tags;
    this.available_countries = data.availableCountries;
  }
};
__name(_MicroformatData, "MicroformatData");
__publicField(_MicroformatData, "type", "MicroformatData");
var MicroformatData = _MicroformatData;

// dist/src/parser/classes/Mix.js
var _Mix = class _Mix extends Playlist {
  constructor(data) {
    super(data);
  }
};
__name(_Mix, "Mix");
__publicField(_Mix, "type", "Mix");
var Mix = _Mix;

// dist/src/parser/classes/ModalWithTitleAndButton.js
var _ModalWithTitleAndButton = class _ModalWithTitleAndButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "content");
    __publicField(this, "button");
    this.title = new Text2(data.title);
    this.content = new Text2(data.content);
    this.button = parser_exports.parseItem(data.button, Button);
  }
};
__name(_ModalWithTitleAndButton, "ModalWithTitleAndButton");
__publicField(_ModalWithTitleAndButton, "type", "ModalWithTitleAndButton");
var ModalWithTitleAndButton = _ModalWithTitleAndButton;

// dist/src/parser/classes/Movie.js
var _Movie = class _Movie extends YTNode {
  constructor(data) {
    var _a, _b, _c;
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "description_snippet");
    __publicField(this, "top_metadata_items");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    __publicField(this, "badges");
    __publicField(this, "use_vertical_poster");
    __publicField(this, "show_action_menu");
    __publicField(this, "menu");
    const overlay_time_status = ((_a = data.thumbnailOverlays.find((overlay) => overlay.thumbnailOverlayTimeStatusRenderer)) == null ? void 0 : _a.thumbnailOverlayTimeStatusRenderer.text) || "N/A";
    this.id = data.videoId;
    this.title = new Text2(data.title);
    if (Reflect.has(data, "descriptionSnippet")) {
      this.description_snippet = new Text2(data.descriptionSnippet);
    }
    this.top_metadata_items = new Text2(data.topMetadataItems);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    this.author = new Author(data.longBylineText, data.ownerBadges, (_c = (_b = data.channelThumbnailSupportedRenderers) == null ? void 0 : _b.channelThumbnailWithLinkRenderer) == null ? void 0 : _c.thumbnail);
    this.duration = {
      text: data.lengthText ? new Text2(data.lengthText).toString() : new Text2(overlay_time_status).toString(),
      seconds: timeToSeconds(data.lengthText ? new Text2(data.lengthText).toString() : new Text2(overlay_time_status).toString())
    };
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.badges = parser_exports.parseArray(data.badges);
    this.use_vertical_poster = data.useVerticalPoster;
    this.show_action_menu = data.showActionMenu;
    this.menu = parser_exports.parseItem(data.menu, Menu);
  }
};
__name(_Movie, "Movie");
__publicField(_Movie, "type", "Movie");
var Movie = _Movie;

// dist/src/parser/classes/MovingThumbnail.js
var _MovingThumbnail = class _MovingThumbnail extends YTNode {
  constructor(data) {
    var _a;
    super();
    return (_a = data.movingThumbnailDetails) == null ? void 0 : _a.thumbnails.map((thumbnail) => new Thumbnail(thumbnail)).sort((a, b) => b.width - a.width);
  }
};
__name(_MovingThumbnail, "MovingThumbnail");
__publicField(_MovingThumbnail, "type", "MovingThumbnail");
var MovingThumbnail = _MovingThumbnail;

// dist/src/parser/classes/MusicCardShelfHeaderBasic.js
var _MusicCardShelfHeaderBasic = class _MusicCardShelfHeaderBasic extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_MusicCardShelfHeaderBasic, "MusicCardShelfHeaderBasic");
__publicField(_MusicCardShelfHeaderBasic, "type", "MusicCardShelfHeaderBasic");
var MusicCardShelfHeaderBasic = _MusicCardShelfHeaderBasic;

// dist/src/parser/classes/MusicInlineBadge.js
var _MusicInlineBadge = class _MusicInlineBadge extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "accessibility");
    this.icon_type = data.icon.iconType;
    if ("accessibilityData" in data && "accessibilityData" in data.accessibilityData) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibilityData.accessibilityData)
      };
    }
  }
  get label() {
    var _a, _b;
    return (_b = (_a = this.accessibility) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
};
__name(_MusicInlineBadge, "MusicInlineBadge");
__publicField(_MusicInlineBadge, "type", "MusicInlineBadge");
var MusicInlineBadge = _MusicInlineBadge;

// dist/src/parser/classes/MusicPlayButton.js
var _MusicPlayButton = class _MusicPlayButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "play_icon_type");
    __publicField(this, "pause_icon_type");
    __publicField(this, "icon_color");
    __publicField(this, "accessibility_play_data");
    __publicField(this, "accessibility_pause_data");
    this.endpoint = new NavigationEndpoint(data.playNavigationEndpoint);
    this.play_icon_type = data.playIcon.iconType;
    this.pause_icon_type = data.pauseIcon.iconType;
    if ("accessibilityPlayData" in data && "accessibilityData" in data.accessibilityPlayData) {
      this.accessibility_play_data = {
        accessibility_data: new AccessibilityData(data.accessibilityPlayData.accessibilityData)
      };
    }
    if ("accessibilityPauseData" in data && "accessibilityData" in data.accessibilityPauseData) {
      this.accessibility_pause_data = {
        accessibility_data: new AccessibilityData(data.accessibilityPauseData.accessibilityData)
      };
    }
    this.icon_color = data.iconColor;
  }
  get play_label() {
    var _a, _b;
    return (_b = (_a = this.accessibility_play_data) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
  get pause_label() {
    var _a, _b;
    return (_b = (_a = this.accessibility_pause_data) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
};
__name(_MusicPlayButton, "MusicPlayButton");
__publicField(_MusicPlayButton, "type", "MusicPlayButton");
var MusicPlayButton = _MusicPlayButton;

// dist/src/parser/classes/MusicItemThumbnailOverlay.js
var _MusicItemThumbnailOverlay = class _MusicItemThumbnailOverlay extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    __publicField(this, "content_position");
    __publicField(this, "display_style");
    this.content = parser_exports.parseItem(data.content, MusicPlayButton);
    this.content_position = data.contentPosition;
    this.display_style = data.displayStyle;
  }
};
__name(_MusicItemThumbnailOverlay, "MusicItemThumbnailOverlay");
__publicField(_MusicItemThumbnailOverlay, "type", "MusicItemThumbnailOverlay");
var MusicItemThumbnailOverlay = _MusicItemThumbnailOverlay;

// dist/src/parser/classes/MusicThumbnail.js
var _MusicThumbnail = class _MusicThumbnail extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_MusicThumbnail, "MusicThumbnail");
__publicField(_MusicThumbnail, "type", "MusicThumbnail");
var MusicThumbnail = _MusicThumbnail;

// dist/src/parser/classes/MusicCardShelf.js
var _MusicCardShelf = class _MusicCardShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "buttons");
    __publicField(this, "menu");
    __publicField(this, "on_tap");
    __publicField(this, "header");
    __publicField(this, "end_icon_type");
    __publicField(this, "subtitle_badges");
    __publicField(this, "thumbnail_overlay");
    __publicField(this, "contents");
    this.thumbnail = parser_exports.parseItem(data.thumbnail, MusicThumbnail);
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
    this.buttons = parser_exports.parseArray(data.buttons, Button);
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.on_tap = new NavigationEndpoint(data.onTap);
    this.header = parser_exports.parseItem(data.header, MusicCardShelfHeaderBasic);
    if (Reflect.has(data, "endIcon") && Reflect.has(data.endIcon, "iconType")) {
      this.end_icon_type = data.endIcon.iconType;
    }
    this.subtitle_badges = parser_exports.parseArray(data.subtitleBadges, MusicInlineBadge);
    this.thumbnail_overlay = parser_exports.parseItem(data.thumbnailOverlay, MusicItemThumbnailOverlay);
    if (Reflect.has(data, "contents")) {
      this.contents = parser_exports.parseArray(data.contents);
    }
  }
};
__name(_MusicCardShelf, "MusicCardShelf");
__publicField(_MusicCardShelf, "type", "MusicCardShelf");
var MusicCardShelf = _MusicCardShelf;

// dist/src/parser/classes/MusicCarouselShelfBasicHeader.js
var _MusicCarouselShelfBasicHeader = class _MusicCarouselShelfBasicHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "strapline");
    __publicField(this, "thumbnail");
    __publicField(this, "more_content");
    __publicField(this, "end_icons");
    this.title = new Text2(data.title);
    if (Reflect.has(data, "strapline")) {
      this.strapline = new Text2(data.strapline);
    }
    if (Reflect.has(data, "thumbnail")) {
      this.thumbnail = parser_exports.parseItem(data.thumbnail, MusicThumbnail);
    }
    if (Reflect.has(data, "moreContentButton")) {
      this.more_content = parser_exports.parseItem(data.moreContentButton, Button);
    }
    if (Reflect.has(data, "endIcons")) {
      this.end_icons = parser_exports.parseArray(data.endIcons, IconLink);
    }
  }
};
__name(_MusicCarouselShelfBasicHeader, "MusicCarouselShelfBasicHeader");
__publicField(_MusicCarouselShelfBasicHeader, "type", "MusicCarouselShelfBasicHeader");
var MusicCarouselShelfBasicHeader = _MusicCarouselShelfBasicHeader;

// dist/src/parser/classes/MusicMultiRowListItem.js
var _MusicMultiRowListItem = class _MusicMultiRowListItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "overlay");
    __publicField(this, "on_tap");
    __publicField(this, "menu");
    __publicField(this, "subtitle");
    __publicField(this, "title");
    __publicField(this, "second_title");
    __publicField(this, "description");
    __publicField(this, "display_style");
    this.thumbnail = parser_exports.parseItem(data.thumbnail, MusicThumbnail);
    this.overlay = parser_exports.parseItem(data.overlay, MusicItemThumbnailOverlay);
    this.on_tap = new NavigationEndpoint(data.onTap);
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.subtitle = new Text2(data.subtitle);
    this.title = new Text2(data.title);
    if (Reflect.has(data, "secondTitle")) {
      this.second_title = new Text2(data.secondTitle);
    }
    if (Reflect.has(data, "description")) {
      this.description = new Text2(data.description);
    }
    if (Reflect.has(data, "displayStyle")) {
      this.display_style = data.displayStyle;
    }
  }
};
__name(_MusicMultiRowListItem, "MusicMultiRowListItem");
__publicField(_MusicMultiRowListItem, "type", "MusicMultiRowListItem");
var MusicMultiRowListItem = _MusicMultiRowListItem;

// dist/src/parser/classes/MusicNavigationButton.js
var _MusicNavigationButton = class _MusicNavigationButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "button_text");
    __publicField(this, "endpoint");
    this.button_text = new Text2(data.buttonText).toString();
    this.endpoint = new NavigationEndpoint(data.clickCommand);
  }
};
__name(_MusicNavigationButton, "MusicNavigationButton");
__publicField(_MusicNavigationButton, "type", "MusicNavigationButton");
var MusicNavigationButton = _MusicNavigationButton;

// dist/src/parser/classes/MusicResponsiveListItemFixedColumn.js
var _MusicResponsiveListItemFixedColumn = class _MusicResponsiveListItemFixedColumn extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "display_priority");
    this.title = new Text2(data.text);
    this.display_priority = data.displayPriority;
  }
};
__name(_MusicResponsiveListItemFixedColumn, "MusicResponsiveListItemFixedColumn");
__publicField(_MusicResponsiveListItemFixedColumn, "type", "musicResponsiveListItemFlexColumnRenderer");
var MusicResponsiveListItemFixedColumn = _MusicResponsiveListItemFixedColumn;

// dist/src/parser/classes/MusicResponsiveListItemFlexColumn.js
var _MusicResponsiveListItemFlexColumn = class _MusicResponsiveListItemFlexColumn extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "display_priority");
    this.title = new Text2(data.text);
    this.display_priority = data.displayPriority;
  }
};
__name(_MusicResponsiveListItemFlexColumn, "MusicResponsiveListItemFlexColumn");
__publicField(_MusicResponsiveListItemFlexColumn, "type", "MusicResponsiveListItemFlexColumn");
var MusicResponsiveListItemFlexColumn = _MusicResponsiveListItemFlexColumn;

// dist/src/parser/classes/MusicResponsiveListItem.js
var _MusicResponsiveListItem_instances, parseOther_fn, parseVideoOrSong_fn, parseSong_fn, parseVideo_fn, parseArtist_fn, parseLibraryArtist_fn, parseNonMusicTrack_fn, parsePodcastShow_fn, parseAlbum_fn, parsePlaylist_fn;
var _MusicResponsiveListItem = class _MusicResponsiveListItem extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f;
    super();
    __privateAdd(this, _MusicResponsiveListItem_instances);
    __publicField(this, "flex_columns");
    __publicField(this, "fixed_columns");
    __publicField(this, "endpoint");
    __publicField(this, "item_type");
    __publicField(this, "index");
    __publicField(this, "thumbnail");
    __publicField(this, "badges");
    __publicField(this, "menu");
    __publicField(this, "overlay");
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "duration");
    __publicField(this, "album");
    __publicField(this, "artists");
    __publicField(this, "views");
    __publicField(this, "authors");
    __publicField(this, "name");
    __publicField(this, "subtitle");
    __publicField(this, "subscribers");
    __publicField(this, "song_count");
    // TODO: these might be replaceable with Author class
    __publicField(this, "author");
    __publicField(this, "item_count");
    __publicField(this, "year");
    this.flex_columns = parser_exports.parseArray(data.flexColumns, MusicResponsiveListItemFlexColumn);
    this.fixed_columns = parser_exports.parseArray(data.fixedColumns, MusicResponsiveListItemFixedColumn);
    const playlist_item_data = {
      video_id: ((_a = data == null ? void 0 : data.playlistItemData) == null ? void 0 : _a.videoId) || null,
      playlist_set_video_id: ((_b = data == null ? void 0 : data.playlistItemData) == null ? void 0 : _b.playlistSetVideoId) || null
    };
    if (Reflect.has(data, "navigationEndpoint")) {
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    }
    let page_type = (_f = (_e = (_d = (_c = this.endpoint) == null ? void 0 : _c.payload) == null ? void 0 : _d.browseEndpointContextSupportedConfigs) == null ? void 0 : _e.browseEndpointContextMusicConfig) == null ? void 0 : _f.pageType;
    if (!page_type) {
      const is_non_music_track = this.flex_columns.find((col) => {
        var _a2, _b2, _c2, _d2;
        return ((_d2 = (_c2 = (_b2 = (_a2 = col.title.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseEndpointContextSupportedConfigs) == null ? void 0 : _c2.browseEndpointContextMusicConfig) == null ? void 0 : _d2.pageType) === "MUSIC_PAGE_TYPE_NON_MUSIC_AUDIO_TRACK_PAGE";
      });
      if (is_non_music_track) {
        page_type = "MUSIC_PAGE_TYPE_NON_MUSIC_AUDIO_TRACK_PAGE";
      }
    }
    switch (page_type) {
      case "MUSIC_PAGE_TYPE_ALBUM":
        this.item_type = "album";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseAlbum_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_PLAYLIST":
        this.item_type = "playlist";
        __privateMethod(this, _MusicResponsiveListItem_instances, parsePlaylist_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_ARTIST":
      case "MUSIC_PAGE_TYPE_USER_CHANNEL":
        this.item_type = "artist";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseArtist_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_LIBRARY_ARTIST":
        this.item_type = "library_artist";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseLibraryArtist_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_NON_MUSIC_AUDIO_TRACK_PAGE":
        this.item_type = "non_music_track";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseNonMusicTrack_fn).call(this, playlist_item_data);
        break;
      case "MUSIC_PAGE_TYPE_PODCAST_SHOW_DETAIL_PAGE":
        this.item_type = "podcast_show";
        __privateMethod(this, _MusicResponsiveListItem_instances, parsePodcastShow_fn).call(this);
        break;
      default:
        if (this.flex_columns[1]) {
          __privateMethod(this, _MusicResponsiveListItem_instances, parseVideoOrSong_fn).call(this, playlist_item_data);
        } else {
          __privateMethod(this, _MusicResponsiveListItem_instances, parseOther_fn).call(this);
        }
    }
    if (Reflect.has(data, "index")) {
      this.index = new Text2(data.index);
    }
    if (Reflect.has(data, "thumbnail")) {
      this.thumbnail = parser_exports.parseItem(data.thumbnail, MusicThumbnail);
    }
    if (Reflect.has(data, "badges")) {
      this.badges = parser_exports.parseArray(data.badges);
    }
    if (Reflect.has(data, "menu")) {
      this.menu = parser_exports.parseItem(data.menu, Menu);
    }
    if (Reflect.has(data, "overlay")) {
      this.overlay = parser_exports.parseItem(data.overlay, MusicItemThumbnailOverlay);
    }
  }
  get thumbnails() {
    var _a;
    return ((_a = this.thumbnail) == null ? void 0 : _a.contents) || [];
  }
};
_MusicResponsiveListItem_instances = new WeakSet();
parseOther_fn = /* @__PURE__ */ __name(function() {
  this.title = this.flex_columns[0].title.toString();
  if (this.endpoint) {
    this.item_type = "endpoint";
  } else {
    this.item_type = "unknown";
  }
}, "#parseOther");
parseVideoOrSong_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  var _a, _b, _c, _d, _e, _f, _g;
  const music_video_type = (_g = (_f = (_e = (_d = (_c = (_b = (_a = this.flex_columns.at(0)) == null ? void 0 : _a.title.runs) == null ? void 0 : _b.at(0)) == null ? void 0 : _c.endpoint) == null ? void 0 : _d.payload) == null ? void 0 : _e.watchEndpointMusicSupportedConfigs) == null ? void 0 : _f.watchEndpointMusicConfig) == null ? void 0 : _g.musicVideoType;
  switch (music_video_type) {
    case "MUSIC_VIDEO_TYPE_UGC":
    case "MUSIC_VIDEO_TYPE_OMV":
      this.item_type = "video";
      __privateMethod(this, _MusicResponsiveListItem_instances, parseVideo_fn).call(this, playlist_item_data);
      break;
    case "MUSIC_VIDEO_TYPE_ATV":
      this.item_type = "song";
      __privateMethod(this, _MusicResponsiveListItem_instances, parseSong_fn).call(this, playlist_item_data);
      break;
    default:
      __privateMethod(this, _MusicResponsiveListItem_instances, parseOther_fn).call(this);
  }
}, "#parseVideoOrSong");
parseSong_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o;
  this.id = playlist_item_data.video_id || ((_b = (_a = this.endpoint) == null ? void 0 : _a.payload) == null ? void 0 : _b.videoId);
  this.title = this.flex_columns[0].title.toString();
  const duration_text = ((_e = (_d = (_c = this.flex_columns.at(1)) == null ? void 0 : _c.title.runs) == null ? void 0 : _d.find((run) => /^\d+$/.test(run.text.replace(/:/g, "")))) == null ? void 0 : _e.text) || ((_g = (_f = this.fixed_columns[0]) == null ? void 0 : _f.title) == null ? void 0 : _g.toString());
  if (duration_text) {
    this.duration = {
      text: duration_text,
      seconds: timeToSeconds(duration_text)
    };
  }
  const album_run = ((_i = (_h = this.flex_columns.at(1)) == null ? void 0 : _h.title.runs) == null ? void 0 : _i.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("MPR"))) || ((_k = (_j = this.flex_columns.at(2)) == null ? void 0 : _j.title.runs) == null ? void 0 : _k.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("MPR")));
  if (album_run && isTextRun(album_run)) {
    this.album = {
      id: (_m = (_l = album_run.endpoint) == null ? void 0 : _l.payload) == null ? void 0 : _m.browseId,
      name: album_run.text,
      endpoint: album_run.endpoint
    };
  }
  const artist_runs = (_o = (_n = this.flex_columns.at(1)) == null ? void 0 : _n.title.runs) == null ? void 0 : _o.filter((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (artist_runs) {
    this.artists = artist_runs.map((run) => {
      var _a2, _b2;
      return {
        name: run.text,
        channel_id: isTextRun(run) ? (_b2 = (_a2 = run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId : void 0,
        endpoint: isTextRun(run) ? run.endpoint : void 0
      };
    });
  }
}, "#parseSong");
parseVideo_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
  this.id = playlist_item_data.video_id;
  this.title = this.flex_columns[0].title.toString();
  this.views = (_c = (_b = (_a = this.flex_columns.at(1)) == null ? void 0 : _a.title.runs) == null ? void 0 : _b.find((run) => run.text.match(/(.*?) views/))) == null ? void 0 : _c.toString();
  const author_runs = (_e = (_d = this.flex_columns.at(1)) == null ? void 0 : _d.title.runs) == null ? void 0 : _e.filter((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (author_runs) {
    this.authors = author_runs.map((run) => {
      var _a2, _b2;
      return {
        name: run.text,
        channel_id: isTextRun(run) ? (_b2 = (_a2 = run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId : void 0,
        endpoint: isTextRun(run) ? run.endpoint : void 0
      };
    });
  }
  const duration_text = ((_g = (_f = this.flex_columns[1].title.runs) == null ? void 0 : _f.find((run) => /^\d+$/.test(run.text.replace(/:/g, "")))) == null ? void 0 : _g.text) || ((_j = (_i = (_h = this.fixed_columns[0]) == null ? void 0 : _h.title.runs) == null ? void 0 : _i.find((run) => /^\d+$/.test(run.text.replace(/:/g, "")))) == null ? void 0 : _j.text);
  if (duration_text) {
    this.duration = {
      text: duration_text,
      seconds: timeToSeconds(duration_text)
    };
  }
}, "#parseVideo");
parseArtist_fn = /* @__PURE__ */ __name(function() {
  var _a, _b, _c, _d, _e, _f;
  this.id = (_b = (_a = this.endpoint) == null ? void 0 : _a.payload) == null ? void 0 : _b.browseId;
  this.name = this.flex_columns[0].title.toString();
  this.subtitle = (_c = this.flex_columns.at(1)) == null ? void 0 : _c.title;
  this.subscribers = ((_f = (_e = (_d = this.subtitle) == null ? void 0 : _d.runs) == null ? void 0 : _e.find((run) => /^(\d*\.)?\d+[M|K]? subscribers?$/i.test(run.text))) == null ? void 0 : _f.text) || "";
}, "#parseArtist");
parseLibraryArtist_fn = /* @__PURE__ */ __name(function() {
  var _a, _b, _c, _d;
  this.name = this.flex_columns[0].title.toString();
  this.subtitle = (_a = this.flex_columns.at(1)) == null ? void 0 : _a.title;
  this.song_count = ((_d = (_c = (_b = this.subtitle) == null ? void 0 : _b.runs) == null ? void 0 : _c.find((run) => /^\d+(,\d+)? songs?$/i.test(run.text))) == null ? void 0 : _d.text) || "";
}, "#parseLibraryArtist");
parseNonMusicTrack_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  var _a, _b;
  this.id = playlist_item_data.video_id || ((_b = (_a = this.endpoint) == null ? void 0 : _a.payload) == null ? void 0 : _b.videoId);
  this.title = this.flex_columns[0].title.toString();
}, "#parseNonMusicTrack");
parsePodcastShow_fn = /* @__PURE__ */ __name(function() {
  var _a, _b;
  this.id = (_b = (_a = this.endpoint) == null ? void 0 : _a.payload) == null ? void 0 : _b.browseId;
  this.title = this.flex_columns[0].title.toString();
}, "#parsePodcastShow");
parseAlbum_fn = /* @__PURE__ */ __name(function() {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i;
  this.id = (_b = (_a = this.endpoint) == null ? void 0 : _a.payload) == null ? void 0 : _b.browseId;
  this.title = this.flex_columns[0].title.toString();
  const author_run = (_d = (_c = this.flex_columns.at(1)) == null ? void 0 : _c.title.runs) == null ? void 0 : _d.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (author_run && isTextRun(author_run)) {
    this.author = {
      name: author_run.text,
      channel_id: (_f = (_e = author_run.endpoint) == null ? void 0 : _e.payload) == null ? void 0 : _f.browseId,
      endpoint: author_run.endpoint
    };
  }
  this.year = (_i = (_h = (_g = this.flex_columns.at(1)) == null ? void 0 : _g.title.runs) == null ? void 0 : _h.find((run) => /^[12][0-9]{3}$/.test(run.text))) == null ? void 0 : _i.text;
}, "#parseAlbum");
parsePlaylist_fn = /* @__PURE__ */ __name(function() {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  this.id = (_b = (_a = this.endpoint) == null ? void 0 : _a.payload) == null ? void 0 : _b.browseId;
  this.title = this.flex_columns[0].title.toString();
  const item_count_run = (_d = (_c = this.flex_columns.at(1)) == null ? void 0 : _c.title.runs) == null ? void 0 : _d.find((run) => run.text.match(/\d+ (song|songs)/));
  this.item_count = item_count_run ? item_count_run.text : void 0;
  const author_run = (_f = (_e = this.flex_columns.at(1)) == null ? void 0 : _e.title.runs) == null ? void 0 : _f.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (author_run && isTextRun(author_run)) {
    this.author = {
      name: author_run.text,
      channel_id: (_h = (_g = author_run.endpoint) == null ? void 0 : _g.payload) == null ? void 0 : _h.browseId,
      endpoint: author_run.endpoint
    };
  }
}, "#parsePlaylist");
__name(_MusicResponsiveListItem, "MusicResponsiveListItem");
__publicField(_MusicResponsiveListItem, "type", "MusicResponsiveListItem");
var MusicResponsiveListItem = _MusicResponsiveListItem;

// dist/src/parser/classes/MusicTwoRowItem.js
var _MusicTwoRowItem = class _MusicTwoRowItem extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v;
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "id");
    __publicField(this, "subtitle");
    __publicField(this, "badges");
    __publicField(this, "item_type");
    __publicField(this, "subscribers");
    __publicField(this, "item_count");
    __publicField(this, "year");
    __publicField(this, "views");
    __publicField(this, "artists");
    __publicField(this, "author");
    __publicField(this, "thumbnail");
    __publicField(this, "thumbnail_overlay");
    __publicField(this, "menu");
    this.title = new Text2(data.title);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.id = ((_b = (_a = this.endpoint) == null ? void 0 : _a.payload) == null ? void 0 : _b.browseId) || ((_d = (_c = this.endpoint) == null ? void 0 : _c.payload) == null ? void 0 : _d.videoId);
    this.subtitle = new Text2(data.subtitle);
    this.badges = parser_exports.parse(data.subtitleBadges);
    const page_type = (_h = (_g = (_f = (_e = this.endpoint) == null ? void 0 : _e.payload) == null ? void 0 : _f.browseEndpointContextSupportedConfigs) == null ? void 0 : _g.browseEndpointContextMusicConfig) == null ? void 0 : _h.pageType;
    switch (page_type) {
      case "MUSIC_PAGE_TYPE_ARTIST":
        this.item_type = "artist";
        break;
      case "MUSIC_PAGE_TYPE_PLAYLIST":
        this.item_type = "playlist";
        break;
      case "MUSIC_PAGE_TYPE_ALBUM":
        this.item_type = "album";
        break;
      default:
        if (((_j = (_i = this.endpoint) == null ? void 0 : _i.metadata) == null ? void 0 : _j.api_url) === "/next") {
          this.item_type = "endpoint";
        } else if ((_k = this.subtitle.runs) == null ? void 0 : _k[0]) {
          if (this.subtitle.runs[0].text !== "Song") {
            this.item_type = "video";
          } else {
            this.item_type = "song";
          }
        } else if (this.endpoint) {
          this.item_type = "endpoint";
        } else {
          this.item_type = "unknown";
        }
        break;
    }
    if (this.item_type == "artist") {
      this.subscribers = ((_m = (_l = this.subtitle.runs) == null ? void 0 : _l.find((run) => /^(\d*\.)?\d+[M|K]? subscribers?$/i.test(run.text))) == null ? void 0 : _m.text) || "";
    } else if (this.item_type == "playlist") {
      const item_count_run = (_n = this.subtitle.runs) == null ? void 0 : _n.find((run) => run.text.match(/\d+ songs|song/));
      this.item_count = item_count_run ? item_count_run.text : null;
    } else if (this.item_type == "album") {
      const artists = (_o = this.subtitle.runs) == null ? void 0 : _o.filter((run) => {
        var _a2, _b2;
        return (_b2 = (_a2 = run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId.startsWith("UC");
      });
      if (artists) {
        this.artists = artists.map((artist) => {
          var _a2, _b2;
          return {
            name: artist.text,
            channel_id: (_b2 = (_a2 = artist.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId,
            endpoint: artist.endpoint
          };
        });
      }
      this.year = (_p = this.subtitle.runs) == null ? void 0 : _p.slice(-1)[0].text;
      if (isNaN(Number(this.year)))
        delete this.year;
    } else if (this.item_type == "video") {
      this.views = ((_r = (_q = this == null ? void 0 : this.subtitle.runs) == null ? void 0 : _q.find((run) => run == null ? void 0 : run.text.match(/(.*?) views/))) == null ? void 0 : _r.text) || "N/A";
      const author = (_s = this.subtitle.runs) == null ? void 0 : _s.find((run) => {
        var _a2, _b2, _c2;
        return (_c2 = (_b2 = (_a2 = run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId) == null ? void 0 : _c2.startsWith("UC");
      });
      if (author) {
        this.author = {
          name: author == null ? void 0 : author.text,
          channel_id: (_u = (_t = author == null ? void 0 : author.endpoint) == null ? void 0 : _t.payload) == null ? void 0 : _u.browseId,
          endpoint: author == null ? void 0 : author.endpoint
        };
      }
    } else if (this.item_type == "song") {
      const artists = (_v = this.subtitle.runs) == null ? void 0 : _v.filter((run) => {
        var _a2, _b2;
        return (_b2 = (_a2 = run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId.startsWith("UC");
      });
      if (artists) {
        this.artists = artists.map((artist) => {
          var _a2, _b2;
          return {
            name: artist == null ? void 0 : artist.text,
            channel_id: (_b2 = (_a2 = artist == null ? void 0 : artist.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId,
            endpoint: artist == null ? void 0 : artist.endpoint
          };
        });
      }
    }
    this.thumbnail = Thumbnail.fromResponse(data.thumbnailRenderer.musicThumbnailRenderer.thumbnail);
    this.thumbnail_overlay = parser_exports.parseItem(data.thumbnailOverlay, MusicItemThumbnailOverlay);
    this.menu = parser_exports.parseItem(data.menu, Menu);
  }
};
__name(_MusicTwoRowItem, "MusicTwoRowItem");
__publicField(_MusicTwoRowItem, "type", "MusicTwoRowItem");
var MusicTwoRowItem = _MusicTwoRowItem;

// dist/src/parser/classes/MusicCarouselShelf.js
var _MusicCarouselShelf = class _MusicCarouselShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "num_items_per_column");
    this.header = parser_exports.parseItem(data.header, MusicCarouselShelfBasicHeader);
    this.contents = parser_exports.parseArray(data.contents, [MusicTwoRowItem, MusicResponsiveListItem, MusicMultiRowListItem, MusicNavigationButton]);
    if (Reflect.has(data, "numItemsPerColumn")) {
      this.num_items_per_column = parseInt(data.numItemsPerColumn);
    }
  }
};
__name(_MusicCarouselShelf, "MusicCarouselShelf");
__publicField(_MusicCarouselShelf, "type", "MusicCarouselShelf");
var MusicCarouselShelf = _MusicCarouselShelf;

// dist/src/parser/classes/MusicDescriptionShelf.js
var _MusicDescriptionShelf = class _MusicDescriptionShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "description");
    __publicField(this, "max_collapsed_lines");
    __publicField(this, "max_expanded_lines");
    __publicField(this, "footer");
    this.description = new Text2(data.description);
    if (Reflect.has(data, "maxCollapsedLines")) {
      this.max_collapsed_lines = data.maxCollapsedLines;
    }
    if (Reflect.has(data, "maxExpandedLines")) {
      this.max_expanded_lines = data.maxExpandedLines;
    }
    this.footer = new Text2(data.footer);
  }
};
__name(_MusicDescriptionShelf, "MusicDescriptionShelf");
__publicField(_MusicDescriptionShelf, "type", "MusicDescriptionShelf");
var MusicDescriptionShelf = _MusicDescriptionShelf;

// dist/src/parser/classes/MusicDetailHeader.js
var _MusicDetailHeader = class _MusicDetailHeader extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "subtitle");
    __publicField(this, "second_subtitle");
    __publicField(this, "year");
    __publicField(this, "song_count");
    __publicField(this, "total_duration");
    __publicField(this, "thumbnails");
    __publicField(this, "badges");
    __publicField(this, "author");
    __publicField(this, "menu");
    this.title = new Text2(data.title);
    this.description = new Text2(data.description);
    this.subtitle = new Text2(data.subtitle);
    this.second_subtitle = new Text2(data.secondSubtitle);
    this.year = ((_b = (_a = this.subtitle.runs) == null ? void 0 : _a.find((run) => /^[12][0-9]{3}$/.test(run.text))) == null ? void 0 : _b.text) || "";
    this.song_count = ((_d = (_c = this.second_subtitle.runs) == null ? void 0 : _c[0]) == null ? void 0 : _d.text) || "";
    this.total_duration = ((_f = (_e = this.second_subtitle.runs) == null ? void 0 : _e[2]) == null ? void 0 : _f.text) || "";
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail.croppedSquareThumbnailRenderer.thumbnail);
    this.badges = parser_exports.parseArray(data.subtitleBadges);
    const author = (_g = this.subtitle.runs) == null ? void 0 : _g.find((run) => {
      var _a2, _b2;
      return (_b2 = (_a2 = run == null ? void 0 : run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId.startsWith("UC");
    });
    if (author) {
      this.author = {
        name: author.text,
        channel_id: (_i = (_h = author.endpoint) == null ? void 0 : _h.payload) == null ? void 0 : _i.browseId,
        endpoint: author.endpoint
      };
    }
    this.menu = parser_exports.parseItem(data.menu);
  }
};
__name(_MusicDetailHeader, "MusicDetailHeader");
__publicField(_MusicDetailHeader, "type", "MusicDetailHeader");
var MusicDetailHeader = _MusicDetailHeader;

// dist/src/parser/classes/MusicDownloadStateBadge.js
var _MusicDownloadStateBadge = class _MusicDownloadStateBadge extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "playlist_id");
    __publicField(this, "supported_download_states");
    this.playlist_id = data.playlistId;
    this.supported_download_states = data.supportedDownloadStates;
  }
};
__name(_MusicDownloadStateBadge, "MusicDownloadStateBadge");
__publicField(_MusicDownloadStateBadge, "type", "MusicDownloadStateBadge");
var MusicDownloadStateBadge = _MusicDownloadStateBadge;

// dist/src/parser/classes/MusicEditablePlaylistDetailHeader.js
var _MusicEditablePlaylistDetailHeader = class _MusicEditablePlaylistDetailHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "edit_header");
    __publicField(this, "playlist_id");
    this.header = parser_exports.parseItem(data.header);
    this.edit_header = parser_exports.parseItem(data.editHeader);
    this.playlist_id = data.playlistId;
  }
};
__name(_MusicEditablePlaylistDetailHeader, "MusicEditablePlaylistDetailHeader");
__publicField(_MusicEditablePlaylistDetailHeader, "type", "MusicEditablePlaylistDetailHeader");
var MusicEditablePlaylistDetailHeader = _MusicEditablePlaylistDetailHeader;

// dist/src/parser/classes/MusicElementHeader.js
var _MusicElementHeader = class _MusicElementHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "element");
    this.element = Reflect.has(data, "elementRenderer") ? parser_exports.parseItem(data, Element) : null;
  }
};
__name(_MusicElementHeader, "MusicElementHeader");
__publicField(_MusicElementHeader, "type", "MusicElementHeader");
var MusicElementHeader = _MusicElementHeader;

// dist/src/parser/classes/MusicHeader.js
var _MusicHeader = class _MusicHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "title");
    if (Reflect.has(data, "header")) {
      this.header = parser_exports.parseItem(data.header);
    }
    if (Reflect.has(data, "title")) {
      this.title = new Text2(data.title);
    }
  }
};
__name(_MusicHeader, "MusicHeader");
__publicField(_MusicHeader, "type", "MusicHeader");
var MusicHeader = _MusicHeader;

// dist/src/parser/classes/MusicImmersiveHeader.js
var _MusicImmersiveHeader = class _MusicImmersiveHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "more_button");
    __publicField(this, "play_button");
    __publicField(this, "share_endpoint");
    __publicField(this, "start_radio_button");
    __publicField(this, "subscription_button");
    __publicField(this, "description");
    __publicField(this, "thumbnail");
    this.title = new Text2(data.title);
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.more_button = parser_exports.parseItem(data.moreButton, ToggleButton);
    this.play_button = parser_exports.parseItem(data.playButton, Button);
    if ("shareEndpoint" in data)
      this.share_endpoint = new NavigationEndpoint(data.shareEndpoint);
    this.start_radio_button = parser_exports.parseItem(data.startRadioButton, Button);
    this.subscription_button = parser_exports.parseItem(data.subscriptionButton, SubscribeButton);
    this.description = new Text2(data.description);
    this.thumbnail = parser_exports.parseItem(data.thumbnail, MusicThumbnail);
  }
};
__name(_MusicImmersiveHeader, "MusicImmersiveHeader");
__publicField(_MusicImmersiveHeader, "type", "MusicImmersiveHeader");
var MusicImmersiveHeader = _MusicImmersiveHeader;

// dist/src/parser/classes/MusicLargeCardItemCarousel.js
var _ActionButton = class _ActionButton {
  constructor(data) {
    __publicField(this, "icon_name");
    __publicField(this, "endpoint");
    __publicField(this, "a11y_text");
    __publicField(this, "style");
    this.icon_name = data.iconName;
    this.endpoint = new NavigationEndpoint(data.onTap);
    this.a11y_text = data.a11yText;
    this.style = data.style;
  }
};
__name(_ActionButton, "ActionButton");
__publicField(_ActionButton, "type", "ActionButton");
var ActionButton = _ActionButton;
var _Panel2 = class _Panel2 {
  constructor(data) {
    __publicField(this, "image");
    __publicField(this, "content_mode");
    __publicField(this, "crop_options");
    __publicField(this, "image_aspect_ratio");
    __publicField(this, "caption");
    __publicField(this, "action_buttons");
    this.image = Thumbnail.fromResponse(data.image.image);
    this.content_mode = data.image.contentMode;
    this.crop_options = data.image.cropOptions;
    this.image_aspect_ratio = data.imageAspectRatio;
    this.caption = data.caption;
    this.action_buttons = data.actionButtons.map((el) => new ActionButton(el));
  }
};
__name(_Panel2, "Panel");
__publicField(_Panel2, "type", "Panel");
var Panel2 = _Panel2;
var _MusicLargeCardItemCarousel = class _MusicLargeCardItemCarousel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "panels");
    __publicField(this, "header");
    this.header = data.shelf.header;
    this.panels = data.shelf.panels.map((el) => new Panel2(el));
  }
};
__name(_MusicLargeCardItemCarousel, "MusicLargeCardItemCarousel");
__publicField(_MusicLargeCardItemCarousel, "type", "MusicLargeCardItemCarousel");
var MusicLargeCardItemCarousel = _MusicLargeCardItemCarousel;

// dist/src/parser/classes/MusicPlaylistEditHeader.js
var _MusicPlaylistEditHeader = class _MusicPlaylistEditHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "edit_title");
    __publicField(this, "edit_description");
    __publicField(this, "privacy");
    __publicField(this, "playlist_id");
    __publicField(this, "endpoint");
    __publicField(this, "privacy_dropdown");
    this.title = new Text2(data.title);
    this.edit_title = new Text2(data.editTitle);
    this.edit_description = new Text2(data.editDescription);
    this.privacy = data.privacy;
    this.playlist_id = data.playlistId;
    this.endpoint = new NavigationEndpoint(data.collaborationSettingsCommand);
    this.privacy_dropdown = parser_exports.parseItem(data.privacyDropdown, Dropdown);
  }
};
__name(_MusicPlaylistEditHeader, "MusicPlaylistEditHeader");
__publicField(_MusicPlaylistEditHeader, "type", "MusicPlaylistEditHeader");
var MusicPlaylistEditHeader = _MusicPlaylistEditHeader;

// dist/src/parser/classes/MusicPlaylistShelf.js
var _MusicPlaylistShelf = class _MusicPlaylistShelf extends YTNode {
  constructor(data) {
    var _a, _b, _c;
    super();
    __publicField(this, "playlist_id");
    __publicField(this, "contents");
    __publicField(this, "collapsed_item_count");
    __publicField(this, "continuation");
    this.playlist_id = data.playlistId;
    this.contents = parser_exports.parseArray(data.contents, [MusicResponsiveListItem, ContinuationItem]);
    this.collapsed_item_count = data.collapsedItemCount;
    this.continuation = ((_c = (_b = (_a = data.continuations) == null ? void 0 : _a[0]) == null ? void 0 : _b.nextContinuationData) == null ? void 0 : _c.continuation) || null;
  }
};
__name(_MusicPlaylistShelf, "MusicPlaylistShelf");
__publicField(_MusicPlaylistShelf, "type", "MusicPlaylistShelf");
var MusicPlaylistShelf = _MusicPlaylistShelf;

// dist/src/parser/classes/PlaylistPanelVideo.js
var _PlaylistPanelVideo = class _PlaylistPanelVideo extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e;
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "endpoint");
    __publicField(this, "selected");
    __publicField(this, "video_id");
    __publicField(this, "duration");
    __publicField(this, "author");
    __publicField(this, "album");
    __publicField(this, "artists");
    __publicField(this, "badges");
    __publicField(this, "menu");
    __publicField(this, "set_video_id");
    this.title = new Text2(data.title);
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.selected = data.selected;
    this.video_id = data.videoId;
    this.duration = {
      text: new Text2(data.lengthText).toString(),
      seconds: timeToSeconds(new Text2(data.lengthText).toString())
    };
    const album = (_a = new Text2(data.longBylineText).runs) == null ? void 0 : _a.find((run) => {
      var _a2, _b2, _c2;
      return (_c2 = (_b2 = (_a2 = run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId) == null ? void 0 : _c2.startsWith("MPR");
    });
    const artists = (_b = new Text2(data.longBylineText).runs) == null ? void 0 : _b.filter((run) => {
      var _a2, _b2, _c2;
      return (_c2 = (_b2 = (_a2 = run.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId) == null ? void 0 : _c2.startsWith("UC");
    });
    this.author = new Text2(data.shortBylineText).toString();
    if (album) {
      this.album = {
        id: (_d = (_c = album.endpoint) == null ? void 0 : _c.payload) == null ? void 0 : _d.browseId,
        name: album.text,
        year: (_e = new Text2(data.longBylineText).runs) == null ? void 0 : _e.slice(-1)[0].text,
        endpoint: album.endpoint
      };
    }
    if (artists) {
      this.artists = artists.map((artist) => {
        var _a2, _b2;
        return {
          name: artist.text,
          channel_id: (_b2 = (_a2 = artist.endpoint) == null ? void 0 : _a2.payload) == null ? void 0 : _b2.browseId,
          endpoint: artist.endpoint
        };
      });
    }
    this.badges = parser_exports.parseArray(data.badges);
    this.menu = parser_exports.parseItem(data.menu);
    this.set_video_id = data.playlistSetVideoId;
  }
};
__name(_PlaylistPanelVideo, "PlaylistPanelVideo");
__publicField(_PlaylistPanelVideo, "type", "PlaylistPanelVideo");
var PlaylistPanelVideo = _PlaylistPanelVideo;

// dist/src/parser/classes/PlaylistPanelVideoWrapper.js
var _PlaylistPanelVideoWrapper = class _PlaylistPanelVideoWrapper extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "primary");
    __publicField(this, "counterpart");
    this.primary = parser_exports.parseItem(data.primaryRenderer, PlaylistPanelVideo);
    if (Reflect.has(data, "counterpart")) {
      this.counterpart = observe(data.counterpart.map((item) => parser_exports.parseItem(item.counterpartRenderer, PlaylistPanelVideo)) || []);
    }
  }
};
__name(_PlaylistPanelVideoWrapper, "PlaylistPanelVideoWrapper");
__publicField(_PlaylistPanelVideoWrapper, "type", "PlaylistPanelVideoWrapper");
var PlaylistPanelVideoWrapper = _PlaylistPanelVideoWrapper;

// dist/src/parser/classes/PlaylistPanel.js
var _PlaylistPanel = class _PlaylistPanel extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d, _e, _f;
    super();
    __publicField(this, "title");
    __publicField(this, "title_text");
    __publicField(this, "contents");
    __publicField(this, "playlist_id");
    __publicField(this, "is_infinite");
    __publicField(this, "continuation");
    __publicField(this, "is_editable");
    __publicField(this, "preview_description");
    __publicField(this, "num_items_to_show");
    this.title = data.title;
    this.title_text = new Text2(data.titleText);
    this.contents = parser_exports.parseArray(data.contents, [PlaylistPanelVideoWrapper, PlaylistPanelVideo, AutomixPreviewVideo]);
    this.playlist_id = data.playlistId;
    this.is_infinite = data.isInfinite;
    this.continuation = ((_c = (_b = (_a = data.continuations) == null ? void 0 : _a[0]) == null ? void 0 : _b.nextRadioContinuationData) == null ? void 0 : _c.continuation) || ((_f = (_e = (_d = data.continuations) == null ? void 0 : _d[0]) == null ? void 0 : _e.nextContinuationData) == null ? void 0 : _f.continuation);
    this.is_editable = data.isEditable;
    this.preview_description = data.previewDescription;
    this.num_items_to_show = data.numItemsToShow;
  }
};
__name(_PlaylistPanel, "PlaylistPanel");
__publicField(_PlaylistPanel, "type", "PlaylistPanel");
var PlaylistPanel = _PlaylistPanel;

// dist/src/parser/classes/MusicQueue.js
var _MusicQueue = class _MusicQueue extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data.content, PlaylistPanel);
  }
};
__name(_MusicQueue, "MusicQueue");
__publicField(_MusicQueue, "type", "MusicQueue");
var MusicQueue = _MusicQueue;

// dist/src/parser/classes/MusicResponsiveHeader.js
var _MusicResponsiveHeader = class _MusicResponsiveHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "buttons");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "strapline_text_one");
    __publicField(this, "strapline_thumbnail");
    __publicField(this, "second_subtitle");
    __publicField(this, "subtitle_badge");
    __publicField(this, "description");
    this.thumbnail = parser_exports.parseItem(data.thumbnail, MusicThumbnail);
    this.buttons = parser_exports.parseArray(data.buttons, [DownloadButton, ToggleButton, MusicPlayButton, Button, Menu]);
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
    this.strapline_text_one = new Text2(data.straplineTextOne);
    this.strapline_thumbnail = parser_exports.parseItem(data.straplineThumbnail, MusicThumbnail);
    this.second_subtitle = new Text2(data.secondSubtitle);
    if (Reflect.has(data, "subtitleBadge")) {
      this.subtitle_badge = parser_exports.parseArray(data.subtitleBadge, MusicInlineBadge);
    }
    if (Reflect.has(data, "description")) {
      this.description = parser_exports.parseItem(data.description, MusicDescriptionShelf);
    }
  }
};
__name(_MusicResponsiveHeader, "MusicResponsiveHeader");
__publicField(_MusicResponsiveHeader, "type", "MusicResponsiveHeader");
var MusicResponsiveHeader = _MusicResponsiveHeader;

// dist/src/parser/classes/MusicShelf.js
var _MusicShelf = class _MusicShelf extends YTNode {
  constructor(data) {
    var _a, _b, _c, _d;
    super();
    __publicField(this, "title");
    __publicField(this, "contents");
    __publicField(this, "endpoint");
    __publicField(this, "continuation");
    __publicField(this, "bottom_text");
    __publicField(this, "bottom_button");
    __publicField(this, "subheaders");
    this.title = new Text2(data.title);
    this.contents = parser_exports.parseArray(data.contents, MusicResponsiveListItem);
    if (Reflect.has(data, "bottomEndpoint")) {
      this.endpoint = new NavigationEndpoint(data.bottomEndpoint);
    }
    if (Reflect.has(data, "continuations")) {
      this.continuation = ((_b = (_a = data.continuations) == null ? void 0 : _a[0].nextContinuationData) == null ? void 0 : _b.continuation) || ((_d = (_c = data.continuations) == null ? void 0 : _c[0].reloadContinuationData) == null ? void 0 : _d.continuation);
    }
    if (Reflect.has(data, "bottomText")) {
      this.bottom_text = new Text2(data.bottomText);
    }
    if (Reflect.has(data, "bottomButton")) {
      this.bottom_button = parser_exports.parseItem(data.bottomButton, Button);
    }
    if (Reflect.has(data, "subheaders")) {
      this.subheaders = parser_exports.parseArray(data.subheaders);
    }
  }
};
__name(_MusicShelf, "MusicShelf");
__publicField(_MusicShelf, "type", "MusicShelf");
var MusicShelf = _MusicShelf;

// dist/src/parser/classes/MusicSideAlignedItem.js
var _MusicSideAlignedItem = class _MusicSideAlignedItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "start_items");
    __publicField(this, "end_items");
    if (Reflect.has(data, "startItems")) {
      this.start_items = parser_exports.parseArray(data.startItems);
    }
    if (Reflect.has(data, "endItems")) {
      this.end_items = parser_exports.parseArray(data.endItems);
    }
  }
};
__name(_MusicSideAlignedItem, "MusicSideAlignedItem");
__publicField(_MusicSideAlignedItem, "type", "MusicSideAlignedItem");
var MusicSideAlignedItem = _MusicSideAlignedItem;

// dist/src/parser/classes/MusicSortFilterButton.js
var _MusicSortFilterButton = class _MusicSortFilterButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "icon_type");
    __publicField(this, "menu");
    this.title = new Text2(data.title).toString();
    if (Reflect.has(data, "icon")) {
      this.icon_type = data.icon.iconType;
    }
    this.menu = parser_exports.parseItem(data.menu, MusicMultiSelectMenu);
  }
};
__name(_MusicSortFilterButton, "MusicSortFilterButton");
__publicField(_MusicSortFilterButton, "type", "MusicSortFilterButton");
var MusicSortFilterButton = _MusicSortFilterButton;

// dist/src/parser/classes/MusicTastebuilderShelfThumbnail.js
var _MusicTastebuilderShelfThumbnail = class _MusicTastebuilderShelfThumbnail extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_MusicTastebuilderShelfThumbnail, "MusicTastebuilderShelfThumbnail");
__publicField(_MusicTastebuilderShelfThumbnail, "type", "MusicTastebuilderShelfThumbnail");
var MusicTastebuilderShelfThumbnail = _MusicTastebuilderShelfThumbnail;

// dist/src/parser/classes/MusicTastebuilderShelf.js
var _MusicTasteBuilderShelf = class _MusicTasteBuilderShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "primary_text");
    __publicField(this, "secondary_text");
    __publicField(this, "action_button");
    __publicField(this, "is_visible");
    this.thumbnail = parser_exports.parseItem(data.thumbnail, MusicTastebuilderShelfThumbnail);
    this.primary_text = new Text2(data.primaryText);
    this.secondary_text = new Text2(data.secondaryText);
    this.action_button = parser_exports.parseItem(data.actionButton, Button);
    this.is_visible = data.isVisible;
  }
};
__name(_MusicTasteBuilderShelf, "MusicTasteBuilderShelf");
__publicField(_MusicTasteBuilderShelf, "type", "MusicTasteBuilderShelf");
var MusicTasteBuilderShelf = _MusicTasteBuilderShelf;

// dist/src/parser/classes/MusicVisualHeader.js
var _MusicVisualHeader = class _MusicVisualHeader extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "menu");
    __publicField(this, "foreground_thumbnail");
    this.title = new Text2(data.title);
    this.thumbnail = data.thumbnail ? Thumbnail.fromResponse((_a = data.thumbnail.musicThumbnailRenderer) == null ? void 0 : _a.thumbnail) : [];
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.foreground_thumbnail = data.foregroundThumbnail ? Thumbnail.fromResponse((_b = data.foregroundThumbnail.musicThumbnailRenderer) == null ? void 0 : _b.thumbnail) : [];
  }
};
__name(_MusicVisualHeader, "MusicVisualHeader");
__publicField(_MusicVisualHeader, "type", "MusicVisualHeader");
var MusicVisualHeader = _MusicVisualHeader;

// dist/src/parser/classes/mweb/MobileTopbar.js
var _MobileTopbar = class _MobileTopbar extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "placeholder_text");
    __publicField(this, "buttons");
    __publicField(this, "logo_type");
    this.placeholder_text = new Text2(data.placeholderText);
    this.buttons = parser_exports.parseArray(data.buttons);
    if (Reflect.has(data, "logo") && Reflect.has(data.logo, "iconType"))
      this.logo_type = data.logo.iconType;
  }
};
__name(_MobileTopbar, "MobileTopbar");
__publicField(_MobileTopbar, "type", "MobileTopbar");
var MobileTopbar = _MobileTopbar;

// dist/src/parser/classes/mweb/MultiPageMenuSection.js
var _MultiPageMenuSection = class _MultiPageMenuSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items);
  }
};
__name(_MultiPageMenuSection, "MultiPageMenuSection");
__publicField(_MultiPageMenuSection, "type", "MultiPageMenuSection");
var MultiPageMenuSection = _MultiPageMenuSection;

// dist/src/parser/classes/mweb/PivotBar.js
var _PivotBar = class _PivotBar extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items);
  }
};
__name(_PivotBar, "PivotBar");
__publicField(_PivotBar, "type", "PivotBar");
var PivotBar = _PivotBar;

// dist/src/parser/classes/mweb/PivotBarItem.js
var _PivotBarItem = class _PivotBarItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "pivot_identifier");
    __publicField(this, "endpoint");
    __publicField(this, "title");
    __publicField(this, "accessibility_label");
    __publicField(this, "icon_type");
    __publicField(this, "accessibility");
    this.pivot_identifier = data.pivotIdentifier;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.title = new Text(data.title);
    if ("accessibility" in data && "accessibilityData" in data.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibility.accessibilityData)
      };
    }
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType"))
      this.icon_type = data.icon.iconType;
  }
  get label() {
    var _a, _b;
    return (_b = (_a = this.accessibility) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
};
__name(_PivotBarItem, "PivotBarItem");
__publicField(_PivotBarItem, "type", "PivotBarItem");
var PivotBarItem = _PivotBarItem;

// dist/src/parser/classes/mweb/TopbarMenuButton.js
var _TopbarMenuButton = class _TopbarMenuButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "menu_renderer");
    __publicField(this, "target_id");
    if (Reflect.has(data, "icon") && Reflect.has(data.icon, "iconType"))
      this.icon_type = data.icon.iconType;
    this.menu_renderer = parser_exports.parseItem(data.menuRenderer);
    this.target_id = data.targetId;
  }
};
__name(_TopbarMenuButton, "TopbarMenuButton");
__publicField(_TopbarMenuButton, "type", "TopbarMenuButton");
var TopbarMenuButton = _TopbarMenuButton;

// dist/src/parser/classes/NotificationAction.js
var _NotificationAction = class _NotificationAction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "response_text");
    this.response_text = new Text2(data.responseText);
  }
};
__name(_NotificationAction, "NotificationAction");
__publicField(_NotificationAction, "type", "NotificationAction");
var NotificationAction = _NotificationAction;

// dist/src/parser/classes/OpenOnePickAddVideoModalCommand.js
var _OpenOnePickAddVideoModalCommand = class _OpenOnePickAddVideoModalCommand extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "list_id");
    __publicField(this, "modal_title");
    __publicField(this, "select_button_label");
    this.list_id = data.listId;
    this.modal_title = data.modalTitle;
    this.select_button_label = data.selectButtonLabel;
  }
};
__name(_OpenOnePickAddVideoModalCommand, "OpenOnePickAddVideoModalCommand");
__publicField(_OpenOnePickAddVideoModalCommand, "type", "OpenOnePickAddVideoModalCommand");
var OpenOnePickAddVideoModalCommand = _OpenOnePickAddVideoModalCommand;

// dist/src/parser/classes/PageHeaderView.js
var _PageHeaderView = class _PageHeaderView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "image");
    __publicField(this, "animated_image");
    __publicField(this, "hero_image");
    __publicField(this, "metadata");
    __publicField(this, "actions");
    __publicField(this, "description");
    __publicField(this, "attributation");
    __publicField(this, "banner");
    this.title = parser_exports.parseItem(data.title, DynamicTextView);
    this.image = parser_exports.parseItem(data.image, [ContentPreviewImageView, DecoratedAvatarView]);
    this.animated_image = parser_exports.parseItem(data.animatedImage, ContentPreviewImageView);
    this.hero_image = parser_exports.parseItem(data.heroImage, ContentPreviewImageView);
    this.metadata = parser_exports.parseItem(data.metadata, ContentMetadataView);
    this.actions = parser_exports.parseItem(data.actions, FlexibleActionsView);
    this.description = parser_exports.parseItem(data.description, DescriptionPreviewView);
    this.attributation = parser_exports.parseItem(data.attributation, AttributionView);
    this.banner = parser_exports.parseItem(data.banner, ImageBannerView);
  }
};
__name(_PageHeaderView, "PageHeaderView");
__publicField(_PageHeaderView, "type", "PageHeaderView");
var PageHeaderView = _PageHeaderView;

// dist/src/parser/classes/PageHeader.js
var _PageHeader = class _PageHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "page_title");
    __publicField(this, "content");
    this.page_title = data.pageTitle;
    this.content = parser_exports.parseItem(data.content, PageHeaderView);
  }
};
__name(_PageHeader, "PageHeader");
__publicField(_PageHeader, "type", "PageHeader");
var PageHeader = _PageHeader;

// dist/src/parser/classes/PageIntroduction.js
var _PageIntroduction = class _PageIntroduction extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header_text");
    __publicField(this, "body_text");
    __publicField(this, "page_title");
    __publicField(this, "header_icon_type");
    this.header_text = new Text2(data.headerText).toString();
    this.body_text = new Text2(data.bodyText).toString();
    this.page_title = new Text2(data.pageTitle).toString();
    this.header_icon_type = data.headerIcon.iconType;
  }
};
__name(_PageIntroduction, "PageIntroduction");
__publicField(_PageIntroduction, "type", "PageIntroduction");
var PageIntroduction = _PageIntroduction;

// dist/src/parser/classes/PivotButton.js
var _PivotButton = class _PivotButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "endpoint");
    __publicField(this, "content_description");
    __publicField(this, "target_id");
    __publicField(this, "sound_attribution_title");
    __publicField(this, "waveform_animation_style");
    __publicField(this, "background_animation_style");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.endpoint = new NavigationEndpoint(data.onClickCommand);
    this.content_description = new Text2(data.contentDescription);
    this.target_id = data.targetId;
    this.sound_attribution_title = new Text2(data.soundAttributionTitle);
    this.waveform_animation_style = data.waveformAnimationStyle;
    this.background_animation_style = data.backgroundAnimationStyle;
  }
};
__name(_PivotButton, "PivotButton");
__publicField(_PivotButton, "type", "PivotButton");
var PivotButton = _PivotButton;

// dist/src/parser/classes/PlayerAnnotationsExpanded.js
var _PlayerAnnotationsExpanded = class _PlayerAnnotationsExpanded extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "featured_channel");
    __publicField(this, "allow_swipe_dismiss");
    __publicField(this, "annotation_id");
    if (Reflect.has(data, "featuredChannel")) {
      this.featured_channel = {
        start_time_ms: data.featuredChannel.startTimeMs,
        end_time_ms: data.featuredChannel.endTimeMs,
        watermark: Thumbnail.fromResponse(data.featuredChannel.watermark),
        channel_name: data.featuredChannel.channelName,
        endpoint: new NavigationEndpoint(data.featuredChannel.navigationEndpoint),
        subscribe_button: parser_exports.parseItem(data.featuredChannel.subscribeButton)
      };
    }
    this.allow_swipe_dismiss = data.allowSwipeDismiss;
    this.annotation_id = data.annotationId;
  }
};
__name(_PlayerAnnotationsExpanded, "PlayerAnnotationsExpanded");
__publicField(_PlayerAnnotationsExpanded, "type", "PlayerAnnotationsExpanded");
var PlayerAnnotationsExpanded = _PlayerAnnotationsExpanded;

// dist/src/parser/classes/PlayerCaptionsTracklist.js
var _PlayerCaptionsTracklist = class _PlayerCaptionsTracklist extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "caption_tracks");
    __publicField(this, "audio_tracks");
    __publicField(this, "default_audio_track_index");
    __publicField(this, "translation_languages");
    if (Reflect.has(data, "captionTracks")) {
      this.caption_tracks = data.captionTracks.map((ct) => ({
        base_url: ct.baseUrl,
        name: new Text2(ct.name),
        vss_id: ct.vssId,
        language_code: ct.languageCode,
        kind: ct.kind,
        is_translatable: ct.isTranslatable
      }));
    }
    if (Reflect.has(data, "audioTracks")) {
      this.audio_tracks = data.audioTracks.map((at) => ({
        audio_track_id: at.audioTrackId,
        captions_initial_state: at.captionsInitialState,
        default_caption_track_index: at.defaultCaptionTrackIndex,
        has_default_track: at.hasDefaultTrack,
        visibility: at.visibility,
        caption_track_indices: at.captionTrackIndices
      }));
    }
    if (Reflect.has(data, "defaultAudioTrackIndex")) {
      this.default_audio_track_index = data.defaultAudioTrackIndex;
    }
    if (Reflect.has(data, "translationLanguages")) {
      this.translation_languages = data.translationLanguages.map((tl) => ({
        language_code: tl.languageCode,
        language_name: new Text2(tl.languageName)
      }));
    }
  }
};
__name(_PlayerCaptionsTracklist, "PlayerCaptionsTracklist");
__publicField(_PlayerCaptionsTracklist, "type", "PlayerCaptionsTracklist");
var PlayerCaptionsTracklist = _PlayerCaptionsTracklist;

// dist/src/parser/classes/PlayerOverflow.js
var _PlayerOverflow = class _PlayerOverflow extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "enable_listen_first");
    this.endpoint = new NavigationEndpoint(data.endpoint);
    this.enable_listen_first = data.enableListenFirst;
  }
};
__name(_PlayerOverflow, "PlayerOverflow");
__publicField(_PlayerOverflow, "type", "PlayerOverflow");
var PlayerOverflow = _PlayerOverflow;

// dist/src/parser/classes/PlayerControlsOverlay.js
var _PlayerControlsOverlay = class _PlayerControlsOverlay extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "overflow");
    this.overflow = parser_exports.parseItem(data.overflow, PlayerOverflow);
  }
};
__name(_PlayerControlsOverlay, "PlayerControlsOverlay");
__publicField(_PlayerControlsOverlay, "type", "PlayerControlsOverlay");
var PlayerControlsOverlay = _PlayerControlsOverlay;

// dist/src/parser/classes/PlayerErrorMessage.js
var _PlayerErrorMessage = class _PlayerErrorMessage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "subreason");
    __publicField(this, "reason");
    __publicField(this, "proceed_button");
    __publicField(this, "thumbnails");
    __publicField(this, "icon_type");
    this.subreason = new Text2(data.subreason);
    this.reason = new Text2(data.reason);
    this.proceed_button = parser_exports.parseItem(data.proceedButton, Button);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    if (Reflect.has(data, "icon")) {
      this.icon_type = data.icon.iconType;
    }
  }
};
__name(_PlayerErrorMessage, "PlayerErrorMessage");
__publicField(_PlayerErrorMessage, "type", "PlayerErrorMessage");
var PlayerErrorMessage = _PlayerErrorMessage;

// dist/src/parser/classes/PlayerLegacyDesktopYpcOffer.js
var _PlayerLegacyDesktopYpcOffer = class _PlayerLegacyDesktopYpcOffer extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "offer_description");
    __publicField(this, "offer_id");
    this.title = data.itemTitle;
    this.thumbnail = data.itemThumbnail;
    this.offer_description = data.offerDescription;
    this.offer_id = data.offerId;
  }
};
__name(_PlayerLegacyDesktopYpcOffer, "PlayerLegacyDesktopYpcOffer");
__publicField(_PlayerLegacyDesktopYpcOffer, "type", "PlayerLegacyDesktopYpcOffer");
var PlayerLegacyDesktopYpcOffer = _PlayerLegacyDesktopYpcOffer;

// dist/src/parser/classes/YpcTrailer.js
var _YpcTrailer = class _YpcTrailer extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "video_message");
    __publicField(this, "player_response");
    this.video_message = data.fullVideoMessage;
    this.player_response = data.unserializedPlayerResponse;
  }
};
__name(_YpcTrailer, "YpcTrailer");
__publicField(_YpcTrailer, "type", "YpcTrailer");
var YpcTrailer = _YpcTrailer;

// dist/src/parser/classes/PlayerLegacyDesktopYpcTrailer.js
var _PlayerLegacyDesktopYpcTrailer = class _PlayerLegacyDesktopYpcTrailer extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "video_id");
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "offer_headline");
    __publicField(this, "offer_description");
    __publicField(this, "offer_id");
    __publicField(this, "offer_button_text");
    __publicField(this, "video_message");
    __publicField(this, "trailer");
    this.video_id = data.trailerVideoId;
    this.title = data.itemTitle;
    this.thumbnail = data.itemThumbnail;
    this.offer_headline = data.offerHeadline;
    this.offer_description = data.offerDescription;
    this.offer_id = data.offerId;
    this.offer_button_text = data.offerButtonText;
    this.video_message = data.fullVideoMessage;
    this.trailer = parser_exports.parseItem(data.ypcTrailer, YpcTrailer);
  }
};
__name(_PlayerLegacyDesktopYpcTrailer, "PlayerLegacyDesktopYpcTrailer");
__publicField(_PlayerLegacyDesktopYpcTrailer, "type", "PlayerLegacyDesktopYpcTrailer");
var PlayerLegacyDesktopYpcTrailer = _PlayerLegacyDesktopYpcTrailer;

// dist/src/parser/classes/PlayerLiveStoryboardSpec.js
var _PlayerLiveStoryboardSpec = class _PlayerLiveStoryboardSpec extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "board");
    const [template_url, thumbnail_width, thumbnail_height, columns, rows] = data.spec.split("#");
    this.board = {
      type: "live",
      template_url,
      thumbnail_width: parseInt(thumbnail_width, 10),
      thumbnail_height: parseInt(thumbnail_height, 10),
      columns: parseInt(columns, 10),
      rows: parseInt(rows, 10)
    };
  }
};
__name(_PlayerLiveStoryboardSpec, "PlayerLiveStoryboardSpec");
__publicField(_PlayerLiveStoryboardSpec, "type", "PlayerLiveStoryboardSpec");
var PlayerLiveStoryboardSpec = _PlayerLiveStoryboardSpec;

// dist/src/parser/classes/PlayerMicroformat.js
var _PlayerMicroformat = class _PlayerMicroformat extends YTNode {
  constructor(data) {
    var _a, _b;
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "thumbnails");
    __publicField(this, "embed");
    __publicField(this, "length_seconds");
    __publicField(this, "channel");
    __publicField(this, "is_family_safe");
    __publicField(this, "is_unlisted");
    __publicField(this, "has_ypc_metadata");
    __publicField(this, "view_count");
    __publicField(this, "category");
    __publicField(this, "publish_date");
    __publicField(this, "upload_date");
    __publicField(this, "available_countries");
    __publicField(this, "start_timestamp");
    __publicField(this, "end_timestamp");
    this.title = new Text2(data.title);
    this.description = new Text2(data.description);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    if (Reflect.has(data, "embed")) {
      this.embed = {
        iframe_url: data.embed.iframeUrl,
        flash_url: data.embed.flashUrl,
        flash_secure_url: data.embed.flashSecureUrl,
        width: data.embed.width,
        height: data.embed.height
      };
    }
    this.length_seconds = parseInt(data.lengthSeconds);
    this.channel = {
      id: data.externalChannelId,
      name: data.ownerChannelName,
      url: data.ownerProfileUrl
    };
    this.is_family_safe = !!data.isFamilySafe;
    this.is_unlisted = !!data.isUnlisted;
    this.has_ypc_metadata = !!data.hasYpcMetadata;
    this.view_count = parseInt(data.viewCount);
    this.category = data.category;
    this.publish_date = data.publishDate;
    this.upload_date = data.uploadDate;
    this.available_countries = data.availableCountries;
    this.start_timestamp = ((_a = data.liveBroadcastDetails) == null ? void 0 : _a.startTimestamp) ? new Date(data.liveBroadcastDetails.startTimestamp) : null;
    this.end_timestamp = ((_b = data.liveBroadcastDetails) == null ? void 0 : _b.endTimestamp) ? new Date(data.liveBroadcastDetails.endTimestamp) : null;
  }
};
__name(_PlayerMicroformat, "PlayerMicroformat");
__publicField(_PlayerMicroformat, "type", "PlayerMicroformat");
var PlayerMicroformat = _PlayerMicroformat;

// dist/src/parser/classes/PlayerOverlayAutoplay.js
var _PlayerOverlayAutoplay = class _PlayerOverlayAutoplay extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "video_id");
    __publicField(this, "video_title");
    __publicField(this, "short_view_count");
    // @TODO: Find out what these are.
    __publicField(this, "prefer_immediate_redirect");
    __publicField(this, "count_down_secs_for_fullscreen");
    __publicField(this, "published");
    __publicField(this, "background");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "cancel_button");
    __publicField(this, "next_button");
    __publicField(this, "close_button");
    this.title = new Text2(data.title);
    this.video_id = data.videoId;
    this.video_title = new Text2(data.videoTitle);
    this.short_view_count = new Text2(data.shortViewCountText);
    this.prefer_immediate_redirect = data.preferImmediateRedirect;
    this.count_down_secs_for_fullscreen = data.countDownSecsForFullscreen;
    this.published = new Text2(data.publishedTimeText);
    this.background = Thumbnail.fromResponse(data.background);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    this.author = new Author(data.byline);
    this.cancel_button = parser_exports.parseItem(data.cancelButton, Button);
    this.next_button = parser_exports.parseItem(data.nextButton, Button);
    this.close_button = parser_exports.parseItem(data.closeButton, Button);
  }
};
__name(_PlayerOverlayAutoplay, "PlayerOverlayAutoplay");
__publicField(_PlayerOverlayAutoplay, "type", "PlayerOverlayAutoplay");
var PlayerOverlayAutoplay = _PlayerOverlayAutoplay;

// dist/src/parser/classes/PlayerOverlayVideoDetails.js
var _PlayerOverlayVideoDetails = class _PlayerOverlayVideoDetails extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
  }
};
__name(_PlayerOverlayVideoDetails, "PlayerOverlayVideoDetails");
__publicField(_PlayerOverlayVideoDetails, "type", "PlayerOverlayVideoDetails");
var PlayerOverlayVideoDetails = _PlayerOverlayVideoDetails;

// dist/src/parser/classes/WatchNextEndScreen.js
var _WatchNextEndScreen = class _WatchNextEndScreen extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "results");
    __publicField(this, "title");
    this.results = parser_exports.parseArray(data.results, [EndScreenVideo, EndScreenPlaylist]);
    this.title = new Text2(data.title).toString();
  }
};
__name(_WatchNextEndScreen, "WatchNextEndScreen");
__publicField(_WatchNextEndScreen, "type", "WatchNextEndScreen");
var WatchNextEndScreen = _WatchNextEndScreen;

// dist/src/parser/classes/PlayerOverlay.js
var _PlayerOverlay = class _PlayerOverlay extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "end_screen");
    __publicField(this, "autoplay");
    __publicField(this, "share_button");
    __publicField(this, "add_to_menu");
    __publicField(this, "fullscreen_engagement");
    __publicField(this, "actions");
    __publicField(this, "browser_media_session");
    __publicField(this, "decorated_player_bar");
    __publicField(this, "video_details");
    this.end_screen = parser_exports.parseItem(data.endScreen, WatchNextEndScreen);
    this.autoplay = parser_exports.parseItem(data.autoplay, PlayerOverlayAutoplay);
    this.share_button = parser_exports.parseItem(data.shareButton, Button);
    this.add_to_menu = parser_exports.parseItem(data.addToMenu, Menu);
    this.fullscreen_engagement = parser_exports.parseItem(data.fullscreenEngagement);
    this.actions = parser_exports.parseArray(data.actions);
    this.browser_media_session = parser_exports.parseItem(data.browserMediaSession);
    this.decorated_player_bar = parser_exports.parseItem(data.decoratedPlayerBarRenderer, DecoratedPlayerBar);
    this.video_details = parser_exports.parseItem(data.videoDetails, PlayerOverlayVideoDetails);
  }
};
__name(_PlayerOverlay, "PlayerOverlay");
__publicField(_PlayerOverlay, "type", "PlayerOverlay");
var PlayerOverlay = _PlayerOverlay;

// dist/src/parser/classes/PlaylistHeader.js
var _PlaylistHeader = class _PlaylistHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "stats");
    __publicField(this, "brief_stats");
    __publicField(this, "author");
    __publicField(this, "description");
    __publicField(this, "num_videos");
    __publicField(this, "view_count");
    __publicField(this, "can_share");
    __publicField(this, "can_delete");
    __publicField(this, "is_editable");
    __publicField(this, "privacy");
    __publicField(this, "save_button");
    __publicField(this, "shuffle_play_button");
    __publicField(this, "menu");
    __publicField(this, "banner");
    this.id = data.playlistId;
    this.title = new Text2(data.title);
    this.subtitle = data.subtitle ? new Text2(data.subtitle) : null;
    this.stats = data.stats.map((stat) => new Text2(stat));
    this.brief_stats = data.briefStats.map((stat) => new Text2(stat));
    this.author = data.ownerText || data.ownerEndpoint ? new Author({ ...data.ownerText, navigationEndpoint: data.ownerEndpoint }, data.ownerBadges, null) : null;
    this.description = new Text2(data.descriptionText);
    this.num_videos = new Text2(data.numVideosText);
    this.view_count = new Text2(data.viewCountText);
    this.can_share = data.shareData.canShare;
    this.can_delete = data.editableDetails.canDelete;
    this.is_editable = data.isEditable;
    this.privacy = data.privacy;
    this.save_button = parser_exports.parseItem(data.saveButton);
    this.shuffle_play_button = parser_exports.parseItem(data.shufflePlayButton);
    this.menu = parser_exports.parseItem(data.moreActionsMenu);
    this.banner = parser_exports.parseItem(data.playlistHeaderBanner);
  }
};
__name(_PlaylistHeader, "PlaylistHeader");
__publicField(_PlaylistHeader, "type", "PlaylistHeader");
var PlaylistHeader = _PlaylistHeader;

// dist/src/parser/classes/PlaylistInfoCardContent.js
var _PlaylistInfoCardContent = class _PlaylistInfoCardContent extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "video_count");
    __publicField(this, "channel_name");
    __publicField(this, "endpoint");
    this.title = new Text2(data.playlistTitle);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.video_count = new Text2(data.playlistVideoCount);
    this.channel_name = new Text2(data.channelName);
    this.endpoint = new NavigationEndpoint(data.action);
  }
};
__name(_PlaylistInfoCardContent, "PlaylistInfoCardContent");
__publicField(_PlaylistInfoCardContent, "type", "PlaylistInfoCardContent");
var PlaylistInfoCardContent = _PlaylistInfoCardContent;

// dist/src/parser/classes/PlaylistMetadata.js
var _PlaylistMetadata = class _PlaylistMetadata extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    this.title = data.title;
    this.description = data.description || null;
  }
};
__name(_PlaylistMetadata, "PlaylistMetadata");
__publicField(_PlaylistMetadata, "type", "PlaylistMetadata");
var PlaylistMetadata = _PlaylistMetadata;

// dist/src/parser/classes/PlaylistSidebar.js
var _PlaylistSidebar = class _PlaylistSidebar extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items);
  }
  // XXX: alias for consistency
  get contents() {
    return this.items;
  }
};
__name(_PlaylistSidebar, "PlaylistSidebar");
__publicField(_PlaylistSidebar, "type", "PlaylistSidebar");
var PlaylistSidebar = _PlaylistSidebar;

// dist/src/parser/classes/PlaylistSidebarPrimaryInfo.js
var _PlaylistSidebarPrimaryInfo = class _PlaylistSidebarPrimaryInfo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "stats");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "endpoint");
    __publicField(this, "description");
    this.stats = data.stats.map((stat) => new Text2(stat));
    this.thumbnail_renderer = parser_exports.parseItem(data.thumbnailRenderer);
    this.title = new Text2(data.title);
    this.menu = parser_exports.parseItem(data.menu);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.description = new Text2(data.description);
  }
};
__name(_PlaylistSidebarPrimaryInfo, "PlaylistSidebarPrimaryInfo");
__publicField(_PlaylistSidebarPrimaryInfo, "type", "PlaylistSidebarPrimaryInfo");
var PlaylistSidebarPrimaryInfo = _PlaylistSidebarPrimaryInfo;

// dist/src/parser/classes/PlaylistSidebarSecondaryInfo.js
var _PlaylistSidebarSecondaryInfo = class _PlaylistSidebarSecondaryInfo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "owner");
    __publicField(this, "button");
    this.owner = parser_exports.parseItem(data.videoOwner);
    this.button = parser_exports.parseItem(data.button);
  }
};
__name(_PlaylistSidebarSecondaryInfo, "PlaylistSidebarSecondaryInfo");
__publicField(_PlaylistSidebarSecondaryInfo, "type", "PlaylistSidebarSecondaryInfo");
var PlaylistSidebarSecondaryInfo = _PlaylistSidebarSecondaryInfo;

// dist/src/parser/classes/PlaylistThumbnailOverlay.js
var _PlaylistThumbnailOverlay = class _PlaylistThumbnailOverlay extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "text");
    if (Reflect.has(data, "icon"))
      this.icon_type = data.icon.iconType;
    this.text = new Text2(data.text);
  }
};
__name(_PlaylistThumbnailOverlay, "PlaylistThumbnailOverlay");
__publicField(_PlaylistThumbnailOverlay, "type", "PlaylistThumbnailOverlay");
var PlaylistThumbnailOverlay = _PlaylistThumbnailOverlay;

// dist/src/parser/classes/PlaylistVideo.js
var _PlaylistVideo = class _PlaylistVideo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "index");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "set_video_id");
    __publicField(this, "endpoint");
    __publicField(this, "is_playable");
    __publicField(this, "menu");
    __publicField(this, "upcoming");
    __publicField(this, "video_info");
    __publicField(this, "accessibility_label");
    __publicField(this, "style");
    __publicField(this, "duration");
    this.id = data.videoId;
    this.index = new Text2(data.index);
    this.title = new Text2(data.title);
    this.author = new Author(data.shortBylineText);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data.thumbnailOverlays);
    this.set_video_id = data == null ? void 0 : data.setVideoId;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.is_playable = data.isPlayable;
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.video_info = new Text2(data.videoInfo);
    this.accessibility_label = data.title.accessibility.accessibilityData.label;
    if (Reflect.has(data, "style")) {
      this.style = data.style;
    }
    const upcoming = data.upcomingEventData && Number(`${data.upcomingEventData.startTime}000`);
    if (upcoming) {
      this.upcoming = new Date(upcoming);
    }
    this.duration = {
      text: new Text2(data.lengthText).toString(),
      seconds: parseInt(data.lengthSeconds)
    };
  }
  get is_live() {
    var _a;
    return ((_a = this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus)) == null ? void 0 : _a.style) === "LIVE";
  }
  get is_upcoming() {
    var _a;
    return ((_a = this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus)) == null ? void 0 : _a.style) === "UPCOMING";
  }
};
__name(_PlaylistVideo, "PlaylistVideo");
__publicField(_PlaylistVideo, "type", "PlaylistVideo");
var PlaylistVideo = _PlaylistVideo;

// dist/src/parser/classes/PlaylistVideoList.js
var _PlaylistVideoList = class _PlaylistVideoList extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "is_editable");
    __publicField(this, "can_reorder");
    __publicField(this, "videos");
    this.id = data.playlistId;
    this.is_editable = data.isEditable;
    this.can_reorder = data.canReorder;
    this.videos = parser_exports.parseArray(data.contents);
  }
};
__name(_PlaylistVideoList, "PlaylistVideoList");
__publicField(_PlaylistVideoList, "type", "PlaylistVideoList");
var PlaylistVideoList = _PlaylistVideoList;

// dist/src/parser/classes/Poll.js
var _Poll = class _Poll extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "choices");
    __publicField(this, "poll_type");
    __publicField(this, "total_votes");
    __publicField(this, "live_chat_poll_id");
    this.choices = data.choices.map((choice) => ({
      text: new Text2(choice.text),
      select_endpoint: choice.selectServiceEndpoint ? new NavigationEndpoint(choice.selectServiceEndpoint) : null,
      deselect_endpoint: choice.deselectServiceEndpoint ? new NavigationEndpoint(choice.deselectServiceEndpoint) : null,
      vote_ratio_if_selected: (choice == null ? void 0 : choice.voteRatioIfSelected) || null,
      vote_percentage_if_selected: new Text2(choice.votePercentageIfSelected),
      vote_ratio_if_not_selected: (choice == null ? void 0 : choice.voteRatioIfSelected) || null,
      vote_percentage_if_not_selected: new Text2(choice.votePercentageIfSelected),
      image: choice.image ? Thumbnail.fromResponse(choice.image) : null
    }));
    if (Reflect.has(data, "type"))
      this.poll_type = data.type;
    if (Reflect.has(data, "totalVotes"))
      this.total_votes = new Text2(data.totalVotes);
    if (Reflect.has(data, "liveChatPollId"))
      this.live_chat_poll_id = data.liveChatPollId;
  }
};
__name(_Poll, "Poll");
__publicField(_Poll, "type", "Poll");
var Poll = _Poll;

// dist/src/parser/classes/Post.js
var _Post = class _Post extends BackstagePost {
  constructor(data) {
    super(data);
  }
};
__name(_Post, "Post");
__publicField(_Post, "type", "Post");
var Post = _Post;

// dist/src/parser/classes/PostMultiImage.js
var _PostMultiImage = class _PostMultiImage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "images");
    this.images = parser_exports.parseArray(data.images, BackstageImage);
  }
};
__name(_PostMultiImage, "PostMultiImage");
__publicField(_PostMultiImage, "type", "PostMultiImage");
var PostMultiImage = _PostMultiImage;

// dist/src/parser/classes/PremiereTrailerBadge.js
var _PremiereTrailerBadge = class _PremiereTrailerBadge extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    this.label = new Text2(data.label);
  }
};
__name(_PremiereTrailerBadge, "PremiereTrailerBadge");
__publicField(_PremiereTrailerBadge, "type", "PremiereTrailerBadge");
var PremiereTrailerBadge = _PremiereTrailerBadge;

// dist/src/parser/classes/ProductListHeader.js
var _ProductListHeader = class _ProductListHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "suppress_padding_disclaimer");
    this.title = new Text2(data.title);
    this.suppress_padding_disclaimer = !!data.suppressPaddingDisclaimer;
  }
};
__name(_ProductListHeader, "ProductListHeader");
__publicField(_ProductListHeader, "type", "ProductListHeader");
var ProductListHeader = _ProductListHeader;

// dist/src/parser/classes/ProductListItem.js
var _ProductListItem = class _ProductListItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "accessibility_title");
    __publicField(this, "thumbnail");
    __publicField(this, "price");
    __publicField(this, "endpoint");
    __publicField(this, "merchant_name");
    __publicField(this, "stay_in_app");
    __publicField(this, "view_button");
    this.title = new Text2(data.title);
    this.accessibility_title = data.accessibilityTitle;
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.price = data.price;
    this.endpoint = new NavigationEndpoint(data.onClickCommand);
    this.merchant_name = data.merchantName;
    this.stay_in_app = !!data.stayInApp;
    this.view_button = parser_exports.parseItem(data.viewButton, Button);
  }
};
__name(_ProductListItem, "ProductListItem");
__publicField(_ProductListItem, "type", "ProductListItem");
var ProductListItem = _ProductListItem;

// dist/src/parser/classes/ProfileColumn.js
var _ProfileColumn = class _ProfileColumn extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ProfileColumn, "ProfileColumn");
__publicField(_ProfileColumn, "type", "ProfileColumn");
var ProfileColumn = _ProfileColumn;

// dist/src/parser/classes/ProfileColumnStats.js
var _ProfileColumnStats = class _ProfileColumnStats extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ProfileColumnStats, "ProfileColumnStats");
__publicField(_ProfileColumnStats, "type", "ProfileColumnStats");
var ProfileColumnStats = _ProfileColumnStats;

// dist/src/parser/classes/ProfileColumnStatsEntry.js
var _ProfileColumnStatsEntry = class _ProfileColumnStatsEntry extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    __publicField(this, "value");
    this.label = new Text2(data.label);
    this.value = new Text2(data.value);
  }
};
__name(_ProfileColumnStatsEntry, "ProfileColumnStatsEntry");
__publicField(_ProfileColumnStatsEntry, "type", "ProfileColumnStatsEntry");
var ProfileColumnStatsEntry = _ProfileColumnStatsEntry;

// dist/src/parser/classes/ProfileColumnUserInfo.js
var _ProfileColumnUserInfo = class _ProfileColumnUserInfo extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    this.title = new Text2(data.title);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
  }
};
__name(_ProfileColumnUserInfo, "ProfileColumnUserInfo");
__publicField(_ProfileColumnUserInfo, "type", "ProfileColumnUserInfo");
var ProfileColumnUserInfo = _ProfileColumnUserInfo;

// dist/src/parser/classes/Quiz.js
var _Quiz = class _Quiz extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "choices");
    __publicField(this, "total_votes");
    this.choices = data.choices.map((choice) => ({
      text: new Text2(choice.text),
      is_correct: choice.isCorrect
    }));
    this.total_votes = new Text2(data.totalVotes);
  }
};
__name(_Quiz, "Quiz");
__publicField(_Quiz, "type", "Quiz");
var Quiz = _Quiz;

// dist/src/parser/classes/RecognitionShelf.js
var _RecognitionShelf = class _RecognitionShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "avatars");
    __publicField(this, "button");
    __publicField(this, "surface");
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
    this.avatars = data.avatars.map((avatar) => new Thumbnail(avatar));
    this.button = parser_exports.parseItem(data.button, Button);
    this.surface = data.surface;
  }
};
__name(_RecognitionShelf, "RecognitionShelf");
__publicField(_RecognitionShelf, "type", "RecognitionShelf");
var RecognitionShelf = _RecognitionShelf;

// dist/src/parser/classes/ReelItem.js
var _ReelItem = class _ReelItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "views");
    __publicField(this, "endpoint");
    __publicField(this, "accessibility");
    this.id = data.videoId;
    this.title = new Text2(data.headline);
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.views = new Text2(data.viewCountText);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    if ("accessibility" in data && "accessibilityData" in data.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    var _a, _b;
    return (_b = (_a = this.accessibility) == null ? void 0 : _a.accessibility_data) == null ? void 0 : _b.label;
  }
};
__name(_ReelItem, "ReelItem");
__publicField(_ReelItem, "type", "ReelItem");
var ReelItem = _ReelItem;

// dist/src/parser/classes/ReelPlayerHeader.js
var _ReelPlayerHeader = class _ReelPlayerHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "reel_title_text");
    __publicField(this, "timestamp_text");
    __publicField(this, "channel_title_text");
    __publicField(this, "channel_thumbnail");
    __publicField(this, "author");
    this.reel_title_text = new Text2(data.reelTitleText);
    this.timestamp_text = new Text2(data.timestampText);
    this.channel_title_text = new Text2(data.channelTitleText);
    this.channel_thumbnail = Thumbnail.fromResponse(data.channelThumbnail);
    this.author = new Author(data.channelNavigationEndpoint, void 0);
  }
};
__name(_ReelPlayerHeader, "ReelPlayerHeader");
__publicField(_ReelPlayerHeader, "type", "ReelPlayerHeader");
var ReelPlayerHeader = _ReelPlayerHeader;

// dist/src/parser/classes/ReelPlayerOverlay.js
var _ReelPlayerOverlay = class _ReelPlayerOverlay extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "reel_player_header_supported_renderers");
    __publicField(this, "menu");
    __publicField(this, "next_item_button");
    __publicField(this, "prev_item_button");
    __publicField(this, "subscribe_button_renderer");
    __publicField(this, "style");
    __publicField(this, "view_comments_button");
    __publicField(this, "share_button");
    __publicField(this, "pivot_button");
    __publicField(this, "info_panel");
    this.like_button = parser_exports.parseItem(data.likeButton, LikeButton);
    this.reel_player_header_supported_renderers = parser_exports.parseItem(data.reelPlayerHeaderSupportedRenderers, ReelPlayerHeader);
    this.menu = parser_exports.parseItem(data.menu, Menu);
    this.next_item_button = parser_exports.parseItem(data.nextItemButton, Button);
    this.prev_item_button = parser_exports.parseItem(data.prevItemButton, Button);
    this.subscribe_button_renderer = parser_exports.parseItem(data.subscribeButtonRenderer, [Button, SubscribeButton]);
    this.style = data.style;
    this.view_comments_button = parser_exports.parseItem(data.viewCommentsButton, Button);
    this.share_button = parser_exports.parseItem(data.shareButton, Button);
    this.pivot_button = parser_exports.parseItem(data.pivotButton, PivotButton);
    this.info_panel = parser_exports.parseItem(data.infoPanel, InfoPanelContainer);
  }
};
__name(_ReelPlayerOverlay, "ReelPlayerOverlay");
__publicField(_ReelPlayerOverlay, "type", "ReelPlayerOverlay");
var ReelPlayerOverlay = _ReelPlayerOverlay;

// dist/src/parser/classes/RelatedChipCloud.js
var _RelatedChipCloud = class _RelatedChipCloud extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data.content);
  }
};
__name(_RelatedChipCloud, "RelatedChipCloud");
__publicField(_RelatedChipCloud, "type", "RelatedChipCloud");
var RelatedChipCloud = _RelatedChipCloud;

// dist/src/parser/classes/RichGrid.js
var _RichGrid = class _RichGrid extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "target_id");
    this.header = parser_exports.parseItem(data.header);
    this.contents = parser_exports.parseArray(data.contents);
    if (Reflect.has(data, "targetId"))
      this.target_id = data.targetId;
  }
};
__name(_RichGrid, "RichGrid");
__publicField(_RichGrid, "type", "RichGrid");
var RichGrid = _RichGrid;

// dist/src/parser/classes/RichItem.js
var _RichItem = class _RichItem extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data.content);
  }
};
__name(_RichItem, "RichItem");
__publicField(_RichItem, "type", "RichItem");
var RichItem = _RichItem;

// dist/src/parser/classes/RichListHeader.js
var _RichListHeader = class _RichListHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "title_style");
    __publicField(this, "icon_type");
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
    if (Reflect.has(data, "titleStyle")) {
      this.title_style = data.titleStyle.style;
    }
    if (Reflect.has(data, "icon")) {
      this.icon_type = data.icon.iconType;
    }
  }
};
__name(_RichListHeader, "RichListHeader");
__publicField(_RichListHeader, "type", "RichListHeader");
var RichListHeader = _RichListHeader;

// dist/src/parser/classes/RichMetadata.js
var _RichMetadata = class _RichMetadata extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "call_to_action");
    __publicField(this, "icon_type");
    __publicField(this, "endpoint");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
    this.call_to_action = new Text2(data.callToAction);
    if (Reflect.has(data, "callToActionIcon")) {
      this.icon_type = data.callToActionIcon.iconType;
    }
    this.endpoint = new NavigationEndpoint(data.endpoint);
  }
};
__name(_RichMetadata, "RichMetadata");
__publicField(_RichMetadata, "type", "RichMetadata");
var RichMetadata = _RichMetadata;

// dist/src/parser/classes/RichMetadataRow.js
var _RichMetadataRow = class _RichMetadataRow extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data.contents);
  }
};
__name(_RichMetadataRow, "RichMetadataRow");
__publicField(_RichMetadataRow, "type", "RichMetadataRow");
var RichMetadataRow = _RichMetadataRow;

// dist/src/parser/classes/RichSection.js
var _RichSection = class _RichSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "content");
    __publicField(this, "full_bleed");
    __publicField(this, "target_id");
    this.content = parser_exports.parseItem(data.content);
    this.full_bleed = !!data.fullBleed;
    if ("targetId" in data) {
      this.target_id = data.targetId;
    }
  }
};
__name(_RichSection, "RichSection");
__publicField(_RichSection, "type", "RichSection");
var RichSection = _RichSection;

// dist/src/parser/classes/RichShelf.js
var _RichShelf = class _RichShelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "contents");
    __publicField(this, "endpoint");
    __publicField(this, "subtitle");
    __publicField(this, "is_expanded");
    __publicField(this, "is_bottom_divider_hidden");
    __publicField(this, "is_top_divider_hidden");
    __publicField(this, "layout_sizing");
    __publicField(this, "icon_type");
    __publicField(this, "menu");
    __publicField(this, "next_button");
    __publicField(this, "previous_button");
    this.title = new Text2(data.title);
    this.contents = parser_exports.parseArray(data.contents);
    this.is_expanded = !!data.is_expanded;
    this.is_bottom_divider_hidden = !!data.isBottomDividerHidden;
    this.is_top_divider_hidden = !!data.isTopDividerHidden;
    if ("endpoint" in data) {
      this.endpoint = new NavigationEndpoint(data.endpoint);
    }
    if ("subtitle" in data) {
      this.subtitle = new Text2(data.subtitle);
    }
    if ("layoutSizing" in data) {
      this.layout_sizing = data.layoutSizing;
    }
    if ("icon" in data) {
      this.icon_type = data.icon.iconType;
    }
    this.menu = parser_exports.parseItem(data.menu);
    this.next_button = parser_exports.parseItem(data.nextButton);
    this.previous_button = parser_exports.parseItem(data.previousButton);
  }
};
__name(_RichShelf, "RichShelf");
__publicField(_RichShelf, "type", "RichShelf");
var RichShelf = _RichShelf;

// dist/src/parser/classes/SearchFilter.js
var _SearchFilter = class _SearchFilter extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "label");
    __publicField(this, "endpoint");
    __publicField(this, "tooltip");
    __publicField(this, "status");
    this.label = new Text2(data.label);
    this.endpoint = new NavigationEndpoint(data.endpoint || data.navigationEndpoint);
    this.tooltip = data.tooltip;
    if (Reflect.has(data, "status")) {
      this.status = data.status;
    }
  }
  get disabled() {
    return this.status === "FILTER_STATUS_DISABLED";
  }
  get selected() {
    return this.status === "FILTER_STATUS_SELECTED";
  }
};
__name(_SearchFilter, "SearchFilter");
__publicField(_SearchFilter, "type", "SearchFilter");
var SearchFilter2 = _SearchFilter;

// dist/src/parser/classes/SearchFilterGroup.js
var _SearchFilterGroup = class _SearchFilterGroup extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "filters");
    this.title = new Text2(data.title);
    this.filters = parser_exports.parseArray(data.filters, SearchFilter2);
  }
};
__name(_SearchFilterGroup, "SearchFilterGroup");
__publicField(_SearchFilterGroup, "type", "SearchFilterGroup");
var SearchFilterGroup = _SearchFilterGroup;

// dist/src/parser/classes/SearchFilterOptionsDialog.js
var _SearchFilterOptionsDialog = class _SearchFilterOptionsDialog extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "groups");
    this.title = new Text2(data.title);
    this.groups = parser_exports.parseArray(data.groups, SearchFilterGroup);
  }
};
__name(_SearchFilterOptionsDialog, "SearchFilterOptionsDialog");
__publicField(_SearchFilterOptionsDialog, "type", "SearchFilterOptionsDialog");
var SearchFilterOptionsDialog = _SearchFilterOptionsDialog;

// dist/src/parser/classes/SearchHeader.js
var _SearchHeader = class _SearchHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "chip_bar");
    __publicField(this, "search_filter_button");
    this.chip_bar = parser_exports.parseItem(data.chipBar, ChipCloud);
    this.search_filter_button = parser_exports.parseItem(data.searchFilterButton, Button);
  }
};
__name(_SearchHeader, "SearchHeader");
__publicField(_SearchHeader, "type", "SearchHeader");
var SearchHeader = _SearchHeader;

// dist/src/parser/classes/SearchSubMenu.js
var _SearchSubMenu = class _SearchSubMenu extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "groups");
    __publicField(this, "button");
    if (Reflect.has(data, "title"))
      this.title = new Text2(data.title);
    if (Reflect.has(data, "groups"))
      this.groups = parser_exports.parseArray(data.groups, SearchFilterGroup);
    if (Reflect.has(data, "button"))
      this.button = parser_exports.parseItem(data.button, ToggleButton);
  }
};
__name(_SearchSubMenu, "SearchSubMenu");
__publicField(_SearchSubMenu, "type", "SearchSubMenu");
var SearchSubMenu = _SearchSubMenu;

// dist/src/parser/classes/SearchSuggestionsSection.js
var _SearchSuggestionsSection = class _SearchSuggestionsSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data.contents);
  }
};
__name(_SearchSuggestionsSection, "SearchSuggestionsSection");
__publicField(_SearchSuggestionsSection, "type", "SearchSuggestionsSection");
var SearchSuggestionsSection = _SearchSuggestionsSection;

// dist/src/parser/classes/UniversalWatchCard.js
var _UniversalWatchCard = class _UniversalWatchCard extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "header");
    __publicField(this, "call_to_action");
    __publicField(this, "sections");
    __publicField(this, "collapsed_label");
    this.header = parser_exports.parseItem(data.header);
    this.call_to_action = parser_exports.parseItem(data.callToAction);
    this.sections = parser_exports.parseArray(data.sections);
    if (Reflect.has(data, "collapsedLabel")) {
      this.collapsed_label = new Text2(data.collapsedLabel);
    }
  }
};
__name(_UniversalWatchCard, "UniversalWatchCard");
__publicField(_UniversalWatchCard, "type", "UniversalWatchCard");
var UniversalWatchCard = _UniversalWatchCard;

// dist/src/parser/classes/SecondarySearchContainer.js
var _SecondarySearchContainer = class _SecondarySearchContainer extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "target_id");
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data.contents, [UniversalWatchCard]);
  }
};
__name(_SecondarySearchContainer, "SecondarySearchContainer");
__publicField(_SecondarySearchContainer, "type", "SecondarySearchContainer");
var SecondarySearchContainer = _SecondarySearchContainer;

// dist/src/parser/classes/SectionHeaderView.js
var _SectionHeaderView = class _SectionHeaderView extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "headline");
    this.headline = Text2.fromAttributed(data.headline);
  }
};
__name(_SectionHeaderView, "SectionHeaderView");
__publicField(_SectionHeaderView, "type", "SectionHeaderView");
var SectionHeaderView = _SectionHeaderView;

// dist/src/parser/classes/SegmentedLikeDislikeButton.js
var _SegmentedLikeDislikeButton = class _SegmentedLikeDislikeButton extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "dislike_button");
    this.like_button = parser_exports.parseItem(data.likeButton, [ToggleButton, Button]);
    this.dislike_button = parser_exports.parseItem(data.dislikeButton, [ToggleButton, Button]);
  }
};
__name(_SegmentedLikeDislikeButton, "SegmentedLikeDislikeButton");
__publicField(_SegmentedLikeDislikeButton, "type", "SegmentedLikeDislikeButton");
var SegmentedLikeDislikeButton = _SegmentedLikeDislikeButton;

// dist/src/parser/classes/SettingBoolean.js
var _SettingBoolean = class _SettingBoolean extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "summary");
    __publicField(this, "enable_endpoint");
    __publicField(this, "disable_endpoint");
    __publicField(this, "item_id");
    if (Reflect.has(data, "title")) {
      this.title = new Text2(data.title);
    }
    if (Reflect.has(data, "summary")) {
      this.summary = new Text2(data.summary);
    }
    if (Reflect.has(data, "enableServiceEndpoint")) {
      this.enable_endpoint = new NavigationEndpoint(data.enableServiceEndpoint);
    }
    if (Reflect.has(data, "disableServiceEndpoint")) {
      this.disable_endpoint = new NavigationEndpoint(data.disableServiceEndpoint);
    }
    this.item_id = data.itemId;
  }
};
__name(_SettingBoolean, "SettingBoolean");
__publicField(_SettingBoolean, "type", "SettingBoolean");
var SettingBoolean = _SettingBoolean;

// dist/src/parser/classes/SettingsCheckbox.js
var _SettingsCheckbox = class _SettingsCheckbox extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "help_text");
    __publicField(this, "enabled");
    __publicField(this, "disabled");
    __publicField(this, "id");
    this.title = new Text2(data.title);
    this.help_text = new Text2(data.helpText);
    this.enabled = data.enabled;
    this.disabled = data.disabled;
    this.id = data.id;
  }
};
__name(_SettingsCheckbox, "SettingsCheckbox");
__publicField(_SettingsCheckbox, "type", "SettingsCheckbox");
var SettingsCheckbox = _SettingsCheckbox;

// dist/src/parser/classes/SettingsSwitch.js
var _SettingsSwitch = class _SettingsSwitch extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "enabled");
    __publicField(this, "enable_endpoint");
    __publicField(this, "disable_endpoint");
    this.title = new Text2(data.title);
    this.subtitle = new Text2(data.subtitle);
    this.enabled = data.enabled;
    this.enable_endpoint = new NavigationEndpoint(data.enableServiceEndpoint);
    this.disable_endpoint = new NavigationEndpoint(data.disableServiceEndpoint);
  }
};
__name(_SettingsSwitch, "SettingsSwitch");
__publicField(_SettingsSwitch, "type", "SettingsSwitch");
var SettingsSwitch = _SettingsSwitch;

// dist/src/parser/classes/SettingsOptions.js
var _SettingsOptions = class _SettingsOptions extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "text");
    __publicField(this, "options");
    this.title = new Text2(data.title);
    if (Reflect.has(data, "text")) {
      this.text = new Text2(data.text).toString();
    }
    if (Reflect.has(data, "options")) {
      this.options = parser_exports.parseArray(data.options, [
        SettingsSwitch,
        Dropdown,
        CopyLink,
        SettingsCheckbox,
        ChannelOptions
      ]);
    }
  }
};
__name(_SettingsOptions, "SettingsOptions");
__publicField(_SettingsOptions, "type", "SettingsOptions");
var SettingsOptions = _SettingsOptions;

// dist/src/parser/classes/SettingsSidebar.js
var _SettingsSidebar = class _SettingsSidebar extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    this.title = new Text2(data.title);
    this.items = parser_exports.parseArray(data.items, CompactLink);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_SettingsSidebar, "SettingsSidebar");
__publicField(_SettingsSidebar, "type", "SettingsSidebar");
var SettingsSidebar = _SettingsSidebar;

// dist/src/parser/classes/SharedPost.js
var _SharedPost = class _SharedPost extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "content");
    __publicField(this, "published");
    __publicField(this, "menu");
    __publicField(this, "original_post");
    __publicField(this, "id");
    __publicField(this, "endpoint");
    __publicField(this, "expand_button");
    __publicField(this, "author");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.content = new Text2(data.content);
    this.published = new Text2(data.publishedTimeText);
    this.menu = parser_exports.parseItem(data.actionMenu, Menu);
    this.original_post = parser_exports.parseItem(data.originalPost, [BackstagePost, Post]);
    this.id = data.postId;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.expand_button = parser_exports.parseItem(data.expandButton, Button);
    this.author = new Author(data.displayName, void 0);
  }
};
__name(_SharedPost, "SharedPost");
__publicField(_SharedPost, "type", "SharedPost");
var SharedPost = _SharedPost;

// dist/src/parser/classes/SharePanelHeader.js
var _SharePanelHeader = class _SharePanelHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = parser_exports.parseItem(data.title);
  }
};
__name(_SharePanelHeader, "SharePanelHeader");
__publicField(_SharePanelHeader, "type", "SharePanelHeader");
var SharePanelHeader = _SharePanelHeader;

// dist/src/parser/classes/SharePanelTitleV15.js
var _SharePanelTitleV15 = class _SharePanelTitleV15 extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data.title);
  }
};
__name(_SharePanelTitleV15, "SharePanelTitleV15");
__publicField(_SharePanelTitleV15, "type", "SharePanelTitleV15");
var SharePanelTitleV15 = _SharePanelTitleV15;

// dist/src/parser/classes/ShareTarget.js
var _ShareTarget = class _ShareTarget extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "service_name");
    __publicField(this, "target_id");
    __publicField(this, "title");
    if (Reflect.has(data, "serviceEndpoint"))
      this.endpoint = new NavigationEndpoint(data.serviceEndpoint);
    else if (Reflect.has(data, "navigationEndpoint"))
      this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.service_name = data.serviceName;
    this.target_id = data.targetId;
    this.title = new Text2(data.title);
  }
};
__name(_ShareTarget, "ShareTarget");
__publicField(_ShareTarget, "type", "ShareTarget");
var ShareTarget = _ShareTarget;

// dist/src/parser/classes/Shelf.js
var _Shelf = class _Shelf extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "content");
    __publicField(this, "icon_type");
    __publicField(this, "menu");
    __publicField(this, "play_all_button");
    __publicField(this, "subtitle");
    this.title = new Text2(data.title);
    if (Reflect.has(data, "endpoint")) {
      this.endpoint = new NavigationEndpoint(data.endpoint);
    }
    this.content = parser_exports.parseItem(data.content);
    if (Reflect.has(data, "icon")) {
      this.icon_type = data.icon.iconType;
    }
    if (Reflect.has(data, "menu")) {
      this.menu = parser_exports.parseItem(data.menu);
    }
    if (Reflect.has(data, "playAllButton")) {
      this.play_all_button = parser_exports.parseItem(data.playAllButton, Button);
    }
    if (Reflect.has(data, "subtitle")) {
      this.subtitle = new Text2(data.subtitle);
    }
  }
};
__name(_Shelf, "Shelf");
__publicField(_Shelf, "type", "Shelf");
var Shelf = _Shelf;

// dist/src/parser/classes/ShortsLockupView.js
var _ShortsLockupView = class _ShortsLockupView extends YTNode {
  constructor(data) {
    var _a;
    super();
    __publicField(this, "entity_id");
    __publicField(this, "accessibility_text");
    __publicField(this, "thumbnail");
    __publicField(this, "on_tap_endpoint");
    __publicField(this, "menu_on_tap");
    __publicField(this, "index_in_collection");
    __publicField(this, "menu_on_tap_a11y_label");
    __publicField(this, "overlay_metadata");
    __publicField(this, "inline_player_data");
    __publicField(this, "badge");
    this.entity_id = data.entityId;
    this.accessibility_text = data.accessibilityText;
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.on_tap_endpoint = new NavigationEndpoint(data.onTap);
    this.menu_on_tap = new NavigationEndpoint(data.menuOnTap);
    this.index_in_collection = data.indexInCollection;
    this.menu_on_tap_a11y_label = data.menuOnTapA11yLabel;
    this.overlay_metadata = {
      primary_text: data.overlayMetadata.primaryText ? Text2.fromAttributed(data.overlayMetadata.primaryText) : void 0,
      secondary_text: data.overlayMetadata.secondaryText ? Text2.fromAttributed(data.overlayMetadata.secondaryText) : void 0
    };
    if ((_a = data.inlinePlayerData) == null ? void 0 : _a.onVisible) {
      this.inline_player_data = new NavigationEndpoint(data.inlinePlayerData.onVisible);
    }
    if (data.badge) {
      this.badge = parser_exports.parseItem(data.badge, BadgeView);
    }
  }
};
__name(_ShortsLockupView, "ShortsLockupView");
__publicField(_ShortsLockupView, "type", "ShortsLockupView");
var ShortsLockupView = _ShortsLockupView;

// dist/src/parser/classes/ShowingResultsFor.js
var _ShowingResultsFor = class _ShowingResultsFor extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "corrected_query");
    __publicField(this, "original_query");
    __publicField(this, "corrected_query_endpoint");
    __publicField(this, "original_query_endpoint");
    __publicField(this, "search_instead_for");
    __publicField(this, "showing_results_for");
    this.corrected_query = new Text2(data.correctedQuery);
    this.original_query = new Text2(data.originalQuery);
    this.corrected_query_endpoint = new NavigationEndpoint(data.correctedQueryEndpoint);
    this.original_query_endpoint = new NavigationEndpoint(data.originalQueryEndpoint);
    this.search_instead_for = new Text2(data.searchInsteadFor);
    this.showing_results_for = new Text2(data.showingResultsFor);
  }
};
__name(_ShowingResultsFor, "ShowingResultsFor");
__publicField(_ShowingResultsFor, "type", "ShowingResultsFor");
var ShowingResultsFor = _ShowingResultsFor;

// dist/src/parser/classes/SimpleCardContent.js
var _SimpleCardContent = class _SimpleCardContent extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "image");
    __publicField(this, "title");
    __publicField(this, "display_domain");
    __publicField(this, "show_link_icon");
    __publicField(this, "call_to_action");
    __publicField(this, "endpoint");
    this.image = Thumbnail.fromResponse(data.image);
    this.title = new Text2(data.title);
    this.display_domain = new Text2(data.displayDomain);
    this.show_link_icon = data.showLinkIcon;
    this.call_to_action = new Text2(data.callToAction);
    this.endpoint = new NavigationEndpoint(data.command);
  }
};
__name(_SimpleCardContent, "SimpleCardContent");
__publicField(_SimpleCardContent, "type", "SimpleCardContent");
var SimpleCardContent = _SimpleCardContent;

// dist/src/parser/classes/SimpleCardTeaser.js
var _SimpleCardTeaser = class _SimpleCardTeaser extends YTNode {
  // @TODO: or string?
  constructor(data) {
    super();
    __publicField(this, "message");
    __publicField(this, "prominent");
    this.message = new Text2(data.message);
    this.prominent = data.prominent;
  }
};
__name(_SimpleCardTeaser, "SimpleCardTeaser");
__publicField(_SimpleCardTeaser, "type", "SimpleCardTeaser");
var SimpleCardTeaser = _SimpleCardTeaser;

// dist/src/parser/classes/SimpleTextSection.js
var _SimpleTextSection = class _SimpleTextSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "lines");
    __publicField(this, "style");
    this.lines = data.lines.map((line) => new Text2(line));
    this.style = data.layoutStyle;
  }
};
__name(_SimpleTextSection, "SimpleTextSection");
__publicField(_SimpleTextSection, "type", "SimpleTextSection");
var SimpleTextSection = _SimpleTextSection;

// dist/src/parser/classes/SingleActionEmergencySupport.js
var _SingleActionEmergencySupport = class _SingleActionEmergencySupport extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "action_text");
    __publicField(this, "nav_text");
    __publicField(this, "details");
    __publicField(this, "icon_type");
    __publicField(this, "endpoint");
    this.action_text = new Text2(data.actionText);
    this.nav_text = new Text2(data.navigationText);
    this.details = new Text2(data.detailsText);
    this.icon_type = data.icon.iconType;
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
  }
};
__name(_SingleActionEmergencySupport, "SingleActionEmergencySupport");
__publicField(_SingleActionEmergencySupport, "type", "SingleActionEmergencySupport");
var SingleActionEmergencySupport = _SingleActionEmergencySupport;

// dist/src/parser/classes/Tab.js
var _Tab = class _Tab extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "selected");
    __publicField(this, "endpoint");
    __publicField(this, "content");
    this.title = data.title || "N/A";
    this.selected = !!data.selected;
    this.endpoint = new NavigationEndpoint(data.endpoint);
    this.content = parser_exports.parseItem(data.content, [SectionList, MusicQueue, RichGrid]);
  }
};
__name(_Tab, "Tab");
__publicField(_Tab, "type", "Tab");
var Tab = _Tab;

// dist/src/parser/classes/SingleColumnBrowseResults.js
var _SingleColumnBrowseResults = class _SingleColumnBrowseResults extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "tabs");
    this.tabs = parser_exports.parseArray(data.tabs, Tab);
  }
};
__name(_SingleColumnBrowseResults, "SingleColumnBrowseResults");
__publicField(_SingleColumnBrowseResults, "type", "SingleColumnBrowseResults");
var SingleColumnBrowseResults = _SingleColumnBrowseResults;

// dist/src/parser/classes/SingleColumnMusicWatchNextResults.js
var _SingleColumnMusicWatchNextResults = class _SingleColumnMusicWatchNextResults extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parse(data);
  }
};
__name(_SingleColumnMusicWatchNextResults, "SingleColumnMusicWatchNextResults");
__publicField(_SingleColumnMusicWatchNextResults, "type", "SingleColumnMusicWatchNextResults");
var SingleColumnMusicWatchNextResults = _SingleColumnMusicWatchNextResults;

// dist/src/parser/classes/SingleHeroImage.js
var _SingleHeroImage = class _SingleHeroImage extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "style");
    this.thumbnails = Thumbnail.fromResponse(data.thumbnail);
    this.style = data.style;
  }
};
__name(_SingleHeroImage, "SingleHeroImage");
__publicField(_SingleHeroImage, "type", "SingleHeroImage");
var SingleHeroImage = _SingleHeroImage;

// dist/src/parser/classes/SlimOwner.js
var _SlimOwner = class _SlimOwner extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "subscribe_button");
    this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
    this.title = new Text2(data.title);
    this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
    this.subscribe_button = parser_exports.parseItem(data.subscribeButton, SubscribeButton);
  }
};
__name(_SlimOwner, "SlimOwner");
__publicField(_SlimOwner, "type", "SlimOwner");
var SlimOwner = _SlimOwner;

// dist/src/parser/classes/SlimVideoMetadata.js
var _SlimVideoMetadata = class _SlimVideoMetadata extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "collapsed_subtitle");
    __publicField(this, "expanded_subtitle");
    __publicField(this, "owner");
    __publicField(this, "description");
    __publicField(this, "video_id");
    __publicField(this, "date");
    this.title = new Text2(data.title);
    this.collapsed_subtitle = new Text2(data.collapsedSubtitle);
    this.expanded_subtitle = new Text2(data.expandedSubtitle);
    this.owner = parser_exports.parseItem(data.owner);
    this.description = new Text2(data.description);
    this.video_id = data.videoId;
    this.date = new Text2(data.dateText);
  }
};
__name(_SlimVideoMetadata, "SlimVideoMetadata");
__publicField(_SlimVideoMetadata, "type", "SlimVideoMetadata");
var SlimVideoMetadata = _SlimVideoMetadata;

// dist/src/parser/classes/StartAt.js
var _StartAt = class _StartAt extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "start_at_option_label");
    this.start_at_option_label = new Text2(data.startAtOptionLabel);
  }
};
__name(_StartAt, "StartAt");
__publicField(_StartAt, "type", "StartAt");
var StartAt = _StartAt;

// dist/src/parser/classes/Tabbed.js
var _Tabbed = class _Tabbed extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parse(data);
  }
};
__name(_Tabbed, "Tabbed");
__publicField(_Tabbed, "type", "Tabbed");
var Tabbed = _Tabbed;

// dist/src/parser/classes/TabbedSearchResults.js
var _TabbedSearchResults = class _TabbedSearchResults extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "tabs");
    this.tabs = parser_exports.parseArray(data.tabs, Tab);
  }
};
__name(_TabbedSearchResults, "TabbedSearchResults");
__publicField(_TabbedSearchResults, "type", "TabbedSearchResults");
var TabbedSearchResults = _TabbedSearchResults;

// dist/src/parser/classes/TextHeader.js
var _TextHeader = class _TextHeader extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "title");
    __publicField(this, "style");
    this.title = new Text2(data.title);
    this.style = data.style;
  }
};
__name(_TextHeader, "TextHeader");
__publicField(_TextHeader, "type", "TextHeader");
var TextHeader = _TextHeader;

// dist/src/parser/classes/ThirdPartyShareTargetSection.js
var _ThirdPartyShareTargetSection = class _ThirdPartyShareTargetSection extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "share_targets");
    this.share_targets = parser_exports.parseArray(data.shareTargets, ShareTarget);
  }
};
__name(_ThirdPartyShareTargetSection, "ThirdPartyShareTargetSection");
__publicField(_ThirdPartyShareTargetSection, "type", "ThirdPartyShareTargetSection");
var ThirdPartyShareTargetSection = _ThirdPartyShareTargetSection;

// dist/src/parser/classes/ThumbnailLandscapePortrait.js
var _ThumbnailLandscapePortrait = class _ThumbnailLandscapePortrait extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "landscape");
    __publicField(this, "portrait");
    this.landscape = Thumbnail.fromResponse(data.landscape);
    this.portrait = Thumbnail.fromResponse(data.portrait);
  }
};
__name(_ThumbnailLandscapePortrait, "ThumbnailLandscapePortrait");
__publicField(_ThumbnailLandscapePortrait, "type", "ThumbnailLandscapePortrait");
var ThumbnailLandscapePortrait = _ThumbnailLandscapePortrait;

// dist/src/parser/classes/ThumbnailOverlayEndorsement.js
var _ThumbnailOverlayEndorsement = class _ThumbnailOverlayEndorsement extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data.text).toString();
  }
};
__name(_ThumbnailOverlayEndorsement, "ThumbnailOverlayEndorsement");
__publicField(_ThumbnailOverlayEndorsement, "type", "ThumbnailOverlayEndorsement");
var ThumbnailOverlayEndorsement = _ThumbnailOverlayEndorsement;

// dist/src/parser/classes/ThumbnailOverlayHoverText.js
var _ThumbnailOverlayHoverText = class _ThumbnailOverlayHoverText extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    this.text = new Text2(data.text);
    this.icon_type = data.icon.iconType;
  }
};
__name(_ThumbnailOverlayHoverText, "ThumbnailOverlayHoverText");
__publicField(_ThumbnailOverlayHoverText, "type", "ThumbnailOverlayHoverText");
var ThumbnailOverlayHoverText = _ThumbnailOverlayHoverText;

// dist/src/parser/classes/ThumbnailOverlayInlineUnplayable.js
var _ThumbnailOverlayInlineUnplayable = class _ThumbnailOverlayInlineUnplayable extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    this.text = new Text2(data.text).toString();
    this.icon_type = data.icon.iconType;
  }
};
__name(_ThumbnailOverlayInlineUnplayable, "ThumbnailOverlayInlineUnplayable");
__publicField(_ThumbnailOverlayInlineUnplayable, "type", "ThumbnailOverlayInlineUnplayable");
var ThumbnailOverlayInlineUnplayable = _ThumbnailOverlayInlineUnplayable;

// dist/src/parser/classes/ThumbnailOverlayLoadingPreview.js
var _ThumbnailOverlayLoadingPreview = class _ThumbnailOverlayLoadingPreview extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data.text);
  }
};
__name(_ThumbnailOverlayLoadingPreview, "ThumbnailOverlayLoadingPreview");
__publicField(_ThumbnailOverlayLoadingPreview, "type", "ThumbnailOverlayLoadingPreview");
var ThumbnailOverlayLoadingPreview = _ThumbnailOverlayLoadingPreview;

// dist/src/parser/classes/ThumbnailOverlayNowPlaying.js
var _ThumbnailOverlayNowPlaying = class _ThumbnailOverlayNowPlaying extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data.text).toString();
  }
};
__name(_ThumbnailOverlayNowPlaying, "ThumbnailOverlayNowPlaying");
__publicField(_ThumbnailOverlayNowPlaying, "type", "ThumbnailOverlayNowPlaying");
var ThumbnailOverlayNowPlaying = _ThumbnailOverlayNowPlaying;

// dist/src/parser/classes/ThumbnailOverlayPinking.js
var _ThumbnailOverlayPinking = class _ThumbnailOverlayPinking extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "hack");
    this.hack = data.hack;
  }
};
__name(_ThumbnailOverlayPinking, "ThumbnailOverlayPinking");
__publicField(_ThumbnailOverlayPinking, "type", "ThumbnailOverlayPinking");
var ThumbnailOverlayPinking = _ThumbnailOverlayPinking;

// dist/src/parser/classes/ThumbnailOverlayPlaybackStatus.js
var _ThumbnailOverlayPlaybackStatus = class _ThumbnailOverlayPlaybackStatus extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "texts");
    this.texts = data.texts.map((text) => new Text2(text));
  }
};
__name(_ThumbnailOverlayPlaybackStatus, "ThumbnailOverlayPlaybackStatus");
__publicField(_ThumbnailOverlayPlaybackStatus, "type", "ThumbnailOverlayPlaybackStatus");
var ThumbnailOverlayPlaybackStatus = _ThumbnailOverlayPlaybackStatus;

// dist/src/parser/classes/ThumbnailOverlayResumePlayback.js
var _ThumbnailOverlayResumePlayback = class _ThumbnailOverlayResumePlayback extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "percent_duration_watched");
    this.percent_duration_watched = data.percentDurationWatched;
  }
};
__name(_ThumbnailOverlayResumePlayback, "ThumbnailOverlayResumePlayback");
__publicField(_ThumbnailOverlayResumePlayback, "type", "ThumbnailOverlayResumePlayback");
var ThumbnailOverlayResumePlayback = _ThumbnailOverlayResumePlayback;

// dist/src/parser/classes/ThumbnailOverlaySidePanel.js
var _ThumbnailOverlaySidePanel = class _ThumbnailOverlaySidePanel extends YTNode {
  constructor(data) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    this.text = new Text2(data.text);
    this.icon_type = data.icon.iconType;
  }
};
__name(_ThumbnailOverlaySidePanel, "ThumbnailOverlaySidePanel");
__publicField(_ThumbnailOverlaySidePanel, "type", "ThumbnailOverlaySidePanel");
var ThumbnailOverlaySidePanel = _ThumbnailOverlaySide