import type { ZodType } from 'zod';
import { OpenAPIDefinitions, RouteConfig } from './openapi-registry';
import { ComponentsObject, OpenAPIObject, PathItemObject, ReferenceObject, SchemaObject, ZodNumericCheck } from './types';
import { UnionPreferredType } from './zod-extensions';
declare const openApiVersions: readonly ["3.0.0", "3.0.1", "3.0.2", "3.0.3", "3.1.0"];
export type OpenApiVersion = typeof openApiVersions[number];
export interface OpenApiVersionSpecifics {
    get nullType(): any;
    mapNullableOfArray(objects: any[], isNullable: boolean): any[];
    mapNullableType(type: NonNullable<SchemaObject['type']> | undefined, isNullable: boolean): Pick<SchemaObject, 'type' | 'nullable'>;
    mapNullableOfRef(ref: ReferenceObject, isNullable: boolean): ReferenceObject | {
        allOf: (ReferenceObject | {
            nullable: boolean;
        })[];
    } | {
        oneOf: (ReferenceObject | {
            type: 'null';
        })[];
    };
    mapTupleItems(schemas: (SchemaObject | ReferenceObject)[]): {
        items?: SchemaObject | ReferenceObject;
        minItems?: number;
        maxItems?: number;
        prefixItems?: (SchemaObject | ReferenceObject)[];
    };
    getNumberChecks(checks: ZodNumericCheck[]): any;
}
export interface OpenApiGeneratorOptions {
    unionPreferredType?: UnionPreferredType;
    sortComponents?: 'alphabetically';
}
export type SchemaRefValue = SchemaObject | ReferenceObject | 'pending';
export type SchemaRefs = Record<string, SchemaRefValue>;
export declare class OpenAPIGenerator {
    private definitions;
    private versionSpecifics;
    private options?;
    private schemaRefs;
    private paramRefs;
    private pathRefs;
    private rawComponents;
    private openApiTransformer;
    constructor(definitions: (OpenAPIDefinitions | ZodType)[], versionSpecifics: OpenApiVersionSpecifics, options?: OpenApiGeneratorOptions | undefined);
    generateDocumentData(): {
        components: ComponentsObject;
        paths: Record<string, PathItemObject>;
    };
    generateComponents(): Pick<OpenAPIObject, 'components'>;
    private buildComponents;
    private isNotPendingRefEntry;
    private get filteredSchemaRefs();
    private sortDefinitions;
    private generateSingle;
    private generateParameterDefinition;
    private getParameterRef;
    private generateInlineParameters;
    private generateSimpleParameter;
    private generateParameter;
    private generateSchemaWithMetadata;
    /**
     * Same as above but applies nullable
     */
    private constructReferencedOpenAPISchema;
    /**
     * Generates an OpenAPI SchemaObject or a ReferenceObject with all the provided metadata applied
     */
    private generateSimpleSchema;
    /**
     * Same as `generateSchema` but if the new schema is added into the
     * referenced schemas, it would return a ReferenceObject and not the
     * whole result.
     *
     * Should be used for nested objects, arrays, etc.
     */
    private generateSchemaWithRef;
    private generateSchemaRef;
    private getRequestBody;
    private getParameters;
    private cleanParameter;
    generatePath(route: RouteConfig): PathItemObject;
    private generateSingleRoute;
    private getResponse;
    private isReferenceObject;
    private getResponseHeaders;
    private getBodyContent;
    private toOpenAPISchema;
}
export {};
