import { QUOTEMARK, BACKSLASH } from '@bbob/plugin-helper';
export class CharGrabber {
    skip(num = 1, silent) {
        this.c.pos += num;
        if (this.o && this.o.onSkip && !silent) {
            this.o.onSkip();
        }
    }
    hasNext() {
        return this.c.len > this.c.pos;
    }
    getCurr() {
        if (typeof this.s[this.c.pos] === 'undefined') {
            return '';
        }
        return this.s[this.c.pos];
    }
    getPos() {
        return this.c.pos;
    }
    getLength() {
        return this.c.len;
    }
    getRest() {
        return this.s.substring(this.c.pos);
    }
    getNext() {
        const nextPos = this.c.pos + 1;
        return nextPos <= this.s.length - 1 ? this.s[nextPos] : null;
    }
    getPrev() {
        const prevPos = this.c.pos - 1;
        if (typeof this.s[prevPos] === 'undefined') {
            return null;
        }
        return this.s[prevPos];
    }
    isLast() {
        return this.c.pos === this.c.len;
    }
    includes(val) {
        return this.s.indexOf(val, this.c.pos) >= 0;
    }
    grabWhile(condition, silent) {
        let start = 0;
        if (this.hasNext()) {
            start = this.c.pos;
            while(this.hasNext() && condition(this.getCurr())){
                this.skip(1, silent);
            }
        }
        return this.s.substring(start, this.c.pos);
    }
    grabN(num = 0) {
        return this.s.substring(this.c.pos, this.c.pos + num);
    }
    /**
   * Grabs rest of string until it find a char
   */ substrUntilChar(char) {
        const { pos } = this.c;
        const idx = this.s.indexOf(char, pos);
        return idx >= 0 ? this.s.substring(pos, idx) : '';
    }
    constructor(source, options = {}){
        this.s = source;
        this.c = {
            pos: 0,
            len: source.length
        };
        this.o = options;
    }
}
/**
 * Creates a grabber wrapper for source string, that helps to iterate over string char by char
 */ export const createCharGrabber = (source, options)=>new CharGrabber(source, options);
/**
 * Trims string from start and end by char
 * @example
 *  trimChar('*hello*', '*') ==> 'hello'
 */ export const trimChar = (str, charToRemove)=>{
    while(str.charAt(0) === charToRemove){
        // eslint-disable-next-line no-param-reassign
        str = str.substring(1);
    }
    while(str.charAt(str.length - 1) === charToRemove){
        // eslint-disable-next-line no-param-reassign
        str = str.substring(0, str.length - 1);
    }
    return str;
};
/**
 * Unquotes \" to "
 */ export const unquote = (str)=>str.replace(BACKSLASH + QUOTEMARK, QUOTEMARK);
