type AnnotationRequest = {
    bold?: boolean;
    italic?: boolean;
    strikethrough?: boolean;
    underline?: boolean;
    code?: boolean;
    color?: ApiColor;
};
type AnnotationResponse = {
    bold: boolean;
    italic: boolean;
    strikethrough: boolean;
    underline: boolean;
    code: boolean;
    color: ApiColor;
};
/**
 * One of: `default`, `gray`, `brown`, `orange`, `yellow`, `green`, `blue`, `purple`,
 * `pink`, `red`, `default_background`, `gray_background`, `brown_background`,
 * `orange_background`, `yellow_background`, `green_background`, `blue_background`,
 * `purple_background`, `pink_background`, `red_background`
 */
type ApiColor = "default" | "gray" | "brown" | "orange" | "yellow" | "green" | "blue" | "purple" | "pink" | "red" | "default_background" | "gray_background" | "brown_background" | "orange_background" | "yellow_background" | "green_background" | "blue_background" | "purple_background" | "pink_background" | "red_background";
type ArrayBasedPropertyValueResponse = TitleArrayBasedPropertyValueResponse | RichTextArrayBasedPropertyValueResponse | PeopleArrayBasedPropertyValueResponse | RelationArrayBasedPropertyValueResponse;
type ArrayPartialRollupValueResponse = {
    type: "array";
    array: Array<SimpleOrArrayPropertyValueResponse>;
};
export type AudioBlockObjectResponse = {
    type: "audio";
    audio: MediaContentWithFileAndCaptionResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type BlockIdCommentParentResponse = {
    type: "block_id";
    block_id: IdResponse;
};
type BlockIdParentForBlockBasedObjectResponse = {
    type: "block_id";
    block_id: IdResponse;
};
export type BlockObjectRequest = {
    embed: MediaContentWithUrlAndCaptionRequest;
    type?: "embed";
    object?: "block";
} | {
    bookmark: MediaContentWithUrlAndCaptionRequest;
    type?: "bookmark";
    object?: "block";
} | {
    image: MediaContentWithFileAndCaptionRequest;
    type?: "image";
    object?: "block";
} | {
    video: MediaContentWithFileAndCaptionRequest;
    type?: "video";
    object?: "block";
} | {
    pdf: MediaContentWithFileAndCaptionRequest;
    type?: "pdf";
    object?: "block";
} | {
    file: MediaContentWithFileNameAndCaptionRequest;
    type?: "file";
    object?: "block";
} | {
    audio: MediaContentWithFileAndCaptionRequest;
    type?: "audio";
    object?: "block";
} | {
    code: {
        rich_text: Array<RichTextItemRequest>;
        language: LanguageRequest;
        caption?: Array<RichTextItemRequest>;
    };
    type?: "code";
    object?: "block";
} | {
    equation: ContentWithExpressionRequest;
    type?: "equation";
    object?: "block";
} | {
    divider: EmptyObject;
    type?: "divider";
    object?: "block";
} | {
    breadcrumb: EmptyObject;
    type?: "breadcrumb";
    object?: "block";
} | {
    table_of_contents: {
        color?: ApiColor;
    };
    type?: "table_of_contents";
    object?: "block";
} | {
    link_to_page: {
        page_id: IdRequest;
        type?: "page_id";
    } | {
        database_id: IdRequest;
        type?: "database_id";
    } | {
        comment_id: IdRequest;
        type?: "comment_id";
    };
    type?: "link_to_page";
    object?: "block";
} | {
    table_row: ContentWithTableRowRequest;
    type?: "table_row";
    object?: "block";
} | {
    table: TableRequestWithTableRowChildren;
    type?: "table";
    object?: "block";
} | {
    column_list: ColumnListRequest;
    type?: "column_list";
    object?: "block";
} | {
    column: ColumnWithChildrenRequest;
    type?: "column";
    object?: "block";
} | {
    heading_1: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        is_toggleable?: boolean;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "heading_1";
    object?: "block";
} | {
    heading_2: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        is_toggleable?: boolean;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "heading_2";
    object?: "block";
} | {
    heading_3: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        is_toggleable?: boolean;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "heading_3";
    object?: "block";
} | {
    paragraph: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "paragraph";
    object?: "block";
} | {
    bulleted_list_item: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "bulleted_list_item";
    object?: "block";
} | {
    numbered_list_item: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "numbered_list_item";
    object?: "block";
} | {
    quote: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "quote";
    object?: "block";
} | {
    to_do: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
        checked?: boolean;
    };
    type?: "to_do";
    object?: "block";
} | {
    toggle: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "toggle";
    object?: "block";
} | {
    template: {
        rich_text: Array<RichTextItemRequest>;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "template";
    object?: "block";
} | {
    callout: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
        icon?: PageIconRequest;
    };
    type?: "callout";
    object?: "block";
} | {
    synced_block: {
        synced_from: {
            block_id: IdRequest;
            type?: "block_id";
        } | null;
        children?: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    };
    type?: "synced_block";
    object?: "block";
};
export type BlockObjectRequestWithoutChildren = {
    embed: MediaContentWithUrlAndCaptionRequest;
    type?: "embed";
    object?: "block";
} | {
    bookmark: MediaContentWithUrlAndCaptionRequest;
    type?: "bookmark";
    object?: "block";
} | {
    image: MediaContentWithFileAndCaptionRequest;
    type?: "image";
    object?: "block";
} | {
    video: MediaContentWithFileAndCaptionRequest;
    type?: "video";
    object?: "block";
} | {
    pdf: MediaContentWithFileAndCaptionRequest;
    type?: "pdf";
    object?: "block";
} | {
    file: MediaContentWithFileNameAndCaptionRequest;
    type?: "file";
    object?: "block";
} | {
    audio: MediaContentWithFileAndCaptionRequest;
    type?: "audio";
    object?: "block";
} | {
    code: {
        rich_text: Array<RichTextItemRequest>;
        language: LanguageRequest;
        caption?: Array<RichTextItemRequest>;
    };
    type?: "code";
    object?: "block";
} | {
    equation: ContentWithExpressionRequest;
    type?: "equation";
    object?: "block";
} | {
    divider: EmptyObject;
    type?: "divider";
    object?: "block";
} | {
    breadcrumb: EmptyObject;
    type?: "breadcrumb";
    object?: "block";
} | {
    table_of_contents: {
        color?: ApiColor;
    };
    type?: "table_of_contents";
    object?: "block";
} | {
    link_to_page: {
        page_id: IdRequest;
        type?: "page_id";
    } | {
        database_id: IdRequest;
        type?: "database_id";
    } | {
        comment_id: IdRequest;
        type?: "comment_id";
    };
    type?: "link_to_page";
    object?: "block";
} | {
    table_row: ContentWithTableRowRequest;
    type?: "table_row";
    object?: "block";
} | {
    heading_1: HeaderContentWithRichTextAndColorRequest;
    type?: "heading_1";
    object?: "block";
} | {
    heading_2: HeaderContentWithRichTextAndColorRequest;
    type?: "heading_2";
    object?: "block";
} | {
    heading_3: HeaderContentWithRichTextAndColorRequest;
    type?: "heading_3";
    object?: "block";
} | {
    paragraph: ContentWithRichTextAndColorRequest;
    type?: "paragraph";
    object?: "block";
} | {
    bulleted_list_item: ContentWithRichTextAndColorRequest;
    type?: "bulleted_list_item";
    object?: "block";
} | {
    numbered_list_item: ContentWithRichTextAndColorRequest;
    type?: "numbered_list_item";
    object?: "block";
} | {
    quote: ContentWithRichTextAndColorRequest;
    type?: "quote";
    object?: "block";
} | {
    to_do: {
        rich_text: Array<RichTextItemRequest>;
        checked?: boolean;
        color?: ApiColor;
    };
    type?: "to_do";
    object?: "block";
} | {
    toggle: ContentWithRichTextAndColorRequest;
    type?: "toggle";
    object?: "block";
} | {
    template: ContentWithRichTextRequest;
    type?: "template";
    object?: "block";
} | {
    callout: {
        rich_text: Array<RichTextItemRequest>;
        icon?: PageIconRequest;
        color?: ApiColor;
    };
    type?: "callout";
    object?: "block";
} | {
    synced_block: {
        synced_from: {
            block_id: IdRequest;
            type?: "block_id";
        } | null;
    };
    type?: "synced_block";
    object?: "block";
};
export type BlockObjectResponse = ParagraphBlockObjectResponse | Heading1BlockObjectResponse | Heading2BlockObjectResponse | Heading3BlockObjectResponse | BulletedListItemBlockObjectResponse | NumberedListItemBlockObjectResponse | QuoteBlockObjectResponse | ToDoBlockObjectResponse | ToggleBlockObjectResponse | TemplateBlockObjectResponse | SyncedBlockBlockObjectResponse | ChildPageBlockObjectResponse | ChildDatabaseBlockObjectResponse | EquationBlockObjectResponse | CodeBlockObjectResponse | CalloutBlockObjectResponse | DividerBlockObjectResponse | BreadcrumbBlockObjectResponse | TableOfContentsBlockObjectResponse | ColumnListBlockObjectResponse | ColumnBlockObjectResponse | LinkToPageBlockObjectResponse | TableBlockObjectResponse | TableRowBlockObjectResponse | EmbedBlockObjectResponse | BookmarkBlockObjectResponse | ImageBlockObjectResponse | VideoBlockObjectResponse | PdfBlockObjectResponse | FileBlockObjectResponse | AudioBlockObjectResponse | LinkPreviewBlockObjectResponse | UnsupportedBlockObjectResponse;
type BlockObjectWithSingleLevelOfChildrenRequest = {
    embed: MediaContentWithUrlAndCaptionRequest;
    type?: "embed";
    object?: "block";
} | {
    bookmark: MediaContentWithUrlAndCaptionRequest;
    type?: "bookmark";
    object?: "block";
} | {
    image: MediaContentWithFileAndCaptionRequest;
    type?: "image";
    object?: "block";
} | {
    video: MediaContentWithFileAndCaptionRequest;
    type?: "video";
    object?: "block";
} | {
    pdf: MediaContentWithFileAndCaptionRequest;
    type?: "pdf";
    object?: "block";
} | {
    file: MediaContentWithFileNameAndCaptionRequest;
    type?: "file";
    object?: "block";
} | {
    audio: MediaContentWithFileAndCaptionRequest;
    type?: "audio";
    object?: "block";
} | {
    code: {
        rich_text: Array<RichTextItemRequest>;
        language: LanguageRequest;
        caption?: Array<RichTextItemRequest>;
    };
    type?: "code";
    object?: "block";
} | {
    equation: ContentWithExpressionRequest;
    type?: "equation";
    object?: "block";
} | {
    divider: EmptyObject;
    type?: "divider";
    object?: "block";
} | {
    breadcrumb: EmptyObject;
    type?: "breadcrumb";
    object?: "block";
} | {
    table_of_contents: {
        color?: ApiColor;
    };
    type?: "table_of_contents";
    object?: "block";
} | {
    link_to_page: {
        page_id: IdRequest;
        type?: "page_id";
    } | {
        database_id: IdRequest;
        type?: "database_id";
    } | {
        comment_id: IdRequest;
        type?: "comment_id";
    };
    type?: "link_to_page";
    object?: "block";
} | {
    table_row: ContentWithTableRowRequest;
    type?: "table_row";
    object?: "block";
} | {
    heading_1: HeaderContentWithSingleLevelOfChildrenRequest;
    type?: "heading_1";
    object?: "block";
} | {
    heading_2: HeaderContentWithSingleLevelOfChildrenRequest;
    type?: "heading_2";
    object?: "block";
} | {
    heading_3: HeaderContentWithSingleLevelOfChildrenRequest;
    type?: "heading_3";
    object?: "block";
} | {
    paragraph: ContentWithSingleLevelOfChildrenRequest;
    type?: "paragraph";
    object?: "block";
} | {
    bulleted_list_item: ContentWithSingleLevelOfChildrenRequest;
    type?: "bulleted_list_item";
    object?: "block";
} | {
    numbered_list_item: ContentWithSingleLevelOfChildrenRequest;
    type?: "numbered_list_item";
    object?: "block";
} | {
    quote: ContentWithSingleLevelOfChildrenRequest;
    type?: "quote";
    object?: "block";
} | {
    table: TableRequestWithTableRowChildren;
    type?: "table";
    object?: "block";
} | {
    to_do: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectRequestWithoutChildren>;
        checked?: boolean;
    };
    type?: "to_do";
    object?: "block";
} | {
    toggle: ContentWithSingleLevelOfChildrenRequest;
    type?: "toggle";
    object?: "block";
} | {
    template: {
        rich_text: Array<RichTextItemRequest>;
        children?: Array<BlockObjectRequestWithoutChildren>;
    };
    type?: "template";
    object?: "block";
} | {
    callout: {
        rich_text: Array<RichTextItemRequest>;
        color?: ApiColor;
        children?: Array<BlockObjectRequestWithoutChildren>;
        icon?: PageIconRequest;
    };
    type?: "callout";
    object?: "block";
} | {
    synced_block: {
        synced_from: {
            block_id: IdRequest;
            type?: "block_id";
        } | null;
        children?: Array<BlockObjectRequestWithoutChildren>;
    };
    type?: "synced_block";
    object?: "block";
};
export type BookmarkBlockObjectResponse = {
    type: "bookmark";
    bookmark: MediaContentWithUrlAndCaptionResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type BooleanFormulaPropertyResponse = {
    type: "boolean";
    boolean: boolean | null;
};
type BooleanFormulaPropertyValueResponse = {
    type: "boolean";
    boolean: boolean | null;
};
type BotInfoResponse = {
    owner: {
        type: "user";
        user: {
            id: IdResponse;
            object: "user";
            name: string | null;
            avatar_url: string | null;
            type: "person";
            person: {
                email?: string;
            };
        } | PartialUserObjectResponse;
    } | {
        type: "workspace";
        workspace: true;
    };
    workspace_id: string;
    workspace_limits: {
        max_file_upload_size_in_bytes: number;
    };
    workspace_name: string | null;
};
export type BotUserObjectResponse = {
    type: "bot";
    bot: EmptyObject | BotInfoResponse;
};
export type BreadcrumbBlockObjectResponse = {
    type: "breadcrumb";
    breadcrumb: EmptyObject;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type BulletedListItemBlockObjectResponse = {
    type: "bulleted_list_item";
    bulleted_list_item: ContentWithRichTextAndColorResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type ButtonPropertyConfigurationRequest = {
    type?: "button";
    button: EmptyObject;
};
export type ButtonPropertyItemObjectResponse = {
    type: "button";
    button: EmptyObject;
    object: "property_item";
    id: string;
};
type ButtonSimplePropertyValueResponse = {
    type: "button";
    button: EmptyObject;
};
export type CalloutBlockObjectResponse = {
    type: "callout";
    callout: {
        rich_text: Array<RichTextItemResponse>;
        color: ApiColor;
        icon: PageIconResponse | null;
    };
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type CheckboxDatabasePropertyConfigResponse = {
    type: "checkbox";
    checkbox: EmptyObject;
};
type CheckboxPropertyConfigurationRequest = {
    type?: "checkbox";
    checkbox: EmptyObject;
};
type CheckboxPropertyFilter = {
    equals: boolean;
} | {
    does_not_equal: boolean;
};
export type CheckboxPropertyItemObjectResponse = {
    type: "checkbox";
    checkbox: boolean;
    object: "property_item";
    id: string;
};
type CheckboxSimplePropertyValueResponse = {
    type: "checkbox";
    checkbox: boolean;
};
export type ChildDatabaseBlockObjectResponse = {
    type: "child_database";
    child_database: TitleObjectResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type ChildPageBlockObjectResponse = {
    type: "child_page";
    child_page: TitleObjectResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type CodeBlockObjectResponse = {
    type: "code";
    code: {
        rich_text: Array<RichTextItemResponse>;
        caption: Array<RichTextItemResponse>;
        language: LanguageRequest;
    };
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type ColumnBlockObjectResponse = {
    type: "column";
    column: ColumnResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type ColumnBlockWithChildrenRequest = {
    column: ColumnWithChildrenRequest;
    type?: "column";
    object?: "block";
};
export type ColumnListBlockObjectResponse = {
    type: "column_list";
    column_list: EmptyObject;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type ColumnListRequest = {
    children: Array<ColumnBlockWithChildrenRequest>;
};
type ColumnResponse = {
    width_ratio?: number;
};
type ColumnWithChildrenRequest = {
    children: Array<BlockObjectWithSingleLevelOfChildrenRequest>;
    width_ratio?: number;
};
export type CommentObjectResponse = {
    object: "comment";
    id: IdResponse;
    parent: CommentParentResponse;
    discussion_id: IdResponse;
    created_time: string;
    last_edited_time: string;
    created_by: PartialUserObjectResponse;
    rich_text: Array<RichTextItemResponse>;
    display_name: {
        type: "custom" | "user" | "integration";
        resolved_name: string | null;
    };
    attachments?: Array<{
        category: "audio" | "image" | "pdf" | "productivity" | "video";
        file: InternalFileResponse;
    }>;
};
type CommentParentResponse = PageIdCommentParentResponse | BlockIdCommentParentResponse;
type ContentPositionSchema = {
    type: "after_block";
    after_block: {
        id: IdRequest;
    };
} | {
    type: "start";
} | {
    type: "end";
};
type ContentWithExpressionRequest = {
    expression: string;
};
type ContentWithRichTextAndColorAndListResponse = {
    rich_text: Array<RichTextItemResponse>;
    color: ApiColor;
    list_start_index?: number;
    list_format?: NumberedListFormat;
};
type ContentWithRichTextAndColorRequest = {
    rich_text: Array<RichTextItemRequest>;
    color?: ApiColor;
};
type ContentWithRichTextAndColorResponse = {
    rich_text: Array<RichTextItemResponse>;
    color: ApiColor;
};
type ContentWithRichTextRequest = {
    rich_text: Array<RichTextItemRequest>;
};
type ContentWithSingleLevelOfChildrenRequest = {
    rich_text: Array<RichTextItemRequest>;
    color?: ApiColor;
    children?: Array<BlockObjectRequestWithoutChildren>;
};
type ContentWithTableResponse = {
    has_column_header: boolean;
    has_row_header: boolean;
    table_width: number;
};
type ContentWithTableRowRequest = {
    cells: Array<Array<RichTextItemRequest>>;
};
type ContentWithTableRowResponse = {
    cells: Array<Array<RichTextItemResponse>>;
};
type CreatedByDatabasePropertyConfigResponse = {
    type: "created_by";
    created_by: EmptyObject;
};
type CreatedByPropertyConfigurationRequest = {
    type?: "created_by";
    created_by: EmptyObject;
};
export type CreatedByPropertyItemObjectResponse = {
    type: "created_by";
    created_by: PartialUserObjectResponse | UserObjectResponse;
    object: "property_item";
    id: string;
};
type CreatedBySimplePropertyValueResponse = {
    type: "created_by";
    created_by: UserValueResponse;
};
type CreatedTimeDatabasePropertyConfigResponse = {
    type: "created_time";
    created_time: EmptyObject;
};
type CreatedTimePropertyConfigurationRequest = {
    type?: "created_time";
    created_time: EmptyObject;
};
export type CreatedTimePropertyItemObjectResponse = {
    type: "created_time";
    created_time: string;
    object: "property_item";
    id: string;
};
type CreatedTimeSimplePropertyValueResponse = {
    type: "created_time";
    created_time: string;
};
type CustomEmojiPageIconRequest = {
    type?: "custom_emoji";
    custom_emoji: {
        id: IdRequest;
        name?: string;
        url?: string;
    };
};
type CustomEmojiPageIconResponse = {
    type: "custom_emoji";
    custom_emoji: CustomEmojiResponse;
};
type CustomEmojiResponse = {
    id: IdResponse;
    name: string;
    url: string;
};
export type DataSourceObjectResponse = {
    object: "data_source";
    id: IdResponse;
    title: Array<RichTextItemResponse>;
    description: Array<RichTextItemResponse>;
    parent: ParentOfDataSourceResponse;
    database_parent: ParentOfDatabaseResponse;
    is_inline: boolean;
    archived: boolean;
    in_trash: boolean;
    created_time: string;
    last_edited_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_by: PartialUserObjectResponse;
    properties: Record<string, DatabasePropertyConfigResponse>;
    icon: PageIconResponse | null;
    cover: PageCoverResponse | null;
    url: string;
    public_url: string | null;
};
type DataSourceParentResponse = {
    type: "data_source_id";
    data_source_id: IdResponse;
    database_id: IdResponse;
};
type DataSourceReferenceResponse = {
    id: IdResponse;
    name: string;
};
export type DatabaseObjectResponse = {
    object: "database";
    id: IdResponse;
    title: Array<RichTextItemResponse>;
    description: Array<RichTextItemResponse>;
    parent: ParentOfDatabaseResponse;
    is_inline: boolean;
    in_trash: boolean;
    is_locked: boolean;
    created_time: string;
    last_edited_time: string;
    data_sources: Array<DataSourceReferenceResponse>;
    icon: PageIconResponse | null;
    cover: PageCoverResponse | null;
    url: string;
    public_url: string | null;
};
type DatabaseParentResponse = {
    type: "database_id";
    database_id: IdResponse;
};
type DatabasePropertyConfigResponse = DatabasePropertyConfigResponseCommon & (NumberDatabasePropertyConfigResponse | FormulaDatabasePropertyConfigResponse | SelectDatabasePropertyConfigResponse | MultiSelectDatabasePropertyConfigResponse | StatusDatabasePropertyConfigResponse | RelationDatabasePropertyConfigResponse | RollupDatabasePropertyConfigResponse | UniqueIdDatabasePropertyConfigResponse | TitleDatabasePropertyConfigResponse | RichTextDatabasePropertyConfigResponse | UrlDatabasePropertyConfigResponse | PeopleDatabasePropertyConfigResponse | FilesDatabasePropertyConfigResponse | EmailDatabasePropertyConfigResponse | PhoneNumberDatabasePropertyConfigResponse | DateDatabasePropertyConfigResponse | CheckboxDatabasePropertyConfigResponse | CreatedByDatabasePropertyConfigResponse | CreatedTimeDatabasePropertyConfigResponse | LastEditedByDatabasePropertyConfigResponse | LastEditedTimeDatabasePropertyConfigResponse);
type DatabasePropertyConfigResponseCommon = {
    id: string;
    name: string;
    description: PropertyDescriptionRequest | null;
};
type DatabasePropertyRelationConfigResponse = DatabasePropertyRelationConfigResponseCommon & (SinglePropertyDatabasePropertyRelationConfigResponse | DualPropertyDatabasePropertyRelationConfigResponse);
type DatabasePropertyRelationConfigResponseCommon = {
    database_id: IdResponse;
    data_source_id: IdResponse;
};
type DateDatabasePropertyConfigResponse = {
    type: "date";
    date: EmptyObject;
};
type DateFormulaPropertyResponse = {
    type: "date";
    date: DateResponse | null;
};
type DateFormulaPropertyValueResponse = {
    type: "date";
    date: DateResponse | null;
};
type DatePartialRollupValueResponse = {
    type: "date";
    date: DateResponse | null;
};
type DatePropertyConfigurationRequest = {
    type?: "date";
    date: EmptyObject;
};
type DatePropertyFilter = {
    equals: string;
} | {
    before: string;
} | {
    after: string;
} | {
    on_or_before: string;
} | {
    on_or_after: string;
} | {
    this_week: EmptyObject;
} | {
    past_week: EmptyObject;
} | {
    past_month: EmptyObject;
} | {
    past_year: EmptyObject;
} | {
    next_week: EmptyObject;
} | {
    next_month: EmptyObject;
} | {
    next_year: EmptyObject;
} | ExistencePropertyFilter;
export type DatePropertyItemObjectResponse = {
    type: "date";
    date: DateResponse | null;
    object: "property_item";
    id: string;
};
type DateRequest = {
    start: string;
    end?: string | null;
    time_zone?: TimeZoneRequest | null;
};
type DateResponse = {
    start: string;
    end: string | null;
    time_zone: TimeZoneRequest | null;
};
type DateSimplePropertyValueResponse = {
    type: "date";
    date: DateResponse | null;
};
export type DividerBlockObjectResponse = {
    type: "divider";
    divider: EmptyObject;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type DualPropertyDatabasePropertyRelationConfigResponse = {
    type?: "dual_property";
    dual_property: {
        synced_property_id: string;
        synced_property_name: string;
    };
};
type EmailDatabasePropertyConfigResponse = {
    type: "email";
    email: EmptyObject;
};
type EmailPropertyConfigurationRequest = {
    type?: "email";
    email: EmptyObject;
};
export type EmailPropertyItemObjectResponse = {
    type: "email";
    email: string | null;
    object: "property_item";
    id: string;
};
type EmailSimplePropertyValueResponse = {
    type: "email";
    email: string | null;
};
export type EmbedBlockObjectResponse = {
    type: "embed";
    embed: MediaContentWithUrlAndCaptionResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type EmojiPageIconRequest = {
    type?: "emoji";
    emoji: EmojiRequest;
};
type EmojiPageIconResponse = {
    type: "emoji";
    emoji: EmojiRequest;
};
type EmojiRequest = string;
type EmptyObject = Record<string, never>;
export type EquationBlockObjectResponse = {
    type: "equation";
    equation: ExpressionObjectResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type EquationRichTextItemRequest = {
    type?: "equation";
    equation: {
        expression: string;
    };
};
export type EquationRichTextItemResponse = {
    type: "equation";
    equation: {
        expression: string;
    };
};
type ExistencePropertyFilter = {
    is_empty: true;
} | {
    is_not_empty: true;
};
type ExpressionObjectResponse = {
    expression: string;
};
type ExternalFileRequest = {
    url: TextRequest;
};
type ExternalInternalOrExternalFileWithNameResponse = {
    type: "external";
    external: {
        url: string;
    };
};
type ExternalMediaContentWithFileAndCaptionResponse = {
    type: "external";
    external: {
        url: TextRequest;
    };
    caption: Array<RichTextItemResponse>;
};
type ExternalMediaContentWithFileNameAndCaptionResponse = {
    type: "external";
    external: {
        url: TextRequest;
    };
    caption: Array<RichTextItemResponse>;
    name: string;
};
type ExternalPageCoverRequest = {
    type?: "external";
    external: {
        url: string;
    };
};
type ExternalPageCoverResponse = {
    type: "external";
    external: {
        url: string;
    };
};
type ExternalPageIconRequest = {
    type?: "external";
    external: {
        url: string;
    };
};
type ExternalPageIconResponse = {
    type: "external";
    external: {
        url: string;
    };
};
export type FileBlockObjectResponse = {
    type: "file";
    file: MediaContentWithFileNameAndCaptionResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type FileInternalOrExternalFileWithNameResponse = {
    type: "file";
    file: InternalFileResponse;
};
type FileMediaContentWithFileAndCaptionResponse = {
    type: "file";
    file: InternalFileResponse;
    caption: Array<RichTextItemResponse>;
};
type FileMediaContentWithFileNameAndCaptionResponse = {
    type: "file";
    file: InternalFileResponse;
    caption: Array<RichTextItemResponse>;
    name: string;
};
type FilePageCoverResponse = {
    type: "file";
    file: InternalFileResponse;
};
type FilePageIconResponse = {
    type: "file";
    file: InternalFileResponse;
};
type FileUploadIdRequest = {
    id: IdRequest;
};
export type FileUploadObjectResponse = {
    object: "file_upload";
    id: IdResponse;
    created_time: string;
    created_by: {
        id: IdResponse;
        type: "person" | "bot" | "agent";
    };
    last_edited_time: string;
    archived: boolean;
    expiry_time: string | null;
    status: "pending" | "uploaded" | "expired" | "failed";
    filename: string | null;
    content_type: string | null;
    content_length: number | null;
    upload_url?: string;
    complete_url?: string;
    file_import_result?: {
        imported_time: string;
    } & ({
        type: "success";
        success: EmptyObject;
    } | {
        type: "error";
        error: {
            type: "validation_error" | "internal_system_error" | "download_error" | "upload_error";
            code: string;
            message: string;
            parameter: string | null;
            status_code: number | null;
        };
    });
    number_of_parts?: {
        total: number;
        sent: number;
    };
};
type FileUploadPageCoverRequest = {
    type?: "file_upload";
    file_upload: {
        id: string;
    };
};
type FileUploadPageIconRequest = {
    type?: "file_upload";
    file_upload: {
        id: string;
    };
};
type FileUploadWithOptionalNameRequest = {
    file_upload: FileUploadIdRequest;
    type?: "file_upload";
    name?: StringRequest;
};
type FilesDatabasePropertyConfigResponse = {
    type: "files";
    files: EmptyObject;
};
type FilesPropertyConfigurationRequest = {
    type?: "files";
    files: EmptyObject;
};
export type FilesPropertyItemObjectResponse = {
    type: "files";
    files: Array<InternalOrExternalFileWithNameResponse>;
    object: "property_item";
    id: string;
};
type FilesSimplePropertyValueResponse = {
    type: "files";
    files: Array<InternalOrExternalFileWithNameResponse>;
};
type FormulaDatabasePropertyConfigResponse = {
    type: "formula";
    formula: {
        expression: string;
    };
};
type FormulaPropertyConfigurationRequest = {
    type?: "formula";
    formula: {
        expression?: string;
    };
};
type FormulaPropertyFilter = {
    string: TextPropertyFilter;
} | {
    checkbox: CheckboxPropertyFilter;
} | {
    number: NumberPropertyFilter;
} | {
    date: DatePropertyFilter;
};
export type FormulaPropertyItemObjectResponse = {
    type: "formula";
    formula: FormulaPropertyResponse;
    object: "property_item";
    id: string;
};
type FormulaPropertyResponse = StringFormulaPropertyResponse | DateFormulaPropertyResponse | NumberFormulaPropertyResponse | BooleanFormulaPropertyResponse;
type FormulaPropertyValueResponse = BooleanFormulaPropertyValueResponse | DateFormulaPropertyValueResponse | NumberFormulaPropertyValueResponse | StringFormulaPropertyValueResponse;
type FormulaSimplePropertyValueResponse = {
    type: "formula";
    formula: FormulaPropertyValueResponse;
};
type GroupFilterOperatorArray = Array<PropertyOrTimestampFilter | {
    or: PropertyOrTimestampFilterArray;
} | {
    and: PropertyOrTimestampFilterArray;
}>;
type GroupObjectRequest = {
    id: IdRequest;
    name?: string | null;
    object?: "group";
};
export type GroupObjectResponse = {
    id: IdResponse;
    object: "group";
    name: string | null;
};
type HeaderContentWithRichTextAndColorRequest = {
    rich_text: Array<RichTextItemRequest>;
    color?: ApiColor;
    is_toggleable?: boolean;
};
type HeaderContentWithRichTextAndColorResponse = {
    rich_text: Array<RichTextItemResponse>;
    color: ApiColor;
    is_toggleable: boolean;
};
type HeaderContentWithSingleLevelOfChildrenRequest = {
    rich_text: Array<RichTextItemRequest>;
    color?: ApiColor;
    is_toggleable?: boolean;
    children?: Array<BlockObjectRequestWithoutChildren>;
};
export type Heading1BlockObjectResponse = {
    type: "heading_1";
    heading_1: HeaderContentWithRichTextAndColorResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type Heading2BlockObjectResponse = {
    type: "heading_2";
    heading_2: HeaderContentWithRichTextAndColorResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type Heading3BlockObjectResponse = {
    type: "heading_3";
    heading_3: HeaderContentWithRichTextAndColorResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type IdObjectResponse = {
    id: string;
};
type IdRequest = string;
type IdResponse = string;
export type ImageBlockObjectResponse = {
    type: "image";
    image: MediaContentWithFileAndCaptionResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type InitialDataSourceRequest = {
    properties?: Record<string, PropertyConfigurationRequest>;
};
type InternalFileRequest = {
    url: string;
    expiry_time?: string;
};
type InternalFileResponse = {
    url: string;
    expiry_time: string;
};
type InternalOrExternalFileWithNameRequest = {
    file: InternalFileRequest;
    name: StringRequest;
    type?: "file";
} | {
    external: ExternalFileRequest;
    name: StringRequest;
    type?: "external";
};
type InternalOrExternalFileWithNameResponse = InternalOrExternalFileWithNameResponseCommon & (FileInternalOrExternalFileWithNameResponse | ExternalInternalOrExternalFileWithNameResponse);
type InternalOrExternalFileWithNameResponseCommon = {
    name: string;
};
type LanguageRequest = "abap" | "abc" | "agda" | "arduino" | "ascii art" | "assembly" | "bash" | "basic" | "bnf" | "c" | "c#" | "c++" | "clojure" | "coffeescript" | "coq" | "css" | "dart" | "dhall" | "diff" | "docker" | "ebnf" | "elixir" | "elm" | "erlang" | "f#" | "flow" | "fortran" | "gherkin" | "glsl" | "go" | "graphql" | "groovy" | "haskell" | "hcl" | "html" | "idris" | "java" | "javascript" | "json" | "julia" | "kotlin" | "latex" | "less" | "lisp" | "livescript" | "llvm ir" | "lua" | "makefile" | "markdown" | "markup" | "matlab" | "mathematica" | "mermaid" | "nix" | "notion formula" | "objective-c" | "ocaml" | "pascal" | "perl" | "php" | "plain text" | "powershell" | "prolog" | "protobuf" | "purescript" | "python" | "r" | "racket" | "reason" | "ruby" | "rust" | "sass" | "scala" | "scheme" | "scss" | "shell" | "smalltalk" | "solidity" | "sql" | "swift" | "toml" | "typescript" | "vb.net" | "verilog" | "vhdl" | "visual basic" | "webassembly" | "xml" | "yaml" | "java/c/c++/c#";
type LastEditedByDatabasePropertyConfigResponse = {
    type: "last_edited_by";
    last_edited_by: EmptyObject;
};
type LastEditedByPropertyConfigurationRequest = {
    type?: "last_edited_by";
    last_edited_by: EmptyObject;
};
export type LastEditedByPropertyItemObjectResponse = {
    type: "last_edited_by";
    last_edited_by: PartialUserObjectResponse | UserObjectResponse;
    object: "property_item";
    id: string;
};
type LastEditedBySimplePropertyValueResponse = {
    type: "last_edited_by";
    last_edited_by: UserValueResponse;
};
type LastEditedTimeDatabasePropertyConfigResponse = {
    type: "last_edited_time";
    last_edited_time: EmptyObject;
};
type LastEditedTimePropertyConfigurationRequest = {
    type?: "last_edited_time";
    last_edited_time: EmptyObject;
};
export type LastEditedTimePropertyItemObjectResponse = {
    type: "last_edited_time";
    last_edited_time: string;
    object: "property_item";
    id: string;
};
type LastEditedTimeSimplePropertyValueResponse = {
    type: "last_edited_time";
    last_edited_time: string;
};
type LastVisitedTimePropertyConfigurationRequest = {
    type?: "last_visited_time";
    last_visited_time: EmptyObject;
};
type LinkMentionResponse = {
    href: string;
    title?: string;
    description?: string;
    link_author?: string;
    link_provider?: string;
    thumbnail_url?: string;
    icon_url?: string;
    iframe_url?: string;
    height?: number;
    padding?: number;
    padding_top?: number;
};
export type LinkPreviewBlockObjectResponse = {
    type: "link_preview";
    link_preview: MediaContentWithUrlResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type LinkPreviewMentionResponse = {
    url: string;
};
export type LinkToPageBlockObjectResponse = {
    type: "link_to_page";
    link_to_page: {
        type: "page_id";
        page_id: IdRequest;
    } | {
        type: "database_id";
        database_id: IdRequest;
    } | {
        type: "comment_id";
        comment_id: IdRequest;
    };
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type LocationPropertyConfigurationRequest = {
    type?: "location";
    location: EmptyObject;
};
type MediaContentWithFileAndCaptionRequest = {
    external: ExternalFileRequest;
    type?: "external";
    caption?: Array<RichTextItemRequest>;
} | {
    file_upload: FileUploadIdRequest;
    type?: "file_upload";
    caption?: Array<RichTextItemRequest>;
};
type MediaContentWithFileAndCaptionResponse = ExternalMediaContentWithFileAndCaptionResponse | FileMediaContentWithFileAndCaptionResponse;
type MediaContentWithFileNameAndCaptionRequest = {
    external: ExternalFileRequest;
    type?: "external";
    caption?: Array<RichTextItemRequest>;
    name?: StringRequest;
} | {
    file_upload: FileUploadIdRequest;
    type?: "file_upload";
    caption?: Array<RichTextItemRequest>;
    name?: StringRequest;
};
type MediaContentWithFileNameAndCaptionResponse = ExternalMediaContentWithFileNameAndCaptionResponse | FileMediaContentWithFileNameAndCaptionResponse;
type MediaContentWithUrlAndCaptionRequest = {
    url: string;
    caption?: Array<RichTextItemRequest>;
};
type MediaContentWithUrlAndCaptionResponse = {
    url: string;
    caption: Array<RichTextItemResponse>;
};
type MediaContentWithUrlResponse = {
    url: TextRequest;
};
type MentionRichTextItemRequest = {
    type?: "mention";
    mention: {
        type?: "user";
        user: PartialUserObjectRequest;
    } | {
        type?: "date";
        date: DateRequest;
    } | {
        type?: "page";
        page: {
            id: IdRequest;
        };
    } | {
        type?: "database";
        database: {
            id: IdRequest;
        };
    } | {
        type?: "template_mention";
        template_mention: TemplateMentionRequest;
    } | {
        type?: "custom_emoji";
        custom_emoji: {
            id: IdRequest;
            name?: string;
            url?: string;
        };
    };
};
export type MentionRichTextItemResponse = {
    type: "mention";
    mention: {
        type: "user";
        user: UserValueResponse;
    } | {
        type: "date";
        date: DateResponse;
    } | {
        type: "link_preview";
        link_preview: LinkPreviewMentionResponse;
    } | {
        type: "link_mention";
        link_mention: LinkMentionResponse;
    } | {
        type: "page";
        page: {
            id: IdResponse;
        };
    } | {
        type: "database";
        database: {
            id: IdResponse;
        };
    } | {
        type: "template_mention";
        template_mention: TemplateMentionResponse;
    } | {
        type: "custom_emoji";
        custom_emoji: CustomEmojiResponse;
    };
};
type MultiSelectDatabasePropertyConfigResponse = {
    type: "multi_select";
    multi_select: {
        options: Array<SelectPropertyResponse>;
    };
};
type MultiSelectPropertyConfigurationRequest = {
    type?: "multi_select";
    multi_select: {
        options?: Array<{
            name: string;
            color?: SelectColor;
            description?: string | null;
        }>;
    };
};
type MultiSelectPropertyFilter = {
    contains: string;
} | {
    does_not_contain: string;
} | ExistencePropertyFilter;
export type MultiSelectPropertyItemObjectResponse = {
    type: "multi_select";
    multi_select: Array<PartialSelectResponse>;
    object: "property_item";
    id: string;
};
type MultiSelectSimplePropertyValueResponse = {
    type: "multi_select";
    multi_select: Array<PartialSelectPropertyValueResponse>;
};
type NumberDatabasePropertyConfigResponse = {
    type: "number";
    number: {
        format: NumberFormat;
    };
};
type NumberFormat = string;
type NumberFormulaPropertyResponse = {
    type: "number";
    number: number | null;
};
type NumberFormulaPropertyValueResponse = {
    type: "number";
    number: number | null;
};
type NumberPartialRollupValueResponse = {
    type: "number";
    number: number | null;
};
type NumberPropertyConfigurationRequest = {
    type?: "number";
    number: {
        format?: NumberFormat;
    };
};
type NumberPropertyFilter = {
    equals: number;
} | {
    does_not_equal: number;
} | {
    greater_than: number;
} | {
    less_than: number;
} | {
    greater_than_or_equal_to: number;
} | {
    less_than_or_equal_to: number;
} | ExistencePropertyFilter;
export type NumberPropertyItemObjectResponse = {
    type: "number";
    number: number | null;
    object: "property_item";
    id: string;
};
type NumberSimplePropertyValueResponse = {
    type: "number";
    number: number | null;
};
type NumberedListFormat = "numbers" | "letters" | "roman";
export type NumberedListItemBlockObjectResponse = {
    type: "numbered_list_item";
    numbered_list_item: ContentWithRichTextAndColorAndListResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type PageCoverRequest = FileUploadPageCoverRequest | ExternalPageCoverRequest;
type PageCoverResponse = FilePageCoverResponse | ExternalPageCoverResponse;
type PageIconRequest = FileUploadPageIconRequest | EmojiPageIconRequest | ExternalPageIconRequest | CustomEmojiPageIconRequest;
type PageIconResponse = EmojiPageIconResponse | FilePageIconResponse | ExternalPageIconResponse | CustomEmojiPageIconResponse;
type PageIdCommentParentResponse = {
    type: "page_id";
    page_id: IdResponse;
};
type PageIdParentForBlockBasedObjectResponse = {
    type: "page_id";
    page_id: IdResponse;
};
export type PageObjectResponse = {
    object: "page";
    id: IdResponse;
    created_time: string;
    last_edited_time: string;
    archived: boolean;
    in_trash: boolean;
    is_locked: boolean;
    url: string;
    public_url: string | null;
    parent: ParentForBlockBasedObjectResponse;
    properties: Record<string, PagePropertyValueWithIdResponse>;
    icon: PageIconResponse | null;
    cover: PageCoverResponse | null;
    created_by: PartialUserObjectResponse;
    last_edited_by: PartialUserObjectResponse;
};
type PagePositionSchema = {
    type: "after_block";
    after_block: {
        id: IdRequest;
    };
} | {
    type: "page_start";
} | {
    type: "page_end";
};
type PagePropertyValueWithIdResponse = IdObjectResponse & (SimpleOrArrayPropertyValueResponse | PartialRollupPropertyResponse);
export type ParagraphBlockObjectResponse = {
    type: "paragraph";
    paragraph: ContentWithRichTextAndColorResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type ParentForBlockBasedObjectResponse = DatabaseParentResponse | DataSourceParentResponse | PageIdParentForBlockBasedObjectResponse | BlockIdParentForBlockBasedObjectResponse | WorkspaceParentForBlockBasedObjectResponse;
type ParentOfDataSourceRequest = {
    type?: "database_id";
    database_id: IdRequest;
};
/**
 * The parent of the data source. This is typically a database (`database_id`), but for
 * externally synced data sources, can be another data source (`data_source_id`).
 */
type ParentOfDataSourceResponse = DatabaseParentResponse | DataSourceParentResponse;
type ParentOfDatabaseResponse = PageIdParentForBlockBasedObjectResponse | WorkspaceParentForBlockBasedObjectResponse | DatabaseParentResponse | BlockIdParentForBlockBasedObjectResponse;
export type PartialBlockObjectResponse = {
    object: "block";
    id: string;
};
export type PartialCommentObjectResponse = {
    object: "comment";
    id: IdResponse;
};
export type PartialDataSourceObjectResponse = {
    object: "data_source";
    id: IdResponse;
    properties: Record<string, DatabasePropertyConfigResponse>;
};
export type PartialDatabaseObjectResponse = {
    object: "database";
    id: IdResponse;
};
export type PartialPageObjectResponse = {
    object: "page";
    id: IdResponse;
};
type PartialRollupPropertyResponse = {
    type: "rollup";
    rollup: PartialRollupValueResponse;
};
type PartialRollupValueResponse = PartialRollupValueResponseCommon & (NumberPartialRollupValueResponse | DatePartialRollupValueResponse | ArrayPartialRollupValueResponse);
type PartialRollupValueResponseCommon = {
    function: RollupFunction;
};
type PartialSelectPropertyValueResponse = {
    id: string;
    name: string;
    color: "default" | "gray" | "brown" | "orange" | "yellow" | "green" | "blue" | "purple" | "pink" | "red";
};
type PartialSelectResponse = {
    id: string;
    name: string;
    color: SelectColor;
};
type PartialUserObjectRequest = {
    id: IdRequest;
    object?: "user";
};
export type PartialUserObjectResponse = {
    id: IdResponse;
    object: "user";
};
export type PdfBlockObjectResponse = {
    type: "pdf";
    pdf: MediaContentWithFileAndCaptionResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type PeopleArrayBasedPropertyValueResponse = {
    type: "people";
    people: Array<UserValueResponse | GroupObjectResponse>;
};
type PeopleDatabasePropertyConfigResponse = {
    type: "people";
    people: EmptyObject;
};
type PeoplePropertyConfigurationRequest = {
    type?: "people";
    people: EmptyObject;
};
type PeoplePropertyFilter = {
    contains: IdRequest;
} | {
    does_not_contain: IdRequest;
} | ExistencePropertyFilter;
export type PeoplePropertyItemObjectResponse = {
    type: "people";
    people: PartialUserObjectResponse | UserObjectResponse;
    object: "property_item";
    id: string;
};
export type PersonUserObjectResponse = {
    type: "person";
    person: {
        email?: string;
    };
};
type PhoneNumberDatabasePropertyConfigResponse = {
    type: "phone_number";
    phone_number: EmptyObject;
};
type PhoneNumberPropertyConfigurationRequest = {
    type?: "phone_number";
    phone_number: EmptyObject;
};
export type PhoneNumberPropertyItemObjectResponse = {
    type: "phone_number";
    phone_number: string | null;
    object: "property_item";
    id: string;
};
type PhoneNumberSimplePropertyValueResponse = {
    type: "phone_number";
    phone_number: string | null;
};
type PlacePropertyConfigurationRequest = {
    type?: "place";
    place: EmptyObject;
};
export type PlacePropertyItemObjectResponse = {
    type: "place";
    place: {
        lat: number;
        lon: number;
        name?: string | null;
        address?: string | null;
        aws_place_id?: string | null;
        google_place_id?: string | null;
    } | null;
    object: "property_item";
    id: string;
};
type PlacePropertyValueResponse = {
    lat: number;
    lon: number;
    name?: string | null;
    address?: string | null;
    aws_place_id?: string | null;
    google_place_id?: string | null;
};
type PlaceSimplePropertyValueResponse = {
    type: "place";
    place: PlacePropertyValueResponse | null;
};
type PropertyConfigurationRequest = PropertyConfigurationRequestCommon & (NumberPropertyConfigurationRequest | FormulaPropertyConfigurationRequest | SelectPropertyConfigurationRequest | MultiSelectPropertyConfigurationRequest | StatusPropertyConfigurationRequest | RelationPropertyConfigurationRequest | RollupPropertyConfigurationRequest | UniqueIdPropertyConfigurationRequest | TitlePropertyConfigurationRequest | RichTextPropertyConfigurationRequest | UrlPropertyConfigurationRequest | PeoplePropertyConfigurationRequest | FilesPropertyConfigurationRequest | EmailPropertyConfigurationRequest | PhoneNumberPropertyConfigurationRequest | DatePropertyConfigurationRequest | CheckboxPropertyConfigurationRequest | CreatedByPropertyConfigurationRequest | CreatedTimePropertyConfigurationRequest | LastEditedByPropertyConfigurationRequest | LastEditedTimePropertyConfigurationRequest | ButtonPropertyConfigurationRequest | LocationPropertyConfigurationRequest | VerificationPropertyConfigurationRequest | LastVisitedTimePropertyConfigurationRequest | PlacePropertyConfigurationRequest);
type PropertyConfigurationRequestCommon = {
    description?: PropertyDescriptionRequest | null;
};
type PropertyDescriptionRequest = string;
type PropertyFilter = {
    title: TextPropertyFilter;
    property: string;
    type?: "title";
} | {
    rich_text: TextPropertyFilter;
    property: string;
    type?: "rich_text";
} | {
    number: NumberPropertyFilter;
    property: string;
    type?: "number";
} | {
    checkbox: CheckboxPropertyFilter;
    property: string;
    type?: "checkbox";
} | {
    select: SelectPropertyFilter;
    property: string;
    type?: "select";
} | {
    multi_select: MultiSelectPropertyFilter;
    property: string;
    type?: "multi_select";
} | {
    status: StatusPropertyFilter;
    property: string;
    type?: "status";
} | {
    date: DatePropertyFilter;
    property: string;
    type?: "date";
} | {
    people: PeoplePropertyFilter;
    property: string;
    type?: "people";
} | {
    files: ExistencePropertyFilter;
    property: string;
    type?: "files";
} | {
    url: TextPropertyFilter;
    property: string;
    type?: "url";
} | {
    email: TextPropertyFilter;
    property: string;
    type?: "email";
} | {
    phone_number: TextPropertyFilter;
    property: string;
    type?: "phone_number";
} | {
    relation: RelationPropertyFilter;
    property: string;
    type?: "relation";
} | {
    created_by: PeoplePropertyFilter;
    property: string;
    type?: "created_by";
} | {
    created_time: DatePropertyFilter;
    property: string;
    type?: "created_time";
} | {
    last_edited_by: PeoplePropertyFilter;
    property: string;
    type?: "last_edited_by";
} | {
    last_edited_time: DatePropertyFilter;
    property: string;
    type?: "last_edited_time";
} | {
    formula: FormulaPropertyFilter;
    property: string;
    type?: "formula";
} | {
    unique_id: NumberPropertyFilter;
    property: string;
    type?: "unique_id";
} | {
    rollup: RollupPropertyFilter;
    property: string;
    type?: "rollup";
} | {
    verification: VerificationPropertyStatusFilter;
    property: string;
    type?: "verification";
};
export type PropertyItemListResponse = PropertyItemPropertyItemListResponse;
export type PropertyItemObjectResponse = NumberPropertyItemObjectResponse | UrlPropertyItemObjectResponse | SelectPropertyItemObjectResponse | MultiSelectPropertyItemObjectResponse | StatusPropertyItemObjectResponse | DatePropertyItemObjectResponse | EmailPropertyItemObjectResponse | PhoneNumberPropertyItemObjectResponse | CheckboxPropertyItemObjectResponse | FilesPropertyItemObjectResponse | CreatedByPropertyItemObjectResponse | CreatedTimePropertyItemObjectResponse | LastEditedByPropertyItemObjectResponse | LastEditedTimePropertyItemObjectResponse | FormulaPropertyItemObjectResponse | ButtonPropertyItemObjectResponse | UniqueIdPropertyItemObjectResponse | VerificationPropertyItemObjectResponse | PlacePropertyItemObjectResponse | TitlePropertyItemObjectResponse | RichTextPropertyItemObjectResponse | PeoplePropertyItemObjectResponse | RelationPropertyItemObjectResponse | RollupPropertyItemObjectResponse;
type PropertyItemPropertyItemListResponse = {
    type: "property_item";
    property_item: {
        type: "title";
        title: EmptyObject;
        next_url: string | null;
        id: string;
    } | {
        type: "rich_text";
        rich_text: EmptyObject;
        next_url: string | null;
        id: string;
    } | {
        type: "people";
        people: EmptyObject;
        next_url: string | null;
        id: string;
    } | {
        type: "relation";
        relation: EmptyObject;
        next_url: string | null;
        id: string;
    } | {
        type: "rollup";
        rollup: {
            type: "number";
            number: number | null;
            function: RollupFunction;
        } | {
            type: "date";
            date: DateResponse | null;
            function: RollupFunction;
        } | {
            type: "array";
            array: Array<EmptyObject>;
            function: RollupFunction;
        } | {
            type: "unsupported";
            unsupported: EmptyObject;
            function: RollupFunction;
        } | {
            type: "incomplete";
            incomplete: EmptyObject;
            function: RollupFunction;
        };
        next_url: string | null;
        id: string;
    };
    object: "list";
    next_cursor: string | null;
    has_more: boolean;
    results: Array<PropertyItemObjectResponse>;
};
type PropertyOrTimestampFilter = PropertyFilter | TimestampFilter;
type PropertyOrTimestampFilterArray = Array<PropertyOrTimestampFilter>;
export type QuoteBlockObjectResponse = {
    type: "quote";
    quote: ContentWithRichTextAndColorResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type RelationArrayBasedPropertyValueResponse = {
    type: "relation";
    relation: Array<RelationItemPropertyValueResponse>;
};
type RelationDatabasePropertyConfigResponse = {
    type: "relation";
    relation: DatabasePropertyRelationConfigResponse;
};
type RelationItemPropertyValueResponse = {
    id: IdRequest;
};
type RelationPropertyConfigurationRequest = {
    type?: "relation";
    relation: {
        data_source_id: IdRequest;
    } & ({
        type?: "single_property";
        single_property: EmptyObject;
    } | {
        type?: "dual_property";
        dual_property: {
            synced_property_id?: string;
            synced_property_name?: string;
        };
    });
};
type RelationPropertyFilter = {
    contains: IdRequest;
} | {
    does_not_contain: IdRequest;
} | ExistencePropertyFilter;
export type RelationPropertyItemObjectResponse = {
    type: "relation";
    relation: {
        id: string;
    };
    object: "property_item";
    id: string;
};
type RichTextArrayBasedPropertyValueResponse = {
    type: "rich_text";
    rich_text: Array<RichTextItemResponse>;
};
type RichTextDatabasePropertyConfigResponse = {
    type: "rich_text";
    rich_text: EmptyObject;
};
type RichTextItemRequest = RichTextItemRequestCommon & (TextRichTextItemRequest | MentionRichTextItemRequest | EquationRichTextItemRequest);
type RichTextItemRequestCommon = {
    annotations?: AnnotationRequest;
};
export type RichTextItemResponse = RichTextItemResponseCommon & (TextRichTextItemResponse | MentionRichTextItemResponse | EquationRichTextItemResponse);
export type RichTextItemResponseCommon = {
    plain_text: string;
    href: string | null;
    annotations: AnnotationResponse;
};
type RichTextPropertyConfigurationRequest = {
    type?: "rich_text";
    rich_text: EmptyObject;
};
export type RichTextPropertyItemObjectResponse = {
    type: "rich_text";
    rich_text: RichTextItemResponse;
    object: "property_item";
    id: string;
};
type RollupDatabasePropertyConfigResponse = {
    type: "rollup";
    rollup: {
        function: RollupFunction;
        rollup_property_name: string;
        relation_property_name: string;
        rollup_property_id: string;
        relation_property_id: string;
    };
};
type RollupFunction = "count" | "count_values" | "empty" | "not_empty" | "unique" | "show_unique" | "percent_empty" | "percent_not_empty" | "sum" | "average" | "median" | "min" | "max" | "range" | "earliest_date" | "latest_date" | "date_range" | "checked" | "unchecked" | "percent_checked" | "percent_unchecked" | "count_per_group" | "percent_per_group" | "show_original";
type RollupPropertyConfigurationRequest = {
    type?: "rollup";
    rollup: {
        function: RollupFunction;
    } & ({
        relation_property_name: string;
        rollup_property_name: string;
    } | {
        relation_property_id: string;
        rollup_property_name: string;
    } | {
        relation_property_name: string;
        rollup_property_id: string;
    } | {
        relation_property_id: string;
        rollup_property_id: string;
    });
};
type RollupPropertyFilter = {
    any: RollupSubfilterPropertyFilter;
} | {
    none: RollupSubfilterPropertyFilter;
} | {
    every: RollupSubfilterPropertyFilter;
} | {
    date: DatePropertyFilter;
} | {
    number: NumberPropertyFilter;
};
export type RollupPropertyItemObjectResponse = {
    type: "rollup";
    rollup: {
        type: "number";
        number: number | null;
        function: RollupFunction;
    } | {
        type: "date";
        date: DateResponse | null;
        function: RollupFunction;
    } | {
        type: "array";
        array: Array<EmptyObject>;
        function: RollupFunction;
    } | {
        type: "unsupported";
        unsupported: EmptyObject;
        function: RollupFunction;
    } | {
        type: "incomplete";
        incomplete: EmptyObject;
        function: RollupFunction;
    };
    object: "property_item";
    id: string;
};
type RollupSubfilterPropertyFilter = {
    rich_text: TextPropertyFilter;
} | {
    number: NumberPropertyFilter;
} | {
    checkbox: CheckboxPropertyFilter;
} | {
    select: SelectPropertyFilter;
} | {
    multi_select: MultiSelectPropertyFilter;
} | {
    relation: RelationPropertyFilter;
} | {
    date: DatePropertyFilter;
} | {
    people: PeoplePropertyFilter;
} | {
    files: ExistencePropertyFilter;
} | {
    status: StatusPropertyFilter;
};
/**
 * One of: `default`, `gray`, `brown`, `orange`, `yellow`, `green`, `blue`, `purple`,
 * `pink`, `red`
 */
type SelectColor = "default" | "gray" | "brown" | "orange" | "yellow" | "green" | "blue" | "purple" | "pink" | "red";
type SelectDatabasePropertyConfigResponse = {
    type: "select";
    select: {
        options: Array<SelectPropertyResponse>;
    };
};
type SelectPropertyConfigurationRequest = {
    type?: "select";
    select: {
        options?: Array<{
            name: string;
            color?: SelectColor;
            description?: string | null;
        }>;
    };
};
type SelectPropertyFilter = {
    equals: string;
} | {
    does_not_equal: string;
} | ExistencePropertyFilter;
export type SelectPropertyItemObjectResponse = {
    type: "select";
    select: PartialSelectResponse | null;
    object: "property_item";
    id: string;
};
type SelectPropertyResponse = {
    id: string;
    name: string;
    color: SelectColor;
    description: string | null;
};
type SelectSimplePropertyValueResponse = {
    type: "select";
    select: PartialSelectPropertyValueResponse | null;
};
type SimpleOrArrayPropertyValueResponse = SimplePropertyValueResponse | ArrayBasedPropertyValueResponse;
type SimplePropertyValueResponse = NumberSimplePropertyValueResponse | UrlSimplePropertyValueResponse | SelectSimplePropertyValueResponse | MultiSelectSimplePropertyValueResponse | StatusSimplePropertyValueResponse | DateSimplePropertyValueResponse | EmailSimplePropertyValueResponse | PhoneNumberSimplePropertyValueResponse | CheckboxSimplePropertyValueResponse | FilesSimplePropertyValueResponse | CreatedBySimplePropertyValueResponse | CreatedTimeSimplePropertyValueResponse | LastEditedBySimplePropertyValueResponse | LastEditedTimeSimplePropertyValueResponse | FormulaSimplePropertyValueResponse | ButtonSimplePropertyValueResponse | UniqueIdSimplePropertyValueResponse | VerificationSimplePropertyValueResponse | PlaceSimplePropertyValueResponse;
type SinglePropertyDatabasePropertyRelationConfigResponse = {
    type: "single_property";
    single_property: EmptyObject;
};
type StatusDatabasePropertyConfigResponse = {
    type: "status";
    status: {
        options: Array<StatusPropertyResponse>;
        groups: Array<{
            id: string;
            name: string;
            color: SelectColor;
            option_ids: Array<string>;
        }>;
    };
};
type StatusPropertyConfigurationRequest = {
    type?: "status";
    status: EmptyObject;
};
type StatusPropertyFilter = {
    equals: string;
} | {
    does_not_equal: string;
} | ExistencePropertyFilter;
export type StatusPropertyItemObjectResponse = {
    type: "status";
    status: PartialSelectResponse | null;
    object: "property_item";
    id: string;
};
type StatusPropertyResponse = {
    id: string;
    name: string;
    color: SelectColor;
    description: string | null;
};
type StatusSimplePropertyValueResponse = {
    type: "status";
    status: PartialSelectPropertyValueResponse | null;
};
type StringFormulaPropertyResponse = {
    type: "string";
    string: string | null;
};
type StringFormulaPropertyValueResponse = {
    type: "string";
    string: string | null;
};
type StringRequest = string;
export type SyncedBlockBlockObjectResponse = {
    type: "synced_block";
    synced_block: {
        synced_from: {
            type: "block_id";
            block_id: IdRequest;
        } | null;
    };
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type TableBlockObjectResponse = {
    type: "table";
    table: ContentWithTableResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type TableOfContentsBlockObjectResponse = {
    type: "table_of_contents";
    table_of_contents: {
        color: ApiColor;
    };
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type TableRequestWithTableRowChildren = {
    table_width: number;
    children: Array<TableRowRequest>;
    has_column_header?: boolean;
    has_row_header?: boolean;
};
export type TableRowBlockObjectResponse = {
    type: "table_row";
    table_row: ContentWithTableRowResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type TableRowRequest = {
    table_row: ContentWithTableRowRequest;
    type?: "table_row";
    object?: "block";
};
export type TemplateBlockObjectResponse = {
    type: "template";
    template: {
        rich_text: Array<RichTextItemResponse>;
    };
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type TemplateMentionDateTemplateMentionRequest = {
    type?: "template_mention_date";
    template_mention_date: "today" | "now";
};
type TemplateMentionDateTemplateMentionResponse = {
    type: "template_mention_date";
    template_mention_date: "today" | "now";
};
type TemplateMentionRequest = TemplateMentionDateTemplateMentionRequest | TemplateMentionUserTemplateMentionRequest;
type TemplateMentionResponse = TemplateMentionDateTemplateMentionResponse | TemplateMentionUserTemplateMentionResponse;
type TemplateMentionUserTemplateMentionRequest = {
    type?: "template_mention_user";
    template_mention_user: "me";
};
type TemplateMentionUserTemplateMentionResponse = {
    type: "template_mention_user";
    template_mention_user: "me";
};
type TextPropertyFilter = {
    equals: string;
} | {
    does_not_equal: string;
} | {
    contains: string;
} | {
    does_not_contain: string;
} | {
    starts_with: string;
} | {
    ends_with: string;
} | ExistencePropertyFilter;
type TextRequest = string;
type TextRichTextItemRequest = {
    type?: "text";
    text: {
        content: string;
        link?: {
            url: string;
        } | null;
    };
};
export type TextRichTextItemResponse = {
    type: "text";
    text: {
        content: string;
        link: {
            url: string;
        } | null;
    };
};
type TimeZoneRequest = string;
type TimestampCreatedTimeFilter = {
    created_time: DatePropertyFilter;
    timestamp: "created_time";
    type?: "created_time";
};
type TimestampFilter = TimestampCreatedTimeFilter | TimestampLastEditedTimeFilter;
type TimestampLastEditedTimeFilter = {
    last_edited_time: DatePropertyFilter;
    timestamp: "last_edited_time";
    type?: "last_edited_time";
};
type TitleArrayBasedPropertyValueResponse = {
    type: "title";
    title: Array<RichTextItemResponse>;
};
type TitleDatabasePropertyConfigResponse = {
    type: "title";
    title: EmptyObject;
};
type TitleObjectResponse = {
    title: string;
};
type TitlePropertyConfigurationRequest = {
    type?: "title";
    title: EmptyObject;
};
export type TitlePropertyItemObjectResponse = {
    type: "title";
    title: RichTextItemResponse;
    object: "property_item";
    id: string;
};
export type ToDoBlockObjectResponse = {
    type: "to_do";
    to_do: {
        rich_text: Array<RichTextItemResponse>;
        color: ApiColor;
        checked: boolean;
    };
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
export type ToggleBlockObjectResponse = {
    type: "toggle";
    toggle: ContentWithRichTextAndColorResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type UniqueIdDatabasePropertyConfigResponse = {
    type: "unique_id";
    unique_id: {
        prefix: string | null;
    };
};
type UniqueIdPropertyConfigurationRequest = {
    type?: "unique_id";
    unique_id: {
        prefix?: string | null;
    };
};
export type UniqueIdPropertyItemObjectResponse = {
    type: "unique_id";
    unique_id: {
        prefix: string | null;
        number: number | null;
    };
    object: "property_item";
    id: string;
};
type UniqueIdPropertyValueResponse = {
    prefix: string | null;
    number: number | null;
};
type UniqueIdSimplePropertyValueResponse = {
    type: "unique_id";
    unique_id: UniqueIdPropertyValueResponse;
};
export type UnsupportedBlockObjectResponse = {
    type: "unsupported";
    unsupported: EmptyObject;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type UpdateMediaContentWithFileAndCaptionRequest = {
    caption?: Array<RichTextItemRequest>;
    external?: ExternalFileRequest;
    file_upload?: FileUploadIdRequest;
};
type UpdateMediaContentWithFileNameAndCaptionRequest = {
    caption?: Array<RichTextItemRequest>;
    external?: ExternalFileRequest;
    file_upload?: FileUploadIdRequest;
    name?: StringRequest;
};
type UpdateMediaContentWithUrlAndCaptionRequest = {
    url?: string;
    caption?: Array<RichTextItemRequest>;
};
type UrlDatabasePropertyConfigResponse = {
    type: "url";
    url: EmptyObject;
};
type UrlPropertyConfigurationRequest = {
    type?: "url";
    url: EmptyObject;
};
export type UrlPropertyItemObjectResponse = {
    type: "url";
    url: string | null;
    object: "property_item";
    id: string;
};
type UrlSimplePropertyValueResponse = {
    type: "url";
    url: string | null;
};
export type UserObjectResponse = UserObjectResponseCommon & (PersonUserObjectResponse | BotUserObjectResponse);
export type UserObjectResponseCommon = {
    id: IdResponse;
    object: "user";
    name: string | null;
    avatar_url: string | null;
};
type UserValueResponse = PartialUserObjectResponse | UserObjectResponse;
type VerificationPropertyConfigurationRequest = {
    type?: "verification";
    verification: EmptyObject;
};
export type VerificationPropertyItemObjectResponse = {
    type: "verification";
    verification: VerificationPropertyValueResponse | null;
    object: "property_item";
    id: string;
};
type VerificationPropertyResponse = {
    state: "verified" | "expired";
    date: DateResponse | null;
    verified_by: PartialUserObjectResponse | null;
};
type VerificationPropertyStatusFilter = {
    status: "verified" | "expired" | "none";
};
type VerificationPropertyUnverifiedResponse = {
    state: "unverified";
    date: null;
    verified_by: null;
};
type VerificationPropertyValueResponse = VerificationPropertyUnverifiedResponse | VerificationPropertyResponse;
type VerificationSimplePropertyValueResponse = {
    type: "verification";
    verification: VerificationPropertyValueResponse | null;
};
export type VideoBlockObjectResponse = {
    type: "video";
    video: MediaContentWithFileAndCaptionResponse;
    parent: ParentForBlockBasedObjectResponse;
    object: "block";
    id: string;
    created_time: string;
    created_by: PartialUserObjectResponse;
    last_edited_time: string;
    last_edited_by: PartialUserObjectResponse;
    has_children: boolean;
    archived: boolean;
    in_trash: boolean;
};
type WorkspaceParentForBlockBasedObjectResponse = {
    type: "workspace";
    workspace: true;
};
export type GetSelfParameters = Record<string, never>;
export type GetSelfResponse = UserObjectResponse;
/**
 * Retrieve your token's bot user
 */
export declare const getSelf: {
    readonly method: "get";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: () => string;
};
type GetUserPathParameters = {
    user_id: IdRequest;
};
export type GetUserParameters = GetUserPathParameters;
export type GetUserResponse = UserObjectResponse;
/**
 * Retrieve a user
 */
export declare const getUser: {
    readonly method: "get";
    readonly pathParams: readonly ["user_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: GetUserPathParameters) => string;
};
type ListUsersQueryParameters = {
    start_cursor?: string;
    page_size?: number;
};
export type ListUsersParameters = ListUsersQueryParameters;
export type ListUsersResponse = {
    type: "user";
    user: EmptyObject;
    object: "list";
    next_cursor: string | null;
    has_more: boolean;
    results: Array<UserObjectResponse>;
};
/**
 * List all users
 */
export declare const listUsers: {
    readonly method: "get";
    readonly pathParams: readonly [];
    readonly queryParams: readonly ["start_cursor", "page_size"];
    readonly bodyParams: readonly [];
    readonly path: () => string;
};
type CreatePageBodyParameters = {
    parent?: {
        page_id: IdRequest;
        type?: "page_id";
    } | {
        database_id: IdRequest;
        type?: "database_id";
    } | {
        data_source_id: IdRequest;
        type?: "data_source_id";
    } | {
        workspace: true;
        type?: "workspace";
    };
    properties?: Record<string, {
        title: Array<RichTextItemRequest>;
        type?: "title";
    } | {
        rich_text: Array<RichTextItemRequest>;
        type?: "rich_text";
    } | {
        number: number | null;
        type?: "number";
    } | {
        url: TextRequest | null;
        type?: "url";
    } | {
        select: {
            id: StringRequest;
            name?: TextRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | {
            name: TextRequest;
            id?: StringRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | null;
        type?: "select";
    } | {
        multi_select: Array<{
            id: StringRequest;
            name?: TextRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | {
            name: TextRequest;
            id?: StringRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        }>;
        type?: "multi_select";
    } | {
        people: Array<PartialUserObjectRequest | GroupObjectRequest>;
        type?: "people";
    } | {
        email: StringRequest | null;
        type?: "email";
    } | {
        phone_number: StringRequest | null;
        type?: "phone_number";
    } | {
        date: DateRequest | null;
        type?: "date";
    } | {
        checkbox: boolean;
        type?: "checkbox";
    } | {
        relation: Array<RelationItemPropertyValueResponse>;
        type?: "relation";
    } | {
        files: Array<InternalOrExternalFileWithNameRequest | FileUploadWithOptionalNameRequest>;
        type?: "files";
    } | {
        status: {
            id: StringRequest;
            name?: TextRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | {
            name: TextRequest;
            id?: StringRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | null;
        type?: "status";
    } | {
        place: {
            lat: number;
            lon: number;
            name?: string | null;
            address?: string | null;
            aws_place_id?: string | null;
            google_place_id?: string | null;
        } | null;
        type?: "place";
    }>;
    icon?: PageIconRequest | null;
    cover?: PageCoverRequest | null;
    content?: Array<BlockObjectRequest>;
    children?: Array<BlockObjectRequest>;
    template?: {
        type: "none";
    } | {
        type: "default";
    } | {
        type: "template_id";
        template_id: IdRequest;
    };
    position?: PagePositionSchema;
};
export type CreatePageParameters = CreatePageBodyParameters;
export type CreatePageResponse = PageObjectResponse | PartialPageObjectResponse;
/**
 * Create a page
 */
export declare const createPage: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["parent", "properties", "icon", "cover", "content", "children", "template", "position"];
    readonly path: () => string;
};
type GetPagePathParameters = {
    page_id: IdRequest;
};
type GetPageQueryParameters = {
    filter_properties?: Array<string>;
};
export type GetPageParameters = GetPagePathParameters & GetPageQueryParameters;
export type GetPageResponse = PartialPageObjectResponse | PageObjectResponse;
/**
 * Retrieve a page
 */
export declare const getPage: {
    readonly method: "get";
    readonly pathParams: readonly ["page_id"];
    readonly queryParams: readonly ["filter_properties"];
    readonly bodyParams: readonly [];
    readonly path: (p: GetPagePathParameters) => string;
};
type UpdatePagePathParameters = {
    page_id: IdRequest;
};
type UpdatePageBodyParameters = {
    properties?: Record<string, {
        title: Array<RichTextItemRequest>;
        type?: "title";
    } | {
        rich_text: Array<RichTextItemRequest>;
        type?: "rich_text";
    } | {
        number: number | null;
        type?: "number";
    } | {
        url: TextRequest | null;
        type?: "url";
    } | {
        select: {
            id: StringRequest;
            name?: TextRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | {
            name: TextRequest;
            id?: StringRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | null;
        type?: "select";
    } | {
        multi_select: Array<{
            id: StringRequest;
            name?: TextRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | {
            name: TextRequest;
            id?: StringRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        }>;
        type?: "multi_select";
    } | {
        people: Array<PartialUserObjectRequest | GroupObjectRequest>;
        type?: "people";
    } | {
        email: StringRequest | null;
        type?: "email";
    } | {
        phone_number: StringRequest | null;
        type?: "phone_number";
    } | {
        date: DateRequest | null;
        type?: "date";
    } | {
        checkbox: boolean;
        type?: "checkbox";
    } | {
        relation: Array<RelationItemPropertyValueResponse>;
        type?: "relation";
    } | {
        files: Array<InternalOrExternalFileWithNameRequest | FileUploadWithOptionalNameRequest>;
        type?: "files";
    } | {
        status: {
            id: StringRequest;
            name?: TextRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | {
            name: TextRequest;
            id?: StringRequest;
            color?: SelectColor;
            description?: TextRequest | null;
        } | null;
        type?: "status";
    } | {
        place: {
            lat: number;
            lon: number;
            name?: string | null;
            address?: string | null;
            aws_place_id?: string | null;
            google_place_id?: string | null;
        } | null;
        type?: "place";
    }>;
    icon?: PageIconRequest | null;
    cover?: PageCoverRequest | null;
    is_locked?: boolean;
    template?: {
        type: "default";
    } | {
        type: "template_id";
        template_id: IdRequest;
    };
    erase_content?: boolean;
    archived?: boolean;
    in_trash?: boolean;
};
export type UpdatePageParameters = UpdatePagePathParameters & UpdatePageBodyParameters;
export type UpdatePageResponse = PageObjectResponse | PartialPageObjectResponse;
/**
 * Update page properties
 */
export declare const updatePage: {
    readonly method: "patch";
    readonly pathParams: readonly ["page_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["properties", "icon", "cover", "is_locked", "template", "erase_content", "archived", "in_trash"];
    readonly path: (p: UpdatePagePathParameters) => string;
};
type GetPagePropertyPathParameters = {
    page_id: IdRequest;
    property_id: string;
};
type GetPagePropertyQueryParameters = {
    start_cursor?: string;
    page_size?: number;
};
export type GetPagePropertyParameters = GetPagePropertyPathParameters & GetPagePropertyQueryParameters;
export type GetPagePropertyResponse = PropertyItemObjectResponse | PropertyItemListResponse;
/**
 * Retrieve a page property item
 */
export declare const getPageProperty: {
    readonly method: "get";
    readonly pathParams: readonly ["page_id", "property_id"];
    readonly queryParams: readonly ["start_cursor", "page_size"];
    readonly bodyParams: readonly [];
    readonly path: (p: GetPagePropertyPathParameters) => string;
};
type GetBlockPathParameters = {
    block_id: IdRequest;
};
export type GetBlockParameters = GetBlockPathParameters;
export type GetBlockResponse = PartialBlockObjectResponse | BlockObjectResponse;
/**
 * Retrieve a block
 */
export declare const getBlock: {
    readonly method: "get";
    readonly pathParams: readonly ["block_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: GetBlockPathParameters) => string;
};
type UpdateBlockPathParameters = {
    block_id: IdRequest;
};
type UpdateBlockBodyParameters = {
    embed: UpdateMediaContentWithUrlAndCaptionRequest;
    type?: "embed";
    archived?: boolean;
    in_trash?: boolean;
} | {
    bookmark: UpdateMediaContentWithUrlAndCaptionRequest;
    type?: "bookmark";
    archived?: boolean;
    in_trash?: boolean;
} | {
    image: UpdateMediaContentWithFileAndCaptionRequest;
    type?: "image";
    archived?: boolean;
    in_trash?: boolean;
} | {
    video: UpdateMediaContentWithFileAndCaptionRequest;
    type?: "video";
    archived?: boolean;
    in_trash?: boolean;
} | {
    pdf: UpdateMediaContentWithFileAndCaptionRequest;
    type?: "pdf";
    archived?: boolean;
    in_trash?: boolean;
} | {
    file: UpdateMediaContentWithFileNameAndCaptionRequest;
    type?: "file";
    archived?: boolean;
    in_trash?: boolean;
} | {
    audio: UpdateMediaContentWithFileAndCaptionRequest;
    type?: "audio";
    archived?: boolean;
    in_trash?: boolean;
} | {
    code: {
        rich_text?: Array<RichTextItemRequest>;
        language?: LanguageRequest;
        caption?: Array<RichTextItemRequest>;
    };
    type?: "code";
    archived?: boolean;
    in_trash?: boolean;
} | {
    equation: ContentWithExpressionRequest;
    type?: "equation";
    archived?: boolean;
    in_trash?: boolean;
} | {
    divider: EmptyObject;
    type?: "divider";
    archived?: boolean;
    in_trash?: boolean;
} | {
    breadcrumb: EmptyObject;
    type?: "breadcrumb";
    archived?: boolean;
    in_trash?: boolean;
} | {
    table_of_contents: {
        color?: ApiColor;
    };
    type?: "table_of_contents";
    archived?: boolean;
    in_trash?: boolean;
} | {
    link_to_page: {
        page_id: IdRequest;
        type?: "page_id";
    } | {
        database_id: IdRequest;
        type?: "database_id";
    } | {
        comment_id: IdRequest;
        type?: "comment_id";
    };
    type?: "link_to_page";
    archived?: boolean;
    in_trash?: boolean;
} | {
    table_row: ContentWithTableRowRequest;
    type?: "table_row";
    archived?: boolean;
    in_trash?: boolean;
} | {
    heading_1: HeaderContentWithRichTextAndColorRequest;
    type?: "heading_1";
    archived?: boolean;
    in_trash?: boolean;
} | {
    heading_2: HeaderContentWithRichTextAndColorRequest;
    type?: "heading_2";
    archived?: boolean;
    in_trash?: boolean;
} | {
    heading_3: HeaderContentWithRichTextAndColorRequest;
    type?: "heading_3";
    archived?: boolean;
    in_trash?: boolean;
} | {
    paragraph: ContentWithRichTextAndColorRequest;
    type?: "paragraph";
    archived?: boolean;
    in_trash?: boolean;
} | {
    bulleted_list_item: ContentWithRichTextAndColorRequest;
    type?: "bulleted_list_item";
    archived?: boolean;
    in_trash?: boolean;
} | {
    numbered_list_item: ContentWithRichTextAndColorRequest;
    type?: "numbered_list_item";
    archived?: boolean;
    in_trash?: boolean;
} | {
    quote: ContentWithRichTextAndColorRequest;
    type?: "quote";
    archived?: boolean;
    in_trash?: boolean;
} | {
    to_do: {
        rich_text?: Array<RichTextItemRequest>;
        checked?: boolean;
        color?: ApiColor;
    };
    type?: "to_do";
    archived?: boolean;
    in_trash?: boolean;
} | {
    toggle: ContentWithRichTextAndColorRequest;
    type?: "toggle";
    archived?: boolean;
    in_trash?: boolean;
} | {
    template: ContentWithRichTextRequest;
    type?: "template";
    archived?: boolean;
    in_trash?: boolean;
} | {
    callout: {
        rich_text?: Array<RichTextItemRequest>;
        icon?: PageIconRequest;
        color?: ApiColor;
    };
    type?: "callout";
    archived?: boolean;
    in_trash?: boolean;
} | {
    synced_block: {
        synced_from: {
            block_id: IdRequest;
            type?: "block_id";
        } | null;
    };
    type?: "synced_block";
    archived?: boolean;
    in_trash?: boolean;
} | {
    table: {
        has_column_header?: boolean;
        has_row_header?: boolean;
    };
    type?: "table";
    archived?: boolean;
    in_trash?: boolean;
} | {
    column: {
        width_ratio?: number;
    };
    type?: "column";
    archived?: boolean;
    in_trash?: boolean;
} | {
    archived?: boolean;
    in_trash?: boolean;
};
export type UpdateBlockParameters = UpdateBlockPathParameters & UpdateBlockBodyParameters;
export type UpdateBlockResponse = PartialBlockObjectResponse | BlockObjectResponse;
/**
 * Update a block
 */
export declare const updateBlock: {
    readonly method: "patch";
    readonly pathParams: readonly ["block_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["embed", "type", "archived", "in_trash", "bookmark", "image", "video", "pdf", "file", "audio", "code", "equation", "divider", "breadcrumb", "table_of_contents", "link_to_page", "table_row", "heading_1", "heading_2", "heading_3", "paragraph", "bulleted_list_item", "numbered_list_item", "quote", "to_do", "toggle", "template", "callout", "synced_block", "table", "column"];
    readonly path: (p: UpdateBlockPathParameters) => string;
};
type DeleteBlockPathParameters = {
    block_id: IdRequest;
};
export type DeleteBlockParameters = DeleteBlockPathParameters;
export type DeleteBlockResponse = PartialBlockObjectResponse | BlockObjectResponse;
/**
 * Delete a block
 */
export declare const deleteBlock: {
    readonly method: "delete";
    readonly pathParams: readonly ["block_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: DeleteBlockPathParameters) => string;
};
type ListBlockChildrenPathParameters = {
    block_id: IdRequest;
};
type ListBlockChildrenQueryParameters = {
    start_cursor?: string;
    page_size?: number;
};
export type ListBlockChildrenParameters = ListBlockChildrenPathParameters & ListBlockChildrenQueryParameters;
export type ListBlockChildrenResponse = {
    type: "block";
    block: EmptyObject;
    object: "list";
    next_cursor: string | null;
    has_more: boolean;
    results: Array<PartialBlockObjectResponse | BlockObjectResponse>;
};
/**
 * Retrieve block children
 */
export declare const listBlockChildren: {
    readonly method: "get";
    readonly pathParams: readonly ["block_id"];
    readonly queryParams: readonly ["start_cursor", "page_size"];
    readonly bodyParams: readonly [];
    readonly path: (p: ListBlockChildrenPathParameters) => string;
};
type AppendBlockChildrenPathParameters = {
    block_id: IdRequest;
};
type AppendBlockChildrenBodyParameters = {
    children: Array<BlockObjectRequest>;
    after?: IdRequest;
    position?: ContentPositionSchema;
};
export type AppendBlockChildrenParameters = AppendBlockChildrenPathParameters & AppendBlockChildrenBodyParameters;
export type AppendBlockChildrenResponse = {
    type: "block";
    block: EmptyObject;
    object: "list";
    next_cursor: string | null;
    has_more: boolean;
    results: Array<PartialBlockObjectResponse | BlockObjectResponse>;
};
/**
 * Append block children
 */
export declare const appendBlockChildren: {
    readonly method: "patch";
    readonly pathParams: readonly ["block_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["children", "after", "position"];
    readonly path: (p: AppendBlockChildrenPathParameters) => string;
};
type GetDataSourcePathParameters = {
    data_source_id: IdRequest;
};
export type GetDataSourceParameters = GetDataSourcePathParameters;
export type GetDataSourceResponse = PartialDataSourceObjectResponse | DataSourceObjectResponse;
/**
 * Retrieve a data source
 */
export declare const getDataSource: {
    readonly method: "get";
    readonly pathParams: readonly ["data_source_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: GetDataSourcePathParameters) => string;
};
type UpdateDataSourcePathParameters = {
    data_source_id: IdRequest;
};
type UpdateDataSourceBodyParameters = {
    title?: Array<RichTextItemRequest>;
    icon?: PageIconRequest | null;
    properties?: Record<string, ({
        name?: string;
        description?: PropertyDescriptionRequest | null;
    } & ({
        type?: "number";
        number: {
            format?: NumberFormat;
        };
    } | {
        type?: "formula";
        formula: {
            expression?: string;
        };
    } | {
        type?: "select";
        select: {
            options?: Array<{
                color?: SelectColor;
                description?: string | null;
            } & ({
                name: string;
                id?: string;
            } | {
                id: string;
                name?: string;
            })>;
        };
    } | {
        type?: "multi_select";
        multi_select: {
            options?: Array<{
                color?: SelectColor;
                description?: string | null;
            } & ({
                name: string;
                id?: string;
            } | {
                id: string;
                name?: string;
            })>;
        };
    } | {
        type?: "status";
        status: EmptyObject;
    } | {
        type?: "relation";
        relation: {
            data_source_id: IdRequest;
        } & ({
            type?: "single_property";
            single_property: EmptyObject;
        } | {
            type?: "dual_property";
            dual_property: {
                synced_property_id?: string;
                synced_property_name?: string;
            };
        });
    } | {
        type?: "rollup";
        rollup: {
            function: RollupFunction;
        } & ({
            relation_property_name: string;
            rollup_property_name: string;
        } | {
            relation_property_id: string;
            rollup_property_name: string;
        } | {
            relation_property_name: string;
            rollup_property_id: string;
        } | {
            relation_property_id: string;
            rollup_property_id: string;
        });
    } | {
        type?: "unique_id";
        unique_id: {
            prefix?: string | null;
        };
    } | {
        type?: "title";
        title: EmptyObject;
    } | {
        type?: "rich_text";
        rich_text: EmptyObject;
    } | {
        type?: "url";
        url: EmptyObject;
    } | {
        type?: "people";
        people: EmptyObject;
    } | {
        type?: "files";
        files: EmptyObject;
    } | {
        type?: "email";
        email: EmptyObject;
    } | {
        type?: "phone_number";
        phone_number: EmptyObject;
    } | {
        type?: "date";
        date: EmptyObject;
    } | {
        type?: "checkbox";
        checkbox: EmptyObject;
    } | {
        type?: "created_by";
        created_by: EmptyObject;
    } | {
        type?: "created_time";
        created_time: EmptyObject;
    } | {
        type?: "last_edited_by";
        last_edited_by: EmptyObject;
    } | {
        type?: "last_edited_time";
        last_edited_time: EmptyObject;
    } | {
        type?: "place";
        place: EmptyObject;
    })) | {
        name: string;
    } | null>;
    in_trash?: boolean;
    archived?: boolean;
    parent?: ParentOfDataSourceRequest;
};
export type UpdateDataSourceParameters = UpdateDataSourcePathParameters & UpdateDataSourceBodyParameters;
export type UpdateDataSourceResponse = PartialDataSourceObjectResponse | DataSourceObjectResponse;
/**
 * Update a data source
 */
export declare const updateDataSource: {
    readonly method: "patch";
    readonly pathParams: readonly ["data_source_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["title", "icon", "properties", "in_trash", "archived", "parent"];
    readonly path: (p: UpdateDataSourcePathParameters) => string;
};
type QueryDataSourcePathParameters = {
    data_source_id: IdRequest;
};
type QueryDataSourceQueryParameters = {
    filter_properties?: Array<string>;
};
type QueryDataSourceBodyParameters = {
    sorts?: Array<{
        property: string;
        direction: "ascending" | "descending";
    } | {
        timestamp: "created_time" | "last_edited_time";
        direction: "ascending" | "descending";
    }>;
    filter?: {
        or: GroupFilterOperatorArray;
    } | {
        and: GroupFilterOperatorArray;
    } | PropertyFilter | TimestampFilter;
    start_cursor?: string;
    page_size?: number;
    archived?: boolean;
    in_trash?: boolean;
    result_type?: "page" | "data_source";
};
export type QueryDataSourceParameters = QueryDataSourcePathParameters & QueryDataSourceQueryParameters & QueryDataSourceBodyParameters;
export type QueryDataSourceResponse = {
    type: "page_or_data_source";
    page_or_data_source: EmptyObject;
    object: "list";
    next_cursor: string | null;
    has_more: boolean;
    results: Array<PageObjectResponse | PartialPageObjectResponse | PartialDataSourceObjectResponse | DataSourceObjectResponse>;
};
/**
 * Query a data source
 */
export declare const queryDataSource: {
    readonly method: "post";
    readonly pathParams: readonly ["data_source_id"];
    readonly queryParams: readonly ["filter_properties"];
    readonly bodyParams: readonly ["sorts", "filter", "start_cursor", "page_size", "archived", "in_trash", "result_type"];
    readonly path: (p: QueryDataSourcePathParameters) => string;
};
type CreateDataSourceBodyParameters = {
    parent: ParentOfDataSourceRequest;
    properties: Record<string, PropertyConfigurationRequest>;
    title?: Array<RichTextItemRequest>;
    icon?: PageIconRequest | null;
};
export type CreateDataSourceParameters = CreateDataSourceBodyParameters;
export type CreateDataSourceResponse = PartialDataSourceObjectResponse | DataSourceObjectResponse;
/**
 * Create a data source
 */
export declare const createDataSource: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["parent", "properties", "title", "icon"];
    readonly path: () => string;
};
type ListDataSourceTemplatesPathParameters = {
    data_source_id: IdRequest;
};
type ListDataSourceTemplatesQueryParameters = {
    name?: string;
    start_cursor?: string;
    page_size?: number;
};
export type ListDataSourceTemplatesParameters = ListDataSourceTemplatesPathParameters & ListDataSourceTemplatesQueryParameters;
export type ListDataSourceTemplatesResponse = {
    templates: Array<{
        id: IdResponse;
        name: string;
        is_default: boolean;
    }>;
    has_more: boolean;
    next_cursor: IdResponse | null;
};
/**
 * List templates in a data source
 */
export declare const listDataSourceTemplates: {
    readonly method: "get";
    readonly pathParams: readonly ["data_source_id"];
    readonly queryParams: readonly ["name", "start_cursor", "page_size"];
    readonly bodyParams: readonly [];
    readonly path: (p: ListDataSourceTemplatesPathParameters) => string;
};
type GetDatabasePathParameters = {
    database_id: IdRequest;
};
export type GetDatabaseParameters = GetDatabasePathParameters;
export type GetDatabaseResponse = PartialDatabaseObjectResponse | DatabaseObjectResponse;
/**
 * Retrieve a database
 */
export declare const getDatabase: {
    readonly method: "get";
    readonly pathParams: readonly ["database_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: GetDatabasePathParameters) => string;
};
type UpdateDatabasePathParameters = {
    database_id: IdRequest;
};
type UpdateDatabaseBodyParameters = {
    parent?: {
        type: "page_id" | "workspace";
    } & ({
        type: "page_id";
        page_id: IdRequest;
    } | {
        type: "workspace";
        workspace: true;
    });
    title?: Array<RichTextItemRequest>;
    description?: Array<RichTextItemRequest>;
    is_inline?: boolean;
    icon?: PageIconRequest;
    cover?: PageCoverRequest;
    in_trash?: boolean;
    is_locked?: boolean;
};
export type UpdateDatabaseParameters = UpdateDatabasePathParameters & UpdateDatabaseBodyParameters;
export type UpdateDatabaseResponse = PartialDatabaseObjectResponse | DatabaseObjectResponse;
/**
 * Update a database
 */
export declare const updateDatabase: {
    readonly method: "patch";
    readonly pathParams: readonly ["database_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["parent", "title", "description", "is_inline", "icon", "cover", "in_trash", "is_locked"];
    readonly path: (p: UpdateDatabasePathParameters) => string;
};
type CreateDatabaseBodyParameters = {
    parent: {
        type: "page_id" | "workspace";
    } & ({
        type: "page_id";
        page_id: IdRequest;
    } | {
        type: "workspace";
        workspace: true;
    });
    title?: Array<RichTextItemRequest>;
    description?: Array<RichTextItemRequest>;
    is_inline?: boolean;
    initial_data_source?: InitialDataSourceRequest;
    icon?: PageIconRequest;
    cover?: PageCoverRequest;
};
export type CreateDatabaseParameters = CreateDatabaseBodyParameters;
export type CreateDatabaseResponse = PartialDatabaseObjectResponse | DatabaseObjectResponse;
/**
 * Create a database
 */
export declare const createDatabase: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["parent", "title", "description", "is_inline", "initial_data_source", "icon", "cover"];
    readonly path: () => string;
};
type SearchBodyParameters = {
    sort?: {
        timestamp: "last_edited_time";
        direction: "ascending" | "descending";
    };
    query?: string;
    start_cursor?: string;
    page_size?: number;
    filter?: {
        property: "object";
        value: "page" | "data_source";
    };
};
export type SearchParameters = SearchBodyParameters;
export type SearchResponse = {
    type: "page_or_data_source";
    page_or_data_source: EmptyObject;
    object: "list";
    next_cursor: string | null;
    has_more: boolean;
    results: Array<PageObjectResponse | PartialPageObjectResponse | PartialDataSourceObjectResponse | DataSourceObjectResponse>;
};
/**
 * Search by title
 */
export declare const search: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["sort", "query", "start_cursor", "page_size", "filter"];
    readonly path: () => string;
};
type CreateCommentBodyParameters = {
    rich_text: Array<RichTextItemRequest>;
    attachments?: Array<{
        file_upload_id: string;
        type?: "file_upload";
    }>;
    display_name?: {
        type: "integration";
    } | {
        type: "user";
    } | {
        type: "custom";
        custom: {
            name: string;
        };
    };
} & ({
    parent: {
        page_id: IdRequest;
        type?: "page_id";
    } | {
        block_id: IdRequest;
        type?: "block_id";
    };
} | {
    discussion_id: IdRequest;
});
export type CreateCommentParameters = CreateCommentBodyParameters;
export type CreateCommentResponse = PartialCommentObjectResponse | CommentObjectResponse;
/**
 * Create a comment
 */
export declare const createComment: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["rich_text", "attachments", "display_name", "parent", "discussion_id"];
    readonly path: () => string;
};
type ListCommentsQueryParameters = {
    block_id: IdRequest;
    start_cursor?: string;
    page_size?: number;
};
export type ListCommentsParameters = ListCommentsQueryParameters;
export type ListCommentsResponse = {
    object: "list";
    next_cursor: IdResponse | null;
    has_more: boolean;
    results: Array<CommentObjectResponse>;
    type: "comment";
    comment: EmptyObject;
};
/**
 * List comments
 */
export declare const listComments: {
    readonly method: "get";
    readonly pathParams: readonly [];
    readonly queryParams: readonly ["block_id", "start_cursor", "page_size"];
    readonly bodyParams: readonly [];
    readonly path: () => string;
};
type GetCommentPathParameters = {
    comment_id: IdRequest;
};
export type GetCommentParameters = GetCommentPathParameters;
export type GetCommentResponse = PartialCommentObjectResponse | CommentObjectResponse;
/**
 * Retrieve a comment
 */
export declare const getComment: {
    readonly method: "get";
    readonly pathParams: readonly ["comment_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: GetCommentPathParameters) => string;
};
type CreateFileUploadBodyParameters = {
    mode?: "single_part" | "multi_part" | "external_url";
    filename?: string;
    content_type?: string;
    number_of_parts?: number;
    external_url?: string;
};
export type CreateFileUploadParameters = CreateFileUploadBodyParameters;
export type CreateFileUploadResponse = FileUploadObjectResponse;
/**
 * Create a file upload
 */
export declare const createFileUpload: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["mode", "filename", "content_type", "number_of_parts", "external_url"];
    readonly path: () => string;
};
type ListFileUploadsQueryParameters = {
    status?: "pending" | "uploaded" | "expired" | "failed";
    start_cursor?: string;
    page_size?: number;
};
export type ListFileUploadsParameters = ListFileUploadsQueryParameters;
export type ListFileUploadsResponse = {
    object: "list";
    next_cursor: IdResponse | null;
    has_more: boolean;
    results: Array<FileUploadObjectResponse>;
    type: "file_upload";
    file_upload: EmptyObject;
};
/**
 * List file uploads
 */
export declare const listFileUploads: {
    readonly method: "get";
    readonly pathParams: readonly [];
    readonly queryParams: readonly ["status", "start_cursor", "page_size"];
    readonly bodyParams: readonly [];
    readonly path: () => string;
};
type SendFileUploadPathParameters = {
    file_upload_id: IdRequest;
};
type SendFileUploadFormDataParameters = {
    file: {
        filename?: string;
        data: string | Blob;
    };
    part_number?: string;
};
export type SendFileUploadParameters = SendFileUploadPathParameters & SendFileUploadFormDataParameters;
export type SendFileUploadResponse = FileUploadObjectResponse;
/**
 * Upload a file
 */
export declare const sendFileUpload: {
    readonly method: "post";
    readonly pathParams: readonly ["file_upload_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly formDataParams: readonly ["file", "part_number"];
    readonly path: (p: SendFileUploadPathParameters) => string;
};
type CompleteFileUploadPathParameters = {
    file_upload_id: IdRequest;
};
export type CompleteFileUploadParameters = CompleteFileUploadPathParameters;
export type CompleteFileUploadResponse = FileUploadObjectResponse;
/**
 * Complete a multi-part file upload
 */
export declare const completeFileUpload: {
    readonly method: "post";
    readonly pathParams: readonly ["file_upload_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: CompleteFileUploadPathParameters) => string;
};
type GetFileUploadPathParameters = {
    file_upload_id: IdRequest;
};
export type GetFileUploadParameters = GetFileUploadPathParameters;
export type GetFileUploadResponse = FileUploadObjectResponse;
/**
 * Retrieve a file upload
 */
export declare const getFileUpload: {
    readonly method: "get";
    readonly pathParams: readonly ["file_upload_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly [];
    readonly path: (p: GetFileUploadPathParameters) => string;
};
type OauthTokenBodyParameters = {
    grant_type: "authorization_code";
    code: string;
    redirect_uri?: string;
    external_account?: {
        key: string;
        name: string;
    };
} | {
    grant_type: "refresh_token";
    refresh_token: string;
};
export type OauthTokenParameters = OauthTokenBodyParameters;
export type OauthTokenResponse = {
    access_token: string;
    token_type: "bearer";
    refresh_token: string | null;
    bot_id: string;
    workspace_icon: string | null;
    workspace_name: string | null;
    workspace_id: string;
    owner: {
        type: "user";
        user: {
            type: "person";
            person: {
                email: string;
            };
            name: string | null;
            avatar_url: string | null;
            id: IdRequest;
            object: "user";
        } | PartialUserObjectResponse;
    } | {
        type: "workspace";
        workspace: true;
    };
    duplicated_template_id: string | null;
    request_id?: string;
};
/**
 * Exchange an authorization code for an access and refresh token
 */
export declare const oauthToken: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["grant_type", "code", "redirect_uri", "external_account", "refresh_token"];
    readonly path: () => string;
};
type OauthRevokeBodyParameters = {
    token: string;
};
export type OauthRevokeParameters = OauthRevokeBodyParameters;
export type OauthRevokeResponse = {
    request_id?: string;
};
/**
 * Revoke a token
 */
export declare const oauthRevoke: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["token"];
    readonly path: () => string;
};
type OauthIntrospectBodyParameters = {
    token: string;
};
export type OauthIntrospectParameters = OauthIntrospectBodyParameters;
export type OauthIntrospectResponse = {
    active: boolean;
    scope?: string;
    iat?: number;
    request_id?: string;
};
/**
 * Introspect a token
 */
export declare const oauthIntrospect: {
    readonly method: "post";
    readonly pathParams: readonly [];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["token"];
    readonly path: () => string;
};
type MovePagePathParameters = {
    page_id: IdRequest;
};
type MovePageBodyParameters = {
    parent: {
        page_id: IdRequest;
        type?: "page_id";
    } | {
        data_source_id: IdRequest;
        type?: "data_source_id";
    };
};
export type MovePageParameters = MovePagePathParameters & MovePageBodyParameters;
export type MovePageResponse = PartialPageObjectResponse | PageObjectResponse;
/**
 * Move a page
 */
export declare const movePage: {
    readonly method: "post";
    readonly pathParams: readonly ["page_id"];
    readonly queryParams: readonly [];
    readonly bodyParams: readonly ["parent"];
    readonly path: (p: MovePagePathParameters) => string;
};
export {};
//# sourceMappingURL=api-endpoints.d.ts.map