import * as openapi_fetch from 'openapi-fetch';
import { components, paths } from '../schema.cjs';
import { SetRequired } from 'type-fest';
import { Client } from '../client.cjs';
import { PathParams } from '../types/utilities.cjs';

type RequestParams<T extends (...args: any) => any> = Parameters<T>[2] extends undefined ? never : Parameters<T>[0];
type RequestResult<T extends (...args: any) => Promise<any>> = Exclude<Awaited<ReturnType<T>>, undefined>;
type GetActivityParams = RequestParams<typeof getActivity>;
type GetActivityResult = RequestResult<typeof getActivity>;
declare const getActivity: (params: {
    id: string;
    actionLimit?: number | undefined;
    actionPage?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            action_page?: components["parameters"]["action_page_query"];
        };
        header?: never;
        path: {
            id: components["parameters"]["activity_id_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["ActivityResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        actions: {
            from: string;
            metadata: {
                authors?: {
                    name: string;
                }[] | undefined;
                description: string;
                pubDate?: string | undefined;
                title: string;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "withdraw" | "deposit";
                sourceNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                targetNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "add" | "borrow" | "collect" | "remove" | "repay" | "supply" | "withdraw";
                tokens: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                }[];
            } | {
                action: "stake" | "unstake" | "claim";
                period?: {
                    end?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                    start?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                } | undefined;
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                from?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                to?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                address?: string | undefined;
                bio?: string | undefined;
                expiry?: string | undefined;
                handle?: string | undefined;
                imageUri?: string | undefined;
                key?: string | undefined;
                name?: string | undefined;
                profileId?: string | undefined;
                value?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "remove" | "appoint" | undefined;
                profile?: {
                    action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                    address?: string | undefined;
                    bio?: string | undefined;
                    expiry?: string | undefined;
                    handle?: string | undefined;
                    imageUri?: string | undefined;
                    key?: string | undefined;
                    name?: string | undefined;
                    profileId?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                proxyAddress: string;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "buy" | "sell" | "list" | undefined;
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            };
            platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
            relatedUrls: string[];
            tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
            to: string;
            type: string;
        }[];
        calldata?: {
            functionHash?: string | undefined;
            parsedFunction?: string | undefined;
            raw?: string | undefined;
        } | undefined;
        direction?: "in" | "out" | "self" | undefined;
        fee?: {
            address?: string | undefined;
            amount: string;
            decimal?: number | undefined;
        } | undefined;
        from: string;
        id: string;
        index: number;
        network?: "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | undefined;
        owner: string;
        platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
        success: boolean;
        tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote" | undefined;
    } | undefined;
    meta?: {
        totalPages: number;
    } | undefined;
}>;
type GetActivitiesParams = RequestParams<typeof getActivities>;
type GetActivitiesResult = RequestResult<typeof getActivities>;
declare const getActivities: (params: {
    account: string;
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    network?: ("arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer")[] | undefined;
    platform?: ("1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion")[] | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: ("collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown")[] | undefined;
    type?: ("post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote")[] | undefined;
    untilTimestamp?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            cursor?: components["parameters"]["cursor_query"];
            direction?: components["parameters"]["direction_query"];
            limit?: components["parameters"]["limit_query"];
            network?: components["parameters"]["network_query"];
            platform?: components["parameters"]["platform_query"];
            since_timestamp?: components["parameters"]["since_timestamp_query"];
            success?: components["parameters"]["success_query"];
            tag?: components["parameters"]["action_tag_query"];
            type?: components["parameters"]["action_type_query"];
            until_timestamp?: components["parameters"]["until_timestamp_query"];
        };
        header?: never;
        path: {
            account: components["parameters"]["account_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["ActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authors?: {
                    name: string;
                }[] | undefined;
                description: string;
                pubDate?: string | undefined;
                title: string;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "withdraw" | "deposit";
                sourceNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                targetNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "add" | "borrow" | "collect" | "remove" | "repay" | "supply" | "withdraw";
                tokens: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                }[];
            } | {
                action: "stake" | "unstake" | "claim";
                period?: {
                    end?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                    start?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                } | undefined;
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                from?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                to?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                address?: string | undefined;
                bio?: string | undefined;
                expiry?: string | undefined;
                handle?: string | undefined;
                imageUri?: string | undefined;
                key?: string | undefined;
                name?: string | undefined;
                profileId?: string | undefined;
                value?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "remove" | "appoint" | undefined;
                profile?: {
                    action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                    address?: string | undefined;
                    bio?: string | undefined;
                    expiry?: string | undefined;
                    handle?: string | undefined;
                    imageUri?: string | undefined;
                    key?: string | undefined;
                    name?: string | undefined;
                    profileId?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                proxyAddress: string;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "buy" | "sell" | "list" | undefined;
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            };
            platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
            relatedUrls: string[];
            tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
            to: string;
            type: string;
        }[];
        calldata?: {
            functionHash?: string | undefined;
            parsedFunction?: string | undefined;
            raw?: string | undefined;
        } | undefined;
        direction?: "in" | "out" | "self" | undefined;
        fee?: {
            address?: string | undefined;
            amount: string;
            decimal?: number | undefined;
        } | undefined;
        from: string;
        id: string;
        index: number;
        network?: "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | undefined;
        owner: string;
        platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
        success: boolean;
        tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote" | undefined;
    }[];
    cursor: string | undefined;
}>;
type GetActivitiesByAccountsParams = SetRequired<Partial<PathParams<"/decentralized/accounts", "post">>, "accounts">;
type GetActivitiesByAccountsResult = RequestResult<typeof getActivitiesByAccounts>;
declare const getActivitiesByAccounts: (params: {
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    network?: ("arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer")[] | undefined;
    platform?: ("1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion")[] | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: ("collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown")[] | undefined;
    type?: ("post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote")[] | undefined;
    untilTimestamp?: number | undefined;
    accounts: string[];
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody: components["requestBodies"]["BatchGetAccountsActivities"];
    responses: {
        200: components["responses"]["ActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authors?: {
                    name: string;
                }[] | undefined;
                description: string;
                pubDate?: string | undefined;
                title: string;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "withdraw" | "deposit";
                sourceNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                targetNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "add" | "borrow" | "collect" | "remove" | "repay" | "supply" | "withdraw";
                tokens: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                }[];
            } | {
                action: "stake" | "unstake" | "claim";
                period?: {
                    end?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                    start?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                } | undefined;
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                from?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                to?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                address?: string | undefined;
                bio?: string | undefined;
                expiry?: string | undefined;
                handle?: string | undefined;
                imageUri?: string | undefined;
                key?: string | undefined;
                name?: string | undefined;
                profileId?: string | undefined;
                value?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "remove" | "appoint" | undefined;
                profile?: {
                    action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                    address?: string | undefined;
                    bio?: string | undefined;
                    expiry?: string | undefined;
                    handle?: string | undefined;
                    imageUri?: string | undefined;
                    key?: string | undefined;
                    name?: string | undefined;
                    profileId?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                proxyAddress: string;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "buy" | "sell" | "list" | undefined;
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            };
            platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
            relatedUrls: string[];
            tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
            to: string;
            type: string;
        }[];
        calldata?: {
            functionHash?: string | undefined;
            parsedFunction?: string | undefined;
            raw?: string | undefined;
        } | undefined;
        direction?: "in" | "out" | "self" | undefined;
        fee?: {
            address?: string | undefined;
            amount: string;
            decimal?: number | undefined;
        } | undefined;
        from: string;
        id: string;
        index: number;
        network?: "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | undefined;
        owner: string;
        platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
        success: boolean;
        tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote" | undefined;
    }[];
    cursor: string | undefined;
}>;
type GetRSSActivityParams = RequestParams<typeof getRSSActivity>;
type GetRSSActivityResult = RequestResult<typeof getRSSActivity>;
declare const getRSSActivity: (params: {
    path: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            path: components["parameters"]["rss_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["RSSActivitiesResponse"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authors?: {
                    name: string;
                }[] | undefined;
                description: string;
                pubDate?: string | undefined;
                title: string;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "withdraw" | "deposit";
                sourceNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                targetNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "add" | "borrow" | "collect" | "remove" | "repay" | "supply" | "withdraw";
                tokens: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                }[];
            } | {
                action: "stake" | "unstake" | "claim";
                period?: {
                    end?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                    start?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                } | undefined;
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                from?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                to?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                address?: string | undefined;
                bio?: string | undefined;
                expiry?: string | undefined;
                handle?: string | undefined;
                imageUri?: string | undefined;
                key?: string | undefined;
                name?: string | undefined;
                profileId?: string | undefined;
                value?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "remove" | "appoint" | undefined;
                profile?: {
                    action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                    address?: string | undefined;
                    bio?: string | undefined;
                    expiry?: string | undefined;
                    handle?: string | undefined;
                    imageUri?: string | undefined;
                    key?: string | undefined;
                    name?: string | undefined;
                    profileId?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                proxyAddress: string;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "buy" | "sell" | "list" | undefined;
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            };
            platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
            relatedUrls: string[];
            tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
            to: string;
            type: string;
        }[];
        calldata?: {
            functionHash?: string | undefined;
            parsedFunction?: string | undefined;
            raw?: string | undefined;
        } | undefined;
        direction?: "in" | "out" | "self" | undefined;
        fee?: {
            address?: string | undefined;
            amount: string;
            decimal?: number | undefined;
        } | undefined;
        from: string;
        id: string;
        index: number;
        network?: "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | undefined;
        owner: string;
        platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
        success: boolean;
        tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote" | undefined;
    }[];
    cursor: string | undefined;
}>;
type GetNetworkActivitiesParams = RequestParams<typeof getNetworkActivities>;
type GetNetworkActivitiesResult = RequestResult<typeof getNetworkActivities>;
declare const getNetworkActivities: (params: {
    network: string;
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    platform?: ("1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion")[] | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: ("collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown")[] | undefined;
    type?: ("post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote")[] | undefined;
    untilTimestamp?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            cursor?: components["parameters"]["cursor_query"];
            direction?: components["parameters"]["direction_query"];
            limit?: components["parameters"]["limit_query"];
            platform?: components["parameters"]["platform_query"];
            since_timestamp?: components["parameters"]["since_timestamp_query"];
            success?: components["parameters"]["success_query"];
            tag?: components["parameters"]["tag_query"];
            type?: components["parameters"]["type_query"];
            until_timestamp?: components["parameters"]["until_timestamp_query"];
        };
        header?: never;
        path: {
            network: components["parameters"]["network_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["ActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authors?: {
                    name: string;
                }[] | undefined;
                description: string;
                pubDate?: string | undefined;
                title: string;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "withdraw" | "deposit";
                sourceNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                targetNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "add" | "borrow" | "collect" | "remove" | "repay" | "supply" | "withdraw";
                tokens: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                }[];
            } | {
                action: "stake" | "unstake" | "claim";
                period?: {
                    end?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                    start?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                } | undefined;
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                from?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                to?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                address?: string | undefined;
                bio?: string | undefined;
                expiry?: string | undefined;
                handle?: string | undefined;
                imageUri?: string | undefined;
                key?: string | undefined;
                name?: string | undefined;
                profileId?: string | undefined;
                value?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "remove" | "appoint" | undefined;
                profile?: {
                    action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                    address?: string | undefined;
                    bio?: string | undefined;
                    expiry?: string | undefined;
                    handle?: string | undefined;
                    imageUri?: string | undefined;
                    key?: string | undefined;
                    name?: string | undefined;
                    profileId?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                proxyAddress: string;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "buy" | "sell" | "list" | undefined;
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            };
            platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
            relatedUrls: string[];
            tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
            to: string;
            type: string;
        }[];
        calldata?: {
            functionHash?: string | undefined;
            parsedFunction?: string | undefined;
            raw?: string | undefined;
        } | undefined;
        direction?: "in" | "out" | "self" | undefined;
        fee?: {
            address?: string | undefined;
            amount: string;
            decimal?: number | undefined;
        } | undefined;
        from: string;
        id: string;
        index: number;
        network?: "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | undefined;
        owner: string;
        platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
        success: boolean;
        tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote" | undefined;
    }[];
    cursor: string | undefined;
}>;
type GetPlatformActivitiesParams = RequestParams<typeof getPlatformActivities>;
type GetPlatformActivitiesResult = RequestResult<typeof getPlatformActivities>;
declare const getPlatformActivities: (params: {
    platform: string;
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    network?: ("arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer")[] | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: ("collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown")[] | undefined;
    type?: ("post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote")[] | undefined;
    untilTimestamp?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            cursor?: components["parameters"]["cursor_query"];
            direction?: components["parameters"]["direction_query"];
            limit?: components["parameters"]["limit_query"];
            network?: components["parameters"]["network_query"];
            since_timestamp?: components["parameters"]["since_timestamp_query"];
            success?: components["parameters"]["success_query"];
            tag?: components["parameters"]["tag_query"];
            type?: components["parameters"]["type_query"];
            until_timestamp?: components["parameters"]["until_timestamp_query"];
        };
        header?: never;
        path: {
            platform: components["parameters"]["platform_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["ActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authors?: {
                    name: string;
                }[] | undefined;
                description: string;
                pubDate?: string | undefined;
                title: string;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "withdraw" | "deposit";
                sourceNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                targetNetwork: "unknown" | "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | "bitcoin" | "rsshub" | "savm";
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "approve" | "revoke";
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                action: "add" | "borrow" | "collect" | "remove" | "repay" | "supply" | "withdraw";
                tokens: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                }[];
            } | {
                action: "stake" | "unstake" | "claim";
                period?: {
                    end?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                    start?: {
                        ext: number;
                        loc?: {
                            cacheEnd: number;
                            cacheStart: number;
                            cacheZone?: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            } | undefined;
                            extend: string;
                            name: string;
                            tx: {
                                index: number;
                                isstd: boolean;
                                isutc: boolean;
                                when: number;
                            }[];
                            zone: {
                                isDST: boolean;
                                name: string;
                                offset: number;
                            }[];
                        } | undefined;
                        wall: number;
                    } | undefined;
                } | undefined;
                token?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                from?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                to?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                address?: string | undefined;
                bio?: string | undefined;
                expiry?: string | undefined;
                handle?: string | undefined;
                imageUri?: string | undefined;
                key?: string | undefined;
                name?: string | undefined;
                profileId?: string | undefined;
                value?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "remove" | "appoint" | undefined;
                profile?: {
                    action?: "create" | "renew" | "unwrap" | "update" | "wrap" | undefined;
                    address?: string | undefined;
                    bio?: string | undefined;
                    expiry?: string | undefined;
                    handle?: string | undefined;
                    imageUri?: string | undefined;
                    key?: string | undefined;
                    name?: string | undefined;
                    profileId?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                proxyAddress: string;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                action?: "buy" | "sell" | "list" | undefined;
                address?: string | undefined;
                cost?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            } | {
                address?: string | undefined;
                decimals?: number | undefined;
                id?: string | undefined;
                name?: string | undefined;
                parsedImageUrl?: string | undefined;
                standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                symbol?: string | undefined;
                uri?: string | undefined;
                value?: string | undefined;
            };
            platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
            relatedUrls: string[];
            tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
            to: string;
            type: string;
        }[];
        calldata?: {
            functionHash?: string | undefined;
            parsedFunction?: string | undefined;
            raw?: string | undefined;
        } | undefined;
        direction?: "in" | "out" | "self" | undefined;
        fee?: {
            address?: string | undefined;
            amount: string;
            decimal?: number | undefined;
        } | undefined;
        from: string;
        id: string;
        index: number;
        network?: "arbitrum" | "arweave" | "avax" | "base" | "binance-smart-chain" | "crossbell" | "ethereum" | "farcaster" | "gnosis" | "linea" | "mastodon" | "near" | "optimism" | "polygon" | "vsl" | "x-layer" | undefined;
        owner: string;
        platform?: "1inch" | "AAVE" | "Aavegotchi" | "Arbitrum" | "Base" | "BendDAO" | "Cow" | "Crossbell" | "Curve" | "ENS" | "Farcaster" | "Highlight" | "IQWiki" | "KiwiStand" | "Lens" | "LiNEAR" | "Lido" | "Linea" | "LooksRare" | "Matters" | "Mirror" | "NearSocial" | "Nouns" | "OpenSea" | "Optimism" | "Paragraph" | "Paraswap" | "Polymarket" | "RSS3" | "Rainbow" | "SAVM" | "Stargate" | "Uniswap" | "Unknown" | "VSL" | "Zerion" | undefined;
        success: boolean;
        tag?: "collectible" | "exchange" | "governance" | "metaverse" | "rss" | "social" | "transaction" | "unknown" | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote" | undefined;
    }[];
    cursor: string | undefined;
}>;
type GetFederatedActivitiesByAccountParams = RequestParams<typeof getFederatedActivitiesByAccount>;
type GetFederatedActivitiesByAccountResult = RequestResult<typeof getFederatedActivitiesByAccount>;
declare const getFederatedActivitiesByAccount: (params: {
    account: string;
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    network?: "mastodon"[] | undefined;
    platform?: "Mastodon"[] | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: "social"[] | undefined;
    type?: ("post" | "comment" | "share")[] | undefined;
    untilTimestamp?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            cursor?: components["parameters"]["cursor_query"];
            direction?: components["parameters"]["direction_query"];
            limit?: components["parameters"]["limit_query"];
            network?: components["parameters"]["federated_network_query"];
            platform?: components["parameters"]["federated_platform_query"];
            since_timestamp?: components["parameters"]["since_timestamp_query"];
            success?: components["parameters"]["success_query"];
            tag?: components["parameters"]["federated_action_tag_query"];
            type?: components["parameters"]["federated_action_type_query"];
            until_timestamp?: components["parameters"]["until_timestamp_query"];
        };
        header?: never;
        path: {
            account: components["parameters"]["federated_account_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["FederatedActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            };
            platform?: string | undefined;
            relatedUrls: string[];
            tag: string;
            to: string;
            type: string;
        }[];
        direction?: "in" | "out" | "self" | undefined;
        from: string;
        id: string;
        index: number;
        network?: string | undefined;
        owner: string;
        platform?: string | undefined;
        success: boolean;
        tag?: string | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "comment" | "share" | undefined;
    }[];
    meta?: {
        cursor: string;
    } | undefined;
}>;
type GetFederatedActivityParams = RequestParams<typeof getFederatedActivity>;
type GetFederatedActivityResult = RequestResult<typeof getFederatedActivity>;
declare const getFederatedActivity: (params: {
    id: string;
    actionLimit?: number | undefined;
    actionPage?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            action_page?: components["parameters"]["action_page_query"];
        };
        header?: never;
        path: {
            id: components["parameters"]["federated_activity_id_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["FederatedActivityResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        actions: {
            from: string;
            metadata: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            };
            platform?: string | undefined;
            relatedUrls: string[];
            tag: string;
            to: string;
            type: string;
        }[];
        direction?: "in" | "out" | "self" | undefined;
        from: string;
        id: string;
        index: number;
        network?: string | undefined;
        owner: string;
        platform?: string | undefined;
        success: boolean;
        tag?: string | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "comment" | "share" | undefined;
    } | undefined;
    meta?: {
        totalPages: number;
    } | undefined;
}>;
type GetFederatedActivitiesByAccountsParams = RequestParams<typeof getFederatedActivitiesByAccounts>;
type GetFederatedActivitiesByAccountsResult = RequestResult<typeof getFederatedActivitiesByAccounts>;
declare const getFederatedActivitiesByAccounts: (params: {
    accounts?: string[] | undefined;
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    network?: string | undefined;
    platform?: string | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: string | undefined;
    type?: ("post" | "delete" | "unknown" | "approval" | "auction" | "bridge" | "burn" | "comment" | "feed" | "liquidity" | "loan" | "mint" | "profile" | "proposal" | "proxy" | "revise" | "reward" | "share" | "staking" | "swap" | "trade" | "transfer" | "vote")[] | undefined;
    untilTimestamp?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody: components["requestBodies"]["BatchGetFederatedAccountsActivities"];
    responses: {
        200: components["responses"]["FederatedActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            };
            platform?: string | undefined;
            relatedUrls: string[];
            tag: string;
            to: string;
            type: string;
        }[];
        direction?: "in" | "out" | "self" | undefined;
        from: string;
        id: string;
        index: number;
        network?: string | undefined;
        owner: string;
        platform?: string | undefined;
        success: boolean;
        tag?: string | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "comment" | "share" | undefined;
    }[];
    meta?: {
        cursor: string;
    } | undefined;
}>;
type GetFederatedNetworkActivitiesParams = RequestParams<typeof getFederatedNetworkActivities>;
type GetFederatedNetworkActivitiesResult = RequestResult<typeof getFederatedNetworkActivities>;
declare const getFederatedNetworkActivities: (params: {
    network: string;
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    platform?: "Mastodon"[] | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: "social"[] | undefined;
    type?: ("post" | "comment" | "share")[] | undefined;
    untilTimestamp?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            cursor?: components["parameters"]["cursor_query"];
            direction?: components["parameters"]["direction_query"];
            limit?: components["parameters"]["limit_query"];
            platform?: components["parameters"]["federated_platform_query"];
            since_timestamp?: components["parameters"]["since_timestamp_query"];
            success?: components["parameters"]["success_query"];
            tag?: components["parameters"]["federated_action_tag_query"];
            type?: components["parameters"]["federated_action_type_query"];
            until_timestamp?: components["parameters"]["until_timestamp_query"];
        };
        header?: never;
        path: {
            network: components["parameters"]["federated_network_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["FederatedActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            };
            platform?: string | undefined;
            relatedUrls: string[];
            tag: string;
            to: string;
            type: string;
        }[];
        direction?: "in" | "out" | "self" | undefined;
        from: string;
        id: string;
        index: number;
        network?: string | undefined;
        owner: string;
        platform?: string | undefined;
        success: boolean;
        tag?: string | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "comment" | "share" | undefined;
    }[];
    meta?: {
        cursor: string;
    } | undefined;
}>;
type GetFederatedPlatformActivitiesParams = RequestParams<typeof getFederatedPlatformActivities>;
type GetFederatedPlatformActivitiesResult = RequestResult<typeof getFederatedPlatformActivities>;
declare const getFederatedPlatformActivities: (params: {
    platform: string;
    actionLimit?: number | undefined;
    cursor?: string | undefined;
    direction?: "in" | "out" | "self" | undefined;
    limit?: number | undefined;
    network?: "mastodon"[] | undefined;
    sinceTimestamp?: number | undefined;
    success?: boolean | undefined;
    tag?: "social"[] | undefined;
    type?: ("post" | "comment" | "share")[] | undefined;
    untilTimestamp?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            action_limit?: components["parameters"]["action_limit_query"];
            cursor?: components["parameters"]["cursor_query"];
            direction?: components["parameters"]["direction_query"];
            limit?: components["parameters"]["limit_query"];
            network?: components["parameters"]["federated_network_query"];
            since_timestamp?: components["parameters"]["since_timestamp_query"];
            success?: components["parameters"]["success_query"];
            tag?: components["parameters"]["federated_action_tag_query"];
            type?: components["parameters"]["federated_action_type_query"];
            until_timestamp?: components["parameters"]["until_timestamp_query"];
        };
        header?: never;
        path: {
            platform: components["parameters"]["federated_platform_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["FederatedActivitiesResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        actions: {
            from: string;
            metadata: {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: any | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            } | {
                authorUrl?: string | undefined;
                body?: string | undefined;
                contentUri?: string | undefined;
                handle?: string | undefined;
                media?: {
                    address: string;
                    mimeType: string;
                }[] | undefined;
                profileId?: string | undefined;
                publicationId?: string | undefined;
                reward?: {
                    address?: string | undefined;
                    decimals?: number | undefined;
                    id?: string | undefined;
                    name?: string | undefined;
                    parsedImageUrl?: string | undefined;
                    standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                    symbol?: string | undefined;
                    uri?: string | undefined;
                    value?: string | undefined;
                } | undefined;
                summary?: string | undefined;
                tags?: string[] | undefined;
                target?: {
                    authorUrl?: string | undefined;
                    body?: string | undefined;
                    contentUri?: string | undefined;
                    handle?: string | undefined;
                    media?: {
                        address: string;
                        mimeType: string;
                    }[] | undefined;
                    profileId?: string | undefined;
                    publicationId?: string | undefined;
                    reward?: {
                        address?: string | undefined;
                        decimals?: number | undefined;
                        id?: string | undefined;
                        name?: string | undefined;
                        parsedImageUrl?: string | undefined;
                        standard?: "Unknown" | "ERC-20" | "NEP-141" | "ERC-165" | "ERC-721" | "ERC-1155" | "ERC-1967" | undefined;
                        symbol?: string | undefined;
                        uri?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    summary?: string | undefined;
                    tags?: string[] | undefined;
                    target?: any | undefined;
                    targetUrl?: string | undefined;
                    timestamp?: number | undefined;
                    title?: string | undefined;
                } | undefined;
                targetUrl?: string | undefined;
                timestamp?: number | undefined;
                title?: string | undefined;
            };
            platform?: string | undefined;
            relatedUrls: string[];
            tag: string;
            to: string;
            type: string;
        }[];
        direction?: "in" | "out" | "self" | undefined;
        from: string;
        id: string;
        index: number;
        network?: string | undefined;
        owner: string;
        platform?: string | undefined;
        success: boolean;
        tag?: string | undefined;
        timestamp: number;
        to: string;
        totalActions: number;
        type?: "post" | "comment" | "share" | undefined;
    }[];
    meta?: {
        cursor: string;
    } | undefined;
}>;
type GetBridgingTransactionsParams = RequestParams<typeof getBridgingTransactions>;
type GetBridgingTransactionsResult = RequestResult<typeof getBridgingTransactions>;
declare const getBridgingTransactions: (params: {
    address?: string | undefined;
    cursor?: string | undefined;
    limit?: number | undefined;
    receiver?: string | undefined;
    sender?: string | undefined;
    type?: "withdraw" | "deposit" | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            address?: components["parameters"]["address_query"];
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
            receiver?: components["parameters"]["receiver_query"];
            sender?: components["parameters"]["sender_query"];
            type?: components["parameters"]["bridging_type_query"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["BridgeTransactionsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        event?: {
            deposit?: {
                finalized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                initialized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            withdraw?: {
                finalized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                initialized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                proved?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
        } | undefined;
        id: string;
        receiver: string;
        sender: string;
        token?: {
            address: {
                l1: string;
                l2: string;
            };
            value: string;
        } | undefined;
    }[] | undefined;
}>;
type GetBridgingTransactionParams = RequestParams<typeof getBridgingTransaction>;
type GetBridgingTransactionResult = RequestResult<typeof getBridgingTransaction>;
declare const getBridgingTransaction: (params: {
    transactionHash: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            transaction_hash: components["parameters"]["bridging_transaction_hash_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["BridgeTransactionByHashResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        event?: {
            deposit?: {
                finalized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                initialized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            withdraw?: {
                finalized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                initialized?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                proved?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
        } | undefined;
        id: string;
        receiver: string;
        sender: string;
        token?: {
            address: {
                l1: string;
                l2: string;
            };
            value: string;
        } | undefined;
    } | undefined;
}>;
type GetStakingTransactionsParams = RequestParams<typeof getStakingTransactions>;
type GetStakingTransactionsResult = RequestResult<typeof getStakingTransactions>;
declare const getStakingTransactions: (params: {
    cursor?: string | undefined;
    limit?: number | undefined;
    node?: string | undefined;
    pending?: boolean | undefined;
    staker?: string | undefined;
    type?: "withdraw" | "stake" | "unstake" | "deposit" | "merge_chips" | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
            node?: components["parameters"]["node_query"];
            pending?: components["parameters"]["pending_query"];
            staker?: components["parameters"]["staker_query"];
            type?: components["parameters"]["staking_type_query"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["StakeTransactionsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor?: string | undefined;
    data?: {
        chipIds?: number[] | null | undefined;
        event?: {
            deposit?: {
                deposited?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            mergeChips?: {
                merged?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            stake?: {
                staked?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            unstake?: {
                claimed?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                requested?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            withdraw?: {
                claimed?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                requested?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
        } | undefined;
        id: string;
        node: string;
        staker: string;
        value: string;
    }[] | undefined;
}>;
type GetStakingTransactionParams = RequestParams<typeof getStakingTransaction>;
type GetStakingTransactionResult = RequestResult<typeof getStakingTransaction>;
declare const getStakingTransaction: (params: {
    transactionHash: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            transaction_hash: components["parameters"]["staking_transaction_hash_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["StakeTransactionByHashResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        chipIds?: number[] | null | undefined;
        event?: {
            deposit?: {
                deposited?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            mergeChips?: {
                merged?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            stake?: {
                staked?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            unstake?: {
                claimed?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                requested?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
            withdraw?: {
                claimed?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
                requested?: {
                    block: {
                        hash: string;
                        number: number;
                        timestamp: number;
                    };
                    metadata?: {
                        burnedTokenIds?: number[] | undefined;
                        newTokenId?: number | undefined;
                    } | null | undefined;
                    transaction: {
                        hash: string;
                        index: number;
                    };
                } | null | undefined;
            } | null | undefined;
        } | undefined;
        id: string;
        node: string;
        staker: string;
        value: string;
    } | undefined;
}>;
type GetStakingsParams = RequestParams<typeof getStakings>;
type GetStakingsResult = RequestResult<typeof getStakings>;
declare const getStakings: (params: {
    cursor?: string | undefined;
    limit?: number | undefined;
    nodeAddress?: string | undefined;
    stakerAddress?: string | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
            node_address?: components["parameters"]["node_address_query"];
            staker_address?: components["parameters"]["staker_address_query"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["StakeStakingsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor: string;
    data: {
        chips: {
            showcase: {
                id: number;
                latestValue: string;
                metadata: {
                    description: string;
                    image: string;
                    name: string;
                };
                node: string;
                owner: string;
                value: string;
            }[];
            total: number;
        };
        node: string;
        staker: string;
    }[];
}>;
type GetStakingProfitParams = RequestParams<typeof getStakingProfit>;
type GetStakingProfitResult = RequestResult<typeof getStakingProfit>;
declare const getStakingProfit: (params: {
    stakerAddress: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            staker_address: components["parameters"]["staker_address_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["StakingProfitResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        oneDay?: {
            date: string;
            profitAndLoss: string;
            totalChipAmount: string;
            totalChipValue: string;
        } | undefined;
        oneMonth?: {
            date: string;
            profitAndLoss: string;
            totalChipAmount: string;
            totalChipValue: string;
        } | undefined;
        oneWeek?: {
            date: string;
            profitAndLoss: string;
            totalChipAmount: string;
            totalChipValue: string;
        } | undefined;
        owner: string;
        totalChipAmount: string;
        totalChipValue: string;
    } | undefined;
}>;
type GetChipsParams = RequestParams<typeof getChips>;
type GetChipsResult = RequestResult<typeof getChips>;
declare const getChips: (params: {
    cursor?: string | undefined;
    id?: number[] | undefined;
    limit?: number | undefined;
    node?: string | undefined;
    owner?: string | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            cursor?: components["parameters"]["cursor_query"];
            id?: components["parameters"]["chip_ids_query"];
            limit?: components["parameters"]["limit_1_200"];
            node?: components["parameters"]["node_query"];
            owner?: components["parameters"]["owner_query"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["ChipsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor: string;
    data: {
        id: number;
        latestValue: string;
        metadata: {
            description: string;
            image: string;
            name: string;
        };
        node: string;
        owner: string;
        value: string;
    }[];
}>;
type GetChipParams = RequestParams<typeof getChip>;
type GetChipResult = RequestResult<typeof getChip>;
declare const getChip: (params: {
    chipId: number;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            chip_id: components["parameters"]["chip_id_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["ChipResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    id: number;
    latestValue: string;
    metadata: {
        description: string;
        image: string;
        name: string;
    };
    node: string;
    owner: string;
    value: string;
}>;
type GetChipSvgParams = RequestParams<typeof getChipSvg>;
type GetChipSvgResult = RequestResult<typeof getChipSvg>;
declare const getChipSvgURL: (params: GetChipSvgParams, client?: Client) => URL;
declare const getChipSvgSrc: (params: GetChipSvgParams, client?: Client) => string;
declare const getChipSvg: (params: {
    chipId: number;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            chip_id: components["parameters"]["chip_id_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["ChipImageResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<string>;
type GetNodeCountSnapshotParams = RequestParams<typeof getNodeCountSnapshot>;
type GetNodeCountSnapshotResult = RequestResult<typeof getNodeCountSnapshot>;
declare const getNodeCountSnapshot: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NodeCountSnapshotsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        count: number;
        date: string;
    }[];
}>;
type GetStakerCountSnapshotParams = RequestParams<typeof getStakerCountSnapshot>;
type GetStakerCountSnapshotResult = RequestResult<typeof getStakerCountSnapshot>;
declare const getStakerCountSnapshot: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["StakerCountSnapshotsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        count: number;
        date: string;
    }[];
}>;
type GetStakerProfitSnapshotParams = RequestParams<typeof getStakerProfitSnapshot>;
type GetStakerProfitSnapshotResult = RequestResult<typeof getStakerProfitSnapshot>;
declare const getStakerProfitSnapshot: (params: {
    afterDate?: string | undefined;
    beforeDate?: string | undefined;
    cursor?: string | undefined;
    limit?: number | undefined;
    stakerAddress?: string | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            afterDate?: components["parameters"]["after_date_query"];
            beforeDate?: components["parameters"]["before_date_query"];
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
            staker_address?: components["parameters"]["staker_address_query"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["StakerProfitSnapshotsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor: string;
    data: {
        address: string;
        date: string;
        epochId: number;
        totalChipAmount: string;
        totalChipValue?: string | undefined;
    }[];
}>;
type GetStakingStatParams = RequestParams<typeof getStakingStat>;
type GetStakingStatResult = RequestResult<typeof getStakingStat>;
declare const getStakingStat: (params: {
    stakerAddress: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            staker_address: components["parameters"]["staker_address_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["StakerResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        address?: string | undefined;
        currentStakedTokens?: string | undefined;
        totalChips?: string | undefined;
        totalStakedNodes?: number | undefined;
        totalStakedTokens?: string | undefined;
    } | undefined;
}>;
type GetOperationProfitSnapshotParams = RequestParams<typeof getOperationProfitSnapshot>;
type GetOperationProfitSnapshotResult = RequestResult<typeof getOperationProfitSnapshot>;
declare const getOperationProfitSnapshot: (params: {
    afterDate?: string | undefined;
    beforeDate?: string | undefined;
    cursor?: string | undefined;
    limit?: number | undefined;
    nodeAddress?: string | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            afterDate?: components["parameters"]["after_date_query"];
            beforeDate?: components["parameters"]["before_date_query"];
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
            node_address?: components["parameters"]["node_address_query"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["OperationProfitSnapshotsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor: string;
    data: {
        address: string;
        date: string;
        epochId: number;
        operationPool: string;
    }[];
}>;
type GetEpochsApySnapshotParams = RequestParams<typeof getEpochsApySnapshot>;
type GetEpochsApySnapshotResult = RequestResult<typeof getEpochsApySnapshot>;
declare const getEpochsApySnapshot: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["EpochAPYSnapshotsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        apy: string;
        date: string;
        epochId: number;
    }[];
}>;
type GetAllNodesParams = RequestParams<typeof getAllNodes>;
type GetAllNodesResult = RequestResult<typeof getAllNodes>;
declare const getAllNodes: (params: {
    cursor?: string | undefined;
    limit?: number | undefined;
    node?: string | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
            node?: components["parameters"]["node_query"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NodesResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    address: string;
    alpha?: boolean | undefined;
    avatar: {
        description?: string | undefined;
        image?: string | undefined;
        name?: string | undefined;
    };
    createdAt: number;
    description: string;
    id: number;
    isPublicGood: boolean;
    lastHeartbeat: number;
    local?: {
        city?: string | undefined;
        country?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        region?: string | undefined;
    }[] | undefined;
    minTokensToStake: string;
    name: string;
    operationPoolTokens: string;
    slashedTokens: string;
    stakingPoolTokens: string;
    status: "none" | "registered" | "initializing" | "outdated" | "online" | "offline" | "slashing" | "slashed" | "exiting" | "exited";
    taxRateBasisPoints?: number | null | undefined;
    totalShares: string;
    type?: "alpha" | "beta" | "production" | undefined;
    version?: string | undefined;
}[]>;
type GetNodeParams = RequestParams<typeof getNode>;
type GetNodeResult = RequestResult<typeof getNode>;
declare const getNode: (params: {
    address: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            address: components["parameters"]["node_address_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NodeResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    address: string;
    alpha?: boolean | undefined;
    avatar: {
        description?: string | undefined;
        image?: string | undefined;
        name?: string | undefined;
    };
    createdAt: number;
    description: string;
    id: number;
    isPublicGood: boolean;
    lastHeartbeat: number;
    local?: {
        city?: string | undefined;
        country?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        region?: string | undefined;
    }[] | undefined;
    minTokensToStake: string;
    name: string;
    operationPoolTokens: string;
    slashedTokens: string;
    stakingPoolTokens: string;
    status: "none" | "registered" | "initializing" | "outdated" | "online" | "offline" | "slashing" | "slashed" | "exiting" | "exited";
    taxRateBasisPoints?: number | null | undefined;
    totalShares: string;
    type?: "alpha" | "beta" | "production" | undefined;
    version?: string | undefined;
}>;
type GetNodeAvatarSvgParams = RequestParams<typeof getNodeAvatarSvg>;
type GetNodeAvatarSvgResult = RequestResult<typeof getNodeAvatarSvg>;
declare const getNodeAvatarSvgURL: (params: GetNodeAvatarSvgParams, client?: Client) => URL;
declare const getNodeAvatarSvgSrc: (params: GetNodeAvatarSvgParams, client?: Client) => string;
declare const getNodeAvatarSvg: (params: {
    address: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            address: components["parameters"]["node_address_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NodeAvatarResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<string>;
type GetNodeEventsParams = RequestParams<typeof getNodeEvents>;
type GetNodeEventsResult = RequestResult<typeof getNodeEvents>;
declare const getNodeEvents: (params: {
    address: string;
    cursor?: string | undefined;
    limit?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
        };
        header?: never;
        path: {
            address: components["parameters"]["node_address_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NodeEventsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor: string;
    data: {
        addressFrom: string;
        addressTo: string;
        block: {
            hash: string;
            number: number;
            timestamp: number;
        };
        chainId: number;
        logIndex: number;
        metadata: {
            nodeCreated?: {
                address: string;
                description: string;
                isPublicGood: boolean;
                name: string;
                nodeId: number;
                taxRateBasisPoints: number;
            } | undefined;
            nodeUpdated?: {
                address: string;
                description: string;
                name: string;
            } | undefined;
        };
        nodeId: number;
        transaction: {
            hash: string;
            index: number;
        };
        type: "nodeCreated" | "nodeUpdated";
    }[];
}>;
type GetNodeOperationProfitParams = RequestParams<typeof getNodeOperationProfit>;
type GetNodeOperationProfitResult = RequestResult<typeof getNodeOperationProfit>;
declare const getNodeOperationProfit: (params: {
    address: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            address: components["parameters"]["node_address_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NodeOperationProfitResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        nodeAddress: string;
        oneDay?: {
            date: string;
            operationPool: string;
            profitAndLoss: string;
        } | undefined;
        oneMonth?: {
            date: string;
            operationPool: string;
            profitAndLoss: string;
        } | undefined;
        oneWeek?: {
            date: string;
            operationPool: string;
            profitAndLoss: string;
        } | undefined;
        operationPool: string;
    };
}>;
type GetEpochsParams = RequestParams<typeof getEpochs>;
type GetEpochsResult = RequestResult<typeof getEpochs>;
declare const getEpochs: (params: {
    cursor?: string | undefined;
    limit?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
        };
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["EpochsResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}> | undefined, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor?: string | undefined;
    data: {
        distributions: {
            block: {
                hash: string;
                number: number;
                timestamp: number;
            };
            endTimestamp: number;
            id: number;
            startTimestamp: number;
            totalOperationRewards: string;
            totalRequestCounts: string;
            totalRewardItems: number;
            totalStakingRewards: string;
            transaction: {
                hash: string;
                index: number;
            };
        }[];
        endTimestamp: number;
        id: number;
        startTimestamp: number;
        totalOperationRewards: string;
        totalRequestCounts: string;
        totalRewardItems: number;
        totalStakingRewards: string;
    }[];
}>;
type GetEpochParams = RequestParams<typeof getEpoch>;
type GetEpochResult = RequestResult<typeof getEpoch>;
declare const getEpoch: (params: {
    epochId: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            epoch_id: components["parameters"]["epoch_id_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["EpochResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    distributions: {
        block: {
            hash: string;
            number: number;
            timestamp: number;
        };
        endTimestamp: number;
        id: number;
        rewardItems: {
            epochId: number;
            index: number;
            nodeAddress: string;
            operationRewards: string;
            requestCounts?: string | undefined;
            stakingRewards: string;
            taxCollected: string;
            transactionHash: string;
        }[];
        startTimestamp: number;
        totalOperationRewards: string;
        totalRequestCounts: string;
        totalRewardItems: number;
        totalStakingRewards: string;
        transaction: {
            hash: string;
            index: number;
        };
    }[];
    endTimestamp: number;
    id: number;
    startTimestamp: number;
    totalOperationRewards: string;
    totalRequestCounts: string;
    totalRewardItems: number;
    totalStakingRewards: string;
}>;
type GetEpochTransactionParams = RequestParams<typeof getEpochTransaction>;
type GetEpochTransactionResult = RequestResult<typeof getEpochTransaction>;
declare const getEpochTransaction: (params: {
    transactionHash: string;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path: {
            transaction_hash: components["parameters"]["epoch_transaction_hash_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["EpochTransactionResponse"];
        400: components["responses"]["400"];
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        block: {
            hash: string;
            number: number;
            timestamp: number;
        };
        endTimestamp: number;
        id: number;
        rewardItems: {
            epochId: number;
            index: number;
            nodeAddress: string;
            operationRewards: string;
            requestCounts?: string | undefined;
            stakingRewards: string;
            taxCollected: string;
            transactionHash: string;
        }[];
        startTimestamp: number;
        totalOperationRewards: string;
        totalRequestCounts: string;
        totalRewardItems: number;
        totalStakingRewards: string;
        transaction: {
            hash: string;
            index: number;
        };
    }[];
}>;
type GetNodeRewardsParams = RequestParams<typeof getNodeRewards>;
type GetNodeRewardsResult = RequestResult<typeof getNodeRewards>;
declare const getNodeRewards: (params: {
    address: string;
    cursor?: string | undefined;
    limit?: number | undefined;
}, init?: Omit<openapi_fetch.FetchOptions<{
    parameters: {
        query?: {
            cursor?: components["parameters"]["cursor_query"];
            limit?: components["parameters"]["limit_1_50"];
        };
        header?: never;
        path: {
            address: components["parameters"]["node_address_path"];
        };
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NodeRewardsByEpochResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}>, "params"> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    cursor: string;
    data: {
        distributions: {
            block: {
                hash: string;
                number: number;
                timestamp: number;
            };
            endTimestamp: number;
            id: number;
            rewardItems: {
                epochId: number;
                index: number;
                nodeAddress: string;
                operationRewards: string;
                requestCounts?: string | undefined;
                stakingRewards: string;
                taxCollected: string;
                transactionHash: string;
            }[];
            startTimestamp: number;
            totalOperationRewards: string;
            totalRequestCounts: string;
            totalRewardItems: number;
            totalStakingRewards: string;
            transaction: {
                hash: string;
                index: number;
            };
        }[];
        endTimestamp: number;
        id: number;
        startTimestamp: number;
        totalOperationRewards: string;
        totalRequestCounts: string;
        totalRewardItems: number;
        totalStakingRewards: string;
    }[];
}>;
type GetAverageEpochsApyParams = RequestParams<typeof getAverageEpochsApy>;
type GetAverageEpochsApyResult = RequestResult<typeof getAverageEpochsApy>;
declare const getAverageEpochsApy: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["EpochsAverageAPYResponse"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: string;
}>;
type GetNetworkAssetsParams = RequestParams<typeof getNetworkAssets>;
type GetNetworkAssetsResult = RequestResult<typeof getNetworkAssets>;
declare const getNetworkAssets: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["AssetsResponse"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data: {
        networks?: {
            iconUrl?: string | undefined;
            name?: string | undefined;
            type?: string | undefined;
        }[] | undefined;
        workers?: {
            iconUrl?: string | undefined;
            name?: string | undefined;
            platform?: string | undefined;
            type?: string | undefined;
        }[] | undefined;
    };
}>;
type GetNetworkConfigParams = RequestParams<typeof getNetworkConfig>;
type GetNetworkConfigResult = RequestResult<typeof getNetworkConfig>;
declare const getNetworkConfig: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["NetworkConfigResponse"];
        400: components["responses"]["400"];
        404: {
            headers: {
                [name: string]: unknown;
            };
            content?: never;
        };
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        data?: {
            decentralized?: {
                endpointConfigs?: {
                    httpHeaders?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    http2Disabled?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    url?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                } | undefined;
                id?: string | undefined;
                workerConfigs?: {
                    endpoint?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    id?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    minimumResource?: {
                        cpuCore?: number | undefined;
                        diskSpaceInGb?: number | undefined;
                        key?: string | undefined;
                        memoryInGb?: number | undefined;
                        title?: string | undefined;
                    } | undefined;
                    network?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    parameters?: {
                        blockBatchSize?: {
                            description?: string | undefined;
                            isRequired?: boolean | undefined;
                            key?: string | undefined;
                            title?: string | undefined;
                            type?: string | undefined;
                            value?: string | undefined;
                        } | undefined;
                        blockReceiptsBatchSize?: {
                            description?: string | undefined;
                            isRequired?: boolean | undefined;
                            key?: string | undefined;
                            title?: string | undefined;
                            type?: string | undefined;
                            value?: string | undefined;
                        } | undefined;
                        concurrentBlockRequests?: {
                            description?: string | undefined;
                            isRequired?: boolean | undefined;
                            key?: string | undefined;
                            title?: string | undefined;
                            type?: string | undefined;
                            value?: string | undefined;
                        } | undefined;
                        receiptsBatchSize?: {
                            description?: string | undefined;
                            isRequired?: boolean | undefined;
                            key?: string | undefined;
                            title?: string | undefined;
                            type?: string | undefined;
                            value?: string | undefined;
                        } | undefined;
                    } | undefined;
                    worker?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                }[] | undefined;
            }[] | undefined;
            federated?: {
                endpointConfigs?: {
                    httpHeaders?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    http2Disabled?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    url?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                } | undefined;
                id?: string | undefined;
                workerConfigs?: {
                    endpoint?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    id?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    minimumResource?: {
                        cpuCore?: number | undefined;
                        diskSpaceInGb?: number | undefined;
                        key?: string | undefined;
                        memoryInGb?: number | undefined;
                        title?: string | undefined;
                    } | undefined;
                    network?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    parameters?: {
                        kafkaTopic?: {
                            description?: string | undefined;
                            isRequired?: boolean | undefined;
                            key?: string | undefined;
                            title?: string | undefined;
                            type?: string | undefined;
                            value?: string | undefined;
                        } | undefined;
                    } | undefined;
                    worker?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                }[] | undefined;
            }[] | undefined;
            rss?: {
                id?: string | undefined;
                workerConfigs?: {
                    endpoint?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    id?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    minimumResource?: {
                        cpuCore?: number | undefined;
                        diskSpaceInGb?: number | undefined;
                        key?: string | undefined;
                        memoryInGb?: number | undefined;
                        title?: string | undefined;
                    } | undefined;
                    network?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                    parameters?: {
                        authentication?: {
                            accessKey?: {
                                description?: string | undefined;
                                isRequired?: boolean | undefined;
                                key?: string | undefined;
                                title?: string | undefined;
                                type?: string | undefined;
                                value?: string | undefined;
                            } | undefined;
                        } | undefined;
                    } | undefined;
                    worker?: {
                        description?: string | undefined;
                        isRequired?: boolean | undefined;
                        key?: string | undefined;
                        title?: string | undefined;
                        type?: string | undefined;
                        value?: string | undefined;
                    } | undefined;
                } | undefined;
            } | undefined;
        } | undefined;
    } | undefined;
}>;
type GetTotalRequestsParams = RequestParams<typeof getTotalRequests>;
type GetTotalRequestsResult = RequestResult<typeof getTotalRequests>;
declare const getTotalRequests: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["TotalRequestsResponse"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        totalRequests?: number | undefined;
    } | undefined;
}>;
type GetTokenSupplyParams = RequestParams<typeof getTokenSupply>;
type GetTokenSupplyResult = RequestResult<typeof getTokenSupply>;
declare const getTokenSupply: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["TokenSupplyResponse"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        totalSupply?: string | undefined;
    } | undefined;
}>;
type GetTokenTvlParams = RequestParams<typeof getTokenTvl>;
type GetTokenTvlResult = RequestResult<typeof getTokenTvl>;
declare const getTokenTvl: (init?: openapi_fetch.FetchOptions<{
    parameters: {
        query?: never;
        header?: never;
        path?: never;
        cookie?: never;
    };
    requestBody?: never;
    responses: {
        200: components["responses"]["TokenTvlResponse"];
        500: components["responses"]["500"];
    };
}> | null | undefined, client?: Readonly<{
    baseUrl: string;
} & Readonly<{
    baseUrl: string;
} & openapi_fetch.Client<paths, `${string}/${string}`>>>) => Promise<{
    data?: {
        tvl?: string | undefined;
    } | undefined;
}>;

export { type GetActivitiesByAccountsParams, type GetActivitiesByAccountsResult, type GetActivitiesParams, type GetActivitiesResult, type GetActivityParams, type GetActivityResult, type GetAllNodesParams, type GetAllNodesResult, type GetAverageEpochsApyParams, type GetAverageEpochsApyResult, type GetBridgingTransactionParams, type GetBridgingTransactionResult, type GetBridgingTransactionsParams, type GetBridgingTransactionsResult, type GetChipParams, type GetChipResult, type GetChipSvgParams, type GetChipSvgResult, type GetChipsParams, type GetChipsResult, type GetEpochParams, type GetEpochResult, type GetEpochTransactionParams, type GetEpochTransactionResult, type GetEpochsApySnapshotParams, type GetEpochsApySnapshotResult, type GetEpochsParams, type GetEpochsResult, type GetFederatedActivitiesByAccountParams, type GetFederatedActivitiesByAccountResult, type GetFederatedActivitiesByAccountsParams, type GetFederatedActivitiesByAccountsResult, type GetFederatedActivityParams, type GetFederatedActivityResult, type GetFederatedNetworkActivitiesParams, type GetFederatedNetworkActivitiesResult, type GetFederatedPlatformActivitiesParams, type GetFederatedPlatformActivitiesResult, type GetNetworkActivitiesParams, type GetNetworkActivitiesResult, type GetNetworkAssetsParams, type GetNetworkAssetsResult, type GetNetworkConfigParams, type GetNetworkConfigResult, type GetNodeAvatarSvgParams, type GetNodeAvatarSvgResult, type GetNodeCountSnapshotParams, type GetNodeCountSnapshotResult, type GetNodeEventsParams, type GetNodeEventsResult, type GetNodeOperationProfitParams, type GetNodeOperationProfitResult, type GetNodeParams, type GetNodeResult, type GetNodeRewardsParams, type GetNodeRewardsResult, type GetOperationProfitSnapshotParams, type GetOperationProfitSnapshotResult, type GetPlatformActivitiesParams, type GetPlatformActivitiesResult, type GetRSSActivityParams, type GetRSSActivityResult, type GetStakerCountSnapshotParams, type GetStakerCountSnapshotResult, type GetStakerProfitSnapshotParams, type GetStakerProfitSnapshotResult, type GetStakingProfitParams, type GetStakingProfitResult, type GetStakingStatParams, type GetStakingStatResult, type GetStakingTransactionParams, type GetStakingTransactionResult, type GetStakingTransactionsParams, type GetStakingTransactionsResult, type GetStakingsParams, type GetStakingsResult, type GetTokenSupplyParams, type GetTokenSupplyResult, type GetTokenTvlParams, type GetTokenTvlResult, type GetTotalRequestsParams, type GetTotalRequestsResult, getActivities, getActivitiesByAccounts, getActivity, getAllNodes, getAverageEpochsApy, getBridgingTransaction, getBridgingTransactions, getChip, getChipSvg, getChipSvgSrc, getChipSvgURL, getChips, getEpoch, getEpochTransaction, getEpochs, getEpochsApySnapshot, getFederatedActivitiesByAccount, getFederatedActivitiesByAccounts, getFederatedActivity, getFederatedNetworkActivities, getFederatedPlatformActivities, getNetworkActivities, getNetworkAssets, getNetworkConfig, getNode, getNodeAvatarSvg, getNodeAvatarSvgSrc, getNodeAvatarSvgURL, getNodeCountSnapshot, getNodeEvents, getNodeOperationProfit, getNodeRewards, getOperationProfitSnapshot, getPlatformActivities, getRSSActivity, getStakerCountSnapshot, getStakerProfitSnapshot, getStakingProfit, getStakingStat, getStakingTransaction, getStakingTransactions, getStakings, getTokenSupply, getTokenTvl, getTotalRequests };
