/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
	"/decentralized/{account}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Account Activities
		 * @description This endpoint retrieves the activities associated with a specified account in the decentralized system. Use query parameters to filter results by action limits, timestamps, status, direction, and more.
		 */
		get: operations["getAccountActivities"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/decentralized/accounts": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Batch Get Accounts Activities
		 * @description Retrieve activities associated with multiple accounts on all compatible networks. You can use various query parameters to filter and paginate the results, including limits on the number of activities and actions, timestamps, success status, direction, and more.
		 */
		post: operations["batchGetAccountsActivities"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/decentralized/network/{network}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Network Activities
		 * @description Retrieve a list of activities from the specified decentralized network. This endpoint allows you to filter activities by various parameters such as limit, timestamp, success status, and more.
		 */
		get: operations["getNetworkActivities"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/decentralized/platform/{platform}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Platform Activities
		 * @description Retrieve a list of activities from the specified decentralized platform. This endpoint allows you to filter activities by various parameters such as limit, timestamp, success status, and more.
		 */
		get: operations["getPlatformActivities"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/decentralized/tx/{id}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Activity by ID
		 * @description This endpoint retrieves the details of a specified decentralized transaction activity by its ID. You can specify additional query parameters to limit the number of actions retrieved and paginate through them.
		 */
		get: operations["getActivityById"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/federated/{account}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Federated Account Activities (Beta)
		 * @description This endpoint retrieves the activities associated with a specified account in the federated system. You can use various query parameters to filter and paginate the results, including limits on the number of activities and actions, timestamps, success status, direction, and more.
		 */
		get: operations["getFederatedAccountActivities"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/federated/accounts": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		get?: never;
		put?: never;
		/**
		 * Batch Get Federated Accounts Activities (Beta)
		 * @description Retrieve activities associated with multiple accounts on all compatible networks. You can use various query parameters to filter and paginate the results, including limits on the number of activities and actions, timestamps, success status, direction, and more.
		 */
		post: operations["batchGetFederatedAccountsActivities"];
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/federated/network/{network}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Federated Network Activities (Beta)
		 * @description Retrieve a list of activities from the specified federated network. This endpoint allows you to filter activities by various parameters such as limit, timestamp, success status, and more.
		 */
		get: operations["getFederatedNetworkActivities"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/federated/platform/{platform}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Federated Platform Activities (Beta)
		 * @description Retrieve a list of activities from the specified federated platform. This endpoint allows you to filter activities by various parameters such as limit, timestamp, success status, and more.
		 */
		get: operations["getFederatedPlatformActivities"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/federated/tx/{id}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Federated Activity by ID (Beta)
		 * @description This endpoint retrieves the details of a specified federated activity by its ID. You can also specify additional query parameters to limit the number of actions retrieved and to paginate through actions.
		 */
		get: operations["getFederatedActivityById"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/bridgings/transactions": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve bridging transactions
		 * @description Retrieve a list of bridging transactions based on various query parameters such as cursor, sender, receiver, address, transaction type, and limit. This endpoint allows users to filter transactions to get precise data related to deposits and withdrawals. The response includes transaction details, such as sender and receiver addresses, token information, and related events like deposit initialization and finalization. Use this endpoint for monitoring, auditing, or analyzing bridging transactions. The 'cursor' parameter can be used for pagination to fetch subsequent sets of results.
		 */
		get: operations["getBridgingTransactions"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/bridgings/transactions/{transaction_hash}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve bridging transaction by hash
		 * @description Retrieve bridging transaction details by its transaction hash. This endpoint provides comprehensive data about a single transaction, including sender, receiver, token details, and related events.
		 */
		get: operations["getBridgingTransactionByHash"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/chips": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve all chips
		 * @description Retrieve a list of all chips. This endpoint allows users to filter the results by cursor, chip IDs, Node address, owner address, and to paginate through the results using cursor and limit parameters. The response includes detailed information about each chip and a cursor for pagination to fetch subsequent sets of results.
		 */
		get: operations["getAllChips"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/chips/{chip_id}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Chips by chip id
		 * @description Retrieve chip details using its unique ID. This endpoint returns comprehensive data about the chip, including its Node address, owner address, and metadata such as name, description, and image.
		 */
		get: operations["getChipById"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/chips/{chip_id}/image.svg": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Chips image by id
		 * @description Retrieve the image of a specific chip by its unique chip ID. This endpoint returns the SVG image associated with the chip.
		 */
		get: operations["getChipImageById"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/dsl/total_requests": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve DSL total requests
		 * @description Retrieve the total number of requests served by Global Indexers.
		 */
		get: operations["getDSLTotalRequests"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/epochs": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve all epochs
		 * @description Retrieve a list of all epochs. This endpoint allows filtering by cursor and limit for pagination.
		 */
		get: operations["getAllEpochs"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/epochs/{address}/rewards": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Node rewards by epoch
		 * @description Retrieve the rewards of a specific Node by epoch. This endpoint allows filtering by cursor and limit for pagination.
		 */
		get: operations["getNodeRewardsByEpoch"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/epochs/{epoch_id}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve epoch by id
		 * @description Retrieve epoch details by its ID.
		 */
		get: operations["getEpochById"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/epochs/apy": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve the average of epochs APY
		 * @description Retrieve the average Annual Percentage Yield (APY) for all epochs.
		 */
		get: operations["getEpochsAverageAPY"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/epochs/distributions/{transaction_hash}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve epoch transaction by hash
		 * @description Retrieve details of an epoch transaction by its hash.
		 */
		get: operations["getEpochTransactionByHash"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/networks/assets": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Node Assets
		 * @description Retrieve Node assets details.
		 */
		get: operations["getNodeAssets"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/networks/config": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve network config
		 * @description Retrieve the configuration details of RSS, Decentralized, and Federated networks.
		 */
		get: operations["getNetworkConfig"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/nodes": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve all RSS3 Nodes
		 * @description Retrieve the list of all RSS3 Nodes. This endpoint allows filtering by cursor, limit, and Node address.
		 */
		get: operations["getAllNodes"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/nodes/{address}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Node by address
		 * @description Retrieve Node details by its address.
		 */
		get: operations["getNodeByAddress"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/nodes/{address}/avatar.svg": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Node avatar by address
		 * @description Retrieve the avatar of a specific Node by its address. This endpoint returns the SVG image associated with the node.
		 */
		get: operations["getNodeAvatarByAddress"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/nodes/{address}/events": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Node transaction events by address
		 * @description Retrieve the transaction events for a specific Node by its address. This endpoint allows filtering by cursor and limit for pagination.
		 */
		get: operations["getNodeEventsByAddress"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/nodes/{address}/operation/profit": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve Node operation profit by address
		 * @description Retrieve the operation profit details for a specific Node by its address. This endpoint provides detailed profit and loss (PNL) information over different time periods.
		 */
		get: operations["getNodeOperationProfitByAddress"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/snapshots/epochs/apy": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve snapshots of epoch APY.
		 * @description Retrieve the Annual Percentage Yield (APY) for epoch snapshots. This endpoint returns an array of objects, each containing an epoch ID and the corresponding APY.
		 */
		get: operations["getEpochAPYSnapshots"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/snapshots/nodes/count": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve snapshots of Node count
		 * @description Retrieve snapshots of the Node count over time. This endpoint returns an array of objects, each containing the date and the corresponding count of nodes on that date.
		 */
		get: operations["getNodeCountSnapshots"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/snapshots/nodes/operation/profit": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve snapshots of operation profit
		 * @description Retrieve snapshots of the operation profit over time for a specific node. This endpoint allows filtering by Node address, date range, and pagination parameters.
		 */
		get: operations["getNodeOperationProfitSnapshots"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/snapshots/stakers/count": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve snapshots of staker count
		 * @description Retrieve snapshots of the total staker count over time. This endpoint returns an array of objects, each containing the date and the corresponding count of stakers on that date.
		 */
		get: operations["getStakerCountSnapshots"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/snapshots/stakers/profit": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve snapshots of the staker profit
		 * @description Retrieve snapshots of the staker profit over time. This endpoint allows filtering by staker address, date range, and pagination parameters.
		 */
		get: operations["getStakerProfitSnapshots"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/stakings/{staker_address}/profit": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve staking profit of a staker
		 * @description Retrieve the staking profit information for a specified staker. This endpoint returns detailed profit data, including the owner's address, total chip amount, total chip value, and profit and loss (PNL) data over different time periods (one day, one week, one month).
		 */
		get: operations["getStakerProfit"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/stakings/{staker_address}/stat": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve the number of nodes, chips, and tokens staked of a staker
		 * @description Retrieve the number of nodes, chips, and tokens staked by a specific staker. This endpoint returns detailed information about the staker, including the number of nodes staked, number of chips owned, total tokens staked, and the total value of the staker's assets.
		 */
		get: operations["getStakerStats"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/stakings/stakings": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve a list of stakers and Nodes
		 * @description Retrieve a list of stakers and their associated Nodes. This endpoint allows users to filter the results by staker address, Node address, and to paginate through the results using cursor and limit parameters. The response includes detailed information about each staker, node, and associated chips.
		 */
		get: operations["getStakersAndNodes"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/stakings/transactions": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve staking transactions
		 * @description Retrieve a list of staking transactions based on various query parameters such as cursor, staker, node, transaction type, pending status, and limit. This endpoint allows users to filter transactions to get precise data related to staking activities including deposits, withdrawals, stakes, and unstakes. The response includes detailed transaction information such as staker address, Node address, value staked, associated chips, and related events. Use this endpoint for monitoring, auditing, or analyzing staking transactions. The 'cursor' parameter can be used for pagination to fetch subsequent sets of results.
		 */
		get: operations["getStakingTransactions"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/stakings/transactions/{transaction_hash}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve staking transaction by hash
		 * @description Retrieve staking transaction details by its transaction hash. This endpoint provides comprehensive data about a single staking transaction, including staker address, Node address, value staked, associated chips, and related events.
		 */
		get: operations["getStakingTransactionByHash"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/token/supply": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve RSS3 token total supply on VSL
		 * @description Retrieve the total supply of RSS3 token on VSL.
		 */
		get: operations["getRSS3TokenTotalSupply"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/nta/token/tvl": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/**
		 * Retrieve TVL in $
		 * @description Retrieve the total value locked (TVL) in $, including RSS3, WETH, USDT, USDC, and POWER.
		 */
		get: operations["getTokenTVL"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
	"/rss/{path}": {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		/** Retrieve RSS Activity by Path */
		get: operations["getRSSActivityByPath"];
		put?: never;
		post?: never;
		delete?: never;
		options?: never;
		head?: never;
		patch?: never;
		trace?: never;
	};
}
export type webhooks = Record<string, never>;
export interface components {
	schemas: {
		/**
		 * @description Represents an individual action within an activity.
		 * @example {
		 *       "tag": "transaction",
		 *       "type": "transfer",
		 *       "from": "0xd8dA6BF26964aF9D7eEd9e03E53415D37aA96045",
		 *       "to": "0xefC5f77c5AD5DB85bc287E80d8c3B88c3f27662C",
		 *       "metadata": {
		 *         "address": "0x7964B6A8aE5a71409e7E17a5b2669903A27997Ac",
		 *         "value": "10000000000000000000000",
		 *         "name": "PlayDoge",
		 *         "symbol": "PLAY",
		 *         "decimals": 18,
		 *         "standard": "ERC-20"
		 *       },
		 *       "related_urls": [
		 *         "https://etherscan.io/tx/0x840e42d573ebe1ff27a9e4914573b4e0518fcd685c7f9331d319abe854f780e3"
		 *       ]
		 *     }
		 */
		Action: {
			/** @description The address from which the action originated. */
			from: string;
			/** @description Additional metadata related to the action. */
			metadata:
				| components["schemas"]["RssFeed"]
				| components["schemas"]["TransactionApproval"]
				| components["schemas"]["TransactionBridge"]
				| components["schemas"]["TransactionTransfer"]
				| components["schemas"]["TransactionBurn"]
				| components["schemas"]["TransactionMint"]
				| components["schemas"]["CollectibleApproval"]
				| components["schemas"]["CollectibleTrade"]
				| components["schemas"]["CollectibleTransfer"]
				| components["schemas"]["CollectibleBurn"]
				| components["schemas"]["CollectibleMint"]
				| components["schemas"]["ExchangeLiquidity"]
				| components["schemas"]["ExchangeStaking"]
				| components["schemas"]["ExchangeSwap"]
				| components["schemas"]["SocialRevise"]
				| components["schemas"]["SocialMint"]
				| components["schemas"]["SocialProfile"]
				| components["schemas"]["SocialPost"]
				| components["schemas"]["SocialComment"]
				| components["schemas"]["SocialDelete"]
				| components["schemas"]["SocialProxy"]
				| components["schemas"]["SocialReward"]
				| components["schemas"]["SocialShare"]
				| components["schemas"]["MetaverseTrade"]
				| components["schemas"]["MetaverseBurn"]
				| components["schemas"]["MetaverseMint"]
				| components["schemas"]["MetaverseTransfer"];
			platform?: components["schemas"]["Platform"];
			/** @description A list of URLs related to the action. */
			related_urls: string[];
			tag?: components["schemas"]["Tag"];
			/** @description The address to which the action is directed. */
			to: string;
			/** @description The type of action performed. */
			type: string;
		};
		/** @description The response structure for a list of activities. */
		ActivitiesResponse: {
			/** @description The list of activities. */
			data: components["schemas"]["Activity"][];
			meta?: components["schemas"]["MetaCursor"];
		};
		Activity: {
			/** @description The list of actions within the activity. */
			actions: components["schemas"]["Action"][];
			calldata?: components["schemas"]["Calldata"];
			direction?: components["schemas"]["Direction"];
			fee?: components["schemas"]["Fee"];
			/**
			 * @description The address from which the activity originated.
			 * @example 0xBAB4d1f27bAA7762a4d822B80C647F715922492f
			 */
			from: string;
			/**
			 * @description The unique identifier for the activity.
			 * @example 0x840e42d573ebe1ff27a9e4914573b4e0518fcd685c7f9331d319abe854f780e3
			 */
			id: string;
			/**
			 * @description The index of the activity in the list.
			 * @example 0
			 */
			index: number;
			network?: components["schemas"]["Network"];
			/**
			 * @description The owner of the activity.
			 * @example 0xd8dA6BF26964aF9D7eEd9e03E53415D37aA96045
			 */
			owner: string;
			platform?: components["schemas"]["Platform"];
			/**
			 * @description Indicates whether the activity was successful.
			 * @example true
			 */
			success: boolean;
			tag?: components["schemas"]["Tag"];
			/**
			 * @description The timestamp of when the activity occurred.
			 * @example 1718689727
			 */
			timestamp: number;
			/**
			 * @description The address to which the activity is directed.
			 * @example 0x7964B6A8aE5a71409e7E17a5b2669903A27997Ac
			 */
			to: string;
			/**
			 * @description The total number of actions within the activity.
			 * @example 1
			 */
			total_actions: number;
			type?: components["schemas"]["Type"];
		};
		ActivityResponse: {
			data?: components["schemas"]["Activity"];
			meta?: components["schemas"]["MetaTotalPages"];
		};
		BridgeTransaction: {
			event?: {
				deposit?: {
					finalized?: components["schemas"]["TransactionEvent"];
					initialized?: components["schemas"]["TransactionEvent"];
				} | null;
				withdraw?: {
					finalized?: components["schemas"]["TransactionEvent"];
					initialized?: components["schemas"]["TransactionEvent"];
					proved?: components["schemas"]["TransactionEvent"];
				} | null;
			};
			/** @example 0x2af31b2a2708d5c9074074c578d3c521bd4385875e500f274fce52d3074460aa */
			id: string;
			/** @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1 */
			receiver: string;
			/** @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1 */
			sender: string;
			token?: {
				address: {
					/** @example 0xc98d64da73a6616c42117b582e832812e7b8d57f */
					l1: string;
					/** @example 0x4200000000000000000000000000000000000042 */
					l2: string;
				};
				/** @example 10000000000000000000000 */
				value: string;
			};
		};
		/** @example {
		 *       "id": 130,
		 *       "start_timestamp": 1718589689,
		 *       "end_timestamp": 1718654555,
		 *       "total_operation_rewards": "0",
		 *       "total_staking_rewards": "61084916609459274004676",
		 *       "total_request_counts": "40",
		 *       "total_rewarded_nodes": 65,
		 *       "distributions": [
		 *         {
		 *           "id": 130,
		 *           "start_timestamp": 1718589689,
		 *           "end_timestamp": 1718654555,
		 *           "transaction": {
		 *             "hash": "0xe804d536d996d49b0ec8627361bc642f92d440e6b519e6faab0944f70bf05fd2",
		 *             "index": 1
		 *           },
		 *           "block": {
		 *             "hash": "0xd9e2a4df54a385507a302ec3c62d3b3833ce8ed80242694d79cfa5b034840379",
		 *             "number": 4398018,
		 *             "timestamp": 1718654555
		 *           },
		 *           "total_operation_rewards": "0",
		 *           "total_staking_rewards": "61084916609459274004676",
		 *           "total_request_counts": "40",
		 *           "total_rewarded_nodes": 65,
		 *           "rewarded_nodes": [
		 *             {
		 *               "epoch_id": 130,
		 *               "index": 48,
		 *               "transaction_hash": "0xe804d536d996d49b0ec8627361bc642f92d440e6b519e6faab0944f70bf05fd2",
		 *               "node_address": "0x69982e017acc0fde3d1542205089a8d3eafcd1b7",
		 *               "operation_rewards": "0",
		 *               "staking_rewards": "18250125229171339678441",
		 *               "tax_collected": "1270138765073564056898",
		 *               "request_count": "0"
		 *             }
		 *           ]
		 *         }
		 *       ]
		 *     } */
		BriefEpoch: {
			distributions: components["schemas"]["BriefEpochDistribution"][];
			end_timestamp: number;
			id: number;
			start_timestamp: number;
			total_operation_rewards: string;
			total_request_counts: string;
			total_reward_items: number;
			total_staking_rewards: string;
		};
		BriefEpochDistribution: {
			block: {
				hash: string;
				number: number;
				timestamp: number;
			};
			end_timestamp: number;
			id: number;
			start_timestamp: number;
			total_operation_rewards: string;
			total_request_counts: string;
			total_reward_items: number;
			total_staking_rewards: string;
			transaction: {
				hash: string;
				index: number;
			};
		};
		/**
		 * @description Represents the call data associated with an activity.
		 * @example {
		 *       "function_hash": "0x4022b75e"
		 *     }
		 */
		Calldata: {
			/** @description The hash of the function called. */
			function_hash?: string;
			/** @description The parsed function name. */
			parsed_function?: string;
			/** @description The raw call data. */
			raw?: string;
		};
		Chip: {
			/** @example 1690 */
			id: number;
			/**
			 * @description The latest value of the chip
			 * @example 613891695796128425340
			 */
			latest_value: string;
			metadata: {
				/** @example Chip Monsters are unique creatures living in the RSS3 Network, each one special because of where it was born. They represent the idea of FREE and OPEN INFORMATION, thriving in a world that values sharing and being different. These Chip Monsters are more than just digital; they symbolize the excitement and importance of being unique in a connected digital world. */
				description: string;
				/** @example https://gi.rss3.io/nta/chips/1690/image.svg */
				image: string;
				/** @example Open Chips #1690 */
				name: string;
			};
			/** @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2 */
			node: string;
			/** @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944 */
			owner: string;
			/**
			 * @description the value at time of minting
			 * @example 500000000000000000000
			 */
			value: string;
		};
		ChipPNL: {
			/** @example 2024-06-14T01:57:07Z */
			date: string;
			/** @example 0.0066375630868202 */
			profit_and_loss: string;
			/** @example 24 */
			total_chip_amount: string;
			/** @example 14459771035071565497880 */
			total_chip_value: string;
		};
		CollectibleApproval: {
			/** @enum {string} */
			action: "approve" | "revoke";
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		CollectibleBurn: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		CollectibleMint: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		CollectibleTrade: {
			/** @enum {string} */
			action: "buy" | "sell" | "offer" | "set" | "create" | "finalize";
			address?: string;
			cost?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		CollectibleTransfer: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		ConfigItem: {
			description?: string;
			is_required?: boolean;
			key?: string;
			title?: string;
			type?: string;
			value?: string;
		};
		CountSnapshot: {
			/** @example 1 */
			count: number;
			/** @example 2024-03-10 */
			date: string;
		};
		DecentralizedConfig: {
			endpoint_configs?: {
				http_headers?: components["schemas"]["ConfigItem"];
				http2_disabled?: components["schemas"]["ConfigItem"];
				url?: components["schemas"]["ConfigItem"];
			};
			id?: string;
			worker_configs?: {
				endpoint?: components["schemas"]["ConfigItem"];
				id?: components["schemas"]["ConfigItem"];
				minimum_resource?: components["schemas"]["MinimumResource"];
				network?: components["schemas"]["ConfigItem"];
				parameters?: {
					block_batch_size?: components["schemas"]["ConfigItem"];
					block_receipts_batch_size?: components["schemas"]["ConfigItem"];
					concurrent_block_requests?: components["schemas"]["ConfigItem"];
					receipts_batch_size?: components["schemas"]["ConfigItem"];
				};
				worker?: components["schemas"]["ConfigItem"];
			}[];
		};
		/**
		 * @description The direction of an activity.
		 * @example out
		 * @enum {string}
		 */
		Direction: "in" | "out" | "self";
		Epoch: {
			distributions: components["schemas"]["EpochDistribution"][];
			/** @example 1718654555 */
			end_timestamp: number;
			/** @example 130 */
			id: number;
			/** @example 1718589689 */
			start_timestamp: number;
			/** @example 0 */
			total_operation_rewards: string;
			/** @example 40 */
			total_request_counts: string;
			/** @example 65 */
			total_reward_items: number;
			/** @example 61084916609459274004676 */
			total_staking_rewards: string;
		};
		EpochAPYSnapshot: {
			/** @example 0.1 */
			apy: string;
			/** @example 2024-06-17T20:02:35Z */
			date: string;
			/** @example 1 */
			epoch_id: number;
		};
		/** @example {
		 *       "id": 130,
		 *       "start_timestamp": 1718589689,
		 *       "end_timestamp": 1718654555,
		 *       "transaction": {
		 *         "hash": "0xe804d536d996d49b0ec8627361bc642f92d440e6b519e6faab0944f70bf05fd2",
		 *         "index": 1
		 *       },
		 *       "block": {
		 *         "hash": "0xd9e2a4df54a385507a302ec3c62d3b3833ce8ed80242694d79cfa5b034840379",
		 *         "number": 4398018,
		 *         "timestamp": 1718654555
		 *       },
		 *       "total_operation_rewards": "0",
		 *       "total_staking_rewards": "61084916609459274004676",
		 *       "total_request_counts": "40",
		 *       "total_rewarded_nodes": 65,
		 *       "rewarded_nodes": [
		 *         {
		 *           "epoch_id": 130,
		 *           "index": 48,
		 *           "transaction_hash": "0xe804d536d996d49b0ec8627361bc642f92d440e6b519e6faab0944f70bf05fd2",
		 *           "node_address": "0x69982e017acc0fde3d1542205089a8d3eafcd1b7",
		 *           "operation_rewards": "0",
		 *           "staking_rewards": "18250125229171339678441",
		 *           "tax_collected": "1270138765073564056898",
		 *           "request_count": "0"
		 *         }
		 *       ]
		 *     } */
		EpochDistribution: {
			block: {
				hash: string;
				number: number;
				timestamp: number;
			};
			end_timestamp: number;
			id: number;
			reward_items: {
				epoch_id: number;
				index: number;
				node_address: string;
				operation_rewards: string;
				request_counts?: string;
				staking_rewards: string;
				tax_collected: string;
				transaction_hash: string;
			}[];
			start_timestamp: number;
			total_operation_rewards: string;
			total_request_counts: string;
			total_reward_items: number;
			total_staking_rewards: string;
			transaction: {
				hash: string;
				index: number;
			};
		};
		ExchangeLiquidity: {
			/** @enum {string} */
			action:
				| "add"
				| "borrow"
				| "collect"
				| "remove"
				| "repay"
				| "supply"
				| "withdraw";
			tokens: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			}[];
		};
		ExchangeStaking: {
			/** @enum {string} */
			action: "stake" | "unstake" | "claim";
			period?: {
				end?: {
					ext: number;
					loc?: {
						cacheEnd: number;
						cacheStart: number;
						cacheZone?: {
							isDST: boolean;
							name: string;
							offset: number;
						};
						extend: string;
						name: string;
						tx: {
							index: number;
							isstd: boolean;
							isutc: boolean;
							when: number;
						}[];
						zone: {
							isDST: boolean;
							name: string;
							offset: number;
						}[];
					};
					wall: number;
				};
				start?: {
					ext: number;
					loc?: {
						cacheEnd: number;
						cacheStart: number;
						cacheZone?: {
							isDST: boolean;
							name: string;
							offset: number;
						};
						extend: string;
						name: string;
						tx: {
							index: number;
							isstd: boolean;
							isutc: boolean;
							when: number;
						}[];
						zone: {
							isDST: boolean;
							name: string;
							offset: number;
						}[];
					};
					wall: number;
				};
			};
			token?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
		};
		ExchangeSwap: {
			from?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			to?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
		};
		/**
		 * @description Represents an individual action within an federated activity.
		 * @example {
		 *       "tag": "social",
		 *       "type": "comment",
		 *       "platform": "Mastodon",
		 *       "from": "@woofers@universeodon.com",
		 *       "to": "@georgetakei@universeodon.com",
		 *       "metadata": {
		 *         "handle": "@woofers@universeodon.com",
		 *         "body": "@ georgetakei ( https://universeodon.com/@georgetakei ) now hold on just a minute...\n\n# woof ( https://universeodon.com/tags/woof )",
		 *         "publication_id": "113324128515491294",
		 *         "tags": [
		 *           "@georgetakei",
		 *           "#woof"
		 *         ],
		 *         "author_url": "https://universeodon.com/users/woofers",
		 *         "timestamp": 1729188972,
		 *         "target": {
		 *           "handle": "@georgetakei@universeodon.com",
		 *           "body": "Just a little treat.",
		 *           "media": [
		 *             {
		 *               "address": "https://media.universeodon.com/media_attachments/files/113/319/346/314/075/495/original/26e989bcf15840a6.png",
		 *               "mime_type": "image/png"
		 *             }
		 *           ],
		 *           "publication_id": "113319346448373294",
		 *           "author_url": "https://universeodon.com/users/georgetakei",
		 *           "timestamp": 1729116004
		 *         },
		 *         "target_url": "https://universeodon.com/users/georgetakei/statuses/113319346448373294"
		 *       },
		 *       "related_urls": [
		 *         "https://universeodon.com/users/woofers/statuses/113324128515491294"
		 *       ]
		 *     }
		 */
		FederatedAction: {
			/** @description The account from which the federated action originated. */
			from: string;
			/** @description Additional metadata related to the federated action. */
			metadata:
				| components["schemas"]["SocialPost"]
				| components["schemas"]["SocialComment"]
				| components["schemas"]["SocialShare"];
			/** @description The platform of the federated activity. */
			platform?: string;
			/** @description A list of URLs related to the action. */
			related_urls: string[];
			/** @description The tag of the federated activity. */
			tag: string;
			/** @description The account to which the federated action is directed. */
			to: string;
			/** @description The type of federated action performed. */
			type: string;
		};
		/** @description The response structure for a list of federated activities. */
		FederatedActivitiesResponse: {
			/** @description The list of federated activities. */
			data: components["schemas"]["FederatedActivity"][];
			meta?: components["schemas"]["MetaCursor"];
		};
		FederatedActivity: {
			/** @description The list of actions within the federated activity. */
			actions: components["schemas"]["FederatedAction"][];
			direction?: components["schemas"]["Direction"];
			/**
			 * @description The account from which the federated activity originated.
			 * @example @woofers@universeodon.com
			 */
			from: string;
			/**
			 * @description The unique identifier for the federated activity.
			 * @example https://universeodon.com/users/woofers/statuses/113324128515491294/activity
			 */
			id: string;
			/**
			 * @description The index of the activity in the list.
			 * @example 0
			 */
			index: number;
			/**
			 * @description The network of the federated activity.
			 * @example mastodon
			 */
			network?: string;
			/**
			 * @description The owner of the federated activity.
			 * @example @georgetakei@universeodon.com
			 */
			owner: string;
			/**
			 * @description The platform of the federated activity.
			 * @example Mastodon
			 */
			platform?: string;
			/**
			 * @description Indicates whether the federated activity was successful.
			 * @example true
			 */
			success: boolean;
			/**
			 * @description The tag of the federated activity.
			 * @example social
			 */
			tag?: string;
			/**
			 * @description The timestamp of when the activity occurred.
			 * @example 1729188972
			 */
			timestamp: number;
			/**
			 * @description The account to which the activity is directed.
			 * @example @georgetakei@universeodon.com
			 */
			to: string;
			/**
			 * @description The total number of actions within the activity.
			 * @example 1
			 */
			total_actions: number;
			/**
			 * @description The type of federated activity.
			 * @example comment
			 * @enum {string}
			 */
			type?: "comment" | "post" | "share";
		};
		FederatedActivityResponse: {
			data?: components["schemas"]["FederatedActivity"];
			meta?: components["schemas"]["MetaTotalPages"];
		};
		FederatedConfig: {
			endpoint_configs?: {
				http_headers?: components["schemas"]["ConfigItem"];
				http2_disabled?: components["schemas"]["ConfigItem"];
				url?: components["schemas"]["ConfigItem"];
			};
			id?: string;
			worker_configs?: {
				endpoint?: components["schemas"]["ConfigItem"];
				id?: components["schemas"]["ConfigItem"];
				minimum_resource?: components["schemas"]["MinimumResource"];
				network?: components["schemas"]["ConfigItem"];
				parameters?: {
					kafka_topic?: components["schemas"]["ConfigItem"];
				};
				worker?: components["schemas"]["ConfigItem"];
			}[];
		};
		/**
		 * @description Represents fee information for an activity.
		 * @example {
		 *       "amount": "315699955320960",
		 *       "decimal": 18
		 *     }
		 */
		Fee: {
			/** @description The address to which the fee is paid. */
			address?: string;
			/** @description The amount of the fee. */
			amount: string;
			/** @description The decimal precision of the fee amount. */
			decimal?: number;
		};
		/**
		 * @description SVG image data of the chip.
		 * @example <?xml version="1.0" encoding="utf-8"?>
		 *       <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;background-color:black;" xml:space="preserve">
		 *         <style type="text/css">.f{fill:#FB1467;}.c{fill:#1477FB;}.b{fill:#DEE5D9;}.h{fill:#DEE5D9;}.alpha{fill:#1477FB;}.pg{fill:#FB1467;}.e{fill-rule:evenodd;clip-rule:evenodd;}</style>
		 *         <path class="f" d="M16 88h68v2H16zm0 4h4v2h-4zm6 0h2v2h-2zm4 0h6v2h-6zm12 0h6v2h-6zm8 0h3v2h-3zm5 0h3v2h-3zm-17 0h2v2h-2zm22 0h6v2h-6zm8 0h2v2h-2zm4 0h6v2h-6zm12 0h4v2h-4zm-4 0h2v2h-2zM16 10h68v2H16zm0-4h4v2h-4zm6 0h2v2h-2zm4 0h6v2h-6zm12 0h6v2h-6zm8 0h3v2h-3zm5 0h3v2h-3zM34 6h2v2h-2zm22 0h6v2h-6zm8 0h2v2h-2zm4 0h6v2h-6zm12 0h4v2h-4zm-4 0h2v2h-2zM12 16v68h-2V16zM6 84v-4h2v4zm0-6v-2h2v2zm0-4v-6h2v6zm0-12v-6h2v6zm0-8v-3h2v3zm0-5v-3h2v3zm0 17v-2h2v2zm0-22v-6h2v6zm0-8v-2h2v2zm0-4v-6h2v6zm0-12v-4h2v4zm0 4v-2h2v2zm84-8v68h-2V16zm2 68v-4h2v4zm0-6v-2h2v2zm0-4v-6h2v6zm0-12v-6h2v6zm0-8v-3h2v3zm0-5v-3h2v3zm0 17v-2h2v2zm0-22v-6h2v6zm0-8v-2h2v2zm0-4v-6h2v6zm0-12v-4h2v4zm0 4v-2h2v2z"/>
		 *         <svg class="c">
		 *           <path d="M52 80h2v6h-2zm4 0h2v6h-2z"/>
		 *           <path d="M58 84v2h-6v-2zm0-4v2h-6v-2zm10 0h2v6h-2zm4 0h2v6h-2z"/>
		 *           <path d="M74 84v2h-6v-2zm0-4v2h-6v-2zm6-12h2v6h-2zm4 0h2v6h-2z"/>
		 *           <path d="M86 72v2h-6v-2zm0-4v2h-6v-2zm-6 12h2v6h-2zm4 0h2v6h-2z"/>
		 *           <path d="M86 84v2h-6v-2zm0-4v2h-6v-2zm-6-28h6v6h-6zM54 86h2v2h-2zm4-2v-2h10v2zm16-6h2v2h-2zm-24 4h2v2h-2zm26-6h2v2h-2zm2-2h2v2h-2zm-4 8h6v2h-6zm6-40h6v6h-6zm4 32v6h-2v-6zm0-16v10h-2V58zm0-26v10h-2V32zm-2 16h2v4h-2zM52 20h2v-6h-2zm4 0h2v-6h-2z"/>
		 *           <path d="M58 16v-2h-6v2zm0 4v-2h-6v2zm10 0h2v-6h-2zm4 0h2v-6h-2z"/>
		 *           <path d="M74 16v-2h-6v2zm0 4v-2h-6v2zm6 12h2v-6h-2zm4 0h2v-6h-2z"/>
		 *           <path d="M86 28v-2h-6v2zm0 4v-2h-6v2zm-6-12h2v-6h-2zm4 0h2v-6h-2z"/>
		 *           <path d="M86 16v-2h-6v2zm0 4v-2h-6v2zm-32-6h2v-2h-2zm4 2v2h10v-2zm16 6h2v-2h-2zm-24-4h2v-2h-2zm26 6h2v-2h-2zm2 2h2v-2h-2zm-4-8h6v-2h-6zm10 8v-6h-2v6zm-36-6h-2v-6h2zm-4 0h-2v-6h2z"/>
		 *           <path d="M42 16v-2h6v2zm0 4v-2h6v2zm-10 0h-2v-6h2zm-4 0h-2v-6h2z"/>
		 *           <path d="M26 16v-2h6v2zm0 4v-2h6v2zm-6 12h-2v-6h2zm-4 0h-2v-6h2z"/>
		 *           <path d="M14 28v-2h6v2zm0 4v-2h6v2zm6-12h-2v-6h2zm-4 0h-2v-6h2z"/>
		 *           <path d="M14 16v-2h6v2zm0 4v-2h6v2zm6 28h-6v-6h6zm26-34h-2v-2h2zm-4 2v2H32v-2zm-16 6h-2v-2h2zm24-4h-2v-2h2zm-26 6h-2v-2h2zm-2 2h-2v-2h2zm4-8h-6v-2h6zm-6 40h-6v-6h6zm-4-32v-6h2v6zm0 16V32h2v10zm0 26V58h2v10zm2-16h-2v-4h2zm30 28h-2v6h2zm-4 0h-2v6h2z"/>
		 *           <path d="M42 84v2h6v-2zm0-4v2h6v-2zm-10 0h-2v6h2zm-4 0h-2v6h2z"/>
		 *           <path d="M26 84v2h6v-2zm0-4v2h6v-2zm-6-12h-2v6h2zm-4 0h-2v6h2z"/>
		 *           <path d="M14 72v2h6v-2zm0-4v2h6v-2zm6 12h-2v6h2zm-4 0h-2v6h2z"/>
		 *           <path d="M14 84v2h6v-2zm0-4v2h6v-2zm32 6h-2v2h2zm-4-2v-2H32v2zm-16-6h-2v2h2zm24 4h-2v2h2zm-26-6h-2v2h2zm-2-2h-2v2h2zm4 8h-6v2h6zm-10-8v6h2v-6z"/>
		 *         </svg>
		 *         <path class="alpha" d="M6 6V4h4v2zm4 0v2H6V6H4v6h2v-2h4v2h2V6zm84-2v2h-4V4zm0 2v2h-4V6h-2v6h2v-2h4v2h2V6zM10 88v2H6v-2zm0 2v2H6v-2H4v6h2v-2h4v2h2v-6zm84-2v2h-4v-2zm0 2v2h-4v-2h-2v6h2v-2h4v2h2v-6z"/>
		 *         <polygon class="b" points="72,46 72,64 70,64 70,66 68,66 68,68 66,68 66,70 64,70 64,72 36,72 36,70 34,70 34,68 32,68 32,66   30,66 30,64 28,64 28,46 30,46 30,44 70,44 70,46 "/>
		 *         <path d="M36 50h2v2h-2zm2 2h2v2h-2zm2 2h2v2h-2zm-4 0h2v2h-2zm4-4h2v2h-2zm18 0h2v2h-2zm2 2h2v2h-2zm2 2h2v2h-2zm-4 0h2v2h-2zm4-4h2v2h-2zm-14 6h4v2h-4zm-2-2h2v2h-2zm6 0h2v2h-2z" fill="#000"/>
		 *         <path d="M40 62h2v2h-2zM42 64h2v2h-2zM42 62h2v2h-2zM44 64h2v2h-2z" fill="#000"/>
		 *         <path d="M44 64h16v4H44z" fill="#000"/>
		 *         <path class="h" d="M28 40h44v2H28z"/>
		 *         <path class="h e" d="M40 33v-3h-2v-2h-2v2h-2v2h-2v2h-2v2h-2v2h5v-2h2v2h5v-3h-4v-2z"/>
		 *         <path class="h e" d="M42 24v2h-4v2h4v2h5v2h-5v6h7V24zm5 4h-2v-2h2zm23 8v-2h-2v-2h-2v-2h-2v-2h-2v2h-2v3h4v2h-6v-3h-3v6h10v-2h2v2h5v-2z"/>
		 *         <path class="h e" d="M58 26v-2h-7v14h2v-8h5v-2h4v-2zm-3 2h-2v-2h2z"/>
		 *       </svg>
		 */
		Image: string;
		/** @description Metadata for paginated responses. */
		MetaCursor: {
			/** @description The cursor for the next set of results. */
			cursor: string;
		};
		/** @description Metadata indicating the total number of pages. */
		MetaTotalPages: {
			/**
			 * @description The total number of pages available.
			 * @example 1
			 */
			totalPages: number;
		};
		MetaverseBurn: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		MetaverseMint: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		MetaverseTrade: {
			/** @enum {string} */
			action?: "buy" | "list" | "sell";
			address?: string;
			cost?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		MetaverseTransfer: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		MinimumResource: {
			cpu_core?: number;
			disk_space_in_gb?: number;
			key?: string;
			memory_in_gb?: number;
			title?: string;
		};
		/**
		 * @description The network on which activities occur.
		 * @example ethereum
		 * @enum {string}
		 */
		Network:
			| "arbitrum"
			| "arweave"
			| "avax"
			| "base"
			| "binance-smart-chain"
			| "crossbell"
			| "ethereum"
			| "farcaster"
			| "gnosis"
			| "linea"
			| "mastodon"
			| "near"
			| "optimism"
			| "polygon"
			| "vsl"
			| "x-layer";
		/** @description The details of an asset for network. */
		NetworkAssetDetail: {
			/** @description The URL of the asset's icon. */
			icon_url?: string;
			/** @description The name of the asset. */
			name?: string;
			/** @description The type of the asset. */
			type?: string;
		};
		/** @example {
		 *       "id": 18,
		 *       "address": "0x69982e017acc0fde3d1542205089a8d3eafcd1b7",
		 *       "name": "Natural Selection Labs",
		 *       "description": "A Node operated by NSL.",
		 *       "tax_rate_basis_points": 800,
		 *       "is_public_good": false,
		 *       "operation_pool_tokens": "724429065703690345869831",
		 *       "staking_pool_tokens": "20798363499373370863570687",
		 *       "total_shares": "17339500000000000000000000",
		 *       "slashed_tokens": "0",
		 *       "alpha": true,
		 *       "status": "online",
		 *       "last_heartbeat": 1718694464,
		 *       "location": [
		 *         {
		 *           "country": "United States",
		 *           "region": "",
		 *           "city": "",
		 *           "latitude": 37.751,
		 *           "longitude": -97.822
		 *         }
		 *       ],
		 *       "avatar": {
		 *         "name": "Node Avatar",
		 *         "description": "",
		 *         "image": "https://gi.rss3.io/nta/nodes/0x69982E017Acc0FDE3d1542205089A8d3EAfcD1B7/avatar.svg"
		 *       },
		 *       "min_tokens_to_stake": "599739424417467944968",
		 *       "apy": "0.3928765550642588002426864199264",
		 *       "reliability_score": "0",
		 *       "version": "v1.0.0",
		 *       "type": "production",
		 *       "created_at": 1710278898
		 *     } */
		Node: {
			address: string;
			/** @description Whether the Node is an alpha node */
			alpha?: boolean;
			avatar: {
				description?: string;
				image?: string;
				name?: string;
			};
			/** @description The timestamp of the Node creation */
			created_at: number;
			description: string;
			id: number;
			is_public_good: boolean;
			/** @description The timestamp of the last heartbeat */
			last_heartbeat: number;
			local?: {
				city?: string;
				country?: string;
				latitude?: number;
				longitude?: number;
				region?: string;
			}[];
			min_tokens_to_stake: string;
			name: string;
			operation_pool_tokens: string;
			slashed_tokens: string;
			staking_pool_tokens: string;
			/** @enum {string} */
			status:
				| "none"
				| "registered"
				| "initializing"
				| "outdated"
				| "online"
				| "offline"
				| "slashing"
				| "slashed"
				| "exiting"
				| "exited";
			tax_rate_basis_points?: number | null;
			total_shares: string;
			/**
			 * @description The type of the node
			 * @enum {string}
			 */
			type?: "alpha" | "beta" | "production";
			/** @description The version of the node */
			version?: string;
		};
		/** @example {
		 *       "transaction": {
		 *         "hash": "0x84c045a41d6fb83a94f4f2096863faced7c5799bcd382bec49333d017f744c41",
		 *         "index": 1
		 *       },
		 *       "block": {
		 *         "hash": "0x0e9f8868b1fd7aa28183292d198b4375263fbc38541d51efd90aec1de7e4b5bc",
		 *         "number": 210189,
		 *         "timestamp": 1710278897
		 *       },
		 *       "address_from": "0x69982e017acc0fde3d1542205089a8d3eafcd1b7",
		 *       "address_to": "0x28f14d917fddba0c1f2923c406952478dfda5578",
		 *       "node_id": 18,
		 *       "type": "nodeCreated",
		 *       "log_index": 0,
		 *       "chain_id": 12553,
		 *       "metadata": {}
		 *     } */
		NodeEvent: {
			address_from: string;
			address_to: string;
			block: {
				hash: string;
				number: number;
				timestamp: number;
			};
			chain_id: number;
			log_index: number;
			metadata: {
				node_created?: {
					address: string;
					description: string;
					is_public_good: boolean;
					name: string;
					node_id: number;
					tax_rate_basis_points: number;
				};
				node_updated?: {
					address: string;
					description: string;
					name: string;
				};
			};
			node_id: number;
			transaction: {
				hash: string;
				index: number;
			};
			/** @enum {string} */
			type: "nodeCreated" | "nodeUpdated";
		};
		OperationProfit: {
			address: string;
			/** @example 2024-03-13T00:08:38+08:00 */
			date: string;
			epoch_id: number;
			operation_pool: string;
		};
		OperationProfitPNL: {
			/** @example 2024-06-17T20:02:35Z */
			date: string;
			/** @example 724429065703690345869831 */
			operation_pool: string;
			/** @example 0 */
			profit_and_loss: string;
		};
		/**
		 * @description The platform on which activities occur.
		 * @enum {string}
		 */
		Platform:
			| "1inch"
			| "AAVE"
			| "Aavegotchi"
			| "Arbitrum"
			| "Base"
			| "BendDAO"
			| "Cow"
			| "Crossbell"
			| "Curve"
			| "ENS"
			| "Farcaster"
			| "Highlight"
			| "IQWiki"
			| "KiwiStand"
			| "Lens"
			| "LiNEAR"
			| "Lido"
			| "Linea"
			| "LooksRare"
			| "Matters"
			| "Mirror"
			| "NearSocial"
			| "Nouns"
			| "OpenSea"
			| "Optimism"
			| "Paragraph"
			| "Paraswap"
			| "Polymarket"
			| "RSS3"
			| "Rainbow"
			| "SAVM"
			| "Stargate"
			| "Uniswap"
			| "Unknown"
			| "VSL"
			| "Zerion";
		ResponseError: {
			details?: string;
			error: string;
			/** @enum {string} */
			error_code:
				| "bad_request"
				| "validation_failed"
				| "bad_params"
				| "internal_error"
				| "service_unavailable";
		};
		RSSConfig: {
			id?: string;
			worker_configs?: {
				endpoint?: components["schemas"]["ConfigItem"];
				id?: components["schemas"]["ConfigItem"];
				minimum_resource?: components["schemas"]["MinimumResource"];
				network?: components["schemas"]["ConfigItem"];
				parameters?: {
					authentication?: {
						access_key?: components["schemas"]["ConfigItem"];
					};
				};
				worker?: components["schemas"]["ConfigItem"];
			};
		};
		RssFeed: {
			authors?: {
				name: string;
			}[];
			description: string;
			pub_date?: string;
			title: string;
		};
		SocialComment: {
			author_url?: string;
			body?: string;
			content_uri?: string;
			handle?: string;
			media?: {
				address: string;
				mime_type: string;
			}[];
			profile_id?: string;
			publication_id?: string;
			reward?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			summary?: string;
			tags?: string[];
			target?: components["schemas"]["SocialPost"];
			target_url?: string;
			timestamp?: number;
			title?: string;
		};
		SocialDelete: {
			author_url?: string;
			body?: string;
			content_uri?: string;
			handle?: string;
			media?: {
				address: string;
				mime_type: string;
			}[];
			profile_id?: string;
			publication_id?: string;
			reward?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			summary?: string;
			tags?: string[];
			target?: components["schemas"]["SocialPost"];
			target_url?: string;
			timestamp?: number;
			title?: string;
		};
		SocialMint: {
			author_url?: string;
			body?: string;
			content_uri?: string;
			handle?: string;
			media?: {
				address: string;
				mime_type: string;
			}[];
			profile_id?: string;
			publication_id?: string;
			reward?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			summary?: string;
			tags?: string[];
			target?: components["schemas"]["SocialPost"];
			target_url?: string;
			timestamp?: number;
			title?: string;
		};
		SocialPost: {
			author_url?: string;
			body?: string;
			content_uri?: string;
			handle?: string;
			media?: {
				address: string;
				mime_type: string;
			}[];
			profile_id?: string;
			publication_id?: string;
			reward?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			summary?: string;
			tags?: string[];
			target?: components["schemas"]["SocialPost"];
			target_url?: string;
			timestamp?: number;
			title?: string;
		};
		SocialProfile: {
			/** @enum {string} */
			action?: "create" | "renew" | "unwrap" | "update" | "wrap";
			address?: string;
			bio?: string;
			expiry?: string;
			handle?: string;
			image_uri?: string;
			key?: string;
			name?: string;
			profile_id?: string;
			value?: string;
		};
		SocialProxy: {
			/** @enum {string} */
			action?: "appoint" | "remove";
			profile?: {
				/** @enum {string} */
				action?: "create" | "renew" | "unwrap" | "update" | "wrap";
				address?: string;
				bio?: string;
				expiry?: string;
				handle?: string;
				image_uri?: string;
				key?: string;
				name?: string;
				profile_id?: string;
				value?: string;
			};
			proxy_address: string;
		};
		SocialRevise: {
			author_url?: string;
			body?: string;
			content_uri?: string;
			handle?: string;
			media?: {
				address: string;
				mime_type: string;
			}[];
			profile_id?: string;
			publication_id?: string;
			reward?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			summary?: string;
			tags?: string[];
			target?: components["schemas"]["SocialPost"];
			target_url?: string;
			timestamp?: number;
			title?: string;
		};
		SocialReward: {
			author_url?: string;
			body?: string;
			content_uri?: string;
			handle?: string;
			media?: {
				address: string;
				mime_type: string;
			}[];
			profile_id?: string;
			publication_id?: string;
			reward?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			summary?: string;
			tags?: string[];
			target?: components["schemas"]["SocialPost"];
			target_url?: string;
			timestamp?: number;
			title?: string;
		};
		SocialShare: {
			author_url?: string;
			body?: string;
			content_uri?: string;
			handle?: string;
			media?: {
				address: string;
				mime_type: string;
			}[];
			profile_id?: string;
			publication_id?: string;
			reward?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
			summary?: string;
			tags?: string[];
			target?: components["schemas"]["SocialPost"];
			target_url?: string;
			timestamp?: number;
			title?: string;
		};
		StakerProfitSnapshot: {
			/** @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944 */
			address: string;
			/** @example 2024-06-17T02:01:29Z */
			date: string;
			/** @example 1 */
			epoch_id: number;
			/** @example 24 */
			total_chip_amount: string;
			/** @example 14459771035071565497880 */
			total_chip_value?: string;
		};
		StakeStaking: {
			chips: {
				showcase: components["schemas"]["Chip"][];
				total: number;
			};
			/** @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2 */
			node: string;
			/** @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1 */
			staker: string;
		};
		StakeTransaction: {
			/** @example [
			 *       1690,
			 *       1691
			 *     ] */
			chip_ids?: number[] | null;
			event?: {
				deposit?: {
					deposited?: components["schemas"]["TransactionEvent"];
				} | null;
				merge_chips?: {
					merged?: components["schemas"]["TransactionEvent"];
				} | null;
				stake?: {
					staked?: components["schemas"]["TransactionEvent"];
				} | null;
				unstake?: {
					claimed?: components["schemas"]["TransactionEvent"];
					requested?: components["schemas"]["TransactionEvent"];
				} | null;
				withdraw?: {
					claimed?: components["schemas"]["TransactionEvent"];
					requested?: components["schemas"]["TransactionEvent"];
				} | null;
			};
			/** @example 0xcb4038576ed46c3913915435c7ccb7316cf83c626dfcf580d0b84b86702e76eb */
			id: string;
			/** @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2 */
			node: string;
			/** @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944 */
			staker: string;
			/** @example 5000000000000000000000 */
			value: string;
		};
		/**
		 * @description A tag used to categorize activities.
		 * @example transaction
		 * @enum {string}
		 */
		Tag:
			| "collectible"
			| "exchange"
			| "governance"
			| "metaverse"
			| "rss"
			| "social"
			| "transaction"
			| "unknown";
		TransactionApproval: {
			/** @enum {string} */
			action: "approve" | "revoke";
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		TransactionBridge: {
			/** @enum {string} */
			action: "deposit" | "withdraw";
			/** @enum {string} */
			source_network:
				| "unknown"
				| "arbitrum"
				| "arweave"
				| "avax"
				| "base"
				| "binance-smart-chain"
				| "bitcoin"
				| "crossbell"
				| "ethereum"
				| "farcaster"
				| "gnosis"
				| "linea"
				| "mastodon"
				| "near"
				| "optimism"
				| "polygon"
				| "rsshub"
				| "savm"
				| "vsl"
				| "x-layer";
			/** @enum {string} */
			target_network:
				| "unknown"
				| "arbitrum"
				| "arweave"
				| "avax"
				| "base"
				| "binance-smart-chain"
				| "bitcoin"
				| "crossbell"
				| "ethereum"
				| "farcaster"
				| "gnosis"
				| "linea"
				| "mastodon"
				| "near"
				| "optimism"
				| "polygon"
				| "rsshub"
				| "savm"
				| "vsl"
				| "x-layer";
			token?: {
				address?: string;
				decimals?: number;
				id?: string;
				name?: string;
				parsed_image_url?: string;
				/** @enum {string} */
				standard?:
					| "Unknown"
					| "ERC-20"
					| "NEP-141"
					| "ERC-165"
					| "ERC-721"
					| "ERC-1155"
					| "ERC-1967";
				symbol?: string;
				uri?: string;
				value?: string;
			};
		};
		TransactionBurn: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		/** @example {
		 *       "block": {
		 *         "hash": "0x200b26e118e51f23d052ef3aa92bc411dbd0a6ce811f511adb9f6049dc938614",
		 *         "number": 726419,
		 *         "timestamp": 1708337158
		 *       },
		 *       "transaction": {
		 *         "hash": "0x6595192f1193c2584c28e7d4b50b9208242bf9b4538933f0081d3f4625373d2f",
		 *         "index": 1
		 *       }
		 *     } */
		TransactionEvent: {
			block: {
				hash: string;
				number: number;
				timestamp: number;
			};
			metadata?: {
				burned_token_ids?: number[];
				new_token_id?: number;
			} | null;
			transaction: {
				hash: string;
				index: number;
			};
		} | null;
		TransactionMint: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		TransactionTransfer: {
			address?: string;
			decimals?: number;
			id?: string;
			name?: string;
			parsed_image_url?: string;
			/** @enum {string} */
			standard?:
				| "Unknown"
				| "ERC-20"
				| "NEP-141"
				| "ERC-165"
				| "ERC-721"
				| "ERC-1155"
				| "ERC-1967";
			symbol?: string;
			uri?: string;
			value?: string;
		};
		/**
		 * @description The type of activity.
		 * @example transfer
		 * @enum {string}
		 */
		Type:
			| "approval"
			| "auction"
			| "bridge"
			| "burn"
			| "comment"
			| "delete"
			| "feed"
			| "liquidity"
			| "loan"
			| "mint"
			| "post"
			| "profile"
			| "proposal"
			| "proxy"
			| "revise"
			| "reward"
			| "share"
			| "staking"
			| "swap"
			| "trade"
			| "transfer"
			| "unknown"
			| "vote";
		/** @description The details of an asset for worker. */
		WorkerAssetDetail: {
			/** @description The URL of the asset's icon. */
			icon_url?: string;
			/** @description The name of the asset. */
			name?: string;
			/** @description The platform of the asset (for workers only). */
			platform?: string;
			/** @description The type of the asset. */
			type?: string;
		};
	};
	responses: {
		/** @description The request was invalid or malformed. */
		400: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["ResponseError"];
			};
		};
		/** @description An internal server error occurred while processing the request. */
		500: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["ResponseError"];
			};
		};
		/** @description A successful response with the activities from the specified account. The response includes details about each activity, such as its ID, timestamp, and associated actions. */
		ActivitiesResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["ActivitiesResponse"];
			};
		};
		/** @description A successful response containing the details of the specified activity. The response includes the activity ID, timestamp, and a list of actions performed within the activity. */
		ActivityResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["ActivityResponse"];
			};
		};
		/** @description A successful response containing the details of an asset (network and worker). */
		AssetsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data: {
						/** @description Array of network info details. */
						networks?: components["schemas"]["NetworkAssetDetail"][];
						/** @description Array of worker info details. */
						workers?: components["schemas"]["WorkerAssetDetail"][];
					};
				};
			};
		};
		/** @description Bridging transaction details fetched successfully */
		BridgeTransactionByHashResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: components["schemas"]["BridgeTransaction"];
				};
			};
		};
		/** @description List of bridging transactions retrieved successfully */
		BridgeTransactionsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: components["schemas"]["BridgeTransaction"][];
				};
			};
		};
		/** @description A successful response containing the SVG image of the specified chip. The image can be used to visually represent the chip. */
		ChipImageResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"image/svg+xml": components["schemas"]["Image"];
			};
		};
		/** @description A successful response containing detailed information about the specified chip. The data includes the chip's ID, Node address, owner address, and metadata such as name, description, and image. */
		ChipResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["Chip"];
			};
		};
		/** @description A successful response containing a list of chips based on the provided filters. Each chip includes detailed information such as its ID, Node address, owner address, and metadata. The response also includes a cursor for pagination to fetch subsequent sets of results. */
		ChipsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/**
					 * @description Cursor for pagination to fetch the next set of results.
					 * @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2
					 */
					cursor: string;
					/** @description Array of chips matching the filter criteria. */
					data: components["schemas"]["Chip"][];
				};
			};
		};
		/** @description A successful response containing the APY for epoch snapshots. Each entry in the data array includes the epoch details and the corresponding APY. */
		EpochAPYSnapshotsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Array of epoch APY snapshots. */
					data: components["schemas"]["EpochAPYSnapshot"][];
				};
			};
		};
		/** @description A successful response containing detailed information about the specified epoch. */
		EpochResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["Epoch"];
			};
		};
		/** @description A successful response containing the average APY for all epochs. */
		EpochsAverageAPYResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/**
					 * @description The average APY of all epochs.
					 * @example 1.4665029316918649354
					 */
					data: string;
				};
			};
		};
		/** @description A successful response containing a list of epochs. Each entry in the data array includes brief information about the epoch. */
		EpochsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Cursor for pagination to fetch the next set of results. */
					cursor?: string;
					/** @description Array of epochs. */
					data: components["schemas"]["BriefEpoch"][];
				};
			};
		};
		/** @description A successful response containing details of the specified epoch transaction. */
		EpochTransactionResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Array of epoch distribution details. */
					data: components["schemas"]["EpochDistribution"][];
				};
			};
		};
		/** @description A successful response with the activities from the specified account. The response includes details about each activity, such as its ID, timestamp, and associated actions. */
		FederatedActivitiesResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["FederatedActivitiesResponse"];
			};
		};
		/** @description A successful response containing the details of the specified federated activity. The response includes the activity ID, timestamp, and a list of actions performed within the activity. */
		FederatedActivityResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["FederatedActivityResponse"];
			};
		};
		/** @description A successful response containing the configuration details of RSS, Decentralized, and Federated networks. */
		NetworkConfigResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: {
						data?: {
							decentralized?: components["schemas"]["DecentralizedConfig"][];
							federated?: components["schemas"]["FederatedConfig"][];
							rss?: components["schemas"]["RSSConfig"];
						};
					};
				};
			};
		};
		/** @description A successful response containing the SVG image of the specified node. The image can be used to visually represent the node. */
		NodeAvatarResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"image/svg+xml": components["schemas"]["Image"];
			};
		};
		/** @description A successful response containing snapshots of Node counts over time. Each entry in the data array includes the date and the count of nodes on that date. */
		NodeCountSnapshotsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Array of Node count snapshots. */
					data: components["schemas"]["CountSnapshot"][];
				};
			};
		};
		/** @description A successful response containing transaction events for the specified node. Each entry in the data array includes detailed information about the event. */
		NodeEventsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Cursor for pagination to fetch the next set of results. */
					cursor: string;
					/** @description Array of Node transaction events. */
					data: components["schemas"]["NodeEvent"][];
				};
			};
		};
		/** @description A successful response containing detailed information about the operation profit of the specified node. Each entry includes address, operation pool, and PNL details for different time periods. */
		NodeOperationProfitResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Operation profit details for the node. */
					data: {
						/**
						 * @description The address of the node.
						 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
						 */
						node_address: string;
						oneDay?: components["schemas"]["OperationProfitPNL"];
						oneMonth?: components["schemas"]["OperationProfitPNL"];
						oneWeek?: components["schemas"]["OperationProfitPNL"];
						/**
						 * @description The operation pool of the node.
						 * @example 724429065703690345869831
						 */
						operation_pool: string;
					};
				};
			};
		};
		/** @description A successful response containing detailed information about the specified node. */
		NodeResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["Node"];
			};
		};
		/** @description A successful response containing the rewards of the specified Node by epoch. Each entry in the data array includes detailed information about the epoch. */
		NodeRewardsByEpochResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Cursor for pagination to fetch the next set of results. */
					cursor: string;
					/** @description Array of epochs with Node rewards. */
					data: components["schemas"]["Epoch"][];
				};
			};
		};
		/** @description A successful response containing a list of nodes. Each entry includes detailed information about the node. */
		NodesResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["Node"][];
			};
		};
		/** @description A successful response containing snapshots of the operation profit over time for the specified node. Each entry in the data array includes the date and profit details. The response also includes a cursor for pagination to fetch subsequent sets of results. */
		OperationProfitSnapshotsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Cursor for pagination to fetch the next set of results. */
					cursor: string;
					/** @description Array of operation profit snapshots. */
					data: components["schemas"]["OperationProfit"][];
				};
			};
		};
		/** @description A successful response with the activities from rss feed. */
		RSSActivitiesResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": components["schemas"]["ActivitiesResponse"];
			};
		};
		/** @description A successful response containing snapshots of the total staker count over time. Each entry in the data array includes the date and the count of stakers on that date. */
		StakerCountSnapshotsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Array of staker count snapshots. */
					data: components["schemas"]["CountSnapshot"][];
				};
			};
		};
		/** @description A successful response containing snapshots of the staker profit over time. Each entry in the data array includes the date and profit details. The response also includes a cursor for pagination to fetch subsequent sets of results. */
		StakerProfitSnapshotsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Cursor for pagination to fetch the next set of results. */
					cursor: string;
					/** @description Array of staker profit snapshots. */
					data: components["schemas"]["StakerProfitSnapshot"][];
				};
			};
		};
		/** @description A successful response containing detailed information about the specified staker. The data includes the staker's wallet address, total staked nodes, total chips, total staked tokens, and current staked tokens. */
		StakerResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: {
						/**
						 * @description The wallet address of the staker.
						 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
						 */
						address?: string;
						/**
						 * @description Total amount of tokens currently staked.
						 * @example 199547980194376366760196
						 */
						current_staked_tokens?: string;
						/**
						 * @description Total number of chips by the staker.
						 * @example 374
						 */
						total_chips?: string;
						/**
						 * @description Total number of nodes staked by the staker.
						 * @example 1
						 */
						total_staked_nodes?: number;
						/**
						 * @description Total number of tokens historically staked (including unstaked tokens).
						 * @example 199547980194376366760196
						 */
						total_staked_tokens?: string;
					};
				};
			};
		};
		/** @description A successful response containing a list of stakers and their associated nodes. Each entry in the data array represents a staker and includes detailed information about the staker, the Node they are associated with, and any associated chips. The response also includes a cursor for pagination to fetch subsequent sets of results. This allows users to retrieve large datasets incrementally. */
		StakeStakingsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/**
					 * @description Cursor for pagination to fetch the next set of results.
					 * @example 0xc7d6378960bd3374c31ce6223df0e79355ff3dc4b6dccf28afe84487321ef9fb
					 */
					cursor: string;
					data: components["schemas"]["StakeStaking"][];
				};
			};
		};
		/** @description Staking transaction details fetched successfully */
		StakeTransactionByHashResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: components["schemas"]["StakeTransaction"];
				};
			};
		};
		/** @description List of staking transactions retrieved successfully with pagination cursor */
		StakeTransactionsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					cursor?: string;
					data?: components["schemas"]["StakeTransaction"][];
				};
			};
		};
		/** @description A successful response containing the staking profit information for the specified staker. The data includes the owner's address, total chip amount, total chip value, and profit and loss (PNL) data for one day, one week, and one month. */
		StakingProfitResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					/** @description Staking profit information for the specified staker. */
					data?: {
						oneDay?: components["schemas"]["ChipPNL"];
						oneMonth?: components["schemas"]["ChipPNL"];
						oneWeek?: components["schemas"]["ChipPNL"];
						/**
						 * @description The address of the staker.
						 * @example 0x827431510a5d249ce4fdb7f00c83a3353f471848
						 */
						owner: string;
						/**
						 * @description The total amount of chips owned by the staker.
						 * @example 1000
						 */
						total_chip_amount: string;
						/**
						 * @description The total value of chips owned by the staker.
						 * @example 100000
						 */
						total_chip_value: string;
					};
				};
			};
		};
		/** @description A successful response containing the total supply of VSL token in RSS3. */
		TokenSupplyResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: {
						/** @description The total supply of VSL token in RSS3. */
						total_supply?: string;
					};
				};
			};
		};
		/** @description A successful response containing the TVL of VSL token in USD, including RSS3, WETH, USDT, USDC and POWER. */
		TokenTvlResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: {
						/** @description The TVL of VSL token in USD, including RSS3, WETH, USDT, USDC and POWER. */
						tvl?: string;
					};
				};
			};
		};
		/** @description A successful response containing the total number of requests made to the API. */
		TotalRequestsResponse: {
			headers: {
				[name: string]: unknown;
			};
			content: {
				"application/json": {
					data?: {
						/** @description The total number of requests made to the API. */
						total_requests?: number;
					};
				};
			};
		};
	};
	parameters: {
		/**
		 * @description Retrieve activities from the specified account. This account is a unique identifier within the decentralized system.
		 * @example 0xd8da6bf26964af9d7eed9e03e53415d37aa96045
		 */
		account_path: string;
		/**
		 * @description Specify the number of actions within the activity to retrieve
		 * @example 10
		 */
		action_limit_query: number;
		/**
		 * @description Specify the pagination for actions
		 * @example 1
		 */
		action_page_query: number;
		/** @description Retrieve activities from the specified tag(s). Tags can be used to categorize activities. */
		action_tag_query: components["schemas"]["Tag"][];
		/** @description Retrieve activities from the specified type(s). Types can help filter activities based on their nature or category. */
		action_type_query: components["schemas"]["Type"][];
		/**
		 * @description Retrieve details for the specified activity ID
		 * @example 0x840e42d573ebe1ff27a9e4914573b4e0518fcd685c7f9331d319abe854f780e3
		 */
		activity_id_path: string;
		/**
		 * @description Retrieve details for the specified activity ID
		 * @example 0x000000000000000000000000113f4b4c3765e5f05fd197c5c35b8a8a9b34245b
		 */
		activity_id_query: string;
		/**
		 * @description Address involved in the transaction
		 * @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1
		 */
		address_query: string;
		/** @description The date after which the snapshots are returned. */
		after_date_query: string;
		/** @description The date before which the snapshots are returned. */
		before_date_query: string;
		/**
		 * @description The unique hash of the bridging transaction
		 * @example 0x2af31b2a2708d5c9074074c578d3c521bd4385875e500f274fce52d3074460aa
		 */
		bridging_transaction_hash_path: string;
		/** @description Type of bridging transaction */
		bridging_type_query: "deposit" | "withdraw";
		/**
		 * @description The unique identifier of the chip to retrieve.
		 * @example 1690
		 */
		chip_id_path: number;
		/**
		 * @description Array of chip IDs to filter the results.
		 * @example [
		 *       1690
		 *     ]
		 */
		chip_ids_query: number[];
		/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
		cursor_query: string;
		/** @description Retrieve activities based on direction. The direction specifies whether the activity is incoming or outgoing. */
		direction_query: components["schemas"]["Direction"];
		/**
		 * @description The ID of the epoch to retrieve.
		 * @example 130
		 */
		epoch_id_path: string;
		/**
		 * @description The unique hash of the epoch transaction
		 * @example 0xe804d536d996d49b0ec8627361bc642f92d440e6b519e6faab0944f70bf05fd2
		 */
		epoch_transaction_hash_path: string;
		/**
		 * @description Retrieve activities from the specified account. This account is a unique identifier within the federated system.
		 * @example @jedi@bolha.us
		 */
		federated_account_path: string;
		/** @description Retrieve activities from the specified tag(s). Tags can be used to categorize activities. */
		federated_action_tag_query: "social"[];
		/** @description Retrieve activities from the specified type(s). Types can help filter activities based on their nature or category. */
		federated_action_type_query: ("post" | "comment" | "share")[];
		/**
		 * @description Retrieve details for the specified federated activity ID
		 * @example https://universeodon.com/users/woofers/statuses/113324128515491294/activity
		 */
		federated_activity_id_path: string;
		/**
		 * @description Retrieve activities from the specified federated network.
		 * @example mastodon
		 */
		federated_network_path: string;
		/** @description Retrieve activities from the specified federated network(s). You can specify one or more federated networks. */
		federated_network_query: "mastodon"[];
		/**
		 * @description Retrieve activities from the specified federated platform.
		 * @example Mastodon
		 */
		federated_platform_path: string;
		/** @description Retrieve activities from the specified platform(s). Platforms refer to the systems or environments where the activities occurred. */
		federated_platform_query: "Mastodon"[];
		/**
		 * @description Limit the number of results
		 * @example 50
		 */
		limit_1_50: number;
		/**
		 * @description Limit the number of results
		 * @example 30
		 */
		limit_1_200: number;
		/**
		 * @description Specify the number of activities to retrieve. By default, this is set to 100, and the maximum allowed value is 100.
		 * @example 20
		 */
		limit_query: number;
		/** @description The name of the network to retrieve available workers for. */
		network_name_path: components["schemas"]["Network"];
		/**
		 * @description Retrieve activities from the specified network.
		 * @example ethereum
		 */
		network_path: string;
		/** @description Retrieve activities from the specified network(s). You can specify one or more networks. */
		network_query: components["schemas"]["Network"][];
		/**
		 * @description The address of the Node to retrieve.
		 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
		 */
		node_address_path: string;
		/**
		 * @description Node address
		 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
		 */
		node_address_query: string;
		/**
		 * @description Node address
		 * @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2
		 */
		node_query: string;
		/**
		 * @description The address of the chip owner to filter the results.
		 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
		 */
		owner_query: string;
		/** @description Pending status of the transaction */
		pending_query: boolean;
		/**
		 * @description Retrieve activities from the specified platform.
		 * @example Uniswap
		 */
		platform_path: string;
		/** @description Retrieve activities from the specified platform(s). Platforms refer to the systems or environments where the activities occurred. */
		platform_query: components["schemas"]["Platform"][];
		/**
		 * @description Receiver address
		 * @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1
		 */
		receiver_query: string;
		/**
		 * @description Retrieve details for the specified RSS path
		 * @example abc
		 */
		rss_path: string;
		/**
		 * @description Sender address
		 * @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1
		 */
		sender_query: string;
		/** @description Retrieve activities starting from this timestamp. The timestamp is specified in Unix epoch time. */
		since_timestamp_query: number;
		/**
		 * @description The address of the staker whose profit information is to be retrieved.
		 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
		 */
		staker_address_path: string;
		/**
		 * @description Staker address
		 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
		 */
		staker_address_query: string;
		/**
		 * @description Staker address
		 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
		 */
		staker_query: string;
		/**
		 * @description The unique hash of the staking transaction
		 * @example 0xcb4038576ed46c3913915435c7ccb7316cf83c626dfcf580d0b84b86702e76eb
		 */
		staking_transaction_hash_path: string;
		/** @description Type of staking transaction */
		staking_type_query:
			| "deposit"
			| "withdraw"
			| "stake"
			| "unstake"
			| "merge_chips";
		/** @description Retrieve activities based on success status. Specify true for successful activities or false for unsuccessful ones. */
		success_query: boolean;
		/** @description Retrieve activities for the specified tag(s). */
		tag_query: components["schemas"]["Tag"][];
		/** @description Retrieve activities for the specified type(s). */
		type_query: components["schemas"]["Type"][];
		/** @description Retrieve activities up to this timestamp. The timestamp is specified in Unix epoch time. */
		until_timestamp_query: number;
		/**
		 * @description The name of the worker.
		 * @example core
		 */
		worker_name_path: string;
	};
	requestBodies: {
		/** @description Request body for batch retrieving activities for multiple accounts */
		BatchGetAccountsActivities: {
			content: {
				"application/json": {
					/**
					 * @description List of accounts to retrieve activities for
					 * @example [
					 *       "0xd8da6bf26964af9d7eed9e03e53415d37aa96045"
					 *     ]
					 */
					accounts?: string[];
					/**
					 * @description Specify the number of actions within the activity to retrieve
					 * @default 10
					 * @example 10
					 */
					action_limit?: number;
					/** @description Specify the cursor used for pagination */
					cursor?: string;
					direction?: components["schemas"]["Direction"];
					/**
					 * @description Specify the number of activities to retrieve
					 * @default 100
					 * @example 20
					 */
					limit?: number;
					/** @description Retrieve activities from the specified network(s) */
					network?: components["schemas"]["Network"][];
					/** @description Retrieve activities from the specified platform(s) */
					platform?: components["schemas"]["Platform"][];
					/** @description Retrieve activities starting from this timestamp */
					since_timestamp?: number;
					/** @description Retrieve activities based on success status */
					success?: boolean;
					/** @description Retrieve activities for the specified tag(s) */
					tag?: components["schemas"]["Tag"][];
					/** @description Retrieve activities for the specified type(s) */
					type?: components["schemas"]["Type"][];
					/** @description Retrieve activities up to this timestamp */
					until_timestamp?: number;
				};
			};
		};
		/** @description Request body for batch retrieving activities for multiple federated accounts */
		BatchGetFederatedAccountsActivities: {
			content: {
				"application/json": {
					/**
					 * @description List of federated accounts to retrieve activities
					 * @example [
					 *       "@hauptstadtzoos@mastodon.berlin",
					 *       "@nummycreations@mstdn.business"
					 *     ]
					 */
					accounts?: string[];
					/**
					 * @description Specify the number of actions within the activity to retrieve
					 * @default 10
					 * @example 10
					 */
					action_limit?: number;
					/** @description Specify the cursor used for pagination */
					cursor?: string;
					direction?: components["schemas"]["Direction"];
					/**
					 * @description Specify the number of activities to retrieve
					 * @default 100
					 * @example 20
					 */
					limit?: number;
					/** @description Retrieve activities from the specified network(s) */
					network?: string;
					/**
					 * @description Retrieve activities from the specified platform(s)
					 * @example Mastodon
					 */
					platform?: string;
					/** @description Retrieve activities starting from this timestamp */
					since_timestamp?: number;
					/** @description Retrieve activities based on success status */
					success?: boolean;
					/**
					 * @description Retrieve activities for the specified tag(s)
					 * @example social
					 */
					tag?: string;
					/**
					 * @description Retrieve activities for the specified type(s)
					 * @example [
					 *       "post",
					 *       "comment",
					 *       "share"
					 *     ]
					 */
					type?: components["schemas"]["Type"][];
					/** @description Retrieve activities up to this timestamp */
					until_timestamp?: number;
				};
			};
		};
	};
	headers: never;
	pathItems: never;
}
export type $defs = Record<string, never>;
export interface operations {
	getAccountActivities: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/** @description Retrieve activities based on direction. The direction specifies whether the activity is incoming or outgoing. */
				direction?: components["parameters"]["direction_query"];
				/**
				 * @description Specify the number of activities to retrieve. By default, this is set to 100, and the maximum allowed value is 100.
				 * @example 20
				 */
				limit?: components["parameters"]["limit_query"];
				/** @description Retrieve activities from the specified network(s). You can specify one or more networks. */
				network?: components["parameters"]["network_query"];
				/** @description Retrieve activities from the specified platform(s). Platforms refer to the systems or environments where the activities occurred. */
				platform?: components["parameters"]["platform_query"];
				/** @description Retrieve activities starting from this timestamp. The timestamp is specified in Unix epoch time. */
				since_timestamp?: components["parameters"]["since_timestamp_query"];
				/** @description Retrieve activities based on success status. Specify true for successful activities or false for unsuccessful ones. */
				success?: components["parameters"]["success_query"];
				/** @description Retrieve activities from the specified tag(s). Tags can be used to categorize activities. */
				tag?: components["parameters"]["action_tag_query"];
				/** @description Retrieve activities from the specified type(s). Types can help filter activities based on their nature or category. */
				type?: components["parameters"]["action_type_query"];
				/** @description Retrieve activities up to this timestamp. The timestamp is specified in Unix epoch time. */
				until_timestamp?: components["parameters"]["until_timestamp_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve activities from the specified account. This account is a unique identifier within the decentralized system.
				 * @example 0xd8da6bf26964af9d7eed9e03e53415d37aa96045
				 */
				account: components["parameters"]["account_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	batchGetAccountsActivities: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody: components["requestBodies"]["BatchGetAccountsActivities"];
		responses: {
			200: components["responses"]["ActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getNetworkActivities: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/** @description Retrieve activities based on direction. The direction specifies whether the activity is incoming or outgoing. */
				direction?: components["parameters"]["direction_query"];
				/**
				 * @description Specify the number of activities to retrieve. By default, this is set to 100, and the maximum allowed value is 100.
				 * @example 20
				 */
				limit?: components["parameters"]["limit_query"];
				/** @description Retrieve activities from the specified platform(s). Platforms refer to the systems or environments where the activities occurred. */
				platform?: components["parameters"]["platform_query"];
				/** @description Retrieve activities starting from this timestamp. The timestamp is specified in Unix epoch time. */
				since_timestamp?: components["parameters"]["since_timestamp_query"];
				/** @description Retrieve activities based on success status. Specify true for successful activities or false for unsuccessful ones. */
				success?: components["parameters"]["success_query"];
				/** @description Retrieve activities for the specified tag(s). */
				tag?: components["parameters"]["tag_query"];
				/** @description Retrieve activities for the specified type(s). */
				type?: components["parameters"]["type_query"];
				/** @description Retrieve activities up to this timestamp. The timestamp is specified in Unix epoch time. */
				until_timestamp?: components["parameters"]["until_timestamp_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve activities from the specified network.
				 * @example ethereum
				 */
				network: components["parameters"]["network_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getPlatformActivities: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/** @description Retrieve activities based on direction. The direction specifies whether the activity is incoming or outgoing. */
				direction?: components["parameters"]["direction_query"];
				/**
				 * @description Specify the number of activities to retrieve. By default, this is set to 100, and the maximum allowed value is 100.
				 * @example 20
				 */
				limit?: components["parameters"]["limit_query"];
				/** @description Retrieve activities from the specified network(s). You can specify one or more networks. */
				network?: components["parameters"]["network_query"];
				/** @description Retrieve activities starting from this timestamp. The timestamp is specified in Unix epoch time. */
				since_timestamp?: components["parameters"]["since_timestamp_query"];
				/** @description Retrieve activities based on success status. Specify true for successful activities or false for unsuccessful ones. */
				success?: components["parameters"]["success_query"];
				/** @description Retrieve activities for the specified tag(s). */
				tag?: components["parameters"]["tag_query"];
				/** @description Retrieve activities for the specified type(s). */
				type?: components["parameters"]["type_query"];
				/** @description Retrieve activities up to this timestamp. The timestamp is specified in Unix epoch time. */
				until_timestamp?: components["parameters"]["until_timestamp_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve activities from the specified platform.
				 * @example Uniswap
				 */
				platform: components["parameters"]["platform_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getActivityById: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/**
				 * @description Specify the pagination for actions
				 * @example 1
				 */
				action_page?: components["parameters"]["action_page_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve details for the specified activity ID
				 * @example 0x840e42d573ebe1ff27a9e4914573b4e0518fcd685c7f9331d319abe854f780e3
				 */
				id: components["parameters"]["activity_id_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ActivityResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getFederatedAccountActivities: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/** @description Retrieve activities based on direction. The direction specifies whether the activity is incoming or outgoing. */
				direction?: components["parameters"]["direction_query"];
				/**
				 * @description Specify the number of activities to retrieve. By default, this is set to 100, and the maximum allowed value is 100.
				 * @example 20
				 */
				limit?: components["parameters"]["limit_query"];
				/** @description Retrieve activities from the specified federated network(s). You can specify one or more federated networks. */
				network?: components["parameters"]["federated_network_query"];
				/** @description Retrieve activities from the specified platform(s). Platforms refer to the systems or environments where the activities occurred. */
				platform?: components["parameters"]["federated_platform_query"];
				/** @description Retrieve activities starting from this timestamp. The timestamp is specified in Unix epoch time. */
				since_timestamp?: components["parameters"]["since_timestamp_query"];
				/** @description Retrieve activities based on success status. Specify true for successful activities or false for unsuccessful ones. */
				success?: components["parameters"]["success_query"];
				/** @description Retrieve activities from the specified tag(s). Tags can be used to categorize activities. */
				tag?: components["parameters"]["federated_action_tag_query"];
				/** @description Retrieve activities from the specified type(s). Types can help filter activities based on their nature or category. */
				type?: components["parameters"]["federated_action_type_query"];
				/** @description Retrieve activities up to this timestamp. The timestamp is specified in Unix epoch time. */
				until_timestamp?: components["parameters"]["until_timestamp_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve activities from the specified account. This account is a unique identifier within the federated system.
				 * @example @jedi@bolha.us
				 */
				account: components["parameters"]["federated_account_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["FederatedActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	batchGetFederatedAccountsActivities: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody: components["requestBodies"]["BatchGetFederatedAccountsActivities"];
		responses: {
			200: components["responses"]["FederatedActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getFederatedNetworkActivities: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/** @description Retrieve activities based on direction. The direction specifies whether the activity is incoming or outgoing. */
				direction?: components["parameters"]["direction_query"];
				/**
				 * @description Specify the number of activities to retrieve. By default, this is set to 100, and the maximum allowed value is 100.
				 * @example 20
				 */
				limit?: components["parameters"]["limit_query"];
				/** @description Retrieve activities from the specified platform(s). Platforms refer to the systems or environments where the activities occurred. */
				platform?: components["parameters"]["federated_platform_query"];
				/** @description Retrieve activities starting from this timestamp. The timestamp is specified in Unix epoch time. */
				since_timestamp?: components["parameters"]["since_timestamp_query"];
				/** @description Retrieve activities based on success status. Specify true for successful activities or false for unsuccessful ones. */
				success?: components["parameters"]["success_query"];
				/** @description Retrieve activities from the specified tag(s). Tags can be used to categorize activities. */
				tag?: components["parameters"]["federated_action_tag_query"];
				/** @description Retrieve activities from the specified type(s). Types can help filter activities based on their nature or category. */
				type?: components["parameters"]["federated_action_type_query"];
				/** @description Retrieve activities up to this timestamp. The timestamp is specified in Unix epoch time. */
				until_timestamp?: components["parameters"]["until_timestamp_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve activities from the specified federated network.
				 * @example mastodon
				 */
				network: components["parameters"]["federated_network_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["FederatedActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getFederatedPlatformActivities: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/** @description Retrieve activities based on direction. The direction specifies whether the activity is incoming or outgoing. */
				direction?: components["parameters"]["direction_query"];
				/**
				 * @description Specify the number of activities to retrieve. By default, this is set to 100, and the maximum allowed value is 100.
				 * @example 20
				 */
				limit?: components["parameters"]["limit_query"];
				/** @description Retrieve activities from the specified federated network(s). You can specify one or more federated networks. */
				network?: components["parameters"]["federated_network_query"];
				/** @description Retrieve activities starting from this timestamp. The timestamp is specified in Unix epoch time. */
				since_timestamp?: components["parameters"]["since_timestamp_query"];
				/** @description Retrieve activities based on success status. Specify true for successful activities or false for unsuccessful ones. */
				success?: components["parameters"]["success_query"];
				/** @description Retrieve activities from the specified tag(s). Tags can be used to categorize activities. */
				tag?: components["parameters"]["federated_action_tag_query"];
				/** @description Retrieve activities from the specified type(s). Types can help filter activities based on their nature or category. */
				type?: components["parameters"]["federated_action_type_query"];
				/** @description Retrieve activities up to this timestamp. The timestamp is specified in Unix epoch time. */
				until_timestamp?: components["parameters"]["until_timestamp_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve activities from the specified federated platform.
				 * @example Mastodon
				 */
				platform: components["parameters"]["federated_platform_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["FederatedActivitiesResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getFederatedActivityById: {
		parameters: {
			query?: {
				/**
				 * @description Specify the number of actions within the activity to retrieve
				 * @example 10
				 */
				action_limit?: components["parameters"]["action_limit_query"];
				/**
				 * @description Specify the pagination for actions
				 * @example 1
				 */
				action_page?: components["parameters"]["action_page_query"];
			};
			header?: never;
			path: {
				/**
				 * @description Retrieve details for the specified federated activity ID
				 * @example https://universeodon.com/users/woofers/statuses/113324128515491294/activity
				 */
				id: components["parameters"]["federated_activity_id_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["FederatedActivityResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getBridgingTransactions: {
		parameters: {
			query?: {
				/**
				 * @description Address involved in the transaction
				 * @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1
				 */
				address?: components["parameters"]["address_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
				/**
				 * @description Receiver address
				 * @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1
				 */
				receiver?: components["parameters"]["receiver_query"];
				/**
				 * @description Sender address
				 * @example 0x3b6d02a24df681ffdf621d35d70aba7adaac07c1
				 */
				sender?: components["parameters"]["sender_query"];
				/** @description Type of bridging transaction */
				type?: components["parameters"]["bridging_type_query"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["BridgeTransactionsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getBridgingTransactionByHash: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The unique hash of the bridging transaction
				 * @example 0x2af31b2a2708d5c9074074c578d3c521bd4385875e500f274fce52d3074460aa
				 */
				transaction_hash: components["parameters"]["bridging_transaction_hash_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["BridgeTransactionByHashResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getAllChips: {
		parameters: {
			query?: {
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Array of chip IDs to filter the results.
				 * @example [
				 *       1690
				 *     ]
				 */
				id?: components["parameters"]["chip_ids_query"];
				/**
				 * @description Limit the number of results
				 * @example 30
				 */
				limit?: components["parameters"]["limit_1_200"];
				/**
				 * @description Node address
				 * @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2
				 */
				node?: components["parameters"]["node_query"];
				/**
				 * @description The address of the chip owner to filter the results.
				 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
				 */
				owner?: components["parameters"]["owner_query"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ChipsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getChipById: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The unique identifier of the chip to retrieve.
				 * @example 1690
				 */
				chip_id: components["parameters"]["chip_id_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ChipResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getChipImageById: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The unique identifier of the chip to retrieve.
				 * @example 1690
				 */
				chip_id: components["parameters"]["chip_id_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["ChipImageResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getDSLTotalRequests: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["TotalRequestsResponse"];
			500: components["responses"]["500"];
		};
	};
	getAllEpochs: {
		parameters: {
			query?: {
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["EpochsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getNodeRewardsByEpoch: {
		parameters: {
			query?: {
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
			};
			header?: never;
			path: {
				/**
				 * @description The address of the Node to retrieve.
				 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
				 */
				address: components["parameters"]["node_address_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NodeRewardsByEpochResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getEpochById: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The ID of the epoch to retrieve.
				 * @example 130
				 */
				epoch_id: components["parameters"]["epoch_id_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["EpochResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getEpochsAverageAPY: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["EpochsAverageAPYResponse"];
			500: components["responses"]["500"];
		};
	};
	getEpochTransactionByHash: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The unique hash of the epoch transaction
				 * @example 0xe804d536d996d49b0ec8627361bc642f92d440e6b519e6faab0944f70bf05fd2
				 */
				transaction_hash: components["parameters"]["epoch_transaction_hash_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["EpochTransactionResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getNodeAssets: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["AssetsResponse"];
			500: components["responses"]["500"];
		};
	};
	getNetworkConfig: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NetworkConfigResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getAllNodes: {
		parameters: {
			query?: {
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
				/**
				 * @description Node address
				 * @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2
				 */
				node?: components["parameters"]["node_query"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NodesResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getNodeByAddress: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The address of the Node to retrieve.
				 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
				 */
				address: components["parameters"]["node_address_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NodeResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getNodeAvatarByAddress: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The address of the Node to retrieve.
				 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
				 */
				address: components["parameters"]["node_address_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NodeAvatarResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getNodeEventsByAddress: {
		parameters: {
			query?: {
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
			};
			header?: never;
			path: {
				/**
				 * @description The address of the Node to retrieve.
				 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
				 */
				address: components["parameters"]["node_address_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NodeEventsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getNodeOperationProfitByAddress: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The address of the Node to retrieve.
				 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
				 */
				address: components["parameters"]["node_address_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NodeOperationProfitResponse"];
			400: components["responses"]["400"];
			/** @description Not found */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
	getEpochAPYSnapshots: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["EpochAPYSnapshotsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getNodeCountSnapshots: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["NodeCountSnapshotsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getNodeOperationProfitSnapshots: {
		parameters: {
			query?: {
				/** @description The date after which the snapshots are returned. */
				afterDate?: components["parameters"]["after_date_query"];
				/** @description The date before which the snapshots are returned. */
				beforeDate?: components["parameters"]["before_date_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
				/**
				 * @description Node address
				 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
				 */
				node_address?: components["parameters"]["node_address_query"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["OperationProfitSnapshotsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getStakerCountSnapshots: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["StakerCountSnapshotsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getStakerProfitSnapshots: {
		parameters: {
			query?: {
				/** @description The date after which the snapshots are returned. */
				afterDate?: components["parameters"]["after_date_query"];
				/** @description The date before which the snapshots are returned. */
				beforeDate?: components["parameters"]["before_date_query"];
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
				/**
				 * @description Staker address
				 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
				 */
				staker_address?: components["parameters"]["staker_address_query"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["StakerProfitSnapshotsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getStakerProfit: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The address of the staker whose profit information is to be retrieved.
				 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
				 */
				staker_address: components["parameters"]["staker_address_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["StakingProfitResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getStakerStats: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The address of the staker whose profit information is to be retrieved.
				 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
				 */
				staker_address: components["parameters"]["staker_address_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["StakerResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getStakersAndNodes: {
		parameters: {
			query?: {
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
				/**
				 * @description Node address
				 * @example 0x69982e017acc0fde3d1542205089a8d3eafcd1b7
				 */
				node_address?: components["parameters"]["node_address_query"];
				/**
				 * @description Staker address
				 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
				 */
				staker_address?: components["parameters"]["staker_address_query"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["StakeStakingsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getStakingTransactions: {
		parameters: {
			query?: {
				/** @description Specify the cursor used for pagination. This helps in retrieving the next set of results in a paginated response. */
				cursor?: components["parameters"]["cursor_query"];
				/**
				 * @description Limit the number of results
				 * @example 50
				 */
				limit?: components["parameters"]["limit_1_50"];
				/**
				 * @description Node address
				 * @example 0x08d66b34054a174841e2361bd4746ff9f4905cc2
				 */
				node?: components["parameters"]["node_query"];
				/** @description Pending status of the transaction */
				pending?: components["parameters"]["pending_query"];
				/**
				 * @description Staker address
				 * @example 0xc8b960d09c0078c18dcbe7eb9ab9d816bcca8944
				 */
				staker?: components["parameters"]["staker_query"];
				/** @description Type of staking transaction */
				type?: components["parameters"]["staking_type_query"];
			};
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["StakeTransactionsResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getStakingTransactionByHash: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description The unique hash of the staking transaction
				 * @example 0xcb4038576ed46c3913915435c7ccb7316cf83c626dfcf580d0b84b86702e76eb
				 */
				transaction_hash: components["parameters"]["staking_transaction_hash_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["StakeTransactionByHashResponse"];
			400: components["responses"]["400"];
			500: components["responses"]["500"];
		};
	};
	getRSS3TokenTotalSupply: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["TokenSupplyResponse"];
			500: components["responses"]["500"];
		};
	};
	getTokenTVL: {
		parameters: {
			query?: never;
			header?: never;
			path?: never;
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["TokenTvlResponse"];
			500: components["responses"]["500"];
		};
	};
	getRSSActivityByPath: {
		parameters: {
			query?: never;
			header?: never;
			path: {
				/**
				 * @description Retrieve details for the specified RSS path
				 * @example abc
				 */
				path: components["parameters"]["rss_path"];
			};
			cookie?: never;
		};
		requestBody?: never;
		responses: {
			200: components["responses"]["RSSActivitiesResponse"];
			/** @description The specified RSS path was not found. */
			404: {
				headers: {
					[name: string]: unknown;
				};
				content?: never;
			};
			500: components["responses"]["500"];
		};
	};
}
