declare function isAddress(address: string): boolean;
declare function isMastodon(handle: string): boolean;
declare function formatAddress(address: string): string;
/**
 * it will format the address, eg: 0x1234567890abcdef1234567890abcdef12345678 -> 0x1234...5678
 * also format the long handle, eg: 0x1234567890abcdef1234567890abcdef12345678.csb -> 0x1234...5678.csb
 */
declare function formatAddressAndNS(address: string): string;
declare function addressToAvatarURL(address: string, size: number): string;

export { addressToAvatarURL, formatAddress, formatAddressAndNS, isAddress, isMastodon };
