import { assertType, describe, it } from "vitest";
describe("TargetId", () => {
  it("has node as a target", () => {
    const target = "node";
    assertType(target);
  });
  it(`target doesn't exist`, () => {
    const target = "foo";
    assertType(target);
  });
  it("has undici as a client", () => {
    const client = "undici";
    assertType(client);
  });
  it(`client doesn't exist`, () => {
    const client = "does-not-exist";
    assertType(client);
  });
  it(`client exists, but target doesn't`, () => {
    const client = "undici";
    assertType(client);
  });
  it("client does exist, but not for the given target", () => {
    const client = "undici";
    assertType(client);
  });
});
//# sourceMappingURL=snippetz.test-d.js.map
