const currencySymbolMap = require('./map')

module.exports = function getSymbolFromCurrency (currencyCode) {
  if (typeof currencyCode !== 'string') {
    return undefined
  }

  const code = currencyCode.toUpperCase()

  if (!Object.prototype.hasOwnProperty.call(currencySymbolMap, code)) {
    return undefined
  }

  return currencySymbolMap[code]
}

module.exports.currencySymbolMap = currencySymbolMap
