'use strict';

const color = require('yoctocolors');
const table = require('text-table');

const { colors } = require('./config/constants.js');

const pluralize = function (word, count) {
  const plural = count === 1 ? word : word + 's';
  return plural;
};

module.exports = function (results) {
  let errorCount = 0;
  let fileCount = 0;
  let failureCount = 0;
  let passCount = 0;
  let warningCount = 0;

  results.forEach(function (result) {
    const messages = result.messages;

    if (messages.length === 0) {
      passCount++;
    } else {
      failureCount++;
      warningCount += result.warningCount;
      errorCount += result.errorCount;
    }
  });

  fileCount = passCount + failureCount;

  const summaryLineArray = [
    color.bold(fileCount + ' ' + pluralize('file', fileCount) + ' checked.'),
    color.bold(passCount + ' passed.'),
    color.bold(failureCount + ' failed.'),
  ];

  if (warningCount || errorCount) {
    summaryLineArray.push(
      color[colors.warning](color.bold(warningCount + ' ' + pluralize('warning', warningCount) + '.'))
    );
    summaryLineArray.push(color[colors.error](color.bold(errorCount + ' ' + pluralize('error', errorCount) + '.')));
  }

  return '\n' + table([summaryLineArray]) + '\n';
};
