import { Bezier } from 'bezier-js';
export interface Vector {
    x: number;
    y: number;
}
export interface TimedVector extends Vector {
    timestamp: number;
}
export declare const origin: Vector;
export declare const sub: (a: Vector, b: Vector) => Vector;
export declare const div: (a: Vector, b: number) => Vector;
export declare const mult: (a: Vector, b: number) => Vector;
export declare const add: (a: Vector, b: Vector) => Vector;
export declare const scale: (value: number, range1: [number, number], range2: [number, number]) => number;
export declare const direction: (a: Vector, b: Vector) => Vector;
export declare const perpendicular: (a: Vector) => Vector;
export declare const magnitude: (a: Vector) => number;
export declare const unit: (a: Vector) => Vector;
export declare const setMagnitude: (a: Vector, amount: number) => Vector;
export declare const randomNumberRange: (min: number, max: number) => number;
export declare const randomVectorOnLine: (a: Vector, b: Vector) => Vector;
export declare const generateBezierAnchors: (a: Vector, b: Vector, spread: number) => [Vector, Vector];
export declare const clamp: (target: number, min: number, max: number) => number;
export declare const overshoot: (coordinate: Vector, radius: number) => Vector;
export declare const bezierCurve: (start: Vector, finish: Vector, 
/**
 * Default is length from start to finish, clamped to 2 < x < 200
 */
spreadOverride?: number) => Bezier;
export declare const bezierCurveSpeed: (t: number, P0: Vector, P1: Vector, P2: Vector, P3: Vector) => number;
