import { $ as UserSearchParams, A as BooleanNumber, B as ParamsBase, C as SearchResultFields, D as UserSearchResultFields, E as UserSearchResult, F as GenreNotation, G as RankingHistoryParams, H as R18Fields, I as GzipLevel, J as SearchParams, K as RankingParams, L as NovelTypeParam, M as DateParam, N as Fields, O as BigGenre, P as Genre, Q as UserOrder, R as OptionalFields, S as PickedNarouSearchResult, T as SearchResultR18Fields, U as R18Site, V as ParamsBaseWithOrder, W as R18SiteNotation, X as StopParam, Y as SearchResultFieldNames, Z as UserFields, _ as SearchBuilderBase, a as NarouNovelJsonp, b as NarouSearchResults, c as NarouParams, d as formatRankingHistory, f as NarouRankingResult, g as SearchBuilder, h as NovelSearchBuilderBase, i as SearchBuilderR18, j as BuntaiParam, k as BigGenreNotation, l as RankingHistoryRawResult, m as DefaultSearchResultFields, n as RankingBuilder, o as ExecuteOptions, p as RankingResult, q as RankingType, r as DefaultR18SearchResultFields, s as NarouNovel, t as UserSearchBuilder, u as RankingHistoryResult, v as End, w as SearchResultOptionalFields, x as NovelType, y as NarouSearchResult, z as Order } from "./user-search-BY6FdEe7.cjs";

//#region src/index.browser.d.ts

/**
 * なろう小説 API で小説を検索する
 * @param {string} [word] 検索ワード
 * @returns {SearchBuilder}
 * @see https://dev.syosetu.com/man/api/
 */
declare function search(word?: string, api?: NarouNovel): SearchBuilder;
/**
 * 18禁小説 API で小説を検索する
 * @param {string} [word] 検索ワード
 * @returns {SearchBuilder}
 * @see https://dev.syosetu.com/xman/api/
 */
declare function searchR18(word?: string, api?: NarouNovel): SearchBuilderR18;
/**
 * なろうユーザ検索 API でユーザを検索する
 * @param {string} [word] - 検索ワード
 * @returns {UserSearchBuilder}
 * @see https://dev.syosetu.com/man/userapi/
 */
declare function searchUser(word?: string, api?: NarouNovel): UserSearchBuilder<keyof UserSearchResult>;
/**
 * なろう小説ランキング API でランキングを取得する
 * @returns {RankingBuilder}
 * @see https://dev.syosetu.com/man/rankapi/
 */
declare function ranking(api?: NarouNovel): RankingBuilder;
/**
 * なろう殿堂入り API でランキング履歴を取得する
 * @param {string} ncode 小説のNコード
 * @param {ExecuteOptions} [options] 実行オプション
 * @param {NarouNovel} [api] API実行クラスのインスタンス
 * @see https://dev.syosetu.com/man/rankinapi/
 */
declare function rankingHistory(ncode: string, options?: ExecuteOptions, api?: NarouNovel): Promise<RankingHistoryResult[]>;
declare const _default: {
  search: typeof search;
  searchR18: typeof searchR18;
  searchUser: typeof searchUser;
  ranking: typeof ranking;
  rankingHistory: typeof rankingHistory;
};
//#endregion
export { BigGenre, BigGenreNotation, BooleanNumber, BuntaiParam, DateParam, DefaultR18SearchResultFields, DefaultSearchResultFields, End, Fields, Genre, GenreNotation, GzipLevel, NarouNovel, NarouNovelJsonp, NarouParams, NarouRankingResult, NarouSearchResult, NarouSearchResults, NovelSearchBuilderBase, NovelType, NovelTypeParam, OptionalFields, Order, ParamsBase, ParamsBaseWithOrder, PickedNarouSearchResult, R18Fields, R18Site, R18SiteNotation, RankingBuilder, RankingHistoryParams, RankingHistoryRawResult, RankingHistoryResult, RankingParams, RankingResult, RankingType, SearchBuilder, SearchBuilderBase, SearchBuilderR18, SearchParams, SearchResultFieldNames, SearchResultFields, SearchResultOptionalFields, SearchResultR18Fields, StopParam, UserFields, UserOrder, UserSearchParams, UserSearchResult, UserSearchResultFields, _default as default, formatRankingHistory, ranking, rankingHistory, search, searchR18, searchUser };
//# sourceMappingURL=index.browser.d.cts.map