import { n as runCli } from "./bindings-DSU8hw_s.js";
import { r as resolvePlugins } from "./prettier-gzzUBJre.js";
import Tinypool from "tinypool";

//#region src-js/cli/worker-proxy.ts
let pool = null;
async function initExternalFormatter(numThreads) {
	pool = new Tinypool({
		filename: new URL("./cli-worker.js", import.meta.url).href,
		minThreads: numThreads,
		maxThreads: numThreads
	});
	return resolvePlugins();
}
async function disposeExternalFormatter() {
	await pool?.destroy();
	pool = null;
}
async function formatEmbeddedCode(options, parserName, code) {
	return pool.run({
		options,
		code,
		parserName
	}, { name: "formatEmbeddedCode" });
}
async function formatFile(options, parserName, fileName, code) {
	return pool.run({
		options,
		code,
		fileName,
		parserName
	}, { name: "formatFile" });
}
async function sortTailwindClasses(filepath, options, classes) {
	return pool.run({
		filepath,
		options,
		classes
	}, { name: "sortTailwindClasses" });
}

//#endregion
//#region src-js/cli.ts
(async () => {
	const args = process.argv.slice(2);
	if (!process.stdout.isTTY) process.stdout._handle?.setBlocking?.(true);
	const [mode, exitCode] = await runCli(args, initExternalFormatter, formatEmbeddedCode, formatFile, sortTailwindClasses);
	if (mode === "init") {
		await import("./init-BlnymtNS.js").then((m) => m.runInit());
		return;
	}
	if (mode === "migrate:prettier") {
		await import("./migrate-prettier-D2MK0fzz.js").then((m) => m.runMigratePrettier());
		return;
	}
	if (mode === "migrate:biome") {
		await import("./migrate-biome-B4fq26fI.js").then((m) => m.runMigrateBiome());
		return;
	}
	await disposeExternalFormatter();
	process.exitCode = exitCode;
})();

//#endregion
export {  };