import { YTNode } from '../helpers.js';
import { Parser } from '../index.js';
import BackstagePost from './BackstagePost.js';
import Button from './Button.js';
import Menu from './menus/Menu.js';
import Author from './misc/Author.js';
import Text from './misc/Text.js';
import Thumbnail from './misc/Thumbnail.js';
import NavigationEndpoint from './NavigationEndpoint.js';
import Post from './Post.js';
export default class SharedPost extends YTNode {
    static type = 'SharedPost';
    thumbnail;
    content;
    published;
    menu;
    original_post;
    id;
    endpoint;
    expand_button;
    author;
    constructor(data) {
        super();
        this.thumbnail = Thumbnail.fromResponse(data.thumbnail);
        this.content = new Text(data.content);
        this.published = new Text(data.publishedTimeText);
        this.menu = Parser.parseItem(data.actionMenu, Menu);
        this.original_post = Parser.parseItem(data.originalPost, [BackstagePost, Post]);
        this.id = data.postId;
        this.endpoint = new NavigationEndpoint(data.navigationEndpoint);
        this.expand_button = Parser.parseItem(data.expandButton, Button);
        this.author = new Author(data.displayName, undefined);
    }
}
//# sourceMappingURL=SharedPost.js.map