PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE "django_migrations" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "applied" datetime NOT NULL);
INSERT INTO "django_migrations" VALUES(1,'abuse_reports','0001_initial','2019-11-25 16:21:35.293413');
INSERT INTO "django_migrations" VALUES(2,'admin_log','0001_initial','2019-11-25 16:21:35.312631');
INSERT INTO "django_migrations" VALUES(3,'api2','0001_initial','2019-11-25 16:21:35.341077');
INSERT INTO "django_migrations" VALUES(4,'contenttypes','0001_initial','2019-11-25 16:21:35.359758');
INSERT INTO "django_migrations" VALUES(5,'contenttypes','0002_remove_content_type_name','2019-11-25 16:21:35.395489');
INSERT INTO "django_migrations" VALUES(6,'auth','0001_initial','2019-11-25 16:21:35.432592');
INSERT INTO "django_migrations" VALUES(7,'auth','0002_alter_permission_name_max_length','2019-11-25 16:21:35.462738');
INSERT INTO "django_migrations" VALUES(8,'auth','0003_alter_user_email_max_length','2019-11-25 16:21:35.490602');
INSERT INTO "django_migrations" VALUES(9,'auth','0004_alter_user_username_opts','2019-11-25 16:21:35.518703');
INSERT INTO "django_migrations" VALUES(10,'auth','0005_alter_user_last_login_null','2019-11-25 16:21:35.546732');
INSERT INTO "django_migrations" VALUES(11,'auth','0006_require_contenttypes_0002','2019-11-25 16:21:35.555073');
INSERT INTO "django_migrations" VALUES(12,'auth','0007_alter_validators_add_error_messages','2019-11-25 16:21:35.583401');
INSERT INTO "django_migrations" VALUES(13,'auth','0008_alter_user_username_max_length','2019-11-25 16:21:35.612254');
INSERT INTO "django_migrations" VALUES(14,'avatar','0001_initial','2019-11-25 16:21:35.635016');
INSERT INTO "django_migrations" VALUES(15,'tags','0001_initial','2019-11-25 16:21:35.678978');
INSERT INTO "django_migrations" VALUES(16,'group','0001_initial','2019-11-25 16:21:35.721308');
INSERT INTO "django_migrations" VALUES(17,'base','0001_initial','2019-11-25 16:21:35.788360');
INSERT INTO "django_migrations" VALUES(18,'base','0002_reposecretkey','2019-11-25 16:21:35.812950');
INSERT INTO "django_migrations" VALUES(19,'base','0003_auto_20181016_1242','2019-11-25 16:21:35.848957');
INSERT INTO "django_migrations" VALUES(20,'base','0004_auto_20191125_1555','2019-11-25 16:21:35.920103');
INSERT INTO "django_migrations" VALUES(21,'captcha','0001_initial','2019-11-25 16:21:35.946372');
INSERT INTO "django_migrations" VALUES(22,'contacts','0001_initial','2019-11-25 16:21:35.966308');
INSERT INTO "django_migrations" VALUES(23,'contacts','0002_auto_20191125_1555','2019-11-25 16:21:36.003873');
INSERT INTO "django_migrations" VALUES(24,'database','0001_initial','2019-11-25 16:21:36.031012');
INSERT INTO "django_migrations" VALUES(25,'database','0002_auto_20190129_2304','2019-11-25 16:21:36.065175');
INSERT INTO "django_migrations" VALUES(26,'django_cas_ng','0001_initial','2019-11-25 16:21:36.106021');
INSERT INTO "django_migrations" VALUES(27,'django_cas_ng','0002_auto_20180410_0948','2019-11-25 16:21:36.135078');
INSERT INTO "django_migrations" VALUES(28,'drafts','0001_initial','2019-11-25 16:21:36.195356');
INSERT INTO "django_migrations" VALUES(29,'drafts','0002_draftreview_author','2019-11-25 16:21:36.229914');
INSERT INTO "django_migrations" VALUES(30,'drafts','0003_auto_20190301_0648','2019-11-25 16:21:36.351146');
INSERT INTO "django_migrations" VALUES(31,'drafts','0004_auto_20190610_0628','2019-11-25 16:21:36.385966');
INSERT INTO "django_migrations" VALUES(32,'file_participants','0001_initial','2019-11-25 16:21:36.415758');
INSERT INTO "django_migrations" VALUES(33,'repo_tags','0001_initial','2019-11-25 16:21:36.445691');
INSERT INTO "django_migrations" VALUES(34,'file_tags','0001_initial','2019-11-25 16:21:36.469924');
INSERT INTO "django_migrations" VALUES(35,'file_tags','0002_remove_filetags_parent_folder_uuid','2019-11-25 16:21:36.505688');
INSERT INTO "django_migrations" VALUES(36,'group','0002_auto_20191125_1555','2019-11-25 16:21:36.561051');
INSERT INTO "django_migrations" VALUES(37,'institutions','0001_initial','2019-11-25 16:21:36.592129');
INSERT INTO "django_migrations" VALUES(38,'institutions','0002_institutionquota','2019-11-25 16:21:36.640985');
INSERT INTO "django_migrations" VALUES(39,'institutions','0003_auto_20180426_0710','2019-11-25 16:21:36.671612');
INSERT INTO "django_migrations" VALUES(40,'invitations','0001_initial','2019-11-25 16:21:36.700393');
INSERT INTO "django_migrations" VALUES(41,'invitations','0002_invitation_invite_type','2019-11-25 16:21:36.727512');
INSERT INTO "django_migrations" VALUES(42,'invitations','0003_auto_20160510_1703','2019-11-25 16:21:36.765895');
INSERT INTO "django_migrations" VALUES(43,'invitations','0004_auto_20160629_1610','2019-11-25 16:21:36.804716');
INSERT INTO "django_migrations" VALUES(44,'invitations','0005_auto_20160629_1614','2019-11-25 16:21:36.835445');
INSERT INTO "django_migrations" VALUES(45,'invitations','0006_reposhareinvitation','2019-11-25 16:21:36.865459');
INSERT INTO "django_migrations" VALUES(46,'notifications','0001_initial','2019-11-25 16:21:36.925638');
INSERT INTO "django_migrations" VALUES(47,'notifications','0002_auto_20180426_0710','2019-11-25 16:21:36.954535');
INSERT INTO "django_migrations" VALUES(48,'notifications','0003_auto_20181115_0825','2019-11-25 16:21:36.981832');
INSERT INTO "django_migrations" VALUES(49,'notifications','0004_auto_20191125_1555','2019-11-25 16:21:37.013168');
INSERT INTO "django_migrations" VALUES(50,'options','0001_initial','2019-11-25 16:21:37.037142');
INSERT INTO "django_migrations" VALUES(51,'options','0002_auto_20181107_0811','2019-11-25 16:21:37.069887');
INSERT INTO "django_migrations" VALUES(52,'organizations','0001_initial','2019-11-25 16:21:37.093309');
INSERT INTO "django_migrations" VALUES(53,'organizations','0002_orgsettings','2019-11-25 16:21:37.118730');
INSERT INTO "django_migrations" VALUES(54,'organizations','0003_auto_20190116_0323','2019-11-25 16:21:37.143778');
INSERT INTO "django_migrations" VALUES(55,'post_office','0001_initial','2019-11-25 16:21:37.208064');
INSERT INTO "django_migrations" VALUES(56,'post_office','0002_add_i18n_and_backend_alias','2019-11-25 16:21:37.340897');
INSERT INTO "django_migrations" VALUES(57,'post_office','0003_longer_subject','2019-11-25 16:21:37.385248');
INSERT INTO "django_migrations" VALUES(58,'post_office','0004_auto_20160607_0901','2019-11-25 16:21:37.594776');
INSERT INTO "django_migrations" VALUES(59,'post_office','0005_auto_20170515_0013','2019-11-25 16:21:37.616807');
INSERT INTO "django_migrations" VALUES(60,'post_office','0006_attachment_mimetype','2019-11-25 16:21:37.644538');
INSERT INTO "django_migrations" VALUES(61,'post_office','0007_auto_20170731_1342','2019-11-25 16:21:37.662796');
INSERT INTO "django_migrations" VALUES(62,'post_office','0008_attachment_headers','2019-11-25 16:21:37.689382');
INSERT INTO "django_migrations" VALUES(63,'profile','0001_initial','2019-11-25 16:21:37.723205');
INSERT INTO "django_migrations" VALUES(64,'profile','0002_auto_20190122_0225','2019-11-25 16:21:37.768288');
INSERT INTO "django_migrations" VALUES(65,'profile','0003_auto_20191125_1555','2019-11-25 16:21:37.814712');
INSERT INTO "django_migrations" VALUES(66,'registration','0001_initial','2019-11-25 16:21:37.836549');
INSERT INTO "django_migrations" VALUES(67,'related_files','0001_initial','2019-11-25 16:21:37.861804');
INSERT INTO "django_migrations" VALUES(68,'repo_api_tokens','0001_initial','2019-11-25 16:21:37.886830');
INSERT INTO "django_migrations" VALUES(69,'revision_tag','0001_initial','2019-11-25 16:21:37.936111');
INSERT INTO "django_migrations" VALUES(70,'revision_tag','0002_auto_20191125_1555','2019-11-25 16:21:37.962772');
INSERT INTO "django_migrations" VALUES(71,'role_permissions','0001_initial','2019-11-25 16:21:38.026384');
INSERT INTO "django_migrations" VALUES(72,'sessions','0001_initial','2019-11-25 16:21:38.050411');
INSERT INTO "django_migrations" VALUES(73,'share','0001_initial','2019-11-25 16:21:38.113101');
INSERT INTO "django_migrations" VALUES(74,'share','0002_auto_20191125_1555','2019-11-25 16:21:38.168031');
INSERT INTO "django_migrations" VALUES(75,'sysadmin_extra','0001_initial','2019-11-25 16:21:38.201072');
INSERT INTO "django_migrations" VALUES(76,'termsandconditions','0001_initial','2019-11-25 16:21:38.250371');
INSERT INTO "django_migrations" VALUES(77,'termsandconditions','0002_auto_20191125_1555','2019-11-25 16:21:38.316701');
INSERT INTO "django_migrations" VALUES(78,'trusted_ip','0001_initial','2019-11-25 16:21:38.337839');
INSERT INTO "django_migrations" VALUES(79,'two_factor','0001_initial','2019-11-25 16:21:38.382530');
INSERT INTO "django_migrations" VALUES(80,'wiki','0001_initial','2019-11-25 16:21:38.416438');
INSERT INTO "django_migrations" VALUES(81,'wiki','0002_auto_20180326_0548','2019-11-25 16:21:38.446838');
INSERT INTO "django_migrations" VALUES(82,'wiki','0003_auto_20180428_0619','2019-11-25 16:21:38.487146');
INSERT INTO "django_migrations" VALUES(83,'wiki','0004_auto_20191125_1555','2019-11-25 16:21:38.520346');
CREATE TABLE "admin_log_adminlog" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(254) NOT NULL, "operation" varchar(255) NOT NULL, "detail" text NOT NULL, "datetime" datetime NOT NULL);
CREATE TABLE "api2_token" ("key" varchar(40) NOT NULL PRIMARY KEY, "user" varchar(255) NOT NULL UNIQUE, "created" datetime NOT NULL);
CREATE TABLE "api2_tokenv2" ("key" varchar(40) NOT NULL PRIMARY KEY, "user" varchar(255) NOT NULL, "platform" varchar(32) NOT NULL, "device_id" varchar(40) NOT NULL, "device_name" varchar(40) NOT NULL, "platform_version" varchar(16) NOT NULL, "client_version" varchar(16) NOT NULL, "last_accessed" datetime NOT NULL, "last_login_ip" char(39) NULL, "created_at" datetime NOT NULL, "wiped_at" datetime NULL);
CREATE TABLE "abuse_reports_abusereport" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "reporter" text NULL, "repo_id" varchar(36) NOT NULL, "repo_name" varchar(255) NOT NULL, "file_path" text NULL, "abuse_type" varchar(255) NOT NULL, "description" text NULL, "handled" bool NOT NULL, "time" datetime NOT NULL);
CREATE TABLE "django_content_type" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app_label" varchar(100) NOT NULL, "model" varchar(100) NOT NULL);
INSERT INTO "django_content_type" VALUES(1,'contenttypes','contenttype');
INSERT INTO "django_content_type" VALUES(2,'constance','config');
INSERT INTO "django_content_type" VALUES(3,'sessions','session');
INSERT INTO "django_content_type" VALUES(4,'base','clientlogintoken');
INSERT INTO "django_content_type" VALUES(5,'base','commandslastcheck');
INSERT INTO "django_content_type" VALUES(6,'base','devicetoken');
INSERT INTO "django_content_type" VALUES(7,'base','filecomment');
INSERT INTO "django_content_type" VALUES(8,'base','userlastlogin');
INSERT INTO "django_content_type" VALUES(9,'base','userstarredfiles');
INSERT INTO "django_content_type" VALUES(10,'base','reposecretkey');
INSERT INTO "django_content_type" VALUES(11,'base','socialauthuser');
INSERT INTO "django_content_type" VALUES(12,'auth','permission');
INSERT INTO "django_content_type" VALUES(13,'auth','group');
INSERT INTO "django_content_type" VALUES(14,'auth','user');
INSERT INTO "django_content_type" VALUES(15,'registration','registrationprofile');
INSERT INTO "django_content_type" VALUES(16,'captcha','captchastore');
INSERT INTO "django_content_type" VALUES(17,'database','constance');
INSERT INTO "django_content_type" VALUES(18,'post_office','attachment');
INSERT INTO "django_content_type" VALUES(19,'post_office','email');
INSERT INTO "django_content_type" VALUES(20,'post_office','emailtemplate');
INSERT INTO "django_content_type" VALUES(21,'post_office','log');
INSERT INTO "django_content_type" VALUES(22,'termsandconditions','termsandconditions');
INSERT INTO "django_content_type" VALUES(23,'termsandconditions','usertermsandconditions');
INSERT INTO "django_content_type" VALUES(24,'api2','token');
INSERT INTO "django_content_type" VALUES(25,'api2','tokenv2');
INSERT INTO "django_content_type" VALUES(26,'avatar','avatar');
INSERT INTO "django_content_type" VALUES(27,'avatar','groupavatar');
INSERT INTO "django_content_type" VALUES(28,'contacts','contact');
INSERT INTO "django_content_type" VALUES(29,'drafts','draft');
INSERT INTO "django_content_type" VALUES(30,'drafts','draftreviewer');
INSERT INTO "django_content_type" VALUES(31,'institutions','institution');
INSERT INTO "django_content_type" VALUES(32,'institutions','institutionadmin');
INSERT INTO "django_content_type" VALUES(33,'institutions','institutionquota');
INSERT INTO "django_content_type" VALUES(34,'invitations','invitation');
INSERT INTO "django_content_type" VALUES(35,'invitations','reposhareinvitation');
INSERT INTO "django_content_type" VALUES(36,'wiki','wiki');
INSERT INTO "django_content_type" VALUES(37,'notifications','notification');
INSERT INTO "django_content_type" VALUES(38,'notifications','usernotification');
INSERT INTO "django_content_type" VALUES(39,'options','useroptions');
INSERT INTO "django_content_type" VALUES(40,'profile','detailedprofile');
INSERT INTO "django_content_type" VALUES(41,'profile','profile');
INSERT INTO "django_content_type" VALUES(42,'share','anonymousshare');
INSERT INTO "django_content_type" VALUES(43,'share','extragroupssharepermission');
INSERT INTO "django_content_type" VALUES(44,'share','extrasharepermission');
INSERT INTO "django_content_type" VALUES(45,'share','fileshare');
INSERT INTO "django_content_type" VALUES(46,'share','orgfileshare');
INSERT INTO "django_content_type" VALUES(47,'share','privatefiledirshare');
INSERT INTO "django_content_type" VALUES(48,'share','uploadlinkshare');
INSERT INTO "django_content_type" VALUES(49,'admin_log','adminlog');
INSERT INTO "django_content_type" VALUES(50,'tags','filetag');
INSERT INTO "django_content_type" VALUES(51,'tags','fileuuidmap');
INSERT INTO "django_content_type" VALUES(52,'tags','tags');
INSERT INTO "django_content_type" VALUES(53,'revision_tag','revisiontags');
INSERT INTO "django_content_type" VALUES(54,'revision_tag','tags');
INSERT INTO "django_content_type" VALUES(55,'two_factor','phonedevice');
INSERT INTO "django_content_type" VALUES(56,'two_factor','staticdevice');
INSERT INTO "django_content_type" VALUES(57,'two_factor','statictoken');
INSERT INTO "django_content_type" VALUES(58,'two_factor','totpdevice');
INSERT INTO "django_content_type" VALUES(59,'role_permissions','adminrole');
INSERT INTO "django_content_type" VALUES(60,'trusted_ip','trustedip');
INSERT INTO "django_content_type" VALUES(61,'repo_tags','repotags');
INSERT INTO "django_content_type" VALUES(62,'file_tags','filetags');
INSERT INTO "django_content_type" VALUES(63,'related_files','relatedfiles');
INSERT INTO "django_content_type" VALUES(64,'file_participants','fileparticipant');
INSERT INTO "django_content_type" VALUES(65,'repo_api_tokens','repoapitokens');
INSERT INTO "django_content_type" VALUES(66,'abuse_reports','abusereport');
INSERT INTO "django_content_type" VALUES(67,'sysadmin_extra','userloginlog');
INSERT INTO "django_content_type" VALUES(68,'organizations','orgmemberquota');
INSERT INTO "django_content_type" VALUES(69,'organizations','orgsettings');
INSERT INTO "django_content_type" VALUES(70,'django_cas_ng','proxygrantingticket');
INSERT INTO "django_content_type" VALUES(71,'django_cas_ng','sessionticket');
INSERT INTO "django_content_type" VALUES(72,'plan','userplan');
INSERT INTO "django_content_type" VALUES(73,'plan','orgplan');
CREATE TABLE "auth_group" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(80) NOT NULL UNIQUE);
CREATE TABLE "auth_group_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL REFERENCES "auth_group" ("id"), "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id"));
CREATE TABLE "auth_user_groups" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id"), "group_id" integer NOT NULL REFERENCES "auth_group" ("id"));
CREATE TABLE "auth_user_user_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id"), "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id"));
CREATE TABLE "auth_permission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "content_type_id" integer NOT NULL REFERENCES "django_content_type" ("id"), "codename" varchar(100) NOT NULL, "name" varchar(255) NOT NULL);
INSERT INTO "auth_permission" VALUES(1,1,'add_contenttype','Can add content type');
INSERT INTO "auth_permission" VALUES(2,1,'change_contenttype','Can change content type');
INSERT INTO "auth_permission" VALUES(3,1,'delete_contenttype','Can delete content type');
INSERT INTO "auth_permission" VALUES(4,2,'change_config','Can change config');
INSERT INTO "auth_permission" VALUES(5,3,'add_session','Can add session');
INSERT INTO "auth_permission" VALUES(6,3,'change_session','Can change session');
INSERT INTO "auth_permission" VALUES(7,3,'delete_session','Can delete session');
INSERT INTO "auth_permission" VALUES(8,4,'add_clientlogintoken','Can add client login token');
INSERT INTO "auth_permission" VALUES(9,4,'change_clientlogintoken','Can change client login token');
INSERT INTO "auth_permission" VALUES(10,4,'delete_clientlogintoken','Can delete client login token');
INSERT INTO "auth_permission" VALUES(11,5,'add_commandslastcheck','Can add commands last check');
INSERT INTO "auth_permission" VALUES(12,5,'change_commandslastcheck','Can change commands last check');
INSERT INTO "auth_permission" VALUES(13,5,'delete_commandslastcheck','Can delete commands last check');
INSERT INTO "auth_permission" VALUES(14,6,'add_devicetoken','Can add device token');
INSERT INTO "auth_permission" VALUES(15,6,'change_devicetoken','Can change device token');
INSERT INTO "auth_permission" VALUES(16,6,'delete_devicetoken','Can delete device token');
INSERT INTO "auth_permission" VALUES(17,7,'add_filecomment','Can add file comment');
INSERT INTO "auth_permission" VALUES(18,7,'change_filecomment','Can change file comment');
INSERT INTO "auth_permission" VALUES(19,7,'delete_filecomment','Can delete file comment');
INSERT INTO "auth_permission" VALUES(20,8,'add_userlastlogin','Can add user last login');
INSERT INTO "auth_permission" VALUES(21,8,'change_userlastlogin','Can change user last login');
INSERT INTO "auth_permission" VALUES(22,8,'delete_userlastlogin','Can delete user last login');
INSERT INTO "auth_permission" VALUES(23,9,'add_userstarredfiles','Can add user starred files');
INSERT INTO "auth_permission" VALUES(24,9,'change_userstarredfiles','Can change user starred files');
INSERT INTO "auth_permission" VALUES(25,9,'delete_userstarredfiles','Can delete user starred files');
INSERT INTO "auth_permission" VALUES(26,10,'add_reposecretkey','Can add repo secret key');
INSERT INTO "auth_permission" VALUES(27,10,'change_reposecretkey','Can change repo secret key');
INSERT INTO "auth_permission" VALUES(28,10,'delete_reposecretkey','Can delete repo secret key');
INSERT INTO "auth_permission" VALUES(29,11,'add_socialauthuser','Can add social auth user');
INSERT INTO "auth_permission" VALUES(30,11,'change_socialauthuser','Can change social auth user');
INSERT INTO "auth_permission" VALUES(31,11,'delete_socialauthuser','Can delete social auth user');
INSERT INTO "auth_permission" VALUES(32,12,'add_permission','Can add permission');
INSERT INTO "auth_permission" VALUES(33,12,'change_permission','Can change permission');
INSERT INTO "auth_permission" VALUES(34,12,'delete_permission','Can delete permission');
INSERT INTO "auth_permission" VALUES(35,13,'add_group','Can add group');
INSERT INTO "auth_permission" VALUES(36,13,'change_group','Can change group');
INSERT INTO "auth_permission" VALUES(37,13,'delete_group','Can delete group');
INSERT INTO "auth_permission" VALUES(38,14,'add_user','Can add user');
INSERT INTO "auth_permission" VALUES(39,14,'change_user','Can change user');
INSERT INTO "auth_permission" VALUES(40,14,'delete_user','Can delete user');
INSERT INTO "auth_permission" VALUES(41,15,'add_registrationprofile','Can add registration profile');
INSERT INTO "auth_permission" VALUES(42,15,'change_registrationprofile','Can change registration profile');
INSERT INTO "auth_permission" VALUES(43,15,'delete_registrationprofile','Can delete registration profile');
INSERT INTO "auth_permission" VALUES(44,16,'add_captchastore','Can add captcha store');
INSERT INTO "auth_permission" VALUES(45,16,'change_captchastore','Can change captcha store');
INSERT INTO "auth_permission" VALUES(46,16,'delete_captchastore','Can delete captcha store');
INSERT INTO "auth_permission" VALUES(47,17,'add_constance','Can add constance');
INSERT INTO "auth_permission" VALUES(48,17,'change_constance','Can change constance');
INSERT INTO "auth_permission" VALUES(49,17,'delete_constance','Can delete constance');
INSERT INTO "auth_permission" VALUES(50,18,'add_attachment','Can add Attachment');
INSERT INTO "auth_permission" VALUES(51,18,'change_attachment','Can change Attachment');
INSERT INTO "auth_permission" VALUES(52,18,'delete_attachment','Can delete Attachment');
INSERT INTO "auth_permission" VALUES(53,19,'add_email','Can add Email');
INSERT INTO "auth_permission" VALUES(54,19,'change_email','Can change Email');
INSERT INTO "auth_permission" VALUES(55,19,'delete_email','Can delete Email');
INSERT INTO "auth_permission" VALUES(56,20,'add_emailtemplate','Can add Email Template');
INSERT INTO "auth_permission" VALUES(57,20,'change_emailtemplate','Can change Email Template');
INSERT INTO "auth_permission" VALUES(58,20,'delete_emailtemplate','Can delete Email Template');
INSERT INTO "auth_permission" VALUES(59,21,'add_log','Can add Log');
INSERT INTO "auth_permission" VALUES(60,21,'change_log','Can change Log');
INSERT INTO "auth_permission" VALUES(61,21,'delete_log','Can delete Log');
INSERT INTO "auth_permission" VALUES(62,22,'add_termsandconditions','Can add Terms and Conditions');
INSERT INTO "auth_permission" VALUES(63,22,'change_termsandconditions','Can change Terms and Conditions');
INSERT INTO "auth_permission" VALUES(64,22,'delete_termsandconditions','Can delete Terms and Conditions');
INSERT INTO "auth_permission" VALUES(65,23,'add_usertermsandconditions','Can add User Terms and Conditions');
INSERT INTO "auth_permission" VALUES(66,23,'change_usertermsandconditions','Can change User Terms and Conditions');
INSERT INTO "auth_permission" VALUES(67,23,'delete_usertermsandconditions','Can delete User Terms and Conditions');
INSERT INTO "auth_permission" VALUES(68,24,'add_token','Can add token');
INSERT INTO "auth_permission" VALUES(69,24,'change_token','Can change token');
INSERT INTO "auth_permission" VALUES(70,24,'delete_token','Can delete token');
INSERT INTO "auth_permission" VALUES(71,25,'add_tokenv2','Can add token v2');
INSERT INTO "auth_permission" VALUES(72,25,'change_tokenv2','Can change token v2');
INSERT INTO "auth_permission" VALUES(73,25,'delete_tokenv2','Can delete token v2');
INSERT INTO "auth_permission" VALUES(74,26,'add_avatar','Can add avatar');
INSERT INTO "auth_permission" VALUES(75,26,'change_avatar','Can change avatar');
INSERT INTO "auth_permission" VALUES(76,26,'delete_avatar','Can delete avatar');
INSERT INTO "auth_permission" VALUES(77,27,'add_groupavatar','Can add group avatar');
INSERT INTO "auth_permission" VALUES(78,27,'change_groupavatar','Can change group avatar');
INSERT INTO "auth_permission" VALUES(79,27,'delete_groupavatar','Can delete group avatar');
INSERT INTO "auth_permission" VALUES(80,28,'add_contact','Can add contact');
INSERT INTO "auth_permission" VALUES(81,28,'change_contact','Can change contact');
INSERT INTO "auth_permission" VALUES(82,28,'delete_contact','Can delete contact');
INSERT INTO "auth_permission" VALUES(83,29,'add_draft','Can add draft');
INSERT INTO "auth_permission" VALUES(84,29,'change_draft','Can change draft');
INSERT INTO "auth_permission" VALUES(85,29,'delete_draft','Can delete draft');
INSERT INTO "auth_permission" VALUES(86,30,'add_draftreviewer','Can add draft reviewer');
INSERT INTO "auth_permission" VALUES(87,30,'change_draftreviewer','Can change draft reviewer');
INSERT INTO "auth_permission" VALUES(88,30,'delete_draftreviewer','Can delete draft reviewer');
INSERT INTO "auth_permission" VALUES(89,31,'add_institution','Can add institution');
INSERT INTO "auth_permission" VALUES(90,31,'change_institution','Can change institution');
INSERT INTO "auth_permission" VALUES(91,31,'delete_institution','Can delete institution');
INSERT INTO "auth_permission" VALUES(92,32,'add_institutionadmin','Can add institution admin');
INSERT INTO "auth_permission" VALUES(93,32,'change_institutionadmin','Can change institution admin');
INSERT INTO "auth_permission" VALUES(94,32,'delete_institutionadmin','Can delete institution admin');
INSERT INTO "auth_permission" VALUES(95,33,'add_institutionquota','Can add institution quota');
INSERT INTO "auth_permission" VALUES(96,33,'change_institutionquota','Can change institution quota');
INSERT INTO "auth_permission" VALUES(97,33,'delete_institutionquota','Can delete institution quota');
INSERT INTO "auth_permission" VALUES(98,34,'add_invitation','Can add invitation');
INSERT INTO "auth_permission" VALUES(99,34,'change_invitation','Can change invitation');
INSERT INTO "auth_permission" VALUES(100,34,'delete_invitation','Can delete invitation');
INSERT INTO "auth_permission" VALUES(101,35,'add_reposhareinvitation','Can add repo share invitation');
INSERT INTO "auth_permission" VALUES(102,35,'change_reposhareinvitation','Can change repo share invitation');
INSERT INTO "auth_permission" VALUES(103,35,'delete_reposhareinvitation','Can delete repo share invitation');
INSERT INTO "auth_permission" VALUES(104,36,'add_wiki','Can add wiki');
INSERT INTO "auth_permission" VALUES(105,36,'change_wiki','Can change wiki');
INSERT INTO "auth_permission" VALUES(106,36,'delete_wiki','Can delete wiki');
INSERT INTO "auth_permission" VALUES(107,37,'add_notification','Can add notification');
INSERT INTO "auth_permission" VALUES(108,37,'change_notification','Can change notification');
INSERT INTO "auth_permission" VALUES(109,37,'delete_notification','Can delete notification');
INSERT INTO "auth_permission" VALUES(110,38,'add_usernotification','Can add user notification');
INSERT INTO "auth_permission" VALUES(111,38,'change_usernotification','Can change user notification');
INSERT INTO "auth_permission" VALUES(112,38,'delete_usernotification','Can delete user notification');
INSERT INTO "auth_permission" VALUES(113,39,'add_useroptions','Can add user options');
INSERT INTO "auth_permission" VALUES(114,39,'change_useroptions','Can change user options');
INSERT INTO "auth_permission" VALUES(115,39,'delete_useroptions','Can delete user options');
INSERT INTO "auth_permission" VALUES(116,40,'add_detailedprofile','Can add detailed profile');
INSERT INTO "auth_permission" VALUES(117,40,'change_detailedprofile','Can change detailed profile');
INSERT INTO "auth_permission" VALUES(118,40,'delete_detailedprofile','Can delete detailed profile');
INSERT INTO "auth_permission" VALUES(119,41,'add_profile','Can add profile');
INSERT INTO "auth_permission" VALUES(120,41,'change_profile','Can change profile');
INSERT INTO "auth_permission" VALUES(121,41,'delete_profile','Can delete profile');
INSERT INTO "auth_permission" VALUES(122,42,'add_anonymousshare','Can add anonymous share');
INSERT INTO "auth_permission" VALUES(123,42,'change_anonymousshare','Can change anonymous share');
INSERT INTO "auth_permission" VALUES(124,42,'delete_anonymousshare','Can delete anonymous share');
INSERT INTO "auth_permission" VALUES(125,43,'add_extragroupssharepermission','Can add extra groups share permission');
INSERT INTO "auth_permission" VALUES(126,43,'change_extragroupssharepermission','Can change extra groups share permission');
INSERT INTO "auth_permission" VALUES(127,43,'delete_extragroupssharepermission','Can delete extra groups share permission');
INSERT INTO "auth_permission" VALUES(128,44,'add_extrasharepermission','Can add extra share permission');
INSERT INTO "auth_permission" VALUES(129,44,'change_extrasharepermission','Can change extra share permission');
INSERT INTO "auth_permission" VALUES(130,44,'delete_extrasharepermission','Can delete extra share permission');
INSERT INTO "auth_permission" VALUES(131,45,'add_fileshare','Can add file share');
INSERT INTO "auth_permission" VALUES(132,45,'change_fileshare','Can change file share');
INSERT INTO "auth_permission" VALUES(133,45,'delete_fileshare','Can delete file share');
INSERT INTO "auth_permission" VALUES(134,46,'add_orgfileshare','Can add org file share');
INSERT INTO "auth_permission" VALUES(135,46,'change_orgfileshare','Can change org file share');
INSERT INTO "auth_permission" VALUES(136,46,'delete_orgfileshare','Can delete org file share');
INSERT INTO "auth_permission" VALUES(137,47,'add_privatefiledirshare','Can add private file dir share');
INSERT INTO "auth_permission" VALUES(138,47,'change_privatefiledirshare','Can change private file dir share');
INSERT INTO "auth_permission" VALUES(139,47,'delete_privatefiledirshare','Can delete private file dir share');
INSERT INTO "auth_permission" VALUES(140,48,'add_uploadlinkshare','Can add upload link share');
INSERT INTO "auth_permission" VALUES(141,48,'change_uploadlinkshare','Can change upload link share');
INSERT INTO "auth_permission" VALUES(142,48,'delete_uploadlinkshare','Can delete upload link share');
INSERT INTO "auth_permission" VALUES(143,49,'add_adminlog','Can add admin log');
INSERT INTO "auth_permission" VALUES(144,49,'change_adminlog','Can change admin log');
INSERT INTO "auth_permission" VALUES(145,49,'delete_adminlog','Can delete admin log');
INSERT INTO "auth_permission" VALUES(146,50,'add_filetag','Can add file tag');
INSERT INTO "auth_permission" VALUES(147,50,'change_filetag','Can change file tag');
INSERT INTO "auth_permission" VALUES(148,50,'delete_filetag','Can delete file tag');
INSERT INTO "auth_permission" VALUES(149,51,'add_fileuuidmap','Can add file uuid map');
INSERT INTO "auth_permission" VALUES(150,51,'change_fileuuidmap','Can change file uuid map');
INSERT INTO "auth_permission" VALUES(151,51,'delete_fileuuidmap','Can delete file uuid map');
INSERT INTO "auth_permission" VALUES(152,52,'add_tags','Can add tags');
INSERT INTO "auth_permission" VALUES(153,52,'change_tags','Can change tags');
INSERT INTO "auth_permission" VALUES(154,52,'delete_tags','Can delete tags');
INSERT INTO "auth_permission" VALUES(155,53,'add_revisiontags','Can add revision tags');
INSERT INTO "auth_permission" VALUES(156,53,'change_revisiontags','Can change revision tags');
INSERT INTO "auth_permission" VALUES(157,53,'delete_revisiontags','Can delete revision tags');
INSERT INTO "auth_permission" VALUES(158,54,'add_tags','Can add tags');
INSERT INTO "auth_permission" VALUES(159,54,'change_tags','Can change tags');
INSERT INTO "auth_permission" VALUES(160,54,'delete_tags','Can delete tags');
INSERT INTO "auth_permission" VALUES(161,55,'add_phonedevice','Can add phone device');
INSERT INTO "auth_permission" VALUES(162,55,'change_phonedevice','Can change phone device');
INSERT INTO "auth_permission" VALUES(163,55,'delete_phonedevice','Can delete phone device');
INSERT INTO "auth_permission" VALUES(164,56,'add_staticdevice','Can add static device');
INSERT INTO "auth_permission" VALUES(165,56,'change_staticdevice','Can change static device');
INSERT INTO "auth_permission" VALUES(166,56,'delete_staticdevice','Can delete static device');
INSERT INTO "auth_permission" VALUES(167,57,'add_statictoken','Can add static token');
INSERT INTO "auth_permission" VALUES(168,57,'change_statictoken','Can change static token');
INSERT INTO "auth_permission" VALUES(169,57,'delete_statictoken','Can delete static token');
INSERT INTO "auth_permission" VALUES(170,58,'add_totpdevice','Can add TOTP device');
INSERT INTO "auth_permission" VALUES(171,58,'change_totpdevice','Can change TOTP device');
INSERT INTO "auth_permission" VALUES(172,58,'delete_totpdevice','Can delete TOTP device');
INSERT INTO "auth_permission" VALUES(173,59,'add_adminrole','Can add admin role');
INSERT INTO "auth_permission" VALUES(174,59,'change_adminrole','Can change admin role');
INSERT INTO "auth_permission" VALUES(175,59,'delete_adminrole','Can delete admin role');
INSERT INTO "auth_permission" VALUES(176,60,'add_trustedip','Can add trusted ip');
INSERT INTO "auth_permission" VALUES(177,60,'change_trustedip','Can change trusted ip');
INSERT INTO "auth_permission" VALUES(178,60,'delete_trustedip','Can delete trusted ip');
INSERT INTO "auth_permission" VALUES(179,61,'add_repotags','Can add repo tags');
INSERT INTO "auth_permission" VALUES(180,61,'change_repotags','Can change repo tags');
INSERT INTO "auth_permission" VALUES(181,61,'delete_repotags','Can delete repo tags');
INSERT INTO "auth_permission" VALUES(182,62,'add_filetags','Can add file tags');
INSERT INTO "auth_permission" VALUES(183,62,'change_filetags','Can change file tags');
INSERT INTO "auth_permission" VALUES(184,62,'delete_filetags','Can delete file tags');
INSERT INTO "auth_permission" VALUES(185,63,'add_relatedfiles','Can add related files');
INSERT INTO "auth_permission" VALUES(186,63,'change_relatedfiles','Can change related files');
INSERT INTO "auth_permission" VALUES(187,63,'delete_relatedfiles','Can delete related files');
INSERT INTO "auth_permission" VALUES(188,64,'add_fileparticipant','Can add file participant');
INSERT INTO "auth_permission" VALUES(189,64,'change_fileparticipant','Can change file participant');
INSERT INTO "auth_permission" VALUES(190,64,'delete_fileparticipant','Can delete file participant');
INSERT INTO "auth_permission" VALUES(191,65,'add_repoapitokens','Can add repo api tokens');
INSERT INTO "auth_permission" VALUES(192,65,'change_repoapitokens','Can change repo api tokens');
INSERT INTO "auth_permission" VALUES(193,65,'delete_repoapitokens','Can delete repo api tokens');
INSERT INTO "auth_permission" VALUES(194,66,'add_abusereport','Can add abuse report');
INSERT INTO "auth_permission" VALUES(195,66,'change_abusereport','Can change abuse report');
INSERT INTO "auth_permission" VALUES(196,66,'delete_abusereport','Can delete abuse report');
INSERT INTO "auth_permission" VALUES(197,67,'add_userloginlog','Can add user login log');
INSERT INTO "auth_permission" VALUES(198,67,'change_userloginlog','Can change user login log');
INSERT INTO "auth_permission" VALUES(199,67,'delete_userloginlog','Can delete user login log');
INSERT INTO "auth_permission" VALUES(200,68,'add_orgmemberquota','Can add org member quota');
INSERT INTO "auth_permission" VALUES(201,68,'change_orgmemberquota','Can change org member quota');
INSERT INTO "auth_permission" VALUES(202,68,'delete_orgmemberquota','Can delete org member quota');
INSERT INTO "auth_permission" VALUES(203,69,'add_orgsettings','Can add org settings');
INSERT INTO "auth_permission" VALUES(204,69,'change_orgsettings','Can change org settings');
INSERT INTO "auth_permission" VALUES(205,69,'delete_orgsettings','Can delete org settings');
INSERT INTO "auth_permission" VALUES(206,70,'add_proxygrantingticket','Can add proxy granting ticket');
INSERT INTO "auth_permission" VALUES(207,70,'change_proxygrantingticket','Can change proxy granting ticket');
INSERT INTO "auth_permission" VALUES(208,70,'delete_proxygrantingticket','Can delete proxy granting ticket');
INSERT INTO "auth_permission" VALUES(209,71,'add_sessionticket','Can add session ticket');
INSERT INTO "auth_permission" VALUES(210,71,'change_sessionticket','Can change session ticket');
INSERT INTO "auth_permission" VALUES(211,71,'delete_sessionticket','Can delete session ticket');
INSERT INTO "auth_permission" VALUES(212,72,'add_userplan','Can add user plan');
INSERT INTO "auth_permission" VALUES(213,72,'change_userplan','Can change user plan');
INSERT INTO "auth_permission" VALUES(214,72,'delete_userplan','Can delete user plan');
INSERT INTO "auth_permission" VALUES(215,73,'add_orgplan','Can add org plan');
INSERT INTO "auth_permission" VALUES(216,73,'change_orgplan','Can change org plan');
INSERT INTO "auth_permission" VALUES(217,73,'delete_orgplan','Can delete org plan');
CREATE TABLE "auth_user" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "password" varchar(128) NOT NULL, "last_login" datetime NULL, "is_superuser" bool NOT NULL, "first_name" varchar(30) NOT NULL, "last_name" varchar(30) NOT NULL, "email" varchar(254) NOT NULL, "is_staff" bool NOT NULL, "is_active" bool NOT NULL, "date_joined" datetime NOT NULL, "username" varchar(150) NOT NULL UNIQUE);
CREATE TABLE "avatar_avatar" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "emailuser" varchar(255) NOT NULL, "primary" bool NOT NULL, "avatar" varchar(1024) NOT NULL, "date_uploaded" datetime NOT NULL);
CREATE TABLE "avatar_groupavatar" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" varchar(255) NOT NULL, "avatar" varchar(1024) NOT NULL, "date_uploaded" datetime NOT NULL);
CREATE TABLE "tags_fileuuidmap" ("uuid" char(32) NOT NULL PRIMARY KEY, "repo_id" varchar(36) NOT NULL, "repo_id_parent_path_md5" varchar(100) NOT NULL, "parent_path" text NOT NULL, "filename" varchar(1024) NOT NULL, "is_dir" bool NOT NULL);
CREATE TABLE "tags_tags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL UNIQUE);
CREATE TABLE "tags_filetag" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "tag_id" integer NOT NULL REFERENCES "tags_tags" ("id"), "uuid_id" char(32) NOT NULL REFERENCES "tags_fileuuidmap" ("uuid"));
CREATE TABLE "base_clientlogintoken" ("token" varchar(32) NOT NULL PRIMARY KEY, "username" varchar(255) NOT NULL, "timestamp" datetime NOT NULL);
CREATE TABLE "base_commandslastcheck" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "command_type" varchar(100) NOT NULL, "last_check" datetime NOT NULL);
CREATE TABLE "base_devicetoken" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(80) NOT NULL, "user" varchar(255) NOT NULL, "platform" varchar(32) NOT NULL, "version" varchar(16) NOT NULL, "pversion" varchar(16) NOT NULL);
CREATE TABLE "base_userlastlogin" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "last_login" datetime NOT NULL);
CREATE TABLE "base_userstarredfiles" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(254) NOT NULL, "org_id" integer NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "is_dir" bool NOT NULL);
CREATE TABLE "base_reposecretkey" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL UNIQUE, "secret_key" varchar(44) NOT NULL);
CREATE TABLE "base_filecomment" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "author" varchar(255) NOT NULL, "comment" text NOT NULL, "created_at" datetime NOT NULL, "updated_at" datetime NOT NULL, "uuid_id" char(32) NOT NULL REFERENCES "tags_fileuuidmap" ("uuid"), "detail" text NOT NULL, "resolved" bool NOT NULL);
CREATE TABLE "social_auth_usersocialauth" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "provider" varchar(32) NOT NULL, "uid" varchar(255) NOT NULL, "extra_data" text NULL);
CREATE TABLE "captcha_captchastore" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "challenge" varchar(32) NOT NULL, "response" varchar(32) NOT NULL, "hashkey" varchar(40) NOT NULL UNIQUE, "expiration" datetime NOT NULL);
CREATE TABLE "contacts_contact" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_email" varchar(255) NOT NULL, "contact_email" varchar(255) NOT NULL, "contact_name" varchar(255) NULL, "note" varchar(255) NULL);
CREATE TABLE "constance_config" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "constance_key" varchar(255) NOT NULL UNIQUE, "value" text NULL);
CREATE TABLE "django_cas_ng_sessionticket" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "session_key" varchar(255) NOT NULL, "ticket" varchar(255) NOT NULL);
CREATE TABLE "django_cas_ng_proxygrantingticket" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "session_key" varchar(255) NULL, "pgtiou" varchar(255) NULL, "pgt" varchar(255) NULL, "date" datetime NOT NULL, "user" varchar(255) NOT NULL);
CREATE TABLE "drafts_draft" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "created_at" datetime NOT NULL, "updated_at" datetime NOT NULL, "username" varchar(255) NOT NULL, "origin_file_version" varchar(100) NOT NULL, "draft_file_path" varchar(1024) NOT NULL, "origin_file_uuid" char(32) NOT NULL UNIQUE, "publish_file_version" varchar(100) NULL, "status" varchar(20) NOT NULL, "origin_repo_id" varchar(36) NOT NULL);
CREATE TABLE "drafts_draftreviewer" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "reviewer" varchar(255) NOT NULL, "draft_id" integer NOT NULL REFERENCES "drafts_draft" ("id"));
CREATE TABLE "file_participants_fileparticipant" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "uuid_id" char(32) NOT NULL REFERENCES "tags_fileuuidmap" ("uuid"));
CREATE TABLE "repo_tags_repotags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "name" varchar(255) NOT NULL, "color" varchar(255) NOT NULL);
CREATE TABLE "file_tags_filetags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "file_uuid_id" char(32) NOT NULL REFERENCES "tags_fileuuidmap" ("uuid"), "repo_tag_id" integer NOT NULL REFERENCES "repo_tags_repotags" ("id"));
CREATE TABLE "institutions_institution" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(200) NOT NULL, "create_time" datetime NOT NULL);
CREATE TABLE "institutions_institutionquota" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "quota" bigint NOT NULL, "institution_id" integer NOT NULL REFERENCES "institutions_institution" ("id"));
CREATE TABLE "institutions_institutionadmin" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "institution_id" integer NOT NULL REFERENCES "institutions_institution" ("id"), "user" varchar(255) NOT NULL);
CREATE TABLE "invitations_invitation" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(40) NOT NULL, "inviter" varchar(255) NOT NULL, "accepter" varchar(255) NOT NULL, "invite_time" datetime NOT NULL, "accept_time" datetime NULL, "invite_type" varchar(20) NOT NULL, "expire_time" datetime NOT NULL);
CREATE TABLE "repo_share_invitation" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "permission" varchar(50) NOT NULL, "invitation_id" integer NOT NULL REFERENCES "invitations_invitation" ("id"));
CREATE TABLE "notifications_notification" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "message" varchar(512) NOT NULL, "primary" bool NOT NULL);
CREATE TABLE "notifications_usernotification" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "to_user" varchar(255) NOT NULL, "msg_type" varchar(30) NOT NULL, "detail" text NOT NULL, "seen" bool NOT NULL, "timestamp" datetime NOT NULL);
CREATE TABLE "options_useroptions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(255) NOT NULL, "option_val" varchar(512) NOT NULL, "option_key" varchar(50) NOT NULL);
CREATE TABLE "organizations_orgmemberquota" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "org_id" integer NOT NULL, "quota" integer NOT NULL);
CREATE TABLE "organizations_orgsettings" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "role" varchar(100) NULL, "org_id" integer NOT NULL UNIQUE);
CREATE TABLE "post_office_attachment_emails" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "attachment_id" integer NOT NULL REFERENCES "post_office_attachment" ("id"), "email_id" integer NOT NULL REFERENCES "post_office_email" ("id"));
CREATE TABLE "post_office_email" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "from_email" varchar(254) NOT NULL, "to" text NOT NULL, "cc" text NOT NULL, "bcc" text NOT NULL, "subject" varchar(989) NOT NULL, "message" text NOT NULL, "html_message" text NOT NULL, "status" smallint unsigned NULL, "priority" smallint unsigned NULL, "created" datetime NOT NULL, "last_updated" datetime NOT NULL, "scheduled_time" datetime NULL, "headers" text NULL, "context" text NULL, "backend_alias" varchar(64) NOT NULL, "template_id" integer NULL REFERENCES "post_office_emailtemplate" ("id"));
CREATE TABLE "post_office_emailtemplate" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "description" text NOT NULL, "subject" varchar(255) NOT NULL, "content" text NOT NULL, "html_content" text NOT NULL, "created" datetime NOT NULL, "last_updated" datetime NOT NULL, "language" varchar(12) NOT NULL, "name" varchar(255) NOT NULL, "default_template_id" integer NULL REFERENCES "post_office_emailtemplate" ("id"));
CREATE TABLE "post_office_log" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "date" datetime NOT NULL, "exception_type" varchar(255) NOT NULL, "message" text NOT NULL, "email_id" integer NOT NULL REFERENCES "post_office_email" ("id"), "status" smallint unsigned NOT NULL);
CREATE TABLE "post_office_attachment" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "file" varchar(100) NOT NULL, "name" varchar(255) NOT NULL, "mimetype" varchar(255) NOT NULL, "headers" text NULL);
CREATE TABLE "profile_detailedprofile" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL, "department" varchar(512) NOT NULL, "telephone" varchar(100) NOT NULL);
CREATE TABLE "profile_profile" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(254) NOT NULL UNIQUE, "nickname" varchar(64) NOT NULL, "intro" text NOT NULL, "lang_code" text NULL, "login_id" varchar(225) NULL UNIQUE, "institution" varchar(225) NULL, "list_in_address_book" bool NOT NULL, "contact_email" varchar(225) NULL UNIQUE);
CREATE TABLE "registration_registrationprofile" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "emailuser_id" integer NOT NULL, "activation_key" varchar(40) NOT NULL);
CREATE TABLE "related_files_relatedfiles" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "o_uuid_id" char(32) NOT NULL REFERENCES "tags_fileuuidmap" ("uuid"), "r_uuid_id" char(32) NOT NULL REFERENCES "tags_fileuuidmap" ("uuid"));
CREATE TABLE "repo_api_tokens" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "app_name" varchar(255) NOT NULL, "token" varchar(40) NOT NULL UNIQUE, "generated_at" datetime NOT NULL, "generated_by" varchar(255) NOT NULL, "last_access" datetime NOT NULL, "permission" varchar(15) NOT NULL);
CREATE TABLE "revision_tag_tags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(255) NOT NULL UNIQUE);
CREATE TABLE "revision_tag_revisiontags" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "revision_id" varchar(255) NOT NULL, "username" varchar(255) NOT NULL, "tag_id" integer NOT NULL REFERENCES "revision_tag_tags" ("id"));
CREATE TABLE "role_permissions_adminrole" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(254) NOT NULL UNIQUE, "role" varchar(255) NOT NULL);
CREATE TABLE "django_session" ("session_key" varchar(40) NOT NULL PRIMARY KEY, "session_data" text NOT NULL, "expire_date" datetime NOT NULL);
CREATE TABLE "share_anonymousshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_owner" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "anonymous_email" varchar(255) NOT NULL, "token" varchar(25) NOT NULL UNIQUE);
CREATE TABLE "share_extragroupssharepermission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "group_id" integer NOT NULL, "permission" varchar(30) NOT NULL);
CREATE TABLE "share_extrasharepermission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "share_to" varchar(255) NOT NULL, "permission" varchar(30) NOT NULL);
CREATE TABLE "share_fileshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "token" varchar(100) NOT NULL UNIQUE, "ctime" datetime NOT NULL, "view_cnt" integer NOT NULL, "s_type" varchar(2) NOT NULL, "password" varchar(128) NULL, "expire_date" datetime NULL, "permission" varchar(50) NOT NULL);
CREATE TABLE "share_orgfileshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "org_id" integer NOT NULL, "file_share_id" integer NOT NULL UNIQUE REFERENCES "share_fileshare" ("id"));
CREATE TABLE "share_privatefiledirshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "from_user" varchar(255) NOT NULL, "to_user" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "token" varchar(10) NOT NULL UNIQUE, "permission" varchar(5) NOT NULL, "s_type" varchar(5) NOT NULL);
CREATE TABLE "share_uploadlinkshare" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "repo_id" varchar(36) NOT NULL, "path" text NOT NULL, "token" varchar(100) NOT NULL UNIQUE, "ctime" datetime NOT NULL, "view_cnt" integer NOT NULL, "password" varchar(128) NULL, "expire_date" datetime NULL);
CREATE TABLE "sysadmin_extra_userloginlog" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "login_date" datetime NOT NULL, "login_ip" varchar(128) NOT NULL, "login_success" bool NOT NULL);
CREATE TABLE "termsandconditions_termsandconditions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "slug" varchar(50) NOT NULL, "name" text NOT NULL, "version_number" decimal NOT NULL, "text" text NULL, "info" text NULL, "date_active" datetime NULL, "date_created" datetime NOT NULL);
CREATE TABLE "termsandconditions_usertermsandconditions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "ip_address" char(39) NULL, "date_accepted" datetime NOT NULL, "terms_id" integer NOT NULL REFERENCES "termsandconditions_termsandconditions" ("id"));
CREATE TABLE "trusted_ip_trustedip" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "ip" varchar(255) NOT NULL);
CREATE TABLE "two_factor_phonedevice" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL UNIQUE, "name" varchar(64) NOT NULL, "confirmed" bool NOT NULL, "number" varchar(40) NOT NULL, "key" varchar(40) NOT NULL, "method" varchar(4) NOT NULL);
CREATE TABLE "two_factor_staticdevice" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL UNIQUE, "name" varchar(64) NOT NULL, "confirmed" bool NOT NULL);
CREATE TABLE "two_factor_statictoken" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(16) NOT NULL, "device_id" integer NOT NULL REFERENCES "two_factor_staticdevice" ("id"));
CREATE TABLE "two_factor_totpdevice" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user" varchar(255) NOT NULL UNIQUE, "name" varchar(64) NOT NULL, "confirmed" bool NOT NULL, "key" varchar(80) NOT NULL, "step" smallint unsigned NOT NULL, "t0" bigint NOT NULL, "digits" smallint unsigned NOT NULL, "tolerance" smallint unsigned NOT NULL, "drift" smallint NOT NULL, "last_t" bigint NOT NULL);
CREATE TABLE "wiki_wiki" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "username" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "slug" varchar(255) NOT NULL UNIQUE, "permission" varchar(50) NOT NULL, "created_at" datetime NOT NULL, "repo_id" varchar(36) NOT NULL);
DELETE FROM sqlite_sequence;
INSERT INTO "sqlite_sequence" VALUES('django_migrations',83);
INSERT INTO "sqlite_sequence" VALUES('django_content_type',73);
INSERT INTO "sqlite_sequence" VALUES('auth_permission',217);
INSERT INTO "sqlite_sequence" VALUES('auth_user',0);
INSERT INTO "sqlite_sequence" VALUES('tags_filetag',0);
INSERT INTO "sqlite_sequence" VALUES('base_filecomment',0);
INSERT INTO "sqlite_sequence" VALUES('contacts_contact',0);
INSERT INTO "sqlite_sequence" VALUES('constance_config',0);
INSERT INTO "sqlite_sequence" VALUES('django_cas_ng_proxygrantingticket',0);
INSERT INTO "sqlite_sequence" VALUES('drafts_draft',0);
INSERT INTO "sqlite_sequence" VALUES('drafts_draftreviewer',0);
INSERT INTO "sqlite_sequence" VALUES('file_tags_filetags',0);
INSERT INTO "sqlite_sequence" VALUES('institutions_institutionadmin',0);
INSERT INTO "sqlite_sequence" VALUES('invitations_invitation',0);
INSERT INTO "sqlite_sequence" VALUES('notifications_notification',0);
INSERT INTO "sqlite_sequence" VALUES('notifications_usernotification',0);
INSERT INTO "sqlite_sequence" VALUES('options_useroptions',0);
INSERT INTO "sqlite_sequence" VALUES('organizations_orgsettings',0);
INSERT INTO "sqlite_sequence" VALUES('post_office_attachment_emails',0);
INSERT INTO "sqlite_sequence" VALUES('post_office_email',0);
INSERT INTO "sqlite_sequence" VALUES('post_office_emailtemplate',0);
INSERT INTO "sqlite_sequence" VALUES('post_office_log',0);
INSERT INTO "sqlite_sequence" VALUES('post_office_attachment',0);
INSERT INTO "sqlite_sequence" VALUES('profile_profile',0);
INSERT INTO "sqlite_sequence" VALUES('revision_tag_revisiontags',0);
INSERT INTO "sqlite_sequence" VALUES('share_fileshare',0);
INSERT INTO "sqlite_sequence" VALUES('share_privatefiledirshare',0);
INSERT INTO "sqlite_sequence" VALUES('termsandconditions_termsandconditions',0);
INSERT INTO "sqlite_sequence" VALUES('termsandconditions_usertermsandconditions',0);
INSERT INTO "sqlite_sequence" VALUES('wiki_wiki',0);
CREATE INDEX "abuse_reports_abusereport_abuse_type_703d5335" ON "abuse_reports_abusereport" ("abuse_type");
CREATE INDEX "abuse_reports_abusereport_handled_94b8304c" ON "abuse_reports_abusereport" ("handled");
CREATE INDEX "admin_log_adminlog_email_7213c993" ON "admin_log_adminlog" ("email");
CREATE INDEX "admin_log_adminlog_operation_4bad7bd1" ON "admin_log_adminlog" ("operation");
CREATE UNIQUE INDEX "api2_tokenv2_user_platform_device_id_37005c24_uniq" ON "api2_tokenv2" ("user", "platform", "device_id");
CREATE UNIQUE INDEX "django_content_type_app_label_model_76bd3d3b_uniq" ON "django_content_type" ("app_label", "model");
CREATE UNIQUE INDEX "auth_group_permissions_group_id_permission_id_0cd325b0_uniq" ON "auth_group_permissions" ("group_id", "permission_id");
CREATE INDEX "auth_group_permissions_group_id_b120cbf9" ON "auth_group_permissions" ("group_id");
CREATE INDEX "auth_group_permissions_permission_id_84c5c92e" ON "auth_group_permissions" ("permission_id");
CREATE UNIQUE INDEX "auth_user_groups_user_id_group_id_94350c0c_uniq" ON "auth_user_groups" ("user_id", "group_id");
CREATE INDEX "auth_user_groups_user_id_6a12ed8b" ON "auth_user_groups" ("user_id");
CREATE INDEX "auth_user_groups_group_id_97559544" ON "auth_user_groups" ("group_id");
CREATE UNIQUE INDEX "auth_user_user_permissions_user_id_permission_id_14a6b632_uniq" ON "auth_user_user_permissions" ("user_id", "permission_id");
CREATE INDEX "auth_user_user_permissions_user_id_a95ead1b" ON "auth_user_user_permissions" ("user_id");
CREATE INDEX "auth_user_user_permissions_permission_id_1fbb5f2c" ON "auth_user_user_permissions" ("permission_id");
CREATE UNIQUE INDEX "auth_permission_content_type_id_codename_01ab375a_uniq" ON "auth_permission" ("content_type_id", "codename");
CREATE INDEX "auth_permission_content_type_id_2f476e4b" ON "auth_permission" ("content_type_id");
CREATE INDEX "tags_fileuuidmap_repo_id_ac67aa33" ON "tags_fileuuidmap" ("repo_id");
CREATE INDEX "tags_fileuuidmap_repo_id_parent_path_md5_c8bb0860" ON "tags_fileuuidmap" ("repo_id_parent_path_md5");
CREATE INDEX "tags_filetag_tag_id_0f264fc9" ON "tags_filetag" ("tag_id");
CREATE INDEX "tags_filetag_uuid_id_2aa2266c" ON "tags_filetag" ("uuid_id");
CREATE UNIQUE INDEX "base_devicetoken_token_user_38535636_uniq" ON "base_devicetoken" ("token", "user");
CREATE INDEX "base_clientlogintoken_username_4ad5d42c" ON "base_clientlogintoken" ("username");
CREATE INDEX "base_userlastlogin_username_270de06f" ON "base_userlastlogin" ("username");
CREATE INDEX "base_userstarredfiles_email_29e69053" ON "base_userstarredfiles" ("email");
CREATE INDEX "base_userstarredfiles_repo_id_f5ecc00a" ON "base_userstarredfiles" ("repo_id");
CREATE INDEX "social_auth_usersocialauth_username_3f06b5cf" ON "social_auth_usersocialauth" ("username");
CREATE INDEX "base_filecomment_author_8a4d7e91" ON "base_filecomment" ("author");
CREATE INDEX "base_filecomment_uuid_id_4f9a2ca2" ON "base_filecomment" ("uuid_id");
CREATE INDEX "base_filecomment_resolved_e0717eca" ON "base_filecomment" ("resolved");
CREATE UNIQUE INDEX "social_auth_usersocialauth_provider_uid_e6b5e668_uniq" ON "social_auth_usersocialauth" ("provider", "uid");
CREATE INDEX "contacts_contact_user_email_149035d4" ON "contacts_contact" ("user_email");
CREATE UNIQUE INDEX "django_cas_ng_proxygrantingticket_session_key_user_8a4ec2bc_uniq" ON "django_cas_ng_proxygrantingticket" ("session_key", "user");
CREATE INDEX "django_cas_ng_proxygrantingticket_user_1f42619d" ON "django_cas_ng_proxygrantingticket" ("user");
CREATE INDEX "drafts_draftreviewer_reviewer_e4c777ac" ON "drafts_draftreviewer" ("reviewer");
CREATE INDEX "drafts_draftreviewer_draft_id_4ea59775" ON "drafts_draftreviewer" ("draft_id");
CREATE INDEX "drafts_draft_created_at_e9f4523f" ON "drafts_draft" ("created_at");
CREATE INDEX "drafts_draft_updated_at_0a144b05" ON "drafts_draft" ("updated_at");
CREATE INDEX "drafts_draft_username_73e6738b" ON "drafts_draft" ("username");
CREATE INDEX "drafts_draft_origin_repo_id_8978ca2c" ON "drafts_draft" ("origin_repo_id");
CREATE UNIQUE INDEX "file_participants_fileparticipant_uuid_id_username_c747dd36_uniq" ON "file_participants_fileparticipant" ("uuid_id", "username");
CREATE INDEX "file_participants_fileparticipant_uuid_id_861b7339" ON "file_participants_fileparticipant" ("uuid_id");
CREATE INDEX "repo_tags_repotags_repo_id_1163a48f" ON "repo_tags_repotags" ("repo_id");
CREATE INDEX "repo_tags_repotags_name_3f4c9027" ON "repo_tags_repotags" ("name");
CREATE INDEX "repo_tags_repotags_color_1292b6c1" ON "repo_tags_repotags" ("color");
CREATE INDEX "file_tags_filetags_file_uuid_id_e30f0ec8" ON "file_tags_filetags" ("file_uuid_id");
CREATE INDEX "file_tags_filetags_repo_tag_id_c39660cb" ON "file_tags_filetags" ("repo_tag_id");
CREATE INDEX "institutions_institutionquota_institution_id_d23201d9" ON "institutions_institutionquota" ("institution_id");
CREATE INDEX "institutions_institutionadmin_institution_id_1e9bb58b" ON "institutions_institutionadmin" ("institution_id");
CREATE INDEX "institutions_institutionadmin_user_c71d766d" ON "institutions_institutionadmin" ("user");
CREATE INDEX "invitations_invitation_token_25a92a38" ON "invitations_invitation" ("token");
CREATE INDEX "invitations_invitation_inviter_b0a7b855" ON "invitations_invitation" ("inviter");
CREATE INDEX "repo_share_invitation_repo_id_7bcf84fa" ON "repo_share_invitation" ("repo_id");
CREATE INDEX "repo_share_invitation_invitation_id_b71effd2" ON "repo_share_invitation" ("invitation_id");
CREATE INDEX "notifications_notification_primary_4f95ec21" ON "notifications_notification" ("primary");
CREATE INDEX "notifications_usernotification_to_user_6cadafa1" ON "notifications_usernotification" ("to_user");
CREATE INDEX "notifications_usernotification_msg_type_985afd02" ON "notifications_usernotification" ("msg_type");
CREATE INDEX "notifications_usernotification_timestamp_125067e8" ON "notifications_usernotification" ("timestamp");
CREATE INDEX "options_useroptions_email_77d5726a" ON "options_useroptions" ("email");
CREATE INDEX "options_useroptions_option_key_7bf7ae4b" ON "options_useroptions" ("option_key");
CREATE INDEX "organizations_orgmemberquota_org_id_93dde51d" ON "organizations_orgmemberquota" ("org_id");
CREATE UNIQUE INDEX "post_office_attachment_emails_attachment_id_email_id_8e046917_uniq" ON "post_office_attachment_emails" ("attachment_id", "email_id");
CREATE INDEX "post_office_attachment_emails_attachment_id_6136fd9a" ON "post_office_attachment_emails" ("attachment_id");
CREATE INDEX "post_office_attachment_emails_email_id_96875fd9" ON "post_office_attachment_emails" ("email_id");
CREATE INDEX "post_office_email_status_013a896c" ON "post_office_email" ("status");
CREATE INDEX "post_office_email_created_1306952f" ON "post_office_email" ("created");
CREATE INDEX "post_office_email_last_updated_0ffcec35" ON "post_office_email" ("last_updated");
CREATE INDEX "post_office_email_scheduled_time_3869ebec" ON "post_office_email" ("scheduled_time");
CREATE INDEX "post_office_email_template_id_417da7da" ON "post_office_email" ("template_id");
CREATE INDEX "post_office_emailtemplate_default_template_id_2ac2f889" ON "post_office_emailtemplate" ("default_template_id");
CREATE INDEX "post_office_log_email_id_d42c8808" ON "post_office_log" ("email_id");
CREATE UNIQUE INDEX "post_office_emailtemplate_name_language_default_template_id_4023e3e4_uniq" ON "post_office_emailtemplate" ("name", "language", "default_template_id");
CREATE INDEX "profile_detailedprofile_user_612c11ba" ON "profile_detailedprofile" ("user");
CREATE INDEX "profile_profile_institution_c0286bd1" ON "profile_profile" ("institution");
CREATE INDEX "profile_profile_list_in_address_book_b1009a78" ON "profile_profile" ("list_in_address_book");
CREATE INDEX "related_files_relatedfiles_o_uuid_id_aaa8e613" ON "related_files_relatedfiles" ("o_uuid_id");
CREATE INDEX "related_files_relatedfiles_r_uuid_id_031751df" ON "related_files_relatedfiles" ("r_uuid_id");
CREATE INDEX "repo_api_tokens_repo_id_47a50fef" ON "repo_api_tokens" ("repo_id");
CREATE INDEX "repo_api_tokens_app_name_7c395c31" ON "repo_api_tokens" ("app_name");
CREATE INDEX "revision_tag_revisiontags_repo_id_212c0c69" ON "revision_tag_revisiontags" ("repo_id");
CREATE INDEX "revision_tag_revisiontags_revision_id_fd9fe0f9" ON "revision_tag_revisiontags" ("revision_id");
CREATE INDEX "revision_tag_revisiontags_username_3007d29e" ON "revision_tag_revisiontags" ("username");
CREATE INDEX "revision_tag_revisiontags_tag_id_ee4e9b00" ON "revision_tag_revisiontags" ("tag_id");
CREATE INDEX "django_session_expire_date_a5c62663" ON "django_session" ("expire_date");
CREATE INDEX "share_extragroupssharepermission_repo_id_38dbaea1" ON "share_extragroupssharepermission" ("repo_id");
CREATE INDEX "share_extragroupssharepermission_group_id_6ca34bb2" ON "share_extragroupssharepermission" ("group_id");
CREATE INDEX "share_extrasharepermission_repo_id_23cc10fc" ON "share_extrasharepermission" ("repo_id");
CREATE INDEX "share_extrasharepermission_share_to_823c16cb" ON "share_extrasharepermission" ("share_to");
CREATE INDEX "share_orgfileshare_org_id_8d17998c" ON "share_orgfileshare" ("org_id");
CREATE INDEX "share_uploadlinkshare_username_3203c243" ON "share_uploadlinkshare" ("username");
CREATE INDEX "share_uploadlinkshare_repo_id_c519f857" ON "share_uploadlinkshare" ("repo_id");
CREATE INDEX "share_uploadlinkshare_expire_date" ON "share_uploadlinkshare" ("expire_date");
CREATE INDEX "share_fileshare_username_5cb6de75" ON "share_fileshare" ("username");
CREATE INDEX "share_fileshare_repo_id_9b5ae27a" ON "share_fileshare" ("repo_id");
CREATE INDEX "share_fileshare_s_type_724eb6c1" ON "share_fileshare" ("s_type");
CREATE INDEX "share_fileshare_permission_d12c353f" ON "share_fileshare" ("permission");
CREATE INDEX "share_privatefiledirshare_from_user_d568d535" ON "share_privatefiledirshare" ("from_user");
CREATE INDEX "share_privatefiledirshare_to_user_2a92a044" ON "share_privatefiledirshare" ("to_user");
CREATE INDEX "share_privatefiledirshare_repo_id_97c5cb6f" ON "share_privatefiledirshare" ("repo_id");
CREATE INDEX "sysadmin_extra_userloginlog_username_5748b9e3" ON "sysadmin_extra_userloginlog" ("username");
CREATE INDEX "sysadmin_extra_userloginlog_login_date_c171d790" ON "sysadmin_extra_userloginlog" ("login_date");
CREATE UNIQUE INDEX "termsandconditions_usertermsandconditions_username_terms_id_a7dabb70_uniq" ON "termsandconditions_usertermsandconditions" ("username", "terms_id");
CREATE INDEX "termsandconditions_termsandconditions_slug_489d1e9d" ON "termsandconditions_termsandconditions" ("slug");
CREATE INDEX "termsandconditions_usertermsandconditions_terms_id_eacdbcc7" ON "termsandconditions_usertermsandconditions" ("terms_id");
CREATE INDEX "trusted_ip_trustedip_ip_e898970c" ON "trusted_ip_trustedip" ("ip");
CREATE INDEX "two_factor_statictoken_token_2ade1084" ON "two_factor_statictoken" ("token");
CREATE INDEX "two_factor_statictoken_device_id_93095b45" ON "two_factor_statictoken" ("device_id");
CREATE UNIQUE INDEX "wiki_wiki_username_repo_id_4c8925af_uniq" ON "wiki_wiki" ("username", "repo_id");
CREATE INDEX "wiki_wiki_created_at_54930e39" ON "wiki_wiki" ("created_at");
CREATE INDEX "wiki_wiki_repo_id_2ee93c37" ON "wiki_wiki" ("repo_id");
CREATE TABLE "ocm_share" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "shared_secret" varchar(36) NOT NULL UNIQUE, "from_user" varchar(255) NOT NULL, "to_user" varchar(255) NOT NULL, "to_server_url" varchar(200) NOT NULL, "repo_id" varchar(36) NOT NULL, "repo_name" varchar(255) NOT NULL, "permission" varchar(50) NOT NULL, "path" text NOT NULL, "ctime" datetime(6) NOT NULL);
CREATE INDEX "ocm_share_from_user_7fbb7bb6" ON "ocm_share" ("from_user");
CREATE INDEX "ocm_share_to_user_4e255523" ON "ocm_share" ("to_user");
CREATE INDEX "ocm_share_to_server_url_43f0e89b" ON "ocm_share" ("to_server_url");
CREATE INDEX "ocm_share_repo_id_51937581" ON "ocm_share" ("repo_id");
CREATE TABLE "ocm_share_received" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "shared_secret" varchar(36) NOT NULL UNIQUE, "from_user" varchar(255) NOT NULL, "to_user" varchar(255) NOT NULL, "from_server_url" varchar(200) NOT NULL, "repo_id" varchar(36) NOT NULL, "repo_name" varchar(255) NOT NULL, "permission" varchar(50) NOT NULL, "path" text NOT NULL, "provider_id" varchar(40) NOT NULL, "ctime" datetime(6) NOT NULL);
CREATE INDEX "ocm_share_received_from_user_8137d8eb" ON "ocm_share_received" ("from_user");
CREATE INDEX "ocm_share_received_to_user_0921d09a" ON "ocm_share_received" ("to_user");
CREATE INDEX "ocm_share_received_from_server_url_10527b80" ON "ocm_share_received" ("from_server_url");
CREATE INDEX "ocm_share_received_repo_id_9e77a1b9" ON "ocm_share_received" ("repo_id");
CREATE INDEX "ocm_share_received_provider_id_60c873e0" ON "ocm_share_received" ("provider_id");
CREATE TABLE "repo_auto_delete" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL UNIQUE, "days" integer NOT NULL);
CREATE TABLE "external_department" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL UNIQUE, "provider" varchar(32) NOT NULL, "outer_id" bigint NOT NULL);
CREATE UNIQUE INDEX "external_department_provider_outer_id_8dns6vkw_uniq" ON "external_department" (`provider`,`outer_id`);
CREATE TABLE IF NOT EXISTS "custom_share_permission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "name" varchar(255) NOT NULL, "description" varchar(500) NOT NULL, "permission" text NOT NULL);
CREATE INDEX IF NOT EXISTS "custom_share_permission_repo_id_578fe49f" ON "custom_share_permission" ("repo_id");
CREATE TABLE IF NOT EXISTS "ocm_via_webdav_received_shares" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "description" varchar(255) NULL, "name" varchar(255) NOT NULL, "owner" varchar(255) NOT NULL, "owner_display_name" varchar(255) NULL, "protocol_name" varchar(255) NOT NULL, "shared_secret" varchar(255) NOT NULL, "permissions" varchar(255) NOT NULL, "provider_id" varchar(255) NOT NULL, "resource_type" varchar(255) NOT NULL, "share_type" varchar(255) NOT NULL, "share_with" varchar(255) NOT NULL, "shared_by" varchar(255) NOT NULL, "shared_by_display_name" varchar(255) NOT NULL, "ctime" datetime NOT NULL, "is_dir" bool NOT NULL);
CREATE INDEX IF NOT EXISTS "ocm_via_webdav_share_received_owner_261eaa70" ON "ocm_via_webdav_received_shares" ("owner");
CREATE INDEX IF NOT EXISTS "ocm_via_webdav_share_received_shared_secret_fbb6be5a" ON "ocm_via_webdav_received_shares" ("shared_secret");
CREATE INDEX IF NOT EXISTS "ocm_via_webdav_share_received_provider_id_a55680e9" ON "ocm_via_webdav_received_shares" ("provider_id");
CREATE INDEX IF NOT EXISTS "ocm_via_webdav_share_received_resource_type_a3c71b57" ON "ocm_via_webdav_received_shares" ("resource_type");
CREATE INDEX IF NOT EXISTS "ocm_via_webdav_share_received_share_type_7615aaab" ON "ocm_via_webdav_received_shares" ("share_type");
CREATE INDEX IF NOT EXISTS "ocm_via_webdav_share_received_share_with_5a23eb17" ON "ocm_via_webdav_received_shares" ("share_with");
CREATE INDEX IF NOT EXISTS "ocm_via_webdav_share_received_shared_by_1786d580" ON "ocm_via_webdav_received_shares" ("shared_by");
CREATE TABLE IF NOT EXISTS "onlyoffice_onlyofficedockey" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "doc_key" varchar(36) NOT NULL, "username" varchar(255) NOT NULL, "repo_id" varchar(36) NULL, "file_path" TEXT NOT NULL, "repo_id_file_path_md5" varchar(100) NOT NULL, "created_time" datetime NOT NULL);
CREATE INDEX IF NOT EXISTS "onlyoffice_onlyofficedockey_doc_key_edba1352" ON "onlyoffice_onlyofficedockey" ("doc_key");
CREATE INDEX IF NOT EXISTS "onlyoffice_onlyofficedockey_repo_id_file_path_md5_52002073" ON "onlyoffice_onlyofficedockey" ("repo_id_file_path_md5");
CREATE TABLE IF NOT EXISTS "org_saml_config" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "org_id" integer NOT NULL UNIQUE, "metadata_url" TEXT NOT NULL, "domain" varchar(255) NULL UNIQUE, "dns_txt" varchar(64) NULL, "domain_verified" integer NOT NULL DEFAULT 0, "idp_certificate" text NULL);
CREATE INDEX IF NOT EXISTS "org_saml_config_domain_verified_398065b9" ON "org_saml_config" ("domain_verified");
CREATE TABLE IF NOT EXISTS "base_usermonitoredrepos" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "email" varchar(254) NOT NULL, "repo_id" varchar(36) NOT NULL, "timestamp" datetime NOT NULL, UNIQUE ("email", "repo_id"));
CREATE INDEX IF NOT EXISTS "base_usermonitoredrepos_email_55ead1b9" ON "base_usermonitoredrepos" ("email");
CREATE INDEX IF NOT EXISTS "base_usermonitoredrepos_repo_id_00e624c3" ON "base_usermonitoredrepos" ("repo_id");
CREATE TABLE IF NOT EXISTS "organizations_orgadminsettings" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "org_id" integer NOT NULL, "key" varchar(255) NOT NULL, "value" TEXT NOT NULL, UNIQUE ("org_id", "key"));
CREATE INDEX IF NOT EXISTS "organizations_orgadminsettings_org_id_4f70d186" ON "organizations_orgadminsettings" ("org_id");
CREATE TABLE IF NOT EXISTS "history_name" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, "doc_uuid" varchar(36) NOT NULL, "obj_id" varchar(40) NOT NULL, "name" varchar(255) NOT NULL, UNIQUE ("doc_uuid", "obj_id"));
CREATE INDEX IF NOT EXISTS "history_name_doc_uuid" ON "history_name" ("doc_uuid");
CREATE TABLE IF NOT EXISTS "sdoc_draft" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, "doc_uuid" varchar(36) NOT NULL UNIQUE, "repo_id" varchar(36) NOT NULL, "username" varchar(255) NOT NULL, "created_at" datetime NOT NULL);
CREATE INDEX IF NOT EXISTS "sdoc_draft_repo_id" ON "sdoc_draft" ("repo_id");
CREATE INDEX IF NOT EXISTS "sdoc_draft_username" ON "sdoc_draft" ("username");
CREATE TABLE IF NOT EXISTS "sdoc_revision" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "revision_id" integer NOT NULL, "doc_uuid" varchar(36) NOT NULL UNIQUE, "origin_doc_uuid" varchar(36) NOT NULL, "origin_doc_path" text NOT NULL, "origin_file_version" varchar(100) NOT NULL, "publish_file_version" varchar(100) NULL, "username" varchar(255) NOT NULL, "publisher" varchar(255) NULL ,"is_published" integer NOT NULL, "created_at" datetime NOT NULL, "updated_at" datetime NOT NULL, UNIQUE ("repo_id", "revision_id"));
CREATE INDEX IF NOT EXISTS "sdoc_revision_repo_id" ON "sdoc_revision" ("repo_id");
CREATE INDEX IF NOT EXISTS "sdoc_revision_origin_doc_uuid" ON "sdoc_revision" ("origin_doc_uuid");
CREATE INDEX IF NOT EXISTS "sdoc_revision_username" ON "sdoc_revision" ("username");
CREATE INDEX IF NOT EXISTS "sdoc_revision_is_published" ON "sdoc_revision" ("is_published");
CREATE TABLE IF NOT EXISTS "sdoc_comment_reply" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, "author" varchar(255) NOT NULL, "reply" text NOT NULL, "type" varchar(36) NOT NULL, "comment_id" integer NOT NULL, "doc_uuid" varchar(36) NOT NULL, "created_at" datetime NOT NULL, "updated_at" datetime NOT NULL);
CREATE INDEX IF NOT EXISTS "sdoc_comment_reply_comment_id" ON "sdoc_comment_reply" ("comment_id");
CREATE INDEX IF NOT EXISTS "sdoc_comment_reply_doc_uuid" ON "sdoc_comment_reply" ("doc_uuid");
CREATE TABLE IF NOT EXISTS "deleted_files_count" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, "repo_id" varchar(36) NOT NULL, "deleted_time" datetime NOT NULL, "files_count" bigint NOT NULL);
CREATE INDEX IF NOT EXISTS "ix_deleted_files_count_repo_id" ON "deleted_files_count" ("repo_id");
CREATE INDEX IF NOT EXISTS "ix_deleted_files_count_deleted_time" ON "deleted_files_count" ("deleted_time");
CREATE TABLE IF NOT EXISTS "sdoc_notification" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, "doc_uuid" varchar(36) NOT NULL UNIQUE, "username" varchar(255) NOT NULL, "msg_type" varchar(36) NOT NULL, "created_at" datetime NOT NULL, "detail" text NOT NULL, "seen" integer NOT NULL DEFAULT 0);
CREATE INDEX IF NOT EXISTS "sdoc_notification_doc_uuid_username" ON "sdoc_notification" ("doc_uuid", "username");
CREATE INDEX IF NOT EXISTS "sdoc_notification_created_at" ON "sdoc_notification" ("created_at");
CREATE TABLE IF NOT EXISTS "base_clientssotoken" ("id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, "token" varchar(100) NOT NULL UNIQUE, "username" varchar(255) NULL, "status" varchar(10) NOT NULL, "api_key" varchar(40) NULL, "created_at" datetime NOT NULL, "updated_at" datetime NULL, "accessed_at" datetime NULL);
CREATE INDEX IF NOT EXISTS "base_clientssotoken_username_651ec6b5" ON "base_clientssotoken" ("username");
CREATE INDEX IF NOT EXISTS "base_clientssotoken_created_at_d185d3e0" ON "base_clientssotoken" ("created_at");
CREATE INDEX IF NOT EXISTS "base_clientssotoken_updated_at_591fc2cd" ON "base_clientssotoken" ("updated_at");
CREATE INDEX IF NOT EXISTS "base_clientssotoken_accessed_at_cdc66bf3" ON "base_clientssotoken" ("accessed_at");
COMMIT;
