import { CellType } from './column';

const MAX_GROUP_LEVEL = 3;

const GROUP_DATE_GRANULARITY = {
  DAY: 'day',
  WEEK: 'week',
  MONTH: 'month',
  QUARTER: 'quarter',
  YEAR: 'year',
};

const DISPLAY_GROUP_DATE_GRANULARITY = {
  [GROUP_DATE_GRANULARITY.DAY]: 'By day',
  [GROUP_DATE_GRANULARITY.WEEK]: 'By week',
  [GROUP_DATE_GRANULARITY.MONTH]: 'By month',
  [GROUP_DATE_GRANULARITY.QUARTER]: 'By quarter',
  [GROUP_DATE_GRANULARITY.YEAR]: 'By year',
};

const GROUP_GEOLOCATION_GRANULARITY = {
  PROVINCE: 'province',
  CITY: 'city',
  DISTRICT: 'district',
  COUNTRY: 'country',
};

const DISPLAY_GROUP_GEOLOCATION_GRANULARITY = {
  [GROUP_GEOLOCATION_GRANULARITY.PROVINCE]: 'By province',
  [GROUP_GEOLOCATION_GRANULARITY.CITY]: 'By city',
  [GROUP_GEOLOCATION_GRANULARITY.DISTRICT]: 'By district',
};

const SUPPORT_GROUP_COLUMN_TYPES = [
  CellType.TEXT,
  CellType.DATE,
  CellType.CTIME,
  CellType.MTIME,
  CellType.CHECKBOX,
  CellType.SINGLE_SELECT,
  CellType.MULTIPLE_SELECT,
  CellType.COLLABORATOR,
  CellType.CREATOR,
  CellType.LAST_MODIFIER,
  CellType.GEOLOCATION,
  CellType.RATE,
];

const GROUPBY_DATE_GRANULARITY_LIST = [
  GROUP_DATE_GRANULARITY.DAY,
  GROUP_DATE_GRANULARITY.WEEK,
  GROUP_DATE_GRANULARITY.MONTH,
  GROUP_DATE_GRANULARITY.QUARTER,
  GROUP_DATE_GRANULARITY.YEAR,
];

export {
  MAX_GROUP_LEVEL,
  GROUP_DATE_GRANULARITY,
  DISPLAY_GROUP_DATE_GRANULARITY,
  GROUP_GEOLOCATION_GRANULARITY,
  DISPLAY_GROUP_GEOLOCATION_GRANULARITY,
  SUPPORT_GROUP_COLUMN_TYPES,
  GROUPBY_DATE_GRANULARITY_LIST,
};
