#include "lib/spotify/error.hpp"

lib::spt::error::error(const char *what, const char *url)
	: std::runtime_error(what),
	request_url(url)
{
}

lib::spt::error::error(const std::string &what, const std::string &url)
	: lib::spt::error(what.c_str(), url.c_str())
{
}

auto lib::spt::error::url() -> const char *
{
	return request_url;
}

auto SpotifyErrorUtil::isErrorObject(const QJsonObject &json) -> bool
{
	return json.contains(QStringLiteral("error"));
}

auto SpotifyErrorUtil::isErrorObject(const nlohmann::json &json) -> bool
{
	return !json.is_null()
		&& json.is_object()
		&& json.contains("error");
}

auto lib::spt::error::is(const nlohmann::json &json) -> bool
{
	return SpotifyErrorUtil::isErrorObject(json);
}

auto SpotifyErrorUtil::errorMessage(const QJsonObject &json) -> QString
{
	return isErrorObject(json)
		? json.value(QStringLiteral("error")).toObject().value(QStringLiteral("message")).toString()
		: QString();
}

auto SpotifyErrorUtil::errorMessage(const nlohmann::json &json) -> QString
{
	return isErrorObject(json)
		? QString::fromStdString(json.at("error").at("message").get<std::string>())
		: QString();
}

auto lib::spt::error::error_message(const nlohmann::json &json) -> std::string
{
	return SpotifyErrorUtil::errorMessage(json).toStdString();
}
