// Copyright (c) Tailscale Inc & contributors
// SPDX-License-Identifier: BSD-3-Clause

// Code generated by tailscale.com/cmd/cloner; DO NOT EDIT.

package dns

import (
	"maps"
	"net/netip"

	"tailscale.com/types/dnstype"
	"tailscale.com/util/dnsname"
	"tailscale.com/util/set"
)

// Clone makes a deep copy of Config.
// The result aliases no memory with the original.
func (src *Config) Clone() *Config {
	if src == nil {
		return nil
	}
	dst := new(Config)
	*dst = *src
	if src.DefaultResolvers != nil {
		dst.DefaultResolvers = make([]*dnstype.Resolver, len(src.DefaultResolvers))
		for i := range dst.DefaultResolvers {
			if src.DefaultResolvers[i] == nil {
				dst.DefaultResolvers[i] = nil
			} else {
				dst.DefaultResolvers[i] = src.DefaultResolvers[i].Clone()
			}
		}
	}
	if dst.Routes != nil {
		dst.Routes = map[dnsname.FQDN][]*dnstype.Resolver{}
		for k := range src.Routes {
			dst.Routes[k] = append([]*dnstype.Resolver{}, src.Routes[k]...)
		}
	}
	dst.SearchDomains = append(src.SearchDomains[:0:0], src.SearchDomains...)
	if dst.Hosts != nil {
		dst.Hosts = map[dnsname.FQDN][]netip.Addr{}
		for k := range src.Hosts {
			dst.Hosts[k] = append([]netip.Addr{}, src.Hosts[k]...)
		}
	}
	dst.SubdomainHosts = maps.Clone(src.SubdomainHosts)
	return dst
}

// A compilation failure here means this code must be regenerated, with the command at the top of this file.
var _ConfigCloneNeedsRegeneration = Config(struct {
	AcceptDNS        bool
	DefaultResolvers []*dnstype.Resolver
	Routes           map[dnsname.FQDN][]*dnstype.Resolver
	SearchDomains    []dnsname.FQDN
	Hosts            map[dnsname.FQDN][]netip.Addr
	SubdomainHosts   set.Set[dnsname.FQDN]
	OnlyIPv6         bool
}{})

// Clone duplicates src into dst and reports whether it succeeded.
// To succeed, <src, dst> must be of types <*T, *T> or <*T, **T>,
// where T is one of Config.
func Clone(dst, src any) bool {
	switch src := src.(type) {
	case *Config:
		switch dst := dst.(type) {
		case *Config:
			*dst = *src.Clone()
			return true
		case **Config:
			*dst = src.Clone()
			return true
		}
	}
	return false
}
