#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::AutosaveSettingsScope *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"autosaveSettingsScopePrivateChats", 1395227007},
    {"autosaveSettingsScopeGroupChats", 853544526},
    {"autosaveSettingsScopeChannelChats", -499572783},
    {"autosaveSettingsScopeChat", -1632255255}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatAction *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatActionTyping", 380122167},
    {"chatActionRecordingVideo", 216553362},
    {"chatActionUploadingVideo", 1234185270},
    {"chatActionRecordingVoiceNote", -808850058},
    {"chatActionUploadingVoiceNote", -613643666},
    {"chatActionUploadingPhoto", 654240583},
    {"chatActionUploadingDocument", 167884362},
    {"chatActionChoosingSticker", 372753697},
    {"chatActionChoosingLocation", -2017893596},
    {"chatActionChoosingContact", -1222507496},
    {"chatActionStartPlayingGame", -865884164},
    {"chatActionRecordingVideoNote", 16523393},
    {"chatActionUploadingVideoNote", 1172364918},
    {"chatActionWatchingAnimations", 2052990641},
    {"chatActionCancel", 1160523958}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::EmojiCategoryType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"emojiCategoryTypeDefault", 1188782699},
    {"emojiCategoryTypeRegularStickers", -1337484846},
    {"emojiCategoryTypeEmojiStatus", 1381282631},
    {"emojiCategoryTypeChatPhoto", 1059063081}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InlineQueryResultsButtonType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inlineQueryResultsButtonTypeStartBot", -23400235},
    {"inlineQueryResultsButtonTypeWebApp", -1197382814}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputMessageContent *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputMessageText", -212805484},
    {"inputMessageAnimation", -210404059},
    {"inputMessageAudio", -626786126},
    {"inputMessageDocument", 1633383097},
    {"inputMessagePaidMedia", -1274819374},
    {"inputMessagePhoto", -810129442},
    {"inputMessageSticker", 1072805625},
    {"inputMessageVideo", -605958271},
    {"inputMessageVideoNote", -714598691},
    {"inputMessageVoiceNote", 1461977004},
    {"inputMessageLocation", 648735088},
    {"inputMessageVenue", 1447926269},
    {"inputMessageContact", -982446849},
    {"inputMessageDice", 841574313},
    {"inputMessageGame", 1252944610},
    {"inputMessageInvoice", -1162047631},
    {"inputMessagePoll", -263337164},
    {"inputMessageStory", -370732053},
    {"inputMessageChecklist", -1722965261},
    {"inputMessageForwarded", -1076506316}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::KeyboardButtonType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"keyboardButtonTypeText", -1773037256},
    {"keyboardButtonTypeRequestPhoneNumber", -1529235527},
    {"keyboardButtonTypeRequestLocation", -125661955},
    {"keyboardButtonTypeRequestPoll", 1902435512},
    {"keyboardButtonTypeRequestUsers", -1738765315},
    {"keyboardButtonTypeRequestChat", 1511138485},
    {"keyboardButtonTypeWebApp", 1892220770}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::NetworkStatisticsEntry *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"networkStatisticsEntryFile", 188452706},
    {"networkStatisticsEntryCall", 737000365}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PremiumLimitType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"premiumLimitTypeSupergroupCount", -247467131},
    {"premiumLimitTypePinnedChatCount", -998947871},
    {"premiumLimitTypeCreatedPublicChatCount", 446086841},
    {"premiumLimitTypeSavedAnimationCount", -19759735},
    {"premiumLimitTypeFavoriteStickerCount", 639754787},
    {"premiumLimitTypeChatFolderCount", 377489774},
    {"premiumLimitTypeChatFolderChosenChatCount", 1691435861},
    {"premiumLimitTypePinnedArchivedChatCount", 1485515276},
    {"premiumLimitTypePinnedSavedMessagesTopicCount", -1544854305},
    {"premiumLimitTypeCaptionLength", 293984314},
    {"premiumLimitTypeBioLength", -1146976765},
    {"premiumLimitTypeChatFolderInviteLinkCount", -128702950},
    {"premiumLimitTypeShareableChatFolderCount", 1612625095},
    {"premiumLimitTypeActiveStoryCount", -1926486372},
    {"premiumLimitTypeWeeklyPostedStoryCount", -506354313},
    {"premiumLimitTypeMonthlyPostedStoryCount", 26329490},
    {"premiumLimitTypeStoryCaptionLength", -1093324030},
    {"premiumLimitTypeStorySuggestedReactionAreaCount", -1170032633},
    {"premiumLimitTypeSimilarChatCount", -1563549935}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ReportReason *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"reportReasonSpam", -1207032897},
    {"reportReasonViolence", 2038679353},
    {"reportReasonPornography", 1306467575},
    {"reportReasonChildAbuse", 761086718},
    {"reportReasonCopyright", 1474441135},
    {"reportReasonUnrelatedLocation", 87562288},
    {"reportReasonFake", 352862176},
    {"reportReasonIllegalDrugs", -61599200},
    {"reportReasonPersonalDetails", -1588882414},
    {"reportReasonCustom", -1380459917}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::StoryPrivacySettings *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"storyPrivacySettingsEveryone", 890847843},
    {"storyPrivacySettingsContacts", 50285309},
    {"storyPrivacySettingsCloseFriends", 2097122144},
    {"storyPrivacySettingsSelectedUsers", -1885772602}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::TransactionDirection *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"transactionDirectionIncoming", -271074103},
    {"transactionDirectionOutgoing", 1638241254}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::affiliateProgramSortOrderProfitability &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::autosaveSettingsScopeGroupChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::backgroundTypeChatTheme &to, JsonObject &from) {
  TRY_STATUS(from_json(to.theme_name_, from.extract_field("theme_name")));
  return Status::OK();
}

Status from_json(td_api::botCommandScopeChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::businessConnectedBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.recipients_, from.extract_field("recipients")));
  TRY_STATUS(from_json(to.rights_, from.extract_field("rights")));
  return Status::OK();
}

Status from_json(td_api::businessFeatureEmojiStatus &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callProblemNoise &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callbackQueryPayloadData &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::chatActionUploadingDocument &to, JsonObject &from) {
  TRY_STATUS(from_json(to.progress_, from.extract_field("progress")));
  return Status::OK();
}

Status from_json(td_api::chatAdministratorRights &to, JsonObject &from) {
  TRY_STATUS(from_json(to.can_manage_chat_, from.extract_field("can_manage_chat")));
  TRY_STATUS(from_json(to.can_change_info_, from.extract_field("can_change_info")));
  TRY_STATUS(from_json(to.can_post_messages_, from.extract_field("can_post_messages")));
  TRY_STATUS(from_json(to.can_edit_messages_, from.extract_field("can_edit_messages")));
  TRY_STATUS(from_json(to.can_delete_messages_, from.extract_field("can_delete_messages")));
  TRY_STATUS(from_json(to.can_invite_users_, from.extract_field("can_invite_users")));
  TRY_STATUS(from_json(to.can_restrict_members_, from.extract_field("can_restrict_members")));
  TRY_STATUS(from_json(to.can_pin_messages_, from.extract_field("can_pin_messages")));
  TRY_STATUS(from_json(to.can_manage_topics_, from.extract_field("can_manage_topics")));
  TRY_STATUS(from_json(to.can_promote_members_, from.extract_field("can_promote_members")));
  TRY_STATUS(from_json(to.can_manage_video_chats_, from.extract_field("can_manage_video_chats")));
  TRY_STATUS(from_json(to.can_post_stories_, from.extract_field("can_post_stories")));
  TRY_STATUS(from_json(to.can_edit_stories_, from.extract_field("can_edit_stories")));
  TRY_STATUS(from_json(to.can_delete_stories_, from.extract_field("can_delete_stories")));
  TRY_STATUS(from_json(to.can_manage_direct_messages_, from.extract_field("can_manage_direct_messages")));
  TRY_STATUS(from_json(to.is_anonymous_, from.extract_field("is_anonymous")));
  return Status::OK();
}

Status from_json(td_api::chatListMain &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatMemberStatusBanned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.banned_until_date_, from.extract_field("banned_until_date")));
  return Status::OK();
}

Status from_json(td_api::chatPermissions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.can_send_basic_messages_, from.extract_field("can_send_basic_messages")));
  TRY_STATUS(from_json(to.can_send_audios_, from.extract_field("can_send_audios")));
  TRY_STATUS(from_json(to.can_send_documents_, from.extract_field("can_send_documents")));
  TRY_STATUS(from_json(to.can_send_photos_, from.extract_field("can_send_photos")));
  TRY_STATUS(from_json(to.can_send_videos_, from.extract_field("can_send_videos")));
  TRY_STATUS(from_json(to.can_send_video_notes_, from.extract_field("can_send_video_notes")));
  TRY_STATUS(from_json(to.can_send_voice_notes_, from.extract_field("can_send_voice_notes")));
  TRY_STATUS(from_json(to.can_send_polls_, from.extract_field("can_send_polls")));
  TRY_STATUS(from_json(to.can_send_other_messages_, from.extract_field("can_send_other_messages")));
  TRY_STATUS(from_json(to.can_add_link_previews_, from.extract_field("can_add_link_previews")));
  TRY_STATUS(from_json(to.can_change_info_, from.extract_field("can_change_info")));
  TRY_STATUS(from_json(to.can_invite_users_, from.extract_field("can_invite_users")));
  TRY_STATUS(from_json(to.can_pin_messages_, from.extract_field("can_pin_messages")));
  TRY_STATUS(from_json(to.can_create_topics_, from.extract_field("can_create_topics")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenApplePush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.device_token_, from.extract_field("device_token")));
  TRY_STATUS(from_json(to.is_app_sandbox_, from.extract_field("is_app_sandbox")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenTizenPush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reg_id_, from.extract_field("reg_id")));
  return Status::OK();
}

Status from_json(td_api::emojiCategoryTypeChatPhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeNotificationSound &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeSelfDestructingVideoNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeWallpaper &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::giftResalePriceTon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.toncoin_cent_count_, from.extract_field("toncoin_cent_count")));
  return Status::OK();
}

Status from_json(td_api::importedContact &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  TRY_STATUS(from_json(to.note_, from.extract_field("note")));
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeBuy &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inputBusinessChatLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::inputChecklistTask &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::inputGroupCallLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.live_period_, from.extract_field("live_period")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_width_, from.extract_field("thumbnail_width")));
  TRY_STATUS(from_json(to.thumbnail_height_, from.extract_field("thumbnail_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessageText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.link_preview_options_, from.extract_field("link_preview_options")));
  TRY_STATUS(from_json(to.clear_draft_, from.extract_field("clear_draft")));
  return Status::OK();
}

Status from_json(td_api::inputMessageVoiceNote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.voice_note_, from.extract_field("voice_note")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json_bytes(to.waveform_, from.extract_field("waveform")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.self_destruct_type_, from.extract_field("self_destruct_type")));
  return Status::OK();
}

Status from_json(td_api::inputMessageChecklist &to, JsonObject &from) {
  TRY_STATUS(from_json(to.checklist_, from.extract_field("checklist")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementPassport &to, JsonObject &from) {
  TRY_STATUS(from_json(to.passport_, from.extract_field("passport")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementTemporaryRegistration &to, JsonObject &from) {
  TRY_STATUS(from_json(to.temporary_registration_, from.extract_field("temporary_registration")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceTranslationFile &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.file_hash_, from.extract_field("file_hash")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypePreviousVenue &to, JsonObject &from) {
  TRY_STATUS(from_json(to.venue_provider_, from.extract_field("venue_provider")));
  TRY_STATUS(from_json(to.venue_id_, from.extract_field("venue_id")));
  return Status::OK();
}

Status from_json(td_api::inputSuggestedPostInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.price_, from.extract_field("price")));
  TRY_STATUS(from_json(to.send_date_, from.extract_field("send_date")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeBotStartInGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.start_parameter_, from.extract_field("start_parameter")));
  TRY_STATUS(from_json(to.administrator_rights_, from.extract_field("administrator_rights")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeDefaultMessageAutoDeleteTimerSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeLanguageSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePasswordSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeQrCodeAuthentication &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeUnsupportedProxy &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::jsonValueBoolean &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeRequestPoll &to, JsonObject &from) {
  TRY_STATUS(from_json(to.force_regular_, from.extract_field("force_regular")));
  TRY_STATUS(from_json(to.force_quiz_, from.extract_field("force_quiz")));
  return Status::OK();
}

Status from_json(td_api::languagePackStringValueDeleted &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::maskPointMouth &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageSelfDestructTypeImmediately &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageSourceChatList &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageTopicSavedMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  return Status::OK();
}

Status from_json(td_api::notificationSettingsScopePrivateChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::paidReactionTypeAnonymous &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypeBankStatement &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::phoneNumberCodeTypeVerify &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureUniqueReactions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureRealTimeChatTranslation &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureMessageEffects &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypePinnedArchivedChatCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeStoryCaptionLength &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeaturePriorityOrder &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabMedia &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::publicChatTypeHasUsername &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::readDatePrivacySettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.show_read_date_, from.extract_field("show_read_date")));
  return Status::OK();
}

Status from_json(td_api::reportReasonCopyright &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::scopeNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.mute_for_, from.extract_field("mute_for")));
  TRY_STATUS(from_json(to.sound_id_, from.extract_field("sound_id")));
  TRY_STATUS(from_json(to.show_preview_, from.extract_field("show_preview")));
  TRY_STATUS(from_json(to.use_default_mute_stories_, from.extract_field("use_default_mute_stories")));
  TRY_STATUS(from_json(to.mute_stories_, from.extract_field("mute_stories")));
  TRY_STATUS(from_json(to.story_sound_id_, from.extract_field("story_sound_id")));
  TRY_STATUS(from_json(to.show_story_poster_, from.extract_field("show_story_poster")));
  TRY_STATUS(from_json(to.disable_pinned_message_notifications_, from.extract_field("disable_pinned_message_notifications")));
  TRY_STATUS(from_json(to.disable_mention_notifications_, from.extract_field("disable_mention_notifications")));
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterUnreadReaction &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::stickerTypeMask &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::storeTransactionAppStore &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.receipt_, from.extract_field("receipt")));
  return Status::OK();
}

Status from_json(td_api::storyPrivacySettingsSelectedUsers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionSubscribeToAnnualPremium &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedPostPriceTon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.toncoin_cent_count_, from.extract_field("toncoin_cent_count")));
  return Status::OK();
}

Status from_json(td_api::targetChatCurrent &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::telegramPaymentPurposeStarGiveaway &to, JsonObject &from) {
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  TRY_STATUS(from_json(to.winner_count_, from.extract_field("winner_count")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypeUrl &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypeCode &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textParseModeMarkdown &to, JsonObject &from) {
  TRY_STATUS(from_json(to.version_, from.extract_field("version")));
  return Status::OK();
}

Status from_json(td_api::topChatCategoryCalls &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowProfilePhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAllowFindingByPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleAllowChatMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::webAppOpenModeFullSize &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::addChatMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::addLogMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.verbosity_level_, from.extract_field("verbosity_level")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::addQuickReplyShortcutMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_name_, from.extract_field("shortcut_name")));
  TRY_STATUS(from_json(to.reply_to_message_id_, from.extract_field("reply_to_message_id")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::allowUnpaidMessagesFromUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.refund_payments_, from.extract_field("refund_payments")));
  return Status::OK();
}

Status from_json(td_api::assignStoreTransaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.transaction_, from.extract_field("transaction")));
  TRY_STATUS(from_json(to.purpose_, from.extract_field("purpose")));
  return Status::OK();
}

Status from_json(td_api::canSendGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_id_, from.extract_field("gift_id")));
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationBotToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::checkCreatedPublicChatsLimit &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::checkWebAppFileDownload &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.file_name_, from.extract_field("file_name")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::clearSearchedForTags &to, JsonObject &from) {
  TRY_STATUS(from_json(to.clear_cashtags_, from.extract_field("clear_cashtags")));
  return Status::OK();
}

Status from_json(td_api::closeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.web_app_launch_id_, from.extract_field("web_app_launch_id")));
  return Status::OK();
}

Status from_json(td_api::createChatFolder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.folder_, from.extract_field("folder")));
  return Status::OK();
}

Status from_json(td_api::createNewSecretChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::declineGroupCallInvitation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::deleteBusinessMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  return Status::OK();
}

Status from_json(td_api::deleteChatReplyMarkup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::deleteGroupCallMessagesBySender &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.sender_id_, from.extract_field("sender_id")));
  TRY_STATUS(from_json(to.report_spam_, from.extract_field("report_spam")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedMessagesTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  return Status::OK();
}

Status from_json(td_api::discardCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json(to.is_disconnected_, from.extract_field("is_disconnected")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json(to.is_video_, from.extract_field("is_video")));
  TRY_STATUS(from_json(to.connection_id_, from.extract_field("connection_id")));
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageChecklist &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.checklist_, from.extract_field("checklist")));
  return Status::OK();
}

Status from_json(td_api::editChatSubscriptionInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::editMessageChecklist &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.checklist_, from.extract_field("checklist")));
  return Status::OK();
}

Status from_json(td_api::editStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.content_, from.extract_field("content")));
  TRY_STATUS(from_json(to.areas_, from.extract_field("areas")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  return Status::OK();
}

Status from_json(td_api::forwardMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.from_chat_id_, from.extract_field("from_chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  TRY_STATUS(from_json(to.send_copy_, from.extract_field("send_copy")));
  TRY_STATUS(from_json(to.remove_caption_, from.extract_field("remove_caption")));
  return Status::OK();
}

Status from_json(td_api::getArchivedStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.offset_sticker_set_id_, from.extract_field("offset_sticker_set_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getBankCardInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bank_card_number_, from.extract_field("bank_card_number")));
  return Status::OK();
}

Status from_json(td_api::getBotSimilarBotCount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.return_local_, from.extract_field("return_local")));
  return Status::OK();
}

Status from_json(td_api::getCallbackQueryMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.callback_query_id_, from.extract_field("callback_query_id")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatFolderInviteLinks &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getChatMember &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.member_id_, from.extract_field("member_id")));
  return Status::OK();
}

Status from_json(td_api::getChatRevenueTransactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getChatStoryInteractions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  TRY_STATUS(from_json(to.prefer_forwards_, from.extract_field("prefer_forwards")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getConnectedWebsites &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getCustomEmojiStickers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_emoji_ids_, from.extract_field("custom_emoji_ids")));
  return Status::OK();
}

Status from_json(td_api::getDirectMessagesChatTopic &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  return Status::OK();
}

Status from_json(td_api::getExternalLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::getForumTopicLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  return Status::OK();
}

Status from_json(td_api::getGroupCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getInstalledBackgrounds &to, JsonObject &from) {
  TRY_STATUS(from_json(to.for_dark_theme_, from.extract_field("for_dark_theme")));
  return Status::OK();
}

Status from_json(td_api::getLanguagePackStrings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  TRY_STATUS(from_json(to.keys_, from.extract_field("keys")));
  return Status::OK();
}

Status from_json(td_api::getLogTags &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getMessageLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::getMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  return Status::OK();
}

Status from_json(td_api::getPassportElement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getPremiumGiftPaymentOptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getProxyLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.proxy_id_, from.extract_field("proxy_id")));
  return Status::OK();
}

Status from_json(td_api::getRecentlyOpenedChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSavedMessagesTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getStarAdAccountUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  return Status::OK();
}

Status from_json(td_api::getStickerEmojis &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::getStoryAvailableReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.row_size_, from.extract_field("row_size")));
  return Status::OK();
}

Status from_json(td_api::getSupergroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::getThemedEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUpgradedGiftValueInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::getUserSupportInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::giftPremiumWithStars &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  TRY_STATUS(from_json(to.month_count_, from.extract_field("month_count")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::joinChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::loadChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::openChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::pinChatMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.disable_notification_, from.extract_field("disable_notification")));
  TRY_STATUS(from_json(to.only_for_self_, from.extract_field("only_for_self")));
  return Status::OK();
}

Status from_json(td_api::readAllChatMentions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::recognizeSpeech &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::removeContacts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::removePendingLiveStoryReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::removeSearchedForTag &to, JsonObject &from) {
  TRY_STATUS(from_json(to.tag_, from.extract_field("tag")));
  return Status::OK();
}

Status from_json(td_api::reorderGiftCollections &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.collection_ids_, from.extract_field("collection_ids")));
  return Status::OK();
}

Status from_json(td_api::replaceVideoChatRtmpUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::reportSupergroupAntiSpamFalsePositive &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::resendMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.quote_, from.extract_field("quote")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  return Status::OK();
}

Status from_json(td_api::revokeChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::searchChatMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.sender_id_, from.extract_field("sender_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  return Status::OK();
}

Status from_json(td_api::searchInstalledStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchPublicStoriesByVenue &to, JsonObject &from) {
  TRY_STATUS(from_json(to.venue_provider_, from.extract_field("venue_provider")));
  TRY_STATUS(from_json(to.venue_id_, from.extract_field("venue_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchUserByPhoneNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::sendCallLog &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json(to.log_file_, from.extract_field("log_file")));
  return Status::OK();
}

Status from_json(td_api::sendMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::sendWebAppCustomRequest &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.method_, from.extract_field("method")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  return Status::OK();
}

Status from_json(td_api::setAuthenticationPremiumPurchaseTransaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.transaction_, from.extract_field("transaction")));
  TRY_STATUS(from_json(to.is_restore_, from.extract_field("is_restore")));
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  return Status::OK();
}

Status from_json(td_api::setBotUpdatesStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.pending_update_count_, from.extract_field("pending_update_count")));
  TRY_STATUS(from_json(to.error_message_, from.extract_field("error_message")));
  return Status::OK();
}

Status from_json(td_api::setBusinessLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  return Status::OK();
}

Status from_json(td_api::setChatClientData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.client_data_, from.extract_field("client_data")));
  return Status::OK();
}

Status from_json(td_api::setChatMessageSender &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_sender_id_, from.extract_field("message_sender_id")));
  return Status::OK();
}

Status from_json(td_api::setChatTitle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::setDefaultGroupAdministratorRights &to, JsonObject &from) {
  TRY_STATUS(from_json(to.default_group_administrator_rights_, from.extract_field("default_group_administrator_rights")));
  return Status::OK();
}

Status from_json(td_api::setGiftResalePrice &to, JsonObject &from) {
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.price_, from.extract_field("price")));
  return Status::OK();
}

Status from_json(td_api::setLogTagVerbosityLevel &to, JsonObject &from) {
  TRY_STATUS(from_json(to.tag_, from.extract_field("tag")));
  TRY_STATUS(from_json(to.new_verbosity_level_, from.extract_field("new_verbosity_level")));
  return Status::OK();
}

Status from_json(td_api::setName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  return Status::OK();
}

Status from_json(td_api::setPinnedChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::setReactionNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.notification_settings_, from.extract_field("notification_settings")));
  return Status::OK();
}

Status from_json(td_api::setStickerSetThumbnail &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.format_, from.extract_field("format")));
  return Status::OK();
}

Status from_json(td_api::setSupergroupUsername &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::setVideoChatDefaultParticipant &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.default_participant_id_, from.extract_field("default_participant_id")));
  return Status::OK();
}

Status from_json(td_api::stopBusinessPoll &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  return Status::OK();
}

Status from_json(td_api::testCallString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::testSquareInt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::toggleChatGiftNotifications &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.are_enabled_, from.extract_field("are_enabled")));
  return Status::OK();
}

Status from_json(td_api::toggleForumTopicIsPinned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.is_pinned_, from.extract_field("is_pinned")));
  return Status::OK();
}

Status from_json(td_api::toggleHasSponsoredMessagesEnabled &to, JsonObject &from) {
  TRY_STATUS(from_json(to.has_sponsored_messages_enabled_, from.extract_field("has_sponsored_messages_enabled")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupIsAllHistoryAvailable &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.is_all_history_available_, from.extract_field("is_all_history_available")));
  return Status::OK();
}

Status from_json(td_api::toggleVideoChatMuteNewParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.mute_new_participants_, from.extract_field("mute_new_participants")));
  return Status::OK();
}

Status from_json(td_api::unpinChatMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::viewVideoMessageAdvertisement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.advertisement_unique_id_, from.extract_field("advertisement_unique_id")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::address &object) {
  auto jo = jv.enter_object();
  jo("@type", "address");
  jo("country_code", object.country_code_);
  jo("state", object.state_);
  jo("city", object.city_);
  jo("street_line1", object.street_line1_);
  jo("street_line2", object.street_line2_);
  jo("postal_code", object.postal_code_);
}

void to_json(JsonValueScope &jv, const td_api::animation &object) {
  auto jo = jv.enter_object();
  jo("@type", "animation");
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
  jo("file_name", object.file_name_);
  jo("mime_type", object.mime_type_);
  jo("has_stickers", JsonBool{object.has_stickers_});
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::AuthorizationState &object) {
  td_api::downcast_call(const_cast<td_api::AuthorizationState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitTdlibParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitTdlibParameters");
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitPhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitPremiumPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitPremiumPurchase");
  jo("store_product_id", object.store_product_id_);
  jo("support_email_address", object.support_email_address_);
  jo("support_email_subject", object.support_email_subject_);
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitEmailAddress &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitEmailAddress");
  jo("allow_apple_id", JsonBool{object.allow_apple_id_});
  jo("allow_google_id", JsonBool{object.allow_google_id_});
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitEmailCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitEmailCode");
  jo("allow_apple_id", JsonBool{object.allow_apple_id_});
  jo("allow_google_id", JsonBool{object.allow_google_id_});
  if (object.code_info_) {
    jo("code_info", ToJson(*object.code_info_));
  }
  if (object.email_address_reset_state_) {
    jo("email_address_reset_state", ToJson(*object.email_address_reset_state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitCode");
  if (object.code_info_) {
    jo("code_info", ToJson(*object.code_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitOtherDeviceConfirmation &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitOtherDeviceConfirmation");
  jo("link", object.link_);
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitRegistration &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitRegistration");
  if (object.terms_of_service_) {
    jo("terms_of_service", ToJson(*object.terms_of_service_));
  }
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateWaitPassword &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateWaitPassword");
  jo("password_hint", object.password_hint_);
  jo("has_recovery_email_address", JsonBool{object.has_recovery_email_address_});
  jo("has_passport_data", JsonBool{object.has_passport_data_});
  jo("recovery_email_address_pattern", object.recovery_email_address_pattern_);
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateReady &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateReady");
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateLoggingOut &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateLoggingOut");
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateClosing &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateClosing");
}

void to_json(JsonValueScope &jv, const td_api::authorizationStateClosed &object) {
  auto jo = jv.enter_object();
  jo("@type", "authorizationStateClosed");
}

void to_json(JsonValueScope &jv, const td_api::availableReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "availableReactions");
  jo("top_reactions", ToJson(object.top_reactions_));
  jo("recent_reactions", ToJson(object.recent_reactions_));
  jo("popular_reactions", ToJson(object.popular_reactions_));
  jo("allow_custom_emoji", JsonBool{object.allow_custom_emoji_});
  jo("are_tags", JsonBool{object.are_tags_});
  if (object.unavailability_reason_) {
    jo("unavailability_reason", ToJson(*object.unavailability_reason_));
  }
}

void to_json(JsonValueScope &jv, const td_api::birthdate &object) {
  auto jo = jv.enter_object();
  jo("@type", "birthdate");
  jo("day", object.day_);
  jo("month", object.month_);
  jo("year", object.year_);
}

void to_json(JsonValueScope &jv, const td_api::botVerification &object) {
  auto jo = jv.enter_object();
  jo("@type", "botVerification");
  jo("bot_user_id", object.bot_user_id_);
  jo("icon_custom_emoji_id", ToJson(JsonInt64{object.icon_custom_emoji_id_}));
  if (object.custom_description_) {
    jo("custom_description", ToJson(*object.custom_description_));
  }
}

void to_json(JsonValueScope &jv, const td_api::businessChatLinkInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessChatLinkInfo");
  jo("chat_id", object.chat_id_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
}

void to_json(JsonValueScope &jv, const td_api::businessLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessLocation");
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  jo("address", object.address_);
}

void to_json(JsonValueScope &jv, const td_api::callId &object) {
  auto jo = jv.enter_object();
  jo("@type", "callId");
  jo("id", object.id_);
}

void to_json(JsonValueScope &jv, const td_api::CanSendMessageToUserResult &object) {
  td_api::downcast_call(const_cast<td_api::CanSendMessageToUserResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::canSendMessageToUserResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "canSendMessageToUserResultOk");
}

void to_json(JsonValueScope &jv, const td_api::canSendMessageToUserResultUserHasPaidMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "canSendMessageToUserResultUserHasPaidMessages");
  jo("outgoing_paid_message_star_count", object.outgoing_paid_message_star_count_);
}

void to_json(JsonValueScope &jv, const td_api::canSendMessageToUserResultUserIsDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "canSendMessageToUserResultUserIsDeleted");
}

void to_json(JsonValueScope &jv, const td_api::canSendMessageToUserResultUserRestrictsNewChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "canSendMessageToUserResultUserRestrictsNewChats");
}

void to_json(JsonValueScope &jv, const td_api::ChatAvailableReactions &object) {
  td_api::downcast_call(const_cast<td_api::ChatAvailableReactions &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatAvailableReactionsAll &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatAvailableReactionsAll");
  jo("max_reaction_count", object.max_reaction_count_);
}

void to_json(JsonValueScope &jv, const td_api::chatAvailableReactionsSome &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatAvailableReactionsSome");
  jo("reactions", ToJson(object.reactions_));
  jo("max_reaction_count", object.max_reaction_count_);
}

void to_json(JsonValueScope &jv, const td_api::ChatBoostSource &object) {
  td_api::downcast_call(const_cast<td_api::ChatBoostSource &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatBoostSourceGiftCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostSourceGiftCode");
  jo("user_id", object.user_id_);
  jo("gift_code", object.gift_code_);
}

void to_json(JsonValueScope &jv, const td_api::chatBoostSourceGiveaway &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostSourceGiveaway");
  jo("user_id", object.user_id_);
  jo("gift_code", object.gift_code_);
  jo("star_count", object.star_count_);
  jo("giveaway_message_id", object.giveaway_message_id_);
  jo("is_unclaimed", JsonBool{object.is_unclaimed_});
}

void to_json(JsonValueScope &jv, const td_api::chatBoostSourcePremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostSourcePremium");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatFolderInviteLinkInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolderInviteLinkInfo");
  if (object.chat_folder_info_) {
    jo("chat_folder_info", ToJson(*object.chat_folder_info_));
  }
  jo("missing_chat_ids", ToJson(object.missing_chat_ids_));
  jo("added_chat_ids", ToJson(object.added_chat_ids_));
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinkSubscriptionInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinkSubscriptionInfo");
  if (object.pricing_) {
    jo("pricing", ToJson(*object.pricing_));
  }
  jo("can_reuse", JsonBool{object.can_reuse_});
  jo("form_id", ToJson(JsonInt64{object.form_id_}));
}

void to_json(JsonValueScope &jv, const td_api::ChatMemberStatus &object) {
  td_api::downcast_call(const_cast<td_api::ChatMemberStatus &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatMemberStatusCreator &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMemberStatusCreator");
  jo("custom_title", object.custom_title_);
  jo("is_anonymous", JsonBool{object.is_anonymous_});
  jo("is_member", JsonBool{object.is_member_});
}

void to_json(JsonValueScope &jv, const td_api::chatMemberStatusAdministrator &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMemberStatusAdministrator");
  jo("custom_title", object.custom_title_);
  jo("can_be_edited", JsonBool{object.can_be_edited_});
  if (object.rights_) {
    jo("rights", ToJson(*object.rights_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatMemberStatusMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMemberStatusMember");
  jo("member_until_date", object.member_until_date_);
}

void to_json(JsonValueScope &jv, const td_api::chatMemberStatusRestricted &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMemberStatusRestricted");
  jo("is_member", JsonBool{object.is_member_});
  jo("restricted_until_date", object.restricted_until_date_);
  if (object.permissions_) {
    jo("permissions", ToJson(*object.permissions_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatMemberStatusLeft &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMemberStatusLeft");
}

void to_json(JsonValueScope &jv, const td_api::chatMemberStatusBanned &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMemberStatusBanned");
  jo("banned_until_date", object.banned_until_date_);
}

void to_json(JsonValueScope &jv, const td_api::ChatPhotoStickerType &object) {
  td_api::downcast_call(const_cast<td_api::ChatPhotoStickerType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatPhotoStickerTypeRegularOrMask &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPhotoStickerTypeRegularOrMask");
  jo("sticker_set_id", ToJson(JsonInt64{object.sticker_set_id_}));
  jo("sticker_id", ToJson(JsonInt64{object.sticker_id_}));
}

void to_json(JsonValueScope &jv, const td_api::chatPhotoStickerTypeCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPhotoStickerTypeCustomEmoji");
  jo("custom_emoji_id", ToJson(JsonInt64{object.custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::ChatStatistics &object) {
  td_api::downcast_call(const_cast<td_api::ChatStatistics &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsSupergroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsSupergroup");
  if (object.period_) {
    jo("period", ToJson(*object.period_));
  }
  if (object.member_count_) {
    jo("member_count", ToJson(*object.member_count_));
  }
  if (object.message_count_) {
    jo("message_count", ToJson(*object.message_count_));
  }
  if (object.viewer_count_) {
    jo("viewer_count", ToJson(*object.viewer_count_));
  }
  if (object.sender_count_) {
    jo("sender_count", ToJson(*object.sender_count_));
  }
  if (object.member_count_graph_) {
    jo("member_count_graph", ToJson(*object.member_count_graph_));
  }
  if (object.join_graph_) {
    jo("join_graph", ToJson(*object.join_graph_));
  }
  if (object.join_by_source_graph_) {
    jo("join_by_source_graph", ToJson(*object.join_by_source_graph_));
  }
  if (object.language_graph_) {
    jo("language_graph", ToJson(*object.language_graph_));
  }
  if (object.message_content_graph_) {
    jo("message_content_graph", ToJson(*object.message_content_graph_));
  }
  if (object.action_graph_) {
    jo("action_graph", ToJson(*object.action_graph_));
  }
  if (object.day_graph_) {
    jo("day_graph", ToJson(*object.day_graph_));
  }
  if (object.week_graph_) {
    jo("week_graph", ToJson(*object.week_graph_));
  }
  jo("top_senders", ToJson(object.top_senders_));
  jo("top_administrators", ToJson(object.top_administrators_));
  jo("top_inviters", ToJson(object.top_inviters_));
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsChannel &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsChannel");
  if (object.period_) {
    jo("period", ToJson(*object.period_));
  }
  if (object.member_count_) {
    jo("member_count", ToJson(*object.member_count_));
  }
  if (object.mean_message_view_count_) {
    jo("mean_message_view_count", ToJson(*object.mean_message_view_count_));
  }
  if (object.mean_message_share_count_) {
    jo("mean_message_share_count", ToJson(*object.mean_message_share_count_));
  }
  if (object.mean_message_reaction_count_) {
    jo("mean_message_reaction_count", ToJson(*object.mean_message_reaction_count_));
  }
  if (object.mean_story_view_count_) {
    jo("mean_story_view_count", ToJson(*object.mean_story_view_count_));
  }
  if (object.mean_story_share_count_) {
    jo("mean_story_share_count", ToJson(*object.mean_story_share_count_));
  }
  if (object.mean_story_reaction_count_) {
    jo("mean_story_reaction_count", ToJson(*object.mean_story_reaction_count_));
  }
  jo("enabled_notifications_percentage", object.enabled_notifications_percentage_);
  if (object.member_count_graph_) {
    jo("member_count_graph", ToJson(*object.member_count_graph_));
  }
  if (object.join_graph_) {
    jo("join_graph", ToJson(*object.join_graph_));
  }
  if (object.mute_graph_) {
    jo("mute_graph", ToJson(*object.mute_graph_));
  }
  if (object.view_count_by_hour_graph_) {
    jo("view_count_by_hour_graph", ToJson(*object.view_count_by_hour_graph_));
  }
  if (object.view_count_by_source_graph_) {
    jo("view_count_by_source_graph", ToJson(*object.view_count_by_source_graph_));
  }
  if (object.join_by_source_graph_) {
    jo("join_by_source_graph", ToJson(*object.join_by_source_graph_));
  }
  if (object.language_graph_) {
    jo("language_graph", ToJson(*object.language_graph_));
  }
  if (object.message_interaction_graph_) {
    jo("message_interaction_graph", ToJson(*object.message_interaction_graph_));
  }
  if (object.message_reaction_graph_) {
    jo("message_reaction_graph", ToJson(*object.message_reaction_graph_));
  }
  if (object.story_interaction_graph_) {
    jo("story_interaction_graph", ToJson(*object.story_interaction_graph_));
  }
  if (object.story_reaction_graph_) {
    jo("story_reaction_graph", ToJson(*object.story_reaction_graph_));
  }
  if (object.instant_view_interaction_graph_) {
    jo("instant_view_interaction_graph", ToJson(*object.instant_view_interaction_graph_));
  }
  jo("recent_interactions", ToJson(object.recent_interactions_));
}

void to_json(JsonValueScope &jv, const td_api::CheckChatUsernameResult &object) {
  td_api::downcast_call(const_cast<td_api::CheckChatUsernameResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::checkChatUsernameResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkChatUsernameResultOk");
}

void to_json(JsonValueScope &jv, const td_api::checkChatUsernameResultUsernameInvalid &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkChatUsernameResultUsernameInvalid");
}

void to_json(JsonValueScope &jv, const td_api::checkChatUsernameResultUsernameOccupied &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkChatUsernameResultUsernameOccupied");
}

void to_json(JsonValueScope &jv, const td_api::checkChatUsernameResultUsernamePurchasable &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkChatUsernameResultUsernamePurchasable");
}

void to_json(JsonValueScope &jv, const td_api::checkChatUsernameResultPublicChatsTooMany &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkChatUsernameResultPublicChatsTooMany");
}

void to_json(JsonValueScope &jv, const td_api::checkChatUsernameResultPublicGroupsUnavailable &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkChatUsernameResultPublicGroupsUnavailable");
}

void to_json(JsonValueScope &jv, const td_api::connectedWebsite &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectedWebsite");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("domain_name", object.domain_name_);
  jo("bot_user_id", object.bot_user_id_);
  jo("browser", object.browser_);
  jo("platform", object.platform_);
  jo("log_in_date", object.log_in_date_);
  jo("last_active_date", object.last_active_date_);
  jo("ip_address", object.ip_address_);
  jo("location", object.location_);
}

void to_json(JsonValueScope &jv, const td_api::customRequestResult &object) {
  auto jo = jv.enter_object();
  jo("@type", "customRequestResult");
  jo("result", object.result_);
}

void to_json(JsonValueScope &jv, const td_api::document &object) {
  auto jo = jv.enter_object();
  jo("@type", "document");
  jo("file_name", object.file_name_);
  jo("mime_type", object.mime_type_);
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
}

void to_json(JsonValueScope &jv, const td_api::emojiKeyword &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiKeyword");
  jo("emoji", object.emoji_);
  jo("keyword", object.keyword_);
}

void to_json(JsonValueScope &jv, const td_api::encryptedPassportElement &object) {
  auto jo = jv.enter_object();
  jo("@type", "encryptedPassportElement");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("data", base64_encode(object.data_));
  if (object.front_side_) {
    jo("front_side", ToJson(*object.front_side_));
  }
  if (object.reverse_side_) {
    jo("reverse_side", ToJson(*object.reverse_side_));
  }
  if (object.selfie_) {
    jo("selfie", ToJson(*object.selfie_));
  }
  jo("translation", ToJson(object.translation_));
  jo("files", ToJson(object.files_));
  jo("value", object.value_);
  jo("hash", object.hash_);
}

void to_json(JsonValueScope &jv, const td_api::FirebaseDeviceVerificationParameters &object) {
  td_api::downcast_call(const_cast<td_api::FirebaseDeviceVerificationParameters &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::firebaseDeviceVerificationParametersSafetyNet &object) {
  auto jo = jv.enter_object();
  jo("@type", "firebaseDeviceVerificationParametersSafetyNet");
  jo("nonce", base64_encode(object.nonce_));
}

void to_json(JsonValueScope &jv, const td_api::firebaseDeviceVerificationParametersPlayIntegrity &object) {
  auto jo = jv.enter_object();
  jo("@type", "firebaseDeviceVerificationParametersPlayIntegrity");
  jo("nonce", object.nonce_);
  jo("cloud_project_number", ToJson(JsonInt64{object.cloud_project_number_}));
}

void to_json(JsonValueScope &jv, const td_api::foundChatBoosts &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundChatBoosts");
  jo("total_count", object.total_count_);
  jo("boosts", ToJson(object.boosts_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::foundWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundWebApp");
  if (object.web_app_) {
    jo("web_app", ToJson(*object.web_app_));
  }
  jo("request_write_access", JsonBool{object.request_write_access_});
  jo("skip_confirmation", JsonBool{object.skip_confirmation_});
}

void to_json(JsonValueScope &jv, const td_api::giftForResale &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftForResale");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("received_gift_id", object.received_gift_id_);
}

void to_json(JsonValueScope &jv, const td_api::GiveawayInfo &object) {
  td_api::downcast_call(const_cast<td_api::GiveawayInfo &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::giveawayInfoOngoing &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayInfoOngoing");
  jo("creation_date", object.creation_date_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  jo("is_ended", JsonBool{object.is_ended_});
}

void to_json(JsonValueScope &jv, const td_api::giveawayInfoCompleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayInfoCompleted");
  jo("creation_date", object.creation_date_);
  jo("actual_winners_selection_date", object.actual_winners_selection_date_);
  jo("was_refunded", JsonBool{object.was_refunded_});
  jo("is_winner", JsonBool{object.is_winner_});
  jo("winner_count", object.winner_count_);
  jo("activation_count", object.activation_count_);
  jo("gift_code", object.gift_code_);
  jo("won_star_count", object.won_star_count_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallParticipant &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallParticipant");
  if (object.participant_id_) {
    jo("participant_id", ToJson(*object.participant_id_));
  }
  jo("audio_source_id", object.audio_source_id_);
  jo("screen_sharing_audio_source_id", object.screen_sharing_audio_source_id_);
  if (object.video_info_) {
    jo("video_info", ToJson(*object.video_info_));
  }
  if (object.screen_sharing_video_info_) {
    jo("screen_sharing_video_info", ToJson(*object.screen_sharing_video_info_));
  }
  jo("bio", object.bio_);
  jo("is_current_user", JsonBool{object.is_current_user_});
  jo("is_speaking", JsonBool{object.is_speaking_});
  jo("is_hand_raised", JsonBool{object.is_hand_raised_});
  jo("can_be_muted_for_all_users", JsonBool{object.can_be_muted_for_all_users_});
  jo("can_be_unmuted_for_all_users", JsonBool{object.can_be_unmuted_for_all_users_});
  jo("can_be_muted_for_current_user", JsonBool{object.can_be_muted_for_current_user_});
  jo("can_be_unmuted_for_current_user", JsonBool{object.can_be_unmuted_for_current_user_});
  jo("is_muted_for_all_users", JsonBool{object.is_muted_for_all_users_});
  jo("is_muted_for_current_user", JsonBool{object.is_muted_for_current_user_});
  jo("can_unmute_self", JsonBool{object.can_unmute_self_});
  jo("volume_level", object.volume_level_);
  jo("order", object.order_);
}

void to_json(JsonValueScope &jv, const td_api::identityDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "identityDocument");
  jo("number", object.number_);
  if (object.expiration_date_) {
    jo("expiration_date", ToJson(*object.expiration_date_));
  }
  if (object.front_side_) {
    jo("front_side", ToJson(*object.front_side_));
  }
  if (object.reverse_side_) {
    jo("reverse_side", ToJson(*object.reverse_side_));
  }
  if (object.selfie_) {
    jo("selfie", ToJson(*object.selfie_));
  }
  jo("translation", ToJson(object.translation_));
}

void to_json(JsonValueScope &jv, const td_api::inputChecklistTask &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputChecklistTask");
  jo("id", object.id_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
}

void to_json(JsonValueScope &jv, const td_api::InternalLinkType &object) {
  td_api::downcast_call(const_cast<td_api::InternalLinkType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeActiveSessions &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeActiveSessions");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeAttachmentMenuBot &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeAttachmentMenuBot");
  if (object.target_chat_) {
    jo("target_chat", ToJson(*object.target_chat_));
  }
  jo("bot_username", object.bot_username_);
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeAuthenticationCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeAuthenticationCode");
  jo("code", object.code_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBackground");
  jo("background_name", object.background_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBotAddToChannel &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBotAddToChannel");
  jo("bot_username", object.bot_username_);
  if (object.administrator_rights_) {
    jo("administrator_rights", ToJson(*object.administrator_rights_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBotStart &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBotStart");
  jo("bot_username", object.bot_username_);
  jo("start_parameter", object.start_parameter_);
  jo("autostart", JsonBool{object.autostart_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBotStartInGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBotStartInGroup");
  jo("bot_username", object.bot_username_);
  jo("start_parameter", object.start_parameter_);
  if (object.administrator_rights_) {
    jo("administrator_rights", ToJson(*object.administrator_rights_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBusinessChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBusinessChat");
  jo("link_name", object.link_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBuyStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBuyStars");
  jo("star_count", object.star_count_);
  jo("purpose", object.purpose_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChangePhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChangePhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatAffiliateProgram &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatAffiliateProgram");
  jo("username", object.username_);
  jo("referrer", object.referrer_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatBoost");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatFolderInvite &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatFolderInvite");
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatFolderSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatFolderSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatInvite &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatInvite");
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeDefaultMessageAutoDeleteTimerSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeDefaultMessageAutoDeleteTimerSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeDirectMessagesChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeDirectMessagesChat");
  jo("channel_username", object.channel_username_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeEditProfileSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeEditProfileSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeGame");
  jo("bot_username", object.bot_username_);
  jo("game_short_name", object.game_short_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeGiftCollection &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeGiftCollection");
  jo("gift_owner_username", object.gift_owner_username_);
  jo("collection_id", object.collection_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeGroupCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeGroupCall");
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeInstantView &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeInstantView");
  jo("url", object.url_);
  jo("fallback_url", object.fallback_url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeInvoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeInvoice");
  jo("invoice_name", object.invoice_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLanguagePack &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLanguagePack");
  jo("language_pack_id", object.language_pack_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLanguageSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLanguageSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLiveStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLiveStory");
  jo("story_poster_username", object.story_poster_username_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLoginEmailSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLoginEmailSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMainWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMainWebApp");
  jo("bot_username", object.bot_username_);
  jo("start_parameter", object.start_parameter_);
  if (object.mode_) {
    jo("mode", ToJson(*object.mode_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMessage");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMessageDraft &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMessageDraft");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("contains_link", JsonBool{object.contains_link_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMyStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMyStars");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMyToncoins &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMyToncoins");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePassportDataRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePassportDataRequest");
  jo("bot_user_id", object.bot_user_id_);
  jo("scope", object.scope_);
  jo("public_key", object.public_key_);
  jo("nonce", object.nonce_);
  jo("callback_url", object.callback_url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePasswordSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePasswordSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePhoneNumberConfirmation &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePhoneNumberConfirmation");
  jo("hash", object.hash_);
  jo("phone_number", object.phone_number_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePhoneNumberPrivacySettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePhoneNumberPrivacySettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePremiumFeatures &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePremiumFeatures");
  jo("referrer", object.referrer_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePremiumGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePremiumGift");
  jo("referrer", object.referrer_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePremiumGiftCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePremiumGiftCode");
  jo("code", object.code_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePrivacyAndSecuritySettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePrivacyAndSecuritySettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeProxy &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeProxy");
  jo("server", object.server_);
  jo("port", object.port_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePublicChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePublicChat");
  jo("chat_username", object.chat_username_);
  jo("draft_text", object.draft_text_);
  jo("open_profile", JsonBool{object.open_profile_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeQrCodeAuthentication &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeQrCodeAuthentication");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeRestorePurchases &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeRestorePurchases");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeStickerSet &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeStickerSet");
  jo("sticker_set_name", object.sticker_set_name_);
  jo("expect_custom_emoji", JsonBool{object.expect_custom_emoji_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeStory");
  jo("story_poster_username", object.story_poster_username_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeStoryAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeStoryAlbum");
  jo("story_album_owner_username", object.story_album_owner_username_);
  jo("story_album_id", object.story_album_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeTheme");
  jo("theme_name", object.theme_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeThemeSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeThemeSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUnknownDeepLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUnknownDeepLink");
  jo("link", object.link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUnsupportedProxy &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUnsupportedProxy");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUpgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUpgradedGift");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUserPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUserPhoneNumber");
  jo("phone_number", object.phone_number_);
  jo("draft_text", object.draft_text_);
  jo("open_profile", JsonBool{object.open_profile_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUserToken &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUserToken");
  jo("token", object.token_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeVideoChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeVideoChat");
  jo("chat_username", object.chat_username_);
  jo("invite_hash", object.invite_hash_);
  jo("is_live_stream", JsonBool{object.is_live_stream_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeWebApp");
  jo("bot_username", object.bot_username_);
  jo("web_app_short_name", object.web_app_short_name_);
  jo("start_parameter", object.start_parameter_);
  if (object.mode_) {
    jo("mode", ToJson(*object.mode_));
  }
}

void to_json(JsonValueScope &jv, const td_api::languagePackInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackInfo");
  jo("id", object.id_);
  jo("base_language_pack_id", object.base_language_pack_id_);
  jo("name", object.name_);
  jo("native_name", object.native_name_);
  jo("plural_code", object.plural_code_);
  jo("is_official", JsonBool{object.is_official_});
  jo("is_rtl", JsonBool{object.is_rtl_});
  jo("is_beta", JsonBool{object.is_beta_});
  jo("is_installed", JsonBool{object.is_installed_});
  jo("total_string_count", object.total_string_count_);
  jo("translated_string_count", object.translated_string_count_);
  jo("local_string_count", object.local_string_count_);
  jo("translation_url", object.translation_url_);
}

void to_json(JsonValueScope &jv, const td_api::localFile &object) {
  auto jo = jv.enter_object();
  jo("@type", "localFile");
  jo("path", object.path_);
  jo("can_be_downloaded", JsonBool{object.can_be_downloaded_});
  jo("can_be_deleted", JsonBool{object.can_be_deleted_});
  jo("is_downloading_active", JsonBool{object.is_downloading_active_});
  jo("is_downloading_completed", JsonBool{object.is_downloading_completed_});
  jo("download_offset", object.download_offset_);
  jo("downloaded_prefix_size", object.downloaded_prefix_size_);
  jo("downloaded_size", object.downloaded_size_);
}

void to_json(JsonValueScope &jv, const td_api::MaskPoint &object) {
  td_api::downcast_call(const_cast<td_api::MaskPoint &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::maskPointForehead &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointForehead");
}

void to_json(JsonValueScope &jv, const td_api::maskPointEyes &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointEyes");
}

void to_json(JsonValueScope &jv, const td_api::maskPointMouth &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointMouth");
}

void to_json(JsonValueScope &jv, const td_api::maskPointChin &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointChin");
}

void to_json(JsonValueScope &jv, const td_api::MessageEffectType &object) {
  td_api::downcast_call(const_cast<td_api::MessageEffectType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageEffectTypeEmojiReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageEffectTypeEmojiReaction");
  if (object.select_animation_) {
    jo("select_animation", ToJson(*object.select_animation_));
  }
  if (object.effect_animation_) {
    jo("effect_animation", ToJson(*object.effect_animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messageEffectTypePremiumSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageEffectTypePremiumSticker");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messagePositions &object) {
  auto jo = jv.enter_object();
  jo("@type", "messagePositions");
  jo("total_count", object.total_count_);
  jo("positions", ToJson(object.positions_));
}

void to_json(JsonValueScope &jv, const td_api::MessageSender &object) {
  td_api::downcast_call(const_cast<td_api::MessageSender &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageSenderUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSenderUser");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::messageSenderChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSenderChat");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::minithumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "minithumbnail");
  jo("width", object.width_);
  jo("height", object.height_);
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::notificationSound &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSound");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("duration", object.duration_);
  jo("date", object.date_);
  jo("title", object.title_);
  jo("data", object.data_);
  if (object.sound_) {
    jo("sound", ToJson(*object.sound_));
  }
}

void to_json(JsonValueScope &jv, const td_api::PageBlockHorizontalAlignment &object) {
  td_api::downcast_call(const_cast<td_api::PageBlockHorizontalAlignment &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHorizontalAlignmentLeft &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHorizontalAlignmentLeft");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHorizontalAlignmentCenter &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHorizontalAlignmentCenter");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHorizontalAlignmentRight &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHorizontalAlignmentRight");
}

void to_json(JsonValueScope &jv, const td_api::PassportElement &object) {
  td_api::downcast_call(const_cast<td_api::PassportElement &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::passportElementPersonalDetails &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementPersonalDetails");
  if (object.personal_details_) {
    jo("personal_details", ToJson(*object.personal_details_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementPassport &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementPassport");
  if (object.passport_) {
    jo("passport", ToJson(*object.passport_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementDriverLicense &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementDriverLicense");
  if (object.driver_license_) {
    jo("driver_license", ToJson(*object.driver_license_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementIdentityCard &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementIdentityCard");
  if (object.identity_card_) {
    jo("identity_card", ToJson(*object.identity_card_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementInternalPassport &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementInternalPassport");
  if (object.internal_passport_) {
    jo("internal_passport", ToJson(*object.internal_passport_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementAddress &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementAddress");
  if (object.address_) {
    jo("address", ToJson(*object.address_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementUtilityBill &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementUtilityBill");
  if (object.utility_bill_) {
    jo("utility_bill", ToJson(*object.utility_bill_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementBankStatement &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementBankStatement");
  if (object.bank_statement_) {
    jo("bank_statement", ToJson(*object.bank_statement_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementRentalAgreement &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementRentalAgreement");
  if (object.rental_agreement_) {
    jo("rental_agreement", ToJson(*object.rental_agreement_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementPassportRegistration &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementPassportRegistration");
  if (object.passport_registration_) {
    jo("passport_registration", ToJson(*object.passport_registration_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementTemporaryRegistration &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementTemporaryRegistration");
  if (object.temporary_registration_) {
    jo("temporary_registration", ToJson(*object.temporary_registration_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementPhoneNumber");
  jo("phone_number", object.phone_number_);
}

void to_json(JsonValueScope &jv, const td_api::passportElementEmailAddress &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementEmailAddress");
  jo("email_address", object.email_address_);
}

void to_json(JsonValueScope &jv, const td_api::paymentForm &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentForm");
  jo("id", ToJson(JsonInt64{object.id_}));
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("seller_bot_user_id", object.seller_bot_user_id_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::phoneNumberInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "phoneNumberInfo");
  if (object.country_) {
    jo("country", ToJson(*object.country_));
  }
  jo("country_calling_code", object.country_calling_code_);
  jo("formatted_phone_number", object.formatted_phone_number_);
  jo("is_anonymous", JsonBool{object.is_anonymous_});
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatures &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatures");
  jo("features", ToJson(object.features_));
  jo("limits", ToJson(object.limits_));
  if (object.payment_link_) {
    jo("payment_link", ToJson(*object.payment_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::premiumState &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumState");
  if (object.state_) {
    jo("state", ToJson(*object.state_));
  }
  jo("payment_options", ToJson(object.payment_options_));
  jo("animations", ToJson(object.animations_));
  jo("business_animations", ToJson(object.business_animations_));
}

void to_json(JsonValueScope &jv, const td_api::ProfileTab &object) {
  td_api::downcast_call(const_cast<td_api::ProfileTab &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::profileTabPosts &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabPosts");
}

void to_json(JsonValueScope &jv, const td_api::profileTabGifts &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabGifts");
}

void to_json(JsonValueScope &jv, const td_api::profileTabMedia &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabMedia");
}

void to_json(JsonValueScope &jv, const td_api::profileTabFiles &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabFiles");
}

void to_json(JsonValueScope &jv, const td_api::profileTabLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabLinks");
}

void to_json(JsonValueScope &jv, const td_api::profileTabMusic &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabMusic");
}

void to_json(JsonValueScope &jv, const td_api::profileTabVoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabVoice");
}

void to_json(JsonValueScope &jv, const td_api::profileTabGifs &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileTabGifs");
}

void to_json(JsonValueScope &jv, const td_api::quickReplyMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "quickReplyMessage");
  jo("id", object.id_);
  if (object.sending_state_) {
    jo("sending_state", ToJson(*object.sending_state_));
  }
  jo("can_be_edited", JsonBool{object.can_be_edited_});
  jo("reply_to_message_id", object.reply_to_message_id_);
  jo("via_bot_user_id", object.via_bot_user_id_);
  jo("media_album_id", ToJson(JsonInt64{object.media_album_id_}));
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
  if (object.reply_markup_) {
    jo("reply_markup", ToJson(*object.reply_markup_));
  }
}

void to_json(JsonValueScope &jv, const td_api::receivedGifts &object) {
  auto jo = jv.enter_object();
  jo("@type", "receivedGifts");
  jo("total_count", object.total_count_);
  jo("gifts", ToJson(object.gifts_));
  jo("are_notifications_enabled", JsonBool{object.are_notifications_enabled_});
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::ReportStoryResult &object) {
  td_api::downcast_call(const_cast<td_api::ReportStoryResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::reportStoryResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportStoryResultOk");
}

void to_json(JsonValueScope &jv, const td_api::reportStoryResultOptionRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportStoryResultOptionRequired");
  jo("title", object.title_);
  jo("options", ToJson(object.options_));
}

void to_json(JsonValueScope &jv, const td_api::reportStoryResultTextRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportStoryResultTextRequired");
  jo("option_id", base64_encode(object.option_id_));
  jo("is_optional", JsonBool{object.is_optional_});
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTopic &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTopic");
  jo("id", object.id_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
  jo("order", ToJson(JsonInt64{object.order_}));
  if (object.last_message_) {
    jo("last_message", ToJson(*object.last_message_));
  }
  if (object.draft_message_) {
    jo("draft_message", ToJson(*object.draft_message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::session &object) {
  auto jo = jv.enter_object();
  jo("@type", "session");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("is_current", JsonBool{object.is_current_});
  jo("is_password_pending", JsonBool{object.is_password_pending_});
  jo("is_unconfirmed", JsonBool{object.is_unconfirmed_});
  jo("can_accept_secret_chats", JsonBool{object.can_accept_secret_chats_});
  jo("can_accept_calls", JsonBool{object.can_accept_calls_});
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("api_id", object.api_id_);
  jo("application_name", object.application_name_);
  jo("application_version", object.application_version_);
  jo("is_official_application", JsonBool{object.is_official_application_});
  jo("device_model", object.device_model_);
  jo("platform", object.platform_);
  jo("system_version", object.system_version_);
  jo("log_in_date", object.log_in_date_);
  jo("last_active_date", object.last_active_date_);
  jo("ip_address", object.ip_address_);
  jo("location", object.location_);
}

void to_json(JsonValueScope &jv, const td_api::sponsoredMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "sponsoredMessage");
  jo("message_id", object.message_id_);
  jo("is_recommended", JsonBool{object.is_recommended_});
  jo("can_be_reported", JsonBool{object.can_be_reported_});
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
  if (object.sponsor_) {
    jo("sponsor", ToJson(*object.sponsor_));
  }
  jo("title", object.title_);
  jo("button_text", object.button_text_);
  jo("accent_color_id", object.accent_color_id_);
  jo("background_custom_emoji_id", ToJson(JsonInt64{object.background_custom_emoji_id_}));
  jo("additional_info", object.additional_info_);
}

void to_json(JsonValueScope &jv, const td_api::starRevenueStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "starRevenueStatistics");
  if (object.revenue_by_day_graph_) {
    jo("revenue_by_day_graph", ToJson(*object.revenue_by_day_graph_));
  }
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  jo("usd_rate", object.usd_rate_);
}

void to_json(JsonValueScope &jv, const td_api::StartLiveStoryResult &object) {
  td_api::downcast_call(const_cast<td_api::StartLiveStoryResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::startLiveStoryResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "startLiveStoryResultOk");
  if (object.story_) {
    jo("story", ToJson(*object.story_));
  }
}

void to_json(JsonValueScope &jv, const td_api::startLiveStoryResultFail &object) {
  auto jo = jv.enter_object();
  jo("@type", "startLiveStoryResultFail");
  if (object.error_type_) {
    jo("error_type", ToJson(*object.error_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::StickerType &object) {
  td_api::downcast_call(const_cast<td_api::StickerType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::stickerTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerTypeRegular");
}

void to_json(JsonValueScope &jv, const td_api::stickerTypeMask &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerTypeMask");
}

void to_json(JsonValueScope &jv, const td_api::stickerTypeCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerTypeCustomEmoji");
}

void to_json(JsonValueScope &jv, const td_api::storyAlbums &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyAlbums");
  jo("albums", ToJson(object.albums_));
}

void to_json(JsonValueScope &jv, const td_api::storyInteractions &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteractions");
  jo("total_count", object.total_count_);
  jo("total_forward_count", object.total_forward_count_);
  jo("total_reaction_count", object.total_reaction_count_);
  jo("interactions", ToJson(object.interactions_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::SuggestedPostPrice &object) {
  td_api::downcast_call(const_cast<td_api::SuggestedPostPrice &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostPriceStar &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostPriceStar");
  jo("star_count", object.star_count_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostPriceTon &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostPriceTon");
  jo("toncoin_cent_count", object.toncoin_cent_count_);
}

void to_json(JsonValueScope &jv, const td_api::targetChatTypes &object) {
  auto jo = jv.enter_object();
  jo("@type", "targetChatTypes");
  jo("allow_user_chats", JsonBool{object.allow_user_chats_});
  jo("allow_bot_chats", JsonBool{object.allow_bot_chats_});
  jo("allow_group_chats", JsonBool{object.allow_group_chats_});
  jo("allow_channel_chats", JsonBool{object.allow_channel_chats_});
}

void to_json(JsonValueScope &jv, const td_api::testVectorStringObject &object) {
  auto jo = jv.enter_object();
  jo("@type", "testVectorStringObject");
  jo("value", ToJson(object.value_));
}

void to_json(JsonValueScope &jv, const td_api::timeZone &object) {
  auto jo = jv.enter_object();
  jo("@type", "timeZone");
  jo("id", object.id_);
  jo("name", object.name_);
  jo("utc_time_offset", object.utc_time_offset_);
}

void to_json(JsonValueScope &jv, const td_api::unreadReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "unreadReaction");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("is_big", JsonBool{object.is_big_});
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftModel &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftModel");
  jo("name", object.name_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  jo("rarity_per_mille", object.rarity_per_mille_);
}

void to_json(JsonValueScope &jv, const td_api::userLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "userLink");
  jo("url", object.url_);
  jo("expires_in", object.expires_in_);
}

void to_json(JsonValueScope &jv, const td_api::users &object) {
  auto jo = jv.enter_object();
  jo("@type", "users");
  jo("total_count", object.total_count_);
  jo("user_ids", ToJson(object.user_ids_));
}

void to_json(JsonValueScope &jv, const td_api::videoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "videoNote");
  jo("duration", object.duration_);
  jo("waveform", base64_encode(object.waveform_));
  jo("length", object.length_);
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.speech_recognition_result_) {
    jo("speech_recognition_result", ToJson(*object.speech_recognition_result_));
  }
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
}

}  // namespace td_api
}  // namespace td
