#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::BackgroundFill *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"backgroundFillSolid", 1010678813},
    {"backgroundFillGradient", -1839206017},
    {"backgroundFillFreeformGradient", -1145469255}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatAvailableReactions *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatAvailableReactionsAll", 694160279},
    {"chatAvailableReactionsSome", 152513153}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::EmojiStatusType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"emojiStatusTypeCustomEmoji", -1666780939},
    {"emojiStatusTypeUpgradedGift", -837921804}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputBackground *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputBackgroundLocal", -1747094364},
    {"inputBackgroundRemote", -274976231},
    {"inputBackgroundPrevious", -351905954}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputMessageReplyTo *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputMessageReplyToMessage", -782038760},
    {"inputMessageReplyToExternalMessage", -505276703},
    {"inputMessageReplyToStory", -1723842320}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::LanguagePackStringValue *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"languagePackStringValueOrdinary", -249256352},
    {"languagePackStringValuePluralized", 1906840261},
    {"languagePackStringValueDeleted", 1834792698}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::NetworkType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"networkTypeNone", -1971691759},
    {"networkTypeMobile", 819228239},
    {"networkTypeMobileRoaming", -1435199760},
    {"networkTypeWiFi", -633872070},
    {"networkTypeOther", 1942128539}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PremiumSource *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"premiumSourceLimitExceeded", -2052159742},
    {"premiumSourceFeature", 445813541},
    {"premiumSourceBusinessFeature", -1492946340},
    {"premiumSourceStoryFeature", -1030737556},
    {"premiumSourceLink", 2135071132},
    {"premiumSourceSettings", -285702859}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ResendCodeReason *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"resendCodeReasonUserRequest", -441923456},
    {"resendCodeReasonVerificationFailed", 529870273}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::SuggestedAction *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"suggestedActionEnableArchiveAndMuteNewChats", 2017586255},
    {"suggestedActionCheckPassword", 1910534839},
    {"suggestedActionCheckPhoneNumber", 648771563},
    {"suggestedActionViewChecksHint", 891303239},
    {"suggestedActionConvertToBroadcastGroup", -965071304},
    {"suggestedActionSetPassword", 1863613848},
    {"suggestedActionUpgradePremium", 1890220539},
    {"suggestedActionRestorePremium", -385229468},
    {"suggestedActionSubscribeToAnnualPremium", 373913787},
    {"suggestedActionGiftPremiumForChristmas", -1816924561},
    {"suggestedActionSetBirthdate", -356672766},
    {"suggestedActionSetProfilePhoto", -1612563093},
    {"suggestedActionExtendPremium", -566207286},
    {"suggestedActionExtendStarSubscriptions", -47000234},
    {"suggestedActionCustom", 2092876611},
    {"suggestedActionSetLoginEmailAddress", 1557625160}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::UpgradedGiftAttributeId *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"upgradedGiftAttributeIdModel", 1053287307},
    {"upgradedGiftAttributeIdSymbol", 1188205608},
    {"upgradedGiftAttributeIdBackdrop", 1461997935}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::affiliateProgramSortOrderCreationDate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::autosaveSettingsScopeChannelChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::birthdate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.day_, from.extract_field("day")));
  TRY_STATUS(from_json(to.month_, from.extract_field("month")));
  TRY_STATUS(from_json(to.year_, from.extract_field("year")));
  return Status::OK();
}

Status from_json(td_api::botCommandScopeChatAdministrators &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::businessFeatureLocation &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessFeatureChatFolderTags &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callProblemInterruptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callbackQueryPayloadDataWithPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::chatActionChoosingSticker &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatAvailableReactionsAll &to, JsonObject &from) {
  TRY_STATUS(from_json(to.max_reaction_count_, from.extract_field("max_reaction_count")));
  return Status::OK();
}

Status from_json(td_api::chatListArchive &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatPhotoSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.background_fill_, from.extract_field("background_fill")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenApplePushVoIP &to, JsonObject &from) {
  TRY_STATUS(from_json(to.device_token_, from.extract_field("device_token")));
  TRY_STATUS(from_json(to.is_app_sandbox_, from.extract_field("is_app_sandbox")));
  TRY_STATUS(from_json(to.encrypt_, from.extract_field("encrypt")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenHuaweiPush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  TRY_STATUS(from_json(to.encrypt_, from.extract_field("encrypt")));
  return Status::OK();
}

Status from_json(td_api::emojiStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.expiration_date_, from.extract_field("expiration_date")));
  return Status::OK();
}

Status from_json(td_api::fileTypePhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeSelfDestructingVoiceNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::firebaseAuthenticationSettingsAndroid &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::giftSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.show_gift_button_, from.extract_field("show_gift_button")));
  TRY_STATUS(from_json(to.accepted_gift_types_, from.extract_field("accepted_gift_types")));
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButton &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::inputBusinessStartPage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.message_, from.extract_field("message")));
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::inputCredentialsSaved &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_credentials_id_, from.extract_field("saved_credentials_id")));
  return Status::OK();
}

Status from_json(td_api::inputGroupCallMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultPhoto &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.photo_url_, from.extract_field("photo_url")));
  TRY_STATUS(from_json(to.photo_width_, from.extract_field("photo_width")));
  TRY_STATUS(from_json(to.photo_height_, from.extract_field("photo_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessageAnimation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.animation_, from.extract_field("animation")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.added_sticker_file_ids_, from.extract_field("added_sticker_file_ids")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json(to.width_, from.extract_field("width")));
  TRY_STATUS(from_json(to.height_, from.extract_field("height")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.show_caption_above_media_, from.extract_field("show_caption_above_media")));
  TRY_STATUS(from_json(to.has_spoiler_, from.extract_field("has_spoiler")));
  return Status::OK();
}

Status from_json(td_api::inputMessageLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.live_period_, from.extract_field("live_period")));
  TRY_STATUS(from_json(to.heading_, from.extract_field("heading")));
  TRY_STATUS(from_json(to.proximity_alert_radius_, from.extract_field("proximity_alert_radius")));
  return Status::OK();
}

Status from_json(td_api::inputMessageForwarded &to, JsonObject &from) {
  TRY_STATUS(from_json(to.from_chat_id_, from.extract_field("from_chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.in_game_share_, from.extract_field("in_game_share")));
  TRY_STATUS(from_json(to.replace_video_start_timestamp_, from.extract_field("replace_video_start_timestamp")));
  TRY_STATUS(from_json(to.new_video_start_timestamp_, from.extract_field("new_video_start_timestamp")));
  TRY_STATUS(from_json(to.copy_options_, from.extract_field("copy_options")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementDriverLicense &to, JsonObject &from) {
  TRY_STATUS(from_json(to.driver_license_, from.extract_field("driver_license")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementPhoneNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceTranslationFiles &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.file_hashes_, from.extract_field("file_hashes")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeSuggestedReaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  TRY_STATUS(from_json(to.is_dark_, from.extract_field("is_dark")));
  TRY_STATUS(from_json(to.is_flipped_, from.extract_field("is_flipped")));
  return Status::OK();
}

Status from_json(td_api::inputTextQuote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.position_, from.extract_field("position")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeBusinessChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_name_, from.extract_field("link_name")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeDirectMessagesChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.channel_username_, from.extract_field("channel_username")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeLiveStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_username_, from.extract_field("story_poster_username")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePhoneNumberConfirmation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.hash_, from.extract_field("hash")));
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeRestorePurchases &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeUpgradedGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::jsonValueNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeRequestUsers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.restrict_user_is_bot_, from.extract_field("restrict_user_is_bot")));
  TRY_STATUS(from_json(to.user_is_bot_, from.extract_field("user_is_bot")));
  TRY_STATUS(from_json(to.restrict_user_is_premium_, from.extract_field("restrict_user_is_premium")));
  TRY_STATUS(from_json(to.user_is_premium_, from.extract_field("user_is_premium")));
  TRY_STATUS(from_json(to.max_quantity_, from.extract_field("max_quantity")));
  TRY_STATUS(from_json(to.request_name_, from.extract_field("request_name")));
  TRY_STATUS(from_json(to.request_username_, from.extract_field("request_username")));
  TRY_STATUS(from_json(to.request_photo_, from.extract_field("request_photo")));
  return Status::OK();
}

Status from_json(td_api::linkPreviewOptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_disabled_, from.extract_field("is_disabled")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.force_small_media_, from.extract_field("force_small_media")));
  TRY_STATUS(from_json(to.force_large_media_, from.extract_field("force_large_media")));
  TRY_STATUS(from_json(to.show_above_text_, from.extract_field("show_above_text")));
  return Status::OK();
}

Status from_json(td_api::maskPointChin &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageSendOptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.suggested_post_info_, from.extract_field("suggested_post_info")));
  TRY_STATUS(from_json(to.disable_notification_, from.extract_field("disable_notification")));
  TRY_STATUS(from_json(to.from_background_, from.extract_field("from_background")));
  TRY_STATUS(from_json(to.protect_content_, from.extract_field("protect_content")));
  TRY_STATUS(from_json(to.allow_paid_broadcast_, from.extract_field("allow_paid_broadcast")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  TRY_STATUS(from_json(to.update_order_of_installed_sticker_sets_, from.extract_field("update_order_of_installed_sticker_sets")));
  TRY_STATUS(from_json(to.scheduling_state_, from.extract_field("scheduling_state")));
  TRY_STATUS(from_json(to.effect_id_, from.extract_field("effect_id")));
  TRY_STATUS(from_json(to.sending_id_, from.extract_field("sending_id")));
  TRY_STATUS(from_json(to.only_preview_, from.extract_field("only_preview")));
  return Status::OK();
}

Status from_json(td_api::messageSourceSearch &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkStatisticsEntryFile &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_type_, from.extract_field("file_type")));
  TRY_STATUS(from_json(to.network_type_, from.extract_field("network_type")));
  TRY_STATUS(from_json(to.sent_bytes_, from.extract_field("sent_bytes")));
  TRY_STATUS(from_json(to.received_bytes_, from.extract_field("received_bytes")));
  return Status::OK();
}

Status from_json(td_api::notificationSettingsScopeGroupChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::paidReactionTypeChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::passportElementTypeRentalAgreement &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::phoneNumberCodeTypeConfirmOwnership &to, JsonObject &from) {
  TRY_STATUS(from_json(to.hash_, from.extract_field("hash")));
  return Status::OK();
}

Status from_json(td_api::premiumFeatureUniqueStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureUpgradedStories &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureChecklists &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypePinnedSavedMessagesTopicCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeStorySuggestedReactionAreaCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeatureStealthMode &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabFiles &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::publicChatTypeIsLocationBased &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::replyMarkupRemoveKeyboard &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  return Status::OK();
}

Status from_json(td_api::reportReasonUnrelatedLocation &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesChatTypeFilterPrivate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterVoiceNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterFailedToSend &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::stickerTypeCustomEmoji &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::storeTransactionGooglePlay &to, JsonObject &from) {
  TRY_STATUS(from_json(to.package_name_, from.extract_field("package_name")));
  TRY_STATUS(from_json(to.store_product_id_, from.extract_field("store_product_id")));
  TRY_STATUS(from_json(to.purchase_token_, from.extract_field("purchase_token")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionEnableArchiveAndMuteNewChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionGiftPremiumForChristmas &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterRecent &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::targetChatChosen &to, JsonObject &from) {
  TRY_STATUS(from_json(to.types_, from.extract_field("types")));
  return Status::OK();
}

Status from_json(td_api::telegramPaymentPurposeJoinChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypeEmailAddress &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypePre &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textParseModeHTML &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::topChatCategoryForwardChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowLinkInForwardedMessages &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictAll &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::webAppOpenModeFullScreen &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::addChatToList &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  return Status::OK();
}

Status from_json(td_api::addMessageReaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  TRY_STATUS(from_json(to.is_big_, from.extract_field("is_big")));
  TRY_STATUS(from_json(to.update_recent_reactions_, from.extract_field("update_recent_reactions")));
  return Status::OK();
}

Status from_json(td_api::addQuickReplyShortcutMessageAlbum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_name_, from.extract_field("shortcut_name")));
  TRY_STATUS(from_json(to.reply_to_message_id_, from.extract_field("reply_to_message_id")));
  TRY_STATUS(from_json(to.input_message_contents_, from.extract_field("input_message_contents")));
  return Status::OK();
}

Status from_json(td_api::answerCallbackQuery &to, JsonObject &from) {
  TRY_STATUS(from_json(to.callback_query_id_, from.extract_field("callback_query_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.show_alert_, from.extract_field("show_alert")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.cache_time_, from.extract_field("cache_time")));
  return Status::OK();
}

Status from_json(td_api::banChatMember &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.member_id_, from.extract_field("member_id")));
  TRY_STATUS(from_json(to.banned_until_date_, from.extract_field("banned_until_date")));
  TRY_STATUS(from_json(to.revoke_messages_, from.extract_field("revoke_messages")));
  return Status::OK();
}

Status from_json(td_api::canSendMessageToUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::checkEmailAddressVerificationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::cleanFileName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_name_, from.extract_field("file_name")));
  return Status::OK();
}

Status from_json(td_api::clickAnimatedEmojiMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::commitPendingLiveStoryReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::createChatFolderInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::createNewStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.needs_repainting_, from.extract_field("needs_repainting")));
  TRY_STATUS(from_json(to.stickers_, from.extract_field("stickers")));
  TRY_STATUS(from_json(to.source_, from.extract_field("source")));
  return Status::OK();
}

Status from_json(td_api::declineSuggestedPost &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.comment_, from.extract_field("comment")));
  return Status::OK();
}

Status from_json(td_api::deleteBusinessStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::deleteCommands &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  return Status::OK();
}

Status from_json(td_api::deleteLanguagePack &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedMessagesTopicMessagesByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.min_date_, from.extract_field("min_date")));
  TRY_STATUS(from_json(to.max_date_, from.extract_field("max_date")));
  return Status::OK();
}

Status from_json(td_api::disconnectAffiliateProgram &to, JsonObject &from) {
  TRY_STATUS(from_json(to.affiliate_, from.extract_field("affiliate")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageLiveLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.live_period_, from.extract_field("live_period")));
  TRY_STATUS(from_json(to.heading_, from.extract_field("heading")));
  TRY_STATUS(from_json(to.proximity_alert_radius_, from.extract_field("proximity_alert_radius")));
  return Status::OK();
}

Status from_json(td_api::editCustomLanguagePackInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.info_, from.extract_field("info")));
  return Status::OK();
}

Status from_json(td_api::editMessageLiveLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.live_period_, from.extract_field("live_period")));
  TRY_STATUS(from_json(to.heading_, from.extract_field("heading")));
  TRY_STATUS(from_json(to.proximity_alert_radius_, from.extract_field("proximity_alert_radius")));
  return Status::OK();
}

Status from_json(td_api::editStoryCover &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.cover_frame_timestamp_, from.extract_field("cover_frame_timestamp")));
  return Status::OK();
}

Status from_json(td_api::getAccountTtl &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAttachedStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::getBasicGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.basic_group_id_, from.extract_field("basic_group_id")));
  return Status::OK();
}

Status from_json(td_api::getBotSimilarBots &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::getChatFolderNewChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getChatMessageByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  return Status::OK();
}

Status from_json(td_api::getChatRevenueWithdrawalUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDatabaseStatistics &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDirectMessagesChatTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getFavoriteStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getForumTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_date_, from.extract_field("offset_date")));
  TRY_STATUS(from_json(to.offset_message_id_, from.extract_field("offset_message_id")));
  TRY_STATUS(from_json(to.offset_forum_topic_id_, from.extract_field("offset_forum_topic_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getGroupCallParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.input_group_call_, from.extract_field("input_group_call")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getInstalledStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  return Status::OK();
}

Status from_json(td_api::getLinkPreview &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.link_preview_options_, from.extract_field("link_preview_options")));
  return Status::OK();
}

Status from_json(td_api::getLogVerbosityLevel &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getMessageAddedReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getMessageLocally &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getNetworkStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.only_current_, from.extract_field("only_current")));
  return Status::OK();
}

Status from_json(td_api::getPasswordState &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getPremiumGiveawayPaymentOptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.boosted_chat_id_, from.extract_field("boosted_chat_id")));
  return Status::OK();
}

Status from_json(td_api::getPublicPostSearchLimits &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::getRecentlyVisitedTMeUrls &to, JsonObject &from) {
  TRY_STATUS(from_json(to.referrer_, from.extract_field("referrer")));
  return Status::OK();
}

Status from_json(td_api::getSavedMessagesTopicMessageByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  return Status::OK();
}

Status from_json(td_api::getStarGiftPaymentOptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getStickerOutline &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_file_id_, from.extract_field("sticker_file_id")));
  TRY_STATUS(from_json(to.for_animated_emoji_, from.extract_field("for_animated_emoji")));
  TRY_STATUS(from_json(to.for_clicked_animated_emoji_message_, from.extract_field("for_clicked_animated_emoji_message")));
  return Status::OK();
}

Status from_json(td_api::getStoryInteractions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.only_contacts_, from.extract_field("only_contacts")));
  TRY_STATUS(from_json(to.prefer_forwards_, from.extract_field("prefer_forwards")));
  TRY_STATUS(from_json(to.prefer_with_reaction_, from.extract_field("prefer_with_reaction")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSupergroupFullInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::getTimeZones &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUpgradedGiftWithdrawalUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getVideoChatAvailableParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::hideContactCloseBirthdays &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::joinChatByInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::loadDirectMessagesChatTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::openChatSimilarChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.opened_chat_id_, from.extract_field("opened_chat_id")));
  return Status::OK();
}

Status from_json(td_api::pingProxy &to, JsonObject &from) {
  TRY_STATUS(from_json(to.proxy_id_, from.extract_field("proxy_id")));
  return Status::OK();
}

Status from_json(td_api::readAllChatReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::recoverAuthenticationPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.recovery_code_, from.extract_field("recovery_code")));
  TRY_STATUS(from_json(to.new_password_, from.extract_field("new_password")));
  TRY_STATUS(from_json(to.new_hint_, from.extract_field("new_hint")));
  return Status::OK();
}

Status from_json(td_api::removeFavoriteSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::removePendingPaidMessageReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::removeStickerFromSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::reorderInstalledStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.sticker_set_ids_, from.extract_field("sticker_set_ids")));
  return Status::OK();
}

Status from_json(td_api::reportAuthenticationCodeMissing &to, JsonObject &from) {
  TRY_STATUS(from_json(to.mobile_network_code_, from.extract_field("mobile_network_code")));
  return Status::OK();
}

Status from_json(td_api::reportSupergroupSpam &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  return Status::OK();
}

Status from_json(td_api::resendPhoneNumberCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reason_, from.extract_field("reason")));
  return Status::OK();
}

Status from_json(td_api::revokeGroupCallInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::searchChatRecentLocationMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  TRY_STATUS(from_json(to.chat_type_filter_, from.extract_field("chat_type_filter")));
  TRY_STATUS(from_json(to.min_date_, from.extract_field("min_date")));
  TRY_STATUS(from_json(to.max_date_, from.extract_field("max_date")));
  return Status::OK();
}

Status from_json(td_api::searchQuote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.quote_, from.extract_field("quote")));
  TRY_STATUS(from_json(to.quote_position_, from.extract_field("quote_position")));
  return Status::OK();
}

Status from_json(td_api::searchUserByToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::sendCallRating &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json(to.rating_, from.extract_field("rating")));
  TRY_STATUS(from_json(to.comment_, from.extract_field("comment")));
  TRY_STATUS(from_json(to.problems_, from.extract_field("problems")));
  return Status::OK();
}

Status from_json(td_api::sendMessageAlbum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  TRY_STATUS(from_json(to.input_message_contents_, from.extract_field("input_message_contents")));
  return Status::OK();
}

Status from_json(td_api::sendWebAppData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.button_text_, from.extract_field("button_text")));
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::setAutoDownloadSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAccountBio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.bio_, from.extract_field("bio")));
  return Status::OK();
}

Status from_json(td_api::setBusinessMessageIsPinned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.is_pinned_, from.extract_field("is_pinned")));
  return Status::OK();
}

Status from_json(td_api::setChatDescription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  return Status::OK();
}

Status from_json(td_api::setChatNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.notification_settings_, from.extract_field("notification_settings")));
  return Status::OK();
}

Status from_json(td_api::setCloseFriends &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::setDefaultMessageAutoDeleteTime &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_auto_delete_time_, from.extract_field("message_auto_delete_time")));
  return Status::OK();
}

Status from_json(td_api::setGiftSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setLogVerbosityLevel &to, JsonObject &from) {
  TRY_STATUS(from_json(to.new_verbosity_level_, from.extract_field("new_verbosity_level")));
  return Status::OK();
}

Status from_json(td_api::setNetworkType &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::setPinnedForumTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_ids_, from.extract_field("forum_topic_ids")));
  return Status::OK();
}

Status from_json(td_api::setReadDatePrivacySettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setStickerSetTitle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::setTdlibParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.use_test_dc_, from.extract_field("use_test_dc")));
  TRY_STATUS(from_json(to.database_directory_, from.extract_field("database_directory")));
  TRY_STATUS(from_json(to.files_directory_, from.extract_field("files_directory")));
  TRY_STATUS(from_json_bytes(to.database_encryption_key_, from.extract_field("database_encryption_key")));
  TRY_STATUS(from_json(to.use_file_database_, from.extract_field("use_file_database")));
  TRY_STATUS(from_json(to.use_chat_info_database_, from.extract_field("use_chat_info_database")));
  TRY_STATUS(from_json(to.use_message_database_, from.extract_field("use_message_database")));
  TRY_STATUS(from_json(to.use_secret_chats_, from.extract_field("use_secret_chats")));
  TRY_STATUS(from_json(to.api_id_, from.extract_field("api_id")));
  TRY_STATUS(from_json(to.api_hash_, from.extract_field("api_hash")));
  TRY_STATUS(from_json(to.system_language_code_, from.extract_field("system_language_code")));
  TRY_STATUS(from_json(to.device_model_, from.extract_field("device_model")));
  TRY_STATUS(from_json(to.system_version_, from.extract_field("system_version")));
  TRY_STATUS(from_json(to.application_version_, from.extract_field("application_version")));
  return Status::OK();
}

Status from_json(td_api::setVideoChatTitle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::stopPoll &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  return Status::OK();
}

Status from_json(td_api::testCallVectorInt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::testUseUpdate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::toggleChatHasProtectedContent &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.has_protected_content_, from.extract_field("has_protected_content")));
  return Status::OK();
}

Status from_json(td_api::toggleGeneralForumTopicIsHidden &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_hidden_, from.extract_field("is_hidden")));
  return Status::OK();
}

Status from_json(td_api::toggleSavedMessagesTopicIsPinned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.is_pinned_, from.extract_field("is_pinned")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupIsBroadcastGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::transferBusinessAccountStars &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::upgradeBasicGroupChatToSupergroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::writeGeneratedFilePart &to, JsonObject &from) {
  TRY_STATUS(from_json(to.generation_id_, from.extract_field("generation_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::advertisementSponsor &object) {
  auto jo = jv.enter_object();
  jo("@type", "advertisementSponsor");
  jo("url", object.url_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("info", object.info_);
}

void to_json(JsonValueScope &jv, const td_api::animations &object) {
  auto jo = jv.enter_object();
  jo("@type", "animations");
  jo("animations", ToJson(object.animations_));
}

void to_json(JsonValueScope &jv, const td_api::autoDownloadSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "autoDownloadSettings");
  jo("is_auto_download_enabled", JsonBool{object.is_auto_download_enabled_});
  jo("max_photo_file_size", object.max_photo_file_size_);
  jo("max_video_file_size", object.max_video_file_size_);
  jo("max_other_file_size", object.max_other_file_size_);
  jo("video_upload_bitrate", object.video_upload_bitrate_);
  jo("preload_large_videos", JsonBool{object.preload_large_videos_});
  jo("preload_next_audio", JsonBool{object.preload_next_audio_});
  jo("preload_stories", JsonBool{object.preload_stories_});
  jo("use_less_data_for_calls", JsonBool{object.use_less_data_for_calls_});
}

void to_json(JsonValueScope &jv, const td_api::background &object) {
  auto jo = jv.enter_object();
  jo("@type", "background");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("is_default", JsonBool{object.is_default_});
  jo("is_dark", JsonBool{object.is_dark_});
  jo("name", object.name_);
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::BlockList &object) {
  td_api::downcast_call(const_cast<td_api::BlockList &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::blockListMain &object) {
  auto jo = jv.enter_object();
  jo("@type", "blockListMain");
}

void to_json(JsonValueScope &jv, const td_api::blockListStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "blockListStories");
}

void to_json(JsonValueScope &jv, const td_api::botVerificationParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "botVerificationParameters");
  jo("icon_custom_emoji_id", ToJson(JsonInt64{object.icon_custom_emoji_id_}));
  jo("organization_name", object.organization_name_);
  if (object.default_custom_description_) {
    jo("default_custom_description", ToJson(*object.default_custom_description_));
  }
  jo("can_set_custom_description", JsonBool{object.can_set_custom_description_});
}

void to_json(JsonValueScope &jv, const td_api::businessChatLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessChatLinks");
  jo("links", ToJson(object.links_));
}

void to_json(JsonValueScope &jv, const td_api::businessMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessMessage");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  if (object.reply_to_message_) {
    jo("reply_to_message", ToJson(*object.reply_to_message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::callProtocol &object) {
  auto jo = jv.enter_object();
  jo("@type", "callProtocol");
  jo("udp_p2p", JsonBool{object.udp_p2p_});
  jo("udp_reflector", JsonBool{object.udp_reflector_});
  jo("min_layer", object.min_layer_);
  jo("max_layer", object.max_layer_);
  jo("library_versions", ToJson(object.library_versions_));
}

void to_json(JsonValueScope &jv, const td_api::CanTransferOwnershipResult &object) {
  td_api::downcast_call(const_cast<td_api::CanTransferOwnershipResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultOk");
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultPasswordNeeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultPasswordNeeded");
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultPasswordTooFresh &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultPasswordTooFresh");
  jo("retry_after", object.retry_after_);
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultSessionTooFresh &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultSessionTooFresh");
  jo("retry_after", object.retry_after_);
}

void to_json(JsonValueScope &jv, const td_api::chatBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBackground");
  if (object.background_) {
    jo("background", ToJson(*object.background_));
  }
  jo("dark_theme_dimming", object.dark_theme_dimming_);
}

void to_json(JsonValueScope &jv, const td_api::chatBoostStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostStatus");
  jo("boost_url", object.boost_url_);
  jo("applied_slot_ids", ToJson(object.applied_slot_ids_));
  jo("level", object.level_);
  jo("gift_code_boost_count", object.gift_code_boost_count_);
  jo("boost_count", object.boost_count_);
  jo("current_level_boost_count", object.current_level_boost_count_);
  jo("next_level_boost_count", object.next_level_boost_count_);
  jo("premium_member_count", object.premium_member_count_);
  jo("premium_member_percentage", object.premium_member_percentage_);
  jo("prepaid_giveaways", ToJson(object.prepaid_giveaways_));
}

void to_json(JsonValueScope &jv, const td_api::chatFolderInviteLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolderInviteLinks");
  jo("invite_links", ToJson(object.invite_links_));
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinks");
  jo("total_count", object.total_count_);
  jo("invite_links", ToJson(object.invite_links_));
}

void to_json(JsonValueScope &jv, const td_api::chatMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMembers");
  jo("total_count", object.total_count_);
  jo("members", ToJson(object.members_));
}

void to_json(JsonValueScope &jv, const td_api::chatPhotos &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPhotos");
  jo("total_count", object.total_count_);
  jo("photos", ToJson(object.photos_));
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsAdministratorActionsInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsAdministratorActionsInfo");
  jo("user_id", object.user_id_);
  jo("deleted_message_count", object.deleted_message_count_);
  jo("banned_user_count", object.banned_user_count_);
  jo("restricted_user_count", object.restricted_user_count_);
}

void to_json(JsonValueScope &jv, const td_api::CheckStickerSetNameResult &object) {
  td_api::downcast_call(const_cast<td_api::CheckStickerSetNameResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::checkStickerSetNameResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkStickerSetNameResultOk");
}

void to_json(JsonValueScope &jv, const td_api::checkStickerSetNameResultNameInvalid &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkStickerSetNameResultNameInvalid");
}

void to_json(JsonValueScope &jv, const td_api::checkStickerSetNameResultNameOccupied &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkStickerSetNameResultNameOccupied");
}

void to_json(JsonValueScope &jv, const td_api::connectedWebsites &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectedWebsites");
  jo("websites", ToJson(object.websites_));
}

void to_json(JsonValueScope &jv, const td_api::data &object) {
  auto jo = jv.enter_object();
  jo("@type", "data");
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::downloadedFileCounts &object) {
  auto jo = jv.enter_object();
  jo("@type", "downloadedFileCounts");
  jo("active_count", object.active_count_);
  jo("paused_count", object.paused_count_);
  jo("completed_count", object.completed_count_);
}

void to_json(JsonValueScope &jv, const td_api::emojiKeywords &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiKeywords");
  jo("emoji_keywords", ToJson(object.emoji_keywords_));
}

void to_json(JsonValueScope &jv, const td_api::error &object) {
  auto jo = jv.enter_object();
  jo("@type", "error");
  jo("code", object.code_);
  jo("message", object.message_);
}

void to_json(JsonValueScope &jv, const td_api::formattedText &object) {
  auto jo = jv.enter_object();
  jo("@type", "formattedText");
  jo("text", object.text_);
  jo("entities", ToJson(object.entities_));
}

void to_json(JsonValueScope &jv, const td_api::foundChatMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundChatMessages");
  jo("total_count", object.total_count_);
  jo("messages", ToJson(object.messages_));
  jo("next_from_message_id", object.next_from_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::game &object) {
  auto jo = jv.enter_object();
  jo("@type", "game");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("short_name", object.short_name_);
  jo("title", object.title_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("description", object.description_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::giftPurchaseLimits &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftPurchaseLimits");
  jo("total_count", object.total_count_);
  jo("remaining_count", object.remaining_count_);
}

void to_json(JsonValueScope &jv, const td_api::giveawayParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayParameters");
  jo("boosted_chat_id", object.boosted_chat_id_);
  jo("additional_chat_ids", ToJson(object.additional_chat_ids_));
  jo("winners_selection_date", object.winners_selection_date_);
  jo("only_new_members", JsonBool{object.only_new_members_});
  jo("has_public_winners", JsonBool{object.has_public_winners_});
  jo("country_codes", ToJson(object.country_codes_));
  jo("prize_description", object.prize_description_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallParticipantVideoInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallParticipantVideoInfo");
  jo("source_groups", ToJson(object.source_groups_));
  jo("endpoint_id", object.endpoint_id_);
  jo("is_paused", JsonBool{object.is_paused_});
}

void to_json(JsonValueScope &jv, const td_api::importedContacts &object) {
  auto jo = jv.enter_object();
  jo("@type", "importedContacts");
  jo("user_ids", ToJson(object.user_ids_));
  jo("importer_count", ToJson(object.importer_count_));
}

void to_json(JsonValueScope &jv, const td_api::InputFile &object) {
  td_api::downcast_call(const_cast<td_api::InputFile &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inputFileId &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileId");
  jo("id", object.id_);
}

void to_json(JsonValueScope &jv, const td_api::inputFileRemote &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileRemote");
  jo("id", object.id_);
}

void to_json(JsonValueScope &jv, const td_api::inputFileLocal &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileLocal");
  jo("path", object.path_);
}

void to_json(JsonValueScope &jv, const td_api::inputFileGenerated &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileGenerated");
  jo("original_path", object.original_path_);
  jo("conversion", object.conversion_);
  jo("expected_size", object.expected_size_);
}

void to_json(JsonValueScope &jv, const td_api::InviteGroupCallParticipantResult &object) {
  td_api::downcast_call(const_cast<td_api::InviteGroupCallParticipantResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultUserPrivacyRestricted &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultUserPrivacyRestricted");
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultUserAlreadyParticipant &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultUserAlreadyParticipant");
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultUserWasBanned &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultUserWasBanned");
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultSuccess &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultSuccess");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::languagePackString &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackString");
  jo("key", object.key_);
  if (object.value_) {
    jo("value", ToJson(*object.value_));
  }
}

void to_json(JsonValueScope &jv, const td_api::localizationTargetInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "localizationTargetInfo");
  jo("language_packs", ToJson(object.language_packs_));
}

void to_json(JsonValueScope &jv, const td_api::maskPosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPosition");
  if (object.point_) {
    jo("point", ToJson(*object.point_));
  }
  jo("x_shift", object.x_shift_);
  jo("y_shift", object.y_shift_);
  jo("scale", object.scale_);
}

void to_json(JsonValueScope &jv, const td_api::MessageFileType &object) {
  td_api::downcast_call(const_cast<td_api::MessageFileType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageFileTypePrivate &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageFileTypePrivate");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::messageFileTypeGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageFileTypeGroup");
  jo("title", object.title_);
}

void to_json(JsonValueScope &jv, const td_api::messageFileTypeUnknown &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageFileTypeUnknown");
}

void to_json(JsonValueScope &jv, const td_api::messageProperties &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageProperties");
  jo("can_add_offer", JsonBool{object.can_add_offer_});
  jo("can_add_tasks", JsonBool{object.can_add_tasks_});
  jo("can_be_approved", JsonBool{object.can_be_approved_});
  jo("can_be_copied", JsonBool{object.can_be_copied_});
  jo("can_be_copied_to_secret_chat", JsonBool{object.can_be_copied_to_secret_chat_});
  jo("can_be_declined", JsonBool{object.can_be_declined_});
  jo("can_be_deleted_only_for_self", JsonBool{object.can_be_deleted_only_for_self_});
  jo("can_be_deleted_for_all_users", JsonBool{object.can_be_deleted_for_all_users_});
  jo("can_be_edited", JsonBool{object.can_be_edited_});
  jo("can_be_forwarded", JsonBool{object.can_be_forwarded_});
  jo("can_be_paid", JsonBool{object.can_be_paid_});
  jo("can_be_pinned", JsonBool{object.can_be_pinned_});
  jo("can_be_replied", JsonBool{object.can_be_replied_});
  jo("can_be_replied_in_another_chat", JsonBool{object.can_be_replied_in_another_chat_});
  jo("can_be_saved", JsonBool{object.can_be_saved_});
  jo("can_be_shared_in_story", JsonBool{object.can_be_shared_in_story_});
  jo("can_edit_media", JsonBool{object.can_edit_media_});
  jo("can_edit_scheduling_state", JsonBool{object.can_edit_scheduling_state_});
  jo("can_edit_suggested_post_info", JsonBool{object.can_edit_suggested_post_info_});
  jo("can_get_author", JsonBool{object.can_get_author_});
  jo("can_get_embedding_code", JsonBool{object.can_get_embedding_code_});
  jo("can_get_link", JsonBool{object.can_get_link_});
  jo("can_get_media_timestamp_links", JsonBool{object.can_get_media_timestamp_links_});
  jo("can_get_message_thread", JsonBool{object.can_get_message_thread_});
  jo("can_get_read_date", JsonBool{object.can_get_read_date_});
  jo("can_get_statistics", JsonBool{object.can_get_statistics_});
  jo("can_get_video_advertisements", JsonBool{object.can_get_video_advertisements_});
  jo("can_get_viewers", JsonBool{object.can_get_viewers_});
  jo("can_mark_tasks_as_done", JsonBool{object.can_mark_tasks_as_done_});
  jo("can_recognize_speech", JsonBool{object.can_recognize_speech_});
  jo("can_report_chat", JsonBool{object.can_report_chat_});
  jo("can_report_reactions", JsonBool{object.can_report_reactions_});
  jo("can_report_supergroup_spam", JsonBool{object.can_report_supergroup_spam_});
  jo("can_set_fact_check", JsonBool{object.can_set_fact_check_});
  jo("need_show_statistics", JsonBool{object.need_show_statistics_});
}

void to_json(JsonValueScope &jv, const td_api::messageSenders &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSenders");
  jo("total_count", object.total_count_);
  jo("senders", ToJson(object.senders_));
}

void to_json(JsonValueScope &jv, const td_api::networkStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkStatistics");
  jo("since_date", object.since_date_);
  jo("entries", ToJson(object.entries_));
}

void to_json(JsonValueScope &jv, const td_api::notificationSounds &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSounds");
  jo("notification_sounds", ToJson(object.notification_sounds_));
}

void to_json(JsonValueScope &jv, const td_api::pageBlockListItem &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockListItem");
  jo("label", object.label_);
  jo("page_blocks", ToJson(object.page_blocks_));
}

void to_json(JsonValueScope &jv, const td_api::passportElementError &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementError");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("message", object.message_);
  if (object.source_) {
    jo("source", ToJson(*object.source_));
  }
}

void to_json(JsonValueScope &jv, const td_api::PaymentFormType &object) {
  td_api::downcast_call(const_cast<td_api::PaymentFormType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::paymentFormTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentFormTypeRegular");
  if (object.invoice_) {
    jo("invoice", ToJson(*object.invoice_));
  }
  jo("payment_provider_user_id", object.payment_provider_user_id_);
  if (object.payment_provider_) {
    jo("payment_provider", ToJson(*object.payment_provider_));
  }
  jo("additional_payment_options", ToJson(object.additional_payment_options_));
  if (object.saved_order_info_) {
    jo("saved_order_info", ToJson(*object.saved_order_info_));
  }
  jo("saved_credentials", ToJson(object.saved_credentials_));
  jo("can_save_credentials", JsonBool{object.can_save_credentials_});
  jo("need_password", JsonBool{object.need_password_});
}

void to_json(JsonValueScope &jv, const td_api::paymentFormTypeStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentFormTypeStars");
  jo("star_count", object.star_count_);
}

void to_json(JsonValueScope &jv, const td_api::paymentFormTypeStarSubscription &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentFormTypeStarSubscription");
  if (object.pricing_) {
    jo("pricing", ToJson(*object.pricing_));
  }
}

void to_json(JsonValueScope &jv, const td_api::photo &object) {
  auto jo = jv.enter_object();
  jo("@type", "photo");
  jo("has_stickers", JsonBool{object.has_stickers_});
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  jo("sizes", ToJson(object.sizes_));
}

void to_json(JsonValueScope &jv, const td_api::premiumGiftCodeInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumGiftCodeInfo");
  if (object.creator_id_) {
    jo("creator_id", ToJson(*object.creator_id_));
  }
  jo("creation_date", object.creation_date_);
  jo("is_from_giveaway", JsonBool{object.is_from_giveaway_});
  jo("giveaway_message_id", object.giveaway_message_id_);
  jo("month_count", object.month_count_);
  jo("day_count", object.day_count_);
  jo("user_id", object.user_id_);
  jo("use_date", object.use_date_);
}

void to_json(JsonValueScope &jv, const td_api::premiumStatePaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumStatePaymentOption");
  if (object.payment_option_) {
    jo("payment_option", ToJson(*object.payment_option_));
  }
  jo("is_current", JsonBool{object.is_current_});
  jo("is_upgrade", JsonBool{object.is_upgrade_});
  jo("last_transaction_id", object.last_transaction_id_);
}

void to_json(JsonValueScope &jv, const td_api::proxies &object) {
  auto jo = jv.enter_object();
  jo("@type", "proxies");
  jo("proxies", ToJson(object.proxies_));
}

void to_json(JsonValueScope &jv, const td_api::quickReplyMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "quickReplyMessages");
  jo("messages", ToJson(object.messages_));
}

void to_json(JsonValueScope &jv, const td_api::recommendedChatFolder &object) {
  auto jo = jv.enter_object();
  jo("@type", "recommendedChatFolder");
  if (object.folder_) {
    jo("folder", ToJson(*object.folder_));
  }
  jo("description", object.description_);
}

void to_json(JsonValueScope &jv, const td_api::ResetPasswordResult &object) {
  td_api::downcast_call(const_cast<td_api::ResetPasswordResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::resetPasswordResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "resetPasswordResultOk");
}

void to_json(JsonValueScope &jv, const td_api::resetPasswordResultPending &object) {
  auto jo = jv.enter_object();
  jo("@type", "resetPasswordResultPending");
  jo("pending_reset_date", object.pending_reset_date_);
}

void to_json(JsonValueScope &jv, const td_api::resetPasswordResultDeclined &object) {
  auto jo = jv.enter_object();
  jo("@type", "resetPasswordResultDeclined");
  jo("retry_date", object.retry_date_);
}

void to_json(JsonValueScope &jv, const td_api::SavedMessagesTopicType &object) {
  td_api::downcast_call(const_cast<td_api::SavedMessagesTopicType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTopicTypeMyNotes &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTopicTypeMyNotes");
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTopicTypeAuthorHidden &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTopicTypeAuthorHidden");
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTopicTypeSavedFromChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTopicTypeSavedFromChat");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::SessionType &object) {
  td_api::downcast_call(const_cast<td_api::SessionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeAndroid &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeAndroid");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeApple &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeApple");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeBrave &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeBrave");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeChrome &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeChrome");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeEdge &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeEdge");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeFirefox &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeFirefox");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeIpad &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeIpad");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeIphone &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeIphone");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeLinux &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeLinux");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeMac &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeMac");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeOpera &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeOpera");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeSafari &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeSafari");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeUbuntu &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeUbuntu");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeUnknown &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeUnknown");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeVivaldi &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeVivaldi");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeWindows &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeWindows");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeXbox &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeXbox");
}

void to_json(JsonValueScope &jv, const td_api::sponsoredMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "sponsoredMessages");
  jo("messages", ToJson(object.messages_));
  jo("messages_between", object.messages_between_);
}

void to_json(JsonValueScope &jv, const td_api::starRevenueStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "starRevenueStatus");
  if (object.total_amount_) {
    jo("total_amount", ToJson(*object.total_amount_));
  }
  if (object.current_amount_) {
    jo("current_amount", ToJson(*object.current_amount_));
  }
  if (object.available_amount_) {
    jo("available_amount", ToJson(*object.available_amount_));
  }
  jo("withdrawal_enabled", JsonBool{object.withdrawal_enabled_});
  jo("next_withdrawal_in", object.next_withdrawal_in_);
}

void to_json(JsonValueScope &jv, const td_api::StatisticalGraph &object) {
  td_api::downcast_call(const_cast<td_api::StatisticalGraph &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::statisticalGraphData &object) {
  auto jo = jv.enter_object();
  jo("@type", "statisticalGraphData");
  jo("json_data", object.json_data_);
  jo("zoom_token", object.zoom_token_);
}

void to_json(JsonValueScope &jv, const td_api::statisticalGraphAsync &object) {
  auto jo = jv.enter_object();
  jo("@type", "statisticalGraphAsync");
  jo("token", object.token_);
}

void to_json(JsonValueScope &jv, const td_api::statisticalGraphError &object) {
  auto jo = jv.enter_object();
  jo("@type", "statisticalGraphError");
  jo("error_message", object.error_message_);
}

void to_json(JsonValueScope &jv, const td_api::stickers &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickers");
  jo("stickers", ToJson(object.stickers_));
}

void to_json(JsonValueScope &jv, const td_api::storyArea &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyArea");
  if (object.position_) {
    jo("position", ToJson(*object.position_));
  }
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::StoryList &object) {
  td_api::downcast_call(const_cast<td_api::StoryList &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::storyListMain &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyListMain");
}

void to_json(JsonValueScope &jv, const td_api::storyListArchive &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyListArchive");
}

void to_json(JsonValueScope &jv, const td_api::SuggestedPostRefundReason &object) {
  td_api::downcast_call(const_cast<td_api::SuggestedPostRefundReason &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostRefundReasonPostDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostRefundReasonPostDeleted");
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostRefundReasonPaymentRefunded &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostRefundReasonPaymentRefunded");
}

void to_json(JsonValueScope &jv, const td_api::temporaryPasswordState &object) {
  auto jo = jv.enter_object();
  jo("@type", "temporaryPasswordState");
  jo("has_password", JsonBool{object.has_password_});
  jo("valid_for", object.valid_for_);
}

void to_json(JsonValueScope &jv, const td_api::text &object) {
  auto jo = jv.enter_object();
  jo("@type", "text");
  jo("text", object.text_);
}

void to_json(JsonValueScope &jv, const td_api::timeZones &object) {
  auto jo = jv.enter_object();
  jo("@type", "timeZones");
  jo("time_zones", ToJson(object.time_zones_));
}

void to_json(JsonValueScope &jv, const td_api::Update &object) {
  td_api::downcast_call(const_cast<td_api::Update &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::updateAuthorizationState &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAuthorizationState");
  if (object.authorization_state_) {
    jo("authorization_state", ToJson(*object.authorization_state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewMessage");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageSendAcknowledged &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageSendAcknowledged");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateMessageSendSucceeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageSendSucceeded");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("old_message_id", object.old_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateMessageSendFailed &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageSendFailed");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("old_message_id", object.old_message_id_);
  if (object.error_) {
    jo("error", ToJson(*object.error_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageContent &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageContent");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.new_content_) {
    jo("new_content", ToJson(*object.new_content_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageEdited &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageEdited");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("edit_date", object.edit_date_);
  if (object.reply_markup_) {
    jo("reply_markup", ToJson(*object.reply_markup_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageIsPinned &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageIsPinned");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::updateMessageInteractionInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageInteractionInfo");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.interaction_info_) {
    jo("interaction_info", ToJson(*object.interaction_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageContentOpened &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageContentOpened");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateMessageMentionRead &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageMentionRead");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("unread_mention_count", object.unread_mention_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateMessageUnreadReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageUnreadReactions");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("unread_reactions", ToJson(object.unread_reactions_));
  jo("unread_reaction_count", object.unread_reaction_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateMessageFactCheck &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageFactCheck");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.fact_check_) {
    jo("fact_check", ToJson(*object.fact_check_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageSuggestedPostInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageSuggestedPostInfo");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.suggested_post_info_) {
    jo("suggested_post_info", ToJson(*object.suggested_post_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageLiveLocationViewed &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageLiveLocationViewed");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateVideoPublished &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateVideoPublished");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateNewChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewChat");
  if (object.chat_) {
    jo("chat", ToJson(*object.chat_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatTitle &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatTitle");
  jo("chat_id", object.chat_id_);
  jo("title", object.title_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatPhoto");
  jo("chat_id", object.chat_id_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatAccentColors &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatAccentColors");
  jo("chat_id", object.chat_id_);
  jo("accent_color_id", object.accent_color_id_);
  jo("background_custom_emoji_id", ToJson(JsonInt64{object.background_custom_emoji_id_}));
  if (object.upgraded_gift_colors_) {
    jo("upgraded_gift_colors", ToJson(*object.upgraded_gift_colors_));
  }
  jo("profile_accent_color_id", object.profile_accent_color_id_);
  jo("profile_background_custom_emoji_id", ToJson(JsonInt64{object.profile_background_custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::updateChatPermissions &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatPermissions");
  jo("chat_id", object.chat_id_);
  if (object.permissions_) {
    jo("permissions", ToJson(*object.permissions_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatLastMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatLastMessage");
  jo("chat_id", object.chat_id_);
  if (object.last_message_) {
    jo("last_message", ToJson(*object.last_message_));
  }
  jo("positions", ToJson(object.positions_));
}

void to_json(JsonValueScope &jv, const td_api::updateChatPosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatPosition");
  jo("chat_id", object.chat_id_);
  if (object.position_) {
    jo("position", ToJson(*object.position_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatAddedToList &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatAddedToList");
  jo("chat_id", object.chat_id_);
  if (object.chat_list_) {
    jo("chat_list", ToJson(*object.chat_list_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatRemovedFromList &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatRemovedFromList");
  jo("chat_id", object.chat_id_);
  if (object.chat_list_) {
    jo("chat_list", ToJson(*object.chat_list_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatReadInbox &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatReadInbox");
  jo("chat_id", object.chat_id_);
  jo("last_read_inbox_message_id", object.last_read_inbox_message_id_);
  jo("unread_count", object.unread_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatReadOutbox &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatReadOutbox");
  jo("chat_id", object.chat_id_);
  jo("last_read_outbox_message_id", object.last_read_outbox_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatActionBar &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatActionBar");
  jo("chat_id", object.chat_id_);
  if (object.action_bar_) {
    jo("action_bar", ToJson(*object.action_bar_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatBusinessBotManageBar &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatBusinessBotManageBar");
  jo("chat_id", object.chat_id_);
  if (object.business_bot_manage_bar_) {
    jo("business_bot_manage_bar", ToJson(*object.business_bot_manage_bar_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatAvailableReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatAvailableReactions");
  jo("chat_id", object.chat_id_);
  if (object.available_reactions_) {
    jo("available_reactions", ToJson(*object.available_reactions_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatDraftMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatDraftMessage");
  jo("chat_id", object.chat_id_);
  if (object.draft_message_) {
    jo("draft_message", ToJson(*object.draft_message_));
  }
  jo("positions", ToJson(object.positions_));
}

void to_json(JsonValueScope &jv, const td_api::updateChatEmojiStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatEmojiStatus");
  jo("chat_id", object.chat_id_);
  if (object.emoji_status_) {
    jo("emoji_status", ToJson(*object.emoji_status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatMessageSender &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatMessageSender");
  jo("chat_id", object.chat_id_);
  if (object.message_sender_id_) {
    jo("message_sender_id", ToJson(*object.message_sender_id_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatMessageAutoDeleteTime &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatMessageAutoDeleteTime");
  jo("chat_id", object.chat_id_);
  jo("message_auto_delete_time", object.message_auto_delete_time_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatNotificationSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatNotificationSettings");
  jo("chat_id", object.chat_id_);
  if (object.notification_settings_) {
    jo("notification_settings", ToJson(*object.notification_settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatPendingJoinRequests &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatPendingJoinRequests");
  jo("chat_id", object.chat_id_);
  if (object.pending_join_requests_) {
    jo("pending_join_requests", ToJson(*object.pending_join_requests_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatReplyMarkup &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatReplyMarkup");
  jo("chat_id", object.chat_id_);
  jo("reply_markup_message_id", object.reply_markup_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatBackground");
  jo("chat_id", object.chat_id_);
  if (object.background_) {
    jo("background", ToJson(*object.background_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatTheme");
  jo("chat_id", object.chat_id_);
  if (object.theme_) {
    jo("theme", ToJson(*object.theme_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatUnreadMentionCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatUnreadMentionCount");
  jo("chat_id", object.chat_id_);
  jo("unread_mention_count", object.unread_mention_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatUnreadReactionCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatUnreadReactionCount");
  jo("chat_id", object.chat_id_);
  jo("unread_reaction_count", object.unread_reaction_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatVideoChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatVideoChat");
  jo("chat_id", object.chat_id_);
  if (object.video_chat_) {
    jo("video_chat", ToJson(*object.video_chat_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatDefaultDisableNotification &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatDefaultDisableNotification");
  jo("chat_id", object.chat_id_);
  jo("default_disable_notification", JsonBool{object.default_disable_notification_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatHasProtectedContent &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatHasProtectedContent");
  jo("chat_id", object.chat_id_);
  jo("has_protected_content", JsonBool{object.has_protected_content_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatIsTranslatable &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatIsTranslatable");
  jo("chat_id", object.chat_id_);
  jo("is_translatable", JsonBool{object.is_translatable_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatIsMarkedAsUnread &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatIsMarkedAsUnread");
  jo("chat_id", object.chat_id_);
  jo("is_marked_as_unread", JsonBool{object.is_marked_as_unread_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatViewAsTopics &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatViewAsTopics");
  jo("chat_id", object.chat_id_);
  jo("view_as_topics", JsonBool{object.view_as_topics_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatBlockList &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatBlockList");
  jo("chat_id", object.chat_id_);
  if (object.block_list_) {
    jo("block_list", ToJson(*object.block_list_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatHasScheduledMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatHasScheduledMessages");
  jo("chat_id", object.chat_id_);
  jo("has_scheduled_messages", JsonBool{object.has_scheduled_messages_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatFolders &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatFolders");
  jo("chat_folders", ToJson(object.chat_folders_));
  jo("main_chat_list_position", object.main_chat_list_position_);
  jo("are_tags_enabled", JsonBool{object.are_tags_enabled_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatOnlineMemberCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatOnlineMemberCount");
  jo("chat_id", object.chat_id_);
  jo("online_member_count", object.online_member_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateSavedMessagesTopic &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSavedMessagesTopic");
  if (object.topic_) {
    jo("topic", ToJson(*object.topic_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateSavedMessagesTopicCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSavedMessagesTopicCount");
  jo("topic_count", object.topic_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateDirectMessagesChatTopic &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateDirectMessagesChatTopic");
  if (object.topic_) {
    jo("topic", ToJson(*object.topic_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateTopicMessageCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateTopicMessageCount");
  jo("chat_id", object.chat_id_);
  if (object.topic_id_) {
    jo("topic_id", ToJson(*object.topic_id_));
  }
  jo("message_count", object.message_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateQuickReplyShortcut &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateQuickReplyShortcut");
  if (object.shortcut_) {
    jo("shortcut", ToJson(*object.shortcut_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateQuickReplyShortcutDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateQuickReplyShortcutDeleted");
  jo("shortcut_id", object.shortcut_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateQuickReplyShortcuts &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateQuickReplyShortcuts");
  jo("shortcut_ids", ToJson(object.shortcut_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateQuickReplyShortcutMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateQuickReplyShortcutMessages");
  jo("shortcut_id", object.shortcut_id_);
  jo("messages", ToJson(object.messages_));
}

void to_json(JsonValueScope &jv, const td_api::updateForumTopicInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateForumTopicInfo");
  if (object.info_) {
    jo("info", ToJson(*object.info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateForumTopic &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateForumTopic");
  jo("chat_id", object.chat_id_);
  jo("forum_topic_id", object.forum_topic_id_);
  jo("is_pinned", JsonBool{object.is_pinned_});
  jo("last_read_inbox_message_id", object.last_read_inbox_message_id_);
  jo("last_read_outbox_message_id", object.last_read_outbox_message_id_);
  jo("unread_mention_count", object.unread_mention_count_);
  jo("unread_reaction_count", object.unread_reaction_count_);
  if (object.notification_settings_) {
    jo("notification_settings", ToJson(*object.notification_settings_));
  }
  if (object.draft_message_) {
    jo("draft_message", ToJson(*object.draft_message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateScopeNotificationSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateScopeNotificationSettings");
  if (object.scope_) {
    jo("scope", ToJson(*object.scope_));
  }
  if (object.notification_settings_) {
    jo("notification_settings", ToJson(*object.notification_settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateReactionNotificationSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateReactionNotificationSettings");
  if (object.notification_settings_) {
    jo("notification_settings", ToJson(*object.notification_settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNotification &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNotification");
  jo("notification_group_id", object.notification_group_id_);
  if (object.notification_) {
    jo("notification", ToJson(*object.notification_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNotificationGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNotificationGroup");
  jo("notification_group_id", object.notification_group_id_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("chat_id", object.chat_id_);
  jo("notification_settings_chat_id", object.notification_settings_chat_id_);
  jo("notification_sound_id", ToJson(JsonInt64{object.notification_sound_id_}));
  jo("total_count", object.total_count_);
  jo("added_notifications", ToJson(object.added_notifications_));
  jo("removed_notification_ids", ToJson(object.removed_notification_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateActiveNotifications &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateActiveNotifications");
  jo("groups", ToJson(object.groups_));
}

void to_json(JsonValueScope &jv, const td_api::updateHavePendingNotifications &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateHavePendingNotifications");
  jo("have_delayed_notifications", JsonBool{object.have_delayed_notifications_});
  jo("have_unreceived_notifications", JsonBool{object.have_unreceived_notifications_});
}

void to_json(JsonValueScope &jv, const td_api::updateDeleteMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateDeleteMessages");
  jo("chat_id", object.chat_id_);
  jo("message_ids", ToJson(object.message_ids_));
  jo("is_permanent", JsonBool{object.is_permanent_});
  jo("from_cache", JsonBool{object.from_cache_});
}

void to_json(JsonValueScope &jv, const td_api::updateChatAction &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatAction");
  jo("chat_id", object.chat_id_);
  if (object.topic_id_) {
    jo("topic_id", ToJson(*object.topic_id_));
  }
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  if (object.action_) {
    jo("action", ToJson(*object.action_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updatePendingTextMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "updatePendingTextMessage");
  jo("chat_id", object.chat_id_);
  jo("forum_topic_id", object.forum_topic_id_);
  jo("draft_id", ToJson(JsonInt64{object.draft_id_}));
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateUserStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateUserStatus");
  jo("user_id", object.user_id_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateUser");
  if (object.user_) {
    jo("user", ToJson(*object.user_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateBasicGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateBasicGroup");
  if (object.basic_group_) {
    jo("basic_group", ToJson(*object.basic_group_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateSupergroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSupergroup");
  if (object.supergroup_) {
    jo("supergroup", ToJson(*object.supergroup_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateSecretChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSecretChat");
  if (object.secret_chat_) {
    jo("secret_chat", ToJson(*object.secret_chat_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateUserFullInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateUserFullInfo");
  jo("user_id", object.user_id_);
  if (object.user_full_info_) {
    jo("user_full_info", ToJson(*object.user_full_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateBasicGroupFullInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateBasicGroupFullInfo");
  jo("basic_group_id", object.basic_group_id_);
  if (object.basic_group_full_info_) {
    jo("basic_group_full_info", ToJson(*object.basic_group_full_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateSupergroupFullInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSupergroupFullInfo");
  jo("supergroup_id", object.supergroup_id_);
  if (object.supergroup_full_info_) {
    jo("supergroup_full_info", ToJson(*object.supergroup_full_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateServiceNotification &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateServiceNotification");
  jo("type", object.type_);
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateFile &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFile");
  if (object.file_) {
    jo("file", ToJson(*object.file_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateFileGenerationStart &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFileGenerationStart");
  jo("generation_id", ToJson(JsonInt64{object.generation_id_}));
  jo("original_path", object.original_path_);
  jo("destination_path", object.destination_path_);
  jo("conversion", object.conversion_);
}

void to_json(JsonValueScope &jv, const td_api::updateFileGenerationStop &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFileGenerationStop");
  jo("generation_id", ToJson(JsonInt64{object.generation_id_}));
}

void to_json(JsonValueScope &jv, const td_api::updateFileDownloads &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFileDownloads");
  jo("total_size", object.total_size_);
  jo("total_count", object.total_count_);
  jo("downloaded_size", object.downloaded_size_);
}

void to_json(JsonValueScope &jv, const td_api::updateFileAddedToDownloads &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFileAddedToDownloads");
  if (object.file_download_) {
    jo("file_download", ToJson(*object.file_download_));
  }
  if (object.counts_) {
    jo("counts", ToJson(*object.counts_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateFileDownload &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFileDownload");
  jo("file_id", object.file_id_);
  jo("complete_date", object.complete_date_);
  jo("is_paused", JsonBool{object.is_paused_});
  if (object.counts_) {
    jo("counts", ToJson(*object.counts_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateFileRemovedFromDownloads &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFileRemovedFromDownloads");
  jo("file_id", object.file_id_);
  if (object.counts_) {
    jo("counts", ToJson(*object.counts_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateApplicationVerificationRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateApplicationVerificationRequired");
  jo("verification_id", object.verification_id_);
  jo("nonce", object.nonce_);
  jo("cloud_project_number", ToJson(JsonInt64{object.cloud_project_number_}));
}

void to_json(JsonValueScope &jv, const td_api::updateApplicationRecaptchaVerificationRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateApplicationRecaptchaVerificationRequired");
  jo("verification_id", object.verification_id_);
  jo("action", object.action_);
  jo("recaptcha_key_id", object.recaptcha_key_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateCall");
  if (object.call_) {
    jo("call", ToJson(*object.call_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateGroupCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateGroupCall");
  if (object.group_call_) {
    jo("group_call", ToJson(*object.group_call_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateGroupCallParticipant &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateGroupCallParticipant");
  jo("group_call_id", object.group_call_id_);
  if (object.participant_) {
    jo("participant", ToJson(*object.participant_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateGroupCallParticipants &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateGroupCallParticipants");
  jo("group_call_id", object.group_call_id_);
  jo("participant_user_ids", ToJson(JsonVectorInt64{object.participant_user_ids_}));
}

void to_json(JsonValueScope &jv, const td_api::updateGroupCallVerificationState &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateGroupCallVerificationState");
  jo("group_call_id", object.group_call_id_);
  jo("generation", object.generation_);
  jo("emojis", ToJson(object.emojis_));
}

void to_json(JsonValueScope &jv, const td_api::updateNewGroupCallMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewGroupCallMessage");
  jo("group_call_id", object.group_call_id_);
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewGroupCallPaidReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewGroupCallPaidReaction");
  jo("group_call_id", object.group_call_id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("star_count", object.star_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateGroupCallMessageSendFailed &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateGroupCallMessageSendFailed");
  jo("group_call_id", object.group_call_id_);
  jo("message_id", object.message_id_);
  if (object.error_) {
    jo("error", ToJson(*object.error_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateGroupCallMessagesDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateGroupCallMessagesDeleted");
  jo("group_call_id", object.group_call_id_);
  jo("message_ids", ToJson(object.message_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateLiveStoryTopDonors &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateLiveStoryTopDonors");
  jo("group_call_id", object.group_call_id_);
  if (object.donors_) {
    jo("donors", ToJson(*object.donors_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewCallSignalingData &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewCallSignalingData");
  jo("call_id", object.call_id_);
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::updateUserPrivacySettingRules &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateUserPrivacySettingRules");
  if (object.setting_) {
    jo("setting", ToJson(*object.setting_));
  }
  if (object.rules_) {
    jo("rules", ToJson(*object.rules_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateUnreadMessageCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateUnreadMessageCount");
  if (object.chat_list_) {
    jo("chat_list", ToJson(*object.chat_list_));
  }
  jo("unread_count", object.unread_count_);
  jo("unread_unmuted_count", object.unread_unmuted_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateUnreadChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateUnreadChatCount");
  if (object.chat_list_) {
    jo("chat_list", ToJson(*object.chat_list_));
  }
  jo("total_count", object.total_count_);
  jo("unread_count", object.unread_count_);
  jo("unread_unmuted_count", object.unread_unmuted_count_);
  jo("marked_as_unread_count", object.marked_as_unread_count_);
  jo("marked_as_unread_unmuted_count", object.marked_as_unread_unmuted_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStory");
  if (object.story_) {
    jo("story", ToJson(*object.story_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateStoryDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStoryDeleted");
  jo("story_poster_chat_id", object.story_poster_chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateStoryPostSucceeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStoryPostSucceeded");
  if (object.story_) {
    jo("story", ToJson(*object.story_));
  }
  jo("old_story_id", object.old_story_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateStoryPostFailed &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStoryPostFailed");
  if (object.story_) {
    jo("story", ToJson(*object.story_));
  }
  if (object.error_) {
    jo("error", ToJson(*object.error_));
  }
  if (object.error_type_) {
    jo("error_type", ToJson(*object.error_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatActiveStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatActiveStories");
  if (object.active_stories_) {
    jo("active_stories", ToJson(*object.active_stories_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateStoryListChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStoryListChatCount");
  if (object.story_list_) {
    jo("story_list", ToJson(*object.story_list_));
  }
  jo("chat_count", object.chat_count_);
}

void to_json(JsonValueScope &jv, const td_api::updateStoryStealthMode &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStoryStealthMode");
  jo("active_until_date", object.active_until_date_);
  jo("cooldown_until_date", object.cooldown_until_date_);
}

void to_json(JsonValueScope &jv, const td_api::updateTrustedMiniAppBots &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateTrustedMiniAppBots");
  jo("bot_user_ids", ToJson(object.bot_user_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateOption");
  jo("name", object.name_);
  if (object.value_) {
    jo("value", ToJson(*object.value_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateStickerSet &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStickerSet");
  if (object.sticker_set_) {
    jo("sticker_set", ToJson(*object.sticker_set_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateInstalledStickerSets &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateInstalledStickerSets");
  if (object.sticker_type_) {
    jo("sticker_type", ToJson(*object.sticker_type_));
  }
  jo("sticker_set_ids", ToJson(JsonVectorInt64{object.sticker_set_ids_}));
}

void to_json(JsonValueScope &jv, const td_api::updateTrendingStickerSets &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateTrendingStickerSets");
  if (object.sticker_type_) {
    jo("sticker_type", ToJson(*object.sticker_type_));
  }
  if (object.sticker_sets_) {
    jo("sticker_sets", ToJson(*object.sticker_sets_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateRecentStickers &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateRecentStickers");
  jo("is_attached", JsonBool{object.is_attached_});
  jo("sticker_ids", ToJson(object.sticker_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateFavoriteStickers &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFavoriteStickers");
  jo("sticker_ids", ToJson(object.sticker_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateSavedAnimations &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSavedAnimations");
  jo("animation_ids", ToJson(object.animation_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateSavedNotificationSounds &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSavedNotificationSounds");
  jo("notification_sound_ids", ToJson(JsonVectorInt64{object.notification_sound_ids_}));
}

void to_json(JsonValueScope &jv, const td_api::updateDefaultBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateDefaultBackground");
  jo("for_dark_theme", JsonBool{object.for_dark_theme_});
  if (object.background_) {
    jo("background", ToJson(*object.background_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateEmojiChatThemes &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateEmojiChatThemes");
  jo("chat_themes", ToJson(object.chat_themes_));
}

void to_json(JsonValueScope &jv, const td_api::updateAccentColors &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAccentColors");
  jo("colors", ToJson(object.colors_));
  jo("available_accent_color_ids", ToJson(object.available_accent_color_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateProfileAccentColors &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateProfileAccentColors");
  jo("colors", ToJson(object.colors_));
  jo("available_accent_color_ids", ToJson(object.available_accent_color_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateLanguagePackStrings &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateLanguagePackStrings");
  jo("localization_target", object.localization_target_);
  jo("language_pack_id", object.language_pack_id_);
  jo("strings", ToJson(object.strings_));
}

void to_json(JsonValueScope &jv, const td_api::updateConnectionState &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateConnectionState");
  if (object.state_) {
    jo("state", ToJson(*object.state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateFreezeState &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateFreezeState");
  jo("is_frozen", JsonBool{object.is_frozen_});
  jo("freezing_date", object.freezing_date_);
  jo("deletion_date", object.deletion_date_);
  jo("appeal_link", object.appeal_link_);
}

void to_json(JsonValueScope &jv, const td_api::updateAgeVerificationParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAgeVerificationParameters");
  if (object.parameters_) {
    jo("parameters", ToJson(*object.parameters_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateTermsOfService &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateTermsOfService");
  jo("terms_of_service_id", object.terms_of_service_id_);
  if (object.terms_of_service_) {
    jo("terms_of_service", ToJson(*object.terms_of_service_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateUnconfirmedSession &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateUnconfirmedSession");
  if (object.session_) {
    jo("session", ToJson(*object.session_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateAttachmentMenuBots &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAttachmentMenuBots");
  jo("bots", ToJson(object.bots_));
}

void to_json(JsonValueScope &jv, const td_api::updateWebAppMessageSent &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateWebAppMessageSent");
  jo("web_app_launch_id", ToJson(JsonInt64{object.web_app_launch_id_}));
}

void to_json(JsonValueScope &jv, const td_api::updateActiveEmojiReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateActiveEmojiReactions");
  jo("emojis", ToJson(object.emojis_));
}

void to_json(JsonValueScope &jv, const td_api::updateAvailableMessageEffects &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAvailableMessageEffects");
  jo("reaction_effect_ids", ToJson(JsonVectorInt64{object.reaction_effect_ids_}));
  jo("sticker_effect_ids", ToJson(JsonVectorInt64{object.sticker_effect_ids_}));
}

void to_json(JsonValueScope &jv, const td_api::updateDefaultReactionType &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateDefaultReactionType");
  if (object.reaction_type_) {
    jo("reaction_type", ToJson(*object.reaction_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateDefaultPaidReactionType &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateDefaultPaidReactionType");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateSavedMessagesTags &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSavedMessagesTags");
  jo("saved_messages_topic_id", object.saved_messages_topic_id_);
  if (object.tags_) {
    jo("tags", ToJson(*object.tags_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateActiveLiveLocationMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateActiveLiveLocationMessages");
  jo("messages", ToJson(object.messages_));
}

void to_json(JsonValueScope &jv, const td_api::updateOwnedStarCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateOwnedStarCount");
  if (object.star_amount_) {
    jo("star_amount", ToJson(*object.star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateOwnedTonCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateOwnedTonCount");
  jo("ton_amount", object.ton_amount_);
}

void to_json(JsonValueScope &jv, const td_api::updateChatRevenueAmount &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatRevenueAmount");
  jo("chat_id", object.chat_id_);
  if (object.revenue_amount_) {
    jo("revenue_amount", ToJson(*object.revenue_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateStarRevenueStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateStarRevenueStatus");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateTonRevenueStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateTonRevenueStatus");
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateSpeechRecognitionTrial &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSpeechRecognitionTrial");
  jo("max_media_duration", object.max_media_duration_);
  jo("weekly_count", object.weekly_count_);
  jo("left_count", object.left_count_);
  jo("next_reset_date", object.next_reset_date_);
}

void to_json(JsonValueScope &jv, const td_api::updateGroupCallMessageLevels &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateGroupCallMessageLevels");
  jo("levels", ToJson(object.levels_));
}

void to_json(JsonValueScope &jv, const td_api::updateDiceEmojis &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateDiceEmojis");
  jo("emojis", ToJson(object.emojis_));
}

void to_json(JsonValueScope &jv, const td_api::updateAnimatedEmojiMessageClicked &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAnimatedEmojiMessageClicked");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateAnimationSearchParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAnimationSearchParameters");
  jo("provider", object.provider_);
  jo("emojis", ToJson(object.emojis_));
}

void to_json(JsonValueScope &jv, const td_api::updateSuggestedActions &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSuggestedActions");
  jo("added_actions", ToJson(object.added_actions_));
  jo("removed_actions", ToJson(object.removed_actions_));
}

void to_json(JsonValueScope &jv, const td_api::updateSpeedLimitNotification &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateSpeedLimitNotification");
  jo("is_upload", JsonBool{object.is_upload_});
}

void to_json(JsonValueScope &jv, const td_api::updateContactCloseBirthdays &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateContactCloseBirthdays");
  jo("close_birthday_users", ToJson(object.close_birthday_users_));
}

void to_json(JsonValueScope &jv, const td_api::updateAutosaveSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateAutosaveSettings");
  if (object.scope_) {
    jo("scope", ToJson(*object.scope_));
  }
  if (object.settings_) {
    jo("settings", ToJson(*object.settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateBusinessConnection &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateBusinessConnection");
  if (object.connection_) {
    jo("connection", ToJson(*object.connection_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewBusinessMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewBusinessMessage");
  jo("connection_id", object.connection_id_);
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateBusinessMessageEdited &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateBusinessMessageEdited");
  jo("connection_id", object.connection_id_);
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateBusinessMessagesDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateBusinessMessagesDeleted");
  jo("connection_id", object.connection_id_);
  jo("chat_id", object.chat_id_);
  jo("message_ids", ToJson(object.message_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateNewInlineQuery &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewInlineQuery");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("sender_user_id", object.sender_user_id_);
  if (object.user_location_) {
    jo("user_location", ToJson(*object.user_location_));
  }
  if (object.chat_type_) {
    jo("chat_type", ToJson(*object.chat_type_));
  }
  jo("query", object.query_);
  jo("offset", object.offset_);
}

void to_json(JsonValueScope &jv, const td_api::updateNewChosenInlineResult &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewChosenInlineResult");
  jo("sender_user_id", object.sender_user_id_);
  if (object.user_location_) {
    jo("user_location", ToJson(*object.user_location_));
  }
  jo("query", object.query_);
  jo("result_id", object.result_id_);
  jo("inline_message_id", object.inline_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::updateNewCallbackQuery &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewCallbackQuery");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("sender_user_id", object.sender_user_id_);
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("chat_instance", ToJson(JsonInt64{object.chat_instance_}));
  if (object.payload_) {
    jo("payload", ToJson(*object.payload_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewInlineCallbackQuery &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewInlineCallbackQuery");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("sender_user_id", object.sender_user_id_);
  jo("inline_message_id", object.inline_message_id_);
  jo("chat_instance", ToJson(JsonInt64{object.chat_instance_}));
  if (object.payload_) {
    jo("payload", ToJson(*object.payload_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewBusinessCallbackQuery &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewBusinessCallbackQuery");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("sender_user_id", object.sender_user_id_);
  jo("connection_id", object.connection_id_);
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("chat_instance", ToJson(JsonInt64{object.chat_instance_}));
  if (object.payload_) {
    jo("payload", ToJson(*object.payload_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewShippingQuery &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewShippingQuery");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("sender_user_id", object.sender_user_id_);
  jo("invoice_payload", object.invoice_payload_);
  if (object.shipping_address_) {
    jo("shipping_address", ToJson(*object.shipping_address_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewPreCheckoutQuery &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewPreCheckoutQuery");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("sender_user_id", object.sender_user_id_);
  jo("currency", object.currency_);
  jo("total_amount", object.total_amount_);
  jo("invoice_payload", base64_encode(object.invoice_payload_));
  jo("shipping_option_id", object.shipping_option_id_);
  if (object.order_info_) {
    jo("order_info", ToJson(*object.order_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewCustomEvent &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewCustomEvent");
  jo("event", object.event_);
}

void to_json(JsonValueScope &jv, const td_api::updateNewCustomQuery &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewCustomQuery");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("data", object.data_);
  jo("timeout", object.timeout_);
}

void to_json(JsonValueScope &jv, const td_api::updatePoll &object) {
  auto jo = jv.enter_object();
  jo("@type", "updatePoll");
  if (object.poll_) {
    jo("poll", ToJson(*object.poll_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updatePollAnswer &object) {
  auto jo = jv.enter_object();
  jo("@type", "updatePollAnswer");
  jo("poll_id", ToJson(JsonInt64{object.poll_id_}));
  if (object.voter_id_) {
    jo("voter_id", ToJson(*object.voter_id_));
  }
  jo("option_ids", ToJson(object.option_ids_));
}

void to_json(JsonValueScope &jv, const td_api::updateChatMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatMember");
  jo("chat_id", object.chat_id_);
  jo("actor_user_id", object.actor_user_id_);
  jo("date", object.date_);
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
  jo("via_join_request", JsonBool{object.via_join_request_});
  jo("via_chat_folder_invite_link", JsonBool{object.via_chat_folder_invite_link_});
  if (object.old_chat_member_) {
    jo("old_chat_member", ToJson(*object.old_chat_member_));
  }
  if (object.new_chat_member_) {
    jo("new_chat_member", ToJson(*object.new_chat_member_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateNewChatJoinRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateNewChatJoinRequest");
  jo("chat_id", object.chat_id_);
  if (object.request_) {
    jo("request", ToJson(*object.request_));
  }
  jo("user_chat_id", object.user_chat_id_);
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateChatBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateChatBoost");
  jo("chat_id", object.chat_id_);
  if (object.boost_) {
    jo("boost", ToJson(*object.boost_));
  }
}

void to_json(JsonValueScope &jv, const td_api::updateMessageReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageReaction");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.actor_id_) {
    jo("actor_id", ToJson(*object.actor_id_));
  }
  jo("date", object.date_);
  jo("old_reaction_types", ToJson(object.old_reaction_types_));
  jo("new_reaction_types", ToJson(object.new_reaction_types_));
}

void to_json(JsonValueScope &jv, const td_api::updateMessageReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "updateMessageReactions");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("date", object.date_);
  jo("reactions", ToJson(object.reactions_));
}

void to_json(JsonValueScope &jv, const td_api::updatePaidMediaPurchased &object) {
  auto jo = jv.enter_object();
  jo("@type", "updatePaidMediaPurchased");
  jo("user_id", object.user_id_);
  jo("payload", object.payload_);
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftModelCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftModelCount");
  if (object.model_) {
    jo("model", ToJson(*object.model_));
  }
  jo("total_count", object.total_count_);
}

void to_json(JsonValueScope &jv, const td_api::UserPrivacySetting &object) {
  td_api::downcast_call(const_cast<td_api::UserPrivacySetting &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingShowStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingShowStatus");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingShowProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingShowProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingShowLinkInForwardedMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingShowLinkInForwardedMessages");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingShowPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingShowPhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingShowBio &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingShowBio");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingShowBirthdate &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingShowBirthdate");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingShowProfileAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingShowProfileAudio");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingAllowChatInvites &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingAllowChatInvites");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingAllowCalls &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingAllowCalls");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingAllowPeerToPeerCalls &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingAllowPeerToPeerCalls");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingAllowFindingByPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingAllowFindingByPhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingAutosaveGifts &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingAutosaveGifts");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingAllowUnpaidMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingAllowUnpaidMessages");
}

void to_json(JsonValueScope &jv, const td_api::validatedOrderInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "validatedOrderInfo");
  jo("order_info_id", object.order_info_id_);
  jo("shipping_options", ToJson(object.shipping_options_));
}

void to_json(JsonValueScope &jv, const td_api::videoStoryboard &object) {
  auto jo = jv.enter_object();
  jo("@type", "videoStoryboard");
  if (object.storyboard_file_) {
    jo("storyboard_file", ToJson(*object.storyboard_file_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.map_file_) {
    jo("map_file", ToJson(*object.map_file_));
  }
}

}  // namespace td_api
}  // namespace td
