#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::BackgroundType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"backgroundTypeWallpaper", 1972128891},
    {"backgroundTypePattern", 1290213117},
    {"backgroundTypeFill", 993008684},
    {"backgroundTypeChatTheme", 1299879762}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatList *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatListMain", -400991316},
    {"chatListArchive", 362770115},
    {"chatListFolder", 385760856}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::FileType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"fileTypeNone", 2003009189},
    {"fileTypeAnimation", -290816582},
    {"fileTypeAudio", -709112160},
    {"fileTypeDocument", -564722929},
    {"fileTypeNotificationSound", -1020289271},
    {"fileTypePhoto", -1718914651},
    {"fileTypePhotoStory", 2018995956},
    {"fileTypeProfilePhoto", 1795089315},
    {"fileTypeSecret", -1871899401},
    {"fileTypeSecretThumbnail", -1401326026},
    {"fileTypeSecure", -1419133146},
    {"fileTypeSelfDestructingPhoto", 2077176475},
    {"fileTypeSelfDestructingVideo", -1223900123},
    {"fileTypeSelfDestructingVideoNote", 1495274177},
    {"fileTypeSelfDestructingVoiceNote", 1691409181},
    {"fileTypeSticker", 475233385},
    {"fileTypeThumbnail", -12443298},
    {"fileTypeUnknown", -2011566768},
    {"fileTypeVideo", 1430816539},
    {"fileTypeVideoNote", -518412385},
    {"fileTypeVideoStory", -2146754143},
    {"fileTypeVoiceNote", -588681661},
    {"fileTypeWallpaper", 1854930076}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputChatPhoto *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputChatPhotoPrevious", 23128529},
    {"inputChatPhotoStatic", 1979179699},
    {"inputChatPhotoAnimation", 90846242},
    {"inputChatPhotoSticker", 1315861341}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputPaidMediaType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputPaidMediaTypePhoto", -761660134},
    {"inputPaidMediaTypeVideo", 1793741625}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::LogStream *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"logStreamDefault", 1390581436},
    {"logStreamFile", 1532136933},
    {"logStreamEmpty", -499912244}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::NotificationSettingsScope *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"notificationSettingsScopePrivateChats", 937446759},
    {"notificationSettingsScopeGroupChats", 1212142067},
    {"notificationSettingsScopeChannelChats", 548013448}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PremiumStoryFeature *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"premiumStoryFeaturePriorityOrder", -1880001849},
    {"premiumStoryFeatureStealthMode", 1194605988},
    {"premiumStoryFeaturePermanentViewsHistory", -1029683296},
    {"premiumStoryFeatureCustomExpirationDuration", -593229162},
    {"premiumStoryFeatureSaveStories", -1501286467},
    {"premiumStoryFeatureLinksAndFormatting", -622623753},
    {"premiumStoryFeatureVideoQuality", -1162887511}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::SearchMessagesChatTypeFilter *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"searchMessagesChatTypeFilterPrivate", 1169248975},
    {"searchMessagesChatTypeFilterGroup", -2059426022},
    {"searchMessagesChatTypeFilterChannel", -773540139}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::SuggestedPostPrice *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"suggestedPostPriceStar", 216488903},
    {"suggestedPostPriceTon", -1095222334}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::UserPrivacySetting *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"userPrivacySettingShowStatus", 1862829310},
    {"userPrivacySettingShowProfilePhoto", 1408485877},
    {"userPrivacySettingShowLinkInForwardedMessages", 592688870},
    {"userPrivacySettingShowPhoneNumber", -791567831},
    {"userPrivacySettingShowBio", 959981409},
    {"userPrivacySettingShowBirthdate", 1167504607},
    {"userPrivacySettingShowProfileAudio", 610353549},
    {"userPrivacySettingAllowChatInvites", 1271668007},
    {"userPrivacySettingAllowCalls", -906967291},
    {"userPrivacySettingAllowPeerToPeerCalls", 352500032},
    {"userPrivacySettingAllowFindingByPhoneNumber", -1846645423},
    {"userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages", 338112060},
    {"userPrivacySettingAutosaveGifts", 1889167821},
    {"userPrivacySettingAllowUnpaidMessages", 1430051047}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::affiliateProgramSortOrderRevenue &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::autosaveSettingsScopeChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::blockListMain &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::botCommandScopeChatMember &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::businessFeatureOpeningHours &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessFeatureUpgradedStories &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callProblemDistortedSpeech &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callbackQueryPayloadGame &to, JsonObject &from) {
  TRY_STATUS(from_json(to.game_short_name_, from.extract_field("game_short_name")));
  return Status::OK();
}

Status from_json(td_api::chatActionChoosingLocation &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatAvailableReactionsSome &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reactions_, from.extract_field("reactions")));
  TRY_STATUS(from_json(to.max_reaction_count_, from.extract_field("max_reaction_count")));
  return Status::OK();
}

Status from_json(td_api::chatListFolder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterAdministrators &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatPhotoStickerTypeRegularOrMask &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_set_id_, from.extract_field("sticker_set_id")));
  TRY_STATUS(from_json(to.sticker_id_, from.extract_field("sticker_id")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenWindowsPush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.access_token_, from.extract_field("access_token")));
  return Status::OK();
}

Status from_json(td_api::draftMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  TRY_STATUS(from_json(to.input_message_text_, from.extract_field("input_message_text")));
  TRY_STATUS(from_json(to.effect_id_, from.extract_field("effect_id")));
  TRY_STATUS(from_json(to.suggested_post_info_, from.extract_field("suggested_post_info")));
  return Status::OK();
}

Status from_json(td_api::emojiStatusTypeCustomEmoji &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_emoji_id_, from.extract_field("custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::fileTypePhotoStory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeSticker &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::firebaseAuthenticationSettingsIos &to, JsonObject &from) {
  TRY_STATUS(from_json(to.device_token_, from.extract_field("device_token")));
  TRY_STATUS(from_json(to.is_app_sandbox_, from.extract_field("is_app_sandbox")));
  return Status::OK();
}

Status from_json(td_api::giveawayParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.boosted_chat_id_, from.extract_field("boosted_chat_id")));
  TRY_STATUS(from_json(to.additional_chat_ids_, from.extract_field("additional_chat_ids")));
  TRY_STATUS(from_json(to.winners_selection_date_, from.extract_field("winners_selection_date")));
  TRY_STATUS(from_json(to.only_new_members_, from.extract_field("only_new_members")));
  TRY_STATUS(from_json(to.has_public_winners_, from.extract_field("has_public_winners")));
  TRY_STATUS(from_json(to.country_codes_, from.extract_field("country_codes")));
  TRY_STATUS(from_json(to.prize_description_, from.extract_field("prize_description")));
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeCopyText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::inputChatPhotoPrevious &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_photo_id_, from.extract_field("chat_photo_id")));
  return Status::OK();
}

Status from_json(td_api::inputCredentialsNew &to, JsonObject &from) {
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  TRY_STATUS(from_json(to.allow_save_, from.extract_field("allow_save")));
  return Status::OK();
}

Status from_json(td_api::inputIdentityDocument &to, JsonObject &from) {
  TRY_STATUS(from_json(to.number_, from.extract_field("number")));
  TRY_STATUS(from_json(to.expiration_date_, from.extract_field("expiration_date")));
  TRY_STATUS(from_json(to.front_side_, from.extract_field("front_side")));
  TRY_STATUS(from_json(to.reverse_side_, from.extract_field("reverse_side")));
  TRY_STATUS(from_json(to.selfie_, from.extract_field("selfie")));
  TRY_STATUS(from_json(to.translation_, from.extract_field("translation")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.sticker_url_, from.extract_field("sticker_url")));
  TRY_STATUS(from_json(to.sticker_width_, from.extract_field("sticker_width")));
  TRY_STATUS(from_json(to.sticker_height_, from.extract_field("sticker_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessageAudio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.audio_, from.extract_field("audio")));
  TRY_STATUS(from_json(to.album_cover_thumbnail_, from.extract_field("album_cover_thumbnail")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.performer_, from.extract_field("performer")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  return Status::OK();
}

Status from_json(td_api::inputMessageVenue &to, JsonObject &from) {
  TRY_STATUS(from_json(to.venue_, from.extract_field("venue")));
  return Status::OK();
}

Status from_json(td_api::inputMessageReplyToMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.quote_, from.extract_field("quote")));
  TRY_STATUS(from_json(to.checklist_task_id_, from.extract_field("checklist_task_id")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementIdentityCard &to, JsonObject &from) {
  TRY_STATUS(from_json(to.identity_card_, from.extract_field("identity_card")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementEmailAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.email_address_, from.extract_field("email_address")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceFile &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.file_hash_, from.extract_field("file_hash")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::inputThumbnail &to, JsonObject &from) {
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.width_, from.extract_field("width")));
  TRY_STATUS(from_json(to.height_, from.extract_field("height")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeBuyStars &to, JsonObject &from) {
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  TRY_STATUS(from_json(to.purpose_, from.extract_field("purpose")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeEditProfileSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeLoginEmailSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePhoneNumberPrivacySettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeUserPhoneNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.draft_text_, from.extract_field("draft_text")));
  TRY_STATUS(from_json(to.open_profile_, from.extract_field("open_profile")));
  return Status::OK();
}

Status from_json(td_api::jsonValueString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeRequestChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.chat_is_channel_, from.extract_field("chat_is_channel")));
  TRY_STATUS(from_json(to.restrict_chat_is_forum_, from.extract_field("restrict_chat_is_forum")));
  TRY_STATUS(from_json(to.chat_is_forum_, from.extract_field("chat_is_forum")));
  TRY_STATUS(from_json(to.restrict_chat_has_username_, from.extract_field("restrict_chat_has_username")));
  TRY_STATUS(from_json(to.chat_has_username_, from.extract_field("chat_has_username")));
  TRY_STATUS(from_json(to.chat_is_created_, from.extract_field("chat_is_created")));
  TRY_STATUS(from_json(to.user_administrator_rights_, from.extract_field("user_administrator_rights")));
  TRY_STATUS(from_json(to.bot_administrator_rights_, from.extract_field("bot_administrator_rights")));
  TRY_STATUS(from_json(to.bot_is_member_, from.extract_field("bot_is_member")));
  TRY_STATUS(from_json(to.request_title_, from.extract_field("request_title")));
  TRY_STATUS(from_json(to.request_username_, from.extract_field("request_username")));
  TRY_STATUS(from_json(to.request_photo_, from.extract_field("request_photo")));
  return Status::OK();
}

Status from_json(td_api::location &to, JsonObject &from) {
  TRY_STATUS(from_json(to.latitude_, from.extract_field("latitude")));
  TRY_STATUS(from_json(to.longitude_, from.extract_field("longitude")));
  TRY_STATUS(from_json(to.horizontal_accuracy_, from.extract_field("horizontal_accuracy")));
  return Status::OK();
}

Status from_json(td_api::maskPosition &to, JsonObject &from) {
  TRY_STATUS(from_json(to.point_, from.extract_field("point")));
  TRY_STATUS(from_json(to.x_shift_, from.extract_field("x_shift")));
  TRY_STATUS(from_json(to.y_shift_, from.extract_field("y_shift")));
  TRY_STATUS(from_json(to.scale_, from.extract_field("scale")));
  return Status::OK();
}

Status from_json(td_api::messageSenderUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::messageSourceChatEventLog &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkStatisticsEntryCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.network_type_, from.extract_field("network_type")));
  TRY_STATUS(from_json(to.sent_bytes_, from.extract_field("sent_bytes")));
  TRY_STATUS(from_json(to.received_bytes_, from.extract_field("received_bytes")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  return Status::OK();
}

Status from_json(td_api::notificationSettingsScopeChannelChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypePersonalDetails &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypePassportRegistration &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::pollTypeRegular &to, JsonObject &from) {
  TRY_STATUS(from_json(to.allow_multiple_answers_, from.extract_field("allow_multiple_answers")));
  return Status::OK();
}

Status from_json(td_api::premiumFeatureCustomEmoji &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureChatBoost &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeSupergroupCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeCaptionLength &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeSimilarChatCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeaturePermanentViewsHistory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabLinks &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::reactionNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_reaction_source_, from.extract_field("message_reaction_source")));
  TRY_STATUS(from_json(to.story_reaction_source_, from.extract_field("story_reaction_source")));
  TRY_STATUS(from_json(to.sound_id_, from.extract_field("sound_id")));
  TRY_STATUS(from_json(to.show_preview_, from.extract_field("show_preview")));
  return Status::OK();
}

Status from_json(td_api::replyMarkupForceReply &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  TRY_STATUS(from_json(to.input_field_placeholder_, from.extract_field("input_field_placeholder")));
  return Status::OK();
}

Status from_json(td_api::reportReasonFake &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesChatTypeFilterGroup &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterPhotoAndVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterPinned &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::storePaymentPurposePremiumSubscription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_restore_, from.extract_field("is_restore")));
  TRY_STATUS(from_json(to.is_upgrade_, from.extract_field("is_upgrade")));
  return Status::OK();
}

Status from_json(td_api::storyAreaPosition &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_percentage_, from.extract_field("x_percentage")));
  TRY_STATUS(from_json(to.y_percentage_, from.extract_field("y_percentage")));
  TRY_STATUS(from_json(to.width_percentage_, from.extract_field("width_percentage")));
  TRY_STATUS(from_json(to.height_percentage_, from.extract_field("height_percentage")));
  TRY_STATUS(from_json(to.rotation_angle_, from.extract_field("rotation_angle")));
  TRY_STATUS(from_json(to.corner_radius_percentage_, from.extract_field("corner_radius_percentage")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionCheckPassword &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionSetBirthdate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterContacts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::targetChatInternalLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::testInt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypePhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypePreCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_, from.extract_field("language")));
  return Status::OK();
}

Status from_json(td_api::themeParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.background_color_, from.extract_field("background_color")));
  TRY_STATUS(from_json(to.secondary_background_color_, from.extract_field("secondary_background_color")));
  TRY_STATUS(from_json(to.header_background_color_, from.extract_field("header_background_color")));
  TRY_STATUS(from_json(to.bottom_bar_background_color_, from.extract_field("bottom_bar_background_color")));
  TRY_STATUS(from_json(to.section_background_color_, from.extract_field("section_background_color")));
  TRY_STATUS(from_json(to.section_separator_color_, from.extract_field("section_separator_color")));
  TRY_STATUS(from_json(to.text_color_, from.extract_field("text_color")));
  TRY_STATUS(from_json(to.accent_text_color_, from.extract_field("accent_text_color")));
  TRY_STATUS(from_json(to.section_header_text_color_, from.extract_field("section_header_text_color")));
  TRY_STATUS(from_json(to.subtitle_text_color_, from.extract_field("subtitle_text_color")));
  TRY_STATUS(from_json(to.destructive_text_color_, from.extract_field("destructive_text_color")));
  TRY_STATUS(from_json(to.hint_color_, from.extract_field("hint_color")));
  TRY_STATUS(from_json(to.link_color_, from.extract_field("link_color")));
  TRY_STATUS(from_json(to.button_color_, from.extract_field("button_color")));
  TRY_STATUS(from_json(to.button_text_color_, from.extract_field("button_text_color")));
  return Status::OK();
}

Status from_json(td_api::transactionDirectionIncoming &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAutosaveGifts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::webAppOpenParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.theme_, from.extract_field("theme")));
  TRY_STATUS(from_json(to.application_name_, from.extract_field("application_name")));
  TRY_STATUS(from_json(to.mode_, from.extract_field("mode")));
  return Status::OK();
}

Status from_json(td_api::addChecklistTasks &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.tasks_, from.extract_field("tasks")));
  return Status::OK();
}

Status from_json(td_api::addNetworkStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.entry_, from.extract_field("entry")));
  return Status::OK();
}

Status from_json(td_api::addRecentSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_attached_, from.extract_field("is_attached")));
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::answerCustomQuery &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_query_id_, from.extract_field("custom_query_id")));
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::banGroupCallParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::canTransferOwnership &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationEmailCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::checkLoginEmailAddressCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::clearAllDraftMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.exclude_secret_chats_, from.extract_field("exclude_secret_chats")));
  return Status::OK();
}

Status from_json(td_api::clickChatSponsoredMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.is_media_click_, from.extract_field("is_media_click")));
  TRY_STATUS(from_json(to.from_fullscreen_, from.extract_field("from_fullscreen")));
  return Status::OK();
}

Status from_json(td_api::commitPendingPaidMessageReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::createChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.expiration_date_, from.extract_field("expiration_date")));
  TRY_STATUS(from_json(to.member_limit_, from.extract_field("member_limit")));
  TRY_STATUS(from_json(to.creates_join_request_, from.extract_field("creates_join_request")));
  return Status::OK();
}

Status from_json(td_api::createNewSupergroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.is_forum_, from.extract_field("is_forum")));
  TRY_STATUS(from_json(to.is_channel_, from.extract_field("is_channel")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.message_auto_delete_time_, from.extract_field("message_auto_delete_time")));
  TRY_STATUS(from_json(to.for_import_, from.extract_field("for_import")));
  return Status::OK();
}

Status from_json(td_api::decryptGroupCallData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.participant_id_, from.extract_field("participant_id")));
  TRY_STATUS(from_json(to.data_channel_, from.extract_field("data_channel")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::deleteChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::deleteDefaultBackground &to, JsonObject &from) {
  TRY_STATUS(from_json(to.for_dark_theme_, from.extract_field("for_dark_theme")));
  return Status::OK();
}

Status from_json(td_api::deleteMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.revoke_, from.extract_field("revoke")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedOrderInfo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::disconnectAllWebsites &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::editForumTopic &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.edit_icon_custom_emoji_, from.extract_field("edit_icon_custom_emoji")));
  TRY_STATUS(from_json(to.icon_custom_emoji_id_, from.extract_field("icon_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::editMessageMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::editUserStarSubscription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.telegram_payment_charge_id_, from.extract_field("telegram_payment_charge_id")));
  TRY_STATUS(from_json(to.is_canceled_, from.extract_field("is_canceled")));
  return Status::OK();
}

Status from_json(td_api::getActiveSessions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAttachmentMenuBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getBasicGroupFullInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.basic_group_id_, from.extract_field("basic_group_id")));
  return Status::OK();
}

Status from_json(td_api::getBusinessAccountStarAmount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  return Status::OK();
}

Status from_json(td_api::getChatActiveStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::getChatMessageCalendar &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  return Status::OK();
}

Status from_json(td_api::getChatScheduledMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatsForChatFolderInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getCountries &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDeepLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::getDirectMessagesChatTopicMessageByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  return Status::OK();
}

Status from_json(td_api::getFile &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::getGameHighScores &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getGroupCallStreamSegment &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.time_offset_, from.extract_field("time_offset")));
  TRY_STATUS(from_json(to.scale_, from.extract_field("scale")));
  TRY_STATUS(from_json(to.channel_id_, from.extract_field("channel_id")));
  TRY_STATUS(from_json(to.video_quality_, from.extract_field("video_quality")));
  return Status::OK();
}

Status from_json(td_api::getInternalLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.is_http_, from.extract_field("is_http")));
  return Status::OK();
}

Status from_json(td_api::getLiveStoryAvailableMessageSenders &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getLoginUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.button_id_, from.extract_field("button_id")));
  TRY_STATUS(from_json(to.allow_write_access_, from.extract_field("allow_write_access")));
  return Status::OK();
}

Status from_json(td_api::getMessageAuthor &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getMessageProperties &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getNewChatPrivacySettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getPaymentForm &to, JsonObject &from) {
  TRY_STATUS(from_json(to.input_invoice_, from.extract_field("input_invoice")));
  TRY_STATUS(from_json(to.theme_, from.extract_field("theme")));
  return Status::OK();
}

Status from_json(td_api::getPremiumInfoSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.month_count_, from.extract_field("month_count")));
  return Status::OK();
}

Status from_json(td_api::getPushReceiverId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  return Status::OK();
}

Status from_json(td_api::getRecommendedChatFolders &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getSavedNotificationSound &to, JsonObject &from) {
  TRY_STATUS(from_json(to.notification_sound_id_, from.extract_field("notification_sound_id")));
  return Status::OK();
}

Status from_json(td_api::getStarGiveawayPaymentOptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.set_id_, from.extract_field("set_id")));
  return Status::OK();
}

Status from_json(td_api::getStoryNotificationSettingsExceptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getSupergroupMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getTonRevenueStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_dark_, from.extract_field("is_dark")));
  return Status::OK();
}

Status from_json(td_api::getUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getVideoChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.can_self_unmute_, from.extract_field("can_self_unmute")));
  return Status::OK();
}

Status from_json(td_api::hideSuggestedAction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.action_, from.extract_field("action")));
  return Status::OK();
}

Status from_json(td_api::joinGroupCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.input_group_call_, from.extract_field("input_group_call")));
  TRY_STATUS(from_json(to.join_parameters_, from.extract_field("join_parameters")));
  return Status::OK();
}

Status from_json(td_api::loadGroupCallParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::openMessageContent &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::postStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.content_, from.extract_field("content")));
  TRY_STATUS(from_json(to.areas_, from.extract_field("areas")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.privacy_settings_, from.extract_field("privacy_settings")));
  TRY_STATUS(from_json(to.album_ids_, from.extract_field("album_ids")));
  TRY_STATUS(from_json(to.active_period_, from.extract_field("active_period")));
  TRY_STATUS(from_json(to.from_story_full_id_, from.extract_field("from_story_full_id")));
  TRY_STATUS(from_json(to.is_posted_to_chat_page_, from.extract_field("is_posted_to_chat_page")));
  TRY_STATUS(from_json(to.protect_content_, from.extract_field("protect_content")));
  return Status::OK();
}

Status from_json(td_api::readAllDirectMessagesChatTopicReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  return Status::OK();
}

Status from_json(td_api::recoverPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.recovery_code_, from.extract_field("recovery_code")));
  TRY_STATUS(from_json(to.new_password_, from.extract_field("new_password")));
  TRY_STATUS(from_json(to.new_hint_, from.extract_field("new_hint")));
  return Status::OK();
}

Status from_json(td_api::removeFileFromDownloads &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  TRY_STATUS(from_json(to.delete_from_cache_, from.extract_field("delete_from_cache")));
  return Status::OK();
}

Status from_json(td_api::removeProfileAudio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::removeStoryAlbumStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  TRY_STATUS(from_json(to.story_ids_, from.extract_field("story_ids")));
  return Status::OK();
}

Status from_json(td_api::reorderQuickReplyShortcuts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_ids_, from.extract_field("shortcut_ids")));
  return Status::OK();
}

Status from_json(td_api::reportChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json_bytes(to.option_id_, from.extract_field("option_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::reportVideoMessageAdvertisement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.advertisement_unique_id_, from.extract_field("advertisement_unique_id")));
  TRY_STATUS(from_json_bytes(to.option_id_, from.extract_field("option_id")));
  return Status::OK();
}

Status from_json(td_api::resendRecoveryEmailAddressCode &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::saveApplicationLogEvent &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::searchChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchOutgoingDocumentMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchRecentlyFoundChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.web_app_short_name_, from.extract_field("web_app_short_name")));
  return Status::OK();
}

Status from_json(td_api::sendCallSignalingData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::sendPassportAuthorizationForm &to, JsonObject &from) {
  TRY_STATUS(from_json(to.authorization_form_id_, from.extract_field("authorization_form_id")));
  TRY_STATUS(from_json(to.types_, from.extract_field("types")));
  return Status::OK();
}

Status from_json(td_api::setAccentColor &to, JsonObject &from) {
  TRY_STATUS(from_json(to.accent_color_id_, from.extract_field("accent_color_id")));
  TRY_STATUS(from_json(to.background_custom_emoji_id_, from.extract_field("background_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::setAutosaveSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAccountGiftSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setBusinessOpeningHours &to, JsonObject &from) {
  TRY_STATUS(from_json(to.opening_hours_, from.extract_field("opening_hours")));
  return Status::OK();
}

Status from_json(td_api::setChatDirectMessagesGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_enabled_, from.extract_field("is_enabled")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  return Status::OK();
}

Status from_json(td_api::setChatPaidMessageStarCount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  return Status::OK();
}

Status from_json(td_api::setCommands &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.commands_, from.extract_field("commands")));
  return Status::OK();
}

Status from_json(td_api::setDefaultReactionType &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  return Status::OK();
}

Status from_json(td_api::setGroupCallPaidMessageStarCount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  return Status::OK();
}

Status from_json(td_api::setLoginEmailAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.new_login_email_address_, from.extract_field("new_login_email_address")));
  return Status::OK();
}

Status from_json(td_api::setNewChatPrivacySettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setPinnedGifts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.received_gift_ids_, from.extract_field("received_gift_ids")));
  return Status::OK();
}

Status from_json(td_api::setRecoveryEmailAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  TRY_STATUS(from_json(to.new_recovery_email_address_, from.extract_field("new_recovery_email_address")));
  return Status::OK();
}

Status from_json(td_api::setStoryAlbumName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::setUpgradedGiftColors &to, JsonObject &from) {
  TRY_STATUS(from_json(to.upgraded_gift_colors_id_, from.extract_field("upgraded_gift_colors_id")));
  return Status::OK();
}

Status from_json(td_api::shareChatWithBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.button_id_, from.extract_field("button_id")));
  TRY_STATUS(from_json(to.shared_chat_id_, from.extract_field("shared_chat_id")));
  TRY_STATUS(from_json(to.only_check_, from.extract_field("only_check")));
  return Status::OK();
}

Status from_json(td_api::suggestUserBirthdate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.birthdate_, from.extract_field("birthdate")));
  return Status::OK();
}

Status from_json(td_api::testCallVectorIntObject &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::toggleAllDownloadsArePaused &to, JsonObject &from) {
  TRY_STATUS(from_json(to.are_paused_, from.extract_field("are_paused")));
  return Status::OK();
}

Status from_json(td_api::toggleChatIsMarkedAsUnread &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_marked_as_unread_, from.extract_field("is_marked_as_unread")));
  return Status::OK();
}

Status from_json(td_api::toggleGiftIsSaved &to, JsonObject &from) {
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.is_saved_, from.extract_field("is_saved")));
  return Status::OK();
}

Status from_json(td_api::toggleSessionCanAcceptCalls &to, JsonObject &from) {
  TRY_STATUS(from_json(to.session_id_, from.extract_field("session_id")));
  TRY_STATUS(from_json(to.can_accept_calls_, from.extract_field("can_accept_calls")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupIsForum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.is_forum_, from.extract_field("is_forum")));
  TRY_STATUS(from_json(to.has_forum_tabs_, from.extract_field("has_forum_tabs")));
  return Status::OK();
}

Status from_json(td_api::transferChatOwnership &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::upgradeGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.keep_original_details_, from.extract_field("keep_original_details")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::accentColor &object) {
  auto jo = jv.enter_object();
  jo("@type", "accentColor");
  jo("id", object.id_);
  jo("built_in_accent_color_id", object.built_in_accent_color_id_);
  jo("light_theme_colors", ToJson(object.light_theme_colors_));
  jo("dark_theme_colors", ToJson(object.dark_theme_colors_));
  jo("min_channel_chat_boost_level", object.min_channel_chat_boost_level_);
}

void to_json(JsonValueScope &jv, const td_api::affiliateInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "affiliateInfo");
  jo("commission_per_mille", object.commission_per_mille_);
  jo("affiliate_chat_id", object.affiliate_chat_id_);
  if (object.star_amount_) {
    jo("star_amount", ToJson(*object.star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::archiveChatListSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "archiveChatListSettings");
  jo("archive_and_mute_new_chats_from_unknown_users", JsonBool{object.archive_and_mute_new_chats_from_unknown_users_});
  jo("keep_unmuted_chats_archived", JsonBool{object.keep_unmuted_chats_archived_});
  jo("keep_chats_from_folders_archived", JsonBool{object.keep_chats_from_folders_archived_});
}

void to_json(JsonValueScope &jv, const td_api::autoDownloadSettingsPresets &object) {
  auto jo = jv.enter_object();
  jo("@type", "autoDownloadSettingsPresets");
  if (object.low_) {
    jo("low", ToJson(*object.low_));
  }
  if (object.medium_) {
    jo("medium", ToJson(*object.medium_));
  }
  if (object.high_) {
    jo("high", ToJson(*object.high_));
  }
}

void to_json(JsonValueScope &jv, const td_api::BackgroundFill &object) {
  td_api::downcast_call(const_cast<td_api::BackgroundFill &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::backgroundFillSolid &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgroundFillSolid");
  jo("color", object.color_);
}

void to_json(JsonValueScope &jv, const td_api::backgroundFillGradient &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgroundFillGradient");
  jo("top_color", object.top_color_);
  jo("bottom_color", object.bottom_color_);
  jo("rotation_angle", object.rotation_angle_);
}

void to_json(JsonValueScope &jv, const td_api::backgroundFillFreeformGradient &object) {
  auto jo = jv.enter_object();
  jo("@type", "backgroundFillFreeformGradient");
  jo("colors", ToJson(object.colors_));
}

void to_json(JsonValueScope &jv, const td_api::botCommand &object) {
  auto jo = jv.enter_object();
  jo("@type", "botCommand");
  jo("command", object.command_);
  jo("description", object.description_);
}

void to_json(JsonValueScope &jv, const td_api::BotWriteAccessAllowReason &object) {
  td_api::downcast_call(const_cast<td_api::BotWriteAccessAllowReason &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::botWriteAccessAllowReasonConnectedWebsite &object) {
  auto jo = jv.enter_object();
  jo("@type", "botWriteAccessAllowReasonConnectedWebsite");
  jo("domain_name", object.domain_name_);
}

void to_json(JsonValueScope &jv, const td_api::botWriteAccessAllowReasonAddedToAttachmentMenu &object) {
  auto jo = jv.enter_object();
  jo("@type", "botWriteAccessAllowReasonAddedToAttachmentMenu");
}

void to_json(JsonValueScope &jv, const td_api::botWriteAccessAllowReasonLaunchedWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "botWriteAccessAllowReasonLaunchedWebApp");
  if (object.web_app_) {
    jo("web_app", ToJson(*object.web_app_));
  }
}

void to_json(JsonValueScope &jv, const td_api::botWriteAccessAllowReasonAcceptedRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "botWriteAccessAllowReasonAcceptedRequest");
}

void to_json(JsonValueScope &jv, const td_api::businessConnectedBot &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessConnectedBot");
  jo("bot_user_id", object.bot_user_id_);
  if (object.recipients_) {
    jo("recipients", ToJson(*object.recipients_));
  }
  if (object.rights_) {
    jo("rights", ToJson(*object.rights_));
  }
}

void to_json(JsonValueScope &jv, const td_api::businessMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessMessages");
  jo("messages", ToJson(object.messages_));
}

void to_json(JsonValueScope &jv, const td_api::callServer &object) {
  auto jo = jv.enter_object();
  jo("@type", "callServer");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("ip_address", object.ip_address_);
  jo("ipv6_address", object.ipv6_address_);
  jo("port", object.port_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chat &object) {
  auto jo = jv.enter_object();
  jo("@type", "chat");
  jo("id", object.id_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("title", object.title_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("accent_color_id", object.accent_color_id_);
  jo("background_custom_emoji_id", ToJson(JsonInt64{object.background_custom_emoji_id_}));
  if (object.upgraded_gift_colors_) {
    jo("upgraded_gift_colors", ToJson(*object.upgraded_gift_colors_));
  }
  jo("profile_accent_color_id", object.profile_accent_color_id_);
  jo("profile_background_custom_emoji_id", ToJson(JsonInt64{object.profile_background_custom_emoji_id_}));
  if (object.permissions_) {
    jo("permissions", ToJson(*object.permissions_));
  }
  if (object.last_message_) {
    jo("last_message", ToJson(*object.last_message_));
  }
  jo("positions", ToJson(object.positions_));
  jo("chat_lists", ToJson(object.chat_lists_));
  if (object.message_sender_id_) {
    jo("message_sender_id", ToJson(*object.message_sender_id_));
  }
  if (object.block_list_) {
    jo("block_list", ToJson(*object.block_list_));
  }
  jo("has_protected_content", JsonBool{object.has_protected_content_});
  jo("is_translatable", JsonBool{object.is_translatable_});
  jo("is_marked_as_unread", JsonBool{object.is_marked_as_unread_});
  jo("view_as_topics", JsonBool{object.view_as_topics_});
  jo("has_scheduled_messages", JsonBool{object.has_scheduled_messages_});
  jo("can_be_deleted_only_for_self", JsonBool{object.can_be_deleted_only_for_self_});
  jo("can_be_deleted_for_all_users", JsonBool{object.can_be_deleted_for_all_users_});
  jo("can_be_reported", JsonBool{object.can_be_reported_});
  jo("default_disable_notification", JsonBool{object.default_disable_notification_});
  jo("unread_count", object.unread_count_);
  jo("last_read_inbox_message_id", object.last_read_inbox_message_id_);
  jo("last_read_outbox_message_id", object.last_read_outbox_message_id_);
  jo("unread_mention_count", object.unread_mention_count_);
  jo("unread_reaction_count", object.unread_reaction_count_);
  if (object.notification_settings_) {
    jo("notification_settings", ToJson(*object.notification_settings_));
  }
  if (object.available_reactions_) {
    jo("available_reactions", ToJson(*object.available_reactions_));
  }
  jo("message_auto_delete_time", object.message_auto_delete_time_);
  if (object.emoji_status_) {
    jo("emoji_status", ToJson(*object.emoji_status_));
  }
  if (object.background_) {
    jo("background", ToJson(*object.background_));
  }
  if (object.theme_) {
    jo("theme", ToJson(*object.theme_));
  }
  if (object.action_bar_) {
    jo("action_bar", ToJson(*object.action_bar_));
  }
  if (object.business_bot_manage_bar_) {
    jo("business_bot_manage_bar", ToJson(*object.business_bot_manage_bar_));
  }
  if (object.video_chat_) {
    jo("video_chat", ToJson(*object.video_chat_));
  }
  if (object.pending_join_requests_) {
    jo("pending_join_requests", ToJson(*object.pending_join_requests_));
  }
  jo("reply_markup_message_id", object.reply_markup_message_id_);
  if (object.draft_message_) {
    jo("draft_message", ToJson(*object.draft_message_));
  }
  jo("client_data", object.client_data_);
}

void to_json(JsonValueScope &jv, const td_api::chatBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoost");
  jo("id", object.id_);
  jo("count", object.count_);
  if (object.source_) {
    jo("source", ToJson(*object.source_));
  }
  jo("start_date", object.start_date_);
  jo("expiration_date", object.expiration_date_);
}

void to_json(JsonValueScope &jv, const td_api::chatEvent &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatEvent");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("date", object.date_);
  if (object.member_id_) {
    jo("member_id", ToJson(*object.member_id_));
  }
  if (object.action_) {
    jo("action", ToJson(*object.action_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatFolderName &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolderName");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("animate_custom_emoji", JsonBool{object.animate_custom_emoji_});
}

void to_json(JsonValueScope &jv, const td_api::chatJoinRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatJoinRequest");
  jo("user_id", object.user_id_);
  jo("date", object.date_);
  jo("bio", object.bio_);
}

void to_json(JsonValueScope &jv, const td_api::chatMessageSender &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMessageSender");
  if (object.sender_) {
    jo("sender", ToJson(*object.sender_));
  }
  jo("needs_premium", JsonBool{object.needs_premium_});
}

void to_json(JsonValueScope &jv, const td_api::chatPosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPosition");
  if (object.list_) {
    jo("list", ToJson(*object.list_));
  }
  jo("order", ToJson(JsonInt64{object.order_}));
  jo("is_pinned", JsonBool{object.is_pinned_});
  if (object.source_) {
    jo("source", ToJson(*object.source_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsInteractionInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsInteractionInfo");
  if (object.object_type_) {
    jo("object_type", ToJson(*object.object_type_));
  }
  jo("view_count", object.view_count_);
  jo("forward_count", object.forward_count_);
  jo("reaction_count", object.reaction_count_);
}

void to_json(JsonValueScope &jv, const td_api::checklist &object) {
  auto jo = jv.enter_object();
  jo("@type", "checklist");
  if (object.title_) {
    jo("title", ToJson(*object.title_));
  }
  jo("tasks", ToJson(object.tasks_));
  jo("others_can_add_tasks", JsonBool{object.others_can_add_tasks_});
  jo("can_add_tasks", JsonBool{object.can_add_tasks_});
  jo("others_can_mark_tasks_as_done", JsonBool{object.others_can_mark_tasks_as_done_});
  jo("can_mark_tasks_as_done", JsonBool{object.can_mark_tasks_as_done_});
}

void to_json(JsonValueScope &jv, const td_api::ConnectionState &object) {
  td_api::downcast_call(const_cast<td_api::ConnectionState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::connectionStateWaitingForNetwork &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectionStateWaitingForNetwork");
}

void to_json(JsonValueScope &jv, const td_api::connectionStateConnectingToProxy &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectionStateConnectingToProxy");
}

void to_json(JsonValueScope &jv, const td_api::connectionStateConnecting &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectionStateConnecting");
}

void to_json(JsonValueScope &jv, const td_api::connectionStateUpdating &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectionStateUpdating");
}

void to_json(JsonValueScope &jv, const td_api::connectionStateReady &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectionStateReady");
}

void to_json(JsonValueScope &jv, const td_api::databaseStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "databaseStatistics");
  jo("statistics", object.statistics_);
}

void to_json(JsonValueScope &jv, const td_api::draftMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "draftMessage");
  if (object.reply_to_) {
    jo("reply_to", ToJson(*object.reply_to_));
  }
  jo("date", object.date_);
  if (object.input_message_text_) {
    jo("input_message_text", ToJson(*object.input_message_text_));
  }
  jo("effect_id", ToJson(JsonInt64{object.effect_id_}));
  if (object.suggested_post_info_) {
    jo("suggested_post_info", ToJson(*object.suggested_post_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::emojiReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiReaction");
  jo("emoji", object.emoji_);
  jo("title", object.title_);
  jo("is_active", JsonBool{object.is_active_});
  if (object.static_icon_) {
    jo("static_icon", ToJson(*object.static_icon_));
  }
  if (object.appear_animation_) {
    jo("appear_animation", ToJson(*object.appear_animation_));
  }
  if (object.select_animation_) {
    jo("select_animation", ToJson(*object.select_animation_));
  }
  if (object.activate_animation_) {
    jo("activate_animation", ToJson(*object.activate_animation_));
  }
  if (object.effect_animation_) {
    jo("effect_animation", ToJson(*object.effect_animation_));
  }
  if (object.around_animation_) {
    jo("around_animation", ToJson(*object.around_animation_));
  }
  if (object.center_animation_) {
    jo("center_animation", ToJson(*object.center_animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::factCheck &object) {
  auto jo = jv.enter_object();
  jo("@type", "factCheck");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("country_code", object.country_code_);
}

void to_json(JsonValueScope &jv, const td_api::forumTopic &object) {
  auto jo = jv.enter_object();
  jo("@type", "forumTopic");
  if (object.info_) {
    jo("info", ToJson(*object.info_));
  }
  if (object.last_message_) {
    jo("last_message", ToJson(*object.last_message_));
  }
  jo("order", ToJson(JsonInt64{object.order_}));
  jo("is_pinned", JsonBool{object.is_pinned_});
  jo("unread_count", object.unread_count_);
  jo("last_read_inbox_message_id", object.last_read_inbox_message_id_);
  jo("last_read_outbox_message_id", object.last_read_outbox_message_id_);
  jo("unread_mention_count", object.unread_mention_count_);
  jo("unread_reaction_count", object.unread_reaction_count_);
  if (object.notification_settings_) {
    jo("notification_settings", ToJson(*object.notification_settings_));
  }
  if (object.draft_message_) {
    jo("draft_message", ToJson(*object.draft_message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::foundFileDownloads &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundFileDownloads");
  if (object.total_counts_) {
    jo("total_counts", ToJson(*object.total_counts_));
  }
  jo("files", ToJson(object.files_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::gameHighScore &object) {
  auto jo = jv.enter_object();
  jo("@type", "gameHighScore");
  jo("position", object.position_);
  jo("user_id", object.user_id_);
  jo("score", object.score_);
}

void to_json(JsonValueScope &jv, const td_api::giftResaleParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftResaleParameters");
  jo("star_count", object.star_count_);
  jo("toncoin_cent_count", object.toncoin_cent_count_);
  jo("toncoin_only", JsonBool{object.toncoin_only_});
}

void to_json(JsonValueScope &jv, const td_api::GiveawayParticipantStatus &object) {
  td_api::downcast_call(const_cast<td_api::GiveawayParticipantStatus &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::giveawayParticipantStatusEligible &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayParticipantStatusEligible");
}

void to_json(JsonValueScope &jv, const td_api::giveawayParticipantStatusParticipating &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayParticipantStatusParticipating");
}

void to_json(JsonValueScope &jv, const td_api::giveawayParticipantStatusAlreadyWasMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayParticipantStatusAlreadyWasMember");
  jo("joined_chat_date", object.joined_chat_date_);
}

void to_json(JsonValueScope &jv, const td_api::giveawayParticipantStatusAdministrator &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayParticipantStatusAdministrator");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::giveawayParticipantStatusDisallowedCountry &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayParticipantStatusDisallowedCountry");
  jo("user_country_code", object.user_country_code_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallParticipants &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallParticipants");
  jo("total_count", object.total_count_);
  jo("participant_ids", ToJson(object.participant_ids_));
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButton &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButton");
  jo("text", object.text_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::InputMessageContent &object) {
  td_api::downcast_call(const_cast<td_api::InputMessageContent &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inputMessageText &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageText");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.link_preview_options_) {
    jo("link_preview_options", ToJson(*object.link_preview_options_));
  }
  jo("clear_draft", JsonBool{object.clear_draft_});
}

void to_json(JsonValueScope &jv, const td_api::inputMessageAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageAnimation");
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("added_sticker_file_ids", ToJson(object.added_sticker_file_ids_));
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("show_caption_above_media", JsonBool{object.show_caption_above_media_});
  jo("has_spoiler", JsonBool{object.has_spoiler_});
}

void to_json(JsonValueScope &jv, const td_api::inputMessageAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageAudio");
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
  if (object.album_cover_thumbnail_) {
    jo("album_cover_thumbnail", ToJson(*object.album_cover_thumbnail_));
  }
  jo("duration", object.duration_);
  jo("title", object.title_);
  jo("performer", object.performer_);
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessageDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageDocument");
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("disable_content_type_detection", JsonBool{object.disable_content_type_detection_});
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessagePaidMedia &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessagePaidMedia");
  jo("star_count", object.star_count_);
  jo("paid_media", ToJson(object.paid_media_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("show_caption_above_media", JsonBool{object.show_caption_above_media_});
  jo("payload", object.payload_);
}

void to_json(JsonValueScope &jv, const td_api::inputMessagePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessagePhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("added_sticker_file_ids", ToJson(object.added_sticker_file_ids_));
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("show_caption_above_media", JsonBool{object.show_caption_above_media_});
  if (object.self_destruct_type_) {
    jo("self_destruct_type", ToJson(*object.self_destruct_type_));
  }
  jo("has_spoiler", JsonBool{object.has_spoiler_});
}

void to_json(JsonValueScope &jv, const td_api::inputMessageSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageSticker");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
  jo("emoji", object.emoji_);
}

void to_json(JsonValueScope &jv, const td_api::inputMessageVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.cover_) {
    jo("cover", ToJson(*object.cover_));
  }
  jo("start_timestamp", object.start_timestamp_);
  jo("added_sticker_file_ids", ToJson(object.added_sticker_file_ids_));
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
  jo("supports_streaming", JsonBool{object.supports_streaming_});
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("show_caption_above_media", JsonBool{object.show_caption_above_media_});
  if (object.self_destruct_type_) {
    jo("self_destruct_type", ToJson(*object.self_destruct_type_));
  }
  jo("has_spoiler", JsonBool{object.has_spoiler_});
}

void to_json(JsonValueScope &jv, const td_api::inputMessageVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageVideoNote");
  if (object.video_note_) {
    jo("video_note", ToJson(*object.video_note_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("duration", object.duration_);
  jo("length", object.length_);
  if (object.self_destruct_type_) {
    jo("self_destruct_type", ToJson(*object.self_destruct_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessageVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageVoiceNote");
  if (object.voice_note_) {
    jo("voice_note", ToJson(*object.voice_note_));
  }
  jo("duration", object.duration_);
  jo("waveform", base64_encode(object.waveform_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  if (object.self_destruct_type_) {
    jo("self_destruct_type", ToJson(*object.self_destruct_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessageLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageLocation");
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  jo("live_period", object.live_period_);
  jo("heading", object.heading_);
  jo("proximity_alert_radius", object.proximity_alert_radius_);
}

void to_json(JsonValueScope &jv, const td_api::inputMessageVenue &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageVenue");
  if (object.venue_) {
    jo("venue", ToJson(*object.venue_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessageContact &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageContact");
  if (object.contact_) {
    jo("contact", ToJson(*object.contact_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessageDice &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageDice");
  jo("emoji", object.emoji_);
  jo("clear_draft", JsonBool{object.clear_draft_});
}

void to_json(JsonValueScope &jv, const td_api::inputMessageGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageGame");
  jo("bot_user_id", object.bot_user_id_);
  jo("game_short_name", object.game_short_name_);
}

void to_json(JsonValueScope &jv, const td_api::inputMessageInvoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageInvoice");
  if (object.invoice_) {
    jo("invoice", ToJson(*object.invoice_));
  }
  jo("title", object.title_);
  jo("description", object.description_);
  jo("photo_url", object.photo_url_);
  jo("photo_size", object.photo_size_);
  jo("photo_width", object.photo_width_);
  jo("photo_height", object.photo_height_);
  jo("payload", base64_encode(object.payload_));
  jo("provider_token", object.provider_token_);
  jo("provider_data", object.provider_data_);
  jo("start_parameter", object.start_parameter_);
  if (object.paid_media_) {
    jo("paid_media", ToJson(*object.paid_media_));
  }
  if (object.paid_media_caption_) {
    jo("paid_media_caption", ToJson(*object.paid_media_caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessagePoll &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessagePoll");
  if (object.question_) {
    jo("question", ToJson(*object.question_));
  }
  jo("options", ToJson(object.options_));
  jo("is_anonymous", JsonBool{object.is_anonymous_});
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("open_period", object.open_period_);
  jo("close_date", object.close_date_);
  jo("is_closed", JsonBool{object.is_closed_});
}

void to_json(JsonValueScope &jv, const td_api::inputMessageStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageStory");
  jo("story_poster_chat_id", object.story_poster_chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::inputMessageChecklist &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageChecklist");
  if (object.checklist_) {
    jo("checklist", ToJson(*object.checklist_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inputMessageForwarded &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageForwarded");
  jo("from_chat_id", object.from_chat_id_);
  jo("message_id", object.message_id_);
  jo("in_game_share", JsonBool{object.in_game_share_});
  jo("replace_video_start_timestamp", JsonBool{object.replace_video_start_timestamp_});
  jo("new_video_start_timestamp", object.new_video_start_timestamp_);
  if (object.copy_options_) {
    jo("copy_options", ToJson(*object.copy_options_));
  }
}

void to_json(JsonValueScope &jv, const td_api::InviteLinkChatType &object) {
  td_api::downcast_call(const_cast<td_api::InviteLinkChatType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inviteLinkChatTypeBasicGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteLinkChatTypeBasicGroup");
}

void to_json(JsonValueScope &jv, const td_api::inviteLinkChatTypeSupergroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteLinkChatTypeSupergroup");
}

void to_json(JsonValueScope &jv, const td_api::inviteLinkChatTypeChannel &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteLinkChatTypeChannel");
}

void to_json(JsonValueScope &jv, const td_api::LanguagePackStringValue &object) {
  td_api::downcast_call(const_cast<td_api::LanguagePackStringValue &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::languagePackStringValueOrdinary &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackStringValueOrdinary");
  jo("value", object.value_);
}

void to_json(JsonValueScope &jv, const td_api::languagePackStringValuePluralized &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackStringValuePluralized");
  jo("zero_value", object.zero_value_);
  jo("one_value", object.one_value_);
  jo("two_value", object.two_value_);
  jo("few_value", object.few_value_);
  jo("many_value", object.many_value_);
  jo("other_value", object.other_value_);
}

void to_json(JsonValueScope &jv, const td_api::languagePackStringValueDeleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackStringValueDeleted");
}

void to_json(JsonValueScope &jv, const td_api::location &object) {
  auto jo = jv.enter_object();
  jo("@type", "location");
  jo("latitude", object.latitude_);
  jo("longitude", object.longitude_);
  jo("horizontal_accuracy", object.horizontal_accuracy_);
}

void to_json(JsonValueScope &jv, const td_api::message &object) {
  auto jo = jv.enter_object();
  jo("@type", "message");
  jo("id", object.id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("chat_id", object.chat_id_);
  if (object.sending_state_) {
    jo("sending_state", ToJson(*object.sending_state_));
  }
  if (object.scheduling_state_) {
    jo("scheduling_state", ToJson(*object.scheduling_state_));
  }
  jo("is_outgoing", JsonBool{object.is_outgoing_});
  jo("is_pinned", JsonBool{object.is_pinned_});
  jo("is_from_offline", JsonBool{object.is_from_offline_});
  jo("can_be_saved", JsonBool{object.can_be_saved_});
  jo("has_timestamped_media", JsonBool{object.has_timestamped_media_});
  jo("is_channel_post", JsonBool{object.is_channel_post_});
  jo("is_paid_star_suggested_post", JsonBool{object.is_paid_star_suggested_post_});
  jo("is_paid_ton_suggested_post", JsonBool{object.is_paid_ton_suggested_post_});
  jo("contains_unread_mention", JsonBool{object.contains_unread_mention_});
  jo("date", object.date_);
  jo("edit_date", object.edit_date_);
  if (object.forward_info_) {
    jo("forward_info", ToJson(*object.forward_info_));
  }
  if (object.import_info_) {
    jo("import_info", ToJson(*object.import_info_));
  }
  if (object.interaction_info_) {
    jo("interaction_info", ToJson(*object.interaction_info_));
  }
  jo("unread_reactions", ToJson(object.unread_reactions_));
  if (object.fact_check_) {
    jo("fact_check", ToJson(*object.fact_check_));
  }
  if (object.suggested_post_info_) {
    jo("suggested_post_info", ToJson(*object.suggested_post_info_));
  }
  if (object.reply_to_) {
    jo("reply_to", ToJson(*object.reply_to_));
  }
  if (object.topic_id_) {
    jo("topic_id", ToJson(*object.topic_id_));
  }
  if (object.self_destruct_type_) {
    jo("self_destruct_type", ToJson(*object.self_destruct_type_));
  }
  jo("self_destruct_in", object.self_destruct_in_);
  jo("auto_delete_in", object.auto_delete_in_);
  jo("via_bot_user_id", object.via_bot_user_id_);
  jo("sender_business_bot_user_id", object.sender_business_bot_user_id_);
  jo("sender_boost_count", object.sender_boost_count_);
  jo("paid_message_star_count", object.paid_message_star_count_);
  jo("author_signature", object.author_signature_);
  jo("media_album_id", ToJson(JsonInt64{object.media_album_id_}));
  jo("effect_id", ToJson(JsonInt64{object.effect_id_}));
  if (object.restriction_info_) {
    jo("restriction_info", ToJson(*object.restriction_info_));
  }
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
  if (object.reply_markup_) {
    jo("reply_markup", ToJson(*object.reply_markup_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messageForwardInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageForwardInfo");
  if (object.origin_) {
    jo("origin", ToJson(*object.origin_));
  }
  jo("date", object.date_);
  if (object.source_) {
    jo("source", ToJson(*object.source_));
  }
  jo("public_service_announcement_type", object.public_service_announcement_type_);
}

void to_json(JsonValueScope &jv, const td_api::messageReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageReaction");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("total_count", object.total_count_);
  jo("is_chosen", JsonBool{object.is_chosen_});
  if (object.used_sender_id_) {
    jo("used_sender_id", ToJson(*object.used_sender_id_));
  }
  jo("recent_sender_ids", ToJson(object.recent_sender_ids_));
}

void to_json(JsonValueScope &jv, const td_api::MessageSendingState &object) {
  td_api::downcast_call(const_cast<td_api::MessageSendingState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageSendingStatePending &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSendingStatePending");
  jo("sending_id", object.sending_id_);
}

void to_json(JsonValueScope &jv, const td_api::messageSendingStateFailed &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSendingStateFailed");
  if (object.error_) {
    jo("error", ToJson(*object.error_));
  }
  jo("can_retry", JsonBool{object.can_retry_});
  jo("need_another_sender", JsonBool{object.need_another_sender_});
  jo("need_another_reply_quote", JsonBool{object.need_another_reply_quote_});
  jo("need_drop_reply", JsonBool{object.need_drop_reply_});
  jo("required_paid_message_star_count", object.required_paid_message_star_count_);
  jo("retry_after", object.retry_after_);
}

void to_json(JsonValueScope &jv, const td_api::NetworkStatisticsEntry &object) {
  td_api::downcast_call(const_cast<td_api::NetworkStatisticsEntry &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::networkStatisticsEntryFile &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkStatisticsEntryFile");
  if (object.file_type_) {
    jo("file_type", ToJson(*object.file_type_));
  }
  if (object.network_type_) {
    jo("network_type", ToJson(*object.network_type_));
  }
  jo("sent_bytes", object.sent_bytes_);
  jo("received_bytes", object.received_bytes_);
}

void to_json(JsonValueScope &jv, const td_api::networkStatisticsEntryCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkStatisticsEntryCall");
  if (object.network_type_) {
    jo("network_type", ToJson(*object.network_type_));
  }
  jo("sent_bytes", object.sent_bytes_);
  jo("received_bytes", object.received_bytes_);
  jo("duration", object.duration_);
}

void to_json(JsonValueScope &jv, const td_api::NotificationType &object) {
  td_api::downcast_call(const_cast<td_api::NotificationType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::notificationTypeNewMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationTypeNewMessage");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("show_preview", JsonBool{object.show_preview_});
}

void to_json(JsonValueScope &jv, const td_api::notificationTypeNewSecretChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationTypeNewSecretChat");
}

void to_json(JsonValueScope &jv, const td_api::notificationTypeNewCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationTypeNewCall");
  jo("call_id", object.call_id_);
}

void to_json(JsonValueScope &jv, const td_api::notificationTypeNewPushMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationTypeNewPushMessage");
  jo("message_id", object.message_id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("sender_name", object.sender_name_);
  jo("is_outgoing", JsonBool{object.is_outgoing_});
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockRelatedArticle &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockRelatedArticle");
  jo("url", object.url_);
  jo("title", object.title_);
  jo("description", object.description_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("author", object.author_);
  jo("publish_date", object.publish_date_);
}

void to_json(JsonValueScope &jv, const td_api::PassportElementErrorSource &object) {
  td_api::downcast_call(const_cast<td_api::PassportElementErrorSource &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceUnspecified &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceUnspecified");
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceDataField &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceDataField");
  jo("field_name", object.field_name_);
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceFrontSide &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceFrontSide");
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceReverseSide &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceReverseSide");
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceSelfie &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceSelfie");
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceTranslationFile &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceTranslationFile");
  jo("file_index", object.file_index_);
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceTranslationFiles &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceTranslationFiles");
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceFile &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceFile");
  jo("file_index", object.file_index_);
}

void to_json(JsonValueScope &jv, const td_api::passportElementErrorSourceFiles &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementErrorSourceFiles");
}

void to_json(JsonValueScope &jv, const td_api::paymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentOption");
  jo("title", object.title_);
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::photoSize &object) {
  auto jo = jv.enter_object();
  jo("@type", "photoSize");
  jo("type", object.type_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
  jo("progressive_sizes", ToJson(object.progressive_sizes_));
}

void to_json(JsonValueScope &jv, const td_api::premiumGiftPaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumGiftPaymentOption");
  jo("currency", object.currency_);
  jo("amount", object.amount_);
  jo("star_count", object.star_count_);
  jo("discount_percentage", object.discount_percentage_);
  jo("month_count", object.month_count_);
  jo("store_product_id", object.store_product_id_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::prepaidGiveaway &object) {
  auto jo = jv.enter_object();
  jo("@type", "prepaidGiveaway");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("winner_count", object.winner_count_);
  if (object.prize_) {
    jo("prize", ToJson(*object.prize_));
  }
  jo("boost_count", object.boost_count_);
  jo("payment_date", object.payment_date_);
}

void to_json(JsonValueScope &jv, const td_api::proxy &object) {
  auto jo = jv.enter_object();
  jo("@type", "proxy");
  jo("id", object.id_);
  jo("server", object.server_);
  jo("port", object.port_);
  jo("last_used_date", object.last_used_date_);
  jo("is_enabled", JsonBool{object.is_enabled_});
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::quickReplyShortcut &object) {
  auto jo = jv.enter_object();
  jo("@type", "quickReplyShortcut");
  jo("id", object.id_);
  jo("name", object.name_);
  if (object.first_message_) {
    jo("first_message", ToJson(*object.first_message_));
  }
  jo("message_count", object.message_count_);
}

void to_json(JsonValueScope &jv, const td_api::recommendedChatFolders &object) {
  auto jo = jv.enter_object();
  jo("@type", "recommendedChatFolders");
  jo("chat_folders", ToJson(object.chat_folders_));
}

void to_json(JsonValueScope &jv, const td_api::restrictionInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "restrictionInfo");
  jo("restriction_reason", object.restriction_reason_);
  jo("has_sensitive_content", JsonBool{object.has_sensitive_content_});
}

void to_json(JsonValueScope &jv, const td_api::scopeAutosaveSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "scopeAutosaveSettings");
  jo("autosave_photos", JsonBool{object.autosave_photos_});
  jo("autosave_videos", JsonBool{object.autosave_videos_});
  jo("max_video_file_size", object.max_video_file_size_);
}

void to_json(JsonValueScope &jv, const td_api::sessions &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessions");
  jo("sessions", ToJson(object.sessions_));
  jo("inactive_session_ttl_days", object.inactive_session_ttl_days_);
}

void to_json(JsonValueScope &jv, const td_api::starAmount &object) {
  auto jo = jv.enter_object();
  jo("@type", "starAmount");
  jo("star_count", object.star_count_);
  jo("nanostar_count", object.nanostar_count_);
}

void to_json(JsonValueScope &jv, const td_api::starSubscription &object) {
  auto jo = jv.enter_object();
  jo("@type", "starSubscription");
  jo("id", object.id_);
  jo("chat_id", object.chat_id_);
  jo("expiration_date", object.expiration_date_);
  jo("is_canceled", JsonBool{object.is_canceled_});
  jo("is_expiring", JsonBool{object.is_expiring_});
  if (object.pricing_) {
    jo("pricing", ToJson(*object.pricing_));
  }
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::statisticalValue &object) {
  auto jo = jv.enter_object();
  jo("@type", "statisticalValue");
  jo("value", object.value_);
  jo("previous_value", object.previous_value_);
  jo("growth_rate_percentage", object.growth_rate_percentage_);
}

void to_json(JsonValueScope &jv, const td_api::storageStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "storageStatistics");
  jo("size", object.size_);
  jo("count", object.count_);
  jo("by_chat", ToJson(object.by_chat_));
}

void to_json(JsonValueScope &jv, const td_api::storyAreaPosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyAreaPosition");
  jo("x_percentage", object.x_percentage_);
  jo("y_percentage", object.y_percentage_);
  jo("width_percentage", object.width_percentage_);
  jo("height_percentage", object.height_percentage_);
  jo("rotation_angle", object.rotation_angle_);
  jo("corner_radius_percentage", object.corner_radius_percentage_);
}

void to_json(JsonValueScope &jv, const td_api::StoryOrigin &object) {
  td_api::downcast_call(const_cast<td_api::StoryOrigin &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::storyOriginPublicStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyOriginPublicStory");
  jo("chat_id", object.chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::storyOriginHiddenUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyOriginHiddenUser");
  jo("poster_name", object.poster_name_);
}

void to_json(JsonValueScope &jv, const td_api::SuggestedPostState &object) {
  td_api::downcast_call(const_cast<td_api::SuggestedPostState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostStatePending &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostStatePending");
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostStateApproved &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostStateApproved");
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostStateDeclined &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostStateDeclined");
}

void to_json(JsonValueScope &jv, const td_api::termsOfService &object) {
  auto jo = jv.enter_object();
  jo("@type", "termsOfService");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("min_user_age", object.min_user_age_);
  jo("show_popup", JsonBool{object.show_popup_});
}

void to_json(JsonValueScope &jv, const td_api::textEntities &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntities");
  jo("entities", ToJson(object.entities_));
}

void to_json(JsonValueScope &jv, const td_api::tonRevenueStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonRevenueStatistics");
  if (object.revenue_by_day_graph_) {
    jo("revenue_by_day_graph", ToJson(*object.revenue_by_day_graph_));
  }
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  jo("usd_rate", object.usd_rate_);
}

void to_json(JsonValueScope &jv, const td_api::updates &object) {
  auto jo = jv.enter_object();
  jo("@type", "updates");
  jo("updates", ToJson(object.updates_));
}

void to_json(JsonValueScope &jv, const td_api::UpgradedGiftOrigin &object) {
  td_api::downcast_call(const_cast<td_api::UpgradedGiftOrigin &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftOriginUpgrade &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftOriginUpgrade");
  jo("gift_message_id", object.gift_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftOriginTransfer &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftOriginTransfer");
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftOriginResale &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftOriginResale");
  if (object.price_) {
    jo("price", ToJson(*object.price_));
  }
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftOriginBlockchain &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftOriginBlockchain");
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftOriginPrepaidUpgrade &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftOriginPrepaidUpgrade");
}

void to_json(JsonValueScope &jv, const td_api::UserPrivacySettingRule &object) {
  td_api::downcast_call(const_cast<td_api::UserPrivacySettingRule &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleAllowAll &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleAllowAll");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleAllowContacts &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleAllowContacts");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleAllowBots &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleAllowBots");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleAllowPremiumUsers &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleAllowPremiumUsers");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleAllowUsers &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleAllowUsers");
  jo("user_ids", ToJson(object.user_ids_));
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleAllowChatMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleAllowChatMembers");
  jo("chat_ids", ToJson(object.chat_ids_));
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleRestrictAll &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleRestrictAll");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleRestrictContacts &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleRestrictContacts");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleRestrictBots &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleRestrictBots");
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleRestrictUsers &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleRestrictUsers");
  jo("user_ids", ToJson(object.user_ids_));
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRuleRestrictChatMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRuleRestrictChatMembers");
  jo("chat_ids", ToJson(object.chat_ids_));
}

void to_json(JsonValueScope &jv, const td_api::VectorPathCommand &object) {
  td_api::downcast_call(const_cast<td_api::VectorPathCommand &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::vectorPathCommandLine &object) {
  auto jo = jv.enter_object();
  jo("@type", "vectorPathCommandLine");
  if (object.end_point_) {
    jo("end_point", ToJson(*object.end_point_));
  }
}

void to_json(JsonValueScope &jv, const td_api::vectorPathCommandCubicBezierCurve &object) {
  auto jo = jv.enter_object();
  jo("@type", "vectorPathCommandCubicBezierCurve");
  if (object.start_control_point_) {
    jo("start_control_point", ToJson(*object.start_control_point_));
  }
  if (object.end_control_point_) {
    jo("end_control_point", ToJson(*object.end_control_point_));
  }
  if (object.end_point_) {
    jo("end_point", ToJson(*object.end_point_));
  }
}

void to_json(JsonValueScope &jv, const td_api::voiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "voiceNote");
  jo("duration", object.duration_);
  jo("waveform", base64_encode(object.waveform_));
  jo("mime_type", object.mime_type_);
  if (object.speech_recognition_result_) {
    jo("speech_recognition_result", ToJson(*object.speech_recognition_result_));
  }
  if (object.voice_) {
    jo("voice", ToJson(*object.voice_));
  }
}

}  // namespace td_api
}  // namespace td
