#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::AffiliateProgramSortOrder *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"affiliateProgramSortOrderProfitability", -1963282585},
    {"affiliateProgramSortOrderCreationDate", -1558628083},
    {"affiliateProgramSortOrderRevenue", 1923269304}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::CallProblem *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"callProblemEcho", 801116548},
    {"callProblemNoise", 1053065359},
    {"callProblemInterruptions", 1119493218},
    {"callProblemDistortedSpeech", 379960581},
    {"callProblemSilentLocal", 253652790},
    {"callProblemSilentRemote", 573634714},
    {"callProblemDropped", -1207311487},
    {"callProblemDistortedVideo", 385245706},
    {"callProblemPixelatedVideo", 2115315411}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::DeviceToken *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"deviceTokenFirebaseCloudMessaging", -797881849},
    {"deviceTokenApplePush", 387541955},
    {"deviceTokenApplePushVoIP", 804275689},
    {"deviceTokenWindowsPush", -1410514289},
    {"deviceTokenMicrosoftPush", 1224269900},
    {"deviceTokenMicrosoftPushVoIP", -785603759},
    {"deviceTokenWebPush", -1694507273},
    {"deviceTokenSimplePush", 49584736},
    {"deviceTokenUbuntuPush", 1782320422},
    {"deviceTokenBlackBerryPush", 1559167234},
    {"deviceTokenTizenPush", -1359947213},
    {"deviceTokenHuaweiPush", 1989103142}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::GroupCallVideoQuality *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"groupCallVideoQualityThumbnail", -379186304},
    {"groupCallVideoQualityMedium", 394968234},
    {"groupCallVideoQualityFull", -2125916617}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputInlineQueryResult *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputInlineQueryResultAnimation", -1489808874},
    {"inputInlineQueryResultArticle", 1983218620},
    {"inputInlineQueryResultAudio", 1260139988},
    {"inputInlineQueryResultContact", 1846064594},
    {"inputInlineQueryResultDocument", 578801869},
    {"inputInlineQueryResultGame", 966074327},
    {"inputInlineQueryResultLocation", -1887650218},
    {"inputInlineQueryResultPhoto", -1123338721},
    {"inputInlineQueryResultSticker", 274007129},
    {"inputInlineQueryResultVenue", 541704509},
    {"inputInlineQueryResultVideo", 1724073191},
    {"inputInlineQueryResultVoiceNote", -1790072503}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InternalLinkType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"internalLinkTypeActiveSessions", 1886108589},
    {"internalLinkTypeAttachmentMenuBot", 1682719269},
    {"internalLinkTypeAuthenticationCode", -209235982},
    {"internalLinkTypeBackground", 185411848},
    {"internalLinkTypeBotAddToChannel", 1401602752},
    {"internalLinkTypeBotStart", 1066950637},
    {"internalLinkTypeBotStartInGroup", -905081650},
    {"internalLinkTypeBusinessChat", -1606751785},
    {"internalLinkTypeBuyStars", -1454587065},
    {"internalLinkTypeChangePhoneNumber", -265856255},
    {"internalLinkTypeChatAffiliateProgram", 632049700},
    {"internalLinkTypeChatBoost", -716571328},
    {"internalLinkTypeChatFolderInvite", -1984804546},
    {"internalLinkTypeChatFolderSettings", -1073805988},
    {"internalLinkTypeChatInvite", 428621017},
    {"internalLinkTypeDefaultMessageAutoDeleteTimerSettings", 732625201},
    {"internalLinkTypeDirectMessagesChat", 1795016752},
    {"internalLinkTypeEditProfileSettings", -1022472090},
    {"internalLinkTypeGame", -260788787},
    {"internalLinkTypeGiftAuction", 1724902818},
    {"internalLinkTypeGiftCollection", -812480347},
    {"internalLinkTypeGroupCall", 1953084438},
    {"internalLinkTypeInstantView", 1776607039},
    {"internalLinkTypeInvoice", -213094996},
    {"internalLinkTypeLanguagePack", -1450766996},
    {"internalLinkTypeLanguageSettings", -1340479770},
    {"internalLinkTypeLiveStory", 665614717},
    {"internalLinkTypeLoginEmailSettings", 1741252808},
    {"internalLinkTypeMainWebApp", 1574925033},
    {"internalLinkTypeMessage", 978541650},
    {"internalLinkTypeMessageDraft", 661633749},
    {"internalLinkTypeMyStars", 1613887070},
    {"internalLinkTypeMyToncoins", -1861488996},
    {"internalLinkTypePassportDataRequest", -988819839},
    {"internalLinkTypePasswordSettings", -1776927773},
    {"internalLinkTypePhoneNumberConfirmation", 1757375254},
    {"internalLinkTypePhoneNumberPrivacySettings", -765272859},
    {"internalLinkTypePremiumFeatures", 1216892745},
    {"internalLinkTypePremiumGift", 1523936577},
    {"internalLinkTypePremiumGiftCode", -564356974},
    {"internalLinkTypePrivacyAndSecuritySettings", -1386255665},
    {"internalLinkTypeProxy", -1313788694},
    {"internalLinkTypePublicChat", 1769614592},
    {"internalLinkTypeQrCodeAuthentication", -1089332956},
    {"internalLinkTypeRestorePurchases", 606090371},
    {"internalLinkTypeSettings", 393561524},
    {"internalLinkTypeStickerSet", -1589227614},
    {"internalLinkTypeStory", 1852042869},
    {"internalLinkTypeStoryAlbum", -332692184},
    {"internalLinkTypeTheme", -200935417},
    {"internalLinkTypeThemeSettings", -1051903722},
    {"internalLinkTypeUnknownDeepLink", 625596379},
    {"internalLinkTypeUnsupportedProxy", -566649079},
    {"internalLinkTypeUpgradedGift", -708405605},
    {"internalLinkTypeUserPhoneNumber", 273398536},
    {"internalLinkTypeUserToken", -1462248615},
    {"internalLinkTypeVideoChat", -2020149068},
    {"internalLinkTypeWebApp", 2062112045}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::MessageSource *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"messageSourceChatHistory", -1090386116},
    {"messageSourceMessageThreadHistory", 290427142},
    {"messageSourceForumTopicHistory", -1518064457},
    {"messageSourceDirectMessagesChatTopicHistory", 1869256503},
    {"messageSourceHistoryPreview", 1024254993},
    {"messageSourceChatList", -2047406102},
    {"messageSourceSearch", 1921333105},
    {"messageSourceChatEventLog", -1028777540},
    {"messageSourceNotification", -1046406163},
    {"messageSourceScreenshot", 469982474},
    {"messageSourceOther", 901818114}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PollType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"pollTypeRegular", 641265698},
    {"pollTypeQuiz", 657013913}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ReactionType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"reactionTypeEmoji", -1942084920},
    {"reactionTypeCustomEmoji", -989117709},
    {"reactionTypePaid", 436294381}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::StoreTransaction *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"storeTransactionAppStore", 1625562441},
    {"storeTransactionGooglePlay", 1094018617}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::TextParseMode *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"textParseModeMarkdown", 360073407},
    {"textParseModeHTML", 1660208627}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::address &to, JsonObject &from) {
  TRY_STATUS(from_json(to.country_code_, from.extract_field("country_code")));
  TRY_STATUS(from_json(to.state_, from.extract_field("state")));
  TRY_STATUS(from_json(to.city_, from.extract_field("city")));
  TRY_STATUS(from_json(to.street_line1_, from.extract_field("street_line1")));
  TRY_STATUS(from_json(to.street_line2_, from.extract_field("street_line2")));
  TRY_STATUS(from_json(to.postal_code_, from.extract_field("postal_code")));
  return Status::OK();
}

Status from_json(td_api::autoDownloadSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_auto_download_enabled_, from.extract_field("is_auto_download_enabled")));
  TRY_STATUS(from_json(to.max_photo_file_size_, from.extract_field("max_photo_file_size")));
  TRY_STATUS(from_json(to.max_video_file_size_, from.extract_field("max_video_file_size")));
  TRY_STATUS(from_json(to.max_other_file_size_, from.extract_field("max_other_file_size")));
  TRY_STATUS(from_json(to.video_upload_bitrate_, from.extract_field("video_upload_bitrate")));
  TRY_STATUS(from_json(to.preload_large_videos_, from.extract_field("preload_large_videos")));
  TRY_STATUS(from_json(to.preload_next_audio_, from.extract_field("preload_next_audio")));
  TRY_STATUS(from_json(to.preload_stories_, from.extract_field("preload_stories")));
  TRY_STATUS(from_json(to.use_less_data_for_calls_, from.extract_field("use_less_data_for_calls")));
  return Status::OK();
}

Status from_json(td_api::backgroundTypePattern &to, JsonObject &from) {
  TRY_STATUS(from_json(to.fill_, from.extract_field("fill")));
  TRY_STATUS(from_json(to.intensity_, from.extract_field("intensity")));
  TRY_STATUS(from_json(to.is_inverted_, from.extract_field("is_inverted")));
  TRY_STATUS(from_json(to.is_moving_, from.extract_field("is_moving")));
  return Status::OK();
}

Status from_json(td_api::botCommandScopeAllGroupChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessAwayMessageSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_id_, from.extract_field("shortcut_id")));
  TRY_STATUS(from_json(to.recipients_, from.extract_field("recipients")));
  TRY_STATUS(from_json(to.schedule_, from.extract_field("schedule")));
  TRY_STATUS(from_json(to.offline_only_, from.extract_field("offline_only")));
  return Status::OK();
}

Status from_json(td_api::businessFeatureStartPage &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessRecipients &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  TRY_STATUS(from_json(to.excluded_chat_ids_, from.extract_field("excluded_chat_ids")));
  TRY_STATUS(from_json(to.select_existing_chats_, from.extract_field("select_existing_chats")));
  TRY_STATUS(from_json(to.select_new_chats_, from.extract_field("select_new_chats")));
  TRY_STATUS(from_json(to.select_contacts_, from.extract_field("select_contacts")));
  TRY_STATUS(from_json(to.select_non_contacts_, from.extract_field("select_non_contacts")));
  TRY_STATUS(from_json(to.exclude_selected_, from.extract_field("exclude_selected")));
  return Status::OK();
}

Status from_json(td_api::callProblemPixelatedVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionUploadingVoiceNote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.progress_, from.extract_field("progress")));
  return Status::OK();
}

Status from_json(td_api::chatActionWatchingAnimations &to, JsonObject &from) {
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  return Status::OK();
}

Status from_json(td_api::chatInviteLinkMember &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.joined_chat_date_, from.extract_field("joined_chat_date")));
  TRY_STATUS(from_json(to.via_chat_folder_invite_link_, from.extract_field("via_chat_folder_invite_link")));
  TRY_STATUS(from_json(to.approver_user_id_, from.extract_field("approver_user_id")));
  return Status::OK();
}

Status from_json(td_api::chatMemberStatusRestricted &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_member_, from.extract_field("is_member")));
  TRY_STATUS(from_json(to.restricted_until_date_, from.extract_field("restricted_until_date")));
  TRY_STATUS(from_json(to.permissions_, from.extract_field("permissions")));
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterBots &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::date &to, JsonObject &from) {
  TRY_STATUS(from_json(to.day_, from.extract_field("day")));
  TRY_STATUS(from_json(to.month_, from.extract_field("month")));
  TRY_STATUS(from_json(to.year_, from.extract_field("year")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenUbuntuPush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::emojiCategoryTypeRegularStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeAudio &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeSelfDestructingPhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeVideoStory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::giftForResaleOrderNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::groupCallVideoQualityMedium &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeCallbackGame &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inputBackgroundRemote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.background_id_, from.extract_field("background_id")));
  return Status::OK();
}

Status from_json(td_api::inputChatThemeGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::inputFileLocal &to, JsonObject &from) {
  TRY_STATUS(from_json(to.path_, from.extract_field("path")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultDocument &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.document_url_, from.extract_field("document_url")));
  TRY_STATUS(from_json(to.mime_type_, from.extract_field("mime_type")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_width_, from.extract_field("thumbnail_width")));
  TRY_STATUS(from_json(to.thumbnail_height_, from.extract_field("thumbnail_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputInvoiceName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::inputMessageVideo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.video_, from.extract_field("video")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.cover_, from.extract_field("cover")));
  TRY_STATUS(from_json(to.start_timestamp_, from.extract_field("start_timestamp")));
  TRY_STATUS(from_json(to.added_sticker_file_ids_, from.extract_field("added_sticker_file_ids")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json(to.width_, from.extract_field("width")));
  TRY_STATUS(from_json(to.height_, from.extract_field("height")));
  TRY_STATUS(from_json(to.supports_streaming_, from.extract_field("supports_streaming")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.show_caption_above_media_, from.extract_field("show_caption_above_media")));
  TRY_STATUS(from_json(to.self_destruct_type_, from.extract_field("self_destruct_type")));
  TRY_STATUS(from_json(to.has_spoiler_, from.extract_field("has_spoiler")));
  return Status::OK();
}

Status from_json(td_api::inputMessagePoll &to, JsonObject &from) {
  TRY_STATUS(from_json(to.question_, from.extract_field("question")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  TRY_STATUS(from_json(to.is_anonymous_, from.extract_field("is_anonymous")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.open_period_, from.extract_field("open_period")));
  TRY_STATUS(from_json(to.close_date_, from.extract_field("close_date")));
  TRY_STATUS(from_json(to.is_closed_, from.extract_field("is_closed")));
  return Status::OK();
}

Status from_json(td_api::inputPaidMediaTypePhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inputPassportElementBankStatement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bank_statement_, from.extract_field("bank_statement")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceFrontSide &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.file_hash_, from.extract_field("file_hash")));
  return Status::OK();
}

Status from_json(td_api::inputStoryArea &to, JsonObject &from) {
  TRY_STATUS(from_json(to.position_, from.extract_field("position")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreas &to, JsonObject &from) {
  TRY_STATUS(from_json(to.areas_, from.extract_field("areas")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeBackground &to, JsonObject &from) {
  TRY_STATUS(from_json(to.background_name_, from.extract_field("background_name")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeChatFolderInvite &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeGroupCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeMessageDraft &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.contains_link_, from.extract_field("contains_link")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePremiumGiftCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeStoryAlbum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_album_owner_username_, from.extract_field("story_album_owner_username")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.web_app_short_name_, from.extract_field("web_app_short_name")));
  TRY_STATUS(from_json(to.start_parameter_, from.extract_field("start_parameter")));
  TRY_STATUS(from_json(to.mode_, from.extract_field("mode")));
  return Status::OK();
}

Status from_json(td_api::keyboardButton &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::languagePackInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.base_language_pack_id_, from.extract_field("base_language_pack_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.native_name_, from.extract_field("native_name")));
  TRY_STATUS(from_json(to.plural_code_, from.extract_field("plural_code")));
  TRY_STATUS(from_json(to.is_official_, from.extract_field("is_official")));
  TRY_STATUS(from_json(to.is_rtl_, from.extract_field("is_rtl")));
  TRY_STATUS(from_json(to.is_beta_, from.extract_field("is_beta")));
  TRY_STATUS(from_json(to.is_installed_, from.extract_field("is_installed")));
  TRY_STATUS(from_json(to.total_string_count_, from.extract_field("total_string_count")));
  TRY_STATUS(from_json(to.translated_string_count_, from.extract_field("translated_string_count")));
  TRY_STATUS(from_json(to.local_string_count_, from.extract_field("local_string_count")));
  TRY_STATUS(from_json(to.translation_url_, from.extract_field("translation_url")));
  return Status::OK();
}

Status from_json(td_api::logStreamFile &to, JsonObject &from) {
  TRY_STATUS(from_json(to.path_, from.extract_field("path")));
  TRY_STATUS(from_json(to.max_file_size_, from.extract_field("max_file_size")));
  TRY_STATUS(from_json(to.redirect_stderr_, from.extract_field("redirect_stderr")));
  return Status::OK();
}

Status from_json(td_api::messageSchedulingStateSendAtDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.send_date_, from.extract_field("send_date")));
  TRY_STATUS(from_json(to.repeat_period_, from.extract_field("repeat_period")));
  return Status::OK();
}

Status from_json(td_api::messageSourceMessageThreadHistory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageSourceOther &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkTypeMobileRoaming &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::optionValueInteger &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::passportElementTypeIdentityCard &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypeEmailAddress &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureIncreasedUploadFileSize &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureEmojiStatus &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureSavedMessagesTags &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeCreatedPublicChatCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeChatFolderInviteLinkCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumSourceFeature &to, JsonObject &from) {
  TRY_STATUS(from_json(to.feature_, from.extract_field("feature")));
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeatureSaveStories &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabVoice &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::reactionNotificationSourceContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::replyMarkupInlineKeyboard &to, JsonObject &from) {
  TRY_STATUS(from_json(to.rows_, from.extract_field("rows")));
  return Status::OK();
}

Status from_json(td_api::reportReasonPersonalDetails &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterEmpty &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterChatPhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::starSubscriptionPricing &to, JsonObject &from) {
  TRY_STATUS(from_json(to.period_, from.extract_field("period")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::storePaymentPurposePremiumGiftCodes &to, JsonObject &from) {
  TRY_STATUS(from_json(to.boosted_chat_id_, from.extract_field("boosted_chat_id")));
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::storyListMain &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionViewChecksHint &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionExtendPremium &to, JsonObject &from) {
  TRY_STATUS(from_json(to.manage_premium_subscription_url_, from.extract_field("manage_premium_subscription_url")));
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterAdministrators &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::targetChatTypes &to, JsonObject &from) {
  TRY_STATUS(from_json(to.allow_user_chats_, from.extract_field("allow_user_chats")));
  TRY_STATUS(from_json(to.allow_bot_chats_, from.extract_field("allow_bot_chats")));
  TRY_STATUS(from_json(to.allow_group_chats_, from.extract_field("allow_group_chats")));
  TRY_STATUS(from_json(to.allow_channel_chats_, from.extract_field("allow_channel_chats")));
  return Status::OK();
}

Status from_json(td_api::testString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypeBankCardNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypeBlockQuote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::topChatCategoryUsers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::transactionDirectionOutgoing &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowBio &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAllowUnpaidMessages &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictBots &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::acceptCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json(to.protocol_, from.extract_field("protocol")));
  return Status::OK();
}

Status from_json(td_api::addContact &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.contact_, from.extract_field("contact")));
  TRY_STATUS(from_json(to.share_phone_number_, from.extract_field("share_phone_number")));
  return Status::OK();
}

Status from_json(td_api::addNetworkStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.entry_, from.extract_field("entry")));
  return Status::OK();
}

Status from_json(td_api::addRecentSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_attached_, from.extract_field("is_attached")));
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::answerCustomQuery &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_query_id_, from.extract_field("custom_query_id")));
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::banGroupCallParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::canTransferOwnership &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationEmailCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::checkEmailAddressVerificationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::cleanFileName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_name_, from.extract_field("file_name")));
  return Status::OK();
}

Status from_json(td_api::clickAnimatedEmojiMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::closeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.web_app_launch_id_, from.extract_field("web_app_launch_id")));
  return Status::OK();
}

Status from_json(td_api::createChatFolder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.folder_, from.extract_field("folder")));
  return Status::OK();
}

Status from_json(td_api::createNewSecretChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::declineGroupCallInvitation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::deleteBusinessMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  return Status::OK();
}

Status from_json(td_api::deleteChatReplyMarkup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::deleteGroupCallMessagesBySender &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.sender_id_, from.extract_field("sender_id")));
  TRY_STATUS(from_json(to.report_spam_, from.extract_field("report_spam")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedMessagesTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  return Status::OK();
}

Status from_json(td_api::discardCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json(to.is_disconnected_, from.extract_field("is_disconnected")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json(to.is_video_, from.extract_field("is_video")));
  TRY_STATUS(from_json(to.connection_id_, from.extract_field("connection_id")));
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageChecklist &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.checklist_, from.extract_field("checklist")));
  return Status::OK();
}

Status from_json(td_api::editChatSubscriptionInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::editMessageChecklist &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.checklist_, from.extract_field("checklist")));
  return Status::OK();
}

Status from_json(td_api::editStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.content_, from.extract_field("content")));
  TRY_STATUS(from_json(to.areas_, from.extract_field("areas")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  return Status::OK();
}

Status from_json(td_api::forwardMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.from_chat_id_, from.extract_field("from_chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  TRY_STATUS(from_json(to.send_copy_, from.extract_field("send_copy")));
  TRY_STATUS(from_json(to.remove_caption_, from.extract_field("remove_caption")));
  return Status::OK();
}

Status from_json(td_api::getArchivedStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.offset_sticker_set_id_, from.extract_field("offset_sticker_set_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getBackgroundUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::getBotName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  return Status::OK();
}

Status from_json(td_api::getCallbackQueryAnswer &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostLevelFeatures &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_channel_, from.extract_field("is_channel")));
  TRY_STATUS(from_json(to.level_, from.extract_field("level")));
  return Status::OK();
}

Status from_json(td_api::getChatFolderDefaultIconName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.folder_, from.extract_field("folder")));
  return Status::OK();
}

Status from_json(td_api::getChatListsToAddChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatRevenueStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_dark_, from.extract_field("is_dark")));
  return Status::OK();
}

Status from_json(td_api::getChatStoryAlbums &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getConnectedAffiliatePrograms &to, JsonObject &from) {
  TRY_STATUS(from_json(to.affiliate_, from.extract_field("affiliate")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getCustomEmojiReactionAnimations &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDefaultProfilePhotoCustomEmojiStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getExternalLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  TRY_STATUS(from_json(to.allow_write_access_, from.extract_field("allow_write_access")));
  return Status::OK();
}

Status from_json(td_api::getForumTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getGiftUpgradeVariants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_id_, from.extract_field("gift_id")));
  return Status::OK();
}

Status from_json(td_api::getImportedContactCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getJsonValue &to, JsonObject &from) {
  TRY_STATUS(from_json(to.json_, from.extract_field("json")));
  return Status::OK();
}

Status from_json(td_api::getLiveStoryTopDonors &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getMainWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.start_parameter_, from.extract_field("start_parameter")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  return Status::OK();
}

Status from_json(td_api::getMessageEffect &to, JsonObject &from) {
  TRY_STATUS(from_json(to.effect_id_, from.extract_field("effect_id")));
  return Status::OK();
}

Status from_json(td_api::getMessageReadDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getOwnedBots &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getPaymentReceipt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getPremiumLimit &to, JsonObject &from) {
  TRY_STATUS(from_json(to.limit_type_, from.extract_field("limit_type")));
  return Status::OK();
}

Status from_json(td_api::getReadDatePrivacySettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getRecommendedChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getSavedNotificationSounds &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getStarGiveawayPaymentOptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getStickerOutlineSvgPath &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_file_id_, from.extract_field("sticker_file_id")));
  TRY_STATUS(from_json(to.for_animated_emoji_, from.extract_field("for_animated_emoji")));
  TRY_STATUS(from_json(to.for_clicked_animated_emoji_message_, from.extract_field("for_clicked_animated_emoji_message")));
  return Status::OK();
}

Status from_json(td_api::getStoryInteractions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.only_contacts_, from.extract_field("only_contacts")));
  TRY_STATUS(from_json(to.prefer_forwards_, from.extract_field("prefer_forwards")));
  TRY_STATUS(from_json(to.prefer_with_reaction_, from.extract_field("prefer_with_reaction")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSupergroupFullInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::getTimeZones &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUpgradedGiftWithdrawalUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getUserSupportInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::giftPremiumWithStars &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  TRY_STATUS(from_json(to.month_count_, from.extract_field("month_count")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::isProfileAudio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::loadActiveStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_list_, from.extract_field("story_list")));
  return Status::OK();
}

Status from_json(td_api::openBotSimilarBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.opened_bot_user_id_, from.extract_field("opened_bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::parseMarkdown &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::processChatJoinRequests &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.approve_, from.extract_field("approve")));
  return Status::OK();
}

Status from_json(td_api::readBusinessMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::registerUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  TRY_STATUS(from_json(to.disable_notification_, from.extract_field("disable_notification")));
  return Status::OK();
}

Status from_json(td_api::removeLoginPasskey &to, JsonObject &from) {
  TRY_STATUS(from_json(to.passkey_id_, from.extract_field("passkey_id")));
  return Status::OK();
}

Status from_json(td_api::removeRecentHashtag &to, JsonObject &from) {
  TRY_STATUS(from_json(to.hashtag_, from.extract_field("hashtag")));
  return Status::OK();
}

Status from_json(td_api::reorderActiveUsernames &to, JsonObject &from) {
  TRY_STATUS(from_json(to.usernames_, from.extract_field("usernames")));
  return Status::OK();
}

Status from_json(td_api::reorderStoryAlbums &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_ids_, from.extract_field("story_album_ids")));
  return Status::OK();
}

Status from_json(td_api::reportChatSponsoredMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json_bytes(to.option_id_, from.extract_field("option_id")));
  return Status::OK();
}

Status from_json(td_api::requestPasswordRecovery &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::resetAuthenticationEmailAddress &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchAffiliatePrograms &to, JsonObject &from) {
  TRY_STATUS(from_json(to.affiliate_, from.extract_field("affiliate")));
  TRY_STATUS(from_json(to.sort_order_, from.extract_field("sort_order")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchContacts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchPublicChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::searchSecretMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  return Status::OK();
}

Status from_json(td_api::sendAuthenticationFirebaseSms &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::sendCustomRequest &to, JsonObject &from) {
  TRY_STATUS(from_json(to.method_, from.extract_field("method")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  return Status::OK();
}

Status from_json(td_api::sendPaymentForm &to, JsonObject &from) {
  TRY_STATUS(from_json(to.input_invoice_, from.extract_field("input_invoice")));
  TRY_STATUS(from_json(to.payment_form_id_, from.extract_field("payment_form_id")));
  TRY_STATUS(from_json(to.order_info_id_, from.extract_field("order_info_id")));
  TRY_STATUS(from_json(to.shipping_option_id_, from.extract_field("shipping_option_id")));
  TRY_STATUS(from_json(to.credentials_, from.extract_field("credentials")));
  TRY_STATUS(from_json(to.tip_amount_, from.extract_field("tip_amount")));
  return Status::OK();
}

Status from_json(td_api::setAccountTtl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.ttl_, from.extract_field("ttl")));
  return Status::OK();
}

Status from_json(td_api::setBio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bio_, from.extract_field("bio")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAccountName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  return Status::OK();
}

Status from_json(td_api::setBusinessStartPage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.start_page_, from.extract_field("start_page")));
  return Status::OK();
}

Status from_json(td_api::setChatDiscussionGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.discussion_chat_id_, from.extract_field("discussion_chat_id")));
  return Status::OK();
}

Status from_json(td_api::setChatPermissions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.permissions_, from.extract_field("permissions")));
  return Status::OK();
}

Status from_json(td_api::setCustomEmojiStickerSetThumbnail &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.custom_emoji_id_, from.extract_field("custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::setDirectMessagesChatTopicIsMarkedAsUnread &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.is_marked_as_unread_, from.extract_field("is_marked_as_unread")));
  return Status::OK();
}

Status from_json(td_api::setGroupCallParticipantIsSpeaking &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.audio_source_, from.extract_field("audio_source")));
  TRY_STATUS(from_json(to.is_speaking_, from.extract_field("is_speaking")));
  return Status::OK();
}

Status from_json(td_api::setMainProfileTab &to, JsonObject &from) {
  TRY_STATUS(from_json(to.main_profile_tab_, from.extract_field("main_profile_tab")));
  return Status::OK();
}

Status from_json(td_api::setOption &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::setPinnedSavedMessagesTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_ids_, from.extract_field("saved_messages_topic_ids")));
  return Status::OK();
}

Status from_json(td_api::setSavedMessagesTagLabel &to, JsonObject &from) {
  TRY_STATUS(from_json(to.tag_, from.extract_field("tag")));
  TRY_STATUS(from_json(to.label_, from.extract_field("label")));
  return Status::OK();
}

Status from_json(td_api::setStoryPrivacySettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.privacy_settings_, from.extract_field("privacy_settings")));
  return Status::OK();
}

Status from_json(td_api::setUserEmojiStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.emoji_status_, from.extract_field("emoji_status")));
  return Status::OK();
}

Status from_json(td_api::sharePhoneNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::suggestUserProfilePhoto &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.photo_, from.extract_field("photo")));
  return Status::OK();
}

Status from_json(td_api::testCallVectorIntObject &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::toggleAllDownloadsArePaused &to, JsonObject &from) {
  TRY_STATUS(from_json(to.are_paused_, from.extract_field("are_paused")));
  return Status::OK();
}

Status from_json(td_api::toggleChatIsMarkedAsUnread &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_marked_as_unread_, from.extract_field("is_marked_as_unread")));
  return Status::OK();
}

Status from_json(td_api::toggleGiftIsSaved &to, JsonObject &from) {
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.is_saved_, from.extract_field("is_saved")));
  return Status::OK();
}

Status from_json(td_api::toggleSessionCanAcceptCalls &to, JsonObject &from) {
  TRY_STATUS(from_json(to.session_id_, from.extract_field("session_id")));
  TRY_STATUS(from_json(to.can_accept_calls_, from.extract_field("can_accept_calls")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupIsForum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.is_forum_, from.extract_field("is_forum")));
  TRY_STATUS(from_json(to.has_forum_tabs_, from.extract_field("has_forum_tabs")));
  return Status::OK();
}

Status from_json(td_api::transferChatOwnership &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::upgradeGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.keep_original_details_, from.extract_field("keep_original_details")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::accentColor &object) {
  auto jo = jv.enter_object();
  jo("@type", "accentColor");
  jo("id", object.id_);
  jo("built_in_accent_color_id", object.built_in_accent_color_id_);
  jo("light_theme_colors", ToJson(object.light_theme_colors_));
  jo("dark_theme_colors", ToJson(object.dark_theme_colors_));
  jo("min_channel_chat_boost_level", object.min_channel_chat_boost_level_);
}

void to_json(JsonValueScope &jv, const td_api::affiliateInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "affiliateInfo");
  jo("commission_per_mille", object.commission_per_mille_);
  jo("affiliate_chat_id", object.affiliate_chat_id_);
  if (object.star_amount_) {
    jo("star_amount", ToJson(*object.star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::archiveChatListSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "archiveChatListSettings");
  jo("archive_and_mute_new_chats_from_unknown_users", JsonBool{object.archive_and_mute_new_chats_from_unknown_users_});
  jo("keep_unmuted_chats_archived", JsonBool{object.keep_unmuted_chats_archived_});
  jo("keep_chats_from_folders_archived", JsonBool{object.keep_chats_from_folders_archived_});
}

void to_json(JsonValueScope &jv, const td_api::AuthenticationCodeType &object) {
  td_api::downcast_call(const_cast<td_api::AuthenticationCodeType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeTelegramMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeTelegramMessage");
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeSms &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeSms");
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeSmsWord &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeSmsWord");
  jo("first_letter", object.first_letter_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeSmsPhrase &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeSmsPhrase");
  jo("first_word", object.first_word_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeCall");
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeFlashCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeFlashCall");
  jo("pattern", object.pattern_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeMissedCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeMissedCall");
  jo("phone_number_prefix", object.phone_number_prefix_);
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeFragment &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeFragment");
  jo("url", object.url_);
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeFirebaseAndroid &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeFirebaseAndroid");
  if (object.device_verification_parameters_) {
    jo("device_verification_parameters", ToJson(*object.device_verification_parameters_));
  }
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeTypeFirebaseIos &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeTypeFirebaseIos");
  jo("receipt", object.receipt_);
  jo("push_timeout", object.push_timeout_);
  jo("length", object.length_);
}

void to_json(JsonValueScope &jv, const td_api::availableReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "availableReaction");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("needs_premium", JsonBool{object.needs_premium_});
}

void to_json(JsonValueScope &jv, const td_api::basicGroupFullInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "basicGroupFullInfo");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("description", object.description_);
  jo("creator_user_id", object.creator_user_id_);
  jo("members", ToJson(object.members_));
  jo("can_hide_members", JsonBool{object.can_hide_members_});
  jo("can_toggle_aggressive_anti_spam", JsonBool{object.can_toggle_aggressive_anti_spam_});
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
  jo("bot_commands", ToJson(object.bot_commands_));
}

void to_json(JsonValueScope &jv, const td_api::botMenuButton &object) {
  auto jo = jv.enter_object();
  jo("@type", "botMenuButton");
  jo("text", object.text_);
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::businessChatLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessChatLink");
  jo("link", object.link_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("title", object.title_);
  jo("view_count", object.view_count_);
}

void to_json(JsonValueScope &jv, const td_api::businessInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessInfo");
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  if (object.opening_hours_) {
    jo("opening_hours", ToJson(*object.opening_hours_));
  }
  if (object.local_opening_hours_) {
    jo("local_opening_hours", ToJson(*object.local_opening_hours_));
  }
  jo("next_open_in", object.next_open_in_);
  jo("next_close_in", object.next_close_in_);
  if (object.greeting_message_settings_) {
    jo("greeting_message_settings", ToJson(*object.greeting_message_settings_));
  }
  if (object.away_message_settings_) {
    jo("away_message_settings", ToJson(*object.away_message_settings_));
  }
  if (object.start_page_) {
    jo("start_page", ToJson(*object.start_page_));
  }
}

void to_json(JsonValueScope &jv, const td_api::CallDiscardReason &object) {
  td_api::downcast_call(const_cast<td_api::CallDiscardReason &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::callDiscardReasonEmpty &object) {
  auto jo = jv.enter_object();
  jo("@type", "callDiscardReasonEmpty");
}

void to_json(JsonValueScope &jv, const td_api::callDiscardReasonMissed &object) {
  auto jo = jv.enter_object();
  jo("@type", "callDiscardReasonMissed");
}

void to_json(JsonValueScope &jv, const td_api::callDiscardReasonDeclined &object) {
  auto jo = jv.enter_object();
  jo("@type", "callDiscardReasonDeclined");
}

void to_json(JsonValueScope &jv, const td_api::callDiscardReasonDisconnected &object) {
  auto jo = jv.enter_object();
  jo("@type", "callDiscardReasonDisconnected");
}

void to_json(JsonValueScope &jv, const td_api::callDiscardReasonHungUp &object) {
  auto jo = jv.enter_object();
  jo("@type", "callDiscardReasonHungUp");
}

void to_json(JsonValueScope &jv, const td_api::callDiscardReasonUpgradeToGroupCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "callDiscardReasonUpgradeToGroupCall");
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::CanSendGiftResult &object) {
  td_api::downcast_call(const_cast<td_api::CanSendGiftResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::canSendGiftResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "canSendGiftResultOk");
}

void to_json(JsonValueScope &jv, const td_api::canSendGiftResultFail &object) {
  auto jo = jv.enter_object();
  jo("@type", "canSendGiftResultFail");
  if (object.reason_) {
    jo("reason", ToJson(*object.reason_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatAdministrators &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatAdministrators");
  jo("administrators", ToJson(object.administrators_));
}

void to_json(JsonValueScope &jv, const td_api::chatBoostSlots &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostSlots");
  jo("slots", ToJson(object.slots_));
}

void to_json(JsonValueScope &jv, const td_api::chatFolderInviteLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolderInviteLink");
  jo("invite_link", object.invite_link_);
  jo("name", object.name_);
  jo("chat_ids", ToJson(object.chat_ids_));
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinkMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinkMembers");
  jo("total_count", object.total_count_);
  jo("members", ToJson(object.members_));
}

void to_json(JsonValueScope &jv, const td_api::chatMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMember");
  if (object.member_id_) {
    jo("member_id", ToJson(*object.member_id_));
  }
  jo("inviter_user_id", object.inviter_user_id_);
  jo("joined_chat_date", object.joined_chat_date_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatPhotoSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPhotoSticker");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  if (object.background_fill_) {
    jo("background_fill", ToJson(*object.background_fill_));
  }
}

void to_json(JsonValueScope &jv, const td_api::ChatSource &object) {
  td_api::downcast_call(const_cast<td_api::ChatSource &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatSourceMtprotoProxy &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatSourceMtprotoProxy");
}

void to_json(JsonValueScope &jv, const td_api::chatSourcePublicServiceAnnouncement &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatSourcePublicServiceAnnouncement");
  jo("type", object.type_);
  jo("text", object.text_);
}

void to_json(JsonValueScope &jv, const td_api::chats &object) {
  auto jo = jv.enter_object();
  jo("@type", "chats");
  jo("total_count", object.total_count_);
  jo("chat_ids", ToJson(object.chat_ids_));
}

void to_json(JsonValueScope &jv, const td_api::connectedAffiliatePrograms &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectedAffiliatePrograms");
  jo("total_count", object.total_count_);
  jo("programs", ToJson(object.programs_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::currentWeather &object) {
  auto jo = jv.enter_object();
  jo("@type", "currentWeather");
  jo("temperature", object.temperature_);
  jo("emoji", object.emoji_);
}

void to_json(JsonValueScope &jv, const td_api::directMessagesChatTopic &object) {
  auto jo = jv.enter_object();
  jo("@type", "directMessagesChatTopic");
  jo("chat_id", object.chat_id_);
  jo("id", object.id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("order", ToJson(JsonInt64{object.order_}));
  jo("can_send_unpaid_messages", JsonBool{object.can_send_unpaid_messages_});
  jo("is_marked_as_unread", JsonBool{object.is_marked_as_unread_});
  jo("unread_count", object.unread_count_);
  jo("last_read_inbox_message_id", object.last_read_inbox_message_id_);
  jo("last_read_outbox_message_id", object.last_read_outbox_message_id_);
  jo("unread_reaction_count", object.unread_reaction_count_);
  if (object.last_message_) {
    jo("last_message", ToJson(*object.last_message_));
  }
  if (object.draft_message_) {
    jo("draft_message", ToJson(*object.draft_message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::emojiChatTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiChatTheme");
  jo("name", object.name_);
  if (object.light_settings_) {
    jo("light_settings", ToJson(*object.light_settings_));
  }
  if (object.dark_settings_) {
    jo("dark_settings", ToJson(*object.dark_settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::encryptedCredentials &object) {
  auto jo = jv.enter_object();
  jo("@type", "encryptedCredentials");
  jo("data", base64_encode(object.data_));
  jo("hash", base64_encode(object.hash_));
  jo("secret", base64_encode(object.secret_));
}

void to_json(JsonValueScope &jv, const td_api::FileType &object) {
  td_api::downcast_call(const_cast<td_api::FileType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::fileTypeNone &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeNone");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeAnimation");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeAudio");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeDocument");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeNotificationSound &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeNotificationSound");
}

void to_json(JsonValueScope &jv, const td_api::fileTypePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypePhoto");
}

void to_json(JsonValueScope &jv, const td_api::fileTypePhotoStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypePhotoStory");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSecret &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSecret");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSecretThumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSecretThumbnail");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSecure &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSecure");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSelfDestructingPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSelfDestructingPhoto");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSelfDestructingVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSelfDestructingVideo");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSelfDestructingVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSelfDestructingVideoNote");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSelfDestructingVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSelfDestructingVoiceNote");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeSticker");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeThumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeThumbnail");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeUnknown &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeUnknown");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeVideo");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeVideoNote");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeVideoStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeVideoStory");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeVoiceNote");
}

void to_json(JsonValueScope &jv, const td_api::fileTypeWallpaper &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileTypeWallpaper");
}

void to_json(JsonValueScope &jv, const td_api::foundAffiliatePrograms &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundAffiliatePrograms");
  jo("total_count", object.total_count_);
  jo("programs", ToJson(object.programs_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::foundUsers &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundUsers");
  jo("user_ids", ToJson(object.user_ids_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::giftAuctionState &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftAuctionState");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  if (object.state_) {
    jo("state", ToJson(*object.state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::giftResaleParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftResaleParameters");
  jo("star_count", object.star_count_);
  jo("toncoin_cent_count", object.toncoin_cent_count_);
  jo("toncoin_only", JsonBool{object.toncoin_only_});
}

void to_json(JsonValueScope &jv, const td_api::giveawayParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayParameters");
  jo("boosted_chat_id", object.boosted_chat_id_);
  jo("additional_chat_ids", ToJson(object.additional_chat_ids_));
  jo("winners_selection_date", object.winners_selection_date_);
  jo("only_new_members", JsonBool{object.only_new_members_});
  jo("has_public_winners", JsonBool{object.has_public_winners_});
  jo("country_codes", ToJson(object.country_codes_));
  jo("prize_description", object.prize_description_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallParticipantVideoInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallParticipantVideoInfo");
  jo("source_groups", ToJson(object.source_groups_));
  jo("endpoint_id", object.endpoint_id_);
  jo("is_paused", JsonBool{object.is_paused_});
}

void to_json(JsonValueScope &jv, const td_api::importedContacts &object) {
  auto jo = jv.enter_object();
  jo("@type", "importedContacts");
  jo("user_ids", ToJson(object.user_ids_));
  jo("importer_count", ToJson(object.importer_count_));
}

void to_json(JsonValueScope &jv, const td_api::InputFile &object) {
  td_api::downcast_call(const_cast<td_api::InputFile &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inputFileId &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileId");
  jo("id", object.id_);
}

void to_json(JsonValueScope &jv, const td_api::inputFileRemote &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileRemote");
  jo("id", object.id_);
}

void to_json(JsonValueScope &jv, const td_api::inputFileLocal &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileLocal");
  jo("path", object.path_);
}

void to_json(JsonValueScope &jv, const td_api::inputFileGenerated &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputFileGenerated");
  jo("original_path", object.original_path_);
  jo("conversion", object.conversion_);
  jo("expected_size", object.expected_size_);
}

void to_json(JsonValueScope &jv, const td_api::InviteGroupCallParticipantResult &object) {
  td_api::downcast_call(const_cast<td_api::InviteGroupCallParticipantResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultUserPrivacyRestricted &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultUserPrivacyRestricted");
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultUserAlreadyParticipant &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultUserAlreadyParticipant");
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultUserWasBanned &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultUserWasBanned");
}

void to_json(JsonValueScope &jv, const td_api::inviteGroupCallParticipantResultSuccess &object) {
  auto jo = jv.enter_object();
  jo("@type", "inviteGroupCallParticipantResultSuccess");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::languagePackString &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackString");
  jo("key", object.key_);
  if (object.value_) {
    jo("value", ToJson(*object.value_));
  }
}

void to_json(JsonValueScope &jv, const td_api::localizationTargetInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "localizationTargetInfo");
  jo("language_packs", ToJson(object.language_packs_));
}

void to_json(JsonValueScope &jv, const td_api::maskPosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPosition");
  if (object.point_) {
    jo("point", ToJson(*object.point_));
  }
  jo("x_shift", object.x_shift_);
  jo("y_shift", object.y_shift_);
  jo("scale", object.scale_);
}

void to_json(JsonValueScope &jv, const td_api::MessageFileType &object) {
  td_api::downcast_call(const_cast<td_api::MessageFileType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageFileTypePrivate &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageFileTypePrivate");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::messageFileTypeGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageFileTypeGroup");
  jo("title", object.title_);
}

void to_json(JsonValueScope &jv, const td_api::messageFileTypeUnknown &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageFileTypeUnknown");
}

void to_json(JsonValueScope &jv, const td_api::messageProperties &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageProperties");
  jo("can_add_offer", JsonBool{object.can_add_offer_});
  jo("can_add_tasks", JsonBool{object.can_add_tasks_});
  jo("can_be_approved", JsonBool{object.can_be_approved_});
  jo("can_be_copied", JsonBool{object.can_be_copied_});
  jo("can_be_copied_to_secret_chat", JsonBool{object.can_be_copied_to_secret_chat_});
  jo("can_be_declined", JsonBool{object.can_be_declined_});
  jo("can_be_deleted_only_for_self", JsonBool{object.can_be_deleted_only_for_self_});
  jo("can_be_deleted_for_all_users", JsonBool{object.can_be_deleted_for_all_users_});
  jo("can_be_edited", JsonBool{object.can_be_edited_});
  jo("can_be_forwarded", JsonBool{object.can_be_forwarded_});
  jo("can_be_paid", JsonBool{object.can_be_paid_});
  jo("can_be_pinned", JsonBool{object.can_be_pinned_});
  jo("can_be_replied", JsonBool{object.can_be_replied_});
  jo("can_be_replied_in_another_chat", JsonBool{object.can_be_replied_in_another_chat_});
  jo("can_be_saved", JsonBool{object.can_be_saved_});
  jo("can_be_shared_in_story", JsonBool{object.can_be_shared_in_story_});
  jo("can_edit_media", JsonBool{object.can_edit_media_});
  jo("can_edit_scheduling_state", JsonBool{object.can_edit_scheduling_state_});
  jo("can_edit_suggested_post_info", JsonBool{object.can_edit_suggested_post_info_});
  jo("can_get_author", JsonBool{object.can_get_author_});
  jo("can_get_embedding_code", JsonBool{object.can_get_embedding_code_});
  jo("can_get_link", JsonBool{object.can_get_link_});
  jo("can_get_media_timestamp_links", JsonBool{object.can_get_media_timestamp_links_});
  jo("can_get_message_thread", JsonBool{object.can_get_message_thread_});
  jo("can_get_read_date", JsonBool{object.can_get_read_date_});
  jo("can_get_statistics", JsonBool{object.can_get_statistics_});
  jo("can_get_video_advertisements", JsonBool{object.can_get_video_advertisements_});
  jo("can_get_viewers", JsonBool{object.can_get_viewers_});
  jo("can_mark_tasks_as_done", JsonBool{object.can_mark_tasks_as_done_});
  jo("can_recognize_speech", JsonBool{object.can_recognize_speech_});
  jo("can_report_chat", JsonBool{object.can_report_chat_});
  jo("can_report_reactions", JsonBool{object.can_report_reactions_});
  jo("can_report_supergroup_spam", JsonBool{object.can_report_supergroup_spam_});
  jo("can_set_fact_check", JsonBool{object.can_set_fact_check_});
  jo("need_show_statistics", JsonBool{object.need_show_statistics_});
}

void to_json(JsonValueScope &jv, const td_api::messageSenders &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSenders");
  jo("total_count", object.total_count_);
  jo("senders", ToJson(object.senders_));
}

void to_json(JsonValueScope &jv, const td_api::networkStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkStatistics");
  jo("since_date", object.since_date_);
  jo("entries", ToJson(object.entries_));
}

void to_json(JsonValueScope &jv, const td_api::notificationSounds &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSounds");
  jo("notification_sounds", ToJson(object.notification_sounds_));
}

void to_json(JsonValueScope &jv, const td_api::pageBlockListItem &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockListItem");
  jo("label", object.label_);
  jo("page_blocks", ToJson(object.page_blocks_));
}

void to_json(JsonValueScope &jv, const td_api::passportAuthorizationForm &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportAuthorizationForm");
  jo("id", object.id_);
  jo("required_elements", ToJson(object.required_elements_));
  jo("privacy_policy_url", object.privacy_policy_url_);
}

void to_json(JsonValueScope &jv, const td_api::passwordState &object) {
  auto jo = jv.enter_object();
  jo("@type", "passwordState");
  jo("has_password", JsonBool{object.has_password_});
  jo("password_hint", object.password_hint_);
  jo("has_recovery_email_address", JsonBool{object.has_recovery_email_address_});
  jo("has_passport_data", JsonBool{object.has_passport_data_});
  if (object.recovery_email_address_code_info_) {
    jo("recovery_email_address_code_info", ToJson(*object.recovery_email_address_code_info_));
  }
  jo("login_email_address_pattern", object.login_email_address_pattern_);
  jo("pending_reset_date", object.pending_reset_date_);
}

void to_json(JsonValueScope &jv, const td_api::personalDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "personalDocument");
  jo("files", ToJson(object.files_));
  jo("translation", ToJson(object.translation_));
}

void to_json(JsonValueScope &jv, const td_api::premiumFeaturePromotionAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeaturePromotionAnimation");
  if (object.feature_) {
    jo("feature", ToJson(*object.feature_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::premiumPaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumPaymentOption");
  jo("currency", object.currency_);
  jo("amount", object.amount_);
  jo("discount_percentage", object.discount_percentage_);
  jo("month_count", object.month_count_);
  jo("store_product_id", object.store_product_id_);
  if (object.payment_link_) {
    jo("payment_link", ToJson(*object.payment_link_));
  }
}

void to_json(JsonValueScope &jv, const td_api::profilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "profilePhoto");
  jo("id", ToJson(JsonInt64{object.id_}));
  if (object.small_) {
    jo("small", ToJson(*object.small_));
  }
  if (object.big_) {
    jo("big", ToJson(*object.big_));
  }
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  jo("has_animation", JsonBool{object.has_animation_});
  jo("is_personal", JsonBool{object.is_personal_});
}

void to_json(JsonValueScope &jv, const td_api::pushReceiverId &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushReceiverId");
  jo("id", ToJson(JsonInt64{object.id_}));
}

void to_json(JsonValueScope &jv, const td_api::receivedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "receivedGift");
  jo("received_gift_id", object.received_gift_id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("unique_gift_number", object.unique_gift_number_);
  jo("is_private", JsonBool{object.is_private_});
  jo("is_saved", JsonBool{object.is_saved_});
  jo("is_pinned", JsonBool{object.is_pinned_});
  jo("can_be_upgraded", JsonBool{object.can_be_upgraded_});
  jo("can_be_transferred", JsonBool{object.can_be_transferred_});
  jo("was_refunded", JsonBool{object.was_refunded_});
  jo("date", object.date_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("collection_ids", ToJson(object.collection_ids_));
  jo("sell_star_count", object.sell_star_count_);
  jo("prepaid_upgrade_star_count", object.prepaid_upgrade_star_count_);
  jo("is_upgrade_separate", JsonBool{object.is_upgrade_separate_});
  jo("transfer_star_count", object.transfer_star_count_);
  jo("drop_original_details_star_count", object.drop_original_details_star_count_);
  jo("next_transfer_date", object.next_transfer_date_);
  jo("next_resale_date", object.next_resale_date_);
  jo("export_date", object.export_date_);
  jo("prepaid_upgrade_hash", object.prepaid_upgrade_hash_);
}

void to_json(JsonValueScope &jv, const td_api::ReportSponsoredResult &object) {
  td_api::downcast_call(const_cast<td_api::ReportSponsoredResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultOk");
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultFailed &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultFailed");
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultOptionRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultOptionRequired");
  jo("title", object.title_);
  jo("options", ToJson(object.options_));
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultAdsHidden &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultAdsHidden");
}

void to_json(JsonValueScope &jv, const td_api::reportSponsoredResultPremiumRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportSponsoredResultPremiumRequired");
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTags &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTags");
  jo("tags", ToJson(object.tags_));
}

void to_json(JsonValueScope &jv, const td_api::sentWebAppMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "sentWebAppMessage");
  jo("inline_message_id", object.inline_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::sponsoredChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "sponsoredChats");
  jo("chats", ToJson(object.chats_));
}

void to_json(JsonValueScope &jv, const td_api::starPaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "starPaymentOption");
  jo("currency", object.currency_);
  jo("amount", object.amount_);
  jo("star_count", object.star_count_);
  jo("store_product_id", object.store_product_id_);
  jo("is_additional", JsonBool{object.is_additional_});
}

void to_json(JsonValueScope &jv, const td_api::StarTransactionType &object) {
  td_api::downcast_call(const_cast<td_api::StarTransactionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePremiumBotDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePremiumBotDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeAppStoreDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeAppStoreDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGooglePlayDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGooglePlayDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeFragmentDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeFragmentDeposit");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUserDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUserDeposit");
  jo("user_id", object.user_id_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiveawayDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiveawayDeposit");
  jo("chat_id", object.chat_id_);
  jo("giveaway_message_id", object.giveaway_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeFragmentWithdrawal &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeFragmentWithdrawal");
  if (object.withdrawal_state_) {
    jo("withdrawal_state", ToJson(*object.withdrawal_state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeTelegramAdsWithdrawal &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeTelegramAdsWithdrawal");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeTelegramApiUsage &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeTelegramApiUsage");
  jo("request_count", object.request_count_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotPaidMediaPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotPaidMediaPurchase");
  jo("user_id", object.user_id_);
  jo("media", ToJson(object.media_));
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotPaidMediaSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotPaidMediaSale");
  jo("user_id", object.user_id_);
  jo("media", ToJson(object.media_));
  jo("payload", object.payload_);
  if (object.affiliate_) {
    jo("affiliate", ToJson(*object.affiliate_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidMediaPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidMediaPurchase");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("media", ToJson(object.media_));
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidMediaSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidMediaSale");
  jo("user_id", object.user_id_);
  jo("message_id", object.message_id_);
  jo("media", ToJson(object.media_));
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotInvoicePurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotInvoicePurchase");
  jo("user_id", object.user_id_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotInvoiceSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotInvoiceSale");
  jo("user_id", object.user_id_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
  jo("invoice_payload", base64_encode(object.invoice_payload_));
  if (object.affiliate_) {
    jo("affiliate", ToJson(*object.affiliate_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotSubscriptionPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotSubscriptionPurchase");
  jo("user_id", object.user_id_);
  jo("subscription_period", object.subscription_period_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBotSubscriptionSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBotSubscriptionSale");
  jo("user_id", object.user_id_);
  jo("subscription_period", object.subscription_period_);
  if (object.product_info_) {
    jo("product_info", ToJson(*object.product_info_));
  }
  jo("invoice_payload", base64_encode(object.invoice_payload_));
  if (object.affiliate_) {
    jo("affiliate", ToJson(*object.affiliate_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelSubscriptionPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelSubscriptionPurchase");
  jo("chat_id", object.chat_id_);
  jo("subscription_period", object.subscription_period_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelSubscriptionSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelSubscriptionSale");
  jo("user_id", object.user_id_);
  jo("subscription_period", object.subscription_period_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftAuctionBid &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftAuctionBid");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftPurchase");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftPurchaseOffer &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftPurchaseOffer");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftTransfer &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftTransfer");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftOriginalDetailsDrop &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftOriginalDetailsDrop");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftSale");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftUpgrade &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftUpgrade");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeGiftUpgradePurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeGiftUpgradePurchase");
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUpgradedGiftPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUpgradedGiftPurchase");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUpgradedGiftSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUpgradedGiftSale");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
  jo("via_offer", JsonBool{object.via_offer_});
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidReactionSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidReactionSend");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeChannelPaidReactionReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeChannelPaidReactionReceive");
  jo("user_id", object.user_id_);
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeAffiliateProgramCommission &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeAffiliateProgramCommission");
  jo("chat_id", object.chat_id_);
  jo("commission_per_mille", object.commission_per_mille_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidMessageSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidMessageSend");
  jo("chat_id", object.chat_id_);
  jo("message_count", object.message_count_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidMessageReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidMessageReceive");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("message_count", object.message_count_);
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallMessageSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallMessageSend");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallMessageReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallMessageReceive");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallReactionSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallReactionSend");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePaidGroupCallReactionReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePaidGroupCallReactionReceive");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("commission_per_mille", object.commission_per_mille_);
  if (object.commission_star_amount_) {
    jo("commission_star_amount", ToJson(*object.commission_star_amount_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeSuggestedPostPaymentSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeSuggestedPostPaymentSend");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeSuggestedPostPaymentReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeSuggestedPostPaymentReceive");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePremiumPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePremiumPurchase");
  jo("user_id", object.user_id_);
  jo("month_count", object.month_count_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBusinessBotTransferSend &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBusinessBotTransferSend");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeBusinessBotTransferReceive &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeBusinessBotTransferReceive");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypePublicPostSearch &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypePublicPostSearch");
}

void to_json(JsonValueScope &jv, const td_api::starTransactionTypeUnsupported &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransactionTypeUnsupported");
}

void to_json(JsonValueScope &jv, const td_api::stickerSetInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerSetInfo");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("title", object.title_);
  jo("name", object.name_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.thumbnail_outline_) {
    jo("thumbnail_outline", ToJson(*object.thumbnail_outline_));
  }
  jo("is_owned", JsonBool{object.is_owned_});
  jo("is_installed", JsonBool{object.is_installed_});
  jo("is_archived", JsonBool{object.is_archived_});
  jo("is_official", JsonBool{object.is_official_});
  if (object.sticker_type_) {
    jo("sticker_type", ToJson(*object.sticker_type_));
  }
  jo("needs_repainting", JsonBool{object.needs_repainting_});
  jo("is_allowed_as_chat_emoji_status", JsonBool{object.is_allowed_as_chat_emoji_status_});
  jo("is_viewed", JsonBool{object.is_viewed_});
  jo("size", object.size_);
  jo("covers", ToJson(object.covers_));
}

void to_json(JsonValueScope &jv, const td_api::story &object) {
  auto jo = jv.enter_object();
  jo("@type", "story");
  jo("id", object.id_);
  jo("poster_chat_id", object.poster_chat_id_);
  if (object.poster_id_) {
    jo("poster_id", ToJson(*object.poster_id_));
  }
  jo("date", object.date_);
  jo("is_being_posted", JsonBool{object.is_being_posted_});
  jo("is_being_edited", JsonBool{object.is_being_edited_});
  jo("is_edited", JsonBool{object.is_edited_});
  jo("is_posted_to_chat_page", JsonBool{object.is_posted_to_chat_page_});
  jo("is_visible_only_for_self", JsonBool{object.is_visible_only_for_self_});
  jo("can_be_added_to_album", JsonBool{object.can_be_added_to_album_});
  jo("can_be_deleted", JsonBool{object.can_be_deleted_});
  jo("can_be_edited", JsonBool{object.can_be_edited_});
  jo("can_be_forwarded", JsonBool{object.can_be_forwarded_});
  jo("can_be_replied", JsonBool{object.can_be_replied_});
  jo("can_set_privacy_settings", JsonBool{object.can_set_privacy_settings_});
  jo("can_toggle_is_posted_to_chat_page", JsonBool{object.can_toggle_is_posted_to_chat_page_});
  jo("can_get_statistics", JsonBool{object.can_get_statistics_});
  jo("can_get_interactions", JsonBool{object.can_get_interactions_});
  jo("has_expired_viewers", JsonBool{object.has_expired_viewers_});
  if (object.repost_info_) {
    jo("repost_info", ToJson(*object.repost_info_));
  }
  if (object.interaction_info_) {
    jo("interaction_info", ToJson(*object.interaction_info_));
  }
  if (object.chosen_reaction_type_) {
    jo("chosen_reaction_type", ToJson(*object.chosen_reaction_type_));
  }
  if (object.privacy_settings_) {
    jo("privacy_settings", ToJson(*object.privacy_settings_));
  }
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
  jo("areas", ToJson(object.areas_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("album_ids", ToJson(object.album_ids_));
}

void to_json(JsonValueScope &jv, const td_api::storyInteractionInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteractionInfo");
  jo("view_count", object.view_count_);
  jo("forward_count", object.forward_count_);
  jo("reaction_count", object.reaction_count_);
  jo("recent_viewer_user_ids", ToJson(object.recent_viewer_user_ids_));
}

void to_json(JsonValueScope &jv, const td_api::SuggestedAction &object) {
  td_api::downcast_call(const_cast<td_api::SuggestedAction &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionEnableArchiveAndMuteNewChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionEnableArchiveAndMuteNewChats");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionCheckPassword &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionCheckPassword");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionCheckPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionCheckPhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionViewChecksHint &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionViewChecksHint");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionConvertToBroadcastGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionConvertToBroadcastGroup");
  jo("supergroup_id", object.supergroup_id_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetPassword &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetPassword");
  jo("authorization_delay", object.authorization_delay_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionUpgradePremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionUpgradePremium");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionRestorePremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionRestorePremium");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSubscribeToAnnualPremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSubscribeToAnnualPremium");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionGiftPremiumForChristmas &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionGiftPremiumForChristmas");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetBirthdate &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetBirthdate");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionExtendPremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionExtendPremium");
  jo("manage_premium_subscription_url", object.manage_premium_subscription_url_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionExtendStarSubscriptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionExtendStarSubscriptions");
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionCustom &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionCustom");
  jo("name", object.name_);
  if (object.title_) {
    jo("title", ToJson(*object.title_));
  }
  if (object.description_) {
    jo("description", ToJson(*object.description_));
  }
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionSetLoginEmailAddress &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionSetLoginEmailAddress");
  jo("can_be_hidden", JsonBool{object.can_be_hidden_});
}

void to_json(JsonValueScope &jv, const td_api::suggestedActionAddLoginPasskey &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedActionAddLoginPasskey");
}

void to_json(JsonValueScope &jv, const td_api::tMeUrls &object) {
  auto jo = jv.enter_object();
  jo("@type", "tMeUrls");
  jo("urls", ToJson(object.urls_));
}

void to_json(JsonValueScope &jv, const td_api::testVectorIntObject &object) {
  auto jo = jv.enter_object();
  jo("@type", "testVectorIntObject");
  jo("value", ToJson(object.value_));
}

void to_json(JsonValueScope &jv, const td_api::thumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "thumbnail");
  if (object.format_) {
    jo("format", ToJson(*object.format_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.file_) {
    jo("file", ToJson(*object.file_));
  }
}

void to_json(JsonValueScope &jv, const td_api::trendingStickerSets &object) {
  auto jo = jv.enter_object();
  jo("@type", "trendingStickerSets");
  jo("total_count", object.total_count_);
  jo("sets", ToJson(object.sets_));
  jo("is_premium", JsonBool{object.is_premium_});
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftBackdropCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftBackdropCount");
  if (object.backdrop_) {
    jo("backdrop", ToJson(*object.backdrop_));
  }
  jo("total_count", object.total_count_);
}

void to_json(JsonValueScope &jv, const td_api::user &object) {
  auto jo = jv.enter_object();
  jo("@type", "user");
  jo("id", object.id_);
  jo("first_name", object.first_name_);
  jo("last_name", object.last_name_);
  if (object.usernames_) {
    jo("usernames", ToJson(*object.usernames_));
  }
  jo("phone_number", object.phone_number_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  if (object.profile_photo_) {
    jo("profile_photo", ToJson(*object.profile_photo_));
  }
  jo("accent_color_id", object.accent_color_id_);
  jo("background_custom_emoji_id", ToJson(JsonInt64{object.background_custom_emoji_id_}));
  if (object.upgraded_gift_colors_) {
    jo("upgraded_gift_colors", ToJson(*object.upgraded_gift_colors_));
  }
  jo("profile_accent_color_id", object.profile_accent_color_id_);
  jo("profile_background_custom_emoji_id", ToJson(JsonInt64{object.profile_background_custom_emoji_id_}));
  if (object.emoji_status_) {
    jo("emoji_status", ToJson(*object.emoji_status_));
  }
  jo("is_contact", JsonBool{object.is_contact_});
  jo("is_mutual_contact", JsonBool{object.is_mutual_contact_});
  jo("is_close_friend", JsonBool{object.is_close_friend_});
  if (object.verification_status_) {
    jo("verification_status", ToJson(*object.verification_status_));
  }
  jo("is_premium", JsonBool{object.is_premium_});
  jo("is_support", JsonBool{object.is_support_});
  if (object.restriction_info_) {
    jo("restriction_info", ToJson(*object.restriction_info_));
  }
  if (object.active_story_state_) {
    jo("active_story_state", ToJson(*object.active_story_state_));
  }
  jo("restricts_new_chats", JsonBool{object.restricts_new_chats_});
  jo("paid_message_star_count", object.paid_message_star_count_);
  jo("have_access", JsonBool{object.have_access_});
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("language_code", object.language_code_);
  jo("added_to_attachment_menu", JsonBool{object.added_to_attachment_menu_});
}

void to_json(JsonValueScope &jv, const td_api::userSupportInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "userSupportInfo");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("author", object.author_);
  jo("date", object.date_);
}

void to_json(JsonValueScope &jv, const td_api::videoChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "videoChat");
  jo("group_call_id", object.group_call_id_);
  jo("has_participants", JsonBool{object.has_participants_});
  if (object.default_participant_id_) {
    jo("default_participant_id", ToJson(*object.default_participant_id_));
  }
}

void to_json(JsonValueScope &jv, const td_api::webPageInstantView &object) {
  auto jo = jv.enter_object();
  jo("@type", "webPageInstantView");
  jo("page_blocks", ToJson(object.page_blocks_));
  jo("view_count", object.view_count_);
  jo("version", object.version_);
  jo("is_rtl", JsonBool{object.is_rtl_});
  jo("is_full", JsonBool{object.is_full_});
  if (object.feedback_link_) {
    jo("feedback_link", ToJson(*object.feedback_link_));
  }
}

}  // namespace td_api
}  // namespace td
