#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::BotCommandScope *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"botCommandScopeDefault", 795652779},
    {"botCommandScopeAllPrivateChats", -344889543},
    {"botCommandScopeAllGroupChats", -981088162},
    {"botCommandScopeAllChatAdministrators", 1998329169},
    {"botCommandScopeChat", -430234971},
    {"botCommandScopeChatAdministrators", 1119682126},
    {"botCommandScopeChatMember", -211380494}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatMembersFilter *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatMembersFilterContacts", 1774485671},
    {"chatMembersFilterAdministrators", -1266893796},
    {"chatMembersFilterMembers", 670504342},
    {"chatMembersFilterMention", 1932296772},
    {"chatMembersFilterRestricted", 1256282813},
    {"chatMembersFilterBanned", -1863102648},
    {"chatMembersFilterBots", -1422567288}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::GiftForResaleOrder *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"giftForResaleOrderPrice", 1371740258},
    {"giftForResaleOrderPriceChangeDate", -1694144054},
    {"giftForResaleOrderNumber", -1301157632}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputCredentials *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputCredentialsSaved", -2034385364},
    {"inputCredentialsNew", -829689558},
    {"inputCredentialsApplePay", -1246570799},
    {"inputCredentialsGooglePay", 844384100}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputPassportElementErrorSource *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputPassportElementErrorSourceUnspecified", 267230319},
    {"inputPassportElementErrorSourceDataField", -426795002},
    {"inputPassportElementErrorSourceFrontSide", 588023741},
    {"inputPassportElementErrorSourceReverseSide", 413072891},
    {"inputPassportElementErrorSourceSelfie", -773575528},
    {"inputPassportElementErrorSourceTranslationFile", 505842299},
    {"inputPassportElementErrorSourceTranslationFiles", -527254048},
    {"inputPassportElementErrorSourceFile", -298492469},
    {"inputPassportElementErrorSourceFiles", -2008541640}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::MessageSchedulingState *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"messageSchedulingStateSendAtDate", 1505903015},
    {"messageSchedulingStateSendWhenOnline", 2092947464},
    {"messageSchedulingStateSendWhenVideoProcessed", 2101578734}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PaidReactionType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"paidReactionTypeRegular", -1199187333},
    {"paidReactionTypeAnonymous", 47892621},
    {"paidReactionTypeChat", -675782044}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ProxyType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"proxyTypeSocks5", -890027341},
    {"proxyTypeHttp", -1547188361},
    {"proxyTypeMtproto", -1964826627}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::StickerFormat *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"stickerFormatWebp", -2123043040},
    {"stickerFormatTgs", 1614588662},
    {"stickerFormatWebm", -2070162097}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::TargetChat *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"targetChatCurrent", -416689904},
    {"targetChatChosen", -1392978522},
    {"targetChatInternalLink", -579301408}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::WebAppOpenMode *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"webAppOpenModeCompact", 1711603675},
    {"webAppOpenModeFullSize", 189320513},
    {"webAppOpenModeFullScreen", 1871315357}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::affiliateTypeBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::backgroundFillGradient &to, JsonObject &from) {
  TRY_STATUS(from_json(to.top_color_, from.extract_field("top_color")));
  TRY_STATUS(from_json(to.bottom_color_, from.extract_field("bottom_color")));
  TRY_STATUS(from_json(to.rotation_angle_, from.extract_field("rotation_angle")));
  return Status::OK();
}

Status from_json(td_api::botCommand &to, JsonObject &from) {
  TRY_STATUS(from_json(to.command_, from.extract_field("command")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  return Status::OK();
}

Status from_json(td_api::businessAwayMessageScheduleAlways &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessFeatureGreetingMessage &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.address_, from.extract_field("address")));
  return Status::OK();
}

Status from_json(td_api::callProblemSilentRemote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionRecordingVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionStartPlayingGame &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatFolder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.icon_, from.extract_field("icon")));
  TRY_STATUS(from_json(to.color_id_, from.extract_field("color_id")));
  TRY_STATUS(from_json(to.is_shareable_, from.extract_field("is_shareable")));
  TRY_STATUS(from_json(to.pinned_chat_ids_, from.extract_field("pinned_chat_ids")));
  TRY_STATUS(from_json(to.included_chat_ids_, from.extract_field("included_chat_ids")));
  TRY_STATUS(from_json(to.excluded_chat_ids_, from.extract_field("excluded_chat_ids")));
  TRY_STATUS(from_json(to.exclude_muted_, from.extract_field("exclude_muted")));
  TRY_STATUS(from_json(to.exclude_read_, from.extract_field("exclude_read")));
  TRY_STATUS(from_json(to.exclude_archived_, from.extract_field("exclude_archived")));
  TRY_STATUS(from_json(to.include_contacts_, from.extract_field("include_contacts")));
  TRY_STATUS(from_json(to.include_non_contacts_, from.extract_field("include_non_contacts")));
  TRY_STATUS(from_json(to.include_bots_, from.extract_field("include_bots")));
  TRY_STATUS(from_json(to.include_groups_, from.extract_field("include_groups")));
  TRY_STATUS(from_json(to.include_channels_, from.extract_field("include_channels")));
  return Status::OK();
}

Status from_json(td_api::chatMemberStatusCreator &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_title_, from.extract_field("custom_title")));
  TRY_STATUS(from_json(to.is_anonymous_, from.extract_field("is_anonymous")));
  TRY_STATUS(from_json(to.is_member_, from.extract_field("is_member")));
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterMention &to, JsonObject &from) {
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  return Status::OK();
}

Status from_json(td_api::collectibleItemTypeUsername &to, JsonObject &from) {
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenMicrosoftPushVoIP &to, JsonObject &from) {
  TRY_STATUS(from_json(to.channel_uri_, from.extract_field("channel_uri")));
  return Status::OK();
}

Status from_json(td_api::emailAddressAuthenticationAppleId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::error &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  TRY_STATUS(from_json(to.message_, from.extract_field("message")));
  return Status::OK();
}

Status from_json(td_api::fileTypeSecret &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeUnknown &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::forumTopicIcon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.color_, from.extract_field("color")));
  TRY_STATUS(from_json(to.custom_emoji_id_, from.extract_field("custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::groupCallDataChannelScreenSharing &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::inlineQueryResultsButtonTypeStartBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.parameter_, from.extract_field("parameter")));
  return Status::OK();
}

Status from_json(td_api::inputChatPhotoAnimation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.animation_, from.extract_field("animation")));
  TRY_STATUS(from_json(to.main_frame_timestamp_, from.extract_field("main_frame_timestamp")));
  return Status::OK();
}

Status from_json(td_api::inputCredentialsGooglePay &to, JsonObject &from) {
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultArticle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_width_, from.extract_field("thumbnail_width")));
  TRY_STATUS(from_json(to.thumbnail_height_, from.extract_field("thumbnail_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultVideo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.video_url_, from.extract_field("video_url")));
  TRY_STATUS(from_json(to.mime_type_, from.extract_field("mime_type")));
  TRY_STATUS(from_json(to.video_width_, from.extract_field("video_width")));
  TRY_STATUS(from_json(to.video_height_, from.extract_field("video_height")));
  TRY_STATUS(from_json(to.video_duration_, from.extract_field("video_duration")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessagePaidMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  TRY_STATUS(from_json(to.paid_media_, from.extract_field("paid_media")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.show_caption_above_media_, from.extract_field("show_caption_above_media")));
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  return Status::OK();
}

Status from_json(td_api::inputMessageDice &to, JsonObject &from) {
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  TRY_STATUS(from_json(to.clear_draft_, from.extract_field("clear_draft")));
  return Status::OK();
}

Status from_json(td_api::inputMessageReplyToExternalMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.quote_, from.extract_field("quote")));
  TRY_STATUS(from_json(to.checklist_task_id_, from.extract_field("checklist_task_id")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementInternalPassport &to, JsonObject &from) {
  TRY_STATUS(from_json(to.internal_passport_, from.extract_field("internal_passport")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementError &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.message_, from.extract_field("message")));
  TRY_STATUS(from_json(to.source_, from.extract_field("source")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceFiles &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.file_hashes_, from.extract_field("file_hashes")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeActiveSessions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeChangePhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeGame &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.game_short_name_, from.extract_field("game_short_name")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeLoginEmailSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePhoneNumberPrivacySettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeUserPhoneNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.draft_text_, from.extract_field("draft_text")));
  TRY_STATUS(from_json(to.open_profile_, from.extract_field("open_profile")));
  return Status::OK();
}

Status from_json(td_api::jsonValueString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeRequestChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.chat_is_channel_, from.extract_field("chat_is_channel")));
  TRY_STATUS(from_json(to.restrict_chat_is_forum_, from.extract_field("restrict_chat_is_forum")));
  TRY_STATUS(from_json(to.chat_is_forum_, from.extract_field("chat_is_forum")));
  TRY_STATUS(from_json(to.restrict_chat_has_username_, from.extract_field("restrict_chat_has_username")));
  TRY_STATUS(from_json(to.chat_has_username_, from.extract_field("chat_has_username")));
  TRY_STATUS(from_json(to.chat_is_created_, from.extract_field("chat_is_created")));
  TRY_STATUS(from_json(to.user_administrator_rights_, from.extract_field("user_administrator_rights")));
  TRY_STATUS(from_json(to.bot_administrator_rights_, from.extract_field("bot_administrator_rights")));
  TRY_STATUS(from_json(to.bot_is_member_, from.extract_field("bot_is_member")));
  TRY_STATUS(from_json(to.request_title_, from.extract_field("request_title")));
  TRY_STATUS(from_json(to.request_username_, from.extract_field("request_username")));
  TRY_STATUS(from_json(to.request_photo_, from.extract_field("request_photo")));
  return Status::OK();
}

Status from_json(td_api::location &to, JsonObject &from) {
  TRY_STATUS(from_json(to.latitude_, from.extract_field("latitude")));
  TRY_STATUS(from_json(to.longitude_, from.extract_field("longitude")));
  TRY_STATUS(from_json(to.horizontal_accuracy_, from.extract_field("horizontal_accuracy")));
  return Status::OK();
}

Status from_json(td_api::maskPosition &to, JsonObject &from) {
  TRY_STATUS(from_json(to.point_, from.extract_field("point")));
  TRY_STATUS(from_json(to.x_shift_, from.extract_field("x_shift")));
  TRY_STATUS(from_json(to.y_shift_, from.extract_field("y_shift")));
  TRY_STATUS(from_json(to.scale_, from.extract_field("scale")));
  return Status::OK();
}

Status from_json(td_api::messageSenderUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::messageSourceChatEventLog &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkStatisticsEntryCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.network_type_, from.extract_field("network_type")));
  TRY_STATUS(from_json(to.sent_bytes_, from.extract_field("sent_bytes")));
  TRY_STATUS(from_json(to.received_bytes_, from.extract_field("received_bytes")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  return Status::OK();
}

Status from_json(td_api::notificationSettingsScopeChannelChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypePersonalDetails &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypePassportRegistration &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::pollTypeRegular &to, JsonObject &from) {
  TRY_STATUS(from_json(to.allow_multiple_answers_, from.extract_field("allow_multiple_answers")));
  return Status::OK();
}

Status from_json(td_api::premiumFeatureCustomEmoji &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureChatBoost &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeaturePaidMessages &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypePinnedSavedMessagesTopicCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeStorySuggestedReactionAreaCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeatureStealthMode &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabFiles &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::publicChatTypeIsLocationBased &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::replyMarkupRemoveKeyboard &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  return Status::OK();
}

Status from_json(td_api::reportReasonUnrelatedLocation &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesChatTypeFilterPrivate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterVoiceNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterFailedToSend &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::stickerTypeCustomEmoji &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::storeTransactionGooglePlay &to, JsonObject &from) {
  TRY_STATUS(from_json(to.package_name_, from.extract_field("package_name")));
  TRY_STATUS(from_json(to.store_product_id_, from.extract_field("store_product_id")));
  TRY_STATUS(from_json(to.purchase_token_, from.extract_field("purchase_token")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionEnableArchiveAndMuteNewChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionGiftPremiumForChristmas &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedPostPriceTon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.toncoin_cent_count_, from.extract_field("toncoin_cent_count")));
  return Status::OK();
}

Status from_json(td_api::targetChatCurrent &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::telegramPaymentPurposeStarGiveaway &to, JsonObject &from) {
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  TRY_STATUS(from_json(to.winner_count_, from.extract_field("winner_count")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypeUrl &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypeCode &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textParseModeMarkdown &to, JsonObject &from) {
  TRY_STATUS(from_json(to.version_, from.extract_field("version")));
  return Status::OK();
}

Status from_json(td_api::topChatCategoryCalls &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowProfilePhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAllowFindingByPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleAllowChatMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::webAppOpenModeFullSize &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::addChatMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::addLogMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.verbosity_level_, from.extract_field("verbosity_level")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::addQuickReplyShortcutInlineQueryResultMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_name_, from.extract_field("shortcut_name")));
  TRY_STATUS(from_json(to.reply_to_message_id_, from.extract_field("reply_to_message_id")));
  TRY_STATUS(from_json(to.query_id_, from.extract_field("query_id")));
  TRY_STATUS(from_json(to.result_id_, from.extract_field("result_id")));
  TRY_STATUS(from_json(to.hide_via_bot_, from.extract_field("hide_via_bot")));
  return Status::OK();
}

Status from_json(td_api::allowBotToSendMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::approveSuggestedPost &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.send_date_, from.extract_field("send_date")));
  return Status::OK();
}

Status from_json(td_api::canPurchaseFromStore &to, JsonObject &from) {
  TRY_STATUS(from_json(to.purpose_, from.extract_field("purpose")));
  return Status::OK();
}

Status from_json(td_api::changeStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.set_id_, from.extract_field("set_id")));
  TRY_STATUS(from_json(to.is_installed_, from.extract_field("is_installed")));
  TRY_STATUS(from_json(to.is_archived_, from.extract_field("is_archived")));
  return Status::OK();
}

Status from_json(td_api::checkChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::checkRecoveryEmailAddressCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::clearRecentStickers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_attached_, from.extract_field("is_attached")));
  return Status::OK();
}

Status from_json(td_api::closeGiftAuction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_id_, from.extract_field("gift_id")));
  return Status::OK();
}

Status from_json(td_api::createBasicGroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.basic_group_id_, from.extract_field("basic_group_id")));
  TRY_STATUS(from_json(to.force_, from.extract_field("force")));
  return Status::OK();
}

Status from_json(td_api::createGroupCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.join_parameters_, from.extract_field("join_parameters")));
  return Status::OK();
}

Status from_json(td_api::createSupergroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.force_, from.extract_field("force")));
  return Status::OK();
}

Status from_json(td_api::deleteBotMediaPreviews &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.file_ids_, from.extract_field("file_ids")));
  return Status::OK();
}

Status from_json(td_api::deleteChatHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.remove_from_chat_list_, from.extract_field("remove_from_chat_list")));
  TRY_STATUS(from_json(to.revoke_, from.extract_field("revoke")));
  return Status::OK();
}

Status from_json(td_api::deleteForumTopic &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  return Status::OK();
}

Status from_json(td_api::deleteQuickReplyShortcutMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_id_, from.extract_field("shortcut_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  return Status::OK();
}

Status from_json(td_api::destroy &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::editBotMediaPreview &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  TRY_STATUS(from_json(to.content_, from.extract_field("content")));
  return Status::OK();
}

Status from_json(td_api::editChatFolder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  TRY_STATUS(from_json(to.folder_, from.extract_field("folder")));
  return Status::OK();
}

Status from_json(td_api::editInlineMessageReplyMarkup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.inline_message_id_, from.extract_field("inline_message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  return Status::OK();
}

Status from_json(td_api::editProxy &to, JsonObject &from) {
  TRY_STATUS(from_json(to.proxy_id_, from.extract_field("proxy_id")));
  TRY_STATUS(from_json(to.server_, from.extract_field("server")));
  TRY_STATUS(from_json(to.port_, from.extract_field("port")));
  TRY_STATUS(from_json(to.enable_, from.extract_field("enable")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::endGroupCallRecording &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getApplicationConfig &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAutosaveSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getBotInfoShortDescription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  return Status::OK();
}

Status from_json(td_api::getBusinessConnectedBot &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getChatAvailableMessageSenders &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatFolder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getChatInviteLinkMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.only_with_expired_subscription_, from.extract_field("only_with_expired_subscription")));
  TRY_STATUS(from_json(to.offset_member_, from.extract_field("offset_member")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getChatNotificationSettingsExceptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.compare_sound_, from.extract_field("compare_sound")));
  return Status::OK();
}

Status from_json(td_api::getChatSparseMessagePositions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  return Status::OK();
}

Status from_json(td_api::getCollectibleItemInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::getCreatedPublicChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::getDefaultChatPhotoCustomEmojiStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getEmojiCategories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::getFileMimeType &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_name_, from.extract_field("file_name")));
  return Status::OK();
}

Status from_json(td_api::getGiftChatThemes &to, JsonObject &from) {
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getGroupCallStreamSegment &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.time_offset_, from.extract_field("time_offset")));
  TRY_STATUS(from_json(to.scale_, from.extract_field("scale")));
  TRY_STATUS(from_json(to.channel_id_, from.extract_field("channel_id")));
  TRY_STATUS(from_json(to.video_quality_, from.extract_field("video_quality")));
  return Status::OK();
}

Status from_json(td_api::getInternalLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.is_http_, from.extract_field("is_http")));
  return Status::OK();
}

Status from_json(td_api::getLiveStoryAvailableMessageSenders &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getLoginPasskeys &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getMessageAddedReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getMessageLocally &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getNetworkStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.only_current_, from.extract_field("only_current")));
  return Status::OK();
}

Status from_json(td_api::getPassportElement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getPremiumGiftPaymentOptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getProxyLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.proxy_id_, from.extract_field("proxy_id")));
  return Status::OK();
}

Status from_json(td_api::getRecentlyOpenedChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSavedMessagesTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getStakeDiceState &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getStatisticalGraph &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::getStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::getSuitableDiscussionChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getThemeParametersJsonString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.theme_, from.extract_field("theme")));
  return Status::OK();
}

Status from_json(td_api::getUpgradedGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::getUserPrivacySettingRules &to, JsonObject &from) {
  TRY_STATUS(from_json(to.setting_, from.extract_field("setting")));
  return Status::OK();
}

Status from_json(td_api::getWebAppPlaceholder &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::inviteGroupCallParticipant &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.is_video_, from.extract_field("is_video")));
  return Status::OK();
}

Status from_json(td_api::launchPrepaidGiveaway &to, JsonObject &from) {
  TRY_STATUS(from_json(to.giveaway_id_, from.extract_field("giveaway_id")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  TRY_STATUS(from_json(to.winner_count_, from.extract_field("winner_count")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::loadSavedMessagesTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::openStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::preliminaryUploadFile &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_, from.extract_field("file")));
  TRY_STATUS(from_json(to.file_type_, from.extract_field("file_type")));
  TRY_STATUS(from_json(to.priority_, from.extract_field("priority")));
  return Status::OK();
}

Status from_json(td_api::readAllDirectMessagesChatTopicReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  return Status::OK();
}

Status from_json(td_api::recoverPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.recovery_code_, from.extract_field("recovery_code")));
  TRY_STATUS(from_json(to.new_password_, from.extract_field("new_password")));
  TRY_STATUS(from_json(to.new_hint_, from.extract_field("new_hint")));
  return Status::OK();
}

Status from_json(td_api::removeFileFromDownloads &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  TRY_STATUS(from_json(to.delete_from_cache_, from.extract_field("delete_from_cache")));
  return Status::OK();
}

Status from_json(td_api::removePendingPaidMessageReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::removeStickerFromSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::reorderInstalledStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.sticker_set_ids_, from.extract_field("sticker_set_ids")));
  return Status::OK();
}

Status from_json(td_api::reportAuthenticationCodeMissing &to, JsonObject &from) {
  TRY_STATUS(from_json(to.mobile_network_code_, from.extract_field("mobile_network_code")));
  return Status::OK();
}

Status from_json(td_api::reportSupergroupSpam &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  return Status::OK();
}

Status from_json(td_api::resendPhoneNumberCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reason_, from.extract_field("reason")));
  return Status::OK();
}

Status from_json(td_api::revokeGroupCallInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::searchChatRecentLocationMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.filter_, from.extract_field("filter")));
  TRY_STATUS(from_json(to.chat_type_filter_, from.extract_field("chat_type_filter")));
  TRY_STATUS(from_json(to.min_date_, from.extract_field("min_date")));
  TRY_STATUS(from_json(to.max_date_, from.extract_field("max_date")));
  return Status::OK();
}

Status from_json(td_api::searchQuote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.quote_, from.extract_field("quote")));
  TRY_STATUS(from_json(to.quote_position_, from.extract_field("quote_position")));
  return Status::OK();
}

Status from_json(td_api::searchUserByToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::sendCallRating &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json(to.rating_, from.extract_field("rating")));
  TRY_STATUS(from_json(to.comment_, from.extract_field("comment")));
  TRY_STATUS(from_json(to.problems_, from.extract_field("problems")));
  return Status::OK();
}

Status from_json(td_api::sendMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::sendWebAppCustomRequest &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.method_, from.extract_field("method")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  return Status::OK();
}

Status from_json(td_api::setAuthenticationPremiumPurchaseTransaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.transaction_, from.extract_field("transaction")));
  TRY_STATUS(from_json(to.is_restore_, from.extract_field("is_restore")));
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  return Status::OK();
}

Status from_json(td_api::setBotUpdatesStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.pending_update_count_, from.extract_field("pending_update_count")));
  TRY_STATUS(from_json(to.error_message_, from.extract_field("error_message")));
  return Status::OK();
}

Status from_json(td_api::setBusinessLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  return Status::OK();
}

Status from_json(td_api::setChatClientData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.client_data_, from.extract_field("client_data")));
  return Status::OK();
}

Status from_json(td_api::setChatMessageSender &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_sender_id_, from.extract_field("message_sender_id")));
  return Status::OK();
}

Status from_json(td_api::setChatTitle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::setDefaultGroupAdministratorRights &to, JsonObject &from) {
  TRY_STATUS(from_json(to.default_group_administrator_rights_, from.extract_field("default_group_administrator_rights")));
  return Status::OK();
}

Status from_json(td_api::setGiftResalePrice &to, JsonObject &from) {
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  TRY_STATUS(from_json(to.price_, from.extract_field("price")));
  return Status::OK();
}

Status from_json(td_api::setLogTagVerbosityLevel &to, JsonObject &from) {
  TRY_STATUS(from_json(to.tag_, from.extract_field("tag")));
  TRY_STATUS(from_json(to.new_verbosity_level_, from.extract_field("new_verbosity_level")));
  return Status::OK();
}

Status from_json(td_api::setName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  return Status::OK();
}

Status from_json(td_api::setPinnedChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::setReactionNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.notification_settings_, from.extract_field("notification_settings")));
  return Status::OK();
}

Status from_json(td_api::setStickerSetThumbnail &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.format_, from.extract_field("format")));
  return Status::OK();
}

Status from_json(td_api::setSupergroupUsername &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::setVideoChatDefaultParticipant &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.default_participant_id_, from.extract_field("default_participant_id")));
  return Status::OK();
}

Status from_json(td_api::stopBusinessPoll &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  return Status::OK();
}

Status from_json(td_api::testCallEmpty &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::testReturnError &to, JsonObject &from) {
  TRY_STATUS(from_json(to.error_, from.extract_field("error")));
  return Status::OK();
}

Status from_json(td_api::toggleChatFolderTags &to, JsonObject &from) {
  TRY_STATUS(from_json(to.are_tags_enabled_, from.extract_field("are_tags_enabled")));
  return Status::OK();
}

Status from_json(td_api::toggleForumTopicIsClosed &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.is_closed_, from.extract_field("is_closed")));
  return Status::OK();
}

Status from_json(td_api::toggleGroupCallScreenSharingIsPaused &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.is_paused_, from.extract_field("is_paused")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupHasHiddenMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.has_hidden_members_, from.extract_field("has_hidden_members")));
  return Status::OK();
}

Status from_json(td_api::toggleVideoChatEnabledStartNotification &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.enabled_start_notification_, from.extract_field("enabled_start_notification")));
  return Status::OK();
}

Status from_json(td_api::unpinAllForumTopicMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  return Status::OK();
}

Status from_json(td_api::viewTrendingStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_set_ids_, from.extract_field("sticker_set_ids")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::addedReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "addedReactions");
  jo("total_count", object.total_count_);
  jo("reactions", ToJson(object.reactions_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::animatedEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "animatedEmoji");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  jo("sticker_width", object.sticker_width_);
  jo("sticker_height", object.sticker_height_);
  jo("fitzpatrick_type", object.fitzpatrick_type_);
  if (object.sound_) {
    jo("sound", ToJson(*object.sound_));
  }
}

void to_json(JsonValueScope &jv, const td_api::audio &object) {
  auto jo = jv.enter_object();
  jo("@type", "audio");
  jo("duration", object.duration_);
  jo("title", object.title_);
  jo("performer", object.performer_);
  jo("file_name", object.file_name_);
  jo("mime_type", object.mime_type_);
  if (object.album_cover_minithumbnail_) {
    jo("album_cover_minithumbnail", ToJson(*object.album_cover_minithumbnail_));
  }
  if (object.album_cover_thumbnail_) {
    jo("album_cover_thumbnail", ToJson(*object.album_cover_thumbnail_));
  }
  jo("external_album_covers", ToJson(object.external_album_covers_));
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
}

void to_json(JsonValueScope &jv, const td_api::AutosaveSettingsScope &object) {
  td_api::downcast_call(const_cast<td_api::AutosaveSettingsScope &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::autosaveSettingsScopePrivateChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "autosaveSettingsScopePrivateChats");
}

void to_json(JsonValueScope &jv, const td_api::autosaveSettingsScopeGroupChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "autosaveSettingsScopeGroupChats");
}

void to_json(JsonValueScope &jv, const td_api::autosaveSettingsScopeChannelChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "autosaveSettingsScopeChannelChats");
}

void to_json(JsonValueScope &jv, const td_api::autosaveSettingsScopeChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "autosaveSettingsScopeChat");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::bankCardActionOpenUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "bankCardActionOpenUrl");
  jo("text", object.text_);
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::botMediaPreview &object) {
  auto jo = jv.enter_object();
  jo("@type", "botMediaPreview");
  jo("date", object.date_);
  if (object.content_) {
    jo("content", ToJson(*object.content_));
  }
}

void to_json(JsonValueScope &jv, const td_api::businessAwayMessageSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessAwayMessageSettings");
  jo("shortcut_id", object.shortcut_id_);
  if (object.recipients_) {
    jo("recipients", ToJson(*object.recipients_));
  }
  if (object.schedule_) {
    jo("schedule", ToJson(*object.schedule_));
  }
  jo("offline_only", JsonBool{object.offline_only_});
}

void to_json(JsonValueScope &jv, const td_api::businessFeaturePromotionAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeaturePromotionAnimation");
  if (object.feature_) {
    jo("feature", ToJson(*object.feature_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::businessRecipients &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessRecipients");
  jo("chat_ids", ToJson(object.chat_ids_));
  jo("excluded_chat_ids", ToJson(object.excluded_chat_ids_));
  jo("select_existing_chats", JsonBool{object.select_existing_chats_});
  jo("select_new_chats", JsonBool{object.select_new_chats_});
  jo("select_contacts", JsonBool{object.select_contacts_});
  jo("select_non_contacts", JsonBool{object.select_non_contacts_});
  jo("exclude_selected", JsonBool{object.exclude_selected_});
}

void to_json(JsonValueScope &jv, const td_api::callbackQueryAnswer &object) {
  auto jo = jv.enter_object();
  jo("@type", "callbackQueryAnswer");
  jo("text", object.text_);
  jo("show_alert", JsonBool{object.show_alert_});
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::chatActiveStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatActiveStories");
  jo("chat_id", object.chat_id_);
  if (object.list_) {
    jo("list", ToJson(*object.list_));
  }
  jo("order", object.order_);
  jo("can_be_archived", JsonBool{object.can_be_archived_});
  jo("max_read_story_id", object.max_read_story_id_);
  jo("stories", ToJson(object.stories_));
}

void to_json(JsonValueScope &jv, const td_api::chatBoostLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostLink");
  jo("link", object.link_);
  jo("is_public", JsonBool{object.is_public_});
}

void to_json(JsonValueScope &jv, const td_api::chatFolder &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolder");
  if (object.name_) {
    jo("name", ToJson(*object.name_));
  }
  if (object.icon_) {
    jo("icon", ToJson(*object.icon_));
  }
  jo("color_id", object.color_id_);
  jo("is_shareable", JsonBool{object.is_shareable_});
  jo("pinned_chat_ids", ToJson(object.pinned_chat_ids_));
  jo("included_chat_ids", ToJson(object.included_chat_ids_));
  jo("excluded_chat_ids", ToJson(object.excluded_chat_ids_));
  jo("exclude_muted", JsonBool{object.exclude_muted_});
  jo("exclude_read", JsonBool{object.exclude_read_});
  jo("exclude_archived", JsonBool{object.exclude_archived_});
  jo("include_contacts", JsonBool{object.include_contacts_});
  jo("include_non_contacts", JsonBool{object.include_non_contacts_});
  jo("include_bots", JsonBool{object.include_bots_});
  jo("include_groups", JsonBool{object.include_groups_});
  jo("include_channels", JsonBool{object.include_channels_});
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinkCounts &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinkCounts");
  jo("invite_link_counts", ToJson(object.invite_link_counts_));
}

void to_json(JsonValueScope &jv, const td_api::ChatList &object) {
  td_api::downcast_call(const_cast<td_api::ChatList &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatListMain &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatListMain");
}

void to_json(JsonValueScope &jv, const td_api::chatListArchive &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatListArchive");
}

void to_json(JsonValueScope &jv, const td_api::chatListFolder &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatListFolder");
  jo("chat_folder_id", object.chat_folder_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatPermissions &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPermissions");
  jo("can_send_basic_messages", JsonBool{object.can_send_basic_messages_});
  jo("can_send_audios", JsonBool{object.can_send_audios_});
  jo("can_send_documents", JsonBool{object.can_send_documents_});
  jo("can_send_photos", JsonBool{object.can_send_photos_});
  jo("can_send_videos", JsonBool{object.can_send_videos_});
  jo("can_send_video_notes", JsonBool{object.can_send_video_notes_});
  jo("can_send_voice_notes", JsonBool{object.can_send_voice_notes_});
  jo("can_send_polls", JsonBool{object.can_send_polls_});
  jo("can_send_other_messages", JsonBool{object.can_send_other_messages_});
  jo("can_add_link_previews", JsonBool{object.can_add_link_previews_});
  jo("can_change_info", JsonBool{object.can_change_info_});
  jo("can_invite_users", JsonBool{object.can_invite_users_});
  jo("can_pin_messages", JsonBool{object.can_pin_messages_});
  jo("can_create_topics", JsonBool{object.can_create_topics_});
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueTransaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueTransaction");
  jo("cryptocurrency", object.cryptocurrency_);
  jo("cryptocurrency_amount", ToJson(JsonInt64{object.cryptocurrency_amount_}));
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::ChatStatisticsObjectType &object) {
  td_api::downcast_call(const_cast<td_api::ChatStatisticsObjectType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsObjectTypeMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsObjectTypeMessage");
  jo("message_id", object.message_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsObjectTypeStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsObjectTypeStory");
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::closedVectorPath &object) {
  auto jo = jv.enter_object();
  jo("@type", "closedVectorPath");
  jo("commands", ToJson(object.commands_));
}

void to_json(JsonValueScope &jv, const td_api::countries &object) {
  auto jo = jv.enter_object();
  jo("@type", "countries");
  jo("countries", ToJson(object.countries_));
}

void to_json(JsonValueScope &jv, const td_api::datedFile &object) {
  auto jo = jv.enter_object();
  jo("@type", "datedFile");
  if (object.file_) {
    jo("file", ToJson(*object.file_));
  }
  jo("date", object.date_);
}

void to_json(JsonValueScope &jv, const td_api::emojiCategories &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiCategories");
  jo("categories", ToJson(object.categories_));
}

void to_json(JsonValueScope &jv, const td_api::EmojiStatusType &object) {
  td_api::downcast_call(const_cast<td_api::EmojiStatusType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::emojiStatusTypeCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiStatusTypeCustomEmoji");
  jo("custom_emoji_id", ToJson(JsonInt64{object.custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::emojiStatusTypeUpgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiStatusTypeUpgradedGift");
  jo("upgraded_gift_id", ToJson(JsonInt64{object.upgraded_gift_id_}));
  jo("gift_title", object.gift_title_);
  jo("gift_name", object.gift_name_);
  jo("model_custom_emoji_id", ToJson(JsonInt64{object.model_custom_emoji_id_}));
  jo("symbol_custom_emoji_id", ToJson(JsonInt64{object.symbol_custom_emoji_id_}));
  if (object.backdrop_colors_) {
    jo("backdrop_colors", ToJson(*object.backdrop_colors_));
  }
}

void to_json(JsonValueScope &jv, const td_api::file &object) {
  auto jo = jv.enter_object();
  jo("@type", "file");
  jo("id", object.id_);
  jo("size", object.size_);
  jo("expected_size", object.expected_size_);
  if (object.local_) {
    jo("local", ToJson(*object.local_));
  }
  if (object.remote_) {
    jo("remote", ToJson(*object.remote_));
  }
}

void to_json(JsonValueScope &jv, const td_api::forumTopics &object) {
  auto jo = jv.enter_object();
  jo("@type", "forumTopics");
  jo("total_count", object.total_count_);
  jo("topics", ToJson(object.topics_));
  jo("next_offset_date", object.next_offset_date_);
  jo("next_offset_message_id", object.next_offset_message_id_);
  jo("next_offset_forum_topic_id", object.next_offset_forum_topic_id_);
}

void to_json(JsonValueScope &jv, const td_api::foundPositions &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundPositions");
  jo("total_count", object.total_count_);
  jo("positions", ToJson(object.positions_));
}

void to_json(JsonValueScope &jv, const td_api::giftAuction &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftAuction");
  jo("id", object.id_);
  jo("gifts_per_round", object.gifts_per_round_);
  jo("start_date", object.start_date_);
}

void to_json(JsonValueScope &jv, const td_api::giftForResale &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftForResale");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("received_gift_id", object.received_gift_id_);
}

void to_json(JsonValueScope &jv, const td_api::giftUpgradeVariants &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftUpgradeVariants");
  jo("models", ToJson(object.models_));
  jo("symbols", ToJson(object.symbols_));
  jo("backdrops", ToJson(object.backdrops_));
}

void to_json(JsonValueScope &jv, const td_api::groupCallMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallMessage");
  jo("message_id", object.message_id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("date", object.date_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("paid_message_star_count", object.paid_message_star_count_);
  jo("is_from_owner", JsonBool{object.is_from_owner_});
  jo("can_be_deleted", JsonBool{object.can_be_deleted_});
}

void to_json(JsonValueScope &jv, const td_api::hashtags &object) {
  auto jo = jv.enter_object();
  jo("@type", "hashtags");
  jo("hashtags", ToJson(object.hashtags_));
}

void to_json(JsonValueScope &jv, const td_api::InlineQueryResultsButtonType &object) {
  td_api::downcast_call(const_cast<td_api::InlineQueryResultsButtonType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inlineQueryResultsButtonTypeStartBot &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineQueryResultsButtonTypeStartBot");
  jo("parameter", object.parameter_);
}

void to_json(JsonValueScope &jv, const td_api::inlineQueryResultsButtonTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineQueryResultsButtonTypeWebApp");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::inputTextQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputTextQuote");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("position", object.position_);
}

void to_json(JsonValueScope &jv, const td_api::KeyboardButtonType &object) {
  td_api::downcast_call(const_cast<td_api::KeyboardButtonType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeText &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeText");
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestPhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestLocation");
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestPoll &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestPoll");
  jo("force_regular", JsonBool{object.force_regular_});
  jo("force_quiz", JsonBool{object.force_quiz_});
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestUsers &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestUsers");
  jo("id", object.id_);
  jo("restrict_user_is_bot", JsonBool{object.restrict_user_is_bot_});
  jo("user_is_bot", JsonBool{object.user_is_bot_});
  jo("restrict_user_is_premium", JsonBool{object.restrict_user_is_premium_});
  jo("user_is_premium", JsonBool{object.user_is_premium_});
  jo("max_quantity", object.max_quantity_);
  jo("request_name", JsonBool{object.request_name_});
  jo("request_username", JsonBool{object.request_username_});
  jo("request_photo", JsonBool{object.request_photo_});
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeRequestChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeRequestChat");
  jo("id", object.id_);
  jo("chat_is_channel", JsonBool{object.chat_is_channel_});
  jo("restrict_chat_is_forum", JsonBool{object.restrict_chat_is_forum_});
  jo("chat_is_forum", JsonBool{object.chat_is_forum_});
  jo("restrict_chat_has_username", JsonBool{object.restrict_chat_has_username_});
  jo("chat_has_username", JsonBool{object.chat_has_username_});
  jo("chat_is_created", JsonBool{object.chat_is_created_});
  if (object.user_administrator_rights_) {
    jo("user_administrator_rights", ToJson(*object.user_administrator_rights_));
  }
  if (object.bot_administrator_rights_) {
    jo("bot_administrator_rights", ToJson(*object.bot_administrator_rights_));
  }
  jo("bot_is_member", JsonBool{object.bot_is_member_});
  jo("request_title", JsonBool{object.request_title_});
  jo("request_username", JsonBool{object.request_username_});
  jo("request_photo", JsonBool{object.request_photo_});
}

void to_json(JsonValueScope &jv, const td_api::keyboardButtonTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "keyboardButtonTypeWebApp");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::LinkPreviewType &object) {
  td_api::downcast_call(const_cast<td_api::LinkPreviewType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeAlbum");
  jo("media", ToJson(object.media_));
  jo("caption", object.caption_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeAnimation");
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeApp");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeArticle &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeArticle");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeAudio");
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeBackground");
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
  if (object.background_type_) {
    jo("background_type", ToJson(*object.background_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeChannelBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeChannelBoost");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeChat");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("creates_join_request", JsonBool{object.creates_join_request_});
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeDirectMessagesChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeDirectMessagesChat");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeDocument");
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeEmbeddedAnimationPlayer &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeEmbeddedAnimationPlayer");
  jo("url", object.url_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeEmbeddedAudioPlayer &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeEmbeddedAudioPlayer");
  jo("url", object.url_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeEmbeddedVideoPlayer &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeEmbeddedVideoPlayer");
  jo("url", object.url_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeExternalAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeExternalAudio");
  jo("url", object.url_);
  jo("mime_type", object.mime_type_);
  jo("duration", object.duration_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeExternalVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeExternalVideo");
  jo("url", object.url_);
  jo("mime_type", object.mime_type_);
  jo("width", object.width_);
  jo("height", object.height_);
  jo("duration", object.duration_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeGiftAuction &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeGiftAuction");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("auction_end_date", object.auction_end_date_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeGiftCollection &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeGiftCollection");
  jo("icons", ToJson(object.icons_));
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeGroupCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeGroupCall");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeInvoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeInvoice");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeLiveStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeLiveStory");
  jo("story_poster_chat_id", object.story_poster_chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeMessage");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypePhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypePremiumGiftCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypePremiumGiftCode");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeShareableChatFolder &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeShareableChatFolder");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeSticker");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeStickerSet &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeStickerSet");
  jo("stickers", ToJson(object.stickers_));
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeStory");
  jo("story_poster_chat_id", object.story_poster_chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeStoryAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeStoryAlbum");
  if (object.photo_icon_) {
    jo("photo_icon", ToJson(*object.photo_icon_));
  }
  if (object.video_icon_) {
    jo("video_icon", ToJson(*object.video_icon_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeSupergroupBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeSupergroupBoost");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeTheme");
  jo("documents", ToJson(object.documents_));
  if (object.settings_) {
    jo("settings", ToJson(*object.settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeUnsupported &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeUnsupported");
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeUpgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeUpgradedGift");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeUser");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("is_bot", JsonBool{object.is_bot_});
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  if (object.cover_) {
    jo("cover", ToJson(*object.cover_));
  }
  jo("start_timestamp", object.start_timestamp_);
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVideoChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVideoChat");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("is_live_stream", JsonBool{object.is_live_stream_});
  jo("joins_as_speaker", JsonBool{object.joins_as_speaker_});
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVideoNote");
  if (object.video_note_) {
    jo("video_note", ToJson(*object.video_note_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeVoiceNote");
  if (object.voice_note_) {
    jo("voice_note", ToJson(*object.voice_note_));
  }
}

void to_json(JsonValueScope &jv, const td_api::linkPreviewTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "linkPreviewTypeWebApp");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::LoginUrlInfo &object) {
  td_api::downcast_call(const_cast<td_api::LoginUrlInfo &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::loginUrlInfoOpen &object) {
  auto jo = jv.enter_object();
  jo("@type", "loginUrlInfoOpen");
  jo("url", object.url_);
  jo("skip_confirmation", JsonBool{object.skip_confirmation_});
}

void to_json(JsonValueScope &jv, const td_api::loginUrlInfoRequestConfirmation &object) {
  auto jo = jv.enter_object();
  jo("@type", "loginUrlInfoRequestConfirmation");
  jo("url", object.url_);
  jo("domain", object.domain_);
  jo("bot_user_id", object.bot_user_id_);
  jo("request_write_access", JsonBool{object.request_write_access_});
}

void to_json(JsonValueScope &jv, const td_api::messageCopyOptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageCopyOptions");
  jo("send_copy", JsonBool{object.send_copy_});
  jo("replace_caption", JsonBool{object.replace_caption_});
  if (object.new_caption_) {
    jo("new_caption", ToJson(*object.new_caption_));
  }
  jo("new_show_caption_above_media", JsonBool{object.new_show_caption_above_media_});
}

void to_json(JsonValueScope &jv, const td_api::MessageOrigin &object) {
  td_api::downcast_call(const_cast<td_api::MessageOrigin &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageOriginUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginUser");
  jo("sender_user_id", object.sender_user_id_);
}

void to_json(JsonValueScope &jv, const td_api::messageOriginHiddenUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginHiddenUser");
  jo("sender_name", object.sender_name_);
}

void to_json(JsonValueScope &jv, const td_api::messageOriginChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginChat");
  jo("sender_chat_id", object.sender_chat_id_);
  jo("author_signature", object.author_signature_);
}

void to_json(JsonValueScope &jv, const td_api::messageOriginChannel &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageOriginChannel");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  jo("author_signature", object.author_signature_);
}

void to_json(JsonValueScope &jv, const td_api::MessageSchedulingState &object) {
  td_api::downcast_call(const_cast<td_api::MessageSchedulingState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageSchedulingStateSendAtDate &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSchedulingStateSendAtDate");
  jo("send_date", object.send_date_);
  jo("repeat_period", object.repeat_period_);
}

void to_json(JsonValueScope &jv, const td_api::messageSchedulingStateSendWhenOnline &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSchedulingStateSendWhenOnline");
}

void to_json(JsonValueScope &jv, const td_api::messageSchedulingStateSendWhenVideoProcessed &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSchedulingStateSendWhenVideoProcessed");
  jo("send_date", object.send_date_);
}

void to_json(JsonValueScope &jv, const td_api::messageViewers &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageViewers");
  jo("viewers", ToJson(object.viewers_));
}

void to_json(JsonValueScope &jv, const td_api::NotificationGroupType &object) {
  td_api::downcast_call(const_cast<td_api::NotificationGroupType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeMessages");
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeMentions &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeMentions");
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeSecretChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeSecretChat");
}

void to_json(JsonValueScope &jv, const td_api::notificationGroupTypeCalls &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationGroupTypeCalls");
}

void to_json(JsonValueScope &jv, const td_api::PageBlock &object) {
  td_api::downcast_call(const_cast<td_api::PageBlock &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::pageBlockTitle &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockTitle");
  if (object.title_) {
    jo("title", ToJson(*object.title_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockSubtitle &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockSubtitle");
  if (object.subtitle_) {
    jo("subtitle", ToJson(*object.subtitle_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAuthorDate &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAuthorDate");
  if (object.author_) {
    jo("author", ToJson(*object.author_));
  }
  jo("publish_date", object.publish_date_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHeader &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHeader");
  if (object.header_) {
    jo("header", ToJson(*object.header_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockSubheader &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockSubheader");
  if (object.subheader_) {
    jo("subheader", ToJson(*object.subheader_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockKicker &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockKicker");
  if (object.kicker_) {
    jo("kicker", ToJson(*object.kicker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockParagraph &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockParagraph");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockPreformatted &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockPreformatted");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("language", object.language_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockFooter &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockFooter");
  if (object.footer_) {
    jo("footer", ToJson(*object.footer_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockDivider &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockDivider");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAnchor &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAnchor");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockList &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockList");
  jo("items", ToJson(object.items_));
}

void to_json(JsonValueScope &jv, const td_api::pageBlockBlockQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockBlockQuote");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.credit_) {
    jo("credit", ToJson(*object.credit_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockPullQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockPullQuote");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.credit_) {
    jo("credit", ToJson(*object.credit_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAnimation");
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("need_autoplay", JsonBool{object.need_autoplay_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockAudio");
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockPhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("need_autoplay", JsonBool{object.need_autoplay_});
  jo("is_looped", JsonBool{object.is_looped_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockVoiceNote");
  if (object.voice_note_) {
    jo("voice_note", ToJson(*object.voice_note_));
  }
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockCover &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockCover");
  if (object.cover_) {
    jo("cover", ToJson(*object.cover_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockEmbedded &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockEmbedded");
  jo("url", object.url_);
  jo("html", object.html_);
  if (object.poster_photo_) {
    jo("poster_photo", ToJson(*object.poster_photo_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("is_full_width", JsonBool{object.is_full_width_});
  jo("allow_scrolling", JsonBool{object.allow_scrolling_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockEmbeddedPost &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockEmbeddedPost");
  jo("url", object.url_);
  jo("author", object.author_);
  if (object.author_photo_) {
    jo("author_photo", ToJson(*object.author_photo_));
  }
  jo("date", object.date_);
  jo("page_blocks", ToJson(object.page_blocks_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockCollage &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockCollage");
  jo("page_blocks", ToJson(object.page_blocks_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockSlideshow &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockSlideshow");
  jo("page_blocks", ToJson(object.page_blocks_));
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::pageBlockChatLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockChatLink");
  jo("title", object.title_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("accent_color_id", object.accent_color_id_);
  jo("username", object.username_);
}

void to_json(JsonValueScope &jv, const td_api::pageBlockTable &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockTable");
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
  jo("cells", ToJson(object.cells_));
  jo("is_bordered", JsonBool{object.is_bordered_});
  jo("is_striped", JsonBool{object.is_striped_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockDetails &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockDetails");
  if (object.header_) {
    jo("header", ToJson(*object.header_));
  }
  jo("page_blocks", ToJson(object.page_blocks_));
  jo("is_open", JsonBool{object.is_open_});
}

void to_json(JsonValueScope &jv, const td_api::pageBlockRelatedArticles &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockRelatedArticles");
  if (object.header_) {
    jo("header", ToJson(*object.header_));
  }
  jo("articles", ToJson(object.articles_));
}

void to_json(JsonValueScope &jv, const td_api::pageBlockMap &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockMap");
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  jo("zoom", object.zoom_);
  jo("width", object.width_);
  jo("height", object.height_);
  if (object.caption_) {
    jo("caption", ToJson(*object.caption_));
  }
}

void to_json(JsonValueScope &jv, const td_api::paidReactor &object) {
  auto jo = jv.enter_object();
  jo("@type", "paidReactor");
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("star_count", object.star_count_);
  jo("is_top", JsonBool{object.is_top_});
  jo("is_me", JsonBool{object.is_me_});
  jo("is_anonymous", JsonBool{object.is_anonymous_});
}

void to_json(JsonValueScope &jv, const td_api::passportElementsWithErrors &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementsWithErrors");
  jo("elements", ToJson(object.elements_));
  jo("errors", ToJson(object.errors_));
}

void to_json(JsonValueScope &jv, const td_api::PaymentReceiptType &object) {
  td_api::downcast_call(const_cast<td_api::PaymentReceiptType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::paymentReceiptTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentReceiptTypeRegular");
  jo("payment_provider_user_id", object.payment_provider_user_id_);
  if (object.invoice_) {
    jo("invoice", ToJson(*object.invoice_));
  }
  if (object.order_info_) {
    jo("order_info", ToJson(*object.order_info_));
  }
  if (object.shipping_option_) {
    jo("shipping_option", ToJson(*object.shipping_option_));
  }
  jo("credentials_title", object.credentials_title_);
  jo("tip_amount", object.tip_amount_);
}

void to_json(JsonValueScope &jv, const td_api::paymentReceiptTypeStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentReceiptTypeStars");
  jo("star_count", object.star_count_);
  jo("transaction_id", object.transaction_id_);
}

void to_json(JsonValueScope &jv, const td_api::pollOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "pollOption");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("voter_count", object.voter_count_);
  jo("vote_percentage", object.vote_percentage_);
  jo("is_chosen", JsonBool{object.is_chosen_});
  jo("is_being_chosen", JsonBool{object.is_being_chosen_});
}

void to_json(JsonValueScope &jv, const td_api::premiumGiveawayPaymentOptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumGiveawayPaymentOptions");
  jo("options", ToJson(object.options_));
}

void to_json(JsonValueScope &jv, const td_api::productInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "productInfo");
  jo("title", object.title_);
  if (object.description_) {
    jo("description", ToJson(*object.description_));
  }
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::publicForwards &object) {
  auto jo = jv.enter_object();
  jo("@type", "publicForwards");
  jo("total_count", object.total_count_);
  jo("forwards", ToJson(object.forwards_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::ReactionType &object) {
  td_api::downcast_call(const_cast<td_api::ReactionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::reactionTypeEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "reactionTypeEmoji");
  jo("emoji", object.emoji_);
}

void to_json(JsonValueScope &jv, const td_api::reactionTypeCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "reactionTypeCustomEmoji");
  jo("custom_emoji_id", ToJson(JsonInt64{object.custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::reactionTypePaid &object) {
  auto jo = jv.enter_object();
  jo("@type", "reactionTypePaid");
}

void to_json(JsonValueScope &jv, const td_api::ReplyMarkup &object) {
  td_api::downcast_call(const_cast<td_api::ReplyMarkup &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::replyMarkupRemoveKeyboard &object) {
  auto jo = jv.enter_object();
  jo("@type", "replyMarkupRemoveKeyboard");
  jo("is_personal", JsonBool{object.is_personal_});
}

void to_json(JsonValueScope &jv, const td_api::replyMarkupForceReply &object) {
  auto jo = jv.enter_object();
  jo("@type", "replyMarkupForceReply");
  jo("is_personal", JsonBool{object.is_personal_});
  jo("input_field_placeholder", object.input_field_placeholder_);
}

void to_json(JsonValueScope &jv, const td_api::replyMarkupShowKeyboard &object) {
  auto jo = jv.enter_object();
  jo("@type", "replyMarkupShowKeyboard");
  jo("rows", ToJson(object.rows_));
  jo("is_persistent", JsonBool{object.is_persistent_});
  jo("resize_keyboard", JsonBool{object.resize_keyboard_});
  jo("one_time", JsonBool{object.one_time_});
  jo("is_personal", JsonBool{object.is_personal_});
  jo("input_field_placeholder", object.input_field_placeholder_);
}

void to_json(JsonValueScope &jv, const td_api::replyMarkupInlineKeyboard &object) {
  auto jo = jv.enter_object();
  jo("@type", "replyMarkupInlineKeyboard");
  jo("rows", ToJson(object.rows_));
}

void to_json(JsonValueScope &jv, const td_api::rtmpUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "rtmpUrl");
  jo("url", object.url_);
  jo("stream_key", object.stream_key_);
}

void to_json(JsonValueScope &jv, const td_api::secretChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "secretChat");
  jo("id", object.id_);
  jo("user_id", object.user_id_);
  if (object.state_) {
    jo("state", ToJson(*object.state_));
  }
  jo("is_outbound", JsonBool{object.is_outbound_});
  jo("key_hash", base64_encode(object.key_hash_));
  jo("layer", object.layer_);
}

void to_json(JsonValueScope &jv, const td_api::shippingOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "shippingOption");
  jo("id", object.id_);
  jo("title", object.title_);
  jo("price_parts", ToJson(object.price_parts_));
}

void to_json(JsonValueScope &jv, const td_api::starGiveawayPaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "starGiveawayPaymentOption");
  jo("currency", object.currency_);
  jo("amount", object.amount_);
  jo("star_count", object.star_count_);
  jo("store_product_id", object.store_product_id_);
  jo("yearly_boost_count", object.yearly_boost_count_);
  jo("winner_options", ToJson(object.winner_options_));
  jo("is_default", JsonBool{object.is_default_});
  jo("is_additional", JsonBool{object.is_additional_});
}

void to_json(JsonValueScope &jv, const td_api::StarSubscriptionType &object) {
  td_api::downcast_call(const_cast<td_api::StarSubscriptionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::starSubscriptionTypeChannel &object) {
  auto jo = jv.enter_object();
  jo("@type", "starSubscriptionTypeChannel");
  jo("can_reuse", JsonBool{object.can_reuse_});
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::starSubscriptionTypeBot &object) {
  auto jo = jv.enter_object();
  jo("@type", "starSubscriptionTypeBot");
  jo("is_canceled_by_bot", JsonBool{object.is_canceled_by_bot_});
  jo("title", object.title_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("invoice_link", object.invoice_link_);
}

void to_json(JsonValueScope &jv, const td_api::StickerFormat &object) {
  td_api::downcast_call(const_cast<td_api::StickerFormat &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::stickerFormatWebp &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerFormatWebp");
}

void to_json(JsonValueScope &jv, const td_api::stickerFormatTgs &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerFormatTgs");
}

void to_json(JsonValueScope &jv, const td_api::stickerFormatWebm &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerFormatWebm");
}

void to_json(JsonValueScope &jv, const td_api::storageStatisticsByFileType &object) {
  auto jo = jv.enter_object();
  jo("@type", "storageStatisticsByFileType");
  if (object.file_type_) {
    jo("file_type", ToJson(*object.file_type_));
  }
  jo("size", object.size_);
  jo("count", object.count_);
}

void to_json(JsonValueScope &jv, const td_api::StoryContent &object) {
  td_api::downcast_call(const_cast<td_api::StoryContent &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::storyContentPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyContentPhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
}

void to_json(JsonValueScope &jv, const td_api::storyContentVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyContentVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  if (object.alternative_video_) {
    jo("alternative_video", ToJson(*object.alternative_video_));
  }
}

void to_json(JsonValueScope &jv, const td_api::storyContentLive &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyContentLive");
  jo("group_call_id", object.group_call_id_);
  jo("is_rtmp_stream", JsonBool{object.is_rtmp_stream_});
}

void to_json(JsonValueScope &jv, const td_api::storyContentUnsupported &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyContentUnsupported");
}

void to_json(JsonValueScope &jv, const td_api::storyRepostInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyRepostInfo");
  if (object.origin_) {
    jo("origin", ToJson(*object.origin_));
  }
  jo("is_content_modified", JsonBool{object.is_content_modified_});
}

void to_json(JsonValueScope &jv, const td_api::supergroupFullInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "supergroupFullInfo");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("description", object.description_);
  jo("member_count", object.member_count_);
  jo("administrator_count", object.administrator_count_);
  jo("restricted_count", object.restricted_count_);
  jo("banned_count", object.banned_count_);
  jo("linked_chat_id", object.linked_chat_id_);
  jo("direct_messages_chat_id", object.direct_messages_chat_id_);
  jo("slow_mode_delay", object.slow_mode_delay_);
  jo("slow_mode_delay_expires_in", object.slow_mode_delay_expires_in_);
  jo("can_enable_paid_messages", JsonBool{object.can_enable_paid_messages_});
  jo("can_enable_paid_reaction", JsonBool{object.can_enable_paid_reaction_});
  jo("can_get_members", JsonBool{object.can_get_members_});
  jo("has_hidden_members", JsonBool{object.has_hidden_members_});
  jo("can_hide_members", JsonBool{object.can_hide_members_});
  jo("can_set_sticker_set", JsonBool{object.can_set_sticker_set_});
  jo("can_set_location", JsonBool{object.can_set_location_});
  jo("can_get_statistics", JsonBool{object.can_get_statistics_});
  jo("can_get_revenue_statistics", JsonBool{object.can_get_revenue_statistics_});
  jo("can_get_star_revenue_statistics", JsonBool{object.can_get_star_revenue_statistics_});
  jo("can_send_gift", JsonBool{object.can_send_gift_});
  jo("can_toggle_aggressive_anti_spam", JsonBool{object.can_toggle_aggressive_anti_spam_});
  jo("is_all_history_available", JsonBool{object.is_all_history_available_});
  jo("can_have_sponsored_messages", JsonBool{object.can_have_sponsored_messages_});
  jo("has_aggressive_anti_spam_enabled", JsonBool{object.has_aggressive_anti_spam_enabled_});
  jo("has_paid_media_allowed", JsonBool{object.has_paid_media_allowed_});
  jo("has_pinned_stories", JsonBool{object.has_pinned_stories_});
  jo("gift_count", object.gift_count_);
  jo("my_boost_count", object.my_boost_count_);
  jo("unrestrict_boost_count", object.unrestrict_boost_count_);
  jo("outgoing_paid_message_star_count", object.outgoing_paid_message_star_count_);
  jo("sticker_set_id", ToJson(JsonInt64{object.sticker_set_id_}));
  jo("custom_emoji_sticker_set_id", ToJson(JsonInt64{object.custom_emoji_sticker_set_id_}));
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  if (object.invite_link_) {
    jo("invite_link", ToJson(*object.invite_link_));
  }
  jo("bot_commands", ToJson(object.bot_commands_));
  if (object.bot_verification_) {
    jo("bot_verification", ToJson(*object.bot_verification_));
  }
  if (object.main_profile_tab_) {
    jo("main_profile_tab", ToJson(*object.main_profile_tab_));
  }
  jo("upgraded_from_basic_group_id", object.upgraded_from_basic_group_id_);
  jo("upgraded_from_max_message_id", object.upgraded_from_max_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::testInt &object) {
  auto jo = jv.enter_object();
  jo("@type", "testInt");
  jo("value", object.value_);
}

void to_json(JsonValueScope &jv, const td_api::TextEntityType &object) {
  td_api::downcast_call(const_cast<td_api::TextEntityType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeMention &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeMention");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeHashtag &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeHashtag");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeCashtag &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeCashtag");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeBotCommand &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeBotCommand");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeUrl");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeEmailAddress &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeEmailAddress");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypePhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypePhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeBankCardNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeBankCardNumber");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeBold &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeBold");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeItalic &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeItalic");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeUnderline &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeUnderline");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeStrikethrough &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeStrikethrough");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeSpoiler &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeSpoiler");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeCode");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypePre &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypePre");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypePreCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypePreCode");
  jo("language", object.language_);
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeBlockQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeBlockQuote");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeExpandableBlockQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeExpandableBlockQuote");
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeTextUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeTextUrl");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeMentionName &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeMentionName");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeCustomEmoji");
  jo("custom_emoji_id", ToJson(JsonInt64{object.custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::textEntityTypeMediaTimestamp &object) {
  auto jo = jv.enter_object();
  jo("@type", "textEntityTypeMediaTimestamp");
  jo("media_timestamp", object.media_timestamp_);
}

void to_json(JsonValueScope &jv, const td_api::tonTransaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransaction");
  jo("id", object.id_);
  jo("ton_amount", object.ton_amount_);
  jo("is_refund", JsonBool{object.is_refund_});
  jo("date", object.date_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::upgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGift");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("regular_gift_id", ToJson(JsonInt64{object.regular_gift_id_}));
  jo("publisher_chat_id", object.publisher_chat_id_);
  jo("title", object.title_);
  jo("name", object.name_);
  jo("number", object.number_);
  jo("total_upgraded_count", object.total_upgraded_count_);
  jo("max_upgraded_count", object.max_upgraded_count_);
  jo("is_premium", JsonBool{object.is_premium_});
  jo("is_theme_available", JsonBool{object.is_theme_available_});
  jo("used_theme_chat_id", object.used_theme_chat_id_);
  if (object.host_id_) {
    jo("host_id", ToJson(*object.host_id_));
  }
  if (object.owner_id_) {
    jo("owner_id", ToJson(*object.owner_id_));
  }
  jo("owner_address", object.owner_address_);
  jo("owner_name", object.owner_name_);
  jo("gift_address", object.gift_address_);
  if (object.model_) {
    jo("model", ToJson(*object.model_));
  }
  if (object.symbol_) {
    jo("symbol", ToJson(*object.symbol_));
  }
  if (object.backdrop_) {
    jo("backdrop", ToJson(*object.backdrop_));
  }
  if (object.original_details_) {
    jo("original_details", ToJson(*object.original_details_));
  }
  if (object.colors_) {
    jo("colors", ToJson(*object.colors_));
  }
  if (object.resale_parameters_) {
    jo("resale_parameters", ToJson(*object.resale_parameters_));
  }
  jo("can_send_purchase_offer", JsonBool{object.can_send_purchase_offer_});
  jo("value_currency", object.value_currency_);
  jo("value_amount", object.value_amount_);
  jo("value_usd_amount", object.value_usd_amount_);
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftSymbol &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftSymbol");
  jo("name", object.name_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  jo("rarity_per_mille", object.rarity_per_mille_);
}

void to_json(JsonValueScope &jv, const td_api::userPrivacySettingRules &object) {
  auto jo = jv.enter_object();
  jo("@type", "userPrivacySettingRules");
  jo("rules", ToJson(object.rules_));
}

void to_json(JsonValueScope &jv, const td_api::venue &object) {
  auto jo = jv.enter_object();
  jo("@type", "venue");
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  jo("title", object.title_);
  jo("address", object.address_);
  jo("provider", object.provider_);
  jo("id", object.id_);
  jo("type", object.type_);
}

void to_json(JsonValueScope &jv, const td_api::webApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "webApp");
  jo("short_name", object.short_name_);
  jo("title", object.title_);
  jo("description", object.description_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

}  // namespace td_api
}  // namespace td
