#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::BusinessFeature *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"businessFeatureLocation", -1064304004},
    {"businessFeatureOpeningHours", 461054701},
    {"businessFeatureQuickReplies", -1674048894},
    {"businessFeatureGreetingMessage", 1789424756},
    {"businessFeatureAwayMessage", 1090119901},
    {"businessFeatureAccountLinks", 1878693646},
    {"businessFeatureStartPage", 401471457},
    {"businessFeatureBots", 275084773},
    {"businessFeatureEmojiStatus", -846282523},
    {"businessFeatureChatFolderTags", -543880918},
    {"businessFeatureUpgradedStories", -1812245550}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::CollectibleItemType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"collectibleItemTypeUsername", 458680273},
    {"collectibleItemTypePhoneNumber", 1256251714}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::GroupCallDataChannel *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"groupCallDataChannelMain", -32177779},
    {"groupCallDataChannelScreenSharing", -601649103}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputGroupCall *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputGroupCallLink", -812157480},
    {"inputGroupCallMessage", -341793768}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputStoryContent *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputStoryContentPhoto", -309196727},
    {"inputStoryContentVideo", 3809243}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::MessageSender *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"messageSenderUser", -336109341},
    {"messageSenderChat", -239660751}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PhoneNumberCodeType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"phoneNumberCodeTypeChange", 87144986},
    {"phoneNumberCodeTypeVerify", -1029402661},
    {"phoneNumberCodeTypeConfirmOwnership", -485404696}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ReactionNotificationSource *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"reactionNotificationSourceNone", 366374940},
    {"reactionNotificationSourceContacts", 555501621},
    {"reactionNotificationSourceAll", 1241689234}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::StorePaymentPurpose *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"storePaymentPurposePremiumSubscription", 1263894804},
    {"storePaymentPurposePremiumGift", -39502443},
    {"storePaymentPurposePremiumGiftCodes", -1072286736},
    {"storePaymentPurposePremiumGiveaway", 1302624938},
    {"storePaymentPurposeStarGiveaway", 211212441},
    {"storePaymentPurposeStars", 410189263},
    {"storePaymentPurposeGiftedStars", 893691428}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::TextEntityType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"textEntityTypeMention", 934535013},
    {"textEntityTypeHashtag", -1023958307},
    {"textEntityTypeCashtag", 1222915915},
    {"textEntityTypeBotCommand", -1150997581},
    {"textEntityTypeUrl", -1312762756},
    {"textEntityTypeEmailAddress", 1425545249},
    {"textEntityTypePhoneNumber", -1160140246},
    {"textEntityTypeBankCardNumber", 105986320},
    {"textEntityTypeBold", -1128210000},
    {"textEntityTypeItalic", -118253987},
    {"textEntityTypeUnderline", 792317842},
    {"textEntityTypeStrikethrough", 961529082},
    {"textEntityTypeSpoiler", 544019899},
    {"textEntityTypeCode", -974534326},
    {"textEntityTypePre", 1648958606},
    {"textEntityTypePreCode", -945325397},
    {"textEntityTypeBlockQuote", -1003999032},
    {"textEntityTypeExpandableBlockQuote", 36572261},
    {"textEntityTypeTextUrl", 445719651},
    {"textEntityTypeMentionName", -1570974289},
    {"textEntityTypeCustomEmoji", 1724820677},
    {"textEntityTypeMediaTimestamp", -1841898992}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::Object *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"acceptedGiftTypes", 1288451078},
    {"accountTtl", 1324495492},
    {"address", -2043654342},
    {"affiliateProgramParameters", 1642662996},
    {"affiliateProgramSortOrderProfitability", -1963282585},
    {"affiliateProgramSortOrderCreationDate", -1558628083},
    {"affiliateProgramSortOrderRevenue", 1923269304},
    {"affiliateTypeCurrentUser", 1453785589},
    {"affiliateTypeBot", -1032587200},
    {"affiliateTypeChannel", -683939735},
    {"archiveChatListSettings", 1058499236},
    {"autoDownloadSettings", 991433696},
    {"autosaveSettingsScopePrivateChats", 1395227007},
    {"autosaveSettingsScopeGroupChats", 853544526},
    {"autosaveSettingsScopeChannelChats", -499572783},
    {"autosaveSettingsScopeChat", -1632255255},
    {"backgroundFillSolid", 1010678813},
    {"backgroundFillGradient", -1839206017},
    {"backgroundFillFreeformGradient", -1145469255},
    {"backgroundTypeWallpaper", 1972128891},
    {"backgroundTypePattern", 1290213117},
    {"backgroundTypeFill", 993008684},
    {"backgroundTypeChatTheme", 1299879762},
    {"birthdate", 1644064030},
    {"blockListMain", 1352930172},
    {"blockListStories", 103323228},
    {"botCommand", -1032140601},
    {"botCommandScopeDefault", 795652779},
    {"botCommandScopeAllPrivateChats", -344889543},
    {"botCommandScopeAllGroupChats", -981088162},
    {"botCommandScopeAllChatAdministrators", 1998329169},
    {"botCommandScopeChat", -430234971},
    {"botCommandScopeChatAdministrators", 1119682126},
    {"botCommandScopeChatMember", -211380494},
    {"botMenuButton", -944407322},
    {"businessAwayMessageScheduleAlways", -910564679},
    {"businessAwayMessageScheduleOutsideOfOpeningHours", -968630506},
    {"businessAwayMessageScheduleCustom", -1967108654},
    {"businessAwayMessageSettings", 353084137},
    {"businessBotRights", 1224839038},
    {"businessConnectedBot", -1815439021},
    {"businessFeatureLocation", -1064304004},
    {"businessFeatureOpeningHours", 461054701},
    {"businessFeatureQuickReplies", -1674048894},
    {"businessFeatureGreetingMessage", 1789424756},
    {"businessFeatureAwayMessage", 1090119901},
    {"businessFeatureAccountLinks", 1878693646},
    {"businessFeatureStartPage", 401471457},
    {"businessFeatureBots", 275084773},
    {"businessFeatureEmojiStatus", -846282523},
    {"businessFeatureChatFolderTags", -543880918},
    {"businessFeatureUpgradedStories", -1812245550},
    {"businessGreetingMessageSettings", 1689140754},
    {"businessLocation", -1084969126},
    {"businessOpeningHours", 816603700},
    {"businessOpeningHoursInterval", -1108322732},
    {"businessRecipients", 868656909},
    {"callProblemEcho", 801116548},
    {"callProblemNoise", 1053065359},
    {"callProblemInterruptions", 1119493218},
    {"callProblemDistortedSpeech", 379960581},
    {"callProblemSilentLocal", 253652790},
    {"callProblemSilentRemote", 573634714},
    {"callProblemDropped", -1207311487},
    {"callProblemDistortedVideo", 385245706},
    {"callProblemPixelatedVideo", 2115315411},
    {"callProtocol", -1075562897},
    {"callbackQueryPayloadData", -1977729946},
    {"callbackQueryPayloadDataWithPassword", 1340266738},
    {"callbackQueryPayloadGame", 1303571512},
    {"chatActionTyping", 380122167},
    {"chatActionRecordingVideo", 216553362},
    {"chatActionUploadingVideo", 1234185270},
    {"chatActionRecordingVoiceNote", -808850058},
    {"chatActionUploadingVoiceNote", -613643666},
    {"chatActionUploadingPhoto", 654240583},
    {"chatActionUploadingDocument", 167884362},
    {"chatActionChoosingSticker", 372753697},
    {"chatActionChoosingLocation", -2017893596},
    {"chatActionChoosingContact", -1222507496},
    {"chatActionStartPlayingGame", -865884164},
    {"chatActionRecordingVideoNote", 16523393},
    {"chatActionUploadingVideoNote", 1172364918},
    {"chatActionWatchingAnimations", 2052990641},
    {"chatActionCancel", 1160523958},
    {"chatAdministratorRights", -1142880374},
    {"chatAvailableReactionsAll", 694160279},
    {"chatAvailableReactionsSome", 152513153},
    {"chatEventLogFilters", -1032965711},
    {"chatFolder", 1596164696},
    {"chatFolderIcon", -146104090},
    {"chatFolderName", -330482274},
    {"chatInviteLinkMember", 29156795},
    {"chatJoinRequest", 59341416},
    {"chatListMain", -400991316},
    {"chatListArchive", 362770115},
    {"chatListFolder", 385760856},
    {"chatLocation", -1566863583},
    {"chatMemberStatusCreator", -160019714},
    {"chatMemberStatusAdministrator", -70024163},
    {"chatMemberStatusMember", -32707562},
    {"chatMemberStatusRestricted", 1661432998},
    {"chatMemberStatusLeft", -5815259},
    {"chatMemberStatusBanned", -1653518666},
    {"chatMembersFilterContacts", 1774485671},
    {"chatMembersFilterAdministrators", -1266893796},
    {"chatMembersFilterMembers", 670504342},
    {"chatMembersFilterMention", 1932296772},
    {"chatMembersFilterRestricted", 1256282813},
    {"chatMembersFilterBanned", -1863102648},
    {"chatMembersFilterBots", -1422567288},
    {"chatNotificationSettings", 1459533846},
    {"chatPermissions", -118334855},
    {"chatPhotoSticker", -1459387485},
    {"chatPhotoStickerTypeRegularOrMask", -415147620},
    {"chatPhotoStickerTypeCustomEmoji", -266224943},
    {"collectibleItemTypeUsername", 458680273},
    {"collectibleItemTypePhoneNumber", 1256251714},
    {"contact", -1993844876},
    {"date", -277956960},
    {"deviceTokenFirebaseCloudMessaging", -797881849},
    {"deviceTokenApplePush", 387541955},
    {"deviceTokenApplePushVoIP", 804275689},
    {"deviceTokenWindowsPush", -1410514289},
    {"deviceTokenMicrosoftPush", 1224269900},
    {"deviceTokenMicrosoftPushVoIP", -785603759},
    {"deviceTokenWebPush", -1694507273},
    {"deviceTokenSimplePush", 49584736},
    {"deviceTokenUbuntuPush", 1782320422},
    {"deviceTokenBlackBerryPush", 1559167234},
    {"deviceTokenTizenPush", -1359947213},
    {"deviceTokenHuaweiPush", 1989103142},
    {"draftMessage", -1165040650},
    {"emailAddressAuthenticationCode", -993257022},
    {"emailAddressAuthenticationAppleId", 633948265},
    {"emailAddressAuthenticationGoogleId", -19142846},
    {"emojiCategoryTypeDefault", 1188782699},
    {"emojiCategoryTypeRegularStickers", -1337484846},
    {"emojiCategoryTypeEmojiStatus", 1381282631},
    {"emojiCategoryTypeChatPhoto", 1059063081},
    {"emojiStatus", 973424912},
    {"emojiStatusTypeCustomEmoji", -1666780939},
    {"emojiStatusTypeUpgradedGift", -837921804},
    {"error", -1679978726},
    {"fileTypeNone", 2003009189},
    {"fileTypeAnimation", -290816582},
    {"fileTypeAudio", -709112160},
    {"fileTypeDocument", -564722929},
    {"fileTypeNotificationSound", -1020289271},
    {"fileTypePhoto", -1718914651},
    {"fileTypePhotoStory", 2018995956},
    {"fileTypeProfilePhoto", 1795089315},
    {"fileTypeSecret", -1871899401},
    {"fileTypeSecretThumbnail", -1401326026},
    {"fileTypeSecure", -1419133146},
    {"fileTypeSelfDestructingPhoto", 2077176475},
    {"fileTypeSelfDestructingVideo", -1223900123},
    {"fileTypeSelfDestructingVideoNote", 1495274177},
    {"fileTypeSelfDestructingVoiceNote", 1691409181},
    {"fileTypeSticker", 475233385},
    {"fileTypeThumbnail", -12443298},
    {"fileTypeUnknown", -2011566768},
    {"fileTypeVideo", 1430816539},
    {"fileTypeVideoNote", -518412385},
    {"fileTypeVideoStory", -2146754143},
    {"fileTypeVoiceNote", -588681661},
    {"fileTypeWallpaper", 1854930076},
    {"firebaseAuthenticationSettingsAndroid", -1771112932},
    {"firebaseAuthenticationSettingsIos", 222930116},
    {"formattedText", -252624564},
    {"forumTopicIcon", -818765421},
    {"giftForResaleOrderPrice", 1371740258},
    {"giftForResaleOrderPriceChangeDate", -1694144054},
    {"giftForResaleOrderNumber", -1301157632},
    {"giftResalePriceStar", 1184402054},
    {"giftResalePriceTon", -415435950},
    {"giftSettings", 45783168},
    {"giveawayParameters", 1171549354},
    {"groupCallDataChannelMain", -32177779},
    {"groupCallDataChannelScreenSharing", -601649103},
    {"groupCallJoinParameters", 1763438054},
    {"groupCallVideoQualityThumbnail", -379186304},
    {"groupCallVideoQualityMedium", 394968234},
    {"groupCallVideoQualityFull", -2125916617},
    {"importedContact", 1818209156},
    {"inlineKeyboardButton", -372105704},
    {"inlineKeyboardButtonTypeUrl", 1130741420},
    {"inlineKeyboardButtonTypeLoginUrl", -1203413081},
    {"inlineKeyboardButtonTypeWebApp", -1767471672},
    {"inlineKeyboardButtonTypeCallback", -1127515139},
    {"inlineKeyboardButtonTypeCallbackWithPassword", 908018248},
    {"inlineKeyboardButtonTypeCallbackGame", -383429528},
    {"inlineKeyboardButtonTypeSwitchInline", 544906485},
    {"inlineKeyboardButtonTypeBuy", 1360739440},
    {"inlineKeyboardButtonTypeUser", 1836574114},
    {"inlineKeyboardButtonTypeCopyText", 68883206},
    {"inlineQueryResultsButton", -790689618},
    {"inlineQueryResultsButtonTypeStartBot", -23400235},
    {"inlineQueryResultsButtonTypeWebApp", -1197382814},
    {"inputBackgroundLocal", -1747094364},
    {"inputBackgroundRemote", -274976231},
    {"inputBackgroundPrevious", -351905954},
    {"inputBusinessChatLink", 237858296},
    {"inputBusinessStartPage", -327383072},
    {"inputChatPhotoPrevious", 23128529},
    {"inputChatPhotoStatic", 1979179699},
    {"inputChatPhotoAnimation", 90846242},
    {"inputChatPhotoSticker", 1315861341},
    {"inputChatThemeEmoji", -1461787199},
    {"inputChatThemeGift", 2026976301},
    {"inputChecklist", -145125739},
    {"inputChecklistTask", 1633462225},
    {"inputCredentialsSaved", -2034385364},
    {"inputCredentialsNew", -829689558},
    {"inputCredentialsApplePay", -1246570799},
    {"inputCredentialsGooglePay", 844384100},
    {"inputFileId", 1788906253},
    {"inputFileRemote", -107574466},
    {"inputFileLocal", 2056030919},
    {"inputFileGenerated", -1333385216},
    {"inputGroupCallLink", -812157480},
    {"inputGroupCallMessage", -341793768},
    {"inputIdentityDocument", 767353688},
    {"inputInlineQueryResultAnimation", -1489808874},
    {"inputInlineQueryResultArticle", 1983218620},
    {"inputInlineQueryResultAudio", 1260139988},
    {"inputInlineQueryResultContact", 1846064594},
    {"inputInlineQueryResultDocument", 578801869},
    {"inputInlineQueryResultGame", 966074327},
    {"inputInlineQueryResultLocation", -1887650218},
    {"inputInlineQueryResultPhoto", -1123338721},
    {"inputInlineQueryResultSticker", 274007129},
    {"inputInlineQueryResultVenue", 541704509},
    {"inputInlineQueryResultVideo", 1724073191},
    {"inputInlineQueryResultVoiceNote", -1790072503},
    {"inputInvoiceMessage", 1490872848},
    {"inputInvoiceName", -1312155917},
    {"inputInvoiceTelegram", -1762853139},
    {"inputMessageText", -212805484},
    {"inputMessageAnimation", -210404059},
    {"inputMessageAudio", -626786126},
    {"inputMessageDocument", 1633383097},
    {"inputMessagePaidMedia", -1274819374},
    {"inputMessagePhoto", -810129442},
    {"inputMessageSticker", 1072805625},
    {"inputMessageVideo", -605958271},
    {"inputMessageVideoNote", -714598691},
    {"inputMessageVoiceNote", 1461977004},
    {"inputMessageLocation", 648735088},
    {"inputMessageVenue", 1447926269},
    {"inputMessageContact", -982446849},
    {"inputMessageDice", 841574313},
    {"inputMessageGame", 1252944610},
    {"inputMessageInvoice", -1162047631},
    {"inputMessagePoll", -263337164},
    {"inputMessageStakeDice", 1946603673},
    {"inputMessageStory", -370732053},
    {"inputMessageChecklist", -1722965261},
    {"inputMessageForwarded", -1076506316},
    {"inputMessageReplyToMessage", -782038760},
    {"inputMessageReplyToExternalMessage", -505276703},
    {"inputMessageReplyToStory", -1723842320},
    {"inputPaidMedia", 475844035},
    {"inputPaidMediaTypePhoto", -761660134},
    {"inputPaidMediaTypeVideo", 1793741625},
    {"inputPassportElementPersonalDetails", 164791359},
    {"inputPassportElementPassport", -497011356},
    {"inputPassportElementDriverLicense", 304813264},
    {"inputPassportElementIdentityCard", -9963390},
    {"inputPassportElementInternalPassport", 715360043},
    {"inputPassportElementAddress", 461630480},
    {"inputPassportElementUtilityBill", 1389203841},
    {"inputPassportElementBankStatement", -26585208},
    {"inputPassportElementRentalAgreement", 1736154155},
    {"inputPassportElementPassportRegistration", 1314562128},
    {"inputPassportElementTemporaryRegistration", -1913238047},
    {"inputPassportElementPhoneNumber", 1319357497},
    {"inputPassportElementEmailAddress", -248605659},
    {"inputPassportElementError", 285756898},
    {"inputPassportElementErrorSourceUnspecified", 267230319},
    {"inputPassportElementErrorSourceDataField", -426795002},
    {"inputPassportElementErrorSourceFrontSide", 588023741},
    {"inputPassportElementErrorSourceReverseSide", 413072891},
    {"inputPassportElementErrorSourceSelfie", -773575528},
    {"inputPassportElementErrorSourceTranslationFile", 505842299},
    {"inputPassportElementErrorSourceTranslationFiles", -527254048},
    {"inputPassportElementErrorSourceFile", -298492469},
    {"inputPassportElementErrorSourceFiles", -2008541640},
    {"inputPersonalDocument", 1676966826},
    {"inputSticker", 1589392402},
    {"inputStoryArea", 122859135},
    {"inputStoryAreaTypeLocation", -1433714887},
    {"inputStoryAreaTypeFoundVenue", -1395809130},
    {"inputStoryAreaTypePreviousVenue", 1846693388},
    {"inputStoryAreaTypeSuggestedReaction", 2101826003},
    {"inputStoryAreaTypeMessage", -266607529},
    {"inputStoryAreaTypeLink", 1408441160},
    {"inputStoryAreaTypeWeather", -1212686691},
    {"inputStoryAreaTypeUpgradedGift", 793059694},
    {"inputStoryAreas", -883247088},
    {"inputStoryContentPhoto", -309196727},
    {"inputStoryContentVideo", 3809243},
    {"inputSuggestedPostInfo", -1246794382},
    {"inputTextQuote", -1219859172},
    {"inputThumbnail", 1582387236},
    {"internalLinkTypeActiveSessions", 1886108589},
    {"internalLinkTypeAttachmentMenuBot", 1682719269},
    {"internalLinkTypeAuthenticationCode", -209235982},
    {"internalLinkTypeBackground", 185411848},
    {"internalLinkTypeBotAddToChannel", 1401602752},
    {"internalLinkTypeBotStart", 1066950637},
    {"internalLinkTypeBotStartInGroup", -905081650},
    {"internalLinkTypeBusinessChat", -1606751785},
    {"internalLinkTypeBuyStars", -1454587065},
    {"internalLinkTypeChangePhoneNumber", -265856255},
    {"internalLinkTypeChatAffiliateProgram", 632049700},
    {"internalLinkTypeChatBoost", -716571328},
    {"internalLinkTypeChatFolderInvite", -1984804546},
    {"internalLinkTypeChatFolderSettings", -1073805988},
    {"internalLinkTypeChatInvite", 428621017},
    {"internalLinkTypeDefaultMessageAutoDeleteTimerSettings", 732625201},
    {"internalLinkTypeDirectMessagesChat", 1795016752},
    {"internalLinkTypeEditProfileSettings", -1022472090},
    {"internalLinkTypeGame", -260788787},
    {"internalLinkTypeGiftAuction", 1724902818},
    {"internalLinkTypeGiftCollection", -812480347},
    {"internalLinkTypeGroupCall", 1953084438},
    {"internalLinkTypeInstantView", 1776607039},
    {"internalLinkTypeInvoice", -213094996},
    {"internalLinkTypeLanguagePack", -1450766996},
    {"internalLinkTypeLanguageSettings", -1340479770},
    {"internalLinkTypeLiveStory", 665614717},
    {"internalLinkTypeLoginEmailSettings", 1741252808},
    {"internalLinkTypeMainWebApp", 1574925033},
    {"internalLinkTypeMessage", 978541650},
    {"internalLinkTypeMessageDraft", 661633749},
    {"internalLinkTypeMyStars", 1613887070},
    {"internalLinkTypeMyToncoins", -1861488996},
    {"internalLinkTypePassportDataRequest", -988819839},
    {"internalLinkTypePasswordSettings", -1776927773},
    {"internalLinkTypePhoneNumberConfirmation", 1757375254},
    {"internalLinkTypePhoneNumberPrivacySettings", -765272859},
    {"internalLinkTypePremiumFeatures", 1216892745},
    {"internalLinkTypePremiumGift", 1523936577},
    {"internalLinkTypePremiumGiftCode", -564356974},
    {"internalLinkTypePrivacyAndSecuritySettings", -1386255665},
    {"internalLinkTypeProxy", -1313788694},
    {"internalLinkTypePublicChat", 1769614592},
    {"internalLinkTypeQrCodeAuthentication", -1089332956},
    {"internalLinkTypeRestorePurchases", 606090371},
    {"internalLinkTypeSettings", 393561524},
    {"internalLinkTypeStickerSet", -1589227614},
    {"internalLinkTypeStory", 1852042869},
    {"internalLinkTypeStoryAlbum", -332692184},
    {"internalLinkTypeTheme", -200935417},
    {"internalLinkTypeThemeSettings", -1051903722},
    {"internalLinkTypeUnknownDeepLink", 625596379},
    {"internalLinkTypeUnsupportedProxy", -566649079},
    {"internalLinkTypeUpgradedGift", -708405605},
    {"internalLinkTypeUserPhoneNumber", 273398536},
    {"internalLinkTypeUserToken", -1462248615},
    {"internalLinkTypeVideoChat", -2020149068},
    {"internalLinkTypeWebApp", 2062112045},
    {"invoice", 113204876},
    {"jsonObjectMember", -1803309418},
    {"jsonValueNull", -92872499},
    {"jsonValueBoolean", -2142186576},
    {"jsonValueNumber", -1010822033},
    {"jsonValueString", 1597947313},
    {"jsonValueArray", -183913546},
    {"jsonValueObject", 520252026},
    {"keyboardButton", -2069836172},
    {"keyboardButtonTypeText", -1773037256},
    {"keyboardButtonTypeRequestPhoneNumber", -1529235527},
    {"keyboardButtonTypeRequestLocation", -125661955},
    {"keyboardButtonTypeRequestPoll", 1902435512},
    {"keyboardButtonTypeRequestUsers", -1738765315},
    {"keyboardButtonTypeRequestChat", 1511138485},
    {"keyboardButtonTypeWebApp", 1892220770},
    {"labeledPricePart", 552789798},
    {"languagePackInfo", 542199642},
    {"languagePackString", 1307632736},
    {"languagePackStringValueOrdinary", -249256352},
    {"languagePackStringValuePluralized", 1906840261},
    {"languagePackStringValueDeleted", 1834792698},
    {"linkPreviewOptions", 1046590451},
    {"location", -443392141},
    {"locationAddress", -1545940190},
    {"logStreamDefault", 1390581436},
    {"logStreamFile", 1532136933},
    {"logStreamEmpty", -499912244},
    {"maskPointForehead", 1027512005},
    {"maskPointEyes", 1748310861},
    {"maskPointMouth", 411773406},
    {"maskPointChin", 534995335},
    {"maskPosition", -2097433026},
    {"messageAutoDeleteTime", 1972045589},
    {"messageCopyOptions", 1079772090},
    {"messageSchedulingStateSendAtDate", 1505903015},
    {"messageSchedulingStateSendWhenOnline", 2092947464},
    {"messageSchedulingStateSendWhenVideoProcessed", 2101578734},
    {"messageSelfDestructTypeTimer", 1351440333},
    {"messageSelfDestructTypeImmediately", -1036218363},
    {"messageSendOptions", -1725581906},
    {"messageSenderUser", -336109341},
    {"messageSenderChat", -239660751},
    {"messageSourceChatHistory", -1090386116},
    {"messageSourceMessageThreadHistory", 290427142},
    {"messageSourceForumTopicHistory", -1518064457},
    {"messageSourceDirectMessagesChatTopicHistory", 1869256503},
    {"messageSourceHistoryPreview", 1024254993},
    {"messageSourceChatList", -2047406102},
    {"messageSourceSearch", 1921333105},
    {"messageSourceChatEventLog", -1028777540},
    {"messageSourceNotification", -1046406163},
    {"messageSourceScreenshot", 469982474},
    {"messageSourceOther", 901818114},
    {"messageTopicThread", 1360920071},
    {"messageTopicForum", 2119440112},
    {"messageTopicDirectMessages", -1285378599},
    {"messageTopicSavedMessages", 588026991},
    {"networkStatisticsEntryFile", 188452706},
    {"networkStatisticsEntryCall", 737000365},
    {"networkTypeNone", -1971691759},
    {"networkTypeMobile", 819228239},
    {"networkTypeMobileRoaming", -1435199760},
    {"networkTypeWiFi", -633872070},
    {"networkTypeOther", 1942128539},
    {"newChatPrivacySettings", 123716192},
    {"notificationSettingsScopePrivateChats", 937446759},
    {"notificationSettingsScopeGroupChats", 1212142067},
    {"notificationSettingsScopeChannelChats", 548013448},
    {"optionValueBoolean", 63135518},
    {"optionValueEmpty", 918955155},
    {"optionValueInteger", -186858780},
    {"optionValueString", 756248212},
    {"orderInfo", 783997294},
    {"paidReactionTypeRegular", -1199187333},
    {"paidReactionTypeAnonymous", 47892621},
    {"paidReactionTypeChat", -675782044},
    {"passportElementTypePersonalDetails", -1032136365},
    {"passportElementTypePassport", -436360376},
    {"passportElementTypeDriverLicense", 1827298379},
    {"passportElementTypeIdentityCard", -502356132},
    {"passportElementTypeInternalPassport", -793781959},
    {"passportElementTypeAddress", 496327874},
    {"passportElementTypeUtilityBill", 627084906},
    {"passportElementTypeBankStatement", 574095667},
    {"passportElementTypeRentalAgreement", -2060583280},
    {"passportElementTypePassportRegistration", -159478209},
    {"passportElementTypeTemporaryRegistration", 1092498527},
    {"passportElementTypePhoneNumber", -995361172},
    {"passportElementTypeEmailAddress", -79321405},
    {"personalDetails", -1061656137},
    {"phoneNumberAuthenticationSettings", 1881885547},
    {"phoneNumberCodeTypeChange", 87144986},
    {"phoneNumberCodeTypeVerify", -1029402661},
    {"phoneNumberCodeTypeConfirmOwnership", -485404696},
    {"pollTypeRegular", 641265698},
    {"pollTypeQuiz", 657013913},
    {"premiumFeatureIncreasedLimits", 1785455031},
    {"premiumFeatureIncreasedUploadFileSize", 1825367155},
    {"premiumFeatureImprovedDownloadSpeed", -267695554},
    {"premiumFeatureVoiceRecognition", 1288216542},
    {"premiumFeatureDisabledAds", -2008587702},
    {"premiumFeatureUniqueReactions", 766750743},
    {"premiumFeatureUniqueStickers", -2101773312},
    {"premiumFeatureCustomEmoji", 1332599628},
    {"premiumFeatureAdvancedChatManagement", 796347674},
    {"premiumFeatureProfileBadge", 233648322},
    {"premiumFeatureEmojiStatus", -36516639},
    {"premiumFeatureAnimatedProfilePhoto", -100741914},
    {"premiumFeatureForumTopicIcon", -823172286},
    {"premiumFeatureAppIcons", 1585050761},
    {"premiumFeatureRealTimeChatTranslation", -1143471488},
    {"premiumFeatureUpgradedStories", -1878522597},
    {"premiumFeatureChatBoost", 1576574747},
    {"premiumFeatureAccentColor", 907724190},
    {"premiumFeatureBackgroundForBoth", 575074042},
    {"premiumFeatureSavedMessagesTags", 1003219334},
    {"premiumFeatureMessagePrivacy", 802322678},
    {"premiumFeatureLastSeenTimes", -762230129},
    {"premiumFeatureBusiness", -1503619324},
    {"premiumFeatureMessageEffects", -723300255},
    {"premiumFeatureChecklists", -1128709251},
    {"premiumFeaturePaidMessages", -2063708431},
    {"premiumLimitTypeSupergroupCount", -247467131},
    {"premiumLimitTypePinnedChatCount", -998947871},
    {"premiumLimitTypeCreatedPublicChatCount", 446086841},
    {"premiumLimitTypeSavedAnimationCount", -19759735},
    {"premiumLimitTypeFavoriteStickerCount", 639754787},
    {"premiumLimitTypeChatFolderCount", 377489774},
    {"premiumLimitTypeChatFolderChosenChatCount", 1691435861},
    {"premiumLimitTypePinnedArchivedChatCount", 1485515276},
    {"premiumLimitTypePinnedSavedMessagesTopicCount", -1544854305},
    {"premiumLimitTypeCaptionLength", 293984314},
    {"premiumLimitTypeBioLength", -1146976765},
    {"premiumLimitTypeChatFolderInviteLinkCount", -128702950},
    {"premiumLimitTypeShareableChatFolderCount", 1612625095},
    {"premiumLimitTypeActiveStoryCount", -1926486372},
    {"premiumLimitTypeWeeklyPostedStoryCount", -506354313},
    {"premiumLimitTypeMonthlyPostedStoryCount", 26329490},
    {"premiumLimitTypeStoryCaptionLength", -1093324030},
    {"premiumLimitTypeStorySuggestedReactionAreaCount", -1170032633},
    {"premiumLimitTypeSimilarChatCount", -1563549935},
    {"premiumSourceLimitExceeded", -2052159742},
    {"premiumSourceFeature", 445813541},
    {"premiumSourceBusinessFeature", -1492946340},
    {"premiumSourceStoryFeature", -1030737556},
    {"premiumSourceLink", 2135071132},
    {"premiumSourceSettings", -285702859},
    {"premiumStoryFeaturePriorityOrder", -1880001849},
    {"premiumStoryFeatureStealthMode", 1194605988},
    {"premiumStoryFeaturePermanentViewsHistory", -1029683296},
    {"premiumStoryFeatureCustomExpirationDuration", -593229162},
    {"premiumStoryFeatureSaveStories", -1501286467},
    {"premiumStoryFeatureLinksAndFormatting", -622623753},
    {"premiumStoryFeatureVideoQuality", -1162887511},
    {"profileTabPosts", -1181952362},
    {"profileTabGifts", 1296815210},
    {"profileTabMedia", 1925597525},
    {"profileTabFiles", -1422681088},
    {"profileTabLinks", -748329831},
    {"profileTabMusic", -1624780178},
    {"profileTabVoice", -461960914},
    {"profileTabGifs", -1564412267},
    {"proxyTypeSocks5", -890027341},
    {"proxyTypeHttp", -1547188361},
    {"proxyTypeMtproto", -1964826627},
    {"publicChatTypeHasUsername", 350789758},
    {"publicChatTypeIsLocationBased", 1183735952},
    {"reactionNotificationSettings", 733017684},
    {"reactionNotificationSourceNone", 366374940},
    {"reactionNotificationSourceContacts", 555501621},
    {"reactionNotificationSourceAll", 1241689234},
    {"reactionTypeEmoji", -1942084920},
    {"reactionTypeCustomEmoji", -989117709},
    {"reactionTypePaid", 436294381},
    {"readDatePrivacySettings", 1654842920},
    {"replyMarkupRemoveKeyboard", -691252879},
    {"replyMarkupForceReply", 1101461919},
    {"replyMarkupShowKeyboard", -791495984},
    {"replyMarkupInlineKeyboard", -619317658},
    {"reportReasonSpam", -1207032897},
    {"reportReasonViolence", 2038679353},
    {"reportReasonPornography", 1306467575},
    {"reportReasonChildAbuse", 761086718},
    {"reportReasonCopyright", 1474441135},
    {"reportReasonUnrelatedLocation", 87562288},
    {"reportReasonFake", 352862176},
    {"reportReasonIllegalDrugs", -61599200},
    {"reportReasonPersonalDetails", -1588882414},
    {"reportReasonCustom", -1380459917},
    {"resendCodeReasonUserRequest", -441923456},
    {"resendCodeReasonVerificationFailed", 529870273},
    {"scopeAutosaveSettings", 1546821427},
    {"scopeNotificationSettings", 88369150},
    {"searchMessagesChatTypeFilterPrivate", 1169248975},
    {"searchMessagesChatTypeFilterGroup", -2059426022},
    {"searchMessagesChatTypeFilterChannel", -773540139},
    {"searchMessagesFilterEmpty", -869395657},
    {"searchMessagesFilterAnimation", -155713339},
    {"searchMessagesFilterAudio", 867505275},
    {"searchMessagesFilterDocument", 1526331215},
    {"searchMessagesFilterPhoto", 925932293},
    {"searchMessagesFilterVideo", 115538222},
    {"searchMessagesFilterVoiceNote", 1841439357},
    {"searchMessagesFilterPhotoAndVideo", 1352130963},
    {"searchMessagesFilterUrl", -1828724341},
    {"searchMessagesFilterChatPhoto", -1247751329},
    {"searchMessagesFilterVideoNote", 564323321},
    {"searchMessagesFilterVoiceAndVideoNote", 664174819},
    {"searchMessagesFilterMention", 2001258652},
    {"searchMessagesFilterUnreadMention", -95769149},
    {"searchMessagesFilterUnreadReaction", -1379651328},
    {"searchMessagesFilterFailedToSend", -596322564},
    {"searchMessagesFilterPinned", 371805512},
    {"shippingOption", 1425690001},
    {"starSubscriptionPricing", -1767733162},
    {"stickerFormatWebp", -2123043040},
    {"stickerFormatTgs", 1614588662},
    {"stickerFormatWebm", -2070162097},
    {"stickerTypeRegular", 56345973},
    {"stickerTypeMask", -1765394796},
    {"stickerTypeCustomEmoji", -120752249},
    {"storePaymentPurposePremiumSubscription", 1263894804},
    {"storePaymentPurposePremiumGift", -39502443},
    {"storePaymentPurposePremiumGiftCodes", -1072286736},
    {"storePaymentPurposePremiumGiveaway", 1302624938},
    {"storePaymentPurposeStarGiveaway", 211212441},
    {"storePaymentPurposeStars", 410189263},
    {"storePaymentPurposeGiftedStars", 893691428},
    {"storeTransactionAppStore", 1625562441},
    {"storeTransactionGooglePlay", 1094018617},
    {"storyAreaPosition", -1533023124},
    {"storyFullId", 765952419},
    {"storyListMain", -672222209},
    {"storyListArchive", -41900223},
    {"storyPrivacySettingsEveryone", 890847843},
    {"storyPrivacySettingsContacts", 50285309},
    {"storyPrivacySettingsCloseFriends", 2097122144},
    {"storyPrivacySettingsSelectedUsers", -1885772602},
    {"suggestedActionEnableArchiveAndMuteNewChats", 2017586255},
    {"suggestedActionCheckPassword", 1910534839},
    {"suggestedActionCheckPhoneNumber", 648771563},
    {"suggestedActionViewChecksHint", 891303239},
    {"suggestedActionConvertToBroadcastGroup", -965071304},
    {"suggestedActionSetPassword", 1863613848},
    {"suggestedActionUpgradePremium", 1890220539},
    {"suggestedActionRestorePremium", -385229468},
    {"suggestedActionSubscribeToAnnualPremium", 373913787},
    {"suggestedActionGiftPremiumForChristmas", -1816924561},
    {"suggestedActionSetBirthdate", -356672766},
    {"suggestedActionSetProfilePhoto", -1612563093},
    {"suggestedActionExtendPremium", -566207286},
    {"suggestedActionExtendStarSubscriptions", -47000234},
    {"suggestedActionCustom", 2092876611},
    {"suggestedActionSetLoginEmailAddress", 1557625160},
    {"suggestedActionAddLoginPasskey", 1186248690},
    {"suggestedPostPriceStar", 216488903},
    {"suggestedPostPriceTon", -1095222334},
    {"supergroupMembersFilterRecent", 1178199509},
    {"supergroupMembersFilterContacts", -1282910856},
    {"supergroupMembersFilterAdministrators", -2097380265},
    {"supergroupMembersFilterSearch", -1696358469},
    {"supergroupMembersFilterRestricted", -1107800034},
    {"supergroupMembersFilterBanned", -1210621683},
    {"supergroupMembersFilterMention", 1151301973},
    {"supergroupMembersFilterBots", 492138918},
    {"targetChatCurrent", -416689904},
    {"targetChatChosen", -1392978522},
    {"targetChatInternalLink", -579301408},
    {"targetChatTypes", 1513098833},
    {"telegramPaymentPurposePremiumGift", -1600286150},
    {"telegramPaymentPurposePremiumGiftCodes", -1863495348},
    {"telegramPaymentPurposePremiumGiveaway", -760757441},
    {"telegramPaymentPurposeStars", 1204968037},
    {"telegramPaymentPurposeGiftedStars", -1850308042},
    {"telegramPaymentPurposeStarGiveaway", 1014604689},
    {"telegramPaymentPurposeJoinChat", -1914869880},
    {"testInt", -574804983},
    {"testString", -27891572},
    {"textEntity", -1951688280},
    {"textEntityTypeMention", 934535013},
    {"textEntityTypeHashtag", -1023958307},
    {"textEntityTypeCashtag", 1222915915},
    {"textEntityTypeBotCommand", -1150997581},
    {"textEntityTypeUrl", -1312762756},
    {"textEntityTypeEmailAddress", 1425545249},
    {"textEntityTypePhoneNumber", -1160140246},
    {"textEntityTypeBankCardNumber", 105986320},
    {"textEntityTypeBold", -1128210000},
    {"textEntityTypeItalic", -118253987},
    {"textEntityTypeUnderline", 792317842},
    {"textEntityTypeStrikethrough", 961529082},
    {"textEntityTypeSpoiler", 544019899},
    {"textEntityTypeCode", -974534326},
    {"textEntityTypePre", 1648958606},
    {"textEntityTypePreCode", -945325397},
    {"textEntityTypeBlockQuote", -1003999032},
    {"textEntityTypeExpandableBlockQuote", 36572261},
    {"textEntityTypeTextUrl", 445719651},
    {"textEntityTypeMentionName", -1570974289},
    {"textEntityTypeCustomEmoji", 1724820677},
    {"textEntityTypeMediaTimestamp", -1841898992},
    {"textParseModeMarkdown", 360073407},
    {"textParseModeHTML", 1660208627},
    {"themeParameters", -276589137},
    {"topChatCategoryUsers", 1026706816},
    {"topChatCategoryBots", -1577129195},
    {"topChatCategoryGroups", 1530056846},
    {"topChatCategoryChannels", -500825885},
    {"topChatCategoryInlineBots", 377023356},
    {"topChatCategoryWebAppBots", 100062973},
    {"topChatCategoryCalls", 356208861},
    {"topChatCategoryForwardChats", 1695922133},
    {"transactionDirectionIncoming", -271074103},
    {"transactionDirectionOutgoing", 1638241254},
    {"upgradedGiftAttributeIdModel", 1053287307},
    {"upgradedGiftAttributeIdSymbol", 1188205608},
    {"upgradedGiftAttributeIdBackdrop", 1461997935},
    {"upgradedGiftBackdropColors", 4227529},
    {"userPrivacySettingShowStatus", 1862829310},
    {"userPrivacySettingShowProfilePhoto", 1408485877},
    {"userPrivacySettingShowLinkInForwardedMessages", 592688870},
    {"userPrivacySettingShowPhoneNumber", -791567831},
    {"userPrivacySettingShowBio", 959981409},
    {"userPrivacySettingShowBirthdate", 1167504607},
    {"userPrivacySettingShowProfileAudio", 610353549},
    {"userPrivacySettingAllowChatInvites", 1271668007},
    {"userPrivacySettingAllowCalls", -906967291},
    {"userPrivacySettingAllowPeerToPeerCalls", 352500032},
    {"userPrivacySettingAllowFindingByPhoneNumber", -1846645423},
    {"userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages", 338112060},
    {"userPrivacySettingAutosaveGifts", 1889167821},
    {"userPrivacySettingAllowUnpaidMessages", 1430051047},
    {"userPrivacySettingRuleAllowAll", -1967186881},
    {"userPrivacySettingRuleAllowContacts", -1892733680},
    {"userPrivacySettingRuleAllowBots", 1404208925},
    {"userPrivacySettingRuleAllowPremiumUsers", 1624147265},
    {"userPrivacySettingRuleAllowUsers", 1110988334},
    {"userPrivacySettingRuleAllowChatMembers", -2048749863},
    {"userPrivacySettingRuleRestrictAll", -1406495408},
    {"userPrivacySettingRuleRestrictContacts", 1008389378},
    {"userPrivacySettingRuleRestrictBots", -1902547363},
    {"userPrivacySettingRuleRestrictUsers", 622796522},
    {"userPrivacySettingRuleRestrictChatMembers", 392530897},
    {"userPrivacySettingRules", 322477541},
    {"venue", 1070406393},
    {"webAppOpenModeCompact", 1711603675},
    {"webAppOpenModeFullSize", 189320513},
    {"webAppOpenModeFullScreen", 1871315357},
    {"webAppOpenParameters", 1375356527}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::Function *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"acceptCall", -646618416},
    {"acceptTermsOfService", 2130576356},
    {"activateStoryStealthMode", -1009023855},
    {"addBotMediaPreview", 1347126571},
    {"addChatFolderByInviteLink", -858593816},
    {"addChatMember", 1720144407},
    {"addChatMembers", -1675991329},
    {"addChatToList", -80523595},
    {"addChecklistTasks", 1554619499},
    {"addContact", -2098628252},
    {"addCustomServerLanguagePack", 4492771},
    {"addFavoriteSticker", 324504799},
    {"addFileToDownloads", 867533751},
    {"addGiftCollectionGifts", -263464606},
    {"addLocalMessage", -166217823},
    {"addLogMessage", 1597427692},
    {"addLoginPasskey", 1838899694},
    {"addMessageReaction", 1419269613},
    {"addNetworkStatistics", 1264825305},
    {"addOffer", 682451739},
    {"addPendingLiveStoryReaction", 661166197},
    {"addPendingPaidMessageReaction", -342110765},
    {"addProfileAudio", 393218847},
    {"addProxy", 331529432},
    {"addQuickReplyShortcutInlineQueryResultMessage", -2017449468},
    {"addQuickReplyShortcutMessage", 1058573098},
    {"addQuickReplyShortcutMessageAlbum", 1348436244},
    {"addRecentSticker", -1478109026},
    {"addRecentlyFoundChat", -1746396787},
    {"addSavedAnimation", -1538525088},
    {"addSavedNotificationSound", 1043956975},
    {"addStickerToSet", 1457266235},
    {"addStoryAlbumStories", -537692984},
    {"allowBotToSendMessages", 1776928142},
    {"allowUnpaidMessagesFromUser", 803569495},
    {"answerCallbackQuery", -1153028490},
    {"answerCustomQuery", -1293603521},
    {"answerInlineQuery", 1343853844},
    {"answerPreCheckoutQuery", -1486789653},
    {"answerShippingQuery", -434601324},
    {"answerWebAppQuery", -1598776079},
    {"applyPremiumGiftCode", -1347138530},
    {"approveSuggestedPost", -924807202},
    {"assignStoreTransaction", -2046202900},
    {"banChatMember", -888111748},
    {"banGroupCallParticipants", 624883173},
    {"blockMessageSenderFromReplies", -1214384757},
    {"boostChat", 1945750252},
    {"buyGiftUpgrade", 154296026},
    {"canBotSendMessages", 544052364},
    {"canPostStory", 668621518},
    {"canPurchaseFromStore", 1017811816},
    {"canSendGift", 1307059830},
    {"canSendMessageToUser", 1529489462},
    {"canTransferOwnership", 634602508},
    {"cancelDownloadFile", -1954524450},
    {"cancelPasswordReset", 940733538},
    {"cancelPreliminaryUploadFile", 823412414},
    {"cancelRecoveryEmailAddressVerification", -1516728691},
    {"changeImportedContacts", 1119625871},
    {"changeStickerSet", 449357293},
    {"checkAuthenticationBotToken", 639321206},
    {"checkAuthenticationCode", -302103382},
    {"checkAuthenticationEmailCode", -582827361},
    {"checkAuthenticationPasskey", 1225325317},
    {"checkAuthenticationPassword", -2025698400},
    {"checkAuthenticationPasswordRecoveryCode", -603309083},
    {"checkAuthenticationPremiumPurchase", 1588959934},
    {"checkChatFolderInviteLink", 522557851},
    {"checkChatInviteLink", -496940997},
    {"checkChatUsername", -119119344},
    {"checkCreatedPublicChatsLimit", -445546591},
    {"checkEmailAddressVerificationCode", -426386685},
    {"checkLoginEmailAddressCode", -1454244766},
    {"checkPasswordRecoveryCode", -200794600},
    {"checkPhoneNumberCode", -603626079},
    {"checkPremiumGiftCode", -1786063260},
    {"checkQuickReplyShortcutName", 2101203241},
    {"checkRecoveryEmailAddressCode", -1997039589},
    {"checkStickerSetName", -1789392642},
    {"checkWebAppFileDownload", -389397278},
    {"cleanFileName", 967964667},
    {"clearAllDraftMessages", -46369573},
    {"clearAutosaveSettingsExceptions", 1475109874},
    {"clearImportedContacts", 869503298},
    {"clearRecentEmojiStatuses", -428749986},
    {"clearRecentReactions", 1298253650},
    {"clearRecentStickers", -321242684},
    {"clearRecentlyFoundChats", -285582542},
    {"clearSearchedForTags", 512017238},
    {"clickAnimatedEmojiMessage", 196179554},
    {"clickChatSponsoredMessage", 971995671},
    {"clickPremiumSubscriptionButton", -369319162},
    {"clickVideoMessageAdvertisement", 1367156622},
    {"close", -1187782273},
    {"closeChat", 39749353},
    {"closeGiftAuction", 115495644},
    {"closeSecretChat", -471006133},
    {"closeStory", 1553967851},
    {"closeWebApp", 1755391174},
    {"commitPendingLiveStoryReactions", -1786229016},
    {"commitPendingPaidMessageReactions", -171354618},
    {"confirmQrCodeAuthentication", -376199379},
    {"confirmSession", -674647009},
    {"connectAffiliateProgram", 1661392684},
    {"createBasicGroupChat", 1972024548},
    {"createBusinessChatLink", -1861018304},
    {"createCall", -1104663024},
    {"createChatFolder", 1015399680},
    {"createChatFolderInviteLink", -2037911099},
    {"createChatInviteLink", 287744833},
    {"createChatSubscriptionInviteLink", 2255717},
    {"createForumTopic", -15242103},
    {"createGiftCollection", -397088099},
    {"createGroupCall", 1930068672},
    {"createInvoiceLink", -814692249},
    {"createNewBasicGroupChat", 1806454709},
    {"createNewSecretChat", -620682651},
    {"createNewStickerSet", -481065727},
    {"createNewSupergroupChat", 804058822},
    {"createPrivateChat", -947758327},
    {"createSecretChat", 1930285615},
    {"createStoryAlbum", -804362185},
    {"createSupergroupChat", 1187475691},
    {"createTemporaryPassword", -1626509434},
    {"createVideoChat", 2124715405},
    {"declineGroupCallInvitation", 1843919377},
    {"declineSuggestedPost", -1758260609},
    {"decryptGroupCallData", 1781743076},
    {"deleteAccount", 1395816134},
    {"deleteAllCallMessages", -1466445325},
    {"deleteAllRevokedChatInviteLinks", 1112020698},
    {"deleteBotMediaPreviews", -1397512722},
    {"deleteBusinessChatLink", -1101895865},
    {"deleteBusinessConnectedBot", -1633976747},
    {"deleteBusinessMessages", 1425721828},
    {"deleteBusinessStory", 1024585042},
    {"deleteChat", -171253666},
    {"deleteChatBackground", 320267896},
    {"deleteChatFolder", -1956364551},
    {"deleteChatFolderInviteLink", -930057858},
    {"deleteChatHistory", -1472081761},
    {"deleteChatMessagesByDate", -1639653185},
    {"deleteChatMessagesBySender", -1164235161},
    {"deleteChatReplyMarkup", 100637531},
    {"deleteCommands", 1002732586},
    {"deleteDefaultBackground", -1297814210},
    {"deleteDirectMessagesChatTopicHistory", -1906080196},
    {"deleteDirectMessagesChatTopicMessagesByDate", 945080841},
    {"deleteFile", 1807653676},
    {"deleteForumTopic", -2121212039},
    {"deleteGiftCollection", -183749499},
    {"deleteGroupCallMessages", 339562398},
    {"deleteGroupCallMessagesBySender", 1677247618},
    {"deleteLanguagePack", -2108761026},
    {"deleteMessages", 1130090173},
    {"deletePassportElement", -1719555468},
    {"deleteProfilePhoto", 1319794625},
    {"deleteQuickReplyShortcut", -246911978},
    {"deleteQuickReplyShortcutMessages", -40522947},
    {"deleteRevokedChatInviteLink", -1859711873},
    {"deleteSavedCredentials", 826300114},
    {"deleteSavedMessagesTopicHistory", 1776237930},
    {"deleteSavedMessagesTopicMessagesByDate", 1444389},
    {"deleteSavedOrderInfo", 1629058164},
    {"deleteStickerSet", 1577745325},
    {"deleteStory", -2020144472},
    {"deleteStoryAlbum", -658327628},
    {"destroy", 685331274},
    {"disableAllSupergroupUsernames", 843511216},
    {"disableProxy", -2100095102},
    {"discardCall", -1545983346},
    {"disconnectAffiliateProgram", -105831172},
    {"disconnectAllWebsites", -1082985981},
    {"disconnectWebsite", -778767395},
    {"downloadFile", 1059402292},
    {"dropGiftOriginalDetails", -1394445843},
    {"editBotMediaPreview", -2037031582},
    {"editBusinessChatLink", 1594947110},
    {"editBusinessMessageCaption", -1071562045},
    {"editBusinessMessageChecklist", -445013904},
    {"editBusinessMessageLiveLocation", 494972447},
    {"editBusinessMessageMedia", -60733576},
    {"editBusinessMessageReplyMarkup", 701787159},
    {"editBusinessMessageText", -1149169252},
    {"editBusinessStory", 472538940},
    {"editChatFolder", 53672754},
    {"editChatFolderInviteLink", -2141872095},
    {"editChatInviteLink", 1320303996},
    {"editChatSubscriptionInviteLink", -951826989},
    {"editCustomLanguagePackInfo", 1320751257},
    {"editForumTopic", 1112389547},
    {"editInlineMessageCaption", 1409762552},
    {"editInlineMessageLiveLocation", 2134352044},
    {"editInlineMessageMedia", 23553921},
    {"editInlineMessageReplyMarkup", -67565858},
    {"editInlineMessageText", -855457307},
    {"editMessageCaption", -2020117951},
    {"editMessageChecklist", 1497856700},
    {"editMessageLiveLocation", -1890511980},
    {"editMessageMedia", -1152678125},
    {"editMessageReplyMarkup", 332127881},
    {"editMessageSchedulingState", -1372976192},
    {"editMessageText", 196272567},
    {"editProxy", -1605883821},
    {"editQuickReplyMessage", 80517006},
    {"editStarSubscription", 2048538904},
    {"editStory", 355296788},
    {"editStoryCover", -1035823266},
    {"editUserStarSubscription", 1370582665},
    {"enableProxy", 1494450838},
    {"encryptGroupCallData", -377997690},
    {"endGroupCall", 573131959},
    {"endGroupCallRecording", -75799927},
    {"endGroupCallScreenSharing", -2047599540},
    {"finishFileGeneration", -1055060835},
    {"forwardMessages", -247889118},
    {"getAccountTtl", -443905161},
    {"getActiveSessions", 1119710526},
    {"getAllPassportElements", -2038945045},
    {"getAllStickerEmojis", 296562224},
    {"getAnimatedEmoji", 1065635702},
    {"getApplicationConfig", -1823144318},
    {"getApplicationDownloadLink", 112013252},
    {"getArchiveChatListSettings", -2087874976},
    {"getArchivedStickerSets", 1001931341},
    {"getAttachedStickerSets", 1302172429},
    {"getAttachmentMenuBot", 1034248699},
    {"getAuthenticationPasskeyParameters", -686037865},
    {"getAuthorizationState", 1949154877},
    {"getAutoDownloadSettingsPresets", -1721088201},
    {"getAutosaveSettings", 2136207914},
    {"getAvailableChatBoostSlots", 1929898965},
    {"getAvailableGifts", -4559695},
    {"getBackgroundUrl", 733769682},
    {"getBankCardInfo", -1310515792},
    {"getBasicGroup", -1635174828},
    {"getBasicGroupFullInfo", -1822039253},
    {"getBlockedMessageSenders", -1931137258},
    {"getBotInfoDescription", -762841035},
    {"getBotInfoShortDescription", 1243358740},
    {"getBotMediaPreviewInfo", 1358299446},
    {"getBotMediaPreviews", 577131608},
    {"getBotName", -1707118036},
    {"getBotSimilarBotCount", -1271545369},
    {"getBotSimilarBots", -825139275},
    {"getBusinessAccountStarAmount", -1817136693},
    {"getBusinessChatLinkInfo", 797670986},
    {"getBusinessChatLinks", 710287703},
    {"getBusinessConnectedBot", 911058883},
    {"getBusinessConnection", -2114706400},
    {"getBusinessFeatures", -997171199},
    {"getCallbackQueryAnswer", 116357727},
    {"getCallbackQueryMessage", -1121939086},
    {"getChat", 1866601536},
    {"getChatActiveStories", 776993781},
    {"getChatAdministrators", 1544468155},
    {"getChatArchivedStories", -1356950392},
    {"getChatAvailableMessageSenders", 1158670635},
    {"getChatAvailablePaidMessageReactionSenders", -1244619639},
    {"getChatBoostFeatures", -389994336},
    {"getChatBoostLevelFeatures", 1172717195},
    {"getChatBoostLink", 1458662533},
    {"getChatBoostLinkInfo", 654068572},
    {"getChatBoostStatus", -810775857},
    {"getChatBoosts", -1419859400},
    {"getChatEventLog", -1281344669},
    {"getChatFolder", 92809880},
    {"getChatFolderChatCount", 2111097790},
    {"getChatFolderChatsToLeave", -1916672337},
    {"getChatFolderDefaultIconName", 754425959},
    {"getChatFolderInviteLinks", 329079776},
    {"getChatFolderNewChats", 2123181260},
    {"getChatHistory", -799960451},
    {"getChatInviteLink", -479575555},
    {"getChatInviteLinkCounts", 890299025},
    {"getChatInviteLinkMembers", 1728376124},
    {"getChatInviteLinks", 883252396},
    {"getChatJoinRequests", -388428126},
    {"getChatListsToAddChat", 654956193},
    {"getChatMember", -792636814},
    {"getChatMessageByDate", 1062564150},
    {"getChatMessageCalendar", 1644001372},
    {"getChatMessageCount", 1641001101},
    {"getChatMessagePosition", -1468174577},
    {"getChatNotificationSettingsExceptions", 201199121},
    {"getChatPinnedMessage", 359865008},
    {"getChatPostedToChatPageStories", -46414037},
    {"getChatRevenueStatistics", 701995836},
    {"getChatRevenueTransactions", -1120110117},
    {"getChatRevenueWithdrawalUrl", 506595104},
    {"getChatScheduledMessages", -549638149},
    {"getChatSimilarChatCount", 1178506894},
    {"getChatSimilarChats", -1152348285},
    {"getChatSparseMessagePositions", 994389757},
    {"getChatSponsoredMessages", 1353203864},
    {"getChatStatistics", 327057816},
    {"getChatStoryAlbums", -1559582892},
    {"getChatStoryInteractions", 354545268},
    {"getChats", -972768574},
    {"getChatsForChatFolderInviteLink", 1873561929},
    {"getChatsToPostStories", 1893901427},
    {"getCloseFriends", -1445628722},
    {"getCollectibleItemInfo", -217797238},
    {"getCommands", 1488621559},
    {"getConnectedAffiliateProgram", -1755191440},
    {"getConnectedAffiliatePrograms", -1960029582},
    {"getConnectedWebsites", -170536110},
    {"getContacts", -1417722768},
    {"getCountries", -51902050},
    {"getCountryCode", 1540593906},
    {"getCountryFlagEmoji", 981871098},
    {"getCreatedPublicChats", 710354415},
    {"getCurrentState", -1191417719},
    {"getCurrentWeather", -1965384759},
    {"getCustomEmojiReactionAnimations", 1232375250},
    {"getCustomEmojiStickers", -2127427955},
    {"getDatabaseStatistics", -1942760263},
    {"getDeepLinkInfo", 680673150},
    {"getDefaultBackgroundCustomEmojiStickers", 485910542},
    {"getDefaultChatEmojiStatuses", 1553698018},
    {"getDefaultChatPhotoCustomEmojiStickers", -376342683},
    {"getDefaultEmojiStatuses", -539392025},
    {"getDefaultMessageAutoDeleteTime", -450857574},
    {"getDefaultProfilePhotoCustomEmojiStickers", 1280041655},
    {"getDirectMessagesChatTopic", 1990530052},
    {"getDirectMessagesChatTopicHistory", 1035221188},
    {"getDirectMessagesChatTopicMessageByDate", 1837500879},
    {"getDirectMessagesChatTopicRevenue", -792382961},
    {"getDisallowedChatEmojiStatuses", -2004787831},
    {"getEmojiCategories", 2139537774},
    {"getEmojiReaction", -449572388},
    {"getEmojiSuggestionsUrl", -1404101841},
    {"getExternalLink", 1586688235},
    {"getExternalLinkInfo", 1175288383},
    {"getFavoriteStickers", -338964672},
    {"getFile", 1553923406},
    {"getFileDownloadedPrefixSize", 855948589},
    {"getFileExtension", -106055372},
    {"getFileMimeType", -2073879671},
    {"getForumTopic", 1931459984},
    {"getForumTopicDefaultIcons", 1479898332},
    {"getForumTopicHistory", -339129791},
    {"getForumTopicLink", 330405972},
    {"getForumTopics", 1368275676},
    {"getGameHighScores", 15746459},
    {"getGiftAuctionAcquiredGifts", -937975215},
    {"getGiftAuctionState", 989210247},
    {"getGiftChatThemes", -1051327876},
    {"getGiftCollections", -1533138835},
    {"getGiftUpgradePreview", -1110719907},
    {"getGiftUpgradeVariants", 554449726},
    {"getGiveawayInfo", -1215852357},
    {"getGreetingStickers", 374873372},
    {"getGrossingWebAppBots", 1696779802},
    {"getGroupCall", 1468491406},
    {"getGroupCallParticipants", 1986739394},
    {"getGroupCallStreamSegment", -502273424},
    {"getGroupCallStreams", -1619226268},
    {"getGroupsInCommon", 381539178},
    {"getImportedContactCount", -656336346},
    {"getInactiveSupergroupChats", -657720907},
    {"getInlineGameHighScores", -533107798},
    {"getInlineQueryResults", 2044524652},
    {"getInstalledBackgrounds", -1051406241},
    {"getInstalledStickerSets", 1630467830},
    {"getInternalLink", 962654640},
    {"getInternalLinkType", -1948428535},
    {"getJsonString", 663458849},
    {"getJsonValue", -1829086715},
    {"getKeywordEmojis", -1969795990},
    {"getLanguagePackInfo", 2077809320},
    {"getLanguagePackString", 150789747},
    {"getLanguagePackStrings", 1246259088},
    {"getLinkPreview", -1039572191},
    {"getLiveStoryAvailableMessageSenders", 1252390532},
    {"getLiveStoryRtmpUrl", 1267168178},
    {"getLiveStoryStreamer", -718164721},
    {"getLiveStoryTopDonors", -700264064},
    {"getLocalizationTargetInfo", 1849499526},
    {"getLogStream", 1167608667},
    {"getLogTagVerbosityLevel", 951004547},
    {"getLogTags", -254449190},
    {"getLogVerbosityLevel", 594057956},
    {"getLoginPasskeys", -165927873},
    {"getLoginUrl", 791844305},
    {"getLoginUrlInfo", -859202125},
    {"getMainWebApp", 594050214},
    {"getMapThumbnailFile", -152660070},
    {"getMarkdownText", 164524584},
    {"getMe", -191516033},
    {"getMenuButton", -437324736},
    {"getMessage", -1821196160},
    {"getMessageAddedReactions", 2110172754},
    {"getMessageAuthor", 1890166449},
    {"getMessageAvailableReactions", 1994098354},
    {"getMessageEffect", -1638843116},
    {"getMessageEmbeddingCode", 1654967561},
    {"getMessageFileType", -490270764},
    {"getMessageImportConfirmationText", 390627752},
    {"getMessageLink", -984158342},
    {"getMessageLinkInfo", -700533672},
    {"getMessageLocally", -603575444},
    {"getMessageProperties", 773382571},
    {"getMessagePublicForwards", 1369285812},
    {"getMessageReadDate", -1484455101},
    {"getMessageStatistics", 1270194648},
    {"getMessageThread", 2062695998},
    {"getMessageThreadHistory", -1808411608},
    {"getMessageViewers", -1584457010},
    {"getMessages", 425299338},
    {"getNetworkStatistics", -986228706},
    {"getNewChatPrivacySettings", -1295299657},
    {"getOption", -1572495746},
    {"getOwnedBots", -1954035715},
    {"getOwnedStickerSets", 1493074208},
    {"getPaidMessageRevenue", 1976589102},
    {"getPasskeyParameters", -680161058},
    {"getPassportAuthorizationForm", 1636107398},
    {"getPassportAuthorizationFormAvailableElements", 1068700924},
    {"getPassportElement", -1882398342},
    {"getPasswordState", -174752904},
    {"getPaymentForm", -1924172076},
    {"getPaymentReceipt", 1013758294},
    {"getPhoneNumberInfo", -1608344583},
    {"getPhoneNumberInfoSync", 547061048},
    {"getPollVoters", -1000625748},
    {"getPreferredCountryLanguage", -933049386},
    {"getPremiumFeatures", -1260640695},
    {"getPremiumGiftPaymentOptions", -480334244},
    {"getPremiumGiveawayPaymentOptions", 1222168073},
    {"getPremiumInfoSticker", 2043562651},
    {"getPremiumLimit", 1075313898},
    {"getPremiumState", 663632610},
    {"getPremiumStickerExamples", 1399442328},
    {"getPremiumStickers", -280950192},
    {"getPreparedInlineMessage", -83179701},
    {"getProxies", -95026381},
    {"getProxyLink", -1054495112},
    {"getPublicPostSearchLimits", -1724216773},
    {"getPushReceiverId", -286505294},
    {"getReadDatePrivacySettings", 451435451},
    {"getReceivedGift", -446535239},
    {"getReceivedGifts", 1411782110},
    {"getRecentEmojiStatuses", -1371914967},
    {"getRecentInlineBots", 1437823548},
    {"getRecentStickers", -579622241},
    {"getRecentlyOpenedChats", -1924156893},
    {"getRecentlyVisitedTMeUrls", 806754961},
    {"getRecommendedChatFolders", -145540217},
    {"getRecommendedChats", -649884303},
    {"getRecoveryEmailAddress", -1594770947},
    {"getRemoteFile", 2137204530},
    {"getRepliedMessage", -641918531},
    {"getSavedAnimations", 7051032},
    {"getSavedMessagesTags", -1932105815},
    {"getSavedMessagesTopicHistory", 2011552360},
    {"getSavedMessagesTopicMessageByDate", -1050786176},
    {"getSavedNotificationSound", 459569431},
    {"getSavedNotificationSounds", -1070305368},
    {"getSavedOrderInfo", -1152016675},
    {"getScopeNotificationSettings", -995613361},
    {"getSearchSponsoredChats", 1568505164},
    {"getSearchedForTags", -1692716851},
    {"getSecretChat", 40599169},
    {"getStakeDiceState", 1389168065},
    {"getStarAdAccountUrl", 1940473181},
    {"getStarGiftPaymentOptions", -500735773},
    {"getStarGiveawayPaymentOptions", -883172578},
    {"getStarPaymentOptions", 1838351940},
    {"getStarRevenueStatistics", -260356841},
    {"getStarSubscriptions", -641223956},
    {"getStarTransactions", -304141747},
    {"getStarWithdrawalUrl", -1445841134},
    {"getStatisticalGraph", 1100975515},
    {"getStickerEmojis", -1895508665},
    {"getStickerOutline", -1550504539},
    {"getStickerOutlineSvgPath", -1615497803},
    {"getStickerSet", 1052318659},
    {"getStickerSetName", 1039849089},
    {"getStickers", 1158058819},
    {"getStorageStatistics", -853193929},
    {"getStorageStatisticsFast", 61368066},
    {"getStory", -2011076366},
    {"getStoryAlbumStories", 1915090076},
    {"getStoryAvailableReactions", 595938619},
    {"getStoryInteractions", 483475469},
    {"getStoryNotificationSettingsExceptions", 627715760},
    {"getStoryPublicForwards", 1810378546},
    {"getStoryStatistics", 982926146},
    {"getSuggestedFileName", -2049399674},
    {"getSuggestedStickerSetName", -1340995520},
    {"getSuitableDiscussionChats", 49044982},
    {"getSuitablePersonalChats", -1870357515},
    {"getSupergroup", 989663458},
    {"getSupergroupFullInfo", 1099776056},
    {"getSupergroupMembers", -570940984},
    {"getSupportName", 1302205794},
    {"getSupportUser", -1733497700},
    {"getTemporaryPasswordState", -12670830},
    {"getTextEntities", -341490693},
    {"getThemeParametersJsonString", -1850145288},
    {"getThemedChatEmojiStatuses", 1924568314},
    {"getThemedEmojiStatuses", -1468220543},
    {"getTimeZones", 1340268632},
    {"getTonRevenueStatistics", -1315591160},
    {"getTonTransactions", -1935011115},
    {"getTonWithdrawalUrl", -1482519601},
    {"getTopChats", -388410847},
    {"getTrendingStickerSets", -531085986},
    {"getUpgradedGift", -1331821135},
    {"getUpgradedGiftEmojiStatuses", -1748975723},
    {"getUpgradedGiftValueInfo", 1818813417},
    {"getUpgradedGiftWithdrawalUrl", -784331188},
    {"getUpgradedGiftsPromotionalAnimation", 1944094513},
    {"getUser", 1117363211},
    {"getUserChatBoosts", -1190205543},
    {"getUserFullInfo", -776823720},
    {"getUserLink", 1226839270},
    {"getUserPrivacySettingRules", -2077223311},
    {"getUserProfileAudios", -208876086},
    {"getUserProfilePhotos", -908132798},
    {"getUserSupportInfo", 1957008133},
    {"getVideoChatAvailableParticipants", -1000496379},
    {"getVideoChatInviteLink", -1394707321},
    {"getVideoChatRtmpUrl", 1210784543},
    {"getVideoMessageAdvertisements", -285681331},
    {"getWebAppLinkUrl", 1627284161},
    {"getWebAppPlaceholder", 583470479},
    {"getWebAppUrl", -1526784188},
    {"getWebPageInstantView", 1741395197},
    {"giftPremiumWithStars", -2058395432},
    {"hideContactCloseBirthdays", -1163065221},
    {"hideSuggestedAction", -1561384065},
    {"importContacts", -662555959},
    {"importMessages", -1864116784},
    {"increaseGiftAuctionBid", -493509001},
    {"inviteGroupCallParticipant", -631535414},
    {"inviteVideoChatParticipants", -473149298},
    {"isLoginEmailAddressRequired", -874594326},
    {"isProfileAudio", -245729314},
    {"joinChat", 326769313},
    {"joinChatByInviteLink", -1049973882},
    {"joinGroupCall", -2026079917},
    {"joinLiveStory", 227825676},
    {"joinVideoChat", 1322989999},
    {"launchPrepaidGiveaway", 639465530},
    {"leaveChat", -1825080735},
    {"leaveGroupCall", 980152233},
    {"loadActiveStories", 2106390328},
    {"loadChats", -1885635205},
    {"loadDirectMessagesChatTopics", 1488065975},
    {"loadGroupCallParticipants", 938720974},
    {"loadQuickReplyShortcutMessages", -46092588},
    {"loadQuickReplyShortcuts", -1016614243},
    {"loadSavedMessagesTopics", 289855160},
    {"logOut", -1581923301},
    {"markChecklistTasksAsDone", 386950739},
    {"openBotSimilarBot", -369688872},
    {"openChat", -323371509},
    {"openChatSimilarChat", -1884883949},
    {"openGiftAuction", -694137370},
    {"openMessageContent", -739088005},
    {"openSponsoredChat", 865985573},
    {"openStory", -696723005},
    {"openWebApp", -950685122},
    {"optimizeStorage", 853186759},
    {"parseMarkdown", 756366063},
    {"parseTextEntities", -1709194593},
    {"pinChatMessage", 2034719663},
    {"pingProxy", -979681103},
    {"placeGiftAuctionBid", 1437176980},
    {"postStory", -1725643742},
    {"preliminaryUploadFile", 1894239129},
    {"processChatFolderNewChats", 1498280672},
    {"processChatJoinRequest", 1004876963},
    {"processChatJoinRequests", 1048722894},
    {"processGiftPurchaseOffer", -1177407462},
    {"processPushNotification", 786679952},
    {"rateSpeechRecognition", -287521867},
    {"readAllChatMentions", 1357558453},
    {"readAllChatReactions", 1421973357},
    {"readAllDirectMessagesChatTopicReactions", 1154665542},
    {"readAllForumTopicMentions", -996864148},
    {"readAllForumTopicReactions", -1986498949},
    {"readBusinessMessage", -1723531538},
    {"readChatList", -1117480790},
    {"readFilePart", -174576822},
    {"readdQuickReplyShortcutMessages", 387399566},
    {"recognizeSpeech", 1741947577},
    {"recoverAuthenticationPassword", -131001053},
    {"recoverPassword", -1524262541},
    {"refundStarPayment", -1804165035},
    {"registerDevice", 366088823},
    {"registerUser", -1012247828},
    {"removeAllFilesFromDownloads", -1186433402},
    {"removeBusinessConnectedBotFromChat", 2020766707},
    {"removeChatActionBar", -1650968070},
    {"removeContacts", 1943858054},
    {"removeFavoriteSticker", 1152945264},
    {"removeFileFromDownloads", 1460060142},
    {"removeGiftCollectionGifts", -692316949},
    {"removeInstalledBackground", 1346446652},
    {"removeLoginPasskey", -1728940387},
    {"removeMessageReaction", -1756934789},
    {"removeMessageSenderBotVerification", -1710174374},
    {"removeNotification", 862630734},
    {"removeNotificationGroup", 1713005454},
    {"removePendingLiveStoryReactions", 868601112},
    {"removePendingPaidMessageReactions", 1100258555},
    {"removeProfileAudio", 1292263034},
    {"removeProxy", 1369219847},
    {"removeRecentHashtag", -1013735260},
    {"removeRecentSticker", 1246577677},
    {"removeRecentlyFoundChat", 717340444},
    {"removeSavedAnimation", -495605479},
    {"removeSavedNotificationSound", -480032946},
    {"removeSearchedForTag", 891382730},
    {"removeStickerFromSet", 1642196644},
    {"removeStoryAlbumStories", 1901872465},
    {"removeTopChat", -1907876267},
    {"reorderActiveUsernames", -455399375},
    {"reorderBotActiveUsernames", -1602301664},
    {"reorderBotMediaPreviews", 630851043},
    {"reorderChatFolders", 1665299546},
    {"reorderGiftCollectionGifts", -1545340419},
    {"reorderGiftCollections", -1607216912},
    {"reorderInstalledStickerSets", 1074928158},
    {"reorderQuickReplyShortcuts", -2052799232},
    {"reorderStoryAlbumStories", 438104756},
    {"reorderStoryAlbums", 514423948},
    {"reorderSupergroupActiveUsernames", -1962466095},
    {"replaceLiveStoryRtmpUrl", 585361229},
    {"replacePrimaryChatInviteLink", 1067350941},
    {"replaceStickerInSet", -406311399},
    {"replaceVideoChatRtmpUrl", 558862304},
    {"reportAuthenticationCodeMissing", -1846555064},
    {"reportChat", 1058475058},
    {"reportChatPhoto", -646966648},
    {"reportChatSponsoredMessage", -979984820},
    {"reportMessageReactions", 919111719},
    {"reportPhoneNumberCodeMissing", -895175341},
    {"reportSponsoredChat", -902673019},
    {"reportStory", 1823256372},
    {"reportSupergroupAntiSpamFalsePositive", -516050872},
    {"reportSupergroupSpam", -94825000},
    {"reportVideoMessageAdvertisement", 617137942},
    {"requestAuthenticationPasswordRecovery", 1393896118},
    {"requestPasswordRecovery", -13777582},
    {"requestQrCodeAuthentication", 1363496527},
    {"resendAuthenticationCode", -1506755656},
    {"resendEmailAddressVerificationCode", -1872416732},
    {"resendLoginEmailAddressCode", 292966933},
    {"resendMessages", 526374678},
    {"resendPhoneNumberCode", 1808704551},
    {"resendRecoveryEmailAddressCode", 433483548},
    {"resetAllNotificationSettings", -174020359},
    {"resetAuthenticationEmailAddress", -415075796},
    {"resetInstalledBackgrounds", 1884553559},
    {"resetNetworkStatistics", 1646452102},
    {"resetPassword", -593589091},
    {"reuseStarSubscription", 778531905},
    {"revokeChatInviteLink", -776514135},
    {"revokeGroupCallInviteLink", 501589140},
    {"saveApplicationLogEvent", -811154930},
    {"savePreparedInlineMessage", -954963751},
    {"searchAffiliatePrograms", 681156625},
    {"searchBackground", -2130996959},
    {"searchCallMessages", -1942229221},
    {"searchChatAffiliateProgram", -1339291206},
    {"searchChatMembers", -445823291},
    {"searchChatMessages", 1072442212},
    {"searchChatRecentLocationMessages", 950238950},
    {"searchChats", -1879787060},
    {"searchChatsOnServer", -1158402188},
    {"searchContacts", -1794690715},
    {"searchEmojis", -1456187668},
    {"searchFileDownloads", 706611286},
    {"searchGiftsForResale", 1659300894},
    {"searchHashtags", 1043637617},
    {"searchInstalledStickerSets", 2120122276},
    {"searchMessages", 1225448885},
    {"searchOutgoingDocumentMessages", -1071397762},
    {"searchPublicChat", 857135533},
    {"searchPublicChats", 970385337},
    {"searchPublicMessagesByTag", 630680746},
    {"searchPublicPosts", 618133347},
    {"searchPublicStoriesByLocation", 1596709256},
    {"searchPublicStoriesByTag", 1778102602},
    {"searchPublicStoriesByVenue", -686136790},
    {"searchQuote", 1751384351},
    {"searchRecentlyFoundChats", 1647445393},
    {"searchSavedMessages", -1969512554},
    {"searchSecretMessages", -852865892},
    {"searchStickerSet", 1676592898},
    {"searchStickerSets", 262801004},
    {"searchStickers", -1856294754},
    {"searchStringsByPrefix", -2023251463},
    {"searchUserByPhoneNumber", -343757368},
    {"searchUserByToken", -666766282},
    {"searchWebApp", -1241740747},
    {"sellGift", -298298375},
    {"sendAuthenticationFirebaseSms", 364994111},
    {"sendBotStartMessage", -1435877650},
    {"sendBusinessMessage", 159888387},
    {"sendBusinessMessageAlbum", 788608366},
    {"sendCallDebugInformation", 2019243839},
    {"sendCallLog", 1057638353},
    {"sendCallRating", -1402719502},
    {"sendCallSignalingData", 1412280732},
    {"sendChatAction", -1586808788},
    {"sendCustomRequest", 285045153},
    {"sendEmailAddressVerificationCode", -221621379},
    {"sendGift", -1199356118},
    {"sendGiftPurchaseOffer", 917878931},
    {"sendGroupCallMessage", 2133590097},
    {"sendInlineQueryResultMessage", -1445935970},
    {"sendMessage", 964116012},
    {"sendMessageAlbum", -1488607732},
    {"sendPassportAuthorizationForm", 652160701},
    {"sendPaymentForm", -965855094},
    {"sendPhoneNumberCode", 1084112144},
    {"sendPhoneNumberFirebaseSms", 261910660},
    {"sendQuickReplyShortcutMessages", 232068765},
    {"sendResoldGift", -1427446834},
    {"sendTextMessageDraft", 2121571326},
    {"sendWebAppCustomRequest", 922705352},
    {"sendWebAppData", -1423978996},
    {"setAccentColor", 1669974841},
    {"setAccountTtl", 701389032},
    {"setAlarm", -873497067},
    {"setApplicationVerificationToken", 927248261},
    {"setArchiveChatListSettings", -884650998},
    {"setAuthenticationEmailAddress", 1773323522},
    {"setAuthenticationPhoneNumber", 868276259},
    {"setAuthenticationPremiumPurchaseTransaction", -450986887},
    {"setAutoDownloadSettings", -353671948},
    {"setAutosaveSettings", 6846656},
    {"setBio", -1619582124},
    {"setBirthdate", 1319755160},
    {"setBotInfoDescription", 693574984},
    {"setBotInfoShortDescription", 982956771},
    {"setBotName", -761922959},
    {"setBotProfilePhoto", -1115272346},
    {"setBotUpdatesStatus", -1154926191},
    {"setBusinessAccountBio", -1698538041},
    {"setBusinessAccountGiftSettings", 1757763090},
    {"setBusinessAccountName", 999582546},
    {"setBusinessAccountProfilePhoto", 1174440149},
    {"setBusinessAccountUsername", -1520126367},
    {"setBusinessAwayMessageSettings", 1232357484},
    {"setBusinessConnectedBot", -1393459472},
    {"setBusinessGreetingMessageSettings", -873120707},
    {"setBusinessLocation", -344717547},
    {"setBusinessMessageIsPinned", -15403536},
    {"setBusinessOpeningHours", -462379918},
    {"setBusinessStartPage", -1628616290},
    {"setChatAccentColor", 882857930},
    {"setChatActiveStoriesList", -521970415},
    {"setChatAffiliateProgram", 14680631},
    {"setChatAvailableReactions", 267075078},
    {"setChatBackground", 246727678},
    {"setChatClientData", -827119811},
    {"setChatDescription", 1957213277},
    {"setChatDirectMessagesGroup", 1633150115},
    {"setChatDiscussionGroup", -918801736},
    {"setChatDraftMessage", -555614927},
    {"setChatEmojiStatus", 1434982674},
    {"setChatLocation", -767091286},
    {"setChatMemberStatus", 81794847},
    {"setChatMessageAutoDeleteTime", -1505643265},
    {"setChatMessageSender", -1421513858},
    {"setChatNotificationSettings", 777199614},
    {"setChatPaidMessageStarCount", -1187053289},
    {"setChatPermissions", 2138507006},
    {"setChatPhoto", -377778941},
    {"setChatPinnedStories", -669062355},
    {"setChatProfileAccentColor", 1109896826},
    {"setChatSlowModeDelay", -540350914},
    {"setChatTheme", 1474791506},
    {"setChatTitle", 164282047},
    {"setCloseFriends", -1908013258},
    {"setCommands", -907165606},
    {"setCustomEmojiStickerSetThumbnail", -1122836246},
    {"setCustomLanguagePack", -296742819},
    {"setCustomLanguagePackString", 1316365592},
    {"setDatabaseEncryptionKey", -1204599371},
    {"setDefaultBackground", -1982748511},
    {"setDefaultChannelAdministratorRights", -234004967},
    {"setDefaultGroupAdministratorRights", 1700231016},
    {"setDefaultMessageAutoDeleteTime", -1772301460},
    {"setDefaultReactionType", 1694730813},
    {"setDirectMessagesChatTopicIsMarkedAsUnread", 1569655059},
    {"setEmojiStatus", -1829224867},
    {"setFileGenerationProgress", 1836403518},
    {"setForumTopicNotificationSettings", -1989500300},
    {"setGameScore", 2127359430},
    {"setGiftCollectionName", 1108355593},
    {"setGiftResalePrice", 373916170},
    {"setGiftSettings", -519330046},
    {"setGroupCallPaidMessageStarCount", -1764341527},
    {"setGroupCallParticipantIsSpeaking", -1019676164},
    {"setGroupCallParticipantVolumeLevel", -1753769944},
    {"setInactiveSessionTtl", 1570548048},
    {"setInlineGameScore", -948871797},
    {"setLiveStoryMessageSender", -1855297410},
    {"setLogStream", -1364199535},
    {"setLogTagVerbosityLevel", -2095589738},
    {"setLogVerbosityLevel", -303429678},
    {"setLoginEmailAddress", 935019476},
    {"setMainProfileTab", 1663496423},
    {"setMenuButton", -1269841599},
    {"setMessageFactCheck", -4309752},
    {"setMessageReactions", -372524900},
    {"setMessageSenderBlockList", -1987355503},
    {"setMessageSenderBotVerification", -1262364086},
    {"setName", 1711693584},
    {"setNetworkType", -701635234},
    {"setNewChatPrivacySettings", 1774139215},
    {"setOption", 2114670322},
    {"setPaidMessageReactionType", -829934930},
    {"setPassportElement", 2068173212},
    {"setPassportElementErrors", -2056754881},
    {"setPassword", -1193589027},
    {"setPersonalChat", -1068782668},
    {"setPinnedChats", -695640000},
    {"setPinnedForumTopics", -1871668497},
    {"setPinnedGifts", 1613526306},
    {"setPinnedSavedMessagesTopics", -194818924},
    {"setPollAnswer", -1399388792},
    {"setProfileAccentColor", -1986281112},
    {"setProfileAudioPosition", 1209963614},
    {"setProfilePhoto", -2048260627},
    {"setQuickReplyShortcutName", 186709105},
    {"setReactionNotificationSettings", 1186124949},
    {"setReadDatePrivacySettings", 493913782},
    {"setRecoveryEmailAddress", -1981836385},
    {"setSavedMessagesTagLabel", -1338323696},
    {"setScopeNotificationSettings", -2049984966},
    {"setStickerEmojis", -638843855},
    {"setStickerKeywords", 137223565},
    {"setStickerMaskPosition", 1202280912},
    {"setStickerPositionInSet", 2075281185},
    {"setStickerSetThumbnail", 1677617458},
    {"setStickerSetTitle", 1693004706},
    {"setStoryAlbumName", -1143129794},
    {"setStoryPrivacySettings", -655801550},
    {"setStoryReaction", 250731529},
    {"setSupergroupCustomEmojiStickerSet", 1328894639},
    {"setSupergroupMainProfileTab", 1314899548},
    {"setSupergroupStickerSet", -2056344215},
    {"setSupergroupUnrestrictBoostCount", 969814179},
    {"setSupergroupUsername", 1346325252},
    {"setTdlibParameters", -775883218},
    {"setUpgradedGiftColors", -966832402},
    {"setUserEmojiStatus", -451519541},
    {"setUserNote", -351487655},
    {"setUserPersonalProfilePhoto", 464136438},
    {"setUserPrivacySettingRules", -473812741},
    {"setUserSupportInfo", -2088986621},
    {"setUsername", 439901214},
    {"setVideoChatDefaultParticipant", -240749901},
    {"setVideoChatTitle", 1915482994},
    {"shareChatWithBot", -1504507166},
    {"sharePhoneNumber", 1097130069},
    {"shareUsersWithBot", -1574608333},
    {"startGroupCallRecording", 1757774971},
    {"startGroupCallScreenSharing", -884068051},
    {"startLiveStory", 1253467958},
    {"startScheduledVideoChat", -1300829822},
    {"stopBusinessPoll", -1142218400},
    {"stopPoll", 1659374253},
    {"suggestUserBirthdate", 39506613},
    {"suggestUserProfilePhoto", -1788742557},
    {"summarizeMessage", 1405194782},
    {"synchronizeLanguagePack", -2065307858},
    {"terminateAllOtherSessions", 1874485523},
    {"terminateSession", -407385812},
    {"testCallBytes", -736011607},
    {"testCallEmpty", -627291626},
    {"testCallString", -1732818385},
    {"testCallVectorInt", -2137277793},
    {"testCallVectorIntObject", 1825428218},
    {"testCallVectorString", -408600900},
    {"testCallVectorStringObject", 1527666429},
    {"testGetDifference", 1747084069},
    {"testNetwork", -1343998901},
    {"testProxy", -1197366626},
    {"testReturnError", 455179506},
    {"testSquareInt", -60135024},
    {"testUseUpdate", 717094686},
    {"toggleAllDownloadsArePaused", 1251512322},
    {"toggleBotCanManageEmojiStatus", 622495770},
    {"toggleBotIsAddedToAttachmentMenu", -1906712934},
    {"toggleBotUsernameIsActive", 2036569097},
    {"toggleBusinessConnectedBotChatIsPaused", 1328957509},
    {"toggleChatDefaultDisableNotification", 314794002},
    {"toggleChatFolderTags", -2092209084},
    {"toggleChatGiftNotifications", -2069429154},
    {"toggleChatHasProtectedContent", 975231309},
    {"toggleChatIsMarkedAsUnread", -986129697},
    {"toggleChatIsPinned", -1485429186},
    {"toggleChatIsTranslatable", -1812345889},
    {"toggleChatViewAsTopics", 724009948},
    {"toggleDirectMessagesChatTopicCanSendUnpaidMessages", -335898703},
    {"toggleDownloadIsPaused", -947493099},
    {"toggleForumTopicIsClosed", 982153376},
    {"toggleForumTopicIsPinned", 1474651795},
    {"toggleGeneralForumTopicIsHidden", 1595741256},
    {"toggleGiftIsSaved", 693198065},
    {"toggleGroupCallAreMessagesAllowed", -1535668758},
    {"toggleGroupCallIsMyVideoEnabled", -1624289030},
    {"toggleGroupCallIsMyVideoPaused", -478875239},
    {"toggleGroupCallParticipantIsHandRaised", -1896127519},
    {"toggleGroupCallParticipantIsMuted", -1308093433},
    {"toggleGroupCallScreenSharingIsPaused", -1602530464},
    {"toggleHasSponsoredMessagesEnabled", 1963285740},
    {"toggleSavedMessagesTopicIsPinned", -1588378164},
    {"toggleSessionCanAcceptCalls", 1819027208},
    {"toggleSessionCanAcceptSecretChats", 1000843390},
    {"toggleStoryIsPostedToChatPage", -2141806228},
    {"toggleSupergroupCanHaveSponsoredMessages", -1098204302},
    {"toggleSupergroupHasAggressiveAntiSpamEnabled", 1748956943},
    {"toggleSupergroupHasAutomaticTranslation", -184993048},
    {"toggleSupergroupHasHiddenMembers", -1537892918},
    {"toggleSupergroupIsAllHistoryAvailable", 1155110478},
    {"toggleSupergroupIsBroadcastGroup", 884089365},
    {"toggleSupergroupIsForum", 371064337},
    {"toggleSupergroupJoinByRequest", 2111807454},
    {"toggleSupergroupJoinToSendMessages", -182022642},
    {"toggleSupergroupSignMessages", 572268491},
    {"toggleSupergroupUsernameIsActive", -1500811777},
    {"toggleUsernameIsActive", 1244098019},
    {"toggleVideoChatEnabledStartNotification", 1851489086},
    {"toggleVideoChatMuteNewParticipants", 987023756},
    {"transferBusinessAccountStars", 732562464},
    {"transferChatOwnership", 2006977043},
    {"transferGift", -1167293126},
    {"translateMessageText", 1405427410},
    {"translateText", 623011058},
    {"unpinAllChatMessages", -1437805385},
    {"unpinAllDirectMessagesChatTopicMessages", 89671100},
    {"unpinAllForumTopicMessages", -1113340771},
    {"unpinChatMessage", 2065448670},
    {"upgradeBasicGroupChatToSupergroupChat", 300488122},
    {"upgradeGift", -1782136103},
    {"uploadStickerFile", 647385283},
    {"validateOrderInfo", -1248305201},
    {"viewMessages", 960236656},
    {"viewPremiumFeature", 192950706},
    {"viewSponsoredChat", 1722644778},
    {"viewTrendingStickerSets", -952416520},
    {"viewVideoMessageAdvertisement", -808563006},
    {"writeGeneratedFilePart", 214474389}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::accountTtl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.days_, from.extract_field("days")));
  return Status::OK();
}

Status from_json(td_api::archiveChatListSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.archive_and_mute_new_chats_from_unknown_users_, from.extract_field("archive_and_mute_new_chats_from_unknown_users")));
  TRY_STATUS(from_json(to.keep_unmuted_chats_archived_, from.extract_field("keep_unmuted_chats_archived")));
  TRY_STATUS(from_json(to.keep_chats_from_folders_archived_, from.extract_field("keep_chats_from_folders_archived")));
  return Status::OK();
}

Status from_json(td_api::backgroundTypeWallpaper &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_blurred_, from.extract_field("is_blurred")));
  TRY_STATUS(from_json(to.is_moving_, from.extract_field("is_moving")));
  return Status::OK();
}

Status from_json(td_api::botCommandScopeAllPrivateChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessAwayMessageScheduleCustom &to, JsonObject &from) {
  TRY_STATUS(from_json(to.start_date_, from.extract_field("start_date")));
  TRY_STATUS(from_json(to.end_date_, from.extract_field("end_date")));
  return Status::OK();
}

Status from_json(td_api::businessFeatureAccountLinks &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessOpeningHoursInterval &to, JsonObject &from) {
  TRY_STATUS(from_json(to.start_minute_, from.extract_field("start_minute")));
  TRY_STATUS(from_json(to.end_minute_, from.extract_field("end_minute")));
  return Status::OK();
}

Status from_json(td_api::callProblemDistortedVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionRecordingVoiceNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionUploadingVideoNote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.progress_, from.extract_field("progress")));
  return Status::OK();
}

Status from_json(td_api::chatFolderName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.animate_custom_emoji_, from.extract_field("animate_custom_emoji")));
  return Status::OK();
}

Status from_json(td_api::chatMemberStatusMember &to, JsonObject &from) {
  TRY_STATUS(from_json(to.member_until_date_, from.extract_field("member_until_date")));
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterBanned &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::contact &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  TRY_STATUS(from_json(to.vcard_, from.extract_field("vcard")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenSimplePush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.endpoint_, from.extract_field("endpoint")));
  return Status::OK();
}

Status from_json(td_api::emojiCategoryTypeDefault &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeAnimation &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeSecure &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeVideoNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::giftForResaleOrderPriceChangeDate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::groupCallVideoQualityThumbnail &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeCallbackWithPassword &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::inputBackgroundLocal &to, JsonObject &from) {
  TRY_STATUS(from_json(to.background_, from.extract_field("background")));
  return Status::OK();
}

Status from_json(td_api::inputChatThemeEmoji &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::inputFileRemote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultContact &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.contact_, from.extract_field("contact")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_width_, from.extract_field("thumbnail_width")));
  TRY_STATUS(from_json(to.thumbnail_height_, from.extract_field("thumbnail_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputInvoiceMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::inputMessageSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.width_, from.extract_field("width")));
  TRY_STATUS(from_json(to.height_, from.extract_field("height")));
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  return Status::OK();
}

Status from_json(td_api::inputMessageInvoice &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invoice_, from.extract_field("invoice")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.photo_url_, from.extract_field("photo_url")));
  TRY_STATUS(from_json(to.photo_size_, from.extract_field("photo_size")));
  TRY_STATUS(from_json(to.photo_width_, from.extract_field("photo_width")));
  TRY_STATUS(from_json(to.photo_height_, from.extract_field("photo_height")));
  TRY_STATUS(from_json_bytes(to.payload_, from.extract_field("payload")));
  TRY_STATUS(from_json(to.provider_token_, from.extract_field("provider_token")));
  TRY_STATUS(from_json(to.provider_data_, from.extract_field("provider_data")));
  TRY_STATUS(from_json(to.start_parameter_, from.extract_field("start_parameter")));
  TRY_STATUS(from_json(to.paid_media_, from.extract_field("paid_media")));
  TRY_STATUS(from_json(to.paid_media_caption_, from.extract_field("paid_media_caption")));
  return Status::OK();
}

Status from_json(td_api::inputPaidMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.media_, from.extract_field("media")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.added_sticker_file_ids_, from.extract_field("added_sticker_file_ids")));
  TRY_STATUS(from_json(to.width_, from.extract_field("width")));
  TRY_STATUS(from_json(to.height_, from.extract_field("height")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementUtilityBill &to, JsonObject &from) {
  TRY_STATUS(from_json(to.utility_bill_, from.extract_field("utility_bill")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceDataField &to, JsonObject &from) {
  TRY_STATUS(from_json(to.field_name_, from.extract_field("field_name")));
  TRY_STATUS(from_json_bytes(to.data_hash_, from.extract_field("data_hash")));
  return Status::OK();
}

Status from_json(td_api::inputSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  TRY_STATUS(from_json(to.format_, from.extract_field("format")));
  TRY_STATUS(from_json(to.emojis_, from.extract_field("emojis")));
  TRY_STATUS(from_json(to.mask_position_, from.extract_field("mask_position")));
  TRY_STATUS(from_json(to.keywords_, from.extract_field("keywords")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeUpgradedGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_name_, from.extract_field("gift_name")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeAuthenticationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeChatBoost &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeGiftCollection &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_owner_username_, from.extract_field("gift_owner_username")));
  TRY_STATUS(from_json(to.collection_id_, from.extract_field("collection_id")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePremiumGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.referrer_, from.extract_field("referrer")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_username_, from.extract_field("story_poster_username")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeVideoChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_username_, from.extract_field("chat_username")));
  TRY_STATUS(from_json(to.invite_hash_, from.extract_field("invite_hash")));
  TRY_STATUS(from_json(to.is_live_stream_, from.extract_field("is_live_stream")));
  return Status::OK();
}

Status from_json(td_api::jsonValueObject &to, JsonObject &from) {
  TRY_STATUS(from_json(to.members_, from.extract_field("members")));
  return Status::OK();
}

Status from_json(td_api::labeledPricePart &to, JsonObject &from) {
  TRY_STATUS(from_json(to.label_, from.extract_field("label")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  return Status::OK();
}

Status from_json(td_api::logStreamDefault &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageCopyOptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.send_copy_, from.extract_field("send_copy")));
  TRY_STATUS(from_json(to.replace_caption_, from.extract_field("replace_caption")));
  TRY_STATUS(from_json(to.new_caption_, from.extract_field("new_caption")));
  TRY_STATUS(from_json(to.new_show_caption_above_media_, from.extract_field("new_show_caption_above_media")));
  return Status::OK();
}

Status from_json(td_api::messageSourceChatHistory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageSourceScreenshot &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkTypeMobile &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::optionValueEmpty &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypeDriverLicense &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypePhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureIncreasedLimits &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureProfileBadge &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureBackgroundForBoth &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypePinnedChatCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeBioLength &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumSourceLimitExceeded &to, JsonObject &from) {
  TRY_STATUS(from_json(to.limit_type_, from.extract_field("limit_type")));
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeatureCustomExpirationDuration &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabMusic &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::reactionNotificationSourceNone &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::replyMarkupShowKeyboard &to, JsonObject &from) {
  TRY_STATUS(from_json(to.rows_, from.extract_field("rows")));
  TRY_STATUS(from_json(to.is_persistent_, from.extract_field("is_persistent")));
  TRY_STATUS(from_json(to.resize_keyboard_, from.extract_field("resize_keyboard")));
  TRY_STATUS(from_json(to.one_time_, from.extract_field("one_time")));
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  TRY_STATUS(from_json(to.input_field_placeholder_, from.extract_field("input_field_placeholder")));
  return Status::OK();
}

Status from_json(td_api::reportReasonIllegalDrugs &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesChatTypeFilterChannel &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterUrl &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::shippingOption &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.price_parts_, from.extract_field("price_parts")));
  return Status::OK();
}

Status from_json(td_api::storePaymentPurposePremiumGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::storyFullId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.poster_chat_id_, from.extract_field("poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionCheckPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionSetProfilePhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterContacts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::targetChatInternalLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::testInt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypePhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypePreCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_, from.extract_field("language")));
  return Status::OK();
}

Status from_json(td_api::themeParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.background_color_, from.extract_field("background_color")));
  TRY_STATUS(from_json(to.secondary_background_color_, from.extract_field("secondary_background_color")));
  TRY_STATUS(from_json(to.header_background_color_, from.extract_field("header_background_color")));
  TRY_STATUS(from_json(to.bottom_bar_background_color_, from.extract_field("bottom_bar_background_color")));
  TRY_STATUS(from_json(to.section_background_color_, from.extract_field("section_background_color")));
  TRY_STATUS(from_json(to.section_separator_color_, from.extract_field("section_separator_color")));
  TRY_STATUS(from_json(to.text_color_, from.extract_field("text_color")));
  TRY_STATUS(from_json(to.accent_text_color_, from.extract_field("accent_text_color")));
  TRY_STATUS(from_json(to.section_header_text_color_, from.extract_field("section_header_text_color")));
  TRY_STATUS(from_json(to.subtitle_text_color_, from.extract_field("subtitle_text_color")));
  TRY_STATUS(from_json(to.destructive_text_color_, from.extract_field("destructive_text_color")));
  TRY_STATUS(from_json(to.hint_color_, from.extract_field("hint_color")));
  TRY_STATUS(from_json(to.link_color_, from.extract_field("link_color")));
  TRY_STATUS(from_json(to.button_color_, from.extract_field("button_color")));
  TRY_STATUS(from_json(to.button_text_color_, from.extract_field("button_text_color")));
  return Status::OK();
}

Status from_json(td_api::transactionDirectionIncoming &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAutosaveGifts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::webAppOpenParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.theme_, from.extract_field("theme")));
  TRY_STATUS(from_json(to.application_name_, from.extract_field("application_name")));
  TRY_STATUS(from_json(to.mode_, from.extract_field("mode")));
  return Status::OK();
}

Status from_json(td_api::addChecklistTasks &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.tasks_, from.extract_field("tasks")));
  return Status::OK();
}

Status from_json(td_api::addMessageReaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  TRY_STATUS(from_json(to.is_big_, from.extract_field("is_big")));
  TRY_STATUS(from_json(to.update_recent_reactions_, from.extract_field("update_recent_reactions")));
  return Status::OK();
}

Status from_json(td_api::addQuickReplyShortcutMessageAlbum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_name_, from.extract_field("shortcut_name")));
  TRY_STATUS(from_json(to.reply_to_message_id_, from.extract_field("reply_to_message_id")));
  TRY_STATUS(from_json(to.input_message_contents_, from.extract_field("input_message_contents")));
  return Status::OK();
}

Status from_json(td_api::answerCallbackQuery &to, JsonObject &from) {
  TRY_STATUS(from_json(to.callback_query_id_, from.extract_field("callback_query_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.show_alert_, from.extract_field("show_alert")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.cache_time_, from.extract_field("cache_time")));
  return Status::OK();
}

Status from_json(td_api::banChatMember &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.member_id_, from.extract_field("member_id")));
  TRY_STATUS(from_json(to.banned_until_date_, from.extract_field("banned_until_date")));
  TRY_STATUS(from_json(to.revoke_messages_, from.extract_field("revoke_messages")));
  return Status::OK();
}

Status from_json(td_api::canSendMessageToUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.code_, from.extract_field("code")));
  return Status::OK();
}

Status from_json(td_api::checkCreatedPublicChatsLimit &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::checkWebAppFileDownload &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.file_name_, from.extract_field("file_name")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::clearSearchedForTags &to, JsonObject &from) {
  TRY_STATUS(from_json(to.clear_cashtags_, from.extract_field("clear_cashtags")));
  return Status::OK();
}

Status from_json(td_api::closeStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::createCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.protocol_, from.extract_field("protocol")));
  TRY_STATUS(from_json(to.is_video_, from.extract_field("is_video")));
  return Status::OK();
}

Status from_json(td_api::createNewBasicGroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.message_auto_delete_time_, from.extract_field("message_auto_delete_time")));
  return Status::OK();
}

Status from_json(td_api::createVideoChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.start_date_, from.extract_field("start_date")));
  TRY_STATUS(from_json(to.is_rtmp_stream_, from.extract_field("is_rtmp_stream")));
  return Status::OK();
}

Status from_json(td_api::deleteBusinessConnectedBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::deleteChatMessagesBySender &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.sender_id_, from.extract_field("sender_id")));
  return Status::OK();
}

Status from_json(td_api::deleteGroupCallMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.report_spam_, from.extract_field("report_spam")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedCredentials &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::disableProxy &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageCaption &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.show_caption_above_media_, from.extract_field("show_caption_above_media")));
  return Status::OK();
}

Status from_json(td_api::editChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.expiration_date_, from.extract_field("expiration_date")));
  TRY_STATUS(from_json(to.member_limit_, from.extract_field("member_limit")));
  TRY_STATUS(from_json(to.creates_join_request_, from.extract_field("creates_join_request")));
  return Status::OK();
}

Status from_json(td_api::editMessageCaption &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.show_caption_above_media_, from.extract_field("show_caption_above_media")));
  return Status::OK();
}

Status from_json(td_api::editStarSubscription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.subscription_id_, from.extract_field("subscription_id")));
  TRY_STATUS(from_json(to.is_canceled_, from.extract_field("is_canceled")));
  return Status::OK();
}

Status from_json(td_api::finishFileGeneration &to, JsonObject &from) {
  TRY_STATUS(from_json(to.generation_id_, from.extract_field("generation_id")));
  TRY_STATUS(from_json(to.error_, from.extract_field("error")));
  return Status::OK();
}

Status from_json(td_api::getArchiveChatListSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAvailableGifts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getBotMediaPreviews &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getBusinessFeatures &to, JsonObject &from) {
  TRY_STATUS(from_json(to.source_, from.extract_field("source")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostFeatures &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_channel_, from.extract_field("is_channel")));
  return Status::OK();
}

Status from_json(td_api::getChatFolderChatsToLeave &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getChatJoinRequests &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_request_, from.extract_field("offset_request")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getChatPostedToChatPageStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.from_story_id_, from.extract_field("from_story_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getChatStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_dark_, from.extract_field("is_dark")));
  return Status::OK();
}

Status from_json(td_api::getConnectedAffiliateProgram &to, JsonObject &from) {
  TRY_STATUS(from_json(to.affiliate_, from.extract_field("affiliate")));
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getCurrentWeather &to, JsonObject &from) {
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  return Status::OK();
}

Status from_json(td_api::getDefaultMessageAutoDeleteTime &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getEmojiSuggestionsUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  return Status::OK();
}

Status from_json(td_api::getForumTopicDefaultIcons &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getGiftUpgradePreview &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_id_, from.extract_field("gift_id")));
  return Status::OK();
}

Status from_json(td_api::getGroupsInCommon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.offset_chat_id_, from.extract_field("offset_chat_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getJsonString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.json_value_, from.extract_field("json_value")));
  return Status::OK();
}

Status from_json(td_api::getLiveStoryStreamer &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getLoginUrlInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.button_id_, from.extract_field("button_id")));
  return Status::OK();
}

Status from_json(td_api::getMessageAvailableReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.row_size_, from.extract_field("row_size")));
  return Status::OK();
}

Status from_json(td_api::getMessagePublicForwards &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getOption &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::getPaymentForm &to, JsonObject &from) {
  TRY_STATUS(from_json(to.input_invoice_, from.extract_field("input_invoice")));
  TRY_STATUS(from_json(to.theme_, from.extract_field("theme")));
  return Status::OK();
}

Status from_json(td_api::getPremiumInfoSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.month_count_, from.extract_field("month_count")));
  return Status::OK();
}

Status from_json(td_api::getPushReceiverId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  return Status::OK();
}

Status from_json(td_api::getRecommendedChatFolders &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getSavedNotificationSound &to, JsonObject &from) {
  TRY_STATUS(from_json(to.notification_sound_id_, from.extract_field("notification_sound_id")));
  return Status::OK();
}

Status from_json(td_api::getStarGiftPaymentOptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getStickerOutline &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_file_id_, from.extract_field("sticker_file_id")));
  TRY_STATUS(from_json(to.for_animated_emoji_, from.extract_field("for_animated_emoji")));
  TRY_STATUS(from_json(to.for_clicked_animated_emoji_message_, from.extract_field("for_clicked_animated_emoji_message")));
  return Status::OK();
}

Status from_json(td_api::getStoryAvailableReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.row_size_, from.extract_field("row_size")));
  return Status::OK();
}

Status from_json(td_api::getSupergroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::getThemedEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUpgradedGiftValueInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::getUserProfilePhotos &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getWebPageInstantView &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.only_local_, from.extract_field("only_local")));
  return Status::OK();
}

Status from_json(td_api::isLoginEmailAddressRequired &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::leaveGroupCall &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::markChecklistTasksAsDone &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.marked_as_done_task_ids_, from.extract_field("marked_as_done_task_ids")));
  TRY_STATUS(from_json(to.marked_as_not_done_task_ids_, from.extract_field("marked_as_not_done_task_ids")));
  return Status::OK();
}

Status from_json(td_api::optimizeStorage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.size_, from.extract_field("size")));
  TRY_STATUS(from_json(to.ttl_, from.extract_field("ttl")));
  TRY_STATUS(from_json(to.count_, from.extract_field("count")));
  TRY_STATUS(from_json(to.immunity_delay_, from.extract_field("immunity_delay")));
  TRY_STATUS(from_json(to.file_types_, from.extract_field("file_types")));
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  TRY_STATUS(from_json(to.exclude_chat_ids_, from.extract_field("exclude_chat_ids")));
  TRY_STATUS(from_json(to.return_deleted_file_statistics_, from.extract_field("return_deleted_file_statistics")));
  TRY_STATUS(from_json(to.chat_limit_, from.extract_field("chat_limit")));
  return Status::OK();
}

Status from_json(td_api::processChatJoinRequest &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.approve_, from.extract_field("approve")));
  return Status::OK();
}

Status from_json(td_api::readAllForumTopicReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  return Status::OK();
}

Status from_json(td_api::registerDevice &to, JsonObject &from) {
  TRY_STATUS(from_json(to.device_token_, from.extract_field("device_token")));
  TRY_STATUS(from_json(to.other_user_ids_, from.extract_field("other_user_ids")));
  return Status::OK();
}

Status from_json(td_api::removeInstalledBackground &to, JsonObject &from) {
  TRY_STATUS(from_json(to.background_id_, from.extract_field("background_id")));
  return Status::OK();
}

Status from_json(td_api::removeProxy &to, JsonObject &from) {
  TRY_STATUS(from_json(to.proxy_id_, from.extract_field("proxy_id")));
  return Status::OK();
}

Status from_json(td_api::removeTopChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.category_, from.extract_field("category")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::reorderStoryAlbumStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  TRY_STATUS(from_json(to.story_ids_, from.extract_field("story_ids")));
  return Status::OK();
}

Status from_json(td_api::reportChatPhoto &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  TRY_STATUS(from_json(to.reason_, from.extract_field("reason")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::requestAuthenticationPasswordRecovery &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::resetAllNotificationSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::savePreparedInlineMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.result_, from.extract_field("result")));
  TRY_STATUS(from_json(to.chat_types_, from.extract_field("chat_types")));
  return Status::OK();
}

Status from_json(td_api::searchChatsOnServer &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchPublicChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::searchSavedMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.tag_, from.extract_field("tag")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::sellGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.received_gift_id_, from.extract_field("received_gift_id")));
  return Status::OK();
}

Status from_json(td_api::sendChatAction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.action_, from.extract_field("action")));
  return Status::OK();
}

Status from_json(td_api::sendPassportAuthorizationForm &to, JsonObject &from) {
  TRY_STATUS(from_json(to.authorization_form_id_, from.extract_field("authorization_form_id")));
  TRY_STATUS(from_json(to.types_, from.extract_field("types")));
  return Status::OK();
}

Status from_json(td_api::setAccentColor &to, JsonObject &from) {
  TRY_STATUS(from_json(to.accent_color_id_, from.extract_field("accent_color_id")));
  TRY_STATUS(from_json(to.background_custom_emoji_id_, from.extract_field("background_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::setAutosaveSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAccountGiftSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setBusinessOpeningHours &to, JsonObject &from) {
  TRY_STATUS(from_json(to.opening_hours_, from.extract_field("opening_hours")));
  return Status::OK();
}

Status from_json(td_api::setChatDirectMessagesGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_enabled_, from.extract_field("is_enabled")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  return Status::OK();
}

Status from_json(td_api::setChatPaidMessageStarCount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  return Status::OK();
}

Status from_json(td_api::setCommands &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.commands_, from.extract_field("commands")));
  return Status::OK();
}

Status from_json(td_api::setDefaultReactionType &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reaction_type_, from.extract_field("reaction_type")));
  return Status::OK();
}

Status from_json(td_api::setGroupCallPaidMessageStarCount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.paid_message_star_count_, from.extract_field("paid_message_star_count")));
  return Status::OK();
}

Status from_json(td_api::setLoginEmailAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.new_login_email_address_, from.extract_field("new_login_email_address")));
  return Status::OK();
}

Status from_json(td_api::setNewChatPrivacySettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setPinnedGifts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.received_gift_ids_, from.extract_field("received_gift_ids")));
  return Status::OK();
}

Status from_json(td_api::setRecoveryEmailAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  TRY_STATUS(from_json(to.new_recovery_email_address_, from.extract_field("new_recovery_email_address")));
  return Status::OK();
}

Status from_json(td_api::setStoryAlbumName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::setUpgradedGiftColors &to, JsonObject &from) {
  TRY_STATUS(from_json(to.upgraded_gift_colors_id_, from.extract_field("upgraded_gift_colors_id")));
  return Status::OK();
}

Status from_json(td_api::shareChatWithBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.button_id_, from.extract_field("button_id")));
  TRY_STATUS(from_json(to.shared_chat_id_, from.extract_field("shared_chat_id")));
  TRY_STATUS(from_json(to.only_check_, from.extract_field("only_check")));
  return Status::OK();
}

Status from_json(td_api::suggestUserBirthdate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.birthdate_, from.extract_field("birthdate")));
  return Status::OK();
}

Status from_json(td_api::testCallVectorInt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::testUseUpdate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::toggleChatHasProtectedContent &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.has_protected_content_, from.extract_field("has_protected_content")));
  return Status::OK();
}

Status from_json(td_api::toggleGeneralForumTopicIsHidden &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_hidden_, from.extract_field("is_hidden")));
  return Status::OK();
}

Status from_json(td_api::toggleSavedMessagesTopicIsPinned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.is_pinned_, from.extract_field("is_pinned")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupIsBroadcastGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::transferBusinessAccountStars &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::upgradeBasicGroupChatToSupergroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::writeGeneratedFilePart &to, JsonObject &from) {
  TRY_STATUS(from_json(to.generation_id_, from.extract_field("generation_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::advertisementSponsor &object) {
  auto jo = jv.enter_object();
  jo("@type", "advertisementSponsor");
  jo("url", object.url_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("info", object.info_);
}

void to_json(JsonValueScope &jv, const td_api::animations &object) {
  auto jo = jv.enter_object();
  jo("@type", "animations");
  jo("animations", ToJson(object.animations_));
}

void to_json(JsonValueScope &jv, const td_api::authenticationCodeInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "authenticationCodeInfo");
  jo("phone_number", object.phone_number_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  if (object.next_type_) {
    jo("next_type", ToJson(*object.next_type_));
  }
  jo("timeout", object.timeout_);
}

void to_json(JsonValueScope &jv, const td_api::availableGifts &object) {
  auto jo = jv.enter_object();
  jo("@type", "availableGifts");
  jo("gifts", ToJson(object.gifts_));
}

void to_json(JsonValueScope &jv, const td_api::basicGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "basicGroup");
  jo("id", object.id_);
  jo("member_count", object.member_count_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  jo("is_active", JsonBool{object.is_active_});
  jo("upgraded_to_supergroup_id", object.upgraded_to_supergroup_id_);
}

void to_json(JsonValueScope &jv, const td_api::botMediaPreviews &object) {
  auto jo = jv.enter_object();
  jo("@type", "botMediaPreviews");
  jo("previews", ToJson(object.previews_));
}

void to_json(JsonValueScope &jv, const td_api::businessBotRights &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessBotRights");
  jo("can_reply", JsonBool{object.can_reply_});
  jo("can_read_messages", JsonBool{object.can_read_messages_});
  jo("can_delete_sent_messages", JsonBool{object.can_delete_sent_messages_});
  jo("can_delete_all_messages", JsonBool{object.can_delete_all_messages_});
  jo("can_edit_name", JsonBool{object.can_edit_name_});
  jo("can_edit_bio", JsonBool{object.can_edit_bio_});
  jo("can_edit_profile_photo", JsonBool{object.can_edit_profile_photo_});
  jo("can_edit_username", JsonBool{object.can_edit_username_});
  jo("can_view_gifts_and_stars", JsonBool{object.can_view_gifts_and_stars_});
  jo("can_sell_gifts", JsonBool{object.can_sell_gifts_});
  jo("can_change_gift_settings", JsonBool{object.can_change_gift_settings_});
  jo("can_transfer_and_upgrade_gifts", JsonBool{object.can_transfer_and_upgrade_gifts_});
  jo("can_transfer_stars", JsonBool{object.can_transfer_stars_});
  jo("can_manage_stories", JsonBool{object.can_manage_stories_});
}

void to_json(JsonValueScope &jv, const td_api::businessGreetingMessageSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessGreetingMessageSettings");
  jo("shortcut_id", object.shortcut_id_);
  if (object.recipients_) {
    jo("recipients", ToJson(*object.recipients_));
  }
  jo("inactivity_days", object.inactivity_days_);
}

void to_json(JsonValueScope &jv, const td_api::call &object) {
  auto jo = jv.enter_object();
  jo("@type", "call");
  jo("id", object.id_);
  jo("user_id", object.user_id_);
  jo("is_outgoing", JsonBool{object.is_outgoing_});
  jo("is_video", JsonBool{object.is_video_});
  if (object.state_) {
    jo("state", ToJson(*object.state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::CanPostStoryResult &object) {
  td_api::downcast_call(const_cast<td_api::CanPostStoryResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::canPostStoryResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "canPostStoryResultOk");
  jo("story_count", object.story_count_);
}

void to_json(JsonValueScope &jv, const td_api::canPostStoryResultPremiumNeeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "canPostStoryResultPremiumNeeded");
}

void to_json(JsonValueScope &jv, const td_api::canPostStoryResultBoostNeeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "canPostStoryResultBoostNeeded");
}

void to_json(JsonValueScope &jv, const td_api::canPostStoryResultActiveStoryLimitExceeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "canPostStoryResultActiveStoryLimitExceeded");
}

void to_json(JsonValueScope &jv, const td_api::canPostStoryResultWeeklyLimitExceeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "canPostStoryResultWeeklyLimitExceeded");
  jo("retry_after", object.retry_after_);
}

void to_json(JsonValueScope &jv, const td_api::canPostStoryResultMonthlyLimitExceeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "canPostStoryResultMonthlyLimitExceeded");
  jo("retry_after", object.retry_after_);
}

void to_json(JsonValueScope &jv, const td_api::canPostStoryResultLiveStoryIsActive &object) {
  auto jo = jv.enter_object();
  jo("@type", "canPostStoryResultLiveStoryIsActive");
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatAdministratorRights &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatAdministratorRights");
  jo("can_manage_chat", JsonBool{object.can_manage_chat_});
  jo("can_change_info", JsonBool{object.can_change_info_});
  jo("can_post_messages", JsonBool{object.can_post_messages_});
  jo("can_edit_messages", JsonBool{object.can_edit_messages_});
  jo("can_delete_messages", JsonBool{object.can_delete_messages_});
  jo("can_invite_users", JsonBool{object.can_invite_users_});
  jo("can_restrict_members", JsonBool{object.can_restrict_members_});
  jo("can_pin_messages", JsonBool{object.can_pin_messages_});
  jo("can_manage_topics", JsonBool{object.can_manage_topics_});
  jo("can_promote_members", JsonBool{object.can_promote_members_});
  jo("can_manage_video_chats", JsonBool{object.can_manage_video_chats_});
  jo("can_post_stories", JsonBool{object.can_post_stories_});
  jo("can_edit_stories", JsonBool{object.can_edit_stories_});
  jo("can_delete_stories", JsonBool{object.can_delete_stories_});
  jo("can_manage_direct_messages", JsonBool{object.can_manage_direct_messages_});
  jo("is_anonymous", JsonBool{object.is_anonymous_});
}

void to_json(JsonValueScope &jv, const td_api::chatBoostSlot &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostSlot");
  jo("slot_id", object.slot_id_);
  jo("currently_boosted_chat_id", object.currently_boosted_chat_id_);
  jo("start_date", object.start_date_);
  jo("expiration_date", object.expiration_date_);
  jo("cooldown_until_date", object.cooldown_until_date_);
}

void to_json(JsonValueScope &jv, const td_api::chatFolderInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolderInfo");
  jo("id", object.id_);
  if (object.name_) {
    jo("name", ToJson(*object.name_));
  }
  if (object.icon_) {
    jo("icon", ToJson(*object.icon_));
  }
  jo("color_id", object.color_id_);
  jo("is_shareable", JsonBool{object.is_shareable_});
  jo("has_my_invite_links", JsonBool{object.has_my_invite_links_});
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinkMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinkMember");
  jo("user_id", object.user_id_);
  jo("joined_chat_date", object.joined_chat_date_);
  jo("via_chat_folder_invite_link", JsonBool{object.via_chat_folder_invite_link_});
  jo("approver_user_id", object.approver_user_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatLocation");
  if (object.location_) {
    jo("location", ToJson(*object.location_));
  }
  jo("address", object.address_);
}

void to_json(JsonValueScope &jv, const td_api::chatPhotoInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPhotoInfo");
  if (object.small_) {
    jo("small", ToJson(*object.small_));
  }
  if (object.big_) {
    jo("big", ToJson(*object.big_));
  }
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  jo("has_animation", JsonBool{object.has_animation_});
  jo("is_personal", JsonBool{object.is_personal_});
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueTransactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueTransactions");
  jo("ton_amount", object.ton_amount_);
  jo("transactions", ToJson(object.transactions_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::ChatType &object) {
  td_api::downcast_call(const_cast<td_api::ChatType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatTypePrivate &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatTypePrivate");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatTypeBasicGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatTypeBasicGroup");
  jo("basic_group_id", object.basic_group_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatTypeSupergroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatTypeSupergroup");
  jo("supergroup_id", object.supergroup_id_);
  jo("is_channel", JsonBool{object.is_channel_});
}

void to_json(JsonValueScope &jv, const td_api::chatTypeSecret &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatTypeSecret");
  jo("secret_chat_id", object.secret_chat_id_);
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::connectedAffiliateProgram &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectedAffiliateProgram");
  jo("url", object.url_);
  jo("bot_user_id", object.bot_user_id_);
  if (object.parameters_) {
    jo("parameters", ToJson(*object.parameters_));
  }
  jo("connection_date", object.connection_date_);
  jo("is_disconnected", JsonBool{object.is_disconnected_});
  jo("user_count", ToJson(JsonInt64{object.user_count_}));
  jo("revenue_star_count", object.revenue_star_count_);
}

void to_json(JsonValueScope &jv, const td_api::createdBasicGroupChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "createdBasicGroupChat");
  jo("chat_id", object.chat_id_);
  if (object.failed_to_add_members_) {
    jo("failed_to_add_members", ToJson(*object.failed_to_add_members_));
  }
}

void to_json(JsonValueScope &jv, const td_api::DiceStickers &object) {
  td_api::downcast_call(const_cast<td_api::DiceStickers &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::diceStickersRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "diceStickersRegular");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::diceStickersSlotMachine &object) {
  auto jo = jv.enter_object();
  jo("@type", "diceStickersSlotMachine");
  if (object.background_) {
    jo("background", ToJson(*object.background_));
  }
  if (object.lever_) {
    jo("lever", ToJson(*object.lever_));
  }
  if (object.left_reel_) {
    jo("left_reel", ToJson(*object.left_reel_));
  }
  if (object.center_reel_) {
    jo("center_reel", ToJson(*object.center_reel_));
  }
  if (object.right_reel_) {
    jo("right_reel", ToJson(*object.right_reel_));
  }
}

void to_json(JsonValueScope &jv, const td_api::EmojiCategorySource &object) {
  td_api::downcast_call(const_cast<td_api::EmojiCategorySource &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::emojiCategorySourceSearch &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiCategorySourceSearch");
  jo("emojis", ToJson(object.emojis_));
}

void to_json(JsonValueScope &jv, const td_api::emojiCategorySourcePremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiCategorySourcePremium");
}

void to_json(JsonValueScope &jv, const td_api::emojis &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojis");
  jo("emojis", ToJson(object.emojis_));
}

void to_json(JsonValueScope &jv, const td_api::fileDownloadedPrefixSize &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileDownloadedPrefixSize");
  jo("size", object.size_);
}

void to_json(JsonValueScope &jv, const td_api::foundAffiliateProgram &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundAffiliateProgram");
  jo("bot_user_id", object.bot_user_id_);
  if (object.info_) {
    jo("info", ToJson(*object.info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::foundStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundStories");
  jo("total_count", object.total_count_);
  jo("stories", ToJson(object.stories_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::giftAuctionAcquiredGifts &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftAuctionAcquiredGifts");
  jo("gifts", ToJson(object.gifts_));
}

void to_json(JsonValueScope &jv, const td_api::GiftPurchaseOfferState &object) {
  td_api::downcast_call(const_cast<td_api::GiftPurchaseOfferState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::giftPurchaseOfferStatePending &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftPurchaseOfferStatePending");
}

void to_json(JsonValueScope &jv, const td_api::giftPurchaseOfferStateAccepted &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftPurchaseOfferStateAccepted");
}

void to_json(JsonValueScope &jv, const td_api::giftPurchaseOfferStateRejected &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftPurchaseOfferStateRejected");
}

void to_json(JsonValueScope &jv, const td_api::GiveawayInfo &object) {
  td_api::downcast_call(const_cast<td_api::GiveawayInfo &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::giveawayInfoOngoing &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayInfoOngoing");
  jo("creation_date", object.creation_date_);
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  jo("is_ended", JsonBool{object.is_ended_});
}

void to_json(JsonValueScope &jv, const td_api::giveawayInfoCompleted &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayInfoCompleted");
  jo("creation_date", object.creation_date_);
  jo("actual_winners_selection_date", object.actual_winners_selection_date_);
  jo("was_refunded", JsonBool{object.was_refunded_});
  jo("is_winner", JsonBool{object.is_winner_});
  jo("winner_count", object.winner_count_);
  jo("activation_count", object.activation_count_);
  jo("gift_code", object.gift_code_);
  jo("won_star_count", object.won_star_count_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallParticipant &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallParticipant");
  if (object.participant_id_) {
    jo("participant_id", ToJson(*object.participant_id_));
  }
  jo("audio_source_id", object.audio_source_id_);
  jo("screen_sharing_audio_source_id", object.screen_sharing_audio_source_id_);
  if (object.video_info_) {
    jo("video_info", ToJson(*object.video_info_));
  }
  if (object.screen_sharing_video_info_) {
    jo("screen_sharing_video_info", ToJson(*object.screen_sharing_video_info_));
  }
  jo("bio", object.bio_);
  jo("is_current_user", JsonBool{object.is_current_user_});
  jo("is_speaking", JsonBool{object.is_speaking_});
  jo("is_hand_raised", JsonBool{object.is_hand_raised_});
  jo("can_be_muted_for_all_users", JsonBool{object.can_be_muted_for_all_users_});
  jo("can_be_unmuted_for_all_users", JsonBool{object.can_be_unmuted_for_all_users_});
  jo("can_be_muted_for_current_user", JsonBool{object.can_be_muted_for_current_user_});
  jo("can_be_unmuted_for_current_user", JsonBool{object.can_be_unmuted_for_current_user_});
  jo("is_muted_for_all_users", JsonBool{object.is_muted_for_all_users_});
  jo("is_muted_for_current_user", JsonBool{object.is_muted_for_current_user_});
  jo("can_unmute_self", JsonBool{object.can_unmute_self_});
  jo("volume_level", object.volume_level_);
  jo("order", object.order_);
}

void to_json(JsonValueScope &jv, const td_api::identityDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "identityDocument");
  jo("number", object.number_);
  if (object.expiration_date_) {
    jo("expiration_date", ToJson(*object.expiration_date_));
  }
  if (object.front_side_) {
    jo("front_side", ToJson(*object.front_side_));
  }
  if (object.reverse_side_) {
    jo("reverse_side", ToJson(*object.reverse_side_));
  }
  if (object.selfie_) {
    jo("selfie", ToJson(*object.selfie_));
  }
  jo("translation", ToJson(object.translation_));
}

void to_json(JsonValueScope &jv, const td_api::inputChecklistTask &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputChecklistTask");
  jo("id", object.id_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
}

void to_json(JsonValueScope &jv, const td_api::InternalLinkType &object) {
  td_api::downcast_call(const_cast<td_api::InternalLinkType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeActiveSessions &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeActiveSessions");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeAttachmentMenuBot &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeAttachmentMenuBot");
  if (object.target_chat_) {
    jo("target_chat", ToJson(*object.target_chat_));
  }
  jo("bot_username", object.bot_username_);
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeAuthenticationCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeAuthenticationCode");
  jo("code", object.code_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBackground");
  jo("background_name", object.background_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBotAddToChannel &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBotAddToChannel");
  jo("bot_username", object.bot_username_);
  if (object.administrator_rights_) {
    jo("administrator_rights", ToJson(*object.administrator_rights_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBotStart &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBotStart");
  jo("bot_username", object.bot_username_);
  jo("start_parameter", object.start_parameter_);
  jo("autostart", JsonBool{object.autostart_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBotStartInGroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBotStartInGroup");
  jo("bot_username", object.bot_username_);
  jo("start_parameter", object.start_parameter_);
  if (object.administrator_rights_) {
    jo("administrator_rights", ToJson(*object.administrator_rights_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBusinessChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBusinessChat");
  jo("link_name", object.link_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeBuyStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeBuyStars");
  jo("star_count", object.star_count_);
  jo("purpose", object.purpose_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChangePhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChangePhoneNumber");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatAffiliateProgram &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatAffiliateProgram");
  jo("username", object.username_);
  jo("referrer", object.referrer_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatBoost");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatFolderInvite &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatFolderInvite");
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatFolderSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatFolderSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeChatInvite &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeChatInvite");
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeDefaultMessageAutoDeleteTimerSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeDefaultMessageAutoDeleteTimerSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeDirectMessagesChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeDirectMessagesChat");
  jo("channel_username", object.channel_username_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeEditProfileSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeEditProfileSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeGame");
  jo("bot_username", object.bot_username_);
  jo("game_short_name", object.game_short_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeGiftAuction &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeGiftAuction");
  jo("auction_id", object.auction_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeGiftCollection &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeGiftCollection");
  jo("gift_owner_username", object.gift_owner_username_);
  jo("collection_id", object.collection_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeGroupCall &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeGroupCall");
  jo("invite_link", object.invite_link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeInstantView &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeInstantView");
  jo("url", object.url_);
  jo("fallback_url", object.fallback_url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeInvoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeInvoice");
  jo("invoice_name", object.invoice_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLanguagePack &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLanguagePack");
  jo("language_pack_id", object.language_pack_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLanguageSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLanguageSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLiveStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLiveStory");
  jo("story_poster_username", object.story_poster_username_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeLoginEmailSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeLoginEmailSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMainWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMainWebApp");
  jo("bot_username", object.bot_username_);
  jo("start_parameter", object.start_parameter_);
  if (object.mode_) {
    jo("mode", ToJson(*object.mode_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMessage");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMessageDraft &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMessageDraft");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("contains_link", JsonBool{object.contains_link_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMyStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMyStars");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeMyToncoins &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeMyToncoins");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePassportDataRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePassportDataRequest");
  jo("bot_user_id", object.bot_user_id_);
  jo("scope", object.scope_);
  jo("public_key", object.public_key_);
  jo("nonce", object.nonce_);
  jo("callback_url", object.callback_url_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePasswordSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePasswordSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePhoneNumberConfirmation &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePhoneNumberConfirmation");
  jo("hash", object.hash_);
  jo("phone_number", object.phone_number_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePhoneNumberPrivacySettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePhoneNumberPrivacySettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePremiumFeatures &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePremiumFeatures");
  jo("referrer", object.referrer_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePremiumGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePremiumGift");
  jo("referrer", object.referrer_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePremiumGiftCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePremiumGiftCode");
  jo("code", object.code_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePrivacyAndSecuritySettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePrivacyAndSecuritySettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeProxy &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeProxy");
  jo("server", object.server_);
  jo("port", object.port_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypePublicChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypePublicChat");
  jo("chat_username", object.chat_username_);
  jo("draft_text", object.draft_text_);
  jo("open_profile", JsonBool{object.open_profile_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeQrCodeAuthentication &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeQrCodeAuthentication");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeRestorePurchases &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeRestorePurchases");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeStickerSet &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeStickerSet");
  jo("sticker_set_name", object.sticker_set_name_);
  jo("expect_custom_emoji", JsonBool{object.expect_custom_emoji_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeStory");
  jo("story_poster_username", object.story_poster_username_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeStoryAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeStoryAlbum");
  jo("story_album_owner_username", object.story_album_owner_username_);
  jo("story_album_id", object.story_album_id_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeTheme");
  jo("theme_name", object.theme_name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeThemeSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeThemeSettings");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUnknownDeepLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUnknownDeepLink");
  jo("link", object.link_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUnsupportedProxy &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUnsupportedProxy");
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUpgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUpgradedGift");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUserPhoneNumber &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUserPhoneNumber");
  jo("phone_number", object.phone_number_);
  jo("draft_text", object.draft_text_);
  jo("open_profile", JsonBool{object.open_profile_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeUserToken &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeUserToken");
  jo("token", object.token_);
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeVideoChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeVideoChat");
  jo("chat_username", object.chat_username_);
  jo("invite_hash", object.invite_hash_);
  jo("is_live_stream", JsonBool{object.is_live_stream_});
}

void to_json(JsonValueScope &jv, const td_api::internalLinkTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "internalLinkTypeWebApp");
  jo("bot_username", object.bot_username_);
  jo("web_app_short_name", object.web_app_short_name_);
  jo("start_parameter", object.start_parameter_);
  if (object.mode_) {
    jo("mode", ToJson(*object.mode_));
  }
}

void to_json(JsonValueScope &jv, const td_api::languagePackInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackInfo");
  jo("id", object.id_);
  jo("base_language_pack_id", object.base_language_pack_id_);
  jo("name", object.name_);
  jo("native_name", object.native_name_);
  jo("plural_code", object.plural_code_);
  jo("is_official", JsonBool{object.is_official_});
  jo("is_rtl", JsonBool{object.is_rtl_});
  jo("is_beta", JsonBool{object.is_beta_});
  jo("is_installed", JsonBool{object.is_installed_});
  jo("total_string_count", object.total_string_count_);
  jo("translated_string_count", object.translated_string_count_);
  jo("local_string_count", object.local_string_count_);
  jo("translation_url", object.translation_url_);
}

void to_json(JsonValueScope &jv, const td_api::localFile &object) {
  auto jo = jv.enter_object();
  jo("@type", "localFile");
  jo("path", object.path_);
  jo("can_be_downloaded", JsonBool{object.can_be_downloaded_});
  jo("can_be_deleted", JsonBool{object.can_be_deleted_});
  jo("is_downloading_active", JsonBool{object.is_downloading_active_});
  jo("is_downloading_completed", JsonBool{object.is_downloading_completed_});
  jo("download_offset", object.download_offset_);
  jo("downloaded_prefix_size", object.downloaded_prefix_size_);
  jo("downloaded_size", object.downloaded_size_);
}

void to_json(JsonValueScope &jv, const td_api::MaskPoint &object) {
  td_api::downcast_call(const_cast<td_api::MaskPoint &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::maskPointForehead &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointForehead");
}

void to_json(JsonValueScope &jv, const td_api::maskPointEyes &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointEyes");
}

void to_json(JsonValueScope &jv, const td_api::maskPointMouth &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointMouth");
}

void to_json(JsonValueScope &jv, const td_api::maskPointChin &object) {
  auto jo = jv.enter_object();
  jo("@type", "maskPointChin");
}

void to_json(JsonValueScope &jv, const td_api::MessageEffectType &object) {
  td_api::downcast_call(const_cast<td_api::MessageEffectType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageEffectTypeEmojiReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageEffectTypeEmojiReaction");
  if (object.select_animation_) {
    jo("select_animation", ToJson(*object.select_animation_));
  }
  if (object.effect_animation_) {
    jo("effect_animation", ToJson(*object.effect_animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messageEffectTypePremiumSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageEffectTypePremiumSticker");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messagePositions &object) {
  auto jo = jv.enter_object();
  jo("@type", "messagePositions");
  jo("total_count", object.total_count_);
  jo("positions", ToJson(object.positions_));
}

void to_json(JsonValueScope &jv, const td_api::MessageSender &object) {
  td_api::downcast_call(const_cast<td_api::MessageSender &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageSenderUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSenderUser");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::messageSenderChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSenderChat");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::minithumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "minithumbnail");
  jo("width", object.width_);
  jo("height", object.height_);
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::notificationSound &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSound");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("duration", object.duration_);
  jo("date", object.date_);
  jo("title", object.title_);
  jo("data", object.data_);
  if (object.sound_) {
    jo("sound", ToJson(*object.sound_));
  }
}

void to_json(JsonValueScope &jv, const td_api::PageBlockHorizontalAlignment &object) {
  td_api::downcast_call(const_cast<td_api::PageBlockHorizontalAlignment &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHorizontalAlignmentLeft &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHorizontalAlignmentLeft");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHorizontalAlignmentCenter &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHorizontalAlignmentCenter");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockHorizontalAlignmentRight &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockHorizontalAlignmentRight");
}

void to_json(JsonValueScope &jv, const td_api::passkeys &object) {
  auto jo = jv.enter_object();
  jo("@type", "passkeys");
  jo("passkeys", ToJson(object.passkeys_));
}

void to_json(JsonValueScope &jv, const td_api::passportSuitableElement &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportSuitableElement");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("is_selfie_required", JsonBool{object.is_selfie_required_});
  jo("is_translation_required", JsonBool{object.is_translation_required_});
  jo("is_native_name_required", JsonBool{object.is_native_name_required_});
}

void to_json(JsonValueScope &jv, const td_api::personalDetails &object) {
  auto jo = jv.enter_object();
  jo("@type", "personalDetails");
  jo("first_name", object.first_name_);
  jo("middle_name", object.middle_name_);
  jo("last_name", object.last_name_);
  jo("native_first_name", object.native_first_name_);
  jo("native_middle_name", object.native_middle_name_);
  jo("native_last_name", object.native_last_name_);
  if (object.birthdate_) {
    jo("birthdate", ToJson(*object.birthdate_));
  }
  jo("gender", object.gender_);
  jo("country_code", object.country_code_);
  jo("residence_country_code", object.residence_country_code_);
}

void to_json(JsonValueScope &jv, const td_api::PremiumFeature &object) {
  td_api::downcast_call(const_cast<td_api::PremiumFeature &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureIncreasedLimits &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureIncreasedLimits");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureIncreasedUploadFileSize &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureIncreasedUploadFileSize");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureImprovedDownloadSpeed &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureImprovedDownloadSpeed");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureVoiceRecognition &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureVoiceRecognition");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureDisabledAds &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureDisabledAds");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureUniqueReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureUniqueReactions");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureUniqueStickers &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureUniqueStickers");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureCustomEmoji");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAdvancedChatManagement &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAdvancedChatManagement");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureProfileBadge &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureProfileBadge");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureEmojiStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureEmojiStatus");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAnimatedProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAnimatedProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureForumTopicIcon &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureForumTopicIcon");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAppIcons &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAppIcons");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureRealTimeChatTranslation &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureRealTimeChatTranslation");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureUpgradedStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureUpgradedStories");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureChatBoost &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureChatBoost");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureAccentColor &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureAccentColor");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureBackgroundForBoth &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureBackgroundForBoth");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureSavedMessagesTags &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureSavedMessagesTags");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureMessagePrivacy &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureMessagePrivacy");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureLastSeenTimes &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureLastSeenTimes");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureBusiness &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureBusiness");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureMessageEffects &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureMessageEffects");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeatureChecklists &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeatureChecklists");
}

void to_json(JsonValueScope &jv, const td_api::premiumFeaturePaidMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumFeaturePaidMessages");
}

void to_json(JsonValueScope &jv, const td_api::PremiumLimitType &object) {
  td_api::downcast_call(const_cast<td_api::PremiumLimitType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeSupergroupCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeSupergroupCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypePinnedChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypePinnedChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeCreatedPublicChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeCreatedPublicChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeSavedAnimationCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeSavedAnimationCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeFavoriteStickerCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeFavoriteStickerCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeChatFolderCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeChatFolderCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeChatFolderChosenChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeChatFolderChosenChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypePinnedArchivedChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypePinnedArchivedChatCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypePinnedSavedMessagesTopicCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypePinnedSavedMessagesTopicCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeCaptionLength &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeCaptionLength");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeBioLength &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeBioLength");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeChatFolderInviteLinkCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeChatFolderInviteLinkCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeShareableChatFolderCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeShareableChatFolderCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeActiveStoryCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeActiveStoryCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeWeeklyPostedStoryCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeWeeklyPostedStoryCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeMonthlyPostedStoryCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeMonthlyPostedStoryCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeStoryCaptionLength &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeStoryCaptionLength");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeStorySuggestedReactionAreaCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeStorySuggestedReactionAreaCount");
}

void to_json(JsonValueScope &jv, const td_api::premiumLimitTypeSimilarChatCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimitTypeSimilarChatCount");
}

void to_json(JsonValueScope &jv, const td_api::profileAccentColors &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileAccentColors");
  jo("palette_colors", ToJson(object.palette_colors_));
  jo("background_colors", ToJson(object.background_colors_));
  jo("story_colors", ToJson(object.story_colors_));
}

void to_json(JsonValueScope &jv, const td_api::PushMessageContent &object) {
  td_api::downcast_call(const_cast<td_api::PushMessageContent &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentHidden &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentHidden");
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentAnimation &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentAnimation");
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
  jo("caption", object.caption_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentAudio &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentAudio");
  if (object.audio_) {
    jo("audio", ToJson(*object.audio_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentContact &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentContact");
  jo("name", object.name_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentContactRegistered &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentContactRegistered");
  jo("as_premium_account", JsonBool{object.as_premium_account_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentDocument &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentDocument");
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGame");
  jo("title", object.title_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGameScore &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGameScore");
  jo("title", object.title_);
  jo("score", object.score_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentInvoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentInvoice");
  jo("price", object.price_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentLocation &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentLocation");
  jo("is_live", JsonBool{object.is_live_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPaidMedia &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPaidMedia");
  jo("star_count", object.star_count_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPhoto");
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("caption", object.caption_);
  jo("is_secret", JsonBool{object.is_secret_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPoll &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPoll");
  jo("question", object.question_);
  jo("is_regular", JsonBool{object.is_regular_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentPremiumGiftCode &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentPremiumGiftCode");
  jo("month_count", object.month_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGiveaway &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGiveaway");
  jo("winner_count", object.winner_count_);
  if (object.prize_) {
    jo("prize", ToJson(*object.prize_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentGift");
  jo("star_count", object.star_count_);
  jo("is_prepaid_upgrade", JsonBool{object.is_prepaid_upgrade_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentUpgradedGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentUpgradedGift");
  jo("is_upgrade", JsonBool{object.is_upgrade_});
  jo("is_prepaid_upgrade", JsonBool{object.is_prepaid_upgrade_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentScreenshotTaken &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentScreenshotTaken");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentSticker &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentSticker");
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  jo("emoji", object.emoji_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentStory");
  jo("is_mention", JsonBool{object.is_mention_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentText &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentText");
  jo("text", object.text_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChecklist &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChecklist");
  jo("title", object.title_);
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideo");
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
  jo("caption", object.caption_);
  jo("is_secret", JsonBool{object.is_secret_});
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideoNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideoNote");
  if (object.video_note_) {
    jo("video_note", ToJson(*object.video_note_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVoiceNote &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVoiceNote");
  if (object.voice_note_) {
    jo("voice_note", ToJson(*object.voice_note_));
  }
  jo("is_pinned", JsonBool{object.is_pinned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentBasicGroupChatCreate &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentBasicGroupChatCreate");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideoChatStarted &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideoChatStarted");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentVideoChatEnded &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentVideoChatEnded");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentInviteVideoChatParticipants &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentInviteVideoChatParticipants");
  jo("is_current_user", JsonBool{object.is_current_user_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatAddMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatAddMembers");
  jo("member_name", object.member_name_);
  jo("is_current_user", JsonBool{object.is_current_user_});
  jo("is_returned", JsonBool{object.is_returned_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatChangePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatChangePhoto");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatChangeTitle &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatChangeTitle");
  jo("title", object.title_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatSetBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatSetBackground");
  jo("is_same", JsonBool{object.is_same_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatSetTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatSetTheme");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatDeleteMember &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatDeleteMember");
  jo("member_name", object.member_name_);
  jo("is_current_user", JsonBool{object.is_current_user_});
  jo("is_left", JsonBool{object.is_left_});
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatJoinByLink &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatJoinByLink");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChatJoinByRequest &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChatJoinByRequest");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentRecurringPayment &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentRecurringPayment");
  jo("amount", object.amount_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentSuggestProfilePhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentSuggestProfilePhoto");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentSuggestBirthdate &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentSuggestBirthdate");
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentProximityAlertTriggered &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentProximityAlertTriggered");
  jo("distance", object.distance_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChecklistTasksAdded &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChecklistTasksAdded");
  jo("task_count", object.task_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentChecklistTasksDone &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentChecklistTasksDone");
  jo("task_count", object.task_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentMessageForwards &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentMessageForwards");
  jo("total_count", object.total_count_);
}

void to_json(JsonValueScope &jv, const td_api::pushMessageContentMediaAlbum &object) {
  auto jo = jv.enter_object();
  jo("@type", "pushMessageContentMediaAlbum");
  jo("total_count", object.total_count_);
  jo("has_photos", JsonBool{object.has_photos_});
  jo("has_videos", JsonBool{object.has_videos_});
  jo("has_audios", JsonBool{object.has_audios_});
  jo("has_documents", JsonBool{object.has_documents_});
}

void to_json(JsonValueScope &jv, const td_api::readDatePrivacySettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "readDatePrivacySettings");
  jo("show_read_date", JsonBool{object.show_read_date_});
}

void to_json(JsonValueScope &jv, const td_api::reportOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportOption");
  jo("id", base64_encode(object.id_));
  jo("text", object.text_);
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTag &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTag");
  if (object.tag_) {
    jo("tag", ToJson(*object.tag_));
  }
  jo("label", object.label_);
  jo("count", object.count_);
}

void to_json(JsonValueScope &jv, const td_api::SentGift &object) {
  td_api::downcast_call(const_cast<td_api::SentGift &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::sentGiftRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "sentGiftRegular");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::sentGiftUpgraded &object) {
  auto jo = jv.enter_object();
  jo("@type", "sentGiftUpgraded");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::sponsoredChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "sponsoredChat");
  jo("unique_id", object.unique_id_);
  jo("chat_id", object.chat_id_);
  jo("sponsor_info", object.sponsor_info_);
  jo("additional_info", object.additional_info_);
}

void to_json(JsonValueScope &jv, const td_api::starGiveawayWinnerOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "starGiveawayWinnerOption");
  jo("winner_count", object.winner_count_);
  jo("won_star_count", object.won_star_count_);
  jo("is_default", JsonBool{object.is_default_});
}

void to_json(JsonValueScope &jv, const td_api::starTransaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "starTransaction");
  jo("id", object.id_);
  if (object.star_amount_) {
    jo("star_amount", ToJson(*object.star_amount_));
  }
  jo("is_refund", JsonBool{object.is_refund_});
  jo("date", object.date_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::stickerSet &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerSet");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("title", object.title_);
  jo("name", object.name_);
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.thumbnail_outline_) {
    jo("thumbnail_outline", ToJson(*object.thumbnail_outline_));
  }
  jo("is_owned", JsonBool{object.is_owned_});
  jo("is_installed", JsonBool{object.is_installed_});
  jo("is_archived", JsonBool{object.is_archived_});
  jo("is_official", JsonBool{object.is_official_});
  if (object.sticker_type_) {
    jo("sticker_type", ToJson(*object.sticker_type_));
  }
  jo("needs_repainting", JsonBool{object.needs_repainting_});
  jo("is_allowed_as_chat_emoji_status", JsonBool{object.is_allowed_as_chat_emoji_status_});
  jo("is_viewed", JsonBool{object.is_viewed_});
  jo("stickers", ToJson(object.stickers_));
  jo("emojis", ToJson(object.emojis_));
}

void to_json(JsonValueScope &jv, const td_api::stories &object) {
  auto jo = jv.enter_object();
  jo("@type", "stories");
  jo("total_count", object.total_count_);
  jo("stories", ToJson(object.stories_));
  jo("pinned_story_ids", ToJson(object.pinned_story_ids_));
}

void to_json(JsonValueScope &jv, const td_api::storyInteraction &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteraction");
  if (object.actor_id_) {
    jo("actor_id", ToJson(*object.actor_id_));
  }
  jo("interaction_date", object.interaction_date_);
  if (object.block_list_) {
    jo("block_list", ToJson(*object.block_list_));
  }
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::storyVideo &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyVideo");
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
  jo("has_stickers", JsonBool{object.has_stickers_});
  jo("is_animation", JsonBool{object.is_animation_});
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("preload_prefix_size", object.preload_prefix_size_);
  jo("cover_frame_timestamp", object.cover_frame_timestamp_);
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
}

void to_json(JsonValueScope &jv, const td_api::TMeUrlType &object) {
  td_api::downcast_call(const_cast<td_api::TMeUrlType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::tMeUrlTypeUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "tMeUrlTypeUser");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::tMeUrlTypeSupergroup &object) {
  auto jo = jv.enter_object();
  jo("@type", "tMeUrlTypeSupergroup");
  jo("supergroup_id", object.supergroup_id_);
}

void to_json(JsonValueScope &jv, const td_api::tMeUrlTypeChatInvite &object) {
  auto jo = jv.enter_object();
  jo("@type", "tMeUrlTypeChatInvite");
  if (object.info_) {
    jo("info", ToJson(*object.info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::tMeUrlTypeStickerSet &object) {
  auto jo = jv.enter_object();
  jo("@type", "tMeUrlTypeStickerSet");
  jo("sticker_set_id", ToJson(JsonInt64{object.sticker_set_id_}));
}

void to_json(JsonValueScope &jv, const td_api::testVectorInt &object) {
  auto jo = jv.enter_object();
  jo("@type", "testVectorInt");
  jo("value", ToJson(object.value_));
}

void to_json(JsonValueScope &jv, const td_api::themeSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "themeSettings");
  if (object.base_theme_) {
    jo("base_theme", ToJson(*object.base_theme_));
  }
  jo("accent_color", object.accent_color_);
  if (object.background_) {
    jo("background", ToJson(*object.background_));
  }
  if (object.outgoing_message_fill_) {
    jo("outgoing_message_fill", ToJson(*object.outgoing_message_fill_));
  }
  jo("animate_outgoing_message_fill", JsonBool{object.animate_outgoing_message_fill_});
  jo("outgoing_message_accent_color", object.outgoing_message_accent_color_);
}

void to_json(JsonValueScope &jv, const td_api::tonTransactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactions");
  jo("ton_amount", object.ton_amount_);
  jo("transactions", ToJson(object.transactions_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftBackdropColors &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftBackdropColors");
  jo("center_color", object.center_color_);
  jo("edge_color", object.edge_color_);
  jo("symbol_color", object.symbol_color_);
  jo("text_color", object.text_color_);
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftValueInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftValueInfo");
  jo("currency", object.currency_);
  jo("value", object.value_);
  jo("is_value_average", JsonBool{object.is_value_average_});
  jo("initial_sale_date", object.initial_sale_date_);
  jo("initial_sale_star_count", object.initial_sale_star_count_);
  jo("initial_sale_price", object.initial_sale_price_);
  jo("last_sale_date", object.last_sale_date_);
  jo("last_sale_price", object.last_sale_price_);
  jo("is_last_sale_on_fragment", JsonBool{object.is_last_sale_on_fragment_});
  jo("minimum_price", object.minimum_price_);
  jo("average_sale_price", object.average_sale_price_);
  jo("telegram_listed_gift_count", object.telegram_listed_gift_count_);
  jo("fragment_listed_gift_count", object.fragment_listed_gift_count_);
  jo("fragment_url", object.fragment_url_);
}

void to_json(JsonValueScope &jv, const td_api::UserStatus &object) {
  td_api::downcast_call(const_cast<td_api::UserStatus &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::userStatusEmpty &object) {
  auto jo = jv.enter_object();
  jo("@type", "userStatusEmpty");
}

void to_json(JsonValueScope &jv, const td_api::userStatusOnline &object) {
  auto jo = jv.enter_object();
  jo("@type", "userStatusOnline");
  jo("expires", object.expires_);
}

void to_json(JsonValueScope &jv, const td_api::userStatusOffline &object) {
  auto jo = jv.enter_object();
  jo("@type", "userStatusOffline");
  jo("was_online", object.was_online_);
}

void to_json(JsonValueScope &jv, const td_api::userStatusRecently &object) {
  auto jo = jv.enter_object();
  jo("@type", "userStatusRecently");
  jo("by_my_privacy_settings", JsonBool{object.by_my_privacy_settings_});
}

void to_json(JsonValueScope &jv, const td_api::userStatusLastWeek &object) {
  auto jo = jv.enter_object();
  jo("@type", "userStatusLastWeek");
  jo("by_my_privacy_settings", JsonBool{object.by_my_privacy_settings_});
}

void to_json(JsonValueScope &jv, const td_api::userStatusLastMonth &object) {
  auto jo = jv.enter_object();
  jo("@type", "userStatusLastMonth");
  jo("by_my_privacy_settings", JsonBool{object.by_my_privacy_settings_});
}

void to_json(JsonValueScope &jv, const td_api::video &object) {
  auto jo = jv.enter_object();
  jo("@type", "video");
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
  jo("file_name", object.file_name_);
  jo("mime_type", object.mime_type_);
  jo("has_stickers", JsonBool{object.has_stickers_});
  jo("supports_streaming", JsonBool{object.supports_streaming_});
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.video_) {
    jo("video", ToJson(*object.video_));
  }
}

void to_json(JsonValueScope &jv, const td_api::WebAppOpenMode &object) {
  td_api::downcast_call(const_cast<td_api::WebAppOpenMode &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::webAppOpenModeCompact &object) {
  auto jo = jv.enter_object();
  jo("@type", "webAppOpenModeCompact");
}

void to_json(JsonValueScope &jv, const td_api::webAppOpenModeFullSize &object) {
  auto jo = jv.enter_object();
  jo("@type", "webAppOpenModeFullSize");
}

void to_json(JsonValueScope &jv, const td_api::webAppOpenModeFullScreen &object) {
  auto jo = jv.enter_object();
  jo("@type", "webAppOpenModeFullScreen");
}

}  // namespace td_api
}  // namespace td
