#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::AutosaveSettingsScope *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"autosaveSettingsScopePrivateChats", 1395227007},
    {"autosaveSettingsScopeGroupChats", 853544526},
    {"autosaveSettingsScopeChannelChats", -499572783},
    {"autosaveSettingsScopeChat", -1632255255}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatAction *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatActionTyping", 380122167},
    {"chatActionRecordingVideo", 216553362},
    {"chatActionUploadingVideo", 1234185270},
    {"chatActionRecordingVoiceNote", -808850058},
    {"chatActionUploadingVoiceNote", -613643666},
    {"chatActionUploadingPhoto", 654240583},
    {"chatActionUploadingDocument", 167884362},
    {"chatActionChoosingSticker", 372753697},
    {"chatActionChoosingLocation", -2017893596},
    {"chatActionChoosingContact", -1222507496},
    {"chatActionStartPlayingGame", -865884164},
    {"chatActionRecordingVideoNote", 16523393},
    {"chatActionUploadingVideoNote", 1172364918},
    {"chatActionWatchingAnimations", 2052990641},
    {"chatActionCancel", 1160523958}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::EmojiCategoryType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"emojiCategoryTypeDefault", 1188782699},
    {"emojiCategoryTypeRegularStickers", -1337484846},
    {"emojiCategoryTypeEmojiStatus", 1381282631},
    {"emojiCategoryTypeChatPhoto", 1059063081}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InlineQueryResultsButtonType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inlineQueryResultsButtonTypeStartBot", -23400235},
    {"inlineQueryResultsButtonTypeWebApp", -1197382814}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputMessageContent *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputMessageText", -212805484},
    {"inputMessageAnimation", -210404059},
    {"inputMessageAudio", -626786126},
    {"inputMessageDocument", 1633383097},
    {"inputMessagePaidMedia", -1274819374},
    {"inputMessagePhoto", -810129442},
    {"inputMessageSticker", 1072805625},
    {"inputMessageVideo", -605958271},
    {"inputMessageVideoNote", -714598691},
    {"inputMessageVoiceNote", 1461977004},
    {"inputMessageLocation", 648735088},
    {"inputMessageVenue", 1447926269},
    {"inputMessageContact", -982446849},
    {"inputMessageDice", 841574313},
    {"inputMessageGame", 1252944610},
    {"inputMessageInvoice", -1162047631},
    {"inputMessagePoll", -263337164},
    {"inputMessageStakeDice", 1946603673},
    {"inputMessageStory", -370732053},
    {"inputMessageChecklist", -1722965261},
    {"inputMessageForwarded", -1076506316}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::KeyboardButtonType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"keyboardButtonTypeText", -1773037256},
    {"keyboardButtonTypeRequestPhoneNumber", -1529235527},
    {"keyboardButtonTypeRequestLocation", -125661955},
    {"keyboardButtonTypeRequestPoll", 1902435512},
    {"keyboardButtonTypeRequestUsers", -1738765315},
    {"keyboardButtonTypeRequestChat", 1511138485},
    {"keyboardButtonTypeWebApp", 1892220770}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::NetworkStatisticsEntry *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"networkStatisticsEntryFile", 188452706},
    {"networkStatisticsEntryCall", 737000365}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PremiumLimitType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"premiumLimitTypeSupergroupCount", -247467131},
    {"premiumLimitTypePinnedChatCount", -998947871},
    {"premiumLimitTypeCreatedPublicChatCount", 446086841},
    {"premiumLimitTypeSavedAnimationCount", -19759735},
    {"premiumLimitTypeFavoriteStickerCount", 639754787},
    {"premiumLimitTypeChatFolderCount", 377489774},
    {"premiumLimitTypeChatFolderChosenChatCount", 1691435861},
    {"premiumLimitTypePinnedArchivedChatCount", 1485515276},
    {"premiumLimitTypePinnedSavedMessagesTopicCount", -1544854305},
    {"premiumLimitTypeCaptionLength", 293984314},
    {"premiumLimitTypeBioLength", -1146976765},
    {"premiumLimitTypeChatFolderInviteLinkCount", -128702950},
    {"premiumLimitTypeShareableChatFolderCount", 1612625095},
    {"premiumLimitTypeActiveStoryCount", -1926486372},
    {"premiumLimitTypeWeeklyPostedStoryCount", -506354313},
    {"premiumLimitTypeMonthlyPostedStoryCount", 26329490},
    {"premiumLimitTypeStoryCaptionLength", -1093324030},
    {"premiumLimitTypeStorySuggestedReactionAreaCount", -1170032633},
    {"premiumLimitTypeSimilarChatCount", -1563549935}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ReportReason *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"reportReasonSpam", -1207032897},
    {"reportReasonViolence", 2038679353},
    {"reportReasonPornography", 1306467575},
    {"reportReasonChildAbuse", 761086718},
    {"reportReasonCopyright", 1474441135},
    {"reportReasonUnrelatedLocation", 87562288},
    {"reportReasonFake", 352862176},
    {"reportReasonIllegalDrugs", -61599200},
    {"reportReasonPersonalDetails", -1588882414},
    {"reportReasonCustom", -1380459917}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::StoryPrivacySettings *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"storyPrivacySettingsEveryone", 890847843},
    {"storyPrivacySettingsContacts", 50285309},
    {"storyPrivacySettingsCloseFriends", 2097122144},
    {"storyPrivacySettingsSelectedUsers", -1885772602}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::TransactionDirection *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"transactionDirectionIncoming", -271074103},
    {"transactionDirectionOutgoing", 1638241254}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::affiliateProgramSortOrderProfitability &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::autosaveSettingsScopeGroupChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::backgroundTypeChatTheme &to, JsonObject &from) {
  TRY_STATUS(from_json(to.theme_name_, from.extract_field("theme_name")));
  return Status::OK();
}

Status from_json(td_api::botCommandScopeChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::businessConnectedBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.recipients_, from.extract_field("recipients")));
  TRY_STATUS(from_json(to.rights_, from.extract_field("rights")));
  return Status::OK();
}

Status from_json(td_api::businessFeatureEmojiStatus &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callProblemNoise &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::callbackQueryPayloadData &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::chatActionUploadingDocument &to, JsonObject &from) {
  TRY_STATUS(from_json(to.progress_, from.extract_field("progress")));
  return Status::OK();
}

Status from_json(td_api::chatAdministratorRights &to, JsonObject &from) {
  TRY_STATUS(from_json(to.can_manage_chat_, from.extract_field("can_manage_chat")));
  TRY_STATUS(from_json(to.can_change_info_, from.extract_field("can_change_info")));
  TRY_STATUS(from_json(to.can_post_messages_, from.extract_field("can_post_messages")));
  TRY_STATUS(from_json(to.can_edit_messages_, from.extract_field("can_edit_messages")));
  TRY_STATUS(from_json(to.can_delete_messages_, from.extract_field("can_delete_messages")));
  TRY_STATUS(from_json(to.can_invite_users_, from.extract_field("can_invite_users")));
  TRY_STATUS(from_json(to.can_restrict_members_, from.extract_field("can_restrict_members")));
  TRY_STATUS(from_json(to.can_pin_messages_, from.extract_field("can_pin_messages")));
  TRY_STATUS(from_json(to.can_manage_topics_, from.extract_field("can_manage_topics")));
  TRY_STATUS(from_json(to.can_promote_members_, from.extract_field("can_promote_members")));
  TRY_STATUS(from_json(to.can_manage_video_chats_, from.extract_field("can_manage_video_chats")));
  TRY_STATUS(from_json(to.can_post_stories_, from.extract_field("can_post_stories")));
  TRY_STATUS(from_json(to.can_edit_stories_, from.extract_field("can_edit_stories")));
  TRY_STATUS(from_json(to.can_delete_stories_, from.extract_field("can_delete_stories")));
  TRY_STATUS(from_json(to.can_manage_direct_messages_, from.extract_field("can_manage_direct_messages")));
  TRY_STATUS(from_json(to.is_anonymous_, from.extract_field("is_anonymous")));
  return Status::OK();
}

Status from_json(td_api::chatListMain &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatMemberStatusBanned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.banned_until_date_, from.extract_field("banned_until_date")));
  return Status::OK();
}

Status from_json(td_api::chatPermissions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.can_send_basic_messages_, from.extract_field("can_send_basic_messages")));
  TRY_STATUS(from_json(to.can_send_audios_, from.extract_field("can_send_audios")));
  TRY_STATUS(from_json(to.can_send_documents_, from.extract_field("can_send_documents")));
  TRY_STATUS(from_json(to.can_send_photos_, from.extract_field("can_send_photos")));
  TRY_STATUS(from_json(to.can_send_videos_, from.extract_field("can_send_videos")));
  TRY_STATUS(from_json(to.can_send_video_notes_, from.extract_field("can_send_video_notes")));
  TRY_STATUS(from_json(to.can_send_voice_notes_, from.extract_field("can_send_voice_notes")));
  TRY_STATUS(from_json(to.can_send_polls_, from.extract_field("can_send_polls")));
  TRY_STATUS(from_json(to.can_send_other_messages_, from.extract_field("can_send_other_messages")));
  TRY_STATUS(from_json(to.can_add_link_previews_, from.extract_field("can_add_link_previews")));
  TRY_STATUS(from_json(to.can_change_info_, from.extract_field("can_change_info")));
  TRY_STATUS(from_json(to.can_invite_users_, from.extract_field("can_invite_users")));
  TRY_STATUS(from_json(to.can_pin_messages_, from.extract_field("can_pin_messages")));
  TRY_STATUS(from_json(to.can_create_topics_, from.extract_field("can_create_topics")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenApplePush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.device_token_, from.extract_field("device_token")));
  TRY_STATUS(from_json(to.is_app_sandbox_, from.extract_field("is_app_sandbox")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenTizenPush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reg_id_, from.extract_field("reg_id")));
  return Status::OK();
}

Status from_json(td_api::emojiCategoryTypeChatPhoto &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeNotificationSound &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeSelfDestructingVideoNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeWallpaper &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::giftResalePriceTon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.toncoin_cent_count_, from.extract_field("toncoin_cent_count")));
  return Status::OK();
}

Status from_json(td_api::importedContact &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.first_name_, from.extract_field("first_name")));
  TRY_STATUS(from_json(to.last_name_, from.extract_field("last_name")));
  TRY_STATUS(from_json(to.note_, from.extract_field("note")));
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeBuy &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::inputBusinessChatLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::inputChecklistTask &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::inputGroupCallLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultLocation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.live_period_, from.extract_field("live_period")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.thumbnail_url_, from.extract_field("thumbnail_url")));
  TRY_STATUS(from_json(to.thumbnail_width_, from.extract_field("thumbnail_width")));
  TRY_STATUS(from_json(to.thumbnail_height_, from.extract_field("thumbnail_height")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessageText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.link_preview_options_, from.extract_field("link_preview_options")));
  TRY_STATUS(from_json(to.clear_draft_, from.extract_field("clear_draft")));
  return Status::OK();
}

Status from_json(td_api::inputMessageVoiceNote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.voice_note_, from.extract_field("voice_note")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json_bytes(to.waveform_, from.extract_field("waveform")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.self_destruct_type_, from.extract_field("self_destruct_type")));
  return Status::OK();
}

Status from_json(td_api::inputMessageStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementPersonalDetails &to, JsonObject &from) {
  TRY_STATUS(from_json(to.personal_details_, from.extract_field("personal_details")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementPassportRegistration &to, JsonObject &from) {
  TRY_STATUS(from_json(to.passport_registration_, from.extract_field("passport_registration")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceSelfie &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.file_hash_, from.extract_field("file_hash")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeFoundVenue &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_id_, from.extract_field("query_id")));
  TRY_STATUS(from_json(to.result_id_, from.extract_field("result_id")));
  return Status::OK();
}

Status from_json(td_api::inputStoryContentVideo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.video_, from.extract_field("video")));
  TRY_STATUS(from_json(to.added_sticker_file_ids_, from.extract_field("added_sticker_file_ids")));
  TRY_STATUS(from_json(to.duration_, from.extract_field("duration")));
  TRY_STATUS(from_json(to.cover_frame_timestamp_, from.extract_field("cover_frame_timestamp")));
  TRY_STATUS(from_json(to.is_animation_, from.extract_field("is_animation")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeBotStart &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.start_parameter_, from.extract_field("start_parameter")));
  TRY_STATUS(from_json(to.autostart_, from.extract_field("autostart")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeChatInvite &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeInvoice &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invoice_name_, from.extract_field("invoice_name")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeMyToncoins &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeProxy &to, JsonObject &from) {
  TRY_STATUS(from_json(to.server_, from.extract_field("server")));
  TRY_STATUS(from_json(to.port_, from.extract_field("port")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeThemeSettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::jsonObjectMember &to, JsonObject &from) {
  TRY_STATUS(from_json(to.key_, from.extract_field("key")));
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeRequestPhoneNumber &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::languagePackStringValueOrdinary &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::maskPointForehead &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageSchedulingStateSendWhenVideoProcessed &to, JsonObject &from) {
  TRY_STATUS(from_json(to.send_date_, from.extract_field("send_date")));
  return Status::OK();
}

Status from_json(td_api::messageSourceDirectMessagesChatTopicHistory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::messageTopicForum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  return Status::OK();
}

Status from_json(td_api::networkTypeOther &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::orderInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  TRY_STATUS(from_json(to.email_address_, from.extract_field("email_address")));
  TRY_STATUS(from_json(to.shipping_address_, from.extract_field("shipping_address")));
  return Status::OK();
}

Status from_json(td_api::passportElementTypeAddress &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::phoneNumberAuthenticationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.allow_flash_call_, from.extract_field("allow_flash_call")));
  TRY_STATUS(from_json(to.allow_missed_call_, from.extract_field("allow_missed_call")));
  TRY_STATUS(from_json(to.is_current_phone_number_, from.extract_field("is_current_phone_number")));
  TRY_STATUS(from_json(to.has_unknown_phone_number_, from.extract_field("has_unknown_phone_number")));
  TRY_STATUS(from_json(to.allow_sms_retriever_api_, from.extract_field("allow_sms_retriever_api")));
  TRY_STATUS(from_json(to.firebase_authentication_settings_, from.extract_field("firebase_authentication_settings")));
  TRY_STATUS(from_json(to.authentication_tokens_, from.extract_field("authentication_tokens")));
  return Status::OK();
}

Status from_json(td_api::premiumFeatureVoiceRecognition &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureForumTopicIcon &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureLastSeenTimes &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeFavoriteStickerCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeActiveStoryCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumSourceStoryFeature &to, JsonObject &from) {
  TRY_STATUS(from_json(to.feature_, from.extract_field("feature")));
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeatureVideoQuality &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::proxyTypeSocks5 &to, JsonObject &from) {
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::reactionTypeEmoji &to, JsonObject &from) {
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  return Status::OK();
}

Status from_json(td_api::reportReasonViolence &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::resendCodeReasonUserRequest &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterAudio &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterVoiceAndVideoNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::stickerFormatTgs &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::storePaymentPurposeStarGiveaway &to, JsonObject &from) {
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  TRY_STATUS(from_json(to.winner_count_, from.extract_field("winner_count")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::storyPrivacySettingsEveryone &to, JsonObject &from) {
  TRY_STATUS(from_json(to.except_user_ids_, from.extract_field("except_user_ids")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionSetPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.authorization_delay_, from.extract_field("authorization_delay")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionCustom &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterRestricted &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::telegramPaymentPurposePremiumGiftCodes &to, JsonObject &from) {
  TRY_STATUS(from_json(to.boosted_chat_id_, from.extract_field("boosted_chat_id")));
  TRY_STATUS(from_json(to.currency_, from.extract_field("currency")));
  TRY_STATUS(from_json(to.amount_, from.extract_field("amount")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  TRY_STATUS(from_json(to.month_count_, from.extract_field("month_count")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypeMention &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypeItalic &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypeTextUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::topChatCategoryGroups &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::upgradedGiftAttributeIdSymbol &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_id_, from.extract_field("sticker_id")));
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowProfileAudio &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleAllowContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictChatMembers &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::activateStoryStealthMode &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::addFavoriteSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::addPendingLiveStoryReaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::addSavedAnimation &to, JsonObject &from) {
  TRY_STATUS(from_json(to.animation_, from.extract_field("animation")));
  return Status::OK();
}

Status from_json(td_api::answerPreCheckoutQuery &to, JsonObject &from) {
  TRY_STATUS(from_json(to.pre_checkout_query_id_, from.extract_field("pre_checkout_query_id")));
  TRY_STATUS(from_json(to.error_message_, from.extract_field("error_message")));
  return Status::OK();
}

Status from_json(td_api::boostChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.slot_ids_, from.extract_field("slot_ids")));
  return Status::OK();
}

Status from_json(td_api::cancelPasswordReset &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::checkPasswordRecoveryCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.recovery_code_, from.extract_field("recovery_code")));
  return Status::OK();
}

Status from_json(td_api::clearAutosaveSettingsExceptions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::clickPremiumSubscriptionButton &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::commitPendingPaidMessageReactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::createChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.expiration_date_, from.extract_field("expiration_date")));
  TRY_STATUS(from_json(to.member_limit_, from.extract_field("member_limit")));
  TRY_STATUS(from_json(to.creates_join_request_, from.extract_field("creates_join_request")));
  return Status::OK();
}

Status from_json(td_api::createNewSupergroupChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.is_forum_, from.extract_field("is_forum")));
  TRY_STATUS(from_json(to.is_channel_, from.extract_field("is_channel")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  TRY_STATUS(from_json(to.location_, from.extract_field("location")));
  TRY_STATUS(from_json(to.message_auto_delete_time_, from.extract_field("message_auto_delete_time")));
  TRY_STATUS(from_json(to.for_import_, from.extract_field("for_import")));
  return Status::OK();
}

Status from_json(td_api::decryptGroupCallData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.participant_id_, from.extract_field("participant_id")));
  TRY_STATUS(from_json(to.data_channel_, from.extract_field("data_channel")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::deleteChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::deleteDefaultBackground &to, JsonObject &from) {
  TRY_STATUS(from_json(to.for_dark_theme_, from.extract_field("for_dark_theme")));
  return Status::OK();
}

Status from_json(td_api::deleteMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.revoke_, from.extract_field("revoke")));
  return Status::OK();
}

Status from_json(td_api::deleteSavedOrderInfo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::disconnectAllWebsites &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::editBusinessMessageMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::editForumTopic &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.edit_icon_custom_emoji_, from.extract_field("edit_icon_custom_emoji")));
  TRY_STATUS(from_json(to.icon_custom_emoji_id_, from.extract_field("icon_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::editMessageMedia &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::editUserStarSubscription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.telegram_payment_charge_id_, from.extract_field("telegram_payment_charge_id")));
  TRY_STATUS(from_json(to.is_canceled_, from.extract_field("is_canceled")));
  return Status::OK();
}

Status from_json(td_api::getActiveSessions &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAttachmentMenuBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getBasicGroup &to, JsonObject &from) {
  TRY_STATUS(from_json(to.basic_group_id_, from.extract_field("basic_group_id")));
  return Status::OK();
}

Status from_json(td_api::getBotSimilarBots &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  return Status::OK();
}

Status from_json(td_api::getChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatBoostLinkInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::getChatFolderNewChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  return Status::OK();
}

Status from_json(td_api::getChatMessageByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  return Status::OK();
}

Status from_json(td_api::getChatRevenueWithdrawalUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::getChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getContacts &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDatabaseStatistics &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDirectMessagesChatTopicHistory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.from_message_id_, from.extract_field("from_message_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getFavoriteStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getForumTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_date_, from.extract_field("offset_date")));
  TRY_STATUS(from_json(to.offset_message_id_, from.extract_field("offset_message_id")));
  TRY_STATUS(from_json(to.offset_forum_topic_id_, from.extract_field("offset_forum_topic_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getGreetingStickers &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getInlineGameHighScores &to, JsonObject &from) {
  TRY_STATUS(from_json(to.inline_message_id_, from.extract_field("inline_message_id")));
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getLanguagePackInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  return Status::OK();
}

Status from_json(td_api::getLogStream &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getMarkdownText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::getMessageFileType &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_file_head_, from.extract_field("message_file_head")));
  return Status::OK();
}

Status from_json(td_api::getMessageThread &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getPaidMessageRevenue &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getPhoneNumberInfoSync &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.phone_number_prefix_, from.extract_field("phone_number_prefix")));
  return Status::OK();
}

Status from_json(td_api::getPremiumStickerExamples &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getReceivedGifts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.collection_id_, from.extract_field("collection_id")));
  TRY_STATUS(from_json(to.exclude_unsaved_, from.extract_field("exclude_unsaved")));
  TRY_STATUS(from_json(to.exclude_saved_, from.extract_field("exclude_saved")));
  TRY_STATUS(from_json(to.exclude_unlimited_, from.extract_field("exclude_unlimited")));
  TRY_STATUS(from_json(to.exclude_upgradable_, from.extract_field("exclude_upgradable")));
  TRY_STATUS(from_json(to.exclude_non_upgradable_, from.extract_field("exclude_non_upgradable")));
  TRY_STATUS(from_json(to.exclude_upgraded_, from.extract_field("exclude_upgraded")));
  TRY_STATUS(from_json(to.exclude_without_colors_, from.extract_field("exclude_without_colors")));
  TRY_STATUS(from_json(to.exclude_hosted_, from.extract_field("exclude_hosted")));
  TRY_STATUS(from_json(to.sort_by_price_, from.extract_field("sort_by_price")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getRemoteFile &to, JsonObject &from) {
  TRY_STATUS(from_json(to.remote_file_id_, from.extract_field("remote_file_id")));
  TRY_STATUS(from_json(to.file_type_, from.extract_field("file_type")));
  return Status::OK();
}

Status from_json(td_api::getScopeNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  return Status::OK();
}

Status from_json(td_api::getStarRevenueStatistics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.is_dark_, from.extract_field("is_dark")));
  return Status::OK();
}

Status from_json(td_api::getStickerSetName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.set_id_, from.extract_field("set_id")));
  return Status::OK();
}

Status from_json(td_api::getStoryPublicForwards &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSupportName &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getTonTransactions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.direction_, from.extract_field("direction")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  return Status::OK();
}

Status from_json(td_api::getVideoChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.can_self_unmute_, from.extract_field("can_self_unmute")));
  return Status::OK();
}

Status from_json(td_api::hideSuggestedAction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.action_, from.extract_field("action")));
  return Status::OK();
}

Status from_json(td_api::joinChatByInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::loadDirectMessagesChatTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::openChatSimilarChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.opened_chat_id_, from.extract_field("opened_chat_id")));
  return Status::OK();
}

Status from_json(td_api::pinChatMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.disable_notification_, from.extract_field("disable_notification")));
  TRY_STATUS(from_json(to.only_for_self_, from.extract_field("only_for_self")));
  return Status::OK();
}

Status from_json(td_api::processPushNotification &to, JsonObject &from) {
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  return Status::OK();
}

Status from_json(td_api::readFilePart &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.count_, from.extract_field("count")));
  return Status::OK();
}

Status from_json(td_api::removeBusinessConnectedBotFromChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::removeMessageSenderBotVerification &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.verified_id_, from.extract_field("verified_id")));
  return Status::OK();
}

Status from_json(td_api::removeRecentlyFoundChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::reorderBotMediaPreviews &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.file_ids_, from.extract_field("file_ids")));
  return Status::OK();
}

Status from_json(td_api::replaceLiveStoryRtmpUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::reportPhoneNumberCodeMissing &to, JsonObject &from) {
  TRY_STATUS(from_json(to.mobile_network_code_, from.extract_field("mobile_network_code")));
  return Status::OK();
}

Status from_json(td_api::resendAuthenticationCode &to, JsonObject &from) {
  TRY_STATUS(from_json(to.reason_, from.extract_field("reason")));
  return Status::OK();
}

Status from_json(td_api::resetNetworkStatistics &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchCallMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.only_missed_, from.extract_field("only_missed")));
  return Status::OK();
}

Status from_json(td_api::searchFileDownloads &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.only_active_, from.extract_field("only_active")));
  TRY_STATUS(from_json(to.only_completed_, from.extract_field("only_completed")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchPublicPosts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  TRY_STATUS(from_json(to.star_count_, from.extract_field("star_count")));
  return Status::OK();
}

Status from_json(td_api::searchStickerSets &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_type_, from.extract_field("sticker_type")));
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::sendBusinessMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.disable_notification_, from.extract_field("disable_notification")));
  TRY_STATUS(from_json(to.protect_content_, from.extract_field("protect_content")));
  TRY_STATUS(from_json(to.effect_id_, from.extract_field("effect_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::sendGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_id_, from.extract_field("gift_id")));
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  TRY_STATUS(from_json(to.is_private_, from.extract_field("is_private")));
  TRY_STATUS(from_json(to.pay_for_upgrade_, from.extract_field("pay_for_upgrade")));
  return Status::OK();
}

Status from_json(td_api::sendPhoneNumberFirebaseSms &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::setApplicationVerificationToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.verification_id_, from.extract_field("verification_id")));
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::setBotInfoDescription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAccountUsername &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::setChatActiveStoriesList &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_list_, from.extract_field("story_list")));
  return Status::OK();
}

Status from_json(td_api::setChatEmojiStatus &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.emoji_status_, from.extract_field("emoji_status")));
  return Status::OK();
}

Status from_json(td_api::setChatPinnedStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_ids_, from.extract_field("story_ids")));
  return Status::OK();
}

Status from_json(td_api::setCustomLanguagePackString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  TRY_STATUS(from_json(to.new_string_, from.extract_field("new_string")));
  return Status::OK();
}

Status from_json(td_api::setFileGenerationProgress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.generation_id_, from.extract_field("generation_id")));
  TRY_STATUS(from_json(to.expected_size_, from.extract_field("expected_size")));
  TRY_STATUS(from_json(to.local_prefix_size_, from.extract_field("local_prefix_size")));
  return Status::OK();
}

Status from_json(td_api::setInactiveSessionTtl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.inactive_session_ttl_days_, from.extract_field("inactive_session_ttl_days")));
  return Status::OK();
}

Status from_json(td_api::setMessageFactCheck &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::setPassportElement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.element_, from.extract_field("element")));
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  return Status::OK();
}

Status from_json(td_api::setProfileAccentColor &to, JsonObject &from) {
  TRY_STATUS(from_json(to.profile_accent_color_id_, from.extract_field("profile_accent_color_id")));
  TRY_STATUS(from_json(to.profile_background_custom_emoji_id_, from.extract_field("profile_background_custom_emoji_id")));
  return Status::OK();
}

Status from_json(td_api::setStickerEmojis &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  TRY_STATUS(from_json(to.emojis_, from.extract_field("emojis")));
  return Status::OK();
}

Status from_json(td_api::setSupergroupCustomEmojiStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.custom_emoji_sticker_set_id_, from.extract_field("custom_emoji_sticker_set_id")));
  return Status::OK();
}

Status from_json(td_api::setUserPersonalProfilePhoto &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.photo_, from.extract_field("photo")));
  return Status::OK();
}

Status from_json(td_api::startGroupCallRecording &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.record_video_, from.extract_field("record_video")));
  TRY_STATUS(from_json(to.use_portrait_orientation_, from.extract_field("use_portrait_orientation")));
  return Status::OK();
}

Status from_json(td_api::synchronizeLanguagePack &to, JsonObject &from) {
  TRY_STATUS(from_json(to.language_pack_id_, from.extract_field("language_pack_id")));
  return Status::OK();
}

Status from_json(td_api::testCallVectorStringObject &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::toggleBotIsAddedToAttachmentMenu &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.is_added_, from.extract_field("is_added")));
  TRY_STATUS(from_json(to.allow_write_access_, from.extract_field("allow_write_access")));
  return Status::OK();
}

Status from_json(td_api::toggleChatIsTranslatable &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.is_translatable_, from.extract_field("is_translatable")));
  return Status::OK();
}

Status from_json(td_api::toggleGroupCallIsMyVideoEnabled &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.is_my_video_enabled_, from.extract_field("is_my_video_enabled")));
  return Status::OK();
}

Status from_json(td_api::toggleStoryIsPostedToChatPage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  TRY_STATUS(from_json(to.is_posted_to_chat_page_, from.extract_field("is_posted_to_chat_page")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupJoinToSendMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.join_to_send_messages_, from.extract_field("join_to_send_messages")));
  return Status::OK();
}

Status from_json(td_api::translateMessageText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.to_language_code_, from.extract_field("to_language_code")));
  return Status::OK();
}

Status from_json(td_api::validateOrderInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.input_invoice_, from.extract_field("input_invoice")));
  TRY_STATUS(from_json(to.order_info_, from.extract_field("order_info")));
  TRY_STATUS(from_json(to.allow_save_, from.extract_field("allow_save")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::accountInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "accountInfo");
  jo("registration_month", object.registration_month_);
  jo("registration_year", object.registration_year_);
  jo("phone_number_country_code", object.phone_number_country_code_);
  jo("last_name_change_date", object.last_name_change_date_);
  jo("last_photo_change_date", object.last_photo_change_date_);
}

void to_json(JsonValueScope &jv, const td_api::affiliateProgramParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "affiliateProgramParameters");
  jo("commission_per_mille", object.commission_per_mille_);
  jo("month_count", object.month_count_);
}

void to_json(JsonValueScope &jv, const td_api::attachmentMenuBotColor &object) {
  auto jo = jv.enter_object();
  jo("@type", "attachmentMenuBotColor");
  jo("light_color", object.light_color_);
  jo("dark_color", object.dark_color_);
}

void to_json(JsonValueScope &jv, const td_api::autoDownloadSettings &object) {
  auto jo = jv.enter_object();
  jo("@type", "autoDownloadSettings");
  jo("is_auto_download_enabled", JsonBool{object.is_auto_download_enabled_});
  jo("max_photo_file_size", object.max_photo_file_size_);
  jo("max_video_file_size", object.max_video_file_size_);
  jo("max_other_file_size", object.max_other_file_size_);
  jo("video_upload_bitrate", object.video_upload_bitrate_);
  jo("preload_large_videos", JsonBool{object.preload_large_videos_});
  jo("preload_next_audio", JsonBool{object.preload_next_audio_});
  jo("preload_stories", JsonBool{object.preload_stories_});
  jo("use_less_data_for_calls", JsonBool{object.use_less_data_for_calls_});
}

void to_json(JsonValueScope &jv, const td_api::background &object) {
  auto jo = jv.enter_object();
  jo("@type", "background");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("is_default", JsonBool{object.is_default_});
  jo("is_dark", JsonBool{object.is_dark_});
  jo("name", object.name_);
  if (object.document_) {
    jo("document", ToJson(*object.document_));
  }
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::BlockList &object) {
  td_api::downcast_call(const_cast<td_api::BlockList &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::blockListMain &object) {
  auto jo = jv.enter_object();
  jo("@type", "blockListMain");
}

void to_json(JsonValueScope &jv, const td_api::blockListStories &object) {
  auto jo = jv.enter_object();
  jo("@type", "blockListStories");
}

void to_json(JsonValueScope &jv, const td_api::botVerificationParameters &object) {
  auto jo = jv.enter_object();
  jo("@type", "botVerificationParameters");
  jo("icon_custom_emoji_id", ToJson(JsonInt64{object.icon_custom_emoji_id_}));
  jo("organization_name", object.organization_name_);
  if (object.default_custom_description_) {
    jo("default_custom_description", ToJson(*object.default_custom_description_));
  }
  jo("can_set_custom_description", JsonBool{object.can_set_custom_description_});
}

void to_json(JsonValueScope &jv, const td_api::businessChatLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessChatLinks");
  jo("links", ToJson(object.links_));
}

void to_json(JsonValueScope &jv, const td_api::businessMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessMessage");
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  if (object.reply_to_message_) {
    jo("reply_to_message", ToJson(*object.reply_to_message_));
  }
}

void to_json(JsonValueScope &jv, const td_api::callProtocol &object) {
  auto jo = jv.enter_object();
  jo("@type", "callProtocol");
  jo("udp_p2p", JsonBool{object.udp_p2p_});
  jo("udp_reflector", JsonBool{object.udp_reflector_});
  jo("min_layer", object.min_layer_);
  jo("max_layer", object.max_layer_);
  jo("library_versions", ToJson(object.library_versions_));
}

void to_json(JsonValueScope &jv, const td_api::CanTransferOwnershipResult &object) {
  td_api::downcast_call(const_cast<td_api::CanTransferOwnershipResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultOk");
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultPasswordNeeded &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultPasswordNeeded");
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultPasswordTooFresh &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultPasswordTooFresh");
  jo("retry_after", object.retry_after_);
}

void to_json(JsonValueScope &jv, const td_api::canTransferOwnershipResultSessionTooFresh &object) {
  auto jo = jv.enter_object();
  jo("@type", "canTransferOwnershipResultSessionTooFresh");
  jo("retry_after", object.retry_after_);
}

void to_json(JsonValueScope &jv, const td_api::chatBackground &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBackground");
  if (object.background_) {
    jo("background", ToJson(*object.background_));
  }
  jo("dark_theme_dimming", object.dark_theme_dimming_);
}

void to_json(JsonValueScope &jv, const td_api::chatBoostStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostStatus");
  jo("boost_url", object.boost_url_);
  jo("applied_slot_ids", ToJson(object.applied_slot_ids_));
  jo("level", object.level_);
  jo("gift_code_boost_count", object.gift_code_boost_count_);
  jo("boost_count", object.boost_count_);
  jo("current_level_boost_count", object.current_level_boost_count_);
  jo("next_level_boost_count", object.next_level_boost_count_);
  jo("premium_member_count", object.premium_member_count_);
  jo("premium_member_percentage", object.premium_member_percentage_);
  jo("prepaid_giveaways", ToJson(object.prepaid_giveaways_));
}

void to_json(JsonValueScope &jv, const td_api::chatFolderInviteLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolderInviteLinks");
  jo("invite_links", ToJson(object.invite_links_));
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinks &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinks");
  jo("total_count", object.total_count_);
  jo("invite_links", ToJson(object.invite_links_));
}

void to_json(JsonValueScope &jv, const td_api::chatMembers &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatMembers");
  jo("total_count", object.total_count_);
  jo("members", ToJson(object.members_));
}

void to_json(JsonValueScope &jv, const td_api::chatPhotos &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPhotos");
  jo("total_count", object.total_count_);
  jo("photos", ToJson(object.photos_));
}

void to_json(JsonValueScope &jv, const td_api::chatStatisticsAdministratorActionsInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatStatisticsAdministratorActionsInfo");
  jo("user_id", object.user_id_);
  jo("deleted_message_count", object.deleted_message_count_);
  jo("banned_user_count", object.banned_user_count_);
  jo("restricted_user_count", object.restricted_user_count_);
}

void to_json(JsonValueScope &jv, const td_api::CheckStickerSetNameResult &object) {
  td_api::downcast_call(const_cast<td_api::CheckStickerSetNameResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::checkStickerSetNameResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkStickerSetNameResultOk");
}

void to_json(JsonValueScope &jv, const td_api::checkStickerSetNameResultNameInvalid &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkStickerSetNameResultNameInvalid");
}

void to_json(JsonValueScope &jv, const td_api::checkStickerSetNameResultNameOccupied &object) {
  auto jo = jv.enter_object();
  jo("@type", "checkStickerSetNameResultNameOccupied");
}

void to_json(JsonValueScope &jv, const td_api::connectedWebsites &object) {
  auto jo = jv.enter_object();
  jo("@type", "connectedWebsites");
  jo("websites", ToJson(object.websites_));
}

void to_json(JsonValueScope &jv, const td_api::data &object) {
  auto jo = jv.enter_object();
  jo("@type", "data");
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::downloadedFileCounts &object) {
  auto jo = jv.enter_object();
  jo("@type", "downloadedFileCounts");
  jo("active_count", object.active_count_);
  jo("paused_count", object.paused_count_);
  jo("completed_count", object.completed_count_);
}

void to_json(JsonValueScope &jv, const td_api::emojiKeywords &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiKeywords");
  jo("emoji_keywords", ToJson(object.emoji_keywords_));
}

void to_json(JsonValueScope &jv, const td_api::error &object) {
  auto jo = jv.enter_object();
  jo("@type", "error");
  jo("code", object.code_);
  jo("message", object.message_);
}

void to_json(JsonValueScope &jv, const td_api::formattedText &object) {
  auto jo = jv.enter_object();
  jo("@type", "formattedText");
  jo("text", object.text_);
  jo("entities", ToJson(object.entities_));
}

void to_json(JsonValueScope &jv, const td_api::foundChatMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundChatMessages");
  jo("total_count", object.total_count_);
  jo("messages", ToJson(object.messages_));
  jo("next_from_message_id", object.next_from_message_id_);
}

void to_json(JsonValueScope &jv, const td_api::game &object) {
  auto jo = jv.enter_object();
  jo("@type", "game");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("short_name", object.short_name_);
  jo("title", object.title_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("description", object.description_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::giftChatTheme &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftChatTheme");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  if (object.light_settings_) {
    jo("light_settings", ToJson(*object.light_settings_));
  }
  if (object.dark_settings_) {
    jo("dark_settings", ToJson(*object.dark_settings_));
  }
}

void to_json(JsonValueScope &jv, const td_api::GiftResaleResult &object) {
  td_api::downcast_call(const_cast<td_api::GiftResaleResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::giftResaleResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftResaleResultOk");
}

void to_json(JsonValueScope &jv, const td_api::giftResaleResultPriceIncreased &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftResaleResultPriceIncreased");
  if (object.price_) {
    jo("price", ToJson(*object.price_));
  }
}

void to_json(JsonValueScope &jv, const td_api::GiveawayPrize &object) {
  td_api::downcast_call(const_cast<td_api::GiveawayPrize &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::giveawayPrizePremium &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayPrizePremium");
  jo("month_count", object.month_count_);
}

void to_json(JsonValueScope &jv, const td_api::giveawayPrizeStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "giveawayPrizeStars");
  jo("star_count", object.star_count_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallRecentSpeaker &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallRecentSpeaker");
  if (object.participant_id_) {
    jo("participant_id", ToJson(*object.participant_id_));
  }
  jo("is_speaking", JsonBool{object.is_speaking_});
}

void to_json(JsonValueScope &jv, const td_api::InlineKeyboardButtonType &object) {
  td_api::downcast_call(const_cast<td_api::InlineKeyboardButtonType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeUrl");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeLoginUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeLoginUrl");
  jo("url", object.url_);
  jo("id", object.id_);
  jo("forward_text", object.forward_text_);
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeWebApp");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeCallback &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeCallback");
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeCallbackWithPassword &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeCallbackWithPassword");
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeCallbackGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeCallbackGame");
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeSwitchInline &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeSwitchInline");
  jo("query", object.query_);
  if (object.target_chat_) {
    jo("target_chat", ToJson(*object.target_chat_));
  }
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeBuy &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeBuy");
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeUser &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeUser");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::inlineKeyboardButtonTypeCopyText &object) {
  auto jo = jv.enter_object();
  jo("@type", "inlineKeyboardButtonTypeCopyText");
  jo("text", object.text_);
}

void to_json(JsonValueScope &jv, const td_api::InputMessageReplyTo &object) {
  td_api::downcast_call(const_cast<td_api::InputMessageReplyTo &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::inputMessageReplyToMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageReplyToMessage");
  jo("message_id", object.message_id_);
  if (object.quote_) {
    jo("quote", ToJson(*object.quote_));
  }
  jo("checklist_task_id", object.checklist_task_id_);
}

void to_json(JsonValueScope &jv, const td_api::inputMessageReplyToExternalMessage &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageReplyToExternalMessage");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.quote_) {
    jo("quote", ToJson(*object.quote_));
  }
  jo("checklist_task_id", object.checklist_task_id_);
}

void to_json(JsonValueScope &jv, const td_api::inputMessageReplyToStory &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputMessageReplyToStory");
  jo("story_poster_chat_id", object.story_poster_chat_id_);
  jo("story_id", object.story_id_);
}

void to_json(JsonValueScope &jv, const td_api::invoice &object) {
  auto jo = jv.enter_object();
  jo("@type", "invoice");
  jo("currency", object.currency_);
  jo("price_parts", ToJson(object.price_parts_));
  jo("subscription_period", object.subscription_period_);
  jo("max_tip_amount", object.max_tip_amount_);
  jo("suggested_tip_amounts", ToJson(object.suggested_tip_amounts_));
  jo("recurring_payment_terms_of_service_url", object.recurring_payment_terms_of_service_url_);
  jo("terms_of_service_url", object.terms_of_service_url_);
  jo("is_test", JsonBool{object.is_test_});
  jo("need_name", JsonBool{object.need_name_});
  jo("need_phone_number", JsonBool{object.need_phone_number_});
  jo("need_email_address", JsonBool{object.need_email_address_});
  jo("need_shipping_address", JsonBool{object.need_shipping_address_});
  jo("send_phone_number_to_provider", JsonBool{object.send_phone_number_to_provider_});
  jo("send_email_address_to_provider", JsonBool{object.send_email_address_to_provider_});
  jo("is_flexible", JsonBool{object.is_flexible_});
}

void to_json(JsonValueScope &jv, const td_api::languagePackStrings &object) {
  auto jo = jv.enter_object();
  jo("@type", "languagePackStrings");
  jo("strings", ToJson(object.strings_));
}

void to_json(JsonValueScope &jv, const td_api::locationAddress &object) {
  auto jo = jv.enter_object();
  jo("@type", "locationAddress");
  jo("country_code", object.country_code_);
  jo("state", object.state_);
  jo("city", object.city_);
  jo("street", object.street_);
}

void to_json(JsonValueScope &jv, const td_api::messageAutoDeleteTime &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageAutoDeleteTime");
  jo("time", object.time_);
}

void to_json(JsonValueScope &jv, const td_api::messageImportInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageImportInfo");
  jo("sender_name", object.sender_name_);
  jo("date", object.date_);
}

void to_json(JsonValueScope &jv, const td_api::messageReactions &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageReactions");
  jo("reactions", ToJson(object.reactions_));
  jo("are_tags", JsonBool{object.are_tags_});
  jo("paid_reactors", ToJson(object.paid_reactors_));
  jo("can_get_added_reactions", JsonBool{object.can_get_added_reactions_});
}

void to_json(JsonValueScope &jv, const td_api::messageStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageStatistics");
  if (object.message_interaction_graph_) {
    jo("message_interaction_graph", ToJson(*object.message_interaction_graph_));
  }
  if (object.message_reaction_graph_) {
    jo("message_reaction_graph", ToJson(*object.message_reaction_graph_));
  }
}

void to_json(JsonValueScope &jv, const td_api::NetworkType &object) {
  td_api::downcast_call(const_cast<td_api::NetworkType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::networkTypeNone &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkTypeNone");
}

void to_json(JsonValueScope &jv, const td_api::networkTypeMobile &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkTypeMobile");
}

void to_json(JsonValueScope &jv, const td_api::networkTypeMobileRoaming &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkTypeMobileRoaming");
}

void to_json(JsonValueScope &jv, const td_api::networkTypeWiFi &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkTypeWiFi");
}

void to_json(JsonValueScope &jv, const td_api::networkTypeOther &object) {
  auto jo = jv.enter_object();
  jo("@type", "networkTypeOther");
}

void to_json(JsonValueScope &jv, const td_api::ok &object) {
  auto jo = jv.enter_object();
  jo("@type", "ok");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockTableCell &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockTableCell");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("is_header", JsonBool{object.is_header_});
  jo("colspan", object.colspan_);
  jo("rowspan", object.rowspan_);
  if (object.align_) {
    jo("align", ToJson(*object.align_));
  }
  if (object.valign_) {
    jo("valign", ToJson(*object.valign_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passportElementError &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportElementError");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("message", object.message_);
  if (object.source_) {
    jo("source", ToJson(*object.source_));
  }
}

void to_json(JsonValueScope &jv, const td_api::PaymentFormType &object) {
  td_api::downcast_call(const_cast<td_api::PaymentFormType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::paymentFormTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentFormTypeRegular");
  if (object.invoice_) {
    jo("invoice", ToJson(*object.invoice_));
  }
  jo("payment_provider_user_id", object.payment_provider_user_id_);
  if (object.payment_provider_) {
    jo("payment_provider", ToJson(*object.payment_provider_));
  }
  jo("additional_payment_options", ToJson(object.additional_payment_options_));
  if (object.saved_order_info_) {
    jo("saved_order_info", ToJson(*object.saved_order_info_));
  }
  jo("saved_credentials", ToJson(object.saved_credentials_));
  jo("can_save_credentials", JsonBool{object.can_save_credentials_});
  jo("need_password", JsonBool{object.need_password_});
}

void to_json(JsonValueScope &jv, const td_api::paymentFormTypeStars &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentFormTypeStars");
  jo("star_count", object.star_count_);
}

void to_json(JsonValueScope &jv, const td_api::paymentFormTypeStarSubscription &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentFormTypeStarSubscription");
  if (object.pricing_) {
    jo("pricing", ToJson(*object.pricing_));
  }
}

void to_json(JsonValueScope &jv, const td_api::photo &object) {
  auto jo = jv.enter_object();
  jo("@type", "photo");
  jo("has_stickers", JsonBool{object.has_stickers_});
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  jo("sizes", ToJson(object.sizes_));
}

void to_json(JsonValueScope &jv, const td_api::premiumGiftCodeInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumGiftCodeInfo");
  if (object.creator_id_) {
    jo("creator_id", ToJson(*object.creator_id_));
  }
  jo("creation_date", object.creation_date_);
  jo("is_from_giveaway", JsonBool{object.is_from_giveaway_});
  jo("giveaway_message_id", object.giveaway_message_id_);
  jo("month_count", object.month_count_);
  jo("day_count", object.day_count_);
  jo("user_id", object.user_id_);
  jo("use_date", object.use_date_);
}

void to_json(JsonValueScope &jv, const td_api::premiumStatePaymentOption &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumStatePaymentOption");
  if (object.payment_option_) {
    jo("payment_option", ToJson(*object.payment_option_));
  }
  jo("is_current", JsonBool{object.is_current_});
  jo("is_upgrade", JsonBool{object.is_upgrade_});
  jo("last_transaction_id", object.last_transaction_id_);
}

void to_json(JsonValueScope &jv, const td_api::proxies &object) {
  auto jo = jv.enter_object();
  jo("@type", "proxies");
  jo("proxies", ToJson(object.proxies_));
}

void to_json(JsonValueScope &jv, const td_api::quickReplyMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "quickReplyMessages");
  jo("messages", ToJson(object.messages_));
}

void to_json(JsonValueScope &jv, const td_api::recommendedChatFolder &object) {
  auto jo = jv.enter_object();
  jo("@type", "recommendedChatFolder");
  if (object.folder_) {
    jo("folder", ToJson(*object.folder_));
  }
  jo("description", object.description_);
}

void to_json(JsonValueScope &jv, const td_api::ResetPasswordResult &object) {
  td_api::downcast_call(const_cast<td_api::ResetPasswordResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::resetPasswordResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "resetPasswordResultOk");
}

void to_json(JsonValueScope &jv, const td_api::resetPasswordResultPending &object) {
  auto jo = jv.enter_object();
  jo("@type", "resetPasswordResultPending");
  jo("pending_reset_date", object.pending_reset_date_);
}

void to_json(JsonValueScope &jv, const td_api::resetPasswordResultDeclined &object) {
  auto jo = jv.enter_object();
  jo("@type", "resetPasswordResultDeclined");
  jo("retry_date", object.retry_date_);
}

void to_json(JsonValueScope &jv, const td_api::SavedMessagesTopicType &object) {
  td_api::downcast_call(const_cast<td_api::SavedMessagesTopicType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTopicTypeMyNotes &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTopicTypeMyNotes");
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTopicTypeAuthorHidden &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTopicTypeAuthorHidden");
}

void to_json(JsonValueScope &jv, const td_api::savedMessagesTopicTypeSavedFromChat &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedMessagesTopicTypeSavedFromChat");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::SessionType &object) {
  td_api::downcast_call(const_cast<td_api::SessionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeAndroid &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeAndroid");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeApple &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeApple");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeBrave &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeBrave");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeChrome &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeChrome");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeEdge &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeEdge");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeFirefox &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeFirefox");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeIpad &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeIpad");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeIphone &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeIphone");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeLinux &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeLinux");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeMac &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeMac");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeOpera &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeOpera");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeSafari &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeSafari");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeUbuntu &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeUbuntu");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeUnknown &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeUnknown");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeVivaldi &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeVivaldi");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeWindows &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeWindows");
}

void to_json(JsonValueScope &jv, const td_api::sessionTypeXbox &object) {
  auto jo = jv.enter_object();
  jo("@type", "sessionTypeXbox");
}

void to_json(JsonValueScope &jv, const td_api::sponsoredMessages &object) {
  auto jo = jv.enter_object();
  jo("@type", "sponsoredMessages");
  jo("messages", ToJson(object.messages_));
  jo("messages_between", object.messages_between_);
}

void to_json(JsonValueScope &jv, const td_api::starRevenueStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "starRevenueStatistics");
  if (object.revenue_by_day_graph_) {
    jo("revenue_by_day_graph", ToJson(*object.revenue_by_day_graph_));
  }
  if (object.status_) {
    jo("status", ToJson(*object.status_));
  }
  jo("usd_rate", object.usd_rate_);
}

void to_json(JsonValueScope &jv, const td_api::StartLiveStoryResult &object) {
  td_api::downcast_call(const_cast<td_api::StartLiveStoryResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::startLiveStoryResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "startLiveStoryResultOk");
  if (object.story_) {
    jo("story", ToJson(*object.story_));
  }
}

void to_json(JsonValueScope &jv, const td_api::startLiveStoryResultFail &object) {
  auto jo = jv.enter_object();
  jo("@type", "startLiveStoryResultFail");
  if (object.error_type_) {
    jo("error_type", ToJson(*object.error_type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::StickerType &object) {
  td_api::downcast_call(const_cast<td_api::StickerType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::stickerTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerTypeRegular");
}

void to_json(JsonValueScope &jv, const td_api::stickerTypeMask &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerTypeMask");
}

void to_json(JsonValueScope &jv, const td_api::stickerTypeCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerTypeCustomEmoji");
}

void to_json(JsonValueScope &jv, const td_api::storyAlbums &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyAlbums");
  jo("albums", ToJson(object.albums_));
}

void to_json(JsonValueScope &jv, const td_api::storyInteractions &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInteractions");
  jo("total_count", object.total_count_);
  jo("total_forward_count", object.total_forward_count_);
  jo("total_reaction_count", object.total_reaction_count_);
  jo("interactions", ToJson(object.interactions_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::SuggestedPostPrice &object) {
  td_api::downcast_call(const_cast<td_api::SuggestedPostPrice &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostPriceStar &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostPriceStar");
  jo("star_count", object.star_count_);
}

void to_json(JsonValueScope &jv, const td_api::suggestedPostPriceTon &object) {
  auto jo = jv.enter_object();
  jo("@type", "suggestedPostPriceTon");
  jo("toncoin_cent_count", object.toncoin_cent_count_);
}

void to_json(JsonValueScope &jv, const td_api::targetChatTypes &object) {
  auto jo = jv.enter_object();
  jo("@type", "targetChatTypes");
  jo("allow_user_chats", JsonBool{object.allow_user_chats_});
  jo("allow_bot_chats", JsonBool{object.allow_bot_chats_});
  jo("allow_group_chats", JsonBool{object.allow_group_chats_});
  jo("allow_channel_chats", JsonBool{object.allow_channel_chats_});
}

void to_json(JsonValueScope &jv, const td_api::testVectorStringObject &object) {
  auto jo = jv.enter_object();
  jo("@type", "testVectorStringObject");
  jo("value", ToJson(object.value_));
}

void to_json(JsonValueScope &jv, const td_api::timeZone &object) {
  auto jo = jv.enter_object();
  jo("@type", "timeZone");
  jo("id", object.id_);
  jo("name", object.name_);
  jo("utc_time_offset", object.utc_time_offset_);
}

void to_json(JsonValueScope &jv, const td_api::unreadReaction &object) {
  auto jo = jv.enter_object();
  jo("@type", "unreadReaction");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("is_big", JsonBool{object.is_big_});
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftModel &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftModel");
  jo("name", object.name_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
  jo("rarity_per_mille", object.rarity_per_mille_);
}

void to_json(JsonValueScope &jv, const td_api::userFullInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "userFullInfo");
  if (object.personal_photo_) {
    jo("personal_photo", ToJson(*object.personal_photo_));
  }
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  if (object.public_photo_) {
    jo("public_photo", ToJson(*object.public_photo_));
  }
  if (object.block_list_) {
    jo("block_list", ToJson(*object.block_list_));
  }
  jo("can_be_called", JsonBool{object.can_be_called_});
  jo("supports_video_calls", JsonBool{object.supports_video_calls_});
  jo("has_private_calls", JsonBool{object.has_private_calls_});
  jo("has_private_forwards", JsonBool{object.has_private_forwards_});
  jo("has_restricted_voice_and_video_note_messages", JsonBool{object.has_restricted_voice_and_video_note_messages_});
  jo("has_posted_to_profile_stories", JsonBool{object.has_posted_to_profile_stories_});
  jo("has_sponsored_messages_enabled", JsonBool{object.has_sponsored_messages_enabled_});
  jo("need_phone_number_privacy_exception", JsonBool{object.need_phone_number_privacy_exception_});
  jo("set_chat_background", JsonBool{object.set_chat_background_});
  if (object.bio_) {
    jo("bio", ToJson(*object.bio_));
  }
  if (object.birthdate_) {
    jo("birthdate", ToJson(*object.birthdate_));
  }
  jo("personal_chat_id", object.personal_chat_id_);
  jo("gift_count", object.gift_count_);
  jo("group_in_common_count", object.group_in_common_count_);
  jo("incoming_paid_message_star_count", object.incoming_paid_message_star_count_);
  jo("outgoing_paid_message_star_count", object.outgoing_paid_message_star_count_);
  if (object.gift_settings_) {
    jo("gift_settings", ToJson(*object.gift_settings_));
  }
  if (object.bot_verification_) {
    jo("bot_verification", ToJson(*object.bot_verification_));
  }
  if (object.main_profile_tab_) {
    jo("main_profile_tab", ToJson(*object.main_profile_tab_));
  }
  if (object.first_profile_audio_) {
    jo("first_profile_audio", ToJson(*object.first_profile_audio_));
  }
  if (object.rating_) {
    jo("rating", ToJson(*object.rating_));
  }
  if (object.pending_rating_) {
    jo("pending_rating", ToJson(*object.pending_rating_));
  }
  jo("pending_rating_date", object.pending_rating_date_);
  if (object.note_) {
    jo("note", ToJson(*object.note_));
  }
  if (object.business_info_) {
    jo("business_info", ToJson(*object.business_info_));
  }
  if (object.bot_info_) {
    jo("bot_info", ToJson(*object.bot_info_));
  }
}

void to_json(JsonValueScope &jv, const td_api::usernames &object) {
  auto jo = jv.enter_object();
  jo("@type", "usernames");
  jo("active_usernames", ToJson(object.active_usernames_));
  jo("disabled_usernames", ToJson(object.disabled_usernames_));
  jo("editable_username", object.editable_username_);
  jo("collectible_usernames", ToJson(object.collectible_usernames_));
}

void to_json(JsonValueScope &jv, const td_api::videoMessageAdvertisements &object) {
  auto jo = jv.enter_object();
  jo("@type", "videoMessageAdvertisements");
  jo("advertisements", ToJson(object.advertisements_));
  jo("start_delay", object.start_delay_);
  jo("between_delay", object.between_delay_);
}

}  // namespace td_api
}  // namespace td
