#include "td/telegram/td_api_json.h"

#include "td/telegram/td_api.h"
#include "td/telegram/td_api.hpp"

#include "td/tl/tl_json.h"

#include "td/utils/base64.h"
#include "td/utils/common.h"
#include "td/utils/FlatHashMap.h"
#include "td/utils/Slice.h"

namespace td {
namespace td_api {
Result<int32> tl_constructor_from_string(td_api::BusinessAwayMessageSchedule *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"businessAwayMessageScheduleAlways", -910564679},
    {"businessAwayMessageScheduleOutsideOfOpeningHours", -968630506},
    {"businessAwayMessageScheduleCustom", -1967108654}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::ChatPhotoStickerType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"chatPhotoStickerTypeRegularOrMask", -415147620},
    {"chatPhotoStickerTypeCustomEmoji", -266224943}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::GiftResalePrice *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"giftResalePriceStar", 1184402054},
    {"giftResalePriceTon", -415435950}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputFile *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputFileId", 1788906253},
    {"inputFileRemote", -107574466},
    {"inputFileLocal", 2056030919},
    {"inputFileGenerated", -1333385216}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::InputStoryAreaType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"inputStoryAreaTypeLocation", -1433714887},
    {"inputStoryAreaTypeFoundVenue", -1395809130},
    {"inputStoryAreaTypePreviousVenue", 1846693388},
    {"inputStoryAreaTypeSuggestedReaction", 2101826003},
    {"inputStoryAreaTypeMessage", -266607529},
    {"inputStoryAreaTypeLink", 1408441160},
    {"inputStoryAreaTypeWeather", -1212686691},
    {"inputStoryAreaTypeUpgradedGift", 793059694}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::MessageSelfDestructType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"messageSelfDestructTypeTimer", 1351440333},
    {"messageSelfDestructTypeImmediately", -1036218363}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PassportElementType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"passportElementTypePersonalDetails", -1032136365},
    {"passportElementTypePassport", -436360376},
    {"passportElementTypeDriverLicense", 1827298379},
    {"passportElementTypeIdentityCard", -502356132},
    {"passportElementTypeInternalPassport", -793781959},
    {"passportElementTypeAddress", 496327874},
    {"passportElementTypeUtilityBill", 627084906},
    {"passportElementTypeBankStatement", 574095667},
    {"passportElementTypeRentalAgreement", -2060583280},
    {"passportElementTypePassportRegistration", -159478209},
    {"passportElementTypeTemporaryRegistration", 1092498527},
    {"passportElementTypePhoneNumber", -995361172},
    {"passportElementTypeEmailAddress", -79321405}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::PublicChatType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"publicChatTypeHasUsername", 350789758},
    {"publicChatTypeIsLocationBased", 1183735952}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::StickerType *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"stickerTypeRegular", 56345973},
    {"stickerTypeMask", -1765394796},
    {"stickerTypeCustomEmoji", -120752249}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Result<int32> tl_constructor_from_string(td_api::TelegramPaymentPurpose *object, const std::string &str) {
  static const FlatHashMap<Slice, int32, SliceHash> m = {
    {"telegramPaymentPurposePremiumGift", -1600286150},
    {"telegramPaymentPurposePremiumGiftCodes", -1863495348},
    {"telegramPaymentPurposePremiumGiveaway", -760757441},
    {"telegramPaymentPurposeStars", 1204968037},
    {"telegramPaymentPurposeGiftedStars", -1850308042},
    {"telegramPaymentPurposeStarGiveaway", 1014604689},
    {"telegramPaymentPurposeJoinChat", -1914869880}
  };
  auto it = m.find(str);
  if (it == m.end()) {
    return Status::Error(PSLICE() << "Unknown class \"" << str << "\"");
  }
  return it->second;
}

Status from_json(td_api::acceptedGiftTypes &to, JsonObject &from) {
  TRY_STATUS(from_json(to.unlimited_gifts_, from.extract_field("unlimited_gifts")));
  TRY_STATUS(from_json(to.limited_gifts_, from.extract_field("limited_gifts")));
  TRY_STATUS(from_json(to.upgraded_gifts_, from.extract_field("upgraded_gifts")));
  TRY_STATUS(from_json(to.gifts_from_channels_, from.extract_field("gifts_from_channels")));
  TRY_STATUS(from_json(to.premium_subscription_, from.extract_field("premium_subscription")));
  return Status::OK();
}

Status from_json(td_api::affiliateTypeChannel &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::backgroundFillFreeformGradient &to, JsonObject &from) {
  TRY_STATUS(from_json(to.colors_, from.extract_field("colors")));
  return Status::OK();
}

Status from_json(td_api::botCommandScopeDefault &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessAwayMessageScheduleOutsideOfOpeningHours &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessFeatureAwayMessage &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::businessOpeningHours &to, JsonObject &from) {
  TRY_STATUS(from_json(to.time_zone_id_, from.extract_field("time_zone_id")));
  TRY_STATUS(from_json(to.opening_hours_, from.extract_field("opening_hours")));
  return Status::OK();
}

Status from_json(td_api::callProblemDropped &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatActionUploadingVideo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.progress_, from.extract_field("progress")));
  return Status::OK();
}

Status from_json(td_api::chatActionRecordingVideoNote &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::chatFolderIcon &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::chatMemberStatusAdministrator &to, JsonObject &from) {
  TRY_STATUS(from_json(to.custom_title_, from.extract_field("custom_title")));
  TRY_STATUS(from_json(to.can_be_edited_, from.extract_field("can_be_edited")));
  TRY_STATUS(from_json(to.rights_, from.extract_field("rights")));
  return Status::OK();
}

Status from_json(td_api::chatMembersFilterRestricted &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::collectibleItemTypePhoneNumber &to, JsonObject &from) {
  TRY_STATUS(from_json(to.phone_number_, from.extract_field("phone_number")));
  return Status::OK();
}

Status from_json(td_api::deviceTokenWebPush &to, JsonObject &from) {
  TRY_STATUS(from_json(to.endpoint_, from.extract_field("endpoint")));
  TRY_STATUS(from_json(to.p256dh_base64url_, from.extract_field("p256dh_base64url")));
  TRY_STATUS(from_json(to.auth_base64url_, from.extract_field("auth_base64url")));
  return Status::OK();
}

Status from_json(td_api::emailAddressAuthenticationGoogleId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::fileTypeNone &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeSecretThumbnail &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::fileTypeVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::giftForResaleOrderPrice &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::groupCallJoinParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.audio_source_id_, from.extract_field("audio_source_id")));
  TRY_STATUS(from_json(to.payload_, from.extract_field("payload")));
  TRY_STATUS(from_json(to.is_muted_, from.extract_field("is_muted")));
  TRY_STATUS(from_json(to.is_my_video_enabled_, from.extract_field("is_my_video_enabled")));
  return Status::OK();
}

Status from_json(td_api::inlineKeyboardButtonTypeCallback &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::inlineQueryResultsButtonTypeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::inputChatPhotoSticker &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::inputFileId &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultAudio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.performer_, from.extract_field("performer")));
  TRY_STATUS(from_json(to.audio_url_, from.extract_field("audio_url")));
  TRY_STATUS(from_json(to.audio_duration_, from.extract_field("audio_duration")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputInlineQueryResultVoiceNote &to, JsonObject &from) {
  TRY_STATUS(from_json(to.id_, from.extract_field("id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  TRY_STATUS(from_json(to.voice_note_url_, from.extract_field("voice_note_url")));
  TRY_STATUS(from_json(to.voice_note_duration_, from.extract_field("voice_note_duration")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::inputMessagePhoto &to, JsonObject &from) {
  TRY_STATUS(from_json(to.photo_, from.extract_field("photo")));
  TRY_STATUS(from_json(to.thumbnail_, from.extract_field("thumbnail")));
  TRY_STATUS(from_json(to.added_sticker_file_ids_, from.extract_field("added_sticker_file_ids")));
  TRY_STATUS(from_json(to.width_, from.extract_field("width")));
  TRY_STATUS(from_json(to.height_, from.extract_field("height")));
  TRY_STATUS(from_json(to.caption_, from.extract_field("caption")));
  TRY_STATUS(from_json(to.show_caption_above_media_, from.extract_field("show_caption_above_media")));
  TRY_STATUS(from_json(to.self_destruct_type_, from.extract_field("self_destruct_type")));
  TRY_STATUS(from_json(to.has_spoiler_, from.extract_field("has_spoiler")));
  return Status::OK();
}

Status from_json(td_api::inputMessageGame &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.game_short_name_, from.extract_field("game_short_name")));
  return Status::OK();
}

Status from_json(td_api::inputMessageReplyToStory &to, JsonObject &from) {
  TRY_STATUS(from_json(to.story_poster_chat_id_, from.extract_field("story_poster_chat_id")));
  TRY_STATUS(from_json(to.story_id_, from.extract_field("story_id")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.address_, from.extract_field("address")));
  return Status::OK();
}

Status from_json(td_api::inputPassportElementErrorSourceUnspecified &to, JsonObject &from) {
  TRY_STATUS(from_json_bytes(to.element_hash_, from.extract_field("element_hash")));
  return Status::OK();
}

Status from_json(td_api::inputPersonalDocument &to, JsonObject &from) {
  TRY_STATUS(from_json(to.files_, from.extract_field("files")));
  TRY_STATUS(from_json(to.translation_, from.extract_field("translation")));
  return Status::OK();
}

Status from_json(td_api::inputStoryAreaTypeWeather &to, JsonObject &from) {
  TRY_STATUS(from_json(to.temperature_, from.extract_field("temperature")));
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  TRY_STATUS(from_json(to.background_color_, from.extract_field("background_color")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeAttachmentMenuBot &to, JsonObject &from) {
  TRY_STATUS(from_json(to.target_chat_, from.extract_field("target_chat")));
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeChatAffiliateProgram &to, JsonObject &from) {
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  TRY_STATUS(from_json(to.referrer_, from.extract_field("referrer")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeGiftAuction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.auction_id_, from.extract_field("auction_id")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeMainWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_username_, from.extract_field("bot_username")));
  TRY_STATUS(from_json(to.start_parameter_, from.extract_field("start_parameter")));
  TRY_STATUS(from_json(to.mode_, from.extract_field("mode")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypePremiumFeatures &to, JsonObject &from) {
  TRY_STATUS(from_json(to.referrer_, from.extract_field("referrer")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeStickerSet &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_set_name_, from.extract_field("sticker_set_name")));
  TRY_STATUS(from_json(to.expect_custom_emoji_, from.extract_field("expect_custom_emoji")));
  return Status::OK();
}

Status from_json(td_api::internalLinkTypeUserToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::jsonValueArray &to, JsonObject &from) {
  TRY_STATUS(from_json(to.values_, from.extract_field("values")));
  return Status::OK();
}

Status from_json(td_api::keyboardButtonTypeWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  return Status::OK();
}

Status from_json(td_api::locationAddress &to, JsonObject &from) {
  TRY_STATUS(from_json(to.country_code_, from.extract_field("country_code")));
  TRY_STATUS(from_json(to.state_, from.extract_field("state")));
  TRY_STATUS(from_json(to.city_, from.extract_field("city")));
  TRY_STATUS(from_json(to.street_, from.extract_field("street")));
  return Status::OK();
}

Status from_json(td_api::messageAutoDeleteTime &to, JsonObject &from) {
  TRY_STATUS(from_json(to.time_, from.extract_field("time")));
  return Status::OK();
}

Status from_json(td_api::messageSenderChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::messageSourceNotification &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::networkTypeNone &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::optionValueBoolean &to, JsonObject &from) {
  TRY_STATUS(from_json(to.value_, from.extract_field("value")));
  return Status::OK();
}

Status from_json(td_api::passportElementTypePassport &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::passportElementTypeTemporaryRegistration &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::pollTypeQuiz &to, JsonObject &from) {
  TRY_STATUS(from_json(to.correct_option_id_, from.extract_field("correct_option_id")));
  TRY_STATUS(from_json(to.explanation_, from.extract_field("explanation")));
  return Status::OK();
}

Status from_json(td_api::premiumFeatureAdvancedChatManagement &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumFeatureAccentColor &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeSupergroupCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeCaptionLength &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumLimitTypeSimilarChatCount &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::premiumStoryFeaturePermanentViewsHistory &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::profileTabLinks &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::reactionNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_reaction_source_, from.extract_field("message_reaction_source")));
  TRY_STATUS(from_json(to.story_reaction_source_, from.extract_field("story_reaction_source")));
  TRY_STATUS(from_json(to.sound_id_, from.extract_field("sound_id")));
  TRY_STATUS(from_json(to.show_preview_, from.extract_field("show_preview")));
  return Status::OK();
}

Status from_json(td_api::replyMarkupForceReply &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_personal_, from.extract_field("is_personal")));
  TRY_STATUS(from_json(to.input_field_placeholder_, from.extract_field("input_field_placeholder")));
  return Status::OK();
}

Status from_json(td_api::reportReasonFake &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesChatTypeFilterGroup &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterPhotoAndVideo &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::searchMessagesFilterPinned &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::storePaymentPurposePremiumSubscription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.is_restore_, from.extract_field("is_restore")));
  TRY_STATUS(from_json(to.is_upgrade_, from.extract_field("is_upgrade")));
  return Status::OK();
}

Status from_json(td_api::storyAreaPosition &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_percentage_, from.extract_field("x_percentage")));
  TRY_STATUS(from_json(to.y_percentage_, from.extract_field("y_percentage")));
  TRY_STATUS(from_json(to.width_percentage_, from.extract_field("width_percentage")));
  TRY_STATUS(from_json(to.height_percentage_, from.extract_field("height_percentage")));
  TRY_STATUS(from_json(to.rotation_angle_, from.extract_field("rotation_angle")));
  TRY_STATUS(from_json(to.corner_radius_percentage_, from.extract_field("corner_radius_percentage")));
  return Status::OK();
}

Status from_json(td_api::suggestedActionCheckPassword &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::suggestedActionSetBirthdate &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::supergroupMembersFilterRecent &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::targetChatChosen &to, JsonObject &from) {
  TRY_STATUS(from_json(to.types_, from.extract_field("types")));
  return Status::OK();
}

Status from_json(td_api::telegramPaymentPurposeJoinChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::textEntityTypeEmailAddress &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textEntityTypePre &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::textParseModeHTML &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::topChatCategoryForwardChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingShowLinkInForwardedMessages &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::userPrivacySettingRuleRestrictAll &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::webAppOpenModeFullScreen &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::addChatToList &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.chat_list_, from.extract_field("chat_list")));
  return Status::OK();
}

Status from_json(td_api::addLoginPasskey &to, JsonObject &from) {
  TRY_STATUS(from_json(to.client_data_, from.extract_field("client_data")));
  TRY_STATUS(from_json_bytes(to.attestation_object_, from.extract_field("attestation_object")));
  return Status::OK();
}

Status from_json(td_api::addQuickReplyShortcutMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_name_, from.extract_field("shortcut_name")));
  TRY_STATUS(from_json(to.reply_to_message_id_, from.extract_field("reply_to_message_id")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::allowUnpaidMessagesFromUser &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.refund_payments_, from.extract_field("refund_payments")));
  return Status::OK();
}

Status from_json(td_api::assignStoreTransaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.transaction_, from.extract_field("transaction")));
  TRY_STATUS(from_json(to.purpose_, from.extract_field("purpose")));
  return Status::OK();
}

Status from_json(td_api::canSendGift &to, JsonObject &from) {
  TRY_STATUS(from_json(to.gift_id_, from.extract_field("gift_id")));
  return Status::OK();
}

Status from_json(td_api::checkAuthenticationBotToken &to, JsonObject &from) {
  TRY_STATUS(from_json(to.token_, from.extract_field("token")));
  return Status::OK();
}

Status from_json(td_api::checkChatUsername &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.username_, from.extract_field("username")));
  return Status::OK();
}

Status from_json(td_api::checkStickerSetName &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  return Status::OK();
}

Status from_json(td_api::clearRecentlyFoundChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::closeSecretChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.secret_chat_id_, from.extract_field("secret_chat_id")));
  return Status::OK();
}

Status from_json(td_api::createBusinessChatLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_info_, from.extract_field("link_info")));
  return Status::OK();
}

Status from_json(td_api::createInvoiceLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.invoice_, from.extract_field("invoice")));
  return Status::OK();
}

Status from_json(td_api::createTemporaryPassword &to, JsonObject &from) {
  TRY_STATUS(from_json(to.password_, from.extract_field("password")));
  TRY_STATUS(from_json(to.valid_for_, from.extract_field("valid_for")));
  return Status::OK();
}

Status from_json(td_api::deleteBusinessChatLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::deleteChatMessagesByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.min_date_, from.extract_field("min_date")));
  TRY_STATUS(from_json(to.max_date_, from.extract_field("max_date")));
  TRY_STATUS(from_json(to.revoke_, from.extract_field("revoke")));
  return Status::OK();
}

Status from_json(td_api::deleteGiftCollection &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.collection_id_, from.extract_field("collection_id")));
  return Status::OK();
}

Status from_json(td_api::deleteRevokedChatInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  return Status::OK();
}

Status from_json(td_api::disableAllSupergroupUsernames &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  return Status::OK();
}

Status from_json(td_api::editBusinessChatLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  TRY_STATUS(from_json(to.link_info_, from.extract_field("link_info")));
  return Status::OK();
}

Status from_json(td_api::editChatFolderInviteLink &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  TRY_STATUS(from_json(to.invite_link_, from.extract_field("invite_link")));
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.chat_ids_, from.extract_field("chat_ids")));
  return Status::OK();
}

Status from_json(td_api::editInlineMessageText &to, JsonObject &from) {
  TRY_STATUS(from_json(to.inline_message_id_, from.extract_field("inline_message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::editQuickReplyMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_id_, from.extract_field("shortcut_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.input_message_content_, from.extract_field("input_message_content")));
  return Status::OK();
}

Status from_json(td_api::endGroupCallScreenSharing &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getApplicationDownloadLink &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getAvailableChatBoostSlots &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getBotMediaPreviewInfo &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  return Status::OK();
}

Status from_json(td_api::getBusinessConnection &to, JsonObject &from) {
  TRY_STATUS(from_json(to.connection_id_, from.extract_field("connection_id")));
  return Status::OK();
}

Status from_json(td_api::getChatAvailablePaidMessageReactionSenders &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatFolderChatCount &to, JsonObject &from) {
  TRY_STATUS(from_json(to.folder_, from.extract_field("folder")));
  return Status::OK();
}

Status from_json(td_api::getChatInviteLinks &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.creator_user_id_, from.extract_field("creator_user_id")));
  TRY_STATUS(from_json(to.is_revoked_, from.extract_field("is_revoked")));
  TRY_STATUS(from_json(to.offset_date_, from.extract_field("offset_date")));
  TRY_STATUS(from_json(to.offset_invite_link_, from.extract_field("offset_invite_link")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getChatPinnedMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getChatSponsoredMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getCommands &to, JsonObject &from) {
  TRY_STATUS(from_json(to.scope_, from.extract_field("scope")));
  TRY_STATUS(from_json(to.language_code_, from.extract_field("language_code")));
  return Status::OK();
}

Status from_json(td_api::getCurrentState &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getDefaultEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getEmojiReaction &to, JsonObject &from) {
  TRY_STATUS(from_json(to.emoji_, from.extract_field("emoji")));
  return Status::OK();
}

Status from_json(td_api::getForumTopic &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  return Status::OK();
}

Status from_json(td_api::getGiftCollections &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  return Status::OK();
}

Status from_json(td_api::getGroupCallStreams &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  return Status::OK();
}

Status from_json(td_api::getInternalLinkType &to, JsonObject &from) {
  TRY_STATUS(from_json(to.link_, from.extract_field("link")));
  return Status::OK();
}

Status from_json(td_api::getLiveStoryRtmpUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::getLoginUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.button_id_, from.extract_field("button_id")));
  TRY_STATUS(from_json(to.allow_write_access_, from.extract_field("allow_write_access")));
  return Status::OK();
}

Status from_json(td_api::getMessageAuthor &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getMessageProperties &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::getNewChatPrivacySettings &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getPasswordState &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getPremiumGiveawayPaymentOptions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.boosted_chat_id_, from.extract_field("boosted_chat_id")));
  return Status::OK();
}

Status from_json(td_api::getPublicPostSearchLimits &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  return Status::OK();
}

Status from_json(td_api::getRecentlyVisitedTMeUrls &to, JsonObject &from) {
  TRY_STATUS(from_json(to.referrer_, from.extract_field("referrer")));
  return Status::OK();
}

Status from_json(td_api::getSavedMessagesTopicMessageByDate &to, JsonObject &from) {
  TRY_STATUS(from_json(to.saved_messages_topic_id_, from.extract_field("saved_messages_topic_id")));
  TRY_STATUS(from_json(to.date_, from.extract_field("date")));
  return Status::OK();
}

Status from_json(td_api::getStarAdAccountUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  return Status::OK();
}

Status from_json(td_api::getStickerEmojis &to, JsonObject &from) {
  TRY_STATUS(from_json(to.sticker_, from.extract_field("sticker")));
  return Status::OK();
}

Status from_json(td_api::getStoryAlbumStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getSuitablePersonalChats &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getThemedChatEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUpgradedGiftEmojiStatuses &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::getUserProfileAudios &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.offset_, from.extract_field("offset")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::getWebAppUrl &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  return Status::OK();
}

Status from_json(td_api::inviteVideoChatParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::leaveChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  return Status::OK();
}

Status from_json(td_api::logOut &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::openWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.url_, from.extract_field("url")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.parameters_, from.extract_field("parameters")));
  return Status::OK();
}

Status from_json(td_api::processChatFolderNewChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_folder_id_, from.extract_field("chat_folder_id")));
  TRY_STATUS(from_json(to.added_chat_ids_, from.extract_field("added_chat_ids")));
  return Status::OK();
}

Status from_json(td_api::readAllForumTopicMentions &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  return Status::OK();
}

Status from_json(td_api::refundStarPayment &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_id_, from.extract_field("user_id")));
  TRY_STATUS(from_json(to.telegram_payment_charge_id_, from.extract_field("telegram_payment_charge_id")));
  return Status::OK();
}

Status from_json(td_api::removeGiftCollectionGifts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.owner_id_, from.extract_field("owner_id")));
  TRY_STATUS(from_json(to.collection_id_, from.extract_field("collection_id")));
  TRY_STATUS(from_json(to.received_gift_ids_, from.extract_field("received_gift_ids")));
  return Status::OK();
}

Status from_json(td_api::removeProfileAudio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.file_id_, from.extract_field("file_id")));
  return Status::OK();
}

Status from_json(td_api::removeStoryAlbumStories &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.story_album_id_, from.extract_field("story_album_id")));
  TRY_STATUS(from_json(to.story_ids_, from.extract_field("story_ids")));
  return Status::OK();
}

Status from_json(td_api::reorderQuickReplyShortcuts &to, JsonObject &from) {
  TRY_STATUS(from_json(to.shortcut_ids_, from.extract_field("shortcut_ids")));
  return Status::OK();
}

Status from_json(td_api::reportChat &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json_bytes(to.option_id_, from.extract_field("option_id")));
  TRY_STATUS(from_json(to.message_ids_, from.extract_field("message_ids")));
  TRY_STATUS(from_json(to.text_, from.extract_field("text")));
  return Status::OK();
}

Status from_json(td_api::reportVideoMessageAdvertisement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.advertisement_unique_id_, from.extract_field("advertisement_unique_id")));
  TRY_STATUS(from_json_bytes(to.option_id_, from.extract_field("option_id")));
  return Status::OK();
}

Status from_json(td_api::resendRecoveryEmailAddressCode &to, JsonObject &from) {
  return Status::OK();
}

Status from_json(td_api::saveApplicationLogEvent &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::searchChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchOutgoingDocumentMessages &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchRecentlyFoundChats &to, JsonObject &from) {
  TRY_STATUS(from_json(to.query_, from.extract_field("query")));
  TRY_STATUS(from_json(to.limit_, from.extract_field("limit")));
  return Status::OK();
}

Status from_json(td_api::searchWebApp &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.web_app_short_name_, from.extract_field("web_app_short_name")));
  return Status::OK();
}

Status from_json(td_api::sendCallSignalingData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.call_id_, from.extract_field("call_id")));
  TRY_STATUS(from_json_bytes(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::sendMessageAlbum &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.topic_id_, from.extract_field("topic_id")));
  TRY_STATUS(from_json(to.reply_to_, from.extract_field("reply_to")));
  TRY_STATUS(from_json(to.options_, from.extract_field("options")));
  TRY_STATUS(from_json(to.input_message_contents_, from.extract_field("input_message_contents")));
  return Status::OK();
}

Status from_json(td_api::sendWebAppData &to, JsonObject &from) {
  TRY_STATUS(from_json(to.bot_user_id_, from.extract_field("bot_user_id")));
  TRY_STATUS(from_json(to.button_text_, from.extract_field("button_text")));
  TRY_STATUS(from_json(to.data_, from.extract_field("data")));
  return Status::OK();
}

Status from_json(td_api::setAutoDownloadSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::setBusinessAccountBio &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.bio_, from.extract_field("bio")));
  return Status::OK();
}

Status from_json(td_api::setBusinessMessageIsPinned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.business_connection_id_, from.extract_field("business_connection_id")));
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.is_pinned_, from.extract_field("is_pinned")));
  return Status::OK();
}

Status from_json(td_api::setChatDescription &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.description_, from.extract_field("description")));
  return Status::OK();
}

Status from_json(td_api::setChatNotificationSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.notification_settings_, from.extract_field("notification_settings")));
  return Status::OK();
}

Status from_json(td_api::setCloseFriends &to, JsonObject &from) {
  TRY_STATUS(from_json(to.user_ids_, from.extract_field("user_ids")));
  return Status::OK();
}

Status from_json(td_api::setDefaultMessageAutoDeleteTime &to, JsonObject &from) {
  TRY_STATUS(from_json(to.message_auto_delete_time_, from.extract_field("message_auto_delete_time")));
  return Status::OK();
}

Status from_json(td_api::setGiftSettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setLogVerbosityLevel &to, JsonObject &from) {
  TRY_STATUS(from_json(to.new_verbosity_level_, from.extract_field("new_verbosity_level")));
  return Status::OK();
}

Status from_json(td_api::setNetworkType &to, JsonObject &from) {
  TRY_STATUS(from_json(to.type_, from.extract_field("type")));
  return Status::OK();
}

Status from_json(td_api::setPinnedForumTopics &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_ids_, from.extract_field("forum_topic_ids")));
  return Status::OK();
}

Status from_json(td_api::setReadDatePrivacySettings &to, JsonObject &from) {
  TRY_STATUS(from_json(to.settings_, from.extract_field("settings")));
  return Status::OK();
}

Status from_json(td_api::setStickerSetTitle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.name_, from.extract_field("name")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::setTdlibParameters &to, JsonObject &from) {
  TRY_STATUS(from_json(to.use_test_dc_, from.extract_field("use_test_dc")));
  TRY_STATUS(from_json(to.database_directory_, from.extract_field("database_directory")));
  TRY_STATUS(from_json(to.files_directory_, from.extract_field("files_directory")));
  TRY_STATUS(from_json_bytes(to.database_encryption_key_, from.extract_field("database_encryption_key")));
  TRY_STATUS(from_json(to.use_file_database_, from.extract_field("use_file_database")));
  TRY_STATUS(from_json(to.use_chat_info_database_, from.extract_field("use_chat_info_database")));
  TRY_STATUS(from_json(to.use_message_database_, from.extract_field("use_message_database")));
  TRY_STATUS(from_json(to.use_secret_chats_, from.extract_field("use_secret_chats")));
  TRY_STATUS(from_json(to.api_id_, from.extract_field("api_id")));
  TRY_STATUS(from_json(to.api_hash_, from.extract_field("api_hash")));
  TRY_STATUS(from_json(to.system_language_code_, from.extract_field("system_language_code")));
  TRY_STATUS(from_json(to.device_model_, from.extract_field("device_model")));
  TRY_STATUS(from_json(to.system_version_, from.extract_field("system_version")));
  TRY_STATUS(from_json(to.application_version_, from.extract_field("application_version")));
  return Status::OK();
}

Status from_json(td_api::setVideoChatTitle &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.title_, from.extract_field("title")));
  return Status::OK();
}

Status from_json(td_api::stopPoll &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  TRY_STATUS(from_json(to.reply_markup_, from.extract_field("reply_markup")));
  return Status::OK();
}

Status from_json(td_api::testCallString &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::testSquareInt &to, JsonObject &from) {
  TRY_STATUS(from_json(to.x_, from.extract_field("x")));
  return Status::OK();
}

Status from_json(td_api::toggleChatGiftNotifications &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.are_enabled_, from.extract_field("are_enabled")));
  return Status::OK();
}

Status from_json(td_api::toggleForumTopicIsPinned &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.forum_topic_id_, from.extract_field("forum_topic_id")));
  TRY_STATUS(from_json(to.is_pinned_, from.extract_field("is_pinned")));
  return Status::OK();
}

Status from_json(td_api::toggleHasSponsoredMessagesEnabled &to, JsonObject &from) {
  TRY_STATUS(from_json(to.has_sponsored_messages_enabled_, from.extract_field("has_sponsored_messages_enabled")));
  return Status::OK();
}

Status from_json(td_api::toggleSupergroupIsAllHistoryAvailable &to, JsonObject &from) {
  TRY_STATUS(from_json(to.supergroup_id_, from.extract_field("supergroup_id")));
  TRY_STATUS(from_json(to.is_all_history_available_, from.extract_field("is_all_history_available")));
  return Status::OK();
}

Status from_json(td_api::toggleVideoChatMuteNewParticipants &to, JsonObject &from) {
  TRY_STATUS(from_json(to.group_call_id_, from.extract_field("group_call_id")));
  TRY_STATUS(from_json(to.mute_new_participants_, from.extract_field("mute_new_participants")));
  return Status::OK();
}

Status from_json(td_api::unpinChatMessage &to, JsonObject &from) {
  TRY_STATUS(from_json(to.chat_id_, from.extract_field("chat_id")));
  TRY_STATUS(from_json(to.message_id_, from.extract_field("message_id")));
  return Status::OK();
}

Status from_json(td_api::viewVideoMessageAdvertisement &to, JsonObject &from) {
  TRY_STATUS(from_json(to.advertisement_unique_id_, from.extract_field("advertisement_unique_id")));
  return Status::OK();
}

void to_json(JsonValueScope &jv, const td_api::address &object) {
  auto jo = jv.enter_object();
  jo("@type", "address");
  jo("country_code", object.country_code_);
  jo("state", object.state_);
  jo("city", object.city_);
  jo("street_line1", object.street_line1_);
  jo("street_line2", object.street_line2_);
  jo("postal_code", object.postal_code_);
}

void to_json(JsonValueScope &jv, const td_api::animation &object) {
  auto jo = jv.enter_object();
  jo("@type", "animation");
  jo("duration", object.duration_);
  jo("width", object.width_);
  jo("height", object.height_);
  jo("file_name", object.file_name_);
  jo("mime_type", object.mime_type_);
  jo("has_stickers", JsonBool{object.has_stickers_});
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::audios &object) {
  auto jo = jv.enter_object();
  jo("@type", "audios");
  jo("total_count", object.total_count_);
  jo("audios", ToJson(object.audios_));
}

void to_json(JsonValueScope &jv, const td_api::availableGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "availableGift");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("resale_count", object.resale_count_);
  jo("min_resale_star_count", object.min_resale_star_count_);
  jo("title", object.title_);
}

void to_json(JsonValueScope &jv, const td_api::bankCardInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "bankCardInfo");
  jo("title", object.title_);
  jo("actions", ToJson(object.actions_));
}

void to_json(JsonValueScope &jv, const td_api::botMediaPreviewInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "botMediaPreviewInfo");
  jo("previews", ToJson(object.previews_));
  jo("language_codes", ToJson(object.language_codes_));
}

void to_json(JsonValueScope &jv, const td_api::businessBotManageBar &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessBotManageBar");
  jo("bot_user_id", object.bot_user_id_);
  jo("manage_url", object.manage_url_);
  jo("is_bot_paused", JsonBool{object.is_bot_paused_});
  jo("can_bot_reply", JsonBool{object.can_bot_reply_});
}

void to_json(JsonValueScope &jv, const td_api::businessFeatures &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessFeatures");
  jo("features", ToJson(object.features_));
}

void to_json(JsonValueScope &jv, const td_api::businessStartPage &object) {
  auto jo = jv.enter_object();
  jo("@type", "businessStartPage");
  jo("title", object.title_);
  jo("message", object.message_);
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::CallbackQueryPayload &object) {
  td_api::downcast_call(const_cast<td_api::CallbackQueryPayload &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::callbackQueryPayloadData &object) {
  auto jo = jv.enter_object();
  jo("@type", "callbackQueryPayloadData");
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::callbackQueryPayloadDataWithPassword &object) {
  auto jo = jv.enter_object();
  jo("@type", "callbackQueryPayloadDataWithPassword");
  jo("password", object.password_);
  jo("data", base64_encode(object.data_));
}

void to_json(JsonValueScope &jv, const td_api::callbackQueryPayloadGame &object) {
  auto jo = jv.enter_object();
  jo("@type", "callbackQueryPayloadGame");
  jo("game_short_name", object.game_short_name_);
}

void to_json(JsonValueScope &jv, const td_api::chatAdministrator &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatAdministrator");
  jo("user_id", object.user_id_);
  jo("custom_title", object.custom_title_);
  jo("is_owner", JsonBool{object.is_owner_});
}

void to_json(JsonValueScope &jv, const td_api::chatBoostLinkInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatBoostLinkInfo");
  jo("is_public", JsonBool{object.is_public_});
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatFolderIcon &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatFolderIcon");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::chatInviteLinkInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatInviteLinkInfo");
  jo("chat_id", object.chat_id_);
  jo("accessible_for", object.accessible_for_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("title", object.title_);
  if (object.photo_) {
    jo("photo", ToJson(*object.photo_));
  }
  jo("accent_color_id", object.accent_color_id_);
  jo("description", object.description_);
  jo("member_count", object.member_count_);
  jo("member_user_ids", ToJson(object.member_user_ids_));
  if (object.subscription_info_) {
    jo("subscription_info", ToJson(*object.subscription_info_));
  }
  jo("creates_join_request", JsonBool{object.creates_join_request_});
  jo("is_public", JsonBool{object.is_public_});
  if (object.verification_status_) {
    jo("verification_status", ToJson(*object.verification_status_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatLists &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatLists");
  jo("chat_lists", ToJson(object.chat_lists_));
}

void to_json(JsonValueScope &jv, const td_api::chatPhoto &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatPhoto");
  jo("id", ToJson(JsonInt64{object.id_}));
  jo("added_date", object.added_date_);
  if (object.minithumbnail_) {
    jo("minithumbnail", ToJson(*object.minithumbnail_));
  }
  jo("sizes", ToJson(object.sizes_));
  if (object.animation_) {
    jo("animation", ToJson(*object.animation_));
  }
  if (object.small_animation_) {
    jo("small_animation", ToJson(*object.small_animation_));
  }
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::ChatRevenueTransactionType &object) {
  td_api::downcast_call(const_cast<td_api::ChatRevenueTransactionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueTransactionTypeUnsupported &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueTransactionTypeUnsupported");
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueTransactionTypeSponsoredMessageEarnings &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueTransactionTypeSponsoredMessageEarnings");
  jo("start_date", object.start_date_);
  jo("end_date", object.end_date_);
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueTransactionTypeSuggestedPostEarnings &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueTransactionTypeSuggestedPostEarnings");
  jo("user_id", object.user_id_);
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueTransactionTypeFragmentWithdrawal &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueTransactionTypeFragmentWithdrawal");
  jo("withdrawal_date", object.withdrawal_date_);
  if (object.state_) {
    jo("state", ToJson(*object.state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::chatRevenueTransactionTypeFragmentRefund &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatRevenueTransactionTypeFragmentRefund");
  jo("refund_date", object.refund_date_);
}

void to_json(JsonValueScope &jv, const td_api::ChatTheme &object) {
  td_api::downcast_call(const_cast<td_api::ChatTheme &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::chatThemeEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatThemeEmoji");
  jo("name", object.name_);
}

void to_json(JsonValueScope &jv, const td_api::chatThemeGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "chatThemeGift");
  if (object.gift_theme_) {
    jo("gift_theme", ToJson(*object.gift_theme_));
  }
}

void to_json(JsonValueScope &jv, const td_api::collectibleItemInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "collectibleItemInfo");
  jo("purchase_date", object.purchase_date_);
  jo("currency", object.currency_);
  jo("amount", object.amount_);
  jo("cryptocurrency", object.cryptocurrency_);
  jo("cryptocurrency_amount", ToJson(JsonInt64{object.cryptocurrency_amount_}));
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::countryInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "countryInfo");
  jo("country_code", object.country_code_);
  jo("name", object.name_);
  jo("english_name", object.english_name_);
  jo("is_hidden", JsonBool{object.is_hidden_});
  jo("calling_codes", ToJson(object.calling_codes_));
}

void to_json(JsonValueScope &jv, const td_api::deepLinkInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "deepLinkInfo");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("need_update_application", JsonBool{object.need_update_application_});
}

void to_json(JsonValueScope &jv, const td_api::emojiCategory &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiCategory");
  jo("name", object.name_);
  if (object.icon_) {
    jo("icon", ToJson(*object.icon_));
  }
  if (object.source_) {
    jo("source", ToJson(*object.source_));
  }
  jo("is_greeting", JsonBool{object.is_greeting_});
}

void to_json(JsonValueScope &jv, const td_api::emojiStatuses &object) {
  auto jo = jv.enter_object();
  jo("@type", "emojiStatuses");
  jo("emoji_statuses", ToJson(object.emoji_statuses_));
}

void to_json(JsonValueScope &jv, const td_api::fileDownload &object) {
  auto jo = jv.enter_object();
  jo("@type", "fileDownload");
  jo("file_id", object.file_id_);
  if (object.message_) {
    jo("message", ToJson(*object.message_));
  }
  jo("add_date", object.add_date_);
  jo("complete_date", object.complete_date_);
  jo("is_paused", JsonBool{object.is_paused_});
}

void to_json(JsonValueScope &jv, const td_api::forwardSource &object) {
  auto jo = jv.enter_object();
  jo("@type", "forwardSource");
  jo("chat_id", object.chat_id_);
  jo("message_id", object.message_id_);
  if (object.sender_id_) {
    jo("sender_id", ToJson(*object.sender_id_));
  }
  jo("sender_name", object.sender_name_);
  jo("date", object.date_);
  jo("is_outgoing", JsonBool{object.is_outgoing_});
}

void to_json(JsonValueScope &jv, const td_api::foundPublicPosts &object) {
  auto jo = jv.enter_object();
  jo("@type", "foundPublicPosts");
  jo("messages", ToJson(object.messages_));
  jo("next_offset", object.next_offset_);
  if (object.search_limits_) {
    jo("search_limits", ToJson(*object.search_limits_));
  }
  jo("are_limits_exceeded", JsonBool{object.are_limits_exceeded_});
}

void to_json(JsonValueScope &jv, const td_api::giftAuctionAcquiredGift &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftAuctionAcquiredGift");
  if (object.receiver_id_) {
    jo("receiver_id", ToJson(*object.receiver_id_));
  }
  jo("date", object.date_);
  jo("star_count", object.star_count_);
  jo("auction_round_number", object.auction_round_number_);
  jo("auction_round_position", object.auction_round_position_);
  jo("unique_gift_number", object.unique_gift_number_);
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("is_private", JsonBool{object.is_private_});
}

void to_json(JsonValueScope &jv, const td_api::giftPurchaseLimits &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftPurchaseLimits");
  jo("total_count", object.total_count_);
  jo("remaining_count", object.remaining_count_);
}

void to_json(JsonValueScope &jv, const td_api::giftsForResale &object) {
  auto jo = jv.enter_object();
  jo("@type", "giftsForResale");
  jo("total_count", object.total_count_);
  jo("gifts", ToJson(object.gifts_));
  jo("models", ToJson(object.models_));
  jo("symbols", ToJson(object.symbols_));
  jo("backdrops", ToJson(object.backdrops_));
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::groupCallMessageLevel &object) {
  auto jo = jv.enter_object();
  jo("@type", "groupCallMessageLevel");
  jo("min_star_count", object.min_star_count_);
  jo("pin_duration", object.pin_duration_);
  jo("max_text_length", object.max_text_length_);
  jo("max_custom_emoji_count", object.max_custom_emoji_count_);
  jo("first_color", object.first_color_);
  jo("second_color", object.second_color_);
  jo("background_color", object.background_color_);
}

void to_json(JsonValueScope &jv, const td_api::httpUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "httpUrl");
  jo("url", object.url_);
}

void to_json(JsonValueScope &jv, const td_api::inputChecklist &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputChecklist");
  if (object.title_) {
    jo("title", ToJson(*object.title_));
  }
  jo("tasks", ToJson(object.tasks_));
  jo("others_can_add_tasks", JsonBool{object.others_can_add_tasks_});
  jo("others_can_mark_tasks_as_done", JsonBool{object.others_can_mark_tasks_as_done_});
}

void to_json(JsonValueScope &jv, const td_api::inputThumbnail &object) {
  auto jo = jv.enter_object();
  jo("@type", "inputThumbnail");
  if (object.thumbnail_) {
    jo("thumbnail", ToJson(*object.thumbnail_));
  }
  jo("width", object.width_);
  jo("height", object.height_);
}

void to_json(JsonValueScope &jv, const td_api::labeledPricePart &object) {
  auto jo = jv.enter_object();
  jo("@type", "labeledPricePart");
  jo("label", object.label_);
  jo("amount", object.amount_);
}

void to_json(JsonValueScope &jv, const td_api::liveStoryDonors &object) {
  auto jo = jv.enter_object();
  jo("@type", "liveStoryDonors");
  jo("total_star_count", object.total_star_count_);
  jo("top_donors", ToJson(object.top_donors_));
}

void to_json(JsonValueScope &jv, const td_api::mainWebApp &object) {
  auto jo = jv.enter_object();
  jo("@type", "mainWebApp");
  jo("url", object.url_);
  if (object.mode_) {
    jo("mode", ToJson(*object.mode_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messageEffect &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageEffect");
  jo("id", ToJson(JsonInt64{object.id_}));
  if (object.static_icon_) {
    jo("static_icon", ToJson(*object.static_icon_));
  }
  jo("emoji", object.emoji_);
  jo("is_premium", JsonBool{object.is_premium_});
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::messagePosition &object) {
  auto jo = jv.enter_object();
  jo("@type", "messagePosition");
  jo("position", object.position_);
  jo("message_id", object.message_id_);
  jo("date", object.date_);
}

void to_json(JsonValueScope &jv, const td_api::MessageSelfDestructType &object) {
  td_api::downcast_call(const_cast<td_api::MessageSelfDestructType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::messageSelfDestructTypeTimer &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSelfDestructTypeTimer");
  jo("self_destruct_time", object.self_destruct_time_);
}

void to_json(JsonValueScope &jv, const td_api::messageSelfDestructTypeImmediately &object) {
  auto jo = jv.enter_object();
  jo("@type", "messageSelfDestructTypeImmediately");
}

void to_json(JsonValueScope &jv, const td_api::messages &object) {
  auto jo = jv.enter_object();
  jo("@type", "messages");
  jo("total_count", object.total_count_);
  jo("messages", ToJson(object.messages_));
}

void to_json(JsonValueScope &jv, const td_api::NotificationSettingsScope &object) {
  td_api::downcast_call(const_cast<td_api::NotificationSettingsScope &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::notificationSettingsScopePrivateChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSettingsScopePrivateChats");
}

void to_json(JsonValueScope &jv, const td_api::notificationSettingsScopeGroupChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSettingsScopeGroupChats");
}

void to_json(JsonValueScope &jv, const td_api::notificationSettingsScopeChannelChats &object) {
  auto jo = jv.enter_object();
  jo("@type", "notificationSettingsScopeChannelChats");
}

void to_json(JsonValueScope &jv, const td_api::pageBlockCaption &object) {
  auto jo = jv.enter_object();
  jo("@type", "pageBlockCaption");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  if (object.credit_) {
    jo("credit", ToJson(*object.credit_));
  }
}

void to_json(JsonValueScope &jv, const td_api::passkey &object) {
  auto jo = jv.enter_object();
  jo("@type", "passkey");
  jo("id", object.id_);
  jo("name", object.name_);
  jo("addition_date", object.addition_date_);
  jo("last_usage_date", object.last_usage_date_);
  jo("software_icon_custom_emoji_id", ToJson(JsonInt64{object.software_icon_custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::passportRequiredElement &object) {
  auto jo = jv.enter_object();
  jo("@type", "passportRequiredElement");
  jo("suitable_elements", ToJson(object.suitable_elements_));
}

void to_json(JsonValueScope &jv, const td_api::paymentResult &object) {
  auto jo = jv.enter_object();
  jo("@type", "paymentResult");
  jo("success", JsonBool{object.success_});
  jo("verification_url", object.verification_url_);
}

void to_json(JsonValueScope &jv, const td_api::PollType &object) {
  td_api::downcast_call(const_cast<td_api::PollType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::pollTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "pollTypeRegular");
  jo("allow_multiple_answers", JsonBool{object.allow_multiple_answers_});
}

void to_json(JsonValueScope &jv, const td_api::pollTypeQuiz &object) {
  auto jo = jv.enter_object();
  jo("@type", "pollTypeQuiz");
  jo("correct_option_id", object.correct_option_id_);
  if (object.explanation_) {
    jo("explanation", ToJson(*object.explanation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::premiumLimit &object) {
  auto jo = jv.enter_object();
  jo("@type", "premiumLimit");
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
  jo("default_value", object.default_value_);
  jo("premium_value", object.premium_value_);
}

void to_json(JsonValueScope &jv, const td_api::profileAccentColor &object) {
  auto jo = jv.enter_object();
  jo("@type", "profileAccentColor");
  jo("id", object.id_);
  if (object.light_theme_colors_) {
    jo("light_theme_colors", ToJson(*object.light_theme_colors_));
  }
  if (object.dark_theme_colors_) {
    jo("dark_theme_colors", ToJson(*object.dark_theme_colors_));
  }
  jo("min_supergroup_chat_boost_level", object.min_supergroup_chat_boost_level_);
  jo("min_channel_chat_boost_level", object.min_channel_chat_boost_level_);
}

void to_json(JsonValueScope &jv, const td_api::publicPostSearchLimits &object) {
  auto jo = jv.enter_object();
  jo("@type", "publicPostSearchLimits");
  jo("daily_free_query_count", object.daily_free_query_count_);
  jo("remaining_free_query_count", object.remaining_free_query_count_);
  jo("next_free_query_in", object.next_free_query_in_);
  jo("star_count", object.star_count_);
  jo("is_current_query_free", JsonBool{object.is_current_query_free_});
}

void to_json(JsonValueScope &jv, const td_api::ReactionUnavailabilityReason &object) {
  td_api::downcast_call(const_cast<td_api::ReactionUnavailabilityReason &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::reactionUnavailabilityReasonAnonymousAdministrator &object) {
  auto jo = jv.enter_object();
  jo("@type", "reactionUnavailabilityReasonAnonymousAdministrator");
}

void to_json(JsonValueScope &jv, const td_api::reactionUnavailabilityReasonGuest &object) {
  auto jo = jv.enter_object();
  jo("@type", "reactionUnavailabilityReasonGuest");
}

void to_json(JsonValueScope &jv, const td_api::ReportChatResult &object) {
  td_api::downcast_call(const_cast<td_api::ReportChatResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::reportChatResultOk &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportChatResultOk");
}

void to_json(JsonValueScope &jv, const td_api::reportChatResultOptionRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportChatResultOptionRequired");
  jo("title", object.title_);
  jo("options", ToJson(object.options_));
}

void to_json(JsonValueScope &jv, const td_api::reportChatResultTextRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportChatResultTextRequired");
  jo("option_id", base64_encode(object.option_id_));
  jo("is_optional", JsonBool{object.is_optional_});
}

void to_json(JsonValueScope &jv, const td_api::reportChatResultMessagesRequired &object) {
  auto jo = jv.enter_object();
  jo("@type", "reportChatResultMessagesRequired");
}

void to_json(JsonValueScope &jv, const td_api::savedCredentials &object) {
  auto jo = jv.enter_object();
  jo("@type", "savedCredentials");
  jo("id", object.id_);
  jo("title", object.title_);
}

void to_json(JsonValueScope &jv, const td_api::SecretChatState &object) {
  td_api::downcast_call(const_cast<td_api::SecretChatState &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::secretChatStatePending &object) {
  auto jo = jv.enter_object();
  jo("@type", "secretChatStatePending");
}

void to_json(JsonValueScope &jv, const td_api::secretChatStateReady &object) {
  auto jo = jv.enter_object();
  jo("@type", "secretChatStateReady");
}

void to_json(JsonValueScope &jv, const td_api::secretChatStateClosed &object) {
  auto jo = jv.enter_object();
  jo("@type", "secretChatStateClosed");
}

void to_json(JsonValueScope &jv, const td_api::SpeechRecognitionResult &object) {
  td_api::downcast_call(const_cast<td_api::SpeechRecognitionResult &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::speechRecognitionResultPending &object) {
  auto jo = jv.enter_object();
  jo("@type", "speechRecognitionResultPending");
  jo("partial_text", object.partial_text_);
}

void to_json(JsonValueScope &jv, const td_api::speechRecognitionResultText &object) {
  auto jo = jv.enter_object();
  jo("@type", "speechRecognitionResultText");
  jo("text", object.text_);
}

void to_json(JsonValueScope &jv, const td_api::speechRecognitionResultError &object) {
  auto jo = jv.enter_object();
  jo("@type", "speechRecognitionResultError");
  if (object.error_) {
    jo("error", ToJson(*object.error_));
  }
}

void to_json(JsonValueScope &jv, const td_api::starGiveawayPaymentOptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "starGiveawayPaymentOptions");
  jo("options", ToJson(object.options_));
}

void to_json(JsonValueScope &jv, const td_api::starSubscriptions &object) {
  auto jo = jv.enter_object();
  jo("@type", "starSubscriptions");
  if (object.star_amount_) {
    jo("star_amount", ToJson(*object.star_amount_));
  }
  jo("subscriptions", ToJson(object.subscriptions_));
  jo("required_star_count", object.required_star_count_);
  jo("next_offset", object.next_offset_);
}

void to_json(JsonValueScope &jv, const td_api::StickerFullType &object) {
  td_api::downcast_call(const_cast<td_api::StickerFullType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::stickerFullTypeRegular &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerFullTypeRegular");
  if (object.premium_animation_) {
    jo("premium_animation", ToJson(*object.premium_animation_));
  }
}

void to_json(JsonValueScope &jv, const td_api::stickerFullTypeMask &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerFullTypeMask");
  if (object.mask_position_) {
    jo("mask_position", ToJson(*object.mask_position_));
  }
}

void to_json(JsonValueScope &jv, const td_api::stickerFullTypeCustomEmoji &object) {
  auto jo = jv.enter_object();
  jo("@type", "stickerFullTypeCustomEmoji");
  jo("custom_emoji_id", ToJson(JsonInt64{object.custom_emoji_id_}));
  jo("needs_repainting", JsonBool{object.needs_repainting_});
}

void to_json(JsonValueScope &jv, const td_api::storageStatisticsFast &object) {
  auto jo = jv.enter_object();
  jo("@type", "storageStatisticsFast");
  jo("files_size", object.files_size_);
  jo("file_count", object.file_count_);
  jo("database_size", object.database_size_);
  jo("language_pack_database_size", object.language_pack_database_size_);
  jo("log_size", object.log_size_);
}

void to_json(JsonValueScope &jv, const td_api::storyInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyInfo");
  jo("story_id", object.story_id_);
  jo("date", object.date_);
  jo("is_for_close_friends", JsonBool{object.is_for_close_friends_});
  jo("is_live", JsonBool{object.is_live_});
}

void to_json(JsonValueScope &jv, const td_api::storyStatistics &object) {
  auto jo = jv.enter_object();
  jo("@type", "storyStatistics");
  if (object.story_interaction_graph_) {
    jo("story_interaction_graph", ToJson(*object.story_interaction_graph_));
  }
  if (object.story_reaction_graph_) {
    jo("story_reaction_graph", ToJson(*object.story_reaction_graph_));
  }
}

void to_json(JsonValueScope &jv, const td_api::tMeUrl &object) {
  auto jo = jv.enter_object();
  jo("@type", "tMeUrl");
  jo("url", object.url_);
  if (object.type_) {
    jo("type", ToJson(*object.type_));
  }
}

void to_json(JsonValueScope &jv, const td_api::testString &object) {
  auto jo = jv.enter_object();
  jo("@type", "testString");
  jo("value", object.value_);
}

void to_json(JsonValueScope &jv, const td_api::textQuote &object) {
  auto jo = jv.enter_object();
  jo("@type", "textQuote");
  if (object.text_) {
    jo("text", ToJson(*object.text_));
  }
  jo("position", object.position_);
  jo("is_manual", JsonBool{object.is_manual_});
}

void to_json(JsonValueScope &jv, const td_api::TonTransactionType &object) {
  td_api::downcast_call(const_cast<td_api::TonTransactionType &>(object), [&jv](const auto &object) { to_json(jv, object); });
}

void to_json(JsonValueScope &jv, const td_api::tonTransactionTypeFragmentDeposit &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactionTypeFragmentDeposit");
  jo("is_gift", JsonBool{object.is_gift_});
  if (object.sticker_) {
    jo("sticker", ToJson(*object.sticker_));
  }
}

void to_json(JsonValueScope &jv, const td_api::tonTransactionTypeFragmentWithdrawal &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactionTypeFragmentWithdrawal");
  if (object.withdrawal_state_) {
    jo("withdrawal_state", ToJson(*object.withdrawal_state_));
  }
}

void to_json(JsonValueScope &jv, const td_api::tonTransactionTypeSuggestedPostPayment &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactionTypeSuggestedPostPayment");
  jo("chat_id", object.chat_id_);
}

void to_json(JsonValueScope &jv, const td_api::tonTransactionTypeGiftPurchaseOffer &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactionTypeGiftPurchaseOffer");
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::tonTransactionTypeUpgradedGiftPurchase &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactionTypeUpgradedGiftPurchase");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
}

void to_json(JsonValueScope &jv, const td_api::tonTransactionTypeUpgradedGiftSale &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactionTypeUpgradedGiftSale");
  jo("user_id", object.user_id_);
  if (object.gift_) {
    jo("gift", ToJson(*object.gift_));
  }
  jo("commission_per_mille", object.commission_per_mille_);
  jo("commission_toncoin_amount", object.commission_toncoin_amount_);
  jo("via_offer", JsonBool{object.via_offer_});
}

void to_json(JsonValueScope &jv, const td_api::tonTransactionTypeUnsupported &object) {
  auto jo = jv.enter_object();
  jo("@type", "tonTransactionTypeUnsupported");
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftBackdrop &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftBackdrop");
  jo("id", object.id_);
  jo("name", object.name_);
  if (object.colors_) {
    jo("colors", ToJson(*object.colors_));
  }
  jo("rarity_per_mille", object.rarity_per_mille_);
}

void to_json(JsonValueScope &jv, const td_api::upgradedGiftSymbolCount &object) {
  auto jo = jv.enter_object();
  jo("@type", "upgradedGiftSymbolCount");
  if (object.symbol_) {
    jo("symbol", ToJson(*object.symbol_));
  }
  jo("total_count", object.total_count_);
}

void to_json(JsonValueScope &jv, const td_api::userRating &object) {
  auto jo = jv.enter_object();
  jo("@type", "userRating");
  jo("level", object.level_);
  jo("is_maximum_level_reached", JsonBool{object.is_maximum_level_reached_});
  jo("rating", object.rating_);
  jo("current_level_rating", object.current_level_rating_);
  jo("next_level_rating", object.next_level_rating_);
}

void to_json(JsonValueScope &jv, const td_api::verificationStatus &object) {
  auto jo = jv.enter_object();
  jo("@type", "verificationStatus");
  jo("is_verified", JsonBool{object.is_verified_});
  jo("is_scam", JsonBool{object.is_scam_});
  jo("is_fake", JsonBool{object.is_fake_});
  jo("bot_verification_icon_custom_emoji_id", ToJson(JsonInt64{object.bot_verification_icon_custom_emoji_id_}));
}

void to_json(JsonValueScope &jv, const td_api::webAppInfo &object) {
  auto jo = jv.enter_object();
  jo("@type", "webAppInfo");
  jo("launch_id", ToJson(JsonInt64{object.launch_id_}));
  jo("url", object.url_);
}

}  // namespace td_api
}  // namespace td
