#pragma once

#include <cstddef>
#include <cstdint>
#include <map>
#include <optional>
#include <spb/json.hpp>
#include <spb/pb.hpp>
#include <string>
#include <vector>

namespace libcore
{
struct ConnectionMetaData;

struct EmptyReq
{
};
struct EmptyResp
{
};
struct ErrorResp
{
std::optional<std::string> error = "";
};
struct LoadConfigReq
{
std::optional<std::string> core_config = "";
std::optional<bool> disable_stats = false;
std::optional<bool> need_extra_process = false;
std::optional<std::string> extra_process_path = "";
std::optional<std::string> extra_process_args = "";
std::optional<std::string> extra_process_conf = "";
std::optional<std::string> extra_process_conf_dir = "";
std::optional<bool> extra_no_out = false;
};
struct URLTestResp
{
std::optional<std::string> outbound_tag = "";
std::optional<int32_t> latency_ms = 0;
std::optional<std::string> error = "";
};
struct TestReq
{
std::optional<std::string> config = "";
std::vector<std::string> outbound_tags;
std::optional<bool> use_default_outbound = false;
std::optional<std::string> url = "";
std::optional<bool> test_current = false;
std::optional<int32_t> max_concurrency = 0;
std::optional<int32_t> test_timeout_ms = 0;
};
struct TestResp
{
std::vector<URLTestResp> results;
};
struct QueryStatsResp
{
std::map< std::string, int64_t > ups;
std::map< std::string, int64_t > downs;
};
struct ListConnectionsResp
{
std::vector<ConnectionMetaData> connections;
};
struct ConnectionMetaData
{
std::optional<std::string> id = "";
std::optional<int64_t> created_at = 0LL;
std::optional<int64_t> upload = 0LL;
std::optional<int64_t> download = 0LL;
std::optional<std::string> outbound = "";
std::optional<std::string> network = "";
std::optional<std::string> dest = "";
std::optional<std::string> protocol = "";
std::optional<std::string> domain = "";
std::optional<std::string> process = "";
};
struct SetSystemDNSRequest
{
std::optional<bool> clear = false;
};
struct IsPrivilegedResponse
{
std::optional<bool> has_privilege = false;
};
struct SpeedTestRequest
{
std::optional<std::string> config = "";
std::vector<std::string> outbound_tags;
std::optional<bool> test_current = false;
std::optional<bool> use_default_outbound = false;
std::optional<bool> test_download = false;
std::optional<bool> test_upload = false;
std::optional<bool> simple_download = false;
std::optional<std::string> simple_download_addr = "";
std::optional<int32_t> timeout_ms = 0;
std::optional<bool> only_country = false;
std::optional<int32_t> country_concurrency = 0;
};
struct SpeedTestResult
{
std::optional<std::string> dl_speed = "";
std::optional<std::string> ul_speed = "";
std::optional<int32_t> latency = 0;
std::optional<std::string> outbound_tag = "";
std::optional<std::string> error = "";
std::optional<std::string> server_name = "";
std::optional<std::string> server_country = "";
std::optional<bool> cancelled = false;
};
struct SpeedTestResponse
{
std::vector<SpeedTestResult> results;
};
struct QuerySpeedTestResponse
{
std::optional<SpeedTestResult> result;
std::optional<bool> is_running = false;
};
struct QueryCountryTestResponse
{
std::vector<SpeedTestResult> results;
};
struct QueryURLTestResponse
{
std::vector<URLTestResp> results;
};
struct RuleSet
{
std::map< std::string, std::string > items;
};
}// namespace libcore

namespace spb::json::detail
{
struct ostream;
struct istream;

void serialize_value( ostream & stream, const libcore::EmptyReq & value );
void deserialize_value( istream & stream, libcore::EmptyReq & value );


void serialize_value( ostream & stream, const libcore::EmptyResp & value );
void deserialize_value( istream & stream, libcore::EmptyResp & value );


void serialize_value( ostream & stream, const libcore::ErrorResp & value );
void deserialize_value( istream & stream, libcore::ErrorResp & value );


void serialize_value( ostream & stream, const libcore::LoadConfigReq & value );
void deserialize_value( istream & stream, libcore::LoadConfigReq & value );


void serialize_value( ostream & stream, const libcore::URLTestResp & value );
void deserialize_value( istream & stream, libcore::URLTestResp & value );


void serialize_value( ostream & stream, const libcore::TestReq & value );
void deserialize_value( istream & stream, libcore::TestReq & value );


void serialize_value( ostream & stream, const libcore::TestResp & value );
void deserialize_value( istream & stream, libcore::TestResp & value );


void serialize_value( ostream & stream, const libcore::QueryStatsResp & value );
void deserialize_value( istream & stream, libcore::QueryStatsResp & value );


void serialize_value( ostream & stream, const libcore::ListConnectionsResp & value );
void deserialize_value( istream & stream, libcore::ListConnectionsResp & value );


void serialize_value( ostream & stream, const libcore::ConnectionMetaData & value );
void deserialize_value( istream & stream, libcore::ConnectionMetaData & value );


void serialize_value( ostream & stream, const libcore::SetSystemDNSRequest & value );
void deserialize_value( istream & stream, libcore::SetSystemDNSRequest & value );


void serialize_value( ostream & stream, const libcore::IsPrivilegedResponse & value );
void deserialize_value( istream & stream, libcore::IsPrivilegedResponse & value );


void serialize_value( ostream & stream, const libcore::SpeedTestRequest & value );
void deserialize_value( istream & stream, libcore::SpeedTestRequest & value );


void serialize_value( ostream & stream, const libcore::SpeedTestResult & value );
void deserialize_value( istream & stream, libcore::SpeedTestResult & value );


void serialize_value( ostream & stream, const libcore::SpeedTestResponse & value );
void deserialize_value( istream & stream, libcore::SpeedTestResponse & value );


void serialize_value( ostream & stream, const libcore::QuerySpeedTestResponse & value );
void deserialize_value( istream & stream, libcore::QuerySpeedTestResponse & value );


void serialize_value( ostream & stream, const libcore::QueryCountryTestResponse & value );
void deserialize_value( istream & stream, libcore::QueryCountryTestResponse & value );


void serialize_value( ostream & stream, const libcore::QueryURLTestResponse & value );
void deserialize_value( istream & stream, libcore::QueryURLTestResponse & value );


void serialize_value( ostream & stream, const libcore::RuleSet & value );
void deserialize_value( istream & stream, libcore::RuleSet & value );

} // namespace spb::json::detail
namespace spb::pb::detail
{
struct ostream;
struct istream;

void serialize( ostream & stream, const libcore::EmptyReq & value );
void deserialize_value( istream & stream, libcore::EmptyReq & value, uint32_t tag );


void serialize( ostream & stream, const libcore::EmptyResp & value );
void deserialize_value( istream & stream, libcore::EmptyResp & value, uint32_t tag );


void serialize( ostream & stream, const libcore::ErrorResp & value );
void deserialize_value( istream & stream, libcore::ErrorResp & value, uint32_t tag );


void serialize( ostream & stream, const libcore::LoadConfigReq & value );
void deserialize_value( istream & stream, libcore::LoadConfigReq & value, uint32_t tag );


void serialize( ostream & stream, const libcore::URLTestResp & value );
void deserialize_value( istream & stream, libcore::URLTestResp & value, uint32_t tag );


void serialize( ostream & stream, const libcore::TestReq & value );
void deserialize_value( istream & stream, libcore::TestReq & value, uint32_t tag );


void serialize( ostream & stream, const libcore::TestResp & value );
void deserialize_value( istream & stream, libcore::TestResp & value, uint32_t tag );


void serialize( ostream & stream, const libcore::QueryStatsResp & value );
void deserialize_value( istream & stream, libcore::QueryStatsResp & value, uint32_t tag );


void serialize( ostream & stream, const libcore::ListConnectionsResp & value );
void deserialize_value( istream & stream, libcore::ListConnectionsResp & value, uint32_t tag );


void serialize( ostream & stream, const libcore::ConnectionMetaData & value );
void deserialize_value( istream & stream, libcore::ConnectionMetaData & value, uint32_t tag );


void serialize( ostream & stream, const libcore::SetSystemDNSRequest & value );
void deserialize_value( istream & stream, libcore::SetSystemDNSRequest & value, uint32_t tag );


void serialize( ostream & stream, const libcore::IsPrivilegedResponse & value );
void deserialize_value( istream & stream, libcore::IsPrivilegedResponse & value, uint32_t tag );


void serialize( ostream & stream, const libcore::SpeedTestRequest & value );
void deserialize_value( istream & stream, libcore::SpeedTestRequest & value, uint32_t tag );


void serialize( ostream & stream, const libcore::SpeedTestResult & value );
void deserialize_value( istream & stream, libcore::SpeedTestResult & value, uint32_t tag );


void serialize( ostream & stream, const libcore::SpeedTestResponse & value );
void deserialize_value( istream & stream, libcore::SpeedTestResponse & value, uint32_t tag );


void serialize( ostream & stream, const libcore::QuerySpeedTestResponse & value );
void deserialize_value( istream & stream, libcore::QuerySpeedTestResponse & value, uint32_t tag );


void serialize( ostream & stream, const libcore::QueryCountryTestResponse & value );
void deserialize_value( istream & stream, libcore::QueryCountryTestResponse & value, uint32_t tag );


void serialize( ostream & stream, const libcore::QueryURLTestResponse & value );
void deserialize_value( istream & stream, libcore::QueryURLTestResponse & value, uint32_t tag );


void serialize( ostream & stream, const libcore::RuleSet & value );
void deserialize_value( istream & stream, libcore::RuleSet & value, uint32_t tag );

} // namespace spb::pb::detail
