/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\f*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/HolidayDates;", "", "<init>", "()V", "getHolidayByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "holiday", "Lcom/unciv/logic/HolidayDates$Holidays;", "year", "", "getHolidayByDate", "date", "Ljava/time/LocalDate;", "getMonth", "Ljava/time/Month;", "closestWeekday", "day", "Ljava/time/DayOfWeek;", "Holidays", "DateRange", "Tables", "core"})
@SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n295#2,2:399\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates\n*L\n158#1:399,2\n*E\n"})
public final class HolidayDates {
    @NotNull
    public static final HolidayDates INSTANCE = new HolidayDates();

    private HolidayDates() {
    }

    @NotNull
    public final DateRange getHolidayByYear(@NotNull Holidays holiday, int year2) {
        Intrinsics.checkNotNullParameter((Object)holiday, "holiday");
        return holiday.getByYear(year2);
    }

    @Nullable
    public final Holidays getHolidayByDate(@NotNull LocalDate date) {
        Object object;
        block4: {
            Object v2;
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter(date, "date");
                    object = System.getProperty("easterEgg");
                    if (object == null) break block3;
                    String it = object;
                    boolean bl = false;
                    Holidays holidays = Holidays.Companion.safeValueOf(it);
                    object = holidays;
                    if (holidays != null) break block4;
                }
                Iterable $this$firstOrNull$iv = Holidays.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Holidays it = (Holidays)((Object)element$iv);
                    boolean bl = false;
                    DateRange range = it.getByYear(date.getYear());
                    if (!(range.contains((Comparable)date) && Random.Default.nextFloat() <= it.getChance())) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            object = v2;
        }
        return object;
    }

    public static /* synthetic */ Holidays getHolidayByDate$default(HolidayDates holidayDates, LocalDate localDate, int n, Object object) {
        if ((n & 1) != 0) {
            LocalDate localDate2 = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue(localDate2, "now(...)");
            localDate = localDate2;
        }
        return holidayDates.getHolidayByDate(localDate);
    }

    @NotNull
    public final Month getMonth() {
        Object object;
        block3: {
            block2: {
                object = System.getProperty("month");
                if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) break block2;
                int it = ((Number)object).intValue();
                boolean bl = false;
                Month month = Month.of(it);
                object = month;
                if (month != null) break block3;
            }
            Month month = LocalDate.now().getMonth();
            object = month;
            Intrinsics.checkNotNullExpressionValue(month, "getMonth(...)");
        }
        return object;
    }

    private final LocalDate closestWeekday(LocalDate $this$closestWeekday, DayOfWeek day2) {
        LocalDate localDate;
        int delta = (7 + $this$closestWeekday.getDayOfWeek().ordinal() - day2.ordinal()) % 7;
        if (delta < 4) {
            LocalDate localDate2 = $this$closestWeekday.plusDays(delta);
            localDate = localDate2;
            Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
        } else {
            LocalDate localDate3 = $this$closestWeekday.minusDays(7 - delta);
            localDate = localDate3;
            Intrinsics.checkNotNullExpressionValue(localDate3, "minusDays(...)");
        }
        return localDate;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/unciv/logic/HolidayDates$DateRange;", "Lkotlin/ranges/ClosedRange;", "Ljava/time/LocalDate;", "start", "endInclusive", "<init>", "(Ljava/time/LocalDate;Ljava/time/LocalDate;)V", "getStart", "()Ljava/time/LocalDate;", "getEndInclusive", "length", "", "getLength", "()I", "toString", "", "equals", "", "other", "", "hashCode", "Companion", "core"})
    public static class DateRange
    implements ClosedRange<LocalDate> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LocalDate start;
        @NotNull
        private final LocalDate endInclusive;
        @NotNull
        private static final DateRange never;

        public DateRange(@NotNull LocalDate start2, @NotNull LocalDate endInclusive) {
            Intrinsics.checkNotNullParameter(start2, "start");
            Intrinsics.checkNotNullParameter(endInclusive, "endInclusive");
            this.start = start2;
            this.endInclusive = endInclusive;
        }

        @Override
        @NotNull
        public LocalDate getStart() {
            return this.start;
        }

        @Override
        @NotNull
        public LocalDate getEndInclusive() {
            return this.endInclusive;
        }

        public final int getLength() {
            return RangesKt.coerceAtLeast((int)this.getStart().until(this.getEndInclusive(), ChronoUnit.DAYS), 0);
        }

        @NotNull
        public String toString() {
            return this.getStart() + ".." + this.getEndInclusive();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DateRange)) {
                return false;
            }
            return Intrinsics.areEqual(this.getStart(), ((DateRange)other).getStart()) && Intrinsics.areEqual(this.getEndInclusive(), ((DateRange)other).getEndInclusive());
        }

        public int hashCode() {
            return 31 * this.getStart().hashCode() + this.getEndInclusive().hashCode();
        }

        static {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue(localDate, "now(...)");
            LocalDate localDate2 = LocalDate.now().plusDays(-1L);
            Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
            never = new DateRange(localDate, localDate2);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/HolidayDates$DateRange$Companion;", "", "<init>", "()V", "of", "Lcom/unciv/logic/HolidayDates$DateRange;", "date", "Ljava/time/LocalDate;", "year", "", "month", "day", "duration", "never", "getNever", "()Lcom/unciv/logic/HolidayDates$DateRange;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DateRange of(@NotNull LocalDate date) {
                Intrinsics.checkNotNullParameter(date, "date");
                return new DateRange(date, date);
            }

            @NotNull
            public final DateRange of(int year2, int month, int day2) {
                LocalDate localDate = LocalDate.of(year2, month, day2);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return this.of(localDate);
            }

            @NotNull
            public final DateRange of(@NotNull LocalDate date, int duration) {
                Intrinsics.checkNotNullParameter(date, "date");
                LocalDate localDate = date.plusDays((long)duration - 1L);
                Intrinsics.checkNotNullExpressionValue(localDate, "plusDays(...)");
                return new DateRange(date, localDate);
            }

            @NotNull
            public final DateRange of(int year2, int month, int day2, int duration) {
                LocalDate localDate = LocalDate.of(year2, month, day2);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return this.of(localDate, duration);
            }

            @NotNull
            public final DateRange getNever() {
                return never;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u0013\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u001c"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays;", "", "chance", "", "<init>", "(Ljava/lang/String;IF)V", "getChance", "()F", "Easter", "Samhain", "Xmas", "DiaDeLosMuertos", "YuleGoat", "Qingming", "Diwali", "LunarNewYear", "AprilFoolsDay", "PrideDay", "TowelDay", "UncivBirthday", "Friday13th", "StarWarsDay", "Passover", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "Companion", "core"})
    public static final abstract class Holidays
    extends Enum<Holidays> {
        @NotNull
        public static final Companion Companion;
        private final float chance;
        public static final /* enum */ Holidays Easter;
        public static final /* enum */ Holidays Samhain;
        public static final /* enum */ Holidays Xmas;
        public static final /* enum */ Holidays DiaDeLosMuertos;
        public static final /* enum */ Holidays YuleGoat;
        public static final /* enum */ Holidays Qingming;
        public static final /* enum */ Holidays Diwali;
        public static final /* enum */ Holidays LunarNewYear;
        public static final /* enum */ Holidays AprilFoolsDay;
        public static final /* enum */ Holidays PrideDay;
        public static final /* enum */ Holidays TowelDay;
        public static final /* enum */ Holidays UncivBirthday;
        public static final /* enum */ Holidays Friday13th;
        public static final /* enum */ Holidays StarWarsDay;
        public static final /* enum */ Holidays Passover;
        private static final /* synthetic */ Holidays[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Holidays(float chance) {
            this.chance = chance;
        }

        /* synthetic */ Holidays(String string, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                f = 1.0f;
            }
            this(f);
        }

        public final float getChance() {
            return this.chance;
        }

        @NotNull
        public abstract DateRange getByYear(int var1);

        public static Holidays[] values() {
            return (Holidays[])$VALUES.clone();
        }

        public static Holidays valueOf(String value) {
            return Enum.valueOf(Holidays.class, value);
        }

        @NotNull
        public static EnumEntries<Holidays> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Holidays(String $enum$name, int $enum$ordinal, float chance, DefaultConstructorMarker $constructor_marker) {
            this(chance);
        }

        static {
            Easter = new Easter("Easter", 0);
            Samhain = new Samhain("Samhain", 1);
            Xmas = new Xmas("Xmas", 2);
            DiaDeLosMuertos = new DiaDeLosMuertos("DiaDeLosMuertos", 3);
            YuleGoat = new YuleGoat("YuleGoat", 4);
            Qingming = new Qingming("Qingming", 5);
            Diwali = new Diwali("Diwali", 6);
            LunarNewYear = new LunarNewYear("LunarNewYear", 7);
            AprilFoolsDay = new AprilFoolsDay("AprilFoolsDay", 8);
            PrideDay = new PrideDay("PrideDay", 9);
            TowelDay = new TowelDay("TowelDay", 10);
            UncivBirthday = new UncivBirthday("UncivBirthday", 11);
            Friday13th = new Friday13th("Friday13th", 12);
            StarWarsDay = new StarWarsDay("StarWarsDay", 13);
            Passover = new Passover("Passover", 14);
            $VALUES = holidaysArray = new Holidays[]{Holidays.Easter, Holidays.Samhain, Holidays.Xmas, Holidays.DiaDeLosMuertos, Holidays.YuleGoat, Holidays.Qingming, Holidays.Diwali, Holidays.LunarNewYear, Holidays.AprilFoolsDay, Holidays.PrideDay, Holidays.TowelDay, Holidays.UncivBirthday, Holidays.Friday13th, Holidays.StarWarsDay, Holidays.Passover};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.AprilFoolsDay", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class AprilFoolsDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            AprilFoolsDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 4, 1);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Companion;", "", "<init>", "()V", "safeValueOf", "Lcom/unciv/logic/HolidayDates$Holidays;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n295#2,2:399\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Companion\n*L\n128#1:399,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Pure
            @Nullable
            public final Holidays safeValueOf(@NotNull String name) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Iterable $this$firstOrNull$iv = Holidays.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Holidays it = (Holidays)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.DiaDeLosMuertos", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class DiaDeLosMuertos
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            DiaDeLosMuertos() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 11, 1, 2);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.Diwali", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Diwali
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Diwali() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = Tables.INSTANCE.getDiwali().get(year2);
                if (localDate == null) {
                    return DateRange.Companion.getNever();
                }
                LocalDate knownValue = localDate;
                LocalDate localDate2 = knownValue.plusDays(-2L);
                Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
                return DateRange.Companion.of(localDate2, 5);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.Easter", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Easter
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Easter() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                int a = year2 % 19;
                int b = year2 / 100;
                int c = year2 % 100;
                int d = b / 4;
                int e = b % 4;
                int g = (8 * b + 13) / 25;
                int h = (19 * a + b - d - g + 15) % 30;
                int i = c / 4;
                int k = c % 4;
                int l = (32 + 2 * e + 2 * i - h - k) % 7;
                int m = (a + 11 * h + 19 * l) / 433;
                int n = (h + l - 7 * m + 90) / 25;
                int p = (h + l - 7 * m + 33 * n + 19) % 32;
                LocalDate sunday = LocalDate.of(year2, n, p);
                LocalDate localDate = sunday.minusDays(2L);
                Intrinsics.checkNotNullExpressionValue(localDate, "minusDays(...)");
                return DateRange.Companion.of(localDate, 4);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.Friday13th", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        @SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Friday13th\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1563#2:399\n1634#2,3:400\n774#2:403\n865#2,2:404\n1#3:406\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Friday13th\n*L\n103#1:399\n103#1:400,3\n104#1:403\n104#1:404,2\n*E\n"})
        static final class Friday13th
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Friday13th() {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                DateRange dateRange;
                void $this$filterTo$iv$iv;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = new IntRange(1, 12);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LocalDate.of(year2, (int)it, 13));
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LocalDate it = (LocalDate)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getDayOfWeek() == DayOfWeek.FRIDAY)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                LocalDate localDate = (LocalDate)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default);
                if (localDate != null) {
                    LocalDate it = localDate;
                    boolean bl = false;
                    DateRange dateRange2 = DateRange.Companion.of(it);
                    if (dateRange2 != null) {
                        dateRange = dateRange2;
                        return dateRange;
                    }
                }
                dateRange = DateRange.Companion.getNever();
                return dateRange;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.LunarNewYear", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class LunarNewYear
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            LunarNewYear() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = Tables.INSTANCE.getLunarNewYear().get(year2);
                if (localDate == null) {
                    return DateRange.Companion.getNever();
                }
                LocalDate knownValue = localDate;
                return DateRange.Companion.of(knownValue);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.Passover", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Passover
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Passover() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = Tables.INSTANCE.getPassover().get(year2);
                if (localDate == null) {
                    return DateRange.Companion.getNever();
                }
                LocalDate knownValue = localDate;
                LocalDate localDate2 = knownValue.plusDays(-2L);
                Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
                return DateRange.Companion.of(localDate2, 5);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.PrideDay", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class PrideDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            PrideDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 6, 28, 3);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.Qingming", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Qingming
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Qingming() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                Instant instant = Tables.INSTANCE.getEquinoxes().get(year2);
                if (instant == null) {
                    return DateRange.Companion.getNever();
                }
                Instant springEquinoxInstant = instant;
                LocalDate springEquinox = springEquinoxInstant.atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate localDate = springEquinox.plusDays(15L);
                Intrinsics.checkNotNullExpressionValue(localDate, "plusDays(...)");
                return DateRange.Companion.of(localDate);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.Samhain", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Samhain
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Samhain() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 10, 31);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.StarWarsDay", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class StarWarsDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            StarWarsDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 5, 4);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.TowelDay", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class TowelDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            TowelDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 5, 25);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.UncivBirthday", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class UncivBirthday
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            UncivBirthday() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 11, 21);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.Xmas", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Xmas
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Xmas() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 12, 24, 4);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/unciv/logic/HolidayDates.Holidays.YuleGoat", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class YuleGoat
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            YuleGoat() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = LocalDate.of(year2, 11, 30);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return DateRange.Companion.of(INSTANCE.closestWeekday(localDate, DayOfWeek.SUNDAY));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R/\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR/\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\f\u001a\u0004\b\u000f\u0010\nR/\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0012\u0010\nR/\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\f\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/HolidayDates$Tables;", "", "<init>", "()V", "equinoxes", "", "", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getEquinoxes", "()Ljava/util/Map;", "equinoxes$delegate", "Lkotlin/Lazy;", "passover", "Ljava/time/LocalDate;", "getPassover", "passover$delegate", "diwali", "getDiwali", "diwali$delegate", "lunarNewYear", "getLunarNewYear", "lunarNewYear$delegate", "core"})
    @SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Tables\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n1222#2,2:399\n1252#2,4:401\n1222#2,2:405\n1252#2,4:407\n1222#2,2:411\n1252#2,4:413\n1222#2,2:417\n1252#2,4:419\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Tables\n*L\n254#1:399,2\n254#1:401,4\n288#1:405,2\n288#1:407,4\n311#1:411,2\n311#1:413,4\n394#1:417,2\n394#1:419,4\n*E\n"})
    private static final class Tables {
        @NotNull
        public static final Tables INSTANCE = new Tables();
        @NotNull
        private static final Lazy equinoxes$delegate = LazyKt.lazy(Tables::equinoxes_delegate$lambda$0);
        @NotNull
        private static final Lazy passover$delegate = LazyKt.lazy(Tables::passover_delegate$lambda$0);
        @NotNull
        private static final Lazy diwali$delegate = LazyKt.lazy(Tables::diwali_delegate$lambda$0);
        @NotNull
        private static final Lazy lunarNewYear$delegate = LazyKt.lazy(Tables::lunarNewYear_delegate$lambda$0);

        private Tables() {
        }

        @NotNull
        public final Map<Integer, Instant> getEquinoxes() {
            Lazy lazy = equinoxes$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, LocalDate> getPassover() {
            Lazy lazy = passover$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, LocalDate> getDiwali() {
            Lazy lazy = diwali$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, LocalDate> getLunarNewYear() {
            Lazy lazy = lunarNewYear$delegate;
            return (Map)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private static final Map equinoxes_delegate$lambda$0() {
            void $this$associateByTo$iv$iv;
            Pair[] pairArray = new Pair[]{TuplesKt.to(2024, "2024-03-20T03:07:00Z"), TuplesKt.to(2025, "2025-03-20T09:02:00Z"), TuplesKt.to(2026, "2026-03-20T14:46:00Z"), TuplesKt.to(2027, "2027-03-20T20:25:00Z"), TuplesKt.to(2028, "2028-03-20T02:17:00Z"), TuplesKt.to(2029, "2029-03-20T08:01:00Z"), TuplesKt.to(2030, "2030-03-20T13:51:00Z"), TuplesKt.to(2031, "2031-03-20T19:41:00Z"), TuplesKt.to(2032, "2032-03-20T01:23:00Z"), TuplesKt.to(2033, "2033-03-20T07:23:00Z"), TuplesKt.to(2034, "2034-03-20T13:18:00Z"), TuplesKt.to(2035, "2035-03-20T19:03:00Z"), TuplesKt.to(2036, "2036-03-20T01:02:00Z"), TuplesKt.to(2037, "2037-03-20T06:50:00Z"), TuplesKt.to(2038, "2038-03-20T12:40:00Z"), TuplesKt.to(2039, "2039-03-20T18:32:00Z"), TuplesKt.to(2040, "2040-03-20T00:11:00Z"), TuplesKt.to(2041, "2041-03-20T06:07:00Z"), TuplesKt.to(2042, "2042-03-20T11:53:00Z"), TuplesKt.to(2043, "2043-03-20T17:29:00Z"), TuplesKt.to(2044, "2044-03-19T23:20:00Z"), TuplesKt.to(2045, "2045-03-20T05:08:00Z"), TuplesKt.to(2046, "2046-03-20T10:58:00Z"), TuplesKt.to(2047, "2047-03-20T16:52:00Z"), TuplesKt.to(2048, "2048-03-19T22:34:00Z"), TuplesKt.to(2049, "2049-03-20T04:28:00Z"), TuplesKt.to(2050, "2050-03-20T10:20:00Z"), TuplesKt.to(2051, "2051-03-20T15:58:00Z"), TuplesKt.to(2052, "2052-03-19T21:56:00Z"), TuplesKt.to(2053, "2053-03-20T03:46:00Z"), TuplesKt.to(2054, "2054-03-20T09:35:00Z"), TuplesKt.to(2055, "2055-03-20T15:28:00Z"), TuplesKt.to(2056, "2056-03-19T21:11:00Z"), TuplesKt.to(2057, "2057-03-20T03:08:00Z"), TuplesKt.to(2058, "2058-03-20T09:04:00Z"), TuplesKt.to(2059, "2059-03-20T14:44:00Z"), TuplesKt.to(2060, "2060-03-19T20:37:00Z"), TuplesKt.to(2061, "2061-03-20T02:26:00Z"), TuplesKt.to(2062, "2062-03-20T08:07:00Z"), TuplesKt.to(2063, "2063-03-20T13:59:00Z"), TuplesKt.to(2064, "2064-03-19T19:40:00Z"), TuplesKt.to(2065, "2065-03-20T01:27:00Z"), TuplesKt.to(2066, "2066-03-20T07:19:00Z"), TuplesKt.to(2067, "2067-03-20T12:55:00Z"), TuplesKt.to(2068, "2068-03-19T18:51:00Z"), TuplesKt.to(2069, "2069-03-20T00:44:00Z"), TuplesKt.to(2070, "2070-03-20T06:35:00Z"), TuplesKt.to(2071, "2071-03-20T12:36:00Z"), TuplesKt.to(2072, "2072-03-19T18:19:00Z"), TuplesKt.to(2073, "2073-03-20T00:12:00Z"), TuplesKt.to(2074, "2074-03-20T06:09:00Z"), TuplesKt.to(2075, "2075-03-20T11:48:00Z"), TuplesKt.to(2076, "2076-03-19T17:37:00Z"), TuplesKt.to(2077, "2077-03-19T23:30:00Z"), TuplesKt.to(2078, "2078-03-20T05:11:00Z"), TuplesKt.to(2079, "2079-03-20T11:03:00Z"), TuplesKt.to(2080, "2080-03-19T16:43:00Z"), TuplesKt.to(2081, "2081-03-19T22:34:00Z"), TuplesKt.to(2082, "2082-03-20T04:32:00Z"), TuplesKt.to(2083, "2083-03-20T10:08:00Z"), TuplesKt.to(2084, "2084-03-19T15:58:00Z"), TuplesKt.to(2085, "2085-03-19T21:53:00Z"), TuplesKt.to(2086, "2086-03-20T03:36:00Z"), TuplesKt.to(2087, "2087-03-20T09:27:00Z"), TuplesKt.to(2088, "2088-03-19T15:16:00Z"), TuplesKt.to(2089, "2089-03-19T21:07:00Z"), TuplesKt.to(2090, "2090-03-20T03:03:00Z"), TuplesKt.to(2091, "2091-03-20T08:40:00Z"), TuplesKt.to(2092, "2092-03-19T14:33:00Z"), TuplesKt.to(2093, "2093-03-19T20:35:00Z"), TuplesKt.to(2094, "2094-03-20T02:20:00Z"), TuplesKt.to(2095, "2095-03-20T08:14:00Z"), TuplesKt.to(2096, "2096-03-19T14:03:00Z"), TuplesKt.to(2097, "2097-03-19T19:49:00Z"), TuplesKt.to(2098, "2098-03-20T01:38:00Z"), TuplesKt.to(2099, "2099-03-20T07:17:00Z"), TuplesKt.to(2100, "2100-03-20T13:04:00Z")};
            Iterable $this$associateBy$iv = CollectionsKt.listOf(pairArray);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Pair it = (Pair)element$iv$iv;
                Integer n = ((Number)it.getFirst()).intValue();
                boolean bl2 = false;
                Instant instant = Instant.parse((CharSequence)it.getSecond());
                map2.put(n, instant);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final Map passover_delegate$lambda$0() {
            void $this$associateByTo$iv$iv;
            Pair[] pairArray = new Pair[]{TuplesKt.to(2023, 5), TuplesKt.to(2024, 22), TuplesKt.to(2025, 12), TuplesKt.to(2026, 1), TuplesKt.to(2027, 21), TuplesKt.to(2028, 10), TuplesKt.to(2029, -2), TuplesKt.to(2030, 17), TuplesKt.to(2031, 7), TuplesKt.to(2032, -6), TuplesKt.to(2033, 13), TuplesKt.to(2034, 3), TuplesKt.to(2035, 23), TuplesKt.to(2036, 11), TuplesKt.to(2037, -2), TuplesKt.to(2038, 19), TuplesKt.to(2039, 8), TuplesKt.to(2040, -4), TuplesKt.to(2041, 15), TuplesKt.to(2042, 4), TuplesKt.to(2043, 24), TuplesKt.to(2044, 11), TuplesKt.to(2045, 1), TuplesKt.to(2046, 20), TuplesKt.to(2047, 10), TuplesKt.to(2048, -4), TuplesKt.to(2049, 16), TuplesKt.to(2050, 6)};
            Iterable $this$associateBy$iv = CollectionsKt.listOf(pairArray);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Pair it = (Pair)element$iv$iv;
                Integer n = ((Number)it.getFirst()).intValue();
                boolean bl2 = false;
                LocalDate localDate = LocalDate.of(((Number)it.getFirst()).intValue(), 4, 1).plusDays(((Number)it.getSecond()).intValue());
                map2.put(n, localDate);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final Map diwali_delegate$lambda$0() {
            void $this$associateByTo$iv$iv;
            Pair[] pairArray = new Pair[]{TuplesKt.to(2024, "2024-11-01"), TuplesKt.to(2025, "2025-10-21"), TuplesKt.to(2026, "2026-11-08"), TuplesKt.to(2027, "2027-10-29"), TuplesKt.to(2028, "2028-10-17"), TuplesKt.to(2029, "2029-11-05"), TuplesKt.to(2030, "2030-10-26"), TuplesKt.to(2031, "2031-11-14"), TuplesKt.to(2032, "2032-11-02"), TuplesKt.to(2033, "2033-10-22"), TuplesKt.to(2034, "2034-11-10"), TuplesKt.to(2035, "2035-10-20"), TuplesKt.to(2036, "2036-10-19"), TuplesKt.to(2037, "2037-11-07"), TuplesKt.to(2038, "2038-10-27"), TuplesKt.to(2039, "2039-10-17"), TuplesKt.to(2040, "2040-11-04")};
            Iterable $this$associateBy$iv = CollectionsKt.listOf(pairArray);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Pair it = (Pair)element$iv$iv;
                Integer n = ((Number)it.getFirst()).intValue();
                boolean bl2 = false;
                LocalDate localDate = LocalDate.parse((CharSequence)it.getSecond());
                map2.put(n, localDate);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final Map lunarNewYear_delegate$lambda$0() {
            void $this$associateByTo$iv$iv;
            Pair[] pairArray = new Pair[]{TuplesKt.to(2024, 41), TuplesKt.to(2025, 29), TuplesKt.to(2026, 48), TuplesKt.to(2027, 37), TuplesKt.to(2028, 26), TuplesKt.to(2029, 44), TuplesKt.to(2030, 34), TuplesKt.to(2031, 23), TuplesKt.to(2032, 42), TuplesKt.to(2033, 31), TuplesKt.to(2034, 50), TuplesKt.to(2035, 39), TuplesKt.to(2036, 28), TuplesKt.to(2037, 46), TuplesKt.to(2038, 35), TuplesKt.to(2039, 24), TuplesKt.to(2040, 43), TuplesKt.to(2041, 32), TuplesKt.to(2042, 22), TuplesKt.to(2043, 41), TuplesKt.to(2044, 30), TuplesKt.to(2045, 48), TuplesKt.to(2046, 37), TuplesKt.to(2047, 26), TuplesKt.to(2048, 45), TuplesKt.to(2049, 33), TuplesKt.to(2050, 23), TuplesKt.to(2051, 42), TuplesKt.to(2052, 32), TuplesKt.to(2053, 50), TuplesKt.to(2054, 39), TuplesKt.to(2055, 28), TuplesKt.to(2056, 46), TuplesKt.to(2057, 35), TuplesKt.to(2058, 24), TuplesKt.to(2059, 43), TuplesKt.to(2060, 33), TuplesKt.to(2061, 21), TuplesKt.to(2062, 40), TuplesKt.to(2063, 29), TuplesKt.to(2064, 48), TuplesKt.to(2065, 36), TuplesKt.to(2066, 26), TuplesKt.to(2067, 45), TuplesKt.to(2068, 34), TuplesKt.to(2069, 23), TuplesKt.to(2070, 42), TuplesKt.to(2071, 31), TuplesKt.to(2072, 50), TuplesKt.to(2073, 38), TuplesKt.to(2074, 27), TuplesKt.to(2075, 46), TuplesKt.to(2076, 36), TuplesKt.to(2077, 24), TuplesKt.to(2078, 43), TuplesKt.to(2079, 33), TuplesKt.to(2080, 22), TuplesKt.to(2081, 40), TuplesKt.to(2082, 29), TuplesKt.to(2083, 48), TuplesKt.to(2084, 37), TuplesKt.to(2085, 26), TuplesKt.to(2086, 45), TuplesKt.to(2087, 34), TuplesKt.to(2088, 24), TuplesKt.to(2089, 41), TuplesKt.to(2090, 30), TuplesKt.to(2091, 49), TuplesKt.to(2092, 38), TuplesKt.to(2093, 27), TuplesKt.to(2094, 46), TuplesKt.to(2095, 36), TuplesKt.to(2096, 25), TuplesKt.to(2097, 43), TuplesKt.to(2098, 32), TuplesKt.to(2099, 21), TuplesKt.to(2100, 40)};
            Iterable $this$associateBy$iv = CollectionsKt.listOf(pairArray);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Pair it = (Pair)element$iv$iv;
                Integer n = ((Number)it.getFirst()).intValue();
                boolean bl2 = false;
                LocalDate localDate = LocalDate.of(((Number)it.getFirst()).intValue(), 1, 1).plusDays(((Number)it.getSecond()).longValue() - 1L);
                map2.put(n, localDate);
            }
            return destination$iv$iv;
        }
    }
}

