/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.StatTreeNode;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.transients.CapitalConnectionsFinder;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.StatMap;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010&\u001a\u00020\u0014H\u0003J\u0012\u0010'\u001a\u0004\u0018\u00010\u00142\u0006\u0010(\u001a\u00020\u001bH\u0003J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0007J\n\u0010,\u001a\u0004\u0018\u00010\u0014H\u0003J\n\u0010-\u001a\u0004\u0018\u00010\u0014H\u0003J\u001a\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001b2\b\b\u0002\u00101\u001a\u000202H\u0007J\b\u00103\u001a\u000204H\u0007J\u001a\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u00132\b\b\u0002\u00101\u001a\u000202H\u0007J\u0016\u00107\u001a\u00020\u00142\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001309H\u0003J\b\u0010:\u001a\u00020\tH\u0003J\u0012\u0010;\u001a\u0004\u0018\u00010\u00142\u0006\u0010<\u001a\u000204H\u0003J\u0010\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020?H\u0003J\n\u0010@\u001a\u0004\u0018\u00010\u0014H\u0003J\u0018\u0010A\u001a\u0002042\u0006\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020\u0013H\u0003J\u0010\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020FH\u0007J\b\u0010G\u001a\u00020FH\u0007J\b\u0010H\u001a\u00020\u001bH\u0003J\u0010\u0010I\u001a\u00020J2\b\b\u0002\u00101\u001a\u000202J\u000e\u0010K\u001a\u00020J2\u0006\u0010L\u001a\u00020\tJ\u0010\u0010M\u001a\u00020J2\u0006\u0010L\u001a\u00020\tH\u0002J\u0010\u0010N\u001a\u00020\t2\u0006\u0010>\u001a\u00020?H\u0003J\u0010\u0010O\u001a\u00020J2\u0006\u0010>\u001a\u00020?H\u0002J8\u0010P\u001a\u00020J2\b\b\u0002\u0010>\u001a\u00020?2\b\b\u0002\u0010I\u001a\u0002042\b\b\u0002\u0010Q\u001a\u0002042\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u0010R\u001a\u000204J\u001a\u0010S\u001a\u00020J2\u0006\u0010>\u001a\u00020?2\b\b\u0002\u0010R\u001a\u000204H\u0002J\u0018\u0010T\u001a\u0002042\u0006\u0010U\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?H\u0007J\u0010\u0010V\u001a\u00020\u001b2\u0006\u0010U\u001a\u00020\u001bH\u0007J\b\u0010W\u001a\u00020\u001bH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR6\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R6\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001a\u0010\u001e\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"\u00a8\u0006X"}, d2={"Lcom/unciv/logic/city/CityStats;", "", "city", "Lcom/unciv/logic/city/City;", "<init>", "(Lcom/unciv/logic/city/City;)V", "getCity", "()Lcom/unciv/logic/city/City;", "baseStatTree", "Lcom/unciv/logic/city/StatTreeNode;", "getBaseStatTree", "()Lcom/unciv/logic/city/StatTreeNode;", "setBaseStatTree", "(Lcom/unciv/logic/city/StatTreeNode;)V", "statPercentBonusTree", "getStatPercentBonusTree", "setStatPercentBonusTree", "finalStatList", "Ljava/util/LinkedHashMap;", "", "Lcom/unciv/models/stats/Stats;", "Lkotlin/collections/LinkedHashMap;", "getFinalStatList", "()Ljava/util/LinkedHashMap;", "setFinalStatList", "(Ljava/util/LinkedHashMap;)V", "happinessList", "", "getHappinessList", "setHappinessList", "statsFromTiles", "getStatsFromTiles", "()Lcom/unciv/models/stats/Stats;", "setStatsFromTiles", "(Lcom/unciv/models/stats/Stats;)V", "currentCityStats", "getCurrentCityStats", "setCurrentCityStats", "getStatsFromTradeRoute", "getStatsFromProduction", "production", "getStatConversionRate", "stat", "Lcom/unciv/models/stats/Stat;", "getStatPercentBonusesFromRailroad", "getStatPercentBonusesFromPuppetCity", "getGrowthBonus", "Lcom/unciv/models/stats/StatMap;", "totalFood", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "hasExtraAnnexUnhappiness", "", "getStatsOfSpecialist", "specialistName", "getStatsFromSpecialists", "specialists", "Lcom/unciv/models/Counter;", "getStatsFromUniquesBySource", "getStatPercentBonusesFromGoldenAge", "isGoldenAge", "getStatsPercentBonusesFromUniquesBySource", "currentConstruction", "Lcom/unciv/models/ruleset/IConstruction;", "getStatPercentBonusesFromUnitSupply", "constructionMatchesFilter", "construction", "filter", "isConnectedToCapital", "roadType", "Lcom/unciv/logic/map/tile/RoadStatus;", "getRoadTypeOfConnectionToCapital", "getBuildingMaintenanceCosts", "updateTileStats", "", "updateCityHappiness", "statsFromBuildings", "updateBaseStatList", "getStatPercentBonusList", "updateStatPercentBonusList", "update", "updateCivStats", "calculateGrowthModifiers", "updateFinalStatList", "canConvertFoodToProduction", "food", "getProductionFromExcessiveFood", "calcFoodEaten", "core"})
@SourceDebugExtension(value={"SMAP\nCityStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStats.kt\ncom/unciv/logic/city/CityStats\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,655:1\n1563#2:656\n1634#2,3:657\n1563#2:670\n1634#2,3:671\n1563#2:674\n1634#2,3:675\n1563#2:678\n1634#2,3:679\n1563#2:682\n1634#2,3:683\n1761#2,3:686\n183#3,2:660\n536#4:662\n521#4,6:663\n1#5:669\n*S KotlinDebug\n*F\n+ 1 CityStats.kt\ncom/unciv/logic/city/CityStats\n*L\n120#1:656\n120#1:657,3\n522#1:670\n522#1:671,3\n571#1:674\n571#1:675,3\n588#1:678\n588#1:679,3\n613#1:682\n613#1:683,3\n323#1:686,3\n132#1:660,2\n197#1:662\n197#1:663,6\n*E\n"})
public final class CityStats {
    @NotNull
    private final City city;
    @NotNull
    private StatTreeNode baseStatTree;
    @NotNull
    private StatTreeNode statPercentBonusTree;
    @NotNull
    private LinkedHashMap<String, Stats> finalStatList;
    @NotNull
    private LinkedHashMap<String, Float> happinessList;
    @NotNull
    private Stats statsFromTiles;
    @NotNull
    private Stats currentCityStats;

    public CityStats(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        this.city = city;
        this.baseStatTree = new StatTreeNode();
        this.statPercentBonusTree = new StatTreeNode();
        this.finalStatList = new LinkedHashMap();
        this.happinessList = new LinkedHashMap();
        this.statsFromTiles = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        this.currentCityStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @NotNull
    public final StatTreeNode getBaseStatTree() {
        return this.baseStatTree;
    }

    public final void setBaseStatTree(@NotNull StatTreeNode statTreeNode) {
        Intrinsics.checkNotNullParameter(statTreeNode, "<set-?>");
        this.baseStatTree = statTreeNode;
    }

    @NotNull
    public final StatTreeNode getStatPercentBonusTree() {
        return this.statPercentBonusTree;
    }

    public final void setStatPercentBonusTree(@NotNull StatTreeNode statTreeNode) {
        Intrinsics.checkNotNullParameter(statTreeNode, "<set-?>");
        this.statPercentBonusTree = statTreeNode;
    }

    @NotNull
    public final LinkedHashMap<String, Stats> getFinalStatList() {
        return this.finalStatList;
    }

    public final void setFinalStatList(@NotNull LinkedHashMap<String, Stats> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.finalStatList = linkedHashMap;
    }

    @NotNull
    public final LinkedHashMap<String, Float> getHappinessList() {
        return this.happinessList;
    }

    public final void setHappinessList(@NotNull LinkedHashMap<String, Float> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.happinessList = linkedHashMap;
    }

    @NotNull
    public final Stats getStatsFromTiles() {
        return this.statsFromTiles;
    }

    public final void setStatsFromTiles(@NotNull Stats stats) {
        Intrinsics.checkNotNullParameter(stats, "<set-?>");
        this.statsFromTiles = stats;
    }

    @NotNull
    public final Stats getCurrentCityStats() {
        return this.currentCityStats;
    }

    public final void setCurrentCityStats(@NotNull Stats stats) {
        Intrinsics.checkNotNullParameter(stats, "<set-?>");
        this.currentCityStats = stats;
    }

    @Readonly
    private final Stats getStatsFromTradeRoute() {
        Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        City city = Civilization.getCapital$default(this.city.getCiv(), false, 1, null);
        Intrinsics.checkNotNull(city);
        City capitalForTradeRoutePurposes = city;
        if (!Intrinsics.areEqual(this.city, capitalForTradeRoutePurposes) && this.city.isConnectedToCapital()) {
            stats.setGold((float)capitalForTradeRoutePurposes.getPopulation().getPopulation() * 0.15f + (float)this.city.getPopulation().getPopulation() * 1.1f - 1.0f);
            Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsFromTradeRoute, null, false, 6, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                stats.add(unique.getStats());
            }
            Stats percentageStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            Iterator<Object> iterator3 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentFromTradeRoutes, null, false, 6, null).iterator();
            while (iterator3.hasNext()) {
                Unique unique = (Unique)iterator3.next();
                Stat stat = Stat.valueOf(unique.getParams().get(1));
                percentageStats.set(stat, percentageStats.get(stat) + Float.parseFloat(unique.getParams().get(0)));
            }
            iterator3 = stats.iterator();
            while (iterator3.hasNext()) {
                Stat stat = ((Stats.StatValuePair)iterator3.next()).component1();
                stats.set(stat, stats.get(stat) * FormattingExtensionsKt.toPercent(percentageStats.get(stat)));
            }
        }
        return stats;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final Stats getStatsFromProduction(float production) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = Stat.Companion.getStatsWithCivWideField();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Stat stat = (Stat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        if (((List)destination$iv$iv).contains(this.city.getCityConstructions().getCurrentConstructionFromQueue())) {
            Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            Stat stat = Stat.valueOf(this.city.getCityConstructions().getCurrentConstructionFromQueue());
            stats.set(stat, production * this.getStatConversionRate(stat));
            return stats;
        }
        return null;
    }

    @Readonly
    public final float getStatConversionRate(@NotNull Stat stat) {
        Object v0;
        float conversionRate;
        block2: {
            Intrinsics.checkNotNullParameter(stat, "stat");
            conversionRate = 0.25f;
            Sequence $this$firstOrNull$iv = Civilization.getMatchingUniques$default(this.city.getCiv(), UniqueType.ProductionToCivWideStatConversionBonus, null, 2, null);
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getParams().get(0), stat.name())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Unique conversionUnique = v0;
        if (conversionUnique != null) {
            conversionRate *= FormattingExtensionsKt.toPercent(conversionUnique.getParams().get(1));
        }
        return conversionRate;
    }

    @Readonly
    private final Stats getStatPercentBonusesFromRailroad() {
        TileImprovement tileImprovement = this.city.getRuleset().getRailroadImprovement();
        if (tileImprovement == null) {
            return null;
        }
        TileImprovement railroadImprovement = tileImprovement;
        String techEnablingRailroad = railroadImprovement.getTechRequired();
        if ((techEnablingRailroad == null || this.city.getCiv().getTech().isResearched(techEnablingRailroad)) && (this.city.isCapital() || this.isConnectedToCapital(RoadStatus.Railroad))) {
            return new Stats(25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 126, null);
        }
        return null;
    }

    @Readonly
    private final Stats getStatPercentBonusesFromPuppetCity() {
        if (!this.city.isPuppet()) {
            return null;
        }
        return new Stats(0.0f, 0.0f, 0.0f, -25.0f, -25.0f, 0.0f, 0.0f, 103, null);
    }

    @Readonly
    @NotNull
    public final StatMap getGrowthBonus(float totalFood, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        StatMap growthSources = new StatMap();
        Iterator iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, this.city, UniqueType.GrowthPercentBonus, null, 4, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, false, 6, null)) continue;
            growthSources.add(unique.getSourceNameForUser(), new Stats(0.0f, Float.parseFloat(unique.getParams().get(0)) / 100.0f * totalFood, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 125, null));
        }
        return growthSources;
    }

    public static /* synthetic */ StatMap getGrowthBonus$default(CityStats cityStats, float f, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return cityStats.getGrowthBonus(f, localUniqueCache);
    }

    @Readonly
    public final boolean hasExtraAnnexUnhappiness() {
        if (Intrinsics.areEqual(this.city.getCiv().getCivName(), this.city.getFoundingCiv()) || this.city.isPuppet()) {
            return false;
        }
        return !City.containsBuildingUnique$default(this.city, UniqueType.RemovesAnnexUnhappiness, null, 2, null);
    }

    @Readonly
    @NotNull
    public final Stats getStatsOfSpecialist(@NotNull String specialistName, @NotNull LocalUniqueCache localUniqueCache) {
        Unique unique;
        Intrinsics.checkNotNullParameter(specialistName, "specialistName");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Specialist specialist = this.city.getRuleset().getSpecialists().get(specialistName);
        if (specialist == null) {
            return new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        }
        Specialist specialist2 = specialist;
        Stats stats = specialist2.cloneStats();
        Iterator iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, this.city, UniqueType.StatsFromSpecialist, null, 4, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, false, 6, null)) continue;
            stats.add(unique.getStats());
        }
        iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, this.city, UniqueType.StatsFromObject, null, 4, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!Intrinsics.areEqual(unique.getParams().get(1), specialistName)) continue;
            stats.add(unique.getStats());
        }
        return stats;
    }

    public static /* synthetic */ Stats getStatsOfSpecialist$default(CityStats cityStats, String string, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return cityStats.getStatsOfSpecialist(string, localUniqueCache);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final Stats getStatsFromSpecialists(Counter<String> specialists) {
        void $this$filterTo$iv$iv;
        Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Map $this$filter$iv = specialists;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        for (Pair pair : MapsKt.toList(destination$iv$iv)) {
            String key = (String)pair.component1();
            int value = ((Number)pair.component2()).intValue();
            stats.add(this.getStatsOfSpecialist(key, localUniqueCache).times(value));
        }
        return stats;
    }

    @Readonly
    private final StatTreeNode getStatsFromUniquesBySource() {
        Unique unique;
        StatTreeNode sourceToStats = new StatTreeNode();
        List<Unique> cityStateStatsMultipliers = SequencesKt.toList(Civilization.getMatchingUniques$default(this.city.getCiv(), UniqueType.BonusStatsFromCityStates, null, 2, null));
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsPerCity, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, false, 6, null)) continue;
            CityStats.getStatsFromUniquesBySource$addUniqueStats(cityStateStatsMultipliers, sourceToStats, unique);
        }
        iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsPerPopulation, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(2), null, false, 6, null)) continue;
            float amountOfEffects = this.city.getPopulation().getPopulation() / Integer.parseInt(unique.getParams().get(1));
            Stats stats = unique.getStats().times(amountOfEffects);
            String[] stringArray = new String[2];
            stringArray[0] = unique.getSourceNameForUser();
            String string = unique.getSourceObjectName();
            if (string == null) {
                string = "";
            }
            stringArray[1] = string;
            sourceToStats.addStats(stats, stringArray);
        }
        iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsFromCitiesOnSpecificTiles, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!Tile.matchesTerrainFilter$default(this.city.getCenterTile(), unique.getParams().get(1), this.city.getCiv(), false, 4, null)) continue;
            CityStats.getStatsFromUniquesBySource$addUniqueStats(cityStateStatsMultipliers, sourceToStats, unique);
        }
        return sourceToStats;
    }

    @Pure
    private final Stats getStatPercentBonusesFromGoldenAge(boolean isGoldenAge) {
        if (!isGoldenAge) {
            return null;
        }
        return new Stats(20.0f, 0.0f, 0.0f, 0.0f, 20.0f, 0.0f, 0.0f, 110, null);
    }

    @Readonly
    private final StatTreeNode getStatsPercentBonusesFromUniquesBySource(IConstruction currentConstruction) {
        Unique unique;
        Unique unique2;
        StatTreeNode sourceToStats = new StatTreeNode();
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentBonus, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique2 = (Unique)iterator2.next();
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats(sourceToStats, unique2, Stat.valueOf(unique2.getParams().get(1)), Float.parseFloat(unique2.getParams().get(0)));
        }
        iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentBonusCities, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique2 = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique2.getParams().get(2), null, false, 6, null)) continue;
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats(sourceToStats, unique2, Stat.valueOf(unique2.getParams().get(1)), Float.parseFloat(unique2.getParams().get(0)));
        }
        Sequence uniquesToCheck = currentConstruction instanceof BaseUnit ? City.getMatchingUniques$default(this.city, UniqueType.PercentProductionUnits, null, false, 6, null) : (currentConstruction instanceof Building && ((Building)currentConstruction).isAnyWonder() ? City.getMatchingUniques$default(this.city, UniqueType.PercentProductionWonders, null, false, 6, null) : (currentConstruction instanceof Building && !((Building)currentConstruction).isAnyWonder() ? City.getMatchingUniques$default(this.city, UniqueType.PercentProductionBuildings, null, false, 6, null) : SequencesKt.emptySequence()));
        Iterator iterator3 = uniquesToCheck.iterator();
        while (iterator3.hasNext()) {
            unique = (Unique)iterator3.next();
            if (!this.constructionMatchesFilter(currentConstruction, unique.getParams().get(1)) || !City.matchesFilter$default(this.city, unique.getParams().get(2), null, false, 6, null)) continue;
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats(sourceToStats, unique, Stat.Production, Float.parseFloat(unique.getParams().get(0)));
        }
        iterator3 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentFromReligionFollowers, null, false, 6, null).iterator();
        while (iterator3.hasNext()) {
            unique = (Unique)iterator3.next();
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats(sourceToStats, unique, Stat.valueOf(unique.getParams().get(1)), Math.min(Float.parseFloat(unique.getParams().get(0)) * (float)this.city.getReligion().getFollowersOfMajorityReligion(), Float.parseFloat(unique.getParams().get(2))));
        }
        if (currentConstruction instanceof Building) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = Civilization.getCapital$default(this.city.getCiv(), false, 1, null);
            boolean bl = isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getCityConstructions()) != null ? ((CityConstructions)isPartOfGameInfoSerialization).isBuilt(((Building)currentConstruction).getName()) : false;
            if (bl) {
                iterator3 = City.getMatchingUniques$default(this.city, UniqueType.PercentProductionBuildingsInCapital, null, false, 6, null).iterator();
                while (iterator3.hasNext()) {
                    unique = (Unique)iterator3.next();
                    CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats(sourceToStats, unique, Stat.Production, Float.parseFloat(unique.getParams().get(0)));
                }
            }
        }
        return sourceToStats;
    }

    @Readonly
    private final Stats getStatPercentBonusesFromUnitSupply() {
        int supplyDeficit = this.city.getCiv().getStats().getUnitSupplyDeficit();
        if (supplyDeficit > 0) {
            return new Stats(this.city.getCiv().getStats().getUnitSupplyProductionPenalty(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 126, null);
        }
        return null;
    }

    @Readonly
    private final boolean constructionMatchesFilter(IConstruction construction, String filter2) {
        GameContext state = this.city.getState();
        if (construction instanceof Building) {
            return ((Building)construction).matchesFilter(filter2, state);
        }
        if (construction instanceof BaseUnit) {
            return BaseUnit.matchesFilter$default((BaseUnit)construction, filter2, state, false, 4, null);
        }
        return false;
    }

    @Readonly
    public final boolean isConnectedToCapital(@NotNull RoadStatus roadType) {
        Intrinsics.checkNotNullParameter(roadType, "roadType");
        if (this.city.getCiv().getCities().size() < 2) {
            return false;
        }
        return roadType == RoadStatus.Railroad ? this.city.isConnectedToCapital(CityStats::isConnectedToCapital$lambda$0) : this.city.isConnectedToCapital();
    }

    @Readonly
    @NotNull
    public final RoadStatus getRoadTypeOfConnectionToCapital() {
        EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium> enumSet;
        block7: {
            block6: {
                Comparable comparable;
                enumSet = this.city.getCiv().getCache().getCitiesConnectedToCapitalToMediums().get(this.city);
                if (enumSet == null) break block6;
                Iterator iterator2 = ((Iterable)enumSet).iterator();
                if (!iterator2.hasNext()) {
                    comparable = null;
                } else {
                    CapitalConnectionsFinder.CapitalConnectionMedium it = (CapitalConnectionsFinder.CapitalConnectionMedium)((Object)iterator2.next());
                    boolean bl = false;
                    Comparable comparable2 = (Comparable)((Object)it.getRoadType());
                    while (iterator2.hasNext()) {
                        CapitalConnectionsFinder.CapitalConnectionMedium it2 = (CapitalConnectionsFinder.CapitalConnectionMedium)((Object)iterator2.next());
                        $i$a$-maxOfOrNull-CityStats$getRoadTypeOfConnectionToCapital$1 = false;
                        Comparable comparable3 = (Comparable)((Object)it2.getRoadType());
                        if (comparable2.compareTo(comparable3) >= 0) continue;
                        comparable2 = comparable3;
                    }
                    comparable = comparable2;
                }
                if ((enumSet = (RoadStatus)((Object)comparable)) != null) break block7;
            }
            enumSet = RoadStatus.None;
        }
        return enumSet;
    }

    @Readonly
    private final float getBuildingMaintenanceCosts() {
        float buildingsMaintenance = this.city.getCityConstructions().getMaintenanceCosts();
        if (!this.city.getCiv().isHuman()) {
            buildingsMaintenance *= this.city.getCiv().getGameInfo().getDifficulty().getAiBuildingMaintenanceModifier();
        }
        return buildingsMaintenance;
    }

    public final void updateTileStats(@NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Sequence<Tile> workedTiles = SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.city.getTilesInRange()), arg_0 -> CityStats.updateTileStats$lambda$0(this, arg_0));
        Iterator<Tile> iterator2 = workedTiles.iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            if (tile.isBlockaded() && this.city.isWorked(tile)) {
                this.city.getWorkedTiles().remove(tile.getPosition());
                this.city.getLockedTiles().remove(tile.getPosition());
                this.city.setShouldReassignPopulation(true);
                continue;
            }
            Stats tileStats = tile.getStats().getTileStats(this.city, this.city.getCiv(), localUniqueCache);
            stats.add(tileStats);
        }
        this.statsFromTiles = stats;
    }

    public static /* synthetic */ void updateTileStats$default(CityStats cityStats, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 1) != 0) {
            localUniqueCache = new LocalUniqueCache(false, 1, null);
        }
        cityStats.updateTileStats(localUniqueCache);
    }

    public final void updateCityHappiness(@NotNull StatTreeNode statsFromBuildings) {
        float happinessFromSpecialists;
        Object unique;
        Intrinsics.checkNotNullParameter(statsFromBuildings, "statsFromBuildings");
        Civilization civInfo = this.city.getCiv();
        LinkedHashMap newHappinessList = new LinkedHashMap();
        float unhappinessModifier = civInfo.getDifficulty().getUnhappinessModifier();
        if (!civInfo.isHuman()) {
            unhappinessModifier *= civInfo.getGameInfo().getDifficulty().getAiUnhappinessModifier();
        }
        float unhappinessFromCity = -3.0f;
        if (this.hasExtraAnnexUnhappiness()) {
            unhappinessFromCity -= 2.0f;
        }
        float uniqueUnhappinessModifier = 0.0f;
        Iterator iterator2 = Civilization.getMatchingUniques$default(civInfo, UniqueType.UnhappinessFromCitiesPercentage, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            uniqueUnhappinessModifier += Float.parseFloat(((Unique)unique).getParams().get(0));
        }
        ((Map)newHappinessList).put("Cities", Float.valueOf(unhappinessFromCity * unhappinessModifier * FormattingExtensionsKt.toPercent(uniqueUnhappinessModifier)));
        float unhappinessFromCitizens = this.city.getPopulation().getPopulation();
        unique = City.getMatchingUniques$default(this.city, UniqueType.UnhappinessFromPopulationTypePercentageChange, null, false, 6, null).iterator();
        while (unique.hasNext()) {
            Unique unique2 = (Unique)unique.next();
            if (!City.matchesFilter$default(this.city, unique2.getParams().get(2), null, false, 6, null)) continue;
            unhappinessFromCitizens += Float.parseFloat(unique2.getParams().get(0)) / 100.0f * (float)this.city.getPopulation().getPopulationFilterAmount(unique2.getParams().get(1));
        }
        if (this.hasExtraAnnexUnhappiness()) {
            unhappinessFromCitizens *= 2.0f;
        }
        if (unhappinessFromCitizens < 0.0f) {
            unhappinessFromCitizens = 0.0f;
        }
        ((Map)newHappinessList).put("Population", Float.valueOf(-unhappinessFromCitizens * unhappinessModifier));
        if (this.hasExtraAnnexUnhappiness()) {
            ((Map)newHappinessList).put("Occupied City", Float.valueOf(-2.0f));
        }
        if ((happinessFromSpecialists = (float)((int)this.getStatsFromSpecialists(this.city.getPopulation().getNewSpecialists()).getHappiness())) > 0.0f) {
            ((Map)newHappinessList).put("Specialists", Float.valueOf(happinessFromSpecialists));
        }
        ((Map)newHappinessList).put("Buildings", Float.valueOf((int)statsFromBuildings.getTotalStats().getHappiness()));
        ((Map)newHappinessList).put("Tile yields", Float.valueOf(this.statsFromTiles.getHappiness()));
        StatTreeNode happinessBySource = this.getStatsFromUniquesBySource();
        for (Map.Entry entry : ((Map)happinessBySource.getChildren()).entrySet()) {
            String source = (String)entry.getKey();
            StatTreeNode stats = (StatTreeNode)entry.getValue();
            if (stats.getTotalStats().getHappiness() == 0.0f) continue;
            if (!newHappinessList.containsKey(source)) {
                ((Map)newHappinessList).put(source, Float.valueOf(0.0f));
            }
            Map map2 = newHappinessList;
            Object v = newHappinessList.get(source);
            Intrinsics.checkNotNull(v);
            map2.put(source, Float.valueOf(((Number)v).floatValue() + stats.getTotalStats().getHappiness()));
        }
        this.happinessList = newHappinessList;
    }

    private final void updateBaseStatList(StatTreeNode statsFromBuildings) {
        StatTreeNode newBaseStatTree = new StatTreeNode();
        StatMap newBaseStatList = new StatMap();
        float f = this.city.getPopulation().getPopulation();
        float f2 = this.city.getPopulation().getFreePopulation();
        String[] stringArray = new String[]{"Population"};
        newBaseStatTree.addStats(new Stats(f2, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 118, null), stringArray);
        ((Map)newBaseStatList).put("Tile yields", this.statsFromTiles);
        ((Map)newBaseStatList).put("Specialists", this.getStatsFromSpecialists(this.city.getPopulation().getNewSpecialists()));
        ((Map)newBaseStatList).put("Trade routes", this.getStatsFromTradeRoute());
        ((Map)newBaseStatTree.getChildren()).put("Buildings", statsFromBuildings);
        for (Map.Entry entry : ((Map)newBaseStatList).entrySet()) {
            String source = (String)entry.getKey();
            Stats stats = (Stats)entry.getValue();
            String[] stringArray2 = new String[]{source};
            newBaseStatTree.addStats(stats, stringArray2);
        }
        newBaseStatTree.add(this.getStatsFromUniquesBySource());
        this.baseStatTree = newBaseStatTree;
    }

    @Readonly
    private final StatTreeNode getStatPercentBonusList(IConstruction currentConstruction) {
        StatTreeNode newStatsBonusTree = new StatTreeNode();
        String[] stringArray = new String[]{"Golden Age"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromGoldenAge(this.city.getCiv().getGoldenAges().isGoldenAge()), stringArray);
        stringArray = new String[]{"Railroad"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromRailroad(), stringArray);
        stringArray = new String[]{"Puppet City"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromPuppetCity(), stringArray);
        stringArray = new String[]{"Unit Supply"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromUnitSupply(), stringArray);
        newStatsBonusTree.add(this.getStatsPercentBonusesFromUniquesBySource(currentConstruction));
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Iterator<Building> iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            String[] stringArray2 = new String[]{"Buildings", building.getName()};
            newStatsBonusTree.addStats(building.getStatPercentageBonuses(this.city, localUniqueCache), stringArray2);
        }
        if (DebugUtils.INSTANCE.getSUPERCHARGED()) {
            Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            for (Stat stat : Stat.getEntries()) {
                stats.set(stat, 10000.0f);
            }
            String[] stringArray3 = new String[]{"Supercharged"};
            newStatsBonusTree.addStats(stats, stringArray3);
        }
        return newStatsBonusTree;
    }

    private final void updateStatPercentBonusList(IConstruction currentConstruction) {
        this.statPercentBonusTree = this.getStatPercentBonusList(currentConstruction);
    }

    public final void update(@NotNull IConstruction currentConstruction, boolean updateTileStats, boolean updateCivStats, @NotNull LocalUniqueCache localUniqueCache, boolean calculateGrowthModifiers) {
        Intrinsics.checkNotNullParameter(currentConstruction, "currentConstruction");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        if (updateTileStats) {
            this.updateTileStats(localUniqueCache);
        }
        StatTreeNode statsFromBuildings = this.city.getCityConstructions().getStats(localUniqueCache);
        this.updateBaseStatList(statsFromBuildings);
        this.updateCityHappiness(statsFromBuildings);
        this.updateStatPercentBonusList(currentConstruction);
        this.updateFinalStatList(currentConstruction, calculateGrowthModifiers);
        Stats newCurrentCityStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Iterator<Stats> iterator2 = this.finalStatList.values().iterator();
        while (iterator2.hasNext()) {
            Stats stat;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            newCurrentCityStats.add(stat);
        }
        this.currentCityStats = newCurrentCityStats;
        if (updateCivStats) {
            this.city.getCiv().updateStatsForNextTurn();
        }
    }

    public static /* synthetic */ void update$default(CityStats cityStats, IConstruction iConstruction, boolean bl, boolean bl2, LocalUniqueCache localUniqueCache, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            iConstruction = cityStats.city.getCityConstructions().getCurrentConstruction();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            localUniqueCache = new LocalUniqueCache(false, 1, null);
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        cityStats.update(iConstruction, bl, bl2, localUniqueCache, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFinalStatList(IConstruction currentConstruction, boolean calculateGrowthModifiers) {
        void $this$mapTo$iv$iv;
        Unique growthNullifyingUnique;
        void $this$mapTo$iv$iv2;
        boolean bl;
        Iterable it;
        boolean bl2;
        Object object;
        void $this$mapTo$iv$iv3;
        Object $this$map$iv;
        Iterable<Stats.StatValuePair> entry;
        StatMap newFinalStatList = new StatMap();
        for (Map.Entry object2 : ((Map)this.baseStatTree.getChildren()).entrySet()) {
            String key = (String)object2.getKey();
            StatTreeNode value = (StatTreeNode)object2.getValue();
            ((Map)newFinalStatList).put(key, value.getTotalStats().clone());
        }
        Stats statPercentBonusesSum = this.statPercentBonusTree.getTotalStats();
        Iterator<Stats> iterator2 = newFinalStatList.values().iterator();
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            ((Stats)entry).setProduction(((Stats)entry).getProduction() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getProduction()));
        }
        Collection<Stats> collection = newFinalStatList.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        entry = collection;
        Object d = this;
        boolean $i$f$map22 = false;
        void var8_25 = $this$map$iv;
        Object destination$iv$iv232 = (String[])new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it2;
            Stats stats = (Stats)item$iv$iv;
            object = destination$iv$iv232;
            bl2 = false;
            object.add(Float.valueOf(it2.getProduction()));
        }
        Stats stats = ((CityStats)d).getStatsFromProduction(CollectionsKt.sumOfFloat((List)destination$iv$iv232));
        if (stats != null && !stats.isEmpty()) {
            void $this$updateFinalStatList_u24lambda_u241;
            Object $i$f$map22 = $this$map$iv = new StatTreeNode();
            d = this;
            boolean bl222 = false;
            $this$updateFinalStatList_u24lambda_u241.getChildren().putAll((Map<String, StatTreeNode>)this.baseStatTree.getChildren());
            destination$iv$iv232 = new String[]{"Production"};
            $this$updateFinalStatList_u24lambda_u241.addStats(stats, (String)destination$iv$iv232);
            ((CityStats)d).baseStatTree = $this$map$iv;
            ((Map)newFinalStatList).put("Construction", stats);
        }
        for (Object e : newFinalStatList.values()) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Stats entry2 = (Stats)e;
            entry2.setGold(entry2.getGold() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getGold()));
            entry2.setCulture(entry2.getCulture() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getCulture()));
            entry2.setFood(entry2.getFood() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getFood()));
            entry2.setFaith(entry2.getFaith() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getFaith()));
        }
        if (IHasUniques.hasUnique$default(this.city.getRuleset().getModOptions(), UniqueType.ConvertGoldToScience, null, 2, null)) {
            Collection<Stats> collection2 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
            Object entry2 = collection2;
            double bl222 = 0.0;
            Iterator $i$f$mapTo22 = entry2.iterator();
            while ($i$f$mapTo22.hasNext()) {
                Object item$iv$iv;
                Iterator iterator3 = $i$f$mapTo22.next();
                item$iv$iv = (Stats)((Object)iterator3);
                double d2 = bl222;
                boolean $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = false;
                double unit = ((Stats)it).getGold();
                bl222 = d2 + unit;
            }
            float amountConverted = (int)(bl222 * (double)this.city.getCiv().getTech().getGoldPercentConvertedToScience());
            if (amountConverted > 0.0f) {
                entry2 = newFinalStatList;
                String bl222 = "Gold -> Science";
                float destination$iv$iv232 = -amountConverted;
                destination$iv$iv232 = new Stats(0.0f, 0.0f, destination$iv$iv232, amountConverted, 0.0f, 0.0f, 0.0f, 115, null);
                entry2.put(bl222, destination$iv$iv232);
            }
        }
        Iterator<Object> amountConverted = newFinalStatList.values().iterator();
        while (amountConverted.hasNext()) {
            Stats entry3;
            Intrinsics.checkNotNullExpressionValue(amountConverted.next(), "next(...)");
            entry3.setScience(entry3.getScience() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getScience()));
        }
        amountConverted = SequencesKt.distinct(SequencesKt.map(City.getMatchingUniques$default(this.city, UniqueType.NullifiesStat, null, false, 6, null), CityStats::updateFinalStatList$lambda$3)).iterator();
        while (amountConverted.hasNext()) {
            void $this$updateFinalStatList_u24lambda_u245;
            Pair entry3 = (Pair)amountConverted.next();
            Unique unique = (Unique)entry3.component1();
            Stat statToBeRemoved = (Stat)entry3.component2();
            Collection<Stats> collection3 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
            it = collection3;
            double $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = 0.0;
            for (Object t : it) {
                void it3;
                Stats stats2 = (Stats)t;
                double d3 = $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232;
                bl = false;
                double d4 = it3.get(statToBeRemoved);
                $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = d3 + d4;
            }
            double removedAmount = $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232;
            Iterable $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = it = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            object = unique.getSourceNameForUser();
            d = newFinalStatList;
            bl2 = false;
            $this$updateFinalStatList_u24lambda_u245.set(statToBeRemoved, -((float)removedAmount));
            Unit unit = Unit.INSTANCE;
            ((StatMap)d).add((String)object, (Stats)it);
        }
        float foodEaten = this.calcFoodEaten();
        Object object2 = newFinalStatList.get((Object)"Population");
        Intrinsics.checkNotNull(object2);
        Stats entry3 = (Stats)object2;
        entry3.setFood(entry3.getFood() - foodEaten);
        Collection<Stats> collection4 = newFinalStatList.values();
        Intrinsics.checkNotNullExpressionValue(collection4, "<get-values>(...)");
        Iterable $this$map$iv2 = collection4;
        boolean $i$f$map3 = false;
        Iterable removedAmount = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it4;
            Iterator iterator4 = (Stats)item$iv$iv;
            d = destination$iv$iv;
            boolean bl3 = false;
            d.add(Float.valueOf(it4.getFood()));
        }
        float totalFood = CollectionsKt.sumOfFloat((List)destination$iv$iv);
        if (totalFood > 0.0f && calculateGrowthModifiers) {
            void $this$mapTo$iv$iv4;
            StatMap growthBonuses = CityStats.getGrowthBonus$default(this, totalFood, null, 2, null);
            for (Map.Entry growthBonus : ((Map)growthBonuses).entrySet()) {
                newFinalStatList.add('[' + (String)growthBonus.getKey() + "] ([Growth])", (Stats)growthBonus.getValue());
            }
            if (this.city.isWeLoveTheKingDayActive() && this.city.getCiv().getHappiness() >= 0) {
                Stats weLoveTheKingFood = new Stats(0.0f, totalFood / (float)4, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 125, null);
                newFinalStatList.add("We Love The King Day", weLoveTheKingFood);
            }
            Collection<Stats> collection5 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection5, "<get-values>(...)");
            Iterable $this$map$iv3 = collection5;
            boolean $i$f$map4 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                void it5;
                Stats bl3 = (Stats)item$iv$iv;
                d = destination$iv$iv3;
                boolean bl32 = false;
                d.add(Float.valueOf(it5.getFood()));
            }
            totalFood = CollectionsKt.sumOfFloat((List)destination$iv$iv3);
        }
        float buildingsMaintenance = this.getBuildingMaintenanceCosts();
        ((Map)newFinalStatList).put("Maintenance", new Stats(0.0f, 0.0f, -((float)((int)buildingsMaintenance)), 0.0f, 0.0f, 0.0f, 0.0f, 123, null));
        if (this.canConvertFoodToProduction(totalFood, currentConstruction)) {
            ((Map)newFinalStatList).put("Excess food to production", new Stats(this.getProductionFromExcessiveFood(totalFood), -totalFood, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 124, null));
        }
        if ((growthNullifyingUnique = (Unique)SequencesKt.firstOrNull(City.getMatchingUniques$default(this.city, UniqueType.NullifiesGrowth, null, false, 6, null))) != null) {
            Collection<Stats> collection6 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection6, "<get-values>(...)");
            Iterable destination$iv$iv3 = collection6;
            double $i$f$mapTo4 = 0.0;
            for (Object it5 : destination$iv$iv3) {
                void it6;
                Stats bl32 = (Stats)it5;
                double d4 = $i$f$mapTo4;
                bl = false;
                double d5 = it6.get(Stat.Food);
                $i$f$mapTo4 = d4 + d5;
            }
            double currentGrowth = $i$f$mapTo4;
            if (currentGrowth > 0.0) {
                newFinalStatList.add(growthNullifyingUnique.getSourceNameForUser(), new Stats(0.0f, -((float)currentGrowth), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 125, null));
            }
        }
        if (this.city.isInResistance()) {
            newFinalStatList.clear();
        }
        Collection<Stats> collection7 = newFinalStatList.values();
        Intrinsics.checkNotNullExpressionValue(collection7, "<get-values>(...)");
        Iterable $this$map$iv4 = collection7;
        boolean $i$f$map5 = false;
        Iterable destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Stats it6 = (Stats)item$iv$iv;
            d = destination$iv$iv4;
            bl = false;
            d.add(Float.valueOf(it2.getProduction()));
        }
        if (CollectionsKt.sumOfFloat((List)destination$iv$iv4) < 1.0f) {
            ((Map)newFinalStatList).put("Production", new Stats(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 126, null));
        }
        this.finalStatList = newFinalStatList;
    }

    static /* synthetic */ void updateFinalStatList$default(CityStats cityStats, IConstruction iConstruction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        cityStats.updateFinalStatList(iConstruction, bl);
    }

    @Readonly
    public final boolean canConvertFoodToProduction(float food, @NotNull IConstruction currentConstruction) {
        Intrinsics.checkNotNullParameter(currentConstruction, "currentConstruction");
        return food > 0.0f && currentConstruction instanceof INonPerpetualConstruction && IHasUniques.hasUnique$default((IHasUniques)((Object)currentConstruction), UniqueType.ConvertFoodToProductionWhenConstructed, null, 2, null);
    }

    @Pure
    public final float getProductionFromExcessiveFood(float food) {
        return food >= 4.0f ? 2.0f + (float)((int)(food / 4.0f)) : (food >= 2.0f ? 2.0f : (food >= 1.0f ? 1.0f : 0.0f));
    }

    @Readonly
    private final float calcFoodEaten() {
        float foodEaten = (float)this.city.getPopulation().getPopulation() * (float)2;
        float foodEatenBySpecialists = 2.0f * (float)this.city.getPopulation().getNumberOfSpecialists();
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.FoodConsumptionBySpecialists, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, false, 6, null)) continue;
            foodEatenBySpecialists *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return foodEaten -= 2.0f * (float)this.city.getPopulation().getNumberOfSpecialists() - foodEatenBySpecialists;
    }

    private static final void getStatsFromUniquesBySource$addUniqueStats(List<Unique> cityStateStatsMultipliers, StatTreeNode sourceToStats, Unique unique) {
        Stats stats = unique.getStats().clone();
        if (unique.getSourceObjectType() == UniqueTarget.CityState) {
            for (Unique multiplierUnique : cityStateStatsMultipliers) {
                Stat stat = Stat.valueOf(multiplierUnique.getParams().get(1));
                stats.set(stat, stats.get(stat) * FormattingExtensionsKt.toPercent(multiplierUnique.getParams().get(0)));
            }
        }
        String[] stringArray = new String[2];
        stringArray[0] = unique.getSourceNameForUser();
        String string = unique.getSourceObjectName();
        if (string == null) {
            string = "";
        }
        stringArray[1] = string;
        sourceToStats.addStats(stats, stringArray);
    }

    private static final void getStatsPercentBonusesFromUniquesBySource$addUniqueStats(StatTreeNode sourceToStats, Unique unique, Stat stat, float amount) {
        Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        stats.add(stat, amount);
        String[] stringArray = new String[2];
        stringArray[0] = unique.getSourceNameForUser();
        String string = unique.getSourceObjectName();
        if (string == null) {
            string = "";
        }
        stringArray[1] = string;
        sourceToStats.addStats(stats, stringArray);
    }

    private static final boolean isConnectedToCapital$lambda$0(EnumSet mediums) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(mediums, "mediums");
            Iterable $this$any$iv = mediums;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CapitalConnectionsFinder.CapitalConnectionMedium it = (CapitalConnectionsFinder.CapitalConnectionMedium)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it.getRoadType() == RoadStatus.Railroad)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean updateTileStats$lambda$0(CityStats this$0, Tile it) {
        boolean bl;
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(this$0.city.getLocation(), it.getPosition())) return true;
        if (this$0.city.isWorked(it)) return true;
        if (!Intrinsics.areEqual(it.getOwningCity(), this$0.city)) return false;
        TileImprovement tileImprovement = it.getUnpillagedTileImprovement();
        if (tileImprovement != null) {
            if (tileImprovement.hasUnique(UniqueType.TileProvidesYieldWithoutPopulation, it.getStateThisTile$core())) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!it.terrainHasUnique(UniqueType.TileProvidesYieldWithoutPopulation, it.getStateThisTile$core())) return false;
        return true;
    }

    private static final Pair updateFinalStatList$lambda$3(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it, Stat.valueOf(it.getParams().get(0)));
    }
}

