/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.TutorialTrigger;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.CityAmbiencePlayer;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.ParticleEffectMapFireworks;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyShortcutDispatcherVeto;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.tilegroups.CityTileGroup;
import com.unciv.ui.components.tilegroups.CityTileState;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileGroupMap;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.layers.TileLayerMisc;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.cityscreen.BuyButtonFactory;
import com.unciv.ui.screens.cityscreen.CityConstructionsTable;
import com.unciv.ui.screens.cityscreen.CityMapHolder;
import com.unciv.ui.screens.cityscreen.CityScreenCityPickerTable;
import com.unciv.ui.screens.cityscreen.CityScreenTileTable;
import com.unciv.ui.screens.cityscreen.CityStatsTable;
import com.unciv.ui.screens.cityscreen.ConstructionInfoTable;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u0000 \u007f2\u00020\u00012\u00020\u0002:\u0003\u007f\u0080\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010K\u001a\u00020LH\u0016J\r\u0010M\u001a\u00020NH\u0000\u00a2\u0006\u0002\bOJ\r\u0010P\u001a\u00020NH\u0000\u00a2\u0006\u0002\bQJ\b\u0010R\u001a\u00020NH\u0002J\u0006\u0010S\u001a\u00020\u0012J\b\u0010T\u001a\u00020NH\u0002J\b\u0010U\u001a\u00020NH\u0002J\b\u0010V\u001a\u00020NH\u0002J)\u0010W\u001a#\u0012\u0015\u0012\u0013\u0018\u00010Y\u00a2\u0006\f\bZ\u0012\b\b[\u0012\u0004\b\b(\\\u0012\u0004\u0012\u00020]0Xj\u0002`^H\u0016J\u0018\u0010_\u001a\u00020N2\u0006\u0010`\u001a\u00020*2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0015\u0010a\u001a\u00020N2\u0006\u00102\u001a\u00020\bH\u0000\u00a2\u0006\u0002\bbJ\u0018\u0010c\u001a\u00020N2\u0006\u0010`\u001a\u00020*2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010d\u001a\u00020N2\u0006\u0010`\u001a\u00020*2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0015\u0010e\u001a\u00020\u00122\u0006\u0010f\u001a\u00020gH\u0000\u00a2\u0006\u0002\bhJ\u000e\u0010i\u001a\u00020N2\u0006\u0010j\u001a\u00020<J\u000e\u0010k\u001a\u00020N2\u0006\u0010[\u001a\u00020lJ\u000e\u0010k\u001a\u00020N2\u0006\u0010m\u001a\u00020\u0006J\u0012\u0010n\u001a\u00020N2\b\u0010o\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010p\u001a\u00020NJ\u001e\u0010q\u001a\u00020N2\u0006\u0010r\u001a\u00020g2\u0006\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020\u0012J\u0006\u0010v\u001a\u00020NJ\u0006\u0010w\u001a\u00020NJ\n\u0010x\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010y\u001a\u00020N2\u0006\u0010z\u001a\u00020<J\b\u0010{\u001a\u00020\u0001H\u0016J\b\u0010|\u001a\u00020NH\u0016J\u0010\u0010}\u001a\u00020N2\u0006\u0010z\u001a\u00020~H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u0012\u0012\u0004\u0012\u00020*0)j\b\u0012\u0004\u0012\u00020*`+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010.\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\"\u00102\u001a\u0004\u0018\u00010\b2\b\u0010.\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0010\u0010;\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010=\u001a\u00020<2\u0006\u0010.\u001a\u00020<8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u0010\u0010B\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010G\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u0019\"\u0004\bI\u0010J\u00a8\u0006\u0081\u0001"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "city", "Lcom/unciv/logic/city/City;", "initSelectedConstruction", "Lcom/unciv/models/ruleset/IConstruction;", "initSelectedTile", "Lcom/unciv/logic/map/tile/Tile;", "ambiencePlayer", "Lcom/unciv/ui/audio/CityAmbiencePlayer;", "<init>", "(Lcom/unciv/logic/city/City;Lcom/unciv/models/ruleset/IConstruction;Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/ui/audio/CityAmbiencePlayer;)V", "getCity$core", "()Lcom/unciv/logic/city/City;", "selectedCiv", "Lcom/unciv/logic/civilization/Civilization;", "isSpying", "", "viewableCities", "", "getViewableCities", "()Ljava/util/List;", "canChangeState", "getCanChangeState", "()Z", "constructionsTable", "Lcom/unciv/ui/screens/cityscreen/CityConstructionsTable;", "razeCityButtonHolder", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityStatsTable", "Lcom/unciv/ui/screens/cityscreen/CityStatsTable;", "tileTable", "Lcom/unciv/ui/screens/cityscreen/CityScreenTileTable;", "selectedConstructionTable", "Lcom/unciv/ui/screens/cityscreen/ConstructionInfoTable;", "cityPickerTable", "Lcom/unciv/ui/screens/cityscreen/CityScreenCityPickerTable;", "exitCityButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "tileGroups", "Ljava/util/ArrayList;", "Lcom/unciv/ui/components/tilegroups/CityTileGroup;", "Lkotlin/collections/ArrayList;", "mapScrollPane", "Lcom/unciv/ui/screens/cityscreen/CityMapHolder;", "value", "selectedConstruction", "getSelectedConstruction", "()Lcom/unciv/models/ruleset/IConstruction;", "selectedTile", "getSelectedTile", "()Lcom/unciv/logic/map/tile/Tile;", "pickTileData", "Lcom/unciv/ui/screens/cityscreen/CityScreen$PickTileForImprovementData;", "getPickTileData", "()Lcom/unciv/ui/screens/cityscreen/CityScreen$PickTileForImprovementData;", "setPickTileData", "(Lcom/unciv/ui/screens/cityscreen/CityScreen$PickTileForImprovementData;)V", "selectedQueueEntryTargetTile", "", "selectedQueueEntry", "getSelectedQueueEntry", "()I", "setSelectedQueueEntry", "(I)V", "nextTileToOwn", "cityAmbiencePlayer", "isWLTKday", "fireworks", "Lcom/unciv/ui/components/ParticleEffectMapFireworks;", "pauseFireworks", "getPauseFireworks$core", "setPauseFireworks$core", "(Z)V", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "update", "", "update$core", "updateWithoutConstructionAndMap", "updateWithoutConstructionAndMap$core", "updateCityStats", "canCityBeChanged", "updateTileGroups", "updateAnnexAndRazeCityButton", "addTiles", "getShortcutDispatcherVetoer", "Lkotlin/Function1;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/ParameterName;", "name", "associatedActor", "Lcom/unciv/ui/components/input/KeyShortcutDispatcherVeto$DispatcherVetoResult;", "Lcom/unciv/ui/components/input/DispatcherVetoer;", "tileWorkedIconOnClick", "tileGroup", "askToBuyTile", "askToBuyTile$core", "tileWorkedIconDoubleClick", "tileGroupOnClick", "hasFreeBuilding", "building", "Lcom/unciv/models/ruleset/Building;", "hasFreeBuilding$core", "selectConstructionFromQueue", "index", "selectConstruction", "", "newConstruction", "selectTile", "newTile", "clearSelection", "startPickTileForCreatesOneImprovement", "construction", "stat", "Lcom/unciv/models/stats/Stat;", "isBuying", "stopPickTileForCreatesOneImprovement", "exit", "passOnCityAmbiencePlayer", "page", "delta", "recreate", "dispose", "render", "", "Companion", "PickTileForImprovementData", "core"})
@SourceDebugExtension(value={"SMAP\nCityScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityScreen.kt\ncom/unciv/ui/screens/cityscreen/CityScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,588:1\n774#2:589\n865#2,2:590\n1#3:592\n*S KotlinDebug\n*F\n+ 1 CityScreen.kt\ncom/unciv/ui/screens/cityscreen/CityScreen\n*L\n74#1:589\n74#1:590,2\n*E\n"})
public final class CityScreen
extends BaseScreen
implements RecreateOnResize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final City city;
    @NotNull
    private final Civilization selectedCiv;
    private final boolean isSpying;
    @NotNull
    private final List<City> viewableCities;
    private final boolean canChangeState;
    @NotNull
    private CityConstructionsTable constructionsTable;
    @NotNull
    private Table razeCityButtonHolder;
    @NotNull
    private CityStatsTable cityStatsTable;
    @NotNull
    private CityScreenTileTable tileTable;
    @NotNull
    private ConstructionInfoTable selectedConstructionTable;
    @NotNull
    private CityScreenCityPickerTable cityPickerTable;
    @NotNull
    private final TextButton exitCityButton;
    @NotNull
    private ArrayList<CityTileGroup> tileGroups;
    @NotNull
    private final CityMapHolder mapScrollPane;
    @Nullable
    private IConstruction selectedConstruction;
    @Nullable
    private Tile selectedTile;
    @Nullable
    private PickTileForImprovementData pickTileData;
    @Nullable
    private Tile selectedQueueEntryTargetTile;
    @Nullable
    private final Tile nextTileToOwn;
    @Nullable
    private CityAmbiencePlayer cityAmbiencePlayer;
    private final boolean isWLTKday;
    @Nullable
    private final ParticleEffectMapFireworks fireworks;
    private boolean pauseFireworks;
    public static final float posFromEdge = 5.0f;
    public static final float wltkIconSize = 40.0f;

    /*
     * WARNING - void declaration
     */
    public CityScreen(@NotNull City city, @Nullable IConstruction initSelectedConstruction, @Nullable Tile initSelectedTile, @Nullable CityAmbiencePlayer ambiencePlayer) {
        void $this$exitCityButton_u24lambda_u240;
        List list2;
        CityScreen cityScreen;
        Object object;
        Intrinsics.checkNotNullParameter(city, "city");
        this.city = city;
        this.selectedCiv = GUI.INSTANCE.getWorldScreen().getSelectedCiv();
        this.isSpying = this.selectedCiv.getGameInfo().isEspionageEnabled() && !Intrinsics.areEqual(this.selectedCiv, this.city.getCiv());
        CityScreen cityScreen2 = this;
        if (this.isSpying) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            object = this.selectedCiv.getEspionageManager().getCitiesWithOurSpies();
            cityScreen = cityScreen2;
            boolean $i$f$filter = false;
            void var7_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                City it = (City)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getCiv(), GUI.INSTANCE.getWorldScreen().getSelectedCiv()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            cityScreen2 = cityScreen;
        } else {
            list2 = this.city.getCiv().getCities();
        }
        cityScreen2.viewableCities = list2;
        this.canChangeState = GUI.INSTANCE.isAllowedChangeState() && !this.isSpying;
        this.constructionsTable = new CityConstructionsTable(this);
        this.razeCityButtonHolder = new Table();
        this.cityStatsTable = new CityStatsTable(this);
        this.tileTable = new CityScreenTileTable(this);
        this.selectedConstructionTable = new ConstructionInfoTable(this);
        this.cityPickerTable = new CityScreenCityPickerTable(this);
        Object $i$f$filter = object = Scene2dExtensionsKt.toTextButton$default("Exit city", null, false, 3, null);
        cityScreen = this;
        boolean bl = false;
        $this$exitCityButton_u24lambda_u240.getLabelCell().pad(10.0f);
        ActivationExtensionsKt.getKeyShortcuts((Actor)$this$exitCityButton_u24lambda_u240).add(KeyCharAndCode.Companion.getBACK());
        ActivationExtensionsKt.onActivation((Actor)$this$exitCityButton_u24lambda_u240, () -> CityScreen.exitCityButton$lambda$0$0(this));
        cityScreen.exitCityButton = object;
        this.tileGroups = new ArrayList();
        this.mapScrollPane = new CityMapHolder();
        this.selectedConstruction = initSelectedConstruction;
        this.selectedTile = initSelectedTile;
        this.nextTileToOwn = this.city.getExpansion().chooseNewTileToOwn();
        CityAmbiencePlayer cityAmbiencePlayer = ambiencePlayer;
        if (cityAmbiencePlayer == null) {
            cityAmbiencePlayer = new CityAmbiencePlayer(this.city);
        }
        this.cityAmbiencePlayer = cityAmbiencePlayer;
        this.isWLTKday = this.city.isWeLoveTheKingDayActive();
        if (this.isWLTKday && UncivGame.Companion.getCurrent().getSettings().getCitySoundsVolume() > 0.0f) {
            SoundPlayer.INSTANCE.play(new UncivSound("WLTK"));
        }
        this.fireworks = this.isWLTKday ? ParticleEffectMapFireworks.Companion.create(this.getGame(), this.mapScrollPane) : null;
        UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask("Enter city screen");
        this.addTiles();
        this.constructionsTable.addActorsToStage();
        this.getStage().addActor(this.cityStatsTable);
        this.getStage().addActor(this.selectedConstructionTable);
        this.getStage().addActor(this.tileTable);
        this.getStage().addActor(this.cityPickerTable);
        this.getStage().addActor(this.exitCityButton);
        this.update$core();
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.PreviousCity, 0, () -> CityScreen._init_$lambda$0(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.NextCity, 0, () -> CityScreen._init_$lambda$1(this), 2, null);
        if (this.isPortrait()) {
            Object $this$_init__u24lambda_u242 = object = this.mapScrollPane;
            boolean bl2 = false;
            ((ZoomableScrollPane)$this$_init__u24lambda_u242).setScrollX((((ScrollPane)$this$_init__u24lambda_u242).getMaxX() - this.constructionsTable.getLowerWidth() - 5.0f) / (float)2);
            ((ScrollPane)$this$_init__u24lambda_u242).setScrollY((((ScrollPane)$this$_init__u24lambda_u242).getMaxY() - Scene2dExtensionsKt.packIfNeeded(this.cityStatsTable).getHeight() - 5.0f + this.cityPickerTable.getTop()) / (float)2);
            ((ScrollPane)$this$_init__u24lambda_u242).updateVisualScroll();
        }
    }

    public /* synthetic */ CityScreen(City city, IConstruction iConstruction, Tile tile, CityAmbiencePlayer cityAmbiencePlayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iConstruction = null;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        if ((n & 8) != 0) {
            cityAmbiencePlayer = null;
        }
        this(city, iConstruction, tile, cityAmbiencePlayer);
    }

    @NotNull
    public final City getCity$core() {
        return this.city;
    }

    @NotNull
    public final List<City> getViewableCities() {
        return this.viewableCities;
    }

    public final boolean getCanChangeState() {
        return this.canChangeState;
    }

    @Nullable
    public final IConstruction getSelectedConstruction() {
        return this.selectedConstruction;
    }

    @Nullable
    public final Tile getSelectedTile() {
        return this.selectedTile;
    }

    @Nullable
    public final PickTileForImprovementData getPickTileData() {
        return this.pickTileData;
    }

    public final void setPickTileData(@Nullable PickTileForImprovementData pickTileForImprovementData) {
        this.pickTileData = pickTileForImprovementData;
    }

    public final int getSelectedQueueEntry() {
        return this.constructionsTable.getSelectedQueueEntry();
    }

    public final void setSelectedQueueEntry(int value) {
        this.constructionsTable.setSelectedQueueEntry(value);
    }

    public final boolean getPauseFireworks$core() {
        return this.pauseFireworks;
    }

    public final void setPauseFireworks$core(boolean bl) {
        this.pauseFireworks = bl;
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.selectedCiv.getGameInfo().getRuleset();
    }

    public final void update$core() {
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, false, 31, null);
        this.constructionsTable.setVisible(!this.isSpying);
        this.constructionsTable.update(this.selectedConstruction);
        this.updateWithoutConstructionAndMap$core();
        this.updateTileGroups();
    }

    public final void updateWithoutConstructionAndMap$core() {
        this.tileTable.update(this.selectedTile);
        this.tileTable.setPosition(this.getStage().getWidth() - 5.0f, 5.0f, 20);
        this.selectedConstructionTable.update(this.selectedConstruction);
        this.selectedConstructionTable.setPosition(this.getStage().getWidth() - 5.0f, 5.0f, 20);
        float rightMargin = !this.isPortrait() || this.isCrampedPortrait() ? 0.0f : (this.selectedTile != null ? Scene2dExtensionsKt.packIfNeeded(this.tileTable).getWidth() : (this.selectedConstruction != null ? Scene2dExtensionsKt.packIfNeeded(this.selectedConstructionTable).getWidth() : 5.0f));
        float leftMargin = !this.isPortrait() ? 0.0f : this.constructionsTable.getLowerWidth();
        float centeredX = (this.getStage().getWidth() - leftMargin - rightMargin) / (float)2 + leftMargin;
        this.exitCityButton.setPosition(centeredX, 10.0f, 4);
        this.cityPickerTable.update();
        this.cityPickerTable.setPosition(centeredX, this.exitCityButton.getTop() + 10.0f, 4);
        this.updateCityStats();
        this.updateAnnexAndRazeCityButton();
    }

    private final void updateCityStats() {
        float statsHeight = this.getStage().getHeight() - 10.0f;
        if (this.selectedTile != null) {
            statsHeight -= this.tileTable.getTop() + 10.0f;
        }
        if (this.selectedConstruction != null) {
            statsHeight -= this.selectedConstructionTable.getTop() + 10.0f;
        }
        this.cityStatsTable.update(statsHeight);
        this.cityStatsTable.setPosition(this.getStage().getWidth() - 5.0f, this.getStage().getHeight() - 5.0f, 18);
    }

    public final boolean canCityBeChanged() {
        return this.canChangeState && !this.city.isPuppet();
    }

    private final void updateTileGroups() {
        LocalUniqueCache cityUniqueCache = new LocalUniqueCache(false, 1, null);
        Iterator<CityTileGroup> iterator2 = this.tileGroups.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<CityTileGroup> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            CityTileGroup tileGroup;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            TileGroup.update$default(tileGroup, this.selectedCiv, null, 2, null);
            tileGroup.getLayerMisc().removeHexOutline();
            if (this.isSpying) continue;
            if (tileGroup.getTileState() == CityTileState.BLOCKADED) {
                BaseScreen.displayTutorial$default(this, TutorialTrigger.CityTileBlockade, null, 2, null);
            }
            if (Intrinsics.areEqual(tileGroup.getTile(), this.nextTileToOwn)) {
                tileGroup.getLayerMisc().addHexOutline(Scene2dExtensionsKt.colorFromRGB(200, 20, 220));
            } else if (Intrinsics.areEqual(tileGroup.getTile(), this.selectedQueueEntryTargetTile)) {
                TileLayerMisc tileLayerMisc = tileGroup.getLayerMisc();
                Color color = Color.BROWN;
                Intrinsics.checkNotNullExpressionValue(color, "BROWN");
                tileLayerMisc.addHexOutline(color);
            } else if (this.pickTileData != null && this.city.getTiles().contains(tileGroup.getTile().getPosition())) {
                Color color;
                Pair<Color, Float> $this$updateTileGroups_u24lambda_u240 = CityScreen.updateTileGroups$getPickImprovementColor(this, cityUniqueCache, tileGroup.getTile());
                boolean bl = false;
                Color color2 = color = $this$updateTileGroups_u24lambda_u240.getFirst().cpy();
                TileLayerMisc tileLayerMisc = tileGroup.getLayerMisc();
                boolean bl2 = false;
                $this$updateTileGroups_u24lambda_u240_u240.a = ((Number)$this$updateTileGroups_u24lambda_u240.getSecond()).floatValue();
                Color color3 = color;
                Intrinsics.checkNotNullExpressionValue(color3, "apply(...)");
                tileLayerMisc.addHexOutline(color3);
            }
            if (this.fireworks == null || !Intrinsics.areEqual(tileGroup.getTile().getPosition(), this.city.getLocation())) continue;
            this.fireworks.setActorBounds(tileGroup);
        }
    }

    private final void updateAnnexAndRazeCityButton() {
        Cell<Actor> cell;
        boolean canAnnex;
        this.razeCityButtonHolder.clear();
        if (this.isWLTKday && this.fireworks == null) {
            CityScreen.updateAnnexAndRazeCityButton$addWltkIcon(this, "OtherIcons/WLTK LR", CityScreen::updateAnnexAndRazeCityButton$lambda$1);
            CityScreen.updateAnnexAndRazeCityButton$addWltkIcon(this, "OtherIcons/WLTK 1", CityScreen::updateAnnexAndRazeCityButton$lambda$2).padRight(10.0f);
        }
        boolean bl = canAnnex = !Civilization.hasUnique$default(this.city.getCiv(), UniqueType.MayNotAnnexCities, null, 2, null);
        if (this.city.isPuppet() && canAnnex) {
            TextButton annexCityButton = Scene2dExtensionsKt.toTextButton$default("Annex city", null, false, 3, null);
            annexCityButton.getLabelCell().pad(10.0f);
            ActivationExtensionsKt.onClick(annexCityButton, () -> CityScreen.updateAnnexAndRazeCityButton$lambda$3(this));
            if (!this.canChangeState) {
                Scene2dExtensionsKt.disable(annexCityButton);
            }
            cell = this.razeCityButtonHolder.add((Actor)annexCityButton);
        } else if (!this.city.isBeingRazed()) {
            TextButton razeCityButton = Scene2dExtensionsKt.toTextButton$default("Raze city", null, false, 3, null);
            razeCityButton.getLabelCell().pad(10.0f);
            ActivationExtensionsKt.onClick(razeCityButton, () -> CityScreen.updateAnnexAndRazeCityButton$lambda$4(this));
            if (!(this.canChangeState && City.canBeDestroyed$default(this.city, false, 1, null) && canAnnex)) {
                Scene2dExtensionsKt.disable(razeCityButton);
            }
            cell = this.razeCityButtonHolder.add((Actor)razeCityButton);
        } else {
            TextButton stopRazingCityButton = Scene2dExtensionsKt.toTextButton$default("Stop razing city", null, false, 3, null);
            stopRazingCityButton.getLabelCell().pad(10.0f);
            ActivationExtensionsKt.onClick(stopRazingCityButton, () -> CityScreen.updateAnnexAndRazeCityButton$lambda$5(this));
            if (!this.canChangeState) {
                Scene2dExtensionsKt.disable(stopRazingCityButton);
            }
            cell = this.razeCityButtonHolder.add((Actor)stopRazingCityButton);
        }
        if (this.isWLTKday && this.fireworks == null) {
            CityScreen.updateAnnexAndRazeCityButton$addWltkIcon(this, "OtherIcons/WLTK 2", CityScreen::updateAnnexAndRazeCityButton$lambda$6).padLeft(10.0f);
            CityScreen.updateAnnexAndRazeCityButton$addWltkIcon(this, "OtherIcons/WLTK LR", CityScreen::updateAnnexAndRazeCityButton$lambda$7);
        }
        this.razeCityButtonHolder.pack();
        if (this.isCrampedPortrait()) {
            float centerX = this.cityPickerTable.getX() + this.cityPickerTable.getWidth() / (float)2 - this.razeCityButtonHolder.getWidth() / (float)2;
            this.razeCityButtonHolder.setPosition(centerX, this.cityPickerTable.getY() + this.cityPickerTable.getHeight() + (float)10);
            this.tileTable.setPosition(this.getStage().getWidth() - 5.0f, this.razeCityButtonHolder.getTop() + 10.0f, 20);
            this.selectedConstructionTable.setPosition(this.getStage().getWidth() - 5.0f, this.razeCityButtonHolder.getTop() + 10.0f, 20);
            this.updateCityStats();
        } else {
            float f;
            if (this.isPortrait()) {
                float it = this.constructionsTable.getUpperWidth();
                boolean bl2 = false;
                f = it + (this.getStage().getWidth() - this.cityStatsTable.getWidth() - it) / (float)2;
            } else {
                f = this.getStage().getWidth() / (float)2;
            }
            float centerX = f;
            this.razeCityButtonHolder.setPosition(centerX, this.getStage().getHeight() - 20.0f, 2);
        }
        this.getStage().addActor(this.razeCityButtonHolder);
    }

    private final void addTiles() {
        Object tileGroup;
        int viewRange = Math.max(this.city.getExpandRange(), this.city.getWorkRange());
        TileSetStrings tileSetStrings = new TileSetStrings(this.city.getCiv().getGameInfo().getRuleset(), this.getGame().getSettings());
        Sequence<CityTileGroup> cityTileGroups = SequencesKt.map(SequencesKt.filter(this.city.getCenterTile().getTilesInDistance(viewRange), arg_0 -> CityScreen.addTiles$lambda$0(this, arg_0)), arg_0 -> CityScreen.addTiles$lambda$1(this, tileSetStrings, arg_0));
        Iterator<CityTileGroup> iterator2 = cityTileGroups.iterator();
        while (iterator2.hasNext()) {
            tileGroup = iterator2.next();
            ActivationExtensionsKt.onClick((Actor)tileGroup, () -> CityScreen.addTiles$lambda$2(this, (CityTileGroup)tileGroup));
            ActivationExtensionsKt.onClick(((TileGroup)tileGroup).getLayerMisc(), () -> CityScreen.addTiles$lambda$3(this, (CityTileGroup)tileGroup));
            ActivationExtensionsKt.onDoubleClick$default(((TileGroup)tileGroup).getLayerMisc(), null, () -> CityScreen.addTiles$lambda$4(this, (CityTileGroup)tileGroup), 1, null);
            this.tileGroups.add((CityTileGroup)tileGroup);
        }
        Set tilesToUnwrap = new LinkedHashSet();
        Iterator<CityTileGroup> iterator3 = this.tileGroups.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        tileGroup = iterator3;
        while (tileGroup.hasNext()) {
            Object e = tileGroup.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            CityTileGroup tileGroup2 = (CityTileGroup)e;
            float xDifference = this.city.getCenterTile().getPosition().x - tileGroup2.getTile().getPosition().x;
            float yDifference = this.city.getCenterTile().getPosition().y - tileGroup2.getTile().getPosition().y;
            if (!(xDifference > (float)viewRange || xDifference < (float)(-viewRange) || yDifference > (float)viewRange) && !(yDifference < (float)(-viewRange))) continue;
            tilesToUnwrap.add(tileGroup2);
        }
        TileGroupMap tileMapGroup = new TileGroupMap(this.mapScrollPane, this.tileGroups, false, tilesToUnwrap, 4, null);
        this.mapScrollPane.setActor(tileMapGroup);
        this.mapScrollPane.setSize(this.getStage().getWidth(), this.getStage().getHeight());
        this.getStage().addActor(this.mapScrollPane);
        this.mapScrollPane.layout();
        this.mapScrollPane.setScrollPercentX(0.5f);
        this.mapScrollPane.setScrollPercentY(0.5f);
        this.mapScrollPane.updateVisualScroll();
    }

    @Override
    @NotNull
    public Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> getShortcutDispatcherVetoer() {
        return KeyShortcutDispatcherVeto.INSTANCE.createTileGroupMapDispatcherVetoer();
    }

    private final void tileWorkedIconOnClick(CityTileGroup tileGroup, City city) {
        if (!this.canChangeState || city.isPuppet()) {
            return;
        }
        Tile tile = tileGroup.getTile();
        if (tileGroup.getTileState() == CityTileState.WORKABLE) {
            boolean bl;
            if (!tile.providesYield() && city.getPopulation().getFreePopulation() > 0) {
                city.getWorkedTiles().add(tile.getPosition());
                bl = this.getGame().getSettings().addCompletedTutorialTask("Reassign worked tiles");
            } else {
                city.getWorkedTiles().remove(tile.getPosition());
                bl = city.getLockedTiles().remove(tile.getPosition());
            }
            CityStats.update$default(city.getCityStats(), null, false, false, null, false, 31, null);
            this.update$core();
        } else if (tileGroup.getTileState() == CityTileState.PURCHASABLE) {
            this.askToBuyTile$core(tile);
        }
    }

    public final void askToBuyTile$core(@NotNull Tile selectedTile) {
        Intrinsics.checkNotNullParameter(selectedTile, "selectedTile");
        if (!this.canChangeState || !this.city.getExpansion().canBuyTile(selectedTile)) {
            return;
        }
        int goldCostOfTile = this.city.getExpansion().getGoldCostOfTile(selectedTile);
        if (!this.city.getCiv().hasStatToBuy(Stat.Gold, goldCostOfTile)) {
            return;
        }
        PopupKt.closeAllPopups(this);
        String purchasePrompt = TranslationsKt.tr$default("Currently you have [" + this.city.getCiv().getGold() + "] [Gold].", false, false, 3, null) + "\n\n" + TranslationsKt.tr$default("Would you like to purchase [Tile] for [" + goldCostOfTile + "] [" + Stat.Gold.getCharacter() + "]?", false, false, 3, null);
        Popup.open$default(new ConfirmPopup(this, purchasePrompt, "Purchase", true, () -> CityScreen.askToBuyTile$lambda$0(this), () -> CityScreen.askToBuyTile$lambda$1(this, selectedTile)), false, 1, null);
    }

    private final void tileWorkedIconDoubleClick(CityTileGroup tileGroup, City city) {
        if (!this.canChangeState || city.isPuppet() || tileGroup.getTileState() != CityTileState.WORKABLE) {
            return;
        }
        Tile tile = tileGroup.getTile();
        if (!tile.isWorked()) {
            this.tileWorkedIconOnClick(tileGroup, city);
        }
        if (tile.isWorked()) {
            city.getLockedTiles().add(tile.getPosition());
        }
        this.update$core();
    }

    private final void tileGroupOnClick(CityTileGroup tileGroup, City city) {
        if (city.isPuppet()) {
            return;
        }
        Tile tileInfo = tileGroup.getTile();
        if (this.pickTileData != null) {
            PickTileForImprovementData pickTileForImprovementData = this.pickTileData;
            Intrinsics.checkNotNull(pickTileForImprovementData);
            PickTileForImprovementData pickTileData = pickTileForImprovementData;
            this.pickTileData = null;
            TileImprovement improvement = pickTileData.getImprovement();
            if (tileInfo.getImprovementFunctions().canBuildImprovement(improvement, city.getState()) && !tileInfo.isMarkedForCreatesOneImprovement()) {
                if (pickTileData.isBuying()) {
                    new BuyButtonFactory(this).askToBuyConstruction(pickTileData.getBuilding(), pickTileData.getBuyStat(), tileInfo);
                } else {
                    tileInfo.getImprovementFunctions().markForCreatesOneImprovement(improvement.getName());
                    city.getCityConstructions().addToQueue(pickTileData.getBuilding().getName());
                }
            }
            this.update$core();
            return;
        }
        this.selectTile(tileInfo);
        this.update$core();
    }

    public final boolean hasFreeBuilding$core(@NotNull Building building) {
        Intrinsics.checkNotNullParameter(building, "building");
        return this.city.getCiv().getCivConstructions().hasFreeBuilding(this.city, building);
    }

    public final void selectConstructionFromQueue(int index) {
        String string = this.city.getCityConstructions().getConstructionQueue().get(index);
        Intrinsics.checkNotNullExpressionValue(string, "get(...)");
        this.selectConstruction(string);
    }

    public final void selectConstruction(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.selectConstruction(this.city.getCityConstructions().getConstruction$core(name));
    }

    public final void selectConstruction(@NotNull IConstruction newConstruction) {
        Intrinsics.checkNotNullParameter(newConstruction, "newConstruction");
        this.selectedConstruction = newConstruction;
        if (newConstruction instanceof Building && ((Building)newConstruction).hasCreateOneImprovementUnique()) {
            TileImprovement improvement = ((Building)newConstruction).getImprovementToCreate(this.city.getRuleset(), this.city.getCiv());
            this.selectedQueueEntryTargetTile = improvement == null ? null : this.city.getCityConstructions().getTileForImprovement(improvement.getName());
        } else {
            this.selectedQueueEntryTargetTile = null;
            this.pickTileData = null;
        }
        this.selectedTile = null;
    }

    private final void selectTile(Tile newTile) {
        this.selectedConstruction = null;
        this.selectedQueueEntryTargetTile = null;
        this.pickTileData = null;
        this.selectedTile = newTile;
    }

    public final void clearSelection() {
        this.selectTile(null);
    }

    public final void startPickTileForCreatesOneImprovement(@NotNull Building construction, @NotNull Stat stat, boolean isBuying) {
        Intrinsics.checkNotNullParameter(construction, "construction");
        Intrinsics.checkNotNullParameter(stat, "stat");
        TileImprovement tileImprovement = construction.getImprovementToCreate(this.city.getRuleset(), this.city.getCiv());
        if (tileImprovement == null) {
            return;
        }
        TileImprovement improvement = tileImprovement;
        this.pickTileData = new PickTileForImprovementData(construction, improvement, isBuying, stat);
        this.updateTileGroups();
        new ToastPopup("Please select a tile for this building's [" + improvement.getName() + ']', this, 0L, 4, null);
    }

    public final void stopPickTileForCreatesOneImprovement() {
        if (this.pickTileData == null) {
            return;
        }
        this.pickTileData = null;
        this.updateTileGroups();
    }

    public final void exit() {
        BaseScreen newScreen = this.getGame().popScreen();
        if (newScreen instanceof WorldScreen) {
            WorldMapHolder.setCenterPosition$default(((WorldScreen)newScreen).getMapHolder(), this.city.getLocation(), true, false, null, 12, null);
            UnitTable.selectUnit$default(((WorldScreen)newScreen).getBottomUnitTable$core(), null, false, 3, null);
        }
    }

    private final CityAmbiencePlayer passOnCityAmbiencePlayer() {
        CityAmbiencePlayer player = this.cityAmbiencePlayer;
        this.cityAmbiencePlayer = null;
        return player;
    }

    public final void page(int delta) {
        int numCities = this.viewableCities.size();
        if (numCities == 0) {
            return;
        }
        int indexOfCity = this.viewableCities.indexOf(this.city);
        int indexOfNextCity = (indexOfCity + delta + numCities) % numCities;
        CityScreen newCityScreen = new CityScreen(this.viewableCities.get(indexOfNextCity), null, null, this.passOnCityAmbiencePlayer(), 6, null);
        newCityScreen.mapScrollPane.zoom(this.mapScrollPane.getScaleX());
        newCityScreen.update$core();
        this.getGame().replaceCurrentScreen(newCityScreen);
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return new CityScreen(this.city, this.selectedConstruction, this.selectedTile, null, 8, null);
    }

    @Override
    public void dispose() {
        CityAmbiencePlayer cityAmbiencePlayer = this.cityAmbiencePlayer;
        if (cityAmbiencePlayer != null) {
            cityAmbiencePlayer.dispose();
        }
        ParticleEffectMapFireworks particleEffectMapFireworks = this.fireworks;
        if (particleEffectMapFireworks != null) {
            particleEffectMapFireworks.dispose();
        }
        super.dispose();
    }

    @Override
    public void render(float delta) {
        block1: {
            super.render(delta);
            if (this.pauseFireworks) {
                return;
            }
            ParticleEffectMapFireworks particleEffectMapFireworks = this.fireworks;
            if (particleEffectMapFireworks == null) break block1;
            particleEffectMapFireworks.render(this.getStage(), delta);
        }
    }

    private static final Unit exitCityButton$lambda$0$0(CityScreen this$0) {
        this$0.exit();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(CityScreen this$0) {
        this$0.page(-1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(CityScreen this$0) {
        this$0.page(1);
        return Unit.INSTANCE;
    }

    private static final boolean updateTileGroups$isExistingImprovementValuable(CityScreen this$0, LocalUniqueCache cityUniqueCache, Tile tile) {
        if (tile.getImprovement() == null) {
            return false;
        }
        Civilization civInfo = this$0.city.getCiv();
        TileStatFunctions tileStatFunctions = tile.getStats();
        TileImprovement tileImprovement = tile.getTileImprovement();
        Intrinsics.checkNotNull(tileImprovement);
        Stats statDiffForNewImprovement = TileStatFunctions.getStatDiffForImprovement$default(tileStatFunctions, tileImprovement, civInfo, this$0.city, cityUniqueCache, null, 16, null);
        return Automation.INSTANCE.rankStatsValue(statDiffForNewImprovement, civInfo) <= 0.0f;
    }

    private static final Pair<Color, Float> updateTileGroups$getPickImprovementColor(CityScreen this$0, LocalUniqueCache cityUniqueCache, Tile tile) {
        PickTileForImprovementData pickTileForImprovementData = this$0.pickTileData;
        Intrinsics.checkNotNull(pickTileForImprovementData);
        TileImprovement improvementToPlace = pickTileForImprovementData.getImprovement();
        return tile.isMarkedForCreatesOneImprovement() ? TuplesKt.to(Color.BROWN, Float.valueOf(0.7f)) : (!tile.getImprovementFunctions().canBuildImprovement(improvementToPlace, this$0.city.getState()) ? TuplesKt.to(Color.RED, Float.valueOf(0.4f)) : (CityScreen.updateTileGroups$isExistingImprovementValuable(this$0, cityUniqueCache, tile) ? TuplesKt.to(Color.ORANGE, Float.valueOf(0.5f)) : (tile.getImprovement() != null ? TuplesKt.to(Color.YELLOW, Float.valueOf(0.6f)) : (tile.getTurnsToImprovement() > 0 ? TuplesKt.to(Color.YELLOW, Float.valueOf(0.6f)) : TuplesKt.to(Color.GREEN, Float.valueOf(0.5f))))));
    }

    private static final Cell<Image> updateAnnexAndRazeCityButton$addWltkIcon(CityScreen this$0, String name, Function1<? super Image, Unit> apply) {
        Table table2 = this$0.razeCityButtonHolder;
        Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, name, null, 2, null);
        apply.invoke(image);
        return table2.add((Actor)image).size(40.0f);
    }

    static /* synthetic */ Cell updateAnnexAndRazeCityButton$addWltkIcon$default(CityScreen cityScreen, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = CityScreen::updateAnnexAndRazeCityButton$addWltkIcon$lambda$0;
        }
        return CityScreen.updateAnnexAndRazeCityButton$addWltkIcon(cityScreen, string, function1);
    }

    private static final Unit updateAnnexAndRazeCityButton$addWltkIcon$lambda$0(Image image) {
        Intrinsics.checkNotNullParameter(image, "<this>");
        return Unit.INSTANCE;
    }

    private static final Unit updateAnnexAndRazeCityButton$lambda$1(Image $this$addWltkIcon) {
        Intrinsics.checkNotNullParameter($this$addWltkIcon, "$this$addWltkIcon");
        $this$addWltkIcon.setColor(Color.GOLD);
        return Unit.INSTANCE;
    }

    private static final Unit updateAnnexAndRazeCityButton$lambda$2(Image $this$addWltkIcon) {
        Intrinsics.checkNotNullParameter($this$addWltkIcon, "$this$addWltkIcon");
        $this$addWltkIcon.setColor(Color.FIREBRICK);
        return Unit.INSTANCE;
    }

    private static final Unit updateAnnexAndRazeCityButton$lambda$3(CityScreen this$0) {
        this$0.city.annexCity();
        this$0.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit updateAnnexAndRazeCityButton$lambda$4(CityScreen this$0) {
        this$0.city.setBeingRazed(true);
        this$0.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit updateAnnexAndRazeCityButton$lambda$5(CityScreen this$0) {
        this$0.city.setBeingRazed(false);
        this$0.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit updateAnnexAndRazeCityButton$lambda$6(Image $this$addWltkIcon) {
        Intrinsics.checkNotNullParameter($this$addWltkIcon, "$this$addWltkIcon");
        $this$addWltkIcon.setColor(Color.FIREBRICK);
        return Unit.INSTANCE;
    }

    private static final Unit updateAnnexAndRazeCityButton$lambda$7(Image $this$addWltkIcon) {
        Intrinsics.checkNotNullParameter($this$addWltkIcon, "$this$addWltkIcon");
        $this$addWltkIcon.setColor(Color.GOLD);
        $this$addWltkIcon.setScaleX(-$this$addWltkIcon.getScaleX());
        $this$addWltkIcon.setOriginX(20.0f);
        return Unit.INSTANCE;
    }

    private static final boolean addTiles$lambda$0(CityScreen this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.selectedCiv.hasExplored(it);
    }

    private static final CityTileGroup addTiles$lambda$1(CityScreen this$0, TileSetStrings $tileSetStrings, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new CityTileGroup(this$0.city, it, $tileSetStrings, false);
    }

    private static final Unit addTiles$lambda$2(CityScreen this$0, CityTileGroup $tileGroup) {
        this$0.tileGroupOnClick($tileGroup, this$0.city);
        return Unit.INSTANCE;
    }

    private static final Unit addTiles$lambda$3(CityScreen this$0, CityTileGroup $tileGroup) {
        this$0.tileWorkedIconOnClick($tileGroup, this$0.city);
        return Unit.INSTANCE;
    }

    private static final Unit addTiles$lambda$4(CityScreen this$0, CityTileGroup $tileGroup) {
        this$0.tileWorkedIconDoubleClick($tileGroup, this$0.city);
        return Unit.INSTANCE;
    }

    private static final Unit askToBuyTile$lambda$0(CityScreen this$0) {
        this$0.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit askToBuyTile$lambda$1(CityScreen this$0, Tile $selectedTile) {
        SoundPlayer.INSTANCE.play(UncivSound.Companion.getCoin());
        this$0.city.getExpansion().buyTile($selectedTile);
        UncivGame.Companion.getCurrent().replaceCurrentScreen(new CityScreen(this$0.city, null, this$0.city.getExpansion().chooseNewTileToOwn(), null, 10, null));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityScreen$Companion;", "", "<init>", "()V", "posFromEdge", "", "wltkIconSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityScreen$PickTileForImprovementData;", "", "building", "Lcom/unciv/models/ruleset/Building;", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "isBuying", "", "buyStat", "Lcom/unciv/models/stats/Stat;", "<init>", "(Lcom/unciv/models/ruleset/Building;Lcom/unciv/models/ruleset/tile/TileImprovement;ZLcom/unciv/models/stats/Stat;)V", "getBuilding", "()Lcom/unciv/models/ruleset/Building;", "getImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "()Z", "getBuyStat", "()Lcom/unciv/models/stats/Stat;", "core"})
    public static final class PickTileForImprovementData {
        @NotNull
        private final Building building;
        @NotNull
        private final TileImprovement improvement;
        private final boolean isBuying;
        @NotNull
        private final Stat buyStat;

        public PickTileForImprovementData(@NotNull Building building, @NotNull TileImprovement improvement, boolean isBuying, @NotNull Stat buyStat) {
            Intrinsics.checkNotNullParameter(building, "building");
            Intrinsics.checkNotNullParameter(improvement, "improvement");
            Intrinsics.checkNotNullParameter(buyStat, "buyStat");
            this.building = building;
            this.improvement = improvement;
            this.isBuying = isBuying;
            this.buyStat = buyStat;
        }

        @NotNull
        public final Building getBuilding() {
            return this.building;
        }

        @NotNull
        public final TileImprovement getImprovement() {
            return this.improvement;
        }

        public final boolean isBuying() {
            return this.isBuying;
        }

        @NotNull
        public final Stat getBuyStat() {
            return this.buyStat;
        }
    }
}

