/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.ImprovementBuildingProblem;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.SmallButtonStyle;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActivationTypes;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.pickerscreens.PickerPane;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\u00020\u0001:\u0002/0B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u001c\u0010\u001a\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\fJ$\u0010\u001c\u001a\u00020\b*\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J$\u0010+\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "onAccept", "Lkotlin/Function0;", "", "<init>", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/mapunit/MapUnit;Lkotlin/jvm/functions/Function0;)V", "selectedImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "currentPlayerCiv", "Lcom/unciv/logic/civilization/Civilization;", "tileMarkedForCreatesOneImprovement", "", "tileWithoutLastTerrain", "maxErasForward", "", "getRequiredTechColumn", "improvement", "accept", "secondImprovement", "addImprovementRow", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "problemReport", "Lcom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen$ProblemReport;", "cityUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "setDescription", "color", "Lcom/badlogic/gdx/graphics/Color;", "getStatIconsTable", "provideResource", "removeImprovement", "getStatsTable", "stats", "Lcom/unciv/models/stats/Stats;", "getProblemReport", "getExplanationActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "report", "Companion", "ProblemReport", "core"})
@SourceDebugExtension(value={"SMAP\nImprovementPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImprovementPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,350:1\n1#2:351\n1255#3,2:352\n1255#3,2:354\n*S KotlinDebug\n*F\n+ 1 ImprovementPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen\n*L\n180#1:352,2\n183#1:354,2\n*E\n"})
public final class ImprovementPickerScreen
extends PickerScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tile tile;
    @NotNull
    private final MapUnit unit;
    @NotNull
    private final Function0<Unit> onAccept;
    @Nullable
    private TileImprovement selectedImprovement;
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final Civilization currentPlayerCiv;
    private final boolean tileMarkedForCreatesOneImprovement;
    @NotNull
    private final Tile tileWithoutLastTerrain;
    private final int maxErasForward;

    /*
     * WARNING - void declaration
     */
    public ImprovementPickerScreen(@NotNull Tile tile, @NotNull MapUnit unit, @NotNull Function0<Unit> onAccept) {
        Object object;
        void it22;
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(onAccept, "onAccept");
        super(false, 1, null);
        this.tile = tile;
        this.unit = unit;
        this.onAccept = onAccept;
        this.gameInfo = this.tile.getTileMap().getGameInfo();
        this.ruleset = this.gameInfo.getRuleset();
        this.currentPlayerCiv = this.gameInfo.getCurrentPlayerCivilization();
        this.tileMarkedForCreatesOneImprovement = this.tile.isMarkedForCreatesOneImprovement();
        Integer n = this.ruleset.getModOptions().getConstants().getMaxImprovementTechErasForward();
        int n2 = ((Number)n).intValue();
        ImprovementPickerScreen improvementPickerScreen = this;
        boolean bl = false;
        boolean bl2 = it22 < 0;
        Integer n3 = !bl2 ? n : null;
        improvementPickerScreen.maxErasForward = n3 != null ? n3 : Integer.MAX_VALUE;
        this.setDefaultCloseAction();
        this.getRightSideButton().setText(TranslationsKt.tr$default("Pick improvement", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), () -> ImprovementPickerScreen._init_$lambda$0(this));
        ActivationExtensionsKt.onClick(this.getDescriptionLabel(), () -> ImprovementPickerScreen._init_$lambda$1(this));
        Table regularImprovements = new Table();
        regularImprovements.defaults().pad(5.0f);
        this.tileWithoutLastTerrain = this.tile.clone(false);
        this.tileWithoutLastTerrain.setTerrainTransients();
        if (((Map)this.ruleset.getTileImprovements()).containsKey("Remove " + this.tileWithoutLastTerrain.getLastTerrain().getName())) {
            this.tileWithoutLastTerrain.removeTerrainFeature(this.tileWithoutLastTerrain.getLastTerrain().getName());
        }
        LocalUniqueCache cityUniqueCache = new LocalUniqueCache(false, 1, null);
        Iterator<TileImprovement> it22 = this.ruleset.getTileImprovements().values().iterator();
        while (it22.hasNext()) {
            ProblemReport problemReport;
            TileImprovement improvement;
            Intrinsics.checkNotNullExpressionValue(it22.next(), "next(...)");
            if (improvement.getTurnsToBuild() == -1 && !Intrinsics.areEqual(improvement.getName(), "Cancel improvement order") || Intrinsics.areEqual(improvement.getName(), this.tile.getImprovement()) || !MapUnit.canBuildImprovement$default(this.unit, improvement, null, 2, null) || this.getProblemReport(improvement) == null) continue;
            this.addImprovementRow(regularImprovements, improvement, problemReport, cityUniqueCache);
        }
        Table ownerTable = new Table();
        if (this.tile.getOwner() == null) {
            object = ownerTable.add((Actor)Scene2dExtensionsKt.toLabel("Unowned tile")).pad(10.0f);
        } else {
            Civilization civilization = this.tile.getOwner();
            Intrinsics.checkNotNull(civilization);
            if (civilization.isCurrentPlayer()) {
                City city = this.tile.getCity();
                Intrinsics.checkNotNull(city);
                TextButton button = Scene2dExtensionsKt.toTextButton$default(city.getName(), null, true, 1, null);
                ActivationExtensionsKt.onClick(button, () -> ImprovementPickerScreen._init_$lambda$2(this));
                StringBuilder stringBuilder = new StringBuilder().append("Tile owned by [");
                Civilization civilization2 = this.tile.getOwner();
                Intrinsics.checkNotNull(civilization2);
                Label label = Scene2dExtensionsKt.toLabel(stringBuilder.append(civilization2.getCivName()).append("] (You)").toString());
                ActivationExtensionsKt.onClick(label, () -> ImprovementPickerScreen._init_$lambda$3(this));
                ownerTable.add((Actor)label);
                ownerTable.add((Actor)button).padLeft(20.0f);
                object = ownerTable.padTop(2.5f);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Tile owned by [");
                Civilization civilization3 = this.tile.getOwner();
                Intrinsics.checkNotNull(civilization3);
                StringBuilder stringBuilder2 = stringBuilder.append(civilization3.getCivName()).append("] - [");
                City city = this.tile.getCity();
                Intrinsics.checkNotNull(city);
                Label label = Scene2dExtensionsKt.toLabel(stringBuilder2.append(city.getName()).append(']').toString());
                ActivationExtensionsKt.onClick(label, () -> ImprovementPickerScreen._init_$lambda$4(this));
                object = ownerTable.add((Actor)label).pad(10.0f);
            }
        }
        this.getTopTable().add((Actor)ownerTable);
        this.getTopTable().row();
        this.getTopTable().add((Actor)regularImprovements);
    }

    private final int getRequiredTechColumn(TileImprovement improvement) {
        Object object = (Technology)((Map)this.ruleset.getTechnologies()).get(improvement.getTechRequired());
        return object != null && (object = ((Technology)object).getColumn()) != null ? ((TechColumn)object).getColumnNumber() : -1;
    }

    public final void accept(@Nullable TileImprovement improvement, @Nullable TileImprovement secondImprovement) {
        if (improvement == null || this.tileMarkedForCreatesOneImprovement) {
            return;
        }
        if (Intrinsics.areEqual(improvement.getName(), "Cancel improvement order")) {
            this.tile.stopWorkingOnImprovement();
        } else {
            if (!Intrinsics.areEqual(improvement.getName(), this.tile.getImprovementInProgress())) {
                this.tile.startWorkingOnImprovement(improvement, this.currentPlayerCiv, this.unit);
                if (secondImprovement != null) {
                    this.tile.queueImprovement(secondImprovement, this.currentPlayerCiv, this.unit);
                }
            }
            this.unit.setAction(null);
            this.onAccept.invoke();
        }
        this.getGame().popScreen();
    }

    public static /* synthetic */ void accept$default(ImprovementPickerScreen improvementPickerScreen, TileImprovement tileImprovement, TileImprovement tileImprovement2, int n, Object object) {
        if ((n & 2) != 0) {
            tileImprovement2 = null;
        }
        improvementPickerScreen.accept(tileImprovement, tileImprovement2);
    }

    /*
     * Unable to fully structure code
     */
    private final void addImprovementRow(Table $this$addImprovementRow, TileImprovement improvement, ProblemReport problemReport, LocalUniqueCache cityUniqueCache) {
        block18: {
            block17: {
                block16: {
                    image = ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, improvement.getName(), 30.0f, false, 4, null);
                    shortcutKey = improvement.getShortcutKey();
                    if (shortcutKey != null) {
                        techLevel = this.getRequiredTechColumn(improvement);
                        v0 = this.ruleset.getTileImprovements().values();
                        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                        isSuperseded = SequencesKt.any(SequencesKt.filter(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)v0), (Function1<TileImprovement, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, addImprovementRow$lambda$0(com.unciv.models.ruleset.tile.TileImprovement com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Ljava/lang/Boolean;)((TileImprovement)improvement)), (Function1<TileImprovement, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, addImprovementRow$lambda$1(com.unciv.ui.screens.pickerscreens.ImprovementPickerScreen com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Ljava/lang/Boolean;)((ImprovementPickerScreen)this)), (Function1<TileImprovement, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, addImprovementRow$lambda$2(com.unciv.ui.screens.pickerscreens.ImprovementPickerScreen int com.unciv.models.ruleset.tile.TileImprovement ), (Lcom/unciv/models/ruleset/tile/TileImprovement;)Ljava/lang/Boolean;)((ImprovementPickerScreen)this, (int)techLevel)));
                        if (isSuperseded) {
                            shortcutKey = null;
                        }
                    }
                    labelText = TranslationsKt.tr$default(improvement.getName(), true, false, 2, null);
                    v1 = turnsToBuild = Intrinsics.areEqual(this.tile.getImprovementInProgress(), improvement.getName()) != false ? this.tile.getTurnsToImprovement() : improvement.getTurnsToBuild(this.currentPlayerCiv, this.unit);
                    if (turnsToBuild > 0) {
                        labelText = labelText + " - " + turnsToBuild + '\u23f3';
                    }
                    v2 = provideResource = this.tile.hasViewableResource(this.currentPlayerCiv) != false && this.tile.getTileResource().isImprovedBy(improvement.getName()) != false;
                    if (provideResource) {
                        labelText = labelText + '\n' + TranslationsKt.tr$default("Provides [" + this.tile.getResource() + ']', false, false, 3, null);
                    }
                    v3 = removeImprovement = improvement.isRoad() == false && StringsKt.startsWith$default(improvement.getName(), "Remove ", false, 2, null) == false && Intrinsics.areEqual(improvement.getName(), "Cancel improvement order") == false;
                    if (this.tile.getImprovement() != null && removeImprovement) {
                        labelText = labelText + '\n' + TranslationsKt.tr$default("Replaces [" + this.tile.getImprovement() + ']', false, false, 3, null);
                    }
                    statIcons = this.getStatIconsTable(provideResource, removeImprovement);
                    stats = TileStatFunctions.getStatDiffForImprovement$default(this.tile.getStats(), improvement, this.currentPlayerCiv, this.tile.getCity(), cityUniqueCache, null, 16, null);
                    if (this.tile.getOwningCity() == null || improvement.isRoad()) break block18;
                    $this$any$iv = stats.getValues();
                    $i$f$any = false;
                    var15_17 = $this$any$iv.iterator();
                    while (var15_17.hasNext()) {
                        element$iv = var15_17.next();
                        it = ((Number)element$iv).floatValue();
                        $i$a$-any-ImprovementPickerScreen$addImprovementRow$1 = false;
                        if (!(it > 0.0f)) continue;
                        v4 = true;
                        break block16;
                    }
                    v4 = false;
                }
                if (!v4 || StringsKt.startsWith$default(improvement.getName(), "Remove ", false, 2, null)) break block18;
                $this$any$iv = this.tile.getTilesInDistance(this.currentPlayerCiv.getModConstants().getCityWorkRange());
                $i$f$any = false;
                var15_17 = $this$any$iv.iterator();
                while (var15_17.hasNext()) {
                    element$iv = var15_17.next();
                    it = (Tile)element$iv;
                    $i$a$-any-ImprovementPickerScreen$addImprovementRow$2 = false;
                    if (!it.isCityCenter()) ** GOTO lbl-1000
                    v5 = it.getCity();
                    Intrinsics.checkNotNull(v5);
                    if (Intrinsics.areEqual(v5.getCiv(), this.currentPlayerCiv)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    v7 = true;
                    break block17;
                }
                v7 = false;
            }
            if (!v7) {
                labelText = labelText + '\n' + TranslationsKt.tr$default("Not in city work range", false, false, 3, null);
            }
        }
        statsTable = this.getStatsTable(stats);
        statIcons.add((Actor)statsTable).padLeft(13.0f);
        $this$addImprovementRow.add((Actor)statIcons).align(16);
        improvementButton = PickerPane.Companion.getPickerOptionButton(image, labelText);
        ActivationExtensionsKt.onActivation$default(improvementButton, ActivationTypes.Tap, null, true, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, addImprovementRow$lambda$5(com.unciv.ui.screens.pickerscreens.ImprovementPickerScreen com.unciv.models.ruleset.tile.TileImprovement ), ()Lkotlin/Unit;)((ImprovementPickerScreen)this, (TileImprovement)improvement), 2, null);
        if (Intrinsics.areEqual(improvement.getName(), this.tile.getImprovementInProgress())) {
            improvementButton.setColor(Color.GREEN);
        } else if (problemReport.isQueueable()) {
            improvementButton.setColor(0.625f, 1.0f, 0.625f, 1.0f);
        }
        if (!problemReport.isEmpty() || this.tileMarkedForCreatesOneImprovement) {
            Scene2dExtensionsKt.disable(improvementButton);
            improvementButton.setTouchable(Touchable.enabled);
            improvementButton.addListener(new ClickListener(this, improvement){
                final /* synthetic */ ImprovementPickerScreen this$0;
                final /* synthetic */ TileImprovement $improvement;
                {
                    this.this$0 = $receiver;
                    this.$improvement = $improvement;
                }

                public void clicked(InputEvent event, float x, float y) {
                    Color color = Color.LIGHT_GRAY;
                    Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
                    ImprovementPickerScreen.access$setDescription(this.this$0, this.$improvement, color);
                }
            });
        } else {
            ActivationExtensionsKt.onDoubleClick$default(improvementButton, null, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, addImprovementRow$lambda$6(com.unciv.ui.screens.pickerscreens.ImprovementPickerScreen com.unciv.models.ruleset.tile.TileImprovement ), ()Lkotlin/Unit;)((ImprovementPickerScreen)this, (TileImprovement)improvement), 1, null);
            if (shortcutKey != null) {
                ActivationExtensionsKt.getKeyShortcuts(improvementButton).add(shortcutKey, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, addImprovementRow$lambda$7(com.unciv.ui.screens.pickerscreens.ImprovementPickerScreen com.unciv.models.ruleset.tile.TileImprovement ), ()Lkotlin/Unit;)((ImprovementPickerScreen)this, (TileImprovement)improvement));
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)improvementButton, shortcutKey.charValue(), 0.0f, 2, null);
            }
        }
        $this$addImprovementRow.add((Actor)improvementButton);
        $this$addImprovementRow.add(this.getExplanationActor(improvement, problemReport)).padLeft(10.0f);
        $this$addImprovementRow.row();
    }

    private final void setDescription(TileImprovement improvement, Color color) {
        this.selectedImprovement = improvement;
        this.getDescriptionLabel().setText(improvement.getDescription(this.ruleset));
        this.getDescriptionLabel().setColor(color);
    }

    private final Table getStatIconsTable(boolean provideResource, boolean removeImprovement) {
        Group resourceIcon;
        Table statIcons = new Table();
        if (provideResource) {
            String string = this.tile.getResource();
            Intrinsics.checkNotNull(string);
            resourceIcon = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, string, 30.0f, 0, 4, null);
            TileResource tileResource = (TileResource)((Map)this.ruleset.getTileResources()).get(this.tile.getResource());
            String link = tileResource != null ? tileResource.makeLink() : null;
            CharSequence charSequence = link;
            if (!(charSequence == null || charSequence.length() == 0)) {
                ActivationExtensionsKt.onClick(resourceIcon, () -> ImprovementPickerScreen.getStatIconsTable$lambda$0(this, link));
            }
            statIcons.add((Actor)resourceIcon).pad(3.0f);
        }
        if (removeImprovement && this.tile.hasViewableResource(this.currentPlayerCiv) && this.tile.getImprovement() != null) {
            TileResource tileResource = this.tile.getTileResource();
            String string = this.tile.getImprovement();
            Intrinsics.checkNotNull(string);
            if (tileResource.isImprovedBy(string)) {
                String string2 = this.tile.getResource();
                Intrinsics.checkNotNull(string2);
                resourceIcon = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, string2, 30.0f, 0, 4, null);
                statIcons.add((Actor)ImageGetter.INSTANCE.getCrossedImage(resourceIcon, 30.0f));
            }
        }
        return statIcons;
    }

    private final Table getStatsTable(Stats stats) {
        Table statsTable = new Table();
        for (Stats.StatValuePair statValuePair : stats) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            int statValue = MathKt.roundToInt(value);
            if (statValue == 0) continue;
            statsTable.add((Actor)ImageGetter.getStatIcon$default(ImageGetter.INSTANCE, key.name(), 0.0f, 2, null)).size(20.0f).padRight(3.0f);
            Label valueLabel = Scene2dExtensionsKt.toLabel(statValue);
            valueLabel.setColor(statValue < 0 ? Color.RED : Color.WHITE);
            statsTable.add((Actor)valueLabel).padRight(13.0f);
        }
        return statsTable;
    }

    private final ProblemReport getProblemReport(TileImprovement improvement) {
        return this.getProblemReport(this.tile, this.tileWithoutLastTerrain, improvement);
    }

    private final ProblemReport getProblemReport(Tile tile, Tile tileWithoutLastTerrain, TileImprovement improvement) {
        ProblemReport report = new ProblemReport();
        Set<ImprovementBuildingProblem> unbuildableBecause = null;
        unbuildableBecause = SequencesKt.toSet(tile.getImprovementFunctions().getImprovementBuildingProblems(improvement, this.unit.getCache().getState()));
        if (!Companion.canReport((Collection<? extends ImprovementBuildingProblem>)unbuildableBecause) && tileWithoutLastTerrain != null) {
            unbuildableBecause = SequencesKt.toSet(tileWithoutLastTerrain.getImprovementFunctions().getImprovementBuildingProblems(improvement, this.unit.getCache().getState()));
            if (!Companion.canReport((Collection<? extends ImprovementBuildingProblem>)unbuildableBecause)) {
                return null;
            }
            report.setSuggestRemoval(true);
        }
        ProblemReport $this$getProblemReport_u24lambda_u240 = report;
        boolean bl = false;
        if ($this$getProblemReport_u24lambda_u240.getSuggestRemoval()) {
            String removalName = "Remove " + tile.getLastTerrain().getName();
            $this$getProblemReport_u24lambda_u240.setRemovalImprovement(this.ruleset.getTileImprovements().get(removalName));
            if ($this$getProblemReport_u24lambda_u240.getRemovalImprovement() != null) {
                Tile tile2 = tileWithoutLastTerrain;
                Intrinsics.checkNotNull(tile2);
                TileImprovement tileImprovement = $this$getProblemReport_u24lambda_u240.getRemovalImprovement();
                Intrinsics.checkNotNull(tileImprovement);
                ProblemReport problemReport = this.getProblemReport(tile2, null, tileImprovement);
                if (problemReport == null) {
                    return null;
                }
                ProblemReport cannotRemoveReport = problemReport;
                $this$getProblemReport_u24lambda_u240.getProposedSolutions().addAll((Collection<Pair<String, String>>)cannotRemoveReport.getProposedSolutions());
                Set<Pair<String, String>> set = $this$getProblemReport_u24lambda_u240.getProposedSolutions();
                String string = "Remove [" + tile.getLastTerrain().getName() + "] first";
                TileImprovement tileImprovement2 = $this$getProblemReport_u24lambda_u240.getRemovalImprovement();
                Intrinsics.checkNotNull(tileImprovement2);
                set.add(TuplesKt.to(string, tileImprovement2.makeLink()));
            }
        }
        if (unbuildableBecause.contains((Object)ImprovementBuildingProblem.MissingTech)) {
            int maxEraNumber = this.currentPlayerCiv.getEraNumber() + this.maxErasForward;
            Iterator<Technology> iterator2 = improvement.requiredTechnologies(this.ruleset).iterator();
            while (iterator2.hasNext()) {
                Technology tech = iterator2.next();
                RulesetObject rulesetObject = tech;
                if (rulesetObject == null || (rulesetObject = ((Technology)rulesetObject).era(this.ruleset)) == null) continue;
                RulesetObject techEra = rulesetObject;
                if (((Era)techEra).getEraNumber() > maxEraNumber) {
                    return null;
                }
                $this$getProblemReport_u24lambda_u240.getProposedSolutions().add(TuplesKt.to("Research [" + tech.getName() + "] first", tech.makeLink()));
            }
        }
        if (unbuildableBecause.contains((Object)ImprovementBuildingProblem.NotJustOutsideBorders)) {
            $this$getProblemReport_u24lambda_u240.getProposedSolutions().add(TuplesKt.to("Have this tile close to your borders", null));
        }
        if (unbuildableBecause.contains((Object)ImprovementBuildingProblem.OutsideBorders)) {
            $this$getProblemReport_u24lambda_u240.getProposedSolutions().add(TuplesKt.to("Have this tile inside your empire", null));
        }
        if (unbuildableBecause.contains((Object)ImprovementBuildingProblem.MissingResources)) {
            Sequence<Pair> resources = SequencesKt.map(SequencesKt.filter(IHasUniques.getMatchingUniques$default(improvement, UniqueType.ConsumesResources, null, 2, null), arg_0 -> ImprovementPickerScreen.getProblemReport$lambda$0$0(this, arg_0)), arg_0 -> ImprovementPickerScreen.getProblemReport$lambda$0$1(this, arg_0));
            CollectionsKt.addAll((Collection)$this$getProblemReport_u24lambda_u240.getProposedSolutions(), resources);
        }
        return report;
    }

    private final Actor getExplanationActor(TileImprovement improvement, ProblemReport report) {
        Table table2;
        if (report.isEmpty()) {
            return Intrinsics.areEqual(this.tile.getImprovementInProgress(), improvement.getName()) ? (Actor)Scene2dExtensionsKt.toLabel("Current construction") : (this.tileMarkedForCreatesOneImprovement ? null : ImprovementPickerScreen.getExplanationActor$getPickNowButton(() -> ImprovementPickerScreen.getExplanationActor$lambda$0(this, improvement)));
        }
        Table $this$getExplanationActor_u24lambda_u241 = table2 = new Table();
        boolean bl = false;
        $this$getExplanationActor_u24lambda_u241.defaults().center();
        for (Pair<String, String> pair : report.getProposedSolutions()) {
            String text2 = pair.component1();
            String link = pair.component2();
            Label label = Scene2dExtensionsKt.toLabel(text2);
            CharSequence charSequence = link;
            if (!(charSequence == null || charSequence.length() == 0)) {
                ActivationExtensionsKt.onClick(label, () -> ImprovementPickerScreen.getExplanationActor$lambda$1$0(this, link));
            }
            $this$getExplanationActor_u24lambda_u241.add((Actor)label).padBottom(5.0f).row();
        }
        if (report.isQueueable()) {
            $this$getExplanationActor_u24lambda_u241.add(ImprovementPickerScreen.getExplanationActor$getPickNowButton(() -> ImprovementPickerScreen.getExplanationActor$lambda$1$1(this, report, improvement))).padTop(5.0f);
        }
        return table2;
    }

    private static final Unit _init_$lambda$0(ImprovementPickerScreen this$0) {
        ImprovementPickerScreen.accept$default(this$0, this$0.selectedImprovement, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ImprovementPickerScreen this$0) {
        TileImprovement tileImprovement = this$0.selectedImprovement;
        String link = tileImprovement != null ? tileImprovement.makeLink() : null;
        CharSequence charSequence = link;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this$0.openCivilopedia(link);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ImprovementPickerScreen this$0) {
        UncivGame uncivGame = this$0.getGame();
        City city = this$0.tile.getCity();
        Intrinsics.checkNotNull(city);
        uncivGame.pushScreen(new CityScreen(city, null, this$0.tile, null, 8, null));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ImprovementPickerScreen this$0) {
        Civilization civilization = this$0.tile.getOwner();
        Intrinsics.checkNotNull(civilization);
        this$0.openCivilopedia(civilization.getNation().makeLink());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(ImprovementPickerScreen this$0) {
        Civilization civilization = this$0.tile.getOwner();
        Intrinsics.checkNotNull(civilization);
        this$0.openCivilopedia(civilization.getNation().makeLink());
        return Unit.INSTANCE;
    }

    private static final boolean addImprovementRow$lambda$0(TileImprovement $improvement, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getShortcutKey(), $improvement.getShortcutKey()) && !Intrinsics.areEqual(it, $improvement);
    }

    private static final boolean addImprovementRow$lambda$1(ImprovementPickerScreen this$0, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.tile.getImprovementFunctions().canBuildImprovement(it, this$0.unit.getCache().getState());
    }

    private static final boolean addImprovementRow$lambda$2(ImprovementPickerScreen this$0, int $techLevel, TileImprovement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getRequiredTechColumn(it) > $techLevel;
    }

    private static final Unit addImprovementRow$lambda$5(ImprovementPickerScreen this$0, TileImprovement $improvement) {
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this$0.setDescription($improvement, color);
        this$0.pick(TranslationsKt.tr$default($improvement.getName(), false, false, 3, null));
        return Unit.INSTANCE;
    }

    private static final Unit addImprovementRow$lambda$6(ImprovementPickerScreen this$0, TileImprovement $improvement) {
        ImprovementPickerScreen.accept$default(this$0, $improvement, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addImprovementRow$lambda$7(ImprovementPickerScreen this$0, TileImprovement $improvement) {
        ImprovementPickerScreen.accept$default(this$0, $improvement, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit getStatIconsTable$lambda$0(ImprovementPickerScreen this$0, String $link) {
        this$0.openCivilopedia($link);
        return Unit.INSTANCE;
    }

    private static final boolean getProblemReport$lambda$0$0(ImprovementPickerScreen this$0, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.currentPlayerCiv.getResourceAmount(it.getParams().get(1)) < Integer.parseInt(it.getParams().get(0));
    }

    private static final Pair getProblemReport$lambda$0$1(ImprovementPickerScreen this$0, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TileResource tileResource = this$0.ruleset.getTileResources().get(it.getParams().get(1));
        return TuplesKt.to("Acquire more [" + it.getParams().get(1) + ']', tileResource != null ? tileResource.makeLink() : null);
    }

    private static final Actor getExplanationActor$getPickNowButton(Function0<Unit> action2) {
        return ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Pick now!", new SmallButtonStyle(), false, 2, null), action2);
    }

    private static final Unit getExplanationActor$lambda$0(ImprovementPickerScreen this$0, TileImprovement $improvement) {
        ImprovementPickerScreen.accept$default(this$0, $improvement, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit getExplanationActor$lambda$1$0(ImprovementPickerScreen this$0, String $link) {
        this$0.openCivilopedia($link);
        return Unit.INSTANCE;
    }

    private static final Unit getExplanationActor$lambda$1$1(ImprovementPickerScreen this$0, ProblemReport $report, TileImprovement $improvement) {
        this$0.accept($report.getRemovalImprovement(), $improvement);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setDescription(ImprovementPickerScreen $this, TileImprovement improvement, Color color) {
        $this.setDescription(improvement, color);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen$Companion;", "", "<init>", "()V", "canReport", "", "problems", "", "Lcom/unciv/logic/map/tile/ImprovementBuildingProblem;", "core"})
    @SourceDebugExtension(value={"SMAP\nImprovementPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImprovementPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,350:1\n1740#2,3:351\n*S KotlinDebug\n*F\n+ 1 ImprovementPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen$Companion\n*L\n42#1:351,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canReport(@NotNull Collection<? extends ImprovementBuildingProblem> problems) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(problems, "problems");
                Iterable $this$all$iv = problems;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ImprovementBuildingProblem it = (ImprovementBuildingProblem)((Object)element$iv);
                        boolean bl2 = false;
                        if (it.getReportable()) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR%\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/screens/pickerscreens/ImprovementPickerScreen$ProblemReport;", "", "<init>", "()V", "suggestRemoval", "", "getSuggestRemoval", "()Z", "setSuggestRemoval", "(Z)V", "removalImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "getRemovalImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "setRemovalImprovement", "(Lcom/unciv/models/ruleset/tile/TileImprovement;)V", "proposedSolutions", "", "Lkotlin/Pair;", "", "getProposedSolutions", "()Ljava/util/Set;", "isEmpty", "isQueueable", "core"})
    private static final class ProblemReport {
        private boolean suggestRemoval;
        @Nullable
        private TileImprovement removalImprovement;
        @NotNull
        private final Set<Pair<String, String>> proposedSolutions = new LinkedHashSet();

        public final boolean getSuggestRemoval() {
            return this.suggestRemoval;
        }

        public final void setSuggestRemoval(boolean bl) {
            this.suggestRemoval = bl;
        }

        @Nullable
        public final TileImprovement getRemovalImprovement() {
            return this.removalImprovement;
        }

        public final void setRemovalImprovement(@Nullable TileImprovement tileImprovement) {
            this.removalImprovement = tileImprovement;
        }

        @NotNull
        public final Set<Pair<String, String>> getProposedSolutions() {
            return this.proposedSolutions;
        }

        public final boolean isEmpty() {
            return this.proposedSolutions.isEmpty();
        }

        public final boolean isQueueable() {
            return this.removalImprovement != null && this.proposedSolutions.size() == 1;
        }
    }
}

