/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.GlobalUniques;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.Conditionals;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.UniqueFlag;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001LB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0007J\b\u0010/\u001a\u00020%H\u0007J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u00100\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u00101\u001a\u00020%H\u0007J\b\u00102\u001a\u00020%H\u0007J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0007J\b\u00107\u001a\u00020%H\u0007J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020:H\u0007J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020:H\u0003J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00000?2\u0006\u0010=\u001a\u00020:H\u0007J\n\u0010@\u001a\u0004\u0018\u00010AH\u0007J\b\u0010B\u001a\u00020\u0003H\u0007J&\u0010C\u001a\u00020<2\u0006\u0010D\u001a\u00020\u00032\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010F\u001a\u00020<H\u0003J\u0010\u0010G\u001a\u00020\u00032\u0006\u0010H\u001a\u00020IH\u0007J\b\u0010J\u001a\u00020\u0003H\u0016J\b\u0010K\u001a\u00020\u0003H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R#\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00110!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010&R\u0011\u0010'\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0013R\u0011\u0010*\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010&R\u0011\u0010+\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010&\u00a8\u0006M"}, d2={"Lcom/unciv/models/ruleset/unique/Unique;", "", "text", "", "sourceObjectType", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "sourceObjectName", "<init>", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/UniqueTarget;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getSourceObjectType", "()Lcom/unciv/models/ruleset/unique/UniqueTarget;", "getSourceObjectName", "placeholderText", "getPlaceholderText", "params", "", "getParams", "()Ljava/util/List;", "type", "Lcom/unciv/models/ruleset/unique/UniqueType;", "getType", "()Lcom/unciv/models/ruleset/unique/UniqueType;", "stats", "Lcom/unciv/models/stats/Stats;", "getStats", "()Lcom/unciv/models/stats/Stats;", "stats$delegate", "Lkotlin/Lazy;", "modifiers", "getModifiers", "modifiersMap", "", "getModifiersMap", "()Ljava/util/Map;", "isTimedTriggerable", "", "()Z", "isTriggerable", "allParams", "getAllParams", "isLocalEffect", "isOtherModifierType", "hasFlag", "flag", "Lcom/unciv/models/ruleset/unique/UniqueFlag;", "isHiddenToUsers", "hasModifier", "isModifiedByGameSpeed", "isModifiedByGameProgress", "getGameProgressModifier", "", "civ", "Lcom/unciv/logic/civilization/Civilization;", "hasTriggerConditional", "conditionalsApply", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "getUniqueMultiplier", "", "gameContext", "getMultiplied", "Lkotlin/sequences/Sequence;", "getDeprecationAnnotation", "Lkotlin/Deprecated;", "getSourceNameForUser", "getNthIndex", "string", "list", "n", "getReplacementText", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "toString", "getDisplayText", "EndlessSequenceOf", "core"})
@SourceDebugExtension(value={"SMAP\nUnique.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Unique.kt\ncom/unciv/models/ruleset/unique/Unique\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n827#2:252\n855#2,2:253\n1491#2:255\n1516#2,3:256\n1519#2,3:266\n1374#2:269\n1460#2,5:270\n1761#2,3:275\n1761#2,2:278\n1761#2,3:280\n1763#2:283\n774#2:287\n865#2,2:288\n2746#2,3:291\n774#2:294\n865#2,2:295\n295#2,2:297\n382#3,7:259\n1276#4,3:284\n1#5:290\n*S KotlinDebug\n*F\n+ 1 Unique.kt\ncom/unciv/models/ruleset/unique/Unique\n*L\n32#1:252\n32#1:253,2\n32#1:255\n32#1:256,3\n32#1:266,3\n43#1:269\n43#1:270,5\n46#1:275,3\n74#1:278,2\n75#1:280,3\n74#1:283\n231#1:287\n231#1:288,2\n248#1:291,3\n249#1:294\n249#1:295,2\n27#1:297,2\n32#1:259,7\n122#1:284,3\n*E\n"})
public final class Unique {
    @NotNull
    private final String text;
    @Nullable
    private final UniqueTarget sourceObjectType;
    @Nullable
    private final String sourceObjectName;
    @NotNull
    private final String placeholderText;
    @NotNull
    private final List<String> params;
    @Nullable
    private final UniqueType type;
    @NotNull
    private final Lazy stats$delegate;
    @NotNull
    private final List<Unique> modifiers;
    @NotNull
    private final Map<UniqueType, List<Unique>> modifiersMap;
    private final boolean isTimedTriggerable;
    private final boolean isTriggerable;
    @NotNull
    private final List<String> allParams;
    private final boolean isLocalEffect;
    private final boolean isOtherModifierType;

    /*
     * WARNING - void declaration
     */
    public Unique(@NotNull String text2, @Nullable UniqueTarget sourceObjectType, @Nullable String sourceObjectName) {
        boolean bl;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable list$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        Unique it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(text2, "text");
        this.text = text2;
        this.sourceObjectType = sourceObjectType;
        this.sourceObjectName = sourceObjectName;
        this.placeholderText = TranslationsKt.getPlaceholderText(this.text);
        this.params = TranslationsKt.getPlaceholderParameters(this.text);
        this.type = UniqueType.Companion.getUniqueTypeMap().get(this.placeholderText);
        this.stats$delegate = LazyKt.lazy(() -> Unique.stats_delegate$lambda$0(this));
        this.modifiers = TranslationsKt.getModifiers(this.text);
        Iterable iterable = this.modifiers;
        Unique unique = this;
        boolean $i$f$filterNot = false;
        void var6_7 = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Unique)element$iv$iv;
            boolean bl2 = false;
            if (it.type == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            UniqueType key$iv$iv;
            it = (Unique)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it.type);
            Object object2 = destination$iv$iv;
            UniqueType key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        unique.modifiersMap = destination$iv$iv;
        this.isTimedTriggerable = this.hasModifier(UniqueType.ConditionalTimedUnique);
        this.isTriggerable = this.type != null && (this.type.getTargetTypes().contains((Object)UniqueTarget.Triggerable) || this.type.getTargetTypes().contains((Object)UniqueTarget.UnitTriggerable) || this.isTimedTriggerable);
        $this$groupBy$iv = this.modifiers;
        Collection collection = this.params;
        unique = this;
        boolean $i$f$flatMap = false;
        $this$groupByTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Unique)element$iv$iv;
            boolean bl5 = false;
            list$iv$iv = it.params;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        unique.allParams = CollectionsKt.plus(collection, (Iterable)list2);
        this.isLocalEffect = this.params.contains("in this city") || this.hasModifier(UniqueType.ConditionalInThisCity);
        Unique unique2 = this;
        Object object = this.type;
        if (object != null && (object = object.getTargetTypes()) != null) {
            boolean bl6;
            block10: {
                void $this$any$iv;
                $this$flatMapTo$iv$iv = (Iterable)object;
                unique = unique2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl6 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UniqueTarget it2 = (UniqueTarget)((Object)element$iv);
                        boolean bl7 = false;
                        if (!(it2.getModifierType() == UniqueTarget.ModifierType.Other)) continue;
                        bl6 = true;
                        break block10;
                    }
                    bl6 = false;
                }
            }
            boolean bl8 = bl6;
            unique2 = unique;
            bl = bl8;
        } else {
            bl = false;
        }
        unique2.isOtherModifierType = bl;
    }

    public /* synthetic */ Unique(String string, UniqueTarget uniqueTarget, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uniqueTarget = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, uniqueTarget, string2);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final UniqueTarget getSourceObjectType() {
        return this.sourceObjectType;
    }

    @Nullable
    public final String getSourceObjectName() {
        return this.sourceObjectName;
    }

    @NotNull
    public final String getPlaceholderText() {
        return this.placeholderText;
    }

    @NotNull
    public final List<String> getParams() {
        return this.params;
    }

    @Nullable
    public final UniqueType getType() {
        return this.type;
    }

    @NotNull
    public final Stats getStats() {
        Lazy lazy = this.stats$delegate;
        return (Stats)lazy.getValue();
    }

    @NotNull
    public final List<Unique> getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public final Map<UniqueType, List<Unique>> getModifiersMap() {
        return this.modifiersMap;
    }

    public final boolean isTimedTriggerable() {
        return this.isTimedTriggerable;
    }

    public final boolean isTriggerable() {
        return this.isTriggerable;
    }

    @NotNull
    public final List<String> getAllParams() {
        return this.allParams;
    }

    public final boolean isLocalEffect() {
        return this.isLocalEffect;
    }

    public final boolean isOtherModifierType() {
        return this.isOtherModifierType;
    }

    @Readonly
    public final boolean hasFlag(@NotNull UniqueFlag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        return this.type != null && this.type.getFlags().contains((Object)flag);
    }

    @Readonly
    public final boolean isHiddenToUsers() {
        return this.hasFlag(UniqueFlag.HiddenToUsers) || this.hasModifier(UniqueType.ModifierHiddenFromUsers);
    }

    @Readonly
    @NotNull
    public final List<Unique> getModifiers(@NotNull UniqueType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        List<Unique> list2 = this.modifiersMap.get((Object)type);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Readonly
    public final boolean hasModifier(@NotNull UniqueType type) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        return this.modifiersMap.containsKey((Object)type);
    }

    @Readonly
    public final boolean isModifiedByGameSpeed() {
        return this.hasModifier(UniqueType.ModifiedByGameSpeed);
    }

    @Readonly
    public final boolean isModifiedByGameProgress() {
        return this.hasModifier(UniqueType.ModifiedByGameProgress);
    }

    @Readonly
    public final float getGameProgressModifier(@NotNull Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        float modifier = 1.0f;
        Ruleset ruleset = civ.getGameInfo().getRuleset();
        float techComplete = !((Map)ruleset.getTechnologies()).isEmpty() ? (float)civ.getTech().getResearchedTechnologies().size() / (float)ruleset.getTechnologies().size() : 0.0f;
        float policyComplete = !((Map)ruleset.getPolicies()).isEmpty() ? (float)civ.getPolicies().getAdoptedPolicies$core().size() / (float)ruleset.getPolicies().size() : 0.0f;
        float gameProgess = Math.max(techComplete, policyComplete);
        for (Unique unique : this.getModifiers(UniqueType.ModifiedByGameProgress)) {
            modifier *= 1.0f + (Float.parseFloat(unique.params.get(0)) / (float)100 - 1.0f) * gameProgess;
        }
        return modifier;
    }

    @Readonly
    public final boolean hasTriggerConditional() {
        boolean bl;
        block10: {
            if (CollectionsKt.none((Iterable)this.modifiers)) {
                return false;
            }
            Iterable $this$any$iv = this.modifiers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block9: {
                        Unique conditional = (Unique)element$iv;
                        boolean bl3 = false;
                        Object object = conditional.type;
                        if (object != null && (object = object.getTargetTypes()) != null) {
                            Iterable $this$any$iv2 = (Iterable)object;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    UniqueTarget it = (UniqueTarget)((Object)element$iv2);
                                    boolean bl4 = false;
                                    if (!(it.canAcceptUniqueTarget(UniqueTarget.TriggerCondition) || it.canAcceptUniqueTarget(UniqueTarget.UnitActionModifier) || it.canAcceptUniqueTarget(UniqueTarget.UnitTriggerCondition))) continue;
                                    bl2 = true;
                                    break block9;
                                }
                                bl2 = false;
                            }
                        } else {
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    public final boolean conditionalsApply(@NotNull GameContext state) {
        Intrinsics.checkNotNullParameter(state, "state");
        if (state.getIgnoreConditionals()) {
            return true;
        }
        if (this.isTimedTriggerable) {
            return true;
        }
        if (this.modifiers.isEmpty()) {
            return true;
        }
        for (Unique modifier : this.modifiers) {
            if (Conditionals.INSTANCE.conditionalApplies(this, modifier, state)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final int getUniqueMultiplier(GameContext gameContext) {
        if (Intrinsics.areEqual(gameContext, GameContext.Companion.getIgnoreMultiplicationForCaching())) {
            return 1;
        }
        int amount = 1;
        List<Unique> forEveryModifiers = this.getModifiers(UniqueType.ForEveryCountable);
        for (Unique unique : forEveryModifiers) {
            Integer n = Countables.Companion.getCountableAmount(unique.params.get(0), gameContext);
            int multiplier = n != null ? n : 0;
            amount *= multiplier;
        }
        List<Unique> forEveryAmountModifiers = this.getModifiers(UniqueType.ForEveryAmountCountable);
        for (Unique conditional : forEveryAmountModifiers) {
            Integer n = Countables.Companion.getCountableAmount(conditional.params.get(1), gameContext);
            int multiplier = n != null ? n : 0;
            int perEvery = Integer.parseInt(conditional.params.get(0));
            amount *= multiplier / perEvery;
        }
        if (gameContext.getRelevantTile() != null) {
            List<Unique> list2 = this.getModifiers(UniqueType.ForEveryAdjacentTile);
            for (Unique conditional : list2) {
                void $this$count$iv;
                Tile tile = gameContext.getRelevantTile();
                Intrinsics.checkNotNull(tile);
                Sequence<Tile> sequence = tile.getNeighbors();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!Tile.matchesFilter$default(it, conditional.params.get(0), null, 2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int multiplier = count$iv;
                amount *= multiplier;
            }
        }
        return RangesKt.coerceAtLeast(amount, 0);
    }

    @Readonly
    @NotNull
    public final Sequence<Unique> getMultiplied(@NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        int multiplier = this.getUniqueMultiplier(gameContext);
        return SequencesKt.take((Sequence)new EndlessSequenceOf<Unique>(this), multiplier);
    }

    @Readonly
    @Nullable
    public final Deprecated getDeprecationAnnotation() {
        UniqueType uniqueType = this.type;
        return uniqueType != null ? uniqueType.getDeprecationAnnotation() : null;
    }

    @Readonly
    @NotNull
    public final String getSourceNameForUser() {
        String string;
        UniqueTarget uniqueTarget = this.sourceObjectType;
        switch (uniqueTarget == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uniqueTarget.ordinal()]) {
            case -1: {
                string = "";
                break;
            }
            case 1: {
                string = GlobalUniques.Companion.getUniqueSourceDescription(this);
                break;
            }
            case 2: {
                string = "Wonders";
                break;
            }
            case 3: {
                string = "Buildings";
                break;
            }
            case 4: {
                string = "Policies";
                break;
            }
            case 5: {
                string = "City-States";
                break;
            }
            default: {
                string = this.sourceObjectType.name();
            }
        }
        return string;
    }

    @Readonly
    private final int getNthIndex(String string, List<String> list2, int n) {
        int count2 = 0;
        int n2 = ((Collection)list2).size();
        for (int i = 0; i < n2; ++i) {
            if (!Intrinsics.areEqual(list2.get(i), string)) continue;
            if (count2 == n) {
                return i;
            }
            ++count2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final String getReplacementText(@NotNull Ruleset ruleset) {
        Collection collection;
        void $this$filterTo$iv$iv;
        Object timesParameterWasSeen;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Deprecated deprecated = this.getDeprecationAnnotation();
        if (deprecated == null) {
            return "";
        }
        Deprecated deprecationAnnotation = deprecated;
        String replacementUniqueText = deprecationAnnotation.replaceWith().expression();
        UniqueType uniqueType = this.type;
        Intrinsics.checkNotNull((Object)uniqueType);
        List<String> deprecatedUniquePlaceholders = TranslationsKt.getPlaceholderParameters(uniqueType.getText());
        String[] stringArray = new String[]{"\" OR \""};
        List possibleUniques = StringsKt.split$default((CharSequence)replacementUniqueText, stringArray, false, 0, 6, null);
        ArrayList finalPossibleUniques = new ArrayList();
        Iterator iterator2 = possibleUniques.iterator();
        while (iterator2.hasNext()) {
            String possibleUnique;
            String resultingUnique = possibleUnique = (String)iterator2.next();
            timesParameterWasSeen = new Counter(null, 1, null);
            for (String parameter : TranslationsKt.getPlaceholderParameters(StringsKt.replace$default(possibleUnique, '<', ' ', false, 4, null))) {
                int timesSeen;
                boolean parameterHasSign = StringsKt.startsWith$default((CharSequence)parameter, '-', false, 2, null) || StringsKt.startsWith$default((CharSequence)parameter, '+', false, 2, null);
                String parameterUnsigned = parameterHasSign ? StringsKt.drop(parameter, 1) : parameter;
                int parameterNumberInDeprecatedUnique = this.getNthIndex(parameterUnsigned, deprecatedUniquePlaceholders, timesSeen = ((Number)((Counter)timesParameterWasSeen).get(parameterUnsigned)).intValue());
                boolean bl = 0 <= parameterNumberInDeprecatedUnique ? parameterNumberInDeprecatedUnique < ((Collection)this.params).size() : false;
                if (!bl) continue;
                ((Counter)timesParameterWasSeen).add(parameterUnsigned, 1);
                int positionInDeprecatedUnique = StringsKt.indexOf$default((CharSequence)this.type.getText(), '[' + parameterUnsigned + ']', 0, false, 6, null);
                String replacementText = this.params.get(parameterNumberInDeprecatedUnique);
                if (this.type.getParameterTypeMap().get(parameterNumberInDeprecatedUnique).contains((Object)UniqueParameterType.Number)) {
                    String replacementTextUnsigned;
                    boolean deprecatedHadPlusSign = positionInDeprecatedUnique > 0 && this.type.getText().charAt(positionInDeprecatedUnique - 1) == '+';
                    boolean deprecatedHadMinusSign = positionInDeprecatedUnique > 0 && this.type.getText().charAt(positionInDeprecatedUnique - 1) == '-';
                    boolean deprecatedHadSign = deprecatedHadPlusSign || deprecatedHadMinusSign;
                    int positionInNewUnique = StringsKt.indexOf$default((CharSequence)possibleUnique, '[' + parameter + ']', 0, false, 6, null);
                    boolean newHasMinusSign = positionInNewUnique > 0 && possibleUnique.charAt(positionInNewUnique - 1) == '-';
                    boolean replacementHasMinusSign = StringsKt.startsWith$default((CharSequence)replacementText, '-', false, 2, null);
                    boolean replacementHasPlusSign = StringsKt.startsWith$default((CharSequence)replacementText, '+', false, 2, null);
                    boolean replacementIsSigned = replacementHasPlusSign || replacementHasMinusSign;
                    String string = replacementTextUnsigned = replacementIsSigned ? StringsKt.drop(replacementText, 1) : replacementText;
                    boolean replacementShouldBeNegative = deprecatedHadMinusSign == newHasMinusSign ? replacementHasMinusSign : !replacementHasMinusSign;
                    boolean replacementShouldBeSigned = deprecatedHadSign && !newHasMinusSign || parameterHasSign;
                    replacementText = !deprecatedHadSign && !newHasMinusSign && !replacementIsSigned ? replacementText : (replacementShouldBeNegative ? '-' + replacementTextUnsigned : (replacementShouldBeSigned ? '+' + replacementTextUnsigned : replacementTextUnsigned));
                }
                resultingUnique = StringsKt.replaceFirst$default(resultingUnique, '[' + parameter + ']', '[' + replacementText + ']', false, 4, null);
            }
            ((Collection)finalPossibleUniques).add(resultingUnique);
        }
        if (finalPossibleUniques.size() == 1) {
            return (String)CollectionsKt.first(finalPossibleUniques);
        }
        Iterable $this$filter$iv = finalPossibleUniques;
        boolean $i$f$filter = false;
        timesParameterWasSeen = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Unique unique = new Unique(it, null, null, 6, null);
            RulesetErrorList errors = new UniqueValidator(ruleset).checkUnique(unique, true, null, true);
            if (!errors.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List uniquesWithNoErrors = (List)destination$iv$iv;
        if (uniquesWithNoErrors.size() == 1) {
            return (String)CollectionsKt.first(uniquesWithNoErrors);
        }
        Collection collection2 = uniquesWithNoErrors;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = possibleUniques;
        } else {
            collection = collection2;
        }
        List uniquesToUnify = (List)collection;
        return CollectionsKt.joinToString$default(uniquesToUnify, "\", \"", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public String toString() {
        return this.type == null ? '\"' + this.text + '\"' : (Object)((Object)this.type) + " (\"" + this.text + "\")";
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final String getDisplayText() {
        String string;
        boolean bl;
        Iterable $this$none$iv;
        block6: {
            $this$none$iv = this.modifiers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!it.isHiddenToUsers()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            string = this.text;
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            $this$none$iv = this.modifiers;
            StringBuilder stringBuilder = new StringBuilder().append(TranslationsKt.removeConditionals(this.text)).append(' ');
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Unique it = (Unique)element$iv$iv;
                boolean bl3 = false;
                if (!(!it.isHiddenToUsers())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            string = stringBuilder.append(CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, Unique::getDisplayText$lambda$2, 30, null)).toString();
        }
        return string;
    }

    private static final Stats stats_delegate$lambda$0(Unique this$0) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this$0.params;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Stats.Companion.isStats(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        String firstStatParam = v0;
        return firstStatParam == null ? new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null) : Stats.Companion.parse(firstStatParam);
    }

    private static final CharSequence getDisplayText$lambda$2(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '<' + it.text + '>';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0096\u0002R\u0010\u0010\u0003\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/unique/Unique$EndlessSequenceOf;", "T", "Lkotlin/sequences/Sequence;", "value", "<init>", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "iterator", "", "core"})
    private static final class EndlessSequenceOf<T>
    implements Sequence<T> {
        private final T value;

        public EndlessSequenceOf(T value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new Iterator<T>(this){
                final /* synthetic */ EndlessSequenceOf<T> this$0;
                {
                    this.this$0 = $receiver;
                }

                public T next() {
                    return (T)EndlessSequenceOf.access$getValue$p(this.this$0);
                }

                public boolean hasNext() {
                    return true;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        public static final /* synthetic */ Object access$getValue$p(EndlessSequenceOf $this) {
            return $this.value;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UniqueTarget.values().length];
            try {
                nArray[UniqueTarget.Global.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueTarget.Wonder.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueTarget.Building.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueTarget.Policy.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueTarget.CityState.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

