/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.files.MapSaver;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.TileMap;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorFilesScroll;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u0012H\u0002J\f\u0010$\u001a\u00020\u0014*\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorSaveTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "headerHeight", "", "<init>", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;F)V", "mapFiles", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorFilesScroll;", "saveButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "deleteButton", "quitButton", "mapNameTextField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "chosenMap", "Lcom/badlogic/gdx/files/FileHandle;", "setSaveButton", "", "enabled", "", "saveHandler", "mapFile", "deleteHandler", "activated", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "deactivated", "selectFile", "file", "saverThread", "Lkotlinx/coroutines/CoroutineScope;", "core"})
public final class MapEditorSaveTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final MapEditorFilesScroll mapFiles;
    @NotNull
    private final TextButton saveButton;
    @NotNull
    private final TextButton deleteButton;
    @NotNull
    private final TextButton quitButton;
    @NotNull
    private final UncivTextField mapNameTextField;
    @Nullable
    private FileHandle chosenMap;

    public MapEditorSaveTab(@NotNull MapEditorScreen editorScreen, float headerHeight) {
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        this.mapFiles = new MapEditorFilesScroll(this.editorScreen.getToolsWidth() - 40.0f, false, (Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            public final void invoke(FileHandle p0) {
                MapEditorSaveTab.access$selectFile((MapEditorSaveTab)this.receiver, p0);
            }
        }, (Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            public final void invoke(FileHandle p0) {
                MapEditorSaveTab.access$saveHandler((MapEditorSaveTab)this.receiver, p0);
            }
        });
        this.saveButton = Scene2dExtensionsKt.toTextButton$default("Save map", null, false, 3, null);
        this.deleteButton = Scene2dExtensionsKt.toTextButton$default("Delete map", null, false, 3, null);
        this.quitButton = Scene2dExtensionsKt.toTextButton$default("Exit map editor", null, false, 3, null);
        this.mapNameTextField = new UncivTextField("Map Name", null, null, 6, null);
        this.mapNameTextField.setMaxLength(100);
        this.mapNameTextField.setTextFieldFilter(MapEditorSaveTab::_init_$lambda$0);
        this.mapNameTextField.selectAll();
        this.add((Actor)this.mapNameTextField).pad(10.0f).fillX().row();
        Table buttonTable = new Table(this.getSkin());
        buttonTable.defaults().pad(10.0f).fillX();
        ActivationExtensionsKt.onActivation(this.saveButton, () -> MapEditorSaveTab._init_$lambda$1(this));
        ActivationExtensionsKt.getKeyShortcuts(this.saveButton).add(KeyCharAndCode.Companion.getRETURN());
        ActivationExtensionsKt.onChange(this.mapNameTextField, arg_0 -> MapEditorSaveTab._init_$lambda$2(this, arg_0));
        buttonTable.add((Actor)this.saveButton);
        ActivationExtensionsKt.onActivation(this.deleteButton, () -> MapEditorSaveTab._init_$lambda$3(this));
        ActivationExtensionsKt.getKeyShortcuts(this.deleteButton).add(KeyCharAndCode.Companion.getDEL());
        buttonTable.add((Actor)this.deleteButton);
        ActivationExtensionsKt.onClick(this.quitButton, new Function0<Unit>((Object)this.editorScreen){

            @Override
            public final void invoke() {
                ((MapEditorScreen)this.receiver).closeEditor$core();
            }
        });
        buttonTable.add((Actor)this.quitButton);
        buttonTable.pack();
        float fileTableHeight = this.editorScreen.getStage().getHeight() - headerHeight - this.mapNameTextField.getPrefHeight() - buttonTable.getHeight() - 22.0f;
        this.add((Actor)this.mapFiles).height(fileTableHeight).fillX().row();
        this.add((Actor)buttonTable).row();
    }

    private final void setSaveButton(boolean enabled) {
        Scene2dExtensionsKt.setEnabled(this.saveButton, enabled);
        this.saveButton.setText(TranslationsKt.tr$default(enabled ? "Save map" : "Working...", false, false, 3, null));
    }

    private final void saveHandler(FileHandle mapFile) {
        if (mapFile != null) {
            this.mapNameTextField.setText(mapFile.name());
        }
        String string = this.mapNameTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (StringsKt.isBlank(string)) {
            return;
        }
        MapParameters mapParameters = this.editorScreen.getTileMap().getMapParameters();
        String string2 = this.mapNameTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        mapParameters.setName(string2);
        this.editorScreen.getTileMap().getMapParameters().setType("Custom");
        TileMap tileMap = this.editorScreen.getTileMap();
        String string3 = this.editorScreen.getDescriptionTextField().getText();
        Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
        tileMap.setDescription(string3);
        this.setSaveButton(false);
        this.editorScreen.startBackgroundJob("MapSaver", false, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapEditorSaveTab this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$startBackgroundJob;
                        ResultKt.throwOnFailure($result);
                        MapEditorSaveTab.access$saverThread(this.this$0, (CoroutineScope)$this$startBackgroundJob);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    static /* synthetic */ void saveHandler$default(MapEditorSaveTab mapEditorSaveTab, FileHandle fileHandle, int n, Object object) {
        if ((n & 1) != 0) {
            fileHandle = null;
        }
        mapEditorSaveTab.saveHandler(fileHandle);
    }

    private final void deleteHandler() {
        if (this.chosenMap == null) {
            return;
        }
        Popup.open$default(new ConfirmPopup(this.editorScreen, "Are you sure you want to delete this map?", "Delete map", false, null, () -> MapEditorSaveTab.deleteHandler$lambda$0(this), 24, null), false, 1, null);
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(true);
        MapEditorScreen.enableKeyboardPanningListener$core$default(this.editorScreen, null, false, 1, null);
        this.mapFiles.updateMaps();
        this.selectFile(null);
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        MapEditorScreen.enableKeyboardPanningListener$core$default(this.editorScreen, null, true, 1, null);
        pager.setScrollDisabled(false);
        this.getStage().setKeyboardFocus(null);
    }

    private final void selectFile(FileHandle file) {
        this.chosenMap = file;
        Object object = file;
        if (object == null || (object = ((FileHandle)object).name()) == null) {
            object = this.editorScreen.getTileMap().getMapParameters().getName();
        }
        this.mapNameTextField.setText((String)object);
        String string = this.mapNameTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if (StringsKt.isBlank(string)) {
            this.mapNameTextField.setText(TranslationsKt.tr$default("My new map", false, false, 3, null));
        }
        this.mapNameTextField.setSelection(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.getStage().setKeyboardFocus(this.mapNameTextField);
        Scene2dExtensionsKt.setEnabled(this.saveButton, true);
        Scene2dExtensionsKt.setEnabled(this.deleteButton, file != null);
        this.deleteButton.setColor(file != null ? Color.SCARLET : Color.BROWN);
    }

    private final void saverThread(CoroutineScope $this$saverThread) {
        try {
            TileMap mapToSave = this.editorScreen.getMapCloneForSave();
            if (!CoroutineScopeKt.isActive($this$saverThread)) {
                return;
            }
            mapToSave.assignContinents(TileMap.AssignContinentsMode.Reassign);
            if (!CoroutineScopeKt.isActive($this$saverThread)) {
                return;
            }
            String string = this.mapNameTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
            MapSaver.INSTANCE.saveMap(string, mapToSave);
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MapEditorSaveTab this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            new ToastPopup("Map saved successfully!", MapEditorSaveTab.access$getEditorScreen$p(this.this$0), 0L, 4, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            this.editorScreen.setDirty(false);
            this.setSaveButton(true);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Failed to save map", ex);
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MapEditorSaveTab this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            Popup cantLoadGamePopup = new Popup(MapEditorSaveTab.access$getEditorScreen$p(this.this$0), null, 0.0f, 6, null);
                            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "It looks like your map can't be saved!", 0, false, null, 14, null).row();
                            Popup.addCloseButton$default(cantLoadGamePopup, null, null, null, null, 15, null);
                            cantLoadGamePopup.open(true);
                            MapEditorSaveTab.access$setSaveButton(this.this$0, true);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    private static final boolean _init_$lambda$0(TextField textField, char c) {
        return c != '\\' && c != '/';
    }

    private static final Unit _init_$lambda$1(MapEditorSaveTab this$0) {
        MapEditorSaveTab.saveHandler$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(MapEditorSaveTab this$0, ChangeListener.ChangeEvent it) {
        Button button = this$0.saveButton;
        String string = this$0.mapNameTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        Scene2dExtensionsKt.setEnabled(button, !StringsKt.isBlank(string));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(MapEditorSaveTab this$0) {
        this$0.deleteHandler();
        return Unit.INSTANCE;
    }

    private static final Unit deleteHandler$lambda$0(MapEditorSaveTab this$0) {
        FileHandle fileHandle = this$0.chosenMap;
        Intrinsics.checkNotNull(fileHandle);
        fileHandle.delete();
        this$0.mapFiles.updateMaps();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$saverThread(MapEditorSaveTab $this, CoroutineScope $receiver) {
        $this.saverThread($receiver);
    }

    public static final /* synthetic */ MapEditorScreen access$getEditorScreen$p(MapEditorSaveTab $this) {
        return $this.editorScreen;
    }

    public static final /* synthetic */ void access$setSaveButton(MapEditorSaveTab $this, boolean enabled) {
        $this.setSaveButton(enabled);
    }

    public static final /* synthetic */ void access$selectFile(MapEditorSaveTab $this, FileHandle file) {
        $this.selectFile(file);
    }

    public static final /* synthetic */ void access$saveHandler(MapEditorSaveTab $this, FileHandle mapFile) {
        $this.saveHandler(mapFile);
    }
}

