/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.UncivGame;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.battle.AirInterception;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.BattleUnitCapture;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.Nuke;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.PromoteUnitAction;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.GameResource;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.stats.SubStat;
import com.unciv.ui.components.UnitMovementMemoryType;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsPillage;
import com.unciv.utils.LogKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001IB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J%\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001fJ\u0018\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0018H\u0002J(\u0010#\u001a\u0012\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020%`&2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0018H\u0003J\u001d\u0010'\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b(J \u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-H\u0002J=\u0010.\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u00102\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u00103\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J%\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b8J \u00109\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0006\u001a\u00020\u0018H\u0002J\u0018\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010;\u001a\u00020<H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00072\u0006\u0010A\u001a\u00020\u0013H\u0007J\"\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020?2\u0006\u0010\u0006\u001a\u00020?2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010EJ \u0010F\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010G\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0018H\u0002J \u0010H\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u00a8\u0006J"}, d2={"Lcom/unciv/logic/battle/Battle;", "", "<init>", "()V", "moveAndAttack", "", "attacker", "Lcom/unciv/logic/battle/ICombatant;", "attackableTile", "Lcom/unciv/logic/battle/AttackableTile;", "movePreparingAttack", "", "tryHealPillage", "attackOrNuke", "Lcom/unciv/logic/battle/Battle$DamageDealt;", "attack", "defender", "triggerPostKillingUniques", "attackedTile", "Lcom/unciv/logic/map/tile/Tile;", "handleCityDefeated", "triggerCombatUniques", "triggerVictoryUniques", "ourUnit", "Lcom/unciv/logic/battle/MapUnitCombatant;", "enemy", "triggerDamageUniquesForUnit", "triggeringUnit", "combatAction", "Lcom/unciv/logic/battle/CombatAction;", "triggerDefeatUniques", "triggerDefeatUniques$core", "tryEarnFromKilling", "civUnit", "defeatedUnit", "getKillUnitPlunderUniques", "Ljava/util/ArrayList;", "Lcom/unciv/models/ruleset/unique/Unique;", "Lkotlin/collections/ArrayList;", "takeDamage", "takeDamage$core", "plunderFromDamage", "plunderingUnit", "plunderedUnit", "damageDealt", "", "postBattleNotifications", "attackerTile", "postBattleNotifications$core", "tryHealAfterKilling", "postBattleMoveToAttackedTile", "postBattleAddXp", "addXp", "thisCombatant", "amount", "otherCombatant", "addXp$core", "reduceAttackerMovementPointsAndAttacks", "conquerCity", "city", "Lcom/unciv/logic/city/City;", "automateCityConquer", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getMapCombatantOfTile", "tile", "destroyIfDefeated", "attackedCiv", "notificationLocation", "Lcom/unciv/logic/map/HexCoord;", "hasWithdrawnFromMeelee", "doWithdrawFromMeleeAbility", "doDestroyImprovementsAbility", "DamageDealt", "core"})
@SourceDebugExtension(value={"SMAP\nBattle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Battle.kt\ncom/unciv/logic/battle/Battle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,805:1\n295#2,2:806\n774#2:813\n865#2:814\n866#2:817\n1255#3,2:808\n183#3,2:810\n2275#3,2:815\n1#4:812\n*S KotlinDebug\n*F\n+ 1 Battle.kt\ncom/unciv/logic/battle/Battle\n*L\n176#1:806,2\n588#1:813\n588#1:814\n588#1:817\n214#1:808,2\n351#1:810,2\n590#1:815,2\n*E\n"})
public final class Battle {
    @NotNull
    public static final Battle INSTANCE = new Battle();

    private Battle() {
    }

    public final void moveAndAttack(@NotNull ICombatant attacker, @NotNull AttackableTile attackableTile) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(attackableTile, "attackableTile");
        if (!this.movePreparingAttack(attacker, attackableTile, true)) {
            return;
        }
        this.attackOrNuke(attacker, attackableTile);
    }

    public final boolean movePreparingAttack(@NotNull ICombatant attacker, @NotNull AttackableTile attackableTile, boolean tryHealPillage) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(attackableTile, "attackableTile");
        if (!(attacker instanceof MapUnitCombatant)) {
            return true;
        }
        List<Tile> tilesMovedThrough = UnitMovement.getDistanceToTiles$default(((MapUnitCombatant)attacker).getUnit().getMovement(), false, null, null, false, 15, null).getPathToTile(attackableTile.getTileToAttackFrom());
        UnitMovement.moveToTile$default(((MapUnitCombatant)attacker).getUnit().getMovement(), attackableTile.getTileToAttackFrom(), false, 2, null);
        if (!Intrinsics.areEqual(((MapUnitCombatant)attacker).getTile(), attackableTile.getTileToAttackFrom())) {
            return false;
        }
        ICombatant combatant = this.getMapCombatantOfTile(attackableTile.getTileToAttack());
        if (combatant == null || Intrinsics.areEqual(combatant.getCivInfo(), ((MapUnitCombatant)attacker).getCivInfo())) {
            return false;
        }
        if (MapUnitCombatant.hasUnique$default((MapUnitCombatant)attacker, UniqueType.MustSetUp, null, 2, null) && !((MapUnitCombatant)attacker).getUnit().isSetUpForSiege() && ((MapUnitCombatant)attacker).getUnit().hasMovement()) {
            ((MapUnitCombatant)attacker).getUnit().setAction(UnitActionType.SetUp.getValue());
            ((MapUnitCombatant)attacker).getUnit().useMovementPoints(1.0f);
        }
        if (tryHealPillage) {
            for (Tile tileToPillage : tilesMovedThrough) {
                if (((MapUnitCombatant)attacker).getUnit().getCurrentMovement() <= 1.0f || ((MapUnitCombatant)attacker).getUnit().getHealth() > 90) break;
                if (!UnitActionsPillage.INSTANCE.canPillage(((MapUnitCombatant)attacker).getUnit(), tileToPillage) || !tileToPillage.canPillageTileImprovement()) continue;
                Object object = UnitActionsPillage.INSTANCE.getPillageAction$core(((MapUnitCombatant)attacker).getUnit(), tileToPillage);
                if (object != null && (object = ((UnitAction)object).getAction()) != null) {
                    object.invoke();
                }
            }
        }
        return ((MapUnitCombatant)attacker).getUnit().hasMovement();
    }

    public static /* synthetic */ boolean movePreparingAttack$default(Battle battle, ICombatant iCombatant, AttackableTile attackableTile, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return battle.movePreparingAttack(iCombatant, attackableTile, bl);
    }

    @NotNull
    public final DamageDealt attackOrNuke(@NotNull ICombatant attacker, @NotNull AttackableTile attackableTile) {
        DamageDealt damageDealt;
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(attackableTile, "attackableTile");
        if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().isNuclearWeapon()) {
            Nuke.INSTANCE.NUKE((MapUnitCombatant)attacker, attackableTile.getTileToAttack());
            damageDealt = DamageDealt.Companion.getNone();
        } else {
            ICombatant iCombatant = this.getMapCombatantOfTile(attackableTile.getTileToAttack());
            Intrinsics.checkNotNull(iCombatant);
            damageDealt = this.attack(attacker, iCombatant);
        }
        return damageDealt;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DamageDealt attack(@NotNull ICombatant attacker, @NotNull ICombatant defender) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Object[] objectArray = new Object[]{attacker.getCivInfo().getCivName(), attacker.getName(), defender.getCivInfo().getCivName(), defender.getName()};
        LogKt.debug("%s %s attacked %s %s", objectArray);
        Tile attackedTile = defender.getTile();
        boolean bl = attacker instanceof MapUnitCombatant ? ((MapUnitCombatant)attacker).getUnit().getAttacksSinceTurnStart().add(attackedTile.getPosition()) : attacker.getCivInfo().getAttacksSinceTurnStart().add(new Civilization.HistoricalAttackMemory(null, attacker.getTile().getPosition(), attackedTile.getPosition()));
        DamageDealt interceptDamage = null;
        if (attacker instanceof MapUnitCombatant && ((MapUnitCombatant)attacker).getUnit().getBaseUnit().isAirUnit()) {
            interceptDamage = AirInterception.INSTANCE.tryInterceptAirAttack$core((MapUnitCombatant)attacker, attackedTile, defender.getCivInfo(), defender);
            if (((MapUnitCombatant)attacker).isDefeated()) {
                return interceptDamage;
            }
        } else {
            interceptDamage = DamageDealt.Companion.getNone();
        }
        if (this.hasWithdrawnFromMeelee(attacker, defender, attackedTile)) {
            return DamageDealt.Companion.getNone();
        }
        boolean isAlreadyDefeatedCity = defender instanceof CityCombatant && ((CityCombatant)defender).isDefeated();
        this.triggerCombatUniques(attacker, defender, attackedTile);
        DamageDealt damageDealt = this.takeDamage$core(attacker, defender);
        boolean captureMilitaryUnitSuccess = BattleUnitCapture.INSTANCE.tryCaptureMilitaryUnit(attacker, defender, attackedTile);
        if (!captureMilitaryUnitSuccess) {
            this.postBattleNotifications$core(attacker, defender, attackedTile, attacker.getTile(), damageDealt);
        }
        if (defender.getCivInfo().isBarbarian() && Intrinsics.areEqual(attackedTile.getImprovement(), "Barbarian encampment")) {
            defender.getCivInfo().getGameInfo().getBarbarians().campAttacked(attackedTile.getPosition());
        }
        this.handleCityDefeated(defender, attacker);
        this.triggerPostKillingUniques(defender, attacker, attackedTile);
        if (attacker instanceof MapUnitCombatant && defender instanceof MapUnitCombatant) {
            this.triggerDamageUniquesForUnit((MapUnitCombatant)attacker, (MapUnitCombatant)defender, attackedTile, CombatAction.Attack);
            if (!attacker.isRanged()) {
                this.triggerDamageUniquesForUnit((MapUnitCombatant)defender, (MapUnitCombatant)attacker, attackedTile, CombatAction.Defend);
            }
        }
        if (!defender.isDefeated() && defender instanceof MapUnitCombatant && ((MapUnitCombatant)defender).getUnit().isExploring()) {
            ((MapUnitCombatant)defender).getUnit().setAction(null);
        }
        if (attacker instanceof MapUnitCombatant) {
            if (MapUnit.hasUnique$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.SelfDestructs, null, false, 6, null)) {
                MapUnit.destroy$default(((MapUnitCombatant)attacker).getUnit(), false, 1, null);
            } else if (((MapUnitCombatant)attacker).getUnit().isMoving()) {
                ((MapUnitCombatant)attacker).getUnit().setAction(null);
            }
            this.doDestroyImprovementsAbility((MapUnitCombatant)attacker, attackedTile, defender);
        }
        if (!captureMilitaryUnitSuccess) {
            this.postBattleMoveToAttackedTile(attacker, defender, attackedTile);
        }
        this.reduceAttackerMovementPointsAndAttacks(attacker, defender, attackedTile);
        if (!isAlreadyDefeatedCity) {
            this.postBattleAddXp(attacker, defender);
        }
        if (attacker instanceof CityCombatant) {
            Object v1;
            block17: {
                void $this$firstOrNull$iv;
                Iterable iterable = ((CityCombatant)attacker).getCivInfo().getNotifications();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Notification it = (Notification)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getText(), "Your city [" + ((CityCombatant)attacker).getName() + "] can bombard the enemy!")) continue;
                    v1 = element$iv;
                    break block17;
                }
                v1 = null;
            }
            Notification cityCanBombardNotification = v1;
            TypeIntrinsics.asMutableCollection(((CityCombatant)attacker).getCivInfo().getNotifications()).remove(cityCanBombardNotification);
        }
        return damageDealt.plus(interceptDamage);
    }

    private final void triggerPostKillingUniques(ICombatant defender, ICombatant attacker, Tile attackedTile) {
        if (defender.isDefeated() && defender instanceof MapUnitCombatant && !((MapUnitCombatant)defender).getUnit().isCivilian()) {
            this.tryEarnFromKilling(attacker, (MapUnitCombatant)defender);
            this.tryHealAfterKilling(attacker);
            if (attacker instanceof MapUnitCombatant) {
                this.triggerVictoryUniques((MapUnitCombatant)attacker, (MapUnitCombatant)defender, attackedTile);
            }
            this.triggerDefeatUniques$core((MapUnitCombatant)defender, attacker, attackedTile);
        } else if (attacker.isDefeated() && attacker instanceof MapUnitCombatant && !((MapUnitCombatant)attacker).getUnit().isCivilian()) {
            this.tryEarnFromKilling(defender, (MapUnitCombatant)attacker);
            this.tryHealAfterKilling(defender);
            if (defender instanceof MapUnitCombatant) {
                this.triggerVictoryUniques((MapUnitCombatant)defender, (MapUnitCombatant)attacker, attackedTile);
            }
            this.triggerDefeatUniques$core((MapUnitCombatant)attacker, defender, attackedTile);
        }
    }

    private final void handleCityDefeated(ICombatant defender, ICombatant attacker) {
        if (!defender.isDefeated() || !(defender instanceof CityCombatant) || !(attacker instanceof MapUnitCombatant) || !attacker.isMelee() && !MapUnit.hasUnique$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.CanDestroyCities, null, true, 2, null) || MapUnit.hasUnique$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.CannotCaptureCities, null, true, 2, null)) {
            return;
        }
        if (((CityCombatant)defender).isDefeated() && City.canBeDestroyed$default(((CityCombatant)defender).getCity(), false, 1, null)) {
            boolean bl;
            String[] stringArray;
            block7: {
                Sequence<String> destroyFilters;
                Sequence<String> $this$any$iv = destroyFilters = SequencesKt.map(MapUnit.getMatchingUniques$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.CanDestroyCities, null, false, 6, null), Battle::handleCityDefeated$lambda$0);
                boolean $i$f$any = false;
                stringArray = $this$any$iv.iterator();
                while (stringArray.hasNext()) {
                    String element$iv;
                    String filter2 = element$iv = stringArray.next();
                    boolean bl2 = false;
                    if (!City.matchesFilter$default(((CityCombatant)defender).getCity(), ((Object)StringsKt.trim((CharSequence)filter2)).toString(), ((MapUnitCombatant)attacker).getCivInfo(), false, 4, null)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl) {
                String cityName = ((CityCombatant)defender).getCity().getName();
                Civilization defendingCiv = ((CityCombatant)defender).getCivInfo();
                stringArray = new String[]{"OtherIcons/Pillage"};
                ((MapUnitCombatant)attacker).getCivInfo().addNotification("We have destroyed the city of [" + cityName + "]!", ((CityCombatant)defender).getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
                City.destroyCity$default(((CityCombatant)defender).getCity(), false, 1, null);
                if (defendingCiv.getCities().isEmpty()) {
                    this.destroyIfDefeated(defendingCiv, ((MapUnitCombatant)attacker).getCivInfo(), ((CityCombatant)defender).getTile().getPosition());
                }
                return;
            }
        }
        if (((MapUnitCombatant)attacker).getUnit().getCiv().isBarbarian()) {
            ((CityCombatant)defender).takeDamage(-1);
            int ransom = Math.min(200, ((CityCombatant)defender).getCity().getCiv().getGold());
            ((CityCombatant)defender).getCity().getCiv().addGold(-ransom);
            String[] stringArray = new String[]{"OtherIcons/Pillage"};
            ((CityCombatant)defender).getCity().getCiv().addNotification("Barbarians raided [" + ((CityCombatant)defender).getCity().getName() + "] and stole [" + ransom + "] Gold from your treasury!", ((CityCombatant)defender).getCity().getLocation(), Notification.NotificationCategory.War, stringArray);
            MapUnit.destroy$default(((MapUnitCombatant)attacker).getUnit(), false, 1, null);
        } else {
            this.conquerCity(((CityCombatant)defender).getCity(), (MapUnitCombatant)attacker);
        }
    }

    private final void triggerCombatUniques(ICombatant attacker, ICombatant defender, Tile attackedTile) {
        Object unit;
        Object object = attacker.getCivInfo();
        Object object2 = CombatAction.Attack;
        GameContext attackerContext = new GameContext((Civilization)object, null, null, attackedTile, attacker, defender, null, (CombatAction)((Object)object2), null, null, false, 1862, null);
        if (attacker instanceof MapUnitCombatant) {
            object = MapUnit.getTriggeredUniques$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.TriggerUponCombat, attackerContext, null, 4, null).iterator();
            while (object.hasNext()) {
                Unique unique = (Unique)object.next();
                unit = Intrinsics.areEqual(unique.getParams().get(0), "Target Unit") && defender instanceof MapUnitCombatant ? ((MapUnitCombatant)defender).getUnit() : ((MapUnitCombatant)attacker).getUnit();
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, (MapUnit)unit, null, null, 12, null);
            }
        }
        object2 = defender.getCivInfo();
        unit = CombatAction.Defend;
        GameContext defenderContext = new GameContext((Civilization)object2, null, null, attackedTile, defender, attacker, null, (CombatAction)((Object)unit), null, null, false, 1862, null);
        if (defender instanceof MapUnitCombatant) {
            object2 = MapUnit.getTriggeredUniques$default(((MapUnitCombatant)defender).getUnit(), UniqueType.TriggerUponCombat, defenderContext, null, 4, null).iterator();
            while (object2.hasNext()) {
                Unique unique = (Unique)object2.next();
                MapUnit unit2 = Intrinsics.areEqual(unique.getParams().get(0), "Target Unit") && attacker instanceof MapUnitCombatant ? ((MapUnitCombatant)attacker).getUnit() : ((MapUnitCombatant)defender).getUnit();
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, unit2, null, null, 12, null);
            }
        }
    }

    private final void triggerVictoryUniques(MapUnitCombatant ourUnit, MapUnitCombatant enemy, Tile attackedTile) {
        Object object = ourUnit.getCivInfo();
        GameContext gameContext = new GameContext((Civilization)object, null, null, attackedTile, ourUnit, enemy, null, null, null, null, false, 1990, null);
        object = ourUnit.getUnit().getTriggeredUniques(UniqueType.TriggerUponDefeatingUnit, gameContext, arg_0 -> Battle.triggerVictoryUniques$lambda$0(enemy, arg_0)).iterator();
        while (object.hasNext()) {
            Unique unique = (Unique)object.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, ourUnit.getUnit(), null, "due to " + ourUnit.getNotificationDisplay("our ") + " defeating a [" + enemy.getName() + ']', 4, null);
        }
    }

    private final void triggerDamageUniquesForUnit(MapUnitCombatant triggeringUnit, MapUnitCombatant enemy, Tile attackedTile, CombatAction combatAction) {
        Object object = triggeringUnit.getCivInfo();
        GameContext gameContext = new GameContext((Civilization)object, null, null, attackedTile, triggeringUnit, enemy, null, combatAction, null, null, false, 1862, null);
        object = triggeringUnit.getUnit().getTriggeredUniques(UniqueType.TriggerUponDamagingUnit, gameContext, arg_0 -> Battle.triggerDamageUniquesForUnit$lambda$0(enemy, arg_0)).iterator();
        while (object.hasNext()) {
            Unique unique = (Unique)object.next();
            boolean bl = Intrinsics.areEqual(unique.getParams().get(0), "Target Unit") ? UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, enemy.getUnit(), null, "due to " + enemy.getNotificationDisplay("our ") + " being damaged by a [" + triggeringUnit.getName() + ']', 4, null) : UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, triggeringUnit.getUnit(), null, "due to " + triggeringUnit.getNotificationDisplay("our ") + " damaging a [" + enemy.getName() + ']', 4, null);
        }
    }

    public final void triggerDefeatUniques$core(@NotNull MapUnitCombatant ourUnit, @NotNull ICombatant enemy, @NotNull Tile attackedTile) {
        Intrinsics.checkNotNullParameter(ourUnit, "ourUnit");
        Intrinsics.checkNotNullParameter(enemy, "enemy");
        Intrinsics.checkNotNullParameter(attackedTile, "attackedTile");
        Object object = ourUnit.getCivInfo();
        GameContext gameContext = new GameContext((Civilization)object, null, null, attackedTile, ourUnit, enemy, null, null, null, null, false, 1990, null);
        object = MapUnit.getTriggeredUniques$default(ourUnit.getUnit(), UniqueType.TriggerUponDefeat, gameContext, null, 4, null).iterator();
        while (object.hasNext()) {
            Unique unique = (Unique)object.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, ourUnit.getUnit(), null, "due to " + ourUnit.getNotificationDisplay("our ") + " being defeated by a [" + enemy.getName() + ']', 4, null);
        }
    }

    private final void tryEarnFromKilling(ICombatant civUnit, MapUnitCombatant defeatedUnit) {
        int unitStr = Math.max(defeatedUnit.getUnit().getBaseUnit().getStrength(), defeatedUnit.getUnit().getBaseUnit().getRangedStrength());
        int unitCost = defeatedUnit.getUnit().getBaseUnit().getCost();
        ArrayList<Unique> bonusUniques = this.getKillUnitPlunderUniques(civUnit, defeatedUnit);
        Iterator<Unique> iterator2 = bonusUniques.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            GameResource resource;
            Unique unique;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!ICombatant.matchesFilter$default(defeatedUnit, unique.getParams().get(1), false, 2, null)) continue;
            float yieldPercent = Float.parseFloat(unique.getParams().get(0)) / (float)100;
            String defeatedUnitYieldSourceType = unique.getParams().get(2);
            int yieldTypeSourceAmount = Intrinsics.areEqual(defeatedUnitYieldSourceType, "Cost") ? unitCost : unitStr;
            int yieldAmount = (int)((float)yieldTypeSourceAmount * yieldPercent);
            if (civUnit.getCivInfo().getGameInfo().getRuleset().getGameResource(unique.getParams().get(3)) == null) continue;
            civUnit.getCivInfo().addGameResource(resource, yieldAmount);
        }
        if (defeatedUnit.getCivInfo().isBarbarian() && !defeatedUnit.isCivilian() && civUnit.getCivInfo().isMajorCiv()) {
            for (Civilization cityState : defeatedUnit.getCivInfo().getGameInfo().getAliveCityStates()) {
                if (!civUnit.getCivInfo().knows(cityState) || !defeatedUnit.getUnit().threatensCiv(cityState)) continue;
                cityState.getCityStateFunctions().threateningBarbarianKilledBy(civUnit.getCivInfo());
            }
        }
        for (Civilization cityState : defeatedUnit.getCivInfo().getGameInfo().getAliveCityStates()) {
            cityState.getQuestManager().militaryUnitKilledBy(civUnit.getCivInfo(), defeatedUnit.getCivInfo());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final ArrayList<Unique> getKillUnitPlunderUniques(ICombatant civUnit, MapUnitCombatant defeatedUnit) {
        block4: {
            bonusUniques = new ArrayList<Unique>();
            gameContext = new GameContext(civUnit.getCivInfo(), null, null, null, civUnit, defeatedUnit, null, null, null, null, false, 1998, null);
            v0 = civUnit instanceof MapUnitCombatant != false ? CollectionsKt.addAll((Collection)bonusUniques, ((MapUnitCombatant)civUnit).getMatchingUniques(UniqueType.KillUnitPlunder, gameContext, true)) : CollectionsKt.addAll((Collection)bonusUniques, civUnit.getCivInfo().getMatchingUniques(UniqueType.KillUnitPlunder, gameContext));
            $this$firstOrNull$iv = civUnit.getTile().getTilesInDistance(4);
            $i$f$firstOrNull = false;
            var9_7 = $this$firstOrNull$iv.iterator();
            while (var9_7.hasNext()) {
                it = element$iv = var9_7.next();
                $i$a$-firstOrNull-Battle$getKillUnitPlunderUniques$cityWithReligion$1 = false;
                if (!it.isCityCenter()) ** GOTO lbl-1000
                v1 = it.getCity();
                Intrinsics.checkNotNull(v1);
                if (SequencesKt.any(City.getMatchingUniques$default(v1, UniqueType.KillUnitPlunderNearCity, gameContext, false, 4, null))) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        var6_11 = v3;
        v4 = cityWithReligion = var6_11 != null ? var6_11.getCity() : null;
        if (cityWithReligion != null) {
            CollectionsKt.addAll((Collection)bonusUniques, City.getMatchingUniques$default(cityWithReligion, UniqueType.KillUnitPlunderNearCity, gameContext, false, 4, null));
        }
        return bonusUniques;
    }

    @NotNull
    public final DamageDealt takeDamage$core(@NotNull ICombatant attacker, @NotNull ICombatant defender) {
        MapUnit unit;
        Unique unique;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        int potentialDamageToDefender = BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, attacker, defender, null, 0.0f, 12, null);
        int potentialDamageToAttacker = BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, attacker, defender, null, 0.0f, 12, null);
        int attackerHealthBefore = attacker.getHealth();
        int defenderHealthBefore = defender.getHealth();
        if (defender instanceof MapUnitCombatant && ((MapUnitCombatant)defender).getUnit().isCivilian() && attacker.isMelee()) {
            BattleUnitCapture.captureCivilianUnit$default(BattleUnitCapture.INSTANCE, attacker, (MapUnitCombatant)defender, false, 4, null);
        } else if (attacker.isRanged() && !attacker.isAirUnit()) {
            defender.takeDamage(potentialDamageToDefender);
        } else {
            while (potentialDamageToDefender + potentialDamageToAttacker > 0) {
                if (Random.Default.nextInt(potentialDamageToDefender + potentialDamageToAttacker) < potentialDamageToDefender) {
                    --potentialDamageToDefender;
                    defender.takeDamage(1);
                    if (!defender.isDefeated()) continue;
                    break;
                }
                --potentialDamageToAttacker;
                attacker.takeDamage(1);
                if (!attacker.isDefeated()) continue;
            }
        }
        int defenderDamageDealt = attackerHealthBefore - attacker.getHealth();
        int attackerDamageDealt = defenderHealthBefore - defender.getHealth();
        if (attacker instanceof MapUnitCombatant) {
            iterator2 = MapUnit.getTriggeredUniques$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.TriggerUponLosingHealth, null, arg_0 -> Battle.takeDamage$lambda$0(defenderDamageDealt, arg_0), 2, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                unit = Intrinsics.areEqual(unique.getParams().get(0), "Target Unit") && defender instanceof MapUnitCombatant ? ((MapUnitCombatant)defender).getUnit() : ((MapUnitCombatant)attacker).getUnit();
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, unit, null, "due to losing [" + defenderDamageDealt + "] HP", 4, null);
            }
        }
        if (defender instanceof MapUnitCombatant) {
            iterator2 = MapUnit.getTriggeredUniques$default(((MapUnitCombatant)defender).getUnit(), UniqueType.TriggerUponLosingHealth, null, arg_0 -> Battle.takeDamage$lambda$1(attackerDamageDealt, arg_0), 2, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                unit = Intrinsics.areEqual(unique.getParams().get(0), "Target Unit") && attacker instanceof MapUnitCombatant ? ((MapUnitCombatant)attacker).getUnit() : ((MapUnitCombatant)defender).getUnit();
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, unit, null, "due to losing [" + attackerDamageDealt + "] HP", 4, null);
            }
        }
        this.plunderFromDamage(attacker, defender, attackerDamageDealt);
        return new DamageDealt(attackerDamageDealt, defenderDamageDealt);
    }

    private final void plunderFromDamage(ICombatant plunderingUnit, ICombatant plunderedUnit, int damageDealt) {
        if (!(plunderingUnit instanceof MapUnitCombatant)) {
            return;
        }
        Civilization civ = ((MapUnitCombatant)plunderingUnit).getCivInfo();
        Stats plunderedGoods = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Iterator<Object> iterator2 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)plunderingUnit).getUnit(), UniqueType.DamageUnitsPlunder, null, true, 2, null).iterator();
        while (iterator2.hasNext()) {
            GameResource resource;
            Unique unique = (Unique)iterator2.next();
            if (!ICombatant.matchesFilter$default(plunderedUnit, unique.getParams().get(1), false, 2, null)) continue;
            float percentage = Float.parseFloat(unique.getParams().get(0));
            float amount = percentage / 100.0f * (float)damageDealt;
            String resourceName = unique.getParams().get(2);
            if (plunderedUnit.getCivInfo().getGameInfo().getRuleset().getGameResource(resourceName) == null) continue;
            if (resource instanceof Stat) {
                plunderedGoods.add((Stat)resource, amount);
                continue;
            }
            int plunderedAmount = MathKt.roundToInt(amount);
            civ.addGameResource(resource, plunderedAmount);
            String icon = resource instanceof SubStat ? ((SubStat)resource).getIcon() : "ResourceIcons/" + resourceName;
            String[] stringArray = new String[]{((MapUnitCombatant)plunderingUnit).getName(), "OtherIcons/Pillage", icon, plunderedUnit instanceof CityCombatant ? "ImprovementIcons/City center" : plunderedUnit.getName()};
            civ.addNotification(((MapUnitCombatant)plunderingUnit).getNotificationDisplay("Your ") + " plundered [" + plunderedAmount + "] [" + resourceName + "] from [" + plunderedUnit.getName() + ']', plunderedUnit.getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
        }
        for (Stats.StatValuePair statValuePair : plunderedGoods) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            int plunderedAmount = (int)value;
            if (plunderedAmount == 0) continue;
            civ.addStat(key, plunderedAmount);
            String[] stringArray = new String[]{((MapUnitCombatant)plunderingUnit).getName(), "OtherIcons/Pillage", "StatIcons/" + key.name(), plunderedUnit instanceof CityCombatant ? "ImprovementIcons/City center" : plunderedUnit.getName()};
            civ.addNotification(((MapUnitCombatant)plunderingUnit).getNotificationDisplay("your ") + " plundered [" + plunderedAmount + "] [" + key.name() + "] from [" + plunderedUnit.getName() + ']', plunderedUnit.getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
        }
    }

    public final void postBattleNotifications$core(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile attackedTile, @Nullable Tile attackerTile, @Nullable DamageDealt damageDealt) {
        String attackerString;
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        Intrinsics.checkNotNullParameter(attackedTile, "attackedTile");
        if (Intrinsics.areEqual(attacker.getCivInfo(), defender.getCivInfo())) {
            return;
        }
        Pair<String, String> pair = !(attacker instanceof CityCombatant) && attacker.isDefeated() ? TuplesKt.to("OtherIcons/Pillage", "was destroyed while attacking") : (!defender.isDefeated() ? TuplesKt.to("OtherIcons/Pillage", "has attacked") : (defender.isCity() && attacker.isMelee() && attacker.getCivInfo().isBarbarian() ? TuplesKt.to("OtherIcons/Pillage", "has raided") : (defender.isCity() && attacker.isMelee() ? TuplesKt.to("OtherIcons/Pillage", "has captured") : TuplesKt.to("OtherIcons/DisbandUnit", "has destroyed"))));
        String battleActionIcon = pair.component1();
        String battleActionString = pair.component2();
        String string = attackerString = attacker.isCity() ? "Enemy city [" + attacker.getName() + ']' : "An enemy [" + attacker.getName() + ']';
        String defenderString = defender.isCity() ? (defender.isDefeated() && attacker.isRanged() ? " the defence of [" + defender.getName() + ']' : " [" + defender.getName() + ']') : defender.getNotificationDisplay("our ");
        String attackerHurtString = damageDealt != null && damageDealt.getDefenderDealt() != 0 ? " ([-" + damageDealt.getDefenderDealt() + "] HP)" : "";
        String defenderHurtString = damageDealt != null ? " ([-" + damageDealt.getAttackerDealt() + "] HP)" : "";
        String notificationString = attackerString + attackerHurtString + ' ' + battleActionString + ' ' + defenderString + defenderHurtString;
        String attackerIcon = attacker instanceof CityCombatant ? "ImprovementIcons/City center" : attacker.getName();
        String defenderIcon = defender instanceof CityCombatant ? "ImprovementIcons/City center" : defender.getName();
        Object[] objectArray = new HexCoord[2];
        objectArray[0] = attackedTile.getPosition();
        Tile tile = attackerTile;
        objectArray[1] = tile != null ? tile.getPosition() : null;
        Sequence<LocationAction> locations = LocationAction.Companion.invoke((HexCoord[])objectArray);
        objectArray = new String[]{attackerIcon, battleActionIcon, defenderIcon};
        defender.getCivInfo().addNotification(notificationString, locations, Notification.NotificationCategory.War, (String[])objectArray);
    }

    public static /* synthetic */ void postBattleNotifications$core$default(Battle battle, ICombatant iCombatant, ICombatant iCombatant2, Tile tile, Tile tile2, DamageDealt damageDealt, int n, Object object) {
        if ((n & 8) != 0) {
            tile2 = null;
        }
        if ((n & 0x10) != 0) {
            damageDealt = null;
        }
        battle.postBattleNotifications$core(iCombatant, iCombatant2, tile, tile2, damageDealt);
    }

    private final void tryHealAfterKilling(ICombatant attacker) {
        if (!(attacker instanceof MapUnitCombatant)) {
            return;
        }
        Iterator iterator2 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)attacker).getUnit(), UniqueType.HealsAfterKilling, null, true, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            int amountToHeal = Integer.parseInt(unique.getParams().get(0));
            ((MapUnitCombatant)attacker).getUnit().healBy(amountToHeal);
        }
    }

    private final void postBattleMoveToAttackedTile(ICombatant attacker, ICombatant defender, Tile attackedTile) {
        if (!attacker.isMelee()) {
            return;
        }
        if (!defender.isDefeated() && !Intrinsics.areEqual(defender.getCivInfo(), attacker.getCivInfo())) {
            return;
        }
        if (!(attacker instanceof MapUnitCombatant)) {
            return;
        }
        if (((MapUnitCombatant)attacker).getUnit().getCache().getCannotMove()) {
            return;
        }
        if (!((MapUnitCombatant)attacker).getUnit().getMovement().canReachInCurrentTurn(attackedTile)) {
            return;
        }
        if (!UnitMovement.canMoveTo$default(((MapUnitCombatant)attacker).getUnit().getMovement(), attackedTile, false, false, false, 14, null)) {
            return;
        }
        ((MapUnitCombatant)attacker).getUnit().getMovement().moveToTile(attackedTile, false);
        ((MapUnitCombatant)attacker).getUnit().setMostRecentMoveType(UnitMovementMemoryType.UnitAttacked);
    }

    private final void postBattleAddXp(ICombatant attacker, ICombatant defender) {
        if (attacker.isAirUnit()) {
            Battle.postBattleAddXp$addXp(attacker, defender, 4, 2);
        } else if (attacker.isRanged()) {
            if (defender.isCity()) {
                Battle.postBattleAddXp$addXp(attacker, defender, 3, 2);
            } else {
                Battle.postBattleAddXp$addXp(attacker, defender, 2, 2);
            }
        } else if (!defender.isCivilian()) {
            Battle.postBattleAddXp$addXp(attacker, defender, 5, 4);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void addXp$core(@NotNull ICombatant thisCombatant, int amount, @NotNull ICombatant otherCombatant) {
        block13: {
            Intrinsics.checkNotNullParameter(thisCombatant, "thisCombatant");
            Intrinsics.checkNotNullParameter(otherCombatant, "otherCombatant");
            if (!(thisCombatant instanceof MapUnitCombatant)) {
                return;
            }
            civ = ((MapUnitCombatant)thisCombatant).getCivInfo();
            otherIsBarbarian = otherCombatant.getCivInfo().isBarbarian();
            promotions = ((MapUnitCombatant)thisCombatant).getUnit().getPromotions();
            modConstants = civ.getGameInfo().getRuleset().getModOptions().getConstants();
            if (otherIsBarbarian && promotions.totalXpProduced() >= modConstants.getMaxXPfromBarbarians()) {
                return;
            }
            unitCouldAlreadyPromote = promotions.canBePromoted();
            gameContext = new GameContext(civ, null, null, null, thisCombatant, otherCombatant, null, null, null, null, false, 1998, null);
            var11_10 = ((MapUnitCombatant)thisCombatant).getMatchingUniques(UniqueType.FlatXPGain, gameContext, true);
            var32_12 = amount;
            var12_15 = 0;
            var13_16 = var11_10.iterator();
            while (var13_16.hasNext()) {
                var15_24 = var14_22 = var13_16.next();
                var33_18 = var12_15;
                $i$a$-sumOfInt-Battle$addXp$baseXP$1 = false;
                var34_19 = Integer.parseInt(it.getParams().get(0));
                var12_15 = var33_18 + var34_19;
            }
            var33_18 = var12_15;
            baseXP = var32_12 + var33_18;
            var13_16 = ((MapUnitCombatant)thisCombatant).getMatchingUniques(UniqueType.PercentageXPGain, gameContext, true);
            var14_23 = 0.0;
            $i$a$-sumOfInt-Battle$addXp$baseXP$1 = var13_16.iterator();
            while ($i$a$-sumOfInt-Battle$addXp$baseXP$1.hasNext()) {
                var17_29 = $i$a$-sumOfInt-Battle$addXp$baseXP$1.next();
                var18_30 = (Unique)var17_29;
                var32_13 = var14_23;
                $i$a$-sumOfDouble-Battle$addXp$xpBonus$1 = false;
                var34_20 = Double.parseDouble(it.getParams().get(0));
                var14_23 = var32_13 + var34_20;
            }
            xpBonus = var14_23;
            xpModifier = 1.0 + xpBonus / (double)100;
            xpGained = (int)((double)baseXP * xpModifier);
            promotions.setXP(promotions.getXP() + xpGained);
            if (otherIsBarbarian || !civ.isMajorCiv()) break block13;
            var17_29 = civ.getGameInfo().getRuleset().getGreatGeneralUnits();
            $i$f$filter = false;
            $i$a$-sumOfDouble-Battle$addXp$xpBonus$1 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block12: {
                    it = (BaseUnit)element$iv$iv;
                    $i$a$-filter-Battle$addXp$greatGeneralUnits$1 = false;
                    if (!it.hasUnique(UniqueType.GreatPersonFromCombat, gameContext)) ** GOTO lbl-1000
                    Intrinsics.checkNotNull(it);
                    $this$none$iv = BaseUnit.getRejectionReasons$default(it, civ, null, null, 6, null);
                    $i$f$none = false;
                    var28_49 = $this$none$iv.iterator();
                    while (var28_49.hasNext()) {
                        element$iv = var28_49.next();
                        reason = (RejectionReason)element$iv;
                        $i$a$-none-Battle$addXp$greatGeneralUnits$1$1 = false;
                        if (!(reason.isConstructionRejection() == false && reason.techPolicyEraWonderRequirements() == false)) continue;
                        v0 = false;
                        break block12;
                    }
                    v0 = true;
                }
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            greatGeneralUnits /* !! */  = CollectionsKt.asSequence((List)destination$iv$iv);
            if (civ.getGameInfo().getRuleset().getGreatGeneralUnits().isEmpty() && civ.getGameInfo().getRuleset().getUnits().get("Great General") != null) {
                v2 = civ.getGameInfo().getRuleset().getUnits().get("Great General");
                Intrinsics.checkNotNull(v2);
                greatGeneralUnits /* !! */  = SequencesKt.plus(greatGeneralUnits /* !! */ , v2);
            }
            var17_29 = greatGeneralUnits /* !! */ .iterator();
            while (var17_29.hasNext()) {
                v3 = var17_29.next();
                Intrinsics.checkNotNullExpressionValue(v3, "next(...)");
                unit = (BaseUnit)v3;
                $i$f$filterTo = SequencesKt.filter(((MapUnitCombatant)thisCombatant).getMatchingUniques(UniqueType.GreatPersonEarnedFaster, gameContext, true), (Function1<Unique, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, addXp$lambda$3(com.unciv.models.ruleset.unit.BaseUnit com.unciv.models.ruleset.unique.GameContext com.unciv.models.ruleset.unique.Unique ), (Lcom/unciv/models/ruleset/unique/Unique;)Ljava/lang/Boolean;)((BaseUnit)unit, (GameContext)gameContext));
                var22_41 = 0.0;
                var24_44 = $i$f$filterTo.iterator();
                while (var24_44.hasNext()) {
                    $this$none$iv = var25_46 = var24_44.next();
                    var32_14 = var22_41;
                    $i$a$-sumOfDouble-Battle$addXp$greatGeneralPointsBonus$2 = false;
                    var34_21 = Double.parseDouble(it.getParams().get(1));
                    var22_41 = var32_14 + var34_21;
                }
                greatGeneralPointsBonus = var22_41;
                greatGeneralPointsModifier = 1.0 + greatGeneralPointsBonus / (double)100;
                greatGeneralPointsGained = (int)((double)xpGained * greatGeneralPointsModifier);
                var24_44 = civ.getGreatPeople().getGreatGeneralPointsCounter();
                var25_46 = unit.getName();
                ((Map)var24_44).put(var25_46, ((Number)var24_44.get(var25_46)).intValue() + greatGeneralPointsGained);
            }
        }
        if (!((MapUnitCombatant)thisCombatant).isDefeated() && !unitCouldAlreadyPromote && promotions.canBePromoted()) {
            pos = ((MapUnitCombatant)thisCombatant).getTile().getPosition();
            var17_29 = new NotificationAction[]{new MapUnitAction(pos, 0, 2, null), new PromoteUnitAction(((MapUnitCombatant)thisCombatant).getName(), pos)};
            v4 = CollectionsKt.listOf(var17_29);
            var17_29 = new String[]{((MapUnitCombatant)thisCombatant).getUnit().getName()};
            civ.addNotification('[' + ((MapUnitCombatant)thisCombatant).getUnit().displayName() + "] can be promoted!", v4, Notification.NotificationCategory.Units, (String[])var17_29);
        }
    }

    private final void reduceAttackerMovementPointsAndAttacks(ICombatant attacker, ICombatant defender, Tile attackedTile) {
        if (!(attacker instanceof MapUnitCombatant)) {
            if (attacker instanceof CityCombatant) {
                ((CityCombatant)attacker).getCity().setAttackedThisTurn(true);
            }
            return;
        }
        MapUnit unit = ((MapUnitCombatant)attacker).getUnit();
        if (defender.isCivilian() && Intrinsics.areEqual(((MapUnitCombatant)attacker).getTile(), defender.getTile())) {
            return;
        }
        GameContext gameContext = new GameContext(attacker, defender, attackedTile, CombatAction.Attack);
        unit.setAttacksThisTurn(unit.getAttacksThisTurn() + 1);
        if (MapUnit.hasUnique$default(unit, UniqueType.CanMoveAfterAttacking, gameContext, false, 4, null) || unit.maxAttacksPerTurn() > unit.getAttacksThisTurn()) {
            if (!(((MapUnitCombatant)attacker).getUnit().getBaseUnit().getMovesLikeAirUnits() || attacker.isMelee() && defender.isDefeated())) {
                unit.useMovementPoints(1.0f);
            }
        } else {
            unit.setCurrentMovement(0.0f);
        }
        if (unit.isFortified() || unit.isSleeping() || unit.isGuarding()) {
            ((MapUnitCombatant)attacker).getUnit().setAction(null);
        }
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private final void conquerCity(City city, MapUnitCombatant attacker) {
        block10: {
            block9: {
                attackerCiv = attacker.getCivInfo();
                var4_4 = new String[]{"OtherIcons/Pillage"};
                attackerCiv.addNotification("We have conquered the city of [" + city.getName() + "]!", city.getLocation(), Notification.NotificationCategory.War, (String[])var4_4);
                city.setHasJustBeenConquered(true);
                $this$conquerCity_u24lambda_u240 = var4_4 = city.getCenterTile();
                $i$a$-apply-Battle$conquerCity$1 = false;
                if ($this$conquerCity_u24lambda_u240.getMilitaryUnit() != null) {
                    v0 = $this$conquerCity_u24lambda_u240.getMilitaryUnit();
                    Intrinsics.checkNotNull(v0);
                    MapUnit.destroy$default(v0, false, 1, null);
                }
                if ($this$conquerCity_u24lambda_u240.getCivilianUnit() != null) {
                    v1 = attacker;
                    v2 = $this$conquerCity_u24lambda_u240.getCivilianUnit();
                    Intrinsics.checkNotNull(v2);
                    BattleUnitCapture.INSTANCE.captureCivilianUnit(v1, new MapUnitCombatant(v2), false);
                }
                for (MapUnit airUnit : CollectionsKt.toList((Iterable)$this$conquerCity_u24lambda_u240.getAirUnits())) {
                    MapUnit.destroy$default(airUnit, false, 1, null);
                }
                gameContext = new GameContext(attackerCiv, city, attacker.getUnit(), null, attacker, null, city.getCenterTile(), null, null, null, false, 1960, null);
                var5_5 = attacker.getMatchingUniques(UniqueType.CaptureCityPlunder, gameContext, true).iterator();
                while (var5_5.hasNext()) {
                    unique = var5_5.next();
                    if (attacker.getCivInfo().getGameInfo().getRuleset().getGameResource(unique.getParams().get(2)) == null) continue;
                    attackerCiv.addGameResource(resource, Integer.parseInt(unique.getParams().get(0)) * (int)city.getCityStats().getCurrentCityStats().get(Stat.valueOf(unique.getParams().get(1))));
                }
                if (attackerCiv.isBarbarian() || attackerCiv.isOneCityChallenger()) {
                    city.destroyCity(true);
                    return;
                }
                if (!city.isOriginalCapital() || !Intrinsics.areEqual(city.getFoundingCivObject(), attackerCiv)) break block9;
                city.puppetCity(attackerCiv);
                city.annexCity();
                break block10;
            }
            if (!attackerCiv.isHuman()) ** GOTO lbl-1000
            v3 = UncivGame.Companion.getCurrent().getWorldScreen();
            v4 = v3 != null && (v3 = v3.getAutoPlay()) != null ? !v3.isAutoPlayingAndFullAutoPlayAI() : false;
            if (v4) {
                attackerCiv.getPopupAlerts().add(new PopupAlert(AlertType.CityConquered, city.getId()));
            } else lbl-1000:
            // 2 sources

            {
                this.automateCityConquer(attackerCiv, city);
            }
        }
        if (attackerCiv.isCurrentPlayer()) {
            UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask("Conquer a city");
        }
        for (Unique unique : CollectionsKt.plus(Civilization.getTriggeredUniques$default(attackerCiv, UniqueType.TriggerUponConqueringCity, gameContext, null, 4, null), MapUnit.getTriggeredUniques$default(attacker.getUnit(), UniqueType.TriggerUponConqueringCity, gameContext, null, 4, null))) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, attacker.getUnit(), null, null, 12, null);
        }
    }

    private final void automateCityConquer(Civilization civInfo, City city) {
        if (!city.hasDiplomaticMarriage()) {
            Civilization civilization = city.getFoundingCivObject();
            Intrinsics.checkNotNull(civilization);
            Civilization foundingCiv = civilization;
            int valueAlliance = NextTurnAutomation.valueCityStateAlliance$core$default(NextTurnAutomation.INSTANCE, civInfo, foundingCiv, false, 4, null);
            if (civInfo.getHappiness() < 0) {
                valueAlliance -= civInfo.getHappiness();
            }
            if (foundingCiv.isCityState() && !Intrinsics.areEqual(city.getCiv(), civInfo) && !Intrinsics.areEqual(foundingCiv, civInfo) && !civInfo.isAtWarWith(foundingCiv) && valueAlliance > 0) {
                city.liberateCity(civInfo);
                return;
            }
        }
        city.puppetCity(civInfo);
        if ((city.getPopulation().getPopulation() < 4 || civInfo.isCityState()) && !Intrinsics.areEqual(city.getFoundingCivObject(), civInfo) && city.canBeDestroyed(true)) {
            if (!Civilization.hasUnique$default(civInfo, UniqueType.MayNotAnnexCities, null, 2, null)) {
                city.annexCity();
            }
            city.setBeingRazed(true);
        }
    }

    @Readonly
    @Nullable
    public final ICombatant getMapCombatantOfTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (tile.isCityCenter()) {
            City city = tile.getCity();
            Intrinsics.checkNotNull(city);
            return new CityCombatant(city);
        }
        if (tile.getMilitaryUnit() != null) {
            MapUnit mapUnit = tile.getMilitaryUnit();
            Intrinsics.checkNotNull(mapUnit);
            return new MapUnitCombatant(mapUnit);
        }
        if (tile.getCivilianUnit() != null) {
            MapUnit mapUnit = tile.getCivilianUnit();
            Intrinsics.checkNotNull(mapUnit);
            return new MapUnitCombatant(mapUnit);
        }
        return null;
    }

    public final void destroyIfDefeated(@NotNull Civilization attackedCiv, @NotNull Civilization attacker, @Nullable HexCoord notificationLocation) {
        Intrinsics.checkNotNullParameter(attackedCiv, "attackedCiv");
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (attackedCiv.isDefeated()) {
            if (attackedCiv.isCityState()) {
                attackedCiv.getCityStateFunctions().cityStateDestroyed(attacker);
            }
            attackedCiv.destroy(notificationLocation);
            attacker.getPopupAlerts().add(new PopupAlert(AlertType.Defeated, attackedCiv.getCivName()));
        }
    }

    public static /* synthetic */ void destroyIfDefeated$default(Battle battle, Civilization civilization, Civilization civilization2, HexCoord hexCoord, int n, Object object) {
        if ((n & 4) != 0) {
            hexCoord = null;
        }
        battle.destroyIfDefeated(civilization, civilization2, hexCoord);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasWithdrawnFromMeelee(ICombatant attacker, ICombatant defender, Tile attackedTile) {
        if (!(attacker instanceof MapUnitCombatant)) return false;
        if (!attacker.isMelee()) return false;
        if (!(defender instanceof MapUnitCombatant)) return false;
        Civilization civilization = ((MapUnitCombatant)defender).getCivInfo();
        MapUnitCombatant mapUnitCombatant = (MapUnitCombatant)defender;
        MapUnitCombatant mapUnitCombatant2 = (MapUnitCombatant)attacker;
        if (!MapUnit.hasUnique$default(((MapUnitCombatant)defender).getUnit(), UniqueType.WithdrawsBeforeMeleeCombat, new GameContext(civilization, null, null, attackedTile, mapUnitCombatant, mapUnitCombatant2, null, null, null, null, false, 1990, null), false, 4, null)) return false;
        if (!this.doWithdrawFromMeleeAbility((MapUnitCombatant)attacker, (MapUnitCombatant)defender)) return false;
        return true;
    }

    private final boolean doWithdrawFromMeleeAbility(MapUnitCombatant attacker, MapUnitCombatant defender) {
        Tile tile;
        if (defender.getUnit().isEmbarked()) {
            return false;
        }
        if (defender.getUnit().getCache().getCannotMove()) {
            return false;
        }
        if (defender.getUnit().isEscorting()) {
            return false;
        }
        if (defender.getUnit().isGuarding()) {
            return false;
        }
        Tile fromTile = defender.getTile();
        Tile attackerTile = attacker.getTile();
        Sequence<Tile> firstCandidateTiles = SequencesKt.filterNot(SequencesKt.filterNot(fromTile.getNeighbors(), arg_0 -> Battle.doWithdrawFromMeleeAbility$lambda$0(attackerTile, arg_0)), arg_0 -> Battle.doWithdrawFromMeleeAbility$lambda$1(defender, arg_0));
        Sequence<Tile> secondCandidateTiles = SequencesKt.filterNot(SequencesKt.filter(fromTile.getNeighbors(), arg_0 -> Battle.doWithdrawFromMeleeAbility$lambda$2(attackerTile, arg_0)), arg_0 -> Battle.doWithdrawFromMeleeAbility$lambda$3(defender, arg_0));
        if (SequencesKt.any(firstCandidateTiles)) {
            tile = (Tile)CollectionsKt.random((Collection)SequencesKt.toList(firstCandidateTiles), Random.Default);
        } else if (SequencesKt.any(secondCandidateTiles)) {
            tile = (Tile)CollectionsKt.random((Collection)SequencesKt.toList(secondCandidateTiles), Random.Default);
        } else {
            return false;
        }
        Tile toTile = tile;
        defender.getUnit().removeFromTile();
        defender.getUnit().putInTile(toTile);
        defender.getUnit().setMostRecentMoveType(UnitMovementMemoryType.UnitWithdrew);
        this.reduceAttackerMovementPointsAndAttacks(attacker, defender, fromTile);
        String attackerName = attacker.getName();
        String defenderName = defender.getName();
        String notificationString = '[' + defenderName + "] withdrew from a [" + attackerName + ']';
        Object[] objectArray = new HexCoord[]{toTile.getPosition(), attacker.getTile().getPosition()};
        Sequence<LocationAction> locations = LocationAction.Companion.invoke((HexCoord[])objectArray);
        objectArray = new String[]{defenderName, "OtherIcons/Pillage", attackerName};
        defender.getCivInfo().addNotification(notificationString, locations, Notification.NotificationCategory.War, (String[])objectArray);
        objectArray = new String[]{defenderName, "OtherIcons/Pillage", attackerName};
        attacker.getCivInfo().addNotification(notificationString, locations, Notification.NotificationCategory.War, (String[])objectArray);
        return true;
    }

    private final void doDestroyImprovementsAbility(MapUnitCombatant attacker, Tile attackedTile, ICombatant defender) {
        if (attackedTile.getImprovement() == null) {
            return;
        }
        Civilization civilization = attacker.getCivInfo();
        Object[] objectArray = CombatAction.Attack;
        GameContext conditionalState = new GameContext(civilization, null, null, null, attacker, defender, attackedTile, (CombatAction)objectArray, null, null, false, 1806, null);
        TileImprovement tileImprovement = attackedTile.getTileImprovement();
        Intrinsics.checkNotNull(tileImprovement);
        if (!IHasUniques.hasUnique$default(tileImprovement, UniqueType.Unpillagable, null, 2, null) && attacker.hasUnique(UniqueType.DestroysImprovementUponAttack, conditionalState)) {
            String currentTileImprovement = attackedTile.getImprovement();
            attackedTile.removeImprovement();
            objectArray = new HexCoord[]{attackedTile.getPosition(), attacker.getTile().getPosition()};
            Sequence<LocationAction> sequence = LocationAction.Companion.invoke((HexCoord[])objectArray);
            objectArray = new String[]{attacker.getUnit().getBaseUnit().getName(), "OtherIcons/Pillage"};
            defender.getCivInfo().addNotification("An enemy [" + attacker.getUnit().getBaseUnit().getName() + "] has destroyed our tile improvement [" + currentTileImprovement + ']', sequence, Notification.NotificationCategory.War, (String[])objectArray);
        }
    }

    private static final String handleCityDefeated$lambda$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getParams().get(0);
    }

    private static final boolean triggerVictoryUniques$lambda$0(MapUnitCombatant $enemy, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return MapUnit.matchesFilter$default($enemy.getUnit(), it.getParams().get(0), false, 2, null);
    }

    private static final boolean triggerDamageUniquesForUnit$lambda$0(MapUnitCombatant $enemy, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ICombatant.matchesFilter$default($enemy, it.getParams().get(0), false, 2, null);
    }

    private static final boolean takeDamage$lambda$0(int $defenderDamageDealt, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.parseInt(it.getParams().get(0)) <= $defenderDamageDealt;
    }

    private static final boolean takeDamage$lambda$1(int $attackerDamageDealt, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.parseInt(it.getParams().get(0)) <= $attackerDamageDealt;
    }

    private static final void postBattleAddXp$addXp(ICombatant $attacker, ICombatant $defender, int attackerXp, int defenderXp) {
        INSTANCE.addXp$core($attacker, attackerXp, $defender);
        INSTANCE.addXp$core($defender, defenderXp, $attacker);
    }

    private static final boolean addXp$lambda$3(BaseUnit $unit, GameContext $gameContext, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return BaseUnit.matchesFilter$default($unit, it.getParams().get(0), $gameContext, false, 4, null);
    }

    @Readonly
    private static final boolean doWithdrawFromMeleeAbility$canNotWithdrawTo(MapUnitCombatant $defender, Tile tile) {
        return !UnitMovement.canMoveTo$default($defender.getUnit().getMovement(), tile, false, false, false, 14, null) || $defender.isLandUnit() && !tile.isLand() || tile.isCityCenter() && !Intrinsics.areEqual(tile.getOwner(), $defender.getCivInfo());
    }

    private static final boolean doWithdrawFromMeleeAbility$lambda$0(Tile $attackerTile, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, $attackerTile) || SequencesKt.contains($attackerTile.getNeighbors(), it);
    }

    private static final boolean doWithdrawFromMeleeAbility$lambda$1(MapUnitCombatant $defender, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Battle.doWithdrawFromMeleeAbility$canNotWithdrawTo($defender, it);
    }

    private static final boolean doWithdrawFromMeleeAbility$lambda$2(Tile $attackerTile, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return SequencesKt.contains($attackerTile.getNeighbors(), it);
    }

    private static final boolean doWithdrawFromMeleeAbility$lambda$3(MapUnitCombatant $defender, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Battle.doWithdrawFromMeleeAbility$canNotWithdrawTo($defender, it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0087\u0002J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/battle/Battle$DamageDealt;", "", "attackerDealt", "", "defenderDealt", "<init>", "(II)V", "getAttackerDealt", "()I", "getDefenderDealt", "plus", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "Companion", "core"})
    public static final class DamageDealt {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int attackerDealt;
        private final int defenderDealt;
        @NotNull
        private static final DamageDealt None = new DamageDealt(0, 0);

        public DamageDealt(int attackerDealt, int defenderDealt) {
            this.attackerDealt = attackerDealt;
            this.defenderDealt = defenderDealt;
        }

        public final int getAttackerDealt() {
            return this.attackerDealt;
        }

        public final int getDefenderDealt() {
            return this.defenderDealt;
        }

        @Pure
        @NotNull
        public final DamageDealt plus(@NotNull DamageDealt other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return new DamageDealt(this.attackerDealt + other.attackerDealt, this.defenderDealt + other.defenderDealt);
        }

        public final int component1() {
            return this.attackerDealt;
        }

        public final int component2() {
            return this.defenderDealt;
        }

        @NotNull
        public final DamageDealt copy(int attackerDealt, int defenderDealt) {
            return new DamageDealt(attackerDealt, defenderDealt);
        }

        public static /* synthetic */ DamageDealt copy$default(DamageDealt damageDealt, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = damageDealt.attackerDealt;
            }
            if ((n3 & 2) != 0) {
                n2 = damageDealt.defenderDealt;
            }
            return damageDealt.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "DamageDealt(attackerDealt=" + this.attackerDealt + ", defenderDealt=" + this.defenderDealt + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.attackerDealt);
            result2 = result2 * 31 + Integer.hashCode(this.defenderDealt);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DamageDealt)) {
                return false;
            }
            DamageDealt damageDealt = (DamageDealt)other;
            if (this.attackerDealt != damageDealt.attackerDealt) {
                return false;
            }
            return this.defenderDealt == damageDealt.defenderDealt;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/battle/Battle$DamageDealt$Companion;", "", "<init>", "()V", "None", "Lcom/unciv/logic/battle/Battle$DamageDealt;", "getNone", "()Lcom/unciv/logic/battle/Battle$DamageDealt;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DamageDealt getNone() {
                return None;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

