/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.tile.Tile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Immutable;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0003J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0007J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0007J\u001a\u0010\u0019\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\u001a\u001a\u00020\u0007H\u0007J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0007J \u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\nH\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0007J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0007J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J.\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0007J&\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120,2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0007J\u0018\u00103\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0005H\u0007J\u0018\u00103\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0012H\u0007J(\u00103\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\nH\u0007J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\nH\u0007J\u0010\u0010@\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\nH\u0007J\u0018\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020DH\u0007J\u0018\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\nH\u0007J\u0016\u0010H\u001a\u00020\n2\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\nJ\u0016\u0010I\u001a\u00020\n2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020KR\"\u00109\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120:8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b;\u0010\u0003R\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050:8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b?\u0010\u0003\u00a8\u0006M"}, d2={"Lcom/unciv/logic/map/HexMath;", "", "<init>", "()V", "getVectorForAngle", "Lcom/badlogic/gdx/math/Vector2;", "angle", "", "getVectorByClockHour", "hour", "", "getNumberOfTilesInHexagon", "size", "getHexagonalRadiusForArea", "numberOfTiles", "getLatitude", "vector", "hexCoord", "Lcom/unciv/logic/map/HexCoord;", "getLongitude", "hexFromLatLong", "latitude", "longitude", "worldFromLatLong", "tileRadius", "getEquivalentRectangularSize", "ratio", "getEquivalentHexagonalRadius", "width", "height", "getUnwrappedNearestTo", "unwrapHexCoord", "staticHexCoord", "longitudinalRadius", "hex2WorldCoords", "world2HexCoords", "worldCoord", "getRow", "getColumn", "getTileCoordsFromColumnRow", "column", "row", "roundHexCoords", "getHexCoordsAtDistance", "", "origin", "distance", "maxDistance", "worldWrap", "", "getHexCoordsInDistance", "getDistance", "destination", "originX", "originY", "destinationX", "destinationY", "clockPositionToHexcoordMap", "", "getClockPositionToHexcoordMap$annotations", "getClockPositionToHexcoord", "clockPosition", "clockPositionToWorldVectorMap", "getClockPositionToWorldVectorMap$annotations", "getClockPositionToWorldVector", "getDistanceFromEdge", "position", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "getZeroBasedIndex", "x", "y", "mapRelativePositionToPositiveIntRedblob", "tilesAndNeighborUniqueIndex", "tile", "Lcom/unciv/logic/map/tile/Tile;", "neighbor", "core"})
public final class HexMath {
    @NotNull
    public static final HexMath INSTANCE = new HexMath();
    @NotNull
    private static final Map<Integer, HexCoord> clockPositionToHexcoordMap;
    @NotNull
    private static final Map<Integer, Vector2> clockPositionToWorldVectorMap;

    private HexMath() {
    }

    @Pure
    @NotNull
    public final Vector2 getVectorForAngle(float angle) {
        return new Vector2((float)Math.sin(angle), (float)Math.cos(angle));
    }

    @Pure
    private final Vector2 getVectorByClockHour(int hour2) {
        return this.getVectorForAngle((float)(Math.PI * 2 * (double)((float)hour2 / 12.0f)));
    }

    @Pure
    public final int getNumberOfTilesInHexagon(int size) {
        if (size < 0) {
            return 0;
        }
        return 1 + 6 * size * (size + 1) / 2;
    }

    @Pure
    public final float getHexagonalRadiusForArea(int numberOfTiles) {
        return numberOfTiles < 1 ? 0.0f : ((float)Math.sqrt(12.0f * (float)numberOfTiles - (float)3) - (float)3) / (float)6;
    }

    @Readonly
    public final int getLatitude(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return (int)vector.x + (int)vector.y;
    }

    @Readonly
    public final int getLatitude(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return hexCoord.getX() + hexCoord.getY();
    }

    @Readonly
    public final int getLongitude(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return (int)vector.x - (int)vector.y;
    }

    @Readonly
    public final int getLongitude(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return hexCoord.getX() - hexCoord.getY();
    }

    @Pure
    @NotNull
    public final Vector2 hexFromLatLong(int latitude, int longitude) {
        float y = (float)(latitude - longitude) / 2.0f;
        float x = (float)longitude + y;
        return new Vector2(x, y);
    }

    @Readonly
    @NotNull
    public final Vector2 worldFromLatLong(@NotNull Vector2 vector, float tileRadius) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        float x = vector.x * tileRadius * 1.5f * -1.0f;
        float y = vector.y * tileRadius * (float)Math.sqrt(3.0f) * 0.5f;
        return new Vector2(x, y);
    }

    @Pure
    @NotNull
    public final HexCoord getEquivalentRectangularSize(int size, float ratio) {
        if (size < 0) {
            return HexCoord.Companion.of(0, 0);
        }
        int nTiles = this.getNumberOfTilesInHexagon(size);
        int width = MathKt.roundToInt((float)Math.sqrt((float)nTiles / ratio));
        int height = MathKt.roundToInt((float)width * ratio);
        return HexCoord.Companion.of(width, height);
    }

    public static /* synthetic */ HexCoord getEquivalentRectangularSize$default(HexMath hexMath, int n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.65f;
        }
        return hexMath.getEquivalentRectangularSize(n, f);
    }

    @Pure
    public final int getEquivalentHexagonalRadius(int width, int height) {
        return MathKt.roundToInt(this.getHexagonalRadiusForArea(width * height));
    }

    @Readonly
    @NotNull
    public final Vector2 getUnwrappedNearestTo(@NotNull HexCoord unwrapHexCoord, @NotNull HexCoord staticHexCoord, int longitudinalRadius) {
        Intrinsics.checkNotNullParameter(unwrapHexCoord, "unwrapHexCoord");
        Intrinsics.checkNotNullParameter(staticHexCoord, "staticHexCoord");
        int referenceLong = this.getLongitude(staticHexCoord);
        int toWrapLat = this.getLatitude(unwrapHexCoord);
        int toWrapLong = this.getLongitude(unwrapHexCoord);
        int n = toWrapLong - referenceLong + longitudinalRadius;
        int n2 = longitudinalRadius * 2;
        int n3 = n % n2;
        return this.hexFromLatLong(toWrapLat, n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31) - longitudinalRadius + referenceLong);
    }

    @Readonly
    @NotNull
    public final Vector2 hex2WorldCoords(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        Vector2 xVector = this.getVectorByClockHour(10);
        xVector.scl((float)Math.sqrt(3.0) * (float)hexCoord.getX());
        Vector2 yVector = this.getVectorByClockHour(2);
        yVector.scl((float)Math.sqrt(3.0) * (float)hexCoord.getY());
        Vector2 vector2 = xVector.add(yVector);
        Intrinsics.checkNotNullExpressionValue(vector2, "add(...)");
        return vector2;
    }

    @Readonly
    @NotNull
    public final Vector2 world2HexCoords(@NotNull Vector2 worldCoord) {
        Intrinsics.checkNotNullParameter(worldCoord, "worldCoord");
        Vector2 D = this.getVectorByClockHour(10);
        D.scl((float)Math.sqrt(3.0));
        Vector2 A = this.getVectorByClockHour(2);
        A.scl((float)Math.sqrt(3.0));
        float den = D.x * A.y - D.y * A.x;
        float x = (worldCoord.x * A.y - worldCoord.y * A.x) / den;
        float y = (worldCoord.y * D.x - worldCoord.x * D.y) / den;
        return new Vector2(x, y);
    }

    @Readonly
    public final int getRow(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return (int)(hexCoord.x / (float)2 + hexCoord.y / (float)2);
    }

    @Readonly
    public final int getRow(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return (hexCoord.getX() + hexCoord.getY()) / 2;
    }

    @Readonly
    public final int getColumn(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return (int)(hexCoord.y - hexCoord.x);
    }

    @Readonly
    public final int getColumn(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return hexCoord.getY() - hexCoord.getX();
    }

    @Pure
    @NotNull
    public final HexCoord getTileCoordsFromColumnRow(int column, int row) {
        int twoRows = row * 2;
        if (Math.abs(column) % 2 == 1) {
            ++twoRows;
        }
        return HexCoord.Companion.of((twoRows - column) / 2, (twoRows + column) / 2);
    }

    @Readonly
    @NotNull
    public final Vector2 roundHexCoords(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return HexMath.roundHexCoords$cubic2HexCoords(HexMath.roundHexCoords$roundCubicCoords(HexMath.roundHexCoords$hex2CubicCoords(hexCoord)));
    }

    @Readonly
    @NotNull
    public final List<HexCoord> getHexCoordsAtDistance(@NotNull HexCoord origin2, int distance, int maxDistance, boolean worldWrap) {
        int i;
        Intrinsics.checkNotNullParameter(origin2, "origin");
        List vectors = new ArrayList();
        if (distance == 0) {
            return CollectionsKt.listOf(origin2.cpy());
        }
        HexCoord current = origin2.minus(HexCoord.Companion.of(distance, distance));
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current);
            ((Collection)vectors).add(HexMath.getHexCoordsAtDistance$getHexcoordOnOtherSideOfClock(origin2, current));
            current = current.plus(1, 0);
        }
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            if (!worldWrap || distance != maxDistance) {
                ((Collection)vectors).add(HexMath.getHexCoordsAtDistance$getHexcoordOnOtherSideOfClock(origin2, current));
            }
            current = current.plus(1, 1);
        }
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            if (!worldWrap || distance != maxDistance || i != 0) {
                ((Collection)vectors).add(HexMath.getHexCoordsAtDistance$getHexcoordOnOtherSideOfClock(origin2, current));
            }
            current = current.plus(0, 1);
        }
        return vectors;
    }

    @Readonly
    @NotNull
    public final List<HexCoord> getHexCoordsInDistance(@NotNull HexCoord origin2, int distance, boolean worldWrap) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        List hexesToReturn = new ArrayList();
        int i = 0;
        if (i <= distance) {
            while (true) {
                CollectionsKt.addAll((Collection)hexesToReturn, (Iterable)this.getHexCoordsAtDistance(origin2, i, distance, worldWrap));
                if (i == distance) break;
                ++i;
            }
        }
        return hexesToReturn;
    }

    @Pure
    public final int getDistance(@NotNull Vector2 origin2, @NotNull Vector2 destination) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Intrinsics.checkNotNullParameter(destination, "destination");
        return this.getDistance((int)origin2.x, (int)origin2.y, (int)destination.x, (int)destination.y);
    }

    @Pure
    public final int getDistance(@NotNull HexCoord origin2, @NotNull HexCoord destination) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Intrinsics.checkNotNullParameter(destination, "destination");
        return this.getDistance(origin2.getX(), origin2.getY(), destination.getX(), destination.getY());
    }

    @Pure
    public final int getDistance(int originX, int originY, int destinationX, int destinationY) {
        int relativeX = originX - destinationX;
        int relativeY = originY - destinationY;
        return relativeX * relativeY >= 0 ? Math.max(Math.abs(relativeX), Math.abs(relativeY)) : Math.abs(relativeX) + Math.abs(relativeY);
    }

    @Immutable
    private static /* synthetic */ void getClockPositionToHexcoordMap$annotations() {
    }

    @Pure
    @NotNull
    public final HexCoord getClockPositionToHexcoord(int clockPosition) {
        HexCoord hexCoord = clockPositionToHexcoordMap.get(clockPosition);
        if (hexCoord == null) {
            hexCoord = HexCoord.Companion.getZero();
        }
        return hexCoord;
    }

    @Immutable
    private static /* synthetic */ void getClockPositionToWorldVectorMap$annotations() {
    }

    @Pure
    @NotNull
    public final Vector2 getClockPositionToWorldVector(int clockPosition) {
        Vector2 vector2 = clockPositionToWorldVectorMap.get(clockPosition);
        if (vector2 == null) {
            Vector2 vector22 = Vector2.Zero;
            vector2 = vector22;
            Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
        }
        return vector2;
    }

    @Readonly
    public final int getDistanceFromEdge(@NotNull HexCoord position, @NotNull MapParameters mapParameters) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        int x = position.getX();
        int y = position.getY();
        if (Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            int height = mapParameters.getMapSize().getHeight();
            int width = mapParameters.getMapSize().getWidth();
            int left = mapParameters.getWorldWrap() ? Integer.MAX_VALUE : width / 2 - (x - y);
            int right = mapParameters.getWorldWrap() ? Integer.MAX_VALUE : (width - 1) / 2 - (y - x);
            int top = height / 2 - (x + y) / 2;
            int bottom = (x + y - 1) / 2 + (height - 1) / 2;
            int[] nArray = new int[]{right, top, bottom};
            return ComparisonsKt.minOf(left, nArray);
        }
        int radius = mapParameters.getMapSize().getRadius();
        if (!mapParameters.getWorldWrap()) {
            return radius - this.getDistance(position, HexCoord.Companion.getZero());
        }
        if (MathKt.getSign(x) == MathKt.getSign(y)) {
            return radius - this.getDistance(position, HexCoord.Companion.getZero());
        }
        if (x > 0) {
            return Math.min(this.getDistance(position, HexCoord.Companion.of(radius, 0)), this.getDistance(position, HexCoord.Companion.of(0, -radius)));
        }
        return Math.min(this.getDistance(position, HexCoord.Companion.of(1, radius)), this.getDistance(position, HexCoord.Companion.of(-radius, -1)));
    }

    @Pure
    public final int getZeroBasedIndex(int x, int y) {
        int n;
        if (x == 0 && y == 0) {
            return 0;
        }
        int ring = this.getDistance(0, 0, x, y);
        int ringStart = 1 + 6 * ring * (ring - 1) / 2;
        int n2 = ring;
        if (n2 == y) {
            n = 0 + x;
        } else if (n2 == x) {
            n = ring + 1 + y;
        } else if (n2 == -x) {
            n = 2 * ring + 1 - y;
        } else if (n2 == -y) {
            n = 3 * ring + 2 - x;
        } else if (n2 == x - y) {
            n = 4 * ring + 2 + x - 1;
        } else if (n2 == y - x) {
            n = 5 * ring + 1 + y - 1;
        } else {
            throw new Exception("How???");
        }
        int positionInRing = n;
        return ringStart + positionInRing;
    }

    public final int mapRelativePositionToPositiveIntRedblob(int x, int y) {
        if (x == 0 && y == 0) {
            return 0;
        }
        int ring = this.getDistance(0, 0, x, y);
        int ringStart = 1 + 6 * ring * (ring - 1) / 2;
        List<HexCoord> vectorsInRing = this.getHexCoordsAtDistance(HexCoord.Companion.getZero(), ring, ring, false);
        int positionInRing = vectorsInRing.indexOf(HexCoord.Companion.of(x, y));
        return ringStart + positionInRing;
    }

    public final int tilesAndNeighborUniqueIndex(@NotNull Tile tile, @NotNull Tile neighbor) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(neighbor, "neighbor");
        return tile.getZeroBasedIndex() * 6 + tile.getTileMap().getNeighborTileClockPosition(tile, neighbor) / 2 - 1;
    }

    @Readonly
    private static final Vector3 roundHexCoords$roundCubicCoords(Vector3 cubicCoords) {
        float rx = (float)Math.rint(cubicCoords.x);
        float ry = (float)Math.rint(cubicCoords.y);
        float rz = (float)Math.rint(cubicCoords.z);
        float deltaX = Math.abs(rx - cubicCoords.x);
        float deltaY = Math.abs(ry - cubicCoords.y);
        float deltaZ = Math.abs(rz - cubicCoords.z);
        if (deltaX > deltaY && deltaX > deltaZ) {
            rx = -ry - rz;
        } else if (deltaY > deltaZ) {
            ry = -rx - rz;
        } else {
            rz = -rx - ry;
        }
        return new Vector3(rx, ry, rz);
    }

    @Readonly
    private static final Vector3 roundHexCoords$hex2CubicCoords(Vector2 hexCoord) {
        return new Vector3(hexCoord.y - hexCoord.x, hexCoord.x, -hexCoord.y);
    }

    @Readonly
    private static final Vector2 roundHexCoords$cubic2HexCoords(Vector3 cubicCoord) {
        return new Vector2(cubicCoord.y, -cubicCoord.z);
    }

    @Readonly
    private static final HexCoord getHexCoordsAtDistance$getHexcoordOnOtherSideOfClock(HexCoord $origin, HexCoord vector) {
        return $origin.times(2).minus(vector);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(0, HexCoord.Companion.of(1, 1)), TuplesKt.to(12, HexCoord.Companion.of(1, 1)), TuplesKt.to(2, HexCoord.Companion.of(0, 1)), TuplesKt.to(4, HexCoord.Companion.of(-1, 0)), TuplesKt.to(6, HexCoord.Companion.of(-1, -1)), TuplesKt.to(8, HexCoord.Companion.of(0, -1)), TuplesKt.to(10, HexCoord.Companion.of(1, 0))};
        clockPositionToHexcoordMap = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(2, INSTANCE.hex2WorldCoords(HexCoord.Companion.of(0, -1))), TuplesKt.to(4, INSTANCE.hex2WorldCoords(HexCoord.Companion.of(1, 0))), TuplesKt.to(6, INSTANCE.hex2WorldCoords(HexCoord.Companion.of(1, 1))), TuplesKt.to(8, INSTANCE.hex2WorldCoords(HexCoord.Companion.of(0, 1))), TuplesKt.to(10, INSTANCE.hex2WorldCoords(HexCoord.Companion.of(-1, 0))), TuplesKt.to(12, INSTANCE.hex2WorldCoords(HexCoord.Companion.of(-1, -1)))};
        clockPositionToWorldVectorMap = MapsKt.mapOf(pairArray);
    }
}

