/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.HexMathKt;
import com.unciv.logic.map.mapgenerator.mapregions.MapGenTileData;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapgenerator.mapregions.TileDataMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ>\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013H\u0002J>\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013H\u0002J0\u0010\u0017\u001a\u00020\u00052\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006!"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/RegionStartFinder;", "", "<init>", "()V", "findStart", "", "region", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "tileData", "Lcom/unciv/logic/map/mapgenerator/mapregions/TileDataMap;", "findStart$core", "findGoodPosition", "", "centerTiles", "", "Lcom/unciv/logic/map/tile/Tile;", "fallbackTiles", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/HexCoord;", "Lkotlin/collections/HashSet;", "findEdgePosition", "outerDonut", "Lkotlin/sequences/Sequence;", "findFallbackPosition", "getCentralRectangle", "Lcom/badlogic/gdx/math/Rectangle;", "originalRect", "proportion", "", "evaluateTileForStart", "tile", "setRegionStart", "position", "core"})
@SourceDebugExtension(value={"SMAP\nRegionStartFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionStartFinder.kt\ncom/unciv/logic/map/mapgenerator/mapregions/RegionStartFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1761#2,3:238\n774#2:241\n865#2,2:242\n1999#2,14:244\n1999#2,14:258\n1761#2,3:272\n774#2:275\n865#2,2:276\n2423#2,14:278\n1999#2,14:292\n1999#2,14:306\n230#2,2:320\n*S KotlinDebug\n*F\n+ 1 RegionStartFinder.kt\ncom/unciv/logic/map/mapgenerator/mapregions/RegionStartFinder\n*L\n66#1:238,3\n68#1:241\n68#1:242,2\n68#1:244,14\n72#1:258,14\n94#1:272,3\n97#1:275\n97#1:276,2\n98#1:278,14\n115#1:292,14\n125#1:306,14\n133#1:320,2\n*E\n"})
public final class RegionStartFinder {
    @NotNull
    public static final RegionStartFinder INSTANCE = new RegionStartFinder();

    private RegionStartFinder() {
    }

    public final void findStart$core(@NotNull Region region, @NotNull TileDataMap tileData) {
        Intrinsics.checkNotNullParameter(region, "region");
        Intrinsics.checkNotNullParameter(tileData, "tileData");
        HashSet<HexCoord> fallbackTiles = new HashSet<HexCoord>();
        Set<Tile> centerTiles = SequencesKt.toSet(region.getTileMap().getTilesInRectangle(this.getCentralRectangle(region.getRect(), 0.33f)));
        if (this.findGoodPosition(centerTiles, region, tileData, fallbackTiles)) {
            return;
        }
        Set<Tile> middleDonut = SequencesKt.toSet(SequencesKt.filterNot(region.getTileMap().getTilesInRectangle(this.getCentralRectangle(region.getRect(), 0.67f)), arg_0 -> RegionStartFinder.findStart$lambda$0(centerTiles, arg_0)));
        if (this.findGoodPosition(middleDonut, region, tileData, fallbackTiles)) {
            return;
        }
        Sequence<Tile> outerDonut = SequencesKt.filterNot(region.getTileMap().getTilesInRectangle(region.getRect()), arg_0 -> RegionStartFinder.findStart$lambda$1(centerTiles, middleDonut, arg_0));
        if (this.findEdgePosition(outerDonut, region, tileData, fallbackTiles)) {
            return;
        }
        this.findFallbackPosition(fallbackTiles, tileData, region);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findGoodPosition(Set<Tile> centerTiles, Region region, TileDataMap tileData, HashSet<HexCoord> fallbackTiles) {
        HashSet<HexCoord> riverTiles = new HashSet<HexCoord>();
        HashSet<HexCoord> wetTiles = new HashSet<HexCoord>();
        HashSet<HexCoord> dryTiles = new HashSet<HexCoord>();
        for (Tile tile : centerTiles) {
            Object object = tileData.get((Object)tile.getPosition());
            Intrinsics.checkNotNull(object);
            if (((MapGenTileData)object).isTwoFromCoast() || region.getContinentID() != -1 && region.getContinentID() != tile.getContinent() || !tile.isLand() || tile.isImpassible()) continue;
            this.evaluateTileForStart(tile, tileData);
            boolean bl = tile.isAdjacentToRiver() ? riverTiles.add(tile.getPosition()) : (tile.isCoastalTile() || Tile.isAdjacentTo$default(tile, "Fresh water", null, 2, null) ? wetTiles.add(tile.getPosition()) : dryTiles.add(tile.getPosition()));
        }
        HashSet[] hashSetArray = new HashSet[]{riverTiles, wetTiles, dryTiles};
        Iterator<Tile> iterator2 = SequencesKt.sequenceOf(hashSetArray).iterator();
        while (iterator2.hasNext()) {
            Object e;
            Object maxElem$iv;
            Iterator iterator$iv;
            Iterable $this$maxByOrNull$iv;
            boolean $i$f$maxByOrNull;
            Object object;
            HexCoord it;
            boolean bl;
            Iterable $this$any$iv;
            HashSet hashSet;
            block17: {
                hashSet = (HashSet)((Object)iterator2.next());
                $this$any$iv = hashSet;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (HexCoord)element$iv;
                        boolean bl2 = false;
                        Object object2 = tileData.get((Object)it);
                        Intrinsics.checkNotNull(object2);
                        if (!((MapGenTileData)object2).isGoodStart()) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Object v5;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$any$iv = hashSet;
                Region region2 = region;
                object = this;
                boolean $i$f$filter = false;
                Iterator iterator3 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    HexCoord it2 = (HexCoord)element$iv$iv;
                    boolean bl3 = false;
                    Object object3 = tileData.get((Object)it2);
                    Intrinsics.checkNotNull(object3);
                    if (!((MapGenTileData)object3).isGoodStart()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                $this$filter$iv = list2;
                $i$f$maxByOrNull = false;
                iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v5 = null;
                } else {
                    maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v5 = maxElem$iv;
                    } else {
                        HexCoord it3 = (HexCoord)maxElem$iv;
                        boolean bl4 = false;
                        Object object4 = tileData.get((Object)it3);
                        Intrinsics.checkNotNull(object4);
                        int maxValue$iv = ((MapGenTileData)object4).getStartScore();
                        do {
                            Object e$iv = iterator$iv.next();
                            HexCoord it4 = (HexCoord)e$iv;
                            boolean bl2 = false;
                            Object object5 = tileData.get((Object)it4);
                            Intrinsics.checkNotNull(object5);
                            int v$iv = ((MapGenTileData)object5).getStartScore();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v5 = maxElem$iv;
                    }
                }
                List list3 = list2 = v5;
                Intrinsics.checkNotNull(list3);
                super.setRegionStart(region2, (HexCoord)((Object)list3), tileData);
                return true;
            }
            if (!(!((Collection)hashSet).isEmpty())) continue;
            $this$maxByOrNull$iv = hashSet;
            object = fallbackTiles;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                e = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    e = maxElem$iv;
                } else {
                    it = (HexCoord)maxElem$iv;
                    boolean bl5 = false;
                    Object object6 = tileData.get((Object)it);
                    Intrinsics.checkNotNull(object6);
                    int maxValue$iv = ((MapGenTileData)object6).getStartScore();
                    do {
                        Object e$iv = iterator$iv.next();
                        HexCoord it5 = (HexCoord)e$iv;
                        boolean bl3 = false;
                        Object object7 = tileData.get((Object)it5);
                        Intrinsics.checkNotNull(object7);
                        int v$iv = ((MapGenTileData)object7).getStartScore();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    e = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(e);
            ((HashSet)object).add(e);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean findEdgePosition(Sequence<Tile> outerDonut, Region region, TileDataMap tileData, HashSet<HexCoord> fallbackTiles) {
        Object center;
        Object it;
        boolean bl;
        HashSet<HexCoord> dryTiles;
        block21: {
            dryTiles = new HashSet<HexCoord>();
            Iterator<Tile> iterator2 = outerDonut.iterator();
            while (iterator2.hasNext()) {
                Tile tile = iterator2.next();
                if (region.getContinentID() != -1 && region.getContinentID() != tile.getContinent() || !tile.isLand() || tile.isImpassible()) continue;
                this.evaluateTileForStart(tile, tileData);
                dryTiles.add(tile.getPosition());
            }
            Iterable $this$any$iv = dryTiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (HexCoord)element$iv;
                    boolean bl2 = false;
                    Object object = tileData.get(it);
                    Intrinsics.checkNotNull(object);
                    if (!((MapGenTileData)object).isGoodStart()) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        if (bl) {
            Object v3;
            void $this$minByOrNull$iv;
            void $this$filterTo$iv$iv;
            center = region.getRect().getCenter(new Vector2());
            Iterable $this$filter$iv = dryTiles;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HexCoord it2 = (HexCoord)element$iv$iv;
                boolean bl3 = false;
                Object object = tileData.get((Object)it2);
                Intrinsics.checkNotNull(object);
                if (!((MapGenTileData)object).isGoodStart()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    Tile tile;
                    HexCoord it3 = (HexCoord)minElem$iv;
                    boolean bl4 = false;
                    Tile tile2 = region.getTileMap().getIfTileExistsOrNull(MathKt.roundToInt(((Vector2)center).x), MathKt.roundToInt(((Vector2)center).y));
                    if (tile2 == null) {
                        tile2 = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                    }
                    if ((tile = region.getTileMap().getIfTileExistsOrNull(it3.getX(), it3.getY())) == null) {
                        tile = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                    }
                    int minValue$iv = tile2.aerialDistanceTo(tile);
                    do {
                        int v$iv;
                        Tile tile3;
                        Object e$iv = iterator$iv.next();
                        HexCoord it4 = (HexCoord)e$iv;
                        $i$a$-minByOrNull-RegionStartFinder$findEdgePosition$closestToCenter$2 = false;
                        Tile tile4 = region.getTileMap().getIfTileExistsOrNull(MathKt.roundToInt(((Vector2)center).x), MathKt.roundToInt(((Vector2)center).y));
                        if (tile4 == null) {
                            tile4 = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                        }
                        if ((tile3 = region.getTileMap().getIfTileExistsOrNull(it4.getX(), it4.getY())) == null) {
                            tile3 = (Tile)CollectionsKt.first((Iterable)region.getTileMap().getValues());
                        }
                        if (minValue$iv <= (v$iv = tile4.aerialDistanceTo(tile3))) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v3);
            HexCoord closestToCenter = v3;
            this.setRegionStart(region, closestToCenter, tileData);
            return true;
        }
        if (!((Collection)dryTiles).isEmpty()) {
            Object e;
            void $this$maxByOrNull$iv;
            center = dryTiles;
            HashSet<HexCoord> hashSet = fallbackTiles;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                e = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    e = maxElem$iv;
                } else {
                    it = (HexCoord)maxElem$iv;
                    boolean bl5 = false;
                    Object object = tileData.get(it);
                    Intrinsics.checkNotNull(object);
                    int maxValue$iv = ((MapGenTileData)object).getStartScore();
                    do {
                        Object e$iv = iterator$iv.next();
                        HexCoord it5 = (HexCoord)e$iv;
                        $i$a$-maxByOrNull-RegionStartFinder$findEdgePosition$2 = false;
                        Object object2 = tileData.get((Object)it5);
                        Intrinsics.checkNotNull(object2);
                        int v$iv = ((MapGenTileData)object2).getStartScore();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    e = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(e);
            hashSet.add((HexCoord)e);
        }
        return false;
    }

    private final void findFallbackPosition(HashSet<HexCoord> fallbackTiles, TileDataMap tileData, Region region) {
        Object element$iv2;
        HexCoord panicPosition;
        block7: {
            Object v0;
            Iterable $this$maxByOrNull$iv = fallbackTiles;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    HexCoord it = (HexCoord)maxElem$iv;
                    boolean bl = false;
                    Object object = tileData.get((Object)it);
                    Intrinsics.checkNotNull(object);
                    int maxValue$iv = ((MapGenTileData)object).getStartScore();
                    do {
                        Object e$iv = iterator$iv.next();
                        HexCoord it2 = (HexCoord)e$iv;
                        $i$a$-maxByOrNull-RegionStartFinder$findFallbackPosition$fallbackPosition$1 = false;
                        Object object2 = tileData.get((Object)it2);
                        Intrinsics.checkNotNull(object2);
                        int v$iv = ((MapGenTileData)object2).getStartScore();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            HexCoord fallbackPosition = v0;
            if (fallbackPosition != null) {
                this.setRegionStart(region, fallbackPosition, tileData);
                return;
            }
            Vector2 vector2 = region.getRect().getPosition(new Vector2());
            Intrinsics.checkNotNullExpressionValue(vector2, "getPosition(...)");
            panicPosition = HexMathKt.toHexCoord(vector2);
            Ruleset ruleset = region.getTileMap().getRuleset();
            Intrinsics.checkNotNull(ruleset);
            Collection<Terrain> collection = ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$first$iv = collection;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Terrain it = (Terrain)element$iv2;
                boolean bl = false;
                if (!(it.getType() == TerrainType.Land)) continue;
                break block7;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        String panicTerrain = ((Terrain)element$iv2).getName();
        region.getTileMap().get(panicPosition).setBaseTerrain(panicTerrain);
        region.getTileMap().get(panicPosition).setTerrainFeatures(CollectionsKt.emptyList());
        this.setRegionStart(region, panicPosition, tileData);
    }

    @Pure
    private final Rectangle getCentralRectangle(Rectangle originalRect, float proportion) {
        Rectangle scaledRect = new Rectangle(originalRect);
        scaledRect.width = originalRect.width * proportion;
        scaledRect.height = originalRect.height * proportion;
        scaledRect.x = originalRect.x + (originalRect.width - scaledRect.width) / (float)2;
        scaledRect.y = originalRect.y + (originalRect.height - scaledRect.height) / (float)2;
        scaledRect.x = MathKt.roundToInt(scaledRect.x);
        scaledRect.y = MathKt.roundToInt(scaledRect.y);
        scaledRect.width = MathKt.roundToInt(scaledRect.width);
        scaledRect.height = MathKt.roundToInt(scaledRect.height);
        return scaledRect;
    }

    private final void evaluateTileForStart(Tile tile, TileDataMap tileData) {
        Object object = tileData.get((Object)tile.getPosition());
        Intrinsics.checkNotNull(object);
        MapGenTileData localData = (MapGenTileData)object;
        int totalFood = 0;
        int totalProd = 0;
        int totalGood = 0;
        int totalJunk = 0;
        int totalRivers = 0;
        int totalScore = 0;
        if (tile.isCoastalTile()) {
            totalScore += 40;
        }
        block4: for (int ring = 1; ring < 4; ++ring) {
            block17: {
                block16: {
                    Iterator<Tile> iterator2 = tile.getTilesAtDistance(ring).iterator();
                    while (iterator2.hasNext()) {
                        Tile outerTile = iterator2.next();
                        Object object2 = tileData.get((Object)outerTile.getPosition());
                        Intrinsics.checkNotNull(object2);
                        MapGenTileData outerTileData = (MapGenTileData)object2;
                        if (outerTileData.isJunk()) {
                            ++totalJunk;
                            continue;
                        }
                        if (outerTileData.isFood()) {
                            ++totalFood;
                        }
                        if (outerTileData.isProd()) {
                            ++totalProd;
                        }
                        if (outerTileData.isGood()) {
                            ++totalGood;
                        }
                        if (!outerTile.isAdjacentToRiver()) continue;
                        ++totalRivers;
                    }
                    Integer n = MapRegions.Companion.getMinimumFoodForRing().get(ring);
                    Intrinsics.checkNotNull(n);
                    if (totalFood < ((Number)n).intValue()) break block16;
                    Integer n2 = MapRegions.Companion.getMinimumProdForRing().get(ring);
                    Intrinsics.checkNotNull(n2);
                    if (totalProd < ((Number)n2).intValue()) break block16;
                    Integer n3 = MapRegions.Companion.getMinimumGoodForRing().get(ring);
                    Intrinsics.checkNotNull(n3);
                    if (totalGood >= ((Number)n3).intValue()) break block17;
                }
                localData.setGoodStart(false);
            }
            switch (ring) {
                case 1: {
                    int foodScore = ((Number)MapRegions.Companion.getFirstRingFoodScores().get(totalFood)).intValue();
                    int prodScore = ((Number)MapRegions.Companion.getFirstRingProdScores().get(totalProd)).intValue();
                    totalScore += foodScore + prodScore + totalRivers + totalGood * 2 - totalJunk * 3;
                    continue block4;
                }
                case 2: {
                    int foodScore = totalFood > 10 ? ((Number)CollectionsKt.last(MapRegions.Companion.getSecondRingFoodScores())).intValue() : ((Number)MapRegions.Companion.getSecondRingFoodScores().get(totalFood)).intValue();
                    int effectiveTotalProd = totalProd >= totalFood * 2 ? totalProd : (totalFood + 1) / 2;
                    int prodScore = effectiveTotalProd > 5 ? ((Number)CollectionsKt.last(MapRegions.Companion.getSecondRingProdScores())).intValue() : ((Number)MapRegions.Companion.getSecondRingProdScores().get(effectiveTotalProd)).intValue();
                    totalScore += foodScore + prodScore + totalRivers + totalGood * 2 - totalJunk * 3;
                    continue block4;
                }
                default: {
                    totalScore += totalFood + totalProd + totalGood + totalRivers - totalJunk * 2;
                }
            }
        }
        if (totalJunk > 9) {
            localData.setGoodStart(false);
        }
        if (localData.getCloseStartPenalty() > 0) {
            localData.setGoodStart(false);
            totalScore -= totalScore * localData.getCloseStartPenalty() / 100;
        }
        localData.setStartScore(totalScore);
    }

    private final void setRegionStart(Region region, HexCoord position, TileDataMap tileData) {
        region.setStartPosition(position);
        for (Map.Entry<Integer, Integer> entry : MapRegions.Companion.getCloseStartPenaltyForRing().entrySet()) {
            int ring = ((Number)entry.getKey()).intValue();
            int penalty = ((Number)entry.getValue()).intValue();
            Iterator<HexCoord> iterator2 = SequencesKt.map(region.getTileMap().get(position).getTilesAtDistance(ring), RegionStartFinder::setRegionStart$lambda$0).iterator();
            while (iterator2.hasNext()) {
                HexCoord outerTile = iterator2.next();
                Object object = tileData.get((Object)outerTile);
                Intrinsics.checkNotNull(object);
                ((MapGenTileData)object).addCloseStartPenalty(penalty);
            }
        }
    }

    private static final boolean findStart$lambda$0(Set $centerTiles, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $centerTiles.contains(it);
    }

    private static final boolean findStart$lambda$1(Set $centerTiles, Set $middleDonut, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $centerTiles.contains(it) || $middleDonut.contains(it);
    }

    private static final HexCoord setRegionStart$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPosition();
    }
}

