/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/unciv/ui/images/PortraitPromotion;", "Lcom/unciv/ui/images/Portrait;", "name", "", "size", "", "<init>", "(Ljava/lang/String;F)V", "level", "", "getLevel", "()I", "setLevel", "(I)V", "getDefaultImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getDefaultImageTint", "Lcom/badlogic/gdx/graphics/Color;", "getDefaultOuterBackgroundTint", "getDefaultInnerBackgroundTint", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPortrait.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Portrait.kt\ncom/unciv/ui/images/PortraitPromotion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1#2:315\n*E\n"})
public final class PortraitPromotion
extends Portrait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int level;
    @NotNull
    private static final Color defaultInnerColor = Scene2dExtensionsKt.colorFromRGB(255, 226, 0);
    @NotNull
    private static final Color defaultOuterColor = Scene2dExtensionsKt.colorFromRGB(0, 12, 49);

    public PortraitPromotion(@NotNull String name, float size) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(Portrait.Type.Promotion, name, size, 0.0f, 8, null);
        if (this.level > 0) {
            Table table2;
            float padding = this.level == 3 ? 0.5f : 2.0f;
            Table $this$_init__u24lambda_u240 = table2 = new Table();
            boolean bl = false;
            $this$_init__u24lambda_u240.defaults().pad(padding);
            Table starTable = table2;
            int n = this.level;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                starTable.add((Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Star", null, 2, null)).size(size / 4.0f);
            }
            Scene2dExtensionsKt.centerX((Actor)starTable, this);
            starTable.setY(size / 6.0f);
            this.addActor(starTable);
        }
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int n) {
        this.level = n;
    }

    @Override
    @NotNull
    public Image getDefaultImage() {
        Image image;
        Promotion.Companion.PromotionBaseNameAndLevel promotionBaseNameAndLevel = Promotion.Companion.getBaseNameAndLevel(this.getImageName());
        String nameWithoutBrackets = promotionBaseNameAndLevel.component1();
        int level = promotionBaseNameAndLevel.component2();
        String basePromotionName = promotionBaseNameAndLevel.component3();
        this.level = level;
        String pathWithoutBrackets = "UnitPromotionIcons/" + nameWithoutBrackets;
        String pathBase = "UnitPromotionIcons/" + basePromotionName;
        String pathUnit = "UnitIcons/" + StringsKt.removeSuffix(basePromotionName, (CharSequence)" ability");
        if (ImageGetter.INSTANCE.imageExists(pathWithoutBrackets)) {
            this.level = 0;
            image = ImageGetter.getImage$default(ImageGetter.INSTANCE, pathWithoutBrackets, null, 2, null);
        } else {
            image = ImageGetter.INSTANCE.imageExists(pathBase) ? ImageGetter.getImage$default(ImageGetter.INSTANCE, pathBase, null, 2, null) : (ImageGetter.INSTANCE.imageExists(pathUnit) ? ImageGetter.getImage$default(ImageGetter.INSTANCE, pathUnit, null, 2, null) : ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getPathIconFallback(), null, 2, null));
        }
        return image;
    }

    @Override
    @NotNull
    public Color getDefaultImageTint() {
        Object object = this.getRuleset().getUnitPromotions().get(this.getImageName());
        if (object == null || (object = ((Promotion)object).getInnerColorObject()) == null) {
            object = defaultInnerColor;
        }
        return object;
    }

    @Override
    @NotNull
    public Color getDefaultOuterBackgroundTint() {
        return this.getDefaultImageTint();
    }

    @Override
    @NotNull
    public Color getDefaultInnerBackgroundTint() {
        Object object = this.getRuleset().getUnitPromotions().get(this.getImageName());
        if (object == null || (object = ((Promotion)object).getOuterColorObject()) == null) {
            object = defaultOuterColor;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/images/PortraitPromotion$Companion;", "", "<init>", "()V", "defaultInnerColor", "Lcom/badlogic/gdx/graphics/Color;", "getDefaultInnerColor", "()Lcom/badlogic/gdx/graphics/Color;", "defaultOuterColor", "getDefaultOuterColor", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getDefaultInnerColor() {
            return defaultInnerColor;
        }

        @NotNull
        public final Color getDefaultOuterColor() {
            return defaultOuterColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

