/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.HexMathKt;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileGroupMap;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.UncivStage;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010#\u001a\u00020\tH\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\tJ\u0006\u0010(\u001a\u00020\tJ\u0016\u0010)\u001a\u0004\u0018\u00010\b*\u00020\u00052\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u000200J\r\u00101\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u0004\u0018\u00010\b2\u0006\u00108\u001a\u00020+R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R-\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u0013j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u001bj\b\u0012\u0004\u0012\u00020\u0014`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "parentScreen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "onTileClick", "Lkotlin/Function1;", "Lcom/unciv/logic/map/tile/Tile;", "", "<init>", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;Lcom/unciv/logic/map/TileMap;Lkotlin/jvm/functions/Function1;)V", "getTileMap$core", "()Lcom/unciv/logic/map/TileMap;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "getEditorScreen", "()Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "tileGroups", "Ljava/util/HashMap;", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "Lkotlin/collections/HashMap;", "getTileGroups", "()Ljava/util/HashMap;", "tileGroupMap", "Lcom/unciv/ui/components/tilegroups/TileGroupMap;", "allTileGroups", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "blinkAction", "Lcom/badlogic/gdx/scenes/scene2d/Action;", "savedCaptureListeners", "", "Lcom/badlogic/gdx/scenes/scene2d/EventListener;", "savedListeners", "setupZoomPanListeners", "addTiles", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "updateTileGroups", "setTransients", "getOrNull", "pos", "Lcom/badlogic/gdx/math/Vector2;", "setCenterPosition", "vector", "Lcom/unciv/logic/map/HexCoord;", "blink", "", "killListeners", "killListeners$core", "resurrectListeners", "resurrectListeners$core", "getDragPaintListener", "Lcom/badlogic/gdx/scenes/scene2d/InputListener;", "getClosestTileTo", "stageCoords", "core"})
@SourceDebugExtension(value={"SMAP\nEditorMapHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorMapHolder.kt\ncom/unciv/ui/screens/mapeditorscreen/EditorMapHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1563#2:239\n1634#2,3:240\n295#2,2:243\n*S KotlinDebug\n*F\n+ 1 EditorMapHolder.kt\ncom/unciv/ui/screens/mapeditorscreen/EditorMapHolder\n*L\n77#1:239\n77#1:240,3\n139#1:243,2\n*E\n"})
public final class EditorMapHolder
extends ZoomableScrollPane {
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final Function1<Tile, Unit> onTileClick;
    @Nullable
    private final MapEditorScreen editorScreen;
    @NotNull
    private final HashMap<Tile, TileGroup> tileGroups;
    private TileGroupMap<TileGroup> tileGroupMap;
    @NotNull
    private final ArrayList<TileGroup> allTileGroups;
    @Nullable
    private Action blinkAction;
    @NotNull
    private List<? extends EventListener> savedCaptureListeners;
    @NotNull
    private List<? extends EventListener> savedListeners;

    public EditorMapHolder(@NotNull BaseScreen parentScreen, @NotNull TileMap tileMap, @NotNull Function1<? super Tile, Unit> onTileClick) {
        Intrinsics.checkNotNullParameter(parentScreen, "parentScreen");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(onTileClick, "onTileClick");
        super(20.0f, 20.0f, 0.0f, 0.0f, 12, null);
        this.tileMap = tileMap;
        this.onTileClick = onTileClick;
        this.editorScreen = parentScreen instanceof MapEditorScreen ? (MapEditorScreen)parentScreen : null;
        this.tileGroups = new HashMap();
        this.allTileGroups = new ArrayList(this.tileMap.getValues().size());
        this.savedCaptureListeners = CollectionsKt.emptyList();
        this.savedListeners = CollectionsKt.emptyList();
        if (this.editorScreen == null) {
            this.setTouchable(Touchable.disabled);
        }
        this.setContinuousScrollingX(this.tileMap.getMapParameters().getWorldWrap());
        this.addTiles(parentScreen.getStage());
        if (this.editorScreen != null) {
            this.addCaptureListener(this.getDragPaintListener());
            this.setupZoomPanListeners();
        }
        this.reloadMaxZoom();
    }

    @NotNull
    public final TileMap getTileMap$core() {
        return this.tileMap;
    }

    @Nullable
    public final MapEditorScreen getEditorScreen() {
        return this.editorScreen;
    }

    @NotNull
    public final HashMap<Tile, TileGroup> getTileGroups() {
        return this.tileGroups;
    }

    private final void setupZoomPanListeners() {
        this.setOnPanStartListener(() -> EditorMapHolder.setupZoomPanListeners$lambda$0(this));
        this.setOnPanStopListener(() -> EditorMapHolder.setupZoomPanListeners$lambda$1(this));
        this.setOnZoomStartListener(() -> EditorMapHolder.setupZoomPanListeners$lambda$2(this));
        this.setOnZoomStopListener(() -> EditorMapHolder.setupZoomPanListeners$lambda$3(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void addTiles(Stage stage) {
        void $this$mapTo$iv$iv;
        TileSetStrings tileSetStrings = this.editorScreen != null ? new TileSetStrings(this.editorScreen.getRuleset(), this.editorScreen.getGame().getSettings()) : new TileSetStrings(null, null, 0, 7, null);
        Iterable $this$map$iv = this.tileMap.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tile tile = (Tile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TileGroup((Tile)it, tileSetStrings, 0.0f, 4, null));
        }
        List daTileGroups = (List)destination$iv$iv;
        this.tileGroupMap = new TileGroupMap(this, daTileGroups, this.getContinuousScrollingX(), null, 8, null);
        TileGroupMap<TileGroup> tileGroupMap = this.tileGroupMap;
        if (tileGroupMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap = null;
        }
        this.setActor(tileGroupMap);
        for (TileGroup tileGroup : daTileGroups) {
            this.allTileGroups.add(tileGroup);
            ((Map)this.tileGroups).put(tileGroup.getTile(), tileGroup);
        }
        Iterator<TileGroup> iterator2 = this.allTileGroups.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object object = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            TileGroup tileGroup = (TileGroup)object;
            tileGroup.setForceVisible(true);
            TileGroup.update$default(tileGroup, null, null, 3, null);
            if (this.getTouchable() == Touchable.disabled) continue;
            ActivationExtensionsKt.onClick(tileGroup, () -> EditorMapHolder.addTiles$lambda$1(this, tileGroup));
        }
        this.setSize(stage.getWidth(), stage.getHeight());
        this.layout();
        this.setScrollPercentX(0.5f);
        this.setScrollPercentY(0.5f);
        this.updateVisualScroll();
    }

    public final void updateTileGroups() {
        Iterator<TileGroup> iterator2 = this.allTileGroups.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<TileGroup> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            TileGroup tileGroup;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            TileGroup.update$default(tileGroup, null, null, 3, null);
        }
    }

    public final void setTransients() {
        Iterator<Tile> iterator2 = this.tileGroups.keySet().iterator();
        while (iterator2.hasNext()) {
            Tile tileInfo;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            tileInfo.setTerrainTransients();
        }
    }

    private final Tile getOrNull(TileMap $this$getOrNull, Vector2 pos) {
        int x = (int)pos.x;
        int y = (int)pos.y;
        if ($this$getOrNull.contains(x, y)) {
            return $this$getOrNull.get(x, y);
        }
        return null;
    }

    public final void setCenterPosition(@NotNull HexCoord vector, boolean blink) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(vector, "vector");
            Iterable $this$firstOrNull$iv = this.allTileGroups;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TileGroup it = (TileGroup)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getTile().getPosition(), vector)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        TileGroup tileGroup = v0;
        if (tileGroup == null) {
            return;
        }
        TileGroup tileGroup2 = tileGroup;
        if (!ZoomableScrollPane.scrollTo$default(this, tileGroup2.getX() + tileGroup2.getWidth() / (float)2, this.getMaxY() - (tileGroup2.getY() + tileGroup2.getWidth() / (float)2), false, 4, null)) {
            return;
        }
        if (!blink) {
            return;
        }
        this.removeAction(this.blinkAction);
        this.blinkAction = Actions.repeat(3, Actions.sequence((Action)Actions.run(() -> EditorMapHolder.setCenterPosition$lambda$1(tileGroup2)), (Action)Actions.delay(0.3f), (Action)Actions.run(() -> EditorMapHolder.setCenterPosition$lambda$2(tileGroup2)), (Action)Actions.delay(0.3f)));
        this.addAction(this.blinkAction);
    }

    public static /* synthetic */ void setCenterPosition$default(EditorMapHolder editorMapHolder, HexCoord hexCoord, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        editorMapHolder.setCenterPosition(hexCoord, bl);
    }

    public final void killListeners$core() {
        DelayedRemovalArray<EventListener> delayedRemovalArray = this.getCaptureListeners();
        Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "getCaptureListeners(...)");
        this.savedCaptureListeners = CollectionsKt.toList((Iterable)delayedRemovalArray);
        DelayedRemovalArray<EventListener> delayedRemovalArray2 = this.getListeners();
        Intrinsics.checkNotNullExpressionValue(delayedRemovalArray2, "getListeners(...)");
        this.savedListeners = CollectionsKt.toList((Iterable)delayedRemovalArray2);
        this.clearListeners();
    }

    public final void resurrectListeners$core() {
        List<? extends EventListener> captureListenersToAdd = this.savedCaptureListeners;
        this.savedCaptureListeners = CollectionsKt.emptyList();
        List<? extends EventListener> listenersToAdd = this.savedListeners;
        this.savedListeners = CollectionsKt.emptyList();
        for (EventListener eventListener : listenersToAdd) {
            this.addListener(eventListener);
        }
        for (EventListener eventListener : captureListenersToAdd) {
            this.addCaptureListener(eventListener);
        }
    }

    private final InputListener getDragPaintListener() {
        return new InputListener(this){
            private boolean isDragging;
            private boolean isPainting;
            private long touchDownTime;
            final /* synthetic */ EditorMapHolder this$0;
            {
                this.this$0 = $receiver;
                this.touchDownTime = System.currentTimeMillis();
            }

            public final boolean isDragging() {
                return this.isDragging;
            }

            public final void setDragging(boolean bl) {
                this.isDragging = bl;
            }

            public final boolean isPainting() {
                return this.isPainting;
            }

            public final void setPainting(boolean bl) {
                this.isPainting = bl;
            }

            public final long getTouchDownTime() {
                return this.touchDownTime;
            }

            public final void setTouchDownTime(long l) {
                this.touchDownTime = l;
            }

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                this.touchDownTime = System.currentTimeMillis();
                return true;
            }

            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                Object object;
                block8: {
                    block7: {
                        if (!this.isDragging && !this.this$0.isPanning()) {
                            this.isDragging = true;
                            long deltaTime = System.currentTimeMillis() - this.touchDownTime;
                            if (deltaTime > 400L) {
                                this.isPainting = true;
                                this.this$0.getStage().cancelTouchFocusExcept(this, this.this$0);
                            }
                        }
                        if (!this.isPainting) {
                            return;
                        }
                        MapEditorScreen mapEditorScreen = this.this$0.getEditorScreen();
                        Intrinsics.checkNotNull(mapEditorScreen);
                        mapEditorScreen.hideSelection();
                        object = this.this$0.getActor();
                        if (object == null) break block7;
                        InputEvent inputEvent = event;
                        Intrinsics.checkNotNull(inputEvent);
                        if ((object = ((Actor)object).stageToLocalCoordinates(new Vector2(inputEvent.getStageX(), event.getStageY()))) != null) break block8;
                    }
                    return;
                }
                Object stageCoords = object;
                Tile tile = this.this$0.getClosestTileTo((Vector2)stageCoords);
                if (tile == null) {
                    return;
                }
                Tile centerTileInfo = tile;
                this.this$0.getEditorScreen().getTabs().getEdit().paintTilesWithBrush$core(centerTileInfo);
            }

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (this.isPainting) {
                    this.this$0.updateTileGroups();
                    this.this$0.setTransients();
                }
                this.isDragging = false;
                this.isPainting = false;
            }
        };
    }

    @Nullable
    public final Tile getClosestTileTo(@NotNull Vector2 stageCoords) {
        Intrinsics.checkNotNullParameter(stageCoords, "stageCoords");
        TileGroupMap<TileGroup> tileGroupMap = this.tileGroupMap;
        if (tileGroupMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap = null;
        }
        Vector2 positionalCoords = tileGroupMap.getPositionalVector(stageCoords);
        Vector2 hexPosition = HexMath.INSTANCE.world2HexCoords(positionalCoords);
        Vector2 rounded = HexMath.INSTANCE.roundHexCoords(hexPosition);
        if (!this.tileMap.getMapParameters().getWorldWrap()) {
            return this.getOrNull(this.tileMap, rounded);
        }
        Vector2 wrapped = HexMath.INSTANCE.getUnwrappedNearestTo(HexMathKt.toHexCoord(rounded), HexCoord.Companion.getZero(), this.tileMap.getMaxLongitude());
        Tile tile = this.getOrNull(this.tileMap, wrapped);
        if (tile == null) {
            tile = this.getOrNull(this.tileMap, rounded);
        }
        return tile;
    }

    private static final void setupZoomPanListeners$setActHit(EditorMapHolder this$0) {
        boolean isEnabled = !this$0.isZooming() && !this$0.isPanning();
        Stage stage = this$0.getStage();
        Intrinsics.checkNotNull(stage, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.UncivStage");
        ((UncivStage)stage).setPerformPointerEnterExitEvents(isEnabled);
        TileGroupMap<TileGroup> tileGroupMap = this$0.tileGroupMap;
        if (tileGroupMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap = null;
        }
        tileGroupMap.setShouldAct(isEnabled);
        TileGroupMap<TileGroup> tileGroupMap2 = this$0.tileGroupMap;
        if (tileGroupMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap2 = null;
        }
        tileGroupMap2.setShouldHit(isEnabled);
    }

    private static final Unit setupZoomPanListeners$lambda$0(EditorMapHolder this$0) {
        EditorMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit setupZoomPanListeners$lambda$1(EditorMapHolder this$0) {
        EditorMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit setupZoomPanListeners$lambda$2(EditorMapHolder this$0) {
        EditorMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit setupZoomPanListeners$lambda$3(EditorMapHolder this$0) {
        EditorMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit addTiles$lambda$1(EditorMapHolder this$0, TileGroup $tileGroup) {
        this$0.onTileClick.invoke($tileGroup.getTile());
        return Unit.INSTANCE;
    }

    private static final void setCenterPosition$lambda$1(TileGroup $tileGroup) {
        $tileGroup.getLayerOverlay().hideHighlight();
    }

    private static final void setCenterPosition$lambda$2(TileGroup $tileGroup) {
        TileLayerOverlay.showHighlight$default($tileGroup.getLayerOverlay(), null, 0.0f, 3, null);
    }
}

