<div align="center">
  <img alt="Hey API logo" height="150" src="https://heyapi.dev/images/logo-300w.png" width="150">
  <h1 align="center"><b>Fetch API Client</b></h1>
  <p align="center">🚀 Fetch API client for `@hey-api/openapi-ts` codegen.</p>
</div>

[Live demo](https://stackblitz.com/edit/hey-api-client-fetch-example?file=openapi-ts.config.ts,src%2Fclient%2Fschemas.gen.ts,src%2Fclient%2Fsdk.gen.ts,src%2Fclient%2Ftypes.gen.ts,src%2FApp.tsx)

## Features

- seamless integration with `@hey-api/openapi-ts` ecosystem
- type-safe response data and errors
- response data validation and transformation
- access to the original request and response
- granular request and response customization options
- minimal learning curve thanks to extending the underlying technology
- support bundling inside the generated output
- [platform](https://heyapi.dev/openapi-ts/integrations) for automating codegen builds

## Dashboard

Hey API is an ecosystem of products helping you build better APIs. Superpower your codegen and APIs with our platform.

[Sign In](https://app.heyapi.dev) to Hey API platform.

## Documentation

Please visit our [website](https://heyapi.dev) for documentation, guides, migrating, and more.

## Sponsors

Love Hey API? Become our [sponsor](https://github.com/sponsors/hey-api).

<p>
  <a href="https://kutt.it/pkEZyc" target="_blank">
    <img alt="Stainless logo" height="50" src="https://heyapi.dev/images/stainless-logo-wordmark-480w.jpeg" />
  </a>
</p>

## Migration Guides

[OpenAPI Typescript Codegen](https://heyapi.dev/openapi-ts/migrating#openapi-typescript-codegen)
