import type { ParserOptions } from "./options.js";
import type { $RefParser } from "./index";
export interface InventoryEntry {
    $ref: any;
    circular: any;
    depth: any;
    extended: any;
    external: any;
    file: any;
    hash: any;
    indirections: any;
    key: any;
    parent: any;
    pathFromRoot: any;
    value: any;
    originalContainerType?: "schemas" | "parameters" | "requestBodies" | "responses" | "headers";
}
/**
 * Bundles all external JSON references into the main JSON schema, thus resulting in a schema that
 * only has *internal* references, not any *external* references.
 * This method mutates the JSON schema object, adding new references and re-mapping existing ones.
 *
 * @param parser
 * @param options
 */
export declare const bundle: (parser: $RefParser, options: ParserOptions) => void;
