/**
 * Audited & minimal JS implementation of Salsa20, ChaCha and AES. Check out individual modules.
 * @example
```js
import { gcm, aessiv } from '@noble/ciphers/aes.js';
import { xsalsa20poly1305 } from '@noble/ciphers/salsa.js';
import { secretbox } from '@noble/ciphers/salsa.js'; // == xsalsa20poly1305
import { chacha20poly1305, xchacha20poly1305 } from '@noble/ciphers/chacha.js';

// Unauthenticated encryption: make sure to use HMAC or similar
import { ctr, cfb, cbc, ecb } from '@noble/ciphers/aes.js';
import { salsa20, xsalsa20 } from '@noble/ciphers/salsa.js';
import { chacha20, xchacha20, chacha8, chacha12 } from '@noble/ciphers/chacha.js';

// KW
import { aeskw, aeskwp } from '@noble/ciphers/aes.js';

// Utilities
import { managedNonce, randomBytes, bytesToHex, hexToBytes } from '@noble/ciphers/utils.js';
import { poly1305 } from '@noble/ciphers/_poly1305.js';
import { ghash, polyval } from '@noble/ciphers/_polyval.js';
```
 * @module
 */
throw new Error('root module cannot be imported: import submodules instead. Check out README');
