"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    NOT_KEYED_COMMAND: true,
    IS_READ_ONLY: true,
    /**
     * Constructs the SCRIPT LOAD command
     *
     * @param parser - The command parser
     * @param script - The Lua script to load
     * @see https://redis.io/commands/script-load/
     */
    parseCommand(parser, script) {
        parser.push('SCRIPT', 'LOAD', script);
    },
    transformReply: undefined
};
//# sourceMappingURL=SCRIPT_LOAD.js.map