import type { Options as ClientOptions, TDataShape, Client } from '@hey-api/client-fetch';
import type { CreateMeasurementData, CreateMeasurementError, GetMeasurementData, GetMeasurementError, ListProbesData, GetLimitsData } from './types.gen.js';
export type Options<TData extends TDataShape = TDataShape, ThrowOnError extends boolean = boolean> = ClientOptions<TData, ThrowOnError> & {
    /**
     * You can provide a client instance returned by `createClient()` instead of
     * individual options. This might be also useful if you want to implement a
     * custom client.
     */
    client?: Client;
    /**
     * You can pass arbitrary values through the `meta` object. This can be
     * used to access values that aren't defined as part of the SDK function.
     */
    meta?: Record<string, unknown>;
};
/**
 * Create a measurement
 * Creates a new measurement with parameters set in the request body.
 * The measurement runs asynchronously and you can retrieve its current state at the URL returned in the `Location` header.
 *
 * ### Client guidelines
 *
 * - If the application is running in interactive mode, set the `inProgressUpdates` option to `true` to have the API
 * return partial results as soon as they are available. This allows the user to see the measurement progress in real time.
 * - If the application is interactive by default but also implements a "CI" mode for scripting, do not set the flag in the CI mode.
 * - To perform multiple measurements using exactly the same probes, create a single measurement first, then pass its `id` in the `locations` field for the other measurements.
 * - When you receive a `429` response, inform the user about their current rate limit status based on the response headers. Depending on the exact situation and on what your application supports, you may also suggest:
 * - Signing in or using an access token.
 * - Learning more about how to get additional credits at https://globalping.io/credits.
 * - Repeating the measurement with fewer probes.
 *
 */
export declare const createMeasurement: <ThrowOnError extends boolean = false>(options?: Options<CreateMeasurementData, ThrowOnError>) => import("@hey-api/client-fetch").RequestResult<import("./types.gen.js").CreateMeasurementResponse, CreateMeasurementError, ThrowOnError>;
/**
 * Get a measurement by ID
 * Returns the status and results of an existing measurement.
 * Measurements are typically available for up to 7 days after creation.
 *
 * > **Tip**: A link to this endpoint is returned in the `Location` response header when creating the measurement.
 *
 * ### Client guidelines
 *
 * As it can take a few seconds for a measurement to complete, you should use the following process for retrieving the results:
 * 1. Request the measurement to retrieve its status.
 * 2. If the status is `in-progress`, wait 500 milliseconds and start again at step 1. Note that it's important to wait 500 ms *after* receiving the response rather than using an "every 500ms" interval as for large measurements, the request itself may take a few hundred milliseconds to complete.
 * 3. If the status is anything **other** than `in-progress`, stop. The measurement is no longer running, and its results are final.
 *
 * > **Important**: Do not query the results of a single measurement more often than every 500 milliseconds. Sending more than two
 * requests per second may trigger a rate limit and prevent you from accessing the results for a few seconds.
 *
 */
export declare const getMeasurement: <ThrowOnError extends boolean = false>(options: Options<GetMeasurementData, ThrowOnError>) => import("@hey-api/client-fetch").RequestResult<import("./types.gen.js").MeasurementResponse, GetMeasurementError, ThrowOnError>;
/**
 * List probes currently online
 * Returns a list of all probes currently online and their metadata, such as location and assigned tags.
 *
 * > **Note**: Probes don't expose unique IDs that would allow you to explicitly select them.
 * Instead, specify the requested location or an ID of an existing measurement when creating new measurements.
 *
 */
export declare const listProbes: <ThrowOnError extends boolean = false>(options?: Options<ListProbesData, ThrowOnError>) => import("@hey-api/client-fetch").RequestResult<import("./types.gen.js").Probes, unknown, ThrowOnError>;
/**
 * Get current rate limits
 * Returns rate limits for the current user (if authenticated) or IP address (if not authenticated).
 *
 */
export declare const getLimits: <ThrowOnError extends boolean = false>(options?: Options<GetLimitsData, ThrowOnError>) => import("@hey-api/client-fetch").RequestResult<import("./types.gen.js").Limits, unknown, ThrowOnError>;
