"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKey = void 0;
var _symmetricKey = _interopRequireDefault(require("./symmetric-key"));
var _lruCache = _interopRequireDefault(require("lru-cache"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// This code is based on the `mssql-jdbc` library published under the conditions of MIT license.
// Copyright (c) 2019 Microsoft Corporation

const cache = new _lruCache.default(0);
const getKey = async (keyInfo, options) => {
  if (!options.trustedServerNameAE) {
    throw new Error('Server name should not be null in getKey');
  }
  const serverName = options.trustedServerNameAE;
  const keyLookupValue = `${serverName}:${Buffer.from(keyInfo.encryptedKey).toString('base64')}:${keyInfo.keyStoreName}`;
  if (cache.has(keyLookupValue)) {
    return cache.get(keyLookupValue);
  } else {
    const provider = options.encryptionKeyStoreProviders && options.encryptionKeyStoreProviders[keyInfo.keyStoreName];
    if (!provider) {
      throw new Error(`Failed to decrypt a column encryption key. Invalid key store provider name: ${keyInfo.keyStoreName}. A key store provider name must denote either a system key store provider or a registered custom key store provider. Valid (currently registered) custom key store provider names are: ${options.encryptionKeyStoreProviders}. Please verify key store provider information in column master key definitions in the database, and verify all custom key store providers used in your application are registered properly.`);
    }
    const plaintextKey = await provider.decryptColumnEncryptionKey(keyInfo.keyPath, keyInfo.algorithmName, keyInfo.encryptedKey);
    const encryptionKey = new _symmetricKey.default(plaintextKey);
    if (options.columnEncryptionKeyCacheTTL > 0) {
      cache.set(keyLookupValue, encryptionKey, options.columnEncryptionKeyCacheTTL);
    }
    return encryptionKey;
  }
};
exports.getKey = getKey;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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